/*******************************************************************************
 * hcmplx.h
 *
 * This module contains all defines, typedefs, and prototypes for HCMPLX.CPP.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/math/hcmplx.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef HCMPLX_H
#define HCMPLX_H

namespace pov
{

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

/*****************************************************************************
* Global typedefs
******************************************************************************/

/*****************************************************************************
* Global variables
******************************************************************************/

/*****************************************************************************
* Global functions
******************************************************************************/

int F_Bound_HCompl (Ray&, const Fractal *, DBL *, DBL *);
void Normal_Calc_HCompl (VECTOR, int, const Fractal *, DBL **);
int Iteration_HCompl (const VECTOR, const Fractal *, DBL **);
int D_Iteration_HCompl (VECTOR, const Fractal *, const VECTOR &, DBL *, DBL **);

int F_Bound_HCompl_z3 (Ray &, const Fractal *, DBL *, DBL *);
void Normal_Calc_HCompl_z3 (VECTOR, int, const Fractal *, DBL **);
int Iteration_HCompl_z3 (const VECTOR, const Fractal *, DBL **);
int D_Iteration_HCompl_z3 (VECTOR, const Fractal *, const VECTOR &, DBL *, DBL **);

int F_Bound_HCompl_Reciprocal (Ray &, const Fractal *, DBL *, DBL *);
void Normal_Calc_HCompl_Reciprocal (VECTOR, int, const Fractal *, DBL **);
int Iteration_HCompl_Reciprocal (const VECTOR, const Fractal *, DBL **);
int D_Iteration_HCompl_Reciprocal (VECTOR, const Fractal *, const VECTOR &, DBL *, DBL **);

int F_Bound_HCompl_Func (Ray &, const Fractal *, DBL *, DBL *);
void Normal_Calc_HCompl_Func (VECTOR, int, const Fractal *, DBL **);
int Iteration_HCompl_Func (const VECTOR, const Fractal *, DBL **);
int D_Iteration_HCompl_Func (VECTOR, const Fractal *, const VECTOR &, DBL *, DBL **);

void Complex_Exp (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_Ln (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_Sin (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_ASin (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_Sinh (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_ASinh (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_Cos (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_ACos (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_Cosh (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_ACosh (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_Tan (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_ATan (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_Tanh (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_ATanh (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_Sqrt (CMPLX *target, CMPLX *source, const CMPLX *);
void Complex_Pwr (CMPLX *target, CMPLX *source, const CMPLX *source2);
void Complex_Mult (CMPLX *target, CMPLX *source1, const CMPLX *source2);
void Complex_Div (CMPLX *target, CMPLX *source1, CMPLX *source2);
void Complex_Power (CMPLX *target, CMPLX *source1, CMPLX *source2);

}

#endif
