/*******************************************************************************
 * quatern.h
 *
 * This module contains all defines, typedefs, and prototypes for quatern.cpp.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/math/quatern.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef JULIA_H
#define JULIA_H

namespace pov
{

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

/*****************************************************************************
* Global typedefs
******************************************************************************/

/*****************************************************************************
* Global variables
******************************************************************************/

/*****************************************************************************
* Global functions
******************************************************************************/

int F_Bound_Julia (Ray & Ray, const Fractal * Fractal, DBL * Depth_Min, DBL * Depth_Max);
void Normal_Calc_Julia (VECTOR Result, int N_Max, const Fractal *fractal, DBL **);
void Normal_Calc_z3 (VECTOR Result, int N_Max, const Fractal *fractal, DBL **);
int Iteration_Julia (const VECTOR point, const Fractal * Julia, DBL **);
int D_Iteration_Julia (VECTOR point, const Fractal *Julia, const VECTOR& Direction, DBL *Dist, DBL **);
int Iteration_z3 (const VECTOR point, const Fractal * Julia, DBL **);
int D_Iteration_z3 (VECTOR point, const Fractal *Julia, const VECTOR& Direction, DBL *Dist, DBL **);

}

#endif
