/*******************************************************************************
 * povray.h
 *
 * This file contains the interface to initialise and terminate all
 * POV-Ray threads. Beyond the functions in this file, no other
 * functions need to be called to run POV-Ray.
 * Rendering is controlled by the classes provided in the frontend
 * files.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/povray.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BACKEND_POVRAY_H
#define POVRAY_BACKEND_POVRAY_H

// Please put everything that isn't a preprocessor directive in this
// file into SKIP_COMPLEX_OPTOUT_H sections like the one below! [trf]
#ifndef SKIP_COMPLEX_OPTOUT_H

#include "base/povms.h"

/**
 *	This function does essential initialisation that is required before
 *	POV-Ray can be used. It also starts the main render thread that
 *	receives and processes all messages received from the frontend.
 *	@param	addr			If not NULL, backend address on return.
 */
void povray_init(POVMSAddress *addr = NULL);

/**
 *	This function shuts down the main render thread and after it has
 *	been called, all memory allocated by POV-Ray has been freed and
 *	all threads created by POV-Ray have been terminated.
 */
void povray_terminate();

#endif // SKIP_COMPLEX_OPTOUT_H

// #define TIMED_BETA
#define POVRAY_IS_BETA

// You should set EXPIRE_AT to no later then two months from the time you
// compile POV-Ray, and additionally no later than 31 December 2010.
// 1272664800 - Sat May  1 08:00:00 EST 2010
// 1293832800 - Sat Jan  1 09:00:00 EST 2011

#define DAYS(n)         (86400 * n)
#define EXPIRE_AT       (1272664800 + DAYS(61))
#define HARD_EXPIRY     (1293832800)

// POV-Ray version and copyright message macros

#define POV_RAY_IS_OFFICIAL 1

#define POV_RAY_VERSION "3.7.0.beta.37a"
#define POV_RAY_COPYRIGHT "Copyright 1991-2003 Persistence of Vision Team\nCopyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd."
#define OFFICIAL_VERSION_NUMBER 370
#define OFFICIAL_VERSION_NUMBER_HEX 0x0370

#if POV_RAY_IS_OFFICIAL == 1

#ifdef DISTRIBUTION_MESSAGE_2
#undef DISTRIBUTION_MESSAGE_2
#endif

#define DISTRIBUTION_MESSAGE_1 "This is a time-limited beta test version which expires 31 Dec 2010."
#define DISTRIBUTION_MESSAGE_2 "General distribution is strongly discouraged."
#define DISTRIBUTION_MESSAGE_3 ""

/*
#define DISTRIBUTION_MESSAGE_1 "This is an official version prepared by the POV-Ray Team. See the"
#define DISTRIBUTION_MESSAGE_2 " documentation on how to contact the authors or visit us on the"
#define DISTRIBUTION_MESSAGE_3 " internet at http://www.povray.org/."
*/

#else

// Please set DISTRIBUTION_MESSAGE_2 to your real name to make
// unofficial versions distinguishable from each other. We also
// recommend including an email address. Remove the #error directive
// afterwards to proceed with the build.

#define DISTRIBUTION_MESSAGE_1 "This is an unofficial version compiled by:"
#ifndef DISTRIBUTION_MESSAGE_2
#error You must complete the following DISTRIBUTION_MESSAGE_2 definition
#define DISTRIBUTION_MESSAGE_2 " FILL IN NAME HERE........................."
#endif
#define DISTRIBUTION_MESSAGE_3 " The POV-Ray Team(tm) is not responsible for supporting this version."

#endif

#endif // POVRAY_BACKEND_POVRAY_H
