/*******************************************************************************
 * camera.h
 *
 * This module contains all defines, typedefs, and prototypes for CAMERA.CPP.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/scene/camera.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/


#ifndef CAMERA_H
#define CAMERA_H

namespace pov
{

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

// Available camera types. [DB 8/94] 

#define PERSPECTIVE_CAMERA      1
#define ORTHOGRAPHIC_CAMERA     2
#define FISHEYE_CAMERA          3
#define ULTRA_WIDE_ANGLE_CAMERA 4
#define OMNIMAX_CAMERA          5
#define PANORAMIC_CAMERA        6
#define CYL_1_CAMERA            7
#define CYL_2_CAMERA            8
#define CYL_3_CAMERA            9
#define CYL_4_CAMERA           10
#define SPHERICAL_CAMERA       11


/*****************************************************************************
* Global typedefs
******************************************************************************/

class Camera
{
public:
	VECTOR Location;
	VECTOR Direction;
	VECTOR Up;
	VECTOR Right;
	VECTOR Sky;
	VECTOR Look_At;                // Used only to record the user's preference 
	VECTOR Focal_Point;            // Used only to record the user's preference 
	DBL Focal_Distance, Aperture;  // ARE 9/92 for focal blur.                  
	int Blur_Samples;              // ARE 9/92 for focal blur.                  
	DBL Confidence;                // Probability for confidence test.          
	DBL Variance;                  // Max. variance for confidence test.        
	int Type;                      // Camera type.                              
	DBL Angle;                     // Viewing angle.                            
	DBL H_Angle;                   // Spherical horizontal viewing angle        
	DBL V_Angle;                   // Spherical verticle viewing angle          
	TNORMAL *Tnormal;              // Primary ray pertubation.                  
	TRANSFORM *Trans;              // Used only to record the user's input      

	Camera();
	Camera(const Camera& src);
	~Camera();
	Camera& operator=(const Camera& rhs);
	void Transform(const TRANSFORM *Trans);
	void Scale(const VECTOR Vector);
	void Rotate(const VECTOR Vector);
	void Translate(const VECTOR Vector);

private:
	void Init();
};

}

#endif
