/*******************************************************************************
 * poly.h
 *
 * This module contains all defines, typedefs, and prototypes for POLY.CPP.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/shape/poly.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/


#ifndef POLY_H
#define POLY_H

namespace pov
{

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#define POLY_OBJECT    (STURM_OK_OBJECT)
#define CUBIC_OBJECT   (STURM_OK_OBJECT)
#define QUARTIC_OBJECT (STURM_OK_OBJECT)

/* Number of coefficients of a three variable polynomial of order x */

inline int term_counts(int x) { return ((x+1)*(x+2)*(x+3)/6); }



/*****************************************************************************
* Global typedefs
******************************************************************************/

class Poly : public ObjectBase
{
	public:
		int Order;
		DBL *Coeffs;

		Poly(int order);
		virtual ~Poly();

		virtual ObjectPtr Copy();

		virtual bool All_Intersections(const Ray&, IStack&, TraceThreadData *);
		virtual bool Inside(const VECTOR, TraceThreadData *) const;
		virtual void Normal(VECTOR, Intersection *, TraceThreadData *) const;
		virtual void Translate(const VECTOR, const TRANSFORM *);
		virtual void Rotate(const VECTOR, const TRANSFORM *);
		virtual void Scale(const VECTOR, const TRANSFORM *);
		virtual void Transform(const TRANSFORM *);
		virtual void Invert();
		virtual void Compute_BBox();
		virtual bool Intersect_BBox(BBoxDirection, const BBOX_VECT&, const BBOX_VECT&, BBOX_VAL) const;
	protected:
		static int intersect(const Ray &Ray, int Order, const DBL *Coeffs, int Sturm_Flag, DBL *Depths, TraceThreadData *Thread);
		static void normal0(VECTOR Result, int Order, const DBL *Coeffs, const VECTOR IPoint);
		static void normal1(VECTOR Result, int Order, const DBL *Coeffs, const VECTOR IPoint);
		static DBL inside(const VECTOR IPoint, int Order, const DBL *Coeffs);
		static int intersect_linear(const Ray &ray, const DBL *Coeffs, DBL *Depths);
		static int intersect_quadratic(const Ray &ray, const DBL *Coeffs, DBL *Depths);
		static int factor_out(int n, int i, int *c, int *s);
		static int binomial(int n, int r);
		static void factor1(int n, int *c, int *s);
};

}

#endif
