/*******************************************************************************
 * jitter.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/support/jitter.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BACKEND_JITTER_H
#define POVRAY_BACKEND_JITTER_H

#include "backend/frame.h"

namespace pov
{

#ifdef DYNAMIC_HASHTABLE
extern unsigned short *hashTable; // GLOBAL VARIABLE
#else
extern ALIGN16 unsigned short hashTable[]; // GLOBAL VARIABLE
#endif

extern const float JitterTable[]; // GLOBAL VARIABLE

inline DBL Jitter2d(int x, int y)
{
	return JitterTable[int(hashTable[int(hashTable[int(x & 0xfff)] ^ y) & 0xfff]) & 0xff];
}

inline void Jitter2d(int x, int y, DBL& jx, DBL& jy)
{
	jx = JitterTable[int(hashTable[int(hashTable[int((x + 1021) & 0xfff)] ^ (y + 1019)) & 0xfff]) & 0xff]; // Note that 1019 and 1021 are prime! [trf]
	jy = JitterTable[int(hashTable[int(hashTable[int((x + 1019) & 0xfff)] ^ (y + 1021)) & 0xfff]) & 0xff]; // Note that 1019 and 1021 are prime! [trf]
}

inline DBL Jitter2d(DBL x, DBL y)
{
	return JitterTable[int(hashTable[int(hashTable[(int(x * 1021.0) & 0xfff)] ^ int(y * 1021.0)) & 0xfff]) & 0xff]; // Note that 1021 is prime! [trf]
}

inline void Jitter2d(DBL x, DBL y, DBL& jx, DBL& jy)
{
	jx = JitterTable[int(hashTable[int(hashTable[(int(x * 1021.0) & 0xfff)] ^ int(y * 1019.0)) & 0xfff]) & 0xff]; // Note that 1019 and 1021 are prime! [trf]
	jy = JitterTable[int(hashTable[int(hashTable[(int(x * 1019.0) & 0xfff)] ^ int(y * 1021.0)) & 0xfff]) & 0xff]; // Note that 1019 and 1021 are prime! [trf]
}

}

#endif // POVRAY_BACKEND_JITTER_H
