/*******************************************************************************
 * statistics.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/support/statistics.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BACKEND_STATISTICS_H
#define POVRAY_BACKEND_STATISTICS_H

#include <vector>

#include "backend/frame.h"
#include "base/types.h"
#include "statspov.h"

namespace pov
{

using namespace pov_base;

template <typename T>
class Counter
{
	public:
		Counter() { value = 0; } // assumes for all types of T that 0 is a valid assignment
		virtual ~Counter() { }
		inline T operator+(T other) { return value + other; }
		inline T operator-(T other) { return value - other; }
		inline T operator++(int) { return value++; }
		inline T operator--(int) { return value--; }
		inline void operator+=(T other) { value += other; }
		inline void operator-=(T other) { value -= other; }
		inline const T operator=(T other) { value = other; return value; }
		inline operator T() const { return value; }
		bool SafeRead(unsigned int maxattempts, T *result) const;

	private:
		volatile T value;
};

template <typename T, int numElem>
class StatisticsBase
{
	public:
		StatisticsBase() {}
		virtual ~StatisticsBase() {}

		inline Counter<T>& operator[](size_t idx) { return counters[idx]; }
		inline Counter<T> operator[](size_t idx) const { return counters[idx]; }

		void operator+=(const StatisticsBase& other);
		StatisticsBase operator+(const StatisticsBase& other);

		void clear();

	private:
		Counter<T> counters[numElem];
};

typedef StatisticsBase<POV_ULONG, MaxIntStat> IntStatistics;
typedef StatisticsBase<double, MaxFPStat> FPStatistics;

class RenderStatistics
{
public:
	RenderStatistics() {}
	virtual ~RenderStatistics() {}

	inline Counter<POV_ULONG>& operator[](IntStatsIndex idx) { return intStats[idx]; }
	inline Counter<POV_ULONG> operator[](IntStatsIndex idx) const { return intStats[idx]; }
	inline Counter<double>& operator[](FPStatsIndex idx) { return fpStats[idx]; }
	inline Counter<double> operator[](FPStatsIndex idx) const { return fpStats[idx]; }
	inline operator IntStatistics&() { return intStats; }
	inline operator IntStatistics() const { return intStats; }
	inline operator FPStatistics&() { return fpStats; }
	inline operator FPStatistics() const { return fpStats; }
	inline void operator+=(const RenderStatistics& rhs) { intStats += rhs.intStats; fpStats += rhs.fpStats; }

protected:
	IntStatistics intStats;
	FPStatistics fpStats;
};

}

#endif // POVRAY_BACKEND_STATISTICS_H
