/*******************************************************************************
 * taskqueue.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/support/taskqueue.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BACKEND_TASKQUEUE_H
#define POVRAY_BACKEND_TASKQUEUE_H

#include <boost/thread.hpp>
#include <boost/thread/condition.hpp>

#include "base/povmscpp.h"
#include "backend/support/task.h"

namespace pov
{

class TaskQueue
{
		class TaskEntry
		{
			public:
				enum EntryType
				{
					kTask,
					kSync,
					kMessage,
					kFunction,
				};

				TaskEntry(EntryType et) : entryType(et) { }
				TaskEntry(shared_ptr<Task> rt) : entryType(kTask), task(rt) { }
				TaskEntry(POVMS_Message& m) : entryType(kMessage), msg(m) { }
				TaskEntry(const boost::function1<void, TaskQueue&>& f) : entryType(kFunction), fn(f) { }
				~TaskEntry() { }

				shared_ptr<Task> GetTask() { return task; }
				POVMS_Message& GetMessage() { return msg; }
				boost::function1<void, TaskQueue&>& GetFunction() { return fn; }

				EntryType GetEntryType() { return entryType; }
			private:
				EntryType entryType;
				shared_ptr<Task> task;
				POVMS_Message msg;
				boost::function1<void, TaskQueue&> fn;
		};
	public:
		TaskQueue();
		~TaskQueue();

		void Stop();
		void Pause();
		void Resume();

		bool IsPaused();
		bool IsRunning();
		bool IsDone();
		bool Failed();

		int FailureCode(int defval = kNoError);

		Task::TaskData *AppendTask(Task *task);
		void AppendSync();
		void AppendMessage(POVMS_Message& msg);
		void AppendFunction(const boost::function1<void, TaskQueue&>& fn);

		bool Process();
	private:
		/// queued task list
		std::queue<TaskEntry> queuedTasks;
		/// active task list
		list<TaskEntry> activeTasks;
		/// queue mutex
		RecursiveMutex queueMutex;
		/// failed code
		int failed;
		/// not available
		TaskQueue(const TaskQueue&);

		/// not available
		TaskQueue& operator=(const TaskQueue&);
};

}

#endif // POVRAY_BACKEND_TASKQUEUE_H
