/*******************************************************************************
 * pigment.h
 *
 * This module contains all defines, typedefs, and prototypes for PIGMENT.CPP.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/texture/pigment.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

/* NOTE: FRAME.H contains other pigment stuff. */

#ifndef PIGMENT_H
#define PIGMENT_H

namespace pov
{

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/




/*****************************************************************************
* Global typedefs
******************************************************************************/



/*****************************************************************************
* Global variables
******************************************************************************/



/*****************************************************************************
* Global constants
******************************************************************************/

extern const BLEND_MAP Brick_Default_Map;
extern const BLEND_MAP Hex_Default_Map;
extern const BLEND_MAP Cubic_Default_Map; // JN2007: Cubic pattern
extern const BLEND_MAP Check_Default_Map;


/*****************************************************************************
* Global functions
******************************************************************************/

PIGMENT *Create_Pigment(unsigned int noisegenerator);
PIGMENT *Copy_Pigment(const PIGMENT *Old);
void Destroy_Pigment(PIGMENT *Pigment);
int Post_Pigment(PIGMENT *Pigment);
bool Compute_Pigment(Colour& colour, const PIGMENT *Pigment, const VECTOR IPoint, const Intersection *Intersect, const Ray *ray, TraceThreadData *Thread);
void Evaluate_Density_Pigment(PIGMENT *pigm, const Vector3d& p, RGBColour& c, TraceThreadData *ttd);

}

#endif
