/*******************************************************************************
 * path.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/base/path.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BASE_PATH_H
#define POVRAY_BASE_PATH_H

#include "base/configbase.h"
#include "base/types.h"

#include <string>
#include <vector>

namespace pov_base
{

class Path
{
	public:
		enum Encoding
		{
			ASCII,
			URL
		};

		Path();
		Path(const char *p, Encoding e = ASCII);
		Path(const string& p, Encoding e = ASCII);
		Path(const UCS2 *p);
		Path(const UCS2String& p);
		Path(const Path& p1, const Path& p2);

		bool operator==(const Path& p) const;
		bool operator!=(const Path& p) const;

		UCS2String operator()() const;

		bool HasVolume() const;

		UCS2String GetVolume() const;
		UCS2String GetFolder() const;
		vector<UCS2String> GetAllFolders() const;
		UCS2String GetFile() const;

		void SetVolume(const char *p);
		void SetVolume(const string& p);
		void SetVolume(const UCS2 *p);
		void SetVolume(const UCS2String& p);

		void AppendFolder(const char *p);
		void AppendFolder(const string& p);
		void AppendFolder(const UCS2 *p);
		void AppendFolder(const UCS2String& p);

		void RemoveFolder();
		void RemoveAllFolders();

		void SetFile(const char *p);
		void SetFile(const string& p);
		void SetFile(const UCS2 *p);
		void SetFile(const UCS2String& p);

		void Clear();

		bool Empty() const;
	private:
		UCS2String volume;
		vector<UCS2String> folders;
		UCS2String file;

		void ParsePathString(const UCS2String& p);

		UCS2String URLToUCS2String(const char *p) const;
		UCS2String URLToUCS2String(const string& p) const;
};

}

#endif // POVRAY_BASE_PATH_H
