/*******************************************************************************
 * configfrontend.h
 *
 * This header file defines all types that can be configured by platform
 * specific code for frontend use. It further allows insertion of platform
 * specific function prototypes making use of those types.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/frontend/configfrontend.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef CONFIGFRONTEND_H
#define CONFIGFRONTEND_H

#include "syspovconfigfrontend.h"

// The output file format used if the user doesn't specify one 
#ifndef DEFAULT_OUTPUT_FORMAT
	#define DEFAULT_OUTPUT_FORMAT   kPOVList_FileType_Targa
#endif

/*
 * The DEFAULT_DISPLAY_GAMMA is used when there isn't one specified by the
 * user in the POVRAY.INI.  For those systems that are very savvy, this
 * could be a function which returns the current display gamma.  The
 * DEFAULT_ASSUMED_GAMMA should be left alone.
 */
#ifndef DEFAULT_DISPLAY_GAMMA
	#define DEFAULT_DISPLAY_GAMMA 2.2
#endif

#ifndef DEFAULT_FILE_GAMMA
	#define DEFAULT_FILE_GAMMA 1.0
#endif

// For backwward compatibility only, will be removed after POV-Ray 3.7! [trf]
#ifndef DEFAULT_ASSUMED_GAMMA
	#define DEFAULT_ASSUMED_GAMMA 1.0
#endif

#include "syspovprotofrontend.h"

#endif
