/*******************************************************************************
 * display.cpp
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/frontend/display.cpp $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

// configbase.h must always be the first POV file included within base *.cpp files
#include "base/configbase.h"
#include "base/types.h"

#include "frontend/configfrontend.h"
#include "frontend/display.h"

// this must be the last file included
#include "base/povdebug.h"

namespace pov_frontend
{

Display::Display(unsigned int w, unsigned int h, COLC gf) :
	width(w),
	height(h),
	gammaFactor(gf)
{
	// nothing to do
}

Display::~Display()
{
	// nothing to do
}

unsigned int Display::GetWidth()
{
	return width;
}

unsigned int Display::GetHeight()
{
	return height;
}

COLC Display::GetGammaFactor()
{
	return gammaFactor;
}

void Display::DrawRectangleFrame(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, const RGBA8& colour)
{
	for(unsigned int x = x1; x <= x2; x++)
	{
		DrawPixel(x, y1, colour);
		DrawPixel(x, y2, colour);
	}

	for(unsigned int y = y1; y <= y2; y++)
	{
		DrawPixel(x1, y, colour);
		DrawPixel(x2, y, colour);
	}
}

void Display::DrawFilledRectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, const RGBA8& colour)
{
	for(unsigned int y = y1; y <= y2; y++)
		for(unsigned int x = x1; x <= x2; x++)
			DrawPixel(x, y, colour);
}

void Display::DrawPixelBlock(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, const RGBA8 *colour)
{
	for(unsigned int y = y1, i = 0; y <= y2; y++)
		for(unsigned int x = x1; x <= x2; x++, i++)
			DrawPixel(x, y, colour[i]);
}

void Display::Clear()
{
	RGBA8 colour;

	colour.red = colour.green = colour.blue = colour.alpha = 0;

	for(unsigned int y = 0; y < GetHeight(); y++)
		for(unsigned int x = 0; x < GetWidth(); x++)
			DrawPixel(x, y, colour);
}

}
