/*******************************************************************************
 * imageprocessing.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/frontend/imageprocessing.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_FRONTEND_IMAGEPROCESSING_H
#define POVRAY_FRONTEND_IMAGEPROCESSING_H

#include "base/povmscpp.h"
#include "base/povmsgid.h"
#include "base/image/image.h"
#include "base/fileinputoutput.h"

#include "frontend/configfrontend.h"

#include <string>

#include <boost/scoped_ptr.hpp>

namespace pov_frontend
{

using namespace pov_base;

class ImageProcessing
{
	public:
		ImageProcessing(unsigned int width, unsigned int height);
		ImageProcessing(POVMS_Object& ropts);
		ImageProcessing(shared_ptr<Image>& img);
		virtual ~ImageProcessing();

		UCS2String WriteImage(POVMS_Object& ropts, POVMSInt frame = 0, int digits = 0);

		shared_ptr<Image>& GetImage();

		UCS2String GetOutputFilename(POVMS_Object& ropts, POVMSInt frame, int digits);
		bool OutputIsStdout(void) { return toStdout; }
		bool OutputIsStderr(void) { return toStderr; }
		virtual bool OutputIsStdout(POVMS_Object& ropts);
		virtual bool OutputIsStderr(POVMS_Object& ropts);
	protected:
		shared_ptr<Image> image;
		bool toStdout;
		bool toStderr;

		void RGB2XYZ(const COLC *rgb, COLC *xyz);
		void XYZ2RGB(const COLC *xyz, COLC *rgb);
	private:
		ImageProcessing();
		ImageProcessing(const ImageProcessing&);
		ImageProcessing& operator=(const ImageProcessing&);
};

}

#endif // POVRAY_FRONTEND_IMAGEPROCESSING_H
