
      module mo_params

      use shr_kind_mod, only : r8 => shr_kind_r8
      use shr_const_mod,only : SHR_CONST_REARTH

      implicit none

      integer, parameter :: kz = 100                  ! altitudes
      integer, parameter :: kw = 650                  ! wavelengths
!----------------------------------------------------------------------------
! 	... number of weighting functions
!           wavelength dependent
!----------------------------------------------------------------------------
      integer, parameter :: ks = 60
!----------------------------------------------------------------------------
!  	... wavelength and altitude dependent
!----------------------------------------------------------------------------
      integer, parameter :: kj = 70

!----------------------------------------------------------------------------
!  	... number of photorates to use from tuv
!----------------------------------------------------------------------------
      integer, parameter :: tuv_jmax = 31

!----------------------------------------------------------------------------
! 	... delta for adding points at beginning or end of data grids
!----------------------------------------------------------------------------
      real(r8), parameter :: deltax = 1.e-4_r8
      real(r8), parameter :: radius =  SHR_CONST_REARTH*1.e-3 ! radius earth (km)

      real(r8) :: largest
      real(r8) :: smallest

      end module mo_params
