#!/bin/bash

. ../MasterTest.sh

# ========== TESTS ==========
# atomicfluct
Test_atomicfluct() {
  TOP="../tz2.parm7"
  cat > ptraj.in <<EOF
trajin ../tz2.nc
atomicfluct out fluct.dat @C,CA,N byres bfactor
EOF
  $PTRAJ $TOP $INPUT > ptraj.out 
  mv fluct.dat ptraj.fluct.dat
  RunCpptraj "atomicfluct test."
  DoTest ptraj.fluct.dat fluct.dat
}

# checkoverlap
Test_checkoverlap() {
  TOP="../tz2.ortho.parm7"
  cat > ptraj.in <<EOF
trajin ../tz2.ortho.nc 1 1
#checkoverlap around :1-13
checkoverlap :1-100 min 1.2
EOF
  $PTRAJ $TOP $INPUT > ptraj.out
  #mv ptraj.out checkoverlap.dat
  RunCpptraj "checkoverlap test."
  #DoTest ptraj.fluct.dat fluct.dat
  CheckTest
}

# clusterdihedral
Test_clusterdihedral() {
  TOP="../tz2.parm7"
  cat > ptraj.in <<EOF
trajin ../tz2.nc
clusterdihedral out cd.dat cut 1 framefile cf.dat clusterinfo ci.dat :2-12
EOF
  $PTRAJ $TOP $INPUT > ptraj.out
  mv cd.dat ptraj.cd.dat
  mv cf.dat ptraj.cf.dat
  mv ci.dat ptraj.ci.dat
  RunCpptraj "clusterdihedral test."
  DoTest ptraj.cd.dat cd.dat
  DoTest ptraj.cf.dat cf.dat
  DoTest ptraj.ci.dat ci.dat
  CheckTest
}

# contacts
Test_contacts() {
  TOP="../tz2.truncoct.parm7"
  cat > ptraj.in <<EOF
#reference tz2.truncoct.rst7 
#reference tz2.truncoct.pdb
trajin ../tz2.truncoct.nc
#contacts reference out contacts.dat :2-12@CA
contacts first out contacts.dat :2-12@CA
EOF
  $PTRAJ $TOP $INPUT > ptraj.out
  mv contacts.dat ptraj.contacts.dat
  RunCpptraj "contacts test."
  DoTest ptraj.contacts.dat contacts.dat
  CheckTest
}

#diffusion
# creates <prefix>_X.xmgr, X = {a,r,x,y,z}
Test_diffusion() {
  TOP="../tz2.ortho.parm7"
  cat > ptraj.in <<EOF
trajin ../tz2.ortho.nc
diffusion :1-13 1.0 diff
EOF
  $PTRAJ $TOP $INPUT > ptraj.out
  mv diff_a.xmgr ptraj.diff_a.xmgr
  mv diff_r.xmgr ptraj.diff_r.xmgr
  mv diff_x.xmgr ptraj.diff_x.xmgr
  mv diff_y.xmgr ptraj.diff_y.xmgr
  mv diff_z.xmgr ptraj.diff_z.xmgr
  RunCpptraj "diffusion test."
  DoTest ptraj.diff_a.xmgr diff_a.xmgr
  DoTest ptraj.diff_r.xmgr diff_r.xmgr
  DoTest ptraj.diff_x.xmgr diff_x.xmgr
  DoTest ptraj.diff_y.xmgr diff_y.xmgr
  DoTest ptraj.diff_z.xmgr diff_z.xmgr
  CheckTest
}

# dipole
Test_dipole() {
  TOP="../tz2.ortho.parm7"
  cat > ptraj.in <<EOF
trajin ../tz2.ortho.nc
rms first :1-13
center :1-13 mass origin 
image origin center familiar
dipole out.dipole 20 0.5 20 0.5 20 0.5 :WAT
EOF
  $PTRAJ $TOP $INPUT > ptraj.out
  mv out.dipole ptraj.out.dipole
  RunCpptraj "dipole test"
  DoTest ptraj.out.dipole out.dipole
  CheckTest
}

# grid - also tests rms, imaging, centering
Test_grid() {
  TOP="../tz2.truncoct.parm7"
  cat > ptraj.in <<EOF
trajin ../tz2.truncoct.nc
rms first :1-13
center :1-13 mass origin 
image origin center familiar
trajout test.crd title "trajectory generated by ptraj"
grid out.grid 20 0.5 20 0.5 20 0.5 :WAT@O  
EOF
  $PTRAJ $TOP $INPUT > ptraj.out
  mv test.crd ptraj.test.crd
  mv out.grid ptraj.out.grid
  RunCpptraj "grid test."
  DoTest ptraj.test.crd test.crd
  DoTest ptraj.out.grid out.grid
  CheckTest
}

# principal
Test_principal() {
  TOP="../tz2.parm7"
  cat > ptraj.in <<EOF
trajin ../tz2.nc 1 10
principal * dorotation
trajout principal.crd nobox title "Test"
EOF
  $PTRAJ $TOP $INPUT > ptraj.out
  mv principal.crd ptraj.principal.crd
  RunCpptraj "principal test."
  DoTest ptraj.principal.crd principal.crd
  CheckTest
}

# randomizeions
Test_randomizeions() {
  TOP="adh206.ff10.tip3p.parm7"
  cat > ptraj.in <<EOF
trajin adh206.tip3p.rst7
randomizeions @Na+ around :1-16 by 5.0 overlap 3.0
trajout random.crd title "Test"
EOF
  $PTRAJ $TOP $INPUT > ptraj.out
  mv random.crd ptraj.random.crd
  RunCpptraj "randomizeions test"
  DoTest ptraj.random.crd random.crd
  CheckTest
}

# unwrap
Test_unwrap() {
  TOP="../tz2.truncoct.parm7"
  cat > ptraj.in <<EOF
trajin ../tz2.truncoct.nc
unwrap :1-13
center :1-13 mass origin
image origin center familiar
trajout unwrap.crd title "Test"
EOF
  $PTRAJ $TOP $INPUT > ptraj.out
  mv unwrap.crd ptraj.unwrap.crd
  RunCpptraj "unwrap test"
  DoTest ptraj.unwrap.crd unwrap.crd
  CheckTest
}

# ==============================================================================
CleanFiles ptraj.* fluct.dat checkoverlap.dat cd.dat cf.dat ci.dat \
           contacts.dat diff_?.xmgr test.crd out.grid out.dipole \
           principal.crd unwrap.crd random.crd

# Test ptraj actions implemented within cpptraj framework
INPUT="ptraj.in"

if [[ -z $AMBERHOME ]] ; then
  PTRAJ=`which ptraj`
else
  PTRAJ=$AMBERHOME/bin/ptraj
fi
if [[ -z $PTRAJ || ! -e $PTRAJ ]] ; then
  echo "Ptraj not found. Cannot run ptraj comparison tests."
  exit 1
fi
echo "  Comparing to ptraj: $PTRAJ"

# First run ptraj, then check cpptraj
 Test_atomicfluct
 #Test_checkoverlap
 Test_clusterdihedral
 Test_contacts
 Test_diffusion
 Test_grid
 Test_dipole
 Test_principal
 Test_unwrap
 Test_randomizeions

EndTest

exit 0
