






      module mo_prod_loss

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: exp_prod_loss
      public :: imp_prod_loss

      contains

      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:,:,:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:,:,:)
      real(r8), intent(in) :: rxt(:,:,:)
      real(r8), intent(in) :: het_rates(:,:,:)



!--------------------------------------------------------------------
! ... loss and production for Explicit method
!--------------------------------------------------------------------


         loss(:,:,1) = (rxt(:,:,76)* y(:,:,3) +rxt(:,:,75)* y(:,:,12))* y(:,:,15)
         prod(:,:,1) = 0._r8
         loss(:,:,2) = ((rxt(:,:,57) +rxt(:,:,58))* y(:,:,3) + rxt(:,:,4))* y(:,:,4)
         prod(:,:,2) = 0._r8
         loss(:,:,3) = (rxt(:,:,84)* y(:,:,12))* y(:,:,16)
         prod(:,:,3) = 0._r8
         loss(:,:,4) = ( + rxt(:,:,195))* y(:,:,97)
         prod(:,:,4) = 0._r8
         loss(:,:,5) = ( + het_rates(:,:,15))* y(:,:,98)
         prod(:,:,5) =rxt(:,:,195)*y(:,:,97)
         loss(:,:,6) = (rxt(:,:,46)* y(:,:,3) +rxt(:,:,47)* y(:,:,12))* y(:,:,11)
         prod(:,:,6) =.050_r8*rxt(:,:,76)*y(:,:,15)*y(:,:,3)

      end subroutine exp_prod_loss

      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:)
      real(r8), intent(in) :: rxt(:)
      real(r8), intent(in) :: het_rates(:)



!--------------------------------------------------------------------
! ... loss and production for Implicit method
!--------------------------------------------------------------------


         loss(90) = (rxt(42)* y(2) +rxt(60)* y(5) +rxt(62)* y(6) +rxt(50)* y(12) &
                  +rxt(51)* y(13) +rxt(86)* y(22) +rxt(97)* y(33) +rxt(140)* y(50) &
                  +rxt(148)* y(53) +rxt(150)* y(54) +rxt(167)* y(63) + rxt(2) &
                  + rxt(3))* y(1)
         prod(90) = (.100_r8*rxt(140)*y(50) +.200_r8*rxt(148)*y(53) + &
                 .200_r8*rxt(150)*y(54))*y(1) + (.890_r8*rxt(8) +.890_r8*rxt(9))*y(7) &
                  + (.250_r8*rxt(106)*y(31) +.250_r8*rxt(160)*y(57))*y(13) +rxt(41) &
                 *y(2)
         loss(29) = ((rxt(57) +rxt(58))* y(4) +rxt(46)* y(11) +rxt(76)* y(15) &
                  + rxt(43) + rxt(44) + rxt(45))* y(3)
         prod(29) =rxt(2)*y(1)
         loss(56) = (rxt(42)* y(1) +rxt(61)* y(6) +rxt(48)* y(12) +rxt(49)* y(13) &
                  + rxt(41))* y(2)
         prod(56) = (rxt(43) +rxt(44))*y(3) +rxt(3)*y(1) +rxt(5)*y(6) +rxt(55)*y(12) &
                 *y(12)
         loss(88) = (rxt(60)* y(1) +rxt(68)* y(7) +rxt(59)* y(13) +rxt(77)* y(17) &
                  +rxt(87)* y(24) +rxt(91)* y(28) +rxt(104)* y(31) +rxt(112)* y(35) &
                  +rxt(99)* y(37) +rxt(117)* y(40) +rxt(122)* y(43) +rxt(129)* y(45) &
                  +rxt(124)* y(48) +rxt(141)* y(51) + (rxt(151) +rxt(152))* y(55) &
                  +rxt(158)* y(57) +rxt(182)* y(61) +rxt(169)* y(64) +rxt(135)* y(68) &
                  +rxt(174)* y(76))* y(5)
         prod(88) = (rxt(5) +.500_r8*rxt(74) +rxt(61)*y(2))*y(6) + (.110_r8*rxt(8) + &
                 .110_r8*rxt(9))*y(7) +2.000_r8*rxt(57)*y(4)*y(3)
         loss(92) = (rxt(62)* y(1) +rxt(61)* y(2) +rxt(64)* y(7) +rxt(66)* y(12) &
                  +rxt(69)* y(13) +rxt(105)* y(31) +rxt(164)* y(57) +rxt(134)* y(70) &
                  + rxt(5) + rxt(74))* y(6)
         prod(92) = (rxt(59)*y(13) +rxt(60)*y(1) +2.000_r8*rxt(68)*y(7) + &
                 rxt(77)*y(17) +rxt(87)*y(24) +rxt(91)*y(28) +rxt(99)*y(37) + &
                 rxt(104)*y(31) +rxt(112)*y(35) +rxt(117)*y(40) +rxt(122)*y(43) + &
                 .900_r8*rxt(124)*y(48) +rxt(129)*y(45) +.900_r8*rxt(135)*y(68) + &
                 .920_r8*rxt(141)*y(51) +rxt(151)*y(55) +rxt(158)*y(57) + &
                 rxt(169)*y(64) +1.206_r8*rxt(174)*y(76) +rxt(182)*y(61))*y(5) &
                  + (.890_r8*rxt(8) +.890_r8*rxt(9) +rxt(63)*y(13) +rxt(142)*y(51) + &
                 rxt(153)*y(55) +rxt(159)*y(57) +rxt(168)*y(63) + &
                 1.206_r8*rxt(175)*y(76) +rxt(180)*y(77) +rxt(183)*y(61))*y(7) &
                  + (.660_r8*rxt(10) +.660_r8*rxt(11) +rxt(71) +rxt(70)*y(12))*y(9) &
                  + (rxt(6) +rxt(65))*y(10) + (rxt(127)*y(74) +.400_r8*rxt(179)*y(77)) &
                 *y(12) + (.600_r8*rxt(19) +rxt(109))*y(73) + (rxt(20) +rxt(165)) &
                 *y(75) +.700_r8*rxt(134)*y(70)*y(6) +rxt(7)*y(8) &
                  +.206_r8*rxt(176)*y(76)*y(13) +rxt(30)*y(77)
         loss(84) = (rxt(68)* y(5) +rxt(64)* y(6) +rxt(63)* y(13) +rxt(82)* y(19) &
                  +rxt(103)* y(30) +rxt(98)* y(33) +rxt(173)* y(50) +rxt(142)* y(51) &
                  +rxt(153)* y(55) +rxt(159)* y(57) +rxt(178)* y(60) +rxt(183)* y(61) &
                  +rxt(168)* y(63) +rxt(175)* y(76) +rxt(180)* y(77) +rxt(200)* y(85) &
                  + rxt(8) + rxt(9) + rxt(73))* y(7)
         prod(84) = (rxt(67)*y(8) +.500_r8*rxt(191)*y(75) +rxt(192)*y(73))*y(12) &
                  + (.330_r8*rxt(10) +.330_r8*rxt(11))*y(9) + (rxt(6) +rxt(65))*y(10) &
                  +rxt(62)*y(6)*y(1) +.400_r8*rxt(19)*y(73)
         loss(55) = (rxt(67)* y(12) + rxt(7) + het_rates(2))* y(8)
         prod(55) = (rxt(73) +rxt(82)*y(19) +rxt(103)*y(30) +rxt(178)*y(60) + &
                 rxt(200)*y(85))*y(7) + (.500_r8*rxt(74) +rxt(66)*y(12))*y(6) &
                  +2.000_r8*rxt(72)*y(10)
         loss(40) = (rxt(70)* y(12) + rxt(10) + rxt(11) + rxt(71) + het_rates(7)) &
                 * y(9)
         prod(40) =rxt(69)*y(13)*y(6)
         loss(30) = ( + rxt(6) + rxt(65) + rxt(72))* y(10)
         prod(30) =rxt(64)*y(7)*y(6)
         loss(86) = (rxt(50)* y(1) +rxt(48)* y(2) +rxt(66)* y(6) +rxt(67)* y(8) &
                  +rxt(70)* y(9) +rxt(47)* y(11) + 2._r8*(rxt(55) +rxt(56))* y(12) &
                  +rxt(54)* y(13) +rxt(53)* y(14) +rxt(75)* y(15) +rxt(84)* y(16) &
                  +rxt(81)* y(18) +rxt(83)* y(19) +rxt(189)* y(20) +rxt(190)* y(21) &
                  +rxt(85)* y(22) +rxt(172)* y(25) +rxt(194)* y(26) +rxt(90)* y(27) &
                  +rxt(95)* y(29) +rxt(102)* y(30) +rxt(108)* y(32) +rxt(96)* y(33) &
                  +rxt(111)* y(34) +rxt(115)* y(36) +rxt(101)* y(38) +rxt(116)* y(39) &
                  +rxt(120)* y(41) +rxt(121)* y(42) +rxt(128)* y(44) +rxt(131)* y(46) &
                  +rxt(123)* y(47) +rxt(126)* y(49) +rxt(139)* y(50) +rxt(144)* y(52) &
                  +rxt(147)* y(53) +rxt(149)* y(54) +rxt(157)* y(56) +rxt(181)* y(58) &
                  +rxt(193)* y(59) +rxt(177)* y(60) +rxt(187)* y(62) +rxt(166)* y(63) &
                  +rxt(171)* y(65) +rxt(132)* y(66) +rxt(133)* y(67) +rxt(137)* y(69) &
                  +rxt(138)* y(72) +rxt(192)* y(73) +rxt(127)* y(74) +rxt(191)* y(75) &
                  +rxt(179)* y(77) +rxt(197)* y(83) + (rxt(198) +rxt(199))* y(85) &
                  +rxt(201)* y(86))* y(12)
         prod(86) = (rxt(51)*y(13) +.120_r8*rxt(86)*y(22) +.330_r8*rxt(97)*y(33) + &
                 .270_r8*rxt(140)*y(50) +.080_r8*rxt(148)*y(53) + &
                 .215_r8*rxt(150)*y(54) +.700_r8*rxt(167)*y(63))*y(1) &
                  + (.300_r8*rxt(81)*y(18) +.500_r8*rxt(95)*y(29) + &
                 .500_r8*rxt(101)*y(38) +.100_r8*rxt(157)*y(56))*y(12) &
                  + (2.000_r8*rxt(45) +rxt(46)*y(11) +.750_r8*rxt(76)*y(15))*y(3) &
                  + (rxt(49)*y(2) +rxt(59)*y(5) +rxt(63)*y(7))*y(13) &
                  + (.330_r8*rxt(10) +.330_r8*rxt(11))*y(9) + (.330_r8*rxt(21) + &
                 .330_r8*rxt(22))*y(54) +.500_r8*rxt(74)*y(6) +rxt(7)*y(8) &
                  +2.000_r8*rxt(15)*y(14) +rxt(12)*y(18) +rxt(24)*y(29) +rxt(18)*y(32) &
                  +rxt(25)*y(36) +rxt(17)*y(38) +rxt(26)*y(41) +rxt(38)*y(46) +rxt(37) &
                 *y(49) +rxt(29)*y(62) +rxt(40)*y(65) +rxt(39)*y(69)
         loss(87) = (rxt(51)* y(1) +rxt(49)* y(2) +rxt(59)* y(5) +rxt(69)* y(6) &
                  +rxt(63)* y(7) +rxt(54)* y(12) + 2._r8*rxt(52)* y(13) +rxt(80) &
                 * y(17) +rxt(92)* y(28) +rxt(106)* y(31) +rxt(113)* y(35) +rxt(100) &
                 * y(37) +rxt(118)* y(40) +rxt(130)* y(45) +rxt(125)* y(48) +rxt(143) &
                 * y(51) +rxt(154)* y(55) +rxt(160)* y(57) +rxt(184)* y(61) +rxt(170) &
                 * y(64) +rxt(136)* y(68) +rxt(176)* y(76) + rxt(203))* y(13)
         prod(87) = (rxt(47)*y(11) +rxt(84)*y(16) +rxt(48)*y(2) +rxt(50)*y(1) + &
                 rxt(53)*y(14) +rxt(83)*y(19) +.250_r8*rxt(85)*y(22) + &
                 .250_r8*rxt(132)*y(66) +rxt(138)*y(72) +.200_r8*rxt(157)*y(56) + &
                 rxt(179)*y(77) +rxt(189)*y(20) +rxt(190)*y(21) + &
                 .500_r8*rxt(191)*y(75) +rxt(193)*y(59) +rxt(194)*y(26) + &
                 .500_r8*rxt(199)*y(85))*y(12) + (rxt(77)*y(17) +rxt(91)*y(28) + &
                 rxt(99)*y(37) +rxt(112)*y(35) +rxt(122)*y(43) + &
                 .900_r8*rxt(124)*y(48) +.900_r8*rxt(135)*y(68) +rxt(141)*y(51) + &
                 .470_r8*rxt(151)*y(55) +rxt(169)*y(64) +.794_r8*rxt(174)*y(76) + &
                 1.500_r8*rxt(182)*y(61))*y(5) + (2.000_r8*rxt(78)*y(17) + &
                 rxt(93)*y(28) +.900_r8*rxt(107)*y(31) +rxt(114)*y(35) + &
                 .300_r8*rxt(119)*y(40) +rxt(145)*y(51) +.730_r8*rxt(155)*y(55) + &
                 rxt(161)*y(57) +rxt(185)*y(61))*y(17) + (.120_r8*rxt(86)*y(22) + &
                 .190_r8*rxt(97)*y(33) +.060_r8*rxt(140)*y(50) + &
                 .060_r8*rxt(148)*y(53) +.275_r8*rxt(150)*y(54) +rxt(167)*y(63))*y(1) &
                  + (rxt(82)*y(19) +rxt(142)*y(51) +.470_r8*rxt(153)*y(55) + &
                 .794_r8*rxt(175)*y(76) +rxt(180)*y(77) +1.500_r8*rxt(183)*y(61))*y(7) &
                  + (.660_r8*rxt(10) +.660_r8*rxt(11) +rxt(71))*y(9) &
                  + (rxt(146)*y(51) +.470_r8*rxt(156)*y(55) +1.500_r8*rxt(186)*y(61)) &
                 *y(31) + (rxt(46)*y(11) +.400_r8*rxt(76)*y(15))*y(3) + (rxt(88) + &
                 rxt(89))*y(23) + (.670_r8*rxt(21) +.670_r8*rxt(22))*y(54) &
                  +.700_r8*rxt(134)*y(70)*y(6) +.794_r8*rxt(176)*y(76)*y(13) +rxt(12) &
                 *y(18) +2.000_r8*rxt(13)*y(19) +2.000_r8*rxt(33)*y(26) &
                  +1.200_r8*rxt(94)*y(28)*y(28) +rxt(24)*y(29) +rxt(16)*y(30) +rxt(25) &
                 *y(36) +rxt(17)*y(38) +.900_r8*rxt(37)*y(49) +rxt(31)*y(52) +rxt(32) &
                 *y(59) +rxt(28)*y(60) +rxt(40)*y(65) +.560_r8*rxt(35)*y(71) &
                  +2.000_r8*rxt(36)*y(72) +rxt(30)*y(77)
         loss(25) = (rxt(53)* y(12) + rxt(15) + het_rates(1))* y(14)
         prod(25) = (.500_r8*rxt(203) +rxt(52)*y(13))*y(13) +rxt(56)*y(12)*y(12)
         loss(89) = (rxt(77)* y(5) +rxt(80)* y(13) + 2._r8*(rxt(78) +rxt(79))* y(17) &
                  +rxt(93)* y(28) +rxt(107)* y(31) +rxt(114)* y(35) +rxt(119)* y(40) &
                  +rxt(145)* y(51) +rxt(155)* y(55) +rxt(161)* y(57) +rxt(185)* y(61)) &
                 * y(17)
         prod(89) = (rxt(104)*y(5) +.900_r8*rxt(107)*y(17) +2.000_r8*rxt(110)*y(31) + &
                 rxt(146)*y(51) +rxt(156)*y(55) +rxt(162)*y(57) +rxt(186)*y(61))*y(31) &
                  + (rxt(75)*y(15) +.700_r8*rxt(81)*y(18) +rxt(172)*y(25))*y(12) &
                  +.310_r8*rxt(97)*y(33)*y(1) +.750_r8*rxt(76)*y(15)*y(3) +rxt(16) &
                 *y(30) +rxt(18)*y(32) +rxt(27)*y(39) +.300_r8*rxt(23)*y(53) &
                  +.400_r8*rxt(19)*y(73)
         loss(42) = (rxt(81)* y(12) + rxt(12) + het_rates(4))* y(18)
         prod(42) =rxt(80)*y(17)*y(13)
         loss(77) = (rxt(82)* y(7) +rxt(83)* y(12) + rxt(13) + rxt(14) + het_rates(3)) &
                 * y(19)
         prod(77) = (rxt(77)*y(5) +2.000_r8*rxt(78)*y(17) +rxt(79)*y(17) + &
                 .700_r8*rxt(93)*y(28) +rxt(107)*y(31) +rxt(114)*y(35) + &
                 .800_r8*rxt(119)*y(40) +1.200_r8*rxt(145)*y(51) + &
                 .880_r8*rxt(155)*y(55) +2.000_r8*rxt(161)*y(57) + &
                 .700_r8*rxt(185)*y(61))*y(17) + (rxt(99)*y(37) +rxt(117)*y(40) + &
                 .500_r8*rxt(122)*y(43) +.100_r8*rxt(124)*y(48) + &
                 .550_r8*rxt(141)*y(51) +.250_r8*rxt(151)*y(55) +rxt(158)*y(57) + &
                 .072_r8*rxt(174)*y(76))*y(5) + (.300_r8*rxt(81)*y(18) + &
                 .500_r8*rxt(85)*y(22) +.500_r8*rxt(108)*y(32) +rxt(189)*y(20) + &
                 .500_r8*rxt(191)*y(75) +rxt(192)*y(73) +.800_r8*rxt(194)*y(26))*y(12) &
                  + (rxt(86)*y(22) +.540_r8*rxt(97)*y(33) +.600_r8*rxt(140)*y(50) + &
                 .800_r8*rxt(148)*y(53) +.700_r8*rxt(150)*y(54))*y(1) &
                  + (.600_r8*rxt(142)*y(51) +.250_r8*rxt(153)*y(55) +rxt(159)*y(57) + &
                 .072_r8*rxt(175)*y(76))*y(7) + (.600_r8*rxt(146)*y(51) + &
                 .250_r8*rxt(156)*y(55) +rxt(162)*y(57))*y(31) + (.670_r8*rxt(21) + &
                 .670_r8*rxt(22))*y(54) +.250_r8*rxt(76)*y(15)*y(3) &
                  +.008_r8*rxt(176)*y(76)*y(13) +rxt(12)*y(18) +2.000_r8*rxt(89)*y(23) &
                  +rxt(33)*y(26) +rxt(17)*y(38) +rxt(26)*y(41) +.100_r8*rxt(37)*y(49) &
                  +.690_r8*rxt(31)*y(52) +2.000_r8*rxt(163)*y(57)*y(57) +rxt(32)*y(59) &
                  +rxt(30)*y(77)
         loss(59) = (rxt(189)* y(12) + het_rates(20))* y(20)
         prod(59) = (rxt(79)*y(17) +.300_r8*rxt(93)*y(28) +.500_r8*rxt(119)*y(40) + &
                 .250_r8*rxt(145)*y(51) +.250_r8*rxt(155)*y(55) + &
                 .300_r8*rxt(185)*y(61))*y(17)
         loss(32) = (rxt(190)* y(12) + het_rates(21))* y(21)
         prod(32) = (.200_r8*rxt(93)*y(17) +.400_r8*rxt(94)*y(28))*y(28)
         loss(37) = (rxt(86)* y(1) +rxt(85)* y(12))* y(22)
         prod(37) = 0._r8
         loss(26) = ( + rxt(88) + rxt(89))* y(23)
         prod(26) =rxt(87)*y(24)*y(5)
         loss(45) = (rxt(87)* y(5))* y(24)
         prod(45) =.750_r8*rxt(85)*y(22)*y(12)
         loss(49) = (rxt(172)* y(12) + het_rates(31))* y(25)
         prod(49) = (.250_r8*rxt(86)*y(22) +.250_r8*rxt(97)*y(33) + &
                 .200_r8*rxt(140)*y(50))*y(1) + (.250_r8*rxt(106)*y(31) + &
                 .250_r8*rxt(160)*y(57))*y(13) +.100_r8*rxt(107)*y(31)*y(17)
         loss(60) = (rxt(194)* y(12) + rxt(33) + het_rates(22))* y(26)
         prod(60) = (.530_r8*rxt(151)*y(5) +.530_r8*rxt(153)*y(7) + &
                 .260_r8*rxt(155)*y(17) +.530_r8*rxt(156)*y(31))*y(55) &
                  + (.250_r8*rxt(182)*y(5) +.250_r8*rxt(183)*y(7) + &
                 .100_r8*rxt(185)*y(17) +.250_r8*rxt(186)*y(31))*y(61) +rxt(88)*y(23)
         loss(18) = (rxt(90)* y(12))* y(27)
         prod(18) = 0._r8
         loss(68) = (rxt(91)* y(5) +rxt(92)* y(13) +rxt(93)* y(17) + 2._r8*rxt(94) &
                 * y(28))* y(28)
         prod(68) = (rxt(90)*y(27) +.500_r8*rxt(95)*y(29))*y(12) +rxt(34)*y(44)
         loss(41) = (rxt(95)* y(12) + rxt(24) + het_rates(11))* y(29)
         prod(41) =rxt(92)*y(28)*y(13)
         loss(73) = (rxt(103)* y(7) +rxt(102)* y(12) + rxt(16) + het_rates(25))* y(30)
         prod(73) = (rxt(91)*y(28) +rxt(99)*y(37) +.270_r8*rxt(112)*y(35) + &
                 rxt(122)*y(43) +.400_r8*rxt(124)*y(48) +rxt(129)*y(45))*y(5) &
                  + (.500_r8*rxt(97)*y(33) +.040_r8*rxt(148)*y(53))*y(1) &
                  + (.500_r8*rxt(95)*y(29) +rxt(190)*y(21))*y(12) &
                  + (.800_r8*rxt(93)*y(17) +1.600_r8*rxt(94)*y(28))*y(28) +rxt(24) &
                 *y(29) +rxt(17)*y(38) +rxt(38)*y(46) +.400_r8*rxt(37)*y(49)
         loss(85) = (rxt(104)* y(5) +rxt(105)* y(6) +rxt(106)* y(13) +rxt(107)* y(17) &
                  + 2._r8*rxt(110)* y(31) +rxt(146)* y(51) +rxt(156)* y(55) +rxt(186) &
                 * y(61))* y(31)
         prod(85) = (rxt(117)*y(40) +rxt(129)*y(45) +.530_r8*rxt(151)*y(55) + &
                 rxt(158)*y(57))*y(5) + (rxt(103)*y(30) +.530_r8*rxt(153)*y(55) + &
                 rxt(159)*y(57) +rxt(178)*y(60))*y(7) + (rxt(102)*y(30) + &
                 .500_r8*rxt(108)*y(32) +rxt(177)*y(60))*y(12) &
                  + (.300_r8*rxt(119)*y(40) +.260_r8*rxt(155)*y(55) +rxt(161)*y(57)) &
                 *y(17) + (.670_r8*rxt(21) +.670_r8*rxt(22))*y(54) &
                  + (.600_r8*rxt(19) +rxt(109))*y(73) +.530_r8*rxt(156)*y(55)*y(31) &
                  +rxt(27)*y(39) +rxt(26)*y(41) +rxt(34)*y(44) +rxt(38)*y(46) &
                  +.300_r8*rxt(23)*y(53) +2.000_r8*rxt(163)*y(57)*y(57) +rxt(32)*y(59) &
                  +rxt(28)*y(60) +.130_r8*rxt(35)*y(71)
         loss(48) = (rxt(108)* y(12) + rxt(18) + het_rates(6))* y(32)
         prod(48) = (.750_r8*rxt(106)*y(31) +.750_r8*rxt(160)*y(57))*y(13)
         loss(72) = (rxt(97)* y(1) +rxt(98)* y(7) +rxt(96)* y(12))* y(33)
         prod(72) =.070_r8*rxt(140)*y(50)*y(1) +.700_r8*rxt(23)*y(53)
         loss(19) = (rxt(111)* y(12))* y(34)
         prod(19) = 0._r8
         loss(69) = (rxt(112)* y(5) +rxt(113)* y(13) +rxt(114)* y(17))* y(35)
         prod(69) = (rxt(111)*y(34) +rxt(115)*y(36))*y(12)
         loss(39) = (rxt(115)* y(12) + rxt(25) + het_rates(12))* y(36)
         prod(39) =rxt(113)*y(35)*y(13)
         loss(65) = (rxt(99)* y(5) +rxt(100)* y(13))* y(37)
         prod(65) = (rxt(96)*y(33) +.500_r8*rxt(101)*y(38))*y(12)
         loss(54) = (rxt(101)* y(12) + rxt(17) + het_rates(5))* y(38)
         prod(54) =rxt(100)*y(37)*y(13)
         loss(64) = (rxt(116)* y(12) + rxt(27))* y(39)
         prod(64) = (.820_r8*rxt(112)*y(35) +.500_r8*rxt(122)*y(43) + &
                 .250_r8*rxt(124)*y(48) +.100_r8*rxt(169)*y(64))*y(5) &
                  +.820_r8*rxt(114)*y(35)*y(17) +.820_r8*rxt(25)*y(36) &
                  +.250_r8*rxt(37)*y(49) +.100_r8*rxt(40)*y(65)
         loss(75) = (rxt(117)* y(5) +rxt(118)* y(13) +rxt(119)* y(17))* y(40)
         prod(75) = (rxt(116)*y(39) +rxt(120)*y(41))*y(12)
         loss(33) = (rxt(120)* y(12) + rxt(26) + het_rates(13))* y(41)
         prod(33) =rxt(118)*y(40)*y(13)
         loss(20) = (rxt(121)* y(12))* y(42)
         prod(20) = 0._r8
         loss(34) = (rxt(122)* y(5))* y(43)
         prod(34) =rxt(121)*y(42)*y(12)
         loss(21) = (rxt(123)* y(12))* y(47)
         prod(21) = 0._r8
         loss(67) = (rxt(124)* y(5) +rxt(125)* y(13))* y(48)
         prod(67) = (rxt(123)*y(47) +rxt(126)*y(49))*y(12)
         loss(62) = (rxt(126)* y(12) + rxt(37) + het_rates(27))* y(49)
         prod(62) =rxt(125)*y(48)*y(13)
         loss(47) = (rxt(128)* y(12) + rxt(34))* y(44)
         prod(47) =.750_r8*rxt(124)*y(48)*y(5) +.800_r8*rxt(37)*y(49)
         loss(63) = (rxt(129)* y(5) +rxt(130)* y(13))* y(45)
         prod(63) = (rxt(128)*y(44) +rxt(131)*y(46))*y(12)
         loss(35) = (rxt(131)* y(12) + rxt(38) + het_rates(28))* y(46)
         prod(35) =rxt(130)*y(45)*y(13)
         loss(70) = (rxt(140)* y(1) +rxt(173)* y(7) +rxt(139)* y(12))* y(50)
         prod(70) = 0._r8
         loss(80) = (rxt(141)* y(5) +rxt(142)* y(7) +rxt(143)* y(13) +rxt(145)* y(17) &
                  +rxt(146)* y(31))* y(51)
         prod(80) = (rxt(139)*y(50) +.500_r8*rxt(144)*y(52))*y(12)
         loss(57) = (rxt(144)* y(12) + rxt(31) + het_rates(19))* y(52)
         prod(57) =rxt(143)*y(51)*y(13)
         loss(82) = (rxt(148)* y(1) +rxt(147)* y(12) + rxt(23) + het_rates(9))* y(53)
         prod(82) = (.320_r8*rxt(141)*y(5) +.350_r8*rxt(142)*y(7) + &
                 .260_r8*rxt(145)*y(17) +.350_r8*rxt(146)*y(31))*y(51) &
                  + (.039_r8*rxt(174)*y(5) +.039_r8*rxt(175)*y(7) + &
                 .039_r8*rxt(176)*y(13))*y(76) + (.200_r8*rxt(140)*y(50) + &
                 rxt(167)*y(63))*y(1) +rxt(169)*y(64)*y(5) +.402_r8*rxt(31)*y(52) &
                  +rxt(40)*y(65)
         loss(81) = (rxt(150)* y(1) +rxt(149)* y(12) + rxt(21) + rxt(22) &
                  + het_rates(10))* y(54)
         prod(81) = (.230_r8*rxt(141)*y(5) +.250_r8*rxt(142)*y(7) + &
                 .190_r8*rxt(145)*y(17) +.250_r8*rxt(146)*y(31))*y(51) &
                  + (.167_r8*rxt(174)*y(5) +.167_r8*rxt(175)*y(7) + &
                 .167_r8*rxt(176)*y(13))*y(76) + (.400_r8*rxt(140)*y(50) + &
                 rxt(167)*y(63))*y(1) +rxt(169)*y(64)*y(5) +.288_r8*rxt(31)*y(52) &
                  +rxt(40)*y(65)
         loss(83) = ((rxt(151) +rxt(152))* y(5) +rxt(153)* y(7) +rxt(154)* y(13) &
                  +rxt(155)* y(17) +rxt(156)* y(31))* y(55)
         prod(83) = (rxt(147)*y(53) +.500_r8*rxt(149)*y(54) +.200_r8*rxt(157)*y(56)) &
                 *y(12)
         loss(36) = (rxt(157)* y(12) + het_rates(16))* y(56)
         prod(36) =rxt(154)*y(55)*y(13)
         loss(91) = (rxt(158)* y(5) +rxt(164)* y(6) +rxt(159)* y(7) +rxt(160)* y(13) &
                  +rxt(161)* y(17) +rxt(162)* y(31) + 2._r8*rxt(163)* y(57))* y(57)
         prod(91) = (.330_r8*rxt(21) +.330_r8*rxt(22) +.500_r8*rxt(149)*y(12))*y(54) &
                  + (rxt(20) +rxt(165))*y(75) +.200_r8*rxt(140)*y(50)*y(1) &
                  +.500_r8*rxt(157)*y(56)*y(12)
         loss(43) = (rxt(181)* y(12) + het_rates(24))* y(58)
         prod(43) = (.370_r8*rxt(141)*y(5) +.400_r8*rxt(142)*y(7) + &
                 .300_r8*rxt(145)*y(17) +.400_r8*rxt(146)*y(31))*y(51) &
                  + (rxt(179)*y(12) +rxt(180)*y(7))*y(77)
         loss(76) = (rxt(193)* y(12) + rxt(32) + het_rates(23))* y(59)
         prod(76) = (.220_r8*rxt(151)*y(5) +.220_r8*rxt(153)*y(7) + &
                 .230_r8*rxt(155)*y(17) +.220_r8*rxt(156)*y(31))*y(55) &
                  + (.250_r8*rxt(182)*y(5) +.250_r8*rxt(183)*y(7) + &
                 .100_r8*rxt(185)*y(17) +.250_r8*rxt(186)*y(31))*y(61) &
                  + (.500_r8*rxt(101)*y(38) +.500_r8*rxt(191)*y(75))*y(12) &
                  +.200_r8*rxt(119)*y(40)*y(17)
         loss(78) = (rxt(178)* y(7) +rxt(177)* y(12) + rxt(28) + het_rates(14))* y(60)
         prod(78) = (.250_r8*rxt(151)*y(5) +.250_r8*rxt(153)*y(7) + &
                 .240_r8*rxt(155)*y(17) +.250_r8*rxt(156)*y(31))*y(55) &
                  + (.250_r8*rxt(182)*y(5) +.250_r8*rxt(183)*y(7) + &
                 .100_r8*rxt(185)*y(17) +.250_r8*rxt(186)*y(31))*y(61) &
                  + (.950_r8*rxt(148)*y(53) +.800_r8*rxt(150)*y(54))*y(1) &
                  + (rxt(127)*y(74) +rxt(193)*y(59))*y(12) +.450_r8*rxt(135)*y(68) &
                 *y(5) +.500_r8*rxt(119)*y(40)*y(17) +.450_r8*rxt(39)*y(69) &
                  +.180_r8*rxt(35)*y(71)
         loss(79) = (rxt(182)* y(5) +rxt(183)* y(7) +rxt(184)* y(13) +rxt(185)* y(17) &
                  +rxt(186)* y(31))* y(61)
         prod(79) = (.500_r8*rxt(144)*y(52) +rxt(181)*y(58) +rxt(187)*y(62))*y(12)
         loss(27) = ((rxt(187) +rxt(188))* y(12) + rxt(29) + het_rates(17))* y(62)
         prod(27) =rxt(184)*y(61)*y(13)
         loss(61) = (rxt(167)* y(1) +rxt(168)* y(7) +rxt(166)* y(12))* y(63)
         prod(61) = 0._r8
         loss(74) = (rxt(169)* y(5) +rxt(170)* y(13))* y(64)
         prod(74) = (rxt(166)*y(63) +rxt(171)*y(65))*y(12) +rxt(168)*y(63)*y(7)
         loss(50) = (rxt(171)* y(12) + rxt(40) + het_rates(30))* y(65)
         prod(50) =rxt(170)*y(64)*y(13)
         loss(23) = (rxt(132)* y(12))* y(66)
         prod(23) = 0._r8
         loss(24) = (rxt(133)* y(12))* y(67)
         prod(24) =.250_r8*rxt(132)*y(66)*y(12)
         loss(51) = (rxt(135)* y(5) +rxt(136)* y(13))* y(68)
         prod(51) = (.700_r8*rxt(132)*y(66) +rxt(137)*y(69))*y(12)
         loss(44) = (rxt(137)* y(12) + rxt(39) + het_rates(29))* y(69)
         prod(44) =rxt(136)*y(68)*y(13)
         loss(28) = (rxt(134)* y(6))* y(70)
         prod(28) =rxt(133)*y(67)*y(12)
         loss(52) = ( + rxt(35))* y(71)
         prod(52) =.900_r8*rxt(135)*y(68)*y(5) +.700_r8*rxt(134)*y(70)*y(6) &
                  +.900_r8*rxt(39)*y(69)
         loss(38) = (rxt(138)* y(12) + rxt(36))* y(72)
         prod(38) =.450_r8*rxt(135)*y(68)*y(5) +.200_r8*rxt(194)*y(26)*y(12) &
                  +.450_r8*rxt(39)*y(69) +.130_r8*rxt(35)*y(71)
         loss(53) = (rxt(192)* y(12) + rxt(19) + rxt(109))* y(73)
         prod(53) =rxt(105)*y(31)*y(6)
         loss(46) = (rxt(127)* y(12) + het_rates(8))* y(74)
         prod(46) =.100_r8*rxt(124)*y(48)*y(5) +rxt(98)*y(33)*y(7)
         loss(58) = (rxt(191)* y(12) + rxt(20) + rxt(165))* y(75)
         prod(58) =rxt(164)*y(57)*y(6)
         loss(66) = (rxt(174)* y(5) +rxt(175)* y(7) +rxt(176)* y(13) + het_rates(26)) &
                 * y(76)
         prod(66) =rxt(173)*y(50)*y(7)
         loss(71) = (rxt(180)* y(7) +rxt(179)* y(12) + rxt(30) + het_rates(18))* y(77)
         prod(71) = (.080_r8*rxt(141)*y(51) +.800_r8*rxt(152)*y(55) + &
                 .794_r8*rxt(174)*y(76))*y(5) + (.794_r8*rxt(175)*y(7) + &
                 .794_r8*rxt(176)*y(13))*y(76)
         loss(1) = ( + rxt(196))* y(78)
         prod(1) = 0._r8
         loss(2) = 0._r8
         prod(2) =rxt(196)*y(78)
         loss(22) = (rxt(197)* y(12) + het_rates(32))* y(83)
         prod(22) = (rxt(198)*y(12) +.500_r8*rxt(199)*y(12) +rxt(200)*y(7))*y(85)
         loss(3) = 0._r8
         prod(3) =rxt(197)*y(83)*y(12)
         loss(31) = (rxt(200)* y(7) + (rxt(198) +rxt(199))* y(12))* y(85)
         prod(31) = 0._r8
         loss(17) = (rxt(201)* y(12) + het_rates(33))* y(86)
         prod(17) = 0._r8
         loss(4) = 0._r8
         prod(4) = 0._r8
         loss(5) = 0._r8
         prod(5) = 0._r8
         loss(6) = ( + rxt(202))* y(80)
         prod(6) = 0._r8
         loss(7) = 0._r8
         prod(7) =rxt(202)*y(80)
         loss(8) = 0._r8
         prod(8) = 0._r8
         loss(9) = 0._r8
         prod(9) = 0._r8
         loss(10) = 0._r8
         prod(10) = 0._r8
         loss(11) = 0._r8
         prod(11) = 0._r8
         loss(12) = 0._r8
         prod(12) = 0._r8
         loss(13) = 0._r8
         prod(13) = 0._r8
         loss(14) = 0._r8
         prod(14) = 0._r8
         loss(15) = 0._r8
         prod(15) = 0._r8
         loss(16) = 0._r8
         prod(16) = 0._r8

      end subroutine imp_prod_loss

      end module mo_prod_loss
