 program test_shr_infnan
!
! Simple unit-test program for the shr_infnan_mod module.
!
! Erik Kluzek
!
! $Id: test_shr_sys.F90 7482 2007-11-07 20:54:58Z erik $
!
 use shr_kind_mod, only: r8 => shr_kind_r8
 use shr_kind_mod, only: r4 => shr_kind_r4
 use shr_infnan_mod
 use test_mod
  
 implicit none
 real(r8), parameter :: inf = O'0777600000000000000000'
 real(r8), parameter :: nan = O'0777700000000000000000'
 real(r8), parameter :: nans = O'0777610000000000000000'

 call test_init( 17 )

 print *, "Unit-tester for shr_infnan_mod"

 call test_is(       shr_infnan_isnan( nan ),    "Test that value set to nan is nan" )
 call test_is(       shr_infnan_isnan( nans ),   "Test that value set to nans is nan" )
 call test_is( .not. shr_infnan_isnan( 1.0_r8 ), "Test that value set to one is NOT nan" )
 call test_is( .not. shr_infnan_isnan( 1.0_r4 ), "Test that value set to SP one is NOT nan" )
 call test_is(       shr_infnan_isnan( log(-1. ) ),  "Test that log-1 is nan" )
 call test_is(       shr_infnan_isnan( sqrt(-1. ) ), "Test that sqrt-1 is nan" )
 call test_is(       shr_infnan_isnan( log(0.) ),    "Test that log0 is nan" )
 call test_is( .not. shr_infnan_isnan( 1.0/0. ),     "Test that 1/0 is NOT nan" )
 call test_is( .not. shr_infnan_isnan( -1.0/0. ),    "Test that -1/0 is NOT nan" )
 call test_is(       shr_infnan_isposinf( inf ),   "Test that value set to inf is inf" )
 call test_is( .not. shr_infnan_isposinf( 1.0_r8 ), "Test that value set to one is NOT inf" )
 call test_is( .not. shr_infnan_isposinf( 1.0_r4 ), "Test that value set to SP one is NOT inf" )
 call test_is(       shr_infnan_isneginf( -inf ),   "Test that value set to -inf is -inf" )
 call test_is( .not. shr_infnan_isneginf( 1.0_r8 ), "Test that value set to one is NOT -inf" )
 call test_is( .not. shr_infnan_isneginf( 1.0_r4 ), "Test that value set to SP one is NOT -inf" )
 call test_is(       shr_infnan_isposinf( 1.0/0 ),      "Test that 1/0 is inf" )
 call test_is(       shr_infnan_isneginf( -1.0/0 ),     "Test that -1/0 is -inf" )

 call test_final()

 end program test_shr_infnan
