#include "dtypes.h"
!===================================================
! DO NOT EDIT THIS FILE, it was generated using /global/homes/j/jedwards/pio_trunk/pio/genf90.pl 
! Any changes you make to this file may be lost
!===================================================
#define __PIO_FILE__ "pionfget_mod.F90"
module pionfget_mod
#ifdef TIMING
  use perf_mod, only : t_startf, t_stopf      ! _EXTERNAL
#endif
  use pio_msg_mod
  use pio_kinds, only: i4,r4,r8,pio_offset
  use pio_types, only : file_desc_t, iosystem_desc_t, var_desc_t, &
     pio_iotype_pbinary, pio_iotype_binary, pio_iotype_direct_pbinary, &
     pio_iotype_netcdf, pio_iotype_pnetcdf, pio_iotype_netcdf4p, pio_iotype_netcdf4c, &
     pio_noerr
  use pio_utils, only : check_netcdf
  use pio_support, only : Debug, DebugIO, piodie, CheckMPIReturn
#ifdef _NETCDF
  use netcdf            ! _EXTERNAL
#endif
  implicit none
  private
#ifdef _PNETCDF
#include <pnetcdf.inc>  /*  _EXTERNAL */
#endif
  include 'mpif.h'  ! _EXTERNAL

!>
!! @defgroup PIO_get_var PIO_get_var
!! @brief Reads netcdf metadata from a file
!! @details The get_var interface is provided as a simplified interface to
!!  read variables from a netcdf format file.   The variable is read on the 
!!  root IO task and broadcast in its entirety to all tasks.  
!<
  public :: get_var
  interface get_var
     module procedure get_var_0d_text, get_var_vdesc_0d_text
     module procedure get_var_1d_text, get_var_vdesc_1d_text
     module procedure get_var_2d_text, get_var_vdesc_2d_text
     module procedure get_var_3d_text, get_var_vdesc_3d_text
     module procedure get_var_4d_text, get_var_vdesc_4d_text
     module procedure get_var_5d_text, get_var_vdesc_5d_text
     module procedure get_var_0d_real, get_var_vdesc_0d_real
     module procedure get_var_1d_real, get_var_vdesc_1d_real
     module procedure get_var_2d_real, get_var_vdesc_2d_real
     module procedure get_var_3d_real, get_var_vdesc_3d_real
     module procedure get_var_4d_real, get_var_vdesc_4d_real
     module procedure get_var_5d_real, get_var_vdesc_5d_real
     module procedure get_var_0d_double, get_var_vdesc_0d_double
     module procedure get_var_1d_double, get_var_vdesc_1d_double
     module procedure get_var_2d_double, get_var_vdesc_2d_double
     module procedure get_var_3d_double, get_var_vdesc_3d_double
     module procedure get_var_4d_double, get_var_vdesc_4d_double
     module procedure get_var_5d_double, get_var_vdesc_5d_double
     module procedure get_var_0d_int, get_var_vdesc_0d_int
     module procedure get_var_1d_int, get_var_vdesc_1d_int
     module procedure get_var_2d_int, get_var_vdesc_2d_int
     module procedure get_var_3d_int, get_var_vdesc_3d_int
     module procedure get_var_4d_int, get_var_vdesc_4d_int
     module procedure get_var_5d_int, get_var_vdesc_5d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_1d_text, get_vara_vdesc_1d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_2d_text, get_vara_vdesc_2d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_3d_text, get_vara_vdesc_3d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_4d_text, get_vara_vdesc_4d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_5d_text, get_vara_vdesc_5d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_1d_real, get_vara_vdesc_1d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_2d_real, get_vara_vdesc_2d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_3d_real, get_vara_vdesc_3d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_4d_real, get_vara_vdesc_4d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_5d_real, get_vara_vdesc_5d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_1d_double, get_vara_vdesc_1d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_2d_double, get_vara_vdesc_2d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_3d_double, get_vara_vdesc_3d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_4d_double, get_vara_vdesc_4d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_5d_double, get_vara_vdesc_5d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_1d_int, get_vara_vdesc_1d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_2d_int, get_vara_vdesc_2d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_3d_int, get_vara_vdesc_3d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_4d_int, get_vara_vdesc_4d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_5d_int, get_vara_vdesc_5d_int
     module procedure get_var1_text, get_var1_vdesc_text
     module procedure get_var1_real, get_var1_vdesc_real
     module procedure get_var1_double, get_var1_vdesc_double
     module procedure get_var1_int, get_var1_vdesc_int
  end interface

 character(len=*), parameter :: modName='pionfget_mod'

CONTAINS

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var1_text (File,varid, index, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar1
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, index(:)
    character(len=*), intent(out) :: ival
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var1_text'
    integer :: iotype, mpierr, ilen, msg
#ifdef TIMING
    call t_startf("pio_get_var1_text")
#endif
    ierr=0
    iotype = File%iotype 
    ios => File%iosystem
    if(Debug) print *,__PIO_FILE__,__LINE__,index

#if (100 == TYPETEXT)
    ilen = len(ival)
    ival(1:ilen) = ' '
#else
    ilen=1
#endif     
    
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR1
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(size(index),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(index,size(index),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       if(100 == TYPETEXT) then
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       end if
    endif


    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_begin_indep_data(File%fh)
          ! Only io proc 0 will do reading
          if(ierr==PIO_NOERR .and. File%iosystem%io_rank==0) then
             ierr = nfmpi_get_var1_text (File%fh, varid, int(index,kind=PIO_OFFSET), ival)
             if(ierr/=PIO_NOERR) print *, __PIO_FILE__,__LINE__,index, ival
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#endif

#ifdef _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=index)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=index)
             if(ierr/=PIO_NOERR) print *,__PIO_FILE__,__LINE__,index, ival
          end if
#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#if (100 == TYPETEXT)
    ilen = len(ival)
#else
    ilen=1
#endif     

    call MPI_Bcast(ival, ilen, MPI_CHARACTER , File%iosystem%IOMaster, File%iosystem%MY_comm, mpierr)
    call CheckMPIReturn(subName, mpierr)

#ifdef TIMING
    call t_stopf("pio_get_var1_text")
#endif
  end function get_var1_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var1_real (File,varid, index, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar1
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, index(:)
    real(r4), intent(out) :: ival
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var1_real'
    integer :: iotype, mpierr, ilen, msg
#ifdef TIMING
    call t_startf("pio_get_var1_real")
#endif
    ierr=0
    iotype = File%iotype 
    ios => File%iosystem
    if(Debug) print *,__PIO_FILE__,__LINE__,index

#if (101 == TYPETEXT)
    ilen = len(ival)
    ival(1:ilen) = ' '
#else
    ilen=1
#endif     
    
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR1
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(size(index),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(index,size(index),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       if(101 == TYPETEXT) then
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       end if
    endif


    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_begin_indep_data(File%fh)
          ! Only io proc 0 will do reading
          if(ierr==PIO_NOERR .and. File%iosystem%io_rank==0) then
             ierr = nfmpi_get_var1_real (File%fh, varid, int(index,kind=PIO_OFFSET), ival)
             if(ierr/=PIO_NOERR) print *, __PIO_FILE__,__LINE__,index, ival
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#endif

#ifdef _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=index)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=index)
             if(ierr/=PIO_NOERR) print *,__PIO_FILE__,__LINE__,index, ival
          end if
#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#if (101 == TYPETEXT)
    ilen = len(ival)
#else
    ilen=1
#endif     

    call MPI_Bcast(ival, ilen, MPI_REAL4 , File%iosystem%IOMaster, File%iosystem%MY_comm, mpierr)
    call CheckMPIReturn(subName, mpierr)

#ifdef TIMING
    call t_stopf("pio_get_var1_real")
#endif
  end function get_var1_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var1_double (File,varid, index, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar1
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, index(:)
    real(r8), intent(out) :: ival
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var1_double'
    integer :: iotype, mpierr, ilen, msg
#ifdef TIMING
    call t_startf("pio_get_var1_double")
#endif
    ierr=0
    iotype = File%iotype 
    ios => File%iosystem
    if(Debug) print *,__PIO_FILE__,__LINE__,index

#if (102 == TYPETEXT)
    ilen = len(ival)
    ival(1:ilen) = ' '
#else
    ilen=1
#endif     
    
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR1
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(size(index),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(index,size(index),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       if(102 == TYPETEXT) then
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       end if
    endif


    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_begin_indep_data(File%fh)
          ! Only io proc 0 will do reading
          if(ierr==PIO_NOERR .and. File%iosystem%io_rank==0) then
             ierr = nfmpi_get_var1_double (File%fh, varid, int(index,kind=PIO_OFFSET), ival)
             if(ierr/=PIO_NOERR) print *, __PIO_FILE__,__LINE__,index, ival
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#endif

#ifdef _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=index)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=index)
             if(ierr/=PIO_NOERR) print *,__PIO_FILE__,__LINE__,index, ival
          end if
#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#if (102 == TYPETEXT)
    ilen = len(ival)
#else
    ilen=1
#endif     

    call MPI_Bcast(ival, ilen, MPI_REAL8 , File%iosystem%IOMaster, File%iosystem%MY_comm, mpierr)
    call CheckMPIReturn(subName, mpierr)

#ifdef TIMING
    call t_stopf("pio_get_var1_double")
#endif
  end function get_var1_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var1_int (File,varid, index, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar1
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, index(:)
    integer(i4), intent(out) :: ival
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var1_int'
    integer :: iotype, mpierr, ilen, msg
#ifdef TIMING
    call t_startf("pio_get_var1_int")
#endif
    ierr=0
    iotype = File%iotype 
    ios => File%iosystem
    if(Debug) print *,__PIO_FILE__,__LINE__,index

#if (103 == TYPETEXT)
    ilen = len(ival)
    ival(1:ilen) = ' '
#else
    ilen=1
#endif     
    
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR1
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(size(index),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(index,size(index),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       if(103 == TYPETEXT) then
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       end if
    endif


    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_begin_indep_data(File%fh)
          ! Only io proc 0 will do reading
          if(ierr==PIO_NOERR .and. File%iosystem%io_rank==0) then
             ierr = nfmpi_get_var1_int (File%fh, varid, int(index,kind=PIO_OFFSET), ival)
             if(ierr/=PIO_NOERR) print *, __PIO_FILE__,__LINE__,index, ival
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#endif

#ifdef _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=index)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=index)
             if(ierr/=PIO_NOERR) print *,__PIO_FILE__,__LINE__,index, ival
          end if
#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#if (103 == TYPETEXT)
    ilen = len(ival)
#else
    ilen=1
#endif     

    call MPI_Bcast(ival, ilen, MPI_INTEGER , File%iosystem%IOMaster, File%iosystem%MY_comm, mpierr)
    call CheckMPIReturn(subName, mpierr)

#ifdef TIMING
    call t_stopf("pio_get_var1_int")
#endif
  end function get_var1_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var1_vdesc_text (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: index(:)
    character(len=*), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var1_vdesc_text'

    ierr = get_var1_text (File, vardesc%varid, index, ival)

  end function get_var1_vdesc_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var1_vdesc_real (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: index(:)
    real(r4), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var1_vdesc_real'

    ierr = get_var1_real (File, vardesc%varid, index, ival)

  end function get_var1_vdesc_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var1_vdesc_double (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: index(:)
    real(r8), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var1_vdesc_double'

    ierr = get_var1_double (File, vardesc%varid, index, ival)

  end function get_var1_vdesc_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var1_vdesc_int (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: index(:)
    integer(i4), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var1_vdesc_int'

    ierr = get_var1_int (File, vardesc%varid, index, ival)

  end function get_var1_vdesc_int


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_1d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_1d_text'

    integer :: dims(1)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_1d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_1d_text")
#endif
  end function get_vara_1d_text


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_2d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_2d_text'

    integer :: dims(2)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_2d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_2d_text")
#endif
  end function get_vara_2d_text


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_3d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_3d_text'

    integer :: dims(3)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_3d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_3d_text")
#endif
  end function get_vara_3d_text


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_4d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_4d_text'

    integer :: dims(4)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_4d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_4d_text")
#endif
  end function get_vara_4d_text


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_5d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_5d_text'

    integer :: dims(5)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_5d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_5d_text")
#endif
  end function get_vara_5d_text


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_1d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_1d_real'

    integer :: dims(1)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_1d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_1d_real")
#endif
  end function get_vara_1d_real


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_2d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_2d_real'

    integer :: dims(2)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_2d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_2d_real")
#endif
  end function get_vara_2d_real


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_3d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_3d_real'

    integer :: dims(3)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_3d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_3d_real")
#endif
  end function get_vara_3d_real


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_4d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_4d_real'

    integer :: dims(4)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_4d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_4d_real")
#endif
  end function get_vara_4d_real


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_5d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_5d_real'

    integer :: dims(5)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_5d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_5d_real")
#endif
  end function get_vara_5d_real


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_1d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_1d_double'

    integer :: dims(1)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_1d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_1d_double")
#endif
  end function get_vara_1d_double


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_2d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_2d_double'

    integer :: dims(2)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_2d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_2d_double")
#endif
  end function get_vara_2d_double


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_3d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_3d_double'

    integer :: dims(3)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_3d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_3d_double")
#endif
  end function get_vara_3d_double


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_4d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_4d_double'

    integer :: dims(4)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_4d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_4d_double")
#endif
  end function get_vara_4d_double


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_5d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_5d_double'

    integer :: dims(5)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_5d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_5d_double")
#endif
  end function get_vara_5d_double


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_1d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_1d_int'

    integer :: dims(1)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_1d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_1d_int")
#endif
  end function get_vara_1d_int


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_2d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_2d_int'

    integer :: dims(2)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_2d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_2d_int")
#endif
  end function get_vara_2d_int


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_3d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_3d_int'

    integer :: dims(3)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_3d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_3d_int")
#endif
  end function get_vara_3d_int


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_4d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_4d_int'

    integer :: dims(4)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_4d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_4d_int")
#endif
  end function get_vara_4d_int


! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_5d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:,:,:)
         
    character(len=*), parameter :: subName=modName//'::get_vara_5d_int'

    integer :: dims(5)
    integer :: iotype, mpierr, i, msg, ilen
    integer(kind=PIO_OFFSET) :: isize
    type(iosystem_desc_t), pointer :: ios
#ifdef TIMING
    call t_startf("pio_get_vara_5d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1
    do i=1,size(count)
       isize=isize*count(i)
    end do



    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVARA_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

       call MPI_BCAST(size(start),1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,size(start),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif






    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_vara_all (File%fh, varid, int(start,kind=PIO_OFFSET), &
               int(count,kind=PIO_OFFSET), ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
          ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival, start=start, count=count)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn(subName,mpierr)
          end if
       

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if



#ifdef TIMING
    call t_stopf("pio_get_vara_5d_int")
#endif
  end function get_vara_5d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_1d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_1d_text'

    ierr = get_vara_1d_text (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_1d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_2d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_2d_text'

    ierr = get_vara_2d_text (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_2d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_3d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_3d_text'

    ierr = get_vara_3d_text (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_3d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_4d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_4d_text'

    ierr = get_vara_4d_text (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_4d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_5d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_5d_text'

    ierr = get_vara_5d_text (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_5d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_1d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_1d_real'

    ierr = get_vara_1d_real (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_1d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_2d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_2d_real'

    ierr = get_vara_2d_real (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_2d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_3d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_3d_real'

    ierr = get_vara_3d_real (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_3d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_4d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_4d_real'

    ierr = get_vara_4d_real (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_4d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_5d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_5d_real'

    ierr = get_vara_5d_real (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_5d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_1d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_1d_double'

    ierr = get_vara_1d_double (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_1d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_2d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_2d_double'

    ierr = get_vara_2d_double (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_2d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_3d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_3d_double'

    ierr = get_vara_3d_double (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_3d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_4d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_4d_double'

    ierr = get_vara_4d_double (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_4d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_5d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_5d_double'

    ierr = get_vara_5d_double (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_5d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_1d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_1d_int'

    ierr = get_vara_1d_int (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_1d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_2d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_2d_int'

    ierr = get_vara_2d_int (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_2d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_3d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_3d_int'

    ierr = get_vara_3d_int (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_3d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_4d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_4d_int'

    ierr = get_vara_4d_int (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_4d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_vara_vdesc_5d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_5d_int'

    ierr = get_vara_5d_int (File, vardesc%varid, start, count, ival)

  end function get_vara_vdesc_5d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_0d_text (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_0d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_0d_text'
    integer :: iotype, mpierr, msg, ilen
#if (0 > 0)
    integer :: dims(0)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_0d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (0 > 0)
    isize= size(ival)
#endif
#if (100 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_0d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (0 > 0)
       do i=1,0
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,0,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_0d_text")
#endif
  end function get_var_0d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_1d_text (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_1d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_1d_text'
    integer :: iotype, mpierr, msg, ilen
#if (1 > 0)
    integer :: dims(1)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_1d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (1 > 0)
    isize= size(ival)
#endif
#if (100 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_1d_text")
#endif
  end function get_var_1d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_2d_text (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_2d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_2d_text'
    integer :: iotype, mpierr, msg, ilen
#if (2 > 0)
    integer :: dims(2)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_2d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (2 > 0)
    isize= size(ival)
#endif
#if (100 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_2d_text")
#endif
  end function get_var_2d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_3d_text (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_3d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_3d_text'
    integer :: iotype, mpierr, msg, ilen
#if (3 > 0)
    integer :: dims(3)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_3d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (3 > 0)
    isize= size(ival)
#endif
#if (100 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_3d_text")
#endif
  end function get_var_3d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_4d_text (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_4d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:,:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_4d_text'
    integer :: iotype, mpierr, msg, ilen
#if (4 > 0)
    integer :: dims(4)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_4d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (4 > 0)
    isize= size(ival)
#endif
#if (100 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_4d_text")
#endif
  end function get_var_4d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_5d_text (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_5d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:,:,:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_5d_text'
    integer :: iotype, mpierr, msg, ilen
#if (5 > 0)
    integer :: dims(5)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_5d_text")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (5 > 0)
    isize= size(ival)
#endif
#if (100 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(100,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(100 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_CHARACTER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_CHARACTER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_CHARACTER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_5d_text")
#endif
  end function get_var_5d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_0d_real (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_0d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_0d_real'
    integer :: iotype, mpierr, msg, ilen
#if (0 > 0)
    integer :: dims(0)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_0d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (0 > 0)
    isize= size(ival)
#endif
#if (101 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_0d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (0 > 0)
       do i=1,0
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,0,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_0d_real")
#endif
  end function get_var_0d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_1d_real (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_1d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_1d_real'
    integer :: iotype, mpierr, msg, ilen
#if (1 > 0)
    integer :: dims(1)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_1d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (1 > 0)
    isize= size(ival)
#endif
#if (101 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_1d_real")
#endif
  end function get_var_1d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_2d_real (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_2d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_2d_real'
    integer :: iotype, mpierr, msg, ilen
#if (2 > 0)
    integer :: dims(2)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_2d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (2 > 0)
    isize= size(ival)
#endif
#if (101 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_2d_real")
#endif
  end function get_var_2d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_3d_real (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_3d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_3d_real'
    integer :: iotype, mpierr, msg, ilen
#if (3 > 0)
    integer :: dims(3)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_3d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (3 > 0)
    isize= size(ival)
#endif
#if (101 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_3d_real")
#endif
  end function get_var_3d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_4d_real (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_4d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:,:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_4d_real'
    integer :: iotype, mpierr, msg, ilen
#if (4 > 0)
    integer :: dims(4)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_4d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (4 > 0)
    isize= size(ival)
#endif
#if (101 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_4d_real")
#endif
  end function get_var_4d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_5d_real (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_5d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:,:,:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_5d_real'
    integer :: iotype, mpierr, msg, ilen
#if (5 > 0)
    integer :: dims(5)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_5d_real")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (5 > 0)
    isize= size(ival)
#endif
#if (101 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(101,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(101 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL4)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL4 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL4 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_5d_real")
#endif
  end function get_var_5d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_0d_double (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_0d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_0d_double'
    integer :: iotype, mpierr, msg, ilen
#if (0 > 0)
    integer :: dims(0)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_0d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (0 > 0)
    isize= size(ival)
#endif
#if (102 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_0d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (0 > 0)
       do i=1,0
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,0,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_0d_double")
#endif
  end function get_var_0d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_1d_double (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_1d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_1d_double'
    integer :: iotype, mpierr, msg, ilen
#if (1 > 0)
    integer :: dims(1)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_1d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (1 > 0)
    isize= size(ival)
#endif
#if (102 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_1d_double")
#endif
  end function get_var_1d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_2d_double (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_2d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_2d_double'
    integer :: iotype, mpierr, msg, ilen
#if (2 > 0)
    integer :: dims(2)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_2d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (2 > 0)
    isize= size(ival)
#endif
#if (102 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_2d_double")
#endif
  end function get_var_2d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_3d_double (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_3d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_3d_double'
    integer :: iotype, mpierr, msg, ilen
#if (3 > 0)
    integer :: dims(3)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_3d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (3 > 0)
    isize= size(ival)
#endif
#if (102 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_3d_double")
#endif
  end function get_var_3d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_4d_double (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_4d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:,:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_4d_double'
    integer :: iotype, mpierr, msg, ilen
#if (4 > 0)
    integer :: dims(4)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_4d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (4 > 0)
    isize= size(ival)
#endif
#if (102 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_4d_double")
#endif
  end function get_var_4d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_5d_double (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_5d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:,:,:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_5d_double'
    integer :: iotype, mpierr, msg, ilen
#if (5 > 0)
    integer :: dims(5)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_5d_double")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (5 > 0)
    isize= size(ival)
#endif
#if (102 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(102,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(102 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_REAL8)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_REAL8 ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_REAL8 , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_5d_double")
#endif
  end function get_var_5d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_0d_int (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_0d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_0d_int'
    integer :: iotype, mpierr, msg, ilen
#if (0 > 0)
    integer :: dims(0)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_0d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (0 > 0)
    isize= size(ival)
#endif
#if (103 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_0d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (0 > 0)
       do i=1,0
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,0,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_0d_int")
#endif
  end function get_var_0d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_1d_int (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_1d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_1d_int'
    integer :: iotype, mpierr, msg, ilen
#if (1 > 0)
    integer :: dims(1)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_1d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (1 > 0)
    isize= size(ival)
#endif
#if (103 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_1d_int")
#endif
  end function get_var_1d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_2d_int (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_2d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_2d_int'
    integer :: iotype, mpierr, msg, ilen
#if (2 > 0)
    integer :: dims(2)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_2d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (2 > 0)
    isize= size(ival)
#endif
#if (103 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_2d_int")
#endif
  end function get_var_2d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_3d_int (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_3d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_3d_int'
    integer :: iotype, mpierr, msg, ilen
#if (3 > 0)
    integer :: dims(3)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_3d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (3 > 0)
    isize= size(ival)
#endif
#if (103 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_3d_int")
#endif
  end function get_var_3d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_4d_int (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_4d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:,:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_4d_int'
    integer :: iotype, mpierr, msg, ilen
#if (4 > 0)
    integer :: dims(4)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_4d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (4 > 0)
    isize= size(ival)
#endif
#if (103 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_4d_int")
#endif
  end function get_var_4d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_5d_int (File,varid, ival) result(ierr)
    use pio_msg_mod, only : pio_msg_getvar_5d
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:,:,:,:,:)
    type(iosystem_desc_t), pointer :: ios
    character(len=*), parameter :: subName=modName//'::get_var_5d_int'
    integer :: iotype, mpierr, msg, ilen
#if (5 > 0)
    integer :: dims(5)
    integer :: i
#endif
    integer(kind=PIO_OFFSET) :: isize

#ifdef TIMING
    call t_startf("pio_get_var_5d_int")
#endif
    ierr=0
    iotype = File%iotype 
    isize=1     
#if (5 > 0)
    isize= size(ival)
#endif
#if (103 == TYPETEXT)
    ilen = len(ival)     
    isize = isize*ilen
    ival(:,:,:,:,:) = ' '
#endif
    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_GETVAR_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(103,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
#if(103 == TYPETEXT) 
          call MPI_BCAST(ilen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif


    endif



    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          ierr = nfmpi_get_var_all(File%fh, varid, ival, isize, MPI_INTEGER)
#endif
#ifdef  _NETCDF
       case(pio_iotype_netcdf4p, pio_iotype_netcdf4c)
             ierr = nf90_get_var(File%fh, varid, ival)
       case(pio_iotype_netcdf)
          ! Only io proc 0 will do reading
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_get_var(File%fh, varid, ival)
          end if
          if(.not. ios%async_interface .and. ios%num_tasks==ios%num_iotasks) then
             call MPI_BCAST(ival,int(isize), MPI_INTEGER ,0,ios%IO_comm, mpierr)
             call CheckMPIReturn('nf_mod',mpierr)
          end if

#endif
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
    if(ios%async_interface .or. ios%num_tasks>ios%num_iotasks) then
       call MPI_Bcast(ival,int(isize), MPI_INTEGER , ios%IOMaster, ios%My_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
#ifdef TIMING
    call t_stopf("pio_get_var_5d_int")
#endif
  end function get_var_5d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_0d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_0d_text'

    ierr = get_var_0d_text (File, vardesc%varid, ival)

  end function get_var_vdesc_0d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_1d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_1d_text'

    ierr = get_var_1d_text (File, vardesc%varid, ival)

  end function get_var_vdesc_1d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_2d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_2d_text'

    ierr = get_var_2d_text (File, vardesc%varid, ival)

  end function get_var_vdesc_2d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_3d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_3d_text'

    ierr = get_var_3d_text (File, vardesc%varid, ival)

  end function get_var_vdesc_3d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_4d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_4d_text'

    ierr = get_var_4d_text (File, vardesc%varid, ival)

  end function get_var_vdesc_4d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_5d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_5d_text'

    ierr = get_var_5d_text (File, vardesc%varid, ival)

  end function get_var_vdesc_5d_text

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_0d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_0d_real'

    ierr = get_var_0d_real (File, vardesc%varid, ival)

  end function get_var_vdesc_0d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_1d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_1d_real'

    ierr = get_var_1d_real (File, vardesc%varid, ival)

  end function get_var_vdesc_1d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_2d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_2d_real'

    ierr = get_var_2d_real (File, vardesc%varid, ival)

  end function get_var_vdesc_2d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_3d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_3d_real'

    ierr = get_var_3d_real (File, vardesc%varid, ival)

  end function get_var_vdesc_3d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_4d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_4d_real'

    ierr = get_var_4d_real (File, vardesc%varid, ival)

  end function get_var_vdesc_4d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_5d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_5d_real'

    ierr = get_var_5d_real (File, vardesc%varid, ival)

  end function get_var_vdesc_5d_real

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_0d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_0d_double'

    ierr = get_var_0d_double (File, vardesc%varid, ival)

  end function get_var_vdesc_0d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_1d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_1d_double'

    ierr = get_var_1d_double (File, vardesc%varid, ival)

  end function get_var_vdesc_1d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_2d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_2d_double'

    ierr = get_var_2d_double (File, vardesc%varid, ival)

  end function get_var_vdesc_2d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_3d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_3d_double'

    ierr = get_var_3d_double (File, vardesc%varid, ival)

  end function get_var_vdesc_3d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_4d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_4d_double'

    ierr = get_var_4d_double (File, vardesc%varid, ival)

  end function get_var_vdesc_4d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_5d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_5d_double'

    ierr = get_var_5d_double (File, vardesc%varid, ival)

  end function get_var_vdesc_5d_double

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_0d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_0d_int'

    ierr = get_var_0d_int (File, vardesc%varid, ival)

  end function get_var_vdesc_0d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_1d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_1d_int'

    ierr = get_var_1d_int (File, vardesc%varid, ival)

  end function get_var_vdesc_1d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_2d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_2d_int'

    ierr = get_var_2d_int (File, vardesc%varid, ival)

  end function get_var_vdesc_2d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_3d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_3d_int'

    ierr = get_var_3d_int (File, vardesc%varid, ival)

  end function get_var_vdesc_3d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_4d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_4d_int'

    ierr = get_var_4d_int (File, vardesc%varid, ival)

  end function get_var_vdesc_4d_int

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
  integer function get_var_vdesc_5d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_var_vdesc_5d_int'

    ierr = get_var_5d_int (File, vardesc%varid, ival)

  end function get_var_vdesc_5d_int
end module pionfget_mod
