 /*@@
   @file      SetupCache.c
   @date      Tue Nov 30 10:30:09 1999
   @author    Tom Goodale
   @desc
              Sets up cache stuff for the CCTK
   @enddesc
   @version   $Id: SetupCache.c,v 1.1.1.1 2009/02/03 01:02:30 jtao Exp $
 @@*/

#include "cctk_Config.h"
#include "cctk_Flesh.h"
#include "cctk_Parameters.h"

#include "cctki_Cache.h"

static const char *rcsid = "$Header: /CCT/Projects/XiRel/SPEC2006/CactusBSSN/src/main/SetupCache.c,v 1.1.1.1 2009/02/03 01:02:30 jtao Exp $";

CCTK_FILEVERSION(main_SetupCache_c);


 /*@@
   @routine    CCTKi_SetupCache
   @date       Tue Nov 30 10:50:02 1999
   @author     Tom Goodale
   @desc
               Sets the cache information.
   @enddesc
   @calls      Utili_CacheDataSet

   @returntype int
   @returndesc
               0 - success
   @endreturndesc
@@*/
int CCTKi_SetupCache (void)
{
  DECLARE_CCTK_PARAMETERS


  if (manual_cache_setup)
  {
    Utili_CacheDataSet (manual_cacheline_bytes, manual_cache_size);
  }
  else
  {
    Utili_CacheDataSet (CCTK_CACHELINE_BYTES, CCTK_CACHE_SIZE);
  }

  return (0);
}
