      module mo_lin_matrix
      private
      public :: linmat
      contains
      subroutine linmat01( mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, hetcnt, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(in) :: het_rates(max(1,hetcnt))
      real(r8), intent(inout) :: mat(nzcnt)
         mat(758) = -( rxt(2) + rxt(3) )
         mat(520) = .890_r8*rxt(8) + .890_r8*rxt(9)
         mat(209) = rxt(41)
         mat(58) = -( rxt(43) + rxt(44) + rxt(45) + rxt(46)*y(11) + rxt(57)*y(4) &
                      + rxt(58)*y(4) + rxt(76)*y(15) )
         mat(731) = rxt(2)
         mat(205) = -( rxt(41) )
         mat(735) = rxt(3)
         mat(782) = rxt(5)
         mat(59) = rxt(43) + rxt(44)
         mat(791) = rxt(5) + .500_r8*rxt(74)
         mat(518) = .110_r8*rxt(8) + .110_r8*rxt(9)
         mat(63) = 2.000_r8*rxt(57)*y(4)
         mat(795) = -( rxt(5) + rxt(74) )
         mat(68) = rxt(6) + rxt(65)
         mat(204) = rxt(7)
         mat(522) = .890_r8*rxt(8) + .890_r8*rxt(9)
         mat(120) = .660_r8*rxt(10) + .660_r8*rxt(11) + rxt(71)
         mat(193) = .600_r8*rxt(19) + rxt(109)
         mat(226) = rxt(20) + rxt(165)
         mat(351) = rxt(30)
         mat(514) = -( rxt(8) + rxt(9) + rxt(73) )
         mat(67) = rxt(6) + rxt(65)
         mat(117) = .330_r8*rxt(10) + .330_r8*rxt(11)
         mat(189) = .400_r8*rxt(19)
         mat(201) = -( rxt(7) + het_rates(2) )
         mat(66) = 2.000_r8*rxt(72)
         mat(496) = rxt(73)
         mat(781) = .500_r8*rxt(74)
         mat(116) = -( rxt(10) + rxt(11) + rxt(71) + het_rates(7) )
         mat(65) = -( rxt(6) + rxt(65) + rxt(72) )
         mat(611) = -( rxt(47)*y(11) + rxt(75)*y(15) + rxt(84)*y(16) )
         mat(203) = rxt(7)
         mat(118) = .330_r8*rxt(10) + .330_r8*rxt(11)
         mat(128) = rxt(12)
         mat(45) = 2.000_r8*rxt(15)
         mat(199) = rxt(17)
         mat(160) = rxt(18)
         mat(454) = .330_r8*rxt(21) + .330_r8*rxt(22)
         mat(124) = rxt(24)
         mat(114) = rxt(25)
         mat(83) = rxt(26)
         mat(53) = rxt(29)
         mat(254) = rxt(37)
         mat(95) = rxt(38)
         mat(139) = rxt(39)
         mat(170) = rxt(40)
         mat(61) = 2.000_r8*rxt(45) + rxt(46)*y(11) + .750_r8*rxt(76)*y(15)
         mat(789) = .500_r8*rxt(74)
         mat(659) = -( rxt(203) )
         mat(119) = .660_r8*rxt(10) + .660_r8*rxt(11) + rxt(71)
         mat(129) = rxt(12)
         mat(409) = 2.000_r8*rxt(13)
         mat(372) = rxt(16)
         mat(200) = rxt(17)
         mat(455) = .670_r8*rxt(21) + .670_r8*rxt(22)
         mat(125) = rxt(24)
         mat(115) = rxt(25)
         mat(416) = rxt(28)
         mat(350) = rxt(30)
         mat(218) = rxt(31)
         mat(404) = rxt(32)
         mat(235) = 2.000_r8*rxt(33)
         mat(186) = .560_r8*rxt(35)
         mat(110) = 2.000_r8*rxt(36)
         mat(255) = .900_r8*rxt(37)
         mat(171) = rxt(40)
         mat(50) = rxt(88) + rxt(89)
         mat(62) = rxt(46)*y(11) + .400_r8*rxt(76)*y(15)
         mat(612) = rxt(47)*y(11) + rxt(84)*y(16)
         mat(44) = -( rxt(15) + het_rates(1) )
         mat(618) = .500_r8*rxt(203)
         mat(373) = rxt(16)
         mat(161) = rxt(18)
         mat(192) = .400_r8*rxt(19)
         mat(471) = .300_r8*rxt(23)
         mat(268) = rxt(27)
         mat(614) = rxt(75)*y(15)
         mat(64) = .750_r8*rxt(76)*y(15)
         mat(126) = -( rxt(12) + het_rates(4) )
         mat(406) = -( rxt(13) + rxt(14) + het_rates(3) )
         mat(127) = rxt(12)
         mat(198) = rxt(17)
         mat(448) = .670_r8*rxt(21) + .670_r8*rxt(22)
         mat(81) = rxt(26)
         mat(346) = rxt(30)
         mat(212) = .690_r8*rxt(31)
         mat(400) = rxt(32)
         mat(233) = rxt(33)
         mat(252) = .100_r8*rxt(37)
         mat(49) = 2.000_r8*rxt(89)
         mat(60) = .250_r8*rxt(76)*y(15)
         mat(227) = -( het_rates(20) )
         mat(75) = -( het_rates(21) )
         mat(47) = -( rxt(88) + rxt(89) )
         mat(162) = -( het_rates(31) )
         mat(232) = -( rxt(33) + het_rates(22) )
         mat(48) = rxt(88)
         mat(154) = rxt(34)
         mat(121) = -( rxt(24) + het_rates(11) )
         mat(368) = -( rxt(16) + het_rates(25) )
         mat(196) = rxt(17)
         mat(123) = rxt(24)
         mat(251) = .400_r8*rxt(37)
         mat(93) = rxt(38)
         mat(190) = .600_r8*rxt(19) + rxt(109)
         mat(453) = .670_r8*rxt(21) + .670_r8*rxt(22)
         mat(467) = .300_r8*rxt(23)
         mat(82) = rxt(26)
         mat(266) = rxt(27)
         mat(414) = rxt(28)
         mat(402) = rxt(32)
         mat(155) = rxt(34)
         mat(184) = .130_r8*rxt(35)
         mat(94) = rxt(38)
         mat(157) = -( rxt(18) + het_rates(6) )
         mat(459) = .700_r8*rxt(23)
         mat(111) = -( rxt(25) + het_rates(12) )
         mat(194) = -( rxt(17) + het_rates(5) )
         mat(264) = -( rxt(27) )
         mat(112) = .820_r8*rxt(25)
         mat(248) = .250_r8*rxt(37)
         mat(166) = .100_r8*rxt(40)
         mat(79) = -( rxt(26) + het_rates(13) )
         mat(246) = -( rxt(37) + het_rates(27) )
         mat(152) = -( rxt(34) )
         mat(245) = .800_r8*rxt(37)
         mat(91) = -( rxt(38) + het_rates(28) )
         mat(211) = -( rxt(31) + het_rates(19) )
         mat(464) = -( rxt(23) + het_rates(9) )
         mat(216) = .402_r8*rxt(31)
         mat(169) = rxt(40)
         mat(450) = -( rxt(21) + rxt(22) + het_rates(10) )
         mat(215) = .288_r8*rxt(31)
         mat(168) = rxt(40)
         mat(96) = -( het_rates(16) )
         mat(225) = rxt(20) + rxt(165)
         mat(457) = .330_r8*rxt(21) + .330_r8*rxt(22)
         mat(131) = -( het_rates(24) )
         mat(399) = -( rxt(32) + het_rates(23) )
         mat(412) = -( rxt(28) + het_rates(14) )
         mat(183) = .180_r8*rxt(35)
         mat(138) = .450_r8*rxt(39)
         mat(51) = -( rxt(29) + het_rates(17) )
         mat(165) = -( rxt(40) + het_rates(30) )
         mat(135) = -( rxt(39) + het_rates(29) )
         mat(182) = -( rxt(35) )
         mat(137) = .900_r8*rxt(39)
         mat(108) = -( rxt(36) )
         mat(181) = .130_r8*rxt(35)
         mat(134) = .450_r8*rxt(39)
         mat(187) = -( rxt(19) + rxt(109) )
         mat(148) = -( het_rates(8) )
         mat(219) = -( rxt(20) + rxt(165) )
         mat(278) = -( het_rates(26) )
         mat(345) = -( rxt(30) + het_rates(18) )
         mat(1) = -( rxt(196) )
         mat(2) = rxt(196)
         mat(34) = -( het_rates(32) )
         mat(19) = -( het_rates(33) )
         mat(7) = -( rxt(202) )
         mat(8) = rxt(202)
      end subroutine linmat01
      subroutine linmat( mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, hetcnt, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(in) :: het_rates(max(1,hetcnt))
      real(r8), intent(inout) :: mat(nzcnt)
      call linmat01( mat, y, rxt, het_rates )
      end subroutine linmat
      end module mo_lin_matrix
