
module mo_constants

  use shr_kind_mod,  only : r8 => shr_kind_r8
  use shr_const_mod

  implicit none

  save

  real(r8), parameter ::  gravit   = SHR_CONST_G         ! m/s^2
  real(r8), parameter ::  rgrav    = 1._r8/gravit
  real(r8), parameter ::  dayspy   = 365._r8             ! days per year
  real(r8), parameter ::  rearth   = SHR_CONST_REARTH    ! radius earth (m)
  real(r8), parameter ::  avogadro = SHR_CONST_AVOGAD*1.e-3  ! Avogadro numb - molecules/mole
  real(r8), parameter ::  boltz    = SHR_CONST_BOLTZ*1.e7_r8 ! erg/k

  real(r8), parameter ::  pi = SHR_CONST_PI               ! radians
  real(r8), parameter ::  d2r  = pi/180._r8               ! radians to degrees
  real(r8), parameter ::  r2d  = 180._r8/pi               ! degrees to radians 

contains

  subroutine mo_constants_inti

    implicit none

  end subroutine mo_constants_inti

end module mo_constants
