module physconst

   ! Physical constants.  Use CCSM shared values whenever available.

   use shr_kind_mod, only: r8 => shr_kind_r8
   use shr_const_mod, only: shr_const_g,      shr_const_stebol, shr_const_tkfrz,  &
                            shr_const_mwdair, shr_const_rdair,  shr_const_mwwv,   &
                            shr_const_latice, shr_const_latvap, shr_const_cpdair, &
                            shr_const_rhofw,  shr_const_cpwv,   shr_const_rgas,   &
                            shr_const_karman, shr_const_pstd,   shr_const_rhodair,&
                            shr_const_avogad, shr_const_boltz,  shr_const_cpfw,   &
                            shr_const_rwv,    shr_const_zvir,   shr_const_pi,     &
                            shr_const_rearth
   implicit none
   private

   ! Universal constants
   real(r8), public, parameter :: r_universal = shr_const_rgas ! Universal gas constant (J/K/kmol)
   real(r8), public, parameter :: stebol = shr_const_stebol    ! Stefan-Boltzmann's constant (W/m^2/K^4)
   real(r8), public, parameter :: avogad = shr_const_avogad    ! Avogadro's number (molecules/kmole)
   real(r8), public, parameter :: boltz  = shr_const_boltz     ! Boltzman's constant (J/K/molecule)
   real(r8), public, parameter :: pi  = shr_const_pi           ! 3.14...
   real(r8), public, parameter :: c0 = 2.99792458e8_r8         ! Speed of light in a vacuum (m/s)
   real(r8), public, parameter :: planck = 6.6260755e-34_r8    ! Planck's constant (J.s)

   ! Constants for Earth
   real(r8), public, parameter :: gravit = shr_const_g         ! gravitational acceleration (m/s**2)
   real(r8), public, parameter :: rga = 1._r8/gravit           ! reciprocal of gravit
   real(r8), public, parameter :: rearth = shr_const_rearth    ! radius of earth (m)

   ! Constants for air
   real(r8), public, parameter :: rair = shr_const_rdair       ! Gas constant for dry air (J/K/kg)
   real(r8), public, parameter :: cpair = shr_const_cpdair     ! specific heat of dry air (J/K/kg)
   real(r8), public, parameter :: cappa = rair/cpair           ! R/Cp
   real(r8), public, parameter :: pstd = shr_const_pstd        ! Standard pressure (Pascals)
   real(r8), public, parameter :: rhodair = shr_const_rhodair  ! density of dry air at STP (kg/m3)

   ! Constants for water
   real(r8), public, parameter :: rh2o = shr_const_rwv         ! gas constant for water vapor (J/K/kg)
   real(r8), public, parameter :: cpwv = shr_const_cpwv        ! specific heat of water vapor (J/K/kg)
   real(r8), public, parameter :: epsilo = shr_const_mwwv/shr_const_mwdair ! ratio of h2o to dry air molecular weights 
   real(r8), public, parameter :: latvap = shr_const_latvap    ! Latent heat of vaporization (J/kg)
   real(r8), public, parameter :: latice = shr_const_latice    ! Latent heat of fusion (J/kg)
   real(r8), public, parameter :: rhoh2o = shr_const_rhofw     ! Density of liquid water (STP)
   real(r8), public, parameter :: tmelt = shr_const_tkfrz      ! Freezing point of water (K)
   real(r8), public, parameter :: cpliq = shr_const_cpfw       ! specific heat of fresh h2o (J/K/kg)

   ! Constants for moist air
   real(r8), public, parameter :: zvir = shr_const_zvir        ! rh2o/rair - 1
   real(r8), public, parameter :: cpvir = cpwv/cpair - 1._r8   ! cpwv/cpair - 1

   ! Molecular weights
   real(r8), public, parameter :: mwdry  =  shr_const_mwdair   ! molecular weight dry air
   real(r8), public, parameter :: mwco2  =  44._r8             ! molecular weight co2
   real(r8), public, parameter :: mwh2o  =  shr_const_mwwv     ! molecular weight h2o
   real(r8), public, parameter :: mwn2o  =  44._r8             ! molecular weight n2o
   real(r8), public, parameter :: mwch4  =  16._r8             ! molecular weight ch4
   real(r8), public, parameter :: mwf11  = 136._r8             ! molecular weight cfc11
   real(r8), public, parameter :: mwf12  = 120._r8             ! molecular weight cfc12
   real(r8), public, parameter :: mwo3   =  48._r8             ! molecular weight O3
   real(r8), public, parameter :: mwso2  =  64._r8
   real(r8), public, parameter :: mwso4  =  96._r8
   real(r8), public, parameter :: mwh2o2 =  34._r8
   real(r8), public, parameter :: mwdms  =  62._r8

   ! Turbulence
   real(r8), public, parameter :: karman = shr_const_karman    ! Von Karman constant

end module physconst
