#define TYPEDOUBLE 102
#define TYPEINT 103
#define TYPETEXT 100
#define TYPELONG 104
#define TYPEREAL 101
!===================================================
! DO NOT EDIT THIS FILE, it was generated using genf90.pl 
! Any changes you make to this file may be lost
!===================================================
#define _FILE_ "pionfput_mod.F90"
module pionfput_mod
#ifdef TIMING
  use perf_mod, only : t_startf, t_stopf      ! _EXTERNAL
#endif
  use pio_kinds, only: i4,r4,r8,pio_offset
  use pio_types
  use pio_utils, only : check_netcdf

  use pio_support, only : Debug, DebugIO, piodie   
#ifdef _NETCDF
  use netcdf            ! _EXTERNAL
#endif
  implicit none
  private
#ifdef _PNETCDF
#include <pnetcdf.inc>  /* _EXTERNAL */
#endif
#ifdef _NETCDF
! Required for netcdf bug workaround
  integer, external :: nf_put_vars_text
#endif
  include 'mpif.h'   ! _EXTERNAL

!>
!! @defgroup PIO_put_var PIO_put_var
!! @brief Writes netcdf metadata to a file
!! @details The put_var interface is provided as a simplified interface to
!!  write variables to a netcdf format file.   
!! @warning Although this is a collective call the variable is written from the 
!!  root IO task, no consistancy check is made with data passed on other tasks.
!! 
!<
  public :: put_var
# 38 "pionfput_mod.F90.in"
  interface put_var
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_text, put_var_vdesc_0d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_text, put_var_vdesc_1d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_text, put_var_vdesc_2d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_text, put_var_vdesc_3d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_text, put_var_vdesc_4d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_text, put_var_vdesc_5d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_real, put_var_vdesc_0d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_real, put_var_vdesc_1d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_real, put_var_vdesc_2d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_real, put_var_vdesc_3d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_real, put_var_vdesc_4d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_real, put_var_vdesc_5d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_double, put_var_vdesc_0d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_double, put_var_vdesc_1d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_double, put_var_vdesc_2d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_double, put_var_vdesc_3d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_double, put_var_vdesc_4d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_double, put_var_vdesc_5d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_int, put_var_vdesc_0d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_int, put_var_vdesc_1d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_int, put_var_vdesc_2d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_int, put_var_vdesc_3d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_int, put_var_vdesc_4d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_int, put_var_vdesc_5d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_text, put_vara_vdesc_1d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_text, put_vara_vdesc_2d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_text, put_vara_vdesc_3d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_text, put_vara_vdesc_4d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_text, put_vara_vdesc_5d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_real, put_vara_vdesc_1d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_real, put_vara_vdesc_2d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_real, put_vara_vdesc_3d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_real, put_vara_vdesc_4d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_real, put_vara_vdesc_5d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_double, put_vara_vdesc_1d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_double, put_vara_vdesc_2d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_double, put_vara_vdesc_3d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_double, put_vara_vdesc_4d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_double, put_vara_vdesc_5d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_int, put_vara_vdesc_1d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_int, put_vara_vdesc_2d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_int, put_vara_vdesc_3d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_int, put_vara_vdesc_4d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_int, put_vara_vdesc_5d_int
     module procedure put_var1_text, put_var1_vdesc_text
     module procedure put_var1_real, put_var1_vdesc_real
     module procedure put_var1_double, put_var1_vdesc_double
     module procedure put_var1_int, put_var1_vdesc_int
  end interface
# 45 "pionfput_mod.F90.in"
contains

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 58 "pionfput_mod.F90.in"
  integer function put_var1_text (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    character(len=*), intent(in) :: ival
#ifdef _PNETCDF
    integer(kind=PIO_OFFSET), allocatable :: count(:)
#endif
    integer :: iotype

#ifdef TIMING
    call t_startf("pio_put_var1_text")
#endif 
    ierr=0
    iotype = File%iotype 
    if(debug) print *,_FILE_,__LINE__,ival,iotype, index
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          allocate(count(size(index)))
          count(:) = 1
#if (100 == TYPETEXT)
          count(1) = len(ival)
#endif	
          ierr = nfmpi_put_vara_all (File%fh, varid, int(index,kind=PIO_OFFSET), count, &
               ival, count, MPI_CHARACTER)
          deallocate(count)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=index)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File,ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_var1_text")
#endif 
  end function put_var1_text

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 58 "pionfput_mod.F90.in"
  integer function put_var1_real (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    real(r4), intent(in) :: ival
#ifdef _PNETCDF
    integer(kind=PIO_OFFSET), allocatable :: count(:)
#endif
    integer :: iotype

#ifdef TIMING
    call t_startf("pio_put_var1_real")
#endif 
    ierr=0
    iotype = File%iotype 
    if(debug) print *,_FILE_,__LINE__,ival,iotype, index
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          allocate(count(size(index)))
          count(:) = 1
#if (101 == TYPETEXT)
          count(1) = len(ival)
#endif	
          ierr = nfmpi_put_vara_all (File%fh, varid, int(index,kind=PIO_OFFSET), count, &
               ival, count, MPI_REAL4)
          deallocate(count)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=index)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File,ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_var1_real")
#endif 
  end function put_var1_real

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 58 "pionfput_mod.F90.in"
  integer function put_var1_double (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    real(r8), intent(in) :: ival
#ifdef _PNETCDF
    integer(kind=PIO_OFFSET), allocatable :: count(:)
#endif
    integer :: iotype

#ifdef TIMING
    call t_startf("pio_put_var1_double")
#endif 
    ierr=0
    iotype = File%iotype 
    if(debug) print *,_FILE_,__LINE__,ival,iotype, index
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          allocate(count(size(index)))
          count(:) = 1
#if (102 == TYPETEXT)
          count(1) = len(ival)
#endif	
          ierr = nfmpi_put_vara_all (File%fh, varid, int(index,kind=PIO_OFFSET), count, &
               ival, count, MPI_REAL8)
          deallocate(count)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=index)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File,ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_var1_double")
#endif 
  end function put_var1_double

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 58 "pionfput_mod.F90.in"
  integer function put_var1_int (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    integer(i4), intent(in) :: ival
#ifdef _PNETCDF
    integer(kind=PIO_OFFSET), allocatable :: count(:)
#endif
    integer :: iotype

#ifdef TIMING
    call t_startf("pio_put_var1_int")
#endif 
    ierr=0
    iotype = File%iotype 
    if(debug) print *,_FILE_,__LINE__,ival,iotype, index
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          allocate(count(size(index)))
          count(:) = 1
#if (103 == TYPETEXT)
          count(1) = len(ival)
#endif	
          ierr = nfmpi_put_vara_all (File%fh, varid, int(index,kind=PIO_OFFSET), count, &
               ival, count, MPI_INTEGER)
          deallocate(count)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=index)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File,ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_var1_int")
#endif 
  end function put_var1_int

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 116 "pionfput_mod.F90.in"
  integer function put_var1_vdesc_text (File,vardesc, start, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:)
    character(len=*), intent(in) :: ival

    ierr = put_var1_text (File, vardesc%varid, start, ival)
  end function put_var1_vdesc_text

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 116 "pionfput_mod.F90.in"
  integer function put_var1_vdesc_real (File,vardesc, start, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:)
    real(r4), intent(in) :: ival

    ierr = put_var1_real (File, vardesc%varid, start, ival)
  end function put_var1_vdesc_real

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 116 "pionfput_mod.F90.in"
  integer function put_var1_vdesc_double (File,vardesc, start, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:)
    real(r8), intent(in) :: ival

    ierr = put_var1_double (File, vardesc%varid, start, ival)
  end function put_var1_vdesc_double

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 116 "pionfput_mod.F90.in"
  integer function put_var1_vdesc_int (File,vardesc, start, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:)
    integer(i4), intent(in) :: ival

    ierr = put_var1_int (File, vardesc%varid, start, ival)
  end function put_var1_vdesc_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_0d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(0), count(0)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_0d_text")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((0==0) || (100== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_text (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,0
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_0d_text (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((100 == TYPETEXT) && (0==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_0d_text")
#endif 
  end function put_var_0d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_1d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(1), count(1)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_1d_text")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((1==0) || (100== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_text (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,1
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_1d_text (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((100 == TYPETEXT) && (1==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_1d_text")
#endif 
  end function put_var_1d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_2d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(2), count(2)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_2d_text")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((2==0) || (100== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_text (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,2
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_2d_text (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((100 == TYPETEXT) && (2==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_2d_text")
#endif 
  end function put_var_2d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_3d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(3), count(3)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_3d_text")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((3==0) || (100== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_text (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,3
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_3d_text (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((100 == TYPETEXT) && (3==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_3d_text")
#endif 
  end function put_var_3d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_4d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(4), count(4)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_4d_text")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((4==0) || (100== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_text (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,4
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_4d_text (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((100 == TYPETEXT) && (4==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_4d_text")
#endif 
  end function put_var_4d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_5d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(5), count(5)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_5d_text")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((5==0) || (100== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_text (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,5
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_5d_text (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((100 == TYPETEXT) && (5==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_5d_text")
#endif 
  end function put_var_5d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_0d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(0), count(0)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_0d_real")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((0==0) || (101== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_real (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,0
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_0d_real (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((101 == TYPETEXT) && (0==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_0d_real")
#endif 
  end function put_var_0d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_1d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(1), count(1)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_1d_real")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((1==0) || (101== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_real (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,1
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_1d_real (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((101 == TYPETEXT) && (1==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_1d_real")
#endif 
  end function put_var_1d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_2d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(2), count(2)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_2d_real")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((2==0) || (101== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_real (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,2
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_2d_real (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((101 == TYPETEXT) && (2==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_2d_real")
#endif 
  end function put_var_2d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_3d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(3), count(3)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_3d_real")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((3==0) || (101== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_real (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,3
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_3d_real (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((101 == TYPETEXT) && (3==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_3d_real")
#endif 
  end function put_var_3d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_4d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(4), count(4)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_4d_real")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((4==0) || (101== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_real (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,4
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_4d_real (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((101 == TYPETEXT) && (4==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_4d_real")
#endif 
  end function put_var_4d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_5d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(5), count(5)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_5d_real")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((5==0) || (101== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_real (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,5
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_5d_real (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((101 == TYPETEXT) && (5==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_5d_real")
#endif 
  end function put_var_5d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_0d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(0), count(0)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_0d_double")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((0==0) || (102== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_double (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,0
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_0d_double (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((102 == TYPETEXT) && (0==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_0d_double")
#endif 
  end function put_var_0d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_1d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(1), count(1)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_1d_double")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((1==0) || (102== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_double (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,1
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_1d_double (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((102 == TYPETEXT) && (1==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_1d_double")
#endif 
  end function put_var_1d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_2d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(2), count(2)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_2d_double")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((2==0) || (102== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_double (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,2
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_2d_double (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((102 == TYPETEXT) && (2==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_2d_double")
#endif 
  end function put_var_2d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_3d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(3), count(3)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_3d_double")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((3==0) || (102== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_double (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,3
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_3d_double (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((102 == TYPETEXT) && (3==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_3d_double")
#endif 
  end function put_var_3d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_4d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(4), count(4)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_4d_double")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((4==0) || (102== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_double (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,4
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_4d_double (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((102 == TYPETEXT) && (4==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_4d_double")
#endif 
  end function put_var_4d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_5d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(5), count(5)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_5d_double")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((5==0) || (102== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_double (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,5
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_5d_double (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((102 == TYPETEXT) && (5==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_5d_double")
#endif 
  end function put_var_5d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_0d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(0), count(0)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_0d_int")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((0==0) || (103== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_int (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,0
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_0d_int (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((103 == TYPETEXT) && (0==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_0d_int")
#endif 
  end function put_var_0d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_1d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(1), count(1)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_1d_int")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((1==0) || (103== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_int (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,1
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_1d_int (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((103 == TYPETEXT) && (1==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_1d_int")
#endif 
  end function put_var_1d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_2d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(2), count(2)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_2d_int")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((2==0) || (103== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_int (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,2
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_2d_int (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((103 == TYPETEXT) && (2==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_2d_int")
#endif 
  end function put_var_2d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_3d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(3), count(3)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_3d_int")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((3==0) || (103== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_int (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,3
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_3d_int (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((103 == TYPETEXT) && (3==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_3d_int")
#endif 
  end function put_var_3d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_4d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(4), count(4)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_4d_int")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((4==0) || (103== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_int (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,4
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_4d_int (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((103 == TYPETEXT) && (4==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_4d_int")
#endif 
  end function put_var_4d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 137 "pionfput_mod.F90.in"
  integer function put_var_5d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype
#ifdef _PNETCDF
    integer :: i, start(5), count(5)
#endif
#ifdef TIMING
    call t_startf("pio_put_var_5d_int")
#endif 
    ierr=PIO_NOERR
    if(File%iosystem%IOProc) then
       iotype = File%iotype 
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if((5==0) || (103== TYPETEXT))
          ierr = nfmpi_begin_indep_data(File%fh)
          if(File%iosystem%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_var_int (File%fh, varid, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          if(File%iosystem%io_rank==0) then
             start = 1
             do i=1,5
                count(i) = size(ival,i)
             end do
          else
             start = 0
             count = 0
          end if
          ierr = put_vara_5d_int (File, varid, start, count, ival)
#endif
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then

#if ((103 == TYPETEXT) && (5==0))
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
# 184 "pionfput_mod.F90.in"
! function nf90_put_var_text before it calls nf_put_vars_text. 
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,_FILE_,__LINE__)
#ifdef TIMING
    call t_stopf("pio_put_var_5d_int")
#endif 
  end function put_var_5d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival
    integer :: iotype

    ierr = put_var_0d_text (File, vardesc%varid, ival)
  end function put_var_vdesc_0d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:)
    integer :: iotype

    ierr = put_var_1d_text (File, vardesc%varid, ival)
  end function put_var_vdesc_1d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:)
    integer :: iotype

    ierr = put_var_2d_text (File, vardesc%varid, ival)
  end function put_var_vdesc_2d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:,:)
    integer :: iotype

    ierr = put_var_3d_text (File, vardesc%varid, ival)
  end function put_var_vdesc_3d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:,:,:)
    integer :: iotype

    ierr = put_var_4d_text (File, vardesc%varid, ival)
  end function put_var_vdesc_4d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype

    ierr = put_var_5d_text (File, vardesc%varid, ival)
  end function put_var_vdesc_5d_text

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival
    integer :: iotype

    ierr = put_var_0d_real (File, vardesc%varid, ival)
  end function put_var_vdesc_0d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:)
    integer :: iotype

    ierr = put_var_1d_real (File, vardesc%varid, ival)
  end function put_var_vdesc_1d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:)
    integer :: iotype

    ierr = put_var_2d_real (File, vardesc%varid, ival)
  end function put_var_vdesc_2d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:,:)
    integer :: iotype

    ierr = put_var_3d_real (File, vardesc%varid, ival)
  end function put_var_vdesc_3d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:,:,:)
    integer :: iotype

    ierr = put_var_4d_real (File, vardesc%varid, ival)
  end function put_var_vdesc_4d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype

    ierr = put_var_5d_real (File, vardesc%varid, ival)
  end function put_var_vdesc_5d_real

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival
    integer :: iotype

    ierr = put_var_0d_double (File, vardesc%varid, ival)
  end function put_var_vdesc_0d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:)
    integer :: iotype

    ierr = put_var_1d_double (File, vardesc%varid, ival)
  end function put_var_vdesc_1d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:)
    integer :: iotype

    ierr = put_var_2d_double (File, vardesc%varid, ival)
  end function put_var_vdesc_2d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:,:)
    integer :: iotype

    ierr = put_var_3d_double (File, vardesc%varid, ival)
  end function put_var_vdesc_3d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:,:,:)
    integer :: iotype

    ierr = put_var_4d_double (File, vardesc%varid, ival)
  end function put_var_vdesc_4d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype

    ierr = put_var_5d_double (File, vardesc%varid, ival)
  end function put_var_vdesc_5d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival
    integer :: iotype

    ierr = put_var_0d_int (File, vardesc%varid, ival)
  end function put_var_vdesc_0d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:)
    integer :: iotype

    ierr = put_var_1d_int (File, vardesc%varid, ival)
  end function put_var_vdesc_1d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:)
    integer :: iotype

    ierr = put_var_2d_int (File, vardesc%varid, ival)
  end function put_var_vdesc_2d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:,:)
    integer :: iotype

    ierr = put_var_3d_int (File, vardesc%varid, ival)
  end function put_var_vdesc_3d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:,:,:)
    integer :: iotype

    ierr = put_var_4d_int (File, vardesc%varid, ival)
  end function put_var_vdesc_4d_int

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 215 "pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype

    ierr = put_var_5d_int (File, vardesc%varid, ival)
  end function put_var_vdesc_5d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_1d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (100 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(1+1), pcount(1+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(1), pcount(1)
#endif
    character(len=*), intent(in) :: ival(:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_1d_text")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_CHARACTER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_1d_text")
#endif 
  end function put_vara_1d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_2d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (100 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(2+1), pcount(2+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(2), pcount(2)
#endif
    character(len=*), intent(in) :: ival(:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_2d_text")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_CHARACTER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_2d_text")
#endif 
  end function put_vara_2d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_3d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (100 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(3+1), pcount(3+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(3), pcount(3)
#endif
    character(len=*), intent(in) :: ival(:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_3d_text")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_CHARACTER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_3d_text")
#endif 
  end function put_vara_3d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_4d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (100 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(4+1), pcount(4+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(4), pcount(4)
#endif
    character(len=*), intent(in) :: ival(:,:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_4d_text")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_CHARACTER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_4d_text")
#endif 
  end function put_vara_4d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_5d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (100 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(5+1), pcount(5+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(5), pcount(5)
#endif
    character(len=*), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_5d_text")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_CHARACTER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_5d_text")
#endif 
  end function put_vara_5d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_1d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (101 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(1+1), pcount(1+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(1), pcount(1)
#endif
    real(r4), intent(in) :: ival(:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_1d_real")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL4)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_1d_real")
#endif 
  end function put_vara_1d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_2d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (101 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(2+1), pcount(2+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(2), pcount(2)
#endif
    real(r4), intent(in) :: ival(:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_2d_real")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL4)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_2d_real")
#endif 
  end function put_vara_2d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_3d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (101 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(3+1), pcount(3+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(3), pcount(3)
#endif
    real(r4), intent(in) :: ival(:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_3d_real")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL4)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_3d_real")
#endif 
  end function put_vara_3d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_4d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (101 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(4+1), pcount(4+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(4), pcount(4)
#endif
    real(r4), intent(in) :: ival(:,:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_4d_real")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL4)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_4d_real")
#endif 
  end function put_vara_4d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_5d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (101 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(5+1), pcount(5+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(5), pcount(5)
#endif
    real(r4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_5d_real")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL4)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_5d_real")
#endif 
  end function put_vara_5d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_1d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (102 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(1+1), pcount(1+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(1), pcount(1)
#endif
    real(r8), intent(in) :: ival(:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_1d_double")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL8)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_1d_double")
#endif 
  end function put_vara_1d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_2d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (102 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(2+1), pcount(2+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(2), pcount(2)
#endif
    real(r8), intent(in) :: ival(:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_2d_double")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL8)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_2d_double")
#endif 
  end function put_vara_2d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_3d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (102 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(3+1), pcount(3+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(3), pcount(3)
#endif
    real(r8), intent(in) :: ival(:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_3d_double")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL8)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_3d_double")
#endif 
  end function put_vara_3d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_4d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (102 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(4+1), pcount(4+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(4), pcount(4)
#endif
    real(r8), intent(in) :: ival(:,:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_4d_double")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL8)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_4d_double")
#endif 
  end function put_vara_4d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_5d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (102 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(5+1), pcount(5+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(5), pcount(5)
#endif
    real(r8), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_5d_double")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_REAL8)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_5d_double")
#endif 
  end function put_vara_5d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_1d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (103 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(1+1), pcount(1+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(1), pcount(1)
#endif
    integer(i4), intent(in) :: ival(:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_1d_int")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_INTEGER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_1d_int")
#endif 
  end function put_vara_1d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_2d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (103 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(2+1), pcount(2+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(2), pcount(2)
#endif
    integer(i4), intent(in) :: ival(:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_2d_int")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_INTEGER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_2d_int")
#endif 
  end function put_vara_2d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_3d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (103 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(3+1), pcount(3+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(3), pcount(3)
#endif
    integer(i4), intent(in) :: ival(:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_3d_int")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_INTEGER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_3d_int")
#endif 
  end function put_vara_3d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_4d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (103 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(4+1), pcount(4+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(4), pcount(4)
#endif
    integer(i4), intent(in) :: ival(:,:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_4d_int")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_INTEGER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_4d_int")
#endif 
  end function put_vara_4d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 237 "pionfput_mod.F90.in"
  integer function put_vara_5d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
#if (103 == TYPETEXT)
    integer(kind=PIO_OFFSET) :: pstart(5+1), pcount(5+1)
#else
    integer(kind=PIO_OFFSET) :: pstart(5), pcount(5)
#endif
    integer(i4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, i
    integer(kind=pio_offset) :: len
#ifdef TIMING
    call t_startf("pio_put_vara_5d_int")
#endif 
    ierr=0
    iotype = File%iotype 
    if(File%iosystem%IOProc) then
       select case (iotype) 
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          len=count(1)
          do i=2,size(count)
             len=len*count(i)
          end do
	  if(File%iosystem%io_rank==0) then
             pstart = start	
             pcount = count
          else
	     pstart=1 ! avoids an unessasary pnetcdf error 
	     pcount=0
          endif
	print *,__FILE__,__LINE__,pstart,pcount
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival, len, MPI_INTEGER)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          ! Only io proc 0 will do writing
          if (File%iosystem%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
          end if
#endif
       case default
          print *,_FILE_,__LINE__,iotype
          call piodie(_FILE_,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,_FILE_,__LINE__)

#ifdef TIMING
    call t_stopf("pio_put_vara_5d_int")
#endif 
  end function put_vara_5d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:)

    ierr = put_vara_1d_text (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_1d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:)

    ierr = put_vara_2d_text (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_2d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_text (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_3d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_text (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_4d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_text (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_5d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:)

    ierr = put_vara_1d_real (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_1d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:)

    ierr = put_vara_2d_real (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_2d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_real (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_3d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_real (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_4d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_real (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_5d_real

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:)

    ierr = put_vara_1d_double (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_1d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:)

    ierr = put_vara_2d_double (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_2d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_double (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_3d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_double (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_4d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_double (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_5d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:)

    ierr = put_vara_1d_int (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_1d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:)

    ierr = put_vara_2d_int (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_2d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_int (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_3d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_int (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_4d_int

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start : 
!! @param count : 
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 304 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_int (File, vardesc%varid, start, count, ival)


  end function put_vara_vdesc_5d_int
end module pionfput_mod
