#!/bin/sh

#short-term archive script - move model output out of run directory
#to free disc space for next invocation of model run
#must be executed from run directory

#function dispose:
#moves output files to specified area of st archive and will
#process interim files along the way: 
#arg1 => interim files flag
#arg2 => destination
#remaining args => actual files to be processed 
dispose() {
    if [ "$1" == "ifiles_y" ] && [ "$STA_SAVE_INTERIM_RFILES" != "TRUE" ]; then
	shift
	shift
	rm $*       2> /dev/null
    else
	shift
	dest=$1
	mkdir -p $dest
	shift
	mv $* $dest 2> /dev/null
    fi
}

echo ""
echo "st_archive.sh: start of short-term archiving"

#validate required env var settings
if [ -z "$STA_ROOT" ]; then
    echo "st_archive.sh: error, environment variable STA_ROOT is required "
    echo "               for root location of short-term archive"
    echo "st_archive.sh: exiting"
    exit 1
fi

if [ ! -d "$STA_ROOT" ]; then
    echo "st_archive.sh: error, setting for root location of short-term archive "
    echo "               is not a valid directory:  STA_ROOT= $STA_ROOT"
    echo "st_archive.sh: exiting"
    exit 1
fi

if [ -z "$ARCH_CASE" ]; then
    echo "st_archive.sh: error, environment variable ARCH_CASE is required "
    echo "               for casename of model run to archive"
    echo "st_archive.sh: exiting"
    exit 1
fi

sta="${STA_ROOT}/st_archive/${ARCH_CASE}"
mkdir -p ${sta} 2> /dev/null
if [ $? -ne 0 ]; then
    echo "st_archive.sh: error, unable to create short-term archive directory"
    echo "st_archive.sh: exiting"
    exit 1
fi

if [ -z "$STA_SAVE_INTERIM_RFILES" ]; then
    echo "st_archive.sh: warning, environment variable STA_SAVE_INTERIM_RFILES is not "
    echo "               set - using "FALSE" as default for saving interim restart files"
    export STA_SAVE_INTERIM_RFILES=FALSE
fi

if [ "$STA_SAVE_INTERIM_RFILES" == "FALSE" ]; then
    echo "st_archive.sh: restart files from end of run will be saved, "
    echo "               interim restart files will be deleted"
fi

#initialize temporary restart tar file (to be renamed later) with pointer files
set rpointer.*
if [ $# -le 0 ]; then
    echo "st_archive.sh: error, script should be invoked from run directory..."
    echo "               expecting restart pointer files of the form 'rpointer.<component>'"
    echo "               but did not find any: $*"
    echo "st_archive.sh: exiting"
    exit 1
fi
tar -cf temp.tar $*

set *cam?.r.*;      latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *cam?.rs.*;     latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *cam?.ra.*;     latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *cam?.rh0.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *cam?.rh1.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *cam?.rh2.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *cam?.rh3.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *cam?.rh4.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *cam?.rh5.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *clm?.r.*;      latest=`ls $* 2> /dev/null | tail -2`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/lnd/rest $*
set *camice.r.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ice/rest $*
set *cice.r.[0-9]*; latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ice/rest $*
set *cice.r.volpn*; latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ice/rest $*
set *cice.r.dEdd*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ice/rest $*
set *cice.r.age*;   latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ice/rest $*
set *cice.r.aero*;   latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ice/rest $*
set *camdom.r.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ocn/rest $*
set *camsom.r.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ocn/rest $*
set *docn?.rb.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ocn/rest $*
set *docn?.rs.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ocn/rest $*
set *datm?.rb.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *datm?.rs.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/atm/rest $*
set *dice?.r.*;     latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ice/rest $*
set *dice?.rb.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ice/rest $*
set *dice?.rs.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/ice/rest $*
set *dlnd?.r.*;     latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/lnd/rest $*
set *dlnd?.rb.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/lnd/rest $*
set *dlnd?.rs.*;    latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/lnd/rest $*
set *cpl.r.*;       latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_y ${sta}/cpl/rest $*; cplfile=$latest

set *cam?.h0.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/atm/hist $*
set *cam?.h1.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/atm/hist $*
set *cam?.h2.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/atm/hist $*
set *cam?.h3.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/atm/hist $*
set *cam?.h4.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/atm/hist $*
set *cam?.h5.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/atm/hist $*
set *cam?.i.*;   latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/atm/init $*
set *clm?.h0.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/lnd/hist $*
set *clm?.h1.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/lnd/hist $*
set *clm?.h2.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/lnd/hist $*
set *clm?.h3.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/lnd/hist $*
set *clm?.h4.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/lnd/hist $*
set *clm?.h5.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/lnd/hist $*
set *clm?.hv.*;  latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/lnd/hist $*
set *clm?.i.*;                                                                                 dispose ifiles_n ${sta}/lnd/init $*
set *cice.h.*;   latest=`ls $* 2> /dev/null | tail -1`; tar -rf temp.tar $latest 2> /dev/null; dispose ifiles_n ${sta}/ice/hist $*

#leave just the required files behind for next restart
rtarfile=`echo $cplfile | sed "s/.nc/.tar/; s/cpl/all/;"`
mv temp.tar $rtarfile
tar -xf $rtarfile
dispose ifiles_n ${sta}/restart.tars $rtarfile

echo "st_archive.sh: short-term archiving completed successfully"

exit 0
