#define TYPEDOUBLE 102
#define TYPEINT 103
#define TYPETEXT 100
#define TYPELONG 104
#define TYPEREAL 101
!===================================================
! DO NOT EDIT THIS FILE, it was generated using genf90.pl 
! Any changes you make to this file may be lost
!===================================================
#define _FILE_ "pionfatt_mod.F90"
module pionfatt_mod
  use pio_kinds, only : r4, r8, i4
  use pio_types, only : iotype_netcdf, iotype_pnetcdf, pio_noerr
  use pio_types, only : pio_iotype_netcdf4p, pio_iotype_netcdf4c
  use pio_types, only : file_desc_t, var_desc_t
  use pio_kinds, only : pio_offset
  use pio_support, only : piodie, checkmpireturn
  use pio_utils, only : check_netcdf, bad_iotype

#ifdef _NETCDF
    use netcdf      ! _EXTERNAL
#endif
  
  implicit none
#ifdef _PNETCDF
#  include <pnetcdf.inc>  /* _EXTERNAL */
#endif
  include 'mpif.h'  ! _EXTERNAL 


!>
!! @private
!<
  public :: put_att
# 26 "pionfatt_mod.F90.in"
  interface put_att
     module procedure put_att_text, put_att_desc_text
     module procedure put_att_real, put_att_desc_real
     module procedure put_att_double, put_att_desc_double
     module procedure put_att_int, put_att_desc_int
     ! TYPE real,int,double
     module procedure put_att_1d_real, put_att_desc_1d_real
     ! TYPE real,int,double
     module procedure put_att_1d_int, put_att_desc_1d_int
     ! TYPE real,int,double
     module procedure put_att_1d_double, put_att_desc_1d_double
  end interface


!>
!! @private
!<
  public :: get_att
# 37 "pionfatt_mod.F90.in"
  interface get_att
     module procedure get_att_text, get_att_desc_text
     module procedure get_att_real, get_att_desc_real
     module procedure get_att_double, get_att_desc_double
     module procedure get_att_int, get_att_desc_int
     ! TYPE real,int,double
     module procedure get_att_1d_real, get_att_desc_1d_real
     ! TYPE real,int,double
     module procedure get_att_1d_int, get_att_desc_1d_int
     ! TYPE real,int,double
     module procedure get_att_1d_double, get_att_desc_1d_double
  end interface

!>
!!  @public 
!!  @defgroup PIO_put_att PIO_put_att
!!  @brief Writes an netcdf attribute to a file 
!<
!>
!! @public 
!! @defgroup PIO_get_att PIO_get_att
!! @brief Reads  an netcdf attribute from a file 
!<

  private :: modName
  character(len=*), parameter :: modName='pionfatt_mod'

# 57 "pionfatt_mod.F90.in"
contains

!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 70 "pionfatt_mod.F90.in"
  integer function put_att_text (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: value

#if (100 != TYPETEXT)
#ifdef DEBUG
    character(len=*) :: chkval
#endif
#endif
    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::put_att_text'
    integer :: iotype, mpierr
    integer(kind=PIO_Offset) ::  clen=1

    iotype = File%iotype
    ierr=PIO_noerr
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if (100 == TYPETEXT)
          clen = len(value)
          ierr= nfmpi_put_att_text (File%fh,varid,name,clen,value)
#else

#ifdef DEBUG
          print *, _FILE_,__LINE__,value
          call MPI_ALLREDUCE(value, chkval, 1, MPI_CHARACTER, MPI_MAX ,File%iosystem%io_comm, mpierr)
          call CheckMPIReturn(subName, mpierr)
          if(chkval /= value) then
             print *,_FILE_,__LINE__,chkval,value, mpierr
             call piodie(_FILE_,__LINE__,'attributes do not match')
          end if
#endif             
#undef DEBUG
          ierr= nfmpi_put_att_text (File%fh,varid,name, nf_text , clen,value)
#endif
#endif

#ifdef _NETCDF
       case(iotype_netcdf,PIO_iotype_netcdf4c)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_put_att(File%fh,varid,name,value)
          endif
       case(PIO_iotype_netcdf4p)
          ierr=nf90_put_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
  end function put_att_text

!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 70 "pionfatt_mod.F90.in"
  integer function put_att_real (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r4), intent(in) :: value

#if (101 != TYPETEXT)
#ifdef DEBUG
    real(r4) :: chkval
#endif
#endif
    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::put_att_real'
    integer :: iotype, mpierr
    integer(kind=PIO_Offset) ::  clen=1

    iotype = File%iotype
    ierr=PIO_noerr
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if (101 == TYPETEXT)
          clen = len(value)
          ierr= nfmpi_put_att_text (File%fh,varid,name,clen,value)
#else

#ifdef DEBUG
          print *, _FILE_,__LINE__,value
          call MPI_ALLREDUCE(value, chkval, 1, MPI_REAL4, MPI_MAX ,File%iosystem%io_comm, mpierr)
          call CheckMPIReturn(subName, mpierr)
          if(chkval /= value) then
             print *,_FILE_,__LINE__,chkval,value, mpierr
             call piodie(_FILE_,__LINE__,'attributes do not match')
          end if
#endif             
#undef DEBUG
          ierr= nfmpi_put_att_real (File%fh,varid,name, nf_real , clen,value)
#endif
#endif

#ifdef _NETCDF
       case(iotype_netcdf,PIO_iotype_netcdf4c)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_put_att(File%fh,varid,name,value)
          endif
       case(PIO_iotype_netcdf4p)
          ierr=nf90_put_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
  end function put_att_real

!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 70 "pionfatt_mod.F90.in"
  integer function put_att_double (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r8), intent(in) :: value

#if (102 != TYPETEXT)
#ifdef DEBUG
    real(r8) :: chkval
#endif
#endif
    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::put_att_double'
    integer :: iotype, mpierr
    integer(kind=PIO_Offset) ::  clen=1

    iotype = File%iotype
    ierr=PIO_noerr
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if (102 == TYPETEXT)
          clen = len(value)
          ierr= nfmpi_put_att_text (File%fh,varid,name,clen,value)
#else

#ifdef DEBUG
          print *, _FILE_,__LINE__,value
          call MPI_ALLREDUCE(value, chkval, 1, MPI_REAL8, MPI_MAX ,File%iosystem%io_comm, mpierr)
          call CheckMPIReturn(subName, mpierr)
          if(chkval /= value) then
             print *,_FILE_,__LINE__,chkval,value, mpierr
             call piodie(_FILE_,__LINE__,'attributes do not match')
          end if
#endif             
#undef DEBUG
          ierr= nfmpi_put_att_double (File%fh,varid,name, nf_double , clen,value)
#endif
#endif

#ifdef _NETCDF
       case(iotype_netcdf,PIO_iotype_netcdf4c)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_put_att(File%fh,varid,name,value)
          endif
       case(PIO_iotype_netcdf4p)
          ierr=nf90_put_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
  end function put_att_double

!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 70 "pionfatt_mod.F90.in"
  integer function put_att_int (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i4), intent(in) :: value

#if (103 != TYPETEXT)
#ifdef DEBUG
    integer(i4) :: chkval
#endif
#endif
    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::put_att_int'
    integer :: iotype, mpierr
    integer(kind=PIO_Offset) ::  clen=1

    iotype = File%iotype
    ierr=PIO_noerr
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#if (103 == TYPETEXT)
          clen = len(value)
          ierr= nfmpi_put_att_text (File%fh,varid,name,clen,value)
#else

#ifdef DEBUG
          print *, _FILE_,__LINE__,value
          call MPI_ALLREDUCE(value, chkval, 1, MPI_INTEGER, MPI_MAX ,File%iosystem%io_comm, mpierr)
          call CheckMPIReturn(subName, mpierr)
          if(chkval /= value) then
             print *,_FILE_,__LINE__,chkval,value, mpierr
             call piodie(_FILE_,__LINE__,'attributes do not match')
          end if
#endif             
#undef DEBUG
          ierr= nfmpi_put_att_int (File%fh,varid,name, nf_int , clen,value)
#endif
#endif

#ifdef _NETCDF
       case(iotype_netcdf,PIO_iotype_netcdf4c)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_put_att(File%fh,varid,name,value)
          endif
       case(PIO_iotype_netcdf4p)
          ierr=nf90_put_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
  end function put_att_int

! TYPE real,double,int
!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 143 "pionfatt_mod.F90.in"
  integer function put_att_1d_real (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r4), intent(in) :: value(:)

#ifdef DEBUG
    real(r4) :: chkval
#endif
    !------------------
    ! Local variables
    !------------------

    character(len=*), parameter :: subName=modName//'::put_att_1d_real'
    integer :: iotype, mpierr
    integer(kind=PIO_Offset) ::  clen

    iotype = File%iotype
    ierr=PIO_noerr
    clen = size(value)

    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#ifdef DEBUG
          print *, _FILE_,__LINE__,value
          call MPI_ALLREDUCE(value, chkval, 1, MPI_REAL4, MPI_MAX ,File%iosystem%io_comm, mpierr)
          call CheckMPIReturn(subName, mpierr)
          if(chkval /= value) then
             print *,_FILE_,__LINE__,chkval,value, mpierr
             call piodie(_FILE_,__LINE__,'attributes do not match')
          end if
#endif             
#undef DEBUG
          ierr= nfmpi_put_att_real (File%fh,varid,name, nf_real , clen,value)
#endif
#ifdef _NETCDF
       case(iotype_netcdf, PIO_iotype_netcdf4c)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_put_att(File%fh,varid,name,value)
          endif
       case(pio_iotype_netcdf4p)
          ierr=nf90_put_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
  end function put_att_1d_real

! TYPE real,double,int
!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 143 "pionfatt_mod.F90.in"
  integer function put_att_1d_double (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r8), intent(in) :: value(:)

#ifdef DEBUG
    real(r8) :: chkval
#endif
    !------------------
    ! Local variables
    !------------------

    character(len=*), parameter :: subName=modName//'::put_att_1d_double'
    integer :: iotype, mpierr
    integer(kind=PIO_Offset) ::  clen

    iotype = File%iotype
    ierr=PIO_noerr
    clen = size(value)

    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#ifdef DEBUG
          print *, _FILE_,__LINE__,value
          call MPI_ALLREDUCE(value, chkval, 1, MPI_REAL8, MPI_MAX ,File%iosystem%io_comm, mpierr)
          call CheckMPIReturn(subName, mpierr)
          if(chkval /= value) then
             print *,_FILE_,__LINE__,chkval,value, mpierr
             call piodie(_FILE_,__LINE__,'attributes do not match')
          end if
#endif             
#undef DEBUG
          ierr= nfmpi_put_att_double (File%fh,varid,name, nf_double , clen,value)
#endif
#ifdef _NETCDF
       case(iotype_netcdf, PIO_iotype_netcdf4c)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_put_att(File%fh,varid,name,value)
          endif
       case(pio_iotype_netcdf4p)
          ierr=nf90_put_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
  end function put_att_1d_double

! TYPE real,double,int
!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 143 "pionfatt_mod.F90.in"
  integer function put_att_1d_int (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i4), intent(in) :: value(:)

#ifdef DEBUG
    integer(i4) :: chkval
#endif
    !------------------
    ! Local variables
    !------------------

    character(len=*), parameter :: subName=modName//'::put_att_1d_int'
    integer :: iotype, mpierr
    integer(kind=PIO_Offset) ::  clen

    iotype = File%iotype
    ierr=PIO_noerr
    clen = size(value)

    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
#ifdef DEBUG
          print *, _FILE_,__LINE__,value
          call MPI_ALLREDUCE(value, chkval, 1, MPI_INTEGER, MPI_MAX ,File%iosystem%io_comm, mpierr)
          call CheckMPIReturn(subName, mpierr)
          if(chkval /= value) then
             print *,_FILE_,__LINE__,chkval,value, mpierr
             call piodie(_FILE_,__LINE__,'attributes do not match')
          end if
#endif             
#undef DEBUG
          ierr= nfmpi_put_att_int (File%fh,varid,name, nf_int , clen,value)
#endif
#ifdef _NETCDF
       case(iotype_netcdf, PIO_iotype_netcdf4c)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_put_att(File%fh,varid,name,value)
          endif
       case(pio_iotype_netcdf4p)
          ierr=nf90_put_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
  end function put_att_1d_int

!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 208 "pionfatt_mod.F90.in"
  integer function put_att_desc_text (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    character(len=*), intent(in)      :: value

    ierr = put_att_text (File,varDesc%varid,name,value)

  end function put_att_desc_text

!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 208 "pionfatt_mod.F90.in"
  integer function put_att_desc_real (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r4), intent(in)      :: value

    ierr = put_att_real (File,varDesc%varid,name,value)

  end function put_att_desc_real

!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 208 "pionfatt_mod.F90.in"
  integer function put_att_desc_double (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r8), intent(in)      :: value

    ierr = put_att_double (File,varDesc%varid,name,value)

  end function put_att_desc_double

!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 208 "pionfatt_mod.F90.in"
  integer function put_att_desc_int (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i4), intent(in)      :: value

    ierr = put_att_int (File,varDesc%varid,name,value)

  end function put_att_desc_int

! TYPE real,int,double
!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 231 "pionfatt_mod.F90.in"
  integer function put_att_desc_1d_real (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r4), intent(in)      :: value(:)

    character(len=*), parameter :: subName=modName//'::put_att_desc_1d_real'

    ierr = put_att_1d_real (File,varDesc%varid,name,value)

  end function put_att_desc_1d_real

! TYPE real,int,double
!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 231 "pionfatt_mod.F90.in"
  integer function put_att_desc_1d_int (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i4), intent(in)      :: value(:)

    character(len=*), parameter :: subName=modName//'::put_att_desc_1d_int'

    ierr = put_att_1d_int (File,varDesc%varid,name,value)

  end function put_att_desc_1d_int

! TYPE real,int,double
!>
!! @public 
!! @ingroup PIO_put_att
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to add
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 231 "pionfatt_mod.F90.in"
  integer function put_att_desc_1d_double (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r8), intent(in)      :: value(:)

    character(len=*), parameter :: subName=modName//'::put_att_desc_1d_double'

    ierr = put_att_1d_double (File,varDesc%varid,name,value)

  end function put_att_desc_1d_double


!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 256 "pionfatt_mod.F90.in"
  integer function get_att_desc_text (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    character(len=*), intent(out)      :: value

    character(len=*), parameter :: subName=modName//'::get_att_desc_text'

    ierr = get_att_text (File,varDesc%varid,name,value)

  end function get_att_desc_text


!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 256 "pionfatt_mod.F90.in"
  integer function get_att_desc_real (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r4), intent(out)      :: value

    character(len=*), parameter :: subName=modName//'::get_att_desc_real'

    ierr = get_att_real (File,varDesc%varid,name,value)

  end function get_att_desc_real


!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 256 "pionfatt_mod.F90.in"
  integer function get_att_desc_double (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r8), intent(out)      :: value

    character(len=*), parameter :: subName=modName//'::get_att_desc_double'

    ierr = get_att_double (File,varDesc%varid,name,value)

  end function get_att_desc_double


!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 256 "pionfatt_mod.F90.in"
  integer function get_att_desc_int (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i4), intent(out)      :: value

    character(len=*), parameter :: subName=modName//'::get_att_desc_int'

    ierr = get_att_int (File,varDesc%varid,name,value)

  end function get_att_desc_int

! TYPE real,int,double
!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 281 "pionfatt_mod.F90.in"
  integer function get_att_desc_1d_real (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r4), intent(out)      :: value(:)

    character(len=*), parameter :: subName=modName//'::get_att_desc_1d_real'

    ierr = get_att_1d_real (File,varDesc%varid,name,value)

  end function get_att_desc_1d_real

! TYPE real,int,double
!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 281 "pionfatt_mod.F90.in"
  integer function get_att_desc_1d_int (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i4), intent(out)      :: value(:)

    character(len=*), parameter :: subName=modName//'::get_att_desc_1d_int'

    ierr = get_att_1d_int (File,varDesc%varid,name,value)

  end function get_att_desc_1d_int

! TYPE real,int,double
!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varDesc @copydoc var_desc_t
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 281 "pionfatt_mod.F90.in"
  integer function get_att_desc_1d_double (File,varDesc,name,value) result(ierr)

    type (File_desc_t), intent(inout) :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r8), intent(out)      :: value(:)

    character(len=*), parameter :: subName=modName//'::get_att_desc_1d_double'

    ierr = get_att_1d_double (File,varDesc%varid,name,value)

  end function get_att_desc_1d_double

!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 305 "pionfatt_mod.F90.in"
  integer function get_att_text (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(in) :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    character(len=*), intent(out)          :: value

    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::get_att_text'
    integer :: iotype, mpierr
    integer :: clen=1

    iotype = File%iotype
    ierr=PIO_noerr
#if (100 == TYPETEXT)	
    clen = len(value)
    value = ' '
#endif
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          ierr= nfmpi_get_att_text (File%fh,varid,name,value)
#endif

#ifdef _NETCDF
       case(iotype_netcdf)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_get_att(File%fh,varid,name,value)
          endif
          if(File%iosystem%num_tasks==File%iosystem%num_iotasks) then

             call MPI_BCAST(value,clen ,MPI_CHARACTER ,0,File%iosystem%IO_comm, mpierr)
             call CheckMPIReturn(subName, mpierr)
          end if
       case(PIO_iotype_netcdf4p,PIO_iotype_netcdf4c)
          ierr=nf90_get_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
    if(File%iosystem%num_tasks>File%iosystem%num_iotasks) then
       call MPI_BCAST(value, clen, MPI_CHARACTER,File%iosystem%iomaster,File%iosystem%comp_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
  end function get_att_text

!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 305 "pionfatt_mod.F90.in"
  integer function get_att_real (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(in) :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r4), intent(out)          :: value

    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::get_att_real'
    integer :: iotype, mpierr
    integer :: clen=1

    iotype = File%iotype
    ierr=PIO_noerr
#if (101 == TYPETEXT)	
    clen = len(value)
    value = ' '
#endif
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          ierr= nfmpi_get_att_real (File%fh,varid,name,value)
#endif

#ifdef _NETCDF
       case(iotype_netcdf)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_get_att(File%fh,varid,name,value)
          endif
          if(File%iosystem%num_tasks==File%iosystem%num_iotasks) then

             call MPI_BCAST(value,clen ,MPI_REAL4 ,0,File%iosystem%IO_comm, mpierr)
             call CheckMPIReturn(subName, mpierr)
          end if
       case(PIO_iotype_netcdf4p,PIO_iotype_netcdf4c)
          ierr=nf90_get_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
    if(File%iosystem%num_tasks>File%iosystem%num_iotasks) then
       call MPI_BCAST(value, clen, MPI_REAL4,File%iosystem%iomaster,File%iosystem%comp_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
  end function get_att_real

!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 305 "pionfatt_mod.F90.in"
  integer function get_att_double (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(in) :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r8), intent(out)          :: value

    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::get_att_double'
    integer :: iotype, mpierr
    integer :: clen=1

    iotype = File%iotype
    ierr=PIO_noerr
#if (102 == TYPETEXT)	
    clen = len(value)
    value = ' '
#endif
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          ierr= nfmpi_get_att_double (File%fh,varid,name,value)
#endif

#ifdef _NETCDF
       case(iotype_netcdf)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_get_att(File%fh,varid,name,value)
          endif
          if(File%iosystem%num_tasks==File%iosystem%num_iotasks) then

             call MPI_BCAST(value,clen ,MPI_REAL8 ,0,File%iosystem%IO_comm, mpierr)
             call CheckMPIReturn(subName, mpierr)
          end if
       case(PIO_iotype_netcdf4p,PIO_iotype_netcdf4c)
          ierr=nf90_get_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
    if(File%iosystem%num_tasks>File%iosystem%num_iotasks) then
       call MPI_BCAST(value, clen, MPI_REAL8,File%iosystem%iomaster,File%iosystem%comp_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
  end function get_att_double

!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 305 "pionfatt_mod.F90.in"
  integer function get_att_int (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(in) :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    integer(i4), intent(out)          :: value

    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::get_att_int'
    integer :: iotype, mpierr
    integer :: clen=1

    iotype = File%iotype
    ierr=PIO_noerr
#if (103 == TYPETEXT)	
    clen = len(value)
    value = ' '
#endif
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          ierr= nfmpi_get_att_int (File%fh,varid,name,value)
#endif

#ifdef _NETCDF
       case(iotype_netcdf)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_get_att(File%fh,varid,name,value)
          endif
          if(File%iosystem%num_tasks==File%iosystem%num_iotasks) then

             call MPI_BCAST(value,clen ,MPI_INTEGER ,0,File%iosystem%IO_comm, mpierr)
             call CheckMPIReturn(subName, mpierr)
          end if
       case(PIO_iotype_netcdf4p,PIO_iotype_netcdf4c)
          ierr=nf90_get_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
    if(File%iosystem%num_tasks>File%iosystem%num_iotasks) then
       call MPI_BCAST(value, clen, MPI_INTEGER,File%iosystem%iomaster,File%iosystem%comp_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if
  end function get_att_int

! TYPE real,int,double
!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 370 "pionfatt_mod.F90.in"
  integer function get_att_1d_real (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(in) :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r4), intent(out)          :: value(:)

    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::get_att_1d_real'
    integer :: iotype, mpierr
    integer :: clen

    iotype = File%iotype
    ierr=PIO_noerr
    clen = size(value)
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          ierr= nfmpi_get_att_real (File%fh,varid,name,value)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_get_att(File%fh,varid,name,value)
          endif
          if(File%iosystem%num_tasks==File%iosystem%num_iotasks) then
             call MPI_BCAST(value,clen ,MPI_REAL4 ,0,File%iosystem%IO_comm, mpierr)
             call CheckMPIReturn(subName, mpierr)
          end if
       case(PIO_iotype_netcdf4p,PIO_iotype_netcdf4c)
          ierr=nf90_get_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
    if(File%iosystem%num_tasks>File%iosystem%num_iotasks) then
       call MPI_BCAST(value, clen, MPI_REAL4,File%iosystem%iomaster,File%iosystem%comp_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if

  end function get_att_1d_real

! TYPE real,int,double
!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 370 "pionfatt_mod.F90.in"
  integer function get_att_1d_int (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(in) :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    integer(i4), intent(out)          :: value(:)

    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::get_att_1d_int'
    integer :: iotype, mpierr
    integer :: clen

    iotype = File%iotype
    ierr=PIO_noerr
    clen = size(value)
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          ierr= nfmpi_get_att_int (File%fh,varid,name,value)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_get_att(File%fh,varid,name,value)
          endif
          if(File%iosystem%num_tasks==File%iosystem%num_iotasks) then
             call MPI_BCAST(value,clen ,MPI_INTEGER ,0,File%iosystem%IO_comm, mpierr)
             call CheckMPIReturn(subName, mpierr)
          end if
       case(PIO_iotype_netcdf4p,PIO_iotype_netcdf4c)
          ierr=nf90_get_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
    if(File%iosystem%num_tasks>File%iosystem%num_iotasks) then
       call MPI_BCAST(value, clen, MPI_INTEGER,File%iosystem%iomaster,File%iosystem%comp_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if

  end function get_att_1d_int

! TYPE real,int,double
!>
!! @public 
!! @ingroup PIO_get_att
!! @brief Reads an netcdf attribute from a  file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param name : name of the attribute to get
!! @param value : The value for the netcdf attribute 
!! @retval ierr @copydoc error_return
!<
# 370 "pionfatt_mod.F90.in"
  integer function get_att_1d_double (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(in) :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r8), intent(out)          :: value(:)

    !------------------
    ! Local variables
    !------------------
    character(len=*), parameter :: subName=modName//'::get_att_1d_double'
    integer :: iotype, mpierr
    integer :: clen

    iotype = File%iotype
    ierr=PIO_noerr
    clen = size(value)
    if(File%iosystem%IOproc) then
       select case(iotype)
#ifdef _PNETCDF
       case(iotype_pnetcdf)
          ierr= nfmpi_get_att_double (File%fh,varid,name,value)
#endif
#ifdef _NETCDF
       case(iotype_netcdf)
          if (File%iosystem%io_rank==0) then
             ierr=nf90_get_att(File%fh,varid,name,value)
          endif
          if(File%iosystem%num_tasks==File%iosystem%num_iotasks) then
             call MPI_BCAST(value,clen ,MPI_REAL8 ,0,File%iosystem%IO_comm, mpierr)
             call CheckMPIReturn(subName, mpierr)
          end if
       case(PIO_iotype_netcdf4p,PIO_iotype_netcdf4c)
          ierr=nf90_get_att(File%fh,varid,name,value)
#endif

       case default
          call bad_iotype(iotype,_FILE_,__LINE__)

       end select
    endif
    call check_netcdf(File, ierr,_FILE_,__LINE__)
    if(File%iosystem%num_tasks>File%iosystem%num_iotasks) then
       call MPI_BCAST(value, clen, MPI_REAL8,File%iosystem%iomaster,File%iosystem%comp_comm, mpierr)
       call CheckMPIReturn(subName, mpierr)
    end if

  end function get_att_1d_double


end module pionfatt_mod
