#define TYPEDOUBLE 102
#define TYPEINT 103
#define TYPETEXT 100
#define TYPELONG 104
#define TYPEREAL 101
!===================================================
! DO NOT EDIT THIS FILE, it was generated using genf90.pl 
! Any changes you make to this file may be lost
!===================================================
#define _FILE_ "pio_support.F90"
!>
!! @private
!<
module pio_support
  use pio_kinds
  use pio_types, only : iotype_pnetcdf, iotype_netcdf, iotype_pnetcdf
  implicit none
  private

  include 'mpif.h'    ! _EXTERNAL
  

  public :: piodie
  public :: CheckMPIreturn
  public :: pio_readdof
  public :: pio_writedof


#ifdef NO_MPI2
  public :: MPI_TYPE_CREATE_INDEXED_BLOCK
#endif

#ifdef NO_SIZEOF
!>
!! @private
!<
  public sizeof
# 29 "pio_support.F90.in"
  interface sizeof
     module procedure sizeof_text
     module procedure sizeof_real
     module procedure sizeof_double
     module procedure sizeof_int
  end interface
#endif

  logical, public :: Debug=.FALSE.
  logical, public :: DebugIO=.FALSE.
  integer,private,parameter :: versno = 1001

  character(len=*), parameter :: modName='pio_support'

# 40 "pio_support.F90.in"
contains

# 42 "pio_support.F90.in"
  subroutine piodie (file,line, msg, ival1, msg2, ival2, msg3, ival3)
    !-----------------------------------------------------------------------
    ! Purpose:
    !
    ! Abort the model for abnormal termination
    !
    ! Author: Jim Edwards
    !
    ! Change History
    ! 20070608 R. Loy  added optional args
    !-----------------------------------------------------------------------
    ! $Id$
    !-----------------------------------------------------------------------
    !-----------------------------------------------------------------------
    implicit none
    !-----------------------------------------------------------------------
    !
    ! Arguments
    !
    character(len=*), intent(in) :: file
    integer,intent(in) :: line
    character(len=*), intent(in), optional :: msg,msg2,msg3
    integer,intent(in),optional :: ival1,ival2,ival3

    character(len=*), parameter :: subName=modName//'::pio_die'
    integer ierr, myrank

    call MPI_COMM_RANK(MPI_COMM_WORLD,myrank,ierr)
    if(ierr /= MPI_SUCCESS) then
      print *, subName,':: Error in call to MPI_COMM_RANK, ierr=',ierr
    endif

    if (present(ival3)) then
       write(6,*) subName,':: myrank=',myrank,': ERROR: ',file,':',line,': ', &
            msg,ival1,msg2,ival2,msg3,ival3
    else if (present(msg3)) then
       write(6,*) subName,':: myrank=',myrank,': ERROR: ',file,':',line,': ', &
            msg,ival1,msg2,ival2,msg3
    else if (present(ival2)) then
       write(6,*) subName,':: myrank=',myrank,': ERROR: ',file,':',line,': ',msg,ival1,msg2,ival2
    else if (present(msg2)) then
       write(6,*) subName,':: myrank=',myrank,': ERROR: ',file,':',line,': ',msg,ival1,msg2
    else if (present(ival1)) then
       write(6,*) subName,':: myrank=',myrank,': ERROR: ',file,':',line,': ',msg,ival1
    else if (present(msg)) then
       write(6,*) subName,':: myrank=',myrank,': ERROR: ',file,':',line,': ',msg
    else
       write(6,*) subName,':: myrank=',myrank,': ERROR: ',file,':',line,': (no message)'
    endif


#if defined(AIX) || defined(_AIX)  || defined(SYSAIX)
#if !defined(BGL) && !defined(BGP)
  close(5)    ! needed to prevent batch jobs from hanging in xl__trbk
  call xl__trbk()
#endif
#endif

#if (defined _MPI)
    ! passing an argument of 1 to mpi_abort will lead to a STOPALL output 
    ! error code of 257
    call mpi_abort (MPI_COMM_WORLD, 1)  
#else
    call abort
#endif

  end subroutine piodie

!=============================================
!  CheckMPIreturn:
!
!      Check and prints an error message
!  if an error occured in a MPI subroutine.
!=============================================
# 116 "pio_support.F90.in"
  subroutine CheckMPIreturn(locmesg, errcode, file, line)

     character(len=*), intent(in) :: locmesg
     integer(i4), intent(in) :: errcode
     character(len=*),optional :: file
     integer, intent(in),optional :: line
     character(len=MPI_MAX_ERROR_STRING) :: errorstring

     integer(i4) :: errorlen

     integer(i4) :: ierr

     if (errcode .ne. MPI_SUCCESS) then
        call MPI_Error_String(errcode,errorstring,errorlen,ierr)
        write(*,*) TRIM(ADJUSTL(locmesg))//errorstring(1:errorlen)
        if(present(file).and.present(line)) then
           call piodie(file,line)
        endif
     end if

  end subroutine CheckMPIreturn

# 138 "pio_support.F90.in"
  subroutine pio_writedof (file, DOF, comm, punit)
    !-----------------------------------------------------------------------
    ! Purpose:
    !
    ! Write a DOF to standard format
    !
    ! Author: T Craig
    !
    ! Change History
    ! 
    !-----------------------------------------------------------------------
    ! $Id$
    !-----------------------------------------------------------------------
    !-----------------------------------------------------------------------
    implicit none
    !-----------------------------------------------------------------------
    !
    ! Arguments
    !
    character(len=*),intent(in) :: file
    integer        ,intent(in) :: dof(:)
    integer         ,intent(in) :: comm
    integer,optional,intent(in) :: punit

    character(len=*), parameter :: subName=modName//'::pio_writedof'
    integer ierr, myrank, npes, sdof, m, n, unit
    integer, pointer :: wdof(:)
    integer, pointer :: sdof1d(:)
    integer          :: status(MPI_STATUS_SIZE)
    integer, parameter :: masterproc = 0

    unit = 81
    if (present(punit)) then
       unit = punit
    endif

    call MPI_COMM_SIZE(comm,npes,ierr)
    call CheckMPIReturn(subName,ierr)
    call MPI_COMM_RANK(comm,myrank,ierr)
    call CheckMPIReturn(subName,ierr)
    sdof = size(dof)

    allocate(sdof1d(0:npes-1))
    sdof1d = -1
    call MPI_GATHER(sdof,1,MPI_INTEGER,sdof1d,1,MPI_INTEGER,masterproc,comm,ierr)
    if (ierr /= MPI_SUCCESS) call piodie(_FILE_,__LINE__,' pio_writedof mpi_gather')

    if (myrank == masterproc) then
       write(6,*) subName,': writing file ',trim(file),' unit=',unit
       open(unit,file=file)
       write(unit,*) versno,npes
    endif

    do n = 0,npes-1
       if (myrank == masterproc) then
          allocate(wdof(sdof1d(n)))
       endif
       if (myrank == masterproc .and. n == masterproc) then
          wdof = dof
       else
          if (myrank == n .and. sdof > 0) then
             call MPI_SEND(dof,sdof,MPI_INTEGER,masterproc,n,comm,status,ierr)
             if (ierr /= MPI_SUCCESS) call piodie(_FILE_,__LINE__,' pio_writedof mpi_send')
          endif
          if (myrank == masterproc .and. sdof1d(n) > 0) then
             call MPI_RECV(wdof,sdof1d(n),MPI_INTEGER,n,n,comm,status,ierr)
             if (ierr /= MPI_SUCCESS) call piodie(_FILE_,__LINE__,' pio_writedof mpi_recv')
          endif
       endif
       if (myrank == masterproc) then
          write(unit,*) n,sdof1d(n)
          do m = 1,sdof1d(n)
             write(unit,*) wdof(m)
          enddo
          deallocate(wdof)
       endif
    enddo

    if (myrank == masterproc) then
       close(unit)
    endif

    deallocate(sdof1d)

  end subroutine pio_writedof

# 224 "pio_support.F90.in"
  subroutine pio_readdof (file, DOF, comm, punit)
    !-----------------------------------------------------------------------
    ! Purpose:
    !
    ! Read a DOF to standard format
    !
    ! Author: T Craig
    !
    ! Change History
    ! 
    !-----------------------------------------------------------------------
    ! $Id$
    !-----------------------------------------------------------------------
    !-----------------------------------------------------------------------
    implicit none
    !-----------------------------------------------------------------------
    !
    ! Arguments
    !
    character(len=*),intent(in) :: file
    integer        ,pointer:: dof(:)
    integer         ,intent(in) :: comm
    integer,optional,intent(in) :: punit

    character(len=*), parameter :: subName=modName//'::pio_readdof'
    integer :: ierr, myrank, npes, sdof, m, n, unit, rn
    integer :: rversno, rnpes
    integer, pointer :: wdof(:)
    integer, parameter :: masterproc = 0
    integer :: status(MPI_STATUS_SIZE)

    unit = 81
    if (present(punit)) then
       unit = punit
    endif

    call MPI_COMM_SIZE(comm,npes,ierr)
    call CheckMPIReturn(subName,ierr)
    call MPI_COMM_RANK(comm,myrank,ierr)
    call CheckMPIReturn(subName,ierr)

    allocate(dof(0))   ! default for pes with no dof

    if (myrank == masterproc) then
       write(6,*) subName,': reading file ',trim(file),' unit=',unit
       open(unit,file=file,status='old')
       read(unit,*) rversno,rnpes
       write(6,*) subName,': reading file ',trim(file),' versno=',rversno
       if (rnpes /= npes) then
          call piodie(_FILE_,__LINE__,'pio_readdof npes incorrect')
       endif

       do n = 0,npes-1
          read(unit,*) rn,sdof
          if (rn /= n) then
             call piodie(_FILE_,__LINE__,'pio_readdof rn out of sync')
          endif
          allocate(wdof(sdof))
          do m = 1,sdof
             read(unit,*) wdof(m)
          enddo
          if (n == masterproc) then
             deallocate(dof)
             allocate(dof(sdof))
             dof = wdof
          else
             call MPI_SEND(sdof,1,MPI_INTEGER,n,n,comm,status,ierr)
             if (ierr /= MPI_SUCCESS) call piodie(_FILE_,__LINE__,' pio_readdof mpi_send1')
             if (sdof > 0) then
                call MPI_SEND(wdof,sdof,MPI_INTEGER,n,npes+n,comm,status,ierr)
                if (ierr /= MPI_SUCCESS) call piodie(_FILE_,__LINE__,' pio_readdof mpi_send2')
             endif
          endif
          deallocate(wdof)
       enddo
       close(unit)
    else
       call MPI_RECV(sdof,1,MPI_INTEGER,masterproc,myrank,comm,status,ierr)
       if (ierr /= MPI_SUCCESS) call piodie(_FILE_,__LINE__,' pio_readdof mpi_recv1')
       if (sdof > 0) then
          deallocate(dof)
          allocate(dof(sdof))
          call MPI_RECV(dof,sdof,MPI_INTEGER,masterproc,npes+myrank,comm,status,ierr)
          if (ierr /= MPI_SUCCESS) call piodie(_FILE_,__LINE__,' pio_readdof mpi_recv2')
       endif
    endif

  end subroutine pio_readdof

#ifdef NO_MPI2

# 315 "pio_support.F90.in"
  subroutine MPI_TYPE_CREATE_INDEXED_BLOCK(count, blen, disp, oldtype, newtype, ierr)
    integer, intent(in)  :: count
    integer, intent(in)  :: blen
    integer, intent(in)  :: disp(:)
    integer, intent(in)  :: oldtype
    integer, intent(out) :: newtype
    integer :: ierr

    integer :: dblens(count)

    dblens = blen

    call mpi_type_indexed(count, dblens, disp, oldtype, newtype, ierr)

  end subroutine MPI_TYPE_CREATE_INDEXED_BLOCK
#endif
#ifdef NO_SIZEOF

# 333 "pio_support.F90.in"
  integer function sizeof_text(val) result(i)
    implicit none
    character(len=*),intent(in) :: val

#if (100 == TYPEINT) 
    i=4
#elif (100 == TYPEREAL)
    i=4
#elif (100 == TYPEDOUBLE)
    i=8
#elif (100 == TYPETEXT)
    i=len(val)
#endif
  end function sizeof_text

# 333 "pio_support.F90.in"
  integer function sizeof_real(val) result(i)
    implicit none
    real(r4),intent(in) :: val

#if (101 == TYPEINT) 
    i=4
#elif (101 == TYPEREAL)
    i=4
#elif (101 == TYPEDOUBLE)
    i=8
#elif (101 == TYPETEXT)
    i=len(val)
#endif
  end function sizeof_real

# 333 "pio_support.F90.in"
  integer function sizeof_double(val) result(i)
    implicit none
    real(r8),intent(in) :: val

#if (102 == TYPEINT) 
    i=4
#elif (102 == TYPEREAL)
    i=4
#elif (102 == TYPEDOUBLE)
    i=8
#elif (102 == TYPETEXT)
    i=len(val)
#endif
  end function sizeof_double

# 333 "pio_support.F90.in"
  integer function sizeof_int(val) result(i)
    implicit none
    integer(i4),intent(in) :: val

#if (103 == TYPEINT) 
    i=4
#elif (103 == TYPEREAL)
    i=4
#elif (103 == TYPEDOUBLE)
    i=8
#elif (103 == TYPETEXT)
    i=len(val)
#endif
  end function sizeof_int
#endif



end module pio_support
