/*@@
   @file    RegisterThornFunctions.c
   @author  Automatically generated by CreateFunctionBindings.pl
   @desc
            Register aliased functions from active thorns
   @enddesc
  @@*/


#include "cctk_Flesh.h"
#include "cctk_ActiveThorns.h"
#include "cctk_WarnLevel.h"
#include "CactusBindings/cctk_Functions.h"

CCTK_INT Register_Boundary(void);
CCTK_INT Register_CoordBase(void);
CCTK_INT Register_IOUtil(void);
CCTK_INT Register_MoL(void);
CCTK_INT Register_PUGHInterp(void);
CCTK_INT Register_PUGHSlab(void);
CCTK_INT Register_StaticConformal(void);
CCTK_INT Register_SymBase(void);
CCTK_INT CCTKBindings_RegisterThornFunctions(void);

CCTK_INT CCTKBindings_RegisterThornFunctions(void)
{
  CCTK_INT retval;

  retval = 0;

  if (CCTK_IsThornActive("Boundary"))
  {
    retval += Register_Boundary();
  }
  if (CCTK_IsThornActive("CoordBase"))
  {
    retval += Register_CoordBase();
  }
  if (CCTK_IsThornActive("IOUtil"))
  {
    retval += Register_IOUtil();
  }
  if (CCTK_IsThornActive("MoL"))
  {
    retval += Register_MoL();
  }
  if (CCTK_IsThornActive("PUGHInterp"))
  {
    retval += Register_PUGHInterp();
  }
  if (CCTK_IsThornActive("PUGHSlab"))
  {
    retval += Register_PUGHSlab();
  }
  if (CCTK_IsThornActive("StaticConformal"))
  {
    retval += Register_StaticConformal();
  }
  if (CCTK_IsThornActive("SymBase"))
  {
    retval += Register_SymBase();
  }

  /* verify that all aliased functions which are REQUIRED
     by active thorns are also provided by someone */
  if (CCTK_IsThornActive("ADMBase"))
  {
    if (! CCTK_IsFunctionAliased("GetBoundarySpecification"))
    {
      CCTK_Warn(1, __LINE__, __FILE__, "Bindings",
                "The aliased function 'GetBoundarySpecification' (required by thorn 'ADMBase') has not been provided by any active thorn !\n"
                "Please activate one of the following thorns which provide this function:\n"
                "  CoordBase");
      retval++;
    }
  }
  if (CCTK_IsThornActive("Boundary"))
  {
    if (! CCTK_IsFunctionAliased("SymmetryTableHandleForGrid"))
    {
      CCTK_Warn(1, __LINE__, __FILE__, "Bindings",
                "The aliased function 'SymmetryTableHandleForGrid' (required by thorn 'Boundary') has not been provided by any active thorn !\n"
                "Please activate one of the following thorns which provide this function:\n"
                "  SymBase");
      retval++;
    }
  }
  if (CCTK_IsThornActive("GenericFD"))
  {
    if (! CCTK_IsFunctionAliased("SymmetryTableHandleForGrid"))
    {
      CCTK_Warn(1, __LINE__, __FILE__, "Bindings",
                "The aliased function 'SymmetryTableHandleForGrid' (required by thorn 'GenericFD') has not been provided by any active thorn !\n"
                "Please activate one of the following thorns which provide this function:\n"
                "  SymBase");
      retval++;
    }
  }
  if (CCTK_IsThornActive("IOASCII"))
  {
    if (! CCTK_IsFunctionAliased("Hyperslab_FreeMapping"))
    {
      CCTK_Warn(1, __LINE__, __FILE__, "Bindings",
                "The aliased function 'Hyperslab_FreeMapping' (required by thorn 'IOASCII') has not been provided by any active thorn !\n"
                "Please activate one of the following thorns which provide this function:\n"
                "  PUGHSlab");
      retval++;
    }
    if (! CCTK_IsFunctionAliased("Hyperslab_GetList"))
    {
      CCTK_Warn(1, __LINE__, __FILE__, "Bindings",
                "The aliased function 'Hyperslab_GetList' (required by thorn 'IOASCII') has not been provided by any active thorn !\n"
                "Please activate one of the following thorns which provide this function:\n"
                "  PUGHSlab");
      retval++;
    }
    if (! CCTK_IsFunctionAliased("IO_TruncateOutputFiles"))
    {
      CCTK_Warn(1, __LINE__, __FILE__, "Bindings",
                "The aliased function 'IO_TruncateOutputFiles' (required by thorn 'IOASCII') has not been provided by any active thorn !\n"
                "Please activate one of the following thorns which provide this function:\n"
                "  IOUtil");
      retval++;
    }
    if (! CCTK_IsFunctionAliased("Hyperslab_GlobalMappingByIndex"))
    {
      CCTK_Warn(1, __LINE__, __FILE__, "Bindings",
                "The aliased function 'Hyperslab_GlobalMappingByIndex' (required by thorn 'IOASCII') has not been provided by any active thorn !\n"
                "Please activate one of the following thorns which provide this function:\n"
                "  PUGHSlab");
      retval++;
    }
  }
  if (CCTK_IsThornActive("IOBasic"))
  {
    if (! CCTK_IsFunctionAliased("IO_TruncateOutputFiles"))
    {
      CCTK_Warn(1, __LINE__, __FILE__, "Bindings",
                "The aliased function 'IO_TruncateOutputFiles' (required by thorn 'IOBasic') has not been provided by any active thorn !\n"
                "Please activate one of the following thorns which provide this function:\n"
                "  IOUtil");
      retval++;
    }
  }

  return retval;
}
