/*@@
   @file    IOASCII_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"
#include "ParameterCRestrictedIO.h"

/* structure containing all private parameters of thorn IOASCII */
struct
{
  CCTK_REAL out1D_xline_y;
  CCTK_REAL out1D_xline_z;
  CCTK_REAL out1D_yline_x;
  CCTK_REAL out1D_yline_z;
  CCTK_REAL out1D_zline_x;
  CCTK_REAL out1D_zline_y;
  CCTK_REAL out2D_xyplane_z;
  CCTK_REAL out2D_xzplane_y;
  CCTK_REAL out2D_yzplane_x;
  const char * out1D_dir;
  const char * out1D_style;
  const char * out1D_vars;
  const char * out2D_dir;
  const char * out2D_style;
  const char * out2D_vars;
  const char * out3D_dir;
  const char * out3D_style;
  const char * out3D_vars;
  const char * out_format;
  CCTK_INT out1D_d;
  CCTK_INT out1D_every;
  CCTK_INT out1D_x;
  CCTK_INT out1D_xline_yi;
  CCTK_INT out1D_xline_zi;
  CCTK_INT out1D_y;
  CCTK_INT out1D_yline_xi;
  CCTK_INT out1D_yline_zi;
  CCTK_INT out1D_z;
  CCTK_INT out1D_zline_xi;
  CCTK_INT out1D_zline_yi;
  CCTK_INT out2D_every;
  CCTK_INT out2D_xyplane_zi;
  CCTK_INT out2D_xzplane_yi;
  CCTK_INT out2D_yzplane_xi;
  CCTK_INT out3D_every;
} PRIVATE_IOASCII_STRUCT;


/* structure containing all restricted parameters of thorn IOASCII */
struct
{
  int dummy_parameter;
} RESTRICTED_IOASCII_STRUCT;


int CCTKi_BindingsCreateIOASCIIParameters(void);
int CCTKi_BindingsCreateIOASCIIParameters(void)
{
  CCTKi_ParameterCreate("out1D_d",
                        "IOASCII",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Do 1D IOASCII output in the diagonal-direction",
                        "yes",
                        &(PRIVATE_IOASCII_STRUCT.out1D_d),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("out1D_dir",
                        "IOASCII",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Output directory for 1D IOASCII files, overrides IO::out_dir",
                        "",
                        &(PRIVATE_IOASCII_STRUCT.out1D_dir),
                        0,
                        NULL,
                        2,
                        ".+", "A valid directory name",
                        "^$", "An empty string to choose the default from IO::out_dir");

  CCTKi_ParameterCreate("out1D_every",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "How often to do 1D IOASCII output, overrides IO::out_every",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out1D_every),
                        0,
                        NULL,
                        3,
                        "1:*", "Every so many iterations",
                        "0:", "Disable 1D IOASCII output",
                        "-1:", "Default to IO::out_every");

  CCTKi_ParameterCreate("out1D_style",
                        "IOASCII",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Which style for 1D lines IOASCII output",
                        "xgraph",
                        &(PRIVATE_IOASCII_STRUCT.out1D_style),
                        0,
                        NULL,
                        3,
                        "xgraph", "f over x plots suitable for xgraph",
                        "gnuplot f(x)", "f over x plots suitable for gnuplot",
                        "gnuplot f(t,x)", "f over t,x plots suitable for gnuplot");

  CCTKi_ParameterCreate("out1D_vars",
                        "IOASCII",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Variables to output in 1D IOASCII file format",
                        "",
                        &(PRIVATE_IOASCII_STRUCT.out1D_vars),
                        0,
                        NULL,
                        2,
                        ".+", "Space-separated list of fully qualified variable/group names",
                        "^$", "An empty string to output nothing");

  CCTKi_ParameterCreate("out1D_x",
                        "IOASCII",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Do 1D IOASCII output in the x-direction",
                        "yes",
                        &(PRIVATE_IOASCII_STRUCT.out1D_x),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("out1D_xline_y",
                        "IOASCII",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "y-coord for 1D lines in x-direction",
                        "-424242",
                        &(PRIVATE_IOASCII_STRUCT.out1D_xline_y),
                        0,
                        NULL,
                        2,
                        "*:*", "A value between [ymin, ymax]",
                        "-424242:", "Default to IO::out_xline_y");

  CCTKi_ParameterCreate("out1D_xline_yi",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "y-index (from 0) for 1D lines in x-direction",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out1D_xline_yi),
                        0,
                        NULL,
                        2,
                        "0:*", "An index between [0, ny)",
                        "-1:", "Choose the default from IO::out_xline_yi");

  CCTKi_ParameterCreate("out1D_xline_z",
                        "IOASCII",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "z-coord for 1D lines in x-direction",
                        "-424242",
                        &(PRIVATE_IOASCII_STRUCT.out1D_xline_z),
                        0,
                        NULL,
                        2,
                        "*:*", "A value between [zmin, zmax]",
                        "-424242:", "Default to IO::out_xline_z");

  CCTKi_ParameterCreate("out1D_xline_zi",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "z-index (from 0) for 1D lines in x-direction",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out1D_xline_zi),
                        0,
                        NULL,
                        2,
                        "0:*", "An index between [0, nz)",
                        "-1:", "Choose the default from IO::out_xline_zi");

  CCTKi_ParameterCreate("out1D_y",
                        "IOASCII",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Do 1D IOASCII output in the y-direction",
                        "yes",
                        &(PRIVATE_IOASCII_STRUCT.out1D_y),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("out1D_yline_x",
                        "IOASCII",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "x-coord for 1D lines in y-direction",
                        "-424242",
                        &(PRIVATE_IOASCII_STRUCT.out1D_yline_x),
                        0,
                        NULL,
                        2,
                        "*:*", "A value between [xmin, xmax]",
                        "-424242:", "Default to IO::out_yline_x");

  CCTKi_ParameterCreate("out1D_yline_xi",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "x-index (from 0) for 1D lines in y-direction",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out1D_yline_xi),
                        0,
                        NULL,
                        2,
                        "0:*", "An index between [0, nx)",
                        "-1:", "Choose the default from IO::out_yline_xi");

  CCTKi_ParameterCreate("out1D_yline_z",
                        "IOASCII",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "z-coord for 1D lines in y-direction",
                        "-424242",
                        &(PRIVATE_IOASCII_STRUCT.out1D_yline_z),
                        0,
                        NULL,
                        2,
                        "*:*", "A value between [zmin, zmax]",
                        "-424242:", "Default to IO::out_yline_z");

  CCTKi_ParameterCreate("out1D_yline_zi",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "z-index (from 0) for 1D lines in y-direction",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out1D_yline_zi),
                        0,
                        NULL,
                        2,
                        "0:*", "An index between [0, nz)",
                        "-1:", "Choose the default from IO::out_yline_zi");

  CCTKi_ParameterCreate("out1D_z",
                        "IOASCII",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Do 1D IOASCII output in the z-direction",
                        "yes",
                        &(PRIVATE_IOASCII_STRUCT.out1D_z),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("out1D_zline_x",
                        "IOASCII",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "x-coord for 1D lines in z-direction",
                        "-424242",
                        &(PRIVATE_IOASCII_STRUCT.out1D_zline_x),
                        0,
                        NULL,
                        2,
                        "*:*", "A value between [xmin, xmax]",
                        "-424242:", "Default to IO::out_zline_x");

  CCTKi_ParameterCreate("out1D_zline_xi",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "x-index (from 0) for 1D lines in z-direction",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out1D_zline_xi),
                        0,
                        NULL,
                        2,
                        "0:*", "An index between [0, nx)",
                        "-1:", "Choose the default from IO::out_zline_xi");

  CCTKi_ParameterCreate("out1D_zline_y",
                        "IOASCII",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "y-coord for 1D lines in z-direction",
                        "-424242",
                        &(PRIVATE_IOASCII_STRUCT.out1D_zline_y),
                        0,
                        NULL,
                        2,
                        "*:*", "A value between [ymin, ymax]",
                        "-424242:", "Default to IO::out_zline_y");

  CCTKi_ParameterCreate("out1D_zline_yi",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "y-index (from 0) for 1D lines in z-direction",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out1D_zline_yi),
                        0,
                        NULL,
                        2,
                        "0:*", "An index between [0, ny)",
                        "-1:", "Choose the default from IO::out_zline_yi");

  CCTKi_ParameterCreate("out2D_dir",
                        "IOASCII",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Output directory for 2D IOASCII files, overrides out_dir",
                        "",
                        &(PRIVATE_IOASCII_STRUCT.out2D_dir),
                        0,
                        NULL,
                        2,
                        ".+", "A valid directory name",
                        "^$", "An empty string to choose the default from IO::out_dir");

  CCTKi_ParameterCreate("out2D_every",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "How often to do 2D IOASCII output, overrides IO::out_every",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out2D_every),
                        0,
                        NULL,
                        3,
                        "1:*", "Every so many iterations",
                        "0:", "Disable 2D IOASCII output",
                        "-1:", "Default to IO::out_every");

  CCTKi_ParameterCreate("out2D_style",
                        "IOASCII",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Which style for 2D slices IOASCII output",
                        "gnuplot f(x,y)",
                        &(PRIVATE_IOASCII_STRUCT.out2D_style),
                        0,
                        NULL,
                        2,
                        "gnuplot f(x,y)", "f over x,y plots suitable for gnuplot",
                        "gnuplot f(t,x,y)", "f over t,x,y plots suitable for gnuplot");

  CCTKi_ParameterCreate("out2D_vars",
                        "IOASCII",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Variables to output in 2D IOASCII file format",
                        "",
                        &(PRIVATE_IOASCII_STRUCT.out2D_vars),
                        0,
                        NULL,
                        2,
                        ".+", "Space-separated list of fully qualified variable/group names",
                        "^$", "An empty string to output nothing");

  CCTKi_ParameterCreate("out2D_xyplane_z",
                        "IOASCII",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "z-coord for 2D planes in xy",
                        "-424242",
                        &(PRIVATE_IOASCII_STRUCT.out2D_xyplane_z),
                        0,
                        NULL,
                        2,
                        "*:*", "A value between [zmin, zmax]",
                        "-424242:", "Default to IO::out_xyplane_z");

  CCTKi_ParameterCreate("out2D_xyplane_zi",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "z-index (from 0) for 2D planes in xy",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out2D_xyplane_zi),
                        0,
                        NULL,
                        2,
                        "0:*", "An index between [0, nz)",
                        "-1:", "Choose the default from IO::out_xyplane_zi");

  CCTKi_ParameterCreate("out2D_xzplane_y",
                        "IOASCII",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "y-coord for 2D planes in xz",
                        "-424242",
                        &(PRIVATE_IOASCII_STRUCT.out2D_xzplane_y),
                        0,
                        NULL,
                        2,
                        "*:*", "A value between [ymin, ymax]",
                        "-424242:", "Default to IO::out_xzplane_y");

  CCTKi_ParameterCreate("out2D_xzplane_yi",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "y-index (from 0) for 2D planes in xz",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out2D_xzplane_yi),
                        0,
                        NULL,
                        2,
                        "0:*", "An index between [0, ny)",
                        "-1:", "Choose the default from IO::out_xzplane_yi");

  CCTKi_ParameterCreate("out2D_yzplane_x",
                        "IOASCII",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "x-coord for 2D planes in yz",
                        "-424242",
                        &(PRIVATE_IOASCII_STRUCT.out2D_yzplane_x),
                        0,
                        NULL,
                        2,
                        "*:*", "A value between [xmin, xmax]",
                        "-424242:", "Default to IO::out_yzplane_x");

  CCTKi_ParameterCreate("out2D_yzplane_xi",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "x-index (from 0) for 2D planes in yz",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out2D_yzplane_xi),
                        0,
                        NULL,
                        2,
                        "0:*", "An index between [0, nx)",
                        "-1:", "Choose the default from IO::out_yzplane_xi");

  CCTKi_ParameterCreate("out3D_dir",
                        "IOASCII",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Output directory for 3D IOASCII files, overrides IO::out_dir",
                        "",
                        &(PRIVATE_IOASCII_STRUCT.out3D_dir),
                        0,
                        NULL,
                        2,
                        ".+", "A valid directory name",
                        "^$", "An empty string to choose the default from IO::out_dir");

  CCTKi_ParameterCreate("out3D_every",
                        "IOASCII",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "How often to do 3D IOASCII output, overrides IO::out_every",
                        "-1",
                        &(PRIVATE_IOASCII_STRUCT.out3D_every),
                        0,
                        NULL,
                        3,
                        "1:*", "Every so many iterations",
                        "0:", "Disable 3D IOASCII output",
                        "-1:", "Default to IO::out_every");

  CCTKi_ParameterCreate("out3D_style",
                        "IOASCII",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Which style for 3D volume IOASCII output",
                        "gnuplot f(x,y,z)",
                        &(PRIVATE_IOASCII_STRUCT.out3D_style),
                        0,
                        NULL,
                        2,
                        "gnuplot f(x,y,z)", "f over x,y,z plots suitable for gnuplot",
                        "gnuplot f(t,x,y,z)", "f over t,x,y,z plots suitable for gnuplot");

  CCTKi_ParameterCreate("out3D_vars",
                        "IOASCII",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Variables to output in 3D IOASCII file format",
                        "",
                        &(PRIVATE_IOASCII_STRUCT.out3D_vars),
                        0,
                        NULL,
                        2,
                        ".+", "Space-separated list of fully qualified variable/group names",
                        "^$", "An empty string to output nothing");

  CCTKi_ParameterCreate("out_format",
                        "IOASCII",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Which format for IOASCII floating-point number output",
                        ".13f",
                        &(PRIVATE_IOASCII_STRUCT.out_format),
                        0,
                        NULL,
                        1,
                        "^(\\.[1]?[0-9])?[EGefg]$", "output with given precision in exponential / floating point notation");

  return 0;
}

int CCTKi_BindingsIOASCIIParameterExtensions(void);
int CCTKi_BindingsIOASCIIParameterExtensions(void)
{
  return 0;
}
