/*@@
   @file       ScheduleMoL.c
   @author     Automatically generated by CreateScheduleBindings.pl
   @desc
               Creates the schedule and parameter recovery bindings 
               for thorn MoL
   @enddesc
@@*/


#ifdef SPEC 
#include "MoL/cctk.h" 
#define THORN_DIR "MoL" 
#else 
#include "MoL/cctk.h"
#endif /* END SPEC */ 
#include "MoL/CParameters.h"
#include "cctki_ScheduleBindings.h"
#include "MoL/cctk_ScheduleFunctions.h"

/* Prototypes for Fortran schedule bindings functions to be registered */
/* Note that this is a cheat, we just need a function pointer. */


void CCTKi_BindingsSchedule_MoL(void);
void CCTKi_BindingsSchedule_MoL(void)
{
  DECLARE_CCTK_PARAMETERS
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::MoL_Counters")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::MoL_Counters", CCTK_MaxTimeLevels("MoL::MoL_Counters"));
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::MoL_Original_Time")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::MoL_Original_Time", CCTK_MaxTimeLevels("MoL::MoL_Original_Time"));
  CCTKi_ScheduleGroupStorage("MoL::MoL_Counters",1);
  CCTKi_ScheduleGroupStorage("MoL::MoL_Original_Time",1);
if (MoL_Memory_Always_On)
{
  if (MoL_Num_Evolved_Vars)
  {
    if (MoL_Num_Scratch_Levels) 
    {
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ScratchSpace")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::ScratchSpace", CCTK_MaxTimeLevels("MoL::ScratchSpace"));
  CCTKi_ScheduleGroupStorage("MoL::ScratchSpace",1);
      if (MoL_Max_Evolved_Array_Size)
      {
      }
    }
  }
  else if (MoL_Num_Scratch_Levels) 
  {
    if (MoL_Max_Evolved_Array_Size)
    {
    }
  }
  if (MoL_Num_SaveAndRestore_Vars)
  {
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::SandRScratchSpace")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::SandRScratchSpace", CCTK_MaxTimeLevels("MoL::SandRScratchSpace"));
  CCTKi_ScheduleGroupStorage("MoL::SandRScratchSpace",1);
  }  
  if (MoL_Max_Evolved_Array_Size)
  {
  }
}
if (CCTK_Equals(ODE_Method,"Generic"))
{
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::RKAlphaCoefficients")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::RKAlphaCoefficients", CCTK_MaxTimeLevels("MoL::RKAlphaCoefficients"));
  CCTKi_ScheduleGroupStorage("MoL::RKAlphaCoefficients",1);
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::RKBetaCoefficients")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::RKBetaCoefficients", CCTK_MaxTimeLevels("MoL::RKBetaCoefficients"));
  CCTKi_ScheduleGroupStorage("MoL::RKBetaCoefficients",1);
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_Startup,
                           "MoL_Startup",
                           "MoL",
                           "MethodOfLines",
                           "Startup banner",
                           "CCTK_STARTUP",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_ParamCheck,
                           "MoL_ParamCheck",
                           "MoL",
                           "MethodOfLines",
                           "Basic parameter checking",
                           "CCTK_PARAMCHECK",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_SetupIndexArrays,
                           "MoL_SetupIndexArrays",
                           "MoL",
                           "MethodOfLines",
                           "Set up the MoL bookkeeping index arrays",
                           "CCTK_WRAGH",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "");
  }
if (CCTK_Equals(ODE_Method,"Generic"))
{
  {
    int cctkschedulei_tlevelarray[] = {1,1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::RKAlphaCoefficients")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::RKAlphaCoefficients", CCTK_MaxTimeLevels("MoL::RKAlphaCoefficients"));
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::RKBetaCoefficients")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::RKBetaCoefficients", CCTK_MaxTimeLevels("MoL::RKBetaCoefficients"));
    CCTKi_ScheduleFunction((void *)MoL_SetupRKCoefficients,
                           "MoL_SetupRKCoefficients",
                           "MoL",
                           "MethodOfLines",
                           "Initialize the generic Runge-Kutta coefficients",
                           "CCTK_WRAGH",
                           "C",
                           2,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "MoL::RKAlphaCoefficients",
                           "MoL::RKBetaCoefficients",
                           "GLOBAL",
                           "");
  }
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_SetScheduleStatus,
                           "MoL_SetScheduleStatus",
                           "MoL",
                           "MethodOfLines",
                           "Set the flag so it is ok to register with MoL",
                           "CCTK_WRAGH",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "GLOBAL",
                           "",
                           "MoL_SetupIndexArrays");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_Register",
"MoL_Register",
                        "MoL",
                        "MethodOfLines",
                        "The group where physics thorns register variables with MoL",
                        "CCTK_WRAGH",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_SetScheduleStatus");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_ReportNumberVariables,
                           "MoL_ReportNumberVariables",
                           "MoL",
                           "MethodOfLines",
                           "Report how many of each type of variable there are",
                           "CCTK_WRAGH",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "META",
                           "",
                           "MoL_Register");
  }
if (initial_data_is_crap)
{
  if (copy_ID_after_MoL_PostStep)
  {
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_FillAllLevels,
                           "MoL_FillAllLevels",
                           "MoL",
                           "MethodOfLines",
                           "A bad routine. Fills all previous timelevels with data copied from the current.",
                           "CCTK_POSTINITIAL",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep");
  }
  }
  else
  {
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_FillAllLevels,
                           "MoL_FillAllLevels",
                           "MoL",
                           "MethodOfLines",
                           "A bad routine. Fills all previous timelevels with data copied from the current.",
                           "CCTK_POSTINITIAL",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep");
  }
  }
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_StartLoop,
                           "MoL_StartLoop",
                           "MoL",
                           "MethodOfLines",
                           "Initialise the step size control",
                           "CCTK_EVOL",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "",
                           "MoL_Evolution");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_StartLoop,
                           "MoL_StartLoop",
                           "MoL",
                           "MethodOfLines",
                           "Initialise the step size control",
                           "CCTK_INITIAL",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "");
  }
if (MoL_Num_Scratch_Levels)
{
  if (MoL_Num_Evolved_Vars)
  {
    if (MoL_Num_SaveAndRestore_Vars)
    {  
      if (MoL_Max_Evolved_Array_Size)
      {
  {
    int cctkschedulei_tlevelarray[] = {1,1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::ScratchSpace", CCTK_MaxTimeLevels("MoL::ScratchSpace"));
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::SandRScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::SandRScratchSpace", CCTK_MaxTimeLevels("MoL::SandRScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        2,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::ScratchSpace",
                        "MoL::SandRScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
      else
      {
  {
    int cctkschedulei_tlevelarray[] = {1,1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::ScratchSpace", CCTK_MaxTimeLevels("MoL::ScratchSpace"));
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::SandRScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::SandRScratchSpace", CCTK_MaxTimeLevels("MoL::SandRScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        2,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::ScratchSpace",
                        "MoL::SandRScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
    }
    else
    {
      if (MoL_Max_Evolved_Array_Size)
      {
  {
    int cctkschedulei_tlevelarray[] = {1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::ScratchSpace", CCTK_MaxTimeLevels("MoL::ScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        1,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::ScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
      else
      {
  {
    int cctkschedulei_tlevelarray[] = {1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::ScratchSpace", CCTK_MaxTimeLevels("MoL::ScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        1,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::ScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
    }
  }
  else 
  {
    if (MoL_Num_SaveAndRestore_Vars)
    {
      if (MoL_Max_Evolved_Array_Size)
      {
  {
    int cctkschedulei_tlevelarray[] = {1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::SandRScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::SandRScratchSpace", CCTK_MaxTimeLevels("MoL::SandRScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        1,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::SandRScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
      else
      {
  {
    int cctkschedulei_tlevelarray[] = {1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::SandRScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::SandRScratchSpace", CCTK_MaxTimeLevels("MoL::SandRScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        1,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::SandRScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
    }
    else
    {
      if (MoL_Max_Evolved_Array_Size)
      {
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
      else
      {
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
    }
  }
}
else 
{
  if (MoL_Num_Evolved_Vars)
  {
    if (MoL_Num_SaveAndRestore_Vars)
    {
      if (MoL_Max_Evolved_Array_Size)
      {
  {
    int cctkschedulei_tlevelarray[] = {1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::SandRScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::SandRScratchSpace", CCTK_MaxTimeLevels("MoL::SandRScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        1,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::SandRScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
      else
      {
  {
    int cctkschedulei_tlevelarray[] = {1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::SandRScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::SandRScratchSpace", CCTK_MaxTimeLevels("MoL::SandRScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        1,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::SandRScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
    }
    else
    {
      if (MoL_Max_Evolved_Array_Size)
      {
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
      else
      {
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
    }
  }
  else 
  {
    if (MoL_Num_SaveAndRestore_Vars)
    {
      if (MoL_Max_Evolved_Array_Size)
      {
  {
    int cctkschedulei_tlevelarray[] = {1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::SandRScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::SandRScratchSpace", CCTK_MaxTimeLevels("MoL::SandRScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        1,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::SandRScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
      else
      {
  {
    int cctkschedulei_tlevelarray[] = {1,0};
    if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::SandRScratchSpace")))
        CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                   "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                   "Value must be between 0 and %d (inclusive)",
                   1, "MoL::SandRScratchSpace", CCTK_MaxTimeLevels("MoL::SandRScratchSpace"));
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        1,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "MoL::SandRScratchSpace",
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
    }
    else
    {
      if (MoL_Max_Evolved_Array_Size)
      {
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
      else
      {
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_Evolution",
"MoL_Evolution",
                        "MoL",
                        "MethodOfLines",
                        "A single Cactus evolution step using MoL",
                        "CCTK_EVOL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL::MoL_Stepsize_Bad");
  }
      }
    }
  }
}
if (MoL_Num_Evolved_Vars_Slow)
{
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ScratchSpaceSlow")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::ScratchSpaceSlow", CCTK_MaxTimeLevels("MoL::ScratchSpaceSlow"));
  CCTKi_ScheduleGroupStorage("MoL::ScratchSpaceSlow",1);
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_StartStep",
"MoL_StartStep",
                        "MoL",
                        "MethodOfLines",
                        "MoL internal setup for the evolution step",
                        "MoL_Evolution",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_SetCounter,
                           "MoL_SetCounter",
                           "MoL",
                           "MethodOfLines",
                           "Set the counter for the ODE method to loop over",
                           "MoL_StartStep",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_SetTime,
                           "MoL_SetTime",
                           "MoL",
                           "MethodOfLines",
                           "Ensure the correct time and timestep are used",
                           "MoL_StartStep",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PreStep",
"MoL_PreStep",
                        "MoL",
                        "MethodOfLines",
                        "Physics thorns can schedule preloop setup routines in here",
                        "MoL_Evolution",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        1, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_Step",
                        "MoL_StartStep");
  }
if (!skip_initial_copy)
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_InitialCopy,
                           "MoL_InitialCopy",
                           "MoL",
                           "MethodOfLines",
                           "Ensure the data is in the correct timelevel",
                           "MoL_Evolution",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_Step",
                           "MoL_PreStep");
  }
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_Step",
"MoL_Step",
                        "MoL",
                        "MethodOfLines",
                        "The loop over the intermediate steps for the ODE integrator",
                        "MoL_Evolution",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        1, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_PreStep",
                        "MoL::MoL_Intermediate_Step");
  }
if (CCTK_Equals(ODE_Method,"ICN-avg")) 
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_ICNAverage,
                           "MoL_Prepare",
                           "MoL",
                           "MethodOfLines",
                           "Averages the time levels for the averaging ICN method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_CalcRHS");
  }
}
if (init_RHS_zero)
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_InitRHS,
                           "MoL_InitRHS",
                           "MoL",
                           "MethodOfLines",
                           "Initialise the RHS functions",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_CalcRHS");
  }
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_CalcRHS",
"MoL_CalcRHS",
                        "MoL",
                        "MethodOfLines",
                        "Physics thorns schedule the calculation of the discrete spatial operator in here",
                        "MoL_Step",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PostRHS",
"MoL_PostRHS",
                        "MoL",
                        "MethodOfLines",
                        "Modify RHS functions",
                        "MoL_Step",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        2, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_NaNCheck",
                        "MoL_Add",
                        "MoL_CalcRHS");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_RHSBoundaries",
"MoL_RHSBoundaries",
                        "MoL",
                        "MethodOfLines",
                        "Any 'final' modifications to the RHS functions (boundaries etc.)",
                        "MoL_Step",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        2, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_NaNCheck",
                        "MoL_Add",
                        "MoL_PostRHS");
  }
if (MoL_NaN_Check)
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_NaNCheck,
                           "MoL_NaNCheck",
                           "MoL",
                           "MethodOfLines",
                           "Check the RHS GFs for NaNs",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_Add",
                           "MoL_CalcRHS");
  }
}
if (CCTK_Equals(ODE_Method,"Generic"))
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_GenericRKAdd,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with a generic method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           2, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_PostStepModify",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"Euler")) 
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_EulerAdd,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the Euler method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"RK2")) 
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RK2Add,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the efficient Runge-Kutta 2 method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"RK3")) 
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RK3Add,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the efficient Runge-Kutta 3 method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"RK4"))
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RK4Add,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the efficient Runge-Kutta 4 method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"RK45") || CCTK_Equals(ODE_Method,"RK45CK"))
{
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ErrorEstimate")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::ErrorEstimate", CCTK_MaxTimeLevels("MoL::ErrorEstimate"));
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ErrorScalars")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::ErrorScalars", CCTK_MaxTimeLevels("MoL::ErrorScalars"));
  CCTKi_ScheduleGroupStorage("MoL::ErrorEstimate",1);
  CCTKi_ScheduleGroupStorage("MoL::ErrorScalars",1);
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RK45Add,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the Runge-Kutta 45 method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"RK65")) 
{
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ErrorEstimate")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::ErrorEstimate", CCTK_MaxTimeLevels("MoL::ErrorEstimate"));
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ErrorScalars")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::ErrorScalars", CCTK_MaxTimeLevels("MoL::ErrorScalars"));
  CCTKi_ScheduleGroupStorage("MoL::ErrorEstimate",1);
  CCTKi_ScheduleGroupStorage("MoL::ErrorScalars",1);
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RK65Add,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the Runge-Kutta 65 method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"RK87")) 
{
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ErrorEstimate")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::ErrorEstimate", CCTK_MaxTimeLevels("MoL::ErrorEstimate"));
  if(!(1 >= 0 && 1  <= CCTK_MaxTimeLevels("MoL::ErrorScalars")))
      CCTK_VWarn(0, __LINE__, __FILE__, CCTK_THORNSTRING,
                 "Tried to schedule %d timelevels for group '%s' in schedule.ccl.\n"
                 "Value must be between 0 and %d (inclusive)",
                 1, "MoL::ErrorScalars", CCTK_MaxTimeLevels("MoL::ErrorScalars"));
  CCTKi_ScheduleGroupStorage("MoL::ErrorEstimate",1);
  CCTKi_ScheduleGroupStorage("MoL::ErrorScalars",1);
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RK87Add,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the Runge-Kutta 87 method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"ICN"))
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_ICNAdd,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the efficient ICN method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"ICN-avg"))
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_ICNAdd,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the averaging ICN method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"AB"))
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_ABAdd,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the Adams-Bashforth",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"RK2-MR-2:1")) 
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RK2_MR_2_1_Add,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the multirate Runge-Kutta 2 method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"RK4-MR-2:1")) 
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RK4_MR_2_1_Add,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the multirate Runge-Kutta 4 method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
else if (CCTK_Equals(ODE_Method,"RK4-RK2")) 
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RK4_RK2_Add,
                           "MoL_Add",
                           "MoL",
                           "MethodOfLines",
                           "Updates calculated with the multirate RK4/RK2 method",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_PostStep",
                           "MoL_CalcRHS");
  }
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PostStep",
"MoL_PostStep",
                        "MoL",
                        "MethodOfLines",
                        "The group for physics thorns to schedule boundary calls etc.",
                        "MoL_Step",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_Add");
  }
if (set_ID_boundaries)
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PostStep",
"MoL_PostStep",
                        "MoL",
                        "MethodOfLines",
                        "Ensure that everything is correct after the initial data have been set up",
                        "CCTK_POSTINITIAL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "");
  }
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PostStep",
"MoL_PostStep",
                        "MoL",
                        "MethodOfLines",
                        "Ensure that everything is correct after regridding",
                        "CCTK_POSTREGRID",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "");
  }
if (set_ID_boundaries)
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PostStep",
"MoL_PostStep",
                        "MoL",
                        "MethodOfLines",
                        "Ensure that everything is correct after restriction",
                        "CCTK_POSTRESTRICTINITIAL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "");
  }
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PostStep",
"MoL_PostStep",
                        "MoL",
                        "MethodOfLines",
                        "Ensure that everything is correct after restriction",
                        "CCTK_POSTRESTRICT",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "");
  }
if(run_MoL_PostStep_in_Post_Recover_Variables) {
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PostStep",
"MoL_PostStep",
                        "MoL",
                        "MethodOfLines",
                        "Ensure that everything is correct after recovery",
                        "CCTK_POST_RECOVER_VARIABLES",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "");
  }
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PostStepModify",
"MoL_PostStepModify",
                        "MoL",
                        "MethodOfLines",
                        "The group for physics thorns to schedule enforcing constraints",
                        "MoL_Step",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        1, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_PostStep",
                        "MoL_Add");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PostStepModify",
"MoL_PostStepModify",
                        "MoL",
                        "MethodOfLines",
                        "The group for physics thorns to schedule enforcing constraints",
                        "CCTK_POSTINITIAL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        1, /* Number of BEFORE   routines  */
                        0, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_PostStep");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PseudoEvolution",
"MoL_PseudoEvolution",
                        "MoL",
                        "MethodOfLines",
                        "Calculate pseudo-evolved quantities",
                        "CCTK_POSTINITIAL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_PostStep");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PseudoEvolution",
"MoL_PseudoEvolution",
                        "MoL",
                        "MethodOfLines",
                        "Calculate pseudo-evolved quantities",
                        "CCTK_EVOL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_Evolution");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PseudoEvolutionBoundaries",
"MoL_PseudoEvolutionBoundaries",
                        "MoL",
                        "MethodOfLines",
                        "Apply boundary conditions to pseudo-evolved quantities",
                        "CCTK_POSTREGRIDINITIAL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_PostStep");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PseudoEvolutionBoundaries",
"MoL_PseudoEvolutionBoundaries",
                        "MoL",
                        "MethodOfLines",
                        "Apply boundary conditions to pseudo-evolved quantities",
                        "CCTK_POSTREGRID",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_PostStep");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PseudoEvolutionBoundaries",
"MoL_PseudoEvolutionBoundaries",
                        "MoL",
                        "MethodOfLines",
                        "Apply boundary conditions to pseudo-evolved quantities",
                        "CCTK_POSTRESTRICTINITIAL",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_PostStep");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleGroup("MoL_PseudoEvolutionBoundaries",
"MoL_PseudoEvolutionBoundaries",
                        "MoL",
                        "MethodOfLines",
                        "Apply boundary conditions to pseudo-evolved quantities",
                        "CCTK_POSTRESTRICT",
                        0,  /* Number of STORAGE  groups   */
                        0,  /* Number of COMM     groups   */
                        0,  /* Number of TRIGGERS groups   */
                        0, /* Number of SYNC     groups    */
                        0, /* Number of WRITES clauses     */
                        0, /* Number of READS clauses      */
                        0, /* Number of Options            */
                        0, /* Number of BEFORE   routines  */
                        1, /* Number of AFTER    routines  */
                        0, /* Number of WHILE    variables */
                        0, /* Number of IF       variables */
                        cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                        "",
                        "MoL_PostStep");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_DecrementCounter,
                           "MoL_DecrementCounter",
                           "MoL",
                           "MethodOfLines",
                           "Alter the counter number",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           2, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "",
                           "MoL_PostStep",
                           "MoL_PostStepModify",
                           "MoL_Add");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_ResetTime,
                           "MoL_ResetTime",
                           "MoL",
                           "MethodOfLines",
                           "If necessary, change the time",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           2, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "",
                           "MoL_PostStep",
                           "MoL_PostStepModify",
                           "MoL_DecrementCounter");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_ResetDeltaTime,
                           "MoL_ResetDeltaTime",
                           "MoL",
                           "MethodOfLines",
                           "If necessary, change the timestep",
                           "MoL_Step",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           2, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "",
                           "MoL_PostStep",
                           "MoL_PostStepModify");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_RestoreSandR,
                           "MoL_RestoreSandR",
                           "MoL",
                           "MethodOfLines",
                           "Restoring the Save and Restore variables to the original state",
                           "MoL_Evolution",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           2, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_ReduceAdaptiveError",
                           "MoL_FinishLoop");
  }
if (adaptive_stepsize)
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_InitAdaptiveError,
                           "MoL_InitAdaptiveError",
                           "MoL",
                           "MethodOfLines",
                           "Control the step size: initialize error check variables",
                           "MoL_Evolution",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "",
                           "MoL_PostStep");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_FindAdaptiveError,
                           "MoL_FindAdaptiveError",
                           "MoL",
                           "MethodOfLines",
                           "Control the step size: compute error check variables",
                           "MoL_Evolution",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "MoL_InitAdaptiveError");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_ReduceAdaptiveError,
                           "MoL_ReduceAdaptiveError",
                           "MoL",
                           "MethodOfLines",
                           "Control the step size: reduce error check variables",
                           "MoL_Evolution",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "",
                           "MoL_FindAdaptiveError");
  }
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_SetEstimatedDt,
                           "MoL_SetEstimatedDt",
                           "MoL",
                           "MethodOfLines",
                           "Control the step size: set the new timestep",
                           "CCTK_POSTSTEP",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "");
  }
}
else
{
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_FinishLoop,
                           "MoL_FinishLoop",
                           "MoL",
                           "MethodOfLines",
                           "Control the step size",
                           "MoL_Evolution",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           1, /* Number of Options            */
                           0, /* Number of BEFORE   routines  */
                           1, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "LEVEL",
                           "",
                           "MoL_Step");
  }
}
  {
    int cctkschedulei_tlevelarray[] = {0};
    CCTKi_ScheduleFunction((void *)MoL_FreeIndexArrays,
                           "MoL_FreeIndexArrays",
                           "MoL",
                           "MethodOfLines",
                           "Free the MoL bookkeeping index arrays",
                           "CCTK_TERMINATE",
                           "C",
                           0,  /* Number of STORAGE  groups   */
                           0,  /* Number of COMM     groups   */
                           0,  /* Number of TRIGGERS groups   */
                           0, /* Number of SYNC     groups    */
                           0, /* Number of WRITES clauses     */
                           0, /* Number of READS clauses      */
                           0, /* Number of Options            */
                           1, /* Number of BEFORE   routines  */
                           0, /* Number of AFTER    routines  */
                           0, /* Number of WHILE    variables */
                           0, /* Number of IF       variables */
                           cctkschedulei_tlevelarray  /* Array of timelevel data for storage groups */,
                           "",
                           "Driver_Terminate");
  }
}

/*@@
  @routine    CCTKi_BindingsParameterRecovery_MoL
  @author     Automatically generated by CreateScheduleBindings.pl
  @desc
              Creates the parameter recovery bindings for thorn MoL
  @enddesc
@@*/

int CCTKi_BindingsParameterRecovery_MoL(void);
int CCTKi_BindingsParameterRecovery_MoL(void)
{
  /* this thorn doesn't define any parameter recovery routines */
  return (0);
}
