/*@@
   @file    MoL.c
   @author  Automatically generated by GridFuncStuff.pl
   @desc
            Creates the CCTK variables for thorn MoL
   @enddesc
 @@*/



#include <stddef.h>

#ifdef SPEC 
#include "MoL/cctk.h" 
#define THORN_DIR "MoL" 
#else 
#include "MoL/cctk.h"
#endif /* END SPEC */ 
#ifdef SPEC 
#include "MoL/cctk_Arguments.h" 
#else 
#include "MoL/cctk_Arguments.h"
#endif /* END SPEC */ 
#include "cctk_Parameter.h"
#include "cctk_WarnLevel.h"
#include "cctki_Groups.h"
#include "cctki_FortranWrappers.h"
#include "MoL/cctk_ScheduleFunctions.h"

int CactusBindingsVariables_MoL_Initialise(void);
static int CCTKi_BindingsFortranWrapperMoL(void *_GH, void *fpointer);

static int CCTKi_BindingsFortranWrapperMoL(void *_GH, void *fpointer)
{
  cGH const *const GH = _GH;
  const int _cctk_zero = 0;
  void (*function)(MOL_C2F_PROTO);
  DECLARE_MOL_C2F
  INITIALISE_MOL_C2F
  (void) (_cctk_zero + 0);

  function = (void (*) (MOL_C2F_PROTO)) fpointer;
  function (PASS_MOL_C2F (GH));

  return (0);
}

int CactusBindingsVariables_MoL_Initialise(void)
{
  const char * warn_mixeddim_gfs = "";
  int warn_mixeddim = 0;
  const CCTK_INT *allow_mixeddim_gfs;


  allow_mixeddim_gfs = CCTK_ParameterGet ("allow_mixeddim_gfs", "Cactus", 0);

  if (CCTKi_CreateGroup ("RKALPHACOEFFICIENTS", "MOL", "METHODOFLINES",
                         "ARRAY", "REAL", "PRIVATE",
                         2, 1,
                         "CONSTANT",
                         "MOL_INTERMEDIATE_STEPS,MOL_NUM_SCRATCH_LEVELS+1", "",
                         "Checkpoint=\"no\"",
                         NULL,
                         1,
                         "RKAlphaCoefficients") == 1)
  {
    warn_mixeddim_gfs = "RKAlphaCoefficients";
    warn_mixeddim = 2;
  }
  if (CCTKi_CreateGroup ("RKBETACOEFFICIENTS", "MOL", "METHODOFLINES",
                         "ARRAY", "REAL", "PRIVATE",
                         1, 1,
                         "CONSTANT",
                         "MOL_INTERMEDIATE_STEPS", "",
                         "Checkpoint=\"no\"",
                         NULL,
                         1,
                         "RKBetaCoefficients") == 1)
  {
    warn_mixeddim_gfs = "RKBetaCoefficients";
    warn_mixeddim = 1;
  }
  if (CCTKi_CreateGroup ("MOL_COUNTERS", "MOL", "METHODOFLINES",
                         "SCALAR", "INT", "PRIVATE",
                         0, 1,
                         "CONSTANT",
                         "", "",
                         "Checkpoint=\"no\"",
                         NULL,
                         4,
                         "MoL_Intermediate_Step",
                         "MoL_Stepsize_Bad",
                         "MoL_SlowStep",
                         "MoL_SlowPostStep") == 1)
  {
    warn_mixeddim_gfs = "MoL_Counters";
    warn_mixeddim = 0;
  }
  if (CCTKi_CreateGroup ("MOL_ORIGINAL_TIME", "MOL", "METHODOFLINES",
                         "SCALAR", "REAL", "PRIVATE",
                         0, 1,
                         "CONSTANT",
                         "", "",
                         "Checkpoint=\"no\"",
                         NULL,
                         2,
                         "Original_Time",
                         "Original_Delta_Time") == 1)
  {
    warn_mixeddim_gfs = "MoL_Original_Time";
    warn_mixeddim = 0;
  }
  if (CCTKi_CreateGroup ("SCRATCHSPACE", "MOL", "METHODOFLINES",
                         "GF", "REAL", "PRIVATE",
                         3, 1,
                         "DEFAULT",
                         "", "",
                         "Prolongation=\"None\" Checkpoint=\"no\"",
                         "MoL_Num_Evolved_Vars*MoL_Num_Scratch_Levels",
                         1,
                         "ScratchSpace") == 1)
  {
    warn_mixeddim_gfs = "ScratchSpace";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("SCRATCHSPACESLOW", "MOL", "METHODOFLINES",
                         "GF", "REAL", "PRIVATE",
                         3, 1,
                         "DEFAULT",
                         "", "",
                         "Prolongation=\"None\" Checkpoint=\"no\"",
                         "MoL_Num_Evolved_Vars_Slow*MoL_Num_Scratch_Levels",
                         1,
                         "ScratchSpaceSlow") == 1)
  {
    warn_mixeddim_gfs = "ScratchSpaceSlow";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("SANDRSCRATCHSPACE", "MOL", "METHODOFLINES",
                         "GF", "REAL", "PRIVATE",
                         3, 1,
                         "DEFAULT",
                         "", "",
                         "Prolongation=\"None\" Checkpoint=\"no\"",
                         "MoL_Num_SaveAndRestore_Vars",
                         1,
                         "SandRScratchSpace") == 1)
  {
    warn_mixeddim_gfs = "SandRScratchSpace";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("ERRORESTIMATE", "MOL", "METHODOFLINES",
                         "GF", "REAL", "PRIVATE",
                         3, 1,
                         "DEFAULT",
                         "", "",
                         "Prolongation=\"None\" Checkpoint=\"no\"",
                         "MoL_Num_Evolved_Vars",
                         1,
                         "ErrorEstimate") == 1)
  {
    warn_mixeddim_gfs = "ErrorEstimate";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("ERRORSCALARS", "MOL", "METHODOFLINES",
                         "SCALAR", "REAL", "PRIVATE",
                         0, 1,
                         "CONSTANT",
                         "", "",
                         "",
                         NULL,
                         3,
                         "Error",
                         "Count",
                         "EstimatedDt") == 1)
  {
    warn_mixeddim_gfs = "ErrorScalars";
    warn_mixeddim = 0;
  }

  if (*warn_mixeddim_gfs)
  {
    if (allow_mixeddim_gfs && *allow_mixeddim_gfs)
    {
      CCTK_VWarn (2, __LINE__, __FILE__, "Cactus",
                  "CCTKi_CreateGroup: Working dimension already set, "
                  "creating GF group '%s' with different dimension %d",
                  warn_mixeddim_gfs, warn_mixeddim);
    }
    else
    {
      CCTK_VWarn (0, __LINE__, __FILE__, "Cactus",
                  "CCTKi_CreateGroup: Working dimension already set, "
                  "cannot create GF group '%s' with dimension %d",
                  warn_mixeddim_gfs, warn_mixeddim);
    }
 }

  CCTKi_RegisterFortranWrapper("MoL", CCTKi_BindingsFortranWrapperMoL);

  return 0;
}
