/*@@
  @header   CDZCDK_guts.h
  @date     August 98
  @author   Gabrielle Allen
  @desc
  Macro to calculate the first covariant derivatives of the 
  extrinsic curvature with respect to y
  @enddesc
@@*/

#ifndef CDZCDK_GUTS
#define CDZCDK_GUTS

#include "DZDK_guts.h"
#include "CHR2_guts.h"

#ifdef FCODE 

      CDZCDK_CDZCDKXX = DZDK_DZDKXX - 2D0*(CHR2_XXZ*CDZCDK_KXX +  \
       CHR2_YXZ*CDZCDK_KXY + CHR2_ZXZ*CDZCDK_KXZ)

      CDZCDK_CDZCDKYY = DZDK_DZDKYY - 2D0*(CHR2_XYZ*CDZCDK_KXY +  \
       CHR2_YYZ*CDZCDK_KYY + CHR2_ZYZ*CDZCDK_KYZ)

      CDZCDK_CDZCDKZZ = DZDK_DZDKZZ - 2D0*(CHR2_XZZ*CDZCDK_KXZ +  \
       CHR2_YZZ*CDZCDK_KYZ + CHR2_ZZZ*CDZCDK_KZZ) 

      CDZCDK_CDZCDKXY = DZDK_DZDKXY-(CHR2_XYZ*CDZCDK_KXX) -  \
       (CHR2_XXZ + CHR2_YYZ)*CDZCDK_KXY  - CHR2_ZYZ*CDZCDK_KXZ -  \
       CHR2_YXZ*CDZCDK_KYY - CHR2_ZXZ*CDZCDK_KYZ

      CDZCDK_CDZCDKXZ = DZDK_DZDKXZ-(CHR2_XZZ*CDZCDK_KXX) - \
       CHR2_YZZ*CDZCDK_KXY - (CHR2_XXZ + CHR2_ZZZ)*CDZCDK_KXZ  \
       - CHR2_YXZ*CDZCDK_KYZ - CHR2_ZXZ*CDZCDK_KZZ

      CDZCDK_CDZCDKYZ = DZDK_DZDKYZ-(CHR2_XZZ*CDZCDK_KXY) -  \
       CHR2_XYZ*CDZCDK_KXZ - CHR2_YZZ*CDZCDK_KYY -  \
      (CHR2_YYZ + CHR2_ZZZ)*CDZCDK_KYZ - CHR2_ZYZ*CDZCDK_KZZ

#endif

#ifdef CCODE

      CDZCDK_CDZCDKXX = DZDK_DZDKXX - 2.*(CHR2_XXZ*CDZCDK_KXX + 
       CHR2_YXZ*CDZCDK_KXY + CHR2_ZXZ*CDZCDK_KXZ);

      CDZCDK_CDZCDKYY = DZDK_DZDKYY - 2.*(CHR2_XYZ*CDZCDK_KXY + 
       CHR2_YYZ*CDZCDK_KYY + CHR2_ZYZ*CDZCDK_KYZ);

      CDZCDK_CDZCDKZZ = DZDK_DZDKZZ - 2.*(CHR2_XZZ*CDZCDK_KXZ + 
       CHR2_YZZ*CDZCDK_KYZ + CHR2_ZZZ*CDZCDK_KZZ); 

      CDZCDK_CDZCDKXY = DZDK_DZDKXY-(CHR2_XYZ*CDZCDK_KXX) - 
       (CHR2_XXZ + CHR2_YYZ)*CDZCDK_KXY  - CHR2_ZYZ*CDZCDK_KXZ - 
       CHR2_YXZ*CDZCDK_KYY - CHR2_ZXZ*CDZCDK_KYZ;

      CDZCDK_CDZCDKXZ = DZDK_DZDKXZ-(CHR2_XZZ*CDZCDK_KXX) -
       CHR2_YZZ*CDZCDK_KXY - (CHR2_XXZ + CHR2_ZZZ)*CDZCDK_KXZ 
       - CHR2_YXZ*CDZCDK_KYZ - CHR2_ZXZ*CDZCDK_KZZ;

      CDZCDK_CDZCDKYZ = DZDK_DZDKYZ-(CHR2_XZZ*CDZCDK_KXY) - 
       CHR2_XYZ*CDZCDK_KXZ - CHR2_YZZ*CDZCDK_KYY - 
      (CHR2_YYZ + CHR2_ZZZ)*CDZCDK_KYZ - CHR2_ZYZ*CDZCDK_KZZ;

#endif

#endif
