#!/bin/bash
# Simple build script, potentially useful if building a GPL-redistributable
# version on a system *without* SPEC CPU2017.  See:
#
#     https://www.spec.org/cpu2017/Docs/licenses.html#GPLtarballs
#
# Note: if the benchmark uses "specpp", that is the freely-redistributable
#       preprocessor "filepp".   It is described at 
#         https://www.spec.org/cpu2017/Docs/utility.html#specpp  
#       and will need to be in your path.  You can find filepp sources as
#       modified by SPEC in redistributable_sources/modified/tools.src/harness-spec.tar.xz 
#---------------------------------------------------------------------------

/usr/bin/gcc     -std=c99   -m64 -c -o gnu/getopt.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  gnu/getopt.c
/usr/bin/gcc     -std=c99   -m64 -c -o gnu/getopt1.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  gnu/getopt1.c
/usr/bin/gcc     -std=c99   -m64 -c -o gnu/regex.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  gnu/regex.c
/usr/bin/gcc     -std=c99   -m64 -c -o ADMBase/InitSymBound.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ADMBase/InitSymBound.c
/usr/bin/gcc     -std=c99   -m64 -c -o ADMBase/Initialisation.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ADMBase/Initialisation.c
/usr/bin/gcc     -std=c99   -m64 -c -o ADMBase/ParamCheck.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ADMBase/ParamCheck.c
/usr/bin/gcc     -std=c99   -m64 -c -o ADMBase/Static.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ADMBase/Static.c
/usr/bin/gcc     -std=c99   -m64 -c -o ADMBase/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ADMBase/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o ADMCoupling/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ADMCoupling/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o ADMMacros/SetLocalSpatialOrder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ADMMacros/SetLocalSpatialOrder.c
/usr/bin/gcc     -std=c99   -m64 -c -o ADMMacros/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ADMMacros/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/Boundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/Boundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/Check.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/Check.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/CopyBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/CopyBoundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/FlatBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/FlatBoundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/NoneBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/NoneBoundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/RadiationBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/RadiationBoundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/Register.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/Register.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/RobinBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/RobinBoundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/ScalarBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/ScalarBoundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/StaticBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/StaticBoundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o Boundary/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Boundary/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/IO/FortranBindingsIO.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/IO/FortranBindingsIO.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/IO/IOMethods.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/IO/IOMethods.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/IO/OverloadIO.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/IO/OverloadIO.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/comm/CactusDefaultComm.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/comm/CactusDefaultComm.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/comm/CactusSync.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/comm/CactusSync.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/comm/Interp.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/comm/Interp.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/comm/OverloadComm.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/comm/OverloadComm.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/comm/Reduction.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/comm/Reduction.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/ActiveThorns.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/ActiveThorns.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Banner.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Banner.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/CactusDefaultEvolve.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/CactusDefaultEvolve.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/CactusDefaultInitialise.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/CactusDefaultInitialise.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/CactusDefaultMainLoopIndex.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/CactusDefaultMainLoopIndex.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/CactusDefaultShutdown.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/CactusDefaultShutdown.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/CallStartupFunctions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/CallStartupFunctions.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/CommandLine.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/CommandLine.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Complex.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Complex.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/ConfigData.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/ConfigData.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Coord.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Coord.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/DebugDefines.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/DebugDefines.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/DefaultTimers.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/DefaultTimers.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Dummies.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Dummies.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/FortranWrappers.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/FortranWrappers.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/GHExtensions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/GHExtensions.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Groups.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Groups.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/GroupsOnGH.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/GroupsOnGH.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/InitialiseCactus.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/InitialiseCactus.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/InitialiseDataStructures.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/InitialiseDataStructures.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/MainUtils.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/MainUtils.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Names.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Names.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/OverloadMain.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/OverloadMain.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/ProcessCommandLine.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/ProcessCommandLine.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/ProcessEnvironment.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/ProcessEnvironment.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/ProcessParameterDatabase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/ProcessParameterDatabase.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/ScheduleInterface.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/ScheduleInterface.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/SetParams.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/SetParams.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/SetupCache.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/SetupCache.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/ShutdownCactus.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/ShutdownCactus.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Subsystems.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Subsystems.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Termination.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Termination.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/Traverse.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/Traverse.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/main/WarnLevel.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/main/WarnLevel.c
/usr/bin/g++                -m64 -c -o Cactus/main/flesh.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/main/flesh.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/AutoGrammar.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/AutoGrammar.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Boundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Boundary.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Bracket.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Bracket.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Call.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Call.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Dot.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Dot.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/End.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/End.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Grammar.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Grammar.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Group.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Group.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/ILiteral.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/ILiteral.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Literal.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Literal.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Lookup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Lookup.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Matcher.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Matcher.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Multi.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Multi.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/NegLookAhead.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/NegLookAhead.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Or.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Or.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/ReParse.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/ReParse.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Seq.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Seq.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/Start.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/Start.cc
/usr/bin/g++                -m64 -c -o Cactus/piraha/smart_ptr.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  Cactus/piraha/smart_ptr.cc
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/schedule/ScheduleCreater.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/schedule/ScheduleCreater.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/schedule/ScheduleSorter.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/schedule/ScheduleSorter.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/schedule/ScheduleTraverse.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/schedule/ScheduleTraverse.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/Cache.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/Cache.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/CactusTimers.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/CactusTimers.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/Expression.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/Expression.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/File.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/File.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/Hash.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/Hash.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/Malloc.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/Malloc.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/Math.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/Math.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/Misc.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/Misc.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/Network.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/Network.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/ParseFile.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/ParseFile.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/RegisterKeyedFunction.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/RegisterKeyedFunction.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/SKBinTree.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/SKBinTree.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/StoreHandledData.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/StoreHandledData.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/StoreKeyedData.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/StoreKeyedData.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/StoreNamedData.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/StoreNamedData.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/String.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/String.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/StringList.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/StringList.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/Table.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/Table.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/Time.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/Time.c
/usr/bin/gcc     -std=c99   -m64 -c -o Cactus/util/snprintf.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Cactus/util/snprintf.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/ADMBase_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/ADMBase_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/AliasedFunctions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/AliasedFunctions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/Boundary_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/Boundary_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/CartGrid3D_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/CartGrid3D_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/CoordBase_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/CoordBase_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/GaugeWave_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/GaugeWave_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/GenericFD_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/GenericFD_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/IOASCII_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/IOASCII_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/IOBasic_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/IOBasic_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/IOUtil_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/IOUtil_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/IsFunctionAliased.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/IsFunctionAliased.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/ML_BSSN_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/ML_BSSN_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/ML_BSSN_Helper_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/ML_BSSN_Helper_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/MoL_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/MoL_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/PUGHInterp_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/PUGHInterp_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/PUGHSlab_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/PUGHSlab_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/RegisterThornFunctions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/RegisterThornFunctions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/StaticConformal_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/StaticConformal_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Functions/SymBase_Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Functions/SymBase_Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Implementations/ImplementationBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Implementations/ImplementationBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/ADMBase_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/ADMBase_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/ADMCoupling_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/ADMCoupling_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/ADMMacros_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/ADMMacros_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/BindingsParameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/BindingsParameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/Boundary_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/Boundary_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/Cactus_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/Cactus_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/CartGrid3D_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/CartGrid3D_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/CoordBase_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/CoordBase_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/CoordGauge_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/CoordGauge_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/Fortran_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/Fortran_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/GaugeWave_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/GaugeWave_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/GenericFD_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/GenericFD_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/Global.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/Global.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/IOASCII_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/IOASCII_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/IOBasic_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/IOBasic_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/IOUtil_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/IOUtil_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/LocalReduce_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/LocalReduce_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/ML_BSSN_Helper_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/ML_BSSN_Helper_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/ML_BSSN_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/ML_BSSN_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/MoL_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/MoL_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/PUGHInterp_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/PUGHInterp_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/PUGHReduce_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/PUGHReduce_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/PUGHSlab_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/PUGHSlab_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/PUGH_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/PUGH_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/StaticConformal_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/StaticConformal_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/SymBase_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/SymBase_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/Time_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/Time_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Parameters/TmunuBase_Parameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Parameters/TmunuBase_Parameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/BindingsParameterRecovery.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/BindingsParameterRecovery.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/BindingsSchedule.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/BindingsSchedule.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleADMBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleADMBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleADMCoupling.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleADMCoupling.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleADMMacros.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleADMMacros.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleBoundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleCactus.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleCactus.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleCartGrid3D.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleCartGrid3D.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleCoordBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleCoordBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleCoordGauge.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleCoordGauge.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleFortran.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleFortran.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleGaugeWave.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleGaugeWave.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleGenericFD.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleGenericFD.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleIOASCII.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleIOASCII.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleIOBasic.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleIOBasic.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleIOUtil.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleIOUtil.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleLocalReduce.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleLocalReduce.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleML_BSSN.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleML_BSSN.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleML_BSSN_Helper.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleML_BSSN_Helper.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleMoL.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleMoL.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/SchedulePUGH.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/SchedulePUGH.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/SchedulePUGHInterp.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/SchedulePUGHInterp.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/SchedulePUGHReduce.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/SchedulePUGHReduce.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/SchedulePUGHSlab.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/SchedulePUGHSlab.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleStaticConformal.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleStaticConformal.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleSymBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleSymBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleTime.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleTime.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Schedule/ScheduleTmunuBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Schedule/ScheduleTmunuBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/ADMBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/ADMBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/ADMCoupling.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/ADMCoupling.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/ADMMacros.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/ADMMacros.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/BindingsVariables.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/BindingsVariables.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/Boundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/Boundary.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/Cactus.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/Cactus.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/CartGrid3D.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/CartGrid3D.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/CoordBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/CoordBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/CoordGauge.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/CoordGauge.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/Fortran.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/Fortran.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/GaugeWave.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/GaugeWave.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/GenericFD.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/GenericFD.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/IOASCII.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/IOASCII.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/IOBasic.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/IOBasic.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/IOUtil.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/IOUtil.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/LocalReduce.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/LocalReduce.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/ML_BSSN.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/ML_BSSN.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/ML_BSSN_Helper.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/ML_BSSN_Helper.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/MoL.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/MoL.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/PUGH.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/PUGH.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/PUGHInterp.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/PUGHInterp.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/PUGHReduce.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/PUGHReduce.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/PUGHSlab.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/PUGHSlab.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/StaticConformal.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/StaticConformal.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/SymBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/SymBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/Time.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/Time.c
/usr/bin/gcc     -std=c99   -m64 -c -o CactusBindings/Variables/TmunuBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CactusBindings/Variables/TmunuBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o CartGrid3D/CartGrid3D.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CartGrid3D/CartGrid3D.c
/usr/bin/gcc     -std=c99   -m64 -c -o CartGrid3D/DecodeSymParameters.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CartGrid3D/DecodeSymParameters.c
/usr/bin/gcc     -std=c99   -m64 -c -o CartGrid3D/GetSymmetry.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CartGrid3D/GetSymmetry.c
/usr/bin/gcc     -std=c99   -m64 -c -o CartGrid3D/ParamCheck.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CartGrid3D/ParamCheck.c
/usr/bin/gcc     -std=c99   -m64 -c -o CartGrid3D/RegisterSymmetries.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CartGrid3D/RegisterSymmetries.c
/usr/bin/gcc     -std=c99   -m64 -c -o CartGrid3D/SetSymmetry.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CartGrid3D/SetSymmetry.c
/usr/bin/gcc     -std=c99   -m64 -c -o CartGrid3D/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CartGrid3D/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o CartGrid3D/Symmetry.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CartGrid3D/Symmetry.c
/usr/bin/gcc     -std=c99   -m64 -c -o CartGrid3D/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CartGrid3D/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o CoordBase/CoordBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CoordBase/CoordBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o CoordBase/Domain.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CoordBase/Domain.c
/usr/bin/gcc     -std=c99   -m64 -c -o CoordBase/GHExtension.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CoordBase/GHExtension.c
/usr/bin/gcc     -std=c99   -m64 -c -o CoordBase/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CoordBase/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o CoordGauge/Slicing.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CoordGauge/Slicing.c
/usr/bin/gcc     -std=c99   -m64 -c -o CoordGauge/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  CoordGauge/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_ActiveThorns.o -Iinclude -g Fortran/cctk_ActiveThorns.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Banner.o -Iinclude -g Fortran/cctk_Banner.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Cache.o -Iinclude -g Fortran/cctk_Cache.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Comm.o -Iinclude -g Fortran/cctk_Comm.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_CommandLine.o -Iinclude -g Fortran/cctk_CommandLine.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Complex.o -Iinclude -g Fortran/cctk_Complex.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Constants.o -Iinclude -g Fortran/cctk_Constants.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Coord.o -Iinclude -g Fortran/cctk_Coord.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_DebugDefines.o -Iinclude -g Fortran/cctk_DebugDefines.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Faces.o -Iinclude -g Fortran/cctk_Faces.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_File.o -Iinclude -g Fortran/cctk_File.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Flesh.o -Iinclude -g Fortran/cctk_Flesh.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_FortranString1.o -Iinclude -g Fortran/cctk_FortranString1.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_FortranWrappers.o -Iinclude -g Fortran/cctk_FortranWrappers.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_GHExtensions.o -Iinclude -g Fortran/cctk_GHExtensions.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_GNU.o -Iinclude -g Fortran/cctk_GNU.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Groups.o -Iinclude -g Fortran/cctk_Groups.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_GroupsOnGH.o -Iinclude -g Fortran/cctk_GroupsOnGH.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_IO.o -Iinclude -g Fortran/cctk_IO.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_IOMethods.o -Iinclude -g Fortran/cctk_IOMethods.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Interp.o -Iinclude -g Fortran/cctk_Interp.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Main.o -Iinclude -g Fortran/cctk_Main.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Malloc1.o -Iinclude -g Fortran/cctk_Malloc1.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Math.o -Iinclude -g Fortran/cctk_Math.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_MemAlloc.o -Iinclude -g Fortran/cctk_MemAlloc.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Misc.o -Iinclude -g Fortran/cctk_Misc.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_ParamCheck.o -Iinclude -g Fortran/cctk_ParamCheck.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Parameter.o -Iinclude -g Fortran/cctk_Parameter.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Reduction.o -Iinclude -g Fortran/cctk_Reduction.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Schedule.o -Iinclude -g Fortran/cctk_Schedule.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Sync.o -Iinclude -g Fortran/cctk_Sync.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Termination.o -Iinclude -g Fortran/cctk_Termination.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Timers.o -Iinclude -g Fortran/cctk_Timers.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Types.o -Iinclude -g Fortran/cctk_Types.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_Version.o -Iinclude -g Fortran/cctk_Version.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk_WarnLevel.o -Iinclude -g Fortran/cctk_WarnLevel.f90
/usr/bin/gfortran           -m64 -c -o Fortran/util_Table.o -Iinclude -g Fortran/util_Table.f90
/usr/bin/gfortran           -m64 -c -o Fortran/cctk.o -Iinclude -g Fortran/cctk.f90
/usr/bin/gcc     -std=c99   -m64 -c -o Fortran/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Fortran/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gfortran           -m64 -c -o Fortran/paramcheck.o -Iinclude -g Fortran/paramcheck.f90
/usr/bin/g++                -m64 -c -o GaugeWave/Boundaries.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  GaugeWave/Boundaries.cc
/usr/bin/g++                -m64 -c -o GaugeWave/GaugeWave_always.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  GaugeWave/GaugeWave_always.cc
/usr/bin/g++                -m64 -c -o GaugeWave/GaugeWave_initial.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  GaugeWave/GaugeWave_initial.cc
/usr/bin/g++                -m64 -c -o GaugeWave/ParamCheck.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  GaugeWave/ParamCheck.cc
/usr/bin/g++                -m64 -c -o GaugeWave/RegisterMoL.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  GaugeWave/RegisterMoL.cc
/usr/bin/g++                -m64 -c -o GaugeWave/RegisterSymmetries.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  GaugeWave/RegisterSymmetries.cc
/usr/bin/g++                -m64 -c -o GaugeWave/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  GaugeWave/Startup.cc
/usr/bin/gcc     -std=c99   -m64 -c -o GaugeWave/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  GaugeWave/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o GenericFD/GenericFD.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  GenericFD/GenericFD.c
/usr/bin/gcc     -std=c99   -m64 -c -o GenericFD/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  GenericFD/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOASCII/ChooseOutput.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOASCII/ChooseOutput.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOASCII/Output1D.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOASCII/Output1D.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOASCII/Output2D.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOASCII/Output2D.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOASCII/Output3D.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOASCII/Output3D.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOASCII/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOASCII/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOASCII/Write1D.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOASCII/Write1D.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOASCII/Write2D.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOASCII/Write2D.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOASCII/Write3D.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOASCII/Write3D.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOASCII/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOASCII/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOBasic/OutputInfo.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOBasic/OutputInfo.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOBasic/OutputScalar.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOBasic/OutputScalar.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOBasic/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOBasic/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOBasic/WriteInfo.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOBasic/WriteInfo.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOBasic/WriteScalar.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOBasic/WriteScalar.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOBasic/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOBasic/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOUtil/AdvertisedFiles.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOUtil/AdvertisedFiles.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOUtil/CheckpointRecovery.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOUtil/CheckpointRecovery.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOUtil/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOUtil/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOUtil/Utils.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOUtil/Utils.c
/usr/bin/gcc     -std=c99   -m64 -c -o IOUtil/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  IOUtil/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/AvgFunctions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/AvgFunctions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/CountFunctions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/CountFunctions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/MaxFunctions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/MaxFunctions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/MinFunctions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/MinFunctions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/Norm1Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/Norm1Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/Norm2Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/Norm2Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/Norm3Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/Norm3Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/Norm4Functions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/Norm4Functions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/NormInfFunctions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/NormInfFunctions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/Reduction.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/Reduction.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionAvg.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionAvg.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionCount.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionCount.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionMax.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionMax.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionMin.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionMin.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionNorm1.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionNorm1.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionNorm2.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionNorm2.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionNorm3.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionNorm3.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionNorm4.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionNorm4.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionNormInf.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionNormInf.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/ReductionSum.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/ReductionSum.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/SumFunctions.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/SumFunctions.c
/usr/bin/gcc     -std=c99   -m64 -c -o LocalReduce/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  LocalReduce/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/g++                -m64 -c -o ML_BSSN/Boundaries.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/Boundaries.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_Advect.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_Advect.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_Dissipation.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_Dissipation.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_InitGamma.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_InitGamma.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_InitRHS.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_InitRHS.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_Minkowski.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_Minkowski.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_RHS.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_RHS.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_RHSStaticBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_RHSStaticBoundary.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_boundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_boundary.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_constraints.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_constraints.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_convertFromADMBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_convertFromADMBase.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_convertFromADMBaseGamma.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_convertFromADMBaseGamma.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_convertToADMBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_convertToADMBase.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_convertToADMBaseDtLapseShift.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_convertToADMBaseDtLapseShift.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_convertToADMBaseDtLapseShiftBoundary.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_convertToADMBaseDtLapseShiftBoundary.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_convertToADMBaseFakeDtLapseShift.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_convertToADMBaseFakeDtLapseShift.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/ML_BSSN_enforce.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/ML_BSSN_enforce.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/RegisterMoL.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/RegisterMoL.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/RegisterSymmetries.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/RegisterSymmetries.cc
/usr/bin/g++                -m64 -c -o ML_BSSN/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  ML_BSSN/Startup.cc
/usr/bin/gcc     -std=c99   -m64 -c -o ML_BSSN/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ML_BSSN/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o ML_BSSN_Helper/ExtrapolateGammas.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ML_BSSN_Helper/ExtrapolateGammas.c
/usr/bin/gcc     -std=c99   -m64 -c -o ML_BSSN_Helper/NewRad.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ML_BSSN_Helper/NewRad.c
/usr/bin/gcc     -std=c99   -m64 -c -o ML_BSSN_Helper/RegisterConstrained.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ML_BSSN_Helper/RegisterConstrained.c
/usr/bin/gcc     -std=c99   -m64 -c -o ML_BSSN_Helper/RegisterSlicing.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ML_BSSN_Helper/RegisterSlicing.c
/usr/bin/gcc     -std=c99   -m64 -c -o ML_BSSN_Helper/SelectBCsADMBase.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ML_BSSN_Helper/SelectBCsADMBase.c
/usr/bin/gcc     -std=c99   -m64 -c -o ML_BSSN_Helper/SetGroupTags.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ML_BSSN_Helper/SetGroupTags.c
/usr/bin/gcc     -std=c99   -m64 -c -o ML_BSSN_Helper/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  ML_BSSN_Helper/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/AB.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/AB.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/ChangeType.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/ChangeType.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/Counter.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/Counter.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/Euler.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/Euler.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/GenericRK.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/GenericRK.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/ICN.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/ICN.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/IndexArrays.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/IndexArrays.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/InitialCopy.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/InitialCopy.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/Operators.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/Operators.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/ParamCheck.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/ParamCheck.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RHSNaNCheck.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RHSNaNCheck.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RK2-MR-2_1.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RK2-MR-2_1.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RK2.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RK2.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RK3.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RK3.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RK4-MR-2_1.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RK4-MR-2_1.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RK4-RK2.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RK4-RK2.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RK4.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RK4.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RK45.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RK45.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RK65.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RK65.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RK87.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RK87.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/RKCoefficients.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/RKCoefficients.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/Registration.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/Registration.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/SandR.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/SandR.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/SetTime.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/SetTime.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/StepSize.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/StepSize.c
/usr/bin/gcc     -std=c99   -m64 -c -o MoL/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  MoL/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/Comm.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/Comm.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/Evolve.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/Evolve.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/FinishReceiveGA.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/FinishReceiveGA.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/GHExtension.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/GHExtension.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/LoadAware.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/LoadAware.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/Overloadables.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/Overloadables.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/P2LMappings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/P2LMappings.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/PostReceiveGA.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/PostReceiveGA.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/PostSendGA.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/PostSendGA.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/PughUtils.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/PughUtils.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/Registration.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/Registration.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/SetupGroup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/SetupGroup.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/SetupPGH.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/SetupPGH.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/SetupPGV.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/SetupPGV.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/Storage.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/Storage.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/Topology.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/Topology.c
/usr/bin/g++                -m64 -c -o PUGH/Vectors.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -DCCTK_DISABLE_RESTRICT=1 -g         -DSPEC_LP64  PUGH/Vectors.cc
/usr/bin/gcc     -std=c99   -m64 -c -o PUGH/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGH/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHInterp/InterpGridArrays.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHInterp/InterpGridArrays.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHInterp/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHInterp/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHInterp/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHInterp/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReduceArraysGlobally.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReduceArraysGlobally.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReduceGA.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReduceGA.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/Reduction.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/Reduction.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionAvg.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionAvg.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionCount.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionCount.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionMax.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionMax.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionMin.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionMin.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionNorm1.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionNorm1.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionNorm2.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionNorm2.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionNorm3.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionNorm3.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionNorm4.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionNorm4.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionNormInf.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionNormInf.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/ReductionSum.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/ReductionSum.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHReduce/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHReduce/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHSlab/DatatypeConversion.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHSlab/DatatypeConversion.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHSlab/GetHyperslab.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHSlab/GetHyperslab.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHSlab/Mapping.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHSlab/Mapping.c
/usr/bin/gcc     -std=c99   -m64 -c -o PUGHSlab/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  PUGHSlab/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o StaticConformal/ConfPhys.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  StaticConformal/ConfPhys.c
/usr/bin/gcc     -std=c99   -m64 -c -o StaticConformal/Initialise.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  StaticConformal/Initialise.c
/usr/bin/gcc     -std=c99   -m64 -c -o StaticConformal/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  StaticConformal/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o SymBase/Check.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  SymBase/Check.c
/usr/bin/gcc     -std=c99   -m64 -c -o SymBase/Faces.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  SymBase/Faces.c
/usr/bin/gcc     -std=c99   -m64 -c -o SymBase/Handles.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  SymBase/Handles.c
/usr/bin/gcc     -std=c99   -m64 -c -o SymBase/Interpolation.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  SymBase/Interpolation.c
/usr/bin/gcc     -std=c99   -m64 -c -o SymBase/Startup.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  SymBase/Startup.c
/usr/bin/gcc     -std=c99   -m64 -c -o SymBase/Statistics.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  SymBase/Statistics.c
/usr/bin/gcc     -std=c99   -m64 -c -o SymBase/Table.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  SymBase/Table.c
/usr/bin/gcc     -std=c99   -m64 -c -o SymBase/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  SymBase/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o Time/Courant.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Time/Courant.c
/usr/bin/gcc     -std=c99   -m64 -c -o Time/Given.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Time/Given.c
/usr/bin/gcc     -std=c99   -m64 -c -o Time/Initialise.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Time/Initialise.c
/usr/bin/gcc     -std=c99   -m64 -c -o Time/Simple.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Time/Simple.c
/usr/bin/gcc     -std=c99   -m64 -c -o Time/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  Time/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gfortran           -m64 -c -o TmunuBase/CopyTmunu.o -Iinclude -g TmunuBase/CopyTmunu.f90
/usr/bin/gfortran           -m64 -c -o TmunuBase/SetStressEnergyState.o -Iinclude -g TmunuBase/SetStressEnergyState.f90
/usr/bin/gfortran           -m64 -c -o TmunuBase/SetTmunu.o -Iinclude -g TmunuBase/SetTmunu.f90
/usr/bin/gfortran           -m64 -c -o TmunuBase/ZeroTmunu.o -Iinclude -g TmunuBase/ZeroTmunu.f90
/usr/bin/gcc     -std=c99   -m64 -c -o TmunuBase/cctk_Bindings/cctk_ThornBindings.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  TmunuBase/cctk_Bindings/cctk_ThornBindings.c
/usr/bin/gcc     -std=c99   -m64 -c -o datestamp.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_SUPPRESS_OPENMP -Iinclude -DCCODE -g               -DSPEC_LP64  datestamp.c
/usr/bin/g++                -m64      -g          gnu/getopt.o gnu/getopt1.o gnu/regex.o ADMBase/InitSymBound.o ADMBase/Initialisation.o ADMBase/ParamCheck.o ADMBase/Static.o ADMBase/cctk_Bindings/cctk_ThornBindings.o ADMCoupling/cctk_Bindings/cctk_ThornBindings.o ADMMacros/SetLocalSpatialOrder.o ADMMacros/cctk_Bindings/cctk_ThornBindings.o Boundary/Boundary.o Boundary/Check.o Boundary/CopyBoundary.o Boundary/FlatBoundary.o Boundary/NoneBoundary.o Boundary/RadiationBoundary.o Boundary/Register.o Boundary/RobinBoundary.o Boundary/ScalarBoundary.o Boundary/StaticBoundary.o Boundary/cctk_Bindings/cctk_ThornBindings.o Cactus/IO/FortranBindingsIO.o Cactus/IO/IOMethods.o Cactus/IO/OverloadIO.o Cactus/cctk_Bindings/cctk_ThornBindings.o Cactus/comm/CactusDefaultComm.o Cactus/comm/CactusSync.o Cactus/comm/Interp.o Cactus/comm/OverloadComm.o Cactus/comm/Reduction.o Cactus/main/ActiveThorns.o Cactus/main/Banner.o Cactus/main/CactusDefaultEvolve.o Cactus/main/CactusDefaultInitialise.o Cactus/main/CactusDefaultMainLoopIndex.o Cactus/main/CactusDefaultShutdown.o Cactus/main/CallStartupFunctions.o Cactus/main/CommandLine.o Cactus/main/Complex.o Cactus/main/ConfigData.o Cactus/main/Coord.o Cactus/main/DebugDefines.o Cactus/main/DefaultTimers.o Cactus/main/Dummies.o Cactus/main/FortranWrappers.o Cactus/main/GHExtensions.o Cactus/main/Groups.o Cactus/main/GroupsOnGH.o Cactus/main/InitialiseCactus.o Cactus/main/InitialiseDataStructures.o Cactus/main/MainUtils.o Cactus/main/Names.o Cactus/main/OverloadMain.o Cactus/main/Parameters.o Cactus/main/ProcessCommandLine.o Cactus/main/ProcessEnvironment.o Cactus/main/ProcessParameterDatabase.o Cactus/main/ScheduleInterface.o Cactus/main/SetParams.o Cactus/main/SetupCache.o Cactus/main/ShutdownCactus.o Cactus/main/Subsystems.o Cactus/main/Termination.o Cactus/main/Traverse.o Cactus/main/WarnLevel.o Cactus/main/flesh.o Cactus/piraha/AutoGrammar.o Cactus/piraha/Boundary.o Cactus/piraha/Bracket.o Cactus/piraha/Call.o Cactus/piraha/Dot.o Cactus/piraha/End.o Cactus/piraha/Grammar.o Cactus/piraha/Group.o Cactus/piraha/ILiteral.o Cactus/piraha/Literal.o Cactus/piraha/Lookup.o Cactus/piraha/Matcher.o Cactus/piraha/Multi.o Cactus/piraha/NegLookAhead.o Cactus/piraha/Or.o Cactus/piraha/ReParse.o Cactus/piraha/Seq.o Cactus/piraha/Start.o Cactus/piraha/smart_ptr.o Cactus/schedule/ScheduleCreater.o Cactus/schedule/ScheduleSorter.o Cactus/schedule/ScheduleTraverse.o Cactus/util/Cache.o Cactus/util/CactusTimers.o Cactus/util/Expression.o Cactus/util/File.o Cactus/util/Hash.o Cactus/util/Malloc.o Cactus/util/Math.o Cactus/util/Misc.o Cactus/util/Network.o Cactus/util/ParseFile.o Cactus/util/RegisterKeyedFunction.o Cactus/util/SKBinTree.o Cactus/util/StoreHandledData.o Cactus/util/StoreKeyedData.o Cactus/util/StoreNamedData.o Cactus/util/String.o Cactus/util/StringList.o Cactus/util/Table.o Cactus/util/Time.o Cactus/util/snprintf.o CactusBindings/Functions/ADMBase_Functions.o CactusBindings/Functions/AliasedFunctions.o CactusBindings/Functions/Boundary_Functions.o CactusBindings/Functions/CartGrid3D_Functions.o CactusBindings/Functions/CoordBase_Functions.o CactusBindings/Functions/GaugeWave_Functions.o CactusBindings/Functions/GenericFD_Functions.o CactusBindings/Functions/IOASCII_Functions.o CactusBindings/Functions/IOBasic_Functions.o CactusBindings/Functions/IOUtil_Functions.o CactusBindings/Functions/IsFunctionAliased.o CactusBindings/Functions/ML_BSSN_Functions.o CactusBindings/Functions/ML_BSSN_Helper_Functions.o CactusBindings/Functions/MoL_Functions.o CactusBindings/Functions/PUGHInterp_Functions.o CactusBindings/Functions/PUGHSlab_Functions.o CactusBindings/Functions/RegisterThornFunctions.o CactusBindings/Functions/StaticConformal_Functions.o CactusBindings/Functions/SymBase_Functions.o CactusBindings/Implementations/ImplementationBindings.o CactusBindings/Parameters/ADMBase_Parameters.o CactusBindings/Parameters/ADMCoupling_Parameters.o CactusBindings/Parameters/ADMMacros_Parameters.o CactusBindings/Parameters/BindingsParameters.o CactusBindings/Parameters/Boundary_Parameters.o CactusBindings/Parameters/Cactus_Parameters.o CactusBindings/Parameters/CartGrid3D_Parameters.o CactusBindings/Parameters/CoordBase_Parameters.o CactusBindings/Parameters/CoordGauge_Parameters.o CactusBindings/Parameters/Fortran_Parameters.o CactusBindings/Parameters/GaugeWave_Parameters.o CactusBindings/Parameters/GenericFD_Parameters.o CactusBindings/Parameters/Global.o CactusBindings/Parameters/IOASCII_Parameters.o CactusBindings/Parameters/IOBasic_Parameters.o CactusBindings/Parameters/IOUtil_Parameters.o CactusBindings/Parameters/LocalReduce_Parameters.o CactusBindings/Parameters/ML_BSSN_Helper_Parameters.o CactusBindings/Parameters/ML_BSSN_Parameters.o CactusBindings/Parameters/MoL_Parameters.o CactusBindings/Parameters/PUGHInterp_Parameters.o CactusBindings/Parameters/PUGHReduce_Parameters.o CactusBindings/Parameters/PUGHSlab_Parameters.o CactusBindings/Parameters/PUGH_Parameters.o CactusBindings/Parameters/StaticConformal_Parameters.o CactusBindings/Parameters/SymBase_Parameters.o CactusBindings/Parameters/Time_Parameters.o CactusBindings/Parameters/TmunuBase_Parameters.o CactusBindings/Schedule/BindingsParameterRecovery.o CactusBindings/Schedule/BindingsSchedule.o CactusBindings/Schedule/ScheduleADMBase.o CactusBindings/Schedule/ScheduleADMCoupling.o CactusBindings/Schedule/ScheduleADMMacros.o CactusBindings/Schedule/ScheduleBoundary.o CactusBindings/Schedule/ScheduleCactus.o CactusBindings/Schedule/ScheduleCartGrid3D.o CactusBindings/Schedule/ScheduleCoordBase.o CactusBindings/Schedule/ScheduleCoordGauge.o CactusBindings/Schedule/ScheduleFortran.o CactusBindings/Schedule/ScheduleGaugeWave.o CactusBindings/Schedule/ScheduleGenericFD.o CactusBindings/Schedule/ScheduleIOASCII.o CactusBindings/Schedule/ScheduleIOBasic.o CactusBindings/Schedule/ScheduleIOUtil.o CactusBindings/Schedule/ScheduleLocalReduce.o CactusBindings/Schedule/ScheduleML_BSSN.o CactusBindings/Schedule/ScheduleML_BSSN_Helper.o CactusBindings/Schedule/ScheduleMoL.o CactusBindings/Schedule/SchedulePUGH.o CactusBindings/Schedule/SchedulePUGHInterp.o CactusBindings/Schedule/SchedulePUGHReduce.o CactusBindings/Schedule/SchedulePUGHSlab.o CactusBindings/Schedule/ScheduleStaticConformal.o CactusBindings/Schedule/ScheduleSymBase.o CactusBindings/Schedule/ScheduleTime.o CactusBindings/Schedule/ScheduleTmunuBase.o CactusBindings/Variables/ADMBase.o CactusBindings/Variables/ADMCoupling.o CactusBindings/Variables/ADMMacros.o CactusBindings/Variables/BindingsVariables.o CactusBindings/Variables/Boundary.o CactusBindings/Variables/Cactus.o CactusBindings/Variables/CartGrid3D.o CactusBindings/Variables/CoordBase.o CactusBindings/Variables/CoordGauge.o CactusBindings/Variables/Fortran.o CactusBindings/Variables/GaugeWave.o CactusBindings/Variables/GenericFD.o CactusBindings/Variables/IOASCII.o CactusBindings/Variables/IOBasic.o CactusBindings/Variables/IOUtil.o CactusBindings/Variables/LocalReduce.o CactusBindings/Variables/ML_BSSN.o CactusBindings/Variables/ML_BSSN_Helper.o CactusBindings/Variables/MoL.o CactusBindings/Variables/PUGH.o CactusBindings/Variables/PUGHInterp.o CactusBindings/Variables/PUGHReduce.o CactusBindings/Variables/PUGHSlab.o CactusBindings/Variables/StaticConformal.o CactusBindings/Variables/SymBase.o CactusBindings/Variables/Time.o CactusBindings/Variables/TmunuBase.o CartGrid3D/CartGrid3D.o CartGrid3D/DecodeSymParameters.o CartGrid3D/GetSymmetry.o CartGrid3D/ParamCheck.o CartGrid3D/RegisterSymmetries.o CartGrid3D/SetSymmetry.o CartGrid3D/Startup.o CartGrid3D/Symmetry.o CartGrid3D/cctk_Bindings/cctk_ThornBindings.o CoordBase/CoordBase.o CoordBase/Domain.o CoordBase/GHExtension.o CoordBase/cctk_Bindings/cctk_ThornBindings.o CoordGauge/Slicing.o CoordGauge/cctk_Bindings/cctk_ThornBindings.o Fortran/cctk.o Fortran/cctk_ActiveThorns.o Fortran/cctk_Banner.o Fortran/cctk_Bindings/cctk_ThornBindings.o Fortran/cctk_Cache.o Fortran/cctk_Comm.o Fortran/cctk_CommandLine.o Fortran/cctk_Complex.o Fortran/cctk_Constants.o Fortran/cctk_Coord.o Fortran/cctk_DebugDefines.o Fortran/cctk_Faces.o Fortran/cctk_File.o Fortran/cctk_Flesh.o Fortran/cctk_FortranString1.o Fortran/cctk_FortranWrappers.o Fortran/cctk_GHExtensions.o Fortran/cctk_GNU.o Fortran/cctk_Groups.o Fortran/cctk_GroupsOnGH.o Fortran/cctk_IO.o Fortran/cctk_IOMethods.o Fortran/cctk_Interp.o Fortran/cctk_Main.o Fortran/cctk_Malloc1.o Fortran/cctk_Math.o Fortran/cctk_MemAlloc.o Fortran/cctk_Misc.o Fortran/cctk_ParamCheck.o Fortran/cctk_Parameter.o Fortran/cctk_Reduction.o Fortran/cctk_Schedule.o Fortran/cctk_Sync.o Fortran/cctk_Termination.o Fortran/cctk_Timers.o Fortran/cctk_Types.o Fortran/cctk_Version.o Fortran/cctk_WarnLevel.o Fortran/paramcheck.o Fortran/util_Table.o GaugeWave/Boundaries.o GaugeWave/GaugeWave_always.o GaugeWave/GaugeWave_initial.o GaugeWave/ParamCheck.o GaugeWave/RegisterMoL.o GaugeWave/RegisterSymmetries.o GaugeWave/Startup.o GaugeWave/cctk_Bindings/cctk_ThornBindings.o GenericFD/GenericFD.o GenericFD/cctk_Bindings/cctk_ThornBindings.o IOASCII/ChooseOutput.o IOASCII/Output1D.o IOASCII/Output2D.o IOASCII/Output3D.o IOASCII/Startup.o IOASCII/Write1D.o IOASCII/Write2D.o IOASCII/Write3D.o IOASCII/cctk_Bindings/cctk_ThornBindings.o IOBasic/OutputInfo.o IOBasic/OutputScalar.o IOBasic/Startup.o IOBasic/WriteInfo.o IOBasic/WriteScalar.o IOBasic/cctk_Bindings/cctk_ThornBindings.o IOUtil/AdvertisedFiles.o IOUtil/CheckpointRecovery.o IOUtil/Startup.o IOUtil/Utils.o IOUtil/cctk_Bindings/cctk_ThornBindings.o LocalReduce/AvgFunctions.o LocalReduce/CountFunctions.o LocalReduce/MaxFunctions.o LocalReduce/MinFunctions.o LocalReduce/Norm1Functions.o LocalReduce/Norm2Functions.o LocalReduce/Norm3Functions.o LocalReduce/Norm4Functions.o LocalReduce/NormInfFunctions.o LocalReduce/Reduction.o LocalReduce/ReductionAvg.o LocalReduce/ReductionCount.o LocalReduce/ReductionMax.o LocalReduce/ReductionMin.o LocalReduce/ReductionNorm1.o LocalReduce/ReductionNorm2.o LocalReduce/ReductionNorm3.o LocalReduce/ReductionNorm4.o LocalReduce/ReductionNormInf.o LocalReduce/ReductionSum.o LocalReduce/Startup.o LocalReduce/SumFunctions.o LocalReduce/cctk_Bindings/cctk_ThornBindings.o ML_BSSN/Boundaries.o ML_BSSN/ML_BSSN_Advect.o ML_BSSN/ML_BSSN_Dissipation.o ML_BSSN/ML_BSSN_InitGamma.o ML_BSSN/ML_BSSN_InitRHS.o ML_BSSN/ML_BSSN_Minkowski.o ML_BSSN/ML_BSSN_RHS.o ML_BSSN/ML_BSSN_RHSStaticBoundary.o ML_BSSN/ML_BSSN_boundary.o ML_BSSN/ML_BSSN_constraints.o ML_BSSN/ML_BSSN_convertFromADMBase.o ML_BSSN/ML_BSSN_convertFromADMBaseGamma.o ML_BSSN/ML_BSSN_convertToADMBase.o ML_BSSN/ML_BSSN_convertToADMBaseDtLapseShift.o ML_BSSN/ML_BSSN_convertToADMBaseDtLapseShiftBoundary.o ML_BSSN/ML_BSSN_convertToADMBaseFakeDtLapseShift.o ML_BSSN/ML_BSSN_enforce.o ML_BSSN/RegisterMoL.o ML_BSSN/RegisterSymmetries.o ML_BSSN/Startup.o ML_BSSN/cctk_Bindings/cctk_ThornBindings.o ML_BSSN_Helper/ExtrapolateGammas.o ML_BSSN_Helper/NewRad.o ML_BSSN_Helper/RegisterConstrained.o ML_BSSN_Helper/RegisterSlicing.o ML_BSSN_Helper/SelectBCsADMBase.o ML_BSSN_Helper/SetGroupTags.o ML_BSSN_Helper/cctk_Bindings/cctk_ThornBindings.o MoL/AB.o MoL/ChangeType.o MoL/Counter.o MoL/Euler.o MoL/GenericRK.o MoL/ICN.o MoL/IndexArrays.o MoL/InitialCopy.o MoL/Operators.o MoL/ParamCheck.o MoL/RHSNaNCheck.o MoL/RK2-MR-2_1.o MoL/RK2.o MoL/RK3.o MoL/RK4-MR-2_1.o MoL/RK4-RK2.o MoL/RK4.o MoL/RK45.o MoL/RK65.o MoL/RK87.o MoL/RKCoefficients.o MoL/Registration.o MoL/SandR.o MoL/SetTime.o MoL/Startup.o MoL/StepSize.o MoL/cctk_Bindings/cctk_ThornBindings.o PUGH/Comm.o PUGH/Evolve.o PUGH/FinishReceiveGA.o PUGH/GHExtension.o PUGH/LoadAware.o PUGH/Overloadables.o PUGH/P2LMappings.o PUGH/PostReceiveGA.o PUGH/PostSendGA.o PUGH/PughUtils.o PUGH/Registration.o PUGH/SetupGroup.o PUGH/SetupPGH.o PUGH/SetupPGV.o PUGH/Startup.o PUGH/Storage.o PUGH/Topology.o PUGH/Vectors.o PUGH/cctk_Bindings/cctk_ThornBindings.o PUGHInterp/InterpGridArrays.o PUGHInterp/Startup.o PUGHInterp/cctk_Bindings/cctk_ThornBindings.o PUGHReduce/ReduceArraysGlobally.o PUGHReduce/ReduceGA.o PUGHReduce/Reduction.o PUGHReduce/ReductionAvg.o PUGHReduce/ReductionCount.o PUGHReduce/ReductionMax.o PUGHReduce/ReductionMin.o PUGHReduce/ReductionNorm1.o PUGHReduce/ReductionNorm2.o PUGHReduce/ReductionNorm3.o PUGHReduce/ReductionNorm4.o PUGHReduce/ReductionNormInf.o PUGHReduce/ReductionSum.o PUGHReduce/Startup.o PUGHReduce/cctk_Bindings/cctk_ThornBindings.o PUGHSlab/DatatypeConversion.o PUGHSlab/GetHyperslab.o PUGHSlab/Mapping.o PUGHSlab/cctk_Bindings/cctk_ThornBindings.o StaticConformal/ConfPhys.o StaticConformal/Initialise.o StaticConformal/cctk_Bindings/cctk_ThornBindings.o SymBase/Check.o SymBase/Faces.o SymBase/Handles.o SymBase/Interpolation.o SymBase/Startup.o SymBase/Statistics.o SymBase/Table.o SymBase/cctk_Bindings/cctk_ThornBindings.o Time/Courant.o Time/Given.o Time/Initialise.o Time/Simple.o Time/cctk_Bindings/cctk_ThornBindings.o TmunuBase/CopyTmunu.o TmunuBase/SetStressEnergyState.o TmunuBase/SetTmunu.o TmunuBase/ZeroTmunu.o TmunuBase/cctk_Bindings/cctk_ThornBindings.o datestamp.o                      -o cactusBSSN_r  
