/****************************************************************************
 *                  povmsrec.h
 *
 * This module contains all defines, typedefs, and prototypes for povmsrec.cpp
 *
 * from Persistence of Vision(tm) Ray Tracer version 3.6.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2009 Persistence of Vision Raytracer Pty. Ltd.
 *---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 *---------------------------------------------------------------------------
 * This program is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 *---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.6/source/povmsrec.h $
 * $Revision: #1 $
 * $Change: 5014 $
 * $DateTime: 2010/06/13 03:51:51 $
 * $Author: thorsten $
 * $Log$
 *****************************************************************************/


#ifndef POVMSRECEIVE_H
#define POVMSRECEIVE_H

BEGIN_POV_NAMESPACE


/*****************************************************************************
* Global preprocessor defines
******************************************************************************/


/*****************************************************************************
* Global typedefs
******************************************************************************/


/*****************************************************************************
* Global variables
******************************************************************************/


/*****************************************************************************
* Global functions
******************************************************************************/

int SetCommandOption(POVMSObjectPtr msg, POVMSType key, SHELLDATA *data);
int Receive_RenderOptions(POVMSObjectPtr msg, POVMSObjectPtr result, int mode, void *);
int Receive_RenderAll(POVMSObjectPtr msg, POVMSObjectPtr result, int mode, void *);
int Receive_RenderArea(POVMSObjectPtr msg, POVMSObjectPtr result, int mode, void *);
int Receive_RenderStop(POVMSObjectPtr msg, POVMSObjectPtr result, int mode, void *);

END_POV_NAMESPACE

#endif /* POVMSRECEIVE_H */
