
#ifndef __RNA_BLENDER_CPP_H__
#define __RNA_BLENDER_CPP_H__

/* Automatically generated classes for the Data API.
 * Do not edit manually, changes will be overwritten. */

#include "RNA_blender.h"
#include "RNA_types.h"
#include "RNA_access.h"

#include <string>
#include <string.h> /* for memcpy */

namespace BL {

#define BOOLEAN_PROPERTY(sname, identifier) \
	inline bool sname::identifier(void) { return sname##_##identifier##_get(&ptr) ? true: false; } \
	inline void sname::identifier(int value) { sname##_##identifier##_set(&ptr, value); }

#define BOOLEAN_ARRAY_PROPERTY(sname, size, identifier) \
	inline Array<int, size> sname::identifier(void) \
		{ Array<int, size> ar; sname##_##identifier##_get(&ptr, ar.data); return ar; } \
	inline void sname::identifier(int values[size]) \
		{ sname##_##identifier##_set(&ptr, values); } \

#define BOOLEAN_DYNAMIC_ARRAY_PROPERTY(sname, identifier) \
	inline DynamicArray<int> sname::identifier(void) { \
		int arraylen[3]; \
		int len = sname##_##identifier##_get_length(&ptr, arraylen); \
		DynamicArray<int> ar(len); \
		sname##_##identifier##_get(&ptr, ar.data); \
		return ar; } \
	inline void sname::identifier(int values[]) \
		{ sname##_##identifier##_set(&ptr, values); } \

#define INT_PROPERTY(sname, identifier) \
	inline int sname::identifier(void) { return sname##_##identifier##_get(&ptr); } \
	inline void sname::identifier(int value) { sname##_##identifier##_set(&ptr, value); }

#define INT_ARRAY_PROPERTY(sname, size, identifier) \
	inline Array<int, size> sname::identifier(void) \
		{ Array<int, size> ar; sname##_##identifier##_get(&ptr, ar.data); return ar; } \
	inline void sname::identifier(int values[size]) \
		{ sname##_##identifier##_set(&ptr, values); } \

#define INT_DYNAMIC_ARRAY_PROPERTY(sname, identifier) \
	inline DynamicArray<int> sname::identifier(void) { \
		int arraylen[3]; \
		int len = sname##_##identifier##_get_length(&ptr, arraylen); \
		DynamicArray<int> ar(len); \
		sname##_##identifier##_get(&ptr, ar.data); \
		return ar; } \
	inline void sname::identifier(int values[]) \
		{ sname##_##identifier##_set(&ptr, values); } \

#define FLOAT_PROPERTY(sname, identifier) \
	inline float sname::identifier(void) { return sname##_##identifier##_get(&ptr); } \
	inline void sname::identifier(float value) { sname##_##identifier##_set(&ptr, value); }

#define FLOAT_ARRAY_PROPERTY(sname, size, identifier) \
	inline Array<float, size> sname::identifier(void) \
		{ Array<float, size> ar; sname##_##identifier##_get(&ptr, ar.data); return ar; } \
	inline void sname::identifier(float values[size]) \
		{ sname##_##identifier##_set(&ptr, values); } \

#define FLOAT_DYNAMIC_ARRAY_PROPERTY(sname, identifier) \
	inline DynamicArray<float> sname::identifier(void) { \
		int arraylen[3]; \
		int len = sname##_##identifier##_get_length(&ptr, arraylen); \
		DynamicArray<float> ar(len); \
		sname##_##identifier##_get(&ptr, ar.data); \
		return ar; } \
	inline void sname::identifier(float values[]) \
		{ sname##_##identifier##_set(&ptr, values); } \

#define ENUM_PROPERTY(type, sname, identifier) \
	inline sname::type sname::identifier(void) { return (type)sname##_##identifier##_get(&ptr); } \
	inline void sname::identifier(sname::type value) { sname##_##identifier##_set(&ptr, value); }

#define STRING_PROPERTY(sname, identifier) \
	inline std::string sname::identifier(void) { \
		int len = sname##_##identifier##_length(&ptr); \
		std::string str; str.resize(len); \
		sname##_##identifier##_get(&ptr, &str[0]); return str; } \
	inline void sname::identifier(const std::string& value) { \
		sname##_##identifier##_set(&ptr, value.c_str()); } \

#define POINTER_PROPERTY(type, sname, identifier) \
	inline type sname::identifier(void) { return type(sname##_##identifier##_get(&ptr)); }

#define COLLECTION_PROPERTY_LENGTH_false(sname, identifier) \
	inline static int sname##_##identifier##_length_wrap(PointerRNA *ptr) \
	{ \
		CollectionPropertyIterator iter; \
		int length = 0; \
		sname##_##identifier##_begin(&iter, ptr); \
		while (iter.valid) { \
			sname##_##identifier##_next(&iter); \
			++length; \
		} \
		sname##_##identifier##_end(&iter); \
		return length; \
	} 
#define COLLECTION_PROPERTY_LENGTH_true(sname, identifier) \
	inline static int sname##_##identifier##_length_wrap(PointerRNA *ptr) \
	{ return sname##_##identifier##_length(ptr); } 

#define COLLECTION_PROPERTY_LOOKUP_INT_false(sname, identifier) \
	inline static int sname##_##identifier##_lookup_int_wrap(PointerRNA *ptr, int key, PointerRNA *r_ptr) \
	{ \
		CollectionPropertyIterator iter; \
		int i = 0, found = 0; \
		sname##_##identifier##_begin(&iter, ptr); \
		while (iter.valid) { \
			if (i == key) { \
				*r_ptr = iter.ptr; \
				found = 1; \
				break; \
			} \
			sname##_##identifier##_next(&iter); \
			++i; \
		} \
		sname##_##identifier##_end(&iter); \
		if (!found) \
			memset(r_ptr, 0, sizeof(*r_ptr)); \
		return found; \
	} 
#define COLLECTION_PROPERTY_LOOKUP_INT_true(sname, identifier) \
	inline static int sname##_##identifier##_lookup_int_wrap(PointerRNA *ptr, int key, PointerRNA *r_ptr) \
	{ \
		int found = sname##_##identifier##_lookup_int(ptr, key, r_ptr); \
		if (!found) \
			memset(r_ptr, 0, sizeof(*r_ptr)); \
		return found; \
	} 
#define COLLECTION_PROPERTY_LOOKUP_STRING_false(sname, identifier) \
	inline static int sname##_##identifier##_lookup_string_wrap(PointerRNA *ptr, const char *key, PointerRNA *r_ptr) \
	{ \
		CollectionPropertyIterator iter; \
		int found = 0; \
		PropertyRNA *item_name_prop = RNA_struct_name_property(ptr->type); \
		sname##_##identifier##_begin(&iter, ptr); \
		while (iter.valid && !found) { \
			char name_fixed[32]; \
			const char *name; \
			int name_length; \
			name = RNA_property_string_get_alloc(&iter.ptr, item_name_prop, name_fixed, sizeof(name_fixed), &name_length); \
			if (!strncmp(name, key, name_length)) { \
				*r_ptr = iter.ptr; \
				found = 1; \
			} \
			if (name_fixed != name) \
				MEM_freeN((void *) name); \
			sname##_##identifier##_next(&iter); \
		} \
		sname##_##identifier##_end(&iter); \
		if (!found) \
			memset(r_ptr, 0, sizeof(*r_ptr)); \
		return found; \
	} 
#define COLLECTION_PROPERTY_LOOKUP_STRING_true(sname, identifier) \
	inline static int sname##_##identifier##_lookup_string_wrap(PointerRNA *ptr, const char *key, PointerRNA *r_ptr) \
	{ \
		int found = sname##_##identifier##_lookup_string(ptr, key, r_ptr); \
		if (!found) \
			memset(r_ptr, 0, sizeof(*r_ptr)); \
		return found; \
	} 
#define COLLECTION_PROPERTY(collection_funcs, type, sname, identifier, has_length, has_lookup_int, has_lookup_string) \
	typedef CollectionIterator<type, sname##_##identifier##_begin, \
		sname##_##identifier##_next, sname##_##identifier##_end> identifier##_iterator; \
	COLLECTION_PROPERTY_LENGTH_##has_length(sname, identifier) \
	COLLECTION_PROPERTY_LOOKUP_INT_##has_lookup_int(sname, identifier) \
	COLLECTION_PROPERTY_LOOKUP_STRING_##has_lookup_string(sname, identifier) \
	Collection<sname, type, sname##_##identifier##_begin, \
		sname##_##identifier##_next, sname##_##identifier##_end, \
		sname##_##identifier##_length_wrap, \
		sname##_##identifier##_lookup_int_wrap, sname##_##identifier##_lookup_string_wrap, collection_funcs> identifier;

class Pointer {
public:
	Pointer(const PointerRNA &p) : ptr(p) { }
	operator const PointerRNA&() { return ptr; }
	bool is_a(StructRNA *type) { return RNA_struct_is_a(ptr.type, type) ? true: false; }
	operator void*() { return ptr.data; }
	operator bool() { return ptr.data != NULL; }

	PointerRNA ptr;
};


template<typename T, int Tsize>
class Array {
public:
	T data[Tsize];

	Array() {}
	Array(const Array<T, Tsize>& other) { memcpy(data, other.data, sizeof(T) * Tsize); }
	const Array<T, Tsize>& operator = (const Array<T, Tsize>& other) { memcpy(data, other.data, sizeof(T) * Tsize); return *this; }

	operator T*() { return data; }
};

template<typename T>
class DynamicArray {
public:
	T *data;
	int length;

	DynamicArray() : data(NULL), length(0) {}
	DynamicArray(int new_length) : data(NULL), length(new_length) { data = (float *)malloc(sizeof(T) * new_length); }
	DynamicArray(const DynamicArray<T>& other) { copy_from(other); }
	const DynamicArray<T>& operator = (const DynamicArray<T>& other) { copy_from(other); return *this; }

	~DynamicArray() { if (data) free(data); }

	operator T*() { return data; }

protected:
	void copy_from(const DynamicArray<T>& other) {
		if (data) free(data);
		data = (float *)malloc(sizeof(T) * other.length);
		memcpy(data, other.data, sizeof(T) * other.length);
		length = other.length;
	}
};

typedef void (*TBeginFunc)(CollectionPropertyIterator *iter, PointerRNA *ptr);
typedef void (*TNextFunc)(CollectionPropertyIterator *iter);
typedef void (*TEndFunc)(CollectionPropertyIterator *iter);
typedef int (*TLengthFunc)(PointerRNA *ptr);
typedef int (*TLookupIntFunc)(PointerRNA *ptr, int key, PointerRNA *r_ptr);
typedef int (*TLookupStringFunc)(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

template<typename T, TBeginFunc Tbegin, TNextFunc Tnext, TEndFunc Tend>
class CollectionIterator {
public:
	CollectionIterator() : t(iter.ptr), init(false) { iter.valid = false; }
	~CollectionIterator(void) { if (init) Tend(&iter); };

	operator bool(void)
	{ return iter.valid != 0; }
	const CollectionIterator<T, Tbegin, Tnext, Tend>& operator++() { Tnext(&iter); t = T(iter.ptr); return *this; }

	T& operator*(void) { return t; }
	T* operator->(void) { return &t; }
	bool operator == (const CollectionIterator<T, Tbegin, Tnext, Tend>& other) { return iter.valid == other.iter.valid; }
	bool operator!=(const CollectionIterator<T, Tbegin, Tnext, Tend>& other) { return iter.valid != other.iter.valid; }

	void begin(const Pointer &ptr)
	{ if (init) Tend(&iter); Tbegin(&iter, (PointerRNA *)&ptr.ptr); t = T(iter.ptr); init = true; }

private:
	const CollectionIterator<T, Tbegin, Tnext, Tend>& operator = (const CollectionIterator<T, Tbegin, Tnext, Tend>& copy) {}
	CollectionPropertyIterator iter;
	T t;
	bool init;
};

template<typename Tp, typename T, TBeginFunc Tbegin, TNextFunc Tnext, TEndFunc Tend,
         TLengthFunc Tlength, TLookupIntFunc Tlookup_int, TLookupStringFunc Tlookup_string,
         typename Tcollection_funcs>
class Collection : public Tcollection_funcs {
public:
	Collection(const PointerRNA &p) : Tcollection_funcs(p), ptr(p) {}

	void begin(CollectionIterator<T, Tbegin, Tnext, Tend>& iter)
	{ iter.begin(ptr); }
	CollectionIterator<T, Tbegin, Tnext, Tend> end()
	{ return CollectionIterator<T, Tbegin, Tnext, Tend>(); } /* test */ 
	int length()
	{ return Tlength(&ptr); }
	T operator[](int key)
	{ PointerRNA r_ptr; Tlookup_int(&ptr, key, &r_ptr); return T(r_ptr); }
	T operator[](const std::string &key)
	{ PointerRNA r_ptr; Tlookup_string(&ptr, key.c_str(), &r_ptr); return T(r_ptr); }

private:
	PointerRNA ptr;
};

class DefaultCollectionFunctions {
public:
	DefaultCollectionFunctions(const PointerRNA &p) {}
};


/**************** Declarations ****************/

class Struct;
class Property;
class BoolProperty;
class IntProperty;
class FloatProperty;
class StringProperty;
class EnumProperty;
class EnumPropertyItem;
class PointerProperty;
class CollectionProperty;
class Function;
class BlenderRNA;
class UnknownType;
class AnyType;
class ID;
class PropertyGroupItem;
class PropertyGroup;
class IDMaterials;
class Library;
class Texture;
class CloudsTexture;
class WoodTexture;
class MarbleTexture;
class MagicTexture;
class BlendTexture;
class StucciTexture;
class NoiseTexture;
class ImageTexture;
class EnvironmentMapTexture;
class MusgraveTexture;
class VoronoiTexture;
class DistortedNoiseTexture;
class PointDensity;
class PointDensityTexture;
class VoxelData;
class VoxelDataTexture;
class OceanTexData;
class OceanTexture;
class TextureSlot;
class EnvironmentMap;
class TexMapping;
class ColorMapping;
class Action;
class ActionFCurves;
class ActionGroups;
class ActionPoseMarkers;
class ActionGroup;
class DopeSheet;
class AnimData;
class NlaTracks;
class AnimDataDrivers;
class KeyingSet;
class KeyingSetPaths;
class KeyingSetPath;
class KeyingSetInfo;
class AnimViz;
class AnimVizOnionSkinning;
class AnimVizMotionPaths;
class MotionPath;
class MotionPathVert;
class Actuator;
class ActionActuator;
class ObjectActuator;
class CameraActuator;
class SoundActuator;
class PropertyActuator;
class ConstraintActuator;
class EditObjectActuator;
class SceneActuator;
class RandomActuator;
class MessageActuator;
class GameActuator;
class VisibilityActuator;
class Filter2DActuator;
class ParentActuator;
class StateActuator;
class ArmatureActuator;
class SteeringActuator;
class MouseActuator;
class Armature;
class ArmatureBones;
class ArmatureEditBones;
class Bone;
class EditBone;
class BoidRule;
class BoidRuleGoal;
class BoidRuleAvoid;
class BoidRuleAvoidCollision;
class BoidRuleFollowLeader;
class BoidRuleAverageSpeed;
class BoidRuleFight;
class BoidState;
class BoidSettings;
class Brush;
class BrushCapabilities;
class SculptToolCapabilities;
class ImapaintToolCapabilities;
class BrushTextureSlot;
class OperatorStrokeElement;
class Camera;
class ClothSettings;
class ClothCollisionSettings;
class CurveMapPoint;
class CurveMap;
class CurveMapPoints;
class CurveMapping;
class ColorRampElement;
class ColorRamp;
class ColorRampElements;
class Histogram;
class Scopes;
class ColorManagedDisplaySettings;
class ColorManagedViewSettings;
class ColorManagedInputColorspaceSettings;
class ColorManagedSequencerColorspaceSettings;
class Constraint;
class ConstraintTarget;
class ChildOfConstraint;
class PythonConstraint;
class StretchToConstraint;
class FollowPathConstraint;
class LockedTrackConstraint;
class ActionConstraint;
class CopyScaleConstraint;
class MaintainVolumeConstraint;
class CopyLocationConstraint;
class CopyRotationConstraint;
class CopyTransformsConstraint;
class FloorConstraint;
class TrackToConstraint;
class KinematicConstraint;
class RigidBodyJointConstraint;
class ClampToConstraint;
class LimitDistanceConstraint;
class LimitScaleConstraint;
class LimitRotationConstraint;
class LimitLocationConstraint;
class TransformConstraint;
class ShrinkwrapConstraint;
class DampedTrackConstraint;
class SplineIKConstraint;
class PivotConstraint;
class FollowTrackConstraint;
class CameraSolverConstraint;
class ObjectSolverConstraint;
class Context;
class Controller;
class ExpressionController;
class PythonController;
class AndController;
class OrController;
class NorController;
class NandController;
class XorController;
class XnorController;
class Curve;
class CurveSplines;
class SurfaceCurve;
class TextCurve;
class TextBox;
class TextCharacterFormat;
class SplinePoint;
class BezierSplinePoint;
class Spline;
class SplinePoints;
class SplineBezierPoints;
class DynamicPaintCanvasSettings;
class DynamicPaintSurfaces;
class DynamicPaintBrushSettings;
class DynamicPaintSurface;
class FCurve;
class FCurveKeyframePoints;
class FCurveModifiers;
class Keyframe;
class FCurveSample;
class DriverTarget;
class DriverVariable;
class Driver;
class ChannelDriverVariables;
class FModifier;
class FModifierGenerator;
class FModifierFunctionGenerator;
class FModifierEnvelope;
class FModifierEnvelopeControlPoints;
class FModifierEnvelopeControlPoint;
class FModifierCycles;
class FModifierPython;
class FModifierLimits;
class FModifierNoise;
class FModifierStepped;
class FluidSettings;
class DomainFluidSettings;
class FluidMeshVertex;
class FluidFluidSettings;
class ObstacleFluidSettings;
class InflowFluidSettings;
class OutflowFluidSettings;
class ParticleFluidSettings;
class ControlFluidSettings;
class GreasePencil;
class GreasePencilLayers;
class GPencilLayer;
class GPencilFrames;
class GPencilFrame;
class GPencilStrokes;
class GPencilStroke;
class GPencilStrokePoints;
class GPencilStrokePoint;
class Group;
class GroupObjects;
class RenderSlot;
class RenderSlots;
class Image;
class ImageUser;
class Key;
class ShapeKey;
class ShapeKeyPoint;
class ShapeKeyCurvePoint;
class ShapeKeyBezierPoint;
class Lamp;
class LampTextureSlots;
class PointLamp;
class AreaLamp;
class SpotLamp;
class SunLamp;
class LampSkySettings;
class HemiLamp;
class LampTextureSlot;
class Lattice;
class LatticePoint;
class LineStyleModifier;
class LineStyleColorModifier;
class LineStyleColorModifier_AlongStroke;
class LineStyleColorModifier_DistanceFromCamera;
class LineStyleColorModifier_DistanceFromObject;
class LineStyleColorModifier_Material;
class LineStyleAlphaModifier;
class LineStyleAlphaModifier_AlongStroke;
class LineStyleAlphaModifier_DistanceFromCamera;
class LineStyleAlphaModifier_DistanceFromObject;
class LineStyleAlphaModifier_Material;
class LineStyleThicknessModifier;
class LineStyleThicknessModifier_AlongStroke;
class LineStyleThicknessModifier_DistanceFromCamera;
class LineStyleThicknessModifier_DistanceFromObject;
class LineStyleThicknessModifier_Material;
class LineStyleThicknessModifier_Calligraphy;
class LineStyleGeometryModifier;
class LineStyleGeometryModifier_Sampling;
class LineStyleGeometryModifier_BezierCurve;
class LineStyleGeometryModifier_SinusDisplacement;
class LineStyleGeometryModifier_SpatialNoise;
class LineStyleGeometryModifier_PerlinNoise1D;
class LineStyleGeometryModifier_PerlinNoise2D;
class LineStyleGeometryModifier_BackboneStretcher;
class LineStyleGeometryModifier_TipRemover;
class LineStyleGeometryModifier_Polygonalization;
class LineStyleGeometryModifier_GuidingLines;
class LineStyleGeometryModifier_Blueprint;
class LineStyleGeometryModifier_2DOffset;
class LineStyleGeometryModifier_2DTransform;
class FreestyleLineStyle;
class LineStyleTextureSlots;
class LineStyleColorModifiers;
class LineStyleAlphaModifiers;
class LineStyleThicknessModifiers;
class LineStyleGeometryModifiers;
class LineStyleTextureSlot;
class BlendData;
class BlendDataCameras;
class BlendDataScenes;
class BlendDataObjects;
class BlendDataMaterials;
class BlendDataNodeTrees;
class BlendDataMeshes;
class BlendDataLamps;
class BlendDataLibraries;
class BlendDataScreens;
class BlendDataWindowManagers;
class BlendDataImages;
class BlendDataLattices;
class BlendDataCurves;
class BlendDataMetaBalls;
class BlendDataFonts;
class BlendDataTextures;
class BlendDataBrushes;
class BlendDataWorlds;
class BlendDataGroups;
class BlendDataTexts;
class BlendDataSpeakers;
class BlendDataSounds;
class BlendDataArmatures;
class BlendDataActions;
class BlendDataParticles;
class BlendDataGreasePencils;
class BlendDataMovieClips;
class BlendDataMasks;
class BlendDataLineStyles;
class Material;
class MaterialTextureSlots;
class TexPaintSlot;
class MaterialRaytraceMirror;
class MaterialRaytraceTransparency;
class MaterialVolume;
class MaterialHalo;
class MaterialSubsurfaceScattering;
class MaterialTextureSlot;
class MaterialStrand;
class MaterialPhysics;
class MaterialGameSettings;
class Mesh;
class MeshVertices;
class MeshEdges;
class MeshTessFaces;
class MeshLoops;
class MeshPolygons;
class UVLoopLayers;
class TessfaceUVTextures;
class UVTextures;
class VertexColors;
class LoopColors;
class FloatProperties;
class IntProperties;
class StringProperties;
class MeshSkinVertexLayer;
class MeshSkinVertex;
class MeshVertex;
class VertexGroupElement;
class MeshEdge;
class MeshTessFace;
class MeshLoop;
class MeshPolygon;
class MeshUVLoopLayer;
class MeshUVLoop;
class MeshTextureFaceLayer;
class MeshTextureFace;
class MeshTexturePolyLayer;
class MeshTexturePoly;
class MeshColorLayer;
class MeshColor;
class MeshLoopColorLayer;
class MeshLoopColor;
class MeshFloatPropertyLayer;
class MeshFloatProperty;
class MeshIntPropertyLayer;
class MeshIntProperty;
class MeshStringPropertyLayer;
class MeshStringProperty;
class MetaElement;
class MetaBall;
class MetaBallElements;
class Modifier;
class SubsurfModifier;
class LatticeModifier;
class CurveModifier;
class BuildModifier;
class MirrorModifier;
class DecimateModifier;
class WaveModifier;
class ArmatureModifier;
class HookModifier;
class SoftBodyModifier;
class BooleanModifier;
class ArrayModifier;
class EdgeSplitModifier;
class DisplaceModifier;
class UVProjectModifier;
class UVProjector;
class SmoothModifier;
class CastModifier;
class MeshDeformModifier;
class ParticleSystemModifier;
class ParticleInstanceModifier;
class ExplodeModifier;
class ClothModifier;
class CollisionModifier;
class BevelModifier;
class ShrinkwrapModifier;
class FluidSimulationModifier;
class MaskModifier;
class SimpleDeformModifier;
class WarpModifier;
class MultiresModifier;
class SurfaceModifier;
class SmokeModifier;
class SolidifyModifier;
class ScrewModifier;
class UVWarpModifier;
class VertexWeightEditModifier;
class VertexWeightMixModifier;
class VertexWeightProximityModifier;
class DynamicPaintModifier;
class OceanModifier;
class RemeshModifier;
class SkinModifier;
class LaplacianSmoothModifier;
class TriangulateModifier;
class MeshCacheModifier;
class LaplacianDeformModifier;
class WireframeModifier;
class NlaTrack;
class NlaStrips;
class NlaStrip;
class NodeSocket;
class NodeSocketInterface;
class Node;
class NodeInputs;
class NodeOutputs;
class NodeLink;
class NodeInternalSocketTemplate;
class NodeInternal;
class ShaderNode;
class CompositorNode;
class TextureNode;
class NodeTree;
class Nodes;
class NodeLinks;
class NodeTreeInputs;
class NodeTreeOutputs;
class NodeSocketStandard;
class NodeSocketInterfaceStandard;
class NodeSocketFloat;
class NodeSocketInterfaceFloat;
class NodeSocketFloatUnsigned;
class NodeSocketInterfaceFloatUnsigned;
class NodeSocketFloatPercentage;
class NodeSocketInterfaceFloatPercentage;
class NodeSocketFloatFactor;
class NodeSocketInterfaceFloatFactor;
class NodeSocketFloatAngle;
class NodeSocketInterfaceFloatAngle;
class NodeSocketFloatTime;
class NodeSocketInterfaceFloatTime;
class NodeSocketInt;
class NodeSocketInterfaceInt;
class NodeSocketIntUnsigned;
class NodeSocketInterfaceIntUnsigned;
class NodeSocketIntPercentage;
class NodeSocketInterfaceIntPercentage;
class NodeSocketIntFactor;
class NodeSocketInterfaceIntFactor;
class NodeSocketBool;
class NodeSocketInterfaceBool;
class NodeSocketVector;
class NodeSocketInterfaceVector;
class NodeSocketVectorTranslation;
class NodeSocketInterfaceVectorTranslation;
class NodeSocketVectorDirection;
class NodeSocketInterfaceVectorDirection;
class NodeSocketVectorVelocity;
class NodeSocketInterfaceVectorVelocity;
class NodeSocketVectorAcceleration;
class NodeSocketInterfaceVectorAcceleration;
class NodeSocketVectorEuler;
class NodeSocketInterfaceVectorEuler;
class NodeSocketVectorXYZ;
class NodeSocketInterfaceVectorXYZ;
class NodeSocketColor;
class NodeSocketInterfaceColor;
class NodeSocketString;
class NodeSocketInterfaceString;
class NodeSocketShader;
class NodeSocketInterfaceShader;
class NodeSocketVirtual;
class CompositorNodeTree;
class ShaderNodeTree;
class TextureNodeTree;
class NodeFrame;
class NodeGroup;
class NodeGroupInput;
class NodeGroupOutput;
class NodeReroute;
class ShaderNodeOutput;
class ShaderNodeMaterial;
class ShaderNodeRGB;
class ShaderNodeValue;
class ShaderNodeMixRGB;
class ShaderNodeValToRGB;
class ShaderNodeRGBToBW;
class ShaderNodeTexture;
class ShaderNodeNormal;
class ShaderNodeGamma;
class ShaderNodeBrightContrast;
class ShaderNodeGeometry;
class ShaderNodeMapping;
class ShaderNodeVectorCurve;
class ShaderNodeRGBCurve;
class ShaderNodeCameraData;
class ShaderNodeLampData;
class ShaderNodeMath;
class ShaderNodeVectorMath;
class ShaderNodeSqueeze;
class ShaderNodeExtendedMaterial;
class ShaderNodeInvert;
class ShaderNodeSeparateRGB;
class ShaderNodeCombineRGB;
class ShaderNodeHueSaturation;
class ShaderNodeOutputMaterial;
class ShaderNodeOutputLamp;
class ShaderNodeOutputWorld;
class ShaderNodeOutputLineStyle;
class ShaderNodeFresnel;
class ShaderNodeLayerWeight;
class ShaderNodeMixShader;
class ShaderNodeAddShader;
class ShaderNodeAttribute;
class ShaderNodeAmbientOcclusion;
class ShaderNodeBackground;
class ShaderNodeHoldout;
class ShaderNodeBsdfAnisotropic;
class ShaderNodeBsdfDiffuse;
class ShaderNodeBsdfGlossy;
class ShaderNodeBsdfGlass;
class ShaderNodeBsdfRefraction;
class ShaderNodeBsdfTranslucent;
class ShaderNodeBsdfTransparent;
class ShaderNodeBsdfVelvet;
class ShaderNodeBsdfToon;
class ShaderNodeBsdfHair;
class ShaderNodeSubsurfaceScattering;
class ShaderNodeVolumeAbsorption;
class ShaderNodeVolumeScatter;
class ShaderNodeEmission;
class ShaderNodeNewGeometry;
class ShaderNodeLightPath;
class ShaderNodeLightFalloff;
class ShaderNodeObjectInfo;
class ShaderNodeParticleInfo;
class ShaderNodeHairInfo;
class ShaderNodeWireframe;
class ShaderNodeWavelength;
class ShaderNodeBlackbody;
class ShaderNodeBump;
class ShaderNodeNormalMap;
class ShaderNodeTangent;
class ShaderNodeScript;
class ShaderNodeTexImage;
class ShaderNodeTexEnvironment;
class ShaderNodeTexSky;
class ShaderNodeTexGradient;
class ShaderNodeTexNoise;
class ShaderNodeTexMagic;
class ShaderNodeTexWave;
class ShaderNodeTexMusgrave;
class ShaderNodeTexVoronoi;
class ShaderNodeTexChecker;
class ShaderNodeTexBrick;
class ShaderNodeTexCoord;
class ShaderNodeVectorTransform;
class ShaderNodeSeparateHSV;
class ShaderNodeCombineHSV;
class ShaderNodeUVMap;
class ShaderNodeUVAlongStroke;
class ShaderNodeSeparateXYZ;
class ShaderNodeCombineXYZ;
class CompositorNodeViewer;
class CompositorNodeRGB;
class CompositorNodeValue;
class CompositorNodeMixRGB;
class CompositorNodeValToRGB;
class CompositorNodeRGBToBW;
class CompositorNodeNormal;
class CompositorNodeCurveVec;
class CompositorNodeCurveRGB;
class CompositorNodeAlphaOver;
class CompositorNodeBlur;
class CompositorNodeFilter;
class CompositorNodeMapValue;
class CompositorNodeMapRange;
class CompositorNodeTime;
class CompositorNodeVecBlur;
class CompositorNodeSepRGBA;
class CompositorNodeSepHSVA;
class CompositorNodeSetAlpha;
class CompositorNodeHueSat;
class CompositorNodeImage;
class CompositorNodeRLayers;
class CompositorNodeComposite;
class CompositorNodeOutputFile;
class CompositorNodeOutputFileFileSlots;
class CompositorNodeOutputFileLayerSlots;
class CompositorNodeTexture;
class CompositorNodeTranslate;
class CompositorNodeZcombine;
class CompositorNodeCombRGBA;
class CompositorNodeDilateErode;
class CompositorNodeInpaint;
class CompositorNodeDespeckle;
class CompositorNodeRotate;
class CompositorNodeScale;
class CompositorNodeSepYCCA;
class CompositorNodeCombYCCA;
class CompositorNodeSepYUVA;
class CompositorNodeCombYUVA;
class CompositorNodeDiffMatte;
class CompositorNodeColorSpill;
class CompositorNodeChromaMatte;
class CompositorNodeChannelMatte;
class CompositorNodeFlip;
class CompositorNodeSplitViewer;
class CompositorNodeMapUV;
class CompositorNodeIDMask;
class CompositorNodeDoubleEdgeMask;
class CompositorNodeDefocus;
class CompositorNodeDisplace;
class CompositorNodeCombHSVA;
class CompositorNodeMath;
class CompositorNodeLumaMatte;
class CompositorNodeBrightContrast;
class CompositorNodeGamma;
class CompositorNodeInvert;
class CompositorNodeNormalize;
class CompositorNodeCrop;
class CompositorNodeDBlur;
class CompositorNodeBilateralblur;
class CompositorNodePremulKey;
class CompositorNodeGlare;
class CompositorNodeTonemap;
class CompositorNodeLensdist;
class CompositorNodeLevels;
class CompositorNodeColorMatte;
class CompositorNodeDistanceMatte;
class CompositorNodeColorBalance;
class CompositorNodeHueCorrect;
class CompositorNodeMovieClip;
class CompositorNodeTransform;
class CompositorNodeStabilize;
class CompositorNodeMovieDistortion;
class CompositorNodeBoxMask;
class CompositorNodeEllipseMask;
class CompositorNodeBokehImage;
class CompositorNodeBokehBlur;
class CompositorNodeSwitch;
class CompositorNodeColorCorrection;
class CompositorNodeMask;
class CompositorNodeKeyingScreen;
class CompositorNodeKeying;
class CompositorNodeTrackPos;
class CompositorNodePixelate;
class CompositorNodePlaneTrackDeform;
class CompositorNodeCornerPin;
class CompositorNodeSunBeams;
class TextureNodeOutput;
class TextureNodeChecker;
class TextureNodeTexture;
class TextureNodeBricks;
class TextureNodeMath;
class TextureNodeMixRGB;
class TextureNodeRGBToBW;
class TextureNodeValToRGB;
class TextureNodeImage;
class TextureNodeCurveRGB;
class TextureNodeInvert;
class TextureNodeHueSaturation;
class TextureNodeCurveTime;
class TextureNodeRotate;
class TextureNodeViewer;
class TextureNodeTranslate;
class TextureNodeCoordinates;
class TextureNodeDistance;
class TextureNodeCompose;
class TextureNodeDecompose;
class TextureNodeValToNor;
class TextureNodeScale;
class TextureNodeAt;
class TextureNodeTexVoronoi;
class TextureNodeTexBlend;
class TextureNodeTexMagic;
class TextureNodeTexMarble;
class TextureNodeTexClouds;
class TextureNodeTexWood;
class TextureNodeTexMusgrave;
class TextureNodeTexNoise;
class TextureNodeTexStucci;
class TextureNodeTexDistNoise;
class ShaderNodeGroup;
class CompositorNodeGroup;
class TextureNodeGroup;
class NodeCustomGroup;
class NodeOutputFileSlotFile;
class NodeOutputFileSlotLayer;
class NodeInstanceHash;
class Object;
class ObjectModifiers;
class ObjectConstraints;
class VertexGroups;
class ParticleSystems;
class GameObjectSettings;
class ObjectBase;
class VertexGroup;
class MaterialSlot;
class DupliObject;
class LodLevel;
class PointCache;
class PointCaches;
class CollisionSettings;
class EffectorWeights;
class FieldSettings;
class GameSoftBodySettings;
class SoftBodySettings;
class PackedFile;
class ParticleTarget;
class SPHFluidSettings;
class ParticleHairKey;
class ParticleKey;
class ChildParticle;
class Particle;
class ParticleDupliWeight;
class ParticleSystem;
class ParticleSettingsTextureSlot;
class ParticleSettings;
class ParticleSettingsTextureSlots;
class Pose;
class BoneGroups;
class PoseBone;
class PoseBoneConstraints;
class IKParam;
class Itasc;
class BoneGroup;
class GameProperty;
class GameBooleanProperty;
class GameIntProperty;
class GameFloatProperty;
class GameTimerProperty;
class GameStringProperty;
class RenderEngine;
class RenderResult;
class RenderLayer;
class RenderPass;
class BakePixel;
class RigidBodyWorld;
class RigidBodyObject;
class RigidBodyConstraint;
class Scene;
class SceneBases;
class SceneObjects;
class KeyingSets;
class KeyingSetsAll;
class TimelineMarkers;
class ToolSettings;
class UnifiedPaintSettings;
class MeshStatVis;
class UnitSettings;
class ImageFormatSettings;
class SceneGameData;
class SceneGameRecastData;
class TransformOrientation;
class SelectedUvElement;
class FFmpegSettings;
class RenderSettings;
class RenderLayers;
class BakeSettings;
class SceneRenderLayer;
class FreestyleLineSet;
class FreestyleModuleSettings;
class FreestyleSettings;
class FreestyleModules;
class Linesets;
class Screen;
class Area;
class AreaSpaces;
class Region;
class View2D;
class PaletteColor;
class Palette;
class PaintCurve;
class Paint;
class Sculpt;
class UvSculpt;
class VertexPaint;
class ImagePaint;
class ParticleEdit;
class ParticleBrush;
class Sensor;
class AlwaysSensor;
class NearSensor;
class MouseSensor;
class KeyboardSensor;
class PropertySensor;
class ArmatureSensor;
class ActuatorSensor;
class DelaySensor;
class CollisionSensor;
class RadarSensor;
class RandomSensor;
class RaySensor;
class MessageSensor;
class JoystickSensor;
class SequenceColorBalanceData;
class SequenceElement;
class SequenceProxy;
class SequenceColorBalance;
class SequenceCrop;
class SequenceTransform;
class Sequence;
class SequenceModifiers;
class SequenceEditor;
class Sequences;
class ImageSequence;
class SequenceElements;
class MetaSequence;
class SceneSequence;
class MovieSequence;
class MovieClipSequence;
class MaskSequence;
class SoundSequence;
class EffectSequence;
class AddSequence;
class AdjustmentSequence;
class AlphaOverSequence;
class AlphaUnderSequence;
class ColorSequence;
class CrossSequence;
class GammaCrossSequence;
class GlowSequence;
class MulticamSequence;
class MultiplySequence;
class OverDropSequence;
class SpeedControlSequence;
class SubtractSequence;
class TransformSequence;
class WipeSequence;
class GaussianBlurSequence;
class SequenceModifier;
class ColorBalanceModifier;
class CurvesModifier;
class HueCorrectModifier;
class BrightContrastModifier;
class SmokeDomainSettings;
class SmokeFlowSettings;
class SmokeCollSettings;
class Space;
class SpaceImageEditor;
class SpaceUVEditor;
class SpaceSequenceEditor;
class SpaceTextEditor;
class FileSelectParams;
class SpaceFileBrowser;
class SpaceOutliner;
class BackgroundImage;
class SpaceView3D;
class BackgroundImages;
class RegionView3D;
class SpaceProperties;
class SpaceDopeSheetEditor;
class SpaceGraphEditor;
class SpaceNLA;
class SpaceTimeline;
class SpaceConsole;
class ConsoleLine;
class SpaceInfo;
class SpaceUserPreferences;
class NodeTreePath;
class SpaceNodeEditor;
class SpaceNodeEditorPath;
class SpaceLogicEditor;
class SpaceClipEditor;
class Speaker;
class TextLine;
class Text;
class TimelineMarker;
class Sound;
class UILayout;
class Panel;
class UIList;
class Header;
class Menu;
class ThemeFontStyle;
class ThemeStyle;
class ThemeWidgetColors;
class ThemeWidgetStateColors;
class ThemePanelColors;
class ThemeGradientColors;
class ThemeUserInterface;
class ThemeSpaceGeneric;
class ThemeSpaceGradient;
class ThemeSpaceListGeneric;
class ThemeView3D;
class ThemeGraphEditor;
class ThemeFileBrowser;
class ThemeNLAEditor;
class ThemeDopeSheet;
class ThemeImageEditor;
class ThemeSequenceEditor;
class ThemeProperties;
class ThemeTextEditor;
class ThemeTimeline;
class ThemeNodeEditor;
class ThemeOutliner;
class ThemeInfo;
class ThemeUserPreferences;
class ThemeConsole;
class ThemeLogicEditor;
class ThemeClipEditor;
class ThemeBoneColorSet;
class Theme;
class UserSolidLight;
class WalkNavigation;
class UserPreferences;
class Addons;
class PathCompareCollection;
class UserPreferencesView;
class UserPreferencesEdit;
class UserPreferencesInput;
class UserPreferencesFilePaths;
class UserPreferencesSystem;
class Addon;
class AddonPreferences;
class PathCompare;
class VectorFont;
class Operator;
class OperatorProperties;
class OperatorMousePath;
class OperatorFileListElement;
class Macro;
class OperatorMacro;
class Event;
class Timer;
class UIPopupMenu;
class UIPieMenu;
class Window;
class WindowManager;
class KeyConfigurations;
class KeyConfig;
class KeyMaps;
class KeyMap;
class KeyMapItems;
class KeyMapItem;
class World;
class WorldTextureSlots;
class WorldLighting;
class WorldMistSettings;
class WorldTextureSlot;
class MovieClip;
class MovieClipProxy;
class MovieClipUser;
class MovieClipScopes;
class MovieTrackingSettings;
class MovieTrackingCamera;
class MovieTrackingMarker;
class MovieTrackingTrack;
class MovieTrackingMarkers;
class MovieTrackingPlaneMarker;
class MovieTrackingPlaneTrack;
class MovieTrackingPlaneMarkers;
class MovieTrackingTracks;
class MovieTrackingPlaneTracks;
class MovieTrackingObjectTracks;
class MovieTrackingObjectPlaneTracks;
class MovieTrackingStabilization;
class MovieTrackingReconstructedCameras;
class MovieReconstructedCamera;
class MovieTrackingReconstruction;
class MovieTrackingObject;
class MovieTrackingDopesheet;
class MovieTracking;
class MovieTrackingObjects;
class MaskParent;
class MaskSplinePointUW;
class MaskSplinePoint;
class MaskSpline;
class MaskSplines;
class MaskSplinePoints;
class MaskLayer;
class Mask;
class MaskLayers;

/**************** Struct Definition ****************/

class Struct : public Pointer {
public:
	Struct(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		properties(ptr_arg),
		functions(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline std::string identifier(void);	inline void identifier(const std::string& value);
	inline std::string description(void);	inline void description(const std::string& value);
	inline std::string translation_context(void);	inline void translation_context(const std::string& value);
	inline Struct base(void);
	inline Struct nested(void);
	inline StringProperty name_property(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Property, Struct, properties, false, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Function, Struct, functions, false, false, false)

};

/**************** Property Definition ****************/

class Property : public Pointer {
public:
	Property(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline std::string identifier(void);	inline void identifier(const std::string& value);
	inline std::string description(void);	inline void description(const std::string& value);
	inline std::string translation_context(void);	inline void translation_context(const std::string& value);
	enum type_enum {
		type_BOOLEAN = 0,
		type_INT = 1,
		type_FLOAT = 2,
		type_STRING = 3,
		type_ENUM = 4,
		type_POINTER = 5,
		type_COLLECTION = 6,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum subtype_enum {
		subtype_NONE = 0,
		subtype_FILE_PATH = 1,
		subtype_DIR_PATH = 2,
		subtype_PIXEL = 12,
		subtype_UNSIGNED = 13,
		subtype_PERCENTAGE = 14,
		subtype_FACTOR = 15,
		subtype_ANGLE = 327696,
		subtype_TIME = 393233,
		subtype_DISTANCE = 65554,
		subtype_COLOR = 20,
		subtype_TRANSLATION = 65557,
		subtype_DIRECTION = 22,
		subtype_MATRIX = 25,
		subtype_EULER = 327706,
		subtype_QUATERNION = 27,
		subtype_XYZ = 29,
		subtype_COLOR_GAMMA = 30,
		subtype_COORDINATES = 31,
		subtype_LAYER = 40,
		subtype_LAYER_MEMBERSHIP = 41,
	};
	inline subtype_enum subtype(void);
	inline void subtype(subtype_enum value);
	inline Struct srna(void);
	enum unit_enum {
		unit_NONE = 0,
		unit_LENGTH = 65536,
		unit_AREA = 131072,
		unit_VOLUME = 196608,
		unit_ROTATION = 327680,
		unit_TIME = 393216,
		unit_VELOCITY = 458752,
		unit_ACCELERATION = 524288,
		unit_CAMERA = 589824,
	};
	inline unit_enum unit(void);
	inline void unit(unit_enum value);
	enum icon_enum {
		icon_NONE = 0,
		icon_QUESTION = 1,
		icon_ERROR = 2,
		icon_CANCEL = 3,
		icon_TRIA_RIGHT = 4,
		icon_TRIA_DOWN = 5,
		icon_TRIA_LEFT = 6,
		icon_TRIA_UP = 7,
		icon_ARROW_LEFTRIGHT = 8,
		icon_PLUS = 9,
		icon_DISCLOSURE_TRI_DOWN = 10,
		icon_DISCLOSURE_TRI_RIGHT = 11,
		icon_RADIOBUT_OFF = 12,
		icon_RADIOBUT_ON = 13,
		icon_MENU_PANEL = 14,
		icon_BLENDER = 15,
		icon_GRIP = 16,
		icon_DOT = 17,
		icon_COLLAPSEMENU = 18,
		icon_X = 19,
		icon_GO_LEFT = 21,
		icon_PLUG = 22,
		icon_UI = 23,
		icon_NODE = 24,
		icon_NODE_SEL = 25,
		icon_FULLSCREEN = 26,
		icon_SPLITSCREEN = 27,
		icon_RIGHTARROW_THIN = 28,
		icon_BORDERMOVE = 29,
		icon_VIEWZOOM = 30,
		icon_ZOOMIN = 31,
		icon_ZOOMOUT = 32,
		icon_PANEL_CLOSE = 33,
		icon_COPY_ID = 34,
		icon_EYEDROPPER = 35,
		icon_LINK_AREA = 36,
		icon_AUTO = 37,
		icon_CHECKBOX_DEHLT = 38,
		icon_CHECKBOX_HLT = 39,
		icon_UNLOCKED = 40,
		icon_LOCKED = 41,
		icon_UNPINNED = 42,
		icon_PINNED = 43,
		icon_SCREEN_BACK = 44,
		icon_RIGHTARROW = 45,
		icon_DOWNARROW_HLT = 46,
		icon_DOTSUP = 47,
		icon_DOTSDOWN = 48,
		icon_LINK = 49,
		icon_INLINK = 50,
		icon_PLUGIN = 51,
		icon_HELP = 52,
		icon_GHOST_ENABLED = 53,
		icon_COLOR = 54,
		icon_LINKED = 55,
		icon_UNLINKED = 56,
		icon_HAND = 57,
		icon_ZOOM_ALL = 58,
		icon_ZOOM_SELECTED = 59,
		icon_ZOOM_PREVIOUS = 60,
		icon_ZOOM_IN = 61,
		icon_ZOOM_OUT = 62,
		icon_RENDER_REGION = 63,
		icon_BORDER_RECT = 64,
		icon_BORDER_LASSO = 65,
		icon_FREEZE = 66,
		icon_STYLUS_PRESSURE = 67,
		icon_GHOST_DISABLED = 68,
		icon_NEW = 69,
		icon_FILE_TICK = 70,
		icon_QUIT = 71,
		icon_URL = 72,
		icon_RECOVER_LAST = 73,
		icon_FULLSCREEN_ENTER = 75,
		icon_FULLSCREEN_EXIT = 76,
		icon_BLANK1 = 77,
		icon_LAMP = 78,
		icon_MATERIAL = 79,
		icon_TEXTURE = 80,
		icon_ANIM = 81,
		icon_WORLD = 82,
		icon_SCENE = 83,
		icon_EDIT = 84,
		icon_GAME = 85,
		icon_RADIO = 86,
		icon_SCRIPT = 87,
		icon_PARTICLES = 88,
		icon_PHYSICS = 89,
		icon_SPEAKER = 90,
		icon_TEXTURE_SHADED = 91,
		icon_VIEW3D = 104,
		icon_IPO = 105,
		icon_OOPS = 106,
		icon_BUTS = 107,
		icon_FILESEL = 108,
		icon_IMAGE_COL = 109,
		icon_INFO = 110,
		icon_SEQUENCE = 111,
		icon_TEXT = 112,
		icon_IMASEL = 113,
		icon_SOUND = 114,
		icon_ACTION = 115,
		icon_NLA = 116,
		icon_SCRIPTWIN = 117,
		icon_TIME = 118,
		icon_NODETREE = 119,
		icon_LOGIC = 120,
		icon_CONSOLE = 121,
		icon_PREFERENCES = 122,
		icon_CLIP = 123,
		icon_ASSET_MANAGER = 124,
		icon_OBJECT_DATAMODE = 130,
		icon_EDITMODE_HLT = 131,
		icon_FACESEL_HLT = 132,
		icon_VPAINT_HLT = 133,
		icon_TPAINT_HLT = 134,
		icon_WPAINT_HLT = 135,
		icon_SCULPTMODE_HLT = 136,
		icon_POSE_HLT = 137,
		icon_PARTICLEMODE = 138,
		icon_LIGHTPAINT = 139,
		icon_SCENE_DATA = 156,
		icon_RENDERLAYERS = 157,
		icon_WORLD_DATA = 158,
		icon_OBJECT_DATA = 159,
		icon_MESH_DATA = 160,
		icon_CURVE_DATA = 161,
		icon_META_DATA = 162,
		icon_LATTICE_DATA = 163,
		icon_LAMP_DATA = 164,
		icon_MATERIAL_DATA = 165,
		icon_TEXTURE_DATA = 166,
		icon_ANIM_DATA = 167,
		icon_CAMERA_DATA = 168,
		icon_PARTICLE_DATA = 169,
		icon_LIBRARY_DATA_DIRECT = 170,
		icon_GROUP = 171,
		icon_ARMATURE_DATA = 172,
		icon_POSE_DATA = 173,
		icon_BONE_DATA = 174,
		icon_CONSTRAINT = 175,
		icon_SHAPEKEY_DATA = 176,
		icon_CONSTRAINT_BONE = 177,
		icon_CAMERA_STEREO = 178,
		icon_PACKAGE = 179,
		icon_UGLYPACKAGE = 180,
		icon_BRUSH_DATA = 182,
		icon_IMAGE_DATA = 183,
		icon_FILE = 184,
		icon_FCURVE = 185,
		icon_FONT_DATA = 186,
		icon_RENDER_RESULT = 187,
		icon_SURFACE_DATA = 188,
		icon_EMPTY_DATA = 189,
		icon_SETTINGS = 190,
		icon_RENDER_ANIMATION = 191,
		icon_RENDER_STILL = 192,
		icon_BOIDS = 194,
		icon_STRANDS = 195,
		icon_LIBRARY_DATA_INDIRECT = 196,
		icon_GREASEPENCIL = 197,
		icon_LINE_DATA = 198,
		icon_GROUP_BONE = 200,
		icon_GROUP_VERTEX = 201,
		icon_GROUP_VCOL = 202,
		icon_GROUP_UVS = 203,
		icon_RNA = 206,
		icon_RNA_ADD = 207,
		icon_OUTLINER_OB_EMPTY = 234,
		icon_OUTLINER_OB_MESH = 235,
		icon_OUTLINER_OB_CURVE = 236,
		icon_OUTLINER_OB_LATTICE = 237,
		icon_OUTLINER_OB_META = 238,
		icon_OUTLINER_OB_LAMP = 239,
		icon_OUTLINER_OB_CAMERA = 240,
		icon_OUTLINER_OB_ARMATURE = 241,
		icon_OUTLINER_OB_FONT = 242,
		icon_OUTLINER_OB_SURFACE = 243,
		icon_OUTLINER_OB_SPEAKER = 244,
		icon_RESTRICT_VIEW_OFF = 253,
		icon_RESTRICT_VIEW_ON = 254,
		icon_RESTRICT_SELECT_OFF = 255,
		icon_RESTRICT_SELECT_ON = 256,
		icon_RESTRICT_RENDER_OFF = 257,
		icon_RESTRICT_RENDER_ON = 258,
		icon_OUTLINER_DATA_EMPTY = 260,
		icon_OUTLINER_DATA_MESH = 261,
		icon_OUTLINER_DATA_CURVE = 262,
		icon_OUTLINER_DATA_LATTICE = 263,
		icon_OUTLINER_DATA_META = 264,
		icon_OUTLINER_DATA_LAMP = 265,
		icon_OUTLINER_DATA_CAMERA = 266,
		icon_OUTLINER_DATA_ARMATURE = 267,
		icon_OUTLINER_DATA_FONT = 268,
		icon_OUTLINER_DATA_SURFACE = 269,
		icon_OUTLINER_DATA_SPEAKER = 270,
		icon_OUTLINER_DATA_POSE = 271,
		icon_MESH_PLANE = 286,
		icon_MESH_CUBE = 287,
		icon_MESH_CIRCLE = 288,
		icon_MESH_UVSPHERE = 289,
		icon_MESH_ICOSPHERE = 290,
		icon_MESH_GRID = 291,
		icon_MESH_MONKEY = 292,
		icon_MESH_CYLINDER = 293,
		icon_MESH_TORUS = 294,
		icon_MESH_CONE = 295,
		icon_LAMP_POINT = 298,
		icon_LAMP_SUN = 299,
		icon_LAMP_SPOT = 300,
		icon_LAMP_HEMI = 301,
		icon_LAMP_AREA = 302,
		icon_META_EMPTY = 305,
		icon_META_PLANE = 306,
		icon_META_CUBE = 307,
		icon_META_BALL = 308,
		icon_META_ELLIPSOID = 309,
		icon_META_CAPSULE = 310,
		icon_SURFACE_NCURVE = 312,
		icon_SURFACE_NCIRCLE = 313,
		icon_SURFACE_NSURFACE = 314,
		icon_SURFACE_NCYLINDER = 315,
		icon_SURFACE_NSPHERE = 316,
		icon_SURFACE_NTORUS = 317,
		icon_CURVE_BEZCURVE = 321,
		icon_CURVE_BEZCIRCLE = 322,
		icon_CURVE_NCURVE = 323,
		icon_CURVE_NCIRCLE = 324,
		icon_CURVE_PATH = 325,
		icon_COLOR_RED = 331,
		icon_COLOR_GREEN = 332,
		icon_COLOR_BLUE = 333,
		icon_TRIA_RIGHT_BAR = 334,
		icon_TRIA_DOWN_BAR = 335,
		icon_TRIA_LEFT_BAR = 336,
		icon_TRIA_UP_BAR = 337,
		icon_FORCE_FORCE = 338,
		icon_FORCE_WIND = 339,
		icon_FORCE_VORTEX = 340,
		icon_FORCE_MAGNETIC = 341,
		icon_FORCE_HARMONIC = 342,
		icon_FORCE_CHARGE = 343,
		icon_FORCE_LENNARDJONES = 344,
		icon_FORCE_TEXTURE = 345,
		icon_FORCE_CURVE = 346,
		icon_FORCE_BOID = 347,
		icon_FORCE_TURBULENCE = 348,
		icon_FORCE_DRAG = 349,
		icon_FORCE_SMOKEFLOW = 350,
		icon_MODIFIER = 442,
		icon_MOD_WAVE = 443,
		icon_MOD_BUILD = 444,
		icon_MOD_DECIM = 445,
		icon_MOD_MIRROR = 446,
		icon_MOD_SOFT = 447,
		icon_MOD_SUBSURF = 448,
		icon_HOOK = 449,
		icon_MOD_PHYSICS = 450,
		icon_MOD_PARTICLES = 451,
		icon_MOD_BOOLEAN = 452,
		icon_MOD_EDGESPLIT = 453,
		icon_MOD_ARRAY = 454,
		icon_MOD_UVPROJECT = 455,
		icon_MOD_DISPLACE = 456,
		icon_MOD_CURVE = 457,
		icon_MOD_LATTICE = 458,
		icon_CONSTRAINT_DATA = 459,
		icon_MOD_ARMATURE = 460,
		icon_MOD_SHRINKWRAP = 461,
		icon_MOD_CAST = 462,
		icon_MOD_MESHDEFORM = 463,
		icon_MOD_BEVEL = 464,
		icon_MOD_SMOOTH = 465,
		icon_MOD_SIMPLEDEFORM = 466,
		icon_MOD_MASK = 467,
		icon_MOD_CLOTH = 468,
		icon_MOD_EXPLODE = 469,
		icon_MOD_FLUIDSIM = 470,
		icon_MOD_MULTIRES = 471,
		icon_MOD_SMOKE = 472,
		icon_MOD_SOLIDIFY = 473,
		icon_MOD_SCREW = 474,
		icon_MOD_VERTEX_WEIGHT = 475,
		icon_MOD_DYNAMICPAINT = 476,
		icon_MOD_REMESH = 477,
		icon_MOD_OCEAN = 478,
		icon_MOD_WARP = 479,
		icon_MOD_SKIN = 480,
		icon_MOD_TRIANGULATE = 481,
		icon_MOD_WIREFRAME = 482,
		icon_REC = 494,
		icon_PLAY = 495,
		icon_FF = 496,
		icon_REW = 497,
		icon_PAUSE = 498,
		icon_PREV_KEYFRAME = 499,
		icon_NEXT_KEYFRAME = 500,
		icon_PLAY_AUDIO = 501,
		icon_PLAY_REVERSE = 502,
		icon_PREVIEW_RANGE = 503,
		icon_ACTION_TWEAK = 504,
		icon_PMARKER_ACT = 505,
		icon_PMARKER_SEL = 506,
		icon_PMARKER = 507,
		icon_MARKER_HLT = 508,
		icon_MARKER = 509,
		icon_SPACE2 = 510,
		icon_SPACE3 = 511,
		icon_KEYINGSET = 512,
		icon_KEY_DEHLT = 513,
		icon_KEY_HLT = 514,
		icon_MUTE_IPO_OFF = 515,
		icon_MUTE_IPO_ON = 516,
		icon_VISIBLE_IPO_OFF = 517,
		icon_VISIBLE_IPO_ON = 518,
		icon_DRIVER = 519,
		icon_SOLO_OFF = 520,
		icon_SOLO_ON = 521,
		icon_FRAME_PREV = 522,
		icon_FRAME_NEXT = 523,
		icon_NLA_PUSHDOWN = 524,
		icon_IPO_CONSTANT = 525,
		icon_IPO_LINEAR = 526,
		icon_IPO_BEZIER = 527,
		icon_IPO_SINE = 528,
		icon_IPO_QUAD = 529,
		icon_IPO_CUBIC = 530,
		icon_IPO_QUART = 531,
		icon_IPO_QUINT = 532,
		icon_IPO_EXPO = 533,
		icon_IPO_CIRC = 534,
		icon_IPO_BOUNCE = 535,
		icon_IPO_ELASTIC = 536,
		icon_IPO_BACK = 537,
		icon_IPO_EASE_IN = 538,
		icon_IPO_EASE_OUT = 539,
		icon_IPO_EASE_IN_OUT = 540,
		icon_VERTEXSEL = 546,
		icon_EDGESEL = 547,
		icon_FACESEL = 548,
		icon_LOOPSEL = 549,
		icon_ROTATE = 551,
		icon_CURSOR = 552,
		icon_ROTATECOLLECTION = 553,
		icon_ROTATECENTER = 554,
		icon_ROTACTIVE = 555,
		icon_ALIGN = 556,
		icon_SMOOTHCURVE = 558,
		icon_SPHERECURVE = 559,
		icon_ROOTCURVE = 560,
		icon_SHARPCURVE = 561,
		icon_LINCURVE = 562,
		icon_NOCURVE = 563,
		icon_RNDCURVE = 564,
		icon_PROP_OFF = 565,
		icon_PROP_ON = 566,
		icon_PROP_CON = 567,
		icon_SCULPT_DYNTOPO = 568,
		icon_PARTICLE_POINT = 569,
		icon_PARTICLE_TIP = 570,
		icon_PARTICLE_PATH = 571,
		icon_MAN_TRANS = 572,
		icon_MAN_ROT = 573,
		icon_MAN_SCALE = 574,
		icon_MANIPUL = 575,
		icon_SNAP_OFF = 576,
		icon_SNAP_ON = 577,
		icon_SNAP_NORMAL = 578,
		icon_SNAP_INCREMENT = 579,
		icon_SNAP_VERTEX = 580,
		icon_SNAP_EDGE = 581,
		icon_SNAP_FACE = 582,
		icon_SNAP_VOLUME = 583,
		icon_STICKY_UVS_LOC = 585,
		icon_STICKY_UVS_DISABLE = 586,
		icon_STICKY_UVS_VERT = 587,
		icon_CLIPUV_DEHLT = 588,
		icon_CLIPUV_HLT = 589,
		icon_SNAP_PEEL_OBJECT = 590,
		icon_GRID = 591,
		icon_PASTEDOWN = 598,
		icon_COPYDOWN = 599,
		icon_PASTEFLIPUP = 600,
		icon_PASTEFLIPDOWN = 601,
		icon_SNAP_SURFACE = 606,
		icon_AUTOMERGE_ON = 607,
		icon_AUTOMERGE_OFF = 608,
		icon_RETOPO = 609,
		icon_UV_VERTEXSEL = 610,
		icon_UV_EDGESEL = 611,
		icon_UV_FACESEL = 612,
		icon_UV_ISLANDSEL = 613,
		icon_UV_SYNC_SELECT = 614,
		icon_BBOX = 624,
		icon_WIRE = 625,
		icon_SOLID = 626,
		icon_SMOOTH = 627,
		icon_POTATO = 628,
		icon_ORTHO = 630,
		icon_LOCKVIEW_OFF = 633,
		icon_LOCKVIEW_ON = 634,
		icon_AXIS_SIDE = 636,
		icon_AXIS_FRONT = 637,
		icon_AXIS_TOP = 638,
		icon_NDOF_DOM = 639,
		icon_NDOF_TURN = 640,
		icon_NDOF_FLY = 641,
		icon_NDOF_TRANS = 642,
		icon_LAYER_USED = 643,
		icon_LAYER_ACTIVE = 644,
		icon_SORTALPHA = 676,
		icon_SORTBYEXT = 677,
		icon_SORTTIME = 678,
		icon_SORTSIZE = 679,
		icon_LONGDISPLAY = 680,
		icon_SHORTDISPLAY = 681,
		icon_GHOST = 682,
		icon_IMGDISPLAY = 683,
		icon_SAVE_AS = 684,
		icon_SAVE_COPY = 685,
		icon_BOOKMARKS = 686,
		icon_FONTPREVIEW = 687,
		icon_FILTER = 688,
		icon_NEWFOLDER = 689,
		icon_OPEN_RECENT = 690,
		icon_FILE_PARENT = 691,
		icon_FILE_REFRESH = 692,
		icon_FILE_FOLDER = 693,
		icon_FILE_BLANK = 694,
		icon_FILE_BLEND = 695,
		icon_FILE_IMAGE = 696,
		icon_FILE_MOVIE = 697,
		icon_FILE_SCRIPT = 698,
		icon_FILE_SOUND = 699,
		icon_FILE_FONT = 700,
		icon_FILE_TEXT = 701,
		icon_RECOVER_AUTO = 702,
		icon_SAVE_PREFS = 703,
		icon_LINK_BLEND = 704,
		icon_APPEND_BLEND = 705,
		icon_IMPORT = 706,
		icon_EXPORT = 707,
		icon_EXTERNAL_DATA = 708,
		icon_LOAD_FACTORY = 709,
		icon_LOOP_BACK = 715,
		icon_LOOP_FORWARDS = 716,
		icon_BACK = 717,
		icon_FORWARD = 718,
		icon_FILE_BACKUP = 726,
		icon_DISK_DRIVE = 727,
		icon_MATPLANE = 728,
		icon_MATSPHERE = 729,
		icon_MATCUBE = 730,
		icon_MONKEY = 731,
		icon_HAIR = 732,
		icon_ALIASED = 733,
		icon_ANTIALIASED = 734,
		icon_MAT_SPHERE_SKY = 735,
		icon_WORDWRAP_OFF = 740,
		icon_WORDWRAP_ON = 741,
		icon_SYNTAX_OFF = 742,
		icon_SYNTAX_ON = 743,
		icon_LINENUMBERS_OFF = 744,
		icon_LINENUMBERS_ON = 745,
		icon_SCRIPTPLUGINS = 746,
		icon_SEQ_SEQUENCER = 754,
		icon_SEQ_PREVIEW = 755,
		icon_SEQ_LUMA_WAVEFORM = 756,
		icon_SEQ_CHROMA_SCOPE = 757,
		icon_SEQ_HISTOGRAM = 758,
		icon_SEQ_SPLITVIEW = 759,
		icon_IMAGE_RGB = 763,
		icon_IMAGE_RGB_ALPHA = 764,
		icon_IMAGE_ALPHA = 765,
		icon_IMAGE_ZDEPTH = 766,
		icon_IMAGEFILE = 767,
		icon_BRUSH_ADD = 780,
		icon_BRUSH_BLOB = 781,
		icon_BRUSH_BLUR = 782,
		icon_BRUSH_CLAY = 783,
		icon_BRUSH_CLAY_STRIPS = 784,
		icon_BRUSH_CLONE = 785,
		icon_BRUSH_CREASE = 786,
		icon_BRUSH_DARKEN = 787,
		icon_BRUSH_FILL = 788,
		icon_BRUSH_FLATTEN = 789,
		icon_BRUSH_GRAB = 790,
		icon_BRUSH_INFLATE = 791,
		icon_BRUSH_LAYER = 792,
		icon_BRUSH_LIGHTEN = 793,
		icon_BRUSH_MASK = 794,
		icon_BRUSH_MIX = 795,
		icon_BRUSH_MULTIPLY = 796,
		icon_BRUSH_NUDGE = 797,
		icon_BRUSH_PINCH = 798,
		icon_BRUSH_SCRAPE = 799,
		icon_BRUSH_SCULPT_DRAW = 800,
		icon_BRUSH_SMEAR = 801,
		icon_BRUSH_SMOOTH = 802,
		icon_BRUSH_SNAKE_HOOK = 803,
		icon_BRUSH_SOFTEN = 804,
		icon_BRUSH_SUBTRACT = 805,
		icon_BRUSH_TEXDRAW = 806,
		icon_BRUSH_TEXFILL = 807,
		icon_BRUSH_TEXMASK = 808,
		icon_BRUSH_THUMB = 809,
		icon_BRUSH_ROTATE = 810,
		icon_BRUSH_VERTEXDRAW = 811,
		icon_MATCAP_01 = 812,
		icon_MATCAP_02 = 813,
		icon_MATCAP_03 = 814,
		icon_MATCAP_04 = 815,
		icon_MATCAP_05 = 816,
		icon_MATCAP_06 = 817,
		icon_MATCAP_07 = 818,
		icon_MATCAP_08 = 819,
		icon_MATCAP_09 = 820,
		icon_MATCAP_10 = 821,
		icon_MATCAP_11 = 822,
		icon_MATCAP_12 = 823,
		icon_MATCAP_13 = 824,
		icon_MATCAP_14 = 825,
		icon_MATCAP_15 = 826,
		icon_MATCAP_16 = 827,
		icon_MATCAP_17 = 828,
		icon_MATCAP_18 = 829,
		icon_MATCAP_19 = 830,
		icon_MATCAP_20 = 831,
		icon_MATCAP_21 = 832,
		icon_MATCAP_22 = 833,
		icon_MATCAP_23 = 834,
		icon_MATCAP_24 = 835,
		icon_VIEW3D_VEC = 836,
		icon_EDIT_VEC = 837,
		icon_EDITMODE_VEC_DEHLT = 838,
		icon_EDITMODE_VEC_HLT = 839,
		icon_DISCLOSURE_TRI_RIGHT_VEC = 840,
		icon_DISCLOSURE_TRI_DOWN_VEC = 841,
		icon_MOVE_UP_VEC = 842,
		icon_MOVE_DOWN_VEC = 843,
		icon_X_VEC = 844,
		icon_SMALL_TRI_RIGHT_VEC = 845,
	};
	inline icon_enum icon(void);
	inline void icon(icon_enum value);
	inline bool is_readonly(void);
	inline void is_readonly(int value);
	inline bool is_animatable(void);
	inline void is_animatable(int value);
	inline bool is_required(void);
	inline void is_required(int value);
	inline bool is_argument_optional(void);
	inline void is_argument_optional(int value);
	inline bool is_never_none(void);
	inline void is_never_none(int value);
	inline bool is_hidden(void);
	inline void is_hidden(int value);
	inline bool is_skip_save(void);
	inline void is_skip_save(int value);
	inline bool is_output(void);
	inline void is_output(int value);
	inline bool is_registered(void);
	inline void is_registered(int value);
	inline bool is_registered_optional(void);
	inline void is_registered_optional(int value);
	inline bool is_runtime(void);
	inline void is_runtime(int value);
	inline bool is_enum_flag(void);
	inline void is_enum_flag(int value);
	inline bool is_library_editable(void);
	inline void is_library_editable(int value);

};

/**************** Boolean Definition ****************/

class BoolProperty : public Property {
public:
	BoolProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline bool default_value(void);
	inline void default_value(int value);
	inline Array<int, 3> default_array(void);
	inline void default_array(int values[3]);
	inline int array_length(void);
	inline void array_length(int value);

};

/**************** Int Definition ****************/

class IntProperty : public Property {
public:
	IntProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);
	inline Array<int, 3> default_array(void);
	inline void default_array(int values[3]);
	inline int array_length(void);
	inline void array_length(int value);
	inline int hard_min(void);
	inline void hard_min(int value);
	inline int hard_max(void);
	inline void hard_max(int value);
	inline int soft_min(void);
	inline void soft_min(int value);
	inline int soft_max(void);
	inline void soft_max(int value);
	inline int step(void);
	inline void step(int value);

};

/**************** Float Definition ****************/

class FloatProperty : public Property {
public:
	FloatProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);
	inline Array<float, 3> default_array(void);
	inline void default_array(float values[3]);
	inline int array_length(void);
	inline void array_length(int value);
	inline float hard_min(void);
	inline void hard_min(float value);
	inline float hard_max(void);
	inline void hard_max(float value);
	inline float soft_min(void);
	inline void soft_min(float value);
	inline float soft_max(void);
	inline void soft_max(float value);
	inline float step(void);
	inline void step(float value);
	inline int precision(void);
	inline void precision(int value);

};

/**************** String Definition ****************/

class StringProperty : public Property {
public:
	StringProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline std::string default_value(void);	inline void default_value(const std::string& value);
	inline int length_max(void);
	inline void length_max(int value);

};

/**************** Enum Definition ****************/

class EnumProperty : public Property {
public:
	EnumProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg),
		enum_items(ptr_arg)
		{}

	enum default_value_enum {
		default_value_DUMMY = 0,
	};
	inline default_value_enum default_value(void);
	inline void default_value(default_value_enum value);
	enum default_flag_enum {
		default_flag_DUMMY = 0,
	};
	inline default_flag_enum default_flag(void);
	inline void default_flag(default_flag_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, EnumPropertyItem, EnumProperty, enum_items, false, false, false)

};

/**************** Enum Item Definition ****************/

class EnumPropertyItem : public Pointer {
public:
	EnumPropertyItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline std::string description(void);	inline void description(const std::string& value);
	inline std::string identifier(void);	inline void identifier(const std::string& value);
	inline int value(void);
	inline void value(int value);
	enum icon_enum {
		icon_NONE = 0,
		icon_QUESTION = 1,
		icon_ERROR = 2,
		icon_CANCEL = 3,
		icon_TRIA_RIGHT = 4,
		icon_TRIA_DOWN = 5,
		icon_TRIA_LEFT = 6,
		icon_TRIA_UP = 7,
		icon_ARROW_LEFTRIGHT = 8,
		icon_PLUS = 9,
		icon_DISCLOSURE_TRI_DOWN = 10,
		icon_DISCLOSURE_TRI_RIGHT = 11,
		icon_RADIOBUT_OFF = 12,
		icon_RADIOBUT_ON = 13,
		icon_MENU_PANEL = 14,
		icon_BLENDER = 15,
		icon_GRIP = 16,
		icon_DOT = 17,
		icon_COLLAPSEMENU = 18,
		icon_X = 19,
		icon_GO_LEFT = 21,
		icon_PLUG = 22,
		icon_UI = 23,
		icon_NODE = 24,
		icon_NODE_SEL = 25,
		icon_FULLSCREEN = 26,
		icon_SPLITSCREEN = 27,
		icon_RIGHTARROW_THIN = 28,
		icon_BORDERMOVE = 29,
		icon_VIEWZOOM = 30,
		icon_ZOOMIN = 31,
		icon_ZOOMOUT = 32,
		icon_PANEL_CLOSE = 33,
		icon_COPY_ID = 34,
		icon_EYEDROPPER = 35,
		icon_LINK_AREA = 36,
		icon_AUTO = 37,
		icon_CHECKBOX_DEHLT = 38,
		icon_CHECKBOX_HLT = 39,
		icon_UNLOCKED = 40,
		icon_LOCKED = 41,
		icon_UNPINNED = 42,
		icon_PINNED = 43,
		icon_SCREEN_BACK = 44,
		icon_RIGHTARROW = 45,
		icon_DOWNARROW_HLT = 46,
		icon_DOTSUP = 47,
		icon_DOTSDOWN = 48,
		icon_LINK = 49,
		icon_INLINK = 50,
		icon_PLUGIN = 51,
		icon_HELP = 52,
		icon_GHOST_ENABLED = 53,
		icon_COLOR = 54,
		icon_LINKED = 55,
		icon_UNLINKED = 56,
		icon_HAND = 57,
		icon_ZOOM_ALL = 58,
		icon_ZOOM_SELECTED = 59,
		icon_ZOOM_PREVIOUS = 60,
		icon_ZOOM_IN = 61,
		icon_ZOOM_OUT = 62,
		icon_RENDER_REGION = 63,
		icon_BORDER_RECT = 64,
		icon_BORDER_LASSO = 65,
		icon_FREEZE = 66,
		icon_STYLUS_PRESSURE = 67,
		icon_GHOST_DISABLED = 68,
		icon_NEW = 69,
		icon_FILE_TICK = 70,
		icon_QUIT = 71,
		icon_URL = 72,
		icon_RECOVER_LAST = 73,
		icon_FULLSCREEN_ENTER = 75,
		icon_FULLSCREEN_EXIT = 76,
		icon_BLANK1 = 77,
		icon_LAMP = 78,
		icon_MATERIAL = 79,
		icon_TEXTURE = 80,
		icon_ANIM = 81,
		icon_WORLD = 82,
		icon_SCENE = 83,
		icon_EDIT = 84,
		icon_GAME = 85,
		icon_RADIO = 86,
		icon_SCRIPT = 87,
		icon_PARTICLES = 88,
		icon_PHYSICS = 89,
		icon_SPEAKER = 90,
		icon_TEXTURE_SHADED = 91,
		icon_VIEW3D = 104,
		icon_IPO = 105,
		icon_OOPS = 106,
		icon_BUTS = 107,
		icon_FILESEL = 108,
		icon_IMAGE_COL = 109,
		icon_INFO = 110,
		icon_SEQUENCE = 111,
		icon_TEXT = 112,
		icon_IMASEL = 113,
		icon_SOUND = 114,
		icon_ACTION = 115,
		icon_NLA = 116,
		icon_SCRIPTWIN = 117,
		icon_TIME = 118,
		icon_NODETREE = 119,
		icon_LOGIC = 120,
		icon_CONSOLE = 121,
		icon_PREFERENCES = 122,
		icon_CLIP = 123,
		icon_ASSET_MANAGER = 124,
		icon_OBJECT_DATAMODE = 130,
		icon_EDITMODE_HLT = 131,
		icon_FACESEL_HLT = 132,
		icon_VPAINT_HLT = 133,
		icon_TPAINT_HLT = 134,
		icon_WPAINT_HLT = 135,
		icon_SCULPTMODE_HLT = 136,
		icon_POSE_HLT = 137,
		icon_PARTICLEMODE = 138,
		icon_LIGHTPAINT = 139,
		icon_SCENE_DATA = 156,
		icon_RENDERLAYERS = 157,
		icon_WORLD_DATA = 158,
		icon_OBJECT_DATA = 159,
		icon_MESH_DATA = 160,
		icon_CURVE_DATA = 161,
		icon_META_DATA = 162,
		icon_LATTICE_DATA = 163,
		icon_LAMP_DATA = 164,
		icon_MATERIAL_DATA = 165,
		icon_TEXTURE_DATA = 166,
		icon_ANIM_DATA = 167,
		icon_CAMERA_DATA = 168,
		icon_PARTICLE_DATA = 169,
		icon_LIBRARY_DATA_DIRECT = 170,
		icon_GROUP = 171,
		icon_ARMATURE_DATA = 172,
		icon_POSE_DATA = 173,
		icon_BONE_DATA = 174,
		icon_CONSTRAINT = 175,
		icon_SHAPEKEY_DATA = 176,
		icon_CONSTRAINT_BONE = 177,
		icon_CAMERA_STEREO = 178,
		icon_PACKAGE = 179,
		icon_UGLYPACKAGE = 180,
		icon_BRUSH_DATA = 182,
		icon_IMAGE_DATA = 183,
		icon_FILE = 184,
		icon_FCURVE = 185,
		icon_FONT_DATA = 186,
		icon_RENDER_RESULT = 187,
		icon_SURFACE_DATA = 188,
		icon_EMPTY_DATA = 189,
		icon_SETTINGS = 190,
		icon_RENDER_ANIMATION = 191,
		icon_RENDER_STILL = 192,
		icon_BOIDS = 194,
		icon_STRANDS = 195,
		icon_LIBRARY_DATA_INDIRECT = 196,
		icon_GREASEPENCIL = 197,
		icon_LINE_DATA = 198,
		icon_GROUP_BONE = 200,
		icon_GROUP_VERTEX = 201,
		icon_GROUP_VCOL = 202,
		icon_GROUP_UVS = 203,
		icon_RNA = 206,
		icon_RNA_ADD = 207,
		icon_OUTLINER_OB_EMPTY = 234,
		icon_OUTLINER_OB_MESH = 235,
		icon_OUTLINER_OB_CURVE = 236,
		icon_OUTLINER_OB_LATTICE = 237,
		icon_OUTLINER_OB_META = 238,
		icon_OUTLINER_OB_LAMP = 239,
		icon_OUTLINER_OB_CAMERA = 240,
		icon_OUTLINER_OB_ARMATURE = 241,
		icon_OUTLINER_OB_FONT = 242,
		icon_OUTLINER_OB_SURFACE = 243,
		icon_OUTLINER_OB_SPEAKER = 244,
		icon_RESTRICT_VIEW_OFF = 253,
		icon_RESTRICT_VIEW_ON = 254,
		icon_RESTRICT_SELECT_OFF = 255,
		icon_RESTRICT_SELECT_ON = 256,
		icon_RESTRICT_RENDER_OFF = 257,
		icon_RESTRICT_RENDER_ON = 258,
		icon_OUTLINER_DATA_EMPTY = 260,
		icon_OUTLINER_DATA_MESH = 261,
		icon_OUTLINER_DATA_CURVE = 262,
		icon_OUTLINER_DATA_LATTICE = 263,
		icon_OUTLINER_DATA_META = 264,
		icon_OUTLINER_DATA_LAMP = 265,
		icon_OUTLINER_DATA_CAMERA = 266,
		icon_OUTLINER_DATA_ARMATURE = 267,
		icon_OUTLINER_DATA_FONT = 268,
		icon_OUTLINER_DATA_SURFACE = 269,
		icon_OUTLINER_DATA_SPEAKER = 270,
		icon_OUTLINER_DATA_POSE = 271,
		icon_MESH_PLANE = 286,
		icon_MESH_CUBE = 287,
		icon_MESH_CIRCLE = 288,
		icon_MESH_UVSPHERE = 289,
		icon_MESH_ICOSPHERE = 290,
		icon_MESH_GRID = 291,
		icon_MESH_MONKEY = 292,
		icon_MESH_CYLINDER = 293,
		icon_MESH_TORUS = 294,
		icon_MESH_CONE = 295,
		icon_LAMP_POINT = 298,
		icon_LAMP_SUN = 299,
		icon_LAMP_SPOT = 300,
		icon_LAMP_HEMI = 301,
		icon_LAMP_AREA = 302,
		icon_META_EMPTY = 305,
		icon_META_PLANE = 306,
		icon_META_CUBE = 307,
		icon_META_BALL = 308,
		icon_META_ELLIPSOID = 309,
		icon_META_CAPSULE = 310,
		icon_SURFACE_NCURVE = 312,
		icon_SURFACE_NCIRCLE = 313,
		icon_SURFACE_NSURFACE = 314,
		icon_SURFACE_NCYLINDER = 315,
		icon_SURFACE_NSPHERE = 316,
		icon_SURFACE_NTORUS = 317,
		icon_CURVE_BEZCURVE = 321,
		icon_CURVE_BEZCIRCLE = 322,
		icon_CURVE_NCURVE = 323,
		icon_CURVE_NCIRCLE = 324,
		icon_CURVE_PATH = 325,
		icon_COLOR_RED = 331,
		icon_COLOR_GREEN = 332,
		icon_COLOR_BLUE = 333,
		icon_TRIA_RIGHT_BAR = 334,
		icon_TRIA_DOWN_BAR = 335,
		icon_TRIA_LEFT_BAR = 336,
		icon_TRIA_UP_BAR = 337,
		icon_FORCE_FORCE = 338,
		icon_FORCE_WIND = 339,
		icon_FORCE_VORTEX = 340,
		icon_FORCE_MAGNETIC = 341,
		icon_FORCE_HARMONIC = 342,
		icon_FORCE_CHARGE = 343,
		icon_FORCE_LENNARDJONES = 344,
		icon_FORCE_TEXTURE = 345,
		icon_FORCE_CURVE = 346,
		icon_FORCE_BOID = 347,
		icon_FORCE_TURBULENCE = 348,
		icon_FORCE_DRAG = 349,
		icon_FORCE_SMOKEFLOW = 350,
		icon_MODIFIER = 442,
		icon_MOD_WAVE = 443,
		icon_MOD_BUILD = 444,
		icon_MOD_DECIM = 445,
		icon_MOD_MIRROR = 446,
		icon_MOD_SOFT = 447,
		icon_MOD_SUBSURF = 448,
		icon_HOOK = 449,
		icon_MOD_PHYSICS = 450,
		icon_MOD_PARTICLES = 451,
		icon_MOD_BOOLEAN = 452,
		icon_MOD_EDGESPLIT = 453,
		icon_MOD_ARRAY = 454,
		icon_MOD_UVPROJECT = 455,
		icon_MOD_DISPLACE = 456,
		icon_MOD_CURVE = 457,
		icon_MOD_LATTICE = 458,
		icon_CONSTRAINT_DATA = 459,
		icon_MOD_ARMATURE = 460,
		icon_MOD_SHRINKWRAP = 461,
		icon_MOD_CAST = 462,
		icon_MOD_MESHDEFORM = 463,
		icon_MOD_BEVEL = 464,
		icon_MOD_SMOOTH = 465,
		icon_MOD_SIMPLEDEFORM = 466,
		icon_MOD_MASK = 467,
		icon_MOD_CLOTH = 468,
		icon_MOD_EXPLODE = 469,
		icon_MOD_FLUIDSIM = 470,
		icon_MOD_MULTIRES = 471,
		icon_MOD_SMOKE = 472,
		icon_MOD_SOLIDIFY = 473,
		icon_MOD_SCREW = 474,
		icon_MOD_VERTEX_WEIGHT = 475,
		icon_MOD_DYNAMICPAINT = 476,
		icon_MOD_REMESH = 477,
		icon_MOD_OCEAN = 478,
		icon_MOD_WARP = 479,
		icon_MOD_SKIN = 480,
		icon_MOD_TRIANGULATE = 481,
		icon_MOD_WIREFRAME = 482,
		icon_REC = 494,
		icon_PLAY = 495,
		icon_FF = 496,
		icon_REW = 497,
		icon_PAUSE = 498,
		icon_PREV_KEYFRAME = 499,
		icon_NEXT_KEYFRAME = 500,
		icon_PLAY_AUDIO = 501,
		icon_PLAY_REVERSE = 502,
		icon_PREVIEW_RANGE = 503,
		icon_ACTION_TWEAK = 504,
		icon_PMARKER_ACT = 505,
		icon_PMARKER_SEL = 506,
		icon_PMARKER = 507,
		icon_MARKER_HLT = 508,
		icon_MARKER = 509,
		icon_SPACE2 = 510,
		icon_SPACE3 = 511,
		icon_KEYINGSET = 512,
		icon_KEY_DEHLT = 513,
		icon_KEY_HLT = 514,
		icon_MUTE_IPO_OFF = 515,
		icon_MUTE_IPO_ON = 516,
		icon_VISIBLE_IPO_OFF = 517,
		icon_VISIBLE_IPO_ON = 518,
		icon_DRIVER = 519,
		icon_SOLO_OFF = 520,
		icon_SOLO_ON = 521,
		icon_FRAME_PREV = 522,
		icon_FRAME_NEXT = 523,
		icon_NLA_PUSHDOWN = 524,
		icon_IPO_CONSTANT = 525,
		icon_IPO_LINEAR = 526,
		icon_IPO_BEZIER = 527,
		icon_IPO_SINE = 528,
		icon_IPO_QUAD = 529,
		icon_IPO_CUBIC = 530,
		icon_IPO_QUART = 531,
		icon_IPO_QUINT = 532,
		icon_IPO_EXPO = 533,
		icon_IPO_CIRC = 534,
		icon_IPO_BOUNCE = 535,
		icon_IPO_ELASTIC = 536,
		icon_IPO_BACK = 537,
		icon_IPO_EASE_IN = 538,
		icon_IPO_EASE_OUT = 539,
		icon_IPO_EASE_IN_OUT = 540,
		icon_VERTEXSEL = 546,
		icon_EDGESEL = 547,
		icon_FACESEL = 548,
		icon_LOOPSEL = 549,
		icon_ROTATE = 551,
		icon_CURSOR = 552,
		icon_ROTATECOLLECTION = 553,
		icon_ROTATECENTER = 554,
		icon_ROTACTIVE = 555,
		icon_ALIGN = 556,
		icon_SMOOTHCURVE = 558,
		icon_SPHERECURVE = 559,
		icon_ROOTCURVE = 560,
		icon_SHARPCURVE = 561,
		icon_LINCURVE = 562,
		icon_NOCURVE = 563,
		icon_RNDCURVE = 564,
		icon_PROP_OFF = 565,
		icon_PROP_ON = 566,
		icon_PROP_CON = 567,
		icon_SCULPT_DYNTOPO = 568,
		icon_PARTICLE_POINT = 569,
		icon_PARTICLE_TIP = 570,
		icon_PARTICLE_PATH = 571,
		icon_MAN_TRANS = 572,
		icon_MAN_ROT = 573,
		icon_MAN_SCALE = 574,
		icon_MANIPUL = 575,
		icon_SNAP_OFF = 576,
		icon_SNAP_ON = 577,
		icon_SNAP_NORMAL = 578,
		icon_SNAP_INCREMENT = 579,
		icon_SNAP_VERTEX = 580,
		icon_SNAP_EDGE = 581,
		icon_SNAP_FACE = 582,
		icon_SNAP_VOLUME = 583,
		icon_STICKY_UVS_LOC = 585,
		icon_STICKY_UVS_DISABLE = 586,
		icon_STICKY_UVS_VERT = 587,
		icon_CLIPUV_DEHLT = 588,
		icon_CLIPUV_HLT = 589,
		icon_SNAP_PEEL_OBJECT = 590,
		icon_GRID = 591,
		icon_PASTEDOWN = 598,
		icon_COPYDOWN = 599,
		icon_PASTEFLIPUP = 600,
		icon_PASTEFLIPDOWN = 601,
		icon_SNAP_SURFACE = 606,
		icon_AUTOMERGE_ON = 607,
		icon_AUTOMERGE_OFF = 608,
		icon_RETOPO = 609,
		icon_UV_VERTEXSEL = 610,
		icon_UV_EDGESEL = 611,
		icon_UV_FACESEL = 612,
		icon_UV_ISLANDSEL = 613,
		icon_UV_SYNC_SELECT = 614,
		icon_BBOX = 624,
		icon_WIRE = 625,
		icon_SOLID = 626,
		icon_SMOOTH = 627,
		icon_POTATO = 628,
		icon_ORTHO = 630,
		icon_LOCKVIEW_OFF = 633,
		icon_LOCKVIEW_ON = 634,
		icon_AXIS_SIDE = 636,
		icon_AXIS_FRONT = 637,
		icon_AXIS_TOP = 638,
		icon_NDOF_DOM = 639,
		icon_NDOF_TURN = 640,
		icon_NDOF_FLY = 641,
		icon_NDOF_TRANS = 642,
		icon_LAYER_USED = 643,
		icon_LAYER_ACTIVE = 644,
		icon_SORTALPHA = 676,
		icon_SORTBYEXT = 677,
		icon_SORTTIME = 678,
		icon_SORTSIZE = 679,
		icon_LONGDISPLAY = 680,
		icon_SHORTDISPLAY = 681,
		icon_GHOST = 682,
		icon_IMGDISPLAY = 683,
		icon_SAVE_AS = 684,
		icon_SAVE_COPY = 685,
		icon_BOOKMARKS = 686,
		icon_FONTPREVIEW = 687,
		icon_FILTER = 688,
		icon_NEWFOLDER = 689,
		icon_OPEN_RECENT = 690,
		icon_FILE_PARENT = 691,
		icon_FILE_REFRESH = 692,
		icon_FILE_FOLDER = 693,
		icon_FILE_BLANK = 694,
		icon_FILE_BLEND = 695,
		icon_FILE_IMAGE = 696,
		icon_FILE_MOVIE = 697,
		icon_FILE_SCRIPT = 698,
		icon_FILE_SOUND = 699,
		icon_FILE_FONT = 700,
		icon_FILE_TEXT = 701,
		icon_RECOVER_AUTO = 702,
		icon_SAVE_PREFS = 703,
		icon_LINK_BLEND = 704,
		icon_APPEND_BLEND = 705,
		icon_IMPORT = 706,
		icon_EXPORT = 707,
		icon_EXTERNAL_DATA = 708,
		icon_LOAD_FACTORY = 709,
		icon_LOOP_BACK = 715,
		icon_LOOP_FORWARDS = 716,
		icon_BACK = 717,
		icon_FORWARD = 718,
		icon_FILE_BACKUP = 726,
		icon_DISK_DRIVE = 727,
		icon_MATPLANE = 728,
		icon_MATSPHERE = 729,
		icon_MATCUBE = 730,
		icon_MONKEY = 731,
		icon_HAIR = 732,
		icon_ALIASED = 733,
		icon_ANTIALIASED = 734,
		icon_MAT_SPHERE_SKY = 735,
		icon_WORDWRAP_OFF = 740,
		icon_WORDWRAP_ON = 741,
		icon_SYNTAX_OFF = 742,
		icon_SYNTAX_ON = 743,
		icon_LINENUMBERS_OFF = 744,
		icon_LINENUMBERS_ON = 745,
		icon_SCRIPTPLUGINS = 746,
		icon_SEQ_SEQUENCER = 754,
		icon_SEQ_PREVIEW = 755,
		icon_SEQ_LUMA_WAVEFORM = 756,
		icon_SEQ_CHROMA_SCOPE = 757,
		icon_SEQ_HISTOGRAM = 758,
		icon_SEQ_SPLITVIEW = 759,
		icon_IMAGE_RGB = 763,
		icon_IMAGE_RGB_ALPHA = 764,
		icon_IMAGE_ALPHA = 765,
		icon_IMAGE_ZDEPTH = 766,
		icon_IMAGEFILE = 767,
		icon_BRUSH_ADD = 780,
		icon_BRUSH_BLOB = 781,
		icon_BRUSH_BLUR = 782,
		icon_BRUSH_CLAY = 783,
		icon_BRUSH_CLAY_STRIPS = 784,
		icon_BRUSH_CLONE = 785,
		icon_BRUSH_CREASE = 786,
		icon_BRUSH_DARKEN = 787,
		icon_BRUSH_FILL = 788,
		icon_BRUSH_FLATTEN = 789,
		icon_BRUSH_GRAB = 790,
		icon_BRUSH_INFLATE = 791,
		icon_BRUSH_LAYER = 792,
		icon_BRUSH_LIGHTEN = 793,
		icon_BRUSH_MASK = 794,
		icon_BRUSH_MIX = 795,
		icon_BRUSH_MULTIPLY = 796,
		icon_BRUSH_NUDGE = 797,
		icon_BRUSH_PINCH = 798,
		icon_BRUSH_SCRAPE = 799,
		icon_BRUSH_SCULPT_DRAW = 800,
		icon_BRUSH_SMEAR = 801,
		icon_BRUSH_SMOOTH = 802,
		icon_BRUSH_SNAKE_HOOK = 803,
		icon_BRUSH_SOFTEN = 804,
		icon_BRUSH_SUBTRACT = 805,
		icon_BRUSH_TEXDRAW = 806,
		icon_BRUSH_TEXFILL = 807,
		icon_BRUSH_TEXMASK = 808,
		icon_BRUSH_THUMB = 809,
		icon_BRUSH_ROTATE = 810,
		icon_BRUSH_VERTEXDRAW = 811,
		icon_MATCAP_01 = 812,
		icon_MATCAP_02 = 813,
		icon_MATCAP_03 = 814,
		icon_MATCAP_04 = 815,
		icon_MATCAP_05 = 816,
		icon_MATCAP_06 = 817,
		icon_MATCAP_07 = 818,
		icon_MATCAP_08 = 819,
		icon_MATCAP_09 = 820,
		icon_MATCAP_10 = 821,
		icon_MATCAP_11 = 822,
		icon_MATCAP_12 = 823,
		icon_MATCAP_13 = 824,
		icon_MATCAP_14 = 825,
		icon_MATCAP_15 = 826,
		icon_MATCAP_16 = 827,
		icon_MATCAP_17 = 828,
		icon_MATCAP_18 = 829,
		icon_MATCAP_19 = 830,
		icon_MATCAP_20 = 831,
		icon_MATCAP_21 = 832,
		icon_MATCAP_22 = 833,
		icon_MATCAP_23 = 834,
		icon_MATCAP_24 = 835,
		icon_VIEW3D_VEC = 836,
		icon_EDIT_VEC = 837,
		icon_EDITMODE_VEC_DEHLT = 838,
		icon_EDITMODE_VEC_HLT = 839,
		icon_DISCLOSURE_TRI_RIGHT_VEC = 840,
		icon_DISCLOSURE_TRI_DOWN_VEC = 841,
		icon_MOVE_UP_VEC = 842,
		icon_MOVE_DOWN_VEC = 843,
		icon_X_VEC = 844,
		icon_SMALL_TRI_RIGHT_VEC = 845,
	};
	inline icon_enum icon(void);
	inline void icon(icon_enum value);

};

/**************** Pointer Definition ****************/

class PointerProperty : public Property {
public:
	PointerProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline Struct fixed_type(void);

};

/**************** Collection Definition ****************/

class CollectionProperty : public Property {
public:
	CollectionProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline Struct fixed_type(void);

};

/**************** Function Definition ****************/

class Function : public Pointer {
public:
	Function(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		parameters(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string identifier(void);	inline void identifier(const std::string& value);
	inline std::string description(void);	inline void description(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Property, Function, parameters, false, false, false)
	inline bool is_registered(void);
	inline void is_registered(int value);
	inline bool is_registered_optional(void);
	inline void is_registered_optional(int value);
	inline bool use_self(void);
	inline void use_self(int value);
	inline bool use_self_type(void);
	inline void use_self_type(int value);

};

/**************** Blender RNA ****************/

class BlenderRNA : public Pointer {
public:
	BlenderRNA(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		structs(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Struct, BlenderRNA, structs, true, true, true)

};

/**************** Unknown Type ****************/

class UnknownType : public Pointer {
public:
	UnknownType(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Any Type ****************/

class AnyType : public Pointer {
public:
	AnyType(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** ID ****************/

class ID : public Pointer {
public:
	ID(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline int users(void);
	inline void users(int value);
	inline bool use_fake_user(void);
	inline void use_fake_user(int value);
	inline bool tag(void);
	inline void tag(int value);
	inline bool is_updated(void);
	inline void is_updated(int value);
	inline bool is_updated_data(void);
	inline void is_updated_data(int value);
	inline bool is_library_indirect(void);
	inline void is_library_indirect(int value);
	inline Library library(void);

	inline ID copy();
	inline void user_clear();
	inline AnimData animation_data_create();
	inline void animation_data_clear();
	inline void update_tag(int refresh);
};

/**************** ID Property ****************/

class PropertyGroupItem : public Pointer {
public:
	PropertyGroupItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** ID Property Group ****************/

class PropertyGroup : public Pointer {
public:
	PropertyGroup(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Library ****************/

class Library : public ID {
public:
	Library(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline Library parent(void);
	inline PackedFile packed_file(void);

};

/**************** Texture ****************/

class Texture : public ID {
public:
	Texture(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	enum type_enum {
		type_NONE = 0,
		type_BLEND = 5,
		type_CLOUDS = 1,
		type_DISTORTED_NOISE = 13,
		type_ENVIRONMENT_MAP = 10,
		type_IMAGE = 8,
		type_MAGIC = 4,
		type_MARBLE = 3,
		type_MUSGRAVE = 11,
		type_NOISE = 7,
		type_OCEAN = 16,
		type_POINT_DENSITY = 14,
		type_STUCCI = 6,
		type_VORONOI = 12,
		type_VOXEL_DATA = 15,
		type_WOOD = 2,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use_clamp(void);
	inline void use_clamp(int value);
	inline bool use_color_ramp(void);
	inline void use_color_ramp(int value);
	inline ColorRamp color_ramp(void);
	inline float intensity(void);
	inline void intensity(float value);
	inline float contrast(void);
	inline void contrast(float value);
	inline float saturation(void);
	inline void saturation(float value);
	inline float factor_red(void);
	inline void factor_red(float value);
	inline float factor_green(void);
	inline void factor_green(float value);
	inline float factor_blue(void);
	inline void factor_blue(float value);
	inline bool use_preview_alpha(void);
	inline void use_preview_alpha(int value);
	inline bool use_nodes(void);
	inline void use_nodes(int value);
	inline NodeTree node_tree(void);
	inline AnimData animation_data(void);

	inline void evaluate(float value[3], float result[4]);
};

/**************** Clouds Texture ****************/

class CloudsTexture : public Texture {
public:
	CloudsTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float noise_scale(void);
	inline void noise_scale(float value);
	inline int noise_depth(void);
	inline void noise_depth(int value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	enum noise_type_enum {
		noise_type_SOFT_NOISE = 0,
		noise_type_HARD_NOISE = 1,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	enum cloud_type_enum {
		cloud_type_GRAYSCALE = 0,
		cloud_type_COLOR = 1,
	};
	inline cloud_type_enum cloud_type(void);
	inline void cloud_type(cloud_type_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Wood Texture ****************/

class WoodTexture : public Texture {
public:
	WoodTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float noise_scale(void);
	inline void noise_scale(float value);
	inline float turbulence(void);
	inline void turbulence(float value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	enum noise_type_enum {
		noise_type_SOFT_NOISE = 0,
		noise_type_HARD_NOISE = 1,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	enum wood_type_enum {
		wood_type_BANDS = 0,
		wood_type_RINGS = 1,
		wood_type_BANDNOISE = 2,
		wood_type_RINGNOISE = 3,
	};
	inline wood_type_enum wood_type(void);
	inline void wood_type(wood_type_enum value);
	enum noise_basis_2_enum {
		noise_basis_2_SIN = 0,
		noise_basis_2_SAW = 1,
		noise_basis_2_TRI = 2,
	};
	inline noise_basis_2_enum noise_basis_2(void);
	inline void noise_basis_2(noise_basis_2_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Marble Texture ****************/

class MarbleTexture : public Texture {
public:
	MarbleTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float noise_scale(void);
	inline void noise_scale(float value);
	inline float turbulence(void);
	inline void turbulence(float value);
	inline int noise_depth(void);
	inline void noise_depth(int value);
	enum noise_type_enum {
		noise_type_SOFT_NOISE = 0,
		noise_type_HARD_NOISE = 1,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	enum marble_type_enum {
		marble_type_SOFT = 0,
		marble_type_SHARP = 1,
		marble_type_SHARPER = 2,
	};
	inline marble_type_enum marble_type(void);
	inline void marble_type(marble_type_enum value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	enum noise_basis_2_enum {
		noise_basis_2_SIN = 0,
		noise_basis_2_SAW = 1,
		noise_basis_2_TRI = 2,
	};
	inline noise_basis_2_enum noise_basis_2(void);
	inline void noise_basis_2(noise_basis_2_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Magic Texture ****************/

class MagicTexture : public Texture {
public:
	MagicTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float turbulence(void);
	inline void turbulence(float value);
	inline int noise_depth(void);
	inline void noise_depth(int value);

};

/**************** Blend Texture ****************/

class BlendTexture : public Texture {
public:
	BlendTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	enum progression_enum {
		progression_LINEAR = 0,
		progression_QUADRATIC = 1,
		progression_EASING = 2,
		progression_DIAGONAL = 3,
		progression_SPHERICAL = 4,
		progression_QUADRATIC_SPHERE = 5,
		progression_RADIAL = 6,
	};
	inline progression_enum progression(void);
	inline void progression(progression_enum value);
	enum use_flip_axis_enum {
		use_flip_axis_HORIZONTAL = 0,
		use_flip_axis_VERTICAL = 2,
	};
	inline use_flip_axis_enum use_flip_axis(void);
	inline void use_flip_axis(use_flip_axis_enum value);

};

/**************** Stucci Texture ****************/

class StucciTexture : public Texture {
public:
	StucciTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float turbulence(void);
	inline void turbulence(float value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	inline float noise_scale(void);
	inline void noise_scale(float value);
	enum noise_type_enum {
		noise_type_SOFT_NOISE = 0,
		noise_type_HARD_NOISE = 1,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	enum stucci_type_enum {
		stucci_type_PLASTIC = 0,
		stucci_type_WALL_IN = 1,
		stucci_type_WALL_OUT = 2,
	};
	inline stucci_type_enum stucci_type(void);
	inline void stucci_type(stucci_type_enum value);

};

/**************** Noise Texture ****************/

class NoiseTexture : public Texture {
public:
	NoiseTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}


};

/**************** Image Texture ****************/

class ImageTexture : public Texture {
public:
	ImageTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline bool use_interpolation(void);
	inline void use_interpolation(int value);
	inline bool use_flip_axis(void);
	inline void use_flip_axis(int value);
	inline bool use_alpha(void);
	inline void use_alpha(int value);
	inline bool use_calculate_alpha(void);
	inline void use_calculate_alpha(int value);
	inline bool invert_alpha(void);
	inline void invert_alpha(int value);
	inline bool use_mipmap(void);
	inline void use_mipmap(int value);
	inline bool use_mipmap_gauss(void);
	inline void use_mipmap_gauss(int value);
	enum filter_type_enum {
		filter_type_BOX = 0,
		filter_type_EWA = 1,
		filter_type_FELINE = 2,
		filter_type_AREA = 3,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);
	inline int filter_probes(void);
	inline void filter_probes(int value);
	inline int filter_eccentricity(void);
	inline void filter_eccentricity(int value);
	inline bool use_filter_size_min(void);
	inline void use_filter_size_min(int value);
	inline float filter_size(void);
	inline void filter_size(float value);
	enum extension_enum {
		extension_EXTEND = 1,
		extension_CLIP = 2,
		extension_CLIP_CUBE = 4,
		extension_REPEAT = 3,
		extension_CHECKER = 5,
	};
	inline extension_enum extension(void);
	inline void extension(extension_enum value);
	inline int repeat_x(void);
	inline void repeat_x(int value);
	inline int repeat_y(void);
	inline void repeat_y(int value);
	inline bool use_mirror_x(void);
	inline void use_mirror_x(int value);
	inline bool use_mirror_y(void);
	inline void use_mirror_y(int value);
	inline bool use_checker_odd(void);
	inline void use_checker_odd(int value);
	inline bool use_checker_even(void);
	inline void use_checker_even(int value);
	inline float checker_distance(void);
	inline void checker_distance(float value);
	inline float crop_min_x(void);
	inline void crop_min_x(float value);
	inline float crop_min_y(void);
	inline void crop_min_y(float value);
	inline float crop_max_x(void);
	inline void crop_max_x(float value);
	inline float crop_max_y(void);
	inline void crop_max_y(float value);
	inline Image image(void);
	inline ImageUser image_user(void);
	inline bool use_normal_map(void);
	inline void use_normal_map(int value);
	inline bool use_derivative_map(void);
	inline void use_derivative_map(int value);

};

/**************** Environment Map ****************/

class EnvironmentMapTexture : public Texture {
public:
	EnvironmentMapTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline Image image(void);
	inline ImageUser image_user(void);
	inline bool use_mipmap(void);
	inline void use_mipmap(int value);
	inline bool use_mipmap_gauss(void);
	inline void use_mipmap_gauss(int value);
	enum filter_type_enum {
		filter_type_BOX = 0,
		filter_type_EWA = 1,
		filter_type_FELINE = 2,
		filter_type_AREA = 3,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);
	inline int filter_probes(void);
	inline void filter_probes(int value);
	inline int filter_eccentricity(void);
	inline void filter_eccentricity(int value);
	inline bool use_filter_size_min(void);
	inline void use_filter_size_min(int value);
	inline float filter_size(void);
	inline void filter_size(float value);
	inline EnvironmentMap environment_map(void);

};

/**************** Musgrave ****************/

class MusgraveTexture : public Texture {
public:
	MusgraveTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	enum musgrave_type_enum {
		musgrave_type_MULTIFRACTAL = 0,
		musgrave_type_RIDGED_MULTIFRACTAL = 1,
		musgrave_type_HYBRID_MULTIFRACTAL = 2,
		musgrave_type_FBM = 3,
		musgrave_type_HETERO_TERRAIN = 4,
	};
	inline musgrave_type_enum musgrave_type(void);
	inline void musgrave_type(musgrave_type_enum value);
	inline float dimension_max(void);
	inline void dimension_max(float value);
	inline float lacunarity(void);
	inline void lacunarity(float value);
	inline float octaves(void);
	inline void octaves(float value);
	inline float offset(void);
	inline void offset(float value);
	inline float gain(void);
	inline void gain(float value);
	inline float noise_intensity(void);
	inline void noise_intensity(float value);
	inline float noise_scale(void);
	inline void noise_scale(float value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Voronoi ****************/

class VoronoiTexture : public Texture {
public:
	VoronoiTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float weight_1(void);
	inline void weight_1(float value);
	inline float weight_2(void);
	inline void weight_2(float value);
	inline float weight_3(void);
	inline void weight_3(float value);
	inline float weight_4(void);
	inline void weight_4(float value);
	inline float minkovsky_exponent(void);
	inline void minkovsky_exponent(float value);
	enum distance_metric_enum {
		distance_metric_DISTANCE = 0,
		distance_metric_DISTANCE_SQUARED = 1,
		distance_metric_MANHATTAN = 2,
		distance_metric_CHEBYCHEV = 3,
		distance_metric_MINKOVSKY_HALF = 4,
		distance_metric_MINKOVSKY_FOUR = 5,
		distance_metric_MINKOVSKY = 6,
	};
	inline distance_metric_enum distance_metric(void);
	inline void distance_metric(distance_metric_enum value);
	enum color_mode_enum {
		color_mode_INTENSITY = 0,
		color_mode_POSITION = 1,
		color_mode_POSITION_OUTLINE = 2,
		color_mode_POSITION_OUTLINE_INTENSITY = 3,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);
	inline float noise_intensity(void);
	inline void noise_intensity(float value);
	inline float noise_scale(void);
	inline void noise_scale(float value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Distorted Noise ****************/

class DistortedNoiseTexture : public Texture {
public:
	DistortedNoiseTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float distortion(void);
	inline void distortion(float value);
	inline float noise_scale(void);
	inline void noise_scale(float value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	enum noise_distortion_enum {
		noise_distortion_BLENDER_ORIGINAL = 0,
		noise_distortion_ORIGINAL_PERLIN = 1,
		noise_distortion_IMPROVED_PERLIN = 2,
		noise_distortion_VORONOI_F1 = 3,
		noise_distortion_VORONOI_F2 = 4,
		noise_distortion_VORONOI_F3 = 5,
		noise_distortion_VORONOI_F4 = 6,
		noise_distortion_VORONOI_F2_F1 = 7,
		noise_distortion_VORONOI_CRACKLE = 8,
		noise_distortion_CELL_NOISE = 14,
	};
	inline noise_distortion_enum noise_distortion(void);
	inline void noise_distortion(noise_distortion_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** PointDensity ****************/

class PointDensity : public Pointer {
public:
	PointDensity(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum point_source_enum {
		point_source_PARTICLE_SYSTEM = 0,
		point_source_OBJECT = 1,
	};
	inline point_source_enum point_source(void);
	inline void point_source(point_source_enum value);
	inline Object object(void);
	inline ParticleSystem particle_system(void);
	enum particle_cache_space_enum {
		particle_cache_space_OBJECT_LOCATION = 0,
		particle_cache_space_OBJECT_SPACE = 1,
		particle_cache_space_WORLD_SPACE = 2,
	};
	inline particle_cache_space_enum particle_cache_space(void);
	inline void particle_cache_space(particle_cache_space_enum value);
	enum vertex_cache_space_enum {
		vertex_cache_space_OBJECT_LOCATION = 0,
		vertex_cache_space_OBJECT_SPACE = 1,
		vertex_cache_space_WORLD_SPACE = 2,
	};
	inline vertex_cache_space_enum vertex_cache_space(void);
	inline void vertex_cache_space(vertex_cache_space_enum value);
	inline float radius(void);
	inline void radius(float value);
	enum falloff_enum {
		falloff_STANDARD = 0,
		falloff_SMOOTH = 1,
		falloff_SOFT = 2,
		falloff_CONSTANT = 3,
		falloff_ROOT = 4,
		falloff_PARTICLE_AGE = 5,
		falloff_PARTICLE_VELOCITY = 6,
	};
	inline falloff_enum falloff(void);
	inline void falloff(falloff_enum value);
	inline float falloff_soft(void);
	inline void falloff_soft(float value);
	enum color_source_enum {
		color_source_CONSTANT = 0,
		color_source_PARTICLE_AGE = 1,
		color_source_PARTICLE_SPEED = 2,
		color_source_PARTICLE_VELOCITY = 3,
	};
	inline color_source_enum color_source(void);
	inline void color_source(color_source_enum value);
	inline float speed_scale(void);
	inline void speed_scale(float value);
	inline float falloff_speed_scale(void);
	inline void falloff_speed_scale(float value);
	inline ColorRamp color_ramp(void);
	inline CurveMapping falloff_curve(void);
	inline bool use_falloff_curve(void);
	inline void use_falloff_curve(int value);
	inline bool use_turbulence(void);
	inline void use_turbulence(int value);
	inline float turbulence_scale(void);
	inline void turbulence_scale(float value);
	inline float turbulence_strength(void);
	inline void turbulence_strength(float value);
	inline int turbulence_depth(void);
	inline void turbulence_depth(int value);
	enum turbulence_influence_enum {
		turbulence_influence_STATIC = 0,
		turbulence_influence_PARTICLE_VELOCITY = 1,
		turbulence_influence_PARTICLE_AGE = 2,
		turbulence_influence_GLOBAL_TIME = 3,
	};
	inline turbulence_influence_enum turbulence_influence(void);
	inline void turbulence_influence(turbulence_influence_enum value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);

};

/**************** Point Density ****************/

class PointDensityTexture : public Texture {
public:
	PointDensityTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline PointDensity point_density(void);

};

/**************** VoxelData ****************/

class VoxelData : public Pointer {
public:
	VoxelData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum interpolation_enum {
		interpolation_NEREASTNEIGHBOR = 0,
		interpolation_TRILINEAR = 1,
		interpolation_QUADRATIC = 2,
		interpolation_TRICUBIC_CATROM = 3,
		interpolation_TRICUBIC_BSPLINE = 4,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	enum smoke_data_type_enum {
		smoke_data_type_SMOKEDENSITY = 0,
		smoke_data_type_SMOKEFLAME = 3,
		smoke_data_type_SMOKEHEAT = 1,
		smoke_data_type_SMOKEVEL = 2,
	};
	inline smoke_data_type_enum smoke_data_type(void);
	inline void smoke_data_type(smoke_data_type_enum value);
	enum extension_enum {
		extension_EXTEND = 1,
		extension_CLIP = 2,
		extension_REPEAT = 3,
	};
	inline extension_enum extension(void);
	inline void extension(extension_enum value);
	inline float intensity(void);
	inline void intensity(float value);
	enum file_format_enum {
		file_format_BLENDER_VOXEL = 0,
		file_format_RAW_8BIT = 1,
		file_format_IMAGE_SEQUENCE = 3,
		file_format_SMOKE = 4,
	};
	inline file_format_enum file_format(void);
	inline void file_format(file_format_enum value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline Array<int, 3> resolution(void);
	inline void resolution(int values[3]);
	inline bool use_still_frame(void);
	inline void use_still_frame(int value);
	inline int still_frame(void);
	inline void still_frame(int value);
	inline Object domain_object(void);

};

/**************** Voxel Data ****************/

class VoxelDataTexture : public Texture {
public:
	VoxelDataTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline VoxelData voxel_data(void);
	inline Image image(void);
	inline ImageUser image_user(void);

};

/**************** Ocean ****************/

class OceanTexData : public Pointer {
public:
	OceanTexData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum output_enum {
		output_DISPLACEMENT = 1,
		output_FOAM = 2,
		output_JPLUS = 3,
		output_EMINUS = 4,
		output_EPLUS = 5,
	};
	inline output_enum output(void);
	inline void output(output_enum value);
	inline Object ocean_object(void);

};

/**************** Ocean ****************/

class OceanTexture : public Texture {
public:
	OceanTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline OceanTexData ocean(void);

};

/**************** Texture Slot ****************/

class TextureSlot : public Pointer {
public:
	TextureSlot(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Texture texture(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline Array<float, 3> offset(void);
	inline void offset(float values[3]);
	inline Array<float, 3> scale(void);
	inline void scale(float values[3]);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_ADD = 2,
		blend_type_SUBTRACT = 3,
		blend_type_MULTIPLY = 1,
		blend_type_SCREEN = 8,
		blend_type_OVERLAY = 9,
		blend_type_DIFFERENCE = 6,
		blend_type_DIVIDE = 4,
		blend_type_DARKEN = 5,
		blend_type_LIGHTEN = 7,
		blend_type_HUE = 10,
		blend_type_SATURATION = 11,
		blend_type_VALUE = 12,
		blend_type_COLOR = 13,
		blend_type_SOFT_LIGHT = 15,
		blend_type_LINEAR_LIGHT = 16,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool use_stencil(void);
	inline void use_stencil(int value);
	inline bool invert(void);
	inline void invert(int value);
	inline bool use_rgb_to_intensity(void);
	inline void use_rgb_to_intensity(int value);
	inline float default_value(void);
	inline void default_value(float value);
	enum output_node_enum {
		output_node_DUMMY = 0,
	};
	inline output_node_enum output_node(void);
	inline void output_node(output_node_enum value);

};

/**************** EnvironmentMap ****************/

class EnvironmentMap : public Pointer {
public:
	EnvironmentMap(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum source_enum {
		source_STATIC = 0,
		source_ANIMATED = 1,
		source_IMAGE_FILE = 2,
	};
	inline source_enum source(void);
	inline void source(source_enum value);
	inline Object viewpoint_object(void);
	enum mapping_enum {
		mapping_CUBE = 0,
		mapping_PLANE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline float clip_start(void);
	inline void clip_start(float value);
	inline float clip_end(void);
	inline void clip_end(float value);
	inline float zoom(void);
	inline void zoom(float value);
	inline Array<int, 20> layers_ignore(void);
	inline void layers_ignore(int values[20]);
	inline int resolution(void);
	inline void resolution(int value);
	inline int depth(void);
	inline void depth(int value);
	inline bool is_valid(void);
	inline void is_valid(int value);

	inline void clear(Context C);
	inline void save(Context C, const char * filepath, Scene scene, float layout[12]);
};

/**************** Texture Mapping ****************/

class TexMapping : public Pointer {
public:
	TexMapping(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum vector_type_enum {
		vector_type_TEXTURE = 1,
		vector_type_POINT = 0,
		vector_type_VECTOR = 2,
		vector_type_NORMAL = 3,
	};
	inline vector_type_enum vector_type(void);
	inline void vector_type(vector_type_enum value);
	inline Array<float, 3> translation(void);
	inline void translation(float values[3]);
	inline Array<float, 3> rotation(void);
	inline void rotation(float values[3]);
	inline Array<float, 3> scale(void);
	inline void scale(float values[3]);
	inline Array<float, 3> min(void);
	inline void min(float values[3]);
	inline Array<float, 3> max(void);
	inline void max(float values[3]);
	inline bool use_min(void);
	inline void use_min(int value);
	inline bool use_max(void);
	inline void use_max(int value);
	enum mapping_x_enum {
		mapping_x_NONE = 0,
		mapping_x_X = 1,
		mapping_x_Y = 2,
		mapping_x_Z = 3,
	};
	inline mapping_x_enum mapping_x(void);
	inline void mapping_x(mapping_x_enum value);
	enum mapping_y_enum {
		mapping_y_NONE = 0,
		mapping_y_X = 1,
		mapping_y_Y = 2,
		mapping_y_Z = 3,
	};
	inline mapping_y_enum mapping_y(void);
	inline void mapping_y(mapping_y_enum value);
	enum mapping_z_enum {
		mapping_z_NONE = 0,
		mapping_z_X = 1,
		mapping_z_Y = 2,
		mapping_z_Z = 3,
	};
	inline mapping_z_enum mapping_z(void);
	inline void mapping_z(mapping_z_enum value);
	enum mapping_enum {
		mapping_FLAT = 0,
		mapping_CUBE = 1,
		mapping_TUBE = 2,
		mapping_SPHERE = 3,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);

};

/**************** Color Mapping ****************/

class ColorMapping : public Pointer {
public:
	ColorMapping(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_color_ramp(void);
	inline void use_color_ramp(int value);
	inline ColorRamp color_ramp(void);
	inline float brightness(void);
	inline void brightness(float value);
	inline float contrast(void);
	inline void contrast(float value);
	inline float saturation(void);
	inline void saturation(float value);
	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_ADD = 2,
		blend_type_SUBTRACT = 3,
		blend_type_MULTIPLY = 1,
		blend_type_SCREEN = 8,
		blend_type_OVERLAY = 9,
		blend_type_DIFFERENCE = 6,
		blend_type_DIVIDE = 4,
		blend_type_DARKEN = 5,
		blend_type_LIGHTEN = 7,
		blend_type_HUE = 10,
		blend_type_SATURATION = 11,
		blend_type_VALUE = 12,
		blend_type_COLOR = 13,
		blend_type_SOFT_LIGHT = 15,
		blend_type_LINEAR_LIGHT = 16,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline Array<float, 3> blend_color(void);
	inline void blend_color(float values[3]);
	inline float blend_factor(void);
	inline void blend_factor(float value);

};

/**************** ID Materials ****************/

class IDMaterials : public Pointer {
public:
	IDMaterials(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void append(Material material);
	inline Material pop(int index, int update_data);
	inline void clear(int update_data);
};

/**************** Action F-Curves ****************/

class ActionFCurves : public Pointer {
public:
	ActionFCurves(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FCurve create(const char * data_path, int index, const char * action_group);
	inline void remove(FCurve fcurve);
};

/**************** Action Groups ****************/

class ActionGroups : public Pointer {
public:
	ActionGroups(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ActionGroup create(const char * name);
	inline void remove(ActionGroup action_group);
};

/**************** Action Pose Markers ****************/

class ActionPoseMarkers : public Pointer {
public:
	ActionPoseMarkers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline TimelineMarker active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline TimelineMarker create(const char * name);
	inline void remove(TimelineMarker marker);
};

/**************** NLA Tracks ****************/

class NlaTracks : public Pointer {
public:
	NlaTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline NlaTrack active(void);

	inline NlaTrack create(Context C, NlaTrack prev);
	inline void remove(Context C, NlaTrack track);
};

/**************** Drivers ****************/

class AnimDataDrivers : public Pointer {
public:
	AnimDataDrivers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FCurve from_existing(Context C, FCurve src_driver);
};

/**************** Keying set paths ****************/

class KeyingSetPaths : public Pointer {
public:
	KeyingSetPaths(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline KeyingSetPath active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline KeyingSetPath add(ID target_id, const char * data_path, int index, int group_method, const char * group_name);
	inline void remove(KeyingSetPath path);
	inline void clear();
};

/**************** Armature Bones ****************/

class ArmatureBones : public Pointer {
public:
	ArmatureBones(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Bone active(void);

};

/**************** Armature EditBones ****************/

class ArmatureEditBones : public Pointer {
public:
	ArmatureEditBones(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline EditBone active(void);

	inline EditBone create(const char * name);
	inline void remove(EditBone bone);
};

/**************** Curve Map Point ****************/

class CurveMapPoints : public Pointer {
public:
	CurveMapPoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline CurveMapPoint create(float position, float value);
	inline void remove(CurveMapPoint point);
};

/**************** Color Ramp Elements ****************/

class ColorRampElements : public Pointer {
public:
	ColorRampElements(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ColorRampElement create(float position);
	inline void remove(ColorRampElement element);
};

/**************** Curve Splines ****************/

class CurveSplines : public Pointer {
public:
	CurveSplines(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object active(void);

	inline Spline create(int type);
	inline void remove(Spline spline);
	inline void clear();
};

/**************** Spline Points ****************/

class SplinePoints : public Pointer {
public:
	SplinePoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Spline Bezier Points ****************/

class SplineBezierPoints : public Pointer {
public:
	SplineBezierPoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Canvas Surfaces ****************/

class DynamicPaintSurfaces : public Pointer {
public:
	DynamicPaintSurfaces(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);
	inline DynamicPaintSurface active(void);

};

/**************** Keyframe Points ****************/

class FCurveKeyframePoints : public Pointer {
public:
	FCurveKeyframePoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Keyframe insert(float frame, float value, int options);
	inline void add(int count);
	inline void remove(Keyframe keyframe, int fast);
};

/**************** F-Curve Modifiers ****************/

class FCurveModifiers : public Pointer {
public:
	FCurveModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline FModifier active(void);

	inline FModifier create(int type);
	inline void remove(FModifier modifier);
};

/**************** ChannelDriver Variables ****************/

class ChannelDriverVariables : public Pointer {
public:
	ChannelDriverVariables(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline DriverVariable create();
	inline void remove(DriverVariable variable);
};

/**************** Control Points ****************/

class FModifierEnvelopeControlPoints : public Pointer {
public:
	FModifierEnvelopeControlPoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FModifierEnvelopeControlPoint add(float frame);
	inline void remove(FModifierEnvelopeControlPoint point);
};

/**************** Grease Pencil Layers ****************/

class GreasePencilLayers : public Pointer {
public:
	GreasePencilLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline GPencilLayer active(void);

	inline GPencilLayer create(const char * name, int set_active);
	inline void remove(GPencilLayer layer);
};

/**************** Grease Pencil Frames ****************/

class GPencilFrames : public Pointer {
public:
	GPencilFrames(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline GPencilFrame create(int frame_number);
	inline void remove(GPencilFrame frame);
	inline GPencilFrame copy(GPencilFrame source);
};

/**************** Grease Pencil Frames ****************/

class GPencilStrokes : public Pointer {
public:
	GPencilStrokes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline GPencilStroke create();
	inline void remove(GPencilStroke stroke);
};

/**************** Grease Pencil Stroke Points ****************/

class GPencilStrokePoints : public Pointer {
public:
	GPencilStrokePoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
	inline void pop(int index);
};

/**************** Group Objects ****************/

class GroupObjects : public Pointer {
public:
	GroupObjects(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void link(Context C, Object object);
	inline void unlink(Context C, Object object);
};

/**************** Render Slots ****************/

class RenderSlots : public Pointer {
public:
	RenderSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline RenderSlot active(void);
	inline int active_index(void);
	inline void active_index(int value);

};

/**************** Texture Slots ****************/

class LampTextureSlots : public Pointer {
public:
	LampTextureSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LampTextureSlot add(Context C);
	inline LampTextureSlot create(Context C, int index);
	inline void clear(Context C, int index);
};

/**************** Texture Slots ****************/

class LineStyleTextureSlots : public Pointer {
public:
	LineStyleTextureSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleTextureSlot add(Context C);
	inline LineStyleTextureSlot create(Context C, int index);
	inline void clear(Context C, int index);
};

/**************** Color Modifiers ****************/

class LineStyleColorModifiers : public Pointer {
public:
	LineStyleColorModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleColorModifier create(const char * name, int type);
	inline void remove(LineStyleColorModifier modifier);
};

/**************** Alpha Modifiers ****************/

class LineStyleAlphaModifiers : public Pointer {
public:
	LineStyleAlphaModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleAlphaModifier create(const char * name, int type);
	inline void remove(LineStyleAlphaModifier modifier);
};

/**************** Thickness Modifiers ****************/

class LineStyleThicknessModifiers : public Pointer {
public:
	LineStyleThicknessModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleThicknessModifier create(const char * name, int type);
	inline void remove(LineStyleThicknessModifier modifier);
};

/**************** Geometry Modifiers ****************/

class LineStyleGeometryModifiers : public Pointer {
public:
	LineStyleGeometryModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleGeometryModifier create(const char * name, int type);
	inline void remove(LineStyleGeometryModifier modifier);
};

/**************** Main Cameras ****************/

class BlendDataCameras : public Pointer {
public:
	BlendDataCameras(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Camera create(const char * name);
	inline void remove(Camera camera);
	inline void tag(int value);
};

/**************** Main Scenes ****************/

class BlendDataScenes : public Pointer {
public:
	BlendDataScenes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Scene create(const char * name);
	inline void remove(Context C, Scene scene);
	inline void tag(int value);
};

/**************** Main Objects ****************/

class BlendDataObjects : public Pointer {
public:
	BlendDataObjects(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Object create(const char * name, ID object_data);
	inline void remove(Object object);
	inline void tag(int value);
};

/**************** Main Materials ****************/

class BlendDataMaterials : public Pointer {
public:
	BlendDataMaterials(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Material create(const char * name);
	inline void remove(Material material);
	inline void tag(int value);
};

/**************** Main Node Trees ****************/

class BlendDataNodeTrees : public Pointer {
public:
	BlendDataNodeTrees(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline NodeTree create(const char * name, int type);
	inline void remove(NodeTree tree);
	inline void tag(int value);
};

/**************** Main Meshes ****************/

class BlendDataMeshes : public Pointer {
public:
	BlendDataMeshes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Mesh create(const char * name);
	inline Mesh new_from_object(Scene scene, Object object, int apply_modifiers, int settings, int calc_tessface, int calc_undeformed);
	inline void remove(Mesh mesh);
	inline void tag(int value);
};

/**************** Main Lamps ****************/

class BlendDataLamps : public Pointer {
public:
	BlendDataLamps(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Lamp create(const char * name, int type);
	inline void remove(Lamp lamp);
	inline void tag(int value);
};

/**************** Main Libraries ****************/

class BlendDataLibraries : public Pointer {
public:
	BlendDataLibraries(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline void tag(int value);
};

/**************** Main Screens ****************/

class BlendDataScreens : public Pointer {
public:
	BlendDataScreens(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline void tag(int value);
};

/**************** Main Window Managers ****************/

class BlendDataWindowManagers : public Pointer {
public:
	BlendDataWindowManagers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline void tag(int value);
};

/**************** Main Images ****************/

class BlendDataImages : public Pointer {
public:
	BlendDataImages(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Image create(const char * name, int width, int height, int alpha, int float_buffer);
	inline Image load(const char * filepath);
	inline void remove(Image image);
	inline void tag(int value);
};

/**************** Main Lattices ****************/

class BlendDataLattices : public Pointer {
public:
	BlendDataLattices(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Lattice create(const char * name);
	inline void remove(Lattice lattice);
	inline void tag(int value);
};

/**************** Main Curves ****************/

class BlendDataCurves : public Pointer {
public:
	BlendDataCurves(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Curve create(const char * name, int type);
	inline void remove(Curve curve);
	inline void tag(int value);
};

/**************** Main Metaballs ****************/

class BlendDataMetaBalls : public Pointer {
public:
	BlendDataMetaBalls(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline MetaBall create(const char * name);
	inline void remove(MetaBall metaball);
	inline void tag(int value);
};

/**************** Main Fonts ****************/

class BlendDataFonts : public Pointer {
public:
	BlendDataFonts(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline VectorFont load(const char * filepath);
	inline void remove(VectorFont vfont);
	inline void tag(int value);
};

/**************** Main Textures ****************/

class BlendDataTextures : public Pointer {
public:
	BlendDataTextures(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Texture create(const char * name, int type);
	inline void remove(Texture texture);
	inline void tag(int value);
};

/**************** Main Brushes ****************/

class BlendDataBrushes : public Pointer {
public:
	BlendDataBrushes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Brush create(const char * name);
	inline void remove(Brush brush);
	inline void tag(int value);
};

/**************** Main Worlds ****************/

class BlendDataWorlds : public Pointer {
public:
	BlendDataWorlds(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline World create(const char * name);
	inline void remove(World world);
	inline void tag(int value);
};

/**************** Main Groups ****************/

class BlendDataGroups : public Pointer {
public:
	BlendDataGroups(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Group create(const char * name);
	inline void remove(Group group);
	inline void tag(int value);
};

/**************** Main Texts ****************/

class BlendDataTexts : public Pointer {
public:
	BlendDataTexts(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Text create(const char * name);
	inline void remove(Text text);
	inline Text load(const char * filepath, int internal);
	inline void tag(int value);
};

/**************** Main Speakers ****************/

class BlendDataSpeakers : public Pointer {
public:
	BlendDataSpeakers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Speaker create(const char * name);
	inline void remove(Speaker speaker);
	inline void tag(int value);
};

/**************** Main Sounds ****************/

class BlendDataSounds : public Pointer {
public:
	BlendDataSounds(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline void tag(int value);
};

/**************** Main Armatures ****************/

class BlendDataArmatures : public Pointer {
public:
	BlendDataArmatures(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Armature create(const char * name);
	inline void remove(Armature armature);
	inline void tag(int value);
};

/**************** Main Actions ****************/

class BlendDataActions : public Pointer {
public:
	BlendDataActions(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline Action create(const char * name);
	inline void remove(Action action);
	inline void tag(int value);
};

/**************** Main Particle Settings ****************/

class BlendDataParticles : public Pointer {
public:
	BlendDataParticles(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline ParticleSettings create(const char * name);
	inline void remove(ParticleSettings particle);
	inline void tag(int value);
};

/**************** Main Grease Pencils ****************/

class BlendDataGreasePencils : public Pointer {
public:
	BlendDataGreasePencils(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline void tag(int value);
	inline GreasePencil create(const char * name);
	inline void remove(GreasePencil grease_pencil);
};

/**************** Main Movie Clips ****************/

class BlendDataMovieClips : public Pointer {
public:
	BlendDataMovieClips(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(int value);
	inline void remove(MovieClip clip);
	inline MovieClip load(const char * filepath);
};

/**************** Main Masks ****************/

class BlendDataMasks : public Pointer {
public:
	BlendDataMasks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(int value);
	inline Mask create(const char * name);
	inline void remove(Mask mask);
};

/**************** Main Line Styles ****************/

class BlendDataLineStyles : public Pointer {
public:
	BlendDataLineStyles(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_updated(void);
	inline void is_updated(int value);

	inline void tag(int value);
	inline FreestyleLineStyle create(const char * name);
	inline void remove(FreestyleLineStyle linestyle);
};

/**************** Texture Slots ****************/

class MaterialTextureSlots : public Pointer {
public:
	MaterialTextureSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MaterialTextureSlot add(Context C);
	inline MaterialTextureSlot create(Context C, int index);
	inline void clear(Context C, int index);
};

/**************** Mesh Vertices ****************/

class MeshVertices : public Pointer {
public:
	MeshVertices(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Mesh Edges ****************/

class MeshEdges : public Pointer {
public:
	MeshEdges(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Mesh Faces ****************/

class MeshTessFaces : public Pointer {
public:
	MeshTessFaces(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active(void);
	inline void active(int value);

	inline void add(int count);
};

/**************** Mesh Loops ****************/

class MeshLoops : public Pointer {
public:
	MeshLoops(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Mesh Polygons ****************/

class MeshPolygons : public Pointer {
public:
	MeshPolygons(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active(void);
	inline void active(int value);

	inline void add(int count);
};

/**************** UV Loop Layers ****************/

class UVLoopLayers : public Pointer {
public:
	UVLoopLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MeshUVLoopLayer active(void);
	inline int active_index(void);
	inline void active_index(int value);

};

/**************** UV Maps ****************/

class TessfaceUVTextures : public Pointer {
public:
	TessfaceUVTextures(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MeshTextureFaceLayer active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline MeshTextureFaceLayer create(const char * name);
};

/**************** UV Maps ****************/

class UVTextures : public Pointer {
public:
	UVTextures(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MeshTexturePolyLayer active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline MeshTexturePolyLayer create(const char * name);
	inline void remove(MeshTexturePolyLayer layer);
};

/**************** Vertex Colors ****************/

class VertexColors : public Pointer {
public:
	VertexColors(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MeshColorLayer active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline MeshColorLayer create(const char * name);
};

/**************** Loop Colors ****************/

class LoopColors : public Pointer {
public:
	LoopColors(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MeshLoopColorLayer active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline MeshLoopColorLayer create(const char * name);
	inline void remove(MeshLoopColorLayer layer);
};

/**************** Float Properties ****************/

class FloatProperties : public Pointer {
public:
	FloatProperties(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MeshFloatPropertyLayer create(const char * name);
};

/**************** Int Properties ****************/

class IntProperties : public Pointer {
public:
	IntProperties(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MeshIntPropertyLayer create(const char * name);
};

/**************** String Properties ****************/

class StringProperties : public Pointer {
public:
	StringProperties(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MeshStringPropertyLayer create(const char * name);
};

/**************** Meta Elements ****************/

class MetaBallElements : public Pointer {
public:
	MetaBallElements(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MetaElement active(void);

	inline MetaElement create(int type);
	inline void remove(MetaElement element);
	inline void clear();
};

/**************** Nla Strips ****************/

class NlaStrips : public Pointer {
public:
	NlaStrips(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NlaStrip create(Context C, const char * name, int start, Action action);
	inline void remove(Context C, NlaStrip strip);
};

/**************** Node Inputs ****************/

class NodeInputs : public Pointer {
public:
	NodeInputs(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocket create(const char * type, const char * name, const char * identifier);
	inline void remove(NodeSocket socket);
	inline void clear();
	inline void move(int from_index, int to_index);
};

/**************** Node Outputs ****************/

class NodeOutputs : public Pointer {
public:
	NodeOutputs(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocket create(const char * type, const char * name, const char * identifier);
	inline void remove(NodeSocket socket);
	inline void clear();
	inline void move(int from_index, int to_index);
};

/**************** Nodes ****************/

class Nodes : public Pointer {
public:
	Nodes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Node active(void);

	inline Node create(Context C, const char * type);
	inline void remove(Node node);
	inline void clear();
};

/**************** Node Links ****************/

class NodeLinks : public Pointer {
public:
	NodeLinks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeLink create(NodeSocket input, NodeSocket output, int verify_limits);
	inline void remove(NodeLink link);
	inline void clear();
};

/**************** Node Tree Inputs ****************/

class NodeTreeInputs : public Pointer {
public:
	NodeTreeInputs(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocketInterface create(const char * type, const char * name);
	inline void remove(NodeSocketInterface socket);
	inline void clear();
	inline void move(int from_index, int to_index);
};

/**************** Node Tree Outputs ****************/

class NodeTreeOutputs : public Pointer {
public:
	NodeTreeOutputs(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocketInterface create(const char * type, const char * name);
	inline void remove(NodeSocketInterface socket);
	inline void clear();
	inline void move(int from_index, int to_index);
};

/**************** File Output Slots ****************/

class CompositorNodeOutputFileFileSlots : public Pointer {
public:
	CompositorNodeOutputFileFileSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocket create(Context C, const char * name);
	inline void remove(NodeSocket socket);
	inline void clear();
	inline void move(int from_index, int to_index);
};

/**************** File Output Slots ****************/

class CompositorNodeOutputFileLayerSlots : public Pointer {
public:
	CompositorNodeOutputFileLayerSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocket create(Context C, const char * name);
	inline void remove(NodeSocket socket);
	inline void clear();
	inline void move(int from_index, int to_index);
};

/**************** Object Modifiers ****************/

class ObjectModifiers : public Pointer {
public:
	ObjectModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Modifier create(Context C, const char * name, int type);
	inline void remove(Context C, Modifier modifier);
	inline void clear(Context C);
};

/**************** Object Constraints ****************/

class ObjectConstraints : public Pointer {
public:
	ObjectConstraints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Constraint active(void);

	inline Constraint create(int type);
	inline void remove(Constraint constraint);
	inline void clear();
};

/**************** Vertex Groups ****************/

class VertexGroups : public Pointer {
public:
	VertexGroups(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline VertexGroup active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline VertexGroup create(const char * name);
	inline void remove(VertexGroup group);
	inline void clear();
};

/**************** Particle Systems ****************/

class ParticleSystems : public Pointer {
public:
	ParticleSystems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ParticleSystem active(void);
	inline int active_index(void);
	inline void active_index(int value);

};

/**************** Point Caches ****************/

class PointCaches : public Pointer {
public:
	PointCaches(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);

};

/**************** Texture Slots ****************/

class ParticleSettingsTextureSlots : public Pointer {
public:
	ParticleSettingsTextureSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ParticleSettingsTextureSlot add(Context C);
	inline ParticleSettingsTextureSlot create(Context C, int index);
	inline void clear(Context C, int index);
};

/**************** Bone Groups ****************/

class BoneGroups : public Pointer {
public:
	BoneGroups(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline BoneGroup active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline BoneGroup create(const char * name);
	inline void remove(BoneGroup group);
};

/**************** PoseBone Constraints ****************/

class PoseBoneConstraints : public Pointer {
public:
	PoseBoneConstraints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Constraint active(void);

	inline Constraint create(int type);
	inline void remove(Constraint constraint);
};

/**************** Scene Bases ****************/

class SceneBases : public Pointer {
public:
	SceneBases(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ObjectBase active(void);

};

/**************** Scene Objects ****************/

class SceneObjects : public Pointer {
public:
	SceneObjects(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object active(void);

	inline ObjectBase link(Context C, Object object);
	inline void unlink(Object object);
};

/**************** Keying Sets ****************/

class KeyingSets : public Pointer {
public:
	KeyingSets(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline KeyingSet active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline KeyingSet create(const char * idname, const char * name);
};

/**************** Keying Sets All ****************/

class KeyingSetsAll : public Pointer {
public:
	KeyingSetsAll(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline KeyingSet active(void);
	inline int active_index(void);
	inline void active_index(int value);

};

/**************** Timeline Markers ****************/

class TimelineMarkers : public Pointer {
public:
	TimelineMarkers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline TimelineMarker create(const char * name, int frame);
	inline void remove(TimelineMarker marker);
	inline void clear();
};

/**************** Render Layers ****************/

class RenderLayers : public Pointer {
public:
	RenderLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);
	inline SceneRenderLayer active(void);

	inline SceneRenderLayer create(const char * name);
	inline void remove(void *main, SceneRenderLayer layer);
};

/**************** Style Modules ****************/

class FreestyleModules : public Pointer {
public:
	FreestyleModules(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FreestyleModuleSettings create();
	inline void remove(FreestyleModuleSettings module);
};

/**************** Line Sets ****************/

class Linesets : public Pointer {
public:
	Linesets(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline FreestyleLineSet active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline FreestyleLineSet create(const char * name);
	inline void remove(FreestyleLineSet lineset);
};

/**************** Area Spaces ****************/

class AreaSpaces : public Pointer {
public:
	AreaSpaces(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Space active(void);

};

/**************** Strip Modifiers ****************/

class SequenceModifiers : public Pointer {
public:
	SequenceModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline SequenceModifier create(Context C, const char * name, int type);
	inline void remove(Context C, SequenceModifier modifier);
	inline void clear(Context C);
};

/**************** Sequences ****************/

class Sequences : public Pointer {
public:
	Sequences(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Sequence new_clip(const char * name, MovieClip clip, int channel, int frame_start);
	inline Sequence new_mask(const char * name, Mask mask, int channel, int frame_start);
	inline Sequence new_scene(const char * name, Scene scene, int channel, int frame_start);
	inline Sequence new_image(const char * name, const char * filepath, int channel, int frame_start);
	inline Sequence new_movie(const char * name, const char * filepath, int channel, int frame_start);
	inline Sequence new_sound(void *main, const char * name, const char * filepath, int channel, int frame_start);
	inline Sequence new_effect(const char * name, int type, int channel, int frame_start, int frame_end, Sequence seq1, Sequence seq2, Sequence seq3);
	inline void remove(Sequence sequence);
};

/**************** SequenceElements ****************/

class SequenceElements : public Pointer {
public:
	SequenceElements(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline SequenceElement append(const char * filename);
	inline void pop(int index);
};

/**************** Background Images ****************/

class BackgroundImages : public Pointer {
public:
	BackgroundImages(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline BackgroundImage create();
	inline void remove(BackgroundImage image);
	inline void clear();
};

/**************** Path ****************/

class SpaceNodeEditorPath : public Pointer {
public:
	SpaceNodeEditorPath(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string to_string(void);	inline void to_string(const std::string& value);

	inline void clear(Context C);
	inline void start(Context C, NodeTree node_tree);
	inline void append(Context C, NodeTree node_tree, Node node);
	inline void pop(Context C);
};

/**************** User Addons ****************/

class Addons : public Pointer {
public:
	Addons(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Addon create();
	inline void remove(Addon addon);
};

/**************** Paths Compare ****************/

class PathCompareCollection : public Pointer {
public:
	PathCompareCollection(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline PathCompare create();
	inline void remove(PathCompare pathcmp);
};

/**************** KeyConfigs ****************/

class KeyConfigurations : public Pointer {
public:
	KeyConfigurations(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline KeyConfig active(void);
	inline KeyConfig default_value(void);
	inline KeyConfig addon(void);
	inline KeyConfig user(void);

	inline KeyConfig create(const char * name);
	inline void remove(KeyConfig keyconfig);
};

/**************** Key Maps ****************/

class KeyMaps : public Pointer {
public:
	KeyMaps(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline KeyMap create(const char * name, int space_type, int region_type, int modal);
	inline void remove(KeyMap keymap);
	inline KeyMap find(const char * name, int space_type, int region_type);
	inline KeyMap find_modal(const char * name);
};

/**************** KeyMap Items ****************/

class KeyMapItems : public Pointer {
public:
	KeyMapItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline KeyMapItem create(const char * idname, int type, int value, int any, int shift, int ctrl, int alt, int oskey, int key_modifier, int head);
	inline KeyMapItem new_modal(const char * propvalue, int type, int value, int any, int shift, int ctrl, int alt, int oskey, int key_modifier);
	inline void remove(KeyMapItem item);
	inline KeyMapItem from_id(int id);
};

/**************** Texture Slots ****************/

class WorldTextureSlots : public Pointer {
public:
	WorldTextureSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline WorldTextureSlot add(Context C);
	inline WorldTextureSlot create(Context C, int index);
	inline void clear(Context C, int index);
};

/**************** Movie Tracking Markers ****************/

class MovieTrackingMarkers : public Pointer {
public:
	MovieTrackingMarkers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MovieTrackingMarker find_frame(int frame, int exact);
	inline MovieTrackingMarker insert_frame(int frame, float co[2]);
	inline void delete_frame(int frame);
};

/**************** Movie Tracking Plane Markers ****************/

class MovieTrackingPlaneMarkers : public Pointer {
public:
	MovieTrackingPlaneMarkers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MovieTrackingPlaneMarker find_frame(int frame, int exact);
	inline MovieTrackingPlaneMarker insert_frame(int frame);
	inline void delete_frame(int frame);
};

/**************** Movie Tracks ****************/

class MovieTrackingTracks : public Pointer {
public:
	MovieTrackingTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingTrack active(void);

	inline MovieTrackingTrack create(const char * name, int frame);
};

/**************** Movie Plane Tracks ****************/

class MovieTrackingPlaneTracks : public Pointer {
public:
	MovieTrackingPlaneTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingPlaneTrack active(void);

};

/**************** Movie Tracks ****************/

class MovieTrackingObjectTracks : public Pointer {
public:
	MovieTrackingObjectTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingTrack active(void);

	inline MovieTrackingTrack create(const char * name, int frame);
};

/**************** Plane Tracks ****************/

class MovieTrackingObjectPlaneTracks : public Pointer {
public:
	MovieTrackingObjectPlaneTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingTrack active(void);

};

/**************** Reconstructed Cameras ****************/

class MovieTrackingReconstructedCameras : public Pointer {
public:
	MovieTrackingReconstructedCameras(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MovieReconstructedCamera find_frame(int frame);
	inline void matrix_from_frame(int frame, float matrix[16]);
};

/**************** Movie Objects ****************/

class MovieTrackingObjects : public Pointer {
public:
	MovieTrackingObjects(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingObject active(void);

	inline MovieTrackingObject create(const char * name);
	inline void remove(MovieTrackingObject object);
};

/**************** Mask Splines ****************/

class MaskSplines : public Pointer {
public:
	MaskSplines(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MaskSpline active(void);
	inline MaskSplinePoint active_point(void);

	inline MaskSpline create();
	inline void remove(MaskSpline spline);
};

/**************** Mask Spline Points ****************/

class MaskSplinePoints : public Pointer {
public:
	MaskSplinePoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
	inline void remove(MaskSplinePoint point);
};

/**************** Mask Layers ****************/

class MaskLayers : public Pointer {
public:
	MaskLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MaskLayer active(void);

	inline MaskLayer create(const char * name);
	inline void remove(MaskLayer layer);
	inline void clear();
};

/**************** Action ****************/

class Action : public ID {
public:
	Action(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		fcurves(ptr_arg),
		groups(ptr_arg),
		pose_markers(ptr_arg)
		{}

	COLLECTION_PROPERTY(ActionFCurves, FCurve, Action, fcurves, false, true, false)
	COLLECTION_PROPERTY(ActionGroups, ActionGroup, Action, groups, false, true, true)
	COLLECTION_PROPERTY(ActionPoseMarkers, TimelineMarker, Action, pose_markers, false, true, true)
	inline Array<float, 2> frame_range(void);
	inline void frame_range(float values[2]);
	enum id_root_enum {
		id_root_ACTION = 17217,
		id_root_ARMATURE = 21057,
		id_root_BRUSH = 21058,
		id_root_CAMERA = 16707,
		id_root_CURVE = 21827,
		id_root_FONT = 18006,
		id_root_GREASEPENCIL = 17479,
		id_root_GROUP = 21063,
		id_root_IMAGE = 19785,
		id_root_KEY = 17739,
		id_root_LAMP = 16716,
		id_root_LIBRARY = 18764,
		id_root_LINESTYLE = 21324,
		id_root_LATTICE = 21580,
		id_root_MASK = 21325,
		id_root_MATERIAL = 16717,
		id_root_META = 16973,
		id_root_MESH = 17741,
		id_root_NODETREE = 21582,
		id_root_OBJECT = 16975,
		id_root_PAINTCURVE = 17232,
		id_root_PALETTE = 19536,
		id_root_PARTICLE = 16720,
		id_root_SCENE = 17235,
		id_root_SCREEN = 21075,
		id_root_SPEAKER = 19283,
		id_root_SOUND = 20307,
		id_root_TEXT = 22612,
		id_root_TEXTURE = 17748,
		id_root_WORLD = 20311,
		id_root_WINDOWMANAGER = 19799,
	};
	inline id_root_enum id_root(void);
	inline void id_root(id_root_enum value);

};

/**************** Action Group ****************/

class ActionGroup : public Pointer {
public:
	ActionGroup(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		channels(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FCurve, ActionGroup, channels, false, false, false)
	inline bool select(void);
	inline void select(int value);
	inline bool lock(void);
	inline void lock(int value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	enum color_set_enum {
		color_set_DEFAULT = 0,
		color_set_THEME01 = 1,
		color_set_THEME02 = 2,
		color_set_THEME03 = 3,
		color_set_THEME04 = 4,
		color_set_THEME05 = 5,
		color_set_THEME06 = 6,
		color_set_THEME07 = 7,
		color_set_THEME08 = 8,
		color_set_THEME09 = 9,
		color_set_THEME10 = 10,
		color_set_THEME11 = 11,
		color_set_THEME12 = 12,
		color_set_THEME13 = 13,
		color_set_THEME14 = 14,
		color_set_THEME15 = 15,
		color_set_THEME16 = 16,
		color_set_THEME17 = 17,
		color_set_THEME18 = 18,
		color_set_THEME19 = 19,
		color_set_THEME20 = 20,
		color_set_CUSTOM = -1,
	};
	inline color_set_enum color_set(void);
	inline void color_set(color_set_enum value);
	inline bool is_custom_color_set(void);
	inline void is_custom_color_set(int value);
	inline ThemeBoneColorSet colors(void);

};

/**************** Dope Sheet ****************/

class DopeSheet : public Pointer {
public:
	DopeSheet(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ID source(void);
	inline bool show_datablock_filters(void);
	inline void show_datablock_filters(int value);
	inline bool show_only_selected(void);
	inline void show_only_selected(int value);
	inline bool show_hidden(void);
	inline void show_hidden(int value);
	inline bool show_only_errors(void);
	inline void show_only_errors(int value);
	inline bool show_only_group_objects(void);
	inline void show_only_group_objects(int value);
	inline Group filter_group(void);
	inline bool show_only_matching_fcurves(void);
	inline void show_only_matching_fcurves(int value);
	inline std::string filter_fcurve_name(void);	inline void filter_fcurve_name(const std::string& value);
	inline bool show_missing_nla(void);
	inline void show_missing_nla(int value);
	inline bool show_summary(void);
	inline void show_summary(int value);
	inline bool show_expanded_summary(void);
	inline void show_expanded_summary(int value);
	inline bool show_transforms(void);
	inline void show_transforms(int value);
	inline bool show_shapekeys(void);
	inline void show_shapekeys(int value);
	inline bool show_modifiers(void);
	inline void show_modifiers(int value);
	inline bool show_meshes(void);
	inline void show_meshes(int value);
	inline bool show_lattices(void);
	inline void show_lattices(int value);
	inline bool show_cameras(void);
	inline void show_cameras(int value);
	inline bool show_materials(void);
	inline void show_materials(int value);
	inline bool show_lamps(void);
	inline void show_lamps(int value);
	inline bool show_linestyles(void);
	inline void show_linestyles(int value);
	inline bool show_textures(void);
	inline void show_textures(int value);
	inline bool show_curves(void);
	inline void show_curves(int value);
	inline bool show_worlds(void);
	inline void show_worlds(int value);
	inline bool show_scenes(void);
	inline void show_scenes(int value);
	inline bool show_particles(void);
	inline void show_particles(int value);
	inline bool show_metaballs(void);
	inline void show_metaballs(int value);
	inline bool show_armatures(void);
	inline void show_armatures(int value);
	inline bool show_nodes(void);
	inline void show_nodes(int value);
	inline bool show_speakers(void);
	inline void show_speakers(int value);

};

/**************** Animation Data ****************/

class AnimData : public Pointer {
public:
	AnimData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		nla_tracks(ptr_arg),
		drivers(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(NlaTracks, NlaTrack, AnimData, nla_tracks, false, true, true)
	inline Action action(void);
	enum action_extrapolation_enum {
		action_extrapolation_NOTHING = 2,
		action_extrapolation_HOLD = 0,
		action_extrapolation_HOLD_FORWARD = 1,
	};
	inline action_extrapolation_enum action_extrapolation(void);
	inline void action_extrapolation(action_extrapolation_enum value);
	enum action_blend_type_enum {
		action_blend_type_REPLACE = 0,
		action_blend_type_ADD = 1,
		action_blend_type_SUBTRACT = 2,
		action_blend_type_MULTIPLY = 3,
	};
	inline action_blend_type_enum action_blend_type(void);
	inline void action_blend_type(action_blend_type_enum value);
	inline float action_influence(void);
	inline void action_influence(float value);
	COLLECTION_PROPERTY(AnimDataDrivers, FCurve, AnimData, drivers, false, true, false)
	inline bool use_nla(void);
	inline void use_nla(int value);

};

/**************** Keying Set ****************/

class KeyingSet : public Pointer {
public:
	KeyingSet(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		paths(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);	inline void bl_label(const std::string& value);
	inline std::string bl_description(void);	inline void bl_description(const std::string& value);
	inline KeyingSetInfo type_info(void);
	COLLECTION_PROPERTY(KeyingSetPaths, KeyingSetPath, KeyingSet, paths, false, true, true)
	inline bool is_path_absolute(void);
	inline void is_path_absolute(int value);
	enum bl_options_enum {
		bl_options_INSERTKEY_NEEDED = 1,
		bl_options_INSERTKEY_VISUAL = 2,
		bl_options_INSERTKEY_XYZ_TO_RGB = 32,
	};
	inline bl_options_enum bl_options(void);
	inline void bl_options(bl_options_enum value);

	inline void refresh(Context C);
};

/**************** Keying Set Path ****************/

class KeyingSetPath : public Pointer {
public:
	KeyingSetPath(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ID id(void);
	enum id_type_enum {
		id_type_ACTION = 17217,
		id_type_ARMATURE = 21057,
		id_type_BRUSH = 21058,
		id_type_CAMERA = 16707,
		id_type_CURVE = 21827,
		id_type_FONT = 18006,
		id_type_GREASEPENCIL = 17479,
		id_type_GROUP = 21063,
		id_type_IMAGE = 19785,
		id_type_KEY = 17739,
		id_type_LAMP = 16716,
		id_type_LIBRARY = 18764,
		id_type_LINESTYLE = 21324,
		id_type_LATTICE = 21580,
		id_type_MASK = 21325,
		id_type_MATERIAL = 16717,
		id_type_META = 16973,
		id_type_MESH = 17741,
		id_type_NODETREE = 21582,
		id_type_OBJECT = 16975,
		id_type_PAINTCURVE = 17232,
		id_type_PALETTE = 19536,
		id_type_PARTICLE = 16720,
		id_type_SCENE = 17235,
		id_type_SCREEN = 21075,
		id_type_SPEAKER = 19283,
		id_type_SOUND = 20307,
		id_type_TEXT = 22612,
		id_type_TEXTURE = 17748,
		id_type_WORLD = 20311,
		id_type_WINDOWMANAGER = 19799,
	};
	inline id_type_enum id_type(void);
	inline void id_type(id_type_enum value);
	inline std::string group(void);	inline void group(const std::string& value);
	enum group_method_enum {
		group_method_NAMED = 0,
		group_method_NONE = 1,
		group_method_KEYINGSET = 2,
	};
	inline group_method_enum group_method(void);
	inline void group_method(group_method_enum value);
	inline std::string data_path(void);	inline void data_path(const std::string& value);
	inline int array_index(void);
	inline void array_index(int value);
	inline bool use_entire_array(void);
	inline void use_entire_array(int value);
	enum bl_options_enum {
		bl_options_INSERTKEY_NEEDED = 1,
		bl_options_INSERTKEY_VISUAL = 2,
		bl_options_INSERTKEY_XYZ_TO_RGB = 32,
	};
	inline bl_options_enum bl_options(void);
	inline void bl_options(bl_options_enum value);

};

/**************** Keying Set Info ****************/

class KeyingSetInfo : public Pointer {
public:
	KeyingSetInfo(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);	inline void bl_label(const std::string& value);
	inline std::string bl_description(void);	inline void bl_description(const std::string& value);
	enum bl_options_enum {
		bl_options_INSERTKEY_NEEDED = 1,
		bl_options_INSERTKEY_VISUAL = 2,
		bl_options_INSERTKEY_XYZ_TO_RGB = 32,
	};
	inline bl_options_enum bl_options(void);
	inline void bl_options(bl_options_enum value);

};

/**************** Animation Visualization ****************/

class AnimViz : public Pointer {
public:
	AnimViz(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline AnimVizOnionSkinning onion_skin_frames(void);
	inline AnimVizMotionPaths motion_path(void);

};

/**************** Onion Skinning Settings ****************/

class AnimVizOnionSkinning : public Pointer {
public:
	AnimVizOnionSkinning(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_NONE = 0,
		type_CURRENT_FRAME = 1,
		type_RANGE = 2,
		type_KEYS = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool show_only_selected(void);
	inline void show_only_selected(int value);
	inline int frame_step(void);
	inline void frame_step(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int frame_before(void);
	inline void frame_before(int value);
	inline int frame_after(void);
	inline void frame_after(int value);

};

/**************** Motion Path Settings ****************/

class AnimVizMotionPaths : public Pointer {
public:
	AnimVizMotionPaths(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_CURRENT_FRAME = 1,
		type_RANGE = 0,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum bake_location_enum {
		bake_location_HEADS = 2,
		bake_location_TAILS = 0,
	};
	inline bake_location_enum bake_location(void);
	inline void bake_location(bake_location_enum value);
	inline bool show_frame_numbers(void);
	inline void show_frame_numbers(int value);
	inline bool show_keyframe_highlight(void);
	inline void show_keyframe_highlight(int value);
	inline bool show_keyframe_numbers(void);
	inline void show_keyframe_numbers(int value);
	inline bool show_keyframe_action_all(void);
	inline void show_keyframe_action_all(int value);
	inline int frame_step(void);
	inline void frame_step(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int frame_before(void);
	inline void frame_before(int value);
	inline int frame_after(void);
	inline void frame_after(int value);

};

/**************** Motion Path ****************/

class MotionPath : public Pointer {
public:
	MotionPath(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		points(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MotionPathVert, MotionPath, points, true, true, false)
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int length(void);
	inline void length(int value);
	inline bool use_bone_head(void);
	inline void use_bone_head(int value);
	inline bool is_modified(void);
	inline void is_modified(int value);

};

/**************** Motion Path Cache Point ****************/

class MotionPathVert : public Pointer {
public:
	MotionPathVert(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline bool select(void);
	inline void select(int value);

};

/**************** Actuator ****************/

class Actuator : public Pointer {
public:
	Actuator(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_ACTION = 15,
		type_ARMATURE = 23,
		type_CAMERA = 3,
		type_CONSTRAINT = 9,
		type_EDIT_OBJECT = 10,
		type_FILTER_2D = 19,
		type_GAME = 17,
		type_MESSAGE = 14,
		type_MOUSE = 25,
		type_MOTION = 0,
		type_PARENT = 20,
		type_PROPERTY = 6,
		type_RANDOM = 13,
		type_SCENE = 11,
		type_SOUND = 5,
		type_STATE = 22,
		type_VISIBILITY = 18,
		type_STEERING = 24,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool pin(void);
	inline void pin(int value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	inline bool active(void);
	inline void active(int value);

	inline void link(Controller controller);
	inline void unlink(Controller controller);
};

/**************** Action Actuator ****************/

class ActionActuator : public Actuator {
public:
	ActionActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum play_mode_enum {
		play_mode_PLAY = 0,
		play_mode_PINGPONG = 1,
		play_mode_FLIPPER = 2,
		play_mode_LOOPSTOP = 3,
		play_mode_LOOPEND = 4,
		play_mode_PROPERTY = 6,
	};
	inline play_mode_enum play_mode(void);
	inline void play_mode(play_mode_enum value);
	inline Action action(void);
	inline bool use_continue_last_frame(void);
	inline void use_continue_last_frame(int value);
	inline std::string property(void);	inline void property(const std::string& value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);
	inline int frame_blend_in(void);
	inline void frame_blend_in(int value);
	inline int priority(void);
	inline void priority(int value);
	inline int layer(void);
	inline void layer(int value);
	inline float layer_weight(void);
	inline void layer_weight(float value);
	inline std::string frame_property(void);	inline void frame_property(const std::string& value);
	inline bool use_additive(void);
	inline void use_additive(int value);
	inline bool use_force(void);
	inline void use_force(int value);
	inline bool use_local(void);
	inline void use_local(int value);
	inline bool apply_to_children(void);
	inline void apply_to_children(int value);
	enum blend_mode_enum {
		blend_mode_BLEND = 0,
		blend_mode_ADD = 1,
	};
	inline blend_mode_enum blend_mode(void);
	inline void blend_mode(blend_mode_enum value);

};

/**************** Motion Actuator ****************/

class ObjectActuator : public Actuator {
public:
	ObjectActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_OBJECT_NORMAL = 0,
		mode_OBJECT_SERVO = 1,
		mode_OBJECT_CHARACTER = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Object reference_object(void);
	inline int damping(void);
	inline void damping(int value);
	inline float proportional_coefficient(void);
	inline void proportional_coefficient(float value);
	inline float integral_coefficient(void);
	inline void integral_coefficient(float value);
	inline float derivate_coefficient(void);
	inline void derivate_coefficient(float value);
	inline float force_max_x(void);
	inline void force_max_x(float value);
	inline float force_min_x(void);
	inline void force_min_x(float value);
	inline float force_max_y(void);
	inline void force_max_y(float value);
	inline float force_min_y(void);
	inline void force_min_y(float value);
	inline float force_max_z(void);
	inline void force_max_z(float value);
	inline float force_min_z(void);
	inline void force_min_z(float value);
	inline Array<float, 3> offset_location(void);
	inline void offset_location(float values[3]);
	inline Array<float, 3> offset_rotation(void);
	inline void offset_rotation(float values[3]);
	inline Array<float, 3> force(void);
	inline void force(float values[3]);
	inline Array<float, 3> torque(void);
	inline void torque(float values[3]);
	inline Array<float, 3> linear_velocity(void);
	inline void linear_velocity(float values[3]);
	inline Array<float, 3> angular_velocity(void);
	inline void angular_velocity(float values[3]);
	inline bool use_local_location(void);
	inline void use_local_location(int value);
	inline bool use_local_rotation(void);
	inline void use_local_rotation(int value);
	inline bool use_local_force(void);
	inline void use_local_force(int value);
	inline bool use_local_torque(void);
	inline void use_local_torque(int value);
	inline bool use_local_linear_velocity(void);
	inline void use_local_linear_velocity(int value);
	inline bool use_local_angular_velocity(void);
	inline void use_local_angular_velocity(int value);
	inline bool use_add_linear_velocity(void);
	inline void use_add_linear_velocity(int value);
	inline bool use_add_character_location(void);
	inline void use_add_character_location(int value);
	inline bool use_servo_limit_x(void);
	inline void use_servo_limit_x(int value);
	inline bool use_servo_limit_y(void);
	inline void use_servo_limit_y(int value);
	inline bool use_servo_limit_z(void);
	inline void use_servo_limit_z(int value);
	inline bool use_character_jump(void);
	inline void use_character_jump(int value);

};

/**************** Camera Actuator ****************/

class CameraActuator : public Actuator {
public:
	CameraActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	inline Object object(void);
	inline float height(void);
	inline void height(float value);
	inline float min(void);
	inline void min(float value);
	inline float max(void);
	inline void max(float value);
	inline float damping(void);
	inline void damping(float value);
	enum axis_enum {
		axis_POS_X = 0,
		axis_POS_Y = 1,
		axis_NEG_X = 3,
		axis_NEG_Y = 4,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);

};

/**************** Sound ****************/

class SoundActuator : public Actuator {
public:
	SoundActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	inline Sound sound(void);
	enum mode_enum {
		mode_PLAYSTOP = 0,
		mode_PLAYEND = 1,
		mode_LOOPSTOP = 2,
		mode_LOOPEND = 3,
		mode_LOOPBIDIRECTIONAL = 4,
		mode_LOOPBIDIRECTIONALSTOP = 5,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline float volume(void);
	inline void volume(float value);
	inline float pitch(void);
	inline void pitch(float value);
	inline float gain_3d_min(void);
	inline void gain_3d_min(float value);
	inline float gain_3d_max(void);
	inline void gain_3d_max(float value);
	inline float distance_3d_reference(void);
	inline void distance_3d_reference(float value);
	inline float distance_3d_max(void);
	inline void distance_3d_max(float value);
	inline float rolloff_factor_3d(void);
	inline void rolloff_factor_3d(float value);
	inline float cone_outer_gain_3d(void);
	inline void cone_outer_gain_3d(float value);
	inline float cone_outer_angle_3d(void);
	inline void cone_outer_angle_3d(float value);
	inline float cone_inner_angle_3d(void);
	inline void cone_inner_angle_3d(float value);
	inline bool use_sound_3d(void);
	inline void use_sound_3d(int value);

};

/**************** Property Actuator ****************/

class PropertyActuator : public Actuator {
public:
	PropertyActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_ASSIGN = 0,
		mode_ADD = 1,
		mode_COPY = 2,
		mode_TOGGLE = 3,
		mode_LEVEL = 4,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline std::string property(void);	inline void property(const std::string& value);
	inline std::string value(void);	inline void value(const std::string& value);
	inline Object object(void);
	inline std::string object_property(void);	inline void object_property(const std::string& value);

};

/**************** Constraint Actuator ****************/

class ConstraintActuator : public Actuator {
public:
	ConstraintActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_LOC = 0,
		mode_DIST = 1,
		mode_ORI = 2,
		mode_FH = 3,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	enum limit_enum {
		limit_NONE = 0,
		limit_LOCX = 1,
		limit_LOCY = 2,
		limit_LOCZ = 4,
	};
	inline limit_enum limit(void);
	inline void limit(limit_enum value);
	enum direction_enum {
		direction_NONE = 0,
		direction_DIRPX = 1,
		direction_DIRPY = 2,
		direction_DIRPZ = 4,
		direction_DIRNX = 8,
		direction_DIRNY = 16,
		direction_DIRNZ = 32,
	};
	inline direction_enum direction(void);
	inline void direction(direction_enum value);
	enum direction_axis_enum {
		direction_axis_NONE = 0,
		direction_axis_DIRPX = 1,
		direction_axis_DIRPY = 2,
		direction_axis_DIRPZ = 4,
		direction_axis_DIRNX = 8,
		direction_axis_DIRNY = 16,
		direction_axis_DIRNZ = 32,
	};
	inline direction_axis_enum direction_axis(void);
	inline void direction_axis(direction_axis_enum value);
	inline float limit_min(void);
	inline void limit_min(float value);
	inline float limit_max(void);
	inline void limit_max(float value);
	inline int damping(void);
	inline void damping(int value);
	inline float range(void);
	inline void range(float value);
	inline float distance(void);
	inline void distance(float value);
	inline std::string material(void);	inline void material(const std::string& value);
	inline std::string property(void);	inline void property(const std::string& value);
	inline int time(void);
	inline void time(int value);
	inline int damping_rotation(void);
	inline void damping_rotation(int value);
	enum direction_axis_pos_enum {
		direction_axis_pos_NONE = 0,
		direction_axis_pos_DIRPX = 1,
		direction_axis_pos_DIRPY = 2,
		direction_axis_pos_DIRPZ = 4,
	};
	inline direction_axis_pos_enum direction_axis_pos(void);
	inline void direction_axis_pos(direction_axis_pos_enum value);
	inline Array<float, 3> rotation_max(void);
	inline void rotation_max(float values[3]);
	inline float angle_min(void);
	inline void angle_min(float value);
	inline float angle_max(void);
	inline void angle_max(float value);
	inline float fh_height(void);
	inline void fh_height(float value);
	inline float fh_force(void);
	inline void fh_force(float value);
	inline float fh_damping(void);
	inline void fh_damping(float value);
	inline bool use_force_distance(void);
	inline void use_force_distance(int value);
	inline bool use_local(void);
	inline void use_local(int value);
	inline bool use_normal(void);
	inline void use_normal(int value);
	inline bool use_persistent(void);
	inline void use_persistent(int value);
	inline bool use_material_detect(void);
	inline void use_material_detect(int value);
	inline bool use_fh_paralel_axis(void);
	inline void use_fh_paralel_axis(int value);
	inline bool use_fh_normal(void);
	inline void use_fh_normal(int value);

};

/**************** Edit Object Actuator ****************/

class EditObjectActuator : public Actuator {
public:
	EditObjectActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_ADDOBJECT = 0,
		mode_ENDOBJECT = 1,
		mode_REPLACEMESH = 2,
		mode_TRACKTO = 3,
		mode_DYNAMICS = 4,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	enum dynamic_operation_enum {
		dynamic_operation_RESTOREDYN = 0,
		dynamic_operation_SUSPENDDYN = 1,
		dynamic_operation_ENABLERIGIDBODY = 2,
		dynamic_operation_DISABLERIGIDBODY = 3,
		dynamic_operation_SETMASS = 4,
	};
	inline dynamic_operation_enum dynamic_operation(void);
	inline void dynamic_operation(dynamic_operation_enum value);
	enum up_axis_enum {
		up_axis_UPAXISX = 0,
		up_axis_UPAXISY = 1,
		up_axis_UPAXISZ = 2,
	};
	inline up_axis_enum up_axis(void);
	inline void up_axis(up_axis_enum value);
	enum track_axis_enum {
		track_axis_TRACKAXISX = 0,
		track_axis_TRACKAXISY = 1,
		track_axis_TRACKAXISZ = 2,
		track_axis_TRACKAXISNEGX = 3,
		track_axis_TRACKAXISNEGY = 4,
		track_axis_TRACKAXISNEGZ = 5,
	};
	inline track_axis_enum track_axis(void);
	inline void track_axis(track_axis_enum value);
	inline Object object(void);
	inline Object track_object(void);
	inline Mesh mesh(void);
	inline int time(void);
	inline void time(int value);
	inline float mass(void);
	inline void mass(float value);
	inline Array<float, 3> linear_velocity(void);
	inline void linear_velocity(float values[3]);
	inline Array<float, 3> angular_velocity(void);
	inline void angular_velocity(float values[3]);
	inline bool use_local_linear_velocity(void);
	inline void use_local_linear_velocity(int value);
	inline bool use_local_angular_velocity(void);
	inline void use_local_angular_velocity(int value);
	inline bool use_replace_display_mesh(void);
	inline void use_replace_display_mesh(int value);
	inline bool use_replace_physics_mesh(void);
	inline void use_replace_physics_mesh(int value);
	inline bool use_3d_tracking(void);
	inline void use_3d_tracking(int value);

};

/**************** Scene Actuator ****************/

class SceneActuator : public Actuator {
public:
	SceneActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_RESTART = 0,
		mode_SET = 1,
		mode_CAMERA = 2,
		mode_ADDFRONT = 3,
		mode_ADDBACK = 4,
		mode_REMOVE = 5,
		mode_SUSPEND = 6,
		mode_RESUME = 7,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Object camera(void);
	inline Scene scene(void);

};

/**************** Random Actuator ****************/

class RandomActuator : public Actuator {
public:
	RandomActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	inline int seed(void);
	inline void seed(int value);
	inline std::string property(void);	inline void property(const std::string& value);
	enum distribution_enum {
		distribution_BOOL_CONSTANT = 0,
		distribution_BOOL_UNIFORM = 1,
		distribution_BOOL_BERNOUILLI = 2,
		distribution_INT_CONSTANT = 3,
		distribution_INT_UNIFORM = 4,
		distribution_INT_POISSON = 5,
		distribution_FLOAT_CONSTANT = 6,
		distribution_FLOAT_UNIFORM = 7,
		distribution_FLOAT_NORMAL = 8,
		distribution_FLOAT_NEGATIVE_EXPONENTIAL = 9,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);
	inline bool use_always_true(void);
	inline void use_always_true(int value);
	inline float chance(void);
	inline void chance(float value);
	inline int int_value(void);
	inline void int_value(int value);
	inline int int_min(void);
	inline void int_min(int value);
	inline int int_max(void);
	inline void int_max(int value);
	inline float int_mean(void);
	inline void int_mean(float value);
	inline float float_value(void);
	inline void float_value(float value);
	inline float float_min(void);
	inline void float_min(float value);
	inline float float_max(void);
	inline void float_max(float value);
	inline float float_mean(void);
	inline void float_mean(float value);
	inline float standard_derivation(void);
	inline void standard_derivation(float value);
	inline float half_life_time(void);
	inline void half_life_time(float value);

};

/**************** Message Actuator ****************/

class MessageActuator : public Actuator {
public:
	MessageActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	inline std::string to_property(void);	inline void to_property(const std::string& value);
	inline std::string subject(void);	inline void subject(const std::string& value);
	enum body_type_enum {
		body_type_TEXT = 0,
		body_type_PROPERTY = 1,
	};
	inline body_type_enum body_type(void);
	inline void body_type(body_type_enum value);
	inline std::string body_message(void);	inline void body_message(const std::string& value);
	inline std::string body_property(void);	inline void body_property(const std::string& value);

};

/**************** Game Actuator ****************/

class GameActuator : public Actuator {
public:
	GameActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_START = 0,
		mode_RESTART = 2,
		mode_QUIT = 3,
		mode_SAVECFG = 4,
		mode_LOADCFG = 5,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline std::string filename(void);	inline void filename(const std::string& value);

};

/**************** Visibility Actuator ****************/

class VisibilityActuator : public Actuator {
public:
	VisibilityActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	inline bool use_visible(void);
	inline void use_visible(int value);
	inline bool use_occlusion(void);
	inline void use_occlusion(int value);
	inline bool apply_to_children(void);
	inline void apply_to_children(int value);

};

/**************** Filter 2D Actuator ****************/

class Filter2DActuator : public Actuator {
public:
	Filter2DActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_ENABLE = -2,
		mode_DISABLE = -1,
		mode_REMOVE = 0,
		mode_MOTIONBLUR = 1,
		mode_BLUR = 2,
		mode_SHARPEN = 3,
		mode_DILATION = 4,
		mode_EROSION = 5,
		mode_LAPLACIAN = 6,
		mode_SOBEL = 7,
		mode_PREWITT = 8,
		mode_GRAYSCALE = 9,
		mode_SEPIA = 10,
		mode_INVERT = 11,
		mode_CUSTOMFILTER = 12,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Text glsl_shader(void);
	inline int filter_pass(void);
	inline void filter_pass(int value);
	inline float motion_blur_factor(void);
	inline void motion_blur_factor(float value);
	inline bool use_motion_blur(void);
	inline void use_motion_blur(int value);

};

/**************** Parent Actuator ****************/

class ParentActuator : public Actuator {
public:
	ParentActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_SETPARENT = 0,
		mode_REMOVEPARENT = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Object object(void);
	inline bool use_compound(void);
	inline void use_compound(int value);
	inline bool use_ghost(void);
	inline void use_ghost(int value);

};

/**************** State Actuator ****************/

class StateActuator : public Actuator {
public:
	StateActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum operation_enum {
		operation_SET = 0,
		operation_ADD = 1,
		operation_REMOVE = 2,
		operation_CHANGE = 3,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);
	inline Array<int, 30> states(void);
	inline void states(int values[30]);

};

/**************** Armature Actuator ****************/

class ArmatureActuator : public Actuator {
public:
	ArmatureActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_RUN = 0,
		mode_ENABLE = 1,
		mode_DISABLE = 2,
		mode_SETTARGET = 3,
		mode_SETWEIGHT = 4,
		mode_SETINFLUENCE = 5,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline std::string bone(void);	inline void bone(const std::string& value);
	inline std::string constraint(void);	inline void constraint(const std::string& value);
	inline Object target(void);
	inline Object secondary_target(void);
	inline float weight(void);
	inline void weight(float value);
	inline float influence(void);
	inline void influence(float value);

};

/**************** Steering Actuator ****************/

class SteeringActuator : public Actuator {
public:
	SteeringActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_SEEK = 0,
		mode_FLEE = 1,
		mode_PATHFOLLOWING = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline float velocity(void);
	inline void velocity(float value);
	inline float acceleration(void);
	inline void acceleration(float value);
	inline float turn_speed(void);
	inline void turn_speed(float value);
	inline float distance(void);
	inline void distance(float value);
	inline Object target(void);
	inline bool self_terminated(void);
	inline void self_terminated(int value);
	inline bool show_visualization(void);
	inline void show_visualization(int value);
	inline int update_period(void);
	inline void update_period(int value);
	inline Object navmesh(void);
	inline bool facing(void);
	inline void facing(int value);
	enum facing_axis_enum {
		facing_axis_X = 1,
		facing_axis_Y = 2,
		facing_axis_Z = 3,
		facing_axis_NEG_X = 4,
		facing_axis_NEG_Y = 5,
		facing_axis_NEG_Z = 6,
	};
	inline facing_axis_enum facing_axis(void);
	inline void facing_axis(facing_axis_enum value);
	inline bool normal_up(void);
	inline void normal_up(int value);

};

/**************** Mouse Actuator ****************/

class MouseActuator : public Actuator {
public:
	MouseActuator(const PointerRNA &ptr_arg) :
		Actuator(ptr_arg)
		{}

	enum mode_enum {
		mode_VISIBILITY = 0,
		mode_LOOK = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool visible(void);
	inline void visible(int value);
	inline bool use_axis_x(void);
	inline void use_axis_x(int value);
	inline bool use_axis_y(void);
	inline void use_axis_y(int value);
	inline bool reset_x(void);
	inline void reset_x(int value);
	inline bool reset_y(void);
	inline void reset_y(int value);
	inline bool local_x(void);
	inline void local_x(int value);
	inline bool local_y(void);
	inline void local_y(int value);
	inline float threshold_x(void);
	inline void threshold_x(float value);
	inline float threshold_y(void);
	inline void threshold_y(float value);
	enum object_axis_x_enum {
		object_axis_x_OBJECT_AXIS_X = 0,
		object_axis_x_OBJECT_AXIS_Y = 1,
		object_axis_x_OBJECT_AXIS_Z = 2,
	};
	inline object_axis_x_enum object_axis_x(void);
	inline void object_axis_x(object_axis_x_enum value);
	enum object_axis_y_enum {
		object_axis_y_OBJECT_AXIS_X = 0,
		object_axis_y_OBJECT_AXIS_Y = 1,
		object_axis_y_OBJECT_AXIS_Z = 2,
	};
	inline object_axis_y_enum object_axis_y(void);
	inline void object_axis_y(object_axis_y_enum value);
	inline float sensitivity_x(void);
	inline void sensitivity_x(float value);
	inline float sensitivity_y(void);
	inline void sensitivity_y(float value);
	inline float min_x(void);
	inline void min_x(float value);
	inline float max_x(void);
	inline void max_x(float value);
	inline float min_y(void);
	inline void min_y(float value);
	inline float max_y(void);
	inline void max_y(float value);

};

/**************** Armature ****************/

class Armature : public ID {
public:
	Armature(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		bones(ptr_arg),
		edit_bones(ptr_arg)
		{}

	inline AnimData animation_data(void);
	COLLECTION_PROPERTY(ArmatureBones, Bone, Armature, bones, false, false, true)
	COLLECTION_PROPERTY(ArmatureEditBones, EditBone, Armature, edit_bones, false, true, true)
	enum pose_position_enum {
		pose_position_POSE = 0,
		pose_position_REST = 1,
	};
	inline pose_position_enum pose_position(void);
	inline void pose_position(pose_position_enum value);
	enum draw_type_enum {
		draw_type_OCTAHEDRAL = 0,
		draw_type_STICK = 1,
		draw_type_BBONE = 2,
		draw_type_ENVELOPE = 3,
		draw_type_WIRE = 4,
	};
	inline draw_type_enum draw_type(void);
	inline void draw_type(draw_type_enum value);
	enum deform_method_enum {
		deform_method_BLENDER = 0,
		deform_method_BGE_CPU = 1,
	};
	inline deform_method_enum deform_method(void);
	inline void deform_method(deform_method_enum value);
	enum ghost_type_enum {
		ghost_type_CURRENT_FRAME = 0,
		ghost_type_RANGE = 1,
		ghost_type_KEYS = 2,
	};
	inline ghost_type_enum ghost_type(void);
	inline void ghost_type(ghost_type_enum value);
	inline Array<int, 32> layers(void);
	inline void layers(int values[32]);
	inline Array<int, 32> layers_protected(void);
	inline void layers_protected(int values[32]);
	inline bool show_axes(void);
	inline void show_axes(int value);
	inline bool show_names(void);
	inline void show_names(int value);
	inline bool use_deform_delay(void);
	inline void use_deform_delay(int value);
	inline bool use_mirror_x(void);
	inline void use_mirror_x(int value);
	inline bool use_auto_ik(void);
	inline void use_auto_ik(int value);
	inline bool show_bone_custom_shapes(void);
	inline void show_bone_custom_shapes(int value);
	inline bool show_group_colors(void);
	inline void show_group_colors(int value);
	inline bool show_only_ghost_selected(void);
	inline void show_only_ghost_selected(int value);
	inline int ghost_step(void);
	inline void ghost_step(int value);
	inline int ghost_size(void);
	inline void ghost_size(int value);
	inline int ghost_frame_start(void);
	inline void ghost_frame_start(int value);
	inline int ghost_frame_end(void);
	inline void ghost_frame_end(int value);
	inline bool is_editmode(void);
	inline void is_editmode(int value);

	inline void transform(float matrix[16]);
};

/**************** Bone ****************/

class Bone : public Pointer {
public:
	Bone(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		children(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Bone parent(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Bone, Bone, children, false, true, true)
	inline std::string name(void);	inline void name(const std::string& value);
	inline Array<int, 32> layers(void);
	inline void layers(int values[32]);
	inline bool use_connect(void);
	inline void use_connect(int value);
	inline bool use_inherit_rotation(void);
	inline void use_inherit_rotation(int value);
	inline bool use_envelope_multiply(void);
	inline void use_envelope_multiply(int value);
	inline bool use_deform(void);
	inline void use_deform(int value);
	inline bool use_inherit_scale(void);
	inline void use_inherit_scale(int value);
	inline bool use_local_location(void);
	inline void use_local_location(int value);
	inline bool use_relative_parent(void);
	inline void use_relative_parent(int value);
	inline bool show_wire(void);
	inline void show_wire(int value);
	inline bool use_cyclic_offset(void);
	inline void use_cyclic_offset(int value);
	inline bool hide_select(void);
	inline void hide_select(int value);
	inline float envelope_distance(void);
	inline void envelope_distance(float value);
	inline float envelope_weight(void);
	inline void envelope_weight(float value);
	inline float head_radius(void);
	inline void head_radius(float value);
	inline float tail_radius(void);
	inline void tail_radius(float value);
	inline int bbone_segments(void);
	inline void bbone_segments(int value);
	inline float bbone_in(void);
	inline void bbone_in(float value);
	inline float bbone_out(void);
	inline void bbone_out(float value);
	inline float bbone_x(void);
	inline void bbone_x(float value);
	inline float bbone_z(void);
	inline void bbone_z(float value);
	inline bool hide(void);
	inline void hide(int value);
	inline bool select(void);
	inline void select(int value);
	inline bool select_head(void);
	inline void select_head(int value);
	inline bool select_tail(void);
	inline void select_tail(int value);
	inline Array<float, 9> matrix(void);
	inline void matrix(float values[9]);
	inline Array<float, 16> matrix_local(void);
	inline void matrix_local(float values[16]);
	inline Array<float, 3> tail(void);
	inline void tail(float values[3]);
	inline Array<float, 3> tail_local(void);
	inline void tail_local(float values[3]);
	inline Array<float, 3> head(void);
	inline void head(float values[3]);
	inline Array<float, 3> head_local(void);
	inline void head_local(float values[3]);

	inline float evaluate_envelope(float point[3]);
};

/**************** Edit Bone ****************/

class EditBone : public Pointer {
public:
	EditBone(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline EditBone parent(void);
	inline float roll(void);
	inline void roll(float value);
	inline Array<float, 3> head(void);
	inline void head(float values[3]);
	inline Array<float, 3> tail(void);
	inline void tail(float values[3]);
	inline std::string name(void);	inline void name(const std::string& value);
	inline Array<int, 32> layers(void);
	inline void layers(int values[32]);
	inline bool use_connect(void);
	inline void use_connect(int value);
	inline bool use_inherit_rotation(void);
	inline void use_inherit_rotation(int value);
	inline bool use_envelope_multiply(void);
	inline void use_envelope_multiply(int value);
	inline bool use_deform(void);
	inline void use_deform(int value);
	inline bool use_inherit_scale(void);
	inline void use_inherit_scale(int value);
	inline bool use_local_location(void);
	inline void use_local_location(int value);
	inline bool use_relative_parent(void);
	inline void use_relative_parent(int value);
	inline bool show_wire(void);
	inline void show_wire(int value);
	inline bool use_cyclic_offset(void);
	inline void use_cyclic_offset(int value);
	inline bool hide_select(void);
	inline void hide_select(int value);
	inline float envelope_distance(void);
	inline void envelope_distance(float value);
	inline float envelope_weight(void);
	inline void envelope_weight(float value);
	inline float head_radius(void);
	inline void head_radius(float value);
	inline float tail_radius(void);
	inline void tail_radius(float value);
	inline int bbone_segments(void);
	inline void bbone_segments(int value);
	inline float bbone_in(void);
	inline void bbone_in(float value);
	inline float bbone_out(void);
	inline void bbone_out(float value);
	inline float bbone_x(void);
	inline void bbone_x(float value);
	inline float bbone_z(void);
	inline void bbone_z(float value);
	inline bool hide(void);
	inline void hide(int value);
	inline bool lock(void);
	inline void lock(int value);
	inline bool select(void);
	inline void select(int value);
	inline bool select_head(void);
	inline void select_head(int value);
	inline bool select_tail(void);
	inline void select_tail(int value);
	inline Array<float, 16> matrix(void);
	inline void matrix(float values[16]);

	inline void align_roll(float vector[3]);
};

/**************** Boid Rule ****************/

class BoidRule : public Pointer {
public:
	BoidRule(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_GOAL = 1,
		type_AVOID = 2,
		type_AVOID_COLLISION = 3,
		type_SEPARATE = 4,
		type_FLOCK = 5,
		type_FOLLOW_LEADER = 6,
		type_AVERAGE_SPEED = 7,
		type_FIGHT = 8,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use_in_air(void);
	inline void use_in_air(int value);
	inline bool use_on_land(void);
	inline void use_on_land(int value);

};

/**************** Goal ****************/

class BoidRuleGoal : public BoidRule {
public:
	BoidRuleGoal(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline Object object(void);
	inline bool use_predict(void);
	inline void use_predict(int value);

};

/**************** Avoid ****************/

class BoidRuleAvoid : public BoidRule {
public:
	BoidRuleAvoid(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline Object object(void);
	inline bool use_predict(void);
	inline void use_predict(int value);
	inline float fear_factor(void);
	inline void fear_factor(float value);

};

/**************** Avoid Collision ****************/

class BoidRuleAvoidCollision : public BoidRule {
public:
	BoidRuleAvoidCollision(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline bool use_avoid(void);
	inline void use_avoid(int value);
	inline bool use_avoid_collision(void);
	inline void use_avoid_collision(int value);
	inline float look_ahead(void);
	inline void look_ahead(float value);

};

/**************** Follow Leader ****************/

class BoidRuleFollowLeader : public BoidRule {
public:
	BoidRuleFollowLeader(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline Object object(void);
	inline float distance(void);
	inline void distance(float value);
	inline int queue_count(void);
	inline void queue_count(int value);
	inline bool use_line(void);
	inline void use_line(int value);

};

/**************** Average Speed ****************/

class BoidRuleAverageSpeed : public BoidRule {
public:
	BoidRuleAverageSpeed(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline float wander(void);
	inline void wander(float value);
	inline float level(void);
	inline void level(float value);
	inline float speed(void);
	inline void speed(float value);

};

/**************** Fight ****************/

class BoidRuleFight : public BoidRule {
public:
	BoidRuleFight(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline float distance(void);
	inline void distance(float value);
	inline float flee_distance(void);
	inline void flee_distance(float value);

};

/**************** Boid State ****************/

class BoidState : public Pointer {
public:
	BoidState(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		rules(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum ruleset_type_enum {
		ruleset_type_FUZZY = 0,
		ruleset_type_RANDOM = 1,
		ruleset_type_AVERAGE = 2,
	};
	inline ruleset_type_enum ruleset_type(void);
	inline void ruleset_type(ruleset_type_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoidRule, BoidState, rules, false, true, true)
	inline BoidRule active_boid_rule(void);
	inline int active_boid_rule_index(void);
	inline void active_boid_rule_index(int value);
	inline float rule_fuzzy(void);
	inline void rule_fuzzy(float value);
	inline float volume(void);
	inline void volume(float value);
	inline float falloff(void);
	inline void falloff(float value);

};

/**************** Boid Settings ****************/

class BoidSettings : public Pointer {
public:
	BoidSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		states(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float land_smooth(void);
	inline void land_smooth(float value);
	inline float bank(void);
	inline void bank(float value);
	inline float pitch(void);
	inline void pitch(float value);
	inline float height(void);
	inline void height(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoidState, BoidSettings, states, false, true, true)
	inline BoidRule active_boid_state(void);
	inline int active_boid_state_index(void);
	inline void active_boid_state_index(int value);
	inline float health(void);
	inline void health(float value);
	inline float strength(void);
	inline void strength(float value);
	inline float aggression(void);
	inline void aggression(float value);
	inline float accuracy(void);
	inline void accuracy(float value);
	inline float range(void);
	inline void range(float value);
	inline float air_speed_min(void);
	inline void air_speed_min(float value);
	inline float air_speed_max(void);
	inline void air_speed_max(float value);
	inline float air_acc_max(void);
	inline void air_acc_max(float value);
	inline float air_ave_max(void);
	inline void air_ave_max(float value);
	inline float air_personal_space(void);
	inline void air_personal_space(float value);
	inline float land_jump_speed(void);
	inline void land_jump_speed(float value);
	inline float land_speed_max(void);
	inline void land_speed_max(float value);
	inline float land_acc_max(void);
	inline void land_acc_max(float value);
	inline float land_ave_max(void);
	inline void land_ave_max(float value);
	inline float land_personal_space(void);
	inline void land_personal_space(float value);
	inline float land_stick_force(void);
	inline void land_stick_force(float value);
	inline bool use_flight(void);
	inline void use_flight(int value);
	inline bool use_land(void);
	inline void use_land(int value);
	inline bool use_climb(void);
	inline void use_climb(int value);

};

/**************** Brush ****************/

class Brush : public ID {
public:
	Brush(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUB = 2,
		blend_MUL = 3,
		blend_LIGHTEN = 4,
		blend_DARKEN = 5,
		blend_ERASE_ALPHA = 6,
		blend_ADD_ALPHA = 7,
		blend_OVERLAY = 8,
		blend_HARDLIGHT = 9,
		blend_COLORBURN = 10,
		blend_LINEARBURN = 11,
		blend_COLORDODGE = 12,
		blend_SCREEN = 13,
		blend_SOFTLIGHT = 14,
		blend_PINLIGHT = 15,
		blend_VIVIDLIGHT = 16,
		blend_LINEARLIGHT = 17,
		blend_DIFFERENCE = 18,
		blend_EXCLUSION = 19,
		blend_HUE = 20,
		blend_SATURATION = 21,
		blend_LUMINOSITY = 22,
		blend_COLOR = 23,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	enum sculpt_tool_enum {
		sculpt_tool_BLOB = 17,
		sculpt_tool_CLAY = 8,
		sculpt_tool_CLAY_STRIPS = 18,
		sculpt_tool_CREASE = 16,
		sculpt_tool_DRAW = 1,
		sculpt_tool_FILL = 9,
		sculpt_tool_FLATTEN = 7,
		sculpt_tool_GRAB = 5,
		sculpt_tool_INFLATE = 4,
		sculpt_tool_LAYER = 6,
		sculpt_tool_MASK = 19,
		sculpt_tool_NUDGE = 11,
		sculpt_tool_PINCH = 3,
		sculpt_tool_ROTATE = 14,
		sculpt_tool_SCRAPE = 10,
		sculpt_tool_SIMPLIFY = 15,
		sculpt_tool_SMOOTH = 2,
		sculpt_tool_SNAKE_HOOK = 13,
		sculpt_tool_THUMB = 12,
	};
	inline sculpt_tool_enum sculpt_tool(void);
	inline void sculpt_tool(sculpt_tool_enum value);
	enum vertex_tool_enum {
		vertex_tool_MIX = 0,
		vertex_tool_ADD = 1,
		vertex_tool_SUB = 2,
		vertex_tool_MUL = 3,
		vertex_tool_BLUR = 4,
		vertex_tool_LIGHTEN = 5,
		vertex_tool_DARKEN = 6,
	};
	inline vertex_tool_enum vertex_tool(void);
	inline void vertex_tool(vertex_tool_enum value);
	enum image_tool_enum {
		image_tool_DRAW = 0,
		image_tool_SOFTEN = 1,
		image_tool_SMEAR = 2,
		image_tool_CLONE = 3,
		image_tool_FILL = 4,
		image_tool_MASK = 5,
	};
	inline image_tool_enum image_tool(void);
	inline void image_tool(image_tool_enum value);
	enum direction_enum {
		direction_ADD = 0,
		direction_SUBTRACT = 512,
	};
	inline direction_enum direction(void);
	inline void direction(direction_enum value);
	enum stroke_method_enum {
		stroke_method_DOTS = 0,
		stroke_method_DRAG_DOT = 8388608,
		stroke_method_SPACE = 1024,
		stroke_method_AIRBRUSH = 1,
		stroke_method_ANCHORED = 256,
		stroke_method_LINE = 536870912,
		stroke_method_CURVE = -2147483648,
	};
	inline stroke_method_enum stroke_method(void);
	inline void stroke_method(stroke_method_enum value);
	enum texture_angle_source_random_enum {
		texture_angle_source_random_USER = 0,
		texture_angle_source_random_RAKE = 128,
		texture_angle_source_random_RANDOM = 33554432,
	};
	inline texture_angle_source_random_enum texture_angle_source_random(void);
	inline void texture_angle_source_random(texture_angle_source_random_enum value);
	enum texture_angle_source_no_random_enum {
		texture_angle_source_no_random_USER = 0,
		texture_angle_source_no_random_RAKE = 128,
	};
	inline texture_angle_source_no_random_enum texture_angle_source_no_random(void);
	inline void texture_angle_source_no_random(texture_angle_source_no_random_enum value);
	enum sculpt_plane_enum {
		sculpt_plane_AREA = 0,
		sculpt_plane_VIEW = 1,
		sculpt_plane_X = 2,
		sculpt_plane_Y = 3,
		sculpt_plane_Z = 4,
	};
	inline sculpt_plane_enum sculpt_plane(void);
	inline void sculpt_plane(sculpt_plane_enum value);
	enum mask_tool_enum {
		mask_tool_DRAW = 0,
		mask_tool_SMOOTH = 1,
	};
	inline mask_tool_enum mask_tool(void);
	inline void mask_tool(mask_tool_enum value);
	inline int size(void);
	inline void size(int value);
	inline float unprojected_radius(void);
	inline void unprojected_radius(float value);
	inline float jitter(void);
	inline void jitter(float value);
	inline int jitter_absolute(void);
	inline void jitter_absolute(int value);
	inline int spacing(void);
	inline void spacing(int value);
	inline int grad_spacing(void);
	inline void grad_spacing(int value);
	inline int smooth_stroke_radius(void);
	inline void smooth_stroke_radius(int value);
	inline float smooth_stroke_factor(void);
	inline void smooth_stroke_factor(float value);
	inline float rate(void);
	inline void rate(float value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline Array<float, 3> secondary_color(void);
	inline void secondary_color(float values[3]);
	inline float weight(void);
	inline void weight(float value);
	inline float strength(void);
	inline void strength(float value);
	inline float plane_offset(void);
	inline void plane_offset(float value);
	inline float plane_trim(void);
	inline void plane_trim(float value);
	inline float height(void);
	inline void height(float value);
	inline float texture_sample_bias(void);
	inline void texture_sample_bias(float value);
	inline float normal_weight(void);
	inline void normal_weight(float value);
	inline float crease_pinch_factor(void);
	inline void crease_pinch_factor(float value);
	inline float auto_smooth_factor(void);
	inline void auto_smooth_factor(float value);
	inline Array<float, 2> stencil_pos(void);
	inline void stencil_pos(float values[2]);
	inline Array<float, 2> stencil_dimension(void);
	inline void stencil_dimension(float values[2]);
	inline Array<float, 2> mask_stencil_pos(void);
	inline void mask_stencil_pos(float values[2]);
	inline Array<float, 2> mask_stencil_dimension(void);
	inline void mask_stencil_dimension(float values[2]);
	inline float sharp_threshold(void);
	inline void sharp_threshold(float value);
	inline float fill_threshold(void);
	inline void fill_threshold(float value);
	inline int blur_kernel_radius(void);
	inline void blur_kernel_radius(int value);
	enum blur_mode_enum {
		blur_mode_BOX = 1,
		blur_mode_GAUSSIAN = 0,
	};
	inline blur_mode_enum blur_mode(void);
	inline void blur_mode(blur_mode_enum value);
	inline bool use_airbrush(void);
	inline void use_airbrush(int value);
	inline bool use_original_normal(void);
	inline void use_original_normal(int value);
	inline bool use_wrap(void);
	inline void use_wrap(int value);
	inline bool use_pressure_strength(void);
	inline void use_pressure_strength(int value);
	inline bool use_offset_pressure(void);
	inline void use_offset_pressure(int value);
	inline bool use_pressure_size(void);
	inline void use_pressure_size(int value);
	inline bool use_gradient(void);
	inline void use_gradient(int value);
	inline bool use_pressure_jitter(void);
	inline void use_pressure_jitter(int value);
	inline bool use_pressure_spacing(void);
	inline void use_pressure_spacing(int value);
	enum use_pressure_masking_enum {
		use_pressure_masking_NONE = 0,
		use_pressure_masking_RAMP = 2,
		use_pressure_masking_CUTOFF = 4,
	};
	inline use_pressure_masking_enum use_pressure_masking(void);
	inline void use_pressure_masking(use_pressure_masking_enum value);
	inline bool use_inverse_smooth_pressure(void);
	inline void use_inverse_smooth_pressure(int value);
	inline bool use_rake(void);
	inline void use_rake(int value);
	inline bool use_relative_jitter(void);
	inline void use_relative_jitter(int value);
	inline bool use_random_rotation(void);
	inline void use_random_rotation(int value);
	inline bool use_plane_trim(void);
	inline void use_plane_trim(int value);
	inline bool use_frontface(void);
	inline void use_frontface(int value);
	inline bool use_anchor(void);
	inline void use_anchor(int value);
	inline bool use_space(void);
	inline void use_space(int value);
	inline bool use_line(void);
	inline void use_line(int value);
	inline bool use_curve(void);
	inline void use_curve(int value);
	inline bool use_smooth_stroke(void);
	inline void use_smooth_stroke(int value);
	inline bool use_persistent(void);
	inline void use_persistent(int value);
	inline bool use_accumulate(void);
	inline void use_accumulate(int value);
	inline bool use_space_attenuation(void);
	inline void use_space_attenuation(int value);
	inline bool use_adaptive_space(void);
	inline void use_adaptive_space(int value);
	inline bool use_locked_size(void);
	inline void use_locked_size(int value);
	inline bool use_edge_to_edge(void);
	inline void use_edge_to_edge(int value);
	inline bool use_restore_mesh(void);
	inline void use_restore_mesh(int value);
	inline bool use_alpha(void);
	inline void use_alpha(int value);
	inline CurveMapping curve(void);
	inline PaintCurve paint_curve(void);
	inline ColorRamp gradient(void);
	enum gradient_stroke_mode_enum {
		gradient_stroke_mode_PRESSURE = 0,
		gradient_stroke_mode_SPACING_REPEAT = 1,
		gradient_stroke_mode_SPACING_CLAMP = 2,
	};
	inline gradient_stroke_mode_enum gradient_stroke_mode(void);
	inline void gradient_stroke_mode(gradient_stroke_mode_enum value);
	enum gradient_fill_mode_enum {
		gradient_fill_mode_LINEAR = 0,
		gradient_fill_mode_RADIAL = 1,
	};
	inline gradient_fill_mode_enum gradient_fill_mode(void);
	inline void gradient_fill_mode(gradient_fill_mode_enum value);
	inline bool use_primary_overlay(void);
	inline void use_primary_overlay(int value);
	inline bool use_secondary_overlay(void);
	inline void use_secondary_overlay(int value);
	inline bool use_cursor_overlay(void);
	inline void use_cursor_overlay(int value);
	inline bool use_cursor_overlay_override(void);
	inline void use_cursor_overlay_override(int value);
	inline bool use_primary_overlay_override(void);
	inline void use_primary_overlay_override(int value);
	inline bool use_secondary_overlay_override(void);
	inline void use_secondary_overlay_override(int value);
	inline bool use_paint_sculpt(void);
	inline void use_paint_sculpt(int value);
	inline bool use_paint_vertex(void);
	inline void use_paint_vertex(int value);
	inline bool use_paint_weight(void);
	inline void use_paint_weight(int value);
	inline bool use_paint_image(void);
	inline void use_paint_image(int value);
	inline BrushTextureSlot texture_slot(void);
	inline Texture texture(void);
	inline BrushTextureSlot mask_texture_slot(void);
	inline Texture mask_texture(void);
	inline int texture_overlay_alpha(void);
	inline void texture_overlay_alpha(int value);
	inline int mask_overlay_alpha(void);
	inline void mask_overlay_alpha(int value);
	inline int cursor_overlay_alpha(void);
	inline void cursor_overlay_alpha(int value);
	inline Array<float, 3> cursor_color_add(void);
	inline void cursor_color_add(float values[3]);
	inline Array<float, 3> cursor_color_subtract(void);
	inline void cursor_color_subtract(float values[3]);
	inline bool use_custom_icon(void);
	inline void use_custom_icon(int value);
	inline std::string icon_filepath(void);	inline void icon_filepath(const std::string& value);
	inline Image clone_image(void);
	inline float clone_alpha(void);
	inline void clone_alpha(float value);
	inline Array<float, 2> clone_offset(void);
	inline void clone_offset(float values[2]);
	inline BrushCapabilities brush_capabilities(void);
	inline SculptToolCapabilities sculpt_capabilities(void);
	inline ImapaintToolCapabilities image_paint_capabilities(void);

};

/**************** Brush Capabilities ****************/

class BrushCapabilities : public Pointer {
public:
	BrushCapabilities(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool has_overlay(void);
	inline void has_overlay(int value);
	inline bool has_random_texture_angle(void);
	inline void has_random_texture_angle(int value);
	inline bool has_texture_angle(void);
	inline void has_texture_angle(int value);
	inline bool has_texture_angle_source(void);
	inline void has_texture_angle_source(int value);
	inline bool has_spacing(void);
	inline void has_spacing(int value);
	inline bool has_smooth_stroke(void);
	inline void has_smooth_stroke(int value);

};

/**************** Sculpt Capabilities ****************/

class SculptToolCapabilities : public Pointer {
public:
	SculptToolCapabilities(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool has_accumulate(void);
	inline void has_accumulate(int value);
	inline bool has_auto_smooth(void);
	inline void has_auto_smooth(int value);
	inline bool has_height(void);
	inline void has_height(int value);
	inline bool has_jitter(void);
	inline void has_jitter(int value);
	inline bool has_normal_weight(void);
	inline void has_normal_weight(int value);
	inline bool has_persistence(void);
	inline void has_persistence(int value);
	inline bool has_pinch_factor(void);
	inline void has_pinch_factor(int value);
	inline bool has_plane_offset(void);
	inline void has_plane_offset(int value);
	inline bool has_random_texture_angle(void);
	inline void has_random_texture_angle(int value);
	inline bool has_sculpt_plane(void);
	inline void has_sculpt_plane(int value);
	inline bool has_secondary_color(void);
	inline void has_secondary_color(int value);
	inline bool has_smooth_stroke(void);
	inline void has_smooth_stroke(int value);
	inline bool has_space_attenuation(void);
	inline void has_space_attenuation(int value);
	inline bool has_strength_pressure(void);
	inline void has_strength_pressure(int value);
	inline bool has_gravity(void);
	inline void has_gravity(int value);

};

/**************** Image Paint Capabilities ****************/

class ImapaintToolCapabilities : public Pointer {
public:
	ImapaintToolCapabilities(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool has_accumulate(void);
	inline void has_accumulate(int value);
	inline bool has_space_attenuation(void);
	inline void has_space_attenuation(int value);
	inline bool has_radius(void);
	inline void has_radius(int value);

};

/**************** Brush Texture Slot ****************/

class BrushTextureSlot : public TextureSlot {
public:
	BrushTextureSlot(const PointerRNA &ptr_arg) :
		TextureSlot(ptr_arg)
		{}

	inline float angle(void);
	inline void angle(float value);
	enum map_mode_enum {
		map_mode_VIEW_PLANE = 0,
		map_mode_AREA_PLANE = 3,
		map_mode_TILED = 1,
		map_mode_3D = 2,
		map_mode_RANDOM = 4,
		map_mode_STENCIL = 5,
	};
	inline map_mode_enum map_mode(void);
	inline void map_mode(map_mode_enum value);
	enum tex_paint_map_mode_enum {
		tex_paint_map_mode_VIEW_PLANE = 0,
		tex_paint_map_mode_TILED = 1,
		tex_paint_map_mode_3D = 2,
		tex_paint_map_mode_RANDOM = 4,
		tex_paint_map_mode_STENCIL = 5,
	};
	inline tex_paint_map_mode_enum tex_paint_map_mode(void);
	inline void tex_paint_map_mode(tex_paint_map_mode_enum value);
	enum mask_map_mode_enum {
		mask_map_mode_VIEW_PLANE = 0,
		mask_map_mode_TILED = 1,
		mask_map_mode_RANDOM = 4,
		mask_map_mode_STENCIL = 5,
	};
	inline mask_map_mode_enum mask_map_mode(void);
	inline void mask_map_mode(mask_map_mode_enum value);

};

/**************** Operator Stroke Element ****************/

class OperatorStrokeElement : public PropertyGroup {
public:
	OperatorStrokeElement(const PointerRNA &ptr_arg) :
		PropertyGroup(ptr_arg)
		{}


};

/**************** Camera ****************/

class Camera : public ID {
public:
	Camera(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	enum type_enum {
		type_PERSP = 0,
		type_ORTHO = 1,
		type_PANO = 2,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum show_guide_enum {
		show_guide_CENTER = 1,
		show_guide_CENTER_DIAGONAL = 2,
		show_guide_THIRDS = 4,
		show_guide_GOLDEN = 8,
		show_guide_GOLDEN_TRIANGLE_A = 16,
		show_guide_GOLDEN_TRIANGLE_B = 32,
		show_guide_HARMONY_TRIANGLE_A = 64,
		show_guide_HARMONY_TRIANGLE_B = 128,
	};
	inline show_guide_enum show_guide(void);
	inline void show_guide(show_guide_enum value);
	enum sensor_fit_enum {
		sensor_fit_AUTO = 0,
		sensor_fit_HORIZONTAL = 1,
		sensor_fit_VERTICAL = 2,
	};
	inline sensor_fit_enum sensor_fit(void);
	inline void sensor_fit(sensor_fit_enum value);
	inline float passepartout_alpha(void);
	inline void passepartout_alpha(float value);
	inline float angle_x(void);
	inline void angle_x(float value);
	inline float angle_y(void);
	inline void angle_y(float value);
	inline float angle(void);
	inline void angle(float value);
	inline float clip_start(void);
	inline void clip_start(float value);
	inline float clip_end(void);
	inline void clip_end(float value);
	inline float lens(void);
	inline void lens(float value);
	inline float sensor_width(void);
	inline void sensor_width(float value);
	inline float sensor_height(void);
	inline void sensor_height(float value);
	inline float ortho_scale(void);
	inline void ortho_scale(float value);
	inline float draw_size(void);
	inline void draw_size(float value);
	inline float shift_x(void);
	inline void shift_x(float value);
	inline float shift_y(void);
	inline void shift_y(float value);
	inline float dof_distance(void);
	inline void dof_distance(float value);
	inline bool show_limits(void);
	inline void show_limits(int value);
	inline bool show_mist(void);
	inline void show_mist(int value);
	inline bool show_passepartout(void);
	inline void show_passepartout(int value);
	inline bool show_title_safe(void);
	inline void show_title_safe(int value);
	inline bool show_name(void);
	inline void show_name(int value);
	inline bool show_sensor(void);
	inline void show_sensor(int value);
	enum lens_unit_enum {
		lens_unit_MILLIMETERS = 0,
		lens_unit_FOV = 32,
	};
	inline lens_unit_enum lens_unit(void);
	inline void lens_unit(lens_unit_enum value);
	inline AnimData animation_data(void);
	inline Object dof_object(void);

	inline void view_frame(Scene scene, float result_1[3], float result_2[3], float result_3[3], float result_4[3]);
};

/**************** Cloth Settings ****************/

class ClothSettings : public Pointer {
public:
	ClothSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float goal_min(void);
	inline void goal_min(float value);
	inline float goal_max(void);
	inline void goal_max(float value);
	inline float goal_default(void);
	inline void goal_default(float value);
	inline float goal_spring(void);
	inline void goal_spring(float value);
	inline float goal_friction(void);
	inline void goal_friction(float value);
	inline float internal_friction(void);
	inline void internal_friction(float value);
	inline float collider_friction(void);
	inline void collider_friction(float value);
	inline float mass(void);
	inline void mass(float value);
	inline std::string vertex_group_mass(void);	inline void vertex_group_mass(const std::string& value);
	inline Array<float, 3> gravity(void);
	inline void gravity(float values[3]);
	inline float air_damping(void);
	inline void air_damping(float value);
	inline float vel_damping(void);
	inline void vel_damping(float value);
	inline bool use_pin_cloth(void);
	inline void use_pin_cloth(int value);
	inline float pin_stiffness(void);
	inline void pin_stiffness(float value);
	inline int quality(void);
	inline void quality(int value);
	inline std::string vertex_group_shrink(void);	inline void vertex_group_shrink(const std::string& value);
	inline float shrink_min(void);
	inline void shrink_min(float value);
	inline float shrink_max(void);
	inline void shrink_max(float value);
	inline bool use_stiffness_scale(void);
	inline void use_stiffness_scale(int value);
	inline float spring_damping(void);
	inline void spring_damping(float value);
	inline float structural_stiffness(void);
	inline void structural_stiffness(float value);
	inline float structural_stiffness_max(void);
	inline void structural_stiffness_max(float value);
	inline float sewing_force_max(void);
	inline void sewing_force_max(float value);
	inline std::string vertex_group_structural_stiffness(void);	inline void vertex_group_structural_stiffness(const std::string& value);
	inline float bending_stiffness(void);
	inline void bending_stiffness(float value);
	inline float bending_stiffness_max(void);
	inline void bending_stiffness_max(float value);
	inline bool use_sewing_springs(void);
	inline void use_sewing_springs(int value);
	inline std::string vertex_group_bending(void);	inline void vertex_group_bending(const std::string& value);
	inline EffectorWeights effector_weights(void);
	inline int pre_roll(void);
	inline void pre_roll(int value);
	inline ShapeKey rest_shape_key(void);

};

/**************** Cloth Collision Settings ****************/

class ClothCollisionSettings : public Pointer {
public:
	ClothCollisionSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_collision(void);
	inline void use_collision(int value);
	inline float repel_force(void);
	inline void repel_force(float value);
	inline float distance_repel(void);
	inline void distance_repel(float value);
	inline float distance_min(void);
	inline void distance_min(float value);
	inline float friction(void);
	inline void friction(float value);
	inline int collision_quality(void);
	inline void collision_quality(int value);
	inline bool use_self_collision(void);
	inline void use_self_collision(int value);
	inline float self_distance_min(void);
	inline void self_distance_min(float value);
	inline float self_friction(void);
	inline void self_friction(float value);
	inline int self_collision_quality(void);
	inline void self_collision_quality(int value);
	inline Group group(void);
	inline std::string vertex_group_self_collisions(void);	inline void vertex_group_self_collisions(const std::string& value);

};

/**************** CurveMapPoint ****************/

class CurveMapPoint : public Pointer {
public:
	CurveMapPoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 2> location(void);
	inline void location(float values[2]);
	enum handle_type_enum {
		handle_type_AUTO = 0,
		handle_type_VECTOR = 2,
	};
	inline handle_type_enum handle_type(void);
	inline void handle_type(handle_type_enum value);
	inline bool select(void);
	inline void select(int value);

};

/**************** CurveMap ****************/

class CurveMap : public Pointer {
public:
	CurveMap(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		points(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum extend_enum {
		extend_HORIZONTAL = 0,
		extend_EXTRAPOLATED = 1,
	};
	inline extend_enum extend(void);
	inline void extend(extend_enum value);
	COLLECTION_PROPERTY(CurveMapPoints, CurveMapPoint, CurveMap, points, true, true, false)

	inline float evaluate(float position);
};

/**************** CurveMapping ****************/

class CurveMapping : public Pointer {
public:
	CurveMapping(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		curves(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_clip(void);
	inline void use_clip(int value);
	inline float clip_min_x(void);
	inline void clip_min_x(float value);
	inline float clip_min_y(void);
	inline void clip_min_y(float value);
	inline float clip_max_x(void);
	inline void clip_max_x(float value);
	inline float clip_max_y(void);
	inline void clip_max_y(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, CurveMap, CurveMapping, curves, true, false, false)
	inline Array<float, 3> black_level(void);
	inline void black_level(float values[3]);
	inline Array<float, 3> white_level(void);
	inline void white_level(float values[3]);

	inline void update();
	inline void initialize();
};

/**************** Color Ramp Element ****************/

class ColorRampElement : public Pointer {
public:
	ColorRampElement(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);
	inline float alpha(void);
	inline void alpha(float value);
	inline float position(void);
	inline void position(float value);

};

/**************** Color Ramp ****************/

class ColorRamp : public Pointer {
public:
	ColorRamp(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		elements(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(ColorRampElements, ColorRampElement, ColorRamp, elements, true, true, false)
	enum interpolation_enum {
		interpolation_EASE = 1,
		interpolation_CARDINAL = 3,
		interpolation_LINEAR = 0,
		interpolation_B_SPLINE = 2,
		interpolation_CONSTANT = 4,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	enum hue_interpolation_enum {
		hue_interpolation_NEAR = 0,
		hue_interpolation_FAR = 1,
		hue_interpolation_CW = 2,
		hue_interpolation_CCW = 3,
	};
	inline hue_interpolation_enum hue_interpolation(void);
	inline void hue_interpolation(hue_interpolation_enum value);
	enum color_mode_enum {
		color_mode_RGB = 0,
		color_mode_HSV = 1,
		color_mode_HSL = 2,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);

	inline void evaluate(float position, float color[4]);
};

/**************** Histogram ****************/

class Histogram : public Pointer {
public:
	Histogram(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum mode_enum {
		mode_LUMA = 0,
		mode_RGB = 1,
		mode_R = 2,
		mode_G = 3,
		mode_B = 4,
		mode_A = 5,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool show_line(void);
	inline void show_line(int value);

};

/**************** Scopes ****************/

class Scopes : public Pointer {
public:
	Scopes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_full_resolution(void);
	inline void use_full_resolution(int value);
	inline float accuracy(void);
	inline void accuracy(float value);
	inline Histogram histogram(void);
	enum waveform_mode_enum {
		waveform_mode_LUMA = 0,
		waveform_mode_RGB = 1,
		waveform_mode_YCBCR601 = 2,
		waveform_mode_YCBCR709 = 3,
		waveform_mode_YCBCRJPG = 4,
	};
	inline waveform_mode_enum waveform_mode(void);
	inline void waveform_mode(waveform_mode_enum value);
	inline float waveform_alpha(void);
	inline void waveform_alpha(float value);
	inline float vectorscope_alpha(void);
	inline void vectorscope_alpha(float value);

};

/**************** ColorManagedDisplaySettings ****************/

class ColorManagedDisplaySettings : public Pointer {
public:
	ColorManagedDisplaySettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum display_device_enum {
		display_device_DEFAULT = 0,
	};
	inline display_device_enum display_device(void);
	inline void display_device(display_device_enum value);

};

/**************** ColorManagedViewSettings ****************/

class ColorManagedViewSettings : public Pointer {
public:
	ColorManagedViewSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum look_enum {
		look_NONE = 0,
	};
	inline look_enum look(void);
	inline void look(look_enum value);
	enum view_transform_enum {
		view_transform_NONE = 0,
	};
	inline view_transform_enum view_transform(void);
	inline void view_transform(view_transform_enum value);
	inline float exposure(void);
	inline void exposure(float value);
	inline float gamma(void);
	inline void gamma(float value);
	inline CurveMapping curve_mapping(void);
	inline bool use_curve_mapping(void);
	inline void use_curve_mapping(int value);

};

/**************** ColorManagedInputColorspaceSettings ****************/

class ColorManagedInputColorspaceSettings : public Pointer {
public:
	ColorManagedInputColorspaceSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum name_enum {
		name_NONE = 0,
	};
	inline name_enum name(void);
	inline void name(name_enum value);

};

/**************** ColorManagedSequencerColorspaceSettings ****************/

class ColorManagedSequencerColorspaceSettings : public Pointer {
public:
	ColorManagedSequencerColorspaceSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum name_enum {
		name_NONE = 0,
	};
	inline name_enum name(void);
	inline void name(name_enum value);

};

/**************** Constraint ****************/

class Constraint : public Pointer {
public:
	Constraint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_CAMERA_SOLVER = 27,
		type_FOLLOW_TRACK = 26,
		type_OBJECT_SOLVER = 28,
		type_COPY_LOCATION = 9,
		type_COPY_ROTATION = 8,
		type_COPY_SCALE = 10,
		type_COPY_TRANSFORMS = 23,
		type_LIMIT_DISTANCE = 14,
		type_LIMIT_LOCATION = 6,
		type_LIMIT_ROTATION = 5,
		type_LIMIT_SCALE = 7,
		type_MAINTAIN_VOLUME = 24,
		type_TRANSFORM = 19,
		type_CLAMP_TO = 18,
		type_DAMPED_TRACK = 21,
		type_IK = 3,
		type_LOCKED_TRACK = 13,
		type_SPLINE_IK = 22,
		type_STRETCH_TO = 15,
		type_TRACK_TO = 2,
		type_ACTION = 12,
		type_CHILD_OF = 1,
		type_FLOOR = 16,
		type_FOLLOW_PATH = 4,
		type_PIVOT = 25,
		type_RIGID_BODY_JOINT = 17,
		type_SHRINKWRAP = 20,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum owner_space_enum {
		owner_space_WORLD = 0,
		owner_space_POSE = 2,
		owner_space_LOCAL_WITH_PARENT = 3,
		owner_space_LOCAL = 1,
	};
	inline owner_space_enum owner_space(void);
	inline void owner_space(owner_space_enum value);
	enum target_space_enum {
		target_space_WORLD = 0,
		target_space_POSE = 2,
		target_space_LOCAL_WITH_PARENT = 3,
		target_space_LOCAL = 1,
	};
	inline target_space_enum target_space(void);
	inline void target_space(target_space_enum value);
	inline bool mute(void);
	inline void mute(int value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	inline bool is_valid(void);
	inline void is_valid(int value);
	inline bool active(void);
	inline void active(int value);
	inline bool is_proxy_local(void);
	inline void is_proxy_local(int value);
	inline float influence(void);
	inline void influence(float value);
	inline float error_location(void);
	inline void error_location(float value);
	inline float error_rotation(void);
	inline void error_rotation(float value);

};

/**************** Constraint Target ****************/

class ConstraintTarget : public Pointer {
public:
	ConstraintTarget(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);

};

/**************** Child Of Constraint ****************/

class ChildOfConstraint : public Constraint {
public:
	ChildOfConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	inline bool use_location_x(void);
	inline void use_location_x(int value);
	inline bool use_location_y(void);
	inline void use_location_y(int value);
	inline bool use_location_z(void);
	inline void use_location_z(int value);
	inline bool use_rotation_x(void);
	inline void use_rotation_x(int value);
	inline bool use_rotation_y(void);
	inline void use_rotation_y(int value);
	inline bool use_rotation_z(void);
	inline void use_rotation_z(int value);
	inline bool use_scale_x(void);
	inline void use_scale_x(int value);
	inline bool use_scale_y(void);
	inline void use_scale_y(int value);
	inline bool use_scale_z(void);
	inline void use_scale_z(int value);
	inline Array<float, 16> inverse_matrix(void);
	inline void inverse_matrix(float values[16]);

};

/**************** Python Constraint ****************/

class PythonConstraint : public Constraint {
public:
	PythonConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg),
		targets(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, ConstraintTarget, PythonConstraint, targets, false, true, false)
	inline int target_count(void);
	inline void target_count(int value);
	inline Text text(void);
	inline bool use_targets(void);
	inline void use_targets(int value);
	inline bool has_script_error(void);
	inline void has_script_error(int value);

};

/**************** Stretch To Constraint ****************/

class StretchToConstraint : public Constraint {
public:
	StretchToConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	enum volume_enum {
		volume_VOLUME_XZX = 0,
		volume_VOLUME_X = 1,
		volume_VOLUME_Z = 2,
		volume_NO_VOLUME = 3,
	};
	inline volume_enum volume(void);
	inline void volume(volume_enum value);
	enum keep_axis_enum {
		keep_axis_PLANE_X = 0,
		keep_axis_PLANE_Z = 2,
	};
	inline keep_axis_enum keep_axis(void);
	inline void keep_axis(keep_axis_enum value);
	inline float rest_length(void);
	inline void rest_length(float value);
	inline float bulge(void);
	inline void bulge(float value);
	inline bool use_bulge_min(void);
	inline void use_bulge_min(int value);
	inline bool use_bulge_max(void);
	inline void use_bulge_max(int value);
	inline float bulge_min(void);
	inline void bulge_min(float value);
	inline float bulge_max(void);
	inline void bulge_max(float value);
	inline float bulge_smooth(void);
	inline void bulge_smooth(float value);

};

/**************** Follow Path Constraint ****************/

class FollowPathConstraint : public Constraint {
public:
	FollowPathConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline float offset(void);
	inline void offset(float value);
	inline float offset_factor(void);
	inline void offset_factor(float value);
	enum forward_axis_enum {
		forward_axis_FORWARD_X = 0,
		forward_axis_FORWARD_Y = 1,
		forward_axis_FORWARD_Z = 2,
		forward_axis_TRACK_NEGATIVE_X = 3,
		forward_axis_TRACK_NEGATIVE_Y = 4,
		forward_axis_TRACK_NEGATIVE_Z = 5,
	};
	inline forward_axis_enum forward_axis(void);
	inline void forward_axis(forward_axis_enum value);
	enum up_axis_enum {
		up_axis_UP_X = 0,
		up_axis_UP_Y = 1,
		up_axis_UP_Z = 2,
	};
	inline up_axis_enum up_axis(void);
	inline void up_axis(up_axis_enum value);
	inline bool use_curve_follow(void);
	inline void use_curve_follow(int value);
	inline bool use_fixed_location(void);
	inline void use_fixed_location(int value);
	inline bool use_curve_radius(void);
	inline void use_curve_radius(int value);

};

/**************** Locked Track Constraint ****************/

class LockedTrackConstraint : public Constraint {
public:
	LockedTrackConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	enum track_axis_enum {
		track_axis_TRACK_X = 0,
		track_axis_TRACK_Y = 1,
		track_axis_TRACK_Z = 2,
		track_axis_TRACK_NEGATIVE_X = 3,
		track_axis_TRACK_NEGATIVE_Y = 4,
		track_axis_TRACK_NEGATIVE_Z = 5,
	};
	inline track_axis_enum track_axis(void);
	inline void track_axis(track_axis_enum value);
	enum lock_axis_enum {
		lock_axis_LOCK_X = 0,
		lock_axis_LOCK_Y = 1,
		lock_axis_LOCK_Z = 2,
	};
	inline lock_axis_enum lock_axis(void);
	inline void lock_axis(lock_axis_enum value);

};

/**************** Action Constraint ****************/

class ActionConstraint : public Constraint {
public:
	ActionConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	enum transform_channel_enum {
		transform_channel_LOCATION_X = 20,
		transform_channel_LOCATION_Y = 21,
		transform_channel_LOCATION_Z = 22,
		transform_channel_ROTATION_X = 0,
		transform_channel_ROTATION_Y = 1,
		transform_channel_ROTATION_Z = 2,
		transform_channel_SCALE_X = 10,
		transform_channel_SCALE_Y = 11,
		transform_channel_SCALE_Z = 12,
	};
	inline transform_channel_enum transform_channel(void);
	inline void transform_channel(transform_channel_enum value);
	inline Action action(void);
	inline bool use_bone_object_action(void);
	inline void use_bone_object_action(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline float max(void);
	inline void max(float value);
	inline float min(void);
	inline void min(float value);

};

/**************** Copy Scale Constraint ****************/

class CopyScaleConstraint : public Constraint {
public:
	CopyScaleConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	inline bool use_x(void);
	inline void use_x(int value);
	inline bool use_y(void);
	inline void use_y(int value);
	inline bool use_z(void);
	inline void use_z(int value);
	inline bool use_offset(void);
	inline void use_offset(int value);

};

/**************** Maintain Volume Constraint ****************/

class MaintainVolumeConstraint : public Constraint {
public:
	MaintainVolumeConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	enum free_axis_enum {
		free_axis_SAMEVOL_X = 0,
		free_axis_SAMEVOL_Y = 1,
		free_axis_SAMEVOL_Z = 2,
	};
	inline free_axis_enum free_axis(void);
	inline void free_axis(free_axis_enum value);
	inline float volume(void);
	inline void volume(float value);

};

/**************** Copy Location Constraint ****************/

class CopyLocationConstraint : public Constraint {
public:
	CopyLocationConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	inline bool use_x(void);
	inline void use_x(int value);
	inline bool use_y(void);
	inline void use_y(int value);
	inline bool use_z(void);
	inline void use_z(int value);
	inline bool invert_x(void);
	inline void invert_x(int value);
	inline bool invert_y(void);
	inline void invert_y(int value);
	inline bool invert_z(void);
	inline void invert_z(int value);
	inline bool use_offset(void);
	inline void use_offset(int value);

};

/**************** Copy Rotation Constraint ****************/

class CopyRotationConstraint : public Constraint {
public:
	CopyRotationConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	inline bool use_x(void);
	inline void use_x(int value);
	inline bool use_y(void);
	inline void use_y(int value);
	inline bool use_z(void);
	inline void use_z(int value);
	inline bool invert_x(void);
	inline void invert_x(int value);
	inline bool invert_y(void);
	inline void invert_y(int value);
	inline bool invert_z(void);
	inline void invert_z(int value);
	inline bool use_offset(void);
	inline void use_offset(int value);

};

/**************** Copy Transforms Constraint ****************/

class CopyTransformsConstraint : public Constraint {
public:
	CopyTransformsConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);

};

/**************** Floor Constraint ****************/

class FloorConstraint : public Constraint {
public:
	FloorConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	enum floor_location_enum {
		floor_location_FLOOR_X = 0,
		floor_location_FLOOR_Y = 1,
		floor_location_FLOOR_Z = 2,
		floor_location_FLOOR_NEGATIVE_X = 3,
		floor_location_FLOOR_NEGATIVE_Y = 4,
		floor_location_FLOOR_NEGATIVE_Z = 5,
	};
	inline floor_location_enum floor_location(void);
	inline void floor_location(floor_location_enum value);
	inline bool use_sticky(void);
	inline void use_sticky(int value);
	inline bool use_rotation(void);
	inline void use_rotation(int value);
	inline float offset(void);
	inline void offset(float value);

};

/**************** Track To Constraint ****************/

class TrackToConstraint : public Constraint {
public:
	TrackToConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	enum track_axis_enum {
		track_axis_TRACK_X = 0,
		track_axis_TRACK_Y = 1,
		track_axis_TRACK_Z = 2,
		track_axis_TRACK_NEGATIVE_X = 3,
		track_axis_TRACK_NEGATIVE_Y = 4,
		track_axis_TRACK_NEGATIVE_Z = 5,
	};
	inline track_axis_enum track_axis(void);
	inline void track_axis(track_axis_enum value);
	enum up_axis_enum {
		up_axis_UP_X = 0,
		up_axis_UP_Y = 1,
		up_axis_UP_Z = 2,
	};
	inline up_axis_enum up_axis(void);
	inline void up_axis(up_axis_enum value);
	inline bool use_target_z(void);
	inline void use_target_z(int value);

};

/**************** Kinematic Constraint ****************/

class KinematicConstraint : public Constraint {
public:
	KinematicConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	inline int iterations(void);
	inline void iterations(int value);
	inline Object pole_target(void);
	inline std::string pole_subtarget(void);	inline void pole_subtarget(const std::string& value);
	inline float pole_angle(void);
	inline void pole_angle(float value);
	inline float weight(void);
	inline void weight(float value);
	inline float orient_weight(void);
	inline void orient_weight(float value);
	inline int chain_count(void);
	inline void chain_count(int value);
	inline bool use_tail(void);
	inline void use_tail(int value);
	enum reference_axis_enum {
		reference_axis_BONE = 0,
		reference_axis_TARGET = 16384,
	};
	inline reference_axis_enum reference_axis(void);
	inline void reference_axis(reference_axis_enum value);
	inline bool use_location(void);
	inline void use_location(int value);
	inline bool lock_location_x(void);
	inline void lock_location_x(int value);
	inline bool lock_location_y(void);
	inline void lock_location_y(int value);
	inline bool lock_location_z(void);
	inline void lock_location_z(int value);
	inline bool use_rotation(void);
	inline void use_rotation(int value);
	inline bool lock_rotation_x(void);
	inline void lock_rotation_x(int value);
	inline bool lock_rotation_y(void);
	inline void lock_rotation_y(int value);
	inline bool lock_rotation_z(void);
	inline void lock_rotation_z(int value);
	inline bool use_stretch(void);
	inline void use_stretch(int value);
	enum ik_type_enum {
		ik_type_COPY_POSE = 0,
		ik_type_DISTANCE = 1,
	};
	inline ik_type_enum ik_type(void);
	inline void ik_type(ik_type_enum value);
	enum limit_mode_enum {
		limit_mode_LIMITDIST_INSIDE = 0,
		limit_mode_LIMITDIST_OUTSIDE = 1,
		limit_mode_LIMITDIST_ONSURFACE = 2,
	};
	inline limit_mode_enum limit_mode(void);
	inline void limit_mode(limit_mode_enum value);
	inline float distance(void);
	inline void distance(float value);

};

/**************** Rigid Body Joint Constraint ****************/

class RigidBodyJointConstraint : public Constraint {
public:
	RigidBodyJointConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline Object child(void);
	enum pivot_type_enum {
		pivot_type_BALL = 1,
		pivot_type_HINGE = 2,
		pivot_type_CONE_TWIST = 4,
		pivot_type_GENERIC_6_DOF = 12,
	};
	inline pivot_type_enum pivot_type(void);
	inline void pivot_type(pivot_type_enum value);
	inline float pivot_x(void);
	inline void pivot_x(float value);
	inline float pivot_y(void);
	inline void pivot_y(float value);
	inline float pivot_z(void);
	inline void pivot_z(float value);
	inline float axis_x(void);
	inline void axis_x(float value);
	inline float axis_y(void);
	inline void axis_y(float value);
	inline float axis_z(void);
	inline void axis_z(float value);
	inline bool use_linked_collision(void);
	inline void use_linked_collision(int value);
	inline bool show_pivot(void);
	inline void show_pivot(int value);
	inline float limit_min_x(void);
	inline void limit_min_x(float value);
	inline float limit_min_y(void);
	inline void limit_min_y(float value);
	inline float limit_min_z(void);
	inline void limit_min_z(float value);
	inline float limit_max_x(void);
	inline void limit_max_x(float value);
	inline float limit_max_y(void);
	inline void limit_max_y(float value);
	inline float limit_max_z(void);
	inline void limit_max_z(float value);
	inline float limit_angle_min_x(void);
	inline void limit_angle_min_x(float value);
	inline float limit_angle_min_y(void);
	inline void limit_angle_min_y(float value);
	inline float limit_angle_min_z(void);
	inline void limit_angle_min_z(float value);
	inline float limit_angle_max_x(void);
	inline void limit_angle_max_x(float value);
	inline float limit_angle_max_y(void);
	inline void limit_angle_max_y(float value);
	inline float limit_angle_max_z(void);
	inline void limit_angle_max_z(float value);
	inline bool use_limit_x(void);
	inline void use_limit_x(int value);
	inline bool use_limit_y(void);
	inline void use_limit_y(int value);
	inline bool use_limit_z(void);
	inline void use_limit_z(int value);
	inline bool use_angular_limit_x(void);
	inline void use_angular_limit_x(int value);
	inline bool use_angular_limit_y(void);
	inline void use_angular_limit_y(int value);
	inline bool use_angular_limit_z(void);
	inline void use_angular_limit_z(int value);

};

/**************** Clamp To Constraint ****************/

class ClampToConstraint : public Constraint {
public:
	ClampToConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	enum main_axis_enum {
		main_axis_CLAMPTO_AUTO = 0,
		main_axis_CLAMPTO_X = 1,
		main_axis_CLAMPTO_Y = 2,
		main_axis_CLAMPTO_Z = 3,
	};
	inline main_axis_enum main_axis(void);
	inline void main_axis(main_axis_enum value);
	inline bool use_cyclic(void);
	inline void use_cyclic(int value);

};

/**************** Limit Distance Constraint ****************/

class LimitDistanceConstraint : public Constraint {
public:
	LimitDistanceConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	inline float distance(void);
	inline void distance(float value);
	enum limit_mode_enum {
		limit_mode_LIMITDIST_INSIDE = 0,
		limit_mode_LIMITDIST_OUTSIDE = 1,
		limit_mode_LIMITDIST_ONSURFACE = 2,
	};
	inline limit_mode_enum limit_mode(void);
	inline void limit_mode(limit_mode_enum value);
	inline bool use_transform_limit(void);
	inline void use_transform_limit(int value);

};

/**************** Limit Size Constraint ****************/

class LimitScaleConstraint : public Constraint {
public:
	LimitScaleConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline bool use_min_x(void);
	inline void use_min_x(int value);
	inline bool use_min_y(void);
	inline void use_min_y(int value);
	inline bool use_min_z(void);
	inline void use_min_z(int value);
	inline bool use_max_x(void);
	inline void use_max_x(int value);
	inline bool use_max_y(void);
	inline void use_max_y(int value);
	inline bool use_max_z(void);
	inline void use_max_z(int value);
	inline float min_x(void);
	inline void min_x(float value);
	inline float min_y(void);
	inline void min_y(float value);
	inline float min_z(void);
	inline void min_z(float value);
	inline float max_x(void);
	inline void max_x(float value);
	inline float max_y(void);
	inline void max_y(float value);
	inline float max_z(void);
	inline void max_z(float value);
	inline bool use_transform_limit(void);
	inline void use_transform_limit(int value);

};

/**************** Limit Rotation Constraint ****************/

class LimitRotationConstraint : public Constraint {
public:
	LimitRotationConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline bool use_limit_x(void);
	inline void use_limit_x(int value);
	inline bool use_limit_y(void);
	inline void use_limit_y(int value);
	inline bool use_limit_z(void);
	inline void use_limit_z(int value);
	inline float min_x(void);
	inline void min_x(float value);
	inline float min_y(void);
	inline void min_y(float value);
	inline float min_z(void);
	inline void min_z(float value);
	inline float max_x(void);
	inline void max_x(float value);
	inline float max_y(void);
	inline void max_y(float value);
	inline float max_z(void);
	inline void max_z(float value);
	inline bool use_transform_limit(void);
	inline void use_transform_limit(int value);

};

/**************** Limit Location Constraint ****************/

class LimitLocationConstraint : public Constraint {
public:
	LimitLocationConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline bool use_min_x(void);
	inline void use_min_x(int value);
	inline bool use_min_y(void);
	inline void use_min_y(int value);
	inline bool use_min_z(void);
	inline void use_min_z(int value);
	inline bool use_max_x(void);
	inline void use_max_x(int value);
	inline bool use_max_y(void);
	inline void use_max_y(int value);
	inline bool use_max_z(void);
	inline void use_max_z(int value);
	inline float min_x(void);
	inline void min_x(float value);
	inline float min_y(void);
	inline void min_y(float value);
	inline float min_z(void);
	inline void min_z(float value);
	inline float max_x(void);
	inline void max_x(float value);
	inline float max_y(void);
	inline void max_y(float value);
	inline float max_z(void);
	inline void max_z(float value);
	inline bool use_transform_limit(void);
	inline void use_transform_limit(int value);

};

/**************** Transformation Constraint ****************/

class TransformConstraint : public Constraint {
public:
	TransformConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	enum map_from_enum {
		map_from_LOCATION = 0,
		map_from_ROTATION = 1,
		map_from_SCALE = 2,
	};
	inline map_from_enum map_from(void);
	inline void map_from(map_from_enum value);
	enum map_to_enum {
		map_to_LOCATION = 0,
		map_to_ROTATION = 1,
		map_to_SCALE = 2,
	};
	inline map_to_enum map_to(void);
	inline void map_to(map_to_enum value);
	enum map_to_x_from_enum {
		map_to_x_from_X = 0,
		map_to_x_from_Y = 1,
		map_to_x_from_Z = 2,
	};
	inline map_to_x_from_enum map_to_x_from(void);
	inline void map_to_x_from(map_to_x_from_enum value);
	enum map_to_y_from_enum {
		map_to_y_from_X = 0,
		map_to_y_from_Y = 1,
		map_to_y_from_Z = 2,
	};
	inline map_to_y_from_enum map_to_y_from(void);
	inline void map_to_y_from(map_to_y_from_enum value);
	enum map_to_z_from_enum {
		map_to_z_from_X = 0,
		map_to_z_from_Y = 1,
		map_to_z_from_Z = 2,
	};
	inline map_to_z_from_enum map_to_z_from(void);
	inline void map_to_z_from(map_to_z_from_enum value);
	inline bool use_motion_extrapolate(void);
	inline void use_motion_extrapolate(int value);
	inline float from_min_x(void);
	inline void from_min_x(float value);
	inline float from_min_y(void);
	inline void from_min_y(float value);
	inline float from_min_z(void);
	inline void from_min_z(float value);
	inline float from_max_x(void);
	inline void from_max_x(float value);
	inline float from_max_y(void);
	inline void from_max_y(float value);
	inline float from_max_z(void);
	inline void from_max_z(float value);
	inline float to_min_x(void);
	inline void to_min_x(float value);
	inline float to_min_y(void);
	inline void to_min_y(float value);
	inline float to_min_z(void);
	inline void to_min_z(float value);
	inline float to_max_x(void);
	inline void to_max_x(float value);
	inline float to_max_y(void);
	inline void to_max_y(float value);
	inline float to_max_z(void);
	inline void to_max_z(float value);
	inline float from_min_x_rot(void);
	inline void from_min_x_rot(float value);
	inline float from_min_y_rot(void);
	inline void from_min_y_rot(float value);
	inline float from_min_z_rot(void);
	inline void from_min_z_rot(float value);
	inline float from_max_x_rot(void);
	inline void from_max_x_rot(float value);
	inline float from_max_y_rot(void);
	inline void from_max_y_rot(float value);
	inline float from_max_z_rot(void);
	inline void from_max_z_rot(float value);
	inline float to_min_x_rot(void);
	inline void to_min_x_rot(float value);
	inline float to_min_y_rot(void);
	inline void to_min_y_rot(float value);
	inline float to_min_z_rot(void);
	inline void to_min_z_rot(float value);
	inline float to_max_x_rot(void);
	inline void to_max_x_rot(float value);
	inline float to_max_y_rot(void);
	inline void to_max_y_rot(float value);
	inline float to_max_z_rot(void);
	inline void to_max_z_rot(float value);
	inline float from_min_x_scale(void);
	inline void from_min_x_scale(float value);
	inline float from_min_y_scale(void);
	inline void from_min_y_scale(float value);
	inline float from_min_z_scale(void);
	inline void from_min_z_scale(float value);
	inline float from_max_x_scale(void);
	inline void from_max_x_scale(float value);
	inline float from_max_y_scale(void);
	inline void from_max_y_scale(float value);
	inline float from_max_z_scale(void);
	inline void from_max_z_scale(float value);
	inline float to_min_x_scale(void);
	inline void to_min_x_scale(float value);
	inline float to_min_y_scale(void);
	inline void to_min_y_scale(float value);
	inline float to_min_z_scale(void);
	inline void to_min_z_scale(float value);
	inline float to_max_x_scale(void);
	inline void to_max_x_scale(float value);
	inline float to_max_y_scale(void);
	inline void to_max_y_scale(float value);
	inline float to_max_z_scale(void);
	inline void to_max_z_scale(float value);

};

/**************** Shrinkwrap Constraint ****************/

class ShrinkwrapConstraint : public Constraint {
public:
	ShrinkwrapConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	enum shrinkwrap_type_enum {
		shrinkwrap_type_NEAREST_SURFACE = 0,
		shrinkwrap_type_PROJECT = 1,
		shrinkwrap_type_NEAREST_VERTEX = 2,
	};
	inline shrinkwrap_type_enum shrinkwrap_type(void);
	inline void shrinkwrap_type(shrinkwrap_type_enum value);
	inline float distance(void);
	inline void distance(float value);
	enum project_axis_enum {
		project_axis_POS_X = 0,
		project_axis_POS_Y = 1,
		project_axis_POS_Z = 2,
		project_axis_NEG_X = 3,
		project_axis_NEG_Y = 4,
		project_axis_NEG_Z = 5,
	};
	inline project_axis_enum project_axis(void);
	inline void project_axis(project_axis_enum value);
	enum project_axis_space_enum {
		project_axis_space_WORLD = 0,
		project_axis_space_POSE = 2,
		project_axis_space_LOCAL_WITH_PARENT = 3,
		project_axis_space_LOCAL = 1,
	};
	inline project_axis_space_enum project_axis_space(void);
	inline void project_axis_space(project_axis_space_enum value);
	inline float project_limit(void);
	inline void project_limit(float value);

};

/**************** Damped Track Constraint ****************/

class DampedTrackConstraint : public Constraint {
public:
	DampedTrackConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	enum track_axis_enum {
		track_axis_TRACK_X = 0,
		track_axis_TRACK_Y = 1,
		track_axis_TRACK_Z = 2,
		track_axis_TRACK_NEGATIVE_X = 3,
		track_axis_TRACK_NEGATIVE_Y = 4,
		track_axis_TRACK_NEGATIVE_Z = 5,
	};
	inline track_axis_enum track_axis(void);
	inline void track_axis(track_axis_enum value);

};

/**************** Spline IK Constraint ****************/

class SplineIKConstraint : public Constraint {
public:
	SplineIKConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline int chain_count(void);
	inline void chain_count(int value);
	inline Array<float, 32> joint_bindings(void);
	inline void joint_bindings(float values[32]);
	inline bool use_chain_offset(void);
	inline void use_chain_offset(int value);
	inline bool use_even_divisions(void);
	inline void use_even_divisions(int value);
	inline bool use_y_stretch(void);
	inline void use_y_stretch(int value);
	inline bool use_curve_radius(void);
	inline void use_curve_radius(int value);
	enum xz_scale_mode_enum {
		xz_scale_mode_NONE = 0,
		xz_scale_mode_BONE_ORIGINAL = 1,
		xz_scale_mode_VOLUME_PRESERVE = 2,
	};
	inline xz_scale_mode_enum xz_scale_mode(void);
	inline void xz_scale_mode(xz_scale_mode_enum value);

};

/**************** Pivot Constraint ****************/

class PivotConstraint : public Constraint {
public:
	PivotConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline Object target(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	inline bool use_relative_location(void);
	inline void use_relative_location(int value);
	inline Array<float, 3> offset(void);
	inline void offset(float values[3]);
	enum rotation_range_enum {
		rotation_range_ALWAYS_ACTIVE = -1,
		rotation_range_NX = 0,
		rotation_range_NY = 1,
		rotation_range_NZ = 2,
		rotation_range_X = 3,
		rotation_range_Y = 4,
		rotation_range_Z = 5,
	};
	inline rotation_range_enum rotation_range(void);
	inline void rotation_range(rotation_range_enum value);

};

/**************** Follow Track Constraint ****************/

class FollowTrackConstraint : public Constraint {
public:
	FollowTrackConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline std::string track(void);	inline void track(const std::string& value);
	inline bool use_active_clip(void);
	inline void use_active_clip(int value);
	inline bool use_3d_position(void);
	inline void use_3d_position(int value);
	inline std::string object(void);	inline void object(const std::string& value);
	inline Object camera(void);
	inline Object depth_object(void);
	enum frame_method_enum {
		frame_method_STRETCH = 0,
		frame_method_FIT = 1,
		frame_method_CROP = 2,
	};
	inline frame_method_enum frame_method(void);
	inline void frame_method(frame_method_enum value);
	inline bool use_undistorted_position(void);
	inline void use_undistorted_position(int value);

};

/**************** Camera Solver Constraint ****************/

class CameraSolverConstraint : public Constraint {
public:
	CameraSolverConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline bool use_active_clip(void);
	inline void use_active_clip(int value);

};

/**************** Object Solver Constraint ****************/

class ObjectSolverConstraint : public Constraint {
public:
	ObjectSolverConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline bool use_active_clip(void);
	inline void use_active_clip(int value);
	inline std::string object(void);	inline void object(const std::string& value);
	inline Object camera(void);

};

/**************** Context ****************/

class Context : public Pointer {
public:
	Context(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline WindowManager window_manager(void);
	inline Window window(void);
	inline Screen screen(void);
	inline Area area(void);
	inline Space space_data(void);
	inline Region region(void);
	inline RegionView3D region_data(void);
	inline BlendData blend_data(void);
	inline Scene scene(void);
	inline ToolSettings tool_settings(void);
	inline UserPreferences user_preferences(void);
	enum mode_enum {
		mode_EDIT_MESH = 0,
		mode_EDIT_CURVE = 1,
		mode_EDIT_SURFACE = 2,
		mode_EDIT_TEXT = 3,
		mode_EDIT_ARMATURE = 4,
		mode_EDIT_METABALL = 5,
		mode_EDIT_LATTICE = 6,
		mode_POSE = 7,
		mode_SCULPT = 8,
		mode_PAINT_WEIGHT = 9,
		mode_PAINT_VERTEX = 10,
		mode_PAINT_TEXTURE = 11,
		mode_PARTICLE = 12,
		mode_OBJECT = 13,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

};

/**************** Controller ****************/

class Controller : public Pointer {
public:
	Controller(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		actuators(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_LOGIC_AND = 0,
		type_LOGIC_OR = 1,
		type_LOGIC_NAND = 4,
		type_LOGIC_NOR = 5,
		type_LOGIC_XOR = 6,
		type_LOGIC_XNOR = 7,
		type_EXPRESSION = 2,
		type_PYTHON = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	inline bool active(void);
	inline void active(int value);
	inline bool use_priority(void);
	inline void use_priority(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Actuator, Controller, actuators, true, true, true)
	inline int states(void);
	inline void states(int value);

	inline void link(Sensor sensor, Actuator actuator);
	inline void unlink(Sensor sensor, Actuator actuator);
};

/**************** Expression Controller ****************/

class ExpressionController : public Controller {
public:
	ExpressionController(const PointerRNA &ptr_arg) :
		Controller(ptr_arg)
		{}

	inline std::string expression(void);	inline void expression(const std::string& value);

};

/**************** Python Controller ****************/

class PythonController : public Controller {
public:
	PythonController(const PointerRNA &ptr_arg) :
		Controller(ptr_arg)
		{}

	enum mode_enum {
		mode_SCRIPT = 0,
		mode_MODULE = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Text text(void);
	inline std::string module(void);	inline void module(const std::string& value);
	inline bool use_debug(void);
	inline void use_debug(int value);

};

/**************** And Controller ****************/

class AndController : public Controller {
public:
	AndController(const PointerRNA &ptr_arg) :
		Controller(ptr_arg)
		{}


};

/**************** Or Controller ****************/

class OrController : public Controller {
public:
	OrController(const PointerRNA &ptr_arg) :
		Controller(ptr_arg)
		{}


};

/**************** Nor Controller ****************/

class NorController : public Controller {
public:
	NorController(const PointerRNA &ptr_arg) :
		Controller(ptr_arg)
		{}


};

/**************** Nand Controller ****************/

class NandController : public Controller {
public:
	NandController(const PointerRNA &ptr_arg) :
		Controller(ptr_arg)
		{}


};

/**************** Xor Controller ****************/

class XorController : public Controller {
public:
	XorController(const PointerRNA &ptr_arg) :
		Controller(ptr_arg)
		{}


};

/**************** Xnor Controller ****************/

class XnorController : public Controller {
public:
	XnorController(const PointerRNA &ptr_arg) :
		Controller(ptr_arg)
		{}


};

/**************** Curve ****************/

class Curve : public ID {
public:
	Curve(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		splines(ptr_arg),
		materials(ptr_arg)
		{}

	inline Key shape_keys(void);
	COLLECTION_PROPERTY(CurveSplines, Spline, Curve, splines, false, false, false)
	inline bool show_handles(void);
	inline void show_handles(int value);
	inline bool show_normal_face(void);
	inline void show_normal_face(int value);
	inline int path_duration(void);
	inline void path_duration(int value);
	inline bool use_path(void);
	inline void use_path(int value);
	inline bool use_path_follow(void);
	inline void use_path_follow(int value);
	inline bool use_stretch(void);
	inline void use_stretch(int value);
	inline bool use_deform_bounds(void);
	inline void use_deform_bounds(int value);
	inline bool use_radius(void);
	inline void use_radius(int value);
	inline int bevel_resolution(void);
	inline void bevel_resolution(int value);
	inline float offset(void);
	inline void offset(float value);
	inline float extrude(void);
	inline void extrude(float value);
	inline float bevel_depth(void);
	inline void bevel_depth(float value);
	inline int resolution_u(void);
	inline void resolution_u(int value);
	inline int resolution_v(void);
	inline void resolution_v(int value);
	inline int render_resolution_u(void);
	inline void render_resolution_u(int value);
	inline int render_resolution_v(void);
	inline void render_resolution_v(int value);
	inline float eval_time(void);
	inline void eval_time(float value);
	inline Object bevel_object(void);
	inline Object taper_object(void);
	enum dimensions_enum {
		dimensions_2D = 0,
		dimensions_3D = 1,
	};
	inline dimensions_enum dimensions(void);
	inline void dimensions(dimensions_enum value);
	enum fill_mode_enum {
		fill_mode_FULL = 0,
		fill_mode_BACK = 4,
		fill_mode_FRONT = 2,
		fill_mode_HALF = 6,
	};
	inline fill_mode_enum fill_mode(void);
	inline void fill_mode(fill_mode_enum value);
	enum twist_mode_enum {
		twist_mode_Z_UP = 0,
		twist_mode_MINIMUM = 3,
		twist_mode_TANGENT = 4,
	};
	inline twist_mode_enum twist_mode(void);
	inline void twist_mode(twist_mode_enum value);
	enum bevel_factor_mapping_start_enum {
		bevel_factor_mapping_start_RESOLUTION = 0,
		bevel_factor_mapping_start_SEGMENTS = 1,
		bevel_factor_mapping_start_SPLINE = 2,
	};
	inline bevel_factor_mapping_start_enum bevel_factor_mapping_start(void);
	inline void bevel_factor_mapping_start(bevel_factor_mapping_start_enum value);
	enum bevel_factor_mapping_end_enum {
		bevel_factor_mapping_end_RESOLUTION = 0,
		bevel_factor_mapping_end_SEGMENTS = 1,
		bevel_factor_mapping_end_SPLINE = 2,
	};
	inline bevel_factor_mapping_end_enum bevel_factor_mapping_end(void);
	inline void bevel_factor_mapping_end(bevel_factor_mapping_end_enum value);
	inline float twist_smooth(void);
	inline void twist_smooth(float value);
	inline bool use_fill_deform(void);
	inline void use_fill_deform(int value);
	inline bool use_fill_caps(void);
	inline void use_fill_caps(int value);
	inline bool use_map_taper(void);
	inline void use_map_taper(int value);
	inline bool use_auto_texspace(void);
	inline void use_auto_texspace(int value);
	inline Array<float, 3> texspace_location(void);
	inline void texspace_location(float values[3]);
	inline Array<float, 3> texspace_size(void);
	inline void texspace_size(float values[3]);
	inline bool use_uv_as_generated(void);
	inline void use_uv_as_generated(int value);
	COLLECTION_PROPERTY(IDMaterials, Material, Curve, materials, true, true, true)
	inline float bevel_factor_start(void);
	inline void bevel_factor_start(float value);
	inline float bevel_factor_end(void);
	inline void bevel_factor_end(float value);
	inline bool is_editmode(void);
	inline void is_editmode(int value);
	inline AnimData animation_data(void);

	inline void transform(float matrix[16], int shape_keys);
	inline int validate_material_indices();
};

/**************** Surface Curve ****************/

class SurfaceCurve : public Curve {
public:
	SurfaceCurve(const PointerRNA &ptr_arg) :
		Curve(ptr_arg)
		{}

	inline bool use_uv_as_generated(void);
	inline void use_uv_as_generated(int value);

};

/**************** Text Curve ****************/

class TextCurve : public Curve {
public:
	TextCurve(const PointerRNA &ptr_arg) :
		Curve(ptr_arg),
		text_boxes(ptr_arg),
		body_format(ptr_arg)
		{}

	enum align_enum {
		align_LEFT = 0,
		align_CENTER = 1,
		align_RIGHT = 2,
		align_JUSTIFY = 3,
		align_FLUSH = 4,
	};
	inline align_enum align(void);
	inline void align(align_enum value);
	inline float size(void);
	inline void size(float value);
	inline float small_caps_scale(void);
	inline void small_caps_scale(float value);
	inline float space_line(void);
	inline void space_line(float value);
	inline float space_word(void);
	inline void space_word(float value);
	inline float space_character(void);
	inline void space_character(float value);
	inline float shear(void);
	inline void shear(float value);
	inline float offset_x(void);
	inline void offset_x(float value);
	inline float offset_y(void);
	inline void offset_y(float value);
	inline float underline_position(void);
	inline void underline_position(float value);
	inline float underline_height(void);
	inline void underline_height(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, TextBox, TextCurve, text_boxes, true, true, false)
	inline int active_textbox(void);
	inline void active_textbox(int value);
	inline std::string family(void);	inline void family(const std::string& value);
	inline std::string body(void);	inline void body(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, TextCharacterFormat, TextCurve, body_format, true, true, false)
	inline Object follow_curve(void);
	inline VectorFont font(void);
	inline VectorFont font_bold(void);
	inline VectorFont font_italic(void);
	inline VectorFont font_bold_italic(void);
	inline TextCharacterFormat edit_format(void);
	inline bool use_fast_edit(void);
	inline void use_fast_edit(int value);
	inline bool use_uv_as_generated(void);
	inline void use_uv_as_generated(int value);

};

/**************** Text Box ****************/

class TextBox : public Pointer {
public:
	TextBox(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float x(void);
	inline void x(float value);
	inline float y(void);
	inline void y(float value);
	inline float width(void);
	inline void width(float value);
	inline float height(void);
	inline void height(float value);

};

/**************** Text Character Format ****************/

class TextCharacterFormat : public Pointer {
public:
	TextCharacterFormat(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_bold(void);
	inline void use_bold(int value);
	inline bool use_italic(void);
	inline void use_italic(int value);
	inline bool use_underline(void);
	inline void use_underline(int value);
	inline bool use_small_caps(void);
	inline void use_small_caps(int value);
	inline int material_index(void);
	inline void material_index(int value);

};

/**************** SplinePoint ****************/

class SplinePoint : public Pointer {
public:
	SplinePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select(void);
	inline void select(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline Array<float, 4> co(void);
	inline void co(float values[4]);
	inline float weight(void);
	inline void weight(float value);
	inline float tilt(void);
	inline void tilt(float value);
	inline float weight_softbody(void);
	inline void weight_softbody(float value);
	inline float radius(void);
	inline void radius(float value);

};

/**************** Bezier Curve Point ****************/

class BezierSplinePoint : public Pointer {
public:
	BezierSplinePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select_left_handle(void);
	inline void select_left_handle(int value);
	inline bool select_right_handle(void);
	inline void select_right_handle(int value);
	inline bool select_control_point(void);
	inline void select_control_point(int value);
	inline bool hide(void);
	inline void hide(int value);
	enum handle_left_type_enum {
		handle_left_type_FREE = 0,
		handle_left_type_VECTOR = 2,
		handle_left_type_ALIGNED = 3,
		handle_left_type_AUTO = 1,
	};
	inline handle_left_type_enum handle_left_type(void);
	inline void handle_left_type(handle_left_type_enum value);
	enum handle_right_type_enum {
		handle_right_type_FREE = 0,
		handle_right_type_VECTOR = 2,
		handle_right_type_ALIGNED = 3,
		handle_right_type_AUTO = 1,
	};
	inline handle_right_type_enum handle_right_type(void);
	inline void handle_right_type(handle_right_type_enum value);
	inline Array<float, 3> handle_left(void);
	inline void handle_left(float values[3]);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 3> handle_right(void);
	inline void handle_right(float values[3]);
	inline float tilt(void);
	inline void tilt(float value);
	inline float weight_softbody(void);
	inline void weight_softbody(float value);
	inline float radius(void);
	inline void radius(float value);

};

/**************** Spline ****************/

class Spline : public Pointer {
public:
	Spline(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		points(ptr_arg),
		bezier_points(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(SplinePoints, SplinePoint, Spline, points, true, true, false)
	COLLECTION_PROPERTY(SplineBezierPoints, BezierSplinePoint, Spline, bezier_points, true, true, false)
	enum tilt_interpolation_enum {
		tilt_interpolation_LINEAR = 0,
		tilt_interpolation_CARDINAL = 1,
		tilt_interpolation_BSPLINE = 2,
		tilt_interpolation_EASE = 3,
	};
	inline tilt_interpolation_enum tilt_interpolation(void);
	inline void tilt_interpolation(tilt_interpolation_enum value);
	enum radius_interpolation_enum {
		radius_interpolation_LINEAR = 0,
		radius_interpolation_CARDINAL = 1,
		radius_interpolation_BSPLINE = 2,
		radius_interpolation_EASE = 3,
	};
	inline radius_interpolation_enum radius_interpolation(void);
	inline void radius_interpolation(radius_interpolation_enum value);
	enum type_enum {
		type_POLY = 0,
		type_BEZIER = 1,
		type_BSPLINE = 2,
		type_CARDINAL = 3,
		type_NURBS = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline int point_count_u(void);
	inline void point_count_u(int value);
	inline int point_count_v(void);
	inline void point_count_v(int value);
	inline int order_u(void);
	inline void order_u(int value);
	inline int order_v(void);
	inline void order_v(int value);
	inline int resolution_u(void);
	inline void resolution_u(int value);
	inline int resolution_v(void);
	inline void resolution_v(int value);
	inline bool use_cyclic_u(void);
	inline void use_cyclic_u(int value);
	inline bool use_cyclic_v(void);
	inline void use_cyclic_v(int value);
	inline bool use_endpoint_u(void);
	inline void use_endpoint_u(int value);
	inline bool use_endpoint_v(void);
	inline void use_endpoint_v(int value);
	inline bool use_bezier_u(void);
	inline void use_bezier_u(int value);
	inline bool use_bezier_v(void);
	inline void use_bezier_v(int value);
	inline bool use_smooth(void);
	inline void use_smooth(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline int material_index(void);
	inline void material_index(int value);
	inline int character_index(void);
	inline void character_index(int value);

};

/**************** Canvas Settings ****************/

class DynamicPaintCanvasSettings : public Pointer {
public:
	DynamicPaintCanvasSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		canvas_surfaces(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DynamicPaintSurfaces, DynamicPaintSurface, DynamicPaintCanvasSettings, canvas_surfaces, false, false, false)

};

/**************** Brush Settings ****************/

class DynamicPaintBrushSettings : public Pointer {
public:
	DynamicPaintBrushSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> paint_color(void);
	inline void paint_color(float values[3]);
	inline float paint_alpha(void);
	inline void paint_alpha(float value);
	inline bool use_material(void);
	inline void use_material(int value);
	inline Material material(void);
	inline bool use_absolute_alpha(void);
	inline void use_absolute_alpha(int value);
	inline float paint_wetness(void);
	inline void paint_wetness(float value);
	inline bool use_paint_erase(void);
	inline void use_paint_erase(int value);
	enum wave_type_enum {
		wave_type_CHANGE = 3,
		wave_type_DEPTH = 0,
		wave_type_FORCE = 1,
		wave_type_REFLECT = 2,
	};
	inline wave_type_enum wave_type(void);
	inline void wave_type(wave_type_enum value);
	inline float wave_factor(void);
	inline void wave_factor(float value);
	inline float wave_clamp(void);
	inline void wave_clamp(float value);
	inline bool use_smudge(void);
	inline void use_smudge(int value);
	inline float smudge_strength(void);
	inline void smudge_strength(float value);
	inline float velocity_max(void);
	inline void velocity_max(float value);
	inline bool use_velocity_alpha(void);
	inline void use_velocity_alpha(int value);
	inline bool use_velocity_depth(void);
	inline void use_velocity_depth(int value);
	inline bool use_velocity_color(void);
	inline void use_velocity_color(int value);
	enum paint_source_enum {
		paint_source_PARTICLE_SYSTEM = 3,
		paint_source_POINT = 4,
		paint_source_DISTANCE = 1,
		paint_source_VOLUME_DISTANCE = 2,
		paint_source_VOLUME = 0,
	};
	inline paint_source_enum paint_source(void);
	inline void paint_source(paint_source_enum value);
	inline float paint_distance(void);
	inline void paint_distance(float value);
	inline bool use_proximity_ramp_alpha(void);
	inline void use_proximity_ramp_alpha(int value);
	enum proximity_falloff_enum {
		proximity_falloff_SMOOTH = 1,
		proximity_falloff_CONSTANT = 0,
		proximity_falloff_RAMP = 2,
	};
	inline proximity_falloff_enum proximity_falloff(void);
	inline void proximity_falloff(proximity_falloff_enum value);
	inline bool use_proximity_project(void);
	inline void use_proximity_project(int value);
	enum ray_direction_enum {
		ray_direction_CANVAS = 0,
		ray_direction_BRUSH = 1,
		ray_direction_Z_AXIS = 2,
	};
	inline ray_direction_enum ray_direction(void);
	inline void ray_direction(ray_direction_enum value);
	inline bool invert_proximity(void);
	inline void invert_proximity(int value);
	inline bool use_negative_volume(void);
	inline void use_negative_volume(int value);
	inline ParticleSystem particle_system(void);
	inline bool use_particle_radius(void);
	inline void use_particle_radius(int value);
	inline float solid_radius(void);
	inline void solid_radius(float value);
	inline float smooth_radius(void);
	inline void smooth_radius(float value);
	inline ColorRamp paint_ramp(void);
	inline ColorRamp velocity_ramp(void);

};

/**************** Paint Surface ****************/

class DynamicPaintSurface : public Pointer {
public:
	DynamicPaintSurface(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum surface_format_enum {
		surface_format_VERTEX = 1,
		surface_format_IMAGE = 2,
	};
	inline surface_format_enum surface_format(void);
	inline void surface_format(surface_format_enum value);
	enum surface_type_enum {
		surface_type_PAINT = 0,
	};
	inline surface_type_enum surface_type(void);
	inline void surface_type(surface_type_enum value);
	inline bool is_active(void);
	inline void is_active(int value);
	inline bool show_preview(void);
	inline void show_preview(int value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline Group brush_group(void);
	inline bool use_dissolve(void);
	inline void use_dissolve(int value);
	inline int dissolve_speed(void);
	inline void dissolve_speed(int value);
	inline bool use_drying(void);
	inline void use_drying(int value);
	inline int dry_speed(void);
	inline void dry_speed(int value);
	inline int image_resolution(void);
	inline void image_resolution(int value);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int frame_substeps(void);
	inline void frame_substeps(int value);
	inline bool use_antialiasing(void);
	inline void use_antialiasing(int value);
	inline float brush_influence_scale(void);
	inline void brush_influence_scale(float value);
	inline float brush_radius_scale(void);
	inline void brush_radius_scale(float value);
	enum init_color_type_enum {
		init_color_type_NONE = 0,
		init_color_type_COLOR = 1,
		init_color_type_TEXTURE = 2,
		init_color_type_VERTEX_COLOR = 3,
	};
	inline init_color_type_enum init_color_type(void);
	inline void init_color_type(init_color_type_enum value);
	inline Array<float, 4> init_color(void);
	inline void init_color(float values[4]);
	inline Texture init_texture(void);
	inline std::string init_layername(void);	inline void init_layername(const std::string& value);
	enum effect_ui_enum {
		effect_ui_SPREAD = 1,
		effect_ui_DRIP = 2,
		effect_ui_SHRINK = 3,
	};
	inline effect_ui_enum effect_ui(void);
	inline void effect_ui(effect_ui_enum value);
	inline bool use_dry_log(void);
	inline void use_dry_log(int value);
	inline bool use_dissolve_log(void);
	inline void use_dissolve_log(int value);
	inline bool use_spread(void);
	inline void use_spread(int value);
	inline float spread_speed(void);
	inline void spread_speed(float value);
	inline float color_dry_threshold(void);
	inline void color_dry_threshold(float value);
	inline float color_spread_speed(void);
	inline void color_spread_speed(float value);
	inline bool use_drip(void);
	inline void use_drip(int value);
	inline bool use_shrink(void);
	inline void use_shrink(int value);
	inline float shrink_speed(void);
	inline void shrink_speed(float value);
	inline EffectorWeights effector_weights(void);
	inline float drip_velocity(void);
	inline void drip_velocity(float value);
	inline float drip_acceleration(void);
	inline void drip_acceleration(float value);
	inline bool use_premultiply(void);
	inline void use_premultiply(int value);
	inline std::string image_output_path(void);	inline void image_output_path(const std::string& value);
	inline std::string output_name_a(void);	inline void output_name_a(const std::string& value);
	inline bool use_output_a(void);
	inline void use_output_a(int value);
	inline std::string output_name_b(void);	inline void output_name_b(const std::string& value);
	inline bool use_output_b(void);
	inline void use_output_b(int value);
	enum preview_id_enum {
		preview_id_PAINT = 0,
		preview_id_WETMAP = 1,
	};
	inline preview_id_enum preview_id(void);
	inline void preview_id(preview_id_enum value);
	inline float depth_clamp(void);
	inline void depth_clamp(float value);
	inline float displace_factor(void);
	inline void displace_factor(float value);
	enum image_fileformat_enum {
		image_fileformat_PNG = 0,
	};
	inline image_fileformat_enum image_fileformat(void);
	inline void image_fileformat(image_fileformat_enum value);
	enum displace_type_enum {
		displace_type_DISPLACE = 0,
		displace_type_DEPTH = 1,
	};
	inline displace_type_enum displace_type(void);
	inline void displace_type(displace_type_enum value);
	inline bool use_incremental_displace(void);
	inline void use_incremental_displace(int value);
	inline float wave_damping(void);
	inline void wave_damping(float value);
	inline float wave_speed(void);
	inline void wave_speed(float value);
	inline float wave_timescale(void);
	inline void wave_timescale(float value);
	inline float wave_spring(void);
	inline void wave_spring(float value);
	inline float wave_smoothness(void);
	inline void wave_smoothness(float value);
	inline bool use_wave_open_border(void);
	inline void use_wave_open_border(int value);
	inline PointCache point_cache(void);
	inline bool is_cache_user(void);
	inline void is_cache_user(int value);
	inline bool use_color_preview(void);
	inline void use_color_preview(int value);

	inline int output_exists(Object object, int index);
};

/**************** F-Curve ****************/

class FCurve : public Pointer {
public:
	FCurve(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		sampled_points(ptr_arg),
		keyframe_points(ptr_arg),
		modifiers(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum extrapolation_enum {
		extrapolation_CONSTANT = 0,
		extrapolation_LINEAR = 1,
	};
	inline extrapolation_enum extrapolation(void);
	inline void extrapolation(extrapolation_enum value);
	inline Driver driver(void);
	inline ActionGroup group(void);
	inline std::string data_path(void);	inline void data_path(const std::string& value);
	inline int array_index(void);
	inline void array_index(int value);
	enum color_mode_enum {
		color_mode_AUTO_RAINBOW = 0,
		color_mode_AUTO_RGB = 1,
		color_mode_CUSTOM = 2,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline bool select(void);
	inline void select(int value);
	inline bool lock(void);
	inline void lock(int value);
	inline bool mute(void);
	inline void mute(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline bool is_valid(void);
	inline void is_valid(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FCurveSample, FCurve, sampled_points, true, true, false)
	COLLECTION_PROPERTY(FCurveKeyframePoints, Keyframe, FCurve, keyframe_points, true, true, false)
	COLLECTION_PROPERTY(FCurveModifiers, FModifier, FCurve, modifiers, false, true, false)

	inline float evaluate(float frame);
	inline void update();
	inline void range(float range[2]);
	inline void update_autoflags(Context C, AnyType data);
};

/**************** Keyframe ****************/

class Keyframe : public Pointer {
public:
	Keyframe(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select_left_handle(void);
	inline void select_left_handle(int value);
	inline bool select_right_handle(void);
	inline void select_right_handle(int value);
	inline bool select_control_point(void);
	inline void select_control_point(int value);
	enum handle_left_type_enum {
		handle_left_type_FREE = 0,
		handle_left_type_VECTOR = 2,
		handle_left_type_ALIGNED = 3,
		handle_left_type_AUTO = 1,
		handle_left_type_AUTO_CLAMPED = 4,
	};
	inline handle_left_type_enum handle_left_type(void);
	inline void handle_left_type(handle_left_type_enum value);
	enum handle_right_type_enum {
		handle_right_type_FREE = 0,
		handle_right_type_VECTOR = 2,
		handle_right_type_ALIGNED = 3,
		handle_right_type_AUTO = 1,
		handle_right_type_AUTO_CLAMPED = 4,
	};
	inline handle_right_type_enum handle_right_type(void);
	inline void handle_right_type(handle_right_type_enum value);
	enum interpolation_enum {
		interpolation_CONSTANT = 0,
		interpolation_LINEAR = 1,
		interpolation_BEZIER = 2,
		interpolation_SINE = 12,
		interpolation_QUAD = 9,
		interpolation_CUBIC = 6,
		interpolation_QUART = 10,
		interpolation_QUINT = 11,
		interpolation_EXPO = 8,
		interpolation_CIRC = 5,
		interpolation_BACK = 3,
		interpolation_BOUNCE = 4,
		interpolation_ELASTIC = 7,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	enum type_enum {
		type_KEYFRAME = 0,
		type_BREAKDOWN = 2,
		type_EXTREME = 1,
		type_JITTER = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum easing_enum {
		easing_AUTO = 0,
		easing_EASE_IN = 1,
		easing_EASE_OUT = 2,
		easing_EASE_IN_OUT = 3,
	};
	inline easing_enum easing(void);
	inline void easing(easing_enum value);
	inline float back(void);
	inline void back(float value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float period(void);
	inline void period(float value);
	inline Array<float, 2> handle_left(void);
	inline void handle_left(float values[2]);
	inline Array<float, 2> co(void);
	inline void co(float values[2]);
	inline Array<float, 2> handle_right(void);
	inline void handle_right(float values[2]);

};

/**************** F-Curve Sample ****************/

class FCurveSample : public Pointer {
public:
	FCurveSample(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select(void);
	inline void select(int value);
	inline Array<float, 2> co(void);
	inline void co(float values[2]);

};

/**************** Driver Target ****************/

class DriverTarget : public Pointer {
public:
	DriverTarget(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ID id(void);
	enum id_type_enum {
		id_type_ACTION = 17217,
		id_type_ARMATURE = 21057,
		id_type_BRUSH = 21058,
		id_type_CAMERA = 16707,
		id_type_CURVE = 21827,
		id_type_FONT = 18006,
		id_type_GREASEPENCIL = 17479,
		id_type_GROUP = 21063,
		id_type_IMAGE = 19785,
		id_type_KEY = 17739,
		id_type_LAMP = 16716,
		id_type_LIBRARY = 18764,
		id_type_LINESTYLE = 21324,
		id_type_LATTICE = 21580,
		id_type_MASK = 21325,
		id_type_MATERIAL = 16717,
		id_type_META = 16973,
		id_type_MESH = 17741,
		id_type_NODETREE = 21582,
		id_type_OBJECT = 16975,
		id_type_PAINTCURVE = 17232,
		id_type_PALETTE = 19536,
		id_type_PARTICLE = 16720,
		id_type_SCENE = 17235,
		id_type_SCREEN = 21075,
		id_type_SPEAKER = 19283,
		id_type_SOUND = 20307,
		id_type_TEXT = 22612,
		id_type_TEXTURE = 17748,
		id_type_WORLD = 20311,
		id_type_WINDOWMANAGER = 19799,
	};
	inline id_type_enum id_type(void);
	inline void id_type(id_type_enum value);
	inline std::string data_path(void);	inline void data_path(const std::string& value);
	inline std::string bone_target(void);	inline void bone_target(const std::string& value);
	enum transform_type_enum {
		transform_type_LOC_X = 0,
		transform_type_LOC_Y = 1,
		transform_type_LOC_Z = 2,
		transform_type_ROT_X = 3,
		transform_type_ROT_Y = 4,
		transform_type_ROT_Z = 5,
		transform_type_SCALE_X = 6,
		transform_type_SCALE_Y = 7,
		transform_type_SCALE_Z = 8,
	};
	inline transform_type_enum transform_type(void);
	inline void transform_type(transform_type_enum value);
	enum transform_space_enum {
		transform_space_WORLD_SPACE = 0,
		transform_space_TRANSFORM_SPACE = 4,
		transform_space_LOCAL_SPACE = 12,
	};
	inline transform_space_enum transform_space(void);
	inline void transform_space(transform_space_enum value);

};

/**************** Driver Variable ****************/

class DriverVariable : public Pointer {
public:
	DriverVariable(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		targets(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_SINGLE_PROP = 0,
		type_TRANSFORMS = 3,
		type_ROTATION_DIFF = 1,
		type_LOC_DIFF = 2,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, DriverTarget, DriverVariable, targets, true, true, false)

};

/**************** Driver ****************/

class Driver : public Pointer {
public:
	Driver(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		variables(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_AVERAGE = 0,
		type_SUM = 2,
		type_SCRIPTED = 1,
		type_MIN = 3,
		type_MAX = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string expression(void);	inline void expression(const std::string& value);
	COLLECTION_PROPERTY(ChannelDriverVariables, DriverVariable, Driver, variables, false, true, true)
	inline bool show_debug_info(void);
	inline void show_debug_info(int value);
	inline bool is_valid(void);
	inline void is_valid(int value);

};

/**************** F-Modifier ****************/

class FModifier : public Pointer {
public:
	FModifier(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_NULL = 0,
		type_GENERATOR = 1,
		type_FNGENERATOR = 2,
		type_ENVELOPE = 3,
		type_CYCLES = 4,
		type_NOISE = 5,
		type_PYTHON = 7,
		type_LIMITS = 8,
		type_STEPPED = 9,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	inline bool mute(void);
	inline void mute(int value);
	inline bool is_valid(void);
	inline void is_valid(int value);
	inline bool active(void);
	inline void active(int value);
	inline bool use_restricted_range(void);
	inline void use_restricted_range(int value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);
	inline float blend_in(void);
	inline void blend_in(float value);
	inline float blend_out(void);
	inline void blend_out(float value);
	inline bool use_influence(void);
	inline void use_influence(int value);
	inline float influence(void);
	inline void influence(float value);

};

/**************** Generator F-Modifier ****************/

class FModifierGenerator : public FModifier {
public:
	FModifierGenerator(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	inline bool use_additive(void);
	inline void use_additive(int value);
	enum mode_enum {
		mode_POLYNOMIAL = 0,
		mode_POLYNOMIAL_FACTORISED = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline int poly_order(void);
	inline void poly_order(int value);
	inline Array<float, 32> coefficients(void);
	inline void coefficients(float values[32]);

};

/**************** Built-In Function F-Modifier ****************/

class FModifierFunctionGenerator : public FModifier {
public:
	FModifierFunctionGenerator(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	inline float amplitude(void);
	inline void amplitude(float value);
	inline float phase_multiplier(void);
	inline void phase_multiplier(float value);
	inline float phase_offset(void);
	inline void phase_offset(float value);
	inline float value_offset(void);
	inline void value_offset(float value);
	inline bool use_additive(void);
	inline void use_additive(int value);
	enum function_type_enum {
		function_type_SIN = 0,
		function_type_COS = 1,
		function_type_TAN = 2,
		function_type_SQRT = 3,
		function_type_LN = 4,
		function_type_SINC = 5,
	};
	inline function_type_enum function_type(void);
	inline void function_type(function_type_enum value);

};

/**************** Envelope F-Modifier ****************/

class FModifierEnvelope : public FModifier {
public:
	FModifierEnvelope(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg),
		control_points(ptr_arg)
		{}

	COLLECTION_PROPERTY(FModifierEnvelopeControlPoints, FModifierEnvelopeControlPoint, FModifierEnvelope, control_points, true, true, false)
	inline float reference_value(void);
	inline void reference_value(float value);
	inline float default_min(void);
	inline void default_min(float value);
	inline float default_max(void);
	inline void default_max(float value);

};

/**************** Envelope Control Point ****************/

class FModifierEnvelopeControlPoint : public Pointer {
public:
	FModifierEnvelopeControlPoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float min(void);
	inline void min(float value);
	inline float max(void);
	inline void max(float value);
	inline float frame(void);
	inline void frame(float value);

};

/**************** Cycles F-Modifier ****************/

class FModifierCycles : public FModifier {
public:
	FModifierCycles(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	enum mode_before_enum {
		mode_before_NONE = 0,
		mode_before_REPEAT = 1,
		mode_before_REPEAT_OFFSET = 2,
		mode_before_MIRROR = 3,
	};
	inline mode_before_enum mode_before(void);
	inline void mode_before(mode_before_enum value);
	inline int cycles_before(void);
	inline void cycles_before(int value);
	enum mode_after_enum {
		mode_after_NONE = 0,
		mode_after_REPEAT = 1,
		mode_after_REPEAT_OFFSET = 2,
		mode_after_MIRROR = 3,
	};
	inline mode_after_enum mode_after(void);
	inline void mode_after(mode_after_enum value);
	inline int cycles_after(void);
	inline void cycles_after(int value);

};

/**************** Python F-Modifier ****************/

class FModifierPython : public FModifier {
public:
	FModifierPython(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}


};

/**************** Limit F-Modifier ****************/

class FModifierLimits : public FModifier {
public:
	FModifierLimits(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	inline bool use_min_x(void);
	inline void use_min_x(int value);
	inline bool use_min_y(void);
	inline void use_min_y(int value);
	inline bool use_max_x(void);
	inline void use_max_x(int value);
	inline bool use_max_y(void);
	inline void use_max_y(int value);
	inline float min_x(void);
	inline void min_x(float value);
	inline float min_y(void);
	inline void min_y(float value);
	inline float max_x(void);
	inline void max_x(float value);
	inline float max_y(void);
	inline void max_y(float value);

};

/**************** Noise F-Modifier ****************/

class FModifierNoise : public FModifier {
public:
	FModifierNoise(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	enum blend_type_enum {
		blend_type_REPLACE = 0,
		blend_type_ADD = 1,
		blend_type_SUBTRACT = 2,
		blend_type_MULTIPLY = 3,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline float scale(void);
	inline void scale(float value);
	inline float strength(void);
	inline void strength(float value);
	inline float phase(void);
	inline void phase(float value);
	inline float offset(void);
	inline void offset(float value);
	inline int depth(void);
	inline void depth(int value);

};

/**************** Stepped Interpolation F-Modifier ****************/

class FModifierStepped : public FModifier {
public:
	FModifierStepped(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	inline float frame_step(void);
	inline void frame_step(float value);
	inline float frame_offset(void);
	inline void frame_offset(float value);
	inline bool use_frame_start(void);
	inline void use_frame_start(int value);
	inline bool use_frame_end(void);
	inline void use_frame_end(int value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);

};

/**************** Fluid Simulation Settings ****************/

class FluidSettings : public Pointer {
public:
	FluidSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_NONE = 1,
		type_DOMAIN = 2,
		type_FLUID = 4,
		type_OBSTACLE = 8,
		type_INFLOW = 16,
		type_OUTFLOW = 32,
		type_PARTICLE = 64,
		type_CONTROL = 128,
	};
	inline type_enum type(void);
	inline void type(type_enum value);

};

/**************** Domain Fluid Simulation Settings ****************/

class DomainFluidSettings : public FluidSettings {
public:
	DomainFluidSettings(const PointerRNA &ptr_arg) :
		FluidSettings(ptr_arg),
		fluid_mesh_vertices(ptr_arg)
		{}

	inline int threads(void);
	inline void threads(int value);
	inline int resolution(void);
	inline void resolution(int value);
	inline int preview_resolution(void);
	inline void preview_resolution(int value);
	enum viewport_display_mode_enum {
		viewport_display_mode_GEOMETRY = 1,
		viewport_display_mode_PREVIEW = 2,
		viewport_display_mode_FINAL = 3,
	};
	inline viewport_display_mode_enum viewport_display_mode(void);
	inline void viewport_display_mode(viewport_display_mode_enum value);
	enum render_display_mode_enum {
		render_display_mode_GEOMETRY = 1,
		render_display_mode_PREVIEW = 2,
		render_display_mode_FINAL = 3,
	};
	inline render_display_mode_enum render_display_mode(void);
	inline void render_display_mode(render_display_mode_enum value);
	inline bool use_reverse_frames(void);
	inline void use_reverse_frames(int value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline std::string memory_estimate(void);	inline void memory_estimate(const std::string& value);
	inline Array<float, 3> gravity(void);
	inline void gravity(float values[3]);
	inline bool use_time_override(void);
	inline void use_time_override(int value);
	inline float start_time(void);
	inline void start_time(float value);
	inline float end_time(void);
	inline void end_time(float value);
	inline int frame_offset(void);
	inline void frame_offset(int value);
	inline float simulation_scale(void);
	inline void simulation_scale(float value);
	inline float simulation_rate(void);
	inline void simulation_rate(float value);
	inline float viscosity_base(void);
	inline void viscosity_base(float value);
	inline int viscosity_exponent(void);
	inline void viscosity_exponent(int value);
	inline int grid_levels(void);
	inline void grid_levels(int value);
	inline float compressibility(void);
	inline void compressibility(float value);
	enum slip_type_enum {
		slip_type_NOSLIP = 512,
		slip_type_PARTIALSLIP = 1024,
		slip_type_FREESLIP = 2048,
	};
	inline slip_type_enum slip_type(void);
	inline void slip_type(slip_type_enum value);
	inline float partial_slip_factor(void);
	inline void partial_slip_factor(float value);
	inline float surface_smooth(void);
	inline void surface_smooth(float value);
	inline int surface_subdivisions(void);
	inline void surface_subdivisions(int value);
	inline bool use_speed_vectors(void);
	inline void use_speed_vectors(int value);
	inline bool use_surface_noobs(void);
	inline void use_surface_noobs(int value);
	inline int tracer_particles(void);
	inline void tracer_particles(int value);
	inline float generate_particles(void);
	inline void generate_particles(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FluidMeshVertex, DomainFluidSettings, fluid_mesh_vertices, true, false, false)

};

/**************** Fluid Mesh Vertex ****************/

class FluidMeshVertex : public Pointer {
public:
	FluidMeshVertex(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> velocity(void);
	inline void velocity(float values[3]);

};

/**************** Fluid Fluid Simulation Settings ****************/

class FluidFluidSettings : public FluidSettings {
public:
	FluidFluidSettings(const PointerRNA &ptr_arg) :
		FluidSettings(ptr_arg)
		{}

	inline bool use(void);
	inline void use(int value);
	enum volume_initialization_enum {
		volume_initialization_VOLUME = 1,
		volume_initialization_SHELL = 2,
		volume_initialization_BOTH = 3,
	};
	inline volume_initialization_enum volume_initialization(void);
	inline void volume_initialization(volume_initialization_enum value);
	inline bool use_animated_mesh(void);
	inline void use_animated_mesh(int value);
	inline Array<float, 3> initial_velocity(void);
	inline void initial_velocity(float values[3]);

};

/**************** Obstacle Fluid Simulation Settings ****************/

class ObstacleFluidSettings : public FluidSettings {
public:
	ObstacleFluidSettings(const PointerRNA &ptr_arg) :
		FluidSettings(ptr_arg)
		{}

	inline bool use(void);
	inline void use(int value);
	enum volume_initialization_enum {
		volume_initialization_VOLUME = 1,
		volume_initialization_SHELL = 2,
		volume_initialization_BOTH = 3,
	};
	inline volume_initialization_enum volume_initialization(void);
	inline void volume_initialization(volume_initialization_enum value);
	inline bool use_animated_mesh(void);
	inline void use_animated_mesh(int value);
	enum slip_type_enum {
		slip_type_NOSLIP = 512,
		slip_type_PARTIALSLIP = 1024,
		slip_type_FREESLIP = 2048,
	};
	inline slip_type_enum slip_type(void);
	inline void slip_type(slip_type_enum value);
	inline float partial_slip_factor(void);
	inline void partial_slip_factor(float value);
	inline float impact_factor(void);
	inline void impact_factor(float value);

};

/**************** Inflow Fluid Simulation Settings ****************/

class InflowFluidSettings : public FluidSettings {
public:
	InflowFluidSettings(const PointerRNA &ptr_arg) :
		FluidSettings(ptr_arg)
		{}

	inline bool use(void);
	inline void use(int value);
	enum volume_initialization_enum {
		volume_initialization_VOLUME = 1,
		volume_initialization_SHELL = 2,
		volume_initialization_BOTH = 3,
	};
	inline volume_initialization_enum volume_initialization(void);
	inline void volume_initialization(volume_initialization_enum value);
	inline bool use_animated_mesh(void);
	inline void use_animated_mesh(int value);
	inline Array<float, 3> inflow_velocity(void);
	inline void inflow_velocity(float values[3]);
	inline bool use_local_coords(void);
	inline void use_local_coords(int value);

};

/**************** Outflow Fluid Simulation Settings ****************/

class OutflowFluidSettings : public FluidSettings {
public:
	OutflowFluidSettings(const PointerRNA &ptr_arg) :
		FluidSettings(ptr_arg)
		{}

	inline bool use(void);
	inline void use(int value);
	enum volume_initialization_enum {
		volume_initialization_VOLUME = 1,
		volume_initialization_SHELL = 2,
		volume_initialization_BOTH = 3,
	};
	inline volume_initialization_enum volume_initialization(void);
	inline void volume_initialization(volume_initialization_enum value);
	inline bool use_animated_mesh(void);
	inline void use_animated_mesh(int value);

};

/**************** Particle Fluid Simulation Settings ****************/

class ParticleFluidSettings : public FluidSettings {
public:
	ParticleFluidSettings(const PointerRNA &ptr_arg) :
		FluidSettings(ptr_arg)
		{}

	inline bool use_drops(void);
	inline void use_drops(int value);
	inline bool use_floats(void);
	inline void use_floats(int value);
	inline bool show_tracer(void);
	inline void show_tracer(int value);
	inline float particle_influence(void);
	inline void particle_influence(float value);
	inline float alpha_influence(void);
	inline void alpha_influence(float value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);

};

/**************** Control Fluid Simulation Settings ****************/

class ControlFluidSettings : public FluidSettings {
public:
	ControlFluidSettings(const PointerRNA &ptr_arg) :
		FluidSettings(ptr_arg)
		{}

	inline bool use(void);
	inline void use(int value);
	inline float start_time(void);
	inline void start_time(float value);
	inline float end_time(void);
	inline void end_time(float value);
	inline float attraction_strength(void);
	inline void attraction_strength(float value);
	inline float attraction_radius(void);
	inline void attraction_radius(float value);
	inline float velocity_strength(void);
	inline void velocity_strength(float value);
	inline float velocity_radius(void);
	inline void velocity_radius(float value);
	inline float quality(void);
	inline void quality(float value);
	inline bool use_reverse_frames(void);
	inline void use_reverse_frames(int value);

};

/**************** Grease Pencil ****************/

class GreasePencil : public ID {
public:
	GreasePencil(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		layers(ptr_arg)
		{}

	COLLECTION_PROPERTY(GreasePencilLayers, GPencilLayer, GreasePencil, layers, false, true, true)
	enum draw_mode_enum {
		draw_mode_CURSOR = 16,
		draw_mode_VIEW = 0,
		draw_mode_SURFACE = 48,
		draw_mode_STROKE = 80,
	};
	inline draw_mode_enum draw_mode(void);
	inline void draw_mode(draw_mode_enum value);
	inline bool use_stroke_endpoints(void);
	inline void use_stroke_endpoints(int value);

	inline void clear();
};

/**************** Grease Pencil Layer ****************/

class GPencilLayer : public Pointer {
public:
	GPencilLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		frames(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string info(void);	inline void info(const std::string& value);
	COLLECTION_PROPERTY(GPencilFrames, GPencilFrame, GPencilLayer, frames, false, true, false)
	inline GPencilFrame active_frame(void);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline float alpha(void);
	inline void alpha(float value);
	inline int line_width(void);
	inline void line_width(int value);
	inline bool use_onion_skinning(void);
	inline void use_onion_skinning(int value);
	inline int ghost_range_max(void);
	inline void ghost_range_max(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline bool lock(void);
	inline void lock(int value);
	inline bool lock_frame(void);
	inline void lock_frame(int value);
	inline bool select(void);
	inline void select(int value);
	inline bool show_points(void);
	inline void show_points(int value);
	inline bool show_x_ray(void);
	inline void show_x_ray(int value);

	inline void clear();
};

/**************** Grease Pencil Frame ****************/

class GPencilFrame : public Pointer {
public:
	GPencilFrame(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		strokes(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(GPencilStrokes, GPencilStroke, GPencilFrame, strokes, false, true, false)
	inline int frame_number(void);
	inline void frame_number(int value);
	inline bool is_edited(void);
	inline void is_edited(int value);
	inline bool select(void);
	inline void select(int value);

	inline void clear();
};

/**************** Grease Pencil Stroke ****************/

class GPencilStroke : public Pointer {
public:
	GPencilStroke(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		points(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(GPencilStrokePoints, GPencilStrokePoint, GPencilStroke, points, true, true, false)
	enum draw_mode_enum {
		draw_mode_SCREEN = 0,
		draw_mode_3DSPACE = 1,
		draw_mode_2DSPACE = 2,
		draw_mode_2DIMAGE = 4,
	};
	inline draw_mode_enum draw_mode(void);
	inline void draw_mode(draw_mode_enum value);

};

/**************** Grease Pencil Stroke Point ****************/

class GPencilStrokePoint : public Pointer {
public:
	GPencilStrokePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline float pressure(void);
	inline void pressure(float value);

};

/**************** Group ****************/

class Group : public ID {
public:
	Group(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		objects(ptr_arg)
		{}

	inline Array<float, 3> dupli_offset(void);
	inline void dupli_offset(float values[3]);
	inline Array<int, 20> layers(void);
	inline void layers(int values[20]);
	COLLECTION_PROPERTY(GroupObjects, Object, Group, objects, false, true, true)

};

/**************** Render Slot ****************/

class RenderSlot : public Pointer {
public:
	RenderSlot(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);

};

/**************** Image ****************/

class Image : public ID {
public:
	Image(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		render_slots(ptr_arg)
		{}

	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline std::string filepath_raw(void);	inline void filepath_raw(const std::string& value);
	enum file_format_enum {
		file_format_BMP = 20,
		file_format_IRIS = 1,
		file_format_PNG = 17,
		file_format_JPEG = 4,
		file_format_TARGA = 0,
		file_format_TARGA_RAW = 14,
		file_format_AVI_JPEG = 16,
		file_format_AVI_RAW = 15,
	};
	inline file_format_enum file_format(void);
	inline void file_format(file_format_enum value);
	enum source_enum {
		source_FILE = 1,
		source_SEQUENCE = 2,
		source_MOVIE = 3,
		source_GENERATED = 4,
		source_VIEWER = 5,
	};
	inline source_enum source(void);
	inline void source(source_enum value);
	enum type_enum {
		type_IMAGE = 0,
		type_MULTILAYER = 1,
		type_UV_TEST = 2,
		type_RENDER_RESULT = 4,
		type_COMPOSITING = 5,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline PackedFile packed_file(void);
	enum field_order_enum {
		field_order_EVEN = 0,
		field_order_ODD = 2,
	};
	inline field_order_enum field_order(void);
	inline void field_order(field_order_enum value);
	inline bool use_fields(void);
	inline void use_fields(int value);
	inline bool use_view_as_render(void);
	inline void use_view_as_render(int value);
	inline bool use_alpha(void);
	inline void use_alpha(int value);
	inline bool is_dirty(void);
	inline void is_dirty(int value);
	enum generated_type_enum {
		generated_type_BLANK = 0,
		generated_type_UV_GRID = 1,
		generated_type_COLOR_GRID = 2,
	};
	inline generated_type_enum generated_type(void);
	inline void generated_type(generated_type_enum value);
	inline int generated_width(void);
	inline void generated_width(int value);
	inline int generated_height(void);
	inline void generated_height(int value);
	inline bool use_generated_float(void);
	inline void use_generated_float(int value);
	inline Array<float, 4> generated_color(void);
	inline void generated_color(float values[4]);
	enum mapping_enum {
		mapping_UV = 0,
		mapping_REFLECTION = 16,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline Array<float, 2> display_aspect(void);
	inline void display_aspect(float values[2]);
	inline bool use_animation(void);
	inline void use_animation(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int fps(void);
	inline void fps(int value);
	inline bool use_tiles(void);
	inline void use_tiles(int value);
	inline int tiles_x(void);
	inline void tiles_x(int value);
	inline int tiles_y(void);
	inline void tiles_y(int value);
	inline bool use_clamp_x(void);
	inline void use_clamp_x(int value);
	inline bool use_clamp_y(void);
	inline void use_clamp_y(int value);
	inline int bindcode(void);
	inline void bindcode(int value);
	COLLECTION_PROPERTY(RenderSlots, RenderSlot, Image, render_slots, false, true, false)
	inline bool has_data(void);
	inline void has_data(int value);
	inline int depth(void);
	inline void depth(int value);
	inline Array<int, 2> size(void);
	inline void size(int values[2]);
	inline Array<float, 2> resolution(void);
	inline void resolution(float values[2]);
	inline int frame_duration(void);
	inline void frame_duration(int value);
	inline DynamicArray<float> pixels(void);
	inline void pixels(float values[]);
	inline int channels(void);
	inline void channels(int value);
	inline bool is_float(void);
	inline void is_float(int value);
	inline ColorManagedInputColorspaceSettings colorspace_settings(void);
	enum alpha_mode_enum {
		alpha_mode_STRAIGHT = 0,
		alpha_mode_PREMUL = 1,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);

	inline void save_render(Context C, const char * filepath, Scene scene);
	inline void save(Context C);
	inline void pack(Context C, int as_png);
	inline void unpack(int method);
	inline void reload();
	inline void update();
	inline void scale(int width, int height);
	inline int gl_touch(int frame, int filter, int mag);
	inline int gl_load(int frame, int filter, int mag);
	inline void gl_free();
	inline void filepath_from_user(ImageUser image_user, char * filepath);
};

/**************** Image User ****************/

class ImageUser : public Pointer {
public:
	ImageUser(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_auto_refresh(void);
	inline void use_auto_refresh(int value);
	inline int frame_current(void);
	inline void frame_current(int value);
	inline bool use_cyclic(void);
	inline void use_cyclic(int value);
	inline int frame_duration(void);
	inline void frame_duration(int value);
	inline int frame_offset(void);
	inline void frame_offset(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int fields_per_frame(void);
	inline void fields_per_frame(int value);
	inline int multilayer_layer(void);
	inline void multilayer_layer(int value);
	inline int multilayer_pass(void);
	inline void multilayer_pass(int value);

};

/**************** Key ****************/

class Key : public ID {
public:
	Key(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		key_blocks(ptr_arg)
		{}

	inline ShapeKey reference_key(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ShapeKey, Key, key_blocks, false, true, true)
	inline AnimData animation_data(void);
	inline ID user(void);
	inline bool use_relative(void);
	inline void use_relative(int value);
	inline float eval_time(void);
	inline void eval_time(float value);
	inline int slurph(void);
	inline void slurph(int value);

};

/**************** Shape Key ****************/

class ShapeKey : public Pointer {
public:
	ShapeKey(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline float frame(void);
	inline void frame(float value);
	inline float value(void);
	inline void value(float value);
	enum interpolation_enum {
		interpolation_KEY_LINEAR = 0,
		interpolation_KEY_CARDINAL = 1,
		interpolation_KEY_CATMULL_ROM = 3,
		interpolation_KEY_BSPLINE = 2,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline ShapeKey relative_key(void);
	inline bool mute(void);
	inline void mute(int value);
	inline float slider_min(void);
	inline void slider_min(float value);
	inline float slider_max(void);
	inline void slider_max(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, UnknownType, ShapeKey, data, true, true, false)

};

/**************** Shape Key Point ****************/

class ShapeKeyPoint : public Pointer {
public:
	ShapeKeyPoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);

};

/**************** Shape Key Curve Point ****************/

class ShapeKeyCurvePoint : public Pointer {
public:
	ShapeKeyCurvePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline float tilt(void);
	inline void tilt(float value);

};

/**************** Shape Key Bezier Point ****************/

class ShapeKeyBezierPoint : public Pointer {
public:
	ShapeKeyBezierPoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 3> handle_left(void);
	inline void handle_left(float values[3]);
	inline Array<float, 3> handle_right(void);
	inline void handle_right(float values[3]);

};

/**************** Lamp ****************/

class Lamp : public ID {
public:
	Lamp(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		texture_slots(ptr_arg)
		{}

	enum type_enum {
		type_POINT = 0,
		type_SUN = 1,
		type_SPOT = 2,
		type_HEMI = 3,
		type_AREA = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline float distance(void);
	inline void distance(float value);
	inline float energy(void);
	inline void energy(float value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline bool use_own_layer(void);
	inline void use_own_layer(int value);
	inline bool use_negative(void);
	inline void use_negative(int value);
	inline bool use_specular(void);
	inline void use_specular(int value);
	inline bool use_diffuse(void);
	inline void use_diffuse(int value);
	inline NodeTree node_tree(void);
	inline bool use_nodes(void);
	inline void use_nodes(int value);
	inline AnimData animation_data(void);
	COLLECTION_PROPERTY(LampTextureSlots, LampTextureSlot, Lamp, texture_slots, false, false, false)
	inline Texture active_texture(void);
	inline int active_texture_index(void);
	inline void active_texture_index(int value);

};

/**************** Point Lamp ****************/

class PointLamp : public Lamp {
public:
	PointLamp(const PointerRNA &ptr_arg) :
		Lamp(ptr_arg)
		{}

	enum falloff_type_enum {
		falloff_type_CONSTANT = 0,
		falloff_type_INVERSE_LINEAR = 1,
		falloff_type_INVERSE_SQUARE = 2,
		falloff_type_CUSTOM_CURVE = 3,
		falloff_type_LINEAR_QUADRATIC_WEIGHTED = 4,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline CurveMapping falloff_curve(void);
	inline bool use_sphere(void);
	inline void use_sphere(int value);
	inline float linear_attenuation(void);
	inline void linear_attenuation(float value);
	inline float quadratic_attenuation(void);
	inline void quadratic_attenuation(float value);
	inline bool use_shadow(void);
	inline void use_shadow(int value);
	enum shadow_method_enum {
		shadow_method_NOSHADOW = 0,
		shadow_method_RAY_SHADOW = 8192,
	};
	inline shadow_method_enum shadow_method(void);
	inline void shadow_method(shadow_method_enum value);
	inline int shadow_buffer_size(void);
	inline void shadow_buffer_size(int value);
	enum shadow_filter_type_enum {
		shadow_filter_type_BOX = 0,
		shadow_filter_type_TENT = 1,
		shadow_filter_type_GAUSS = 2,
	};
	inline shadow_filter_type_enum shadow_filter_type(void);
	inline void shadow_filter_type(shadow_filter_type_enum value);
	enum shadow_sample_buffers_enum {
		shadow_sample_buffers_BUFFERS_1 = 1,
		shadow_sample_buffers_BUFFERS_4 = 4,
		shadow_sample_buffers_BUFFERS_9 = 9,
	};
	inline shadow_sample_buffers_enum shadow_sample_buffers(void);
	inline void shadow_sample_buffers(shadow_sample_buffers_enum value);
	inline float shadow_buffer_clip_start(void);
	inline void shadow_buffer_clip_start(float value);
	inline float shadow_buffer_clip_end(void);
	inline void shadow_buffer_clip_end(float value);
	inline float shadow_buffer_bias(void);
	inline void shadow_buffer_bias(float value);
	inline float shadow_buffer_bleed_bias(void);
	inline void shadow_buffer_bleed_bias(float value);
	inline float shadow_buffer_soft(void);
	inline void shadow_buffer_soft(float value);
	inline int shadow_buffer_samples(void);
	inline void shadow_buffer_samples(int value);
	enum shadow_buffer_type_enum {
		shadow_buffer_type_REGULAR = 0,
		shadow_buffer_type_HALFWAY = 2,
		shadow_buffer_type_IRREGULAR = 1,
		shadow_buffer_type_DEEP = 3,
	};
	inline shadow_buffer_type_enum shadow_buffer_type(void);
	inline void shadow_buffer_type(shadow_buffer_type_enum value);
	enum ge_shadow_buffer_type_enum {
		ge_shadow_buffer_type_SIMPLE = 0,
		ge_shadow_buffer_type_VARIANCE = 1,
	};
	inline ge_shadow_buffer_type_enum ge_shadow_buffer_type(void);
	inline void ge_shadow_buffer_type(ge_shadow_buffer_type_enum value);
	inline bool use_auto_clip_start(void);
	inline void use_auto_clip_start(int value);
	inline bool use_auto_clip_end(void);
	inline void use_auto_clip_end(int value);
	inline float compression_threshold(void);
	inline void compression_threshold(float value);
	inline Array<float, 3> shadow_color(void);
	inline void shadow_color(float values[3]);
	inline bool use_only_shadow(void);
	inline void use_only_shadow(int value);
	enum shadow_ray_sample_method_enum {
		shadow_ray_sample_method_ADAPTIVE_QMC = 1,
		shadow_ray_sample_method_CONSTANT_QMC = 2,
	};
	inline shadow_ray_sample_method_enum shadow_ray_sample_method(void);
	inline void shadow_ray_sample_method(shadow_ray_sample_method_enum value);
	inline int shadow_ray_samples(void);
	inline void shadow_ray_samples(int value);
	inline float shadow_adaptive_threshold(void);
	inline void shadow_adaptive_threshold(float value);
	inline float shadow_soft_size(void);
	inline void shadow_soft_size(float value);
	inline bool use_shadow_layer(void);
	inline void use_shadow_layer(int value);

};

/**************** Area Lamp ****************/

class AreaLamp : public Lamp {
public:
	AreaLamp(const PointerRNA &ptr_arg) :
		Lamp(ptr_arg)
		{}

	inline bool use_shadow(void);
	inline void use_shadow(int value);
	enum shadow_method_enum {
		shadow_method_NOSHADOW = 0,
		shadow_method_RAY_SHADOW = 8192,
	};
	inline shadow_method_enum shadow_method(void);
	inline void shadow_method(shadow_method_enum value);
	inline int shadow_buffer_size(void);
	inline void shadow_buffer_size(int value);
	enum shadow_filter_type_enum {
		shadow_filter_type_BOX = 0,
		shadow_filter_type_TENT = 1,
		shadow_filter_type_GAUSS = 2,
	};
	inline shadow_filter_type_enum shadow_filter_type(void);
	inline void shadow_filter_type(shadow_filter_type_enum value);
	enum shadow_sample_buffers_enum {
		shadow_sample_buffers_BUFFERS_1 = 1,
		shadow_sample_buffers_BUFFERS_4 = 4,
		shadow_sample_buffers_BUFFERS_9 = 9,
	};
	inline shadow_sample_buffers_enum shadow_sample_buffers(void);
	inline void shadow_sample_buffers(shadow_sample_buffers_enum value);
	inline float shadow_buffer_clip_start(void);
	inline void shadow_buffer_clip_start(float value);
	inline float shadow_buffer_clip_end(void);
	inline void shadow_buffer_clip_end(float value);
	inline float shadow_buffer_bias(void);
	inline void shadow_buffer_bias(float value);
	inline float shadow_buffer_bleed_bias(void);
	inline void shadow_buffer_bleed_bias(float value);
	inline float shadow_buffer_soft(void);
	inline void shadow_buffer_soft(float value);
	inline int shadow_buffer_samples(void);
	inline void shadow_buffer_samples(int value);
	enum shadow_buffer_type_enum {
		shadow_buffer_type_REGULAR = 0,
		shadow_buffer_type_HALFWAY = 2,
		shadow_buffer_type_IRREGULAR = 1,
		shadow_buffer_type_DEEP = 3,
	};
	inline shadow_buffer_type_enum shadow_buffer_type(void);
	inline void shadow_buffer_type(shadow_buffer_type_enum value);
	enum ge_shadow_buffer_type_enum {
		ge_shadow_buffer_type_SIMPLE = 0,
		ge_shadow_buffer_type_VARIANCE = 1,
	};
	inline ge_shadow_buffer_type_enum ge_shadow_buffer_type(void);
	inline void ge_shadow_buffer_type(ge_shadow_buffer_type_enum value);
	inline bool use_auto_clip_start(void);
	inline void use_auto_clip_start(int value);
	inline bool use_auto_clip_end(void);
	inline void use_auto_clip_end(int value);
	inline float compression_threshold(void);
	inline void compression_threshold(float value);
	inline Array<float, 3> shadow_color(void);
	inline void shadow_color(float values[3]);
	inline bool use_only_shadow(void);
	inline void use_only_shadow(int value);
	enum shadow_ray_sample_method_enum {
		shadow_ray_sample_method_ADAPTIVE_QMC = 1,
		shadow_ray_sample_method_CONSTANT_QMC = 2,
		shadow_ray_sample_method_CONSTANT_JITTERED = 0,
	};
	inline shadow_ray_sample_method_enum shadow_ray_sample_method(void);
	inline void shadow_ray_sample_method(shadow_ray_sample_method_enum value);
	inline int shadow_ray_samples_x(void);
	inline void shadow_ray_samples_x(int value);
	inline int shadow_ray_samples_y(void);
	inline void shadow_ray_samples_y(int value);
	inline float shadow_adaptive_threshold(void);
	inline void shadow_adaptive_threshold(float value);
	inline float shadow_soft_size(void);
	inline void shadow_soft_size(float value);
	inline bool use_shadow_layer(void);
	inline void use_shadow_layer(int value);
	inline bool use_umbra(void);
	inline void use_umbra(int value);
	inline bool use_dither(void);
	inline void use_dither(int value);
	inline bool use_jitter(void);
	inline void use_jitter(int value);
	enum shape_enum {
		shape_SQUARE = 0,
		shape_RECTANGLE = 1,
	};
	inline shape_enum shape(void);
	inline void shape(shape_enum value);
	inline float size(void);
	inline void size(float value);
	inline float size_y(void);
	inline void size_y(float value);
	inline float gamma(void);
	inline void gamma(float value);

};

/**************** Spot Lamp ****************/

class SpotLamp : public Lamp {
public:
	SpotLamp(const PointerRNA &ptr_arg) :
		Lamp(ptr_arg)
		{}

	enum falloff_type_enum {
		falloff_type_CONSTANT = 0,
		falloff_type_INVERSE_LINEAR = 1,
		falloff_type_INVERSE_SQUARE = 2,
		falloff_type_CUSTOM_CURVE = 3,
		falloff_type_LINEAR_QUADRATIC_WEIGHTED = 4,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline CurveMapping falloff_curve(void);
	inline bool use_sphere(void);
	inline void use_sphere(int value);
	inline float linear_attenuation(void);
	inline void linear_attenuation(float value);
	inline float quadratic_attenuation(void);
	inline void quadratic_attenuation(float value);
	inline bool use_shadow(void);
	inline void use_shadow(int value);
	enum shadow_method_enum {
		shadow_method_NOSHADOW = 0,
		shadow_method_BUFFER_SHADOW = 1,
		shadow_method_RAY_SHADOW = 8192,
	};
	inline shadow_method_enum shadow_method(void);
	inline void shadow_method(shadow_method_enum value);
	inline int shadow_buffer_size(void);
	inline void shadow_buffer_size(int value);
	enum shadow_filter_type_enum {
		shadow_filter_type_BOX = 0,
		shadow_filter_type_TENT = 1,
		shadow_filter_type_GAUSS = 2,
	};
	inline shadow_filter_type_enum shadow_filter_type(void);
	inline void shadow_filter_type(shadow_filter_type_enum value);
	enum shadow_sample_buffers_enum {
		shadow_sample_buffers_BUFFERS_1 = 1,
		shadow_sample_buffers_BUFFERS_4 = 4,
		shadow_sample_buffers_BUFFERS_9 = 9,
	};
	inline shadow_sample_buffers_enum shadow_sample_buffers(void);
	inline void shadow_sample_buffers(shadow_sample_buffers_enum value);
	inline float shadow_buffer_clip_start(void);
	inline void shadow_buffer_clip_start(float value);
	inline float shadow_buffer_clip_end(void);
	inline void shadow_buffer_clip_end(float value);
	inline float shadow_buffer_bias(void);
	inline void shadow_buffer_bias(float value);
	inline float shadow_buffer_bleed_bias(void);
	inline void shadow_buffer_bleed_bias(float value);
	inline float shadow_buffer_soft(void);
	inline void shadow_buffer_soft(float value);
	inline int shadow_buffer_samples(void);
	inline void shadow_buffer_samples(int value);
	enum shadow_buffer_type_enum {
		shadow_buffer_type_REGULAR = 0,
		shadow_buffer_type_HALFWAY = 2,
		shadow_buffer_type_IRREGULAR = 1,
		shadow_buffer_type_DEEP = 3,
	};
	inline shadow_buffer_type_enum shadow_buffer_type(void);
	inline void shadow_buffer_type(shadow_buffer_type_enum value);
	enum ge_shadow_buffer_type_enum {
		ge_shadow_buffer_type_SIMPLE = 0,
		ge_shadow_buffer_type_VARIANCE = 1,
	};
	inline ge_shadow_buffer_type_enum ge_shadow_buffer_type(void);
	inline void ge_shadow_buffer_type(ge_shadow_buffer_type_enum value);
	inline bool use_auto_clip_start(void);
	inline void use_auto_clip_start(int value);
	inline bool use_auto_clip_end(void);
	inline void use_auto_clip_end(int value);
	inline float compression_threshold(void);
	inline void compression_threshold(float value);
	inline Array<float, 3> shadow_color(void);
	inline void shadow_color(float values[3]);
	inline bool use_only_shadow(void);
	inline void use_only_shadow(int value);
	enum shadow_ray_sample_method_enum {
		shadow_ray_sample_method_ADAPTIVE_QMC = 1,
		shadow_ray_sample_method_CONSTANT_QMC = 2,
	};
	inline shadow_ray_sample_method_enum shadow_ray_sample_method(void);
	inline void shadow_ray_sample_method(shadow_ray_sample_method_enum value);
	inline int shadow_ray_samples(void);
	inline void shadow_ray_samples(int value);
	inline float shadow_adaptive_threshold(void);
	inline void shadow_adaptive_threshold(float value);
	inline float shadow_soft_size(void);
	inline void shadow_soft_size(float value);
	inline bool use_shadow_layer(void);
	inline void use_shadow_layer(int value);
	inline bool use_square(void);
	inline void use_square(int value);
	inline bool use_halo(void);
	inline void use_halo(int value);
	inline float halo_intensity(void);
	inline void halo_intensity(float value);
	inline int halo_step(void);
	inline void halo_step(int value);
	inline float spot_blend(void);
	inline void spot_blend(float value);
	inline float spot_size(void);
	inline void spot_size(float value);
	inline bool show_cone(void);
	inline void show_cone(int value);

};

/**************** Sun Lamp ****************/

class SunLamp : public Lamp {
public:
	SunLamp(const PointerRNA &ptr_arg) :
		Lamp(ptr_arg)
		{}

	inline bool use_shadow(void);
	inline void use_shadow(int value);
	enum shadow_method_enum {
		shadow_method_NOSHADOW = 0,
		shadow_method_RAY_SHADOW = 8192,
	};
	inline shadow_method_enum shadow_method(void);
	inline void shadow_method(shadow_method_enum value);
	inline int shadow_buffer_size(void);
	inline void shadow_buffer_size(int value);
	enum shadow_filter_type_enum {
		shadow_filter_type_BOX = 0,
		shadow_filter_type_TENT = 1,
		shadow_filter_type_GAUSS = 2,
	};
	inline shadow_filter_type_enum shadow_filter_type(void);
	inline void shadow_filter_type(shadow_filter_type_enum value);
	enum shadow_sample_buffers_enum {
		shadow_sample_buffers_BUFFERS_1 = 1,
		shadow_sample_buffers_BUFFERS_4 = 4,
		shadow_sample_buffers_BUFFERS_9 = 9,
	};
	inline shadow_sample_buffers_enum shadow_sample_buffers(void);
	inline void shadow_sample_buffers(shadow_sample_buffers_enum value);
	inline float shadow_buffer_clip_start(void);
	inline void shadow_buffer_clip_start(float value);
	inline float shadow_buffer_clip_end(void);
	inline void shadow_buffer_clip_end(float value);
	inline float shadow_buffer_bias(void);
	inline void shadow_buffer_bias(float value);
	inline float shadow_buffer_bleed_bias(void);
	inline void shadow_buffer_bleed_bias(float value);
	inline float shadow_buffer_soft(void);
	inline void shadow_buffer_soft(float value);
	inline int shadow_buffer_samples(void);
	inline void shadow_buffer_samples(int value);
	enum shadow_buffer_type_enum {
		shadow_buffer_type_REGULAR = 0,
		shadow_buffer_type_HALFWAY = 2,
		shadow_buffer_type_IRREGULAR = 1,
		shadow_buffer_type_DEEP = 3,
	};
	inline shadow_buffer_type_enum shadow_buffer_type(void);
	inline void shadow_buffer_type(shadow_buffer_type_enum value);
	enum ge_shadow_buffer_type_enum {
		ge_shadow_buffer_type_SIMPLE = 0,
		ge_shadow_buffer_type_VARIANCE = 1,
	};
	inline ge_shadow_buffer_type_enum ge_shadow_buffer_type(void);
	inline void ge_shadow_buffer_type(ge_shadow_buffer_type_enum value);
	inline bool use_auto_clip_start(void);
	inline void use_auto_clip_start(int value);
	inline bool use_auto_clip_end(void);
	inline void use_auto_clip_end(int value);
	inline float compression_threshold(void);
	inline void compression_threshold(float value);
	inline Array<float, 3> shadow_color(void);
	inline void shadow_color(float values[3]);
	inline bool use_only_shadow(void);
	inline void use_only_shadow(int value);
	enum shadow_ray_sample_method_enum {
		shadow_ray_sample_method_ADAPTIVE_QMC = 1,
		shadow_ray_sample_method_CONSTANT_QMC = 2,
	};
	inline shadow_ray_sample_method_enum shadow_ray_sample_method(void);
	inline void shadow_ray_sample_method(shadow_ray_sample_method_enum value);
	inline int shadow_ray_samples(void);
	inline void shadow_ray_samples(int value);
	inline float shadow_adaptive_threshold(void);
	inline void shadow_adaptive_threshold(float value);
	inline float shadow_soft_size(void);
	inline void shadow_soft_size(float value);
	inline bool use_shadow_layer(void);
	inline void use_shadow_layer(int value);
	inline LampSkySettings sky(void);
	inline float shadow_frustum_size(void);
	inline void shadow_frustum_size(float value);

};

/**************** Lamp Sky Settings ****************/

class LampSkySettings : public Pointer {
public:
	LampSkySettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum sky_color_space_enum {
		sky_color_space_SMPTE = 0,
		sky_color_space_REC709 = 1,
		sky_color_space_CIE = 2,
	};
	inline sky_color_space_enum sky_color_space(void);
	inline void sky_color_space(sky_color_space_enum value);
	enum sky_blend_type_enum {
		sky_blend_type_MIX = 0,
		sky_blend_type_ADD = 1,
		sky_blend_type_MULTIPLY = 2,
		sky_blend_type_SUBTRACT = 3,
		sky_blend_type_SCREEN = 4,
		sky_blend_type_DIVIDE = 5,
		sky_blend_type_DIFFERENCE = 6,
		sky_blend_type_DARKEN = 7,
		sky_blend_type_LIGHTEN = 8,
		sky_blend_type_OVERLAY = 9,
		sky_blend_type_DODGE = 10,
		sky_blend_type_BURN = 11,
		sky_blend_type_HUE = 12,
		sky_blend_type_SATURATION = 13,
		sky_blend_type_VALUE = 14,
		sky_blend_type_COLOR = 15,
		sky_blend_type_SOFT_LIGHT = 16,
		sky_blend_type_LINEAR_LIGHT = 17,
	};
	inline sky_blend_type_enum sky_blend_type(void);
	inline void sky_blend_type(sky_blend_type_enum value);
	inline float horizon_brightness(void);
	inline void horizon_brightness(float value);
	inline float spread(void);
	inline void spread(float value);
	inline float sun_brightness(void);
	inline void sun_brightness(float value);
	inline float sun_size(void);
	inline void sun_size(float value);
	inline float backscattered_light(void);
	inline void backscattered_light(float value);
	inline float sun_intensity(void);
	inline void sun_intensity(float value);
	inline float atmosphere_turbidity(void);
	inline void atmosphere_turbidity(float value);
	inline float atmosphere_inscattering(void);
	inline void atmosphere_inscattering(float value);
	inline float atmosphere_extinction(void);
	inline void atmosphere_extinction(float value);
	inline float atmosphere_distance_factor(void);
	inline void atmosphere_distance_factor(float value);
	inline float sky_blend(void);
	inline void sky_blend(float value);
	inline float sky_exposure(void);
	inline void sky_exposure(float value);
	inline bool use_sky(void);
	inline void use_sky(int value);
	inline bool use_atmosphere(void);
	inline void use_atmosphere(int value);

};

/**************** Hemi Lamp ****************/

class HemiLamp : public Lamp {
public:
	HemiLamp(const PointerRNA &ptr_arg) :
		Lamp(ptr_arg)
		{}


};

/**************** Lamp Texture Slot ****************/

class LampTextureSlot : public TextureSlot {
public:
	LampTextureSlot(const PointerRNA &ptr_arg) :
		TextureSlot(ptr_arg)
		{}

	enum texture_coords_enum {
		texture_coords_GLOBAL = 8,
		texture_coords_VIEW = 128,
		texture_coords_OBJECT = 32,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline Object object(void);
	inline bool use_map_color(void);
	inline void use_map_color(int value);
	inline bool use_map_shadow(void);
	inline void use_map_shadow(int value);
	inline float color_factor(void);
	inline void color_factor(float value);
	inline float shadow_factor(void);
	inline void shadow_factor(float value);

};

/**************** Lattice ****************/

class Lattice : public ID {
public:
	Lattice(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		points(ptr_arg)
		{}

	inline int points_u(void);
	inline void points_u(int value);
	inline int points_v(void);
	inline void points_v(int value);
	inline int points_w(void);
	inline void points_w(int value);
	enum interpolation_type_u_enum {
		interpolation_type_u_KEY_LINEAR = 0,
		interpolation_type_u_KEY_CARDINAL = 1,
		interpolation_type_u_KEY_CATMULL_ROM = 3,
		interpolation_type_u_KEY_BSPLINE = 2,
	};
	inline interpolation_type_u_enum interpolation_type_u(void);
	inline void interpolation_type_u(interpolation_type_u_enum value);
	enum interpolation_type_v_enum {
		interpolation_type_v_KEY_LINEAR = 0,
		interpolation_type_v_KEY_CARDINAL = 1,
		interpolation_type_v_KEY_CATMULL_ROM = 3,
		interpolation_type_v_KEY_BSPLINE = 2,
	};
	inline interpolation_type_v_enum interpolation_type_v(void);
	inline void interpolation_type_v(interpolation_type_v_enum value);
	enum interpolation_type_w_enum {
		interpolation_type_w_KEY_LINEAR = 0,
		interpolation_type_w_KEY_CARDINAL = 1,
		interpolation_type_w_KEY_CATMULL_ROM = 3,
		interpolation_type_w_KEY_BSPLINE = 2,
	};
	inline interpolation_type_w_enum interpolation_type_w(void);
	inline void interpolation_type_w(interpolation_type_w_enum value);
	inline bool use_outside(void);
	inline void use_outside(int value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline Key shape_keys(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, LatticePoint, Lattice, points, false, false, false)
	inline bool is_editmode(void);
	inline void is_editmode(int value);
	inline AnimData animation_data(void);

	inline void transform(float matrix[16], int shape_keys);
};

/**************** LatticePoint ****************/

class LatticePoint : public Pointer {
public:
	LatticePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		groups(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select(void);
	inline void select(int value);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 3> co_deform(void);
	inline void co_deform(float values[3]);
	inline float weight_softbody(void);
	inline void weight_softbody(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, VertexGroupElement, LatticePoint, groups, false, false, false)

};

/**************** Line Style Modifier ****************/

class LineStyleModifier : public Pointer {
public:
	LineStyleModifier(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Line Style Color Modifier ****************/

class LineStyleColorModifier : public LineStyleModifier {
public:
	LineStyleColorModifier(const PointerRNA &ptr_arg) :
		LineStyleModifier(ptr_arg)
		{}


};

/**************** Along Stroke ****************/

class LineStyleColorModifier_AlongStroke : public LineStyleColorModifier {
public:
	LineStyleColorModifier_AlongStroke(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_MULTIPLY = 2,
		blend_SUBTRACT = 3,
		blend_SCREEN = 4,
		blend_DIVIDE = 5,
		blend_DIFFERENCE = 6,
		blend_DARKEN = 7,
		blend_LIGHTEN = 8,
		blend_OVERLAY = 9,
		blend_DODGE = 10,
		blend_BURN = 11,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_VALUE = 14,
		blend_COLOR = 15,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline ColorRamp color_ramp(void);

};

/**************** Distance from Camera ****************/

class LineStyleColorModifier_DistanceFromCamera : public LineStyleColorModifier {
public:
	LineStyleColorModifier_DistanceFromCamera(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_MULTIPLY = 2,
		blend_SUBTRACT = 3,
		blend_SCREEN = 4,
		blend_DIVIDE = 5,
		blend_DIFFERENCE = 6,
		blend_DARKEN = 7,
		blend_LIGHTEN = 8,
		blend_OVERLAY = 9,
		blend_DODGE = 10,
		blend_BURN = 11,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_VALUE = 14,
		blend_COLOR = 15,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline ColorRamp color_ramp(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);

};

/**************** Distance from Object ****************/

class LineStyleColorModifier_DistanceFromObject : public LineStyleColorModifier {
public:
	LineStyleColorModifier_DistanceFromObject(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_MULTIPLY = 2,
		blend_SUBTRACT = 3,
		blend_SCREEN = 4,
		blend_DIVIDE = 5,
		blend_DIFFERENCE = 6,
		blend_DARKEN = 7,
		blend_LIGHTEN = 8,
		blend_OVERLAY = 9,
		blend_DODGE = 10,
		blend_BURN = 11,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_VALUE = 14,
		blend_COLOR = 15,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline ColorRamp color_ramp(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);
	inline Object target(void);

};

/**************** Material ****************/

class LineStyleColorModifier_Material : public LineStyleColorModifier {
public:
	LineStyleColorModifier_Material(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_MULTIPLY = 2,
		blend_SUBTRACT = 3,
		blend_SCREEN = 4,
		blend_DIVIDE = 5,
		blend_DIFFERENCE = 6,
		blend_DARKEN = 7,
		blend_LIGHTEN = 8,
		blend_OVERLAY = 9,
		blend_DODGE = 10,
		blend_BURN = 11,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_VALUE = 14,
		blend_COLOR = 15,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum material_attribute_enum {
		material_attribute_LINE = 11,
		material_attribute_LINE_R = 12,
		material_attribute_LINE_G = 13,
		material_attribute_LINE_B = 14,
		material_attribute_LINE_A = 15,
		material_attribute_DIFF = 1,
		material_attribute_DIFF_R = 2,
		material_attribute_DIFF_G = 3,
		material_attribute_DIFF_B = 4,
		material_attribute_SPEC = 5,
		material_attribute_SPEC_R = 6,
		material_attribute_SPEC_G = 7,
		material_attribute_SPEC_B = 8,
		material_attribute_SPEC_HARD = 9,
		material_attribute_ALPHA = 10,
	};
	inline material_attribute_enum material_attribute(void);
	inline void material_attribute(material_attribute_enum value);
	inline ColorRamp color_ramp(void);
	inline bool use_ramp(void);
	inline void use_ramp(int value);

};

/**************** Line Style Alpha Modifier ****************/

class LineStyleAlphaModifier : public LineStyleModifier {
public:
	LineStyleAlphaModifier(const PointerRNA &ptr_arg) :
		LineStyleModifier(ptr_arg)
		{}


};

/**************** Along Stroke ****************/

class LineStyleAlphaModifier_AlongStroke : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_AlongStroke(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MININUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(int value);
	inline CurveMapping curve(void);

};

/**************** Distance from Camera ****************/

class LineStyleAlphaModifier_DistanceFromCamera : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_DistanceFromCamera(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MININUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(int value);
	inline CurveMapping curve(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);

};

/**************** Distance from Object ****************/

class LineStyleAlphaModifier_DistanceFromObject : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_DistanceFromObject(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MININUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(int value);
	inline CurveMapping curve(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);
	inline Object target(void);

};

/**************** Material ****************/

class LineStyleAlphaModifier_Material : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_Material(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MININUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum material_attribute_enum {
		material_attribute_LINE = 11,
		material_attribute_LINE_R = 12,
		material_attribute_LINE_G = 13,
		material_attribute_LINE_B = 14,
		material_attribute_LINE_A = 15,
		material_attribute_DIFF = 1,
		material_attribute_DIFF_R = 2,
		material_attribute_DIFF_G = 3,
		material_attribute_DIFF_B = 4,
		material_attribute_SPEC = 5,
		material_attribute_SPEC_R = 6,
		material_attribute_SPEC_G = 7,
		material_attribute_SPEC_B = 8,
		material_attribute_SPEC_HARD = 9,
		material_attribute_ALPHA = 10,
	};
	inline material_attribute_enum material_attribute(void);
	inline void material_attribute(material_attribute_enum value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(int value);
	inline CurveMapping curve(void);

};

/**************** Line Style Thickness Modifier ****************/

class LineStyleThicknessModifier : public LineStyleModifier {
public:
	LineStyleThicknessModifier(const PointerRNA &ptr_arg) :
		LineStyleModifier(ptr_arg)
		{}


};

/**************** Along Stroke ****************/

class LineStyleThicknessModifier_AlongStroke : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_AlongStroke(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MININUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(int value);
	inline CurveMapping curve(void);
	inline float value_min(void);
	inline void value_min(float value);
	inline float value_max(void);
	inline void value_max(float value);

};

/**************** Distance from Camera ****************/

class LineStyleThicknessModifier_DistanceFromCamera : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_DistanceFromCamera(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MININUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(int value);
	inline CurveMapping curve(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);
	inline float value_min(void);
	inline void value_min(float value);
	inline float value_max(void);
	inline void value_max(float value);

};

/**************** Distance from Object ****************/

class LineStyleThicknessModifier_DistanceFromObject : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_DistanceFromObject(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MININUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(int value);
	inline CurveMapping curve(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);
	inline float value_min(void);
	inline void value_min(float value);
	inline float value_max(void);
	inline void value_max(float value);
	inline Object target(void);

};

/**************** Material ****************/

class LineStyleThicknessModifier_Material : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_Material(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MININUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum material_attribute_enum {
		material_attribute_LINE = 11,
		material_attribute_LINE_R = 12,
		material_attribute_LINE_G = 13,
		material_attribute_LINE_B = 14,
		material_attribute_LINE_A = 15,
		material_attribute_DIFF = 1,
		material_attribute_DIFF_R = 2,
		material_attribute_DIFF_G = 3,
		material_attribute_DIFF_B = 4,
		material_attribute_SPEC = 5,
		material_attribute_SPEC_R = 6,
		material_attribute_SPEC_G = 7,
		material_attribute_SPEC_B = 8,
		material_attribute_SPEC_HARD = 9,
		material_attribute_ALPHA = 10,
	};
	inline material_attribute_enum material_attribute(void);
	inline void material_attribute(material_attribute_enum value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(int value);
	inline CurveMapping curve(void);
	inline float value_min(void);
	inline void value_min(float value);
	inline float value_max(void);
	inline void value_max(float value);

};

/**************** Calligraphy ****************/

class LineStyleThicknessModifier_Calligraphy : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_Calligraphy(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MININUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float orientation(void);
	inline void orientation(float value);
	inline float thickness_min(void);
	inline void thickness_min(float value);
	inline float thickness_max(void);
	inline void thickness_max(float value);

};

/**************** Line Style Geometry Modifier ****************/

class LineStyleGeometryModifier : public LineStyleModifier {
public:
	LineStyleGeometryModifier(const PointerRNA &ptr_arg) :
		LineStyleModifier(ptr_arg)
		{}


};

/**************** Sampling ****************/

class LineStyleGeometryModifier_Sampling : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_Sampling(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float sampling(void);
	inline void sampling(float value);

};

/**************** Bezier Curve ****************/

class LineStyleGeometryModifier_BezierCurve : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_BezierCurve(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float error(void);
	inline void error(float value);

};

/**************** Sinus Displacement ****************/

class LineStyleGeometryModifier_SinusDisplacement : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_SinusDisplacement(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float wavelength(void);
	inline void wavelength(float value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float phase(void);
	inline void phase(float value);

};

/**************** Spatial Noise ****************/

class LineStyleGeometryModifier_SpatialNoise : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_SpatialNoise(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float scale(void);
	inline void scale(float value);
	inline int octaves(void);
	inline void octaves(int value);
	inline bool smooth(void);
	inline void smooth(int value);
	inline bool use_pure_random(void);
	inline void use_pure_random(int value);

};

/**************** Perlin Noise 1D ****************/

class LineStyleGeometryModifier_PerlinNoise1D : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_PerlinNoise1D(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float frequency(void);
	inline void frequency(float value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline int octaves(void);
	inline void octaves(int value);
	inline float angle(void);
	inline void angle(float value);
	inline int seed(void);
	inline void seed(int value);

};

/**************** Perlin Noise 2D ****************/

class LineStyleGeometryModifier_PerlinNoise2D : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_PerlinNoise2D(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float frequency(void);
	inline void frequency(float value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline int octaves(void);
	inline void octaves(int value);
	inline float angle(void);
	inline void angle(float value);
	inline int seed(void);
	inline void seed(int value);

};

/**************** Backbone Stretcher ****************/

class LineStyleGeometryModifier_BackboneStretcher : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_BackboneStretcher(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float backbone_length(void);
	inline void backbone_length(float value);

};

/**************** Tip Remover ****************/

class LineStyleGeometryModifier_TipRemover : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_TipRemover(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float tip_length(void);
	inline void tip_length(float value);

};

/**************** Polygonalization ****************/

class LineStyleGeometryModifier_Polygonalization : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_Polygonalization(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float error(void);
	inline void error(float value);

};

/**************** Guiding Lines ****************/

class LineStyleGeometryModifier_GuidingLines : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_GuidingLines(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float offset(void);
	inline void offset(float value);

};

/**************** Blueprint ****************/

class LineStyleGeometryModifier_Blueprint : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_Blueprint(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum shape_enum {
		shape_CIRCLES = 1,
		shape_ELLIPSES = 2,
		shape_SQUARES = 4,
	};
	inline shape_enum shape(void);
	inline void shape(shape_enum value);
	inline int rounds(void);
	inline void rounds(int value);
	inline float backbone_length(void);
	inline void backbone_length(float value);
	inline int random_radius(void);
	inline void random_radius(int value);
	inline int random_center(void);
	inline void random_center(int value);
	inline int random_backbone(void);
	inline void random_backbone(int value);

};

/**************** 2D Offset ****************/

class LineStyleGeometryModifier_2DOffset : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_2DOffset(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	inline float start(void);
	inline void start(float value);
	inline float end(void);
	inline void end(float value);
	inline float x(void);
	inline void x(float value);
	inline float y(void);
	inline void y(float value);

};

/**************** 2D Transform ****************/

class LineStyleGeometryModifier_2DTransform : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_2DTransform(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool use(void);
	inline void use(int value);
	inline bool expanded(void);
	inline void expanded(int value);
	enum pivot_enum {
		pivot_CENTER = 1,
		pivot_START = 2,
		pivot_END = 3,
		pivot_PARAM = 4,
		pivot_ABSOLUTE = 5,
	};
	inline pivot_enum pivot(void);
	inline void pivot(pivot_enum value);
	inline float scale_x(void);
	inline void scale_x(float value);
	inline float scale_y(void);
	inline void scale_y(float value);
	inline float angle(void);
	inline void angle(float value);
	inline float pivot_u(void);
	inline void pivot_u(float value);
	inline float pivot_x(void);
	inline void pivot_x(float value);
	inline float pivot_y(void);
	inline void pivot_y(float value);

};

/**************** Freestyle Line Style ****************/

class FreestyleLineStyle : public ID {
public:
	FreestyleLineStyle(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		texture_slots(ptr_arg),
		color_modifiers(ptr_arg),
		alpha_modifiers(ptr_arg),
		thickness_modifiers(ptr_arg),
		geometry_modifiers(ptr_arg)
		{}

	COLLECTION_PROPERTY(LineStyleTextureSlots, LineStyleTextureSlot, FreestyleLineStyle, texture_slots, false, false, false)
	inline Texture active_texture(void);
	inline int active_texture_index(void);
	inline void active_texture_index(int value);
	enum panel_enum {
		panel_STROKES = 1,
		panel_COLOR = 2,
		panel_ALPHA = 3,
		panel_THICKNESS = 4,
		panel_GEOMETRY = 5,
		panel_TEXTURE = 6,
	};
	inline panel_enum panel(void);
	inline void panel(panel_enum value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline float alpha(void);
	inline void alpha(float value);
	inline float thickness(void);
	inline void thickness(float value);
	enum thickness_position_enum {
		thickness_position_CENTER = 1,
		thickness_position_INSIDE = 2,
		thickness_position_OUTSIDE = 3,
		thickness_position_RELATIVE = 4,
	};
	inline thickness_position_enum thickness_position(void);
	inline void thickness_position(thickness_position_enum value);
	inline float thickness_ratio(void);
	inline void thickness_ratio(float value);
	COLLECTION_PROPERTY(LineStyleColorModifiers, LineStyleColorModifier, FreestyleLineStyle, color_modifiers, false, true, false)
	COLLECTION_PROPERTY(LineStyleAlphaModifiers, LineStyleAlphaModifier, FreestyleLineStyle, alpha_modifiers, false, true, false)
	COLLECTION_PROPERTY(LineStyleThicknessModifiers, LineStyleThicknessModifier, FreestyleLineStyle, thickness_modifiers, false, true, false)
	COLLECTION_PROPERTY(LineStyleGeometryModifiers, LineStyleGeometryModifier, FreestyleLineStyle, geometry_modifiers, false, true, false)
	inline bool use_chaining(void);
	inline void use_chaining(int value);
	enum chaining_enum {
		chaining_PLAIN = 1,
		chaining_SKETCHY = 2,
	};
	inline chaining_enum chaining(void);
	inline void chaining(chaining_enum value);
	inline int rounds(void);
	inline void rounds(int value);
	inline bool use_same_object(void);
	inline void use_same_object(int value);
	inline bool use_split_length(void);
	inline void use_split_length(int value);
	inline float split_length(void);
	inline void split_length(float value);
	inline bool use_angle_min(void);
	inline void use_angle_min(int value);
	inline float angle_min(void);
	inline void angle_min(float value);
	inline bool use_angle_max(void);
	inline void use_angle_max(int value);
	inline float angle_max(void);
	inline void angle_max(float value);
	inline bool use_length_min(void);
	inline void use_length_min(int value);
	inline float length_min(void);
	inline void length_min(float value);
	inline bool use_length_max(void);
	inline void use_length_max(int value);
	inline float length_max(void);
	inline void length_max(float value);
	inline bool use_chain_count(void);
	inline void use_chain_count(int value);
	inline int chain_count(void);
	inline void chain_count(int value);
	inline bool use_split_pattern(void);
	inline void use_split_pattern(int value);
	inline int split_dash1(void);
	inline void split_dash1(int value);
	inline int split_gap1(void);
	inline void split_gap1(int value);
	inline int split_dash2(void);
	inline void split_dash2(int value);
	inline int split_gap2(void);
	inline void split_gap2(int value);
	inline int split_dash3(void);
	inline void split_dash3(int value);
	inline int split_gap3(void);
	inline void split_gap3(int value);
	inline bool material_boundary(void);
	inline void material_boundary(int value);
	inline bool use_sorting(void);
	inline void use_sorting(int value);
	enum sort_key_enum {
		sort_key_DISTANCE_FROM_CAMERA = 1,
		sort_key_2D_LENGTH = 2,
		sort_key_PROJECTED_X = 3,
		sort_key_PROJECTED_Y = 4,
	};
	inline sort_key_enum sort_key(void);
	inline void sort_key(sort_key_enum value);
	enum sort_order_enum {
		sort_order_DEFAULT = 0,
		sort_order_REVERSE = 4096,
	};
	inline sort_order_enum sort_order(void);
	inline void sort_order(sort_order_enum value);
	enum integration_type_enum {
		integration_type_MEAN = 1,
		integration_type_MIN = 2,
		integration_type_MAX = 3,
		integration_type_FIRST = 4,
		integration_type_LAST = 5,
	};
	inline integration_type_enum integration_type(void);
	inline void integration_type(integration_type_enum value);
	inline bool use_dashed_line(void);
	inline void use_dashed_line(int value);
	enum caps_enum {
		caps_BUTT = 1,
		caps_ROUND = 2,
		caps_SQUARE = 3,
	};
	inline caps_enum caps(void);
	inline void caps(caps_enum value);
	inline int dash1(void);
	inline void dash1(int value);
	inline int gap1(void);
	inline void gap1(int value);
	inline int dash2(void);
	inline void dash2(int value);
	inline int gap2(void);
	inline void gap2(int value);
	inline int dash3(void);
	inline void dash3(int value);
	inline int gap3(void);
	inline void gap3(int value);
	inline bool use_texture(void);
	inline void use_texture(int value);
	inline float texture_spacing(void);
	inline void texture_spacing(float value);
	inline NodeTree node_tree(void);
	inline bool use_nodes(void);
	inline void use_nodes(int value);

};

/**************** LineStyle Texture Slot ****************/

class LineStyleTextureSlot : public TextureSlot {
public:
	LineStyleTextureSlot(const PointerRNA &ptr_arg) :
		TextureSlot(ptr_arg)
		{}

	enum mapping_x_enum {
		mapping_x_NONE = 0,
		mapping_x_X = 1,
		mapping_x_Y = 2,
		mapping_x_Z = 3,
	};
	inline mapping_x_enum mapping_x(void);
	inline void mapping_x(mapping_x_enum value);
	enum mapping_y_enum {
		mapping_y_NONE = 0,
		mapping_y_X = 1,
		mapping_y_Y = 2,
		mapping_y_Z = 3,
	};
	inline mapping_y_enum mapping_y(void);
	inline void mapping_y(mapping_y_enum value);
	enum mapping_z_enum {
		mapping_z_NONE = 0,
		mapping_z_X = 1,
		mapping_z_Y = 2,
		mapping_z_Z = 3,
	};
	inline mapping_z_enum mapping_z(void);
	inline void mapping_z(mapping_z_enum value);
	enum mapping_enum {
		mapping_FLAT = 0,
		mapping_CUBE = 1,
		mapping_TUBE = 2,
		mapping_SPHERE = 3,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool use_map_color_diffuse(void);
	inline void use_map_color_diffuse(int value);
	inline bool use_map_alpha(void);
	inline void use_map_alpha(int value);
	inline bool use_tips(void);
	inline void use_tips(int value);
	enum texture_coords_enum {
		texture_coords_WINDOW = 1024,
		texture_coords_GLOBAL = 8,
		texture_coords_ALONG_STROKE = 16,
		texture_coords_ORCO = 1,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline float alpha_factor(void);
	inline void alpha_factor(float value);
	inline float diffuse_color_factor(void);
	inline void diffuse_color_factor(float value);

};

/**************** Blendfile Data ****************/

class BlendData : public Pointer {
public:
	BlendData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		cameras(ptr_arg),
		scenes(ptr_arg),
		objects(ptr_arg),
		materials(ptr_arg),
		node_groups(ptr_arg),
		meshes(ptr_arg),
		lamps(ptr_arg),
		libraries(ptr_arg),
		screens(ptr_arg),
		window_managers(ptr_arg),
		images(ptr_arg),
		lattices(ptr_arg),
		curves(ptr_arg),
		metaballs(ptr_arg),
		fonts(ptr_arg),
		textures(ptr_arg),
		brushes(ptr_arg),
		worlds(ptr_arg),
		groups(ptr_arg),
		shape_keys(ptr_arg),
		scripts(ptr_arg),
		texts(ptr_arg),
		speakers(ptr_arg),
		sounds(ptr_arg),
		armatures(ptr_arg),
		actions(ptr_arg),
		particles(ptr_arg),
		grease_pencil(ptr_arg),
		movieclips(ptr_arg),
		masks(ptr_arg),
		linestyles(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline bool is_dirty(void);
	inline void is_dirty(int value);
	inline bool is_saved(void);
	inline void is_saved(int value);
	inline bool use_autopack(void);
	inline void use_autopack(int value);
	inline Array<int, 3> version(void);
	inline void version(int values[3]);
	COLLECTION_PROPERTY(BlendDataCameras, Camera, BlendData, cameras, false, false, false)
	COLLECTION_PROPERTY(BlendDataScenes, Scene, BlendData, scenes, false, false, false)
	COLLECTION_PROPERTY(BlendDataObjects, Object, BlendData, objects, false, false, false)
	COLLECTION_PROPERTY(BlendDataMaterials, Material, BlendData, materials, false, false, false)
	COLLECTION_PROPERTY(BlendDataNodeTrees, NodeTree, BlendData, node_groups, false, false, false)
	COLLECTION_PROPERTY(BlendDataMeshes, Mesh, BlendData, meshes, false, false, false)
	COLLECTION_PROPERTY(BlendDataLamps, Lamp, BlendData, lamps, false, false, false)
	COLLECTION_PROPERTY(BlendDataLibraries, Library, BlendData, libraries, false, false, false)
	COLLECTION_PROPERTY(BlendDataScreens, Screen, BlendData, screens, false, false, false)
	COLLECTION_PROPERTY(BlendDataWindowManagers, WindowManager, BlendData, window_managers, false, false, false)
	COLLECTION_PROPERTY(BlendDataImages, Image, BlendData, images, false, false, false)
	COLLECTION_PROPERTY(BlendDataLattices, Lattice, BlendData, lattices, false, false, false)
	COLLECTION_PROPERTY(BlendDataCurves, Curve, BlendData, curves, false, false, false)
	COLLECTION_PROPERTY(BlendDataMetaBalls, MetaBall, BlendData, metaballs, false, false, false)
	COLLECTION_PROPERTY(BlendDataFonts, VectorFont, BlendData, fonts, false, false, false)
	COLLECTION_PROPERTY(BlendDataTextures, Texture, BlendData, textures, false, false, false)
	COLLECTION_PROPERTY(BlendDataBrushes, Brush, BlendData, brushes, false, false, false)
	COLLECTION_PROPERTY(BlendDataWorlds, World, BlendData, worlds, false, false, false)
	COLLECTION_PROPERTY(BlendDataGroups, Group, BlendData, groups, false, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Key, BlendData, shape_keys, false, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ID, BlendData, scripts, false, false, false)
	COLLECTION_PROPERTY(BlendDataTexts, Text, BlendData, texts, false, false, false)
	COLLECTION_PROPERTY(BlendDataSpeakers, Speaker, BlendData, speakers, false, false, false)
	COLLECTION_PROPERTY(BlendDataSounds, Sound, BlendData, sounds, false, false, false)
	COLLECTION_PROPERTY(BlendDataArmatures, Armature, BlendData, armatures, false, false, false)
	COLLECTION_PROPERTY(BlendDataActions, Action, BlendData, actions, false, false, false)
	COLLECTION_PROPERTY(BlendDataParticles, ParticleSettings, BlendData, particles, false, false, false)
	COLLECTION_PROPERTY(BlendDataGreasePencils, GreasePencil, BlendData, grease_pencil, false, false, false)
	COLLECTION_PROPERTY(BlendDataMovieClips, MovieClip, BlendData, movieclips, false, false, false)
	COLLECTION_PROPERTY(BlendDataMasks, Mask, BlendData, masks, false, false, false)
	COLLECTION_PROPERTY(BlendDataLineStyles, FreestyleLineStyle, BlendData, linestyles, false, false, false)

};

/**************** Material ****************/

class Material : public ID {
public:
	Material(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		texture_slots(ptr_arg),
		texture_paint_images(ptr_arg),
		texture_paint_slots(ptr_arg)
		{}

	enum type_enum {
		type_SURFACE = 0,
		type_WIRE = 3,
		type_VOLUME = 2,
		type_HALO = 1,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use_transparency(void);
	inline void use_transparency(int value);
	enum transparency_method_enum {
		transparency_method_MASK = 0,
		transparency_method_Z_TRANSPARENCY = 64,
		transparency_method_RAYTRACE = 131072,
	};
	inline transparency_method_enum transparency_method(void);
	inline void transparency_method(transparency_method_enum value);
	enum preview_render_type_enum {
		preview_render_type_FLAT = 0,
		preview_render_type_SPHERE = 1,
		preview_render_type_CUBE = 2,
		preview_render_type_MONKEY = 3,
		preview_render_type_HAIR = 10,
		preview_render_type_SPHERE_A = 4,
	};
	inline preview_render_type_enum preview_render_type(void);
	inline void preview_render_type(preview_render_type_enum value);
	inline float ambient(void);
	inline void ambient(float value);
	inline float emit(void);
	inline void emit(float value);
	inline float translucency(void);
	inline void translucency(float value);
	inline bool use_cubic(void);
	inline void use_cubic(int value);
	inline bool use_object_color(void);
	inline void use_object_color(int value);
	inline float shadow_ray_bias(void);
	inline void shadow_ray_bias(float value);
	inline float shadow_buffer_bias(void);
	inline void shadow_buffer_bias(float value);
	inline float shadow_cast_alpha(void);
	inline void shadow_cast_alpha(float value);
	inline Group light_group(void);
	inline int pass_index(void);
	inline void pass_index(int value);
	inline bool use_light_group_exclusive(void);
	inline void use_light_group_exclusive(int value);
	inline bool use_light_group_local(void);
	inline void use_light_group_local(int value);
	inline bool use_raytrace(void);
	inline void use_raytrace(int value);
	inline bool use_shadows(void);
	inline void use_shadows(int value);
	inline bool use_shadeless(void);
	inline void use_shadeless(int value);
	inline bool use_vertex_color_light(void);
	inline void use_vertex_color_light(int value);
	inline bool use_vertex_color_paint(void);
	inline void use_vertex_color_paint(int value);
	inline bool invert_z(void);
	inline void invert_z(int value);
	inline float offset_z(void);
	inline void offset_z(float value);
	inline bool use_sky(void);
	inline void use_sky(int value);
	inline bool use_only_shadow(void);
	inline void use_only_shadow(int value);
	enum shadow_only_type_enum {
		shadow_only_type_SHADOW_ONLY_OLD = 0,
		shadow_only_type_SHADOW_ONLY = 1,
		shadow_only_type_SHADOW_ONLY_SHADED = 2,
	};
	inline shadow_only_type_enum shadow_only_type(void);
	inline void shadow_only_type(shadow_only_type_enum value);
	inline bool use_face_texture(void);
	inline void use_face_texture(int value);
	inline bool use_face_texture_alpha(void);
	inline void use_face_texture_alpha(int value);
	inline bool use_cast_shadows(void);
	inline void use_cast_shadows(int value);
	inline bool use_cast_shadows_only(void);
	inline void use_cast_shadows_only(int value);
	inline bool use_mist(void);
	inline void use_mist(int value);
	inline bool use_transparent_shadows(void);
	inline void use_transparent_shadows(int value);
	inline bool use_ray_shadow_bias(void);
	inline void use_ray_shadow_bias(int value);
	inline bool use_full_oversampling(void);
	inline void use_full_oversampling(int value);
	inline bool use_cast_buffer_shadows(void);
	inline void use_cast_buffer_shadows(int value);
	inline bool use_cast_approximate(void);
	inline void use_cast_approximate(int value);
	inline bool use_tangent_shading(void);
	inline void use_tangent_shading(int value);
	inline bool use_uv_project(void);
	inline void use_uv_project(int value);
	inline MaterialRaytraceMirror raytrace_mirror(void);
	inline MaterialRaytraceTransparency raytrace_transparency(void);
	inline MaterialVolume volume(void);
	inline MaterialHalo halo(void);
	inline MaterialSubsurfaceScattering subsurface_scattering(void);
	inline MaterialStrand strand(void);
	inline MaterialPhysics physics(void);
	inline MaterialGameSettings game_settings(void);
	inline NodeTree node_tree(void);
	inline bool use_nodes(void);
	inline void use_nodes(int value);
	inline Material active_node_material(void);
	inline AnimData animation_data(void);
	COLLECTION_PROPERTY(MaterialTextureSlots, MaterialTextureSlot, Material, texture_slots, false, false, false)
	inline Texture active_texture(void);
	inline int active_texture_index(void);
	inline void active_texture_index(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Image, Material, texture_paint_images, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, TexPaintSlot, Material, texture_paint_slots, false, false, false)
	inline int paint_active_slot(void);
	inline void paint_active_slot(int value);
	inline int paint_clone_slot(void);
	inline void paint_clone_slot(int value);
	inline Array<int, 18> use_textures(void);
	inline void use_textures(int values[18]);
	inline Array<float, 3> diffuse_color(void);
	inline void diffuse_color(float values[3]);
	inline Array<float, 3> specular_color(void);
	inline void specular_color(float values[3]);
	inline Array<float, 3> mirror_color(void);
	inline void mirror_color(float values[3]);
	inline float alpha(void);
	inline void alpha(float value);
	inline float specular_alpha(void);
	inline void specular_alpha(float value);
	inline bool use_diffuse_ramp(void);
	inline void use_diffuse_ramp(int value);
	inline ColorRamp diffuse_ramp(void);
	inline bool use_specular_ramp(void);
	inline void use_specular_ramp(int value);
	inline ColorRamp specular_ramp(void);
	enum diffuse_ramp_blend_enum {
		diffuse_ramp_blend_MIX = 0,
		diffuse_ramp_blend_ADD = 1,
		diffuse_ramp_blend_MULTIPLY = 2,
		diffuse_ramp_blend_SUBTRACT = 3,
		diffuse_ramp_blend_SCREEN = 4,
		diffuse_ramp_blend_DIVIDE = 5,
		diffuse_ramp_blend_DIFFERENCE = 6,
		diffuse_ramp_blend_DARKEN = 7,
		diffuse_ramp_blend_LIGHTEN = 8,
		diffuse_ramp_blend_OVERLAY = 9,
		diffuse_ramp_blend_DODGE = 10,
		diffuse_ramp_blend_BURN = 11,
		diffuse_ramp_blend_HUE = 12,
		diffuse_ramp_blend_SATURATION = 13,
		diffuse_ramp_blend_VALUE = 14,
		diffuse_ramp_blend_COLOR = 15,
		diffuse_ramp_blend_SOFT_LIGHT = 16,
		diffuse_ramp_blend_LINEAR_LIGHT = 17,
	};
	inline diffuse_ramp_blend_enum diffuse_ramp_blend(void);
	inline void diffuse_ramp_blend(diffuse_ramp_blend_enum value);
	enum specular_ramp_blend_enum {
		specular_ramp_blend_MIX = 0,
		specular_ramp_blend_ADD = 1,
		specular_ramp_blend_MULTIPLY = 2,
		specular_ramp_blend_SUBTRACT = 3,
		specular_ramp_blend_SCREEN = 4,
		specular_ramp_blend_DIVIDE = 5,
		specular_ramp_blend_DIFFERENCE = 6,
		specular_ramp_blend_DARKEN = 7,
		specular_ramp_blend_LIGHTEN = 8,
		specular_ramp_blend_OVERLAY = 9,
		specular_ramp_blend_DODGE = 10,
		specular_ramp_blend_BURN = 11,
		specular_ramp_blend_HUE = 12,
		specular_ramp_blend_SATURATION = 13,
		specular_ramp_blend_VALUE = 14,
		specular_ramp_blend_COLOR = 15,
		specular_ramp_blend_SOFT_LIGHT = 16,
		specular_ramp_blend_LINEAR_LIGHT = 17,
	};
	inline specular_ramp_blend_enum specular_ramp_blend(void);
	inline void specular_ramp_blend(specular_ramp_blend_enum value);
	enum diffuse_ramp_input_enum {
		diffuse_ramp_input_SHADER = 0,
		diffuse_ramp_input_ENERGY = 1,
		diffuse_ramp_input_NORMAL = 2,
		diffuse_ramp_input_RESULT = 3,
	};
	inline diffuse_ramp_input_enum diffuse_ramp_input(void);
	inline void diffuse_ramp_input(diffuse_ramp_input_enum value);
	enum specular_ramp_input_enum {
		specular_ramp_input_SHADER = 0,
		specular_ramp_input_ENERGY = 1,
		specular_ramp_input_NORMAL = 2,
		specular_ramp_input_RESULT = 3,
	};
	inline specular_ramp_input_enum specular_ramp_input(void);
	inline void specular_ramp_input(specular_ramp_input_enum value);
	inline float diffuse_ramp_factor(void);
	inline void diffuse_ramp_factor(float value);
	inline float specular_ramp_factor(void);
	inline void specular_ramp_factor(float value);
	inline Array<float, 4> line_color(void);
	inline void line_color(float values[4]);
	inline int line_priority(void);
	inline void line_priority(int value);
	enum diffuse_shader_enum {
		diffuse_shader_LAMBERT = 0,
		diffuse_shader_OREN_NAYAR = 1,
		diffuse_shader_TOON = 2,
		diffuse_shader_MINNAERT = 3,
		diffuse_shader_FRESNEL = 4,
	};
	inline diffuse_shader_enum diffuse_shader(void);
	inline void diffuse_shader(diffuse_shader_enum value);
	inline float diffuse_intensity(void);
	inline void diffuse_intensity(float value);
	inline float roughness(void);
	inline void roughness(float value);
	inline float diffuse_toon_size(void);
	inline void diffuse_toon_size(float value);
	inline float diffuse_toon_smooth(void);
	inline void diffuse_toon_smooth(float value);
	inline float diffuse_fresnel(void);
	inline void diffuse_fresnel(float value);
	inline float diffuse_fresnel_factor(void);
	inline void diffuse_fresnel_factor(float value);
	inline float darkness(void);
	inline void darkness(float value);
	enum specular_shader_enum {
		specular_shader_COOKTORR = 0,
		specular_shader_PHONG = 1,
		specular_shader_BLINN = 2,
		specular_shader_TOON = 3,
		specular_shader_WARDISO = 4,
	};
	inline specular_shader_enum specular_shader(void);
	inline void specular_shader(specular_shader_enum value);
	inline float specular_intensity(void);
	inline void specular_intensity(float value);
	inline int specular_hardness(void);
	inline void specular_hardness(int value);
	inline float specular_ior(void);
	inline void specular_ior(float value);
	inline float specular_toon_size(void);
	inline void specular_toon_size(float value);
	inline float specular_toon_smooth(void);
	inline void specular_toon_smooth(float value);
	inline float specular_slope(void);
	inline void specular_slope(float value);

};

/**************** Texture Paint Slot ****************/

class TexPaintSlot : public Pointer {
public:
	TexPaintSlot(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	inline int index(void);
	inline void index(int value);

};

/**************** Material Raytrace Mirror ****************/

class MaterialRaytraceMirror : public Pointer {
public:
	MaterialRaytraceMirror(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use(void);
	inline void use(int value);
	inline float reflect_factor(void);
	inline void reflect_factor(float value);
	inline float fresnel(void);
	inline void fresnel(float value);
	inline float fresnel_factor(void);
	inline void fresnel_factor(float value);
	inline float gloss_factor(void);
	inline void gloss_factor(float value);
	inline float gloss_anisotropic(void);
	inline void gloss_anisotropic(float value);
	inline int gloss_samples(void);
	inline void gloss_samples(int value);
	inline float gloss_threshold(void);
	inline void gloss_threshold(float value);
	inline int depth(void);
	inline void depth(int value);
	inline float distance(void);
	inline void distance(float value);
	enum fade_to_enum {
		fade_to_FADE_TO_SKY = 0,
		fade_to_FADE_TO_MATERIAL = 1,
	};
	inline fade_to_enum fade_to(void);
	inline void fade_to(fade_to_enum value);

};

/**************** Material Raytrace Transparency ****************/

class MaterialRaytraceTransparency : public Pointer {
public:
	MaterialRaytraceTransparency(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float ior(void);
	inline void ior(float value);
	inline float fresnel(void);
	inline void fresnel(float value);
	inline float fresnel_factor(void);
	inline void fresnel_factor(float value);
	inline float gloss_factor(void);
	inline void gloss_factor(float value);
	inline int gloss_samples(void);
	inline void gloss_samples(int value);
	inline float gloss_threshold(void);
	inline void gloss_threshold(float value);
	inline int depth(void);
	inline void depth(int value);
	inline float filter(void);
	inline void filter(float value);
	inline float depth_max(void);
	inline void depth_max(float value);
	inline float falloff(void);
	inline void falloff(float value);

};

/**************** Material Volume ****************/

class MaterialVolume : public Pointer {
public:
	MaterialVolume(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum step_method_enum {
		step_method_RANDOMIZED = 0,
		step_method_CONSTANT = 1,
	};
	inline step_method_enum step_method(void);
	inline void step_method(step_method_enum value);
	inline float step_size(void);
	inline void step_size(float value);
	enum light_method_enum {
		light_method_SHADELESS = 0,
		light_method_SHADOWED = 2,
		light_method_SHADED = 1,
		light_method_MULTIPLE_SCATTERING = 3,
		light_method_SHADED_PLUS_MULTIPLE_SCATTERING = 4,
	};
	inline light_method_enum light_method(void);
	inline void light_method(light_method_enum value);
	inline bool use_external_shadows(void);
	inline void use_external_shadows(int value);
	inline bool use_light_cache(void);
	inline void use_light_cache(int value);
	inline int cache_resolution(void);
	inline void cache_resolution(int value);
	inline float ms_diffusion(void);
	inline void ms_diffusion(float value);
	inline float ms_spread(void);
	inline void ms_spread(float value);
	inline float ms_intensity(void);
	inline void ms_intensity(float value);
	inline float depth_threshold(void);
	inline void depth_threshold(float value);
	inline float density(void);
	inline void density(float value);
	inline float density_scale(void);
	inline void density_scale(float value);
	inline float scattering(void);
	inline void scattering(float value);
	inline Array<float, 3> transmission_color(void);
	inline void transmission_color(float values[3]);
	inline Array<float, 3> reflection_color(void);
	inline void reflection_color(float values[3]);
	inline float reflection(void);
	inline void reflection(float value);
	inline Array<float, 3> emission_color(void);
	inline void emission_color(float values[3]);
	inline float emission(void);
	inline void emission(float value);
	inline float asymmetry(void);
	inline void asymmetry(float value);

};

/**************** Material Halo ****************/

class MaterialHalo : public Pointer {
public:
	MaterialHalo(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float size(void);
	inline void size(float value);
	inline int hardness(void);
	inline void hardness(int value);
	inline float add(void);
	inline void add(float value);
	inline int ring_count(void);
	inline void ring_count(int value);
	inline int line_count(void);
	inline void line_count(int value);
	inline int star_tip_count(void);
	inline void star_tip_count(int value);
	inline int seed(void);
	inline void seed(int value);
	inline bool use_flare_mode(void);
	inline void use_flare_mode(int value);
	inline float flare_size(void);
	inline void flare_size(float value);
	inline float flare_subflare_size(void);
	inline void flare_subflare_size(float value);
	inline float flare_boost(void);
	inline void flare_boost(float value);
	inline int flare_seed(void);
	inline void flare_seed(int value);
	inline int flare_subflare_count(void);
	inline void flare_subflare_count(int value);
	inline bool use_ring(void);
	inline void use_ring(int value);
	inline bool use_lines(void);
	inline void use_lines(int value);
	inline bool use_star(void);
	inline void use_star(int value);
	inline bool use_texture(void);
	inline void use_texture(int value);
	inline bool use_vertex_normal(void);
	inline void use_vertex_normal(int value);
	inline bool use_extreme_alpha(void);
	inline void use_extreme_alpha(int value);
	inline bool use_shaded(void);
	inline void use_shaded(int value);
	inline bool use_soft(void);
	inline void use_soft(int value);

};

/**************** Material Subsurface Scattering ****************/

class MaterialSubsurfaceScattering : public Pointer {
public:
	MaterialSubsurfaceScattering(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> radius(void);
	inline void radius(float values[3]);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline float error_threshold(void);
	inline void error_threshold(float value);
	inline float scale(void);
	inline void scale(float value);
	inline float ior(void);
	inline void ior(float value);
	inline float color_factor(void);
	inline void color_factor(float value);
	inline float texture_factor(void);
	inline void texture_factor(float value);
	inline float front(void);
	inline void front(float value);
	inline float back(void);
	inline void back(float value);
	inline bool use(void);
	inline void use(int value);

};

/**************** Material Texture Slot ****************/

class MaterialTextureSlot : public TextureSlot {
public:
	MaterialTextureSlot(const PointerRNA &ptr_arg) :
		TextureSlot(ptr_arg)
		{}

	enum texture_coords_enum {
		texture_coords_GLOBAL = 8,
		texture_coords_OBJECT = 32,
		texture_coords_UV = 16,
		texture_coords_ORCO = 1,
		texture_coords_STRAND = 8192,
		texture_coords_WINDOW = 1024,
		texture_coords_NORMAL = 4,
		texture_coords_REFLECTION = 2,
		texture_coords_STRESS = 16384,
		texture_coords_TANGENT = 4096,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline Object object(void);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	inline bool use_from_dupli(void);
	inline void use_from_dupli(int value);
	inline bool use_map_to_bounds(void);
	inline void use_map_to_bounds(int value);
	inline bool use_from_original(void);
	inline void use_from_original(int value);
	inline bool use_map_color_diffuse(void);
	inline void use_map_color_diffuse(int value);
	inline bool use_map_normal(void);
	inline void use_map_normal(int value);
	inline bool use_map_color_spec(void);
	inline void use_map_color_spec(int value);
	inline bool use_map_mirror(void);
	inline void use_map_mirror(int value);
	inline bool use_map_diffuse(void);
	inline void use_map_diffuse(int value);
	inline bool use_map_specular(void);
	inline void use_map_specular(int value);
	inline bool use_map_ambient(void);
	inline void use_map_ambient(int value);
	inline bool use_map_hardness(void);
	inline void use_map_hardness(int value);
	inline bool use_map_raymir(void);
	inline void use_map_raymir(int value);
	inline bool use_map_alpha(void);
	inline void use_map_alpha(int value);
	inline bool use_map_emit(void);
	inline void use_map_emit(int value);
	inline bool use_map_translucency(void);
	inline void use_map_translucency(int value);
	inline bool use_map_displacement(void);
	inline void use_map_displacement(int value);
	inline bool use_map_warp(void);
	inline void use_map_warp(int value);
	enum mapping_x_enum {
		mapping_x_NONE = 0,
		mapping_x_X = 1,
		mapping_x_Y = 2,
		mapping_x_Z = 3,
	};
	inline mapping_x_enum mapping_x(void);
	inline void mapping_x(mapping_x_enum value);
	enum mapping_y_enum {
		mapping_y_NONE = 0,
		mapping_y_X = 1,
		mapping_y_Y = 2,
		mapping_y_Z = 3,
	};
	inline mapping_y_enum mapping_y(void);
	inline void mapping_y(mapping_y_enum value);
	enum mapping_z_enum {
		mapping_z_NONE = 0,
		mapping_z_X = 1,
		mapping_z_Y = 2,
		mapping_z_Z = 3,
	};
	inline mapping_z_enum mapping_z(void);
	inline void mapping_z(mapping_z_enum value);
	enum mapping_enum {
		mapping_FLAT = 0,
		mapping_CUBE = 1,
		mapping_TUBE = 2,
		mapping_SPHERE = 3,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	enum normal_map_space_enum {
		normal_map_space_CAMERA = 0,
		normal_map_space_WORLD = 1,
		normal_map_space_OBJECT = 2,
		normal_map_space_TANGENT = 3,
	};
	inline normal_map_space_enum normal_map_space(void);
	inline void normal_map_space(normal_map_space_enum value);
	inline float normal_factor(void);
	inline void normal_factor(float value);
	inline float displacement_factor(void);
	inline void displacement_factor(float value);
	inline float warp_factor(void);
	inline void warp_factor(float value);
	inline float specular_color_factor(void);
	inline void specular_color_factor(float value);
	inline float diffuse_color_factor(void);
	inline void diffuse_color_factor(float value);
	inline float mirror_factor(void);
	inline void mirror_factor(float value);
	inline float alpha_factor(void);
	inline void alpha_factor(float value);
	inline float diffuse_factor(void);
	inline void diffuse_factor(float value);
	inline float specular_factor(void);
	inline void specular_factor(float value);
	inline float emit_factor(void);
	inline void emit_factor(float value);
	inline float hardness_factor(void);
	inline void hardness_factor(float value);
	inline float raymir_factor(void);
	inline void raymir_factor(float value);
	inline float translucency_factor(void);
	inline void translucency_factor(float value);
	inline float ambient_factor(void);
	inline void ambient_factor(float value);
	inline bool use_map_color_emission(void);
	inline void use_map_color_emission(int value);
	inline bool use_map_color_reflection(void);
	inline void use_map_color_reflection(int value);
	inline bool use_map_color_transmission(void);
	inline void use_map_color_transmission(int value);
	inline bool use_map_density(void);
	inline void use_map_density(int value);
	inline bool use_map_emission(void);
	inline void use_map_emission(int value);
	inline bool use_map_scatter(void);
	inline void use_map_scatter(int value);
	inline bool use_map_reflect(void);
	inline void use_map_reflect(int value);
	inline float emission_color_factor(void);
	inline void emission_color_factor(float value);
	inline float reflection_color_factor(void);
	inline void reflection_color_factor(float value);
	inline float transmission_color_factor(void);
	inline void transmission_color_factor(float value);
	inline float density_factor(void);
	inline void density_factor(float value);
	inline float emission_factor(void);
	inline void emission_factor(float value);
	inline float scattering_factor(void);
	inline void scattering_factor(float value);
	inline float reflection_factor(void);
	inline void reflection_factor(float value);
	inline bool use(void);
	inline void use(int value);
	enum bump_method_enum {
		bump_method_BUMP_ORIGINAL = 0,
		bump_method_BUMP_COMPATIBLE = 128,
		bump_method_BUMP_LOW_QUALITY = 256,
		bump_method_BUMP_MEDIUM_QUALITY = 512,
		bump_method_BUMP_BEST_QUALITY = 8192,
	};
	inline bump_method_enum bump_method(void);
	inline void bump_method(bump_method_enum value);
	enum bump_objectspace_enum {
		bump_objectspace_BUMP_VIEWSPACE = 0,
		bump_objectspace_BUMP_OBJECTSPACE = 1024,
		bump_objectspace_BUMP_TEXTURESPACE = 2048,
	};
	inline bump_objectspace_enum bump_objectspace(void);
	inline void bump_objectspace(bump_objectspace_enum value);

};

/**************** Material Strand ****************/

class MaterialStrand : public Pointer {
public:
	MaterialStrand(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_tangent_shading(void);
	inline void use_tangent_shading(int value);
	inline bool use_surface_diffuse(void);
	inline void use_surface_diffuse(int value);
	inline float blend_distance(void);
	inline void blend_distance(float value);
	inline bool use_blender_units(void);
	inline void use_blender_units(int value);
	inline float root_size(void);
	inline void root_size(float value);
	inline float tip_size(void);
	inline void tip_size(float value);
	inline float size_min(void);
	inline void size_min(float value);
	inline float shape(void);
	inline void shape(float value);
	inline float width_fade(void);
	inline void width_fade(float value);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);

};

/**************** Material Physics ****************/

class MaterialPhysics : public Pointer {
public:
	MaterialPhysics(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float friction(void);
	inline void friction(float value);
	inline float elasticity(void);
	inline void elasticity(float value);
	inline bool use_fh_normal(void);
	inline void use_fh_normal(int value);
	inline float fh_force(void);
	inline void fh_force(float value);
	inline float fh_distance(void);
	inline void fh_distance(float value);
	inline float fh_damping(void);
	inline void fh_damping(float value);

};

/**************** Material Game Settings ****************/

class MaterialGameSettings : public Pointer {
public:
	MaterialGameSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_backface_culling(void);
	inline void use_backface_culling(int value);
	inline bool text(void);
	inline void text(int value);
	inline bool invisible(void);
	inline void invisible(int value);
	enum alpha_blend_enum {
		alpha_blend_OPAQUE = 0,
		alpha_blend_ADD = 1,
		alpha_blend_CLIP = 4,
		alpha_blend_ALPHA = 2,
		alpha_blend_ALPHA_SORT = 8,
	};
	inline alpha_blend_enum alpha_blend(void);
	inline void alpha_blend(alpha_blend_enum value);
	enum face_orientation_enum {
		face_orientation_NORMAL = 0,
		face_orientation_HALO = 512,
		face_orientation_BILLBOARD = 1024,
		face_orientation_SHADOW = 2048,
	};
	inline face_orientation_enum face_orientation(void);
	inline void face_orientation(face_orientation_enum value);
	inline bool physics(void);
	inline void physics(int value);

};

/**************** Mesh ****************/

class Mesh : public ID {
public:
	Mesh(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		vertices(ptr_arg),
		edges(ptr_arg),
		tessfaces(ptr_arg),
		loops(ptr_arg),
		polygons(ptr_arg),
		uv_layers(ptr_arg),
		tessface_uv_textures(ptr_arg),
		uv_textures(ptr_arg),
		tessface_vertex_colors(ptr_arg),
		vertex_colors(ptr_arg),
		polygon_layers_float(ptr_arg),
		polygon_layers_int(ptr_arg),
		polygon_layers_string(ptr_arg),
		skin_vertices(ptr_arg),
		materials(ptr_arg)
		{}

	COLLECTION_PROPERTY(MeshVertices, MeshVertex, Mesh, vertices, true, true, false)
	COLLECTION_PROPERTY(MeshEdges, MeshEdge, Mesh, edges, true, true, false)
	COLLECTION_PROPERTY(MeshTessFaces, MeshTessFace, Mesh, tessfaces, true, true, false)
	COLLECTION_PROPERTY(MeshLoops, MeshLoop, Mesh, loops, true, true, false)
	COLLECTION_PROPERTY(MeshPolygons, MeshPolygon, Mesh, polygons, true, true, false)
	inline Mesh texture_mesh(void);
	COLLECTION_PROPERTY(UVLoopLayers, MeshUVLoopLayer, Mesh, uv_layers, true, true, true)
	inline MeshUVLoopLayer uv_layer_clone(void);
	inline int uv_layer_clone_index(void);
	inline void uv_layer_clone_index(int value);
	inline MeshUVLoopLayer uv_layer_stencil(void);
	inline int uv_layer_stencil_index(void);
	inline void uv_layer_stencil_index(int value);
	COLLECTION_PROPERTY(TessfaceUVTextures, MeshTextureFaceLayer, Mesh, tessface_uv_textures, true, true, true)
	COLLECTION_PROPERTY(UVTextures, MeshTexturePolyLayer, Mesh, uv_textures, true, true, true)
	inline MeshTexturePolyLayer uv_texture_clone(void);
	inline int uv_texture_clone_index(void);
	inline void uv_texture_clone_index(int value);
	inline MeshTexturePolyLayer uv_texture_stencil(void);
	inline int uv_texture_stencil_index(void);
	inline void uv_texture_stencil_index(int value);
	COLLECTION_PROPERTY(VertexColors, MeshColorLayer, Mesh, tessface_vertex_colors, true, true, true)
	COLLECTION_PROPERTY(LoopColors, MeshLoopColorLayer, Mesh, vertex_colors, true, true, true)
	COLLECTION_PROPERTY(FloatProperties, MeshFloatPropertyLayer, Mesh, polygon_layers_float, true, true, true)
	COLLECTION_PROPERTY(IntProperties, MeshIntPropertyLayer, Mesh, polygon_layers_int, true, true, true)
	COLLECTION_PROPERTY(StringProperties, MeshStringPropertyLayer, Mesh, polygon_layers_string, true, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshSkinVertexLayer, Mesh, skin_vertices, true, true, true)
	inline bool use_auto_smooth(void);
	inline void use_auto_smooth(int value);
	inline float auto_smooth_angle(void);
	inline void auto_smooth_angle(float value);
	inline bool show_double_sided(void);
	inline void show_double_sided(int value);
	inline Mesh texco_mesh(void);
	inline Key shape_keys(void);
	inline bool use_auto_texspace(void);
	inline void use_auto_texspace(int value);
	inline bool show_edges(void);
	inline void show_edges(int value);
	inline bool show_faces(void);
	inline void show_faces(int value);
	inline bool show_normal_face(void);
	inline void show_normal_face(int value);
	inline bool show_normal_loop(void);
	inline void show_normal_loop(int value);
	inline bool show_normal_vertex(void);
	inline void show_normal_vertex(int value);
	inline bool show_weight(void);
	inline void show_weight(int value);
	inline bool show_edge_crease(void);
	inline void show_edge_crease(int value);
	inline bool show_edge_bevel_weight(void);
	inline void show_edge_bevel_weight(int value);
	inline bool show_edge_seams(void);
	inline void show_edge_seams(int value);
	inline bool show_edge_sharp(void);
	inline void show_edge_sharp(int value);
	inline bool show_freestyle_edge_marks(void);
	inline void show_freestyle_edge_marks(int value);
	inline bool show_freestyle_face_marks(void);
	inline void show_freestyle_face_marks(int value);
	inline bool show_statvis(void);
	inline void show_statvis(int value);
	inline bool show_extra_edge_length(void);
	inline void show_extra_edge_length(int value);
	inline bool show_extra_edge_angle(void);
	inline void show_extra_edge_angle(int value);
	inline bool show_extra_face_angle(void);
	inline void show_extra_face_angle(int value);
	inline bool show_extra_face_area(void);
	inline void show_extra_face_area(int value);
	inline bool show_extra_indices(void);
	inline void show_extra_indices(int value);
	inline bool use_mirror_x(void);
	inline void use_mirror_x(int value);
	inline bool use_mirror_topology(void);
	inline void use_mirror_topology(int value);
	inline bool use_paint_mask(void);
	inline void use_paint_mask(int value);
	inline bool use_paint_mask_vertex(void);
	inline void use_paint_mask_vertex(int value);
	inline bool use_customdata_vertex_bevel(void);
	inline void use_customdata_vertex_bevel(int value);
	inline bool use_customdata_edge_bevel(void);
	inline void use_customdata_edge_bevel(int value);
	inline bool use_customdata_edge_crease(void);
	inline void use_customdata_edge_crease(int value);
	inline int total_vert_sel(void);
	inline void total_vert_sel(int value);
	inline int total_edge_sel(void);
	inline void total_edge_sel(int value);
	inline int total_face_sel(void);
	inline void total_face_sel(int value);
	inline bool is_editmode(void);
	inline void is_editmode(int value);
	inline AnimData animation_data(void);
	inline bool auto_texspace(void);
	inline void auto_texspace(int value);
	inline Array<float, 3> texspace_location(void);
	inline void texspace_location(float values[3]);
	inline Array<float, 3> texspace_size(void);
	inline void texspace_size(float values[3]);
	COLLECTION_PROPERTY(IDMaterials, Material, Mesh, materials, true, true, true)

	inline void transform(float matrix[16], int shape_keys);
	inline void calc_normals();
	inline void calc_normals_split(float split_angle);
	inline void free_normals_split();
	inline void calc_tangents(const char * uvmap);
	inline void free_tangents();
	inline void calc_tessface();
	inline void calc_smooth_groups(int use_bitflags, int *poly_groups_len, int **poly_groups, int *groups);
	inline void update(Context C, int calc_edges, int calc_tessface);
	inline const char * unit_test_compare(Mesh mesh);
	inline int validate(int verbose);
	inline int validate_material_indices();
};

/**************** Mesh Skin Vertex Layer ****************/

class MeshSkinVertexLayer : public Pointer {
public:
	MeshSkinVertexLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshSkinVertex, MeshSkinVertexLayer, data, true, true, false)

};

/**************** Skin Vertex ****************/

class MeshSkinVertex : public Pointer {
public:
	MeshSkinVertex(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 2> radius(void);
	inline void radius(float values[2]);
	inline bool use_root(void);
	inline void use_root(int value);
	inline bool use_loose(void);
	inline void use_loose(int value);

};

/**************** Mesh Vertex ****************/

class MeshVertex : public Pointer {
public:
	MeshVertex(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		groups(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline bool select(void);
	inline void select(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline float bevel_weight(void);
	inline void bevel_weight(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, VertexGroupElement, MeshVertex, groups, false, false, false)
	inline int index(void);
	inline void index(int value);
	inline Array<float, 3> undeformed_co(void);
	inline void undeformed_co(float values[3]);

};

/**************** Vertex Group Element ****************/

class VertexGroupElement : public Pointer {
public:
	VertexGroupElement(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int group(void);
	inline void group(int value);
	inline float weight(void);
	inline void weight(float value);

};

/**************** Mesh Edge ****************/

class MeshEdge : public Pointer {
public:
	MeshEdge(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<int, 2> vertices(void);
	inline void vertices(int values[2]);
	inline float crease(void);
	inline void crease(float value);
	inline float bevel_weight(void);
	inline void bevel_weight(float value);
	inline bool select(void);
	inline void select(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline bool use_seam(void);
	inline void use_seam(int value);
	inline bool use_edge_sharp(void);
	inline void use_edge_sharp(int value);
	inline bool is_loose(void);
	inline void is_loose(int value);
	inline bool use_freestyle_mark(void);
	inline void use_freestyle_mark(int value);
	inline int index(void);
	inline void index(int value);

};

/**************** Mesh TessFace ****************/

class MeshTessFace : public Pointer {
public:
	MeshTessFace(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<int, 4> vertices(void);
	inline void vertices(int values[4]);
	inline Array<int, 4> vertices_raw(void);
	inline void vertices_raw(int values[4]);
	inline int material_index(void);
	inline void material_index(int value);
	inline bool select(void);
	inline void select(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline bool use_smooth(void);
	inline void use_smooth(int value);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline Array<float, 12> split_normals(void);
	inline void split_normals(float values[12]);
	inline float area(void);
	inline void area(float value);
	inline int index(void);
	inline void index(int value);

};

/**************** Mesh Loop ****************/

class MeshLoop : public Pointer {
public:
	MeshLoop(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int vertex_index(void);
	inline void vertex_index(int value);
	inline int edge_index(void);
	inline void edge_index(int value);
	inline int index(void);
	inline void index(int value);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline Array<float, 3> tangent(void);
	inline void tangent(float values[3]);
	inline float bitangent_sign(void);
	inline void bitangent_sign(float value);
	inline Array<float, 3> bitangent(void);
	inline void bitangent(float values[3]);

};

/**************** Mesh Polygon ****************/

class MeshPolygon : public Pointer {
public:
	MeshPolygon(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<int, 3> vertices(void);
	inline void vertices(int values[3]);
	inline int loop_start(void);
	inline void loop_start(int value);
	inline int loop_total(void);
	inline void loop_total(int value);
	inline int material_index(void);
	inline void material_index(int value);
	inline bool select(void);
	inline void select(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline bool use_smooth(void);
	inline void use_smooth(int value);
	inline bool use_freestyle_mark(void);
	inline void use_freestyle_mark(int value);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline Array<float, 3> center(void);
	inline void center(float values[3]);
	inline float area(void);
	inline void area(float value);
	inline int index(void);
	inline void index(int value);

};

/**************** MeshUVLoopLayer ****************/

class MeshUVLoopLayer : public Pointer {
public:
	MeshUVLoopLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshUVLoop, MeshUVLoopLayer, data, true, true, false)
	inline std::string name(void);	inline void name(const std::string& value);

};

/**************** MeshUVLoop ****************/

class MeshUVLoop : public Pointer {
public:
	MeshUVLoop(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 2> uv(void);
	inline void uv(float values[2]);
	inline bool pin_uv(void);
	inline void pin_uv(int value);
	inline bool select(void);
	inline void select(int value);
	inline bool select_edge(void);
	inline void select_edge(int value);

};

/**************** Mesh UV Map ****************/

class MeshTextureFaceLayer : public Pointer {
public:
	MeshTextureFaceLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool active(void);
	inline void active(int value);
	inline bool active_render(void);
	inline void active_render(int value);
	inline bool active_clone(void);
	inline void active_clone(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshTextureFace, MeshTextureFaceLayer, data, true, true, false)

};

/**************** Mesh UV Map Face ****************/

class MeshTextureFace : public Pointer {
public:
	MeshTextureFace(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Image image(void);
	inline Array<float, 2> uv1(void);
	inline void uv1(float values[2]);
	inline Array<float, 2> uv2(void);
	inline void uv2(float values[2]);
	inline Array<float, 2> uv3(void);
	inline void uv3(float values[2]);
	inline Array<float, 2> uv4(void);
	inline void uv4(float values[2]);
	inline Array<float, 8> uv(void);
	inline void uv(float values[8]);
	inline Array<float, 8> uv_raw(void);
	inline void uv_raw(float values[8]);

};

/**************** Mesh UV Map ****************/

class MeshTexturePolyLayer : public Pointer {
public:
	MeshTexturePolyLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool active(void);
	inline void active(int value);
	inline bool active_render(void);
	inline void active_render(int value);
	inline bool active_clone(void);
	inline void active_clone(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshTexturePoly, MeshTexturePolyLayer, data, true, true, false)

};

/**************** Mesh UV Map Face ****************/

class MeshTexturePoly : public Pointer {
public:
	MeshTexturePoly(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Image image(void);

};

/**************** Mesh Vertex Color Layer ****************/

class MeshColorLayer : public Pointer {
public:
	MeshColorLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool active(void);
	inline void active(int value);
	inline bool active_render(void);
	inline void active_render(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshColor, MeshColorLayer, data, true, true, false)

};

/**************** Mesh Vertex Color ****************/

class MeshColor : public Pointer {
public:
	MeshColor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> color1(void);
	inline void color1(float values[3]);
	inline Array<float, 3> color2(void);
	inline void color2(float values[3]);
	inline Array<float, 3> color3(void);
	inline void color3(float values[3]);
	inline Array<float, 3> color4(void);
	inline void color4(float values[3]);

};

/**************** Mesh Vertex Color Layer ****************/

class MeshLoopColorLayer : public Pointer {
public:
	MeshLoopColorLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool active(void);
	inline void active(int value);
	inline bool active_render(void);
	inline void active_render(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshLoopColor, MeshLoopColorLayer, data, true, true, false)

};

/**************** Mesh Vertex Color ****************/

class MeshLoopColor : public Pointer {
public:
	MeshLoopColor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);

};

/**************** Mesh Float Property Layer ****************/

class MeshFloatPropertyLayer : public Pointer {
public:
	MeshFloatPropertyLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshFloatProperty, MeshFloatPropertyLayer, data, true, true, false)

};

/**************** Mesh Float Property ****************/

class MeshFloatProperty : public Pointer {
public:
	MeshFloatProperty(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float value(void);
	inline void value(float value);

};

/**************** Mesh Int Property Layer ****************/

class MeshIntPropertyLayer : public Pointer {
public:
	MeshIntPropertyLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshIntProperty, MeshIntPropertyLayer, data, true, true, false)

};

/**************** Mesh Int Property ****************/

class MeshIntProperty : public Pointer {
public:
	MeshIntProperty(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int value(void);
	inline void value(int value);

};

/**************** Mesh String Property Layer ****************/

class MeshStringPropertyLayer : public Pointer {
public:
	MeshStringPropertyLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshStringProperty, MeshStringPropertyLayer, data, true, true, false)

};

/**************** Mesh String Property ****************/

class MeshStringProperty : public Pointer {
public:
	MeshStringProperty(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string value(void);	inline void value(const std::string& value);

};

/**************** Meta Element ****************/

class MetaElement : public Pointer {
public:
	MetaElement(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_BALL = 0,
		type_CAPSULE = 4,
		type_PLANE = 5,
		type_ELLIPSOID = 6,
		type_CUBE = 7,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 4> rotation(void);
	inline void rotation(float values[4]);
	inline float radius(void);
	inline void radius(float value);
	inline float size_x(void);
	inline void size_x(float value);
	inline float size_y(void);
	inline void size_y(float value);
	inline float size_z(void);
	inline void size_z(float value);
	inline float stiffness(void);
	inline void stiffness(float value);
	inline bool use_negative(void);
	inline void use_negative(int value);
	inline bool hide(void);
	inline void hide(int value);

};

/**************** MetaBall ****************/

class MetaBall : public ID {
public:
	MetaBall(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		elements(ptr_arg),
		materials(ptr_arg)
		{}

	COLLECTION_PROPERTY(MetaBallElements, MetaElement, MetaBall, elements, false, true, false)
	enum update_method_enum {
		update_method_UPDATE_ALWAYS = 0,
		update_method_HALFRES = 1,
		update_method_FAST = 2,
		update_method_NEVER = 3,
	};
	inline update_method_enum update_method(void);
	inline void update_method(update_method_enum value);
	inline float resolution(void);
	inline void resolution(float value);
	inline float render_resolution(void);
	inline void render_resolution(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline bool use_auto_texspace(void);
	inline void use_auto_texspace(int value);
	inline Array<float, 3> texspace_location(void);
	inline void texspace_location(float values[3]);
	inline Array<float, 3> texspace_size(void);
	inline void texspace_size(float values[3]);
	COLLECTION_PROPERTY(IDMaterials, Material, MetaBall, materials, true, true, true)
	inline bool is_editmode(void);
	inline void is_editmode(int value);
	inline AnimData animation_data(void);

	inline void transform(float matrix[16]);
};

/**************** Modifier ****************/

class Modifier : public Pointer {
public:
	Modifier(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_MESH_CACHE = 46,
		type_UV_PROJECT = 15,
		type_UV_WARP = 45,
		type_VERTEX_WEIGHT_EDIT = 36,
		type_VERTEX_WEIGHT_MIX = 37,
		type_VERTEX_WEIGHT_PROXIMITY = 38,
		type_ARRAY = 12,
		type_BEVEL = 24,
		type_BOOLEAN = 11,
		type_BUILD = 4,
		type_DECIMATE = 6,
		type_EDGE_SPLIT = 13,
		type_MASK = 27,
		type_MIRROR = 5,
		type_MULTIRES = 29,
		type_REMESH = 41,
		type_SCREW = 34,
		type_SKIN = 42,
		type_SOLIDIFY = 33,
		type_SUBSURF = 1,
		type_TRIANGULATE = 44,
		type_WIREFRAME = 48,
		type_ARMATURE = 8,
		type_CAST = 17,
		type_CURVE = 3,
		type_DISPLACE = 14,
		type_HOOK = 9,
		type_LAPLACIANSMOOTH = 43,
		type_LAPLACIANDEFORM = 47,
		type_LATTICE = 2,
		type_MESH_DEFORM = 18,
		type_SHRINKWRAP = 25,
		type_SIMPLE_DEFORM = 28,
		type_SMOOTH = 16,
		type_WARP = 35,
		type_WAVE = 7,
		type_CLOTH = 22,
		type_COLLISION = 23,
		type_DYNAMIC_PAINT = 40,
		type_EXPLODE = 21,
		type_FLUID_SIMULATION = 26,
		type_OCEAN = 39,
		type_PARTICLE_INSTANCE = 20,
		type_PARTICLE_SYSTEM = 19,
		type_SMOKE = 31,
		type_SOFT_BODY = 10,
		type_SURFACE = 30,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool show_viewport(void);
	inline void show_viewport(int value);
	inline bool show_render(void);
	inline void show_render(int value);
	inline bool show_in_editmode(void);
	inline void show_in_editmode(int value);
	inline bool show_on_cage(void);
	inline void show_on_cage(int value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	inline bool use_apply_on_spline(void);
	inline void use_apply_on_spline(int value);

};

/**************** Subsurf Modifier ****************/

class SubsurfModifier : public Modifier {
public:
	SubsurfModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum subdivision_type_enum {
		subdivision_type_CATMULL_CLARK = 0,
		subdivision_type_SIMPLE = 1,
	};
	inline subdivision_type_enum subdivision_type(void);
	inline void subdivision_type(subdivision_type_enum value);
	inline int levels(void);
	inline void levels(int value);
	inline int render_levels(void);
	inline void render_levels(int value);
	inline bool show_only_control_edges(void);
	inline void show_only_control_edges(int value);
	inline bool use_subsurf_uv(void);
	inline void use_subsurf_uv(int value);

};

/**************** Lattice Modifier ****************/

class LatticeModifier : public Modifier {
public:
	LatticeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline float strength(void);
	inline void strength(float value);

};

/**************** Curve Modifier ****************/

class CurveModifier : public Modifier {
public:
	CurveModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	enum deform_axis_enum {
		deform_axis_POS_X = 1,
		deform_axis_POS_Y = 2,
		deform_axis_POS_Z = 3,
		deform_axis_NEG_X = 4,
		deform_axis_NEG_Y = 5,
		deform_axis_NEG_Z = 6,
	};
	inline deform_axis_enum deform_axis(void);
	inline void deform_axis(deform_axis_enum value);

};

/**************** Build Modifier ****************/

class BuildModifier : public Modifier {
public:
	BuildModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_duration(void);
	inline void frame_duration(float value);
	inline bool use_reverse(void);
	inline void use_reverse(int value);
	inline bool use_random_order(void);
	inline void use_random_order(int value);
	inline int seed(void);
	inline void seed(int value);

};

/**************** Mirror Modifier ****************/

class MirrorModifier : public Modifier {
public:
	MirrorModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline bool use_x(void);
	inline void use_x(int value);
	inline bool use_y(void);
	inline void use_y(int value);
	inline bool use_z(void);
	inline void use_z(int value);
	inline bool use_clip(void);
	inline void use_clip(int value);
	inline bool use_mirror_vertex_groups(void);
	inline void use_mirror_vertex_groups(int value);
	inline bool use_mirror_merge(void);
	inline void use_mirror_merge(int value);
	inline bool use_mirror_u(void);
	inline void use_mirror_u(int value);
	inline bool use_mirror_v(void);
	inline void use_mirror_v(int value);
	inline float merge_threshold(void);
	inline void merge_threshold(float value);
	inline Object mirror_object(void);

};

/**************** Decimate Modifier ****************/

class DecimateModifier : public Modifier {
public:
	DecimateModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum decimate_type_enum {
		decimate_type_COLLAPSE = 0,
		decimate_type_UNSUBDIV = 1,
		decimate_type_DISSOLVE = 2,
	};
	inline decimate_type_enum decimate_type(void);
	inline void decimate_type(decimate_type_enum value);
	inline float ratio(void);
	inline void ratio(float value);
	inline int iterations(void);
	inline void iterations(int value);
	inline float angle_limit(void);
	inline void angle_limit(float value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(int value);
	inline bool use_collapse_triangulate(void);
	inline void use_collapse_triangulate(int value);
	inline bool use_dissolve_boundaries(void);
	inline void use_dissolve_boundaries(int value);
	enum delimit_enum {
		delimit_NORMAL = 1,
		delimit_MATERIAL = 2,
		delimit_SEAM = 4,
	};
	inline delimit_enum delimit(void);
	inline void delimit(delimit_enum value);
	inline int face_count(void);
	inline void face_count(int value);

};

/**************** Wave Modifier ****************/

class WaveModifier : public Modifier {
public:
	WaveModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline bool use_x(void);
	inline void use_x(int value);
	inline bool use_y(void);
	inline void use_y(int value);
	inline bool use_cyclic(void);
	inline void use_cyclic(int value);
	inline bool use_normal(void);
	inline void use_normal(int value);
	inline bool use_normal_x(void);
	inline void use_normal_x(int value);
	inline bool use_normal_y(void);
	inline void use_normal_y(int value);
	inline bool use_normal_z(void);
	inline void use_normal_z(int value);
	inline float time_offset(void);
	inline void time_offset(float value);
	inline float lifetime(void);
	inline void lifetime(float value);
	inline float damping_time(void);
	inline void damping_time(float value);
	inline float falloff_radius(void);
	inline void falloff_radius(float value);
	inline float start_position_x(void);
	inline void start_position_x(float value);
	inline float start_position_y(void);
	inline void start_position_y(float value);
	inline Object start_position_object(void);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline float speed(void);
	inline void speed(float value);
	inline float height(void);
	inline void height(float value);
	inline float width(void);
	inline void width(float value);
	inline float narrowness(void);
	inline void narrowness(float value);
	inline Texture texture(void);
	enum texture_coords_enum {
		texture_coords_LOCAL = 0,
		texture_coords_GLOBAL = 1,
		texture_coords_OBJECT = 2,
		texture_coords_UV = 3,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	inline Object texture_coords_object(void);

};

/**************** Armature Modifier ****************/

class ArmatureModifier : public Modifier {
public:
	ArmatureModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline bool use_bone_envelopes(void);
	inline void use_bone_envelopes(int value);
	inline bool use_vertex_groups(void);
	inline void use_vertex_groups(int value);
	inline bool use_deform_preserve_volume(void);
	inline void use_deform_preserve_volume(int value);
	inline bool use_multi_modifier(void);
	inline void use_multi_modifier(int value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(int value);

};

/**************** Hook Modifier ****************/

class HookModifier : public Modifier {
public:
	HookModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float falloff(void);
	inline void falloff(float value);
	inline float force(void);
	inline void force(float value);
	inline Array<float, 3> center(void);
	inline void center(float values[3]);
	inline Object object(void);
	inline std::string subtarget(void);	inline void subtarget(const std::string& value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);

};

/**************** Soft Body Modifier ****************/

class SoftBodyModifier : public Modifier {
public:
	SoftBodyModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline SoftBodySettings settings(void);
	inline PointCache point_cache(void);

};

/**************** Boolean Modifier ****************/

class BooleanModifier : public Modifier {
public:
	BooleanModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	enum operation_enum {
		operation_INTERSECT = 0,
		operation_UNION = 1,
		operation_DIFFERENCE = 2,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);

};

/**************** Array Modifier ****************/

class ArrayModifier : public Modifier {
public:
	ArrayModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum fit_type_enum {
		fit_type_FIXED_COUNT = 0,
		fit_type_FIT_LENGTH = 1,
		fit_type_FIT_CURVE = 2,
	};
	inline fit_type_enum fit_type(void);
	inline void fit_type(fit_type_enum value);
	inline int count(void);
	inline void count(int value);
	inline float fit_length(void);
	inline void fit_length(float value);
	inline Object curve(void);
	inline bool use_constant_offset(void);
	inline void use_constant_offset(int value);
	inline Array<float, 3> constant_offset_displace(void);
	inline void constant_offset_displace(float values[3]);
	inline bool use_relative_offset(void);
	inline void use_relative_offset(int value);
	inline Array<float, 3> relative_offset_displace(void);
	inline void relative_offset_displace(float values[3]);
	inline bool use_merge_vertices(void);
	inline void use_merge_vertices(int value);
	inline bool use_merge_vertices_cap(void);
	inline void use_merge_vertices_cap(int value);
	inline float merge_threshold(void);
	inline void merge_threshold(float value);
	inline bool use_object_offset(void);
	inline void use_object_offset(int value);
	inline Object offset_object(void);
	inline Object start_cap(void);
	inline Object end_cap(void);

};

/**************** EdgeSplit Modifier ****************/

class EdgeSplitModifier : public Modifier {
public:
	EdgeSplitModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float split_angle(void);
	inline void split_angle(float value);
	inline bool use_edge_angle(void);
	inline void use_edge_angle(int value);
	inline bool use_edge_sharp(void);
	inline void use_edge_sharp(int value);

};

/**************** Displace Modifier ****************/

class DisplaceModifier : public Modifier {
public:
	DisplaceModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline float mid_level(void);
	inline void mid_level(float value);
	inline float strength(void);
	inline void strength(float value);
	enum direction_enum {
		direction_X = 0,
		direction_Y = 1,
		direction_Z = 2,
		direction_NORMAL = 3,
		direction_RGB_TO_XYZ = 4,
	};
	inline direction_enum direction(void);
	inline void direction(direction_enum value);
	inline Texture texture(void);
	enum texture_coords_enum {
		texture_coords_LOCAL = 0,
		texture_coords_GLOBAL = 1,
		texture_coords_OBJECT = 2,
		texture_coords_UV = 3,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	inline Object texture_coords_object(void);

};

/**************** UV Project Modifier ****************/

class UVProjectModifier : public Modifier {
public:
	UVProjectModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg),
		projectors(ptr_arg)
		{}

	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	inline int projector_count(void);
	inline void projector_count(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, UVProjector, UVProjectModifier, projectors, false, true, false)
	inline Image image(void);
	inline float aspect_x(void);
	inline void aspect_x(float value);
	inline float aspect_y(void);
	inline void aspect_y(float value);
	inline float scale_x(void);
	inline void scale_x(float value);
	inline float scale_y(void);
	inline void scale_y(float value);
	inline bool use_image_override(void);
	inline void use_image_override(int value);

};

/**************** UVProjector ****************/

class UVProjector : public Pointer {
public:
	UVProjector(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object object(void);

};

/**************** Smooth Modifier ****************/

class SmoothModifier : public Modifier {
public:
	SmoothModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline bool use_x(void);
	inline void use_x(int value);
	inline bool use_y(void);
	inline void use_y(int value);
	inline bool use_z(void);
	inline void use_z(int value);
	inline float factor(void);
	inline void factor(float value);
	inline int iterations(void);
	inline void iterations(int value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);

};

/**************** Cast Modifier ****************/

class CastModifier : public Modifier {
public:
	CastModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum cast_type_enum {
		cast_type_SPHERE = 0,
		cast_type_CYLINDER = 1,
		cast_type_CUBOID = 2,
	};
	inline cast_type_enum cast_type(void);
	inline void cast_type(cast_type_enum value);
	inline Object object(void);
	inline bool use_x(void);
	inline void use_x(int value);
	inline bool use_y(void);
	inline void use_y(int value);
	inline bool use_z(void);
	inline void use_z(int value);
	inline bool use_radius_as_size(void);
	inline void use_radius_as_size(int value);
	inline bool use_transform(void);
	inline void use_transform(int value);
	inline float factor(void);
	inline void factor(float value);
	inline float radius(void);
	inline void radius(float value);
	inline float size(void);
	inline void size(float value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);

};

/**************** MeshDeform Modifier ****************/

class MeshDeformModifier : public Modifier {
public:
	MeshDeformModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline bool is_bound(void);
	inline void is_bound(int value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(int value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline int precision(void);
	inline void precision(int value);
	inline bool use_dynamic_bind(void);
	inline void use_dynamic_bind(int value);

};

/**************** ParticleSystem Modifier ****************/

class ParticleSystemModifier : public Modifier {
public:
	ParticleSystemModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline ParticleSystem particle_system(void);

};

/**************** ParticleInstance Modifier ****************/

class ParticleInstanceModifier : public Modifier {
public:
	ParticleInstanceModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline int particle_system_index(void);
	inline void particle_system_index(int value);
	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
		axis_Z = 2,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	inline bool use_normal(void);
	inline void use_normal(int value);
	inline bool use_children(void);
	inline void use_children(int value);
	inline bool use_path(void);
	inline void use_path(int value);
	inline bool show_unborn(void);
	inline void show_unborn(int value);
	inline bool show_alive(void);
	inline void show_alive(int value);
	inline bool show_dead(void);
	inline void show_dead(int value);
	inline bool use_preserve_shape(void);
	inline void use_preserve_shape(int value);
	inline bool use_size(void);
	inline void use_size(int value);
	inline float position(void);
	inline void position(float value);
	inline float random_position(void);
	inline void random_position(float value);

};

/**************** Explode Modifier ****************/

class ExplodeModifier : public Modifier {
public:
	ExplodeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline float protect(void);
	inline void protect(float value);
	inline bool use_edge_cut(void);
	inline void use_edge_cut(int value);
	inline bool show_unborn(void);
	inline void show_unborn(int value);
	inline bool show_alive(void);
	inline void show_alive(int value);
	inline bool show_dead(void);
	inline void show_dead(int value);
	inline bool use_size(void);
	inline void use_size(int value);
	inline std::string particle_uv(void);	inline void particle_uv(const std::string& value);

};

/**************** Cloth Modifier ****************/

class ClothModifier : public Modifier {
public:
	ClothModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline ClothSettings settings(void);
	inline ClothCollisionSettings collision_settings(void);
	inline PointCache point_cache(void);

};

/**************** Collision Modifier ****************/

class CollisionModifier : public Modifier {
public:
	CollisionModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline CollisionSettings settings(void);

};

/**************** Bevel Modifier ****************/

class BevelModifier : public Modifier {
public:
	BevelModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float width(void);
	inline void width(float value);
	inline int segments(void);
	inline void segments(int value);
	inline bool use_only_vertices(void);
	inline void use_only_vertices(int value);
	enum limit_method_enum {
		limit_method_NONE = 0,
		limit_method_ANGLE = 8,
		limit_method_WEIGHT = 16,
		limit_method_VGROUP = 32,
	};
	inline limit_method_enum limit_method(void);
	inline void limit_method(limit_method_enum value);
	enum edge_weight_method_enum {
		edge_weight_method_AVERAGE = 0,
		edge_weight_method_SHARPEST = 128,
		edge_weight_method_LARGEST = 256,
	};
	inline edge_weight_method_enum edge_weight_method(void);
	inline void edge_weight_method(edge_weight_method_enum value);
	inline float angle_limit(void);
	inline void angle_limit(float value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline bool use_clamp_overlap(void);
	inline void use_clamp_overlap(int value);
	enum offset_type_enum {
		offset_type_OFFSET = 0,
		offset_type_WIDTH = 1,
		offset_type_DEPTH = 2,
		offset_type_PERCENT = 3,
	};
	inline offset_type_enum offset_type(void);
	inline void offset_type(offset_type_enum value);
	inline float profile(void);
	inline void profile(float value);
	inline int material(void);
	inline void material(int value);

};

/**************** Shrinkwrap Modifier ****************/

class ShrinkwrapModifier : public Modifier {
public:
	ShrinkwrapModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum wrap_method_enum {
		wrap_method_NEAREST_SURFACEPOINT = 0,
		wrap_method_PROJECT = 1,
		wrap_method_NEAREST_VERTEX = 2,
	};
	inline wrap_method_enum wrap_method(void);
	inline void wrap_method(wrap_method_enum value);
	enum cull_face_enum {
		cull_face_OFF = 0,
		cull_face_FRONT = 8,
		cull_face_BACK = 16,
	};
	inline cull_face_enum cull_face(void);
	inline void cull_face(cull_face_enum value);
	inline Object target(void);
	inline Object auxiliary_target(void);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline float offset(void);
	inline void offset(float value);
	inline float project_limit(void);
	inline void project_limit(float value);
	inline bool use_project_x(void);
	inline void use_project_x(int value);
	inline bool use_project_y(void);
	inline void use_project_y(int value);
	inline bool use_project_z(void);
	inline void use_project_z(int value);
	inline int subsurf_levels(void);
	inline void subsurf_levels(int value);
	inline bool use_negative_direction(void);
	inline void use_negative_direction(int value);
	inline bool use_positive_direction(void);
	inline void use_positive_direction(int value);
	inline bool use_keep_above_surface(void);
	inline void use_keep_above_surface(int value);

};

/**************** Fluid Simulation Modifier ****************/

class FluidSimulationModifier : public Modifier {
public:
	FluidSimulationModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline FluidSettings settings(void);

};

/**************** Mask Modifier ****************/

class MaskModifier : public Modifier {
public:
	MaskModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum mode_enum {
		mode_VERTEX_GROUP = 0,
		mode_ARMATURE = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Object armature(void);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(int value);

};

/**************** SimpleDeform Modifier ****************/

class SimpleDeformModifier : public Modifier {
public:
	SimpleDeformModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum deform_method_enum {
		deform_method_TWIST = 1,
		deform_method_BEND = 2,
		deform_method_TAPER = 3,
		deform_method_STRETCH = 4,
	};
	inline deform_method_enum deform_method(void);
	inline void deform_method(deform_method_enum value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline Object origin(void);
	inline float factor(void);
	inline void factor(float value);
	inline float angle(void);
	inline void angle(float value);
	inline Array<float, 2> limits(void);
	inline void limits(float values[2]);
	inline bool lock_x(void);
	inline void lock_x(int value);
	inline bool lock_y(void);
	inline void lock_y(int value);

};

/**************** Warp Modifier ****************/

class WarpModifier : public Modifier {
public:
	WarpModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object_from(void);
	inline Object object_to(void);
	inline float strength(void);
	inline void strength(float value);
	enum falloff_type_enum {
		falloff_type_NONE = 0,
		falloff_type_CURVE = 1,
		falloff_type_SMOOTH = 3,
		falloff_type_SPHERE = 7,
		falloff_type_ROOT = 4,
		falloff_type_SHARP = 2,
		falloff_type_LINEAR = 5,
		falloff_type_CONSTANT = 6,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline float falloff_radius(void);
	inline void falloff_radius(float value);
	inline CurveMapping falloff_curve(void);
	inline bool use_volume_preserve(void);
	inline void use_volume_preserve(int value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline Texture texture(void);
	enum texture_coords_enum {
		texture_coords_LOCAL = 0,
		texture_coords_GLOBAL = 1,
		texture_coords_OBJECT = 2,
		texture_coords_UV = 3,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	inline Object texture_coords_object(void);

};

/**************** Multires Modifier ****************/

class MultiresModifier : public Modifier {
public:
	MultiresModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum subdivision_type_enum {
		subdivision_type_CATMULL_CLARK = 0,
		subdivision_type_SIMPLE = 1,
	};
	inline subdivision_type_enum subdivision_type(void);
	inline void subdivision_type(subdivision_type_enum value);
	inline int levels(void);
	inline void levels(int value);
	inline int sculpt_levels(void);
	inline void sculpt_levels(int value);
	inline int render_levels(void);
	inline void render_levels(int value);
	inline int total_levels(void);
	inline void total_levels(int value);
	inline bool is_external(void);
	inline void is_external(int value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline bool show_only_control_edges(void);
	inline void show_only_control_edges(int value);
	inline bool use_subsurf_uv(void);
	inline void use_subsurf_uv(int value);

};

/**************** Surface Modifier ****************/

class SurfaceModifier : public Modifier {
public:
	SurfaceModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}


};

/**************** Smoke Modifier ****************/

class SmokeModifier : public Modifier {
public:
	SmokeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline SmokeDomainSettings domain_settings(void);
	inline SmokeFlowSettings flow_settings(void);
	inline SmokeCollSettings coll_settings(void);
	enum smoke_type_enum {
		smoke_type_NONE = 0,
		smoke_type_DOMAIN = 1,
		smoke_type_FLOW = 2,
		smoke_type_COLLISION = 4,
	};
	inline smoke_type_enum smoke_type(void);
	inline void smoke_type(smoke_type_enum value);

};

/**************** Solidify Modifier ****************/

class SolidifyModifier : public Modifier {
public:
	SolidifyModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float thickness(void);
	inline void thickness(float value);
	inline float thickness_clamp(void);
	inline void thickness_clamp(float value);
	inline float thickness_vertex_group(void);
	inline void thickness_vertex_group(float value);
	inline float offset(void);
	inline void offset(float value);
	inline float edge_crease_inner(void);
	inline void edge_crease_inner(float value);
	inline float edge_crease_outer(void);
	inline void edge_crease_outer(float value);
	inline float edge_crease_rim(void);
	inline void edge_crease_rim(float value);
	inline int material_offset(void);
	inline void material_offset(int value);
	inline int material_offset_rim(void);
	inline void material_offset_rim(int value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline bool use_rim(void);
	inline void use_rim(int value);
	inline bool use_even_offset(void);
	inline void use_even_offset(int value);
	inline bool use_quality_normals(void);
	inline void use_quality_normals(int value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(int value);
	inline bool use_flip_normals(void);
	inline void use_flip_normals(int value);
	inline bool use_rim_only(void);
	inline void use_rim_only(int value);

};

/**************** Screw Modifier ****************/

class ScrewModifier : public Modifier {
public:
	ScrewModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline int steps(void);
	inline void steps(int value);
	inline int render_steps(void);
	inline void render_steps(int value);
	inline int iterations(void);
	inline void iterations(int value);
	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
		axis_Z = 2,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	inline float angle(void);
	inline void angle(float value);
	inline float screw_offset(void);
	inline void screw_offset(float value);
	inline bool use_normal_flip(void);
	inline void use_normal_flip(int value);
	inline bool use_normal_calculate(void);
	inline void use_normal_calculate(int value);
	inline bool use_object_screw_offset(void);
	inline void use_object_screw_offset(int value);
	inline bool use_smooth_shade(void);
	inline void use_smooth_shade(int value);
	inline bool use_stretch_u(void);
	inline void use_stretch_u(int value);
	inline bool use_stretch_v(void);
	inline void use_stretch_v(int value);

};

/**************** UVWarp Modifier ****************/

class UVWarpModifier : public Modifier {
public:
	UVWarpModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum axis_u_enum {
		axis_u_X = 0,
		axis_u_Y = 1,
		axis_u_Z = 2,
	};
	inline axis_u_enum axis_u(void);
	inline void axis_u(axis_u_enum value);
	enum axis_v_enum {
		axis_v_X = 0,
		axis_v_Y = 1,
		axis_v_Z = 2,
	};
	inline axis_v_enum axis_v(void);
	inline void axis_v(axis_v_enum value);
	inline Array<float, 2> center(void);
	inline void center(float values[2]);
	inline Object object_from(void);
	inline std::string bone_from(void);	inline void bone_from(const std::string& value);
	inline Object object_to(void);
	inline std::string bone_to(void);	inline void bone_to(const std::string& value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);

};

/**************** WeightVG Edit Modifier ****************/

class VertexWeightEditModifier : public Modifier {
public:
	VertexWeightEditModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	enum falloff_type_enum {
		falloff_type_LINEAR = 0,
		falloff_type_CURVE = 1,
		falloff_type_SHARP = 2,
		falloff_type_SMOOTH = 3,
		falloff_type_ROOT = 4,
		falloff_type_ICON_SPHERECURVE = 7,
		falloff_type_RANDOM = 8,
		falloff_type_STEP = 9,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline bool use_add(void);
	inline void use_add(int value);
	inline bool use_remove(void);
	inline void use_remove(int value);
	inline float default_weight(void);
	inline void default_weight(float value);
	inline CurveMapping map_curve(void);
	inline float add_threshold(void);
	inline void add_threshold(float value);
	inline float remove_threshold(void);
	inline void remove_threshold(float value);
	inline float mask_constant(void);
	inline void mask_constant(float value);
	inline std::string mask_vertex_group(void);	inline void mask_vertex_group(const std::string& value);
	inline Texture mask_texture(void);
	enum mask_tex_use_channel_enum {
		mask_tex_use_channel_INT = 1,
		mask_tex_use_channel_RED = 2,
		mask_tex_use_channel_GREEN = 3,
		mask_tex_use_channel_BLUE = 4,
		mask_tex_use_channel_HUE = 5,
		mask_tex_use_channel_SAT = 6,
		mask_tex_use_channel_VAL = 7,
		mask_tex_use_channel_ALPHA = 8,
	};
	inline mask_tex_use_channel_enum mask_tex_use_channel(void);
	inline void mask_tex_use_channel(mask_tex_use_channel_enum value);
	enum mask_tex_mapping_enum {
		mask_tex_mapping_LOCAL = 0,
		mask_tex_mapping_GLOBAL = 1,
		mask_tex_mapping_OBJECT = 2,
		mask_tex_mapping_UV = 3,
	};
	inline mask_tex_mapping_enum mask_tex_mapping(void);
	inline void mask_tex_mapping(mask_tex_mapping_enum value);
	inline std::string mask_tex_uv_layer(void);	inline void mask_tex_uv_layer(const std::string& value);
	inline Object mask_tex_map_object(void);

};

/**************** WeightVG Mix Modifier ****************/

class VertexWeightMixModifier : public Modifier {
public:
	VertexWeightMixModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group_a(void);	inline void vertex_group_a(const std::string& value);
	inline std::string vertex_group_b(void);	inline void vertex_group_b(const std::string& value);
	inline float default_weight_a(void);
	inline void default_weight_a(float value);
	inline float default_weight_b(void);
	inline void default_weight_b(float value);
	enum mix_mode_enum {
		mix_mode_SET = 1,
		mix_mode_ADD = 2,
		mix_mode_SUB = 3,
		mix_mode_MUL = 4,
		mix_mode_DIV = 5,
		mix_mode_DIF = 6,
		mix_mode_AVG = 7,
	};
	inline mix_mode_enum mix_mode(void);
	inline void mix_mode(mix_mode_enum value);
	enum mix_set_enum {
		mix_set_ALL = 1,
		mix_set_A = 2,
		mix_set_B = 3,
		mix_set_OR = 4,
		mix_set_AND = 5,
	};
	inline mix_set_enum mix_set(void);
	inline void mix_set(mix_set_enum value);
	inline float mask_constant(void);
	inline void mask_constant(float value);
	inline std::string mask_vertex_group(void);	inline void mask_vertex_group(const std::string& value);
	inline Texture mask_texture(void);
	enum mask_tex_use_channel_enum {
		mask_tex_use_channel_INT = 1,
		mask_tex_use_channel_RED = 2,
		mask_tex_use_channel_GREEN = 3,
		mask_tex_use_channel_BLUE = 4,
		mask_tex_use_channel_HUE = 5,
		mask_tex_use_channel_SAT = 6,
		mask_tex_use_channel_VAL = 7,
		mask_tex_use_channel_ALPHA = 8,
	};
	inline mask_tex_use_channel_enum mask_tex_use_channel(void);
	inline void mask_tex_use_channel(mask_tex_use_channel_enum value);
	enum mask_tex_mapping_enum {
		mask_tex_mapping_LOCAL = 0,
		mask_tex_mapping_GLOBAL = 1,
		mask_tex_mapping_OBJECT = 2,
		mask_tex_mapping_UV = 3,
	};
	inline mask_tex_mapping_enum mask_tex_mapping(void);
	inline void mask_tex_mapping(mask_tex_mapping_enum value);
	inline std::string mask_tex_uv_layer(void);	inline void mask_tex_uv_layer(const std::string& value);
	inline Object mask_tex_map_object(void);

};

/**************** WeightVG Proximity Modifier ****************/

class VertexWeightProximityModifier : public Modifier {
public:
	VertexWeightProximityModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	enum proximity_mode_enum {
		proximity_mode_OBJECT = 1,
		proximity_mode_GEOMETRY = 2,
	};
	inline proximity_mode_enum proximity_mode(void);
	inline void proximity_mode(proximity_mode_enum value);
	enum proximity_geometry_enum {
		proximity_geometry_VERTEX = 1,
		proximity_geometry_EDGE = 2,
		proximity_geometry_FACE = 4,
	};
	inline proximity_geometry_enum proximity_geometry(void);
	inline void proximity_geometry(proximity_geometry_enum value);
	inline Object target(void);
	inline float min_dist(void);
	inline void min_dist(float value);
	inline float max_dist(void);
	inline void max_dist(float value);
	enum falloff_type_enum {
		falloff_type_LINEAR = 0,
		falloff_type_SHARP = 2,
		falloff_type_SMOOTH = 3,
		falloff_type_ROOT = 4,
		falloff_type_ICON_SPHERECURVE = 7,
		falloff_type_RANDOM = 8,
		falloff_type_STEP = 9,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline float mask_constant(void);
	inline void mask_constant(float value);
	inline std::string mask_vertex_group(void);	inline void mask_vertex_group(const std::string& value);
	inline Texture mask_texture(void);
	enum mask_tex_use_channel_enum {
		mask_tex_use_channel_INT = 1,
		mask_tex_use_channel_RED = 2,
		mask_tex_use_channel_GREEN = 3,
		mask_tex_use_channel_BLUE = 4,
		mask_tex_use_channel_HUE = 5,
		mask_tex_use_channel_SAT = 6,
		mask_tex_use_channel_VAL = 7,
		mask_tex_use_channel_ALPHA = 8,
	};
	inline mask_tex_use_channel_enum mask_tex_use_channel(void);
	inline void mask_tex_use_channel(mask_tex_use_channel_enum value);
	enum mask_tex_mapping_enum {
		mask_tex_mapping_LOCAL = 0,
		mask_tex_mapping_GLOBAL = 1,
		mask_tex_mapping_OBJECT = 2,
		mask_tex_mapping_UV = 3,
	};
	inline mask_tex_mapping_enum mask_tex_mapping(void);
	inline void mask_tex_mapping(mask_tex_mapping_enum value);
	inline std::string mask_tex_uv_layer(void);	inline void mask_tex_uv_layer(const std::string& value);
	inline Object mask_tex_map_object(void);

};

/**************** Dynamic Paint Modifier ****************/

class DynamicPaintModifier : public Modifier {
public:
	DynamicPaintModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline DynamicPaintCanvasSettings canvas_settings(void);
	inline DynamicPaintBrushSettings brush_settings(void);
	enum ui_type_enum {
		ui_type_CANVAS = 1,
		ui_type_BRUSH = 2,
	};
	inline ui_type_enum ui_type(void);
	inline void ui_type(ui_type_enum value);

};

/**************** Ocean Modifier ****************/

class OceanModifier : public Modifier {
public:
	OceanModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum geometry_mode_enum {
		geometry_mode_GENERATE = 0,
		geometry_mode_DISPLACE = 1,
	};
	inline geometry_mode_enum geometry_mode(void);
	inline void geometry_mode(geometry_mode_enum value);
	inline float size(void);
	inline void size(float value);
	inline int repeat_x(void);
	inline void repeat_x(int value);
	inline int repeat_y(void);
	inline void repeat_y(int value);
	inline bool use_normals(void);
	inline void use_normals(int value);
	inline bool use_foam(void);
	inline void use_foam(int value);
	inline int resolution(void);
	inline void resolution(int value);
	inline int spatial_size(void);
	inline void spatial_size(int value);
	inline float wind_velocity(void);
	inline void wind_velocity(float value);
	inline float damping(void);
	inline void damping(float value);
	inline float wave_scale_min(void);
	inline void wave_scale_min(float value);
	inline float wave_alignment(void);
	inline void wave_alignment(float value);
	inline float wave_direction(void);
	inline void wave_direction(float value);
	inline float wave_scale(void);
	inline void wave_scale(float value);
	inline float depth(void);
	inline void depth(float value);
	inline float foam_coverage(void);
	inline void foam_coverage(float value);
	inline float bake_foam_fade(void);
	inline void bake_foam_fade(float value);
	inline std::string foam_layer_name(void);	inline void foam_layer_name(const std::string& value);
	inline float choppiness(void);
	inline void choppiness(float value);
	inline float time(void);
	inline void time(float value);
	inline int random_seed(void);
	inline void random_seed(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline bool is_cached(void);
	inline void is_cached(int value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);

};

/**************** Remesh Modifier ****************/

class RemeshModifier : public Modifier {
public:
	RemeshModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum mode_enum {
		mode_BLOCKS = 0,
		mode_SMOOTH = 1,
		mode_SHARP = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline float scale(void);
	inline void scale(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline int octree_depth(void);
	inline void octree_depth(int value);
	inline float sharpness(void);
	inline void sharpness(float value);
	inline bool use_remove_disconnected(void);
	inline void use_remove_disconnected(int value);
	inline bool use_smooth_shade(void);
	inline void use_smooth_shade(int value);

};

/**************** Skin Modifier ****************/

class SkinModifier : public Modifier {
public:
	SkinModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float branch_smoothing(void);
	inline void branch_smoothing(float value);
	inline bool use_smooth_shade(void);
	inline void use_smooth_shade(int value);
	inline bool use_x_symmetry(void);
	inline void use_x_symmetry(int value);
	inline bool use_y_symmetry(void);
	inline void use_y_symmetry(int value);
	inline bool use_z_symmetry(void);
	inline void use_z_symmetry(int value);

};

/**************** Laplacian Smooth Modifier ****************/

class LaplacianSmoothModifier : public Modifier {
public:
	LaplacianSmoothModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline bool use_x(void);
	inline void use_x(int value);
	inline bool use_y(void);
	inline void use_y(int value);
	inline bool use_z(void);
	inline void use_z(int value);
	inline bool use_volume_preserve(void);
	inline void use_volume_preserve(int value);
	inline bool use_normalized(void);
	inline void use_normalized(int value);
	inline float lambda_factor(void);
	inline void lambda_factor(float value);
	inline float lambda_border(void);
	inline void lambda_border(float value);
	inline int iterations(void);
	inline void iterations(int value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);

};

/**************** Triangulate Modifier ****************/

class TriangulateModifier : public Modifier {
public:
	TriangulateModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum quad_method_enum {
		quad_method_BEAUTY = 0,
		quad_method_FIXED = 1,
		quad_method_FIXED_ALTERNATE = 2,
		quad_method_SHORTEST_DIAGONAL = 3,
	};
	inline quad_method_enum quad_method(void);
	inline void quad_method(quad_method_enum value);
	enum ngon_method_enum {
		ngon_method_BEAUTY = 0,
		ngon_method_CLIP = 1,
	};
	inline ngon_method_enum ngon_method(void);
	inline void ngon_method(ngon_method_enum value);

};

/**************** Cache Modifier ****************/

class MeshCacheModifier : public Modifier {
public:
	MeshCacheModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum cache_format_enum {
		cache_format_MDD = 1,
		cache_format_PC2 = 2,
	};
	inline cache_format_enum cache_format(void);
	inline void cache_format(cache_format_enum value);
	enum interpolation_enum {
		interpolation_NONE = 0,
		interpolation_LINEAR = 1,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	enum time_mode_enum {
		time_mode_FRAME = 0,
		time_mode_TIME = 1,
		time_mode_FACTOR = 2,
	};
	inline time_mode_enum time_mode(void);
	inline void time_mode(time_mode_enum value);
	enum play_mode_enum {
		play_mode_SCENE = 0,
		play_mode_CUSTOM = 1,
	};
	inline play_mode_enum play_mode(void);
	inline void play_mode(play_mode_enum value);
	enum deform_mode_enum {
		deform_mode_OVERWRITE = 0,
		deform_mode_INTEGRATE = 1,
	};
	inline deform_mode_enum deform_mode(void);
	inline void deform_mode(deform_mode_enum value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline float factor(void);
	inline void factor(float value);
	enum forward_axis_enum {
		forward_axis_POS_X = 0,
		forward_axis_POS_Y = 1,
		forward_axis_POS_Z = 2,
		forward_axis_NEG_X = 3,
		forward_axis_NEG_Y = 4,
		forward_axis_NEG_Z = 5,
	};
	inline forward_axis_enum forward_axis(void);
	inline void forward_axis(forward_axis_enum value);
	enum up_axis_enum {
		up_axis_POS_X = 0,
		up_axis_POS_Y = 1,
		up_axis_POS_Z = 2,
		up_axis_NEG_X = 3,
		up_axis_NEG_Y = 4,
		up_axis_NEG_Z = 5,
	};
	inline up_axis_enum up_axis(void);
	inline void up_axis(up_axis_enum value);
	enum flip_axis_enum {
		flip_axis_X = 1,
		flip_axis_Y = 2,
		flip_axis_Z = 4,
	};
	inline flip_axis_enum flip_axis(void);
	inline void flip_axis(flip_axis_enum value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_scale(void);
	inline void frame_scale(float value);
	inline float eval_frame(void);
	inline void eval_frame(float value);
	inline float eval_time(void);
	inline void eval_time(float value);
	inline float eval_factor(void);
	inline void eval_factor(float value);

};

/**************** Laplacian Deform Modifier ****************/

class LaplacianDeformModifier : public Modifier {
public:
	LaplacianDeformModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline int iterations(void);
	inline void iterations(int value);
	inline bool is_bind(void);
	inline void is_bind(int value);

};

/**************** Wireframe Modifier ****************/

class WireframeModifier : public Modifier {
public:
	WireframeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float thickness(void);
	inline void thickness(float value);
	inline float thickness_vertex_group(void);
	inline void thickness_vertex_group(float value);
	inline float offset(void);
	inline void offset(float value);
	inline bool use_replace(void);
	inline void use_replace(int value);
	inline bool use_boundary(void);
	inline void use_boundary(int value);
	inline bool use_even_offset(void);
	inline void use_even_offset(int value);
	inline bool use_relative_offset(void);
	inline void use_relative_offset(int value);
	inline bool use_crease(void);
	inline void use_crease(int value);
	inline float crease_weight(void);
	inline void crease_weight(float value);
	inline int material_offset(void);
	inline void material_offset(int value);
	inline std::string vertex_group(void);	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(int value);

};

/**************** NLA Track ****************/

class NlaTrack : public Pointer {
public:
	NlaTrack(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		strips(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(NlaStrips, NlaStrip, NlaTrack, strips, false, true, true)
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool active(void);
	inline void active(int value);
	inline bool is_solo(void);
	inline void is_solo(int value);
	inline bool select(void);
	inline void select(int value);
	inline bool mute(void);
	inline void mute(int value);
	inline bool lock(void);
	inline void lock(int value);

};

/**************** NLA Strip ****************/

class NlaStrip : public Pointer {
public:
	NlaStrip(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		fcurves(ptr_arg),
		modifiers(ptr_arg),
		strips(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_CLIP = 0,
		type_TRANSITION = 1,
		type_META = 2,
		type_SOUND = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum extrapolation_enum {
		extrapolation_NOTHING = 2,
		extrapolation_HOLD = 0,
		extrapolation_HOLD_FORWARD = 1,
	};
	inline extrapolation_enum extrapolation(void);
	inline void extrapolation(extrapolation_enum value);
	enum blend_type_enum {
		blend_type_REPLACE = 0,
		blend_type_ADD = 1,
		blend_type_SUBTRACT = 2,
		blend_type_MULTIPLY = 3,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);
	inline float blend_in(void);
	inline void blend_in(float value);
	inline float blend_out(void);
	inline void blend_out(float value);
	inline bool use_auto_blend(void);
	inline void use_auto_blend(int value);
	inline Action action(void);
	inline float action_frame_start(void);
	inline void action_frame_start(float value);
	inline float action_frame_end(void);
	inline void action_frame_end(float value);
	inline float repeat(void);
	inline void repeat(float value);
	inline float scale(void);
	inline void scale(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FCurve, NlaStrip, fcurves, false, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FModifier, NlaStrip, modifiers, false, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, NlaStrip, NlaStrip, strips, false, true, true)
	inline float influence(void);
	inline void influence(float value);
	inline float strip_time(void);
	inline void strip_time(float value);
	inline bool use_animated_influence(void);
	inline void use_animated_influence(int value);
	inline bool use_animated_time(void);
	inline void use_animated_time(int value);
	inline bool use_animated_time_cyclic(void);
	inline void use_animated_time_cyclic(int value);
	inline bool active(void);
	inline void active(int value);
	inline bool select(void);
	inline void select(int value);
	inline bool mute(void);
	inline void mute(int value);
	inline bool use_reverse(void);
	inline void use_reverse(int value);
	inline bool use_sync_length(void);
	inline void use_sync_length(int value);

};

/**************** Node Socket ****************/

class NodeSocket : public Pointer {
public:
	NodeSocket(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline std::string identifier(void);	inline void identifier(const std::string& value);
	inline bool is_output(void);
	inline void is_output(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline bool enabled(void);
	inline void enabled(int value);
	inline int link_limit(void);
	inline void link_limit(int value);
	inline bool is_linked(void);
	inline void is_linked(int value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	inline bool hide_value(void);
	inline void hide_value(int value);
	inline Node node(void);
	enum type_enum {
		type_CUSTOM = -1,
		type_VALUE = 0,
		type_INT = 6,
		type_BOOLEAN = 4,
		type_VECTOR = 1,
		type_STRING = 7,
		type_RGBA = 2,
		type_SHADER = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);

};

/**************** Node Socket Template ****************/

class NodeSocketInterface : public Pointer {
public:
	NodeSocketInterface(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline std::string identifier(void);	inline void identifier(const std::string& value);
	inline bool is_output(void);
	inline void is_output(int value);
	inline std::string bl_socket_idname(void);	inline void bl_socket_idname(const std::string& value);

};

/**************** Node ****************/

class Node : public Pointer {
public:
	Node(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		inputs(ptr_arg),
		outputs(ptr_arg),
		internal_links(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_CUSTOM = -1,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline Array<float, 2> location(void);
	inline void location(float values[2]);
	inline float width(void);
	inline void width(float value);
	inline float width_hidden(void);
	inline void width_hidden(float value);
	inline float height(void);
	inline void height(float value);
	inline Array<float, 2> dimensions(void);
	inline void dimensions(float values[2]);
	inline std::string name(void);	inline void name(const std::string& value);
	inline std::string label(void);	inline void label(const std::string& value);
	COLLECTION_PROPERTY(NodeInputs, NodeSocket, Node, inputs, false, true, true)
	COLLECTION_PROPERTY(NodeOutputs, NodeSocket, Node, outputs, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, NodeLink, Node, internal_links, false, true, false)
	inline Node parent(void);
	inline bool use_custom_color(void);
	inline void use_custom_color(int value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline bool select(void);
	inline void select(int value);
	inline bool show_options(void);
	inline void show_options(int value);
	inline bool show_preview(void);
	inline void show_preview(int value);
	inline bool hide(void);
	inline void hide(int value);
	inline bool mute(void);
	inline void mute(int value);
	inline bool show_texture(void);
	inline void show_texture(int value);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);	inline void bl_label(const std::string& value);
	inline std::string bl_description(void);	inline void bl_description(const std::string& value);
	enum bl_icon_enum {
		bl_icon_NONE = 0,
		bl_icon_QUESTION = 1,
		bl_icon_ERROR = 2,
		bl_icon_CANCEL = 3,
		bl_icon_TRIA_RIGHT = 4,
		bl_icon_TRIA_DOWN = 5,
		bl_icon_TRIA_LEFT = 6,
		bl_icon_TRIA_UP = 7,
		bl_icon_ARROW_LEFTRIGHT = 8,
		bl_icon_PLUS = 9,
		bl_icon_DISCLOSURE_TRI_DOWN = 10,
		bl_icon_DISCLOSURE_TRI_RIGHT = 11,
		bl_icon_RADIOBUT_OFF = 12,
		bl_icon_RADIOBUT_ON = 13,
		bl_icon_MENU_PANEL = 14,
		bl_icon_BLENDER = 15,
		bl_icon_GRIP = 16,
		bl_icon_DOT = 17,
		bl_icon_COLLAPSEMENU = 18,
		bl_icon_X = 19,
		bl_icon_GO_LEFT = 21,
		bl_icon_PLUG = 22,
		bl_icon_UI = 23,
		bl_icon_NODE = 24,
		bl_icon_NODE_SEL = 25,
		bl_icon_FULLSCREEN = 26,
		bl_icon_SPLITSCREEN = 27,
		bl_icon_RIGHTARROW_THIN = 28,
		bl_icon_BORDERMOVE = 29,
		bl_icon_VIEWZOOM = 30,
		bl_icon_ZOOMIN = 31,
		bl_icon_ZOOMOUT = 32,
		bl_icon_PANEL_CLOSE = 33,
		bl_icon_COPY_ID = 34,
		bl_icon_EYEDROPPER = 35,
		bl_icon_LINK_AREA = 36,
		bl_icon_AUTO = 37,
		bl_icon_CHECKBOX_DEHLT = 38,
		bl_icon_CHECKBOX_HLT = 39,
		bl_icon_UNLOCKED = 40,
		bl_icon_LOCKED = 41,
		bl_icon_UNPINNED = 42,
		bl_icon_PINNED = 43,
		bl_icon_SCREEN_BACK = 44,
		bl_icon_RIGHTARROW = 45,
		bl_icon_DOWNARROW_HLT = 46,
		bl_icon_DOTSUP = 47,
		bl_icon_DOTSDOWN = 48,
		bl_icon_LINK = 49,
		bl_icon_INLINK = 50,
		bl_icon_PLUGIN = 51,
		bl_icon_HELP = 52,
		bl_icon_GHOST_ENABLED = 53,
		bl_icon_COLOR = 54,
		bl_icon_LINKED = 55,
		bl_icon_UNLINKED = 56,
		bl_icon_HAND = 57,
		bl_icon_ZOOM_ALL = 58,
		bl_icon_ZOOM_SELECTED = 59,
		bl_icon_ZOOM_PREVIOUS = 60,
		bl_icon_ZOOM_IN = 61,
		bl_icon_ZOOM_OUT = 62,
		bl_icon_RENDER_REGION = 63,
		bl_icon_BORDER_RECT = 64,
		bl_icon_BORDER_LASSO = 65,
		bl_icon_FREEZE = 66,
		bl_icon_STYLUS_PRESSURE = 67,
		bl_icon_GHOST_DISABLED = 68,
		bl_icon_NEW = 69,
		bl_icon_FILE_TICK = 70,
		bl_icon_QUIT = 71,
		bl_icon_URL = 72,
		bl_icon_RECOVER_LAST = 73,
		bl_icon_FULLSCREEN_ENTER = 75,
		bl_icon_FULLSCREEN_EXIT = 76,
		bl_icon_BLANK1 = 77,
		bl_icon_LAMP = 78,
		bl_icon_MATERIAL = 79,
		bl_icon_TEXTURE = 80,
		bl_icon_ANIM = 81,
		bl_icon_WORLD = 82,
		bl_icon_SCENE = 83,
		bl_icon_EDIT = 84,
		bl_icon_GAME = 85,
		bl_icon_RADIO = 86,
		bl_icon_SCRIPT = 87,
		bl_icon_PARTICLES = 88,
		bl_icon_PHYSICS = 89,
		bl_icon_SPEAKER = 90,
		bl_icon_TEXTURE_SHADED = 91,
		bl_icon_VIEW3D = 104,
		bl_icon_IPO = 105,
		bl_icon_OOPS = 106,
		bl_icon_BUTS = 107,
		bl_icon_FILESEL = 108,
		bl_icon_IMAGE_COL = 109,
		bl_icon_INFO = 110,
		bl_icon_SEQUENCE = 111,
		bl_icon_TEXT = 112,
		bl_icon_IMASEL = 113,
		bl_icon_SOUND = 114,
		bl_icon_ACTION = 115,
		bl_icon_NLA = 116,
		bl_icon_SCRIPTWIN = 117,
		bl_icon_TIME = 118,
		bl_icon_NODETREE = 119,
		bl_icon_LOGIC = 120,
		bl_icon_CONSOLE = 121,
		bl_icon_PREFERENCES = 122,
		bl_icon_CLIP = 123,
		bl_icon_ASSET_MANAGER = 124,
		bl_icon_OBJECT_DATAMODE = 130,
		bl_icon_EDITMODE_HLT = 131,
		bl_icon_FACESEL_HLT = 132,
		bl_icon_VPAINT_HLT = 133,
		bl_icon_TPAINT_HLT = 134,
		bl_icon_WPAINT_HLT = 135,
		bl_icon_SCULPTMODE_HLT = 136,
		bl_icon_POSE_HLT = 137,
		bl_icon_PARTICLEMODE = 138,
		bl_icon_LIGHTPAINT = 139,
		bl_icon_SCENE_DATA = 156,
		bl_icon_RENDERLAYERS = 157,
		bl_icon_WORLD_DATA = 158,
		bl_icon_OBJECT_DATA = 159,
		bl_icon_MESH_DATA = 160,
		bl_icon_CURVE_DATA = 161,
		bl_icon_META_DATA = 162,
		bl_icon_LATTICE_DATA = 163,
		bl_icon_LAMP_DATA = 164,
		bl_icon_MATERIAL_DATA = 165,
		bl_icon_TEXTURE_DATA = 166,
		bl_icon_ANIM_DATA = 167,
		bl_icon_CAMERA_DATA = 168,
		bl_icon_PARTICLE_DATA = 169,
		bl_icon_LIBRARY_DATA_DIRECT = 170,
		bl_icon_GROUP = 171,
		bl_icon_ARMATURE_DATA = 172,
		bl_icon_POSE_DATA = 173,
		bl_icon_BONE_DATA = 174,
		bl_icon_CONSTRAINT = 175,
		bl_icon_SHAPEKEY_DATA = 176,
		bl_icon_CONSTRAINT_BONE = 177,
		bl_icon_CAMERA_STEREO = 178,
		bl_icon_PACKAGE = 179,
		bl_icon_UGLYPACKAGE = 180,
		bl_icon_BRUSH_DATA = 182,
		bl_icon_IMAGE_DATA = 183,
		bl_icon_FILE = 184,
		bl_icon_FCURVE = 185,
		bl_icon_FONT_DATA = 186,
		bl_icon_RENDER_RESULT = 187,
		bl_icon_SURFACE_DATA = 188,
		bl_icon_EMPTY_DATA = 189,
		bl_icon_SETTINGS = 190,
		bl_icon_RENDER_ANIMATION = 191,
		bl_icon_RENDER_STILL = 192,
		bl_icon_BOIDS = 194,
		bl_icon_STRANDS = 195,
		bl_icon_LIBRARY_DATA_INDIRECT = 196,
		bl_icon_GREASEPENCIL = 197,
		bl_icon_LINE_DATA = 198,
		bl_icon_GROUP_BONE = 200,
		bl_icon_GROUP_VERTEX = 201,
		bl_icon_GROUP_VCOL = 202,
		bl_icon_GROUP_UVS = 203,
		bl_icon_RNA = 206,
		bl_icon_RNA_ADD = 207,
		bl_icon_OUTLINER_OB_EMPTY = 234,
		bl_icon_OUTLINER_OB_MESH = 235,
		bl_icon_OUTLINER_OB_CURVE = 236,
		bl_icon_OUTLINER_OB_LATTICE = 237,
		bl_icon_OUTLINER_OB_META = 238,
		bl_icon_OUTLINER_OB_LAMP = 239,
		bl_icon_OUTLINER_OB_CAMERA = 240,
		bl_icon_OUTLINER_OB_ARMATURE = 241,
		bl_icon_OUTLINER_OB_FONT = 242,
		bl_icon_OUTLINER_OB_SURFACE = 243,
		bl_icon_OUTLINER_OB_SPEAKER = 244,
		bl_icon_RESTRICT_VIEW_OFF = 253,
		bl_icon_RESTRICT_VIEW_ON = 254,
		bl_icon_RESTRICT_SELECT_OFF = 255,
		bl_icon_RESTRICT_SELECT_ON = 256,
		bl_icon_RESTRICT_RENDER_OFF = 257,
		bl_icon_RESTRICT_RENDER_ON = 258,
		bl_icon_OUTLINER_DATA_EMPTY = 260,
		bl_icon_OUTLINER_DATA_MESH = 261,
		bl_icon_OUTLINER_DATA_CURVE = 262,
		bl_icon_OUTLINER_DATA_LATTICE = 263,
		bl_icon_OUTLINER_DATA_META = 264,
		bl_icon_OUTLINER_DATA_LAMP = 265,
		bl_icon_OUTLINER_DATA_CAMERA = 266,
		bl_icon_OUTLINER_DATA_ARMATURE = 267,
		bl_icon_OUTLINER_DATA_FONT = 268,
		bl_icon_OUTLINER_DATA_SURFACE = 269,
		bl_icon_OUTLINER_DATA_SPEAKER = 270,
		bl_icon_OUTLINER_DATA_POSE = 271,
		bl_icon_MESH_PLANE = 286,
		bl_icon_MESH_CUBE = 287,
		bl_icon_MESH_CIRCLE = 288,
		bl_icon_MESH_UVSPHERE = 289,
		bl_icon_MESH_ICOSPHERE = 290,
		bl_icon_MESH_GRID = 291,
		bl_icon_MESH_MONKEY = 292,
		bl_icon_MESH_CYLINDER = 293,
		bl_icon_MESH_TORUS = 294,
		bl_icon_MESH_CONE = 295,
		bl_icon_LAMP_POINT = 298,
		bl_icon_LAMP_SUN = 299,
		bl_icon_LAMP_SPOT = 300,
		bl_icon_LAMP_HEMI = 301,
		bl_icon_LAMP_AREA = 302,
		bl_icon_META_EMPTY = 305,
		bl_icon_META_PLANE = 306,
		bl_icon_META_CUBE = 307,
		bl_icon_META_BALL = 308,
		bl_icon_META_ELLIPSOID = 309,
		bl_icon_META_CAPSULE = 310,
		bl_icon_SURFACE_NCURVE = 312,
		bl_icon_SURFACE_NCIRCLE = 313,
		bl_icon_SURFACE_NSURFACE = 314,
		bl_icon_SURFACE_NCYLINDER = 315,
		bl_icon_SURFACE_NSPHERE = 316,
		bl_icon_SURFACE_NTORUS = 317,
		bl_icon_CURVE_BEZCURVE = 321,
		bl_icon_CURVE_BEZCIRCLE = 322,
		bl_icon_CURVE_NCURVE = 323,
		bl_icon_CURVE_NCIRCLE = 324,
		bl_icon_CURVE_PATH = 325,
		bl_icon_COLOR_RED = 331,
		bl_icon_COLOR_GREEN = 332,
		bl_icon_COLOR_BLUE = 333,
		bl_icon_TRIA_RIGHT_BAR = 334,
		bl_icon_TRIA_DOWN_BAR = 335,
		bl_icon_TRIA_LEFT_BAR = 336,
		bl_icon_TRIA_UP_BAR = 337,
		bl_icon_FORCE_FORCE = 338,
		bl_icon_FORCE_WIND = 339,
		bl_icon_FORCE_VORTEX = 340,
		bl_icon_FORCE_MAGNETIC = 341,
		bl_icon_FORCE_HARMONIC = 342,
		bl_icon_FORCE_CHARGE = 343,
		bl_icon_FORCE_LENNARDJONES = 344,
		bl_icon_FORCE_TEXTURE = 345,
		bl_icon_FORCE_CURVE = 346,
		bl_icon_FORCE_BOID = 347,
		bl_icon_FORCE_TURBULENCE = 348,
		bl_icon_FORCE_DRAG = 349,
		bl_icon_FORCE_SMOKEFLOW = 350,
		bl_icon_MODIFIER = 442,
		bl_icon_MOD_WAVE = 443,
		bl_icon_MOD_BUILD = 444,
		bl_icon_MOD_DECIM = 445,
		bl_icon_MOD_MIRROR = 446,
		bl_icon_MOD_SOFT = 447,
		bl_icon_MOD_SUBSURF = 448,
		bl_icon_HOOK = 449,
		bl_icon_MOD_PHYSICS = 450,
		bl_icon_MOD_PARTICLES = 451,
		bl_icon_MOD_BOOLEAN = 452,
		bl_icon_MOD_EDGESPLIT = 453,
		bl_icon_MOD_ARRAY = 454,
		bl_icon_MOD_UVPROJECT = 455,
		bl_icon_MOD_DISPLACE = 456,
		bl_icon_MOD_CURVE = 457,
		bl_icon_MOD_LATTICE = 458,
		bl_icon_CONSTRAINT_DATA = 459,
		bl_icon_MOD_ARMATURE = 460,
		bl_icon_MOD_SHRINKWRAP = 461,
		bl_icon_MOD_CAST = 462,
		bl_icon_MOD_MESHDEFORM = 463,
		bl_icon_MOD_BEVEL = 464,
		bl_icon_MOD_SMOOTH = 465,
		bl_icon_MOD_SIMPLEDEFORM = 466,
		bl_icon_MOD_MASK = 467,
		bl_icon_MOD_CLOTH = 468,
		bl_icon_MOD_EXPLODE = 469,
		bl_icon_MOD_FLUIDSIM = 470,
		bl_icon_MOD_MULTIRES = 471,
		bl_icon_MOD_SMOKE = 472,
		bl_icon_MOD_SOLIDIFY = 473,
		bl_icon_MOD_SCREW = 474,
		bl_icon_MOD_VERTEX_WEIGHT = 475,
		bl_icon_MOD_DYNAMICPAINT = 476,
		bl_icon_MOD_REMESH = 477,
		bl_icon_MOD_OCEAN = 478,
		bl_icon_MOD_WARP = 479,
		bl_icon_MOD_SKIN = 480,
		bl_icon_MOD_TRIANGULATE = 481,
		bl_icon_MOD_WIREFRAME = 482,
		bl_icon_REC = 494,
		bl_icon_PLAY = 495,
		bl_icon_FF = 496,
		bl_icon_REW = 497,
		bl_icon_PAUSE = 498,
		bl_icon_PREV_KEYFRAME = 499,
		bl_icon_NEXT_KEYFRAME = 500,
		bl_icon_PLAY_AUDIO = 501,
		bl_icon_PLAY_REVERSE = 502,
		bl_icon_PREVIEW_RANGE = 503,
		bl_icon_ACTION_TWEAK = 504,
		bl_icon_PMARKER_ACT = 505,
		bl_icon_PMARKER_SEL = 506,
		bl_icon_PMARKER = 507,
		bl_icon_MARKER_HLT = 508,
		bl_icon_MARKER = 509,
		bl_icon_SPACE2 = 510,
		bl_icon_SPACE3 = 511,
		bl_icon_KEYINGSET = 512,
		bl_icon_KEY_DEHLT = 513,
		bl_icon_KEY_HLT = 514,
		bl_icon_MUTE_IPO_OFF = 515,
		bl_icon_MUTE_IPO_ON = 516,
		bl_icon_VISIBLE_IPO_OFF = 517,
		bl_icon_VISIBLE_IPO_ON = 518,
		bl_icon_DRIVER = 519,
		bl_icon_SOLO_OFF = 520,
		bl_icon_SOLO_ON = 521,
		bl_icon_FRAME_PREV = 522,
		bl_icon_FRAME_NEXT = 523,
		bl_icon_NLA_PUSHDOWN = 524,
		bl_icon_IPO_CONSTANT = 525,
		bl_icon_IPO_LINEAR = 526,
		bl_icon_IPO_BEZIER = 527,
		bl_icon_IPO_SINE = 528,
		bl_icon_IPO_QUAD = 529,
		bl_icon_IPO_CUBIC = 530,
		bl_icon_IPO_QUART = 531,
		bl_icon_IPO_QUINT = 532,
		bl_icon_IPO_EXPO = 533,
		bl_icon_IPO_CIRC = 534,
		bl_icon_IPO_BOUNCE = 535,
		bl_icon_IPO_ELASTIC = 536,
		bl_icon_IPO_BACK = 537,
		bl_icon_IPO_EASE_IN = 538,
		bl_icon_IPO_EASE_OUT = 539,
		bl_icon_IPO_EASE_IN_OUT = 540,
		bl_icon_VERTEXSEL = 546,
		bl_icon_EDGESEL = 547,
		bl_icon_FACESEL = 548,
		bl_icon_LOOPSEL = 549,
		bl_icon_ROTATE = 551,
		bl_icon_CURSOR = 552,
		bl_icon_ROTATECOLLECTION = 553,
		bl_icon_ROTATECENTER = 554,
		bl_icon_ROTACTIVE = 555,
		bl_icon_ALIGN = 556,
		bl_icon_SMOOTHCURVE = 558,
		bl_icon_SPHERECURVE = 559,
		bl_icon_ROOTCURVE = 560,
		bl_icon_SHARPCURVE = 561,
		bl_icon_LINCURVE = 562,
		bl_icon_NOCURVE = 563,
		bl_icon_RNDCURVE = 564,
		bl_icon_PROP_OFF = 565,
		bl_icon_PROP_ON = 566,
		bl_icon_PROP_CON = 567,
		bl_icon_SCULPT_DYNTOPO = 568,
		bl_icon_PARTICLE_POINT = 569,
		bl_icon_PARTICLE_TIP = 570,
		bl_icon_PARTICLE_PATH = 571,
		bl_icon_MAN_TRANS = 572,
		bl_icon_MAN_ROT = 573,
		bl_icon_MAN_SCALE = 574,
		bl_icon_MANIPUL = 575,
		bl_icon_SNAP_OFF = 576,
		bl_icon_SNAP_ON = 577,
		bl_icon_SNAP_NORMAL = 578,
		bl_icon_SNAP_INCREMENT = 579,
		bl_icon_SNAP_VERTEX = 580,
		bl_icon_SNAP_EDGE = 581,
		bl_icon_SNAP_FACE = 582,
		bl_icon_SNAP_VOLUME = 583,
		bl_icon_STICKY_UVS_LOC = 585,
		bl_icon_STICKY_UVS_DISABLE = 586,
		bl_icon_STICKY_UVS_VERT = 587,
		bl_icon_CLIPUV_DEHLT = 588,
		bl_icon_CLIPUV_HLT = 589,
		bl_icon_SNAP_PEEL_OBJECT = 590,
		bl_icon_GRID = 591,
		bl_icon_PASTEDOWN = 598,
		bl_icon_COPYDOWN = 599,
		bl_icon_PASTEFLIPUP = 600,
		bl_icon_PASTEFLIPDOWN = 601,
		bl_icon_SNAP_SURFACE = 606,
		bl_icon_AUTOMERGE_ON = 607,
		bl_icon_AUTOMERGE_OFF = 608,
		bl_icon_RETOPO = 609,
		bl_icon_UV_VERTEXSEL = 610,
		bl_icon_UV_EDGESEL = 611,
		bl_icon_UV_FACESEL = 612,
		bl_icon_UV_ISLANDSEL = 613,
		bl_icon_UV_SYNC_SELECT = 614,
		bl_icon_BBOX = 624,
		bl_icon_WIRE = 625,
		bl_icon_SOLID = 626,
		bl_icon_SMOOTH = 627,
		bl_icon_POTATO = 628,
		bl_icon_ORTHO = 630,
		bl_icon_LOCKVIEW_OFF = 633,
		bl_icon_LOCKVIEW_ON = 634,
		bl_icon_AXIS_SIDE = 636,
		bl_icon_AXIS_FRONT = 637,
		bl_icon_AXIS_TOP = 638,
		bl_icon_NDOF_DOM = 639,
		bl_icon_NDOF_TURN = 640,
		bl_icon_NDOF_FLY = 641,
		bl_icon_NDOF_TRANS = 642,
		bl_icon_LAYER_USED = 643,
		bl_icon_LAYER_ACTIVE = 644,
		bl_icon_SORTALPHA = 676,
		bl_icon_SORTBYEXT = 677,
		bl_icon_SORTTIME = 678,
		bl_icon_SORTSIZE = 679,
		bl_icon_LONGDISPLAY = 680,
		bl_icon_SHORTDISPLAY = 681,
		bl_icon_GHOST = 682,
		bl_icon_IMGDISPLAY = 683,
		bl_icon_SAVE_AS = 684,
		bl_icon_SAVE_COPY = 685,
		bl_icon_BOOKMARKS = 686,
		bl_icon_FONTPREVIEW = 687,
		bl_icon_FILTER = 688,
		bl_icon_NEWFOLDER = 689,
		bl_icon_OPEN_RECENT = 690,
		bl_icon_FILE_PARENT = 691,
		bl_icon_FILE_REFRESH = 692,
		bl_icon_FILE_FOLDER = 693,
		bl_icon_FILE_BLANK = 694,
		bl_icon_FILE_BLEND = 695,
		bl_icon_FILE_IMAGE = 696,
		bl_icon_FILE_MOVIE = 697,
		bl_icon_FILE_SCRIPT = 698,
		bl_icon_FILE_SOUND = 699,
		bl_icon_FILE_FONT = 700,
		bl_icon_FILE_TEXT = 701,
		bl_icon_RECOVER_AUTO = 702,
		bl_icon_SAVE_PREFS = 703,
		bl_icon_LINK_BLEND = 704,
		bl_icon_APPEND_BLEND = 705,
		bl_icon_IMPORT = 706,
		bl_icon_EXPORT = 707,
		bl_icon_EXTERNAL_DATA = 708,
		bl_icon_LOAD_FACTORY = 709,
		bl_icon_LOOP_BACK = 715,
		bl_icon_LOOP_FORWARDS = 716,
		bl_icon_BACK = 717,
		bl_icon_FORWARD = 718,
		bl_icon_FILE_BACKUP = 726,
		bl_icon_DISK_DRIVE = 727,
		bl_icon_MATPLANE = 728,
		bl_icon_MATSPHERE = 729,
		bl_icon_MATCUBE = 730,
		bl_icon_MONKEY = 731,
		bl_icon_HAIR = 732,
		bl_icon_ALIASED = 733,
		bl_icon_ANTIALIASED = 734,
		bl_icon_MAT_SPHERE_SKY = 735,
		bl_icon_WORDWRAP_OFF = 740,
		bl_icon_WORDWRAP_ON = 741,
		bl_icon_SYNTAX_OFF = 742,
		bl_icon_SYNTAX_ON = 743,
		bl_icon_LINENUMBERS_OFF = 744,
		bl_icon_LINENUMBERS_ON = 745,
		bl_icon_SCRIPTPLUGINS = 746,
		bl_icon_SEQ_SEQUENCER = 754,
		bl_icon_SEQ_PREVIEW = 755,
		bl_icon_SEQ_LUMA_WAVEFORM = 756,
		bl_icon_SEQ_CHROMA_SCOPE = 757,
		bl_icon_SEQ_HISTOGRAM = 758,
		bl_icon_SEQ_SPLITVIEW = 759,
		bl_icon_IMAGE_RGB = 763,
		bl_icon_IMAGE_RGB_ALPHA = 764,
		bl_icon_IMAGE_ALPHA = 765,
		bl_icon_IMAGE_ZDEPTH = 766,
		bl_icon_IMAGEFILE = 767,
		bl_icon_BRUSH_ADD = 780,
		bl_icon_BRUSH_BLOB = 781,
		bl_icon_BRUSH_BLUR = 782,
		bl_icon_BRUSH_CLAY = 783,
		bl_icon_BRUSH_CLAY_STRIPS = 784,
		bl_icon_BRUSH_CLONE = 785,
		bl_icon_BRUSH_CREASE = 786,
		bl_icon_BRUSH_DARKEN = 787,
		bl_icon_BRUSH_FILL = 788,
		bl_icon_BRUSH_FLATTEN = 789,
		bl_icon_BRUSH_GRAB = 790,
		bl_icon_BRUSH_INFLATE = 791,
		bl_icon_BRUSH_LAYER = 792,
		bl_icon_BRUSH_LIGHTEN = 793,
		bl_icon_BRUSH_MASK = 794,
		bl_icon_BRUSH_MIX = 795,
		bl_icon_BRUSH_MULTIPLY = 796,
		bl_icon_BRUSH_NUDGE = 797,
		bl_icon_BRUSH_PINCH = 798,
		bl_icon_BRUSH_SCRAPE = 799,
		bl_icon_BRUSH_SCULPT_DRAW = 800,
		bl_icon_BRUSH_SMEAR = 801,
		bl_icon_BRUSH_SMOOTH = 802,
		bl_icon_BRUSH_SNAKE_HOOK = 803,
		bl_icon_BRUSH_SOFTEN = 804,
		bl_icon_BRUSH_SUBTRACT = 805,
		bl_icon_BRUSH_TEXDRAW = 806,
		bl_icon_BRUSH_TEXFILL = 807,
		bl_icon_BRUSH_TEXMASK = 808,
		bl_icon_BRUSH_THUMB = 809,
		bl_icon_BRUSH_ROTATE = 810,
		bl_icon_BRUSH_VERTEXDRAW = 811,
		bl_icon_MATCAP_01 = 812,
		bl_icon_MATCAP_02 = 813,
		bl_icon_MATCAP_03 = 814,
		bl_icon_MATCAP_04 = 815,
		bl_icon_MATCAP_05 = 816,
		bl_icon_MATCAP_06 = 817,
		bl_icon_MATCAP_07 = 818,
		bl_icon_MATCAP_08 = 819,
		bl_icon_MATCAP_09 = 820,
		bl_icon_MATCAP_10 = 821,
		bl_icon_MATCAP_11 = 822,
		bl_icon_MATCAP_12 = 823,
		bl_icon_MATCAP_13 = 824,
		bl_icon_MATCAP_14 = 825,
		bl_icon_MATCAP_15 = 826,
		bl_icon_MATCAP_16 = 827,
		bl_icon_MATCAP_17 = 828,
		bl_icon_MATCAP_18 = 829,
		bl_icon_MATCAP_19 = 830,
		bl_icon_MATCAP_20 = 831,
		bl_icon_MATCAP_21 = 832,
		bl_icon_MATCAP_22 = 833,
		bl_icon_MATCAP_23 = 834,
		bl_icon_MATCAP_24 = 835,
	};
	inline bl_icon_enum bl_icon(void);
	inline void bl_icon(bl_icon_enum value);
	enum bl_static_type_enum {
		bl_static_type_CUSTOM = -1,
	};
	inline bl_static_type_enum bl_static_type(void);
	inline void bl_static_type(bl_static_type_enum value);
	inline float bl_width_default(void);
	inline void bl_width_default(float value);
	inline float bl_width_min(void);
	inline void bl_width_min(float value);
	inline float bl_width_max(void);
	inline void bl_width_max(float value);
	inline float bl_height_default(void);
	inline void bl_height_default(float value);
	inline float bl_height_min(void);
	inline void bl_height_min(float value);
	inline float bl_height_max(void);
	inline void bl_height_max(float value);

	inline void socket_value_update(Context context);
	inline int is_registered_node_type();
};

/**************** Valid ****************/

class NodeLink : public Pointer {
public:
	NodeLink(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_valid(void);
	inline void is_valid(int value);
	inline Node from_node(void);
	inline Node to_node(void);
	inline NodeSocket from_socket(void);
	inline NodeSocket to_socket(void);
	inline bool is_hidden(void);
	inline void is_hidden(int value);

};

/**************** Socket Template ****************/

class NodeInternalSocketTemplate : public Pointer {
public:
	NodeInternalSocketTemplate(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline std::string identifier(void);	inline void identifier(const std::string& value);
	enum type_enum {
		type_CUSTOM = -1,
		type_VALUE = 0,
		type_INT = 6,
		type_BOOLEAN = 4,
		type_VECTOR = 1,
		type_STRING = 7,
		type_RGBA = 2,
		type_SHADER = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);

};

/**************** NodeInternal ****************/

class NodeInternal : public Node {
public:
	NodeInternal(const PointerRNA &ptr_arg) :
		Node(ptr_arg)
		{}


	inline int poll(NodeTree node_tree);
	inline int poll_instance(NodeTree node_tree);
	inline void update();
	inline void draw_buttons(Context context, UILayout layout);
	inline void draw_buttons_ext(Context context, UILayout layout);
};

/**************** Shader Node ****************/

class ShaderNode : public NodeInternal {
public:
	ShaderNode(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


};

/**************** Compositor Node ****************/

class CompositorNode : public NodeInternal {
public:
	CompositorNode(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


	inline void tag_need_exec();
};

/**************** Texture Node ****************/

class TextureNode : public NodeInternal {
public:
	TextureNode(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


};

/**************** Node Tree ****************/

class NodeTree : public ID {
public:
	NodeTree(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		nodes(ptr_arg),
		links(ptr_arg),
		inputs(ptr_arg),
		outputs(ptr_arg)
		{}

	inline Array<float, 2> view_center(void);
	inline void view_center(float values[2]);
	inline AnimData animation_data(void);
	COLLECTION_PROPERTY(Nodes, Node, NodeTree, nodes, false, true, true)
	COLLECTION_PROPERTY(NodeLinks, NodeLink, NodeTree, links, false, true, false)
	inline GreasePencil grease_pencil(void);
	enum type_enum {
		type_SHADER = 0,
		type_TEXTURE = 2,
		type_COMPOSITING = 1,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	COLLECTION_PROPERTY(NodeTreeInputs, NodeSocketInterface, NodeTree, inputs, false, true, true)
	inline int active_input(void);
	inline void active_input(int value);
	COLLECTION_PROPERTY(NodeTreeOutputs, NodeSocketInterface, NodeTree, outputs, false, true, true)
	inline int active_output(void);
	inline void active_output(int value);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);	inline void bl_label(const std::string& value);
	inline std::string bl_description(void);	inline void bl_description(const std::string& value);
	enum bl_icon_enum {
		bl_icon_NONE = 0,
		bl_icon_QUESTION = 1,
		bl_icon_ERROR = 2,
		bl_icon_CANCEL = 3,
		bl_icon_TRIA_RIGHT = 4,
		bl_icon_TRIA_DOWN = 5,
		bl_icon_TRIA_LEFT = 6,
		bl_icon_TRIA_UP = 7,
		bl_icon_ARROW_LEFTRIGHT = 8,
		bl_icon_PLUS = 9,
		bl_icon_DISCLOSURE_TRI_DOWN = 10,
		bl_icon_DISCLOSURE_TRI_RIGHT = 11,
		bl_icon_RADIOBUT_OFF = 12,
		bl_icon_RADIOBUT_ON = 13,
		bl_icon_MENU_PANEL = 14,
		bl_icon_BLENDER = 15,
		bl_icon_GRIP = 16,
		bl_icon_DOT = 17,
		bl_icon_COLLAPSEMENU = 18,
		bl_icon_X = 19,
		bl_icon_GO_LEFT = 21,
		bl_icon_PLUG = 22,
		bl_icon_UI = 23,
		bl_icon_NODE = 24,
		bl_icon_NODE_SEL = 25,
		bl_icon_FULLSCREEN = 26,
		bl_icon_SPLITSCREEN = 27,
		bl_icon_RIGHTARROW_THIN = 28,
		bl_icon_BORDERMOVE = 29,
		bl_icon_VIEWZOOM = 30,
		bl_icon_ZOOMIN = 31,
		bl_icon_ZOOMOUT = 32,
		bl_icon_PANEL_CLOSE = 33,
		bl_icon_COPY_ID = 34,
		bl_icon_EYEDROPPER = 35,
		bl_icon_LINK_AREA = 36,
		bl_icon_AUTO = 37,
		bl_icon_CHECKBOX_DEHLT = 38,
		bl_icon_CHECKBOX_HLT = 39,
		bl_icon_UNLOCKED = 40,
		bl_icon_LOCKED = 41,
		bl_icon_UNPINNED = 42,
		bl_icon_PINNED = 43,
		bl_icon_SCREEN_BACK = 44,
		bl_icon_RIGHTARROW = 45,
		bl_icon_DOWNARROW_HLT = 46,
		bl_icon_DOTSUP = 47,
		bl_icon_DOTSDOWN = 48,
		bl_icon_LINK = 49,
		bl_icon_INLINK = 50,
		bl_icon_PLUGIN = 51,
		bl_icon_HELP = 52,
		bl_icon_GHOST_ENABLED = 53,
		bl_icon_COLOR = 54,
		bl_icon_LINKED = 55,
		bl_icon_UNLINKED = 56,
		bl_icon_HAND = 57,
		bl_icon_ZOOM_ALL = 58,
		bl_icon_ZOOM_SELECTED = 59,
		bl_icon_ZOOM_PREVIOUS = 60,
		bl_icon_ZOOM_IN = 61,
		bl_icon_ZOOM_OUT = 62,
		bl_icon_RENDER_REGION = 63,
		bl_icon_BORDER_RECT = 64,
		bl_icon_BORDER_LASSO = 65,
		bl_icon_FREEZE = 66,
		bl_icon_STYLUS_PRESSURE = 67,
		bl_icon_GHOST_DISABLED = 68,
		bl_icon_NEW = 69,
		bl_icon_FILE_TICK = 70,
		bl_icon_QUIT = 71,
		bl_icon_URL = 72,
		bl_icon_RECOVER_LAST = 73,
		bl_icon_FULLSCREEN_ENTER = 75,
		bl_icon_FULLSCREEN_EXIT = 76,
		bl_icon_BLANK1 = 77,
		bl_icon_LAMP = 78,
		bl_icon_MATERIAL = 79,
		bl_icon_TEXTURE = 80,
		bl_icon_ANIM = 81,
		bl_icon_WORLD = 82,
		bl_icon_SCENE = 83,
		bl_icon_EDIT = 84,
		bl_icon_GAME = 85,
		bl_icon_RADIO = 86,
		bl_icon_SCRIPT = 87,
		bl_icon_PARTICLES = 88,
		bl_icon_PHYSICS = 89,
		bl_icon_SPEAKER = 90,
		bl_icon_TEXTURE_SHADED = 91,
		bl_icon_VIEW3D = 104,
		bl_icon_IPO = 105,
		bl_icon_OOPS = 106,
		bl_icon_BUTS = 107,
		bl_icon_FILESEL = 108,
		bl_icon_IMAGE_COL = 109,
		bl_icon_INFO = 110,
		bl_icon_SEQUENCE = 111,
		bl_icon_TEXT = 112,
		bl_icon_IMASEL = 113,
		bl_icon_SOUND = 114,
		bl_icon_ACTION = 115,
		bl_icon_NLA = 116,
		bl_icon_SCRIPTWIN = 117,
		bl_icon_TIME = 118,
		bl_icon_NODETREE = 119,
		bl_icon_LOGIC = 120,
		bl_icon_CONSOLE = 121,
		bl_icon_PREFERENCES = 122,
		bl_icon_CLIP = 123,
		bl_icon_ASSET_MANAGER = 124,
		bl_icon_OBJECT_DATAMODE = 130,
		bl_icon_EDITMODE_HLT = 131,
		bl_icon_FACESEL_HLT = 132,
		bl_icon_VPAINT_HLT = 133,
		bl_icon_TPAINT_HLT = 134,
		bl_icon_WPAINT_HLT = 135,
		bl_icon_SCULPTMODE_HLT = 136,
		bl_icon_POSE_HLT = 137,
		bl_icon_PARTICLEMODE = 138,
		bl_icon_LIGHTPAINT = 139,
		bl_icon_SCENE_DATA = 156,
		bl_icon_RENDERLAYERS = 157,
		bl_icon_WORLD_DATA = 158,
		bl_icon_OBJECT_DATA = 159,
		bl_icon_MESH_DATA = 160,
		bl_icon_CURVE_DATA = 161,
		bl_icon_META_DATA = 162,
		bl_icon_LATTICE_DATA = 163,
		bl_icon_LAMP_DATA = 164,
		bl_icon_MATERIAL_DATA = 165,
		bl_icon_TEXTURE_DATA = 166,
		bl_icon_ANIM_DATA = 167,
		bl_icon_CAMERA_DATA = 168,
		bl_icon_PARTICLE_DATA = 169,
		bl_icon_LIBRARY_DATA_DIRECT = 170,
		bl_icon_GROUP = 171,
		bl_icon_ARMATURE_DATA = 172,
		bl_icon_POSE_DATA = 173,
		bl_icon_BONE_DATA = 174,
		bl_icon_CONSTRAINT = 175,
		bl_icon_SHAPEKEY_DATA = 176,
		bl_icon_CONSTRAINT_BONE = 177,
		bl_icon_CAMERA_STEREO = 178,
		bl_icon_PACKAGE = 179,
		bl_icon_UGLYPACKAGE = 180,
		bl_icon_BRUSH_DATA = 182,
		bl_icon_IMAGE_DATA = 183,
		bl_icon_FILE = 184,
		bl_icon_FCURVE = 185,
		bl_icon_FONT_DATA = 186,
		bl_icon_RENDER_RESULT = 187,
		bl_icon_SURFACE_DATA = 188,
		bl_icon_EMPTY_DATA = 189,
		bl_icon_SETTINGS = 190,
		bl_icon_RENDER_ANIMATION = 191,
		bl_icon_RENDER_STILL = 192,
		bl_icon_BOIDS = 194,
		bl_icon_STRANDS = 195,
		bl_icon_LIBRARY_DATA_INDIRECT = 196,
		bl_icon_GREASEPENCIL = 197,
		bl_icon_LINE_DATA = 198,
		bl_icon_GROUP_BONE = 200,
		bl_icon_GROUP_VERTEX = 201,
		bl_icon_GROUP_VCOL = 202,
		bl_icon_GROUP_UVS = 203,
		bl_icon_RNA = 206,
		bl_icon_RNA_ADD = 207,
		bl_icon_OUTLINER_OB_EMPTY = 234,
		bl_icon_OUTLINER_OB_MESH = 235,
		bl_icon_OUTLINER_OB_CURVE = 236,
		bl_icon_OUTLINER_OB_LATTICE = 237,
		bl_icon_OUTLINER_OB_META = 238,
		bl_icon_OUTLINER_OB_LAMP = 239,
		bl_icon_OUTLINER_OB_CAMERA = 240,
		bl_icon_OUTLINER_OB_ARMATURE = 241,
		bl_icon_OUTLINER_OB_FONT = 242,
		bl_icon_OUTLINER_OB_SURFACE = 243,
		bl_icon_OUTLINER_OB_SPEAKER = 244,
		bl_icon_RESTRICT_VIEW_OFF = 253,
		bl_icon_RESTRICT_VIEW_ON = 254,
		bl_icon_RESTRICT_SELECT_OFF = 255,
		bl_icon_RESTRICT_SELECT_ON = 256,
		bl_icon_RESTRICT_RENDER_OFF = 257,
		bl_icon_RESTRICT_RENDER_ON = 258,
		bl_icon_OUTLINER_DATA_EMPTY = 260,
		bl_icon_OUTLINER_DATA_MESH = 261,
		bl_icon_OUTLINER_DATA_CURVE = 262,
		bl_icon_OUTLINER_DATA_LATTICE = 263,
		bl_icon_OUTLINER_DATA_META = 264,
		bl_icon_OUTLINER_DATA_LAMP = 265,
		bl_icon_OUTLINER_DATA_CAMERA = 266,
		bl_icon_OUTLINER_DATA_ARMATURE = 267,
		bl_icon_OUTLINER_DATA_FONT = 268,
		bl_icon_OUTLINER_DATA_SURFACE = 269,
		bl_icon_OUTLINER_DATA_SPEAKER = 270,
		bl_icon_OUTLINER_DATA_POSE = 271,
		bl_icon_MESH_PLANE = 286,
		bl_icon_MESH_CUBE = 287,
		bl_icon_MESH_CIRCLE = 288,
		bl_icon_MESH_UVSPHERE = 289,
		bl_icon_MESH_ICOSPHERE = 290,
		bl_icon_MESH_GRID = 291,
		bl_icon_MESH_MONKEY = 292,
		bl_icon_MESH_CYLINDER = 293,
		bl_icon_MESH_TORUS = 294,
		bl_icon_MESH_CONE = 295,
		bl_icon_LAMP_POINT = 298,
		bl_icon_LAMP_SUN = 299,
		bl_icon_LAMP_SPOT = 300,
		bl_icon_LAMP_HEMI = 301,
		bl_icon_LAMP_AREA = 302,
		bl_icon_META_EMPTY = 305,
		bl_icon_META_PLANE = 306,
		bl_icon_META_CUBE = 307,
		bl_icon_META_BALL = 308,
		bl_icon_META_ELLIPSOID = 309,
		bl_icon_META_CAPSULE = 310,
		bl_icon_SURFACE_NCURVE = 312,
		bl_icon_SURFACE_NCIRCLE = 313,
		bl_icon_SURFACE_NSURFACE = 314,
		bl_icon_SURFACE_NCYLINDER = 315,
		bl_icon_SURFACE_NSPHERE = 316,
		bl_icon_SURFACE_NTORUS = 317,
		bl_icon_CURVE_BEZCURVE = 321,
		bl_icon_CURVE_BEZCIRCLE = 322,
		bl_icon_CURVE_NCURVE = 323,
		bl_icon_CURVE_NCIRCLE = 324,
		bl_icon_CURVE_PATH = 325,
		bl_icon_COLOR_RED = 331,
		bl_icon_COLOR_GREEN = 332,
		bl_icon_COLOR_BLUE = 333,
		bl_icon_TRIA_RIGHT_BAR = 334,
		bl_icon_TRIA_DOWN_BAR = 335,
		bl_icon_TRIA_LEFT_BAR = 336,
		bl_icon_TRIA_UP_BAR = 337,
		bl_icon_FORCE_FORCE = 338,
		bl_icon_FORCE_WIND = 339,
		bl_icon_FORCE_VORTEX = 340,
		bl_icon_FORCE_MAGNETIC = 341,
		bl_icon_FORCE_HARMONIC = 342,
		bl_icon_FORCE_CHARGE = 343,
		bl_icon_FORCE_LENNARDJONES = 344,
		bl_icon_FORCE_TEXTURE = 345,
		bl_icon_FORCE_CURVE = 346,
		bl_icon_FORCE_BOID = 347,
		bl_icon_FORCE_TURBULENCE = 348,
		bl_icon_FORCE_DRAG = 349,
		bl_icon_FORCE_SMOKEFLOW = 350,
		bl_icon_MODIFIER = 442,
		bl_icon_MOD_WAVE = 443,
		bl_icon_MOD_BUILD = 444,
		bl_icon_MOD_DECIM = 445,
		bl_icon_MOD_MIRROR = 446,
		bl_icon_MOD_SOFT = 447,
		bl_icon_MOD_SUBSURF = 448,
		bl_icon_HOOK = 449,
		bl_icon_MOD_PHYSICS = 450,
		bl_icon_MOD_PARTICLES = 451,
		bl_icon_MOD_BOOLEAN = 452,
		bl_icon_MOD_EDGESPLIT = 453,
		bl_icon_MOD_ARRAY = 454,
		bl_icon_MOD_UVPROJECT = 455,
		bl_icon_MOD_DISPLACE = 456,
		bl_icon_MOD_CURVE = 457,
		bl_icon_MOD_LATTICE = 458,
		bl_icon_CONSTRAINT_DATA = 459,
		bl_icon_MOD_ARMATURE = 460,
		bl_icon_MOD_SHRINKWRAP = 461,
		bl_icon_MOD_CAST = 462,
		bl_icon_MOD_MESHDEFORM = 463,
		bl_icon_MOD_BEVEL = 464,
		bl_icon_MOD_SMOOTH = 465,
		bl_icon_MOD_SIMPLEDEFORM = 466,
		bl_icon_MOD_MASK = 467,
		bl_icon_MOD_CLOTH = 468,
		bl_icon_MOD_EXPLODE = 469,
		bl_icon_MOD_FLUIDSIM = 470,
		bl_icon_MOD_MULTIRES = 471,
		bl_icon_MOD_SMOKE = 472,
		bl_icon_MOD_SOLIDIFY = 473,
		bl_icon_MOD_SCREW = 474,
		bl_icon_MOD_VERTEX_WEIGHT = 475,
		bl_icon_MOD_DYNAMICPAINT = 476,
		bl_icon_MOD_REMESH = 477,
		bl_icon_MOD_OCEAN = 478,
		bl_icon_MOD_WARP = 479,
		bl_icon_MOD_SKIN = 480,
		bl_icon_MOD_TRIANGULATE = 481,
		bl_icon_MOD_WIREFRAME = 482,
		bl_icon_REC = 494,
		bl_icon_PLAY = 495,
		bl_icon_FF = 496,
		bl_icon_REW = 497,
		bl_icon_PAUSE = 498,
		bl_icon_PREV_KEYFRAME = 499,
		bl_icon_NEXT_KEYFRAME = 500,
		bl_icon_PLAY_AUDIO = 501,
		bl_icon_PLAY_REVERSE = 502,
		bl_icon_PREVIEW_RANGE = 503,
		bl_icon_ACTION_TWEAK = 504,
		bl_icon_PMARKER_ACT = 505,
		bl_icon_PMARKER_SEL = 506,
		bl_icon_PMARKER = 507,
		bl_icon_MARKER_HLT = 508,
		bl_icon_MARKER = 509,
		bl_icon_SPACE2 = 510,
		bl_icon_SPACE3 = 511,
		bl_icon_KEYINGSET = 512,
		bl_icon_KEY_DEHLT = 513,
		bl_icon_KEY_HLT = 514,
		bl_icon_MUTE_IPO_OFF = 515,
		bl_icon_MUTE_IPO_ON = 516,
		bl_icon_VISIBLE_IPO_OFF = 517,
		bl_icon_VISIBLE_IPO_ON = 518,
		bl_icon_DRIVER = 519,
		bl_icon_SOLO_OFF = 520,
		bl_icon_SOLO_ON = 521,
		bl_icon_FRAME_PREV = 522,
		bl_icon_FRAME_NEXT = 523,
		bl_icon_NLA_PUSHDOWN = 524,
		bl_icon_IPO_CONSTANT = 525,
		bl_icon_IPO_LINEAR = 526,
		bl_icon_IPO_BEZIER = 527,
		bl_icon_IPO_SINE = 528,
		bl_icon_IPO_QUAD = 529,
		bl_icon_IPO_CUBIC = 530,
		bl_icon_IPO_QUART = 531,
		bl_icon_IPO_QUINT = 532,
		bl_icon_IPO_EXPO = 533,
		bl_icon_IPO_CIRC = 534,
		bl_icon_IPO_BOUNCE = 535,
		bl_icon_IPO_ELASTIC = 536,
		bl_icon_IPO_BACK = 537,
		bl_icon_IPO_EASE_IN = 538,
		bl_icon_IPO_EASE_OUT = 539,
		bl_icon_IPO_EASE_IN_OUT = 540,
		bl_icon_VERTEXSEL = 546,
		bl_icon_EDGESEL = 547,
		bl_icon_FACESEL = 548,
		bl_icon_LOOPSEL = 549,
		bl_icon_ROTATE = 551,
		bl_icon_CURSOR = 552,
		bl_icon_ROTATECOLLECTION = 553,
		bl_icon_ROTATECENTER = 554,
		bl_icon_ROTACTIVE = 555,
		bl_icon_ALIGN = 556,
		bl_icon_SMOOTHCURVE = 558,
		bl_icon_SPHERECURVE = 559,
		bl_icon_ROOTCURVE = 560,
		bl_icon_SHARPCURVE = 561,
		bl_icon_LINCURVE = 562,
		bl_icon_NOCURVE = 563,
		bl_icon_RNDCURVE = 564,
		bl_icon_PROP_OFF = 565,
		bl_icon_PROP_ON = 566,
		bl_icon_PROP_CON = 567,
		bl_icon_SCULPT_DYNTOPO = 568,
		bl_icon_PARTICLE_POINT = 569,
		bl_icon_PARTICLE_TIP = 570,
		bl_icon_PARTICLE_PATH = 571,
		bl_icon_MAN_TRANS = 572,
		bl_icon_MAN_ROT = 573,
		bl_icon_MAN_SCALE = 574,
		bl_icon_MANIPUL = 575,
		bl_icon_SNAP_OFF = 576,
		bl_icon_SNAP_ON = 577,
		bl_icon_SNAP_NORMAL = 578,
		bl_icon_SNAP_INCREMENT = 579,
		bl_icon_SNAP_VERTEX = 580,
		bl_icon_SNAP_EDGE = 581,
		bl_icon_SNAP_FACE = 582,
		bl_icon_SNAP_VOLUME = 583,
		bl_icon_STICKY_UVS_LOC = 585,
		bl_icon_STICKY_UVS_DISABLE = 586,
		bl_icon_STICKY_UVS_VERT = 587,
		bl_icon_CLIPUV_DEHLT = 588,
		bl_icon_CLIPUV_HLT = 589,
		bl_icon_SNAP_PEEL_OBJECT = 590,
		bl_icon_GRID = 591,
		bl_icon_PASTEDOWN = 598,
		bl_icon_COPYDOWN = 599,
		bl_icon_PASTEFLIPUP = 600,
		bl_icon_PASTEFLIPDOWN = 601,
		bl_icon_SNAP_SURFACE = 606,
		bl_icon_AUTOMERGE_ON = 607,
		bl_icon_AUTOMERGE_OFF = 608,
		bl_icon_RETOPO = 609,
		bl_icon_UV_VERTEXSEL = 610,
		bl_icon_UV_EDGESEL = 611,
		bl_icon_UV_FACESEL = 612,
		bl_icon_UV_ISLANDSEL = 613,
		bl_icon_UV_SYNC_SELECT = 614,
		bl_icon_BBOX = 624,
		bl_icon_WIRE = 625,
		bl_icon_SOLID = 626,
		bl_icon_SMOOTH = 627,
		bl_icon_POTATO = 628,
		bl_icon_ORTHO = 630,
		bl_icon_LOCKVIEW_OFF = 633,
		bl_icon_LOCKVIEW_ON = 634,
		bl_icon_AXIS_SIDE = 636,
		bl_icon_AXIS_FRONT = 637,
		bl_icon_AXIS_TOP = 638,
		bl_icon_NDOF_DOM = 639,
		bl_icon_NDOF_TURN = 640,
		bl_icon_NDOF_FLY = 641,
		bl_icon_NDOF_TRANS = 642,
		bl_icon_LAYER_USED = 643,
		bl_icon_LAYER_ACTIVE = 644,
		bl_icon_SORTALPHA = 676,
		bl_icon_SORTBYEXT = 677,
		bl_icon_SORTTIME = 678,
		bl_icon_SORTSIZE = 679,
		bl_icon_LONGDISPLAY = 680,
		bl_icon_SHORTDISPLAY = 681,
		bl_icon_GHOST = 682,
		bl_icon_IMGDISPLAY = 683,
		bl_icon_SAVE_AS = 684,
		bl_icon_SAVE_COPY = 685,
		bl_icon_BOOKMARKS = 686,
		bl_icon_FONTPREVIEW = 687,
		bl_icon_FILTER = 688,
		bl_icon_NEWFOLDER = 689,
		bl_icon_OPEN_RECENT = 690,
		bl_icon_FILE_PARENT = 691,
		bl_icon_FILE_REFRESH = 692,
		bl_icon_FILE_FOLDER = 693,
		bl_icon_FILE_BLANK = 694,
		bl_icon_FILE_BLEND = 695,
		bl_icon_FILE_IMAGE = 696,
		bl_icon_FILE_MOVIE = 697,
		bl_icon_FILE_SCRIPT = 698,
		bl_icon_FILE_SOUND = 699,
		bl_icon_FILE_FONT = 700,
		bl_icon_FILE_TEXT = 701,
		bl_icon_RECOVER_AUTO = 702,
		bl_icon_SAVE_PREFS = 703,
		bl_icon_LINK_BLEND = 704,
		bl_icon_APPEND_BLEND = 705,
		bl_icon_IMPORT = 706,
		bl_icon_EXPORT = 707,
		bl_icon_EXTERNAL_DATA = 708,
		bl_icon_LOAD_FACTORY = 709,
		bl_icon_LOOP_BACK = 715,
		bl_icon_LOOP_FORWARDS = 716,
		bl_icon_BACK = 717,
		bl_icon_FORWARD = 718,
		bl_icon_FILE_BACKUP = 726,
		bl_icon_DISK_DRIVE = 727,
		bl_icon_MATPLANE = 728,
		bl_icon_MATSPHERE = 729,
		bl_icon_MATCUBE = 730,
		bl_icon_MONKEY = 731,
		bl_icon_HAIR = 732,
		bl_icon_ALIASED = 733,
		bl_icon_ANTIALIASED = 734,
		bl_icon_MAT_SPHERE_SKY = 735,
		bl_icon_WORDWRAP_OFF = 740,
		bl_icon_WORDWRAP_ON = 741,
		bl_icon_SYNTAX_OFF = 742,
		bl_icon_SYNTAX_ON = 743,
		bl_icon_LINENUMBERS_OFF = 744,
		bl_icon_LINENUMBERS_ON = 745,
		bl_icon_SCRIPTPLUGINS = 746,
		bl_icon_SEQ_SEQUENCER = 754,
		bl_icon_SEQ_PREVIEW = 755,
		bl_icon_SEQ_LUMA_WAVEFORM = 756,
		bl_icon_SEQ_CHROMA_SCOPE = 757,
		bl_icon_SEQ_HISTOGRAM = 758,
		bl_icon_SEQ_SPLITVIEW = 759,
		bl_icon_IMAGE_RGB = 763,
		bl_icon_IMAGE_RGB_ALPHA = 764,
		bl_icon_IMAGE_ALPHA = 765,
		bl_icon_IMAGE_ZDEPTH = 766,
		bl_icon_IMAGEFILE = 767,
		bl_icon_BRUSH_ADD = 780,
		bl_icon_BRUSH_BLOB = 781,
		bl_icon_BRUSH_BLUR = 782,
		bl_icon_BRUSH_CLAY = 783,
		bl_icon_BRUSH_CLAY_STRIPS = 784,
		bl_icon_BRUSH_CLONE = 785,
		bl_icon_BRUSH_CREASE = 786,
		bl_icon_BRUSH_DARKEN = 787,
		bl_icon_BRUSH_FILL = 788,
		bl_icon_BRUSH_FLATTEN = 789,
		bl_icon_BRUSH_GRAB = 790,
		bl_icon_BRUSH_INFLATE = 791,
		bl_icon_BRUSH_LAYER = 792,
		bl_icon_BRUSH_LIGHTEN = 793,
		bl_icon_BRUSH_MASK = 794,
		bl_icon_BRUSH_MIX = 795,
		bl_icon_BRUSH_MULTIPLY = 796,
		bl_icon_BRUSH_NUDGE = 797,
		bl_icon_BRUSH_PINCH = 798,
		bl_icon_BRUSH_SCRAPE = 799,
		bl_icon_BRUSH_SCULPT_DRAW = 800,
		bl_icon_BRUSH_SMEAR = 801,
		bl_icon_BRUSH_SMOOTH = 802,
		bl_icon_BRUSH_SNAKE_HOOK = 803,
		bl_icon_BRUSH_SOFTEN = 804,
		bl_icon_BRUSH_SUBTRACT = 805,
		bl_icon_BRUSH_TEXDRAW = 806,
		bl_icon_BRUSH_TEXFILL = 807,
		bl_icon_BRUSH_TEXMASK = 808,
		bl_icon_BRUSH_THUMB = 809,
		bl_icon_BRUSH_ROTATE = 810,
		bl_icon_BRUSH_VERTEXDRAW = 811,
		bl_icon_MATCAP_01 = 812,
		bl_icon_MATCAP_02 = 813,
		bl_icon_MATCAP_03 = 814,
		bl_icon_MATCAP_04 = 815,
		bl_icon_MATCAP_05 = 816,
		bl_icon_MATCAP_06 = 817,
		bl_icon_MATCAP_07 = 818,
		bl_icon_MATCAP_08 = 819,
		bl_icon_MATCAP_09 = 820,
		bl_icon_MATCAP_10 = 821,
		bl_icon_MATCAP_11 = 822,
		bl_icon_MATCAP_12 = 823,
		bl_icon_MATCAP_13 = 824,
		bl_icon_MATCAP_14 = 825,
		bl_icon_MATCAP_15 = 826,
		bl_icon_MATCAP_16 = 827,
		bl_icon_MATCAP_17 = 828,
		bl_icon_MATCAP_18 = 829,
		bl_icon_MATCAP_19 = 830,
		bl_icon_MATCAP_20 = 831,
		bl_icon_MATCAP_21 = 832,
		bl_icon_MATCAP_22 = 833,
		bl_icon_MATCAP_23 = 834,
		bl_icon_MATCAP_24 = 835,
	};
	inline bl_icon_enum bl_icon(void);
	inline void bl_icon(bl_icon_enum value);

	inline void interface_update(Context context);
};

/**************** NodeSocketStandard ****************/

class NodeSocketStandard : public NodeSocket {
public:
	NodeSocketStandard(const PointerRNA &ptr_arg) :
		NodeSocket(ptr_arg)
		{}


	inline void draw(Context context, UILayout layout, Node node, const char * text);
	inline void draw_color(Context context, Node node, float color[4]);
};

/**************** NodeSocketInterfaceStandard ****************/

class NodeSocketInterfaceStandard : public NodeSocketInterface {
public:
	NodeSocketInterfaceStandard(const PointerRNA &ptr_arg) :
		NodeSocketInterface(ptr_arg)
		{}

	enum type_enum {
		type_CUSTOM = -1,
		type_VALUE = 0,
		type_INT = 6,
		type_BOOLEAN = 4,
		type_VECTOR = 1,
		type_STRING = 7,
		type_RGBA = 2,
		type_SHADER = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);

	inline void draw(Context context, UILayout layout);
	inline void draw_color(Context context, float color[4]);
};

/**************** Float Node Socket ****************/

class NodeSocketFloat : public NodeSocketStandard {
public:
	NodeSocketFloat(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);

};

/**************** Float Node Socket Interface ****************/

class NodeSocketInterfaceFloat : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceFloat(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Float Node Socket ****************/

class NodeSocketFloatUnsigned : public NodeSocketStandard {
public:
	NodeSocketFloatUnsigned(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);

};

/**************** Float Node Socket Interface ****************/

class NodeSocketInterfaceFloatUnsigned : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceFloatUnsigned(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Float Node Socket ****************/

class NodeSocketFloatPercentage : public NodeSocketStandard {
public:
	NodeSocketFloatPercentage(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);

};

/**************** Float Node Socket Interface ****************/

class NodeSocketInterfaceFloatPercentage : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceFloatPercentage(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Float Node Socket ****************/

class NodeSocketFloatFactor : public NodeSocketStandard {
public:
	NodeSocketFloatFactor(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);

};

/**************** Float Node Socket Interface ****************/

class NodeSocketInterfaceFloatFactor : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceFloatFactor(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Float Node Socket ****************/

class NodeSocketFloatAngle : public NodeSocketStandard {
public:
	NodeSocketFloatAngle(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);

};

/**************** Float Node Socket Interface ****************/

class NodeSocketInterfaceFloatAngle : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceFloatAngle(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Float Node Socket ****************/

class NodeSocketFloatTime : public NodeSocketStandard {
public:
	NodeSocketFloatTime(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);

};

/**************** Float Node Socket Interface ****************/

class NodeSocketInterfaceFloatTime : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceFloatTime(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Integer Node Socket ****************/

class NodeSocketInt : public NodeSocketStandard {
public:
	NodeSocketInt(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);

};

/**************** Integer Node Socket Interface ****************/

class NodeSocketInterfaceInt : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceInt(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);
	inline int min_value(void);
	inline void min_value(int value);
	inline int max_value(void);
	inline void max_value(int value);

};

/**************** Integer Node Socket ****************/

class NodeSocketIntUnsigned : public NodeSocketStandard {
public:
	NodeSocketIntUnsigned(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);

};

/**************** Integer Node Socket Interface ****************/

class NodeSocketInterfaceIntUnsigned : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceIntUnsigned(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);
	inline int min_value(void);
	inline void min_value(int value);
	inline int max_value(void);
	inline void max_value(int value);

};

/**************** Integer Node Socket ****************/

class NodeSocketIntPercentage : public NodeSocketStandard {
public:
	NodeSocketIntPercentage(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);

};

/**************** Integer Node Socket Interface ****************/

class NodeSocketInterfaceIntPercentage : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceIntPercentage(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);
	inline int min_value(void);
	inline void min_value(int value);
	inline int max_value(void);
	inline void max_value(int value);

};

/**************** Integer Node Socket ****************/

class NodeSocketIntFactor : public NodeSocketStandard {
public:
	NodeSocketIntFactor(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);

};

/**************** Integer Node Socket Interface ****************/

class NodeSocketInterfaceIntFactor : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceIntFactor(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);
	inline int min_value(void);
	inline void min_value(int value);
	inline int max_value(void);
	inline void max_value(int value);

};

/**************** Boolean Node Socket ****************/

class NodeSocketBool : public NodeSocketStandard {
public:
	NodeSocketBool(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline bool default_value(void);
	inline void default_value(int value);

};

/**************** Boolean Node Socket Interface ****************/

class NodeSocketInterfaceBool : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceBool(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline bool default_value(void);
	inline void default_value(int value);

};

/**************** Vector Node Socket ****************/

class NodeSocketVector : public NodeSocketStandard {
public:
	NodeSocketVector(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);

};

/**************** Vector Node Socket Interface ****************/

class NodeSocketInterfaceVector : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceVector(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Vector Node Socket ****************/

class NodeSocketVectorTranslation : public NodeSocketStandard {
public:
	NodeSocketVectorTranslation(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);

};

/**************** Vector Node Socket Interface ****************/

class NodeSocketInterfaceVectorTranslation : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceVectorTranslation(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Vector Node Socket ****************/

class NodeSocketVectorDirection : public NodeSocketStandard {
public:
	NodeSocketVectorDirection(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);

};

/**************** Vector Node Socket Interface ****************/

class NodeSocketInterfaceVectorDirection : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceVectorDirection(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Vector Node Socket ****************/

class NodeSocketVectorVelocity : public NodeSocketStandard {
public:
	NodeSocketVectorVelocity(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);

};

/**************** Vector Node Socket Interface ****************/

class NodeSocketInterfaceVectorVelocity : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceVectorVelocity(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Vector Node Socket ****************/

class NodeSocketVectorAcceleration : public NodeSocketStandard {
public:
	NodeSocketVectorAcceleration(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);

};

/**************** Vector Node Socket Interface ****************/

class NodeSocketInterfaceVectorAcceleration : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceVectorAcceleration(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Vector Node Socket ****************/

class NodeSocketVectorEuler : public NodeSocketStandard {
public:
	NodeSocketVectorEuler(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);

};

/**************** Vector Node Socket Interface ****************/

class NodeSocketInterfaceVectorEuler : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceVectorEuler(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Vector Node Socket ****************/

class NodeSocketVectorXYZ : public NodeSocketStandard {
public:
	NodeSocketVectorXYZ(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);

};

/**************** Vector Node Socket Interface ****************/

class NodeSocketInterfaceVectorXYZ : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceVectorXYZ(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline Array<float, 3> default_value(void);
	inline void default_value(float values[3]);
	inline float min_value(void);
	inline void min_value(float value);
	inline float max_value(void);
	inline void max_value(float value);

};

/**************** Color Node Socket ****************/

class NodeSocketColor : public NodeSocketStandard {
public:
	NodeSocketColor(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline Array<float, 4> default_value(void);
	inline void default_value(float values[4]);

};

/**************** Color Node Socket Interface ****************/

class NodeSocketInterfaceColor : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceColor(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline Array<float, 4> default_value(void);
	inline void default_value(float values[4]);

};

/**************** String Node Socket ****************/

class NodeSocketString : public NodeSocketStandard {
public:
	NodeSocketString(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}

	inline std::string default_value(void);	inline void default_value(const std::string& value);

};

/**************** String Node Socket Interface ****************/

class NodeSocketInterfaceString : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceString(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}

	inline std::string default_value(void);	inline void default_value(const std::string& value);

};

/**************** Shader Node Socket ****************/

class NodeSocketShader : public NodeSocketStandard {
public:
	NodeSocketShader(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}


};

/**************** Shader Node Socket Interface ****************/

class NodeSocketInterfaceShader : public NodeSocketInterfaceStandard {
public:
	NodeSocketInterfaceShader(const PointerRNA &ptr_arg) :
		NodeSocketInterfaceStandard(ptr_arg)
		{}


};

/**************** Virtual Node Socket ****************/

class NodeSocketVirtual : public NodeSocketStandard {
public:
	NodeSocketVirtual(const PointerRNA &ptr_arg) :
		NodeSocketStandard(ptr_arg)
		{}


};

/**************** Compositor Node Tree ****************/

class CompositorNodeTree : public NodeTree {
public:
	CompositorNodeTree(const PointerRNA &ptr_arg) :
		NodeTree(ptr_arg)
		{}

	enum render_quality_enum {
		render_quality_HIGH = 0,
		render_quality_MEDIUM = 1,
		render_quality_LOW = 2,
	};
	inline render_quality_enum render_quality(void);
	inline void render_quality(render_quality_enum value);
	enum edit_quality_enum {
		edit_quality_HIGH = 0,
		edit_quality_MEDIUM = 1,
		edit_quality_LOW = 2,
	};
	inline edit_quality_enum edit_quality(void);
	inline void edit_quality(edit_quality_enum value);
	enum chunk_size_enum {
		chunk_size_32 = 32,
		chunk_size_64 = 64,
		chunk_size_128 = 128,
		chunk_size_256 = 256,
		chunk_size_512 = 512,
		chunk_size_1024 = 1024,
	};
	inline chunk_size_enum chunk_size(void);
	inline void chunk_size(chunk_size_enum value);
	inline bool use_opencl(void);
	inline void use_opencl(int value);
	inline bool use_groupnode_buffer(void);
	inline void use_groupnode_buffer(int value);
	inline bool use_two_pass(void);
	inline void use_two_pass(int value);
	inline bool use_viewer_border(void);
	inline void use_viewer_border(int value);

};

/**************** Shader Node Tree ****************/

class ShaderNodeTree : public NodeTree {
public:
	ShaderNodeTree(const PointerRNA &ptr_arg) :
		NodeTree(ptr_arg)
		{}


};

/**************** Texture Node Tree ****************/

class TextureNodeTree : public NodeTree {
public:
	TextureNodeTree(const PointerRNA &ptr_arg) :
		NodeTree(ptr_arg)
		{}


};

/**************** Frame ****************/

class NodeFrame : public NodeInternal {
public:
	NodeFrame(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}

	inline bool shrink(void);
	inline void shrink(int value);
	inline int label_size(void);
	inline void label_size(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Group ****************/

class NodeGroup : public NodeInternal {
public:
	NodeGroup(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}

	inline NodeTree node_tree(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Group Input ****************/

class NodeGroupInput : public NodeInternal {
public:
	NodeGroupInput(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Group Output ****************/

class NodeGroupOutput : public NodeInternal {
public:
	NodeGroupOutput(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Reroute ****************/

class NodeReroute : public NodeInternal {
public:
	NodeReroute(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Output ****************/

class ShaderNodeOutput : public ShaderNode {
public:
	ShaderNodeOutput(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Material ****************/

class ShaderNodeMaterial : public ShaderNode {
public:
	ShaderNodeMaterial(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Material material(void);
	inline bool use_diffuse(void);
	inline void use_diffuse(int value);
	inline bool use_specular(void);
	inline void use_specular(int value);
	inline bool invert_normal(void);
	inline void invert_normal(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** RGB ****************/

class ShaderNodeRGB : public ShaderNode {
public:
	ShaderNodeRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Value ****************/

class ShaderNodeValue : public ShaderNode {
public:
	ShaderNodeValue(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** MixRGB ****************/

class ShaderNodeMixRGB : public ShaderNode {
public:
	ShaderNodeMixRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_ADD = 1,
		blend_type_MULTIPLY = 2,
		blend_type_SUBTRACT = 3,
		blend_type_SCREEN = 4,
		blend_type_DIVIDE = 5,
		blend_type_DIFFERENCE = 6,
		blend_type_DARKEN = 7,
		blend_type_LIGHTEN = 8,
		blend_type_OVERLAY = 9,
		blend_type_DODGE = 10,
		blend_type_BURN = 11,
		blend_type_HUE = 12,
		blend_type_SATURATION = 13,
		blend_type_VALUE = 14,
		blend_type_COLOR = 15,
		blend_type_SOFT_LIGHT = 16,
		blend_type_LINEAR_LIGHT = 17,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool use_alpha(void);
	inline void use_alpha(int value);
	inline bool use_clamp(void);
	inline void use_clamp(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ColorRamp ****************/

class ShaderNodeValToRGB : public ShaderNode {
public:
	ShaderNodeValToRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline ColorRamp color_ramp(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** RGB to BW ****************/

class ShaderNodeRGBToBW : public ShaderNode {
public:
	ShaderNodeRGBToBW(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Texture ****************/

class ShaderNodeTexture : public ShaderNode {
public:
	ShaderNodeTexture(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Texture texture(void);
	inline int node_output(void);
	inline void node_output(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Normal ****************/

class ShaderNodeNormal : public ShaderNode {
public:
	ShaderNodeNormal(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Gamma ****************/

class ShaderNodeGamma : public ShaderNode {
public:
	ShaderNodeGamma(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Bright Contrast ****************/

class ShaderNodeBrightContrast : public ShaderNode {
public:
	ShaderNodeBrightContrast(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Geometry ****************/

class ShaderNodeGeometry : public ShaderNode {
public:
	ShaderNodeGeometry(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	inline std::string color_layer(void);	inline void color_layer(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Mapping ****************/

class ShaderNodeMapping : public ShaderNode {
public:
	ShaderNodeMapping(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum vector_type_enum {
		vector_type_TEXTURE = 1,
		vector_type_POINT = 0,
		vector_type_VECTOR = 2,
		vector_type_NORMAL = 3,
	};
	inline vector_type_enum vector_type(void);
	inline void vector_type(vector_type_enum value);
	inline Array<float, 3> translation(void);
	inline void translation(float values[3]);
	inline Array<float, 3> rotation(void);
	inline void rotation(float values[3]);
	inline Array<float, 3> scale(void);
	inline void scale(float values[3]);
	inline Array<float, 3> min(void);
	inline void min(float values[3]);
	inline Array<float, 3> max(void);
	inline void max(float values[3]);
	inline bool use_min(void);
	inline void use_min(int value);
	inline bool use_max(void);
	inline void use_max(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Vector Curves ****************/

class ShaderNodeVectorCurve : public ShaderNode {
public:
	ShaderNodeVectorCurve(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** RGB Curves ****************/

class ShaderNodeRGBCurve : public ShaderNode {
public:
	ShaderNodeRGBCurve(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Camera Data ****************/

class ShaderNodeCameraData : public ShaderNode {
public:
	ShaderNodeCameraData(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Lamp Data ****************/

class ShaderNodeLampData : public ShaderNode {
public:
	ShaderNodeLampData(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Object lamp_object(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Math ****************/

class ShaderNodeMath : public ShaderNode {
public:
	ShaderNodeMath(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum operation_enum {
		operation_ADD = 0,
		operation_SUBTRACT = 1,
		operation_MULTIPLY = 2,
		operation_DIVIDE = 3,
		operation_SINE = 4,
		operation_COSINE = 5,
		operation_TANGENT = 6,
		operation_ARCSINE = 7,
		operation_ARCCOSINE = 8,
		operation_ARCTANGENT = 9,
		operation_POWER = 10,
		operation_LOGARITHM = 11,
		operation_MINIMUM = 12,
		operation_MAXIMUM = 13,
		operation_ROUND = 14,
		operation_LESS_THAN = 15,
		operation_GREATER_THAN = 16,
		operation_MODULO = 17,
		operation_ABSOLUTE = 18,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);
	inline bool use_clamp(void);
	inline void use_clamp(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Vector Math ****************/

class ShaderNodeVectorMath : public ShaderNode {
public:
	ShaderNodeVectorMath(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum operation_enum {
		operation_ADD = 0,
		operation_SUBTRACT = 1,
		operation_AVERAGE = 2,
		operation_DOT_PRODUCT = 3,
		operation_CROSS_PRODUCT = 4,
		operation_NORMALIZE = 5,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Squeeze Value ****************/

class ShaderNodeSqueeze : public ShaderNode {
public:
	ShaderNodeSqueeze(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Extended Material ****************/

class ShaderNodeExtendedMaterial : public ShaderNode {
public:
	ShaderNodeExtendedMaterial(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Material material(void);
	inline bool use_diffuse(void);
	inline void use_diffuse(int value);
	inline bool use_specular(void);
	inline void use_specular(int value);
	inline bool invert_normal(void);
	inline void invert_normal(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Invert ****************/

class ShaderNodeInvert : public ShaderNode {
public:
	ShaderNodeInvert(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Separate RGB ****************/

class ShaderNodeSeparateRGB : public ShaderNode {
public:
	ShaderNodeSeparateRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Combine RGB ****************/

class ShaderNodeCombineRGB : public ShaderNode {
public:
	ShaderNodeCombineRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Hue/Saturation ****************/

class ShaderNodeHueSaturation : public ShaderNode {
public:
	ShaderNodeHueSaturation(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Material Output ****************/

class ShaderNodeOutputMaterial : public ShaderNode {
public:
	ShaderNodeOutputMaterial(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Lamp Output ****************/

class ShaderNodeOutputLamp : public ShaderNode {
public:
	ShaderNodeOutputLamp(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** World Output ****************/

class ShaderNodeOutputWorld : public ShaderNode {
public:
	ShaderNodeOutputWorld(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Line Style Output ****************/

class ShaderNodeOutputLineStyle : public ShaderNode {
public:
	ShaderNodeOutputLineStyle(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(int value);
	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_ADD = 1,
		blend_type_MULTIPLY = 2,
		blend_type_SUBTRACT = 3,
		blend_type_SCREEN = 4,
		blend_type_DIVIDE = 5,
		blend_type_DIFFERENCE = 6,
		blend_type_DARKEN = 7,
		blend_type_LIGHTEN = 8,
		blend_type_OVERLAY = 9,
		blend_type_DODGE = 10,
		blend_type_BURN = 11,
		blend_type_HUE = 12,
		blend_type_SATURATION = 13,
		blend_type_VALUE = 14,
		blend_type_COLOR = 15,
		blend_type_SOFT_LIGHT = 16,
		blend_type_LINEAR_LIGHT = 17,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool use_alpha(void);
	inline void use_alpha(int value);
	inline bool use_clamp(void);
	inline void use_clamp(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Fresnel ****************/

class ShaderNodeFresnel : public ShaderNode {
public:
	ShaderNodeFresnel(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Layer Weight ****************/

class ShaderNodeLayerWeight : public ShaderNode {
public:
	ShaderNodeLayerWeight(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Mix Shader ****************/

class ShaderNodeMixShader : public ShaderNode {
public:
	ShaderNodeMixShader(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Add Shader ****************/

class ShaderNodeAddShader : public ShaderNode {
public:
	ShaderNodeAddShader(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Attribute ****************/

class ShaderNodeAttribute : public ShaderNode {
public:
	ShaderNodeAttribute(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline std::string attribute_name(void);	inline void attribute_name(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Ambient Occlusion ****************/

class ShaderNodeAmbientOcclusion : public ShaderNode {
public:
	ShaderNodeAmbientOcclusion(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Background ****************/

class ShaderNodeBackground : public ShaderNode {
public:
	ShaderNodeBackground(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Holdout ****************/

class ShaderNodeHoldout : public ShaderNode {
public:
	ShaderNodeHoldout(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Anisotropic BSDF ****************/

class ShaderNodeBsdfAnisotropic : public ShaderNode {
public:
	ShaderNodeBsdfAnisotropic(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_BECKMANN = 0,
		distribution_GGX = 2,
		distribution_ASHIKHMIN_SHIRLEY = 3,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Diffuse BSDF ****************/

class ShaderNodeBsdfDiffuse : public ShaderNode {
public:
	ShaderNodeBsdfDiffuse(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Glossy BSDF ****************/

class ShaderNodeBsdfGlossy : public ShaderNode {
public:
	ShaderNodeBsdfGlossy(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_SHARP = 1,
		distribution_BECKMANN = 0,
		distribution_GGX = 2,
		distribution_ASHIKHMIN_SHIRLEY = 3,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Glass BSDF ****************/

class ShaderNodeBsdfGlass : public ShaderNode {
public:
	ShaderNodeBsdfGlass(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_SHARP = 1,
		distribution_BECKMANN = 0,
		distribution_GGX = 2,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Refraction BSDF ****************/

class ShaderNodeBsdfRefraction : public ShaderNode {
public:
	ShaderNodeBsdfRefraction(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_SHARP = 1,
		distribution_BECKMANN = 0,
		distribution_GGX = 2,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Translucent BSDF ****************/

class ShaderNodeBsdfTranslucent : public ShaderNode {
public:
	ShaderNodeBsdfTranslucent(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Transparent BSDF ****************/

class ShaderNodeBsdfTransparent : public ShaderNode {
public:
	ShaderNodeBsdfTransparent(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Velvet BSDF ****************/

class ShaderNodeBsdfVelvet : public ShaderNode {
public:
	ShaderNodeBsdfVelvet(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Toon BSDF ****************/

class ShaderNodeBsdfToon : public ShaderNode {
public:
	ShaderNodeBsdfToon(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum component_enum {
		component_DIFFUSE = 0,
		component_GLOSSY = 1,
	};
	inline component_enum component(void);
	inline void component(component_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Hair BSDF ****************/

class ShaderNodeBsdfHair : public ShaderNode {
public:
	ShaderNodeBsdfHair(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum component_enum {
		component_Reflection = 0,
		component_Transmission = 1,
	};
	inline component_enum component(void);
	inline void component(component_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Subsurface Scattering ****************/

class ShaderNodeSubsurfaceScattering : public ShaderNode {
public:
	ShaderNodeSubsurfaceScattering(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum falloff_enum {
		falloff_CUBIC = 1,
		falloff_GAUSSIAN = 2,
	};
	inline falloff_enum falloff(void);
	inline void falloff(falloff_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Volume Absorption ****************/

class ShaderNodeVolumeAbsorption : public ShaderNode {
public:
	ShaderNodeVolumeAbsorption(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Volume Scatter ****************/

class ShaderNodeVolumeScatter : public ShaderNode {
public:
	ShaderNodeVolumeScatter(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Emission ****************/

class ShaderNodeEmission : public ShaderNode {
public:
	ShaderNodeEmission(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Geometry ****************/

class ShaderNodeNewGeometry : public ShaderNode {
public:
	ShaderNodeNewGeometry(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Light Path ****************/

class ShaderNodeLightPath : public ShaderNode {
public:
	ShaderNodeLightPath(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Light Falloff ****************/

class ShaderNodeLightFalloff : public ShaderNode {
public:
	ShaderNodeLightFalloff(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Object Info ****************/

class ShaderNodeObjectInfo : public ShaderNode {
public:
	ShaderNodeObjectInfo(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Particle Info ****************/

class ShaderNodeParticleInfo : public ShaderNode {
public:
	ShaderNodeParticleInfo(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Hair Info ****************/

class ShaderNodeHairInfo : public ShaderNode {
public:
	ShaderNodeHairInfo(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Wireframe ****************/

class ShaderNodeWireframe : public ShaderNode {
public:
	ShaderNodeWireframe(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool use_pixel_size(void);
	inline void use_pixel_size(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Wavelength ****************/

class ShaderNodeWavelength : public ShaderNode {
public:
	ShaderNodeWavelength(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Blackbody ****************/

class ShaderNodeBlackbody : public ShaderNode {
public:
	ShaderNodeBlackbody(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Bump ****************/

class ShaderNodeBump : public ShaderNode {
public:
	ShaderNodeBump(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool invert(void);
	inline void invert(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Normal Map ****************/

class ShaderNodeNormalMap : public ShaderNode {
public:
	ShaderNodeNormalMap(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum space_enum {
		space_TANGENT = 0,
		space_OBJECT = 1,
		space_WORLD = 2,
		space_BLENDER_OBJECT = 3,
		space_BLENDER_WORLD = 4,
	};
	inline space_enum space(void);
	inline void space(space_enum value);
	inline std::string uv_map(void);	inline void uv_map(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Tangent ****************/

class ShaderNodeTangent : public ShaderNode {
public:
	ShaderNodeTangent(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum direction_type_enum {
		direction_type_RADIAL = 0,
		direction_type_UV_MAP = 1,
	};
	inline direction_type_enum direction_type(void);
	inline void direction_type(direction_type_enum value);
	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
		axis_Z = 2,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	inline std::string uv_map(void);	inline void uv_map(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Script ****************/

class ShaderNodeScript : public ShaderNode {
public:
	ShaderNodeScript(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Text script(void);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	enum mode_enum {
		mode_INTERNAL = 0,
		mode_EXTERNAL = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool use_auto_update(void);
	inline void use_auto_update(int value);
	inline std::string bytecode(void);	inline void bytecode(const std::string& value);
	inline std::string bytecode_hash(void);	inline void bytecode_hash(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Image Texture ****************/

class ShaderNodeTexImage : public ShaderNode {
public:
	ShaderNodeTexImage(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Image image(void);
	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum color_space_enum {
		color_space_COLOR = 1,
		color_space_NONE = 0,
	};
	inline color_space_enum color_space(void);
	inline void color_space(color_space_enum value);
	enum projection_enum {
		projection_FLAT = 0,
		projection_BOX = 1,
	};
	inline projection_enum projection(void);
	inline void projection(projection_enum value);
	enum interpolation_enum {
		interpolation_Linear = 0,
		interpolation_Closest = 1,
		interpolation_Cubic = 2,
		interpolation_Smart = 3,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	inline float projection_blend(void);
	inline void projection_blend(float value);
	inline ImageUser image_user(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Environment Texture ****************/

class ShaderNodeTexEnvironment : public ShaderNode {
public:
	ShaderNodeTexEnvironment(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Image image(void);
	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum color_space_enum {
		color_space_COLOR = 1,
		color_space_NONE = 0,
	};
	inline color_space_enum color_space(void);
	inline void color_space(color_space_enum value);
	enum projection_enum {
		projection_EQUIRECTANGULAR = 0,
		projection_MIRROR_BALL = 1,
	};
	inline projection_enum projection(void);
	inline void projection(projection_enum value);
	inline ImageUser image_user(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Sky Texture ****************/

class ShaderNodeTexSky : public ShaderNode {
public:
	ShaderNodeTexSky(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum sky_type_enum {
		sky_type_PREETHAM = 0,
		sky_type_HOSEK_WILKIE = 1,
	};
	inline sky_type_enum sky_type(void);
	inline void sky_type(sky_type_enum value);
	inline Array<float, 3> sun_direction(void);
	inline void sun_direction(float values[3]);
	inline float turbidity(void);
	inline void turbidity(float value);
	inline float ground_albedo(void);
	inline void ground_albedo(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Gradient Texture ****************/

class ShaderNodeTexGradient : public ShaderNode {
public:
	ShaderNodeTexGradient(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum gradient_type_enum {
		gradient_type_LINEAR = 0,
		gradient_type_QUADRATIC = 1,
		gradient_type_EASING = 2,
		gradient_type_DIAGONAL = 3,
		gradient_type_SPHERICAL = 6,
		gradient_type_QUADRATIC_SPHERE = 5,
		gradient_type_RADIAL = 4,
	};
	inline gradient_type_enum gradient_type(void);
	inline void gradient_type(gradient_type_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Noise Texture ****************/

class ShaderNodeTexNoise : public ShaderNode {
public:
	ShaderNodeTexNoise(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Magic Texture ****************/

class ShaderNodeTexMagic : public ShaderNode {
public:
	ShaderNodeTexMagic(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	inline int turbulence_depth(void);
	inline void turbulence_depth(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Wave Texture ****************/

class ShaderNodeTexWave : public ShaderNode {
public:
	ShaderNodeTexWave(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum wave_type_enum {
		wave_type_BANDS = 0,
		wave_type_RINGS = 1,
	};
	inline wave_type_enum wave_type(void);
	inline void wave_type(wave_type_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Musgrave Texture ****************/

class ShaderNodeTexMusgrave : public ShaderNode {
public:
	ShaderNodeTexMusgrave(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum musgrave_type_enum {
		musgrave_type_MULTIFRACTAL = 0,
		musgrave_type_RIDGED_MULTIFRACTAL = 3,
		musgrave_type_HYBRID_MULTIFRACTAL = 2,
		musgrave_type_FBM = 1,
		musgrave_type_HETERO_TERRAIN = 4,
	};
	inline musgrave_type_enum musgrave_type(void);
	inline void musgrave_type(musgrave_type_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Voronoi Texture ****************/

class ShaderNodeTexVoronoi : public ShaderNode {
public:
	ShaderNodeTexVoronoi(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum coloring_enum {
		coloring_INTENSITY = 0,
		coloring_CELLS = 1,
	};
	inline coloring_enum coloring(void);
	inline void coloring(coloring_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Checker Texture ****************/

class ShaderNodeTexChecker : public ShaderNode {
public:
	ShaderNodeTexChecker(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Brick Texture ****************/

class ShaderNodeTexBrick : public ShaderNode {
public:
	ShaderNodeTexBrick(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	inline int offset_frequency(void);
	inline void offset_frequency(int value);
	inline int squash_frequency(void);
	inline void squash_frequency(int value);
	inline float offset(void);
	inline void offset(float value);
	inline float squash(void);
	inline void squash(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Texture Coordinate ****************/

class ShaderNodeTexCoord : public ShaderNode {
public:
	ShaderNodeTexCoord(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool from_dupli(void);
	inline void from_dupli(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Vector Transform ****************/

class ShaderNodeVectorTransform : public ShaderNode {
public:
	ShaderNodeVectorTransform(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum vector_type_enum {
		vector_type_POINT = 1,
		vector_type_VECTOR = 0,
		vector_type_NORMAL = 2,
	};
	inline vector_type_enum vector_type(void);
	inline void vector_type(vector_type_enum value);
	enum convert_from_enum {
		convert_from_WORLD = 0,
		convert_from_OBJECT = 1,
		convert_from_CAMERA = 2,
	};
	inline convert_from_enum convert_from(void);
	inline void convert_from(convert_from_enum value);
	enum convert_to_enum {
		convert_to_WORLD = 0,
		convert_to_OBJECT = 1,
		convert_to_CAMERA = 2,
	};
	inline convert_to_enum convert_to(void);
	inline void convert_to(convert_to_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Separate HSV ****************/

class ShaderNodeSeparateHSV : public ShaderNode {
public:
	ShaderNodeSeparateHSV(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Combine HSV ****************/

class ShaderNodeCombineHSV : public ShaderNode {
public:
	ShaderNodeCombineHSV(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** UV Map ****************/

class ShaderNodeUVMap : public ShaderNode {
public:
	ShaderNodeUVMap(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool from_dupli(void);
	inline void from_dupli(int value);
	inline std::string uv_map(void);	inline void uv_map(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** UV Along Stroke ****************/

class ShaderNodeUVAlongStroke : public ShaderNode {
public:
	ShaderNodeUVAlongStroke(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool use_tips(void);
	inline void use_tips(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Separate XYZ ****************/

class ShaderNodeSeparateXYZ : public ShaderNode {
public:
	ShaderNodeSeparateXYZ(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Combine XYZ ****************/

class ShaderNodeCombineXYZ : public ShaderNode {
public:
	ShaderNodeCombineXYZ(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Viewer ****************/

class CompositorNodeViewer : public CompositorNode {
public:
	CompositorNodeViewer(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum tile_order_enum {
		tile_order_CENTEROUT = 0,
		tile_order_RANDOM = 1,
		tile_order_BOTTOMUP = 2,
		tile_order_RULE_OF_THIRDS = 3,
	};
	inline tile_order_enum tile_order(void);
	inline void tile_order(tile_order_enum value);
	inline float center_x(void);
	inline void center_x(float value);
	inline float center_y(void);
	inline void center_y(float value);
	inline bool use_alpha(void);
	inline void use_alpha(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** RGB ****************/

class CompositorNodeRGB : public CompositorNode {
public:
	CompositorNodeRGB(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Value ****************/

class CompositorNodeValue : public CompositorNode {
public:
	CompositorNodeValue(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Mix ****************/

class CompositorNodeMixRGB : public CompositorNode {
public:
	CompositorNodeMixRGB(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_ADD = 1,
		blend_type_MULTIPLY = 2,
		blend_type_SUBTRACT = 3,
		blend_type_SCREEN = 4,
		blend_type_DIVIDE = 5,
		blend_type_DIFFERENCE = 6,
		blend_type_DARKEN = 7,
		blend_type_LIGHTEN = 8,
		blend_type_OVERLAY = 9,
		blend_type_DODGE = 10,
		blend_type_BURN = 11,
		blend_type_HUE = 12,
		blend_type_SATURATION = 13,
		blend_type_VALUE = 14,
		blend_type_COLOR = 15,
		blend_type_SOFT_LIGHT = 16,
		blend_type_LINEAR_LIGHT = 17,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool use_alpha(void);
	inline void use_alpha(int value);
	inline bool use_clamp(void);
	inline void use_clamp(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ColorRamp ****************/

class CompositorNodeValToRGB : public CompositorNode {
public:
	CompositorNodeValToRGB(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline ColorRamp color_ramp(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** RGB to BW ****************/

class CompositorNodeRGBToBW : public CompositorNode {
public:
	CompositorNodeRGBToBW(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Normal ****************/

class CompositorNodeNormal : public CompositorNode {
public:
	CompositorNodeNormal(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Vector Curves ****************/

class CompositorNodeCurveVec : public CompositorNode {
public:
	CompositorNodeCurveVec(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** RGB Curves ****************/

class CompositorNodeCurveRGB : public CompositorNode {
public:
	CompositorNodeCurveRGB(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Alpha Over ****************/

class CompositorNodeAlphaOver : public CompositorNode {
public:
	CompositorNodeAlphaOver(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_premultiply(void);
	inline void use_premultiply(int value);
	inline float premul(void);
	inline void premul(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Blur ****************/

class CompositorNodeBlur : public CompositorNode {
public:
	CompositorNodeBlur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_variable_size(void);
	inline void use_variable_size(int value);
	inline int size_x(void);
	inline void size_x(int value);
	inline int size_y(void);
	inline void size_y(int value);
	inline bool use_relative(void);
	inline void use_relative(int value);
	enum aspect_correction_enum {
		aspect_correction_NONE = 0,
		aspect_correction_Y = 1,
		aspect_correction_X = 2,
	};
	inline aspect_correction_enum aspect_correction(void);
	inline void aspect_correction(aspect_correction_enum value);
	inline float factor(void);
	inline void factor(float value);
	inline float factor_x(void);
	inline void factor_x(float value);
	inline float factor_y(void);
	inline void factor_y(float value);
	enum filter_type_enum {
		filter_type_FLAT = 0,
		filter_type_TENT = 1,
		filter_type_QUAD = 2,
		filter_type_CUBIC = 3,
		filter_type_GAUSS = 5,
		filter_type_FAST_GAUSS = 7,
		filter_type_CATROM = 4,
		filter_type_MITCH = 6,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);
	inline bool use_bokeh(void);
	inline void use_bokeh(int value);
	inline bool use_gamma_correction(void);
	inline void use_gamma_correction(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Filter ****************/

class CompositorNodeFilter : public CompositorNode {
public:
	CompositorNodeFilter(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum filter_type_enum {
		filter_type_SOFTEN = 0,
		filter_type_SHARPEN = 1,
		filter_type_LAPLACE = 2,
		filter_type_SOBEL = 3,
		filter_type_PREWITT = 4,
		filter_type_KIRSCH = 5,
		filter_type_SHADOW = 6,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Map Value ****************/

class CompositorNodeMapValue : public CompositorNode {
public:
	CompositorNodeMapValue(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Array<float, 1> offset(void);
	inline void offset(float values[1]);
	inline Array<float, 1> size(void);
	inline void size(float values[1]);
	inline bool use_min(void);
	inline void use_min(int value);
	inline bool use_max(void);
	inline void use_max(int value);
	inline Array<float, 1> min(void);
	inline void min(float values[1]);
	inline Array<float, 1> max(void);
	inline void max(float values[1]);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Map Range ****************/

class CompositorNodeMapRange : public CompositorNode {
public:
	CompositorNodeMapRange(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_clamp(void);
	inline void use_clamp(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Time ****************/

class CompositorNodeTime : public CompositorNode {
public:
	CompositorNodeTime(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline CurveMapping curve(void);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Vector Blur ****************/

class CompositorNodeVecBlur : public CompositorNode {
public:
	CompositorNodeVecBlur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int samples(void);
	inline void samples(int value);
	inline int speed_min(void);
	inline void speed_min(int value);
	inline int speed_max(void);
	inline void speed_max(int value);
	inline float factor(void);
	inline void factor(float value);
	inline bool use_curved(void);
	inline void use_curved(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Separate RGBA ****************/

class CompositorNodeSepRGBA : public CompositorNode {
public:
	CompositorNodeSepRGBA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Separate HSVA ****************/

class CompositorNodeSepHSVA : public CompositorNode {
public:
	CompositorNodeSepHSVA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Set Alpha ****************/

class CompositorNodeSetAlpha : public CompositorNode {
public:
	CompositorNodeSetAlpha(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Hue Saturation Value ****************/

class CompositorNodeHueSat : public CompositorNode {
public:
	CompositorNodeHueSat(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float color_hue(void);
	inline void color_hue(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float color_value(void);
	inline void color_value(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Image ****************/

class CompositorNodeImage : public CompositorNode {
public:
	CompositorNodeImage(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Image image(void);
	inline bool use_straight_alpha_output(void);
	inline void use_straight_alpha_output(int value);
	inline int frame_duration(void);
	inline void frame_duration(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_offset(void);
	inline void frame_offset(int value);
	inline bool use_cyclic(void);
	inline void use_cyclic(int value);
	inline bool use_auto_refresh(void);
	inline void use_auto_refresh(int value);
	enum layer_enum {
		layer_PLACEHOLDER = 0,
	};
	inline layer_enum layer(void);
	inline void layer(layer_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Render Layers ****************/

class CompositorNodeRLayers : public CompositorNode {
public:
	CompositorNodeRLayers(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Scene scene(void);
	enum layer_enum {
		layer_PLACEHOLDER = 0,
	};
	inline layer_enum layer(void);
	inline void layer(layer_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Composite ****************/

class CompositorNodeComposite : public CompositorNode {
public:
	CompositorNodeComposite(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_alpha(void);
	inline void use_alpha(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** File Output ****************/

class CompositorNodeOutputFile : public CompositorNode {
public:
	CompositorNodeOutputFile(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg),
		file_slots(ptr_arg),
		layer_slots(ptr_arg)
		{}

	inline std::string base_path(void);	inline void base_path(const std::string& value);
	inline int active_input_index(void);
	inline void active_input_index(int value);
	inline ImageFormatSettings format(void);
	COLLECTION_PROPERTY(CompositorNodeOutputFileFileSlots, NodeOutputFileSlotFile, CompositorNodeOutputFile, file_slots, false, false, false)
	COLLECTION_PROPERTY(CompositorNodeOutputFileLayerSlots, NodeOutputFileSlotLayer, CompositorNodeOutputFile, layer_slots, false, false, false)

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Texture ****************/

class CompositorNodeTexture : public CompositorNode {
public:
	CompositorNodeTexture(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Texture texture(void);
	inline int node_output(void);
	inline void node_output(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Translate ****************/

class CompositorNodeTranslate : public CompositorNode {
public:
	CompositorNodeTranslate(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_relative(void);
	inline void use_relative(int value);
	enum wrap_axis_enum {
		wrap_axis_NONE = 0,
		wrap_axis_XAXIS = 1,
		wrap_axis_YAXIS = 2,
		wrap_axis_BOTH = 3,
	};
	inline wrap_axis_enum wrap_axis(void);
	inline void wrap_axis(wrap_axis_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Z Combine ****************/

class CompositorNodeZcombine : public CompositorNode {
public:
	CompositorNodeZcombine(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_alpha(void);
	inline void use_alpha(int value);
	inline bool use_antialias_z(void);
	inline void use_antialias_z(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Combine RGBA ****************/

class CompositorNodeCombRGBA : public CompositorNode {
public:
	CompositorNodeCombRGBA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Dilate/Erode ****************/

class CompositorNodeDilateErode : public CompositorNode {
public:
	CompositorNodeDilateErode(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mode_enum {
		mode_STEP = 0,
		mode_THRESHOLD = 1,
		mode_DISTANCE = 2,
		mode_FEATHER = 3,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline int distance(void);
	inline void distance(int value);
	inline float edge(void);
	inline void edge(float value);
	enum falloff_enum {
		falloff_SMOOTH = 0,
		falloff_SPHERE = 1,
		falloff_ROOT = 2,
		falloff_SHARP = 3,
		falloff_LINEAR = 4,
	};
	inline falloff_enum falloff(void);
	inline void falloff(falloff_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Inpaint ****************/

class CompositorNodeInpaint : public CompositorNode {
public:
	CompositorNodeInpaint(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int distance(void);
	inline void distance(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Despeckle ****************/

class CompositorNodeDespeckle : public CompositorNode {
public:
	CompositorNodeDespeckle(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float threshold(void);
	inline void threshold(float value);
	inline float threshold_neighbor(void);
	inline void threshold_neighbor(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Rotate ****************/

class CompositorNodeRotate : public CompositorNode {
public:
	CompositorNodeRotate(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum filter_type_enum {
		filter_type_NEAREST = 0,
		filter_type_BILINEAR = 1,
		filter_type_BICUBIC = 2,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Scale ****************/

class CompositorNodeScale : public CompositorNode {
public:
	CompositorNodeScale(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum space_enum {
		space_RELATIVE = 0,
		space_ABSOLUTE = 1,
		space_SCENE_SIZE = 2,
		space_RENDER_SIZE = 3,
	};
	inline space_enum space(void);
	inline void space(space_enum value);
	enum frame_method_enum {
		frame_method_STRETCH = 0,
		frame_method_FIT = 1,
		frame_method_CROP = 3,
	};
	inline frame_method_enum frame_method(void);
	inline void frame_method(frame_method_enum value);
	inline float offset_x(void);
	inline void offset_x(float value);
	inline float offset_y(void);
	inline void offset_y(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Separate YCbCrA ****************/

class CompositorNodeSepYCCA : public CompositorNode {
public:
	CompositorNodeSepYCCA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mode_enum {
		mode_ITUBT601 = 0,
		mode_ITUBT709 = 1,
		mode_JFIF = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Combine YCbCrA ****************/

class CompositorNodeCombYCCA : public CompositorNode {
public:
	CompositorNodeCombYCCA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mode_enum {
		mode_ITUBT601 = 0,
		mode_ITUBT709 = 1,
		mode_JFIF = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Separate YUVA ****************/

class CompositorNodeSepYUVA : public CompositorNode {
public:
	CompositorNodeSepYUVA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Combine YUVA ****************/

class CompositorNodeCombYUVA : public CompositorNode {
public:
	CompositorNodeCombYUVA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Difference Key ****************/

class CompositorNodeDiffMatte : public CompositorNode {
public:
	CompositorNodeDiffMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float tolerance(void);
	inline void tolerance(float value);
	inline float falloff(void);
	inline void falloff(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Color Spill ****************/

class CompositorNodeColorSpill : public CompositorNode {
public:
	CompositorNodeColorSpill(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum channel_enum {
		channel_R = 1,
		channel_G = 2,
		channel_B = 3,
	};
	inline channel_enum channel(void);
	inline void channel(channel_enum value);
	enum limit_method_enum {
		limit_method_SIMPLE = 0,
		limit_method_AVERAGE = 1,
	};
	inline limit_method_enum limit_method(void);
	inline void limit_method(limit_method_enum value);
	enum limit_channel_enum {
		limit_channel_R = 1,
		limit_channel_G = 2,
		limit_channel_B = 3,
	};
	inline limit_channel_enum limit_channel(void);
	inline void limit_channel(limit_channel_enum value);
	inline float ratio(void);
	inline void ratio(float value);
	inline bool use_unspill(void);
	inline void use_unspill(int value);
	inline float unspill_red(void);
	inline void unspill_red(float value);
	inline float unspill_green(void);
	inline void unspill_green(float value);
	inline float unspill_blue(void);
	inline void unspill_blue(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Chroma Key ****************/

class CompositorNodeChromaMatte : public CompositorNode {
public:
	CompositorNodeChromaMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float tolerance(void);
	inline void tolerance(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline float lift(void);
	inline void lift(float value);
	inline float gain(void);
	inline void gain(float value);
	inline float shadow_adjust(void);
	inline void shadow_adjust(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Channel Key ****************/

class CompositorNodeChannelMatte : public CompositorNode {
public:
	CompositorNodeChannelMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum color_space_enum {
		color_space_RGB = 1,
		color_space_HSV = 2,
		color_space_YUV = 3,
		color_space_YCC = 4,
	};
	inline color_space_enum color_space(void);
	inline void color_space(color_space_enum value);
	enum matte_channel_enum {
		matte_channel_R = 1,
		matte_channel_G = 2,
		matte_channel_B = 3,
	};
	inline matte_channel_enum matte_channel(void);
	inline void matte_channel(matte_channel_enum value);
	enum limit_method_enum {
		limit_method_SINGLE = 0,
		limit_method_MAX = 1,
	};
	inline limit_method_enum limit_method(void);
	inline void limit_method(limit_method_enum value);
	enum limit_channel_enum {
		limit_channel_R = 1,
		limit_channel_G = 2,
		limit_channel_B = 3,
	};
	inline limit_channel_enum limit_channel(void);
	inline void limit_channel(limit_channel_enum value);
	inline float limit_max(void);
	inline void limit_max(float value);
	inline float limit_min(void);
	inline void limit_min(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Flip ****************/

class CompositorNodeFlip : public CompositorNode {
public:
	CompositorNodeFlip(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
		axis_XY = 2,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Split Viewer ****************/

class CompositorNodeSplitViewer : public CompositorNode {
public:
	CompositorNodeSplitViewer(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	inline int factor(void);
	inline void factor(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Map UV ****************/

class CompositorNodeMapUV : public CompositorNode {
public:
	CompositorNodeMapUV(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int alpha(void);
	inline void alpha(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ID Mask ****************/

class CompositorNodeIDMask : public CompositorNode {
public:
	CompositorNodeIDMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int index(void);
	inline void index(int value);
	inline bool use_antialiasing(void);
	inline void use_antialiasing(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Double Edge Mask ****************/

class CompositorNodeDoubleEdgeMask : public CompositorNode {
public:
	CompositorNodeDoubleEdgeMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum inner_mode_enum {
		inner_mode_ALL = 0,
		inner_mode_ADJACENT_ONLY = 1,
	};
	inline inner_mode_enum inner_mode(void);
	inline void inner_mode(inner_mode_enum value);
	enum edge_mode_enum {
		edge_mode_BLEED_OUT = 0,
		edge_mode_KEEP_IN = 1,
	};
	inline edge_mode_enum edge_mode(void);
	inline void edge_mode(edge_mode_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Defocus ****************/

class CompositorNodeDefocus : public CompositorNode {
public:
	CompositorNodeDefocus(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Scene scene(void);
	enum bokeh_enum {
		bokeh_OCTAGON = 8,
		bokeh_HEPTAGON = 7,
		bokeh_HEXAGON = 6,
		bokeh_PENTAGON = 5,
		bokeh_SQUARE = 4,
		bokeh_TRIANGLE = 3,
		bokeh_CIRCLE = 0,
	};
	inline bokeh_enum bokeh(void);
	inline void bokeh(bokeh_enum value);
	inline float angle(void);
	inline void angle(float value);
	inline bool use_gamma_correction(void);
	inline void use_gamma_correction(int value);
	inline float f_stop(void);
	inline void f_stop(float value);
	inline float blur_max(void);
	inline void blur_max(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline bool use_preview(void);
	inline void use_preview(int value);
	inline bool use_zbuffer(void);
	inline void use_zbuffer(int value);
	inline float z_scale(void);
	inline void z_scale(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Displace ****************/

class CompositorNodeDisplace : public CompositorNode {
public:
	CompositorNodeDisplace(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Combine HSVA ****************/

class CompositorNodeCombHSVA : public CompositorNode {
public:
	CompositorNodeCombHSVA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Math ****************/

class CompositorNodeMath : public CompositorNode {
public:
	CompositorNodeMath(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum operation_enum {
		operation_ADD = 0,
		operation_SUBTRACT = 1,
		operation_MULTIPLY = 2,
		operation_DIVIDE = 3,
		operation_SINE = 4,
		operation_COSINE = 5,
		operation_TANGENT = 6,
		operation_ARCSINE = 7,
		operation_ARCCOSINE = 8,
		operation_ARCTANGENT = 9,
		operation_POWER = 10,
		operation_LOGARITHM = 11,
		operation_MINIMUM = 12,
		operation_MAXIMUM = 13,
		operation_ROUND = 14,
		operation_LESS_THAN = 15,
		operation_GREATER_THAN = 16,
		operation_MODULO = 17,
		operation_ABSOLUTE = 18,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);
	inline bool use_clamp(void);
	inline void use_clamp(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Luminance Key ****************/

class CompositorNodeLumaMatte : public CompositorNode {
public:
	CompositorNodeLumaMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float limit_max(void);
	inline void limit_max(float value);
	inline float limit_min(void);
	inline void limit_min(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Bright/Contrast ****************/

class CompositorNodeBrightContrast : public CompositorNode {
public:
	CompositorNodeBrightContrast(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Gamma ****************/

class CompositorNodeGamma : public CompositorNode {
public:
	CompositorNodeGamma(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Invert ****************/

class CompositorNodeInvert : public CompositorNode {
public:
	CompositorNodeInvert(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool invert_rgb(void);
	inline void invert_rgb(int value);
	inline bool invert_alpha(void);
	inline void invert_alpha(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Normalize ****************/

class CompositorNodeNormalize : public CompositorNode {
public:
	CompositorNodeNormalize(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Crop ****************/

class CompositorNodeCrop : public CompositorNode {
public:
	CompositorNodeCrop(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_crop_size(void);
	inline void use_crop_size(int value);
	inline bool relative(void);
	inline void relative(int value);
	inline int min_x(void);
	inline void min_x(int value);
	inline int max_x(void);
	inline void max_x(int value);
	inline int min_y(void);
	inline void min_y(int value);
	inline int max_y(void);
	inline void max_y(int value);
	inline float rel_min_x(void);
	inline void rel_min_x(float value);
	inline float rel_max_x(void);
	inline void rel_max_x(float value);
	inline float rel_min_y(void);
	inline void rel_min_y(float value);
	inline float rel_max_y(void);
	inline void rel_max_y(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Directional Blur ****************/

class CompositorNodeDBlur : public CompositorNode {
public:
	CompositorNodeDBlur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int iterations(void);
	inline void iterations(int value);
	inline bool use_wrap(void);
	inline void use_wrap(int value);
	inline float center_x(void);
	inline void center_x(float value);
	inline float center_y(void);
	inline void center_y(float value);
	inline float distance(void);
	inline void distance(float value);
	inline float angle(void);
	inline void angle(float value);
	inline float spin(void);
	inline void spin(float value);
	inline float zoom(void);
	inline void zoom(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Bilateral Blur ****************/

class CompositorNodeBilateralblur : public CompositorNode {
public:
	CompositorNodeBilateralblur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int iterations(void);
	inline void iterations(int value);
	inline float sigma_color(void);
	inline void sigma_color(float value);
	inline float sigma_space(void);
	inline void sigma_space(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Alpha Convert ****************/

class CompositorNodePremulKey : public CompositorNode {
public:
	CompositorNodePremulKey(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mapping_enum {
		mapping_STRAIGHT_TO_PREMUL = 0,
		mapping_PREMUL_TO_STRAIGHT = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Glare ****************/

class CompositorNodeGlare : public CompositorNode {
public:
	CompositorNodeGlare(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum glare_type_enum {
		glare_type_GHOSTS = 3,
		glare_type_STREAKS = 2,
		glare_type_FOG_GLOW = 1,
		glare_type_SIMPLE_STAR = 0,
	};
	inline glare_type_enum glare_type(void);
	inline void glare_type(glare_type_enum value);
	enum quality_enum {
		quality_HIGH = 0,
		quality_MEDIUM = 1,
		quality_LOW = 2,
	};
	inline quality_enum quality(void);
	inline void quality(quality_enum value);
	inline int iterations(void);
	inline void iterations(int value);
	inline float color_modulation(void);
	inline void color_modulation(float value);
	inline float mix(void);
	inline void mix(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline int streaks(void);
	inline void streaks(int value);
	inline float angle_offset(void);
	inline void angle_offset(float value);
	inline float fade(void);
	inline void fade(float value);
	inline bool use_rotate_45(void);
	inline void use_rotate_45(int value);
	inline int size(void);
	inline void size(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Tonemap ****************/

class CompositorNodeTonemap : public CompositorNode {
public:
	CompositorNodeTonemap(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum tonemap_type_enum {
		tonemap_type_RD_PHOTORECEPTOR = 1,
		tonemap_type_RH_SIMPLE = 0,
	};
	inline tonemap_type_enum tonemap_type(void);
	inline void tonemap_type(tonemap_type_enum value);
	inline float key(void);
	inline void key(float value);
	inline float offset(void);
	inline void offset(float value);
	inline float gamma(void);
	inline void gamma(float value);
	inline float intensity(void);
	inline void intensity(float value);
	inline float contrast(void);
	inline void contrast(float value);
	inline float adaptation(void);
	inline void adaptation(float value);
	inline float correction(void);
	inline void correction(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Lens Distortion ****************/

class CompositorNodeLensdist : public CompositorNode {
public:
	CompositorNodeLensdist(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_projector(void);
	inline void use_projector(int value);
	inline bool use_jitter(void);
	inline void use_jitter(int value);
	inline bool use_fit(void);
	inline void use_fit(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Levels ****************/

class CompositorNodeLevels : public CompositorNode {
public:
	CompositorNodeLevels(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum channel_enum {
		channel_COMBINED_RGB = 1,
		channel_RED = 2,
		channel_GREEN = 3,
		channel_BLUE = 4,
		channel_LUMINANCE = 5,
	};
	inline channel_enum channel(void);
	inline void channel(channel_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Color Key ****************/

class CompositorNodeColorMatte : public CompositorNode {
public:
	CompositorNodeColorMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float color_hue(void);
	inline void color_hue(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float color_value(void);
	inline void color_value(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Distance Key ****************/

class CompositorNodeDistanceMatte : public CompositorNode {
public:
	CompositorNodeDistanceMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum channel_enum {
		channel_RGB = 1,
		channel_YCC = 2,
	};
	inline channel_enum channel(void);
	inline void channel(channel_enum value);
	inline float tolerance(void);
	inline void tolerance(float value);
	inline float falloff(void);
	inline void falloff(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Color Balance ****************/

class CompositorNodeColorBalance : public CompositorNode {
public:
	CompositorNodeColorBalance(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum correction_method_enum {
		correction_method_LIFT_GAMMA_GAIN = 0,
		correction_method_OFFSET_POWER_SLOPE = 1,
	};
	inline correction_method_enum correction_method(void);
	inline void correction_method(correction_method_enum value);
	inline Array<float, 3> lift(void);
	inline void lift(float values[3]);
	inline Array<float, 3> gamma(void);
	inline void gamma(float values[3]);
	inline Array<float, 3> gain(void);
	inline void gain(float values[3]);
	inline Array<float, 3> offset(void);
	inline void offset(float values[3]);
	inline Array<float, 3> power(void);
	inline void power(float values[3]);
	inline Array<float, 3> slope(void);
	inline void slope(float values[3]);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Hue Correct ****************/

class CompositorNodeHueCorrect : public CompositorNode {
public:
	CompositorNodeHueCorrect(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Movie Clip ****************/

class CompositorNodeMovieClip : public CompositorNode {
public:
	CompositorNodeMovieClip(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Transform ****************/

class CompositorNodeTransform : public CompositorNode {
public:
	CompositorNodeTransform(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum filter_type_enum {
		filter_type_NEAREST = 0,
		filter_type_BILINEAR = 1,
		filter_type_BICUBIC = 2,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Stabilize 2D ****************/

class CompositorNodeStabilize : public CompositorNode {
public:
	CompositorNodeStabilize(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	enum filter_type_enum {
		filter_type_NEAREST = 0,
		filter_type_BILINEAR = 1,
		filter_type_BICUBIC = 2,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Movie Distortion ****************/

class CompositorNodeMovieDistortion : public CompositorNode {
public:
	CompositorNodeMovieDistortion(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	enum distortion_type_enum {
		distortion_type_UNDISTORT = 0,
		distortion_type_DISTORT = 1,
	};
	inline distortion_type_enum distortion_type(void);
	inline void distortion_type(distortion_type_enum value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Box Mask ****************/

class CompositorNodeBoxMask : public CompositorNode {
public:
	CompositorNodeBoxMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mask_type_enum {
		mask_type_ADD = 0,
		mask_type_SUBTRACT = 1,
		mask_type_MULTIPLY = 2,
		mask_type_NOT = 3,
	};
	inline mask_type_enum mask_type(void);
	inline void mask_type(mask_type_enum value);
	inline float x(void);
	inline void x(float value);
	inline float y(void);
	inline void y(float value);
	inline float width(void);
	inline void width(float value);
	inline float height(void);
	inline void height(float value);
	inline float rotation(void);
	inline void rotation(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Ellipse Mask ****************/

class CompositorNodeEllipseMask : public CompositorNode {
public:
	CompositorNodeEllipseMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mask_type_enum {
		mask_type_ADD = 0,
		mask_type_SUBTRACT = 1,
		mask_type_MULTIPLY = 2,
		mask_type_NOT = 3,
	};
	inline mask_type_enum mask_type(void);
	inline void mask_type(mask_type_enum value);
	inline float x(void);
	inline void x(float value);
	inline float y(void);
	inline void y(float value);
	inline float width(void);
	inline void width(float value);
	inline float height(void);
	inline void height(float value);
	inline float rotation(void);
	inline void rotation(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Bokeh Image ****************/

class CompositorNodeBokehImage : public CompositorNode {
public:
	CompositorNodeBokehImage(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float angle(void);
	inline void angle(float value);
	inline int flaps(void);
	inline void flaps(int value);
	inline float rounding(void);
	inline void rounding(float value);
	inline float catadioptric(void);
	inline void catadioptric(float value);
	inline float shift(void);
	inline void shift(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Bokeh Blur ****************/

class CompositorNodeBokehBlur : public CompositorNode {
public:
	CompositorNodeBokehBlur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_variable_size(void);
	inline void use_variable_size(int value);
	inline float blur_max(void);
	inline void blur_max(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Switch ****************/

class CompositorNodeSwitch : public CompositorNode {
public:
	CompositorNodeSwitch(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool check(void);
	inline void check(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Color Correction ****************/

class CompositorNodeColorCorrection : public CompositorNode {
public:
	CompositorNodeColorCorrection(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool red(void);
	inline void red(int value);
	inline bool green(void);
	inline void green(int value);
	inline bool blue(void);
	inline void blue(int value);
	inline float midtones_start(void);
	inline void midtones_start(float value);
	inline float midtones_end(void);
	inline void midtones_end(float value);
	inline float master_saturation(void);
	inline void master_saturation(float value);
	inline float master_contrast(void);
	inline void master_contrast(float value);
	inline float master_gamma(void);
	inline void master_gamma(float value);
	inline float master_gain(void);
	inline void master_gain(float value);
	inline float master_lift(void);
	inline void master_lift(float value);
	inline float shadows_saturation(void);
	inline void shadows_saturation(float value);
	inline float shadows_contrast(void);
	inline void shadows_contrast(float value);
	inline float shadows_gamma(void);
	inline void shadows_gamma(float value);
	inline float shadows_gain(void);
	inline void shadows_gain(float value);
	inline float shadows_lift(void);
	inline void shadows_lift(float value);
	inline float midtones_saturation(void);
	inline void midtones_saturation(float value);
	inline float midtones_contrast(void);
	inline void midtones_contrast(float value);
	inline float midtones_gamma(void);
	inline void midtones_gamma(float value);
	inline float midtones_gain(void);
	inline void midtones_gain(float value);
	inline float midtones_lift(void);
	inline void midtones_lift(float value);
	inline float highlights_saturation(void);
	inline void highlights_saturation(float value);
	inline float highlights_contrast(void);
	inline void highlights_contrast(float value);
	inline float highlights_gamma(void);
	inline void highlights_gamma(float value);
	inline float highlights_gain(void);
	inline void highlights_gain(float value);
	inline float highlights_lift(void);
	inline void highlights_lift(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Mask ****************/

class CompositorNodeMask : public CompositorNode {
public:
	CompositorNodeMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Mask mask(void);
	inline bool use_antialiasing(void);
	inline void use_antialiasing(int value);
	inline bool use_feather(void);
	inline void use_feather(int value);
	inline bool use_motion_blur(void);
	inline void use_motion_blur(int value);
	inline int motion_blur_samples(void);
	inline void motion_blur_samples(int value);
	inline float motion_blur_shutter(void);
	inline void motion_blur_shutter(float value);
	enum size_source_enum {
		size_source_SCENE = 0,
		size_source_FIXED = 256,
		size_source_FIXED_SCENE = 512,
	};
	inline size_source_enum size_source(void);
	inline void size_source(size_source_enum value);
	inline int size_x(void);
	inline void size_x(int value);
	inline int size_y(void);
	inline void size_y(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Keying Screen ****************/

class CompositorNodeKeyingScreen : public CompositorNode {
public:
	CompositorNodeKeyingScreen(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline std::string tracking_object(void);	inline void tracking_object(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Keying ****************/

class CompositorNodeKeying : public CompositorNode {
public:
	CompositorNodeKeying(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float screen_balance(void);
	inline void screen_balance(float value);
	inline float despill_factor(void);
	inline void despill_factor(float value);
	inline float despill_balance(void);
	inline void despill_balance(float value);
	inline float clip_black(void);
	inline void clip_black(float value);
	inline float clip_white(void);
	inline void clip_white(float value);
	inline int blur_pre(void);
	inline void blur_pre(int value);
	inline int blur_post(void);
	inline void blur_post(int value);
	inline int dilate_distance(void);
	inline void dilate_distance(int value);
	inline int edge_kernel_radius(void);
	inline void edge_kernel_radius(int value);
	inline float edge_kernel_tolerance(void);
	inline void edge_kernel_tolerance(float value);
	enum feather_falloff_enum {
		feather_falloff_SMOOTH = 0,
		feather_falloff_SPHERE = 1,
		feather_falloff_ROOT = 2,
		feather_falloff_SHARP = 3,
		feather_falloff_LINEAR = 4,
	};
	inline feather_falloff_enum feather_falloff(void);
	inline void feather_falloff(feather_falloff_enum value);
	inline int feather_distance(void);
	inline void feather_distance(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Track Position ****************/

class CompositorNodeTrackPos : public CompositorNode {
public:
	CompositorNodeTrackPos(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	enum position_enum {
		position_ABSOLUTE = 0,
		position_RELATIVE_START = 1,
		position_RELATIVE_FRAME = 2,
		position_ABSOLUTE_FRAME = 3,
	};
	inline position_enum position(void);
	inline void position(position_enum value);
	inline int frame_relative(void);
	inline void frame_relative(int value);
	inline std::string tracking_object(void);	inline void tracking_object(const std::string& value);
	inline std::string track_name(void);	inline void track_name(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Pixelate ****************/

class CompositorNodePixelate : public CompositorNode {
public:
	CompositorNodePixelate(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Plane Track Deform ****************/

class CompositorNodePlaneTrackDeform : public CompositorNode {
public:
	CompositorNodePlaneTrackDeform(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline std::string tracking_object(void);	inline void tracking_object(const std::string& value);
	inline std::string plane_track_name(void);	inline void plane_track_name(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Corner Pin ****************/

class CompositorNodeCornerPin : public CompositorNode {
public:
	CompositorNodeCornerPin(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Sun Beams ****************/

class CompositorNodeSunBeams : public CompositorNode {
public:
	CompositorNodeSunBeams(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Array<float, 2> source(void);
	inline void source(float values[2]);
	inline float ray_length(void);
	inline void ray_length(float value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Output ****************/

class TextureNodeOutput : public TextureNode {
public:
	TextureNodeOutput(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline std::string filepath(void);	inline void filepath(const std::string& value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Checker ****************/

class TextureNodeChecker : public TextureNode {
public:
	TextureNodeChecker(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Texture ****************/

class TextureNodeTexture : public TextureNode {
public:
	TextureNodeTexture(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline Texture texture(void);
	inline int node_output(void);
	inline void node_output(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Bricks ****************/

class TextureNodeBricks : public TextureNode {
public:
	TextureNodeBricks(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline float offset(void);
	inline void offset(float value);
	inline int offset_frequency(void);
	inline void offset_frequency(int value);
	inline float squash(void);
	inline void squash(float value);
	inline int squash_frequency(void);
	inline void squash_frequency(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Math ****************/

class TextureNodeMath : public TextureNode {
public:
	TextureNodeMath(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	enum operation_enum {
		operation_ADD = 0,
		operation_SUBTRACT = 1,
		operation_MULTIPLY = 2,
		operation_DIVIDE = 3,
		operation_SINE = 4,
		operation_COSINE = 5,
		operation_TANGENT = 6,
		operation_ARCSINE = 7,
		operation_ARCCOSINE = 8,
		operation_ARCTANGENT = 9,
		operation_POWER = 10,
		operation_LOGARITHM = 11,
		operation_MINIMUM = 12,
		operation_MAXIMUM = 13,
		operation_ROUND = 14,
		operation_LESS_THAN = 15,
		operation_GREATER_THAN = 16,
		operation_MODULO = 17,
		operation_ABSOLUTE = 18,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);
	inline bool use_clamp(void);
	inline void use_clamp(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Mix RGB ****************/

class TextureNodeMixRGB : public TextureNode {
public:
	TextureNodeMixRGB(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_ADD = 1,
		blend_type_MULTIPLY = 2,
		blend_type_SUBTRACT = 3,
		blend_type_SCREEN = 4,
		blend_type_DIVIDE = 5,
		blend_type_DIFFERENCE = 6,
		blend_type_DARKEN = 7,
		blend_type_LIGHTEN = 8,
		blend_type_OVERLAY = 9,
		blend_type_DODGE = 10,
		blend_type_BURN = 11,
		blend_type_HUE = 12,
		blend_type_SATURATION = 13,
		blend_type_VALUE = 14,
		blend_type_COLOR = 15,
		blend_type_SOFT_LIGHT = 16,
		blend_type_LINEAR_LIGHT = 17,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool use_alpha(void);
	inline void use_alpha(int value);
	inline bool use_clamp(void);
	inline void use_clamp(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** RGB to BW ****************/

class TextureNodeRGBToBW : public TextureNode {
public:
	TextureNodeRGBToBW(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ColorRamp ****************/

class TextureNodeValToRGB : public TextureNode {
public:
	TextureNodeValToRGB(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline ColorRamp color_ramp(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Image ****************/

class TextureNodeImage : public TextureNode {
public:
	TextureNodeImage(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline Image image(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** RGB Curves ****************/

class TextureNodeCurveRGB : public TextureNode {
public:
	TextureNodeCurveRGB(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Invert ****************/

class TextureNodeInvert : public TextureNode {
public:
	TextureNodeInvert(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Hue/Saturation ****************/

class TextureNodeHueSaturation : public TextureNode {
public:
	TextureNodeHueSaturation(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Curve Time ****************/

class TextureNodeCurveTime : public TextureNode {
public:
	TextureNodeCurveTime(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline CurveMapping curve(void);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Rotate ****************/

class TextureNodeRotate : public TextureNode {
public:
	TextureNodeRotate(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Viewer ****************/

class TextureNodeViewer : public TextureNode {
public:
	TextureNodeViewer(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Translate ****************/

class TextureNodeTranslate : public TextureNode {
public:
	TextureNodeTranslate(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Coordinates ****************/

class TextureNodeCoordinates : public TextureNode {
public:
	TextureNodeCoordinates(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Distance ****************/

class TextureNodeDistance : public TextureNode {
public:
	TextureNodeDistance(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Combine RGBA ****************/

class TextureNodeCompose : public TextureNode {
public:
	TextureNodeCompose(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Separate RGBA ****************/

class TextureNodeDecompose : public TextureNode {
public:
	TextureNodeDecompose(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Value to Normal ****************/

class TextureNodeValToNor : public TextureNode {
public:
	TextureNodeValToNor(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Scale ****************/

class TextureNodeScale : public TextureNode {
public:
	TextureNodeScale(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** At ****************/

class TextureNodeAt : public TextureNode {
public:
	TextureNodeAt(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Voronoi ****************/

class TextureNodeTexVoronoi : public TextureNode {
public:
	TextureNodeTexVoronoi(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Blend ****************/

class TextureNodeTexBlend : public TextureNode {
public:
	TextureNodeTexBlend(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Magic ****************/

class TextureNodeTexMagic : public TextureNode {
public:
	TextureNodeTexMagic(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Marble ****************/

class TextureNodeTexMarble : public TextureNode {
public:
	TextureNodeTexMarble(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Clouds ****************/

class TextureNodeTexClouds : public TextureNode {
public:
	TextureNodeTexClouds(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Wood ****************/

class TextureNodeTexWood : public TextureNode {
public:
	TextureNodeTexWood(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Musgrave ****************/

class TextureNodeTexMusgrave : public TextureNode {
public:
	TextureNodeTexMusgrave(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Noise ****************/

class TextureNodeTexNoise : public TextureNode {
public:
	TextureNodeTexNoise(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Stucci ****************/

class TextureNodeTexStucci : public TextureNode {
public:
	TextureNodeTexStucci(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Distorted Noise ****************/

class TextureNodeTexDistNoise : public TextureNode {
public:
	TextureNodeTexDistNoise(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Group ****************/

class ShaderNodeGroup : public ShaderNode {
public:
	ShaderNodeGroup(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline NodeTree node_tree(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Group ****************/

class CompositorNodeGroup : public CompositorNode {
public:
	CompositorNodeGroup(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline NodeTree node_tree(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Group ****************/

class TextureNodeGroup : public TextureNode {
public:
	TextureNodeGroup(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline NodeTree node_tree(void);

	inline int is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Custom Group ****************/

class NodeCustomGroup : public Node {
public:
	NodeCustomGroup(const PointerRNA &ptr_arg) :
		Node(ptr_arg)
		{}

	inline NodeTree node_tree(void);

};

/**************** Output File Slot ****************/

class NodeOutputFileSlotFile : public Pointer {
public:
	NodeOutputFileSlotFile(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_node_format(void);
	inline void use_node_format(int value);
	inline ImageFormatSettings format(void);
	inline std::string path(void);	inline void path(const std::string& value);

};

/**************** Output File Layer Slot ****************/

class NodeOutputFileSlotLayer : public Pointer {
public:
	NodeOutputFileSlotLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);

};

/**************** Node Instance Hash ****************/

class NodeInstanceHash : public Pointer {
public:
	NodeInstanceHash(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Object ****************/

class Object : public ID {
public:
	Object(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		material_slots(ptr_arg),
		modifiers(ptr_arg),
		constraints(ptr_arg),
		vertex_groups(ptr_arg),
		particle_systems(ptr_arg),
		dupli_list(ptr_arg),
		lod_levels(ptr_arg)
		{}

	inline ID data(void);
	enum type_enum {
		type_MESH = 1,
		type_CURVE = 2,
		type_SURFACE = 3,
		type_META = 5,
		type_FONT = 4,
		type_ARMATURE = 25,
		type_LATTICE = 22,
		type_EMPTY = 0,
		type_CAMERA = 11,
		type_LAMP = 10,
		type_SPEAKER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum mode_enum {
		mode_OBJECT = 0,
		mode_EDIT = 1,
		mode_POSE = 64,
		mode_SCULPT = 2,
		mode_VERTEX_PAINT = 4,
		mode_WEIGHT_PAINT = 8,
		mode_TEXTURE_PAINT = 16,
		mode_PARTICLE_EDIT = 32,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Array<int, 20> layers(void);
	inline void layers(int values[20]);
	inline Array<int, 8> layers_local_view(void);
	inline void layers_local_view(int values[8]);
	inline bool select(void);
	inline void select(int value);
	inline Array<float, 24> bound_box(void);
	inline void bound_box(float values[24]);
	inline Object parent(void);
	enum parent_type_enum {
		parent_type_OBJECT = 0,
		parent_type_CURVE = 1,
		parent_type_KEY = 2,
		parent_type_ARMATURE = 4,
		parent_type_LATTICE = 4,
		parent_type_VERTEX = 5,
		parent_type_VERTEX_3 = 6,
		parent_type_BONE = 7,
	};
	inline parent_type_enum parent_type(void);
	inline void parent_type(parent_type_enum value);
	inline Array<int, 3> parent_vertices(void);
	inline void parent_vertices(int values[3]);
	inline std::string parent_bone(void);	inline void parent_bone(const std::string& value);
	enum track_axis_enum {
		track_axis_POS_X = 0,
		track_axis_POS_Y = 1,
		track_axis_POS_Z = 2,
		track_axis_NEG_X = 3,
		track_axis_NEG_Y = 4,
		track_axis_NEG_Z = 5,
	};
	inline track_axis_enum track_axis(void);
	inline void track_axis(track_axis_enum value);
	enum up_axis_enum {
		up_axis_X = 0,
		up_axis_Y = 1,
		up_axis_Z = 2,
	};
	inline up_axis_enum up_axis(void);
	inline void up_axis(up_axis_enum value);
	inline Object proxy(void);
	inline Object proxy_group(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MaterialSlot, Object, material_slots, true, true, true)
	inline Material active_material(void);
	inline int active_material_index(void);
	inline void active_material_index(int value);
	inline Array<float, 3> location(void);
	inline void location(float values[3]);
	inline Array<float, 4> rotation_quaternion(void);
	inline void rotation_quaternion(float values[4]);
	inline Array<float, 4> rotation_axis_angle(void);
	inline void rotation_axis_angle(float values[4]);
	inline Array<float, 3> rotation_euler(void);
	inline void rotation_euler(float values[3]);
	enum rotation_mode_enum {
		rotation_mode_QUATERNION = 0,
		rotation_mode_XYZ = 1,
		rotation_mode_XZY = 2,
		rotation_mode_YXZ = 3,
		rotation_mode_YZX = 4,
		rotation_mode_ZXY = 5,
		rotation_mode_ZYX = 6,
		rotation_mode_AXIS_ANGLE = -1,
	};
	inline rotation_mode_enum rotation_mode(void);
	inline void rotation_mode(rotation_mode_enum value);
	inline Array<float, 3> scale(void);
	inline void scale(float values[3]);
	inline Array<float, 3> dimensions(void);
	inline void dimensions(float values[3]);
	inline Array<float, 3> delta_location(void);
	inline void delta_location(float values[3]);
	inline Array<float, 3> delta_rotation_euler(void);
	inline void delta_rotation_euler(float values[3]);
	inline Array<float, 4> delta_rotation_quaternion(void);
	inline void delta_rotation_quaternion(float values[4]);
	inline Array<float, 3> delta_scale(void);
	inline void delta_scale(float values[3]);
	inline Array<int, 3> lock_location(void);
	inline void lock_location(int values[3]);
	inline Array<int, 3> lock_rotation(void);
	inline void lock_rotation(int values[3]);
	inline bool lock_rotation_w(void);
	inline void lock_rotation_w(int value);
	inline bool lock_rotations_4d(void);
	inline void lock_rotations_4d(int value);
	inline Array<int, 3> lock_scale(void);
	inline void lock_scale(int values[3]);
	inline Array<float, 16> matrix_world(void);
	inline void matrix_world(float values[16]);
	inline Array<float, 16> matrix_local(void);
	inline void matrix_local(float values[16]);
	inline Array<float, 16> matrix_basis(void);
	inline void matrix_basis(float values[16]);
	inline Array<float, 16> matrix_parent_inverse(void);
	inline void matrix_parent_inverse(float values[16]);
	COLLECTION_PROPERTY(ObjectModifiers, Modifier, Object, modifiers, false, true, true)
	COLLECTION_PROPERTY(ObjectConstraints, Constraint, Object, constraints, false, true, true)
	inline GameObjectSettings game(void);
	COLLECTION_PROPERTY(VertexGroups, VertexGroup, Object, vertex_groups, false, true, true)
	enum empty_draw_type_enum {
		empty_draw_type_PLAIN_AXES = 2,
		empty_draw_type_ARROWS = 1,
		empty_draw_type_SINGLE_ARROW = 4,
		empty_draw_type_CIRCLE = 3,
		empty_draw_type_CUBE = 5,
		empty_draw_type_SPHERE = 6,
		empty_draw_type_CONE = 7,
		empty_draw_type_IMAGE = 8,
	};
	inline empty_draw_type_enum empty_draw_type(void);
	inline void empty_draw_type(empty_draw_type_enum value);
	inline float empty_draw_size(void);
	inline void empty_draw_size(float value);
	inline Array<float, 2> empty_image_offset(void);
	inline void empty_image_offset(float values[2]);
	inline ImageUser image_user(void);
	inline int pass_index(void);
	inline void pass_index(int value);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);
	inline FieldSettings field(void);
	inline CollisionSettings collision(void);
	inline SoftBodySettings soft_body(void);
	COLLECTION_PROPERTY(ParticleSystems, ParticleSystem, Object, particle_systems, false, true, true)
	inline RigidBodyObject rigid_body(void);
	inline RigidBodyConstraint rigid_body_constraint(void);
	inline bool hide(void);
	inline void hide(int value);
	inline bool hide_select(void);
	inline void hide_select(int value);
	inline bool hide_render(void);
	inline void hide_render(int value);
	inline AnimData animation_data(void);
	inline AnimViz animation_visualization(void);
	inline MotionPath motion_path(void);
	inline bool use_slow_parent(void);
	inline void use_slow_parent(int value);
	inline float slow_parent_offset(void);
	inline void slow_parent_offset(float value);
	inline bool use_extra_recalc_object(void);
	inline void use_extra_recalc_object(int value);
	inline bool use_extra_recalc_data(void);
	inline void use_extra_recalc_data(int value);
	enum dupli_type_enum {
		dupli_type_NONE = 0,
		dupli_type_FRAMES = 8,
		dupli_type_VERTS = 16,
		dupli_type_FACES = 512,
		dupli_type_GROUP = 256,
	};
	inline dupli_type_enum dupli_type(void);
	inline void dupli_type(dupli_type_enum value);
	inline bool use_dupli_frames_speed(void);
	inline void use_dupli_frames_speed(int value);
	inline bool use_dupli_vertices_rotation(void);
	inline void use_dupli_vertices_rotation(int value);
	inline bool use_dupli_faces_scale(void);
	inline void use_dupli_faces_scale(int value);
	inline float dupli_faces_scale(void);
	inline void dupli_faces_scale(float value);
	inline Group dupli_group(void);
	inline int dupli_frames_start(void);
	inline void dupli_frames_start(int value);
	inline int dupli_frames_end(void);
	inline void dupli_frames_end(int value);
	inline int dupli_frames_on(void);
	inline void dupli_frames_on(int value);
	inline int dupli_frames_off(void);
	inline void dupli_frames_off(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, DupliObject, Object, dupli_list, false, true, false)
	inline bool is_duplicator(void);
	inline void is_duplicator(int value);
	enum draw_type_enum {
		draw_type_BOUNDS = 1,
		draw_type_WIRE = 2,
		draw_type_SOLID = 3,
		draw_type_TEXTURED = 5,
	};
	inline draw_type_enum draw_type(void);
	inline void draw_type(draw_type_enum value);
	inline bool show_bounds(void);
	inline void show_bounds(int value);
	enum draw_bounds_type_enum {
		draw_bounds_type_BOX = 0,
		draw_bounds_type_SPHERE = 1,
		draw_bounds_type_CYLINDER = 2,
		draw_bounds_type_CONE = 3,
		draw_bounds_type_CAPSULE = 7,
	};
	inline draw_bounds_type_enum draw_bounds_type(void);
	inline void draw_bounds_type(draw_bounds_type_enum value);
	inline bool show_name(void);
	inline void show_name(int value);
	inline bool show_axis(void);
	inline void show_axis(int value);
	inline bool show_texture_space(void);
	inline void show_texture_space(int value);
	inline bool show_wire(void);
	inline void show_wire(int value);
	inline bool show_all_edges(void);
	inline void show_all_edges(int value);
	inline bool show_transparent(void);
	inline void show_transparent(int value);
	inline bool show_x_ray(void);
	inline void show_x_ray(int value);
	inline GreasePencil grease_pencil(void);
	inline Action pose_library(void);
	inline Pose pose(void);
	inline bool show_only_shape_key(void);
	inline void show_only_shape_key(int value);
	inline bool use_shape_key_edit_mode(void);
	inline void use_shape_key_edit_mode(int value);
	inline ShapeKey active_shape_key(void);
	inline int active_shape_key_index(void);
	inline void active_shape_key_index(int value);
	inline bool use_dynamic_topology_sculpting(void);
	inline void use_dynamic_topology_sculpting(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, LodLevel, Object, lod_levels, false, true, false)

	inline void convert_space(PoseBone pose_bone, float matrix[16], float matrix_return[16], int from_space, int to_space);
	inline Mesh to_mesh(Scene scene, int apply_modifiers, int settings, int calc_tessface, int calc_undeformed);
	inline void dupli_list_create(Scene scene, int settings);
	inline void dupli_list_clear();
	inline Object find_armature();
	inline ShapeKey shape_key_add(Context C, const char * name, int from_mix);
	inline void ray_cast(float start[3], float end[3], float location[3], float normal[3], int *index);
	inline void closest_point_on_mesh(float point[3], float max_dist, float location[3], float normal[3], int *index);
	inline int is_visible(Scene scene);
	inline int is_modified(Scene scene, int settings);
	inline int is_deform_modified(Scene scene, int settings);
	inline int update_from_editmode();
};

/**************** Game Object Settings ****************/

class GameObjectSettings : public Pointer {
public:
	GameObjectSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		sensors(ptr_arg),
		controllers(ptr_arg),
		actuators(ptr_arg),
		properties(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Sensor, GameObjectSettings, sensors, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Controller, GameObjectSettings, controllers, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Actuator, GameObjectSettings, actuators, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, GameProperty, GameObjectSettings, properties, false, true, true)
	inline bool show_sensors(void);
	inline void show_sensors(int value);
	inline bool show_controllers(void);
	inline void show_controllers(int value);
	inline bool show_actuators(void);
	inline void show_actuators(int value);
	enum physics_type_enum {
		physics_type_NO_COLLISION = 0,
		physics_type_STATIC = 1,
		physics_type_DYNAMIC = 2,
		physics_type_RIGID_BODY = 3,
		physics_type_SOFT_BODY = 4,
		physics_type_OCCLUDE = 5,
		physics_type_SENSOR = 6,
		physics_type_NAVMESH = 7,
		physics_type_CHARACTER = 8,
	};
	inline physics_type_enum physics_type(void);
	inline void physics_type(physics_type_enum value);
	inline bool use_record_animation(void);
	inline void use_record_animation(int value);
	inline bool use_actor(void);
	inline void use_actor(int value);
	inline bool use_ghost(void);
	inline void use_ghost(int value);
	inline float mass(void);
	inline void mass(float value);
	inline float radius(void);
	inline void radius(float value);
	inline bool use_sleep(void);
	inline void use_sleep(int value);
	inline float damping(void);
	inline void damping(float value);
	inline float rotation_damping(void);
	inline void rotation_damping(float value);
	inline float velocity_min(void);
	inline void velocity_min(float value);
	inline float velocity_max(void);
	inline void velocity_max(float value);
	inline float step_height(void);
	inline void step_height(float value);
	inline float jump_speed(void);
	inline void jump_speed(float value);
	inline float fall_speed(void);
	inline void fall_speed(float value);
	inline Array<int, 8> collision_group(void);
	inline void collision_group(int values[8]);
	inline Array<int, 8> collision_mask(void);
	inline void collision_mask(int values[8]);
	inline bool lock_location_x(void);
	inline void lock_location_x(int value);
	inline bool lock_location_y(void);
	inline void lock_location_y(int value);
	inline bool lock_location_z(void);
	inline void lock_location_z(int value);
	inline bool lock_rotation_x(void);
	inline void lock_rotation_x(int value);
	inline bool lock_rotation_y(void);
	inline void lock_rotation_y(int value);
	inline bool lock_rotation_z(void);
	inline void lock_rotation_z(int value);
	inline bool use_activity_culling(void);
	inline void use_activity_culling(int value);
	inline bool use_material_physics_fh(void);
	inline void use_material_physics_fh(int value);
	inline bool use_rotate_from_normal(void);
	inline void use_rotate_from_normal(int value);
	inline float form_factor(void);
	inline void form_factor(float value);
	inline bool use_anisotropic_friction(void);
	inline void use_anisotropic_friction(int value);
	inline Array<float, 3> friction_coefficients(void);
	inline void friction_coefficients(float values[3]);
	inline bool use_collision_bounds(void);
	inline void use_collision_bounds(int value);
	enum collision_bounds_type_enum {
		collision_bounds_type_BOX = 0,
		collision_bounds_type_SPHERE = 1,
		collision_bounds_type_CYLINDER = 2,
		collision_bounds_type_CONE = 3,
		collision_bounds_type_CONVEX_HULL = 5,
		collision_bounds_type_TRIANGLE_MESH = 4,
		collision_bounds_type_CAPSULE = 7,
	};
	inline collision_bounds_type_enum collision_bounds_type(void);
	inline void collision_bounds_type(collision_bounds_type_enum value);
	inline bool use_collision_compound(void);
	inline void use_collision_compound(int value);
	inline float collision_margin(void);
	inline void collision_margin(float value);
	inline GameSoftBodySettings soft_body(void);
	inline bool use_obstacle_create(void);
	inline void use_obstacle_create(int value);
	inline float obstacle_radius(void);
	inline void obstacle_radius(float value);
	inline Array<int, 30> states_visible(void);
	inline void states_visible(int values[30]);
	inline Array<int, 30> used_states(void);
	inline void used_states(int values[30]);
	inline Array<int, 30> states_initial(void);
	inline void states_initial(int values[30]);
	inline bool show_debug_state(void);
	inline void show_debug_state(int value);
	inline bool use_all_states(void);
	inline void use_all_states(int value);
	inline bool show_state_panel(void);
	inline void show_state_panel(int value);

};

/**************** Object Base ****************/

class ObjectBase : public Pointer {
public:
	ObjectBase(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object object(void);
	inline Array<int, 20> layers(void);
	inline void layers(int values[20]);
	inline Array<int, 8> layers_local_view(void);
	inline void layers_local_view(int values[8]);
	inline bool select(void);
	inline void select(int value);

	inline void layers_from_view(SpaceView3D view);
};

/**************** Vertex Group ****************/

class VertexGroup : public Pointer {
public:
	VertexGroup(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool lock_weight(void);
	inline void lock_weight(int value);
	inline int index(void);
	inline void index(int value);

	inline void add(int index_len, int *index, float weight, int type);
	inline void remove(int index_len, int *index);
	inline float weight(int index);
};

/**************** Material Slot ****************/

class MaterialSlot : public Pointer {
public:
	MaterialSlot(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Material material(void);
	enum link_enum {
		link_OBJECT = 1,
		link_DATA = 0,
	};
	inline link_enum link(void);
	inline void link(link_enum value);
	inline std::string name(void);	inline void name(const std::string& value);

};

/**************** Object Duplicate ****************/

class DupliObject : public Pointer {
public:
	DupliObject(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object object(void);
	inline Array<float, 16> matrix(void);
	inline void matrix(float values[16]);
	inline bool hide(void);
	inline void hide(int value);
	inline int index(void);
	inline void index(int value);
	inline Array<int, 8> persistent_id(void);
	inline void persistent_id(int values[8]);
	inline ParticleSystem particle_system(void);
	inline Array<float, 3> orco(void);
	inline void orco(float values[3]);
	inline Array<float, 2> uv(void);
	inline void uv(float values[2]);
	enum type_enum {
		type_NONE = 0,
		type_FRAMES = 8,
		type_VERTS = 16,
		type_FACES = 512,
		type_GROUP = 256,
	};
	inline type_enum type(void);
	inline void type(type_enum value);

};

/**************** LodLevel ****************/

class LodLevel : public Pointer {
public:
	LodLevel(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float distance(void);
	inline void distance(float value);
	inline Object object(void);
	inline bool use_mesh(void);
	inline void use_mesh(int value);
	inline bool use_material(void);
	inline void use_material(int value);

};

/**************** Point Cache ****************/

class PointCache : public Pointer {
public:
	PointCache(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		point_caches(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int frame_step(void);
	inline void frame_step(int value);
	inline int index(void);
	inline void index(int value);
	enum compression_enum {
		compression_NO = 0,
		compression_LIGHT = 1,
		compression_HEAVY = 2,
	};
	inline compression_enum compression(void);
	inline void compression(compression_enum value);
	inline bool is_baked(void);
	inline void is_baked(int value);
	inline bool is_baking(void);
	inline void is_baking(int value);
	inline bool use_disk_cache(void);
	inline void use_disk_cache(int value);
	inline bool is_outdated(void);
	inline void is_outdated(int value);
	inline bool frames_skipped(void);
	inline void frames_skipped(int value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline std::string info(void);	inline void info(const std::string& value);
	inline bool use_external(void);
	inline void use_external(int value);
	inline bool use_library_path(void);
	inline void use_library_path(int value);
	COLLECTION_PROPERTY(PointCaches, PointCache, PointCache, point_caches, false, false, false)

};

/**************** Collision Settings ****************/

class CollisionSettings : public Pointer {
public:
	CollisionSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use(void);
	inline void use(int value);
	inline float damping_factor(void);
	inline void damping_factor(float value);
	inline float damping_random(void);
	inline void damping_random(float value);
	inline float friction_factor(void);
	inline void friction_factor(float value);
	inline float friction_random(void);
	inline void friction_random(float value);
	inline float permeability(void);
	inline void permeability(float value);
	inline bool use_particle_kill(void);
	inline void use_particle_kill(int value);
	inline float stickiness(void);
	inline void stickiness(float value);
	inline float thickness_inner(void);
	inline void thickness_inner(float value);
	inline float thickness_outer(void);
	inline void thickness_outer(float value);
	inline float damping(void);
	inline void damping(float value);
	inline float absorption(void);
	inline void absorption(float value);

};

/**************** Effector Weights ****************/

class EffectorWeights : public Pointer {
public:
	EffectorWeights(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool apply_to_hair_growing(void);
	inline void apply_to_hair_growing(int value);
	inline Group group(void);
	inline float gravity(void);
	inline void gravity(float value);
	inline float all(void);
	inline void all(float value);
	inline float force(void);
	inline void force(float value);
	inline float vortex(void);
	inline void vortex(float value);
	inline float magnetic(void);
	inline void magnetic(float value);
	inline float wind(void);
	inline void wind(float value);
	inline float curve_guide(void);
	inline void curve_guide(float value);
	inline float texture(void);
	inline void texture(float value);
	inline float harmonic(void);
	inline void harmonic(float value);
	inline float charge(void);
	inline void charge(float value);
	inline float lennardjones(void);
	inline void lennardjones(float value);
	inline float boid(void);
	inline void boid(float value);
	inline float turbulence(void);
	inline void turbulence(float value);
	inline float drag(void);
	inline void drag(float value);
	inline float smokeflow(void);
	inline void smokeflow(float value);

};

/**************** Field Settings ****************/

class FieldSettings : public Pointer {
public:
	FieldSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_NONE = 0,
		type_FORCE = 1,
		type_WIND = 4,
		type_VORTEX = 2,
		type_MAGNET = 3,
		type_HARMONIC = 7,
		type_CHARGE = 8,
		type_LENNARDJ = 9,
		type_TEXTURE = 6,
		type_GUIDE = 5,
		type_BOID = 10,
		type_TURBULENCE = 11,
		type_DRAG = 12,
		type_SMOKE_FLOW = 13,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum shape_enum {
		shape_POINT = 0,
		shape_PLANE = 1,
		shape_SURFACE = 2,
		shape_POINTS = 3,
	};
	inline shape_enum shape(void);
	inline void shape(shape_enum value);
	enum falloff_type_enum {
		falloff_type_SPHERE = 0,
		falloff_type_TUBE = 1,
		falloff_type_CONE = 2,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	enum texture_mode_enum {
		texture_mode_RGB = 0,
		texture_mode_GRADIENT = 1,
		texture_mode_CURL = 2,
	};
	inline texture_mode_enum texture_mode(void);
	inline void texture_mode(texture_mode_enum value);
	enum z_direction_enum {
		z_direction_BOTH = 0,
		z_direction_POSITIVE = 1,
		z_direction_NEGATIVE = 2,
	};
	inline z_direction_enum z_direction(void);
	inline void z_direction(z_direction_enum value);
	inline float strength(void);
	inline void strength(float value);
	inline float linear_drag(void);
	inline void linear_drag(float value);
	inline float harmonic_damping(void);
	inline void harmonic_damping(float value);
	inline float quadratic_drag(void);
	inline void quadratic_drag(float value);
	inline float flow(void);
	inline void flow(float value);
	inline float inflow(void);
	inline void inflow(float value);
	inline float size(void);
	inline void size(float value);
	inline float rest_length(void);
	inline void rest_length(float value);
	inline float falloff_power(void);
	inline void falloff_power(float value);
	inline float distance_min(void);
	inline void distance_min(float value);
	inline float distance_max(void);
	inline void distance_max(float value);
	inline float radial_min(void);
	inline void radial_min(float value);
	inline float radial_max(void);
	inline void radial_max(float value);
	inline float radial_falloff(void);
	inline void radial_falloff(float value);
	inline float texture_nabla(void);
	inline void texture_nabla(float value);
	inline float noise(void);
	inline void noise(float value);
	inline int seed(void);
	inline void seed(int value);
	inline bool use_min_distance(void);
	inline void use_min_distance(int value);
	inline bool use_max_distance(void);
	inline void use_max_distance(int value);
	inline bool use_radial_min(void);
	inline void use_radial_min(int value);
	inline bool use_radial_max(void);
	inline void use_radial_max(int value);
	inline bool use_object_coords(void);
	inline void use_object_coords(int value);
	inline bool use_global_coords(void);
	inline void use_global_coords(int value);
	inline bool use_2d_force(void);
	inline void use_2d_force(int value);
	inline bool use_root_coords(void);
	inline void use_root_coords(int value);
	inline bool apply_to_location(void);
	inline void apply_to_location(int value);
	inline bool apply_to_rotation(void);
	inline void apply_to_rotation(int value);
	inline bool use_absorption(void);
	inline void use_absorption(int value);
	inline bool use_multiple_springs(void);
	inline void use_multiple_springs(int value);
	inline bool use_smoke_density(void);
	inline void use_smoke_density(int value);
	inline Texture texture(void);
	inline Object source_object(void);
	inline float guide_minimum(void);
	inline void guide_minimum(float value);
	inline float guide_free(void);
	inline void guide_free(float value);
	inline bool use_guide_path_add(void);
	inline void use_guide_path_add(int value);
	inline bool use_guide_path_weight(void);
	inline void use_guide_path_weight(int value);
	inline float guide_clump_amount(void);
	inline void guide_clump_amount(float value);
	inline float guide_clump_shape(void);
	inline void guide_clump_shape(float value);
	enum guide_kink_type_enum {
		guide_kink_type_NONE = 0,
		guide_kink_type_CURL = 1,
		guide_kink_type_RADIAL = 2,
		guide_kink_type_WAVE = 3,
		guide_kink_type_BRAID = 4,
		guide_kink_type_ROTATION = 5,
		guide_kink_type_ROLL = 6,
	};
	inline guide_kink_type_enum guide_kink_type(void);
	inline void guide_kink_type(guide_kink_type_enum value);
	enum guide_kink_axis_enum {
		guide_kink_axis_X = 0,
		guide_kink_axis_Y = 1,
		guide_kink_axis_Z = 2,
	};
	inline guide_kink_axis_enum guide_kink_axis(void);
	inline void guide_kink_axis(guide_kink_axis_enum value);
	inline float guide_kink_frequency(void);
	inline void guide_kink_frequency(float value);
	inline float guide_kink_shape(void);
	inline void guide_kink_shape(float value);
	inline float guide_kink_amplitude(void);
	inline void guide_kink_amplitude(float value);

};

/**************** Game Soft Body Settings ****************/

class GameSoftBodySettings : public Pointer {
public:
	GameSoftBodySettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float linear_stiffness(void);
	inline void linear_stiffness(float value);
	inline float dynamic_friction(void);
	inline void dynamic_friction(float value);
	inline float shape_threshold(void);
	inline void shape_threshold(float value);
	inline float collision_margin(void);
	inline void collision_margin(float value);
	inline float weld_threshold(void);
	inline void weld_threshold(float value);
	inline int location_iterations(void);
	inline void location_iterations(int value);
	inline int cluster_iterations(void);
	inline void cluster_iterations(int value);
	inline bool use_shape_match(void);
	inline void use_shape_match(int value);
	inline bool use_bending_constraints(void);
	inline void use_bending_constraints(int value);
	inline bool use_cluster_rigid_to_softbody(void);
	inline void use_cluster_rigid_to_softbody(int value);
	inline bool use_cluster_soft_to_softbody(void);
	inline void use_cluster_soft_to_softbody(int value);

};

/**************** Soft Body Settings ****************/

class SoftBodySettings : public Pointer {
public:
	SoftBodySettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float friction(void);
	inline void friction(float value);
	inline float mass(void);
	inline void mass(float value);
	inline std::string vertex_group_mass(void);	inline void vertex_group_mass(const std::string& value);
	inline float gravity(void);
	inline void gravity(float value);
	inline float speed(void);
	inline void speed(float value);
	inline std::string vertex_group_goal(void);	inline void vertex_group_goal(const std::string& value);
	inline float goal_min(void);
	inline void goal_min(float value);
	inline float goal_max(void);
	inline void goal_max(float value);
	inline float goal_default(void);
	inline void goal_default(float value);
	inline float goal_spring(void);
	inline void goal_spring(float value);
	inline float goal_friction(void);
	inline void goal_friction(float value);
	inline float pull(void);
	inline void pull(float value);
	inline float push(void);
	inline void push(float value);
	inline float damping(void);
	inline void damping(float value);
	inline int spring_length(void);
	inline void spring_length(int value);
	inline int aero(void);
	inline void aero(int value);
	inline int plastic(void);
	inline void plastic(int value);
	inline float bend(void);
	inline void bend(float value);
	inline float shear(void);
	inline void shear(float value);
	inline std::string vertex_group_spring(void);	inline void vertex_group_spring(const std::string& value);
	enum collision_type_enum {
		collision_type_MANUAL = 0,
		collision_type_AVERAGE = 1,
		collision_type_MINIMAL = 2,
		collision_type_MAXIMAL = 3,
		collision_type_MINMAX = 4,
	};
	inline collision_type_enum collision_type(void);
	inline void collision_type(collision_type_enum value);
	inline float ball_size(void);
	inline void ball_size(float value);
	inline float ball_stiff(void);
	inline void ball_stiff(float value);
	inline float ball_damp(void);
	inline void ball_damp(float value);
	inline float error_threshold(void);
	inline void error_threshold(float value);
	inline int step_min(void);
	inline void step_min(int value);
	inline int step_max(void);
	inline void step_max(int value);
	inline int choke(void);
	inline void choke(int value);
	inline int fuzzy(void);
	inline void fuzzy(int value);
	inline bool use_auto_step(void);
	inline void use_auto_step(int value);
	inline bool use_diagnose(void);
	inline void use_diagnose(int value);
	inline bool use_estimate_matrix(void);
	inline void use_estimate_matrix(int value);
	inline Array<float, 3> location_mass_center(void);
	inline void location_mass_center(float values[3]);
	inline Array<float, 9> rotation_estimate(void);
	inline void rotation_estimate(float values[9]);
	inline Array<float, 9> scale_estimate(void);
	inline void scale_estimate(float values[9]);
	inline bool use_goal(void);
	inline void use_goal(int value);
	inline bool use_edges(void);
	inline void use_edges(int value);
	inline bool use_stiff_quads(void);
	inline void use_stiff_quads(int value);
	inline bool use_edge_collision(void);
	inline void use_edge_collision(int value);
	inline bool use_face_collision(void);
	inline void use_face_collision(int value);
	enum aerodynamics_type_enum {
		aerodynamics_type_SIMPLE = 0,
		aerodynamics_type_LIFT_FORCE = 1,
	};
	inline aerodynamics_type_enum aerodynamics_type(void);
	inline void aerodynamics_type(aerodynamics_type_enum value);
	inline bool use_self_collision(void);
	inline void use_self_collision(int value);
	inline EffectorWeights effector_weights(void);

};

/**************** Packed File ****************/

class PackedFile : public Pointer {
public:
	PackedFile(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int size(void);
	inline void size(int value);
	inline std::string data(void);	inline void data(const std::string& value);

};

/**************** Particle Target ****************/

class ParticleTarget : public Pointer {
public:
	ParticleTarget(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline Object object(void);
	inline int system(void);
	inline void system(int value);
	inline float time(void);
	inline void time(float value);
	inline float duration(void);
	inline void duration(float value);
	inline bool is_valid(void);
	inline void is_valid(int value);
	enum alliance_enum {
		alliance_FRIEND = 1,
		alliance_NEUTRAL = 0,
		alliance_ENEMY = 2,
	};
	inline alliance_enum alliance(void);
	inline void alliance(alliance_enum value);

};

/**************** SPH Fluid Settings ****************/

class SPHFluidSettings : public Pointer {
public:
	SPHFluidSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum solver_enum {
		solver_DDR = 0,
		solver_CLASSICAL = 1,
	};
	inline solver_enum solver(void);
	inline void solver(solver_enum value);
	inline float spring_force(void);
	inline void spring_force(float value);
	inline float fluid_radius(void);
	inline void fluid_radius(float value);
	inline float rest_length(void);
	inline void rest_length(float value);
	inline bool use_viscoelastic_springs(void);
	inline void use_viscoelastic_springs(int value);
	inline bool use_initial_rest_length(void);
	inline void use_initial_rest_length(int value);
	inline float plasticity(void);
	inline void plasticity(float value);
	inline float yield_ratio(void);
	inline void yield_ratio(float value);
	inline int spring_frames(void);
	inline void spring_frames(int value);
	inline float linear_viscosity(void);
	inline void linear_viscosity(float value);
	inline float stiff_viscosity(void);
	inline void stiff_viscosity(float value);
	inline float stiffness(void);
	inline void stiffness(float value);
	inline float repulsion(void);
	inline void repulsion(float value);
	inline float rest_density(void);
	inline void rest_density(float value);
	inline float buoyancy(void);
	inline void buoyancy(float value);
	inline bool factor_repulsion(void);
	inline void factor_repulsion(int value);
	inline bool use_factor_density(void);
	inline void use_factor_density(int value);
	inline bool factor_radius(void);
	inline void factor_radius(int value);
	inline bool factor_stiff_viscosity(void);
	inline void factor_stiff_viscosity(int value);
	inline bool factor_rest_length(void);
	inline void factor_rest_length(int value);

};

/**************** Particle Hair Key ****************/

class ParticleHairKey : public Pointer {
public:
	ParticleHairKey(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float time(void);
	inline void time(float value);
	inline float weight(void);
	inline void weight(float value);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 3> co_local(void);
	inline void co_local(float values[3]);

	inline void co_object(Object object, ParticleSystemModifier modifier, Particle particle, float co[3]);
};

/**************** Particle Key ****************/

class ParticleKey : public Pointer {
public:
	ParticleKey(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> location(void);
	inline void location(float values[3]);
	inline Array<float, 3> velocity(void);
	inline void velocity(float values[3]);
	inline Array<float, 4> rotation(void);
	inline void rotation(float values[4]);
	inline Array<float, 3> angular_velocity(void);
	inline void angular_velocity(float values[3]);
	inline float time(void);
	inline void time(float value);

};

/**************** Child Particle ****************/

class ChildParticle : public Pointer {
public:
	ChildParticle(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Particle ****************/

class Particle : public Pointer {
public:
	Particle(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		hair_keys(ptr_arg),
		particle_keys(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> location(void);
	inline void location(float values[3]);
	inline Array<float, 3> velocity(void);
	inline void velocity(float values[3]);
	inline Array<float, 3> angular_velocity(void);
	inline void angular_velocity(float values[3]);
	inline Array<float, 4> rotation(void);
	inline void rotation(float values[4]);
	inline Array<float, 3> prev_location(void);
	inline void prev_location(float values[3]);
	inline Array<float, 3> prev_velocity(void);
	inline void prev_velocity(float values[3]);
	inline Array<float, 3> prev_angular_velocity(void);
	inline void prev_angular_velocity(float values[3]);
	inline Array<float, 4> prev_rotation(void);
	inline void prev_rotation(float values[4]);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ParticleHairKey, Particle, hair_keys, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ParticleKey, Particle, particle_keys, true, true, false)
	inline float birth_time(void);
	inline void birth_time(float value);
	inline float lifetime(void);
	inline void lifetime(float value);
	inline float die_time(void);
	inline void die_time(float value);
	inline float size(void);
	inline void size(float value);
	inline bool is_exist(void);
	inline void is_exist(int value);
	inline bool is_visible(void);
	inline void is_visible(int value);
	enum alive_state_enum {
		alive_state_DEAD = 1,
		alive_state_UNBORN = 2,
		alive_state_ALIVE = 3,
		alive_state_DYING = 4,
	};
	inline alive_state_enum alive_state(void);
	inline void alive_state(alive_state_enum value);

	inline void uv_on_emitter(ParticleSystemModifier modifier, float uv[2]);
};

/**************** Particle Dupliobject Weight ****************/

class ParticleDupliWeight : public Pointer {
public:
	ParticleDupliWeight(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline int count(void);
	inline void count(int value);

};

/**************** Particle System ****************/

class ParticleSystem : public Pointer {
public:
	ParticleSystem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		particles(ptr_arg),
		child_particles(ptr_arg),
		targets(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline ParticleSettings settings(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Particle, ParticleSystem, particles, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ChildParticle, ParticleSystem, child_particles, true, true, false)
	inline int seed(void);
	inline void seed(int value);
	inline int child_seed(void);
	inline void child_seed(int value);
	inline bool is_global_hair(void);
	inline void is_global_hair(int value);
	inline bool use_hair_dynamics(void);
	inline void use_hair_dynamics(int value);
	inline ClothModifier cloth(void);
	inline Object reactor_target_object(void);
	inline int reactor_target_particle_system(void);
	inline void reactor_target_particle_system(int value);
	inline bool use_keyed_timing(void);
	inline void use_keyed_timing(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ParticleTarget, ParticleSystem, targets, false, true, true)
	inline ParticleTarget active_particle_target(void);
	inline int active_particle_target_index(void);
	inline void active_particle_target_index(int value);
	inline std::string billboard_normal_uv(void);	inline void billboard_normal_uv(const std::string& value);
	inline std::string billboard_time_index_uv(void);	inline void billboard_time_index_uv(const std::string& value);
	inline std::string billboard_split_uv(void);	inline void billboard_split_uv(const std::string& value);
	inline std::string vertex_group_density(void);	inline void vertex_group_density(const std::string& value);
	inline bool invert_vertex_group_density(void);
	inline void invert_vertex_group_density(int value);
	inline std::string vertex_group_velocity(void);	inline void vertex_group_velocity(const std::string& value);
	inline bool invert_vertex_group_velocity(void);
	inline void invert_vertex_group_velocity(int value);
	inline std::string vertex_group_length(void);	inline void vertex_group_length(const std::string& value);
	inline bool invert_vertex_group_length(void);
	inline void invert_vertex_group_length(int value);
	inline std::string vertex_group_clump(void);	inline void vertex_group_clump(const std::string& value);
	inline bool invert_vertex_group_clump(void);
	inline void invert_vertex_group_clump(int value);
	inline std::string vertex_group_kink(void);	inline void vertex_group_kink(const std::string& value);
	inline bool invert_vertex_group_kink(void);
	inline void invert_vertex_group_kink(int value);
	inline std::string vertex_group_roughness_1(void);	inline void vertex_group_roughness_1(const std::string& value);
	inline bool invert_vertex_group_roughness_1(void);
	inline void invert_vertex_group_roughness_1(int value);
	inline std::string vertex_group_roughness_2(void);	inline void vertex_group_roughness_2(const std::string& value);
	inline bool invert_vertex_group_roughness_2(void);
	inline void invert_vertex_group_roughness_2(int value);
	inline std::string vertex_group_roughness_end(void);	inline void vertex_group_roughness_end(const std::string& value);
	inline bool invert_vertex_group_roughness_end(void);
	inline void invert_vertex_group_roughness_end(int value);
	inline std::string vertex_group_size(void);	inline void vertex_group_size(const std::string& value);
	inline bool invert_vertex_group_size(void);
	inline void invert_vertex_group_size(int value);
	inline std::string vertex_group_tangent(void);	inline void vertex_group_tangent(const std::string& value);
	inline bool invert_vertex_group_tangent(void);
	inline void invert_vertex_group_tangent(int value);
	inline std::string vertex_group_rotation(void);	inline void vertex_group_rotation(const std::string& value);
	inline bool invert_vertex_group_rotation(void);
	inline void invert_vertex_group_rotation(int value);
	inline std::string vertex_group_field(void);	inline void vertex_group_field(const std::string& value);
	inline bool invert_vertex_group_field(void);
	inline void invert_vertex_group_field(int value);
	inline PointCache point_cache(void);
	inline bool has_multiple_caches(void);
	inline void has_multiple_caches(int value);
	inline Object parent(void);
	inline bool is_editable(void);
	inline void is_editable(int value);
	inline bool is_edited(void);
	inline void is_edited(int value);
	inline float dt_frac(void);
	inline void dt_frac(float value);

	inline void set_resolution(Scene scene, Object object, int resolution);
	inline void co_hair(Object object, int particle_no, int step, float co[3]);
	inline void uv_on_emitter(ParticleSystemModifier modifier, Particle particle, int particle_no, int uv_no, float uv[2]);
	inline void mcol_on_emitter(ParticleSystemModifier modifier, Particle particle, int particle_no, int vcol_no, float mcol[3]);
};

/**************** Particle Settings Texture Slot ****************/

class ParticleSettingsTextureSlot : public TextureSlot {
public:
	ParticleSettingsTextureSlot(const PointerRNA &ptr_arg) :
		TextureSlot(ptr_arg)
		{}

	enum texture_coords_enum {
		texture_coords_GLOBAL = 8,
		texture_coords_OBJECT = 32,
		texture_coords_UV = 16,
		texture_coords_ORCO = 1,
		texture_coords_STRAND = 8192,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline Object object(void);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	enum mapping_x_enum {
		mapping_x_NONE = 0,
		mapping_x_X = 1,
		mapping_x_Y = 2,
		mapping_x_Z = 3,
	};
	inline mapping_x_enum mapping_x(void);
	inline void mapping_x(mapping_x_enum value);
	enum mapping_y_enum {
		mapping_y_NONE = 0,
		mapping_y_X = 1,
		mapping_y_Y = 2,
		mapping_y_Z = 3,
	};
	inline mapping_y_enum mapping_y(void);
	inline void mapping_y(mapping_y_enum value);
	enum mapping_z_enum {
		mapping_z_NONE = 0,
		mapping_z_X = 1,
		mapping_z_Y = 2,
		mapping_z_Z = 3,
	};
	inline mapping_z_enum mapping_z(void);
	inline void mapping_z(mapping_z_enum value);
	enum mapping_enum {
		mapping_FLAT = 0,
		mapping_CUBE = 1,
		mapping_TUBE = 2,
		mapping_SPHERE = 3,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool use_map_time(void);
	inline void use_map_time(int value);
	inline bool use_map_life(void);
	inline void use_map_life(int value);
	inline bool use_map_density(void);
	inline void use_map_density(int value);
	inline bool use_map_size(void);
	inline void use_map_size(int value);
	inline bool use_map_velocity(void);
	inline void use_map_velocity(int value);
	inline bool use_map_field(void);
	inline void use_map_field(int value);
	inline bool use_map_gravity(void);
	inline void use_map_gravity(int value);
	inline bool use_map_damp(void);
	inline void use_map_damp(int value);
	inline bool use_map_clump(void);
	inline void use_map_clump(int value);
	inline bool use_map_kink(void);
	inline void use_map_kink(int value);
	inline bool use_map_rough(void);
	inline void use_map_rough(int value);
	inline bool use_map_length(void);
	inline void use_map_length(int value);
	inline float time_factor(void);
	inline void time_factor(float value);
	inline float life_factor(void);
	inline void life_factor(float value);
	inline float density_factor(void);
	inline void density_factor(float value);
	inline float size_factor(void);
	inline void size_factor(float value);
	inline float velocity_factor(void);
	inline void velocity_factor(float value);
	inline float field_factor(void);
	inline void field_factor(float value);
	inline float gravity_factor(void);
	inline void gravity_factor(float value);
	inline float damp_factor(void);
	inline void damp_factor(float value);
	inline float length_factor(void);
	inline void length_factor(float value);
	inline float clump_factor(void);
	inline void clump_factor(float value);
	inline float kink_factor(void);
	inline void kink_factor(float value);
	inline float rough_factor(void);
	inline void rough_factor(float value);

};

/**************** Particle Settings ****************/

class ParticleSettings : public ID {
public:
	ParticleSettings(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		texture_slots(ptr_arg),
		dupli_weights(ptr_arg)
		{}

	COLLECTION_PROPERTY(ParticleSettingsTextureSlots, ParticleSettingsTextureSlot, ParticleSettings, texture_slots, false, false, false)
	inline Texture active_texture(void);
	inline int active_texture_index(void);
	inline void active_texture_index(int value);
	inline bool is_fluid(void);
	inline void is_fluid(int value);
	inline bool use_react_start_end(void);
	inline void use_react_start_end(int value);
	inline bool use_react_multiple(void);
	inline void use_react_multiple(int value);
	inline bool regrow_hair(void);
	inline void regrow_hair(int value);
	inline bool show_unborn(void);
	inline void show_unborn(int value);
	inline bool use_dead(void);
	inline void use_dead(int value);
	inline bool use_emit_random(void);
	inline void use_emit_random(int value);
	inline bool use_even_distribution(void);
	inline void use_even_distribution(int value);
	inline bool use_die_on_collision(void);
	inline void use_die_on_collision(int value);
	inline bool use_size_deflect(void);
	inline void use_size_deflect(int value);
	inline bool use_rotations(void);
	inline void use_rotations(int value);
	inline bool use_dynamic_rotation(void);
	inline void use_dynamic_rotation(int value);
	inline bool use_multiply_size_mass(void);
	inline void use_multiply_size_mass(int value);
	inline bool use_advanced_hair(void);
	inline void use_advanced_hair(int value);
	inline bool lock_boids_to_surface(void);
	inline void lock_boids_to_surface(int value);
	inline bool use_hair_bspline(void);
	inline void use_hair_bspline(int value);
	inline bool invert_grid(void);
	inline void invert_grid(int value);
	inline bool hexagonal_grid(void);
	inline void hexagonal_grid(int value);
	inline bool apply_effector_to_children(void);
	inline void apply_effector_to_children(int value);
	inline bool create_long_hair_children(void);
	inline void create_long_hair_children(int value);
	inline bool apply_guide_to_children(void);
	inline void apply_guide_to_children(int value);
	inline bool use_self_effect(void);
	inline void use_self_effect(int value);
	enum type_enum {
		type_EMITTER = 0,
		type_HAIR = 2,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum emit_from_enum {
		emit_from_VERT = 0,
		emit_from_FACE = 1,
		emit_from_VOLUME = 2,
	};
	inline emit_from_enum emit_from(void);
	inline void emit_from(emit_from_enum value);
	enum distribution_enum {
		distribution_JIT = 0,
		distribution_RAND = 1,
		distribution_GRID = 2,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);
	enum physics_type_enum {
		physics_type_NO = 0,
		physics_type_NEWTON = 1,
		physics_type_KEYED = 2,
		physics_type_BOIDS = 3,
		physics_type_FLUID = 4,
	};
	inline physics_type_enum physics_type(void);
	inline void physics_type(physics_type_enum value);
	enum rotation_mode_enum {
		rotation_mode_NONE = 0,
		rotation_mode_NOR = 1,
		rotation_mode_NOR_TAN = 9,
		rotation_mode_VEL = 2,
		rotation_mode_GLOB_X = 3,
		rotation_mode_GLOB_Y = 4,
		rotation_mode_GLOB_Z = 5,
		rotation_mode_OB_X = 6,
		rotation_mode_OB_Y = 7,
		rotation_mode_OB_Z = 8,
	};
	inline rotation_mode_enum rotation_mode(void);
	inline void rotation_mode(rotation_mode_enum value);
	enum angular_velocity_mode_enum {
		angular_velocity_mode_NONE = 0,
		angular_velocity_mode_VELOCITY = 1,
		angular_velocity_mode_HORIZONTAL = 3,
		angular_velocity_mode_VERTICAL = 4,
		angular_velocity_mode_GLOBAL_X = 5,
		angular_velocity_mode_GLOBAL_Y = 6,
		angular_velocity_mode_GLOBAL_Z = 7,
		angular_velocity_mode_RAND = 2,
	};
	inline angular_velocity_mode_enum angular_velocity_mode(void);
	inline void angular_velocity_mode(angular_velocity_mode_enum value);
	enum react_event_enum {
		react_event_DEATH = 0,
		react_event_COLLIDE = 1,
		react_event_NEAR = 2,
	};
	inline react_event_enum react_event(void);
	inline void react_event(react_event_enum value);
	inline bool show_velocity(void);
	inline void show_velocity(int value);
	inline bool show_size(void);
	inline void show_size(int value);
	inline bool use_render_emitter(void);
	inline void use_render_emitter(int value);
	inline bool show_health(void);
	inline void show_health(int value);
	inline bool use_absolute_path_time(void);
	inline void use_absolute_path_time(int value);
	inline bool use_parent_particles(void);
	inline void use_parent_particles(int value);
	inline bool show_number(void);
	inline void show_number(int value);
	inline bool use_group_pick_random(void);
	inline void use_group_pick_random(int value);
	inline bool use_group_count(void);
	inline void use_group_count(int value);
	inline bool use_global_dupli(void);
	inline void use_global_dupli(int value);
	inline bool use_rotation_dupli(void);
	inline void use_rotation_dupli(int value);
	inline bool use_scale_dupli(void);
	inline void use_scale_dupli(int value);
	inline bool use_render_adaptive(void);
	inline void use_render_adaptive(int value);
	inline bool use_velocity_length(void);
	inline void use_velocity_length(int value);
	inline bool use_whole_group(void);
	inline void use_whole_group(int value);
	inline bool use_strand_primitive(void);
	inline void use_strand_primitive(int value);
	enum draw_method_enum {
		draw_method_NONE = 0,
		draw_method_RENDER = 10,
		draw_method_DOT = 1,
		draw_method_CIRC = 2,
		draw_method_CROSS = 3,
		draw_method_AXIS = 4,
	};
	inline draw_method_enum draw_method(void);
	inline void draw_method(draw_method_enum value);
	enum render_type_enum {
		render_type_NONE = 0,
		render_type_HALO = 1,
		render_type_LINE = 5,
		render_type_PATH = 6,
		render_type_OBJECT = 7,
		render_type_GROUP = 8,
		render_type_BILLBOARD = 9,
	};
	inline render_type_enum render_type(void);
	inline void render_type(render_type_enum value);
	enum draw_color_enum {
		draw_color_NONE = 0,
		draw_color_MATERIAL = 1,
		draw_color_VELOCITY = 2,
		draw_color_ACCELERATION = 3,
	};
	inline draw_color_enum draw_color(void);
	inline void draw_color(draw_color_enum value);
	inline int draw_size(void);
	inline void draw_size(int value);
	enum child_type_enum {
		child_type_NONE = 0,
		child_type_SIMPLE = 1,
		child_type_INTERPOLATED = 2,
	};
	inline child_type_enum child_type(void);
	inline void child_type(child_type_enum value);
	inline int draw_step(void);
	inline void draw_step(int value);
	inline int render_step(void);
	inline void render_step(int value);
	inline int hair_step(void);
	inline void hair_step(int value);
	inline int keys_step(void);
	inline void keys_step(int value);
	inline int adaptive_angle(void);
	inline void adaptive_angle(int value);
	inline int adaptive_pixel(void);
	inline void adaptive_pixel(int value);
	inline int draw_percentage(void);
	inline void draw_percentage(int value);
	inline int material(void);
	inline void material(int value);
	enum material_slot_enum {
		material_slot_DUMMY = 0,
	};
	inline material_slot_enum material_slot(void);
	inline void material_slot(material_slot_enum value);
	enum integrator_enum {
		integrator_EULER = 0,
		integrator_VERLET = 3,
		integrator_MIDPOINT = 1,
		integrator_RK4 = 2,
	};
	inline integrator_enum integrator(void);
	inline void integrator(integrator_enum value);
	enum kink_enum {
		kink_NO = 0,
		kink_CURL = 1,
		kink_RADIAL = 2,
		kink_WAVE = 3,
		kink_BRAID = 4,
	};
	inline kink_enum kink(void);
	inline void kink(kink_enum value);
	enum kink_axis_enum {
		kink_axis_X = 0,
		kink_axis_Y = 1,
		kink_axis_Z = 2,
	};
	inline kink_axis_enum kink_axis(void);
	inline void kink_axis(kink_axis_enum value);
	inline bool lock_billboard(void);
	inline void lock_billboard(int value);
	enum billboard_align_enum {
		billboard_align_X = 0,
		billboard_align_Y = 1,
		billboard_align_Z = 2,
		billboard_align_VIEW = 3,
		billboard_align_VEL = 4,
	};
	inline billboard_align_enum billboard_align(void);
	inline void billboard_align(billboard_align_enum value);
	inline int billboard_uv_split(void);
	inline void billboard_uv_split(int value);
	enum billboard_animation_enum {
		billboard_animation_NONE = 0,
		billboard_animation_AGE = 1,
		billboard_animation_FRAME = 3,
		billboard_animation_ANGLE = 2,
	};
	inline billboard_animation_enum billboard_animation(void);
	inline void billboard_animation(billboard_animation_enum value);
	enum billboard_offset_split_enum {
		billboard_offset_split_NONE = 0,
		billboard_offset_split_LINEAR = 1,
		billboard_offset_split_RANDOM = 2,
	};
	inline billboard_offset_split_enum billboard_offset_split(void);
	inline void billboard_offset_split(billboard_offset_split_enum value);
	inline float billboard_tilt(void);
	inline void billboard_tilt(float value);
	inline float color_maximum(void);
	inline void color_maximum(float value);
	inline float billboard_tilt_random(void);
	inline void billboard_tilt_random(float value);
	inline Array<float, 2> billboard_offset(void);
	inline void billboard_offset(float values[2]);
	inline Array<float, 2> billboard_size(void);
	inline void billboard_size(float values[2]);
	inline float billboard_velocity_head(void);
	inline void billboard_velocity_head(float value);
	inline float billboard_velocity_tail(void);
	inline void billboard_velocity_tail(float value);
	inline bool use_simplify(void);
	inline void use_simplify(int value);
	inline bool use_simplify_viewport(void);
	inline void use_simplify_viewport(int value);
	inline int simplify_refsize(void);
	inline void simplify_refsize(int value);
	inline float simplify_rate(void);
	inline void simplify_rate(float value);
	inline float simplify_transition(void);
	inline void simplify_transition(float value);
	inline float simplify_viewport(void);
	inline void simplify_viewport(float value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);
	inline float lifetime(void);
	inline void lifetime(float value);
	inline float lifetime_random(void);
	inline void lifetime_random(float value);
	inline float time_tweak(void);
	inline void time_tweak(float value);
	inline float timestep(void);
	inline void timestep(float value);
	inline bool use_adaptive_subframes(void);
	inline void use_adaptive_subframes(int value);
	inline int subframes(void);
	inline void subframes(int value);
	inline float courant_target(void);
	inline void courant_target(float value);
	inline float jitter_factor(void);
	inline void jitter_factor(float value);
	inline float effect_hair(void);
	inline void effect_hair(float value);
	inline int count(void);
	inline void count(int value);
	inline int userjit(void);
	inline void userjit(int value);
	inline int grid_resolution(void);
	inline void grid_resolution(int value);
	inline float grid_random(void);
	inline void grid_random(float value);
	inline int effector_amount(void);
	inline void effector_amount(int value);
	inline float normal_factor(void);
	inline void normal_factor(float value);
	inline float object_factor(void);
	inline void object_factor(float value);
	inline float factor_random(void);
	inline void factor_random(float value);
	inline float particle_factor(void);
	inline void particle_factor(float value);
	inline float tangent_factor(void);
	inline void tangent_factor(float value);
	inline float tangent_phase(void);
	inline void tangent_phase(float value);
	inline float reactor_factor(void);
	inline void reactor_factor(float value);
	inline Array<float, 3> object_align_factor(void);
	inline void object_align_factor(float values[3]);
	inline float angular_velocity_factor(void);
	inline void angular_velocity_factor(float value);
	inline float phase_factor(void);
	inline void phase_factor(float value);
	inline float rotation_factor_random(void);
	inline void rotation_factor_random(float value);
	inline float phase_factor_random(void);
	inline void phase_factor_random(float value);
	inline float hair_length(void);
	inline void hair_length(float value);
	inline float mass(void);
	inline void mass(float value);
	inline float particle_size(void);
	inline void particle_size(float value);
	inline float size_random(void);
	inline void size_random(float value);
	inline float drag_factor(void);
	inline void drag_factor(float value);
	inline float brownian_factor(void);
	inline void brownian_factor(float value);
	inline float damping(void);
	inline void damping(float value);
	inline float length_random(void);
	inline void length_random(float value);
	inline int child_nbr(void);
	inline void child_nbr(int value);
	inline int rendered_child_count(void);
	inline void rendered_child_count(int value);
	inline float virtual_parents(void);
	inline void virtual_parents(float value);
	inline float child_size(void);
	inline void child_size(float value);
	inline float child_size_random(void);
	inline void child_size_random(float value);
	inline float child_radius(void);
	inline void child_radius(float value);
	inline float child_roundness(void);
	inline void child_roundness(float value);
	inline float clump_factor(void);
	inline void clump_factor(float value);
	inline float clump_shape(void);
	inline void clump_shape(float value);
	inline float kink_amplitude(void);
	inline void kink_amplitude(float value);
	inline float kink_amplitude_clump(void);
	inline void kink_amplitude_clump(float value);
	inline float kink_frequency(void);
	inline void kink_frequency(float value);
	inline float kink_shape(void);
	inline void kink_shape(float value);
	inline float kink_flat(void);
	inline void kink_flat(float value);
	inline float roughness_1(void);
	inline void roughness_1(float value);
	inline float roughness_1_size(void);
	inline void roughness_1_size(float value);
	inline float roughness_2(void);
	inline void roughness_2(float value);
	inline float roughness_2_size(void);
	inline void roughness_2_size(float value);
	inline float roughness_2_threshold(void);
	inline void roughness_2_threshold(float value);
	inline float roughness_endpoint(void);
	inline void roughness_endpoint(float value);
	inline float roughness_end_shape(void);
	inline void roughness_end_shape(float value);
	inline float child_length(void);
	inline void child_length(float value);
	inline float child_length_threshold(void);
	inline void child_length_threshold(float value);
	inline float child_parting_factor(void);
	inline void child_parting_factor(float value);
	inline float child_parting_min(void);
	inline void child_parting_min(float value);
	inline float child_parting_max(void);
	inline void child_parting_max(float value);
	inline float branch_threshold(void);
	inline void branch_threshold(float value);
	inline float line_length_tail(void);
	inline void line_length_tail(float value);
	inline float line_length_head(void);
	inline void line_length_head(float value);
	inline float path_start(void);
	inline void path_start(float value);
	inline float path_end(void);
	inline void path_end(float value);
	inline int trail_count(void);
	inline void trail_count(int value);
	inline int keyed_loops(void);
	inline void keyed_loops(int value);
	inline bool use_modifier_stack(void);
	inline void use_modifier_stack(int value);
	inline Group dupli_group(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ParticleDupliWeight, ParticleSettings, dupli_weights, false, true, true)
	inline ParticleDupliWeight active_dupliweight(void);
	inline int active_dupliweight_index(void);
	inline void active_dupliweight_index(int value);
	inline Object dupli_object(void);
	inline Object billboard_object(void);
	inline BoidSettings boids(void);
	inline SPHFluidSettings fluid(void);
	inline EffectorWeights effector_weights(void);
	inline AnimData animation_data(void);
	inline FieldSettings force_field_1(void);
	inline FieldSettings force_field_2(void);

};

/**************** Pose ****************/

class Pose : public Pointer {
public:
	Pose(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		bones(ptr_arg),
		bone_groups(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, PoseBone, Pose, bones, false, true, true)
	COLLECTION_PROPERTY(BoneGroups, BoneGroup, Pose, bone_groups, false, true, true)
	enum ik_solver_enum {
		ik_solver_LEGACY = 0,
		ik_solver_ITASC = 1,
	};
	inline ik_solver_enum ik_solver(void);
	inline void ik_solver(ik_solver_enum value);
	inline IKParam ik_param(void);
	inline AnimViz animation_visualization(void);

};

/**************** Pose Bone ****************/

class PoseBone : public Pointer {
public:
	PoseBone(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		constraints(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(PoseBoneConstraints, Constraint, PoseBone, constraints, false, true, true)
	inline std::string name(void);	inline void name(const std::string& value);
	inline MotionPath motion_path(void);
	inline Bone bone(void);
	inline PoseBone parent(void);
	inline PoseBone child(void);
	inline Array<float, 3> location(void);
	inline void location(float values[3]);
	inline Array<float, 3> scale(void);
	inline void scale(float values[3]);
	inline Array<float, 4> rotation_quaternion(void);
	inline void rotation_quaternion(float values[4]);
	inline Array<float, 4> rotation_axis_angle(void);
	inline void rotation_axis_angle(float values[4]);
	inline Array<float, 3> rotation_euler(void);
	inline void rotation_euler(float values[3]);
	enum rotation_mode_enum {
		rotation_mode_QUATERNION = 0,
		rotation_mode_XYZ = 1,
		rotation_mode_XZY = 2,
		rotation_mode_YXZ = 3,
		rotation_mode_YZX = 4,
		rotation_mode_ZXY = 5,
		rotation_mode_ZYX = 6,
		rotation_mode_AXIS_ANGLE = -1,
	};
	inline rotation_mode_enum rotation_mode(void);
	inline void rotation_mode(rotation_mode_enum value);
	inline Array<float, 16> matrix_channel(void);
	inline void matrix_channel(float values[16]);
	inline Array<float, 16> matrix_basis(void);
	inline void matrix_basis(float values[16]);
	inline Array<float, 16> matrix(void);
	inline void matrix(float values[16]);
	inline Array<float, 3> head(void);
	inline void head(float values[3]);
	inline Array<float, 3> tail(void);
	inline void tail(float values[3]);
	inline bool is_in_ik_chain(void);
	inline void is_in_ik_chain(int value);
	inline bool lock_ik_x(void);
	inline void lock_ik_x(int value);
	inline bool lock_ik_y(void);
	inline void lock_ik_y(int value);
	inline bool lock_ik_z(void);
	inline void lock_ik_z(int value);
	inline bool use_ik_limit_x(void);
	inline void use_ik_limit_x(int value);
	inline bool use_ik_limit_y(void);
	inline void use_ik_limit_y(int value);
	inline bool use_ik_limit_z(void);
	inline void use_ik_limit_z(int value);
	inline bool use_ik_rotation_control(void);
	inline void use_ik_rotation_control(int value);
	inline bool use_ik_linear_control(void);
	inline void use_ik_linear_control(int value);
	inline float ik_min_x(void);
	inline void ik_min_x(float value);
	inline float ik_max_x(void);
	inline void ik_max_x(float value);
	inline float ik_min_y(void);
	inline void ik_min_y(float value);
	inline float ik_max_y(void);
	inline void ik_max_y(float value);
	inline float ik_min_z(void);
	inline void ik_min_z(float value);
	inline float ik_max_z(void);
	inline void ik_max_z(float value);
	inline float ik_stiffness_x(void);
	inline void ik_stiffness_x(float value);
	inline float ik_stiffness_y(void);
	inline void ik_stiffness_y(float value);
	inline float ik_stiffness_z(void);
	inline void ik_stiffness_z(float value);
	inline float ik_stretch(void);
	inline void ik_stretch(float value);
	inline float ik_rotation_weight(void);
	inline void ik_rotation_weight(float value);
	inline float ik_linear_weight(void);
	inline void ik_linear_weight(float value);
	inline Object custom_shape(void);
	inline PoseBone custom_shape_transform(void);
	inline int bone_group_index(void);
	inline void bone_group_index(int value);
	inline BoneGroup bone_group(void);
	inline Array<int, 3> lock_location(void);
	inline void lock_location(int values[3]);
	inline Array<int, 3> lock_rotation(void);
	inline void lock_rotation(int values[3]);
	inline bool lock_rotation_w(void);
	inline void lock_rotation_w(int value);
	inline bool lock_rotations_4d(void);
	inline void lock_rotations_4d(int value);
	inline Array<int, 3> lock_scale(void);
	inline void lock_scale(int values[3]);

	inline float evaluate_envelope(float point[3]);
};

/**************** IKParam ****************/

class IKParam : public Pointer {
public:
	IKParam(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum ik_solver_enum {
		ik_solver_LEGACY = 0,
		ik_solver_ITASC = 1,
	};
	inline ik_solver_enum ik_solver(void);
	inline void ik_solver(ik_solver_enum value);

};

/**************** bItasc ****************/

class Itasc : public IKParam {
public:
	Itasc(const PointerRNA &ptr_arg) :
		IKParam(ptr_arg)
		{}

	inline float precision(void);
	inline void precision(float value);
	inline int iterations(void);
	inline void iterations(int value);
	inline int step_count(void);
	inline void step_count(int value);
	enum mode_enum {
		mode_ANIMATION = 0,
		mode_SIMULATION = 8,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	enum reiteration_method_enum {
		reiteration_method_NEVER = 0,
		reiteration_method_INITIAL = 2,
		reiteration_method_ALWAYS = 6,
	};
	inline reiteration_method_enum reiteration_method(void);
	inline void reiteration_method(reiteration_method_enum value);
	inline bool use_auto_step(void);
	inline void use_auto_step(int value);
	inline float step_min(void);
	inline void step_min(float value);
	inline float step_max(void);
	inline void step_max(float value);
	inline float feedback(void);
	inline void feedback(float value);
	inline float velocity_max(void);
	inline void velocity_max(float value);
	enum solver_enum {
		solver_SDLS = 0,
		solver_DLS = 1,
	};
	inline solver_enum solver(void);
	inline void solver(solver_enum value);
	inline float damping_max(void);
	inline void damping_max(float value);
	inline float damping_epsilon(void);
	inline void damping_epsilon(float value);

};

/**************** Bone Group ****************/

class BoneGroup : public Pointer {
public:
	BoneGroup(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum color_set_enum {
		color_set_DEFAULT = 0,
		color_set_THEME01 = 1,
		color_set_THEME02 = 2,
		color_set_THEME03 = 3,
		color_set_THEME04 = 4,
		color_set_THEME05 = 5,
		color_set_THEME06 = 6,
		color_set_THEME07 = 7,
		color_set_THEME08 = 8,
		color_set_THEME09 = 9,
		color_set_THEME10 = 10,
		color_set_THEME11 = 11,
		color_set_THEME12 = 12,
		color_set_THEME13 = 13,
		color_set_THEME14 = 14,
		color_set_THEME15 = 15,
		color_set_THEME16 = 16,
		color_set_THEME17 = 17,
		color_set_THEME18 = 18,
		color_set_THEME19 = 19,
		color_set_THEME20 = 20,
		color_set_CUSTOM = -1,
	};
	inline color_set_enum color_set(void);
	inline void color_set(color_set_enum value);
	inline bool is_custom_color_set(void);
	inline void is_custom_color_set(int value);
	inline ThemeBoneColorSet colors(void);

};

/**************** Game Property ****************/

class GameProperty : public Pointer {
public:
	GameProperty(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_BOOL = 0,
		type_INT = 1,
		type_FLOAT = 2,
		type_STRING = 3,
		type_TIMER = 5,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool show_debug(void);
	inline void show_debug(int value);

};

/**************** Game Boolean Property ****************/

class GameBooleanProperty : public GameProperty {
public:
	GameBooleanProperty(const PointerRNA &ptr_arg) :
		GameProperty(ptr_arg)
		{}

	inline bool value(void);
	inline void value(int value);

};

/**************** Game Integer Property ****************/

class GameIntProperty : public GameProperty {
public:
	GameIntProperty(const PointerRNA &ptr_arg) :
		GameProperty(ptr_arg)
		{}

	inline int value(void);
	inline void value(int value);

};

/**************** Game Float Property ****************/

class GameFloatProperty : public GameProperty {
public:
	GameFloatProperty(const PointerRNA &ptr_arg) :
		GameProperty(ptr_arg)
		{}

	inline float value(void);
	inline void value(float value);

};

/**************** Game Timer Property ****************/

class GameTimerProperty : public GameProperty {
public:
	GameTimerProperty(const PointerRNA &ptr_arg) :
		GameProperty(ptr_arg)
		{}

	inline float value(void);
	inline void value(float value);

};

/**************** Game String Property ****************/

class GameStringProperty : public GameProperty {
public:
	GameStringProperty(const PointerRNA &ptr_arg) :
		GameProperty(ptr_arg)
		{}

	inline std::string value(void);	inline void value(const std::string& value);

};

/**************** Render Engine ****************/

class RenderEngine : public Pointer {
public:
	RenderEngine(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_animation(void);
	inline void is_animation(int value);
	inline bool is_preview(void);
	inline void is_preview(int value);
	inline Object camera_override(void);
	inline Array<int, 20> layer_override(void);
	inline void layer_override(int values[20]);
	inline int tile_x(void);
	inline void tile_x(int value);
	inline int tile_y(void);
	inline void tile_y(int value);
	inline int resolution_x(void);
	inline void resolution_x(int value);
	inline int resolution_y(void);
	inline void resolution_y(int value);
	inline RenderSettings render(void);
	inline bool use_highlight_tiles(void);
	inline void use_highlight_tiles(int value);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);	inline void bl_label(const std::string& value);
	inline bool bl_use_preview(void);
	inline void bl_use_preview(int value);
	inline bool bl_use_texture_preview(void);
	inline void bl_use_texture_preview(int value);
	inline bool bl_use_postprocess(void);
	inline void bl_use_postprocess(int value);
	inline bool bl_use_shading_nodes(void);
	inline void bl_use_shading_nodes(int value);
	inline bool bl_use_exclude_layers(void);
	inline void bl_use_exclude_layers(int value);
	inline bool bl_use_save_buffers(void);
	inline void bl_use_save_buffers(int value);

	inline void tag_redraw();
	inline void tag_update();
	inline RenderResult begin_result(int x, int y, int w, int h, const char * layer);
	inline void update_result(RenderResult result);
	inline void end_result(RenderResult result, int cancel, int do_merge_results);
	inline int test_break();
	inline void update_stats(const char * stats, const char * info);
	inline void frame_set(int frame, float subframe);
	inline void update_progress(float progress);
	inline void update_memory_stats(float memory_used, float memory_peak);
	inline void report(int type, const char * message);
	inline void bind_display_space_shader(Scene scene);
	inline void unbind_display_space_shader();
	inline int support_display_space_shader(Scene scene);
};

/**************** Render Result ****************/

class RenderResult : public Pointer {
public:
	RenderResult(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		layers(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int resolution_x(void);
	inline void resolution_x(int value);
	inline int resolution_y(void);
	inline void resolution_y(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, RenderLayer, RenderResult, layers, false, false, false)

	inline void load_from_file(const char * filename);
};

/**************** Render Layer ****************/

class RenderLayer : public Pointer {
public:
	RenderLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		passes(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline Material material_override(void);
	inline Group light_override(void);
	inline Array<int, 20> layers(void);
	inline void layers(int values[20]);
	inline Array<int, 20> layers_zmask(void);
	inline void layers_zmask(int values[20]);
	inline Array<int, 20> layers_exclude(void);
	inline void layers_exclude(int values[20]);
	inline bool use(void);
	inline void use(int value);
	inline bool use_zmask(void);
	inline void use_zmask(int value);
	inline bool invert_zmask(void);
	inline void invert_zmask(int value);
	inline bool use_all_z(void);
	inline void use_all_z(int value);
	inline bool use_solid(void);
	inline void use_solid(int value);
	inline bool use_halo(void);
	inline void use_halo(int value);
	inline bool use_ztransp(void);
	inline void use_ztransp(int value);
	inline bool use_sky(void);
	inline void use_sky(int value);
	inline bool use_edge_enhance(void);
	inline void use_edge_enhance(int value);
	inline bool use_strand(void);
	inline void use_strand(int value);
	inline bool use_freestyle(void);
	inline void use_freestyle(int value);
	inline bool use_pass_combined(void);
	inline void use_pass_combined(int value);
	inline bool use_pass_z(void);
	inline void use_pass_z(int value);
	inline bool use_pass_vector(void);
	inline void use_pass_vector(int value);
	inline bool use_pass_normal(void);
	inline void use_pass_normal(int value);
	inline bool use_pass_uv(void);
	inline void use_pass_uv(int value);
	inline bool use_pass_mist(void);
	inline void use_pass_mist(int value);
	inline bool use_pass_object_index(void);
	inline void use_pass_object_index(int value);
	inline bool use_pass_material_index(void);
	inline void use_pass_material_index(int value);
	inline bool use_pass_color(void);
	inline void use_pass_color(int value);
	inline bool use_pass_diffuse(void);
	inline void use_pass_diffuse(int value);
	inline bool use_pass_specular(void);
	inline void use_pass_specular(int value);
	inline bool use_pass_shadow(void);
	inline void use_pass_shadow(int value);
	inline bool use_pass_ambient_occlusion(void);
	inline void use_pass_ambient_occlusion(int value);
	inline bool use_pass_reflection(void);
	inline void use_pass_reflection(int value);
	inline bool use_pass_refraction(void);
	inline void use_pass_refraction(int value);
	inline bool use_pass_emit(void);
	inline void use_pass_emit(int value);
	inline bool use_pass_environment(void);
	inline void use_pass_environment(int value);
	inline bool use_pass_indirect(void);
	inline void use_pass_indirect(int value);
	inline bool exclude_specular(void);
	inline void exclude_specular(int value);
	inline bool exclude_shadow(void);
	inline void exclude_shadow(int value);
	inline bool exclude_ambient_occlusion(void);
	inline void exclude_ambient_occlusion(int value);
	inline bool exclude_reflection(void);
	inline void exclude_reflection(int value);
	inline bool exclude_refraction(void);
	inline void exclude_refraction(int value);
	inline bool exclude_emit(void);
	inline void exclude_emit(int value);
	inline bool exclude_environment(void);
	inline void exclude_environment(int value);
	inline bool exclude_indirect(void);
	inline void exclude_indirect(int value);
	inline bool use_pass_diffuse_direct(void);
	inline void use_pass_diffuse_direct(int value);
	inline bool use_pass_diffuse_indirect(void);
	inline void use_pass_diffuse_indirect(int value);
	inline bool use_pass_diffuse_color(void);
	inline void use_pass_diffuse_color(int value);
	inline bool use_pass_glossy_direct(void);
	inline void use_pass_glossy_direct(int value);
	inline bool use_pass_glossy_indirect(void);
	inline void use_pass_glossy_indirect(int value);
	inline bool use_pass_glossy_color(void);
	inline void use_pass_glossy_color(int value);
	inline bool use_pass_transmission_direct(void);
	inline void use_pass_transmission_direct(int value);
	inline bool use_pass_transmission_indirect(void);
	inline void use_pass_transmission_indirect(int value);
	inline bool use_pass_transmission_color(void);
	inline void use_pass_transmission_color(int value);
	inline bool use_pass_subsurface_direct(void);
	inline void use_pass_subsurface_direct(int value);
	inline bool use_pass_subsurface_indirect(void);
	inline void use_pass_subsurface_indirect(int value);
	inline bool use_pass_subsurface_color(void);
	inline void use_pass_subsurface_color(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, RenderPass, RenderLayer, passes, false, false, false)
	inline DynamicArray<float> rect(void);
	inline void rect(float values[]);

	inline void load_from_file(const char * filename, int x, int y);
};

/**************** Render Pass ****************/

class RenderPass : public Pointer {
public:
	RenderPass(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline std::string channel_id(void);	inline void channel_id(const std::string& value);
	inline int channels(void);
	inline void channels(int value);
	enum type_enum {
		type_COMBINED = 1,
		type_Z = 2,
		type_COLOR = 4,
		type_DIFFUSE = 8,
		type_SPECULAR = 16,
		type_SHADOW = 32,
		type_AO = 64,
		type_REFLECTION = 128,
		type_NORMAL = 256,
		type_VECTOR = 512,
		type_REFRACTION = 1024,
		type_OBJECT_INDEX = 2048,
		type_UV = 4096,
		type_MIST = 16384,
		type_EMIT = 65536,
		type_ENVIRONMENT = 131072,
		type_MATERIAL_INDEX = 262144,
		type_DIFFUSE_DIRECT = 524288,
		type_DIFFUSE_INDIRECT = 1048576,
		type_DIFFUSE_COLOR = 2097152,
		type_GLOSSY_DIRECT = 4194304,
		type_GLOSSY_INDIRECT = 8388608,
		type_GLOSSY_COLOR = 16777216,
		type_TRANSMISSION_DIRECT = 33554432,
		type_TRANSMISSION_INDIRECT = 67108864,
		type_TRANSMISSION_COLOR = 134217728,
		type_SUBSURFACE_DIRECT = 268435456,
		type_SUBSURFACE_INDIRECT = 536870912,
		type_SUBSURFACE_COLOR = 1073741824,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline DynamicArray<float> rect(void);
	inline void rect(float values[]);
	enum debug_type_enum {
		debug_type_BVH_TRAVERSAL_STEPS = 0,
	};
	inline debug_type_enum debug_type(void);
	inline void debug_type(debug_type_enum value);

};

/**************** Bake Pixel ****************/

class BakePixel : public Pointer {
public:
	BakePixel(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int primitive_id(void);
	inline void primitive_id(int value);
	inline Array<float, 2> uv(void);
	inline void uv(float values[2]);
	inline float du_dx(void);
	inline void du_dx(float value);
	inline float du_dy(void);
	inline void du_dy(float value);
	inline float dv_dx(void);
	inline void dv_dx(float value);
	inline float dv_dy(void);
	inline void dv_dy(float value);
	inline BakePixel next(void);

};

/**************** Rigid Body World ****************/

class RigidBodyWorld : public Pointer {
public:
	RigidBodyWorld(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Group group(void);
	inline Group constraints(void);
	inline bool enabled(void);
	inline void enabled(int value);
	inline float time_scale(void);
	inline void time_scale(float value);
	inline int steps_per_second(void);
	inline void steps_per_second(int value);
	inline int solver_iterations(void);
	inline void solver_iterations(int value);
	inline bool use_split_impulse(void);
	inline void use_split_impulse(int value);
	inline PointCache point_cache(void);
	inline EffectorWeights effector_weights(void);

	inline void convex_sweep_test(Object object, float start[3], float end[3], float object_location[3], float hitpoint[3], float normal[3], int *has_hit);
};

/**************** Rigid Body Object ****************/

class RigidBodyObject : public Pointer {
public:
	RigidBodyObject(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_ACTIVE = 0,
		type_PASSIVE = 1,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum mesh_source_enum {
		mesh_source_BASE = 0,
		mesh_source_DEFORM = 1,
		mesh_source_FINAL = 2,
	};
	inline mesh_source_enum mesh_source(void);
	inline void mesh_source(mesh_source_enum value);
	inline bool enabled(void);
	inline void enabled(int value);
	enum collision_shape_enum {
		collision_shape_BOX = 0,
		collision_shape_SPHERE = 1,
		collision_shape_CAPSULE = 2,
		collision_shape_CYLINDER = 3,
		collision_shape_CONE = 4,
		collision_shape_CONVEX_HULL = 5,
		collision_shape_MESH = 6,
	};
	inline collision_shape_enum collision_shape(void);
	inline void collision_shape(collision_shape_enum value);
	inline bool kinematic(void);
	inline void kinematic(int value);
	inline bool use_deform(void);
	inline void use_deform(int value);
	inline float mass(void);
	inline void mass(float value);
	inline bool use_deactivation(void);
	inline void use_deactivation(int value);
	inline bool use_start_deactivated(void);
	inline void use_start_deactivated(int value);
	inline float deactivate_linear_velocity(void);
	inline void deactivate_linear_velocity(float value);
	inline float deactivate_angular_velocity(void);
	inline void deactivate_angular_velocity(float value);
	inline float linear_damping(void);
	inline void linear_damping(float value);
	inline float angular_damping(void);
	inline void angular_damping(float value);
	inline float friction(void);
	inline void friction(float value);
	inline float restitution(void);
	inline void restitution(float value);
	inline bool use_margin(void);
	inline void use_margin(int value);
	inline float collision_margin(void);
	inline void collision_margin(float value);
	inline Array<int, 20> collision_groups(void);
	inline void collision_groups(int values[20]);

};

/**************** Rigid Body Constraint ****************/

class RigidBodyConstraint : public Pointer {
public:
	RigidBodyConstraint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_FIXED = 8,
		type_POINT = 0,
		type_HINGE = 1,
		type_SLIDER = 3,
		type_PISTON = 9,
		type_GENERIC = 5,
		type_GENERIC_SPRING = 6,
		type_MOTOR = 11,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool enabled(void);
	inline void enabled(int value);
	inline bool disable_collisions(void);
	inline void disable_collisions(int value);
	inline Object object1(void);
	inline Object object2(void);
	inline bool use_breaking(void);
	inline void use_breaking(int value);
	inline float breaking_threshold(void);
	inline void breaking_threshold(float value);
	inline bool use_override_solver_iterations(void);
	inline void use_override_solver_iterations(int value);
	inline int solver_iterations(void);
	inline void solver_iterations(int value);
	inline bool use_limit_lin_x(void);
	inline void use_limit_lin_x(int value);
	inline bool use_limit_lin_y(void);
	inline void use_limit_lin_y(int value);
	inline bool use_limit_lin_z(void);
	inline void use_limit_lin_z(int value);
	inline bool use_limit_ang_x(void);
	inline void use_limit_ang_x(int value);
	inline bool use_limit_ang_y(void);
	inline void use_limit_ang_y(int value);
	inline bool use_limit_ang_z(void);
	inline void use_limit_ang_z(int value);
	inline bool use_spring_x(void);
	inline void use_spring_x(int value);
	inline bool use_spring_y(void);
	inline void use_spring_y(int value);
	inline bool use_spring_z(void);
	inline void use_spring_z(int value);
	inline bool use_motor_lin(void);
	inline void use_motor_lin(int value);
	inline bool use_motor_ang(void);
	inline void use_motor_ang(int value);
	inline float limit_lin_x_lower(void);
	inline void limit_lin_x_lower(float value);
	inline float limit_lin_x_upper(void);
	inline void limit_lin_x_upper(float value);
	inline float limit_lin_y_lower(void);
	inline void limit_lin_y_lower(float value);
	inline float limit_lin_y_upper(void);
	inline void limit_lin_y_upper(float value);
	inline float limit_lin_z_lower(void);
	inline void limit_lin_z_lower(float value);
	inline float limit_lin_z_upper(void);
	inline void limit_lin_z_upper(float value);
	inline float limit_ang_x_lower(void);
	inline void limit_ang_x_lower(float value);
	inline float limit_ang_x_upper(void);
	inline void limit_ang_x_upper(float value);
	inline float limit_ang_y_lower(void);
	inline void limit_ang_y_lower(float value);
	inline float limit_ang_y_upper(void);
	inline void limit_ang_y_upper(float value);
	inline float limit_ang_z_lower(void);
	inline void limit_ang_z_lower(float value);
	inline float limit_ang_z_upper(void);
	inline void limit_ang_z_upper(float value);
	inline float spring_stiffness_x(void);
	inline void spring_stiffness_x(float value);
	inline float spring_stiffness_y(void);
	inline void spring_stiffness_y(float value);
	inline float spring_stiffness_z(void);
	inline void spring_stiffness_z(float value);
	inline float spring_damping_x(void);
	inline void spring_damping_x(float value);
	inline float spring_damping_y(void);
	inline void spring_damping_y(float value);
	inline float spring_damping_z(void);
	inline void spring_damping_z(float value);
	inline float motor_lin_target_velocity(void);
	inline void motor_lin_target_velocity(float value);
	inline float motor_lin_max_impulse(void);
	inline void motor_lin_max_impulse(float value);
	inline float motor_ang_target_velocity(void);
	inline void motor_ang_target_velocity(float value);
	inline float motor_ang_max_impulse(void);
	inline void motor_ang_max_impulse(float value);

};

/**************** Scene ****************/

class Scene : public ID {
public:
	Scene(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		object_bases(ptr_arg),
		objects(ptr_arg),
		keying_sets(ptr_arg),
		keying_sets_all(ptr_arg),
		timeline_markers(ptr_arg),
		orientations(ptr_arg)
		{}

	inline Object camera(void);
	inline Scene background_set(void);
	inline World world(void);
	inline Array<float, 3> cursor_location(void);
	inline void cursor_location(float values[3]);
	COLLECTION_PROPERTY(SceneBases, ObjectBase, Scene, object_bases, false, true, true)
	COLLECTION_PROPERTY(SceneObjects, Object, Scene, objects, false, true, true)
	inline Array<int, 20> layers(void);
	inline void layers(int values[20]);
	inline int active_layer(void);
	inline void active_layer(int value);
	inline int frame_current(void);
	inline void frame_current(int value);
	inline float frame_subframe(void);
	inline void frame_subframe(float value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int frame_step(void);
	inline void frame_step(int value);
	inline float frame_current_final(void);
	inline void frame_current_final(float value);
	inline bool lock_frame_selection_to_range(void);
	inline void lock_frame_selection_to_range(int value);
	inline bool use_preview_range(void);
	inline void use_preview_range(int value);
	inline int frame_preview_start(void);
	inline void frame_preview_start(int value);
	inline int frame_preview_end(void);
	inline void frame_preview_end(int value);
	inline bool show_keys_from_selected_only(void);
	inline void show_keys_from_selected_only(int value);
	inline std::string use_stamp_note(void);	inline void use_stamp_note(const std::string& value);
	inline AnimData animation_data(void);
	inline bool is_nla_tweakmode(void);
	inline void is_nla_tweakmode(int value);
	inline bool use_frame_drop(void);
	inline void use_frame_drop(int value);
	enum sync_mode_enum {
		sync_mode_NONE = 0,
		sync_mode_FRAME_DROP = 8,
		sync_mode_AUDIO_SYNC = 2,
	};
	inline sync_mode_enum sync_mode(void);
	inline void sync_mode(sync_mode_enum value);
	inline NodeTree node_tree(void);
	inline bool use_nodes(void);
	inline void use_nodes(int value);
	inline SequenceEditor sequence_editor(void);
	COLLECTION_PROPERTY(KeyingSets, KeyingSet, Scene, keying_sets, false, true, true)
	COLLECTION_PROPERTY(KeyingSetsAll, KeyingSet, Scene, keying_sets_all, false, false, false)
	inline RigidBodyWorld rigidbody_world(void);
	inline ToolSettings tool_settings(void);
	inline UnitSettings unit_settings(void);
	inline Array<float, 3> gravity(void);
	inline void gravity(float values[3]);
	inline bool use_gravity(void);
	inline void use_gravity(int value);
	inline RenderSettings render(void);
	COLLECTION_PROPERTY(TimelineMarkers, TimelineMarker, Scene, timeline_markers, false, true, true)
	inline bool use_audio(void);
	inline void use_audio(int value);
	inline bool use_audio_sync(void);
	inline void use_audio_sync(int value);
	inline bool use_audio_scrub(void);
	inline void use_audio_scrub(int value);
	inline float audio_doppler_speed(void);
	inline void audio_doppler_speed(float value);
	inline float audio_doppler_factor(void);
	inline void audio_doppler_factor(float value);
	enum audio_distance_model_enum {
		audio_distance_model_NONE = 0,
		audio_distance_model_INVERSE = 1,
		audio_distance_model_INVERSE_CLAMPED = 2,
		audio_distance_model_LINEAR = 3,
		audio_distance_model_LINEAR_CLAMPED = 4,
		audio_distance_model_EXPONENT = 5,
		audio_distance_model_EXPONENT_CLAMPED = 6,
	};
	inline audio_distance_model_enum audio_distance_model(void);
	inline void audio_distance_model(audio_distance_model_enum value);
	inline float audio_volume(void);
	inline void audio_volume(float value);
	inline SceneGameData game_settings(void);
	inline GreasePencil grease_pencil(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, TransformOrientation, Scene, orientations, false, true, true)
	inline MovieClip active_clip(void);
	inline ColorManagedViewSettings view_settings(void);
	inline ColorManagedDisplaySettings display_settings(void);
	inline ColorManagedSequencerColorspaceSettings sequencer_colorspace_settings(void);

	inline SequenceEditor sequence_editor_create();
	inline void sequence_editor_clear();
	inline const char * statistics();
	inline void frame_set(int frame, float subframe);
	inline void update();
	inline void ray_cast(float start[3], float end[3], int *result, Object *object, float matrix[16], float location[3], float normal[3]);
};

/**************** Tool Settings ****************/

class ToolSettings : public Pointer {
public:
	ToolSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Sculpt sculpt(void);
	inline bool use_auto_normalize(void);
	inline void use_auto_normalize(int value);
	inline bool use_multipaint(void);
	inline void use_multipaint(int value);
	enum vertex_group_user_enum {
		vertex_group_user_NONE = 0,
		vertex_group_user_ACTIVE = 1,
		vertex_group_user_ALL = 2,
	};
	inline vertex_group_user_enum vertex_group_user(void);
	inline void vertex_group_user(vertex_group_user_enum value);
	enum vertex_group_subset_enum {
		vertex_group_subset_ALL = 0,
		vertex_group_subset_BONE_DEFORM = 3,
		vertex_group_subset_OTHER_DEFORM = 4,
	};
	inline vertex_group_subset_enum vertex_group_subset(void);
	inline void vertex_group_subset(vertex_group_subset_enum value);
	inline VertexPaint vertex_paint(void);
	inline VertexPaint weight_paint(void);
	inline ImagePaint image_paint(void);
	inline UvSculpt uv_sculpt(void);
	inline ParticleEdit particle_edit(void);
	inline bool use_uv_sculpt(void);
	inline void use_uv_sculpt(int value);
	inline bool uv_sculpt_lock_borders(void);
	inline void uv_sculpt_lock_borders(int value);
	inline bool uv_sculpt_all_islands(void);
	inline void uv_sculpt_all_islands(int value);
	enum uv_sculpt_tool_enum {
		uv_sculpt_tool_PINCH = 1,
		uv_sculpt_tool_RELAX = 2,
		uv_sculpt_tool_GRAB = 3,
	};
	inline uv_sculpt_tool_enum uv_sculpt_tool(void);
	inline void uv_sculpt_tool(uv_sculpt_tool_enum value);
	enum uv_relax_method_enum {
		uv_relax_method_LAPLACIAN = 1,
		uv_relax_method_HC = 2,
	};
	inline uv_relax_method_enum uv_relax_method(void);
	inline void uv_relax_method(uv_relax_method_enum value);
	enum proportional_edit_enum {
		proportional_edit_DISABLED = 0,
		proportional_edit_ENABLED = 1,
		proportional_edit_PROJECTED = 3,
		proportional_edit_CONNECTED = 2,
	};
	inline proportional_edit_enum proportional_edit(void);
	inline void proportional_edit(proportional_edit_enum value);
	inline bool use_proportional_edit_objects(void);
	inline void use_proportional_edit_objects(int value);
	inline bool use_proportional_edit_mask(void);
	inline void use_proportional_edit_mask(int value);
	enum proportional_edit_falloff_enum {
		proportional_edit_falloff_SMOOTH = 0,
		proportional_edit_falloff_SPHERE = 1,
		proportional_edit_falloff_ROOT = 2,
		proportional_edit_falloff_SHARP = 3,
		proportional_edit_falloff_LINEAR = 4,
		proportional_edit_falloff_CONSTANT = 5,
		proportional_edit_falloff_RANDOM = 6,
	};
	inline proportional_edit_falloff_enum proportional_edit_falloff(void);
	inline void proportional_edit_falloff(proportional_edit_falloff_enum value);
	inline float proportional_size(void);
	inline void proportional_size(float value);
	inline float normal_size(void);
	inline void normal_size(float value);
	inline float double_threshold(void);
	inline void double_threshold(float value);
	inline bool use_mesh_automerge(void);
	inline void use_mesh_automerge(int value);
	inline bool use_snap(void);
	inline void use_snap(int value);
	inline bool use_snap_align_rotation(void);
	inline void use_snap_align_rotation(int value);
	enum snap_element_enum {
		snap_element_INCREMENT = 0,
		snap_element_VERTEX = 1,
		snap_element_EDGE = 2,
		snap_element_FACE = 3,
		snap_element_VOLUME = 4,
	};
	inline snap_element_enum snap_element(void);
	inline void snap_element(snap_element_enum value);
	enum snap_node_element_enum {
		snap_node_element_GRID = 8,
		snap_node_element_NODE_X = 5,
		snap_node_element_NODE_Y = 6,
		snap_node_element_NODE_XY = 7,
	};
	inline snap_node_element_enum snap_node_element(void);
	inline void snap_node_element(snap_node_element_enum value);
	enum snap_uv_element_enum {
		snap_uv_element_INCREMENT = 0,
		snap_uv_element_VERTEX = 1,
	};
	inline snap_uv_element_enum snap_uv_element(void);
	inline void snap_uv_element(snap_uv_element_enum value);
	enum snap_target_enum {
		snap_target_CLOSEST = 0,
		snap_target_CENTER = 1,
		snap_target_MEDIAN = 2,
		snap_target_ACTIVE = 3,
	};
	inline snap_target_enum snap_target(void);
	inline void snap_target(snap_target_enum value);
	inline bool use_snap_peel_object(void);
	inline void use_snap_peel_object(int value);
	inline bool use_snap_project(void);
	inline void use_snap_project(int value);
	inline bool use_snap_self(void);
	inline void use_snap_self(int value);
	inline bool use_grease_pencil_sessions(void);
	inline void use_grease_pencil_sessions(int value);
	inline bool use_keyframe_insert_auto(void);
	inline void use_keyframe_insert_auto(int value);
	enum auto_keying_mode_enum {
		auto_keying_mode_ADD_REPLACE_KEYS = 2,
		auto_keying_mode_REPLACE_KEYS = 4,
	};
	inline auto_keying_mode_enum auto_keying_mode(void);
	inline void auto_keying_mode(auto_keying_mode_enum value);
	inline bool use_record_with_nla(void);
	inline void use_record_with_nla(int value);
	inline bool use_keyframe_insert_keyingset(void);
	inline void use_keyframe_insert_keyingset(int value);
	enum uv_select_mode_enum {
		uv_select_mode_VERTEX = 1,
		uv_select_mode_EDGE = 2,
		uv_select_mode_FACE = 4,
		uv_select_mode_ISLAND = 8,
	};
	inline uv_select_mode_enum uv_select_mode(void);
	inline void uv_select_mode(uv_select_mode_enum value);
	inline bool use_uv_select_sync(void);
	inline void use_uv_select_sync(int value);
	inline bool show_uv_local_view(void);
	inline void show_uv_local_view(int value);
	inline Array<int, 3> mesh_select_mode(void);
	inline void mesh_select_mode(int values[3]);
	inline float vertex_group_weight(void);
	inline void vertex_group_weight(float value);
	enum edge_path_mode_enum {
		edge_path_mode_SELECT = 0,
		edge_path_mode_SEAM = 1,
		edge_path_mode_SHARP = 2,
		edge_path_mode_CREASE = 3,
		edge_path_mode_BEVEL = 4,
		edge_path_mode_FREESTYLE = 5,
	};
	inline edge_path_mode_enum edge_path_mode(void);
	inline void edge_path_mode(edge_path_mode_enum value);
	inline bool edge_path_live_unwrap(void);
	inline void edge_path_live_unwrap(int value);
	inline bool use_bone_sketching(void);
	inline void use_bone_sketching(int value);
	inline bool use_etch_quick(void);
	inline void use_etch_quick(int value);
	inline bool use_etch_overdraw(void);
	inline void use_etch_overdraw(int value);
	inline bool use_etch_autoname(void);
	inline void use_etch_autoname(int value);
	inline std::string etch_number(void);	inline void etch_number(const std::string& value);
	inline std::string etch_side(void);	inline void etch_side(const std::string& value);
	inline Object etch_template(void);
	inline int etch_subdivision_number(void);
	inline void etch_subdivision_number(int value);
	inline float etch_adaptive_limit(void);
	inline void etch_adaptive_limit(float value);
	inline float etch_length_limit(void);
	inline void etch_length_limit(float value);
	enum etch_roll_mode_enum {
		etch_roll_mode_NONE = 0,
		etch_roll_mode_VIEW = 1,
		etch_roll_mode_JOINT = 2,
	};
	inline etch_roll_mode_enum etch_roll_mode(void);
	inline void etch_roll_mode(etch_roll_mode_enum value);
	enum etch_convert_mode_enum {
		etch_convert_mode_FIXED = 0,
		etch_convert_mode_LENGTH = 1,
		etch_convert_mode_ADAPTIVE = 2,
		etch_convert_mode_RETARGET = 3,
	};
	inline etch_convert_mode_enum etch_convert_mode(void);
	inline void etch_convert_mode(etch_convert_mode_enum value);
	inline UnifiedPaintSettings unified_paint_settings(void);
	inline MeshStatVis statvis(void);

};

/**************** Unified Paint Settings ****************/

class UnifiedPaintSettings : public Pointer {
public:
	UnifiedPaintSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_unified_size(void);
	inline void use_unified_size(int value);
	inline bool use_unified_strength(void);
	inline void use_unified_strength(int value);
	inline bool use_unified_weight(void);
	inline void use_unified_weight(int value);
	inline bool use_unified_color(void);
	inline void use_unified_color(int value);
	inline int size(void);
	inline void size(int value);
	inline float unprojected_radius(void);
	inline void unprojected_radius(float value);
	inline float strength(void);
	inline void strength(float value);
	inline float weight(void);
	inline void weight(float value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline Array<float, 3> secondary_color(void);
	inline void secondary_color(float values[3]);
	inline bool use_pressure_size(void);
	inline void use_pressure_size(int value);
	inline bool use_pressure_strength(void);
	inline void use_pressure_strength(int value);
	inline bool use_locked_size(void);
	inline void use_locked_size(int value);

};

/**************** Mesh Visualize Statistics ****************/

class MeshStatVis : public Pointer {
public:
	MeshStatVis(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_OVERHANG = 0,
		type_THICKNESS = 1,
		type_INTERSECT = 2,
		type_DISTORT = 3,
		type_SHARP = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline float overhang_min(void);
	inline void overhang_min(float value);
	inline float overhang_max(void);
	inline void overhang_max(float value);
	enum overhang_axis_enum {
		overhang_axis_POS_X = 0,
		overhang_axis_POS_Y = 1,
		overhang_axis_POS_Z = 2,
		overhang_axis_NEG_X = 3,
		overhang_axis_NEG_Y = 4,
		overhang_axis_NEG_Z = 5,
	};
	inline overhang_axis_enum overhang_axis(void);
	inline void overhang_axis(overhang_axis_enum value);
	inline float thickness_min(void);
	inline void thickness_min(float value);
	inline float thickness_max(void);
	inline void thickness_max(float value);
	inline int thickness_samples(void);
	inline void thickness_samples(int value);
	inline float distort_min(void);
	inline void distort_min(float value);
	inline float distort_max(void);
	inline void distort_max(float value);
	inline float sharp_min(void);
	inline void sharp_min(float value);
	inline float sharp_max(void);
	inline void sharp_max(float value);

};

/**************** Unit Settings ****************/

class UnitSettings : public Pointer {
public:
	UnitSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum system_enum {
		system_NONE = 0,
		system_METRIC = 1,
		system_IMPERIAL = 2,
	};
	inline system_enum system(void);
	inline void system(system_enum value);
	enum system_rotation_enum {
		system_rotation_DEGREES = 0,
		system_rotation_RADIANS = 2,
	};
	inline system_rotation_enum system_rotation(void);
	inline void system_rotation(system_rotation_enum value);
	inline float scale_length(void);
	inline void scale_length(float value);
	inline bool use_separate(void);
	inline void use_separate(int value);

};

/**************** Image Format ****************/

class ImageFormatSettings : public Pointer {
public:
	ImageFormatSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum file_format_enum {
		file_format_BMP = 20,
		file_format_IRIS = 1,
		file_format_PNG = 17,
		file_format_JPEG = 4,
		file_format_TARGA = 0,
		file_format_TARGA_RAW = 14,
		file_format_AVI_JPEG = 16,
		file_format_AVI_RAW = 15,
	};
	inline file_format_enum file_format(void);
	inline void file_format(file_format_enum value);
	enum color_mode_enum {
		color_mode_BW = 8,
		color_mode_RGB = 24,
		color_mode_RGBA = 32,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);
	enum color_depth_enum {
		color_depth_8 = 2,
		color_depth_10 = 4,
		color_depth_12 = 8,
		color_depth_16 = 16,
		color_depth_32 = 64,
	};
	inline color_depth_enum color_depth(void);
	inline void color_depth(color_depth_enum value);
	inline int quality(void);
	inline void quality(int value);
	inline int compression(void);
	inline void compression(int value);
	inline bool use_zbuffer(void);
	inline void use_zbuffer(int value);
	inline bool use_preview(void);
	inline void use_preview(int value);
	inline bool use_cineon_log(void);
	inline void use_cineon_log(int value);
	inline int cineon_black(void);
	inline void cineon_black(int value);
	inline int cineon_white(void);
	inline void cineon_white(int value);
	inline float cineon_gamma(void);
	inline void cineon_gamma(float value);
	inline ColorManagedViewSettings view_settings(void);
	inline ColorManagedDisplaySettings display_settings(void);

};

/**************** Game Data ****************/

class SceneGameData : public Pointer {
public:
	SceneGameData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int resolution_x(void);
	inline void resolution_x(int value);
	inline int resolution_y(void);
	inline void resolution_y(int value);
	enum vsync_enum {
		vsync_OFF = 1,
		vsync_ON = 0,
		vsync_ADAPTIVE = 2,
	};
	inline vsync_enum vsync(void);
	inline void vsync(vsync_enum value);
	enum samples_enum {
		samples_SAMPLES_0 = 0,
		samples_SAMPLES_2 = 2,
		samples_SAMPLES_4 = 4,
		samples_SAMPLES_8 = 8,
		samples_SAMPLES_16 = 16,
	};
	inline samples_enum samples(void);
	inline void samples(samples_enum value);
	inline int depth(void);
	inline void depth(int value);
	enum exit_key_enum {
		exit_key_NONE = 0,
		exit_key_LEFTMOUSE = 1,
		exit_key_MIDDLEMOUSE = 2,
		exit_key_RIGHTMOUSE = 3,
		exit_key_BUTTON4MOUSE = 7,
		exit_key_BUTTON5MOUSE = 8,
		exit_key_BUTTON6MOUSE = 18,
		exit_key_BUTTON7MOUSE = 19,
		exit_key_ACTIONMOUSE = 5,
		exit_key_SELECTMOUSE = 6,
		exit_key_MOUSEMOVE = 4,
		exit_key_INBETWEEN_MOUSEMOVE = 17,
		exit_key_TRACKPADPAN = 14,
		exit_key_TRACKPADZOOM = 15,
		exit_key_MOUSEROTATE = 16,
		exit_key_WHEELUPMOUSE = 10,
		exit_key_WHEELDOWNMOUSE = 11,
		exit_key_WHEELINMOUSE = 12,
		exit_key_WHEELOUTMOUSE = 13,
		exit_key_EVT_TWEAK_L = 20483,
		exit_key_EVT_TWEAK_M = 20484,
		exit_key_EVT_TWEAK_R = 20485,
		exit_key_EVT_TWEAK_A = 20486,
		exit_key_EVT_TWEAK_S = 20487,
		exit_key_A = 97,
		exit_key_B = 98,
		exit_key_C = 99,
		exit_key_D = 100,
		exit_key_E = 101,
		exit_key_F = 102,
		exit_key_G = 103,
		exit_key_H = 104,
		exit_key_I = 105,
		exit_key_J = 106,
		exit_key_K = 107,
		exit_key_L = 108,
		exit_key_M = 109,
		exit_key_N = 110,
		exit_key_O = 111,
		exit_key_P = 112,
		exit_key_Q = 113,
		exit_key_R = 114,
		exit_key_S = 115,
		exit_key_T = 116,
		exit_key_U = 117,
		exit_key_V = 118,
		exit_key_W = 119,
		exit_key_X = 120,
		exit_key_Y = 121,
		exit_key_Z = 122,
		exit_key_ZERO = 48,
		exit_key_ONE = 49,
		exit_key_TWO = 50,
		exit_key_THREE = 51,
		exit_key_FOUR = 52,
		exit_key_FIVE = 53,
		exit_key_SIX = 54,
		exit_key_SEVEN = 55,
		exit_key_EIGHT = 56,
		exit_key_NINE = 57,
		exit_key_LEFT_CTRL = 212,
		exit_key_LEFT_ALT = 213,
		exit_key_LEFT_SHIFT = 217,
		exit_key_RIGHT_ALT = 214,
		exit_key_RIGHT_CTRL = 215,
		exit_key_RIGHT_SHIFT = 216,
		exit_key_OSKEY = 172,
		exit_key_GRLESS = 173,
		exit_key_ESC = 218,
		exit_key_TAB = 219,
		exit_key_RET = 220,
		exit_key_SPACE = 221,
		exit_key_LINE_FEED = 222,
		exit_key_BACK_SPACE = 223,
		exit_key_DEL = 224,
		exit_key_SEMI_COLON = 225,
		exit_key_PERIOD = 226,
		exit_key_COMMA = 227,
		exit_key_QUOTE = 228,
		exit_key_ACCENT_GRAVE = 229,
		exit_key_MINUS = 230,
		exit_key_SLASH = 232,
		exit_key_BACK_SLASH = 233,
		exit_key_EQUAL = 234,
		exit_key_LEFT_BRACKET = 235,
		exit_key_RIGHT_BRACKET = 236,
		exit_key_LEFT_ARROW = 137,
		exit_key_DOWN_ARROW = 138,
		exit_key_RIGHT_ARROW = 139,
		exit_key_UP_ARROW = 140,
		exit_key_NUMPAD_2 = 152,
		exit_key_NUMPAD_4 = 154,
		exit_key_NUMPAD_6 = 156,
		exit_key_NUMPAD_8 = 158,
		exit_key_NUMPAD_1 = 151,
		exit_key_NUMPAD_3 = 153,
		exit_key_NUMPAD_5 = 155,
		exit_key_NUMPAD_7 = 157,
		exit_key_NUMPAD_9 = 159,
		exit_key_NUMPAD_PERIOD = 199,
		exit_key_NUMPAD_SLASH = 161,
		exit_key_NUMPAD_ASTERIX = 160,
		exit_key_NUMPAD_0 = 150,
		exit_key_NUMPAD_MINUS = 162,
		exit_key_NUMPAD_ENTER = 163,
		exit_key_NUMPAD_PLUS = 164,
		exit_key_F1 = 300,
		exit_key_F2 = 301,
		exit_key_F3 = 302,
		exit_key_F4 = 303,
		exit_key_F5 = 304,
		exit_key_F6 = 305,
		exit_key_F7 = 306,
		exit_key_F8 = 307,
		exit_key_F9 = 308,
		exit_key_F10 = 309,
		exit_key_F11 = 310,
		exit_key_F12 = 311,
		exit_key_F13 = 312,
		exit_key_F14 = 313,
		exit_key_F15 = 314,
		exit_key_F16 = 315,
		exit_key_F17 = 316,
		exit_key_F18 = 317,
		exit_key_F19 = 318,
		exit_key_PAUSE = 165,
		exit_key_INSERT = 166,
		exit_key_HOME = 167,
		exit_key_PAGE_UP = 168,
		exit_key_PAGE_DOWN = 169,
		exit_key_END = 170,
		exit_key_MEDIA_PLAY = 174,
		exit_key_MEDIA_STOP = 175,
		exit_key_MEDIA_FIRST = 176,
		exit_key_MEDIA_LAST = 177,
		exit_key_TEXTINPUT = -2,
		exit_key_WINDOW_DEACTIVATE = 260,
		exit_key_TIMER = 272,
		exit_key_TIMER0 = 273,
		exit_key_TIMER1 = 274,
		exit_key_TIMER2 = 275,
		exit_key_TIMER_JOBS = 276,
		exit_key_TIMER_AUTOSAVE = 277,
		exit_key_TIMER_REPORT = 278,
		exit_key_TIMERREGION = 279,
		exit_key_NDOF_MOTION = 400,
		exit_key_NDOF_BUTTON_MENU = 401,
		exit_key_NDOF_BUTTON_FIT = 402,
		exit_key_NDOF_BUTTON_TOP = 403,
		exit_key_NDOF_BUTTON_BOTTOM = 404,
		exit_key_NDOF_BUTTON_LEFT = 405,
		exit_key_NDOF_BUTTON_RIGHT = 406,
		exit_key_NDOF_BUTTON_FRONT = 407,
		exit_key_NDOF_BUTTON_BACK = 408,
		exit_key_NDOF_BUTTON_ISO1 = 409,
		exit_key_NDOF_BUTTON_ISO2 = 410,
		exit_key_NDOF_BUTTON_ROLL_CW = 411,
		exit_key_NDOF_BUTTON_ROLL_CCW = 412,
		exit_key_NDOF_BUTTON_SPIN_CW = 413,
		exit_key_NDOF_BUTTON_SPIN_CCW = 414,
		exit_key_NDOF_BUTTON_TILT_CW = 415,
		exit_key_NDOF_BUTTON_TILT_CCW = 416,
		exit_key_NDOF_BUTTON_ROTATE = 417,
		exit_key_NDOF_BUTTON_PANZOOM = 418,
		exit_key_NDOF_BUTTON_DOMINANT = 419,
		exit_key_NDOF_BUTTON_PLUS = 420,
		exit_key_NDOF_BUTTON_MINUS = 421,
		exit_key_NDOF_BUTTON_ESC = 422,
		exit_key_NDOF_BUTTON_ALT = 423,
		exit_key_NDOF_BUTTON_SHIFT = 424,
		exit_key_NDOF_BUTTON_CTRL = 425,
		exit_key_NDOF_BUTTON_1 = 426,
		exit_key_NDOF_BUTTON_2 = 427,
		exit_key_NDOF_BUTTON_3 = 428,
		exit_key_NDOF_BUTTON_4 = 429,
		exit_key_NDOF_BUTTON_5 = 430,
		exit_key_NDOF_BUTTON_6 = 431,
		exit_key_NDOF_BUTTON_7 = 432,
		exit_key_NDOF_BUTTON_8 = 433,
		exit_key_NDOF_BUTTON_9 = 434,
		exit_key_NDOF_BUTTON_10 = 435,
		exit_key_NDOF_BUTTON_A = 436,
		exit_key_NDOF_BUTTON_B = 437,
		exit_key_NDOF_BUTTON_C = 438,
	};
	inline exit_key_enum exit_key(void);
	inline void exit_key(exit_key_enum value);
	enum raster_storage_enum {
		raster_storage_AUTO = 0,
		raster_storage_IMMEDIATE = 1,
		raster_storage_VERTEX_ARRAY = 2,
	};
	inline raster_storage_enum raster_storage(void);
	inline void raster_storage(raster_storage_enum value);
	inline int frequency(void);
	inline void frequency(int value);
	inline bool show_fullscreen(void);
	inline void show_fullscreen(int value);
	inline bool use_desktop(void);
	inline void use_desktop(int value);
	enum frame_type_enum {
		frame_type_LETTERBOX = 0,
		frame_type_EXTEND = 1,
		frame_type_SCALE = 2,
	};
	inline frame_type_enum frame_type(void);
	inline void frame_type(frame_type_enum value);
	inline Array<float, 3> frame_color(void);
	inline void frame_color(float values[3]);
	enum stereo_enum {
		stereo_NONE = 1,
		stereo_STEREO = 2,
		stereo_DOME = 3,
	};
	inline stereo_enum stereo(void);
	inline void stereo(stereo_enum value);
	enum stereo_mode_enum {
		stereo_mode_QUADBUFFERED = 2,
		stereo_mode_ABOVEBELOW = 3,
		stereo_mode_INTERLACED = 4,
		stereo_mode_ANAGLYPH = 5,
		stereo_mode_SIDEBYSIDE = 6,
		stereo_mode_VINTERLACE = 7,
		stereo_mode_3DTVTOPBOTTOM = 9,
	};
	inline stereo_mode_enum stereo_mode(void);
	inline void stereo_mode(stereo_mode_enum value);
	inline float stereo_eye_separation(void);
	inline void stereo_eye_separation(float value);
	enum dome_mode_enum {
		dome_mode_FISHEYE = 1,
		dome_mode_TRUNCATED_FRONT = 2,
		dome_mode_TRUNCATED_REAR = 3,
		dome_mode_ENVMAP = 4,
		dome_mode_PANORAM_SPH = 5,
	};
	inline dome_mode_enum dome_mode(void);
	inline void dome_mode(dome_mode_enum value);
	inline int dome_tessellation(void);
	inline void dome_tessellation(int value);
	inline float dome_buffer_resolution(void);
	inline void dome_buffer_resolution(float value);
	inline int dome_angle(void);
	inline void dome_angle(int value);
	inline int dome_tilt(void);
	inline void dome_tilt(int value);
	inline Text dome_text(void);
	enum physics_engine_enum {
		physics_engine_NONE = 0,
		physics_engine_BULLET = 5,
	};
	inline physics_engine_enum physics_engine(void);
	inline void physics_engine(physics_engine_enum value);
	inline float physics_gravity(void);
	inline void physics_gravity(float value);
	inline int occlusion_culling_resolution(void);
	inline void occlusion_culling_resolution(int value);
	inline int fps(void);
	inline void fps(int value);
	inline int logic_step_max(void);
	inline void logic_step_max(int value);
	inline int physics_step_max(void);
	inline void physics_step_max(int value);
	inline int physics_step_sub(void);
	inline void physics_step_sub(int value);
	inline float deactivation_linear_threshold(void);
	inline void deactivation_linear_threshold(float value);
	inline float deactivation_angular_threshold(void);
	inline void deactivation_angular_threshold(float value);
	inline float deactivation_time(void);
	inline void deactivation_time(float value);
	inline bool use_occlusion_culling(void);
	inline void use_occlusion_culling(int value);
	inline bool use_activity_culling(void);
	inline void use_activity_culling(int value);
	inline float activity_culling_box_radius(void);
	inline void activity_culling_box_radius(float value);
	inline bool show_debug_properties(void);
	inline void show_debug_properties(int value);
	inline bool show_framerate_profile(void);
	inline void show_framerate_profile(int value);
	inline bool show_physics_visualization(void);
	inline void show_physics_visualization(int value);
	inline bool show_mouse(void);
	inline void show_mouse(int value);
	inline bool use_frame_rate(void);
	inline void use_frame_rate(int value);
	inline bool use_display_lists(void);
	inline void use_display_lists(int value);
	inline bool use_deprecation_warnings(void);
	inline void use_deprecation_warnings(int value);
	inline bool use_animation_record(void);
	inline void use_animation_record(int value);
	inline bool use_auto_start(void);
	inline void use_auto_start(int value);
	inline bool use_restrict_animation_updates(void);
	inline void use_restrict_animation_updates(int value);
	enum material_mode_enum {
		material_mode_MULTITEXTURE = 1,
		material_mode_GLSL = 2,
	};
	inline material_mode_enum material_mode(void);
	inline void material_mode(material_mode_enum value);
	inline bool use_glsl_lights(void);
	inline void use_glsl_lights(int value);
	inline bool use_glsl_shaders(void);
	inline void use_glsl_shaders(int value);
	inline bool use_glsl_shadows(void);
	inline void use_glsl_shadows(int value);
	inline bool use_glsl_ramps(void);
	inline void use_glsl_ramps(int value);
	inline bool use_glsl_nodes(void);
	inline void use_glsl_nodes(int value);
	inline bool use_glsl_color_management(void);
	inline void use_glsl_color_management(int value);
	inline bool use_glsl_extra_textures(void);
	inline void use_glsl_extra_textures(int value);
	inline bool use_material_caching(void);
	inline void use_material_caching(int value);
	enum obstacle_simulation_enum {
		obstacle_simulation_NONE = 0,
		obstacle_simulation_RVO_RAYS = 1,
		obstacle_simulation_RVO_CELLS = 2,
	};
	inline obstacle_simulation_enum obstacle_simulation(void);
	inline void obstacle_simulation(obstacle_simulation_enum value);
	inline float level_height(void);
	inline void level_height(float value);
	inline bool show_obstacle_simulation(void);
	inline void show_obstacle_simulation(int value);
	inline SceneGameRecastData recast_data(void);

};

/**************** Recast Data ****************/

class SceneGameRecastData : public Pointer {
public:
	SceneGameRecastData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float cell_size(void);
	inline void cell_size(float value);
	inline float cell_height(void);
	inline void cell_height(float value);
	inline float agent_height(void);
	inline void agent_height(float value);
	inline float agent_radius(void);
	inline void agent_radius(float value);
	inline float climb_max(void);
	inline void climb_max(float value);
	inline float slope_max(void);
	inline void slope_max(float value);
	inline float region_min_size(void);
	inline void region_min_size(float value);
	inline float region_merge_size(void);
	inline void region_merge_size(float value);
	inline float edge_max_len(void);
	inline void edge_max_len(float value);
	inline float edge_max_error(void);
	inline void edge_max_error(float value);
	inline int verts_per_poly(void);
	inline void verts_per_poly(int value);
	inline float sample_dist(void);
	inline void sample_dist(float value);
	inline float sample_max_error(void);
	inline void sample_max_error(float value);

};

/**************** TransformOrientation ****************/

class TransformOrientation : public Pointer {
public:
	TransformOrientation(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 9> matrix(void);
	inline void matrix(float values[9]);
	inline std::string name(void);	inline void name(const std::string& value);

};

/**************** Selected UV Element ****************/

class SelectedUvElement : public PropertyGroup {
public:
	SelectedUvElement(const PointerRNA &ptr_arg) :
		PropertyGroup(ptr_arg)
		{}


};

/**************** FFmpeg Settings ****************/

class FFmpegSettings : public Pointer {
public:
	FFmpegSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int audio_mixrate(void);
	inline void audio_mixrate(int value);
	enum audio_channels_enum {
		audio_channels_MONO = 1,
		audio_channels_STEREO = 2,
		audio_channels_SURROUND4 = 4,
		audio_channels_SURROUND51 = 6,
		audio_channels_SURROUND71 = 8,
	};
	inline audio_channels_enum audio_channels(void);
	inline void audio_channels(audio_channels_enum value);

};

/**************** Render Data ****************/

class RenderSettings : public Pointer {
public:
	RenderSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		layers(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ImageFormatSettings image_settings(void);
	inline int resolution_x(void);
	inline void resolution_x(int value);
	inline int resolution_y(void);
	inline void resolution_y(int value);
	inline int resolution_percentage(void);
	inline void resolution_percentage(int value);
	inline int tile_x(void);
	inline void tile_x(int value);
	inline int tile_y(void);
	inline void tile_y(int value);
	inline int preview_start_resolution(void);
	inline void preview_start_resolution(int value);
	inline float pixel_aspect_x(void);
	inline void pixel_aspect_x(float value);
	inline float pixel_aspect_y(void);
	inline void pixel_aspect_y(float value);
	inline FFmpegSettings ffmpeg(void);
	inline int fps(void);
	inline void fps(int value);
	inline float fps_base(void);
	inline void fps_base(float value);
	inline int frame_map_old(void);
	inline void frame_map_old(int value);
	inline int frame_map_new(void);
	inline void frame_map_new(int value);
	inline float dither_intensity(void);
	inline void dither_intensity(float value);
	enum pixel_filter_type_enum {
		pixel_filter_type_BOX = 0,
		pixel_filter_type_TENT = 1,
		pixel_filter_type_QUADRATIC = 2,
		pixel_filter_type_CUBIC = 3,
		pixel_filter_type_CATMULLROM = 4,
		pixel_filter_type_GAUSSIAN = 5,
		pixel_filter_type_MITCHELL = 6,
	};
	inline pixel_filter_type_enum pixel_filter_type(void);
	inline void pixel_filter_type(pixel_filter_type_enum value);
	inline float filter_size(void);
	inline void filter_size(float value);
	enum alpha_mode_enum {
		alpha_mode_SKY = 0,
		alpha_mode_TRANSPARENT = 1,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);
	enum octree_resolution_enum {
		octree_resolution_64 = 64,
		octree_resolution_128 = 128,
		octree_resolution_256 = 256,
		octree_resolution_512 = 512,
	};
	inline octree_resolution_enum octree_resolution(void);
	inline void octree_resolution(octree_resolution_enum value);
	enum raytrace_method_enum {
		raytrace_method_AUTO = 0,
		raytrace_method_OCTREE = 1,
		raytrace_method_VBVH = 3,
		raytrace_method_SIMD_SVBVH = 4,
		raytrace_method_SIMD_QBVH = 5,
	};
	inline raytrace_method_enum raytrace_method(void);
	inline void raytrace_method(raytrace_method_enum value);
	inline bool use_instances(void);
	inline void use_instances(int value);
	inline bool use_local_coords(void);
	inline void use_local_coords(int value);
	inline bool use_antialiasing(void);
	inline void use_antialiasing(int value);
	enum antialiasing_samples_enum {
		antialiasing_samples_5 = 5,
		antialiasing_samples_8 = 8,
		antialiasing_samples_11 = 11,
		antialiasing_samples_16 = 16,
	};
	inline antialiasing_samples_enum antialiasing_samples(void);
	inline void antialiasing_samples(antialiasing_samples_enum value);
	inline bool use_fields(void);
	inline void use_fields(int value);
	enum field_order_enum {
		field_order_EVEN_FIRST = 0,
		field_order_ODD_FIRST = 8192,
	};
	inline field_order_enum field_order(void);
	inline void field_order(field_order_enum value);
	inline bool use_fields_still(void);
	inline void use_fields_still(int value);
	inline bool use_shadows(void);
	inline void use_shadows(int value);
	inline bool use_envmaps(void);
	inline void use_envmaps(int value);
	inline bool use_sss(void);
	inline void use_sss(int value);
	inline bool use_raytrace(void);
	inline void use_raytrace(int value);
	inline bool use_textures(void);
	inline void use_textures(int value);
	inline bool use_edge_enhance(void);
	inline void use_edge_enhance(int value);
	inline int edge_threshold(void);
	inline void edge_threshold(int value);
	inline Array<float, 3> edge_color(void);
	inline void edge_color(float values[3]);
	inline bool use_freestyle(void);
	inline void use_freestyle(int value);
	inline int threads(void);
	inline void threads(int value);
	enum threads_mode_enum {
		threads_mode_AUTO = 0,
		threads_mode_FIXED = 524288,
	};
	inline threads_mode_enum threads_mode(void);
	inline void threads_mode(threads_mode_enum value);
	inline bool use_motion_blur(void);
	inline void use_motion_blur(int value);
	inline int motion_blur_samples(void);
	inline void motion_blur_samples(int value);
	inline float motion_blur_shutter(void);
	inline void motion_blur_shutter(float value);
	inline bool use_border(void);
	inline void use_border(int value);
	inline float border_min_x(void);
	inline void border_min_x(float value);
	inline float border_min_y(void);
	inline void border_min_y(float value);
	inline float border_max_x(void);
	inline void border_max_x(float value);
	inline float border_max_y(void);
	inline void border_max_y(float value);
	inline bool use_crop_to_border(void);
	inline void use_crop_to_border(int value);
	inline bool use_placeholder(void);
	inline void use_placeholder(int value);
	inline bool use_overwrite(void);
	inline void use_overwrite(int value);
	inline bool use_compositing(void);
	inline void use_compositing(int value);
	inline bool use_sequencer(void);
	inline void use_sequencer(int value);
	inline bool use_file_extension(void);
	inline void use_file_extension(int value);
	inline std::string file_extension(void);	inline void file_extension(const std::string& value);
	inline bool is_movie_format(void);
	inline void is_movie_format(int value);
	inline bool use_free_image_textures(void);
	inline void use_free_image_textures(int value);
	inline bool use_free_unused_nodes(void);
	inline void use_free_unused_nodes(int value);
	inline bool use_save_buffers(void);
	inline void use_save_buffers(int value);
	inline bool use_full_sample(void);
	inline void use_full_sample(int value);
	enum display_mode_enum {
		display_mode_SCREEN = 0,
		display_mode_AREA = 1,
		display_mode_WINDOW = 2,
		display_mode_NONE = 3,
	};
	inline display_mode_enum display_mode(void);
	inline void display_mode(display_mode_enum value);
	inline bool use_lock_interface(void);
	inline void use_lock_interface(int value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline bool use_render_cache(void);
	inline void use_render_cache(int value);
	enum bake_type_enum {
		bake_type_FULL = 1,
		bake_type_AO = 2,
		bake_type_SHADOW = 6,
		bake_type_NORMALS = 3,
		bake_type_TEXTURE = 4,
		bake_type_DISPLACEMENT = 5,
		bake_type_DERIVATIVE = 13,
		bake_type_VERTEX_COLORS = 14,
		bake_type_EMIT = 12,
		bake_type_ALPHA = 11,
		bake_type_MIRROR_INTENSITY = 10,
		bake_type_MIRROR_COLOR = 9,
		bake_type_SPEC_INTENSITY = 8,
		bake_type_SPEC_COLOR = 7,
	};
	inline bake_type_enum bake_type(void);
	inline void bake_type(bake_type_enum value);
	enum bake_normal_space_enum {
		bake_normal_space_CAMERA = 0,
		bake_normal_space_WORLD = 1,
		bake_normal_space_OBJECT = 2,
		bake_normal_space_TANGENT = 3,
	};
	inline bake_normal_space_enum bake_normal_space(void);
	inline void bake_normal_space(bake_normal_space_enum value);
	enum bake_quad_split_enum {
		bake_quad_split_AUTO = 0,
		bake_quad_split_FIXED = 1,
		bake_quad_split_FIXED_ALT = 2,
	};
	inline bake_quad_split_enum bake_quad_split(void);
	inline void bake_quad_split(bake_quad_split_enum value);
	enum bake_aa_mode_enum {
		bake_aa_mode_5 = 5,
		bake_aa_mode_8 = 8,
		bake_aa_mode_11 = 11,
		bake_aa_mode_16 = 16,
	};
	inline bake_aa_mode_enum bake_aa_mode(void);
	inline void bake_aa_mode(bake_aa_mode_enum value);
	inline bool use_bake_selected_to_active(void);
	inline void use_bake_selected_to_active(int value);
	inline bool use_bake_normalize(void);
	inline void use_bake_normalize(int value);
	inline bool use_bake_clear(void);
	inline void use_bake_clear(int value);
	inline bool use_bake_antialiasing(void);
	inline void use_bake_antialiasing(int value);
	inline int bake_margin(void);
	inline void bake_margin(int value);
	inline float bake_distance(void);
	inline void bake_distance(float value);
	inline float bake_bias(void);
	inline void bake_bias(float value);
	inline bool use_bake_multires(void);
	inline void use_bake_multires(int value);
	inline bool use_bake_lores_mesh(void);
	inline void use_bake_lores_mesh(int value);
	inline int bake_samples(void);
	inline void bake_samples(int value);
	inline bool use_bake_to_vertex_color(void);
	inline void use_bake_to_vertex_color(int value);
	inline bool use_bake_user_scale(void);
	inline void use_bake_user_scale(int value);
	inline float bake_user_scale(void);
	inline void bake_user_scale(float value);
	inline bool use_stamp_time(void);
	inline void use_stamp_time(int value);
	inline bool use_stamp_date(void);
	inline void use_stamp_date(int value);
	inline bool use_stamp_frame(void);
	inline void use_stamp_frame(int value);
	inline bool use_stamp_camera(void);
	inline void use_stamp_camera(int value);
	inline bool use_stamp_lens(void);
	inline void use_stamp_lens(int value);
	inline bool use_stamp_scene(void);
	inline void use_stamp_scene(int value);
	inline bool use_stamp_note(void);
	inline void use_stamp_note(int value);
	inline bool use_stamp_marker(void);
	inline void use_stamp_marker(int value);
	inline bool use_stamp_filename(void);
	inline void use_stamp_filename(int value);
	inline bool use_stamp_sequencer_strip(void);
	inline void use_stamp_sequencer_strip(int value);
	inline bool use_stamp_render_time(void);
	inline void use_stamp_render_time(int value);
	inline std::string stamp_note_text(void);	inline void stamp_note_text(const std::string& value);
	inline bool use_stamp(void);
	inline void use_stamp(int value);
	inline int stamp_font_size(void);
	inline void stamp_font_size(int value);
	inline Array<float, 4> stamp_foreground(void);
	inline void stamp_foreground(float values[4]);
	inline Array<float, 4> stamp_background(void);
	inline void stamp_background(float values[4]);
	inline bool use_sequencer_gl_preview(void);
	inline void use_sequencer_gl_preview(int value);
	enum sequencer_gl_preview_enum {
		sequencer_gl_preview_BOUNDBOX = 1,
		sequencer_gl_preview_WIREFRAME = 2,
		sequencer_gl_preview_SOLID = 3,
		sequencer_gl_preview_TEXTURED = 5,
		sequencer_gl_preview_MATERIAL = 4,
		sequencer_gl_preview_RENDERED = 6,
	};
	inline sequencer_gl_preview_enum sequencer_gl_preview(void);
	inline void sequencer_gl_preview(sequencer_gl_preview_enum value);
	enum sequencer_gl_render_enum {
		sequencer_gl_render_BOUNDBOX = 1,
		sequencer_gl_render_WIREFRAME = 2,
		sequencer_gl_render_SOLID = 3,
		sequencer_gl_render_TEXTURED = 5,
		sequencer_gl_render_MATERIAL = 4,
		sequencer_gl_render_RENDERED = 6,
	};
	inline sequencer_gl_render_enum sequencer_gl_render(void);
	inline void sequencer_gl_render(sequencer_gl_render_enum value);
	inline bool use_sequencer_gl_textured_solid(void);
	inline void use_sequencer_gl_textured_solid(int value);
	COLLECTION_PROPERTY(RenderLayers, SceneRenderLayer, RenderSettings, layers, false, true, true)
	inline bool use_single_layer(void);
	inline void use_single_layer(int value);
	enum engine_enum {
		engine_BLENDER_RENDER = 0,
	};
	inline engine_enum engine(void);
	inline void engine(engine_enum value);
	inline bool has_multiple_engines(void);
	inline void has_multiple_engines(int value);
	inline bool use_shading_nodes(void);
	inline void use_shading_nodes(int value);
	inline bool use_game_engine(void);
	inline void use_game_engine(int value);
	inline bool use_simplify(void);
	inline void use_simplify(int value);
	inline int simplify_subdivision(void);
	inline void simplify_subdivision(int value);
	inline float simplify_child_particles(void);
	inline void simplify_child_particles(float value);
	inline int simplify_shadow_samples(void);
	inline void simplify_shadow_samples(int value);
	inline float simplify_ao_sss(void);
	inline void simplify_ao_sss(float value);
	inline bool use_simplify_triangulate(void);
	inline void use_simplify_triangulate(int value);
	inline bool use_persistent_data(void);
	inline void use_persistent_data(int value);
	enum line_thickness_mode_enum {
		line_thickness_mode_ABSOLUTE = 1,
		line_thickness_mode_RELATIVE = 2,
	};
	inline line_thickness_mode_enum line_thickness_mode(void);
	inline void line_thickness_mode(line_thickness_mode_enum value);
	inline float line_thickness(void);
	inline void line_thickness(float value);
	inline BakeSettings bake(void);

	inline void frame_path(int frame, char * filepath);
};

/**************** Bake Data ****************/

class BakeSettings : public Pointer {
public:
	BakeSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string cage_object(void);	inline void cage_object(const std::string& value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline int width(void);
	inline void width(int value);
	inline int height(void);
	inline void height(int value);
	inline int margin(void);
	inline void margin(int value);
	inline float cage_extrusion(void);
	inline void cage_extrusion(float value);
	enum normal_space_enum {
		normal_space_OBJECT = 2,
		normal_space_TANGENT = 3,
	};
	inline normal_space_enum normal_space(void);
	inline void normal_space(normal_space_enum value);
	enum normal_r_enum {
		normal_r_POS_X = 0,
		normal_r_POS_Y = 1,
		normal_r_POS_Z = 2,
		normal_r_NEG_X = 3,
		normal_r_NEG_Y = 4,
		normal_r_NEG_Z = 5,
	};
	inline normal_r_enum normal_r(void);
	inline void normal_r(normal_r_enum value);
	enum normal_g_enum {
		normal_g_POS_X = 0,
		normal_g_POS_Y = 1,
		normal_g_POS_Z = 2,
		normal_g_NEG_X = 3,
		normal_g_NEG_Y = 4,
		normal_g_NEG_Z = 5,
	};
	inline normal_g_enum normal_g(void);
	inline void normal_g(normal_g_enum value);
	enum normal_b_enum {
		normal_b_POS_X = 0,
		normal_b_POS_Y = 1,
		normal_b_POS_Z = 2,
		normal_b_NEG_X = 3,
		normal_b_NEG_Y = 4,
		normal_b_NEG_Z = 5,
	};
	inline normal_b_enum normal_b(void);
	inline void normal_b(normal_b_enum value);
	inline ImageFormatSettings image_settings(void);
	enum save_mode_enum {
		save_mode_INTERNAL = 0,
		save_mode_EXTERNAL = 1,
	};
	inline save_mode_enum save_mode(void);
	inline void save_mode(save_mode_enum value);
	inline bool use_selected_to_active(void);
	inline void use_selected_to_active(int value);
	inline bool use_clear(void);
	inline void use_clear(int value);
	inline bool use_split_materials(void);
	inline void use_split_materials(int value);
	inline bool use_automatic_name(void);
	inline void use_automatic_name(int value);
	inline bool use_cage(void);
	inline void use_cage(int value);

};

/**************** Scene Render Layer ****************/

class SceneRenderLayer : public Pointer {
public:
	SceneRenderLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline Material material_override(void);
	inline Group light_override(void);
	inline Array<int, 20> layers(void);
	inline void layers(int values[20]);
	inline Array<int, 20> layers_zmask(void);
	inline void layers_zmask(int values[20]);
	inline Array<int, 20> layers_exclude(void);
	inline void layers_exclude(int values[20]);
	inline int samples(void);
	inline void samples(int value);
	inline float pass_alpha_threshold(void);
	inline void pass_alpha_threshold(float value);
	inline bool use(void);
	inline void use(int value);
	inline bool use_zmask(void);
	inline void use_zmask(int value);
	inline bool invert_zmask(void);
	inline void invert_zmask(int value);
	inline bool use_all_z(void);
	inline void use_all_z(int value);
	inline bool use_solid(void);
	inline void use_solid(int value);
	inline bool use_halo(void);
	inline void use_halo(int value);
	inline bool use_ztransp(void);
	inline void use_ztransp(int value);
	inline bool use_sky(void);
	inline void use_sky(int value);
	inline bool use_edge_enhance(void);
	inline void use_edge_enhance(int value);
	inline bool use_strand(void);
	inline void use_strand(int value);
	inline bool use_freestyle(void);
	inline void use_freestyle(int value);
	inline bool use_pass_combined(void);
	inline void use_pass_combined(int value);
	inline bool use_pass_z(void);
	inline void use_pass_z(int value);
	inline bool use_pass_vector(void);
	inline void use_pass_vector(int value);
	inline bool use_pass_normal(void);
	inline void use_pass_normal(int value);
	inline bool use_pass_uv(void);
	inline void use_pass_uv(int value);
	inline bool use_pass_mist(void);
	inline void use_pass_mist(int value);
	inline bool use_pass_object_index(void);
	inline void use_pass_object_index(int value);
	inline bool use_pass_material_index(void);
	inline void use_pass_material_index(int value);
	inline bool use_pass_color(void);
	inline void use_pass_color(int value);
	inline bool use_pass_diffuse(void);
	inline void use_pass_diffuse(int value);
	inline bool use_pass_specular(void);
	inline void use_pass_specular(int value);
	inline bool use_pass_shadow(void);
	inline void use_pass_shadow(int value);
	inline bool use_pass_ambient_occlusion(void);
	inline void use_pass_ambient_occlusion(int value);
	inline bool use_pass_reflection(void);
	inline void use_pass_reflection(int value);
	inline bool use_pass_refraction(void);
	inline void use_pass_refraction(int value);
	inline bool use_pass_emit(void);
	inline void use_pass_emit(int value);
	inline bool use_pass_environment(void);
	inline void use_pass_environment(int value);
	inline bool use_pass_indirect(void);
	inline void use_pass_indirect(int value);
	inline bool exclude_specular(void);
	inline void exclude_specular(int value);
	inline bool exclude_shadow(void);
	inline void exclude_shadow(int value);
	inline bool exclude_ambient_occlusion(void);
	inline void exclude_ambient_occlusion(int value);
	inline bool exclude_reflection(void);
	inline void exclude_reflection(int value);
	inline bool exclude_refraction(void);
	inline void exclude_refraction(int value);
	inline bool exclude_emit(void);
	inline void exclude_emit(int value);
	inline bool exclude_environment(void);
	inline void exclude_environment(int value);
	inline bool exclude_indirect(void);
	inline void exclude_indirect(int value);
	inline bool use_pass_diffuse_direct(void);
	inline void use_pass_diffuse_direct(int value);
	inline bool use_pass_diffuse_indirect(void);
	inline void use_pass_diffuse_indirect(int value);
	inline bool use_pass_diffuse_color(void);
	inline void use_pass_diffuse_color(int value);
	inline bool use_pass_glossy_direct(void);
	inline void use_pass_glossy_direct(int value);
	inline bool use_pass_glossy_indirect(void);
	inline void use_pass_glossy_indirect(int value);
	inline bool use_pass_glossy_color(void);
	inline void use_pass_glossy_color(int value);
	inline bool use_pass_transmission_direct(void);
	inline void use_pass_transmission_direct(int value);
	inline bool use_pass_transmission_indirect(void);
	inline void use_pass_transmission_indirect(int value);
	inline bool use_pass_transmission_color(void);
	inline void use_pass_transmission_color(int value);
	inline bool use_pass_subsurface_direct(void);
	inline void use_pass_subsurface_direct(int value);
	inline bool use_pass_subsurface_indirect(void);
	inline void use_pass_subsurface_indirect(int value);
	inline bool use_pass_subsurface_color(void);
	inline void use_pass_subsurface_color(int value);
	inline FreestyleSettings freestyle_settings(void);

};

/**************** Freestyle Line Set ****************/

class FreestyleLineSet : public Pointer {
public:
	FreestyleLineSet(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline FreestyleLineStyle linestyle(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline bool show_render(void);
	inline void show_render(int value);
	inline bool select_by_visibility(void);
	inline void select_by_visibility(int value);
	inline bool select_by_edge_types(void);
	inline void select_by_edge_types(int value);
	inline bool select_by_group(void);
	inline void select_by_group(int value);
	inline bool select_by_image_border(void);
	inline void select_by_image_border(int value);
	inline bool select_by_face_marks(void);
	inline void select_by_face_marks(int value);
	enum edge_type_negation_enum {
		edge_type_negation_INCLUSIVE = 0,
		edge_type_negation_EXCLUSIVE = 4,
	};
	inline edge_type_negation_enum edge_type_negation(void);
	inline void edge_type_negation(edge_type_negation_enum value);
	enum edge_type_combination_enum {
		edge_type_combination_OR = 0,
		edge_type_combination_AND = 8,
	};
	inline edge_type_combination_enum edge_type_combination(void);
	inline void edge_type_combination(edge_type_combination_enum value);
	inline Group group(void);
	enum group_negation_enum {
		group_negation_INCLUSIVE = 0,
		group_negation_EXCLUSIVE = 16,
	};
	inline group_negation_enum group_negation(void);
	inline void group_negation(group_negation_enum value);
	enum face_mark_negation_enum {
		face_mark_negation_INCLUSIVE = 0,
		face_mark_negation_EXCLUSIVE = 32,
	};
	inline face_mark_negation_enum face_mark_negation(void);
	inline void face_mark_negation(face_mark_negation_enum value);
	enum face_mark_condition_enum {
		face_mark_condition_ONE = 0,
		face_mark_condition_BOTH = 64,
	};
	inline face_mark_condition_enum face_mark_condition(void);
	inline void face_mark_condition(face_mark_condition_enum value);
	inline bool select_silhouette(void);
	inline void select_silhouette(int value);
	inline bool select_border(void);
	inline void select_border(int value);
	inline bool select_crease(void);
	inline void select_crease(int value);
	inline bool select_ridge_valley(void);
	inline void select_ridge_valley(int value);
	inline bool select_suggestive_contour(void);
	inline void select_suggestive_contour(int value);
	inline bool select_material_boundary(void);
	inline void select_material_boundary(int value);
	inline bool select_contour(void);
	inline void select_contour(int value);
	inline bool select_external_contour(void);
	inline void select_external_contour(int value);
	inline bool select_edge_mark(void);
	inline void select_edge_mark(int value);
	inline bool exclude_silhouette(void);
	inline void exclude_silhouette(int value);
	inline bool exclude_border(void);
	inline void exclude_border(int value);
	inline bool exclude_crease(void);
	inline void exclude_crease(int value);
	inline bool exclude_ridge_valley(void);
	inline void exclude_ridge_valley(int value);
	inline bool exclude_suggestive_contour(void);
	inline void exclude_suggestive_contour(int value);
	inline bool exclude_material_boundary(void);
	inline void exclude_material_boundary(int value);
	inline bool exclude_contour(void);
	inline void exclude_contour(int value);
	inline bool exclude_external_contour(void);
	inline void exclude_external_contour(int value);
	inline bool exclude_edge_mark(void);
	inline void exclude_edge_mark(int value);
	enum visibility_enum {
		visibility_VISIBLE = 1,
		visibility_HIDDEN = 2,
		visibility_RANGE = 3,
	};
	inline visibility_enum visibility(void);
	inline void visibility(visibility_enum value);
	inline int qi_start(void);
	inline void qi_start(int value);
	inline int qi_end(void);
	inline void qi_end(int value);

};

/**************** Freestyle Module ****************/

class FreestyleModuleSettings : public Pointer {
public:
	FreestyleModuleSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Text script(void);
	inline bool use(void);
	inline void use(int value);

};

/**************** Freestyle Settings ****************/

class FreestyleSettings : public Pointer {
public:
	FreestyleSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		modules(ptr_arg),
		linesets(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(FreestyleModules, FreestyleModuleSettings, FreestyleSettings, modules, false, true, false)
	enum mode_enum {
		mode_SCRIPT = 1,
		mode_EDITOR = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool use_culling(void);
	inline void use_culling(int value);
	inline bool use_suggestive_contours(void);
	inline void use_suggestive_contours(int value);
	inline bool use_ridges_and_valleys(void);
	inline void use_ridges_and_valleys(int value);
	inline bool use_material_boundaries(void);
	inline void use_material_boundaries(int value);
	inline bool use_smoothness(void);
	inline void use_smoothness(int value);
	inline bool use_advanced_options(void);
	inline void use_advanced_options(int value);
	inline bool use_view_map_cache(void);
	inline void use_view_map_cache(int value);
	inline float sphere_radius(void);
	inline void sphere_radius(float value);
	inline float kr_derivative_epsilon(void);
	inline void kr_derivative_epsilon(float value);
	inline float crease_angle(void);
	inline void crease_angle(float value);
	COLLECTION_PROPERTY(Linesets, FreestyleLineSet, FreestyleSettings, linesets, false, true, true)

};

/**************** Screen ****************/

class Screen : public ID {
public:
	Screen(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		areas(ptr_arg)
		{}

	inline Scene scene(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Area, Screen, areas, false, true, false)
	inline bool is_animation_playing(void);
	inline void is_animation_playing(int value);
	inline bool show_fullscreen(void);
	inline void show_fullscreen(int value);
	inline bool use_play_top_left_3d_editor(void);
	inline void use_play_top_left_3d_editor(int value);
	inline bool use_play_3d_editors(void);
	inline void use_play_3d_editors(int value);
	inline bool use_play_animation_editors(void);
	inline void use_play_animation_editors(int value);
	inline bool use_play_properties_editors(void);
	inline void use_play_properties_editors(int value);
	inline bool use_play_image_editors(void);
	inline void use_play_image_editors(int value);
	inline bool use_play_sequence_editors(void);
	inline void use_play_sequence_editors(int value);
	inline bool use_play_node_editors(void);
	inline void use_play_node_editors(int value);
	inline bool use_play_clip_editors(void);
	inline void use_play_clip_editors(int value);

};

/**************** Area ****************/

class Area : public Pointer {
public:
	Area(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		spaces(ptr_arg),
		regions(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(AreaSpaces, Space, Area, spaces, false, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Region, Area, regions, false, true, false)
	inline bool show_menus(void);
	inline void show_menus(int value);
	enum type_enum {
		type_EMPTY = 0,
		type_VIEW_3D = 1,
		type_TIMELINE = 15,
		type_GRAPH_EDITOR = 2,
		type_DOPESHEET_EDITOR = 12,
		type_NLA_EDITOR = 13,
		type_IMAGE_EDITOR = 6,
		type_SEQUENCE_EDITOR = 8,
		type_CLIP_EDITOR = 20,
		type_TEXT_EDITOR = 9,
		type_NODE_EDITOR = 16,
		type_LOGIC_EDITOR = 17,
		type_PROPERTIES = 4,
		type_OUTLINER = 3,
		type_USER_PREFERENCES = 19,
		type_INFO = 7,
		type_FILE_BROWSER = 5,
		type_CONSOLE = 18,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline int x(void);
	inline void x(int value);
	inline int y(void);
	inline void y(int value);
	inline int width(void);
	inline void width(int value);
	inline int height(void);
	inline void height(int value);

	inline void tag_redraw();
	inline void header_text_set(const char * text);
};

/**************** Region ****************/

class Region : public Pointer {
public:
	Region(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int id(void);
	inline void id(int value);
	enum type_enum {
		type_WINDOW = 0,
		type_HEADER = 1,
		type_CHANNELS = 2,
		type_TEMPORARY = 3,
		type_UI = 4,
		type_TOOLS = 5,
		type_TOOL_PROPS = 6,
		type_PREVIEW = 7,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline int x(void);
	inline void x(int value);
	inline int y(void);
	inline void y(int value);
	inline int width(void);
	inline void width(int value);
	inline int height(void);
	inline void height(int value);
	inline View2D view2d(void);

	inline void tag_redraw();
};

/**************** View2D ****************/

class View2D : public Pointer {
public:
	View2D(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void region_to_view(int x, int y, float result[2]);
	inline void view_to_region(float x, float y, int clip, int result[2]);
};

/**************** Palette Color ****************/

class PaletteColor : public Pointer {
public:
	PaletteColor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline float strength(void);
	inline void strength(float value);
	inline float weight(void);
	inline void weight(float value);

};

/**************** Palette ****************/

class Palette : public ID {
public:
	Palette(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		colors(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, PaletteColor, Palette, colors, false, true, false)

};

/**************** Paint Curve ****************/

class PaintCurve : public ID {
public:
	PaintCurve(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}


};

/**************** Paint ****************/

class Paint : public Pointer {
public:
	Paint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Brush brush(void);
	inline Palette palette(void);
	inline bool show_brush(void);
	inline void show_brush(int value);
	inline bool show_brush_on_surface(void);
	inline void show_brush_on_surface(int value);
	inline bool show_low_resolution(void);
	inline void show_low_resolution(int value);
	inline int input_samples(void);
	inline void input_samples(int value);
	inline bool use_symmetry_x(void);
	inline void use_symmetry_x(int value);
	inline bool use_symmetry_y(void);
	inline void use_symmetry_y(int value);
	inline bool use_symmetry_z(void);
	inline void use_symmetry_z(int value);
	inline bool use_symmetry_feather(void);
	inline void use_symmetry_feather(int value);

};

/**************** Sculpt ****************/

class Sculpt : public Paint {
public:
	Sculpt(const PointerRNA &ptr_arg) :
		Paint(ptr_arg)
		{}

	inline Array<int, 3> radial_symmetry(void);
	inline void radial_symmetry(int values[3]);
	inline bool lock_x(void);
	inline void lock_x(int value);
	inline bool lock_y(void);
	inline void lock_y(int value);
	inline bool lock_z(void);
	inline void lock_z(int value);
	inline bool use_threaded(void);
	inline void use_threaded(int value);
	inline bool use_deform_only(void);
	inline void use_deform_only(int value);
	inline bool show_diffuse_color(void);
	inline void show_diffuse_color(int value);
	inline float detail_size(void);
	inline void detail_size(float value);
	inline float constant_detail(void);
	inline void constant_detail(float value);
	inline bool use_smooth_shading(void);
	inline void use_smooth_shading(int value);
	enum symmetrize_direction_enum {
		symmetrize_direction_NEGATIVE_X = 0,
		symmetrize_direction_POSITIVE_X = 3,
		symmetrize_direction_NEGATIVE_Y = 1,
		symmetrize_direction_POSITIVE_Y = 4,
		symmetrize_direction_NEGATIVE_Z = 2,
		symmetrize_direction_POSITIVE_Z = 5,
	};
	inline symmetrize_direction_enum symmetrize_direction(void);
	inline void symmetrize_direction(symmetrize_direction_enum value);
	enum detail_refine_method_enum {
		detail_refine_method_SUBDIVIDE = 4096,
		detail_refine_method_COLLAPSE = 2048,
		detail_refine_method_SUBDIVIDE_COLLAPSE = 6144,
	};
	inline detail_refine_method_enum detail_refine_method(void);
	inline void detail_refine_method(detail_refine_method_enum value);
	enum detail_type_method_enum {
		detail_type_method_RELATIVE = 0,
		detail_type_method_CONSTANT = 8192,
	};
	inline detail_type_method_enum detail_type_method(void);
	inline void detail_type_method(detail_type_method_enum value);
	inline float gravity(void);
	inline void gravity(float value);
	inline Object gravity_object(void);

};

/**************** UV Sculpting ****************/

class UvSculpt : public Paint {
public:
	UvSculpt(const PointerRNA &ptr_arg) :
		Paint(ptr_arg)
		{}


};

/**************** Vertex Paint ****************/

class VertexPaint : public Paint {
public:
	VertexPaint(const PointerRNA &ptr_arg) :
		Paint(ptr_arg)
		{}

	inline bool use_normal(void);
	inline void use_normal(int value);
	inline bool use_spray(void);
	inline void use_spray(int value);
	inline bool use_group_restrict(void);
	inline void use_group_restrict(int value);

};

/**************** Image Paint ****************/

class ImagePaint : public Paint {
public:
	ImagePaint(const PointerRNA &ptr_arg) :
		Paint(ptr_arg)
		{}

	inline bool use_occlude(void);
	inline void use_occlude(int value);
	inline bool use_backface_culling(void);
	inline void use_backface_culling(int value);
	inline bool use_normal_falloff(void);
	inline void use_normal_falloff(int value);
	inline bool use_stencil_layer(void);
	inline void use_stencil_layer(int value);
	inline bool invert_stencil(void);
	inline void invert_stencil(int value);
	inline Image stencil_image(void);
	inline Image canvas(void);
	inline Image clone_image(void);
	inline Array<float, 3> stencil_color(void);
	inline void stencil_color(float values[3]);
	inline bool use_clone_layer(void);
	inline void use_clone_layer(int value);
	inline int seam_bleed(void);
	inline void seam_bleed(int value);
	inline int normal_angle(void);
	inline void normal_angle(int value);
	inline Array<int, 2> screen_grab_size(void);
	inline void screen_grab_size(int values[2]);
	enum mode_enum {
		mode_MATERIAL = 0,
		mode_IMAGE = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool missing_uvs(void);
	inline void missing_uvs(int value);
	inline bool missing_materials(void);
	inline void missing_materials(int value);
	inline bool missing_stencil(void);
	inline void missing_stencil(int value);
	inline bool missing_texture(void);
	inline void missing_texture(int value);

	inline int detect_data();
};

/**************** Particle Edit ****************/

class ParticleEdit : public Pointer {
public:
	ParticleEdit(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum tool_enum {
		tool_NONE = -1,
		tool_COMB = 0,
		tool_SMOOTH = 5,
		tool_ADD = 4,
		tool_LENGTH = 2,
		tool_PUFF = 3,
		tool_CUT = 1,
		tool_WEIGHT = 6,
	};
	inline tool_enum tool(void);
	inline void tool(tool_enum value);
	enum select_mode_enum {
		select_mode_PATH = 1,
		select_mode_POINT = 2,
		select_mode_TIP = 4,
	};
	inline select_mode_enum select_mode(void);
	inline void select_mode(select_mode_enum value);
	inline bool use_preserve_length(void);
	inline void use_preserve_length(int value);
	inline bool use_preserve_root(void);
	inline void use_preserve_root(int value);
	inline bool use_emitter_deflect(void);
	inline void use_emitter_deflect(int value);
	inline float emitter_distance(void);
	inline void emitter_distance(float value);
	inline bool use_fade_time(void);
	inline void use_fade_time(int value);
	inline bool use_auto_velocity(void);
	inline void use_auto_velocity(int value);
	inline bool show_particles(void);
	inline void show_particles(int value);
	inline bool use_default_interpolate(void);
	inline void use_default_interpolate(int value);
	inline int default_key_count(void);
	inline void default_key_count(int value);
	inline ParticleBrush brush(void);
	inline int draw_step(void);
	inline void draw_step(int value);
	inline int fade_frames(void);
	inline void fade_frames(int value);
	enum type_enum {
		type_PARTICLES = 0,
		type_SOFT_BODY = 1,
		type_CLOTH = 2,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool is_editable(void);
	inline void is_editable(int value);
	inline bool is_hair(void);
	inline void is_hair(int value);
	inline Object object(void);

};

/**************** Particle Brush ****************/

class ParticleBrush : public Pointer {
public:
	ParticleBrush(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int size(void);
	inline void size(int value);
	inline float strength(void);
	inline void strength(float value);
	inline int count(void);
	inline void count(int value);
	inline int steps(void);
	inline void steps(int value);
	enum puff_mode_enum {
		puff_mode_ADD = 0,
		puff_mode_SUB = 1,
	};
	inline puff_mode_enum puff_mode(void);
	inline void puff_mode(puff_mode_enum value);
	inline bool use_puff_volume(void);
	inline void use_puff_volume(int value);
	enum length_mode_enum {
		length_mode_GROW = 0,
		length_mode_SHRINK = 1,
	};
	inline length_mode_enum length_mode(void);
	inline void length_mode(length_mode_enum value);
	inline CurveMapping curve(void);

};

/**************** Sensor ****************/

class Sensor : public Pointer {
public:
	Sensor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		controllers(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_ACTUATOR = 12,
		type_ALWAYS = 0,
		type_ARMATURE = 14,
		type_COLLISION = 6,
		type_DELAY = 13,
		type_JOYSTICK = 11,
		type_KEYBOARD = 3,
		type_MESSAGE = 10,
		type_MOUSE = 5,
		type_NEAR = 2,
		type_PROPERTY = 4,
		type_RADAR = 7,
		type_RANDOM = 8,
		type_RAY = 9,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool pin(void);
	inline void pin(int value);
	inline bool active(void);
	inline void active(int value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	inline bool invert(void);
	inline void invert(int value);
	inline bool use_level(void);
	inline void use_level(int value);
	inline bool use_pulse_true_level(void);
	inline void use_pulse_true_level(int value);
	inline bool use_pulse_false_level(void);
	inline void use_pulse_false_level(int value);
	inline int frequency(void);
	inline void frequency(int value);
	inline bool use_tap(void);
	inline void use_tap(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Controller, Sensor, controllers, true, true, true)

	inline void link(Controller controller);
	inline void unlink(Controller controller);
};

/**************** Always Sensor ****************/

class AlwaysSensor : public Sensor {
public:
	AlwaysSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}


};

/**************** Near Sensor ****************/

class NearSensor : public Sensor {
public:
	NearSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	inline std::string property(void);	inline void property(const std::string& value);
	inline float distance(void);
	inline void distance(float value);
	inline float reset_distance(void);
	inline void reset_distance(float value);

};

/**************** Mouse Sensor ****************/

class MouseSensor : public Sensor {
public:
	MouseSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	enum mouse_event_enum {
		mouse_event_LEFTCLICK = 1,
		mouse_event_MIDDLECLICK = 2,
		mouse_event_RIGHTCLICK = 4,
		mouse_event_WHEELUP = 5,
		mouse_event_WHEELDOWN = 6,
		mouse_event_MOVEMENT = 8,
		mouse_event_MOUSEOVER = 16,
		mouse_event_MOUSEOVERANY = 32,
	};
	inline mouse_event_enum mouse_event(void);
	inline void mouse_event(mouse_event_enum value);
	inline bool use_pulse(void);
	inline void use_pulse(int value);
	enum use_material_enum {
		use_material_PROPERTY = 0,
		use_material_MATERIAL = 1,
	};
	inline use_material_enum use_material(void);
	inline void use_material(use_material_enum value);
	inline std::string property(void);	inline void property(const std::string& value);
	inline std::string material(void);	inline void material(const std::string& value);
	inline bool use_x_ray(void);
	inline void use_x_ray(int value);

};

/**************** Keyboard Sensor ****************/

class KeyboardSensor : public Sensor {
public:
	KeyboardSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	enum key_enum {
		key_NONE = 0,
		key_LEFTMOUSE = 1,
		key_MIDDLEMOUSE = 2,
		key_RIGHTMOUSE = 3,
		key_BUTTON4MOUSE = 7,
		key_BUTTON5MOUSE = 8,
		key_BUTTON6MOUSE = 18,
		key_BUTTON7MOUSE = 19,
		key_ACTIONMOUSE = 5,
		key_SELECTMOUSE = 6,
		key_MOUSEMOVE = 4,
		key_INBETWEEN_MOUSEMOVE = 17,
		key_TRACKPADPAN = 14,
		key_TRACKPADZOOM = 15,
		key_MOUSEROTATE = 16,
		key_WHEELUPMOUSE = 10,
		key_WHEELDOWNMOUSE = 11,
		key_WHEELINMOUSE = 12,
		key_WHEELOUTMOUSE = 13,
		key_EVT_TWEAK_L = 20483,
		key_EVT_TWEAK_M = 20484,
		key_EVT_TWEAK_R = 20485,
		key_EVT_TWEAK_A = 20486,
		key_EVT_TWEAK_S = 20487,
		key_A = 97,
		key_B = 98,
		key_C = 99,
		key_D = 100,
		key_E = 101,
		key_F = 102,
		key_G = 103,
		key_H = 104,
		key_I = 105,
		key_J = 106,
		key_K = 107,
		key_L = 108,
		key_M = 109,
		key_N = 110,
		key_O = 111,
		key_P = 112,
		key_Q = 113,
		key_R = 114,
		key_S = 115,
		key_T = 116,
		key_U = 117,
		key_V = 118,
		key_W = 119,
		key_X = 120,
		key_Y = 121,
		key_Z = 122,
		key_ZERO = 48,
		key_ONE = 49,
		key_TWO = 50,
		key_THREE = 51,
		key_FOUR = 52,
		key_FIVE = 53,
		key_SIX = 54,
		key_SEVEN = 55,
		key_EIGHT = 56,
		key_NINE = 57,
		key_LEFT_CTRL = 212,
		key_LEFT_ALT = 213,
		key_LEFT_SHIFT = 217,
		key_RIGHT_ALT = 214,
		key_RIGHT_CTRL = 215,
		key_RIGHT_SHIFT = 216,
		key_OSKEY = 172,
		key_GRLESS = 173,
		key_ESC = 218,
		key_TAB = 219,
		key_RET = 220,
		key_SPACE = 221,
		key_LINE_FEED = 222,
		key_BACK_SPACE = 223,
		key_DEL = 224,
		key_SEMI_COLON = 225,
		key_PERIOD = 226,
		key_COMMA = 227,
		key_QUOTE = 228,
		key_ACCENT_GRAVE = 229,
		key_MINUS = 230,
		key_SLASH = 232,
		key_BACK_SLASH = 233,
		key_EQUAL = 234,
		key_LEFT_BRACKET = 235,
		key_RIGHT_BRACKET = 236,
		key_LEFT_ARROW = 137,
		key_DOWN_ARROW = 138,
		key_RIGHT_ARROW = 139,
		key_UP_ARROW = 140,
		key_NUMPAD_2 = 152,
		key_NUMPAD_4 = 154,
		key_NUMPAD_6 = 156,
		key_NUMPAD_8 = 158,
		key_NUMPAD_1 = 151,
		key_NUMPAD_3 = 153,
		key_NUMPAD_5 = 155,
		key_NUMPAD_7 = 157,
		key_NUMPAD_9 = 159,
		key_NUMPAD_PERIOD = 199,
		key_NUMPAD_SLASH = 161,
		key_NUMPAD_ASTERIX = 160,
		key_NUMPAD_0 = 150,
		key_NUMPAD_MINUS = 162,
		key_NUMPAD_ENTER = 163,
		key_NUMPAD_PLUS = 164,
		key_F1 = 300,
		key_F2 = 301,
		key_F3 = 302,
		key_F4 = 303,
		key_F5 = 304,
		key_F6 = 305,
		key_F7 = 306,
		key_F8 = 307,
		key_F9 = 308,
		key_F10 = 309,
		key_F11 = 310,
		key_F12 = 311,
		key_F13 = 312,
		key_F14 = 313,
		key_F15 = 314,
		key_F16 = 315,
		key_F17 = 316,
		key_F18 = 317,
		key_F19 = 318,
		key_PAUSE = 165,
		key_INSERT = 166,
		key_HOME = 167,
		key_PAGE_UP = 168,
		key_PAGE_DOWN = 169,
		key_END = 170,
		key_MEDIA_PLAY = 174,
		key_MEDIA_STOP = 175,
		key_MEDIA_FIRST = 176,
		key_MEDIA_LAST = 177,
		key_TEXTINPUT = -2,
		key_WINDOW_DEACTIVATE = 260,
		key_TIMER = 272,
		key_TIMER0 = 273,
		key_TIMER1 = 274,
		key_TIMER2 = 275,
		key_TIMER_JOBS = 276,
		key_TIMER_AUTOSAVE = 277,
		key_TIMER_REPORT = 278,
		key_TIMERREGION = 279,
		key_NDOF_MOTION = 400,
		key_NDOF_BUTTON_MENU = 401,
		key_NDOF_BUTTON_FIT = 402,
		key_NDOF_BUTTON_TOP = 403,
		key_NDOF_BUTTON_BOTTOM = 404,
		key_NDOF_BUTTON_LEFT = 405,
		key_NDOF_BUTTON_RIGHT = 406,
		key_NDOF_BUTTON_FRONT = 407,
		key_NDOF_BUTTON_BACK = 408,
		key_NDOF_BUTTON_ISO1 = 409,
		key_NDOF_BUTTON_ISO2 = 410,
		key_NDOF_BUTTON_ROLL_CW = 411,
		key_NDOF_BUTTON_ROLL_CCW = 412,
		key_NDOF_BUTTON_SPIN_CW = 413,
		key_NDOF_BUTTON_SPIN_CCW = 414,
		key_NDOF_BUTTON_TILT_CW = 415,
		key_NDOF_BUTTON_TILT_CCW = 416,
		key_NDOF_BUTTON_ROTATE = 417,
		key_NDOF_BUTTON_PANZOOM = 418,
		key_NDOF_BUTTON_DOMINANT = 419,
		key_NDOF_BUTTON_PLUS = 420,
		key_NDOF_BUTTON_MINUS = 421,
		key_NDOF_BUTTON_ESC = 422,
		key_NDOF_BUTTON_ALT = 423,
		key_NDOF_BUTTON_SHIFT = 424,
		key_NDOF_BUTTON_CTRL = 425,
		key_NDOF_BUTTON_1 = 426,
		key_NDOF_BUTTON_2 = 427,
		key_NDOF_BUTTON_3 = 428,
		key_NDOF_BUTTON_4 = 429,
		key_NDOF_BUTTON_5 = 430,
		key_NDOF_BUTTON_6 = 431,
		key_NDOF_BUTTON_7 = 432,
		key_NDOF_BUTTON_8 = 433,
		key_NDOF_BUTTON_9 = 434,
		key_NDOF_BUTTON_10 = 435,
		key_NDOF_BUTTON_A = 436,
		key_NDOF_BUTTON_B = 437,
		key_NDOF_BUTTON_C = 438,
	};
	inline key_enum key(void);
	inline void key(key_enum value);
	enum modifier_key_1_enum {
		modifier_key_1_NONE = 0,
		modifier_key_1_LEFTMOUSE = 1,
		modifier_key_1_MIDDLEMOUSE = 2,
		modifier_key_1_RIGHTMOUSE = 3,
		modifier_key_1_BUTTON4MOUSE = 7,
		modifier_key_1_BUTTON5MOUSE = 8,
		modifier_key_1_BUTTON6MOUSE = 18,
		modifier_key_1_BUTTON7MOUSE = 19,
		modifier_key_1_ACTIONMOUSE = 5,
		modifier_key_1_SELECTMOUSE = 6,
		modifier_key_1_MOUSEMOVE = 4,
		modifier_key_1_INBETWEEN_MOUSEMOVE = 17,
		modifier_key_1_TRACKPADPAN = 14,
		modifier_key_1_TRACKPADZOOM = 15,
		modifier_key_1_MOUSEROTATE = 16,
		modifier_key_1_WHEELUPMOUSE = 10,
		modifier_key_1_WHEELDOWNMOUSE = 11,
		modifier_key_1_WHEELINMOUSE = 12,
		modifier_key_1_WHEELOUTMOUSE = 13,
		modifier_key_1_EVT_TWEAK_L = 20483,
		modifier_key_1_EVT_TWEAK_M = 20484,
		modifier_key_1_EVT_TWEAK_R = 20485,
		modifier_key_1_EVT_TWEAK_A = 20486,
		modifier_key_1_EVT_TWEAK_S = 20487,
		modifier_key_1_A = 97,
		modifier_key_1_B = 98,
		modifier_key_1_C = 99,
		modifier_key_1_D = 100,
		modifier_key_1_E = 101,
		modifier_key_1_F = 102,
		modifier_key_1_G = 103,
		modifier_key_1_H = 104,
		modifier_key_1_I = 105,
		modifier_key_1_J = 106,
		modifier_key_1_K = 107,
		modifier_key_1_L = 108,
		modifier_key_1_M = 109,
		modifier_key_1_N = 110,
		modifier_key_1_O = 111,
		modifier_key_1_P = 112,
		modifier_key_1_Q = 113,
		modifier_key_1_R = 114,
		modifier_key_1_S = 115,
		modifier_key_1_T = 116,
		modifier_key_1_U = 117,
		modifier_key_1_V = 118,
		modifier_key_1_W = 119,
		modifier_key_1_X = 120,
		modifier_key_1_Y = 121,
		modifier_key_1_Z = 122,
		modifier_key_1_ZERO = 48,
		modifier_key_1_ONE = 49,
		modifier_key_1_TWO = 50,
		modifier_key_1_THREE = 51,
		modifier_key_1_FOUR = 52,
		modifier_key_1_FIVE = 53,
		modifier_key_1_SIX = 54,
		modifier_key_1_SEVEN = 55,
		modifier_key_1_EIGHT = 56,
		modifier_key_1_NINE = 57,
		modifier_key_1_LEFT_CTRL = 212,
		modifier_key_1_LEFT_ALT = 213,
		modifier_key_1_LEFT_SHIFT = 217,
		modifier_key_1_RIGHT_ALT = 214,
		modifier_key_1_RIGHT_CTRL = 215,
		modifier_key_1_RIGHT_SHIFT = 216,
		modifier_key_1_OSKEY = 172,
		modifier_key_1_GRLESS = 173,
		modifier_key_1_ESC = 218,
		modifier_key_1_TAB = 219,
		modifier_key_1_RET = 220,
		modifier_key_1_SPACE = 221,
		modifier_key_1_LINE_FEED = 222,
		modifier_key_1_BACK_SPACE = 223,
		modifier_key_1_DEL = 224,
		modifier_key_1_SEMI_COLON = 225,
		modifier_key_1_PERIOD = 226,
		modifier_key_1_COMMA = 227,
		modifier_key_1_QUOTE = 228,
		modifier_key_1_ACCENT_GRAVE = 229,
		modifier_key_1_MINUS = 230,
		modifier_key_1_SLASH = 232,
		modifier_key_1_BACK_SLASH = 233,
		modifier_key_1_EQUAL = 234,
		modifier_key_1_LEFT_BRACKET = 235,
		modifier_key_1_RIGHT_BRACKET = 236,
		modifier_key_1_LEFT_ARROW = 137,
		modifier_key_1_DOWN_ARROW = 138,
		modifier_key_1_RIGHT_ARROW = 139,
		modifier_key_1_UP_ARROW = 140,
		modifier_key_1_NUMPAD_2 = 152,
		modifier_key_1_NUMPAD_4 = 154,
		modifier_key_1_NUMPAD_6 = 156,
		modifier_key_1_NUMPAD_8 = 158,
		modifier_key_1_NUMPAD_1 = 151,
		modifier_key_1_NUMPAD_3 = 153,
		modifier_key_1_NUMPAD_5 = 155,
		modifier_key_1_NUMPAD_7 = 157,
		modifier_key_1_NUMPAD_9 = 159,
		modifier_key_1_NUMPAD_PERIOD = 199,
		modifier_key_1_NUMPAD_SLASH = 161,
		modifier_key_1_NUMPAD_ASTERIX = 160,
		modifier_key_1_NUMPAD_0 = 150,
		modifier_key_1_NUMPAD_MINUS = 162,
		modifier_key_1_NUMPAD_ENTER = 163,
		modifier_key_1_NUMPAD_PLUS = 164,
		modifier_key_1_F1 = 300,
		modifier_key_1_F2 = 301,
		modifier_key_1_F3 = 302,
		modifier_key_1_F4 = 303,
		modifier_key_1_F5 = 304,
		modifier_key_1_F6 = 305,
		modifier_key_1_F7 = 306,
		modifier_key_1_F8 = 307,
		modifier_key_1_F9 = 308,
		modifier_key_1_F10 = 309,
		modifier_key_1_F11 = 310,
		modifier_key_1_F12 = 311,
		modifier_key_1_F13 = 312,
		modifier_key_1_F14 = 313,
		modifier_key_1_F15 = 314,
		modifier_key_1_F16 = 315,
		modifier_key_1_F17 = 316,
		modifier_key_1_F18 = 317,
		modifier_key_1_F19 = 318,
		modifier_key_1_PAUSE = 165,
		modifier_key_1_INSERT = 166,
		modifier_key_1_HOME = 167,
		modifier_key_1_PAGE_UP = 168,
		modifier_key_1_PAGE_DOWN = 169,
		modifier_key_1_END = 170,
		modifier_key_1_MEDIA_PLAY = 174,
		modifier_key_1_MEDIA_STOP = 175,
		modifier_key_1_MEDIA_FIRST = 176,
		modifier_key_1_MEDIA_LAST = 177,
		modifier_key_1_TEXTINPUT = -2,
		modifier_key_1_WINDOW_DEACTIVATE = 260,
		modifier_key_1_TIMER = 272,
		modifier_key_1_TIMER0 = 273,
		modifier_key_1_TIMER1 = 274,
		modifier_key_1_TIMER2 = 275,
		modifier_key_1_TIMER_JOBS = 276,
		modifier_key_1_TIMER_AUTOSAVE = 277,
		modifier_key_1_TIMER_REPORT = 278,
		modifier_key_1_TIMERREGION = 279,
		modifier_key_1_NDOF_MOTION = 400,
		modifier_key_1_NDOF_BUTTON_MENU = 401,
		modifier_key_1_NDOF_BUTTON_FIT = 402,
		modifier_key_1_NDOF_BUTTON_TOP = 403,
		modifier_key_1_NDOF_BUTTON_BOTTOM = 404,
		modifier_key_1_NDOF_BUTTON_LEFT = 405,
		modifier_key_1_NDOF_BUTTON_RIGHT = 406,
		modifier_key_1_NDOF_BUTTON_FRONT = 407,
		modifier_key_1_NDOF_BUTTON_BACK = 408,
		modifier_key_1_NDOF_BUTTON_ISO1 = 409,
		modifier_key_1_NDOF_BUTTON_ISO2 = 410,
		modifier_key_1_NDOF_BUTTON_ROLL_CW = 411,
		modifier_key_1_NDOF_BUTTON_ROLL_CCW = 412,
		modifier_key_1_NDOF_BUTTON_SPIN_CW = 413,
		modifier_key_1_NDOF_BUTTON_SPIN_CCW = 414,
		modifier_key_1_NDOF_BUTTON_TILT_CW = 415,
		modifier_key_1_NDOF_BUTTON_TILT_CCW = 416,
		modifier_key_1_NDOF_BUTTON_ROTATE = 417,
		modifier_key_1_NDOF_BUTTON_PANZOOM = 418,
		modifier_key_1_NDOF_BUTTON_DOMINANT = 419,
		modifier_key_1_NDOF_BUTTON_PLUS = 420,
		modifier_key_1_NDOF_BUTTON_MINUS = 421,
		modifier_key_1_NDOF_BUTTON_ESC = 422,
		modifier_key_1_NDOF_BUTTON_ALT = 423,
		modifier_key_1_NDOF_BUTTON_SHIFT = 424,
		modifier_key_1_NDOF_BUTTON_CTRL = 425,
		modifier_key_1_NDOF_BUTTON_1 = 426,
		modifier_key_1_NDOF_BUTTON_2 = 427,
		modifier_key_1_NDOF_BUTTON_3 = 428,
		modifier_key_1_NDOF_BUTTON_4 = 429,
		modifier_key_1_NDOF_BUTTON_5 = 430,
		modifier_key_1_NDOF_BUTTON_6 = 431,
		modifier_key_1_NDOF_BUTTON_7 = 432,
		modifier_key_1_NDOF_BUTTON_8 = 433,
		modifier_key_1_NDOF_BUTTON_9 = 434,
		modifier_key_1_NDOF_BUTTON_10 = 435,
		modifier_key_1_NDOF_BUTTON_A = 436,
		modifier_key_1_NDOF_BUTTON_B = 437,
		modifier_key_1_NDOF_BUTTON_C = 438,
	};
	inline modifier_key_1_enum modifier_key_1(void);
	inline void modifier_key_1(modifier_key_1_enum value);
	enum modifier_key_2_enum {
		modifier_key_2_NONE = 0,
		modifier_key_2_LEFTMOUSE = 1,
		modifier_key_2_MIDDLEMOUSE = 2,
		modifier_key_2_RIGHTMOUSE = 3,
		modifier_key_2_BUTTON4MOUSE = 7,
		modifier_key_2_BUTTON5MOUSE = 8,
		modifier_key_2_BUTTON6MOUSE = 18,
		modifier_key_2_BUTTON7MOUSE = 19,
		modifier_key_2_ACTIONMOUSE = 5,
		modifier_key_2_SELECTMOUSE = 6,
		modifier_key_2_MOUSEMOVE = 4,
		modifier_key_2_INBETWEEN_MOUSEMOVE = 17,
		modifier_key_2_TRACKPADPAN = 14,
		modifier_key_2_TRACKPADZOOM = 15,
		modifier_key_2_MOUSEROTATE = 16,
		modifier_key_2_WHEELUPMOUSE = 10,
		modifier_key_2_WHEELDOWNMOUSE = 11,
		modifier_key_2_WHEELINMOUSE = 12,
		modifier_key_2_WHEELOUTMOUSE = 13,
		modifier_key_2_EVT_TWEAK_L = 20483,
		modifier_key_2_EVT_TWEAK_M = 20484,
		modifier_key_2_EVT_TWEAK_R = 20485,
		modifier_key_2_EVT_TWEAK_A = 20486,
		modifier_key_2_EVT_TWEAK_S = 20487,
		modifier_key_2_A = 97,
		modifier_key_2_B = 98,
		modifier_key_2_C = 99,
		modifier_key_2_D = 100,
		modifier_key_2_E = 101,
		modifier_key_2_F = 102,
		modifier_key_2_G = 103,
		modifier_key_2_H = 104,
		modifier_key_2_I = 105,
		modifier_key_2_J = 106,
		modifier_key_2_K = 107,
		modifier_key_2_L = 108,
		modifier_key_2_M = 109,
		modifier_key_2_N = 110,
		modifier_key_2_O = 111,
		modifier_key_2_P = 112,
		modifier_key_2_Q = 113,
		modifier_key_2_R = 114,
		modifier_key_2_S = 115,
		modifier_key_2_T = 116,
		modifier_key_2_U = 117,
		modifier_key_2_V = 118,
		modifier_key_2_W = 119,
		modifier_key_2_X = 120,
		modifier_key_2_Y = 121,
		modifier_key_2_Z = 122,
		modifier_key_2_ZERO = 48,
		modifier_key_2_ONE = 49,
		modifier_key_2_TWO = 50,
		modifier_key_2_THREE = 51,
		modifier_key_2_FOUR = 52,
		modifier_key_2_FIVE = 53,
		modifier_key_2_SIX = 54,
		modifier_key_2_SEVEN = 55,
		modifier_key_2_EIGHT = 56,
		modifier_key_2_NINE = 57,
		modifier_key_2_LEFT_CTRL = 212,
		modifier_key_2_LEFT_ALT = 213,
		modifier_key_2_LEFT_SHIFT = 217,
		modifier_key_2_RIGHT_ALT = 214,
		modifier_key_2_RIGHT_CTRL = 215,
		modifier_key_2_RIGHT_SHIFT = 216,
		modifier_key_2_OSKEY = 172,
		modifier_key_2_GRLESS = 173,
		modifier_key_2_ESC = 218,
		modifier_key_2_TAB = 219,
		modifier_key_2_RET = 220,
		modifier_key_2_SPACE = 221,
		modifier_key_2_LINE_FEED = 222,
		modifier_key_2_BACK_SPACE = 223,
		modifier_key_2_DEL = 224,
		modifier_key_2_SEMI_COLON = 225,
		modifier_key_2_PERIOD = 226,
		modifier_key_2_COMMA = 227,
		modifier_key_2_QUOTE = 228,
		modifier_key_2_ACCENT_GRAVE = 229,
		modifier_key_2_MINUS = 230,
		modifier_key_2_SLASH = 232,
		modifier_key_2_BACK_SLASH = 233,
		modifier_key_2_EQUAL = 234,
		modifier_key_2_LEFT_BRACKET = 235,
		modifier_key_2_RIGHT_BRACKET = 236,
		modifier_key_2_LEFT_ARROW = 137,
		modifier_key_2_DOWN_ARROW = 138,
		modifier_key_2_RIGHT_ARROW = 139,
		modifier_key_2_UP_ARROW = 140,
		modifier_key_2_NUMPAD_2 = 152,
		modifier_key_2_NUMPAD_4 = 154,
		modifier_key_2_NUMPAD_6 = 156,
		modifier_key_2_NUMPAD_8 = 158,
		modifier_key_2_NUMPAD_1 = 151,
		modifier_key_2_NUMPAD_3 = 153,
		modifier_key_2_NUMPAD_5 = 155,
		modifier_key_2_NUMPAD_7 = 157,
		modifier_key_2_NUMPAD_9 = 159,
		modifier_key_2_NUMPAD_PERIOD = 199,
		modifier_key_2_NUMPAD_SLASH = 161,
		modifier_key_2_NUMPAD_ASTERIX = 160,
		modifier_key_2_NUMPAD_0 = 150,
		modifier_key_2_NUMPAD_MINUS = 162,
		modifier_key_2_NUMPAD_ENTER = 163,
		modifier_key_2_NUMPAD_PLUS = 164,
		modifier_key_2_F1 = 300,
		modifier_key_2_F2 = 301,
		modifier_key_2_F3 = 302,
		modifier_key_2_F4 = 303,
		modifier_key_2_F5 = 304,
		modifier_key_2_F6 = 305,
		modifier_key_2_F7 = 306,
		modifier_key_2_F8 = 307,
		modifier_key_2_F9 = 308,
		modifier_key_2_F10 = 309,
		modifier_key_2_F11 = 310,
		modifier_key_2_F12 = 311,
		modifier_key_2_F13 = 312,
		modifier_key_2_F14 = 313,
		modifier_key_2_F15 = 314,
		modifier_key_2_F16 = 315,
		modifier_key_2_F17 = 316,
		modifier_key_2_F18 = 317,
		modifier_key_2_F19 = 318,
		modifier_key_2_PAUSE = 165,
		modifier_key_2_INSERT = 166,
		modifier_key_2_HOME = 167,
		modifier_key_2_PAGE_UP = 168,
		modifier_key_2_PAGE_DOWN = 169,
		modifier_key_2_END = 170,
		modifier_key_2_MEDIA_PLAY = 174,
		modifier_key_2_MEDIA_STOP = 175,
		modifier_key_2_MEDIA_FIRST = 176,
		modifier_key_2_MEDIA_LAST = 177,
		modifier_key_2_TEXTINPUT = -2,
		modifier_key_2_WINDOW_DEACTIVATE = 260,
		modifier_key_2_TIMER = 272,
		modifier_key_2_TIMER0 = 273,
		modifier_key_2_TIMER1 = 274,
		modifier_key_2_TIMER2 = 275,
		modifier_key_2_TIMER_JOBS = 276,
		modifier_key_2_TIMER_AUTOSAVE = 277,
		modifier_key_2_TIMER_REPORT = 278,
		modifier_key_2_TIMERREGION = 279,
		modifier_key_2_NDOF_MOTION = 400,
		modifier_key_2_NDOF_BUTTON_MENU = 401,
		modifier_key_2_NDOF_BUTTON_FIT = 402,
		modifier_key_2_NDOF_BUTTON_TOP = 403,
		modifier_key_2_NDOF_BUTTON_BOTTOM = 404,
		modifier_key_2_NDOF_BUTTON_LEFT = 405,
		modifier_key_2_NDOF_BUTTON_RIGHT = 406,
		modifier_key_2_NDOF_BUTTON_FRONT = 407,
		modifier_key_2_NDOF_BUTTON_BACK = 408,
		modifier_key_2_NDOF_BUTTON_ISO1 = 409,
		modifier_key_2_NDOF_BUTTON_ISO2 = 410,
		modifier_key_2_NDOF_BUTTON_ROLL_CW = 411,
		modifier_key_2_NDOF_BUTTON_ROLL_CCW = 412,
		modifier_key_2_NDOF_BUTTON_SPIN_CW = 413,
		modifier_key_2_NDOF_BUTTON_SPIN_CCW = 414,
		modifier_key_2_NDOF_BUTTON_TILT_CW = 415,
		modifier_key_2_NDOF_BUTTON_TILT_CCW = 416,
		modifier_key_2_NDOF_BUTTON_ROTATE = 417,
		modifier_key_2_NDOF_BUTTON_PANZOOM = 418,
		modifier_key_2_NDOF_BUTTON_DOMINANT = 419,
		modifier_key_2_NDOF_BUTTON_PLUS = 420,
		modifier_key_2_NDOF_BUTTON_MINUS = 421,
		modifier_key_2_NDOF_BUTTON_ESC = 422,
		modifier_key_2_NDOF_BUTTON_ALT = 423,
		modifier_key_2_NDOF_BUTTON_SHIFT = 424,
		modifier_key_2_NDOF_BUTTON_CTRL = 425,
		modifier_key_2_NDOF_BUTTON_1 = 426,
		modifier_key_2_NDOF_BUTTON_2 = 427,
		modifier_key_2_NDOF_BUTTON_3 = 428,
		modifier_key_2_NDOF_BUTTON_4 = 429,
		modifier_key_2_NDOF_BUTTON_5 = 430,
		modifier_key_2_NDOF_BUTTON_6 = 431,
		modifier_key_2_NDOF_BUTTON_7 = 432,
		modifier_key_2_NDOF_BUTTON_8 = 433,
		modifier_key_2_NDOF_BUTTON_9 = 434,
		modifier_key_2_NDOF_BUTTON_10 = 435,
		modifier_key_2_NDOF_BUTTON_A = 436,
		modifier_key_2_NDOF_BUTTON_B = 437,
		modifier_key_2_NDOF_BUTTON_C = 438,
	};
	inline modifier_key_2_enum modifier_key_2(void);
	inline void modifier_key_2(modifier_key_2_enum value);
	inline std::string target(void);	inline void target(const std::string& value);
	inline std::string log(void);	inline void log(const std::string& value);
	inline bool use_all_keys(void);
	inline void use_all_keys(int value);

};

/**************** Property Sensor ****************/

class PropertySensor : public Sensor {
public:
	PropertySensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	enum evaluation_type_enum {
		evaluation_type_PROPEQUAL = 0,
		evaluation_type_PROPNEQUAL = 1,
		evaluation_type_PROPINTERVAL = 2,
		evaluation_type_PROPCHANGED = 3,
		evaluation_type_PROPLESSTHAN = 5,
		evaluation_type_PROPGREATERTHAN = 6,
	};
	inline evaluation_type_enum evaluation_type(void);
	inline void evaluation_type(evaluation_type_enum value);
	inline std::string property(void);	inline void property(const std::string& value);
	inline std::string value(void);	inline void value(const std::string& value);
	inline std::string value_min(void);	inline void value_min(const std::string& value);
	inline std::string value_max(void);	inline void value_max(const std::string& value);

};

/**************** Armature Sensor ****************/

class ArmatureSensor : public Sensor {
public:
	ArmatureSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	enum test_type_enum {
		test_type_STATECHG = 0,
		test_type_LINERRORBELOW = 1,
		test_type_LINERRORABOVE = 2,
		test_type_ROTERRORBELOW = 3,
		test_type_ROTERRORABOVE = 4,
	};
	inline test_type_enum test_type(void);
	inline void test_type(test_type_enum value);
	inline std::string bone(void);	inline void bone(const std::string& value);
	inline std::string constraint(void);	inline void constraint(const std::string& value);
	inline float value(void);
	inline void value(float value);

};

/**************** Actuator Sensor ****************/

class ActuatorSensor : public Sensor {
public:
	ActuatorSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	inline std::string actuator(void);	inline void actuator(const std::string& value);

};

/**************** Delay Sensor ****************/

class DelaySensor : public Sensor {
public:
	DelaySensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	inline int delay(void);
	inline void delay(int value);
	inline int duration(void);
	inline void duration(int value);
	inline bool use_repeat(void);
	inline void use_repeat(int value);

};

/**************** Collision Sensor ****************/

class CollisionSensor : public Sensor {
public:
	CollisionSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	inline bool use_pulse(void);
	inline void use_pulse(int value);
	inline bool use_material(void);
	inline void use_material(int value);
	inline std::string property(void);	inline void property(const std::string& value);
	inline std::string material(void);	inline void material(const std::string& value);

};

/**************** Radar Sensor ****************/

class RadarSensor : public Sensor {
public:
	RadarSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	inline std::string property(void);	inline void property(const std::string& value);
	enum axis_enum {
		axis_XAXIS = 0,
		axis_YAXIS = 1,
		axis_ZAXIS = 2,
		axis_NEGXAXIS = 3,
		axis_NEGYAXIS = 4,
		axis_NEGZAXIS = 5,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	inline float angle(void);
	inline void angle(float value);
	inline float distance(void);
	inline void distance(float value);

};

/**************** Random Sensor ****************/

class RandomSensor : public Sensor {
public:
	RandomSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	inline int seed(void);
	inline void seed(int value);

};

/**************** Ray Sensor ****************/

class RaySensor : public Sensor {
public:
	RaySensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	enum ray_type_enum {
		ray_type_PROPERTY = 0,
		ray_type_MATERIAL = 1,
	};
	inline ray_type_enum ray_type(void);
	inline void ray_type(ray_type_enum value);
	inline std::string property(void);	inline void property(const std::string& value);
	inline std::string material(void);	inline void material(const std::string& value);
	inline bool use_x_ray(void);
	inline void use_x_ray(int value);
	inline float range(void);
	inline void range(float value);
	enum axis_enum {
		axis_XAXIS = 1,
		axis_YAXIS = 0,
		axis_ZAXIS = 2,
		axis_NEGXAXIS = 3,
		axis_NEGYAXIS = 4,
		axis_NEGZAXIS = 5,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);

};

/**************** Message Sensor ****************/

class MessageSensor : public Sensor {
public:
	MessageSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	inline std::string subject(void);	inline void subject(const std::string& value);

};

/**************** Joystick Sensor ****************/

class JoystickSensor : public Sensor {
public:
	JoystickSensor(const PointerRNA &ptr_arg) :
		Sensor(ptr_arg)
		{}

	inline int joystick_index(void);
	inline void joystick_index(int value);
	enum event_type_enum {
		event_type_BUTTON = 0,
		event_type_AXIS = 1,
		event_type_HAT = 2,
		event_type_AXIS_SINGLE = 3,
	};
	inline event_type_enum event_type(void);
	inline void event_type(event_type_enum value);
	inline bool use_all_events(void);
	inline void use_all_events(int value);
	inline int button_number(void);
	inline void button_number(int value);
	inline int axis_number(void);
	inline void axis_number(int value);
	inline int axis_threshold(void);
	inline void axis_threshold(int value);
	enum axis_direction_enum {
		axis_direction_RIGHTAXIS = 0,
		axis_direction_UPAXIS = 1,
		axis_direction_LEFTAXIS = 2,
		axis_direction_DOWNAXIS = 3,
	};
	inline axis_direction_enum axis_direction(void);
	inline void axis_direction(axis_direction_enum value);
	inline int single_axis_number(void);
	inline void single_axis_number(int value);
	inline int hat_number(void);
	inline void hat_number(int value);
	enum hat_direction_enum {
		hat_direction_UP = 1,
		hat_direction_DOWN = 4,
		hat_direction_LEFT = 8,
		hat_direction_RIGHT = 2,
		hat_direction_UPRIGHT = 3,
		hat_direction_DOWNLEFT = 12,
		hat_direction_UPLEFT = 9,
		hat_direction_DOWNRIGHT = 6,
	};
	inline hat_direction_enum hat_direction(void);
	inline void hat_direction(hat_direction_enum value);

};

/**************** Sequence Color Balance Data ****************/

class SequenceColorBalanceData : public Pointer {
public:
	SequenceColorBalanceData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> lift(void);
	inline void lift(float values[3]);
	inline Array<float, 3> gamma(void);
	inline void gamma(float values[3]);
	inline Array<float, 3> gain(void);
	inline void gain(float values[3]);
	inline bool invert_gain(void);
	inline void invert_gain(int value);
	inline bool invert_gamma(void);
	inline void invert_gamma(int value);
	inline bool invert_lift(void);
	inline void invert_lift(int value);

};

/**************** Sequence Element ****************/

class SequenceElement : public Pointer {
public:
	SequenceElement(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string filename(void);	inline void filename(const std::string& value);
	inline int orig_width(void);
	inline void orig_width(int value);
	inline int orig_height(void);
	inline void orig_height(int value);

};

/**************** Sequence Proxy ****************/

class SequenceProxy : public Pointer {
public:
	SequenceProxy(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string directory(void);	inline void directory(const std::string& value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline bool build_25(void);
	inline void build_25(int value);
	inline bool build_50(void);
	inline void build_50(int value);
	inline bool build_75(void);
	inline void build_75(int value);
	inline bool build_100(void);
	inline void build_100(int value);
	inline bool build_record_run(void);
	inline void build_record_run(int value);
	inline bool build_free_run(void);
	inline void build_free_run(int value);
	inline bool build_free_run_rec_date(void);
	inline void build_free_run_rec_date(int value);
	inline int quality(void);
	inline void quality(int value);
	enum timecode_enum {
		timecode_NONE = 0,
		timecode_RECORD_RUN = 1,
		timecode_FREE_RUN = 2,
		timecode_FREE_RUN_REC_DATE = 4,
		timecode_RECORD_RUN_NO_GAPS = 8,
	};
	inline timecode_enum timecode(void);
	inline void timecode(timecode_enum value);

};

/**************** Sequence Color Balance ****************/

class SequenceColorBalance : public SequenceColorBalanceData {
public:
	SequenceColorBalance(const PointerRNA &ptr_arg) :
		SequenceColorBalanceData(ptr_arg)
		{}


};

/**************** Sequence Crop ****************/

class SequenceCrop : public Pointer {
public:
	SequenceCrop(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int max_y(void);
	inline void max_y(int value);
	inline int min_y(void);
	inline void min_y(int value);
	inline int min_x(void);
	inline void min_x(int value);
	inline int max_x(void);
	inline void max_x(int value);

};

/**************** Sequence Transform ****************/

class SequenceTransform : public Pointer {
public:
	SequenceTransform(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int offset_x(void);
	inline void offset_x(int value);
	inline int offset_y(void);
	inline void offset_y(int value);

};

/**************** Sequence ****************/

class Sequence : public Pointer {
public:
	Sequence(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		modifiers(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_IMAGE = 0,
		type_META = 1,
		type_SCENE = 2,
		type_MOVIE = 3,
		type_MOVIECLIP = 6,
		type_MASK = 7,
		type_SOUND = 4,
		type_CROSS = 8,
		type_ADD = 9,
		type_SUBTRACT = 10,
		type_ALPHA_OVER = 11,
		type_ALPHA_UNDER = 12,
		type_GAMMA_CROSS = 13,
		type_MULTIPLY = 14,
		type_OVER_DROP = 15,
		type_WIPE = 25,
		type_GLOW = 26,
		type_TRANSFORM = 27,
		type_COLOR = 28,
		type_SPEED = 29,
		type_MULTICAM = 30,
		type_ADJUSTMENT = 31,
		type_GAUSSIAN_BLUR = 40,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool select(void);
	inline void select(int value);
	inline bool select_left_handle(void);
	inline void select_left_handle(int value);
	inline bool select_right_handle(void);
	inline void select_right_handle(int value);
	inline bool mute(void);
	inline void mute(int value);
	inline bool lock(void);
	inline void lock(int value);
	inline int frame_final_duration(void);
	inline void frame_final_duration(int value);
	inline int frame_duration(void);
	inline void frame_duration(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_final_start(void);
	inline void frame_final_start(int value);
	inline int frame_final_end(void);
	inline void frame_final_end(int value);
	inline int frame_offset_start(void);
	inline void frame_offset_start(int value);
	inline int frame_offset_end(void);
	inline void frame_offset_end(int value);
	inline int frame_still_start(void);
	inline void frame_still_start(int value);
	inline int frame_still_end(void);
	inline void frame_still_end(int value);
	inline int channel(void);
	inline void channel(int value);
	inline bool use_linear_modifiers(void);
	inline void use_linear_modifiers(int value);
	enum blend_type_enum {
		blend_type_REPLACE = 0,
		blend_type_CROSS = 8,
		blend_type_ADD = 9,
		blend_type_SUBTRACT = 10,
		blend_type_ALPHA_OVER = 11,
		blend_type_ALPHA_UNDER = 12,
		blend_type_GAMMA_CROSS = 13,
		blend_type_MULTIPLY = 14,
		blend_type_OVER_DROP = 15,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline float blend_alpha(void);
	inline void blend_alpha(float value);
	inline float effect_fader(void);
	inline void effect_fader(float value);
	inline bool use_default_fade(void);
	inline void use_default_fade(int value);
	inline float speed_factor(void);
	inline void speed_factor(float value);
	COLLECTION_PROPERTY(SequenceModifiers, SequenceModifier, Sequence, modifiers, false, true, true)

	inline void update(int data);
	inline SequenceElement strip_elem_from_frame(int frame);
	inline void swap(Sequence other);
};

/**************** Sequence Editor ****************/

class SequenceEditor : public Pointer {
public:
	SequenceEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		sequences(ptr_arg),
		sequences_all(ptr_arg),
		meta_stack(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(Sequences, Sequence, SequenceEditor, sequences, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Sequence, SequenceEditor, sequences_all, false, false, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Sequence, SequenceEditor, meta_stack, false, true, true)
	inline Sequence active_strip(void);
	inline bool show_overlay(void);
	inline void show_overlay(int value);
	inline bool use_overlay_lock(void);
	inline void use_overlay_lock(int value);
	inline int overlay_frame(void);
	inline void overlay_frame(int value);

};

/**************** Image Sequence ****************/

class ImageSequence : public Sequence {
public:
	ImageSequence(const PointerRNA &ptr_arg) :
		Sequence(ptr_arg),
		elements(ptr_arg)
		{}

	inline std::string directory(void);	inline void directory(const std::string& value);
	COLLECTION_PROPERTY(SequenceElements, SequenceElement, ImageSequence, elements, true, true, false)
	inline bool use_deinterlace(void);
	inline void use_deinterlace(int value);
	enum alpha_mode_enum {
		alpha_mode_STRAIGHT = 0,
		alpha_mode_PREMUL = 1,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);
	inline bool use_flip_x(void);
	inline void use_flip_x(int value);
	inline bool use_flip_y(void);
	inline void use_flip_y(int value);
	inline bool use_float(void);
	inline void use_float(int value);
	inline bool use_reverse_frames(void);
	inline void use_reverse_frames(int value);
	inline float color_multiply(void);
	inline void color_multiply(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float strobe(void);
	inline void strobe(float value);
	inline bool use_translation(void);
	inline void use_translation(int value);
	inline SequenceTransform transform(void);
	inline bool use_crop(void);
	inline void use_crop(int value);
	inline SequenceCrop crop(void);
	inline bool use_proxy(void);
	inline void use_proxy(int value);
	inline SequenceProxy proxy(void);
	inline bool use_proxy_custom_directory(void);
	inline void use_proxy_custom_directory(int value);
	inline bool use_proxy_custom_file(void);
	inline void use_proxy_custom_file(int value);
	inline int animation_offset_start(void);
	inline void animation_offset_start(int value);
	inline int animation_offset_end(void);
	inline void animation_offset_end(int value);
	inline ColorManagedInputColorspaceSettings colorspace_settings(void);

};

/**************** Meta Sequence ****************/

class MetaSequence : public Sequence {
public:
	MetaSequence(const PointerRNA &ptr_arg) :
		Sequence(ptr_arg),
		sequences(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, Sequence, MetaSequence, sequences, false, true, true)
	inline bool use_deinterlace(void);
	inline void use_deinterlace(int value);
	enum alpha_mode_enum {
		alpha_mode_STRAIGHT = 0,
		alpha_mode_PREMUL = 1,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);
	inline bool use_flip_x(void);
	inline void use_flip_x(int value);
	inline bool use_flip_y(void);
	inline void use_flip_y(int value);
	inline bool use_float(void);
	inline void use_float(int value);
	inline bool use_reverse_frames(void);
	inline void use_reverse_frames(int value);
	inline float color_multiply(void);
	inline void color_multiply(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float strobe(void);
	inline void strobe(float value);
	inline bool use_translation(void);
	inline void use_translation(int value);
	inline SequenceTransform transform(void);
	inline bool use_crop(void);
	inline void use_crop(int value);
	inline SequenceCrop crop(void);
	inline bool use_proxy(void);
	inline void use_proxy(int value);
	inline SequenceProxy proxy(void);
	inline bool use_proxy_custom_directory(void);
	inline void use_proxy_custom_directory(int value);
	inline bool use_proxy_custom_file(void);
	inline void use_proxy_custom_file(int value);
	inline int animation_offset_start(void);
	inline void animation_offset_start(int value);
	inline int animation_offset_end(void);
	inline void animation_offset_end(int value);

};

/**************** Scene Sequence ****************/

class SceneSequence : public Sequence {
public:
	SceneSequence(const PointerRNA &ptr_arg) :
		Sequence(ptr_arg)
		{}

	inline Scene scene(void);
	inline Object scene_camera(void);
	inline bool use_deinterlace(void);
	inline void use_deinterlace(int value);
	enum alpha_mode_enum {
		alpha_mode_STRAIGHT = 0,
		alpha_mode_PREMUL = 1,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);
	inline bool use_flip_x(void);
	inline void use_flip_x(int value);
	inline bool use_flip_y(void);
	inline void use_flip_y(int value);
	inline bool use_float(void);
	inline void use_float(int value);
	inline bool use_reverse_frames(void);
	inline void use_reverse_frames(int value);
	inline float color_multiply(void);
	inline void color_multiply(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float strobe(void);
	inline void strobe(float value);
	inline bool use_translation(void);
	inline void use_translation(int value);
	inline SequenceTransform transform(void);
	inline bool use_crop(void);
	inline void use_crop(int value);
	inline SequenceCrop crop(void);
	inline bool use_proxy(void);
	inline void use_proxy(int value);
	inline SequenceProxy proxy(void);
	inline bool use_proxy_custom_directory(void);
	inline void use_proxy_custom_directory(int value);
	inline bool use_proxy_custom_file(void);
	inline void use_proxy_custom_file(int value);
	inline int animation_offset_start(void);
	inline void animation_offset_start(int value);
	inline int animation_offset_end(void);
	inline void animation_offset_end(int value);

};

/**************** Movie Sequence ****************/

class MovieSequence : public Sequence {
public:
	MovieSequence(const PointerRNA &ptr_arg) :
		Sequence(ptr_arg),
		elements(ptr_arg)
		{}

	inline int mpeg_preseek(void);
	inline void mpeg_preseek(int value);
	inline int stream_index(void);
	inline void stream_index(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, SequenceElement, MovieSequence, elements, true, true, false)
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline bool use_deinterlace(void);
	inline void use_deinterlace(int value);
	enum alpha_mode_enum {
		alpha_mode_STRAIGHT = 0,
		alpha_mode_PREMUL = 1,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);
	inline bool use_flip_x(void);
	inline void use_flip_x(int value);
	inline bool use_flip_y(void);
	inline void use_flip_y(int value);
	inline bool use_float(void);
	inline void use_float(int value);
	inline bool use_reverse_frames(void);
	inline void use_reverse_frames(int value);
	inline float color_multiply(void);
	inline void color_multiply(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float strobe(void);
	inline void strobe(float value);
	inline bool use_translation(void);
	inline void use_translation(int value);
	inline SequenceTransform transform(void);
	inline bool use_crop(void);
	inline void use_crop(int value);
	inline SequenceCrop crop(void);
	inline bool use_proxy(void);
	inline void use_proxy(int value);
	inline SequenceProxy proxy(void);
	inline bool use_proxy_custom_directory(void);
	inline void use_proxy_custom_directory(int value);
	inline bool use_proxy_custom_file(void);
	inline void use_proxy_custom_file(int value);
	inline int animation_offset_start(void);
	inline void animation_offset_start(int value);
	inline int animation_offset_end(void);
	inline void animation_offset_end(int value);
	inline ColorManagedInputColorspaceSettings colorspace_settings(void);

};

/**************** MovieClip Sequence ****************/

class MovieClipSequence : public Sequence {
public:
	MovieClipSequence(const PointerRNA &ptr_arg) :
		Sequence(ptr_arg)
		{}

	inline bool undistort(void);
	inline void undistort(int value);
	inline bool stabilize2d(void);
	inline void stabilize2d(int value);
	inline bool use_deinterlace(void);
	inline void use_deinterlace(int value);
	enum alpha_mode_enum {
		alpha_mode_STRAIGHT = 0,
		alpha_mode_PREMUL = 1,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);
	inline bool use_flip_x(void);
	inline void use_flip_x(int value);
	inline bool use_flip_y(void);
	inline void use_flip_y(int value);
	inline bool use_float(void);
	inline void use_float(int value);
	inline bool use_reverse_frames(void);
	inline void use_reverse_frames(int value);
	inline float color_multiply(void);
	inline void color_multiply(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float strobe(void);
	inline void strobe(float value);
	inline bool use_translation(void);
	inline void use_translation(int value);
	inline SequenceTransform transform(void);
	inline bool use_crop(void);
	inline void use_crop(int value);
	inline SequenceCrop crop(void);
	inline int animation_offset_start(void);
	inline void animation_offset_start(int value);
	inline int animation_offset_end(void);
	inline void animation_offset_end(int value);

};

/**************** Mask Sequence ****************/

class MaskSequence : public Sequence {
public:
	MaskSequence(const PointerRNA &ptr_arg) :
		Sequence(ptr_arg)
		{}

	inline Mask mask(void);
	inline bool use_deinterlace(void);
	inline void use_deinterlace(int value);
	enum alpha_mode_enum {
		alpha_mode_STRAIGHT = 0,
		alpha_mode_PREMUL = 1,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);
	inline bool use_flip_x(void);
	inline void use_flip_x(int value);
	inline bool use_flip_y(void);
	inline void use_flip_y(int value);
	inline bool use_float(void);
	inline void use_float(int value);
	inline bool use_reverse_frames(void);
	inline void use_reverse_frames(int value);
	inline float color_multiply(void);
	inline void color_multiply(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float strobe(void);
	inline void strobe(float value);
	inline bool use_translation(void);
	inline void use_translation(int value);
	inline SequenceTransform transform(void);
	inline bool use_crop(void);
	inline void use_crop(int value);
	inline SequenceCrop crop(void);
	inline int animation_offset_start(void);
	inline void animation_offset_start(int value);
	inline int animation_offset_end(void);
	inline void animation_offset_end(int value);

};

/**************** Sound Sequence ****************/

class SoundSequence : public Sequence {
public:
	SoundSequence(const PointerRNA &ptr_arg) :
		Sequence(ptr_arg)
		{}

	inline Sound sound(void);
	inline float volume(void);
	inline void volume(float value);
	inline float pitch(void);
	inline void pitch(float value);
	inline float pan(void);
	inline void pan(float value);
	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline bool show_waveform(void);
	inline void show_waveform(int value);
	inline int animation_offset_start(void);
	inline void animation_offset_start(int value);
	inline int animation_offset_end(void);
	inline void animation_offset_end(int value);

};

/**************** Effect Sequence ****************/

class EffectSequence : public Sequence {
public:
	EffectSequence(const PointerRNA &ptr_arg) :
		Sequence(ptr_arg)
		{}

	inline bool use_deinterlace(void);
	inline void use_deinterlace(int value);
	enum alpha_mode_enum {
		alpha_mode_STRAIGHT = 0,
		alpha_mode_PREMUL = 1,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);
	inline bool use_flip_x(void);
	inline void use_flip_x(int value);
	inline bool use_flip_y(void);
	inline void use_flip_y(int value);
	inline bool use_float(void);
	inline void use_float(int value);
	inline bool use_reverse_frames(void);
	inline void use_reverse_frames(int value);
	inline float color_multiply(void);
	inline void color_multiply(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float strobe(void);
	inline void strobe(float value);
	inline bool use_translation(void);
	inline void use_translation(int value);
	inline SequenceTransform transform(void);
	inline bool use_crop(void);
	inline void use_crop(int value);
	inline SequenceCrop crop(void);
	inline bool use_proxy(void);
	inline void use_proxy(int value);
	inline SequenceProxy proxy(void);
	inline bool use_proxy_custom_directory(void);
	inline void use_proxy_custom_directory(int value);
	inline bool use_proxy_custom_file(void);
	inline void use_proxy_custom_file(int value);

};

/**************** Add Sequence ****************/

class AddSequence : public EffectSequence {
public:
	AddSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline Sequence input_2(void);

};

/**************** Adjustment Layer Sequence ****************/

class AdjustmentSequence : public EffectSequence {
public:
	AdjustmentSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline int animation_offset_start(void);
	inline void animation_offset_start(int value);
	inline int animation_offset_end(void);
	inline void animation_offset_end(int value);

};

/**************** Alpha Over Sequence ****************/

class AlphaOverSequence : public EffectSequence {
public:
	AlphaOverSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline Sequence input_2(void);

};

/**************** Alpha Under Sequence ****************/

class AlphaUnderSequence : public EffectSequence {
public:
	AlphaUnderSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline Sequence input_2(void);

};

/**************** Color Sequence ****************/

class ColorSequence : public EffectSequence {
public:
	ColorSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);

};

/**************** Cross Sequence ****************/

class CrossSequence : public EffectSequence {
public:
	CrossSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline Sequence input_2(void);

};

/**************** Gamma Cross Sequence ****************/

class GammaCrossSequence : public EffectSequence {
public:
	GammaCrossSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline Sequence input_2(void);

};

/**************** Glow Sequence ****************/

class GlowSequence : public EffectSequence {
public:
	GlowSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline float threshold(void);
	inline void threshold(float value);
	inline float clamp(void);
	inline void clamp(float value);
	inline float boost_factor(void);
	inline void boost_factor(float value);
	inline float blur_radius(void);
	inline void blur_radius(float value);
	inline int quality(void);
	inline void quality(int value);
	inline bool use_only_boost(void);
	inline void use_only_boost(int value);

};

/**************** Multicam Select Sequence ****************/

class MulticamSequence : public EffectSequence {
public:
	MulticamSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline int multicam_source(void);
	inline void multicam_source(int value);
	inline int animation_offset_start(void);
	inline void animation_offset_start(int value);
	inline int animation_offset_end(void);
	inline void animation_offset_end(int value);

};

/**************** Multiply Sequence ****************/

class MultiplySequence : public EffectSequence {
public:
	MultiplySequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline Sequence input_2(void);

};

/**************** Over Drop Sequence ****************/

class OverDropSequence : public EffectSequence {
public:
	OverDropSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline Sequence input_2(void);

};

/**************** SpeedControl Sequence ****************/

class SpeedControlSequence : public EffectSequence {
public:
	SpeedControlSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline float multiply_speed(void);
	inline void multiply_speed(float value);
	inline bool use_as_speed(void);
	inline void use_as_speed(int value);
	inline bool scale_to_length(void);
	inline void scale_to_length(int value);

};

/**************** Subtract Sequence ****************/

class SubtractSequence : public EffectSequence {
public:
	SubtractSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline Sequence input_2(void);

};

/**************** Transform Sequence ****************/

class TransformSequence : public EffectSequence {
public:
	TransformSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline float scale_start_x(void);
	inline void scale_start_x(float value);
	inline float scale_start_y(void);
	inline void scale_start_y(float value);
	inline bool use_uniform_scale(void);
	inline void use_uniform_scale(int value);
	inline float translate_start_x(void);
	inline void translate_start_x(float value);
	inline float translate_start_y(void);
	inline void translate_start_y(float value);
	inline float rotation_start(void);
	inline void rotation_start(float value);
	enum translation_unit_enum {
		translation_unit_PIXELS = 0,
		translation_unit_PERCENT = 1,
	};
	inline translation_unit_enum translation_unit(void);
	inline void translation_unit(translation_unit_enum value);
	enum interpolation_enum {
		interpolation_NONE = 0,
		interpolation_BILINEAR = 1,
		interpolation_BICUBIC = 2,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);

};

/**************** Wipe Sequence ****************/

class WipeSequence : public EffectSequence {
public:
	WipeSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline float blur_width(void);
	inline void blur_width(float value);
	inline float angle(void);
	inline void angle(float value);
	enum direction_enum {
		direction_OUT = 0,
		direction_IN = 1,
	};
	inline direction_enum direction(void);
	inline void direction(direction_enum value);
	enum transition_type_enum {
		transition_type_SINGLE = 0,
		transition_type_DOUBLE = 1,
		transition_type_IRIS = 4,
		transition_type_CLOCK = 5,
	};
	inline transition_type_enum transition_type(void);
	inline void transition_type(transition_type_enum value);

};

/**************** Gaussian Blur Sequence ****************/

class GaussianBlurSequence : public EffectSequence {
public:
	GaussianBlurSequence(const PointerRNA &ptr_arg) :
		EffectSequence(ptr_arg)
		{}

	inline int input_count(void);
	inline void input_count(int value);
	inline Sequence input_1(void);
	inline float size_x(void);
	inline void size_x(float value);
	inline float size_y(void);
	inline void size_y(float value);

};

/**************** SequenceModifier ****************/

class SequenceModifier : public Pointer {
public:
	SequenceModifier(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum type_enum {
		type_COLOR_BALANCE = 1,
		type_CURVES = 2,
		type_HUE_CORRECT = 3,
		type_BRIGHT_CONTRAST = 4,
		type_MASK = 5,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool mute(void);
	inline void mute(int value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	enum input_mask_type_enum {
		input_mask_type_STRIP = 0,
		input_mask_type_ID = 1,
	};
	inline input_mask_type_enum input_mask_type(void);
	inline void input_mask_type(input_mask_type_enum value);
	inline Sequence input_mask_strip(void);
	inline Mask input_mask_id(void);

};

/**************** ColorBalanceModifier ****************/

class ColorBalanceModifier : public SequenceModifier {
public:
	ColorBalanceModifier(const PointerRNA &ptr_arg) :
		SequenceModifier(ptr_arg)
		{}

	inline SequenceColorBalanceData color_balance(void);
	inline float color_multiply(void);
	inline void color_multiply(float value);

};

/**************** CurvesModifier ****************/

class CurvesModifier : public SequenceModifier {
public:
	CurvesModifier(const PointerRNA &ptr_arg) :
		SequenceModifier(ptr_arg)
		{}

	inline CurveMapping curve_mapping(void);

};

/**************** HueCorrectModifier ****************/

class HueCorrectModifier : public SequenceModifier {
public:
	HueCorrectModifier(const PointerRNA &ptr_arg) :
		SequenceModifier(ptr_arg)
		{}

	inline CurveMapping curve_mapping(void);

};

/**************** BrightContrastModifier ****************/

class BrightContrastModifier : public SequenceModifier {
public:
	BrightContrastModifier(const PointerRNA &ptr_arg) :
		SequenceModifier(ptr_arg)
		{}

	inline float bright(void);
	inline void bright(float value);
	inline float contrast(void);
	inline void contrast(float value);

};

/**************** Domain Settings ****************/

class SmokeDomainSettings : public Pointer {
public:
	SmokeDomainSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int resolution_max(void);
	inline void resolution_max(int value);
	inline int amplify(void);
	inline void amplify(int value);
	inline bool use_high_resolution(void);
	inline void use_high_resolution(int value);
	inline bool show_high_resolution(void);
	inline void show_high_resolution(int value);
	enum noise_type_enum {
		noise_type_NOISEWAVE = 1,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	inline float alpha(void);
	inline void alpha(float value);
	inline float beta(void);
	inline void beta(float value);
	inline Group collision_group(void);
	inline Group fluid_group(void);
	inline Group effector_group(void);
	inline float strength(void);
	inline void strength(float value);
	inline int dissolve_speed(void);
	inline void dissolve_speed(int value);
	inline bool use_dissolve_smoke(void);
	inline void use_dissolve_smoke(int value);
	inline bool use_dissolve_smoke_log(void);
	inline void use_dissolve_smoke_log(int value);
	inline PointCache point_cache(void);
	enum point_cache_compress_type_enum {
		point_cache_compress_type_CACHELIGHT = 0,
		point_cache_compress_type_CACHEHEAVY = 1,
	};
	inline point_cache_compress_type_enum point_cache_compress_type(void);
	inline void point_cache_compress_type(point_cache_compress_type_enum value);
	enum collision_extents_enum {
		collision_extents_BORDEROPEN = 0,
		collision_extents_BORDERVERTICAL = 1,
		collision_extents_BORDERCLOSED = 2,
	};
	inline collision_extents_enum collision_extents(void);
	inline void collision_extents(collision_extents_enum value);
	inline EffectorWeights effector_weights(void);
	enum highres_sampling_enum {
		highres_sampling_FULLSAMPLE = 2,
		highres_sampling_LINEAR = 1,
		highres_sampling_NEAREST = 0,
	};
	inline highres_sampling_enum highres_sampling(void);
	inline void highres_sampling(highres_sampling_enum value);
	inline float time_scale(void);
	inline void time_scale(float value);
	inline float vorticity(void);
	inline void vorticity(float value);
	inline Array<float, 32> density_grid(void);
	inline void density_grid(float values[32]);
	inline Array<float, 32> flame_grid(void);
	inline void flame_grid(float values[32]);
	inline Array<float, 32> color_grid(void);
	inline void color_grid(float values[32]);
	inline Array<float, 3> cell_size(void);
	inline void cell_size(float values[3]);
	inline Array<float, 3> start_point(void);
	inline void start_point(float values[3]);
	inline Array<int, 3> domain_resolution(void);
	inline void domain_resolution(int values[3]);
	inline float burning_rate(void);
	inline void burning_rate(float value);
	inline float flame_smoke(void);
	inline void flame_smoke(float value);
	inline float flame_vorticity(void);
	inline void flame_vorticity(float value);
	inline float flame_ignition(void);
	inline void flame_ignition(float value);
	inline float flame_max_temp(void);
	inline void flame_max_temp(float value);
	inline Array<float, 3> flame_smoke_color(void);
	inline void flame_smoke_color(float values[3]);
	inline bool use_adaptive_domain(void);
	inline void use_adaptive_domain(int value);
	inline int additional_res(void);
	inline void additional_res(int value);
	inline int adapt_margin(void);
	inline void adapt_margin(int value);
	inline float adapt_threshold(void);
	inline void adapt_threshold(float value);

};

/**************** Flow Settings ****************/

class SmokeFlowSettings : public Pointer {
public:
	SmokeFlowSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float density(void);
	inline void density(float value);
	inline Array<float, 3> smoke_color(void);
	inline void smoke_color(float values[3]);
	inline float fuel_amount(void);
	inline void fuel_amount(float value);
	inline float temperature(void);
	inline void temperature(float value);
	inline ParticleSystem particle_system(void);
	enum smoke_flow_type_enum {
		smoke_flow_type_OUTFLOW = 2,
		smoke_flow_type_SMOKE = 0,
		smoke_flow_type_BOTH = 3,
		smoke_flow_type_FIRE = 1,
	};
	inline smoke_flow_type_enum smoke_flow_type(void);
	inline void smoke_flow_type(smoke_flow_type_enum value);
	enum smoke_flow_source_enum {
		smoke_flow_source_PARTICLES = 0,
		smoke_flow_source_MESH = 1,
	};
	inline smoke_flow_source_enum smoke_flow_source(void);
	inline void smoke_flow_source(smoke_flow_source_enum value);
	inline bool use_absolute(void);
	inline void use_absolute(int value);
	inline bool use_initial_velocity(void);
	inline void use_initial_velocity(int value);
	inline float velocity_factor(void);
	inline void velocity_factor(float value);
	inline float velocity_normal(void);
	inline void velocity_normal(float value);
	inline float velocity_random(void);
	inline void velocity_random(float value);
	inline float volume_density(void);
	inline void volume_density(float value);
	inline float surface_distance(void);
	inline void surface_distance(float value);
	inline float particle_size(void);
	inline void particle_size(float value);
	inline bool use_particle_size(void);
	inline void use_particle_size(int value);
	inline int subframes(void);
	inline void subframes(int value);
	inline std::string density_vertex_group(void);	inline void density_vertex_group(const std::string& value);
	inline bool use_texture(void);
	inline void use_texture(int value);
	enum texture_map_type_enum {
		texture_map_type_AUTO = 0,
		texture_map_type_UV = 1,
	};
	inline texture_map_type_enum texture_map_type(void);
	inline void texture_map_type(texture_map_type_enum value);
	inline std::string uv_layer(void);	inline void uv_layer(const std::string& value);
	inline Texture noise_texture(void);
	inline float texture_size(void);
	inline void texture_size(float value);
	inline float texture_offset(void);
	inline void texture_offset(float value);

};

/**************** Collision Settings ****************/

class SmokeCollSettings : public Pointer {
public:
	SmokeCollSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum collision_type_enum {
		collision_type_COLLSTATIC = 0,
		collision_type_COLLRIGID = 1,
		collision_type_COLLANIMATED = 2,
	};
	inline collision_type_enum collision_type(void);
	inline void collision_type(collision_type_enum value);

};

/**************** Space ****************/

class Space : public Pointer {
public:
	Space(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_EMPTY = 0,
		type_VIEW_3D = 1,
		type_TIMELINE = 15,
		type_GRAPH_EDITOR = 2,
		type_DOPESHEET_EDITOR = 12,
		type_NLA_EDITOR = 13,
		type_IMAGE_EDITOR = 6,
		type_SEQUENCE_EDITOR = 8,
		type_CLIP_EDITOR = 20,
		type_TEXT_EDITOR = 9,
		type_NODE_EDITOR = 16,
		type_LOGIC_EDITOR = 17,
		type_PROPERTIES = 4,
		type_OUTLINER = 3,
		type_USER_PREFERENCES = 19,
		type_INFO = 7,
		type_FILE_BROWSER = 5,
		type_CONSOLE = 18,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool show_locked_time(void);
	inline void show_locked_time(int value);

};

/**************** Space Image Editor ****************/

class SpaceImageEditor : public Space {
public:
	SpaceImageEditor(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	inline Image image(void);
	inline ImageUser image_user(void);
	inline Scopes scopes(void);
	inline bool use_image_pin(void);
	inline void use_image_pin(int value);
	inline Histogram sample_histogram(void);
	inline Array<float, 2> zoom(void);
	inline void zoom(float values[2]);
	inline bool show_repeat(void);
	inline void show_repeat(int value);
	inline bool show_grease_pencil(void);
	inline void show_grease_pencil(int value);
	enum draw_channels_enum {
		draw_channels_COLOR_ALPHA = 4096,
		draw_channels_COLOR = 0,
		draw_channels_ALPHA = 8192,
		draw_channels_Z_BUFFER = 16384,
	};
	inline draw_channels_enum draw_channels(void);
	inline void draw_channels(draw_channels_enum value);
	inline SpaceUVEditor uv_editor(void);
	enum mode_enum {
		mode_VIEW = 0,
		mode_PAINT = 1,
		mode_MASK = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Array<float, 2> cursor_location(void);
	inline void cursor_location(float values[2]);
	enum pivot_point_enum {
		pivot_point_BOUNDING_BOX_CENTER = 0,
		pivot_point_CURSOR = 1,
		pivot_point_INDIVIDUAL_ORIGINS = 2,
		pivot_point_MEDIAN_POINT = 3,
		pivot_point_ACTIVE_ELEMENT = 4,
	};
	inline pivot_point_enum pivot_point(void);
	inline void pivot_point(pivot_point_enum value);
	inline GreasePencil grease_pencil(void);
	inline bool use_realtime_update(void);
	inline void use_realtime_update(int value);
	inline bool show_render(void);
	inline void show_render(int value);
	inline bool show_paint(void);
	inline void show_paint(int value);
	inline bool show_uvedit(void);
	inline void show_uvedit(int value);
	inline bool show_maskedit(void);
	inline void show_maskedit(int value);
	inline Mask mask(void);
	enum mask_draw_type_enum {
		mask_draw_type_OUTLINE = 0,
		mask_draw_type_DASH = 1,
		mask_draw_type_BLACK = 2,
		mask_draw_type_WHITE = 3,
	};
	inline mask_draw_type_enum mask_draw_type(void);
	inline void mask_draw_type(mask_draw_type_enum value);
	inline bool show_mask_smooth(void);
	inline void show_mask_smooth(int value);
	inline bool show_mask_overlay(void);
	inline void show_mask_overlay(int value);
	enum mask_overlay_mode_enum {
		mask_overlay_mode_ALPHACHANNEL = 0,
		mask_overlay_mode_COMBINED = 1,
	};
	inline mask_overlay_mode_enum mask_overlay_mode(void);
	inline void mask_overlay_mode(mask_overlay_mode_enum value);

};

/**************** Space UV Editor ****************/

class SpaceUVEditor : public Pointer {
public:
	SpaceUVEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum sticky_select_mode_enum {
		sticky_select_mode_DISABLED = 1,
		sticky_select_mode_SHARED_LOCATION = 0,
		sticky_select_mode_SHARED_VERTEX = 2,
	};
	inline sticky_select_mode_enum sticky_select_mode(void);
	inline void sticky_select_mode(sticky_select_mode_enum value);
	enum edge_draw_type_enum {
		edge_draw_type_OUTLINE = 0,
		edge_draw_type_DASH = 1,
		edge_draw_type_BLACK = 2,
		edge_draw_type_WHITE = 3,
	};
	inline edge_draw_type_enum edge_draw_type(void);
	inline void edge_draw_type(edge_draw_type_enum value);
	inline bool show_smooth_edges(void);
	inline void show_smooth_edges(int value);
	inline bool show_stretch(void);
	inline void show_stretch(int value);
	enum draw_stretch_type_enum {
		draw_stretch_type_ANGLE = 0,
		draw_stretch_type_AREA = 1,
	};
	inline draw_stretch_type_enum draw_stretch_type(void);
	inline void draw_stretch_type(draw_stretch_type_enum value);
	inline bool show_modified_edges(void);
	inline void show_modified_edges(int value);
	inline bool show_other_objects(void);
	inline void show_other_objects(int value);
	inline bool show_texpaint(void);
	inline void show_texpaint(int value);
	inline bool show_normalized_coords(void);
	inline void show_normalized_coords(int value);
	inline bool show_faces(void);
	inline void show_faces(int value);
	inline bool use_snap_to_pixels(void);
	inline void use_snap_to_pixels(int value);
	inline bool lock_bounds(void);
	inline void lock_bounds(int value);
	inline bool use_live_unwrap(void);
	inline void use_live_unwrap(int value);

};

/**************** Space Sequence Editor ****************/

class SpaceSequenceEditor : public Space {
public:
	SpaceSequenceEditor(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	enum view_type_enum {
		view_type_SEQUENCER = 1,
		view_type_PREVIEW = 2,
		view_type_SEQUENCER_PREVIEW = 3,
	};
	inline view_type_enum view_type(void);
	inline void view_type(view_type_enum value);
	enum display_mode_enum {
		display_mode_IMAGE = 1,
		display_mode_WAVEFORM = 2,
		display_mode_VECTOR_SCOPE = 3,
		display_mode_HISTOGRAM = 4,
	};
	inline display_mode_enum display_mode(void);
	inline void display_mode(display_mode_enum value);
	inline bool show_frame_indicator(void);
	inline void show_frame_indicator(int value);
	inline bool show_frames(void);
	inline void show_frames(int value);
	inline bool use_marker_sync(void);
	inline void use_marker_sync(int value);
	inline bool show_separate_color(void);
	inline void show_separate_color(int value);
	inline bool show_safe_margin(void);
	inline void show_safe_margin(int value);
	inline bool show_seconds(void);
	inline void show_seconds(int value);
	inline bool show_grease_pencil(void);
	inline void show_grease_pencil(int value);
	inline int display_channel(void);
	inline void display_channel(int value);
	enum preview_channels_enum {
		preview_channels_COLOR_ALPHA = 64,
		preview_channels_COLOR = 0,
	};
	inline preview_channels_enum preview_channels(void);
	inline void preview_channels(preview_channels_enum value);
	inline int draw_overexposed(void);
	inline void draw_overexposed(int value);
	enum proxy_render_size_enum {
		proxy_render_size_NONE = -1,
		proxy_render_size_SCENE = 0,
		proxy_render_size_PROXY_25 = 25,
		proxy_render_size_PROXY_50 = 50,
		proxy_render_size_PROXY_75 = 75,
		proxy_render_size_PROXY_100 = 99,
		proxy_render_size_FULL = 100,
	};
	inline proxy_render_size_enum proxy_render_size(void);
	inline void proxy_render_size(proxy_render_size_enum value);
	inline GreasePencil grease_pencil(void);
	enum overlay_type_enum {
		overlay_type_RECTANGLE = 0,
		overlay_type_REFERENCE = 1,
		overlay_type_CURRENT = 2,
	};
	inline overlay_type_enum overlay_type(void);
	inline void overlay_type(overlay_type_enum value);

};

/**************** Space Text Editor ****************/

class SpaceTextEditor : public Space {
public:
	SpaceTextEditor(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	inline Text text(void);
	inline bool show_word_wrap(void);
	inline void show_word_wrap(int value);
	inline bool show_line_numbers(void);
	inline void show_line_numbers(int value);
	inline bool show_syntax_highlight(void);
	inline void show_syntax_highlight(int value);
	inline bool show_line_highlight(void);
	inline void show_line_highlight(int value);
	inline int tab_width(void);
	inline void tab_width(int value);
	inline int font_size(void);
	inline void font_size(int value);
	inline bool show_margin(void);
	inline void show_margin(int value);
	inline int margin_column(void);
	inline void margin_column(int value);
	inline int top(void);
	inline void top(int value);
	inline int visible_lines(void);
	inline void visible_lines(int value);
	inline bool use_overwrite(void);
	inline void use_overwrite(int value);
	inline bool use_live_edit(void);
	inline void use_live_edit(int value);
	inline bool use_find_all(void);
	inline void use_find_all(int value);
	inline bool use_find_wrap(void);
	inline void use_find_wrap(int value);
	inline bool use_match_case(void);
	inline void use_match_case(int value);
	inline std::string find_text(void);	inline void find_text(const std::string& value);
	inline std::string replace_text(void);	inline void replace_text(const std::string& value);

};

/**************** File Select Parameters ****************/

class FileSelectParams : public Pointer {
public:
	FileSelectParams(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string title(void);	inline void title(const std::string& value);
	inline std::string directory(void);	inline void directory(const std::string& value);
	inline std::string filename(void);	inline void filename(const std::string& value);
	enum display_type_enum {
		display_type_FILE_SHORTDISPLAY = 1,
		display_type_FILE_LONGDISPLAY = 2,
		display_type_FILE_IMGDISPLAY = 3,
	};
	inline display_type_enum display_type(void);
	inline void display_type(display_type_enum value);
	inline bool use_filter(void);
	inline void use_filter(int value);
	inline bool show_hidden(void);
	inline void show_hidden(int value);
	enum sort_method_enum {
		sort_method_FILE_SORT_ALPHA = 1,
		sort_method_FILE_SORT_EXTENSION = 2,
		sort_method_FILE_SORT_TIME = 3,
		sort_method_FILE_SORT_SIZE = 4,
	};
	inline sort_method_enum sort_method(void);
	inline void sort_method(sort_method_enum value);
	inline bool use_filter_image(void);
	inline void use_filter_image(int value);
	inline bool use_filter_blender(void);
	inline void use_filter_blender(int value);
	inline bool use_filter_backup(void);
	inline void use_filter_backup(int value);
	inline bool use_filter_movie(void);
	inline void use_filter_movie(int value);
	inline bool use_filter_script(void);
	inline void use_filter_script(int value);
	inline bool use_filter_font(void);
	inline void use_filter_font(int value);
	inline bool use_filter_sound(void);
	inline void use_filter_sound(int value);
	inline bool use_filter_text(void);
	inline void use_filter_text(int value);
	inline bool use_filter_folder(void);
	inline void use_filter_folder(int value);
	inline std::string filter_glob(void);	inline void filter_glob(const std::string& value);

};

/**************** Space File Browser ****************/

class SpaceFileBrowser : public Space {
public:
	SpaceFileBrowser(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	inline FileSelectParams params(void);
	inline Operator active_operator(void);
	inline Operator operator_value(void);

};

/**************** Space Outliner ****************/

class SpaceOutliner : public Space {
public:
	SpaceOutliner(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	enum display_mode_enum {
		display_mode_ALL_SCENES = 0,
		display_mode_CURRENT_SCENE = 1,
		display_mode_VISIBLE_LAYERS = 2,
		display_mode_SELECTED = 3,
		display_mode_ACTIVE = 4,
		display_mode_SAME_TYPES = 5,
		display_mode_GROUPS = 6,
		display_mode_SEQUENCE = 10,
		display_mode_LIBRARIES = 7,
		display_mode_DATABLOCKS = 11,
		display_mode_USER_PREFERENCES = 12,
	};
	inline display_mode_enum display_mode(void);
	inline void display_mode(display_mode_enum value);
	inline std::string filter_text(void);	inline void filter_text(const std::string& value);
	inline bool use_filter_case_sensitive(void);
	inline void use_filter_case_sensitive(int value);
	inline bool use_filter_complete(void);
	inline void use_filter_complete(int value);
	inline bool show_restrict_columns(void);
	inline void show_restrict_columns(int value);

};

/**************** Background Image ****************/

class BackgroundImage : public Pointer {
public:
	BackgroundImage(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum source_enum {
		source_IMAGE = 0,
		source_MOVIE_CLIP = 1,
	};
	inline source_enum source(void);
	inline void source(source_enum value);
	inline Image image(void);
	inline MovieClip clip(void);
	inline ImageUser image_user(void);
	inline MovieClipUser clip_user(void);
	inline float offset_x(void);
	inline void offset_x(float value);
	inline float offset_y(void);
	inline void offset_y(float value);
	inline float size(void);
	inline void size(float value);
	inline float opacity(void);
	inline void opacity(float value);
	enum view_axis_enum {
		view_axis_LEFT = 8,
		view_axis_RIGHT = 16,
		view_axis_BACK = 4,
		view_axis_FRONT = 2,
		view_axis_BOTTOM = 64,
		view_axis_TOP = 32,
		view_axis_ALL = 0,
		view_axis_CAMERA = 256,
	};
	inline view_axis_enum view_axis(void);
	inline void view_axis(view_axis_enum value);
	inline bool show_expanded(void);
	inline void show_expanded(int value);
	inline bool use_camera_clip(void);
	inline void use_camera_clip(int value);
	inline bool show_background_image(void);
	inline void show_background_image(int value);
	inline bool show_on_foreground(void);
	inline void show_on_foreground(int value);
	enum draw_depth_enum {
		draw_depth_BACK = 0,
		draw_depth_FRONT = 16,
	};
	inline draw_depth_enum draw_depth(void);
	inline void draw_depth(draw_depth_enum value);
	enum frame_method_enum {
		frame_method_STRETCH = 0,
		frame_method_FIT = 32,
		frame_method_CROP = 96,
	};
	inline frame_method_enum frame_method(void);
	inline void frame_method(frame_method_enum value);

};

/**************** 3D View Space ****************/

class SpaceView3D : public Space {
public:
	SpaceView3D(const PointerRNA &ptr_arg) :
		Space(ptr_arg),
		background_images(ptr_arg),
		region_quadviews(ptr_arg)
		{}

	inline Object camera(void);
	inline bool use_render_border(void);
	inline void use_render_border(int value);
	inline float render_border_min_x(void);
	inline void render_border_min_x(float value);
	inline float render_border_min_y(void);
	inline void render_border_min_y(float value);
	inline float render_border_max_x(void);
	inline void render_border_max_x(float value);
	inline float render_border_max_y(void);
	inline void render_border_max_y(float value);
	inline Object lock_object(void);
	inline std::string lock_bone(void);	inline void lock_bone(const std::string& value);
	inline bool lock_cursor(void);
	inline void lock_cursor(int value);
	enum viewport_shade_enum {
		viewport_shade_BOUNDBOX = 1,
		viewport_shade_WIREFRAME = 2,
		viewport_shade_SOLID = 3,
		viewport_shade_TEXTURED = 5,
		viewport_shade_MATERIAL = 4,
		viewport_shade_RENDERED = 6,
	};
	inline viewport_shade_enum viewport_shade(void);
	inline void viewport_shade(viewport_shade_enum value);
	inline SpaceView3D local_view(void);
	inline Array<float, 3> cursor_location(void);
	inline void cursor_location(float values[3]);
	inline float lens(void);
	inline void lens(float value);
	inline float clip_start(void);
	inline void clip_start(float value);
	inline float clip_end(void);
	inline void clip_end(float value);
	inline float grid_scale(void);
	inline void grid_scale(float value);
	inline int grid_lines(void);
	inline void grid_lines(int value);
	inline int grid_subdivisions(void);
	inline void grid_subdivisions(int value);
	inline float grid_scale_unit(void);
	inline void grid_scale_unit(float value);
	inline bool show_floor(void);
	inline void show_floor(int value);
	inline bool show_axis_x(void);
	inline void show_axis_x(int value);
	inline bool show_axis_y(void);
	inline void show_axis_y(int value);
	inline bool show_axis_z(void);
	inline void show_axis_z(int value);
	inline bool show_outline_selected(void);
	inline void show_outline_selected(int value);
	inline bool show_all_objects_origin(void);
	inline void show_all_objects_origin(int value);
	inline bool show_relationship_lines(void);
	inline void show_relationship_lines(int value);
	inline bool show_grease_pencil(void);
	inline void show_grease_pencil(int value);
	inline bool show_textured_solid(void);
	inline void show_textured_solid(int value);
	inline bool show_backface_culling(void);
	inline void show_backface_culling(int value);
	inline bool show_textured_shadeless(void);
	inline void show_textured_shadeless(int value);
	inline bool show_occlude_wire(void);
	inline void show_occlude_wire(int value);
	inline bool lock_camera(void);
	inline void lock_camera(int value);
	inline bool show_only_render(void);
	inline void show_only_render(int value);
	inline bool use_occlude_geometry(void);
	inline void use_occlude_geometry(int value);
	COLLECTION_PROPERTY(BackgroundImages, BackgroundImage, SpaceView3D, background_images, false, true, false)
	inline bool show_background_images(void);
	inline void show_background_images(int value);
	enum pivot_point_enum {
		pivot_point_BOUNDING_BOX_CENTER = 0,
		pivot_point_CURSOR = 1,
		pivot_point_INDIVIDUAL_ORIGINS = 2,
		pivot_point_MEDIAN_POINT = 3,
		pivot_point_ACTIVE_ELEMENT = 4,
	};
	inline pivot_point_enum pivot_point(void);
	inline void pivot_point(pivot_point_enum value);
	inline bool use_pivot_point_align(void);
	inline void use_pivot_point_align(int value);
	inline bool show_manipulator(void);
	inline void show_manipulator(int value);
	enum transform_manipulators_enum {
		transform_manipulators_TRANSLATE = 1,
		transform_manipulators_ROTATE = 2,
		transform_manipulators_SCALE = 4,
	};
	inline transform_manipulators_enum transform_manipulators(void);
	inline void transform_manipulators(transform_manipulators_enum value);
	enum transform_orientation_enum {
		transform_orientation_GLOBAL = 0,
		transform_orientation_LOCAL = 1,
		transform_orientation_NORMAL = 2,
		transform_orientation_GIMBAL = 4,
		transform_orientation_VIEW = 3,
	};
	inline transform_orientation_enum transform_orientation(void);
	inline void transform_orientation(transform_orientation_enum value);
	inline TransformOrientation current_orientation(void);
	inline bool lock_camera_and_layers(void);
	inline void lock_camera_and_layers(int value);
	inline Array<int, 20> layers(void);
	inline void layers(int values[20]);
	inline Array<int, 8> layers_local_view(void);
	inline void layers_local_view(int values[8]);
	inline Array<int, 20> layers_used(void);
	inline void layers_used(int values[20]);
	inline RegionView3D region_3d(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, RegionView3D, SpaceView3D, region_quadviews, false, false, false)
	inline bool show_reconstruction(void);
	inline void show_reconstruction(int value);
	inline float tracks_draw_size(void);
	inline void tracks_draw_size(float value);
	enum tracks_draw_type_enum {
		tracks_draw_type_PLAIN_AXES = 2,
		tracks_draw_type_ARROWS = 1,
		tracks_draw_type_SINGLE_ARROW = 4,
		tracks_draw_type_CIRCLE = 3,
		tracks_draw_type_CUBE = 5,
		tracks_draw_type_SPHERE = 6,
		tracks_draw_type_CONE = 7,
	};
	inline tracks_draw_type_enum tracks_draw_type(void);
	inline void tracks_draw_type(tracks_draw_type_enum value);
	inline bool show_camera_path(void);
	inline void show_camera_path(int value);
	inline bool show_bundle_names(void);
	inline void show_bundle_names(int value);
	inline bool use_matcap(void);
	inline void use_matcap(int value);
	enum matcap_icon_enum {
		matcap_icon_01 = 812,
		matcap_icon_02 = 813,
		matcap_icon_03 = 814,
		matcap_icon_04 = 815,
		matcap_icon_05 = 816,
		matcap_icon_06 = 817,
		matcap_icon_07 = 818,
		matcap_icon_08 = 819,
		matcap_icon_09 = 820,
		matcap_icon_10 = 821,
		matcap_icon_11 = 822,
		matcap_icon_12 = 823,
		matcap_icon_13 = 824,
		matcap_icon_14 = 825,
		matcap_icon_15 = 826,
		matcap_icon_16 = 827,
		matcap_icon_17 = 828,
		matcap_icon_18 = 829,
		matcap_icon_19 = 830,
		matcap_icon_20 = 831,
		matcap_icon_21 = 832,
		matcap_icon_22 = 833,
		matcap_icon_23 = 834,
		matcap_icon_24 = 835,
	};
	inline matcap_icon_enum matcap_icon(void);
	inline void matcap_icon(matcap_icon_enum value);

};

/**************** 3D View Region ****************/

class RegionView3D : public Pointer {
public:
	RegionView3D(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool lock_rotation(void);
	inline void lock_rotation(int value);
	inline bool show_sync_view(void);
	inline void show_sync_view(int value);
	inline bool use_box_clip(void);
	inline void use_box_clip(int value);
	inline Array<float, 16> perspective_matrix(void);
	inline void perspective_matrix(float values[16]);
	inline Array<float, 16> view_matrix(void);
	inline void view_matrix(float values[16]);
	enum view_perspective_enum {
		view_perspective_PERSP = 1,
		view_perspective_ORTHO = 0,
		view_perspective_CAMERA = 2,
	};
	inline view_perspective_enum view_perspective(void);
	inline void view_perspective(view_perspective_enum value);
	inline bool is_perspective(void);
	inline void is_perspective(int value);
	inline Array<float, 3> view_location(void);
	inline void view_location(float values[3]);
	inline Array<float, 4> view_rotation(void);
	inline void view_rotation(float values[4]);
	inline float view_distance(void);
	inline void view_distance(float value);
	inline float view_camera_zoom(void);
	inline void view_camera_zoom(float value);
	inline Array<float, 2> view_camera_offset(void);
	inline void view_camera_offset(float values[2]);

	inline void update();
};

/**************** Properties Space ****************/

class SpaceProperties : public Space {
public:
	SpaceProperties(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	enum context_enum {
		context_SCENE = 1,
		context_RENDER = 0,
		context_RENDER_LAYER = 13,
		context_WORLD = 2,
		context_OBJECT = 3,
		context_CONSTRAINT = 11,
		context_MODIFIER = 10,
		context_DATA = 4,
		context_BONE = 9,
		context_BONE_CONSTRAINT = 12,
		context_MATERIAL = 5,
		context_TEXTURE = 6,
		context_PARTICLES = 7,
		context_PHYSICS = 8,
	};
	inline context_enum context(void);
	inline void context(context_enum value);
	enum align_enum {
		align_HORIZONTAL = 1,
		align_VERTICAL = 2,
	};
	inline align_enum align(void);
	inline void align(align_enum value);
	enum texture_context_enum {
		texture_context_MATERIAL = 0,
		texture_context_WORLD = 1,
		texture_context_LAMP = 2,
		texture_context_PARTICLES = 3,
		texture_context_LINESTYLE = 5,
		texture_context_OTHER = 4,
	};
	inline texture_context_enum texture_context(void);
	inline void texture_context(texture_context_enum value);
	inline bool use_limited_texture_context(void);
	inline void use_limited_texture_context(int value);
	inline ID pin_id(void);
	inline bool use_pin_id(void);
	inline void use_pin_id(int value);

};

/**************** Space Dope Sheet Editor ****************/

class SpaceDopeSheetEditor : public Space {
public:
	SpaceDopeSheetEditor(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	inline Action action(void);
	enum mode_enum {
		mode_DOPESHEET = 3,
		mode_ACTION = 0,
		mode_SHAPEKEY = 1,
		mode_GPENCIL = 2,
		mode_MASK = 4,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool show_seconds(void);
	inline void show_seconds(int value);
	inline bool show_frame_indicator(void);
	inline void show_frame_indicator(int value);
	inline bool show_sliders(void);
	inline void show_sliders(int value);
	inline bool show_pose_markers(void);
	inline void show_pose_markers(int value);
	inline bool show_group_colors(void);
	inline void show_group_colors(int value);
	inline bool use_auto_merge_keyframes(void);
	inline void use_auto_merge_keyframes(int value);
	inline bool use_realtime_update(void);
	inline void use_realtime_update(int value);
	inline bool use_marker_sync(void);
	inline void use_marker_sync(int value);
	inline DopeSheet dopesheet(void);
	enum auto_snap_enum {
		auto_snap_NONE = 0,
		auto_snap_STEP = 1,
		auto_snap_TIME_STEP = 5,
		auto_snap_FRAME = 2,
		auto_snap_SECOND = 4,
		auto_snap_MARKER = 3,
	};
	inline auto_snap_enum auto_snap(void);
	inline void auto_snap(auto_snap_enum value);

};

/**************** Space Graph Editor ****************/

class SpaceGraphEditor : public Space {
public:
	SpaceGraphEditor(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	enum mode_enum {
		mode_FCURVES = 0,
		mode_DRIVERS = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool show_seconds(void);
	inline void show_seconds(int value);
	inline bool show_frame_indicator(void);
	inline void show_frame_indicator(int value);
	inline bool show_sliders(void);
	inline void show_sliders(int value);
	inline bool show_handles(void);
	inline void show_handles(int value);
	inline bool use_only_selected_curves_handles(void);
	inline void use_only_selected_curves_handles(int value);
	inline bool use_only_selected_keyframe_handles(void);
	inline void use_only_selected_keyframe_handles(int value);
	inline bool use_beauty_drawing(void);
	inline void use_beauty_drawing(int value);
	inline bool show_group_colors(void);
	inline void show_group_colors(int value);
	inline bool use_auto_merge_keyframes(void);
	inline void use_auto_merge_keyframes(int value);
	inline bool use_realtime_update(void);
	inline void use_realtime_update(int value);
	inline bool show_cursor(void);
	inline void show_cursor(int value);
	inline float cursor_position_y(void);
	inline void cursor_position_y(float value);
	enum pivot_point_enum {
		pivot_point_BOUNDING_BOX_CENTER = 0,
		pivot_point_CURSOR = 1,
		pivot_point_INDIVIDUAL_ORIGINS = 2,
	};
	inline pivot_point_enum pivot_point(void);
	inline void pivot_point(pivot_point_enum value);
	inline DopeSheet dopesheet(void);
	enum auto_snap_enum {
		auto_snap_NONE = 0,
		auto_snap_STEP = 1,
		auto_snap_TIME_STEP = 5,
		auto_snap_FRAME = 2,
		auto_snap_SECOND = 4,
		auto_snap_MARKER = 3,
	};
	inline auto_snap_enum auto_snap(void);
	inline void auto_snap(auto_snap_enum value);
	inline bool has_ghost_curves(void);
	inline void has_ghost_curves(int value);
	inline bool use_normalization(void);
	inline void use_normalization(int value);
	inline bool use_auto_normalization(void);
	inline void use_auto_normalization(int value);

};

/**************** Space Nla Editor ****************/

class SpaceNLA : public Space {
public:
	SpaceNLA(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	inline bool show_seconds(void);
	inline void show_seconds(int value);
	inline bool show_frame_indicator(void);
	inline void show_frame_indicator(int value);
	inline bool show_strip_curves(void);
	inline void show_strip_curves(int value);
	inline bool use_realtime_update(void);
	inline void use_realtime_update(int value);
	inline DopeSheet dopesheet(void);
	enum auto_snap_enum {
		auto_snap_NONE = 0,
		auto_snap_STEP = 1,
		auto_snap_TIME_STEP = 5,
		auto_snap_FRAME = 2,
		auto_snap_SECOND = 4,
		auto_snap_MARKER = 3,
	};
	inline auto_snap_enum auto_snap(void);
	inline void auto_snap(auto_snap_enum value);

};

/**************** Space Timeline Editor ****************/

class SpaceTimeline : public Space {
public:
	SpaceTimeline(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	inline bool show_frame_indicator(void);
	inline void show_frame_indicator(int value);
	inline bool show_seconds(void);
	inline void show_seconds(int value);
	inline bool show_cache(void);
	inline void show_cache(int value);
	inline bool cache_softbody(void);
	inline void cache_softbody(int value);
	inline bool cache_particles(void);
	inline void cache_particles(int value);
	inline bool cache_cloth(void);
	inline void cache_cloth(int value);
	inline bool cache_smoke(void);
	inline void cache_smoke(int value);
	inline bool cache_dynamicpaint(void);
	inline void cache_dynamicpaint(int value);
	inline bool cache_rigidbody(void);
	inline void cache_rigidbody(int value);

};

/**************** Space Console ****************/

class SpaceConsole : public Space {
public:
	SpaceConsole(const PointerRNA &ptr_arg) :
		Space(ptr_arg),
		history(ptr_arg),
		scrollback(ptr_arg)
		{}

	inline int font_size(void);
	inline void font_size(int value);
	inline int select_start(void);
	inline void select_start(int value);
	inline int select_end(void);
	inline void select_end(int value);
	inline std::string prompt(void);	inline void prompt(const std::string& value);
	inline std::string language(void);	inline void language(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ConsoleLine, SpaceConsole, history, false, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ConsoleLine, SpaceConsole, scrollback, false, true, false)

};

/**************** Console Input ****************/

class ConsoleLine : public Pointer {
public:
	ConsoleLine(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string body(void);	inline void body(const std::string& value);
	inline int current_character(void);
	inline void current_character(int value);
	enum type_enum {
		type_OUTPUT = 0,
		type_INPUT = 1,
		type_INFO = 2,
		type_ERROR = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);

};

/**************** Space Info ****************/

class SpaceInfo : public Space {
public:
	SpaceInfo(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	inline bool show_report_debug(void);
	inline void show_report_debug(int value);
	inline bool show_report_info(void);
	inline void show_report_info(int value);
	inline bool show_report_operator(void);
	inline void show_report_operator(int value);
	inline bool show_report_warning(void);
	inline void show_report_warning(int value);
	inline bool show_report_error(void);
	inline void show_report_error(int value);

};

/**************** Space User Preferences ****************/

class SpaceUserPreferences : public Space {
public:
	SpaceUserPreferences(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	enum filter_type_enum {
		filter_type_NAME = 0,
		filter_type_KEY = 1,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);
	inline std::string filter_text(void);	inline void filter_text(const std::string& value);

};

/**************** Node Tree Path ****************/

class NodeTreePath : public Pointer {
public:
	NodeTreePath(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline NodeTree node_tree(void);

};

/**************** Space Node Editor ****************/

class SpaceNodeEditor : public Space {
public:
	SpaceNodeEditor(const PointerRNA &ptr_arg) :
		Space(ptr_arg),
		path(ptr_arg)
		{}

	enum tree_type_enum {
		tree_type_DUMMY = 0,
	};
	inline tree_type_enum tree_type(void);
	inline void tree_type(tree_type_enum value);
	enum texture_type_enum {
		texture_type_OBJECT = 0,
		texture_type_WORLD = 1,
		texture_type_BRUSH = 2,
	};
	inline texture_type_enum texture_type(void);
	inline void texture_type(texture_type_enum value);
	enum shader_type_enum {
		shader_type_OBJECT = 0,
		shader_type_WORLD = 1,
	};
	inline shader_type_enum shader_type(void);
	inline void shader_type(shader_type_enum value);
	inline ID id(void);
	inline ID id_from(void);
	COLLECTION_PROPERTY(SpaceNodeEditorPath, NodeTreePath, SpaceNodeEditor, path, false, true, false)
	inline NodeTree node_tree(void);
	inline NodeTree edit_tree(void);
	inline bool pin(void);
	inline void pin(int value);
	inline bool show_backdrop(void);
	inline void show_backdrop(int value);
	inline bool show_grease_pencil(void);
	inline void show_grease_pencil(int value);
	inline bool use_auto_render(void);
	inline void use_auto_render(int value);
	inline float backdrop_zoom(void);
	inline void backdrop_zoom(float value);
	inline float backdrop_x(void);
	inline void backdrop_x(float value);
	inline float backdrop_y(void);
	inline void backdrop_y(float value);
	enum backdrop_channels_enum {
		backdrop_channels_COLOR_ALPHA = 8,
		backdrop_channels_COLOR = 0,
		backdrop_channels_ALPHA = 16,
		backdrop_channels_RED = 128,
		backdrop_channels_GREEN = 256,
		backdrop_channels_BLUE = 512,
	};
	inline backdrop_channels_enum backdrop_channels(void);
	inline void backdrop_channels(backdrop_channels_enum value);
	inline bool show_highlight(void);
	inline void show_highlight(int value);
	inline Array<float, 2> cursor_location(void);
	inline void cursor_location(float values[2]);

	inline void cursor_location_from_region(Context C, int x, int y);
};

/**************** Space Logic Editor ****************/

class SpaceLogicEditor : public Space {
public:
	SpaceLogicEditor(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	inline bool show_sensors_selected_objects(void);
	inline void show_sensors_selected_objects(int value);
	inline bool show_sensors_active_object(void);
	inline void show_sensors_active_object(int value);
	inline bool show_sensors_linked_controller(void);
	inline void show_sensors_linked_controller(int value);
	inline bool show_sensors_active_states(void);
	inline void show_sensors_active_states(int value);
	inline bool show_controllers_selected_objects(void);
	inline void show_controllers_selected_objects(int value);
	inline bool show_controllers_active_object(void);
	inline void show_controllers_active_object(int value);
	inline bool show_controllers_linked_controller(void);
	inline void show_controllers_linked_controller(int value);
	inline bool show_actuators_selected_objects(void);
	inline void show_actuators_selected_objects(int value);
	inline bool show_actuators_active_object(void);
	inline void show_actuators_active_object(int value);
	inline bool show_actuators_linked_controller(void);
	inline void show_actuators_linked_controller(int value);
	inline bool show_actuators_active_states(void);
	inline void show_actuators_active_states(int value);

};

/**************** Space Clip Editor ****************/

class SpaceClipEditor : public Space {
public:
	SpaceClipEditor(const PointerRNA &ptr_arg) :
		Space(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline MovieClipUser clip_user(void);
	inline Mask mask(void);
	enum mask_draw_type_enum {
		mask_draw_type_OUTLINE = 0,
		mask_draw_type_DASH = 1,
		mask_draw_type_BLACK = 2,
		mask_draw_type_WHITE = 3,
	};
	inline mask_draw_type_enum mask_draw_type(void);
	inline void mask_draw_type(mask_draw_type_enum value);
	inline bool show_mask_smooth(void);
	inline void show_mask_smooth(int value);
	inline bool show_mask_overlay(void);
	inline void show_mask_overlay(int value);
	enum mask_overlay_mode_enum {
		mask_overlay_mode_ALPHACHANNEL = 0,
		mask_overlay_mode_COMBINED = 1,
	};
	inline mask_overlay_mode_enum mask_overlay_mode(void);
	inline void mask_overlay_mode(mask_overlay_mode_enum value);
	enum mode_enum {
		mode_TRACKING = 0,
		mode_MASK = 3,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	enum view_enum {
		view_CLIP = 0,
		view_GRAPH = 1,
		view_DOPESHEET = 2,
	};
	inline view_enum view(void);
	inline void view(view_enum value);
	inline bool show_marker_pattern(void);
	inline void show_marker_pattern(int value);
	inline bool show_marker_search(void);
	inline void show_marker_search(int value);
	inline bool lock_selection(void);
	inline void lock_selection(int value);
	inline bool lock_time_cursor(void);
	inline void lock_time_cursor(int value);
	inline bool show_track_path(void);
	inline void show_track_path(int value);
	inline int path_length(void);
	inline void path_length(int value);
	inline bool show_tiny_markers(void);
	inline void show_tiny_markers(int value);
	inline bool show_bundles(void);
	inline void show_bundles(int value);
	inline bool use_mute_footage(void);
	inline void use_mute_footage(int value);
	inline bool show_disabled(void);
	inline void show_disabled(int value);
	inline MovieClipScopes scopes(void);
	inline bool show_names(void);
	inline void show_names(int value);
	inline bool show_grid(void);
	inline void show_grid(int value);
	inline bool show_stable(void);
	inline void show_stable(int value);
	inline bool use_manual_calibration(void);
	inline void use_manual_calibration(int value);
	inline bool show_grease_pencil(void);
	inline void show_grease_pencil(int value);
	inline bool show_filters(void);
	inline void show_filters(int value);
	inline bool show_graph_frames(void);
	inline void show_graph_frames(int value);
	inline bool show_graph_tracks_motion(void);
	inline void show_graph_tracks_motion(int value);
	inline bool show_graph_tracks_error(void);
	inline void show_graph_tracks_error(int value);
	inline bool show_graph_only_selected(void);
	inline void show_graph_only_selected(int value);
	inline bool show_graph_hidden(void);
	inline void show_graph_hidden(int value);
	inline bool show_red_channel(void);
	inline void show_red_channel(int value);
	inline bool show_green_channel(void);
	inline void show_green_channel(int value);
	inline bool show_blue_channel(void);
	inline void show_blue_channel(int value);
	inline bool use_grayscale_preview(void);
	inline void use_grayscale_preview(int value);
	inline bool show_seconds(void);
	inline void show_seconds(int value);
	enum grease_pencil_source_enum {
		grease_pencil_source_CLIP = 0,
		grease_pencil_source_TRACK = 1,
	};
	inline grease_pencil_source_enum grease_pencil_source(void);
	inline void grease_pencil_source(grease_pencil_source_enum value);
	enum pivot_point_enum {
		pivot_point_BOUNDING_BOX_CENTER = 0,
		pivot_point_CURSOR = 1,
		pivot_point_INDIVIDUAL_ORIGINS = 2,
		pivot_point_MEDIAN_POINT = 3,
	};
	inline pivot_point_enum pivot_point(void);
	inline void pivot_point(pivot_point_enum value);

};

/**************** Speaker ****************/

class Speaker : public ID {
public:
	Speaker(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	inline bool muted(void);
	inline void muted(int value);
	inline bool relative(void);
	inline void relative(int value);
	inline Sound sound(void);
	inline float volume_max(void);
	inline void volume_max(float value);
	inline float volume_min(void);
	inline void volume_min(float value);
	inline float distance_max(void);
	inline void distance_max(float value);
	inline float distance_reference(void);
	inline void distance_reference(float value);
	inline float attenuation(void);
	inline void attenuation(float value);
	inline float cone_angle_outer(void);
	inline void cone_angle_outer(float value);
	inline float cone_angle_inner(void);
	inline void cone_angle_inner(float value);
	inline float cone_volume_outer(void);
	inline void cone_volume_outer(float value);
	inline float volume(void);
	inline void volume(float value);
	inline float pitch(void);
	inline void pitch(float value);
	inline AnimData animation_data(void);

};

/**************** Text Line ****************/

class TextLine : public Pointer {
public:
	TextLine(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string body(void);	inline void body(const std::string& value);

};

/**************** Text ****************/

class Text : public ID {
public:
	Text(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		lines(ptr_arg)
		{}

	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline bool is_dirty(void);
	inline void is_dirty(int value);
	inline bool is_modified(void);
	inline void is_modified(int value);
	inline bool is_in_memory(void);
	inline void is_in_memory(int value);
	inline bool use_module(void);
	inline void use_module(int value);
	inline bool use_tabs_as_spaces(void);
	inline void use_tabs_as_spaces(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, TextLine, Text, lines, false, true, false)
	inline TextLine current_line(void);
	inline int current_character(void);
	inline void current_character(int value);
	inline int current_line_index(void);
	inline void current_line_index(int value);
	inline TextLine select_end_line(void);
	inline int select_end_character(void);
	inline void select_end_character(int value);

	inline void clear();
	inline void write(const char * text);
};

/**************** Marker ****************/

class TimelineMarker : public Pointer {
public:
	TimelineMarker(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline int frame(void);
	inline void frame(int value);
	inline bool select(void);
	inline void select(int value);
	inline Object camera(void);

};

/**************** Sound ****************/

class Sound : public ID {
public:
	Sound(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline PackedFile packed_file(void);
	inline bool use_memory_cache(void);
	inline void use_memory_cache(int value);
	inline bool use_mono(void);
	inline void use_mono(int value);

};

/**************** UI Layout ****************/

class UILayout : public Pointer {
public:
	UILayout(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool active(void);
	inline void active(int value);
	enum operator_context_enum {
		operator_context_INVOKE_DEFAULT = 0,
		operator_context_INVOKE_REGION_WIN = 1,
		operator_context_INVOKE_REGION_CHANNELS = 2,
		operator_context_INVOKE_REGION_PREVIEW = 3,
		operator_context_INVOKE_AREA = 4,
		operator_context_INVOKE_SCREEN = 5,
		operator_context_EXEC_DEFAULT = 6,
		operator_context_EXEC_REGION_WIN = 7,
		operator_context_EXEC_REGION_CHANNELS = 8,
		operator_context_EXEC_REGION_PREVIEW = 9,
		operator_context_EXEC_AREA = 10,
		operator_context_EXEC_SCREEN = 11,
	};
	inline operator_context_enum operator_context(void);
	inline void operator_context(operator_context_enum value);
	inline bool enabled(void);
	inline void enabled(int value);
	inline bool alert(void);
	inline void alert(int value);
	enum alignment_enum {
		alignment_EXPAND = 0,
		alignment_LEFT = 1,
		alignment_CENTER = 2,
		alignment_RIGHT = 3,
	};
	inline alignment_enum alignment(void);
	inline void alignment(alignment_enum value);
	inline float scale_x(void);
	inline void scale_x(float value);
	inline float scale_y(void);
	inline void scale_y(float value);

	inline UILayout row(int align);
	inline UILayout column(int align);
	inline UILayout column_flow(int columns, int align);
	inline UILayout box();
	inline UILayout split(float percentage, int align);
	inline UILayout menu_pie();
	inline int icon(Context C, AnyType data);
	inline const char * enum_item_name(Context C, AnyType data, const char * property, const char * identifier);
	inline const char * enum_item_description(Context C, AnyType data, const char * property, const char * identifier);
	inline int enum_item_icon(Context C, AnyType data, const char * property, const char * identifier);
	inline void prop(AnyType data, const char * property, const char * text, const char * text_ctxt, int translate, int icon, int expand, int slider, int toggle, int icon_only, int event, int full_event, int emboss, int index, int icon_value);
	inline void props_enum(AnyType data, const char * property);
	inline void prop_menu_enum(AnyType data, const char * property, const char * text, const char * text_ctxt, int translate, int icon);
	inline void prop_enum(AnyType data, const char * property, const char * value, const char * text, const char * text_ctxt, int translate, int icon);
	inline void prop_search(AnyType data, const char * property, AnyType search_data, const char * search_property, const char * text, const char * text_ctxt, int translate, int icon);
	inline OperatorProperties operator_value(const char * operator_value, const char * text, const char * text_ctxt, int translate, int icon, int emboss);
	inline void operator_enum(const char * operator_value, const char * property);
	inline void operator_menu_enum(Context C, const char * operator_value, const char * property, const char * text, const char * text_ctxt, int translate, int icon);
	inline void label(const char * text, const char * text_ctxt, int translate, int icon, int icon_value);
	inline void menu(Context C, const char * menu, const char * text, const char * text_ctxt, int translate, int icon);
	inline void separator();
	inline void context_pointer_set(const char * name, AnyType data);
	inline void template_header(Context C);
	inline void template_ID(Context C, AnyType data, const char * property, const char * create, const char * open, const char * unlink);
	inline void template_ID_preview(Context C, AnyType data, const char * property, const char * create, const char * open, const char * unlink, int rows, int cols);
	inline void template_any_ID(AnyType data, const char * property, const char * type_property, const char * text, const char * text_ctxt, int translate);
	inline void template_path_builder(AnyType data, const char * property, ID root, const char * text, const char * text_ctxt, int translate);
	inline UILayout template_modifier(Context C, Modifier data);
	inline UILayout template_constraint(Constraint data);
	inline void template_preview(Context C, ID id, int show_buttons, ID parent, TextureSlot slot, const char * preview_id);
	inline void template_curve_mapping(AnyType data, const char * property, int type, int levels, int brush, int use_negative_slope);
	inline void template_color_ramp(AnyType data, const char * property, int expand);
	inline void template_icon_view(AnyType data, const char * property);
	inline void template_histogram(AnyType data, const char * property);
	inline void template_waveform(AnyType data, const char * property);
	inline void template_vectorscope(AnyType data, const char * property);
	inline void template_layers(AnyType data, const char * property, AnyType used_layers_data, const char * used_layers_property, int active_layer);
	inline void template_color_picker(AnyType data, const char * property, int value_slider, int lock, int lock_luminosity, int cubic);
	inline void template_palette(AnyType data, const char * property, int color);
	inline void template_image_layers(Context C, Image image, ImageUser image_user);
	inline void template_image(Context C, AnyType data, const char * property, ImageUser image_user, int compact);
	inline void template_image_settings(ImageFormatSettings image_settings, int color_management);
	inline void template_movieclip(Context C, AnyType data, const char * property, int compact);
	inline void template_track(AnyType data, const char * property);
	inline void template_marker(AnyType data, const char * property, MovieClipUser clip_user, MovieTrackingTrack track, int compact);
	inline void template_movieclip_information(AnyType data, const char * property, MovieClipUser clip_user);
	inline void template_list(Context C, const char * listtype_name, const char * list_id, AnyType dataptr, const char * propname, AnyType active_dataptr, const char * active_propname, int rows, int maxrows, int type, int columns);
	inline void template_running_jobs(Context C);
	inline void template_operator_search();
	inline void template_header_3D(Context C);
	inline void template_edit_mode_selection(Context C);
	inline void template_reports_banner(Context C);
	inline void template_node_link(NodeTree ntree, Node node, NodeSocket socket);
	inline void template_node_view(Context C, NodeTree ntree, Node node, NodeSocket socket);
	inline void template_texture_user(Context C);
	inline void template_keymap_item_properties(KeyMapItem item);
	inline void template_component_menu(AnyType data, const char * property, const char * name);
	inline const char * introspect();
	inline void template_colorspace_settings(AnyType data, const char * property);
	inline void template_colormanaged_view_settings(Context C, AnyType data, const char * property);
	inline void template_node_socket(Context C, float color[4]);
};

/**************** Panel ****************/

class Panel : public Pointer {
public:
	Panel(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline UILayout layout(void);
	inline std::string text(void);	inline void text(const std::string& value);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);	inline void bl_label(const std::string& value);
	inline std::string bl_translation_context(void);	inline void bl_translation_context(const std::string& value);
	inline std::string bl_category(void);	inline void bl_category(const std::string& value);
	enum bl_space_type_enum {
		bl_space_type_EMPTY = 0,
		bl_space_type_VIEW_3D = 1,
		bl_space_type_TIMELINE = 15,
		bl_space_type_GRAPH_EDITOR = 2,
		bl_space_type_DOPESHEET_EDITOR = 12,
		bl_space_type_NLA_EDITOR = 13,
		bl_space_type_IMAGE_EDITOR = 6,
		bl_space_type_SEQUENCE_EDITOR = 8,
		bl_space_type_CLIP_EDITOR = 20,
		bl_space_type_TEXT_EDITOR = 9,
		bl_space_type_NODE_EDITOR = 16,
		bl_space_type_LOGIC_EDITOR = 17,
		bl_space_type_PROPERTIES = 4,
		bl_space_type_OUTLINER = 3,
		bl_space_type_USER_PREFERENCES = 19,
		bl_space_type_INFO = 7,
		bl_space_type_FILE_BROWSER = 5,
		bl_space_type_CONSOLE = 18,
	};
	inline bl_space_type_enum bl_space_type(void);
	inline void bl_space_type(bl_space_type_enum value);
	enum bl_region_type_enum {
		bl_region_type_WINDOW = 0,
		bl_region_type_HEADER = 1,
		bl_region_type_CHANNELS = 2,
		bl_region_type_TEMPORARY = 3,
		bl_region_type_UI = 4,
		bl_region_type_TOOLS = 5,
		bl_region_type_TOOL_PROPS = 6,
		bl_region_type_PREVIEW = 7,
	};
	inline bl_region_type_enum bl_region_type(void);
	inline void bl_region_type(bl_region_type_enum value);
	inline std::string bl_context(void);	inline void bl_context(const std::string& value);
	enum bl_options_enum {
		bl_options_DEFAULT_CLOSED = 1,
		bl_options_HIDE_HEADER = 2,
	};
	inline bl_options_enum bl_options(void);
	inline void bl_options(bl_options_enum value);
	inline bool use_pin(void);
	inline void use_pin(int value);

};

/**************** UIList ****************/

class UIList : public Pointer {
public:
	UIList(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	enum layout_type_enum {
		layout_type_DEFAULT = 0,
		layout_type_COMPACT = 1,
		layout_type_GRID = 2,
	};
	inline layout_type_enum layout_type(void);
	inline void layout_type(layout_type_enum value);
	inline bool use_filter_show(void);
	inline void use_filter_show(int value);
	inline std::string filter_name(void);	inline void filter_name(const std::string& value);
	inline bool use_filter_invert(void);
	inline void use_filter_invert(int value);
	inline bool use_filter_sort_alpha(void);
	inline void use_filter_sort_alpha(int value);
	inline bool use_filter_sort_reverse(void);
	inline void use_filter_sort_reverse(int value);
	inline int bitflag_filter_item(void);
	inline void bitflag_filter_item(int value);

};

/**************** Header ****************/

class Header : public Pointer {
public:
	Header(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline UILayout layout(void);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	enum bl_space_type_enum {
		bl_space_type_EMPTY = 0,
		bl_space_type_VIEW_3D = 1,
		bl_space_type_TIMELINE = 15,
		bl_space_type_GRAPH_EDITOR = 2,
		bl_space_type_DOPESHEET_EDITOR = 12,
		bl_space_type_NLA_EDITOR = 13,
		bl_space_type_IMAGE_EDITOR = 6,
		bl_space_type_SEQUENCE_EDITOR = 8,
		bl_space_type_CLIP_EDITOR = 20,
		bl_space_type_TEXT_EDITOR = 9,
		bl_space_type_NODE_EDITOR = 16,
		bl_space_type_LOGIC_EDITOR = 17,
		bl_space_type_PROPERTIES = 4,
		bl_space_type_OUTLINER = 3,
		bl_space_type_USER_PREFERENCES = 19,
		bl_space_type_INFO = 7,
		bl_space_type_FILE_BROWSER = 5,
		bl_space_type_CONSOLE = 18,
	};
	inline bl_space_type_enum bl_space_type(void);
	inline void bl_space_type(bl_space_type_enum value);

};

/**************** Menu ****************/

class Menu : public Pointer {
public:
	Menu(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline UILayout layout(void);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);	inline void bl_label(const std::string& value);
	inline std::string bl_translation_context(void);	inline void bl_translation_context(const std::string& value);
	inline std::string bl_description(void);	inline void bl_description(const std::string& value);

};

/**************** Font Style ****************/

class ThemeFontStyle : public Pointer {
public:
	ThemeFontStyle(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int points(void);
	inline void points(int value);
	enum font_kerning_style_enum {
		font_kerning_style_UNFITTED = 0,
		font_kerning_style_FITTED = 1,
	};
	inline font_kerning_style_enum font_kerning_style(void);
	inline void font_kerning_style(font_kerning_style_enum value);
	inline int shadow(void);
	inline void shadow(int value);
	inline int shadow_offset_x(void);
	inline void shadow_offset_x(int value);
	inline int shadow_offset_y(void);
	inline void shadow_offset_y(int value);
	inline float shadow_alpha(void);
	inline void shadow_alpha(float value);
	inline float shadow_value(void);
	inline void shadow_value(float value);

};

/**************** Style ****************/

class ThemeStyle : public Pointer {
public:
	ThemeStyle(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeFontStyle panel_title(void);
	inline ThemeFontStyle widget_label(void);
	inline ThemeFontStyle widget(void);

};

/**************** Theme Widget Color Set ****************/

class ThemeWidgetColors : public Pointer {
public:
	ThemeWidgetColors(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> outline(void);
	inline void outline(float values[3]);
	inline Array<float, 4> inner(void);
	inline void inner(float values[4]);
	inline Array<float, 4> inner_sel(void);
	inline void inner_sel(float values[4]);
	inline Array<float, 4> item(void);
	inline void item(float values[4]);
	inline Array<float, 3> text(void);
	inline void text(float values[3]);
	inline Array<float, 3> text_sel(void);
	inline void text_sel(float values[3]);
	inline bool show_shaded(void);
	inline void show_shaded(int value);
	inline int shadetop(void);
	inline void shadetop(int value);
	inline int shadedown(void);
	inline void shadedown(int value);

};

/**************** Theme Widget State Color ****************/

class ThemeWidgetStateColors : public Pointer {
public:
	ThemeWidgetStateColors(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> inner_anim(void);
	inline void inner_anim(float values[3]);
	inline Array<float, 3> inner_anim_sel(void);
	inline void inner_anim_sel(float values[3]);
	inline Array<float, 3> inner_key(void);
	inline void inner_key(float values[3]);
	inline Array<float, 3> inner_key_sel(void);
	inline void inner_key_sel(float values[3]);
	inline Array<float, 3> inner_driven(void);
	inline void inner_driven(float values[3]);
	inline Array<float, 3> inner_driven_sel(void);
	inline void inner_driven_sel(float values[3]);
	inline float blend(void);
	inline void blend(float value);

};

/**************** Theme Panel Color ****************/

class ThemePanelColors : public Pointer {
public:
	ThemePanelColors(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 4> header(void);
	inline void header(float values[4]);
	inline Array<float, 4> back(void);
	inline void back(float values[4]);
	inline bool show_header(void);
	inline void show_header(int value);
	inline bool show_back(void);
	inline void show_back(int value);

};

/**************** Theme Background Color ****************/

class ThemeGradientColors : public Pointer {
public:
	ThemeGradientColors(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool show_grad(void);
	inline void show_grad(int value);
	inline Array<float, 3> gradient(void);
	inline void gradient(float values[3]);
	inline Array<float, 3> high_gradient(void);
	inline void high_gradient(float values[3]);

};

/**************** Theme User Interface ****************/

class ThemeUserInterface : public Pointer {
public:
	ThemeUserInterface(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeWidgetColors wcol_regular(void);
	inline ThemeWidgetColors wcol_tool(void);
	inline ThemeWidgetColors wcol_radio(void);
	inline ThemeWidgetColors wcol_text(void);
	inline ThemeWidgetColors wcol_option(void);
	inline ThemeWidgetColors wcol_toggle(void);
	inline ThemeWidgetColors wcol_num(void);
	inline ThemeWidgetColors wcol_numslider(void);
	inline ThemeWidgetColors wcol_box(void);
	inline ThemeWidgetColors wcol_menu(void);
	inline ThemeWidgetColors wcol_pulldown(void);
	inline ThemeWidgetColors wcol_menu_back(void);
	inline ThemeWidgetColors wcol_pie_menu(void);
	inline ThemeWidgetColors wcol_tooltip(void);
	inline ThemeWidgetColors wcol_menu_item(void);
	inline ThemeWidgetColors wcol_scroll(void);
	inline ThemeWidgetColors wcol_progress(void);
	inline ThemeWidgetColors wcol_list_item(void);
	inline ThemeWidgetStateColors wcol_state(void);
	inline float menu_shadow_fac(void);
	inline void menu_shadow_fac(float value);
	inline int menu_shadow_width(void);
	inline void menu_shadow_width(int value);
	inline std::string icon_file(void);	inline void icon_file(const std::string& value);
	inline float icon_alpha(void);
	inline void icon_alpha(float value);
	inline Array<float, 4> emboss(void);
	inline void emboss(float values[4]);
	inline Array<float, 3> axis_x(void);
	inline void axis_x(float values[3]);
	inline Array<float, 3> axis_y(void);
	inline void axis_y(float values[3]);
	inline Array<float, 3> axis_z(void);
	inline void axis_z(float values[3]);

};

/**************** Theme Space Settings ****************/

class ThemeSpaceGeneric : public Pointer {
public:
	ThemeSpaceGeneric(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> back(void);
	inline void back(float values[3]);
	inline Array<float, 3> title(void);
	inline void title(float values[3]);
	inline Array<float, 3> text(void);
	inline void text(float values[3]);
	inline Array<float, 3> text_hi(void);
	inline void text_hi(float values[3]);
	inline Array<float, 3> header(void);
	inline void header(float values[3]);
	inline Array<float, 3> header_text(void);
	inline void header_text(float values[3]);
	inline Array<float, 3> header_text_hi(void);
	inline void header_text_hi(float values[3]);
	inline ThemePanelColors panelcolors(void);
	inline Array<float, 4> button(void);
	inline void button(float values[4]);
	inline Array<float, 3> button_title(void);
	inline void button_title(float values[3]);
	inline Array<float, 3> button_text(void);
	inline void button_text(float values[3]);
	inline Array<float, 3> button_text_hi(void);
	inline void button_text_hi(float values[3]);
	inline Array<float, 3> tab_active(void);
	inline void tab_active(float values[3]);
	inline Array<float, 3> tab_inactive(void);
	inline void tab_inactive(float values[3]);
	inline Array<float, 4> tab_back(void);
	inline void tab_back(float values[4]);
	inline Array<float, 3> tab_outline(void);
	inline void tab_outline(float values[3]);

};

/**************** Theme Space Settings ****************/

class ThemeSpaceGradient : public Pointer {
public:
	ThemeSpaceGradient(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeGradientColors gradients(void);
	inline Array<float, 3> title(void);
	inline void title(float values[3]);
	inline Array<float, 3> text(void);
	inline void text(float values[3]);
	inline Array<float, 3> text_hi(void);
	inline void text_hi(float values[3]);
	inline Array<float, 3> header(void);
	inline void header(float values[3]);
	inline Array<float, 3> header_text(void);
	inline void header_text(float values[3]);
	inline Array<float, 3> header_text_hi(void);
	inline void header_text_hi(float values[3]);
	inline ThemePanelColors panelcolors(void);
	inline Array<float, 4> button(void);
	inline void button(float values[4]);
	inline Array<float, 3> button_title(void);
	inline void button_title(float values[3]);
	inline Array<float, 3> button_text(void);
	inline void button_text(float values[3]);
	inline Array<float, 3> button_text_hi(void);
	inline void button_text_hi(float values[3]);
	inline Array<float, 3> tab_active(void);
	inline void tab_active(float values[3]);
	inline Array<float, 3> tab_inactive(void);
	inline void tab_inactive(float values[3]);
	inline Array<float, 4> tab_back(void);
	inline void tab_back(float values[4]);
	inline Array<float, 3> tab_outline(void);
	inline void tab_outline(float values[3]);

};

/**************** Theme Space List Settings ****************/

class ThemeSpaceListGeneric : public Pointer {
public:
	ThemeSpaceListGeneric(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> list(void);
	inline void list(float values[3]);
	inline Array<float, 3> list_title(void);
	inline void list_title(float values[3]);
	inline Array<float, 3> list_text(void);
	inline void list_text(float values[3]);
	inline Array<float, 3> list_text_hi(void);
	inline void list_text_hi(float values[3]);

};

/**************** Theme 3D View ****************/

class ThemeView3D : public Pointer {
public:
	ThemeView3D(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGradient space(void);
	inline Array<float, 3> grid(void);
	inline void grid(float values[3]);
	inline Array<float, 3> wire(void);
	inline void wire(float values[3]);
	inline Array<float, 3> wire_edit(void);
	inline void wire_edit(float values[3]);
	inline Array<float, 4> lamp(void);
	inline void lamp(float values[4]);
	inline Array<float, 3> speaker(void);
	inline void speaker(float values[3]);
	inline Array<float, 3> camera(void);
	inline void camera(float values[3]);
	inline Array<float, 3> view_overlay(void);
	inline void view_overlay(float values[3]);
	inline Array<float, 3> empty(void);
	inline void empty(float values[3]);
	inline Array<float, 3> object_selected(void);
	inline void object_selected(float values[3]);
	inline Array<float, 3> object_active(void);
	inline void object_active(float values[3]);
	inline Array<float, 3> object_grouped(void);
	inline void object_grouped(float values[3]);
	inline Array<float, 3> object_grouped_active(void);
	inline void object_grouped_active(float values[3]);
	inline Array<float, 3> transform(void);
	inline void transform(float values[3]);
	inline Array<float, 3> vertex(void);
	inline void vertex(float values[3]);
	inline Array<float, 3> vertex_select(void);
	inline void vertex_select(float values[3]);
	inline int vertex_size(void);
	inline void vertex_size(int value);
	inline Array<float, 3> vertex_unreferenced(void);
	inline void vertex_unreferenced(float values[3]);
	inline Array<float, 3> edge_select(void);
	inline void edge_select(float values[3]);
	inline Array<float, 3> edge_seam(void);
	inline void edge_seam(float values[3]);
	inline Array<float, 3> edge_sharp(void);
	inline void edge_sharp(float values[3]);
	inline Array<float, 3> edge_crease(void);
	inline void edge_crease(float values[3]);
	inline Array<float, 3> edge_facesel(void);
	inline void edge_facesel(float values[3]);
	inline Array<float, 3> freestyle_edge_mark(void);
	inline void freestyle_edge_mark(float values[3]);
	inline Array<float, 4> face(void);
	inline void face(float values[4]);
	inline Array<float, 4> face_select(void);
	inline void face_select(float values[4]);
	inline Array<float, 3> face_dot(void);
	inline void face_dot(float values[3]);
	inline int facedot_size(void);
	inline void facedot_size(int value);
	inline Array<float, 4> freestyle_face_mark(void);
	inline void freestyle_face_mark(float values[4]);
	inline Array<float, 3> nurb_uline(void);
	inline void nurb_uline(float values[3]);
	inline Array<float, 3> nurb_vline(void);
	inline void nurb_vline(float values[3]);
	inline Array<float, 3> nurb_sel_uline(void);
	inline void nurb_sel_uline(float values[3]);
	inline Array<float, 3> nurb_sel_vline(void);
	inline void nurb_sel_vline(float values[3]);
	inline Array<float, 3> act_spline(void);
	inline void act_spline(float values[3]);
	inline Array<float, 3> handle_free(void);
	inline void handle_free(float values[3]);
	inline Array<float, 3> handle_auto(void);
	inline void handle_auto(float values[3]);
	inline Array<float, 3> handle_vect(void);
	inline void handle_vect(float values[3]);
	inline Array<float, 3> handle_sel_vect(void);
	inline void handle_sel_vect(float values[3]);
	inline Array<float, 3> handle_align(void);
	inline void handle_align(float values[3]);
	inline Array<float, 3> handle_sel_free(void);
	inline void handle_sel_free(float values[3]);
	inline Array<float, 3> handle_sel_auto(void);
	inline void handle_sel_auto(float values[3]);
	inline Array<float, 3> handle_sel_align(void);
	inline void handle_sel_align(float values[3]);
	inline Array<float, 3> lastsel_point(void);
	inline void lastsel_point(float values[3]);
	inline Array<float, 3> extra_edge_len(void);
	inline void extra_edge_len(float values[3]);
	inline Array<float, 3> extra_edge_angle(void);
	inline void extra_edge_angle(float values[3]);
	inline Array<float, 3> extra_face_angle(void);
	inline void extra_face_angle(float values[3]);
	inline Array<float, 3> extra_face_area(void);
	inline void extra_face_area(float values[3]);
	inline Array<float, 4> editmesh_active(void);
	inline void editmesh_active(float values[4]);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline Array<float, 3> vertex_normal(void);
	inline void vertex_normal(float values[3]);
	inline Array<float, 3> split_normal(void);
	inline void split_normal(float values[3]);
	inline Array<float, 3> bone_solid(void);
	inline void bone_solid(float values[3]);
	inline Array<float, 3> bone_pose(void);
	inline void bone_pose(float values[3]);
	inline Array<float, 3> bone_pose_active(void);
	inline void bone_pose_active(float values[3]);
	inline Array<float, 3> frame_current(void);
	inline void frame_current(float values[3]);
	inline int outline_width(void);
	inline void outline_width(int value);
	inline Array<float, 3> bundle_solid(void);
	inline void bundle_solid(float values[3]);
	inline Array<float, 3> camera_path(void);
	inline void camera_path(float values[3]);
	inline Array<float, 3> skin_root(void);
	inline void skin_root(float values[3]);
	inline Array<float, 4> paint_curve_handle(void);
	inline void paint_curve_handle(float values[4]);
	inline Array<float, 4> paint_curve_pivot(void);
	inline void paint_curve_pivot(float values[4]);

};

/**************** Theme Graph Editor ****************/

class ThemeGraphEditor : public Pointer {
public:
	ThemeGraphEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline ThemeSpaceListGeneric space_list(void);
	inline Array<float, 3> grid(void);
	inline void grid(float values[3]);
	inline Array<float, 3> frame_current(void);
	inline void frame_current(float values[3]);
	inline Array<float, 3> window_sliders(void);
	inline void window_sliders(float values[3]);
	inline Array<float, 3> channels_region(void);
	inline void channels_region(float values[3]);
	inline Array<float, 3> dopesheet_channel(void);
	inline void dopesheet_channel(float values[3]);
	inline Array<float, 3> dopesheet_subchannel(void);
	inline void dopesheet_subchannel(float values[3]);
	inline Array<float, 3> channel_group(void);
	inline void channel_group(float values[3]);
	inline Array<float, 3> active_channels_group(void);
	inline void active_channels_group(float values[3]);
	inline Array<float, 3> vertex(void);
	inline void vertex(float values[3]);
	inline Array<float, 3> vertex_select(void);
	inline void vertex_select(float values[3]);
	inline int vertex_size(void);
	inline void vertex_size(int value);
	inline Array<float, 3> vertex_unreferenced(void);
	inline void vertex_unreferenced(float values[3]);
	inline Array<float, 3> handle_free(void);
	inline void handle_free(float values[3]);
	inline Array<float, 3> handle_auto(void);
	inline void handle_auto(float values[3]);
	inline Array<float, 3> handle_vect(void);
	inline void handle_vect(float values[3]);
	inline Array<float, 3> handle_sel_vect(void);
	inline void handle_sel_vect(float values[3]);
	inline Array<float, 3> handle_align(void);
	inline void handle_align(float values[3]);
	inline Array<float, 3> handle_sel_free(void);
	inline void handle_sel_free(float values[3]);
	inline Array<float, 3> handle_sel_auto(void);
	inline void handle_sel_auto(float values[3]);
	inline Array<float, 3> handle_sel_align(void);
	inline void handle_sel_align(float values[3]);
	inline Array<float, 3> handle_auto_clamped(void);
	inline void handle_auto_clamped(float values[3]);
	inline Array<float, 3> handle_sel_auto_clamped(void);
	inline void handle_sel_auto_clamped(float values[3]);
	inline Array<float, 3> lastsel_point(void);
	inline void lastsel_point(float values[3]);
	inline Array<float, 3> handle_vertex(void);
	inline void handle_vertex(float values[3]);
	inline Array<float, 3> handle_vertex_select(void);
	inline void handle_vertex_select(float values[3]);
	inline int handle_vertex_size(void);
	inline void handle_vertex_size(int value);

};

/**************** Theme File Browser ****************/

class ThemeFileBrowser : public Pointer {
public:
	ThemeFileBrowser(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline ThemeSpaceListGeneric space_list(void);
	inline Array<float, 3> selected_file(void);
	inline void selected_file(float values[3]);
	inline Array<float, 3> scrollbar(void);
	inline void scrollbar(float values[3]);
	inline Array<float, 3> scroll_handle(void);
	inline void scroll_handle(float values[3]);
	inline Array<float, 3> active_file(void);
	inline void active_file(float values[3]);
	inline Array<float, 3> active_file_text(void);
	inline void active_file_text(float values[3]);

};

/**************** Theme NLA Editor ****************/

class ThemeNLAEditor : public Pointer {
public:
	ThemeNLAEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline ThemeSpaceListGeneric space_list(void);
	inline Array<float, 3> grid(void);
	inline void grid(float values[3]);
	inline Array<float, 3> view_sliders(void);
	inline void view_sliders(float values[3]);
	inline Array<float, 4> active_action(void);
	inline void active_action(float values[4]);
	inline Array<float, 4> active_action_unset(void);
	inline void active_action_unset(float values[4]);
	inline Array<float, 3> strips(void);
	inline void strips(float values[3]);
	inline Array<float, 3> strips_selected(void);
	inline void strips_selected(float values[3]);
	inline Array<float, 3> transition_strips(void);
	inline void transition_strips(float values[3]);
	inline Array<float, 3> transition_strips_selected(void);
	inline void transition_strips_selected(float values[3]);
	inline Array<float, 3> meta_strips(void);
	inline void meta_strips(float values[3]);
	inline Array<float, 3> meta_strips_selected(void);
	inline void meta_strips_selected(float values[3]);
	inline Array<float, 3> sound_strips(void);
	inline void sound_strips(float values[3]);
	inline Array<float, 3> sound_strips_selected(void);
	inline void sound_strips_selected(float values[3]);
	inline Array<float, 3> tweak(void);
	inline void tweak(float values[3]);
	inline Array<float, 3> tweak_duplicate(void);
	inline void tweak_duplicate(float values[3]);
	inline Array<float, 4> keyframe_border(void);
	inline void keyframe_border(float values[4]);
	inline Array<float, 4> keyframe_border_selected(void);
	inline void keyframe_border_selected(float values[4]);
	inline Array<float, 3> frame_current(void);
	inline void frame_current(float values[3]);

};

/**************** Theme Dope Sheet ****************/

class ThemeDopeSheet : public Pointer {
public:
	ThemeDopeSheet(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline ThemeSpaceListGeneric space_list(void);
	inline Array<float, 3> grid(void);
	inline void grid(float values[3]);
	inline Array<float, 3> frame_current(void);
	inline void frame_current(float values[3]);
	inline Array<float, 3> value_sliders(void);
	inline void value_sliders(float values[3]);
	inline Array<float, 3> view_sliders(void);
	inline void view_sliders(float values[3]);
	inline Array<float, 3> dopesheet_channel(void);
	inline void dopesheet_channel(float values[3]);
	inline Array<float, 3> dopesheet_subchannel(void);
	inline void dopesheet_subchannel(float values[3]);
	inline Array<float, 3> channels(void);
	inline void channels(float values[3]);
	inline Array<float, 3> channels_selected(void);
	inline void channels_selected(float values[3]);
	inline Array<float, 3> channel_group(void);
	inline void channel_group(float values[3]);
	inline Array<float, 3> active_channels_group(void);
	inline void active_channels_group(float values[3]);
	inline Array<float, 3> long_key(void);
	inline void long_key(float values[3]);
	inline Array<float, 3> long_key_selected(void);
	inline void long_key_selected(float values[3]);
	inline Array<float, 3> keyframe(void);
	inline void keyframe(float values[3]);
	inline Array<float, 3> keyframe_selected(void);
	inline void keyframe_selected(float values[3]);
	inline Array<float, 3> keyframe_extreme(void);
	inline void keyframe_extreme(float values[3]);
	inline Array<float, 3> keyframe_extreme_selected(void);
	inline void keyframe_extreme_selected(float values[3]);
	inline Array<float, 3> keyframe_breakdown(void);
	inline void keyframe_breakdown(float values[3]);
	inline Array<float, 3> keyframe_breakdown_selected(void);
	inline void keyframe_breakdown_selected(float values[3]);
	inline Array<float, 3> keyframe_jitter(void);
	inline void keyframe_jitter(float values[3]);
	inline Array<float, 3> keyframe_jitter_selected(void);
	inline void keyframe_jitter_selected(float values[3]);
	inline Array<float, 4> keyframe_border(void);
	inline void keyframe_border(float values[4]);
	inline Array<float, 4> keyframe_border_selected(void);
	inline void keyframe_border_selected(float values[4]);
	inline Array<float, 4> summary(void);
	inline void summary(float values[4]);

};

/**************** Theme Image Editor ****************/

class ThemeImageEditor : public Pointer {
public:
	ThemeImageEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline Array<float, 3> vertex(void);
	inline void vertex(float values[3]);
	inline Array<float, 3> vertex_select(void);
	inline void vertex_select(float values[3]);
	inline int vertex_size(void);
	inline void vertex_size(int value);
	inline Array<float, 3> vertex_unreferenced(void);
	inline void vertex_unreferenced(float values[3]);
	inline Array<float, 4> face(void);
	inline void face(float values[4]);
	inline Array<float, 4> face_select(void);
	inline void face_select(float values[4]);
	inline Array<float, 3> face_dot(void);
	inline void face_dot(float values[3]);
	inline int facedot_size(void);
	inline void facedot_size(int value);
	inline Array<float, 4> freestyle_face_mark(void);
	inline void freestyle_face_mark(float values[4]);
	inline Array<float, 4> editmesh_active(void);
	inline void editmesh_active(float values[4]);
	inline Array<float, 3> wire_edit(void);
	inline void wire_edit(float values[3]);
	inline Array<float, 3> edge_select(void);
	inline void edge_select(float values[3]);
	inline Array<float, 4> scope_back(void);
	inline void scope_back(float values[4]);
	inline Array<float, 4> preview_stitch_face(void);
	inline void preview_stitch_face(float values[4]);
	inline Array<float, 4> preview_stitch_edge(void);
	inline void preview_stitch_edge(float values[4]);
	inline Array<float, 4> preview_stitch_vert(void);
	inline void preview_stitch_vert(float values[4]);
	inline Array<float, 4> preview_stitch_stitchable(void);
	inline void preview_stitch_stitchable(float values[4]);
	inline Array<float, 4> preview_stitch_unstitchable(void);
	inline void preview_stitch_unstitchable(float values[4]);
	inline Array<float, 4> preview_stitch_active(void);
	inline void preview_stitch_active(float values[4]);
	inline Array<float, 4> uv_shadow(void);
	inline void uv_shadow(float values[4]);
	inline Array<float, 4> uv_others(void);
	inline void uv_others(float values[4]);
	inline Array<float, 3> frame_current(void);
	inline void frame_current(float values[3]);
	inline Array<float, 3> handle_free(void);
	inline void handle_free(float values[3]);
	inline Array<float, 3> handle_auto(void);
	inline void handle_auto(float values[3]);
	inline Array<float, 3> handle_align(void);
	inline void handle_align(float values[3]);
	inline Array<float, 3> handle_sel_free(void);
	inline void handle_sel_free(float values[3]);
	inline Array<float, 3> handle_sel_auto(void);
	inline void handle_sel_auto(float values[3]);
	inline Array<float, 3> handle_sel_align(void);
	inline void handle_sel_align(float values[3]);
	inline Array<float, 3> handle_auto_clamped(void);
	inline void handle_auto_clamped(float values[3]);
	inline Array<float, 3> handle_sel_auto_clamped(void);
	inline void handle_sel_auto_clamped(float values[3]);
	inline Array<float, 3> handle_vertex(void);
	inline void handle_vertex(float values[3]);
	inline Array<float, 3> handle_vertex_select(void);
	inline void handle_vertex_select(float values[3]);
	inline int handle_vertex_size(void);
	inline void handle_vertex_size(int value);
	inline Array<float, 4> paint_curve_handle(void);
	inline void paint_curve_handle(float values[4]);
	inline Array<float, 4> paint_curve_pivot(void);
	inline void paint_curve_pivot(float values[4]);

};

/**************** Theme Sequence Editor ****************/

class ThemeSequenceEditor : public Pointer {
public:
	ThemeSequenceEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline Array<float, 3> grid(void);
	inline void grid(float values[3]);
	inline Array<float, 3> window_sliders(void);
	inline void window_sliders(float values[3]);
	inline Array<float, 3> movie_strip(void);
	inline void movie_strip(float values[3]);
	inline Array<float, 3> movieclip_strip(void);
	inline void movieclip_strip(float values[3]);
	inline Array<float, 3> image_strip(void);
	inline void image_strip(float values[3]);
	inline Array<float, 3> scene_strip(void);
	inline void scene_strip(float values[3]);
	inline Array<float, 3> audio_strip(void);
	inline void audio_strip(float values[3]);
	inline Array<float, 3> effect_strip(void);
	inline void effect_strip(float values[3]);
	inline Array<float, 3> transition_strip(void);
	inline void transition_strip(float values[3]);
	inline Array<float, 3> meta_strip(void);
	inline void meta_strip(float values[3]);
	inline Array<float, 3> frame_current(void);
	inline void frame_current(float values[3]);
	inline Array<float, 3> keyframe(void);
	inline void keyframe(float values[3]);
	inline Array<float, 3> draw_action(void);
	inline void draw_action(float values[3]);
	inline Array<float, 3> preview_back(void);
	inline void preview_back(float values[3]);

};

/**************** Theme Properties ****************/

class ThemeProperties : public Pointer {
public:
	ThemeProperties(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);

};

/**************** Theme Text Editor ****************/

class ThemeTextEditor : public Pointer {
public:
	ThemeTextEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline Array<float, 3> line_numbers_background(void);
	inline void line_numbers_background(float values[3]);
	inline Array<float, 3> selected_text(void);
	inline void selected_text(float values[3]);
	inline Array<float, 3> cursor(void);
	inline void cursor(float values[3]);
	inline Array<float, 3> syntax_builtin(void);
	inline void syntax_builtin(float values[3]);
	inline Array<float, 3> syntax_symbols(void);
	inline void syntax_symbols(float values[3]);
	inline Array<float, 3> syntax_special(void);
	inline void syntax_special(float values[3]);
	inline Array<float, 3> syntax_preprocessor(void);
	inline void syntax_preprocessor(float values[3]);
	inline Array<float, 3> syntax_reserved(void);
	inline void syntax_reserved(float values[3]);
	inline Array<float, 3> syntax_comment(void);
	inline void syntax_comment(float values[3]);
	inline Array<float, 3> syntax_string(void);
	inline void syntax_string(float values[3]);
	inline Array<float, 3> syntax_numbers(void);
	inline void syntax_numbers(float values[3]);

};

/**************** Theme Timeline ****************/

class ThemeTimeline : public Pointer {
public:
	ThemeTimeline(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline Array<float, 3> grid(void);
	inline void grid(float values[3]);
	inline Array<float, 3> frame_current(void);
	inline void frame_current(float values[3]);

};

/**************** Theme Node Editor ****************/

class ThemeNodeEditor : public Pointer {
public:
	ThemeNodeEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline ThemeSpaceListGeneric space_list(void);
	inline Array<float, 3> node_selected(void);
	inline void node_selected(float values[3]);
	inline Array<float, 3> node_active(void);
	inline void node_active(float values[3]);
	inline Array<float, 3> wire(void);
	inline void wire(float values[3]);
	inline Array<float, 3> wire_inner(void);
	inline void wire_inner(float values[3]);
	inline Array<float, 3> wire_select(void);
	inline void wire_select(float values[3]);
	inline Array<float, 3> selected_text(void);
	inline void selected_text(float values[3]);
	inline Array<float, 4> node_backdrop(void);
	inline void node_backdrop(float values[4]);
	inline Array<float, 3> converter_node(void);
	inline void converter_node(float values[3]);
	inline Array<float, 3> color_node(void);
	inline void color_node(float values[3]);
	inline Array<float, 3> group_node(void);
	inline void group_node(float values[3]);
	inline Array<float, 3> group_socket_node(void);
	inline void group_socket_node(float values[3]);
	inline Array<float, 4> frame_node(void);
	inline void frame_node(float values[4]);
	inline Array<float, 3> matte_node(void);
	inline void matte_node(float values[3]);
	inline Array<float, 3> distor_node(void);
	inline void distor_node(float values[3]);
	inline int noodle_curving(void);
	inline void noodle_curving(int value);
	inline Array<float, 3> input_node(void);
	inline void input_node(float values[3]);
	inline Array<float, 3> output_node(void);
	inline void output_node(float values[3]);
	inline Array<float, 3> filter_node(void);
	inline void filter_node(float values[3]);
	inline Array<float, 3> vector_node(void);
	inline void vector_node(float values[3]);
	inline Array<float, 3> texture_node(void);
	inline void texture_node(float values[3]);
	inline Array<float, 3> shader_node(void);
	inline void shader_node(float values[3]);
	inline Array<float, 3> script_node(void);
	inline void script_node(float values[3]);
	inline Array<float, 3> pattern_node(void);
	inline void pattern_node(float values[3]);
	inline Array<float, 3> layout_node(void);
	inline void layout_node(float values[3]);

};

/**************** Theme Outliner ****************/

class ThemeOutliner : public Pointer {
public:
	ThemeOutliner(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline Array<float, 3> match(void);
	inline void match(float values[3]);
	inline Array<float, 3> selected_highlight(void);
	inline void selected_highlight(float values[3]);

};

/**************** Theme Info ****************/

class ThemeInfo : public Pointer {
public:
	ThemeInfo(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline Array<float, 3> info_selected(void);
	inline void info_selected(float values[3]);
	inline Array<float, 3> info_selected_text(void);
	inline void info_selected_text(float values[3]);
	inline Array<float, 3> info_error(void);
	inline void info_error(float values[3]);
	inline Array<float, 3> info_error_text(void);
	inline void info_error_text(float values[3]);
	inline Array<float, 3> info_warning(void);
	inline void info_warning(float values[3]);
	inline Array<float, 3> info_warning_text(void);
	inline void info_warning_text(float values[3]);
	inline Array<float, 3> info_info(void);
	inline void info_info(float values[3]);
	inline Array<float, 3> info_info_text(void);
	inline void info_info_text(float values[3]);
	inline Array<float, 3> info_debug(void);
	inline void info_debug(float values[3]);
	inline Array<float, 3> info_debug_text(void);
	inline void info_debug_text(float values[3]);

};

/**************** Theme User Preferences ****************/

class ThemeUserPreferences : public Pointer {
public:
	ThemeUserPreferences(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);

};

/**************** Theme Console ****************/

class ThemeConsole : public Pointer {
public:
	ThemeConsole(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline Array<float, 3> line_output(void);
	inline void line_output(float values[3]);
	inline Array<float, 3> line_input(void);
	inline void line_input(float values[3]);
	inline Array<float, 3> line_info(void);
	inline void line_info(float values[3]);
	inline Array<float, 3> line_error(void);
	inline void line_error(float values[3]);
	inline Array<float, 3> cursor(void);
	inline void cursor(float values[3]);
	inline Array<float, 4> select(void);
	inline void select(float values[4]);

};

/**************** Theme Logic Editor ****************/

class ThemeLogicEditor : public Pointer {
public:
	ThemeLogicEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);

};

/**************** Theme Clip Editor ****************/

class ThemeClipEditor : public Pointer {
public:
	ThemeClipEditor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ThemeSpaceGeneric space(void);
	inline ThemeSpaceListGeneric space_list(void);
	inline Array<float, 3> marker_outline(void);
	inline void marker_outline(float values[3]);
	inline Array<float, 3> marker(void);
	inline void marker(float values[3]);
	inline Array<float, 3> active_marker(void);
	inline void active_marker(float values[3]);
	inline Array<float, 3> selected_marker(void);
	inline void selected_marker(float values[3]);
	inline Array<float, 3> disabled_marker(void);
	inline void disabled_marker(float values[3]);
	inline Array<float, 3> locked_marker(void);
	inline void locked_marker(float values[3]);
	inline Array<float, 3> path_before(void);
	inline void path_before(float values[3]);
	inline Array<float, 3> path_after(void);
	inline void path_after(float values[3]);
	inline Array<float, 3> frame_current(void);
	inline void frame_current(float values[3]);
	inline Array<float, 3> strips(void);
	inline void strips(float values[3]);
	inline Array<float, 3> strips_selected(void);
	inline void strips_selected(float values[3]);
	inline Array<float, 3> handle_free(void);
	inline void handle_free(float values[3]);
	inline Array<float, 3> handle_auto(void);
	inline void handle_auto(float values[3]);
	inline Array<float, 3> handle_align(void);
	inline void handle_align(float values[3]);
	inline Array<float, 3> handle_sel_free(void);
	inline void handle_sel_free(float values[3]);
	inline Array<float, 3> handle_sel_auto(void);
	inline void handle_sel_auto(float values[3]);
	inline Array<float, 3> handle_sel_align(void);
	inline void handle_sel_align(float values[3]);
	inline Array<float, 3> handle_auto_clamped(void);
	inline void handle_auto_clamped(float values[3]);
	inline Array<float, 3> handle_sel_auto_clamped(void);
	inline void handle_sel_auto_clamped(float values[3]);
	inline Array<float, 3> handle_vertex(void);
	inline void handle_vertex(float values[3]);
	inline Array<float, 3> handle_vertex_select(void);
	inline void handle_vertex_select(float values[3]);
	inline int handle_vertex_size(void);
	inline void handle_vertex_size(int value);

};

/**************** Theme Bone Color Set ****************/

class ThemeBoneColorSet : public Pointer {
public:
	ThemeBoneColorSet(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline Array<float, 3> select(void);
	inline void select(float values[3]);
	inline Array<float, 3> active(void);
	inline void active(float values[3]);
	inline bool show_colored_constraints(void);
	inline void show_colored_constraints(int value);

};

/**************** Theme ****************/

class Theme : public Pointer {
public:
	Theme(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		bone_color_sets(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum theme_area_enum {
		theme_area_USER_INTERFACE = 0,
		theme_area_STYLE = 19,
		theme_area_BONE_COLOR_SETS = 18,
		theme_area_VIEW_3D = 1,
		theme_area_TIMELINE = 2,
		theme_area_GRAPH_EDITOR = 3,
		theme_area_DOPESHEET_EDITOR = 4,
		theme_area_NLA_EDITOR = 5,
		theme_area_IMAGE_EDITOR = 6,
		theme_area_SEQUENCE_EDITOR = 7,
		theme_area_TEXT_EDITOR = 8,
		theme_area_NODE_EDITOR = 9,
		theme_area_LOGIC_EDITOR = 10,
		theme_area_PROPERTIES = 11,
		theme_area_OUTLINER = 12,
		theme_area_USER_PREFERENCES = 14,
		theme_area_INFO = 15,
		theme_area_FILE_BROWSER = 16,
		theme_area_CONSOLE = 17,
		theme_area_CLIP_EDITOR = 20,
	};
	inline theme_area_enum theme_area(void);
	inline void theme_area(theme_area_enum value);
	inline ThemeUserInterface user_interface(void);
	inline ThemeView3D view_3d(void);
	inline ThemeGraphEditor graph_editor(void);
	inline ThemeFileBrowser file_browser(void);
	inline ThemeNLAEditor nla_editor(void);
	inline ThemeDopeSheet dopesheet_editor(void);
	inline ThemeImageEditor image_editor(void);
	inline ThemeSequenceEditor sequence_editor(void);
	inline ThemeProperties properties(void);
	inline ThemeTextEditor text_editor(void);
	inline ThemeTimeline timeline(void);
	inline ThemeNodeEditor node_editor(void);
	inline ThemeLogicEditor logic_editor(void);
	inline ThemeOutliner outliner(void);
	inline ThemeInfo info(void);
	inline ThemeUserPreferences user_preferences(void);
	inline ThemeConsole console(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ThemeBoneColorSet, Theme, bone_color_sets, true, true, false)
	inline ThemeClipEditor clip_editor(void);

};

/**************** Solid Light ****************/

class UserSolidLight : public Pointer {
public:
	UserSolidLight(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use(void);
	inline void use(int value);
	inline Array<float, 3> direction(void);
	inline void direction(float values[3]);
	inline Array<float, 3> diffuse_color(void);
	inline void diffuse_color(float values[3]);
	inline Array<float, 3> specular_color(void);
	inline void specular_color(float values[3]);

};

/**************** Walk Navigation ****************/

class WalkNavigation : public Pointer {
public:
	WalkNavigation(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float mouse_speed(void);
	inline void mouse_speed(float value);
	inline float walk_speed(void);
	inline void walk_speed(float value);
	inline float walk_speed_factor(void);
	inline void walk_speed_factor(float value);
	inline float view_height(void);
	inline void view_height(float value);
	inline float jump_height(void);
	inline void jump_height(float value);
	inline float teleport_time(void);
	inline void teleport_time(float value);
	inline bool use_gravity(void);
	inline void use_gravity(int value);
	inline bool use_mouse_reverse(void);
	inline void use_mouse_reverse(int value);

};

/**************** User Preferences ****************/

class UserPreferences : public Pointer {
public:
	UserPreferences(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		themes(ptr_arg),
		ui_styles(ptr_arg),
		addons(ptr_arg),
		autoexec_paths(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum active_section_enum {
		active_section_INTERFACE = 0,
		active_section_EDITING = 1,
		active_section_INPUT = 5,
		active_section_ADDONS = 6,
		active_section_THEMES = 4,
		active_section_FILES = 2,
		active_section_SYSTEM = 3,
	};
	inline active_section_enum active_section(void);
	inline void active_section(active_section_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Theme, UserPreferences, themes, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ThemeStyle, UserPreferences, ui_styles, false, true, false)
	COLLECTION_PROPERTY(Addons, Addon, UserPreferences, addons, false, true, true)
	COLLECTION_PROPERTY(PathCompareCollection, PathCompare, UserPreferences, autoexec_paths, false, true, true)
	inline UserPreferencesView view(void);
	inline UserPreferencesEdit edit(void);
	inline UserPreferencesInput inputs(void);
	inline UserPreferencesFilePaths filepaths(void);
	inline UserPreferencesSystem system(void);

};

/**************** View & Controls ****************/

class UserPreferencesView : public Pointer {
public:
	UserPreferencesView(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool show_tooltips(void);
	inline void show_tooltips(int value);
	inline bool show_tooltips_python(void);
	inline void show_tooltips_python(int value);
	inline bool show_object_info(void);
	inline void show_object_info(int value);
	inline bool use_global_scene(void);
	inline void use_global_scene(int value);
	inline bool show_large_cursors(void);
	inline void show_large_cursors(int value);
	inline bool show_view_name(void);
	inline void show_view_name(int value);
	inline bool show_splash(void);
	inline void show_splash(int value);
	inline bool show_playback_fps(void);
	inline void show_playback_fps(int value);
	inline bool use_mouse_over_open(void);
	inline void use_mouse_over_open(int value);
	inline int open_toplevel_delay(void);
	inline void open_toplevel_delay(int value);
	inline int open_sublevel_delay(void);
	inline void open_sublevel_delay(int value);
	inline int pie_initial_timeout(void);
	inline void pie_initial_timeout(int value);
	inline int pie_animation_timeout(void);
	inline void pie_animation_timeout(int value);
	inline int pie_menu_radius(void);
	inline void pie_menu_radius(int value);
	inline int pie_menu_threshold(void);
	inline void pie_menu_threshold(int value);
	inline int pie_menu_confirm(void);
	inline void pie_menu_confirm(int value);
	inline bool use_quit_dialog(void);
	inline void use_quit_dialog(int value);
	inline int open_left_mouse_delay(void);
	inline void open_left_mouse_delay(int value);
	inline int open_right_mouse_delay(void);
	inline void open_right_mouse_delay(int value);
	inline bool show_column_layout(void);
	inline void show_column_layout(int value);
	inline bool use_directional_menus(void);
	inline void use_directional_menus(int value);
	inline bool use_global_pivot(void);
	inline void use_global_pivot(int value);
	inline bool use_mouse_depth_navigate(void);
	inline void use_mouse_depth_navigate(int value);
	inline bool use_mouse_depth_cursor(void);
	inline void use_mouse_depth_cursor(int value);
	inline bool use_camera_lock_parent(void);
	inline void use_camera_lock_parent(int value);
	inline bool use_zoom_to_mouse(void);
	inline void use_zoom_to_mouse(int value);
	inline bool use_auto_perspective(void);
	inline void use_auto_perspective(int value);
	inline bool use_rotate_around_active(void);
	inline void use_rotate_around_active(int value);
	inline bool show_mini_axis(void);
	inline void show_mini_axis(int value);
	inline int mini_axis_size(void);
	inline void mini_axis_size(int value);
	inline int mini_axis_brightness(void);
	inline void mini_axis_brightness(int value);
	inline int smooth_view(void);
	inline void smooth_view(int value);
	inline int rotation_angle(void);
	inline void rotation_angle(int value);
	inline bool show_manipulator(void);
	inline void show_manipulator(int value);
	inline int manipulator_size(void);
	inline void manipulator_size(int value);
	inline int manipulator_handle_size(void);
	inline void manipulator_handle_size(int value);
	inline int manipulator_hotspot(void);
	inline void manipulator_hotspot(int value);
	inline int object_origin_size(void);
	inline void object_origin_size(int value);
	inline int view2d_grid_spacing_min(void);
	inline void view2d_grid_spacing_min(int value);
	enum timecode_style_enum {
		timecode_style_MINIMAL = 0,
		timecode_style_SMPTE = 2,
		timecode_style_SMPTE_COMPACT = 1,
		timecode_style_MILLISECONDS = 3,
		timecode_style_SECONDS_ONLY = 4,
	};
	inline timecode_style_enum timecode_style(void);
	inline void timecode_style(timecode_style_enum value);

};

/**************** Edit Methods ****************/

class UserPreferencesEdit : public Pointer {
public:
	UserPreferencesEdit(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum material_link_enum {
		material_link_OBDATA = 0,
		material_link_OBJECT = 256,
	};
	inline material_link_enum material_link(void);
	inline void material_link(material_link_enum value);
	enum object_align_enum {
		object_align_WORLD = 0,
		object_align_VIEW = 524288,
	};
	inline object_align_enum object_align(void);
	inline void object_align(object_align_enum value);
	inline bool use_enter_edit_mode(void);
	inline void use_enter_edit_mode(int value);
	inline bool use_drag_immediately(void);
	inline void use_drag_immediately(int value);
	inline int undo_steps(void);
	inline void undo_steps(int value);
	inline int undo_memory_limit(void);
	inline void undo_memory_limit(int value);
	inline bool use_global_undo(void);
	inline void use_global_undo(int value);
	inline bool use_auto_keying(void);
	inline void use_auto_keying(int value);
	enum auto_keying_mode_enum {
		auto_keying_mode_ADD_REPLACE_KEYS = 3,
		auto_keying_mode_REPLACE_KEYS = 5,
	};
	inline auto_keying_mode_enum auto_keying_mode(void);
	inline void auto_keying_mode(auto_keying_mode_enum value);
	inline bool use_keyframe_insert_available(void);
	inline void use_keyframe_insert_available(int value);
	inline bool use_auto_keying_warning(void);
	inline void use_auto_keying_warning(int value);
	inline bool use_keyframe_insert_needed(void);
	inline void use_keyframe_insert_needed(int value);
	inline bool use_visual_keying(void);
	inline void use_visual_keying(int value);
	inline bool use_insertkey_xyz_to_rgb(void);
	inline void use_insertkey_xyz_to_rgb(int value);
	enum keyframe_new_interpolation_type_enum {
		keyframe_new_interpolation_type_CONSTANT = 0,
		keyframe_new_interpolation_type_LINEAR = 1,
		keyframe_new_interpolation_type_BEZIER = 2,
		keyframe_new_interpolation_type_SINE = 12,
		keyframe_new_interpolation_type_QUAD = 9,
		keyframe_new_interpolation_type_CUBIC = 6,
		keyframe_new_interpolation_type_QUART = 10,
		keyframe_new_interpolation_type_QUINT = 11,
		keyframe_new_interpolation_type_EXPO = 8,
		keyframe_new_interpolation_type_CIRC = 5,
		keyframe_new_interpolation_type_BACK = 3,
		keyframe_new_interpolation_type_BOUNCE = 4,
		keyframe_new_interpolation_type_ELASTIC = 7,
	};
	inline keyframe_new_interpolation_type_enum keyframe_new_interpolation_type(void);
	inline void keyframe_new_interpolation_type(keyframe_new_interpolation_type_enum value);
	enum keyframe_new_handle_type_enum {
		keyframe_new_handle_type_FREE = 0,
		keyframe_new_handle_type_VECTOR = 2,
		keyframe_new_handle_type_ALIGNED = 3,
		keyframe_new_handle_type_AUTO = 1,
		keyframe_new_handle_type_AUTO_CLAMPED = 4,
	};
	inline keyframe_new_handle_type_enum keyframe_new_handle_type(void);
	inline void keyframe_new_handle_type(keyframe_new_handle_type_enum value);
	inline bool use_negative_frames(void);
	inline void use_negative_frames(int value);
	inline float fcurve_unselected_alpha(void);
	inline void fcurve_unselected_alpha(float value);
	inline int grease_pencil_manhattan_distance(void);
	inline void grease_pencil_manhattan_distance(int value);
	inline int grease_pencil_euclidean_distance(void);
	inline void grease_pencil_euclidean_distance(int value);
	inline bool use_grease_pencil_smooth_stroke(void);
	inline void use_grease_pencil_smooth_stroke(int value);
	inline bool use_grease_pencil_simplify_stroke(void);
	inline void use_grease_pencil_simplify_stroke(int value);
	inline int grease_pencil_eraser_radius(void);
	inline void grease_pencil_eraser_radius(int value);
	inline Array<float, 4> grease_pencil_default_color(void);
	inline void grease_pencil_default_color(float values[4]);
	inline Array<float, 3> sculpt_paint_overlay_color(void);
	inline void sculpt_paint_overlay_color(float values[3]);
	inline bool use_duplicate_mesh(void);
	inline void use_duplicate_mesh(int value);
	inline bool use_duplicate_surface(void);
	inline void use_duplicate_surface(int value);
	inline bool use_duplicate_curve(void);
	inline void use_duplicate_curve(int value);
	inline bool use_duplicate_text(void);
	inline void use_duplicate_text(int value);
	inline bool use_duplicate_metaball(void);
	inline void use_duplicate_metaball(int value);
	inline bool use_duplicate_armature(void);
	inline void use_duplicate_armature(int value);
	inline bool use_duplicate_lamp(void);
	inline void use_duplicate_lamp(int value);
	inline bool use_duplicate_material(void);
	inline void use_duplicate_material(int value);
	inline bool use_duplicate_texture(void);
	inline void use_duplicate_texture(int value);
	inline bool use_duplicate_fcurve(void);
	inline void use_duplicate_fcurve(int value);
	inline bool use_duplicate_action(void);
	inline void use_duplicate_action(int value);
	inline bool use_duplicate_particle(void);
	inline void use_duplicate_particle(int value);

};

/**************** Input ****************/

class UserPreferencesInput : public Pointer {
public:
	UserPreferencesInput(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum select_mouse_enum {
		select_mouse_LEFT = 16384,
		select_mouse_RIGHT = 0,
	};
	inline select_mouse_enum select_mouse(void);
	inline void select_mouse(select_mouse_enum value);
	enum view_zoom_method_enum {
		view_zoom_method_CONTINUE = 0,
		view_zoom_method_DOLLY = 2,
		view_zoom_method_SCALE = 1,
	};
	inline view_zoom_method_enum view_zoom_method(void);
	inline void view_zoom_method(view_zoom_method_enum value);
	enum view_zoom_axis_enum {
		view_zoom_axis_VERTICAL = 0,
		view_zoom_axis_HORIZONTAL = 67108864,
	};
	inline view_zoom_axis_enum view_zoom_axis(void);
	inline void view_zoom_axis(view_zoom_axis_enum value);
	inline bool invert_mouse_zoom(void);
	inline void invert_mouse_zoom(int value);
	enum view_rotate_method_enum {
		view_rotate_method_TURNTABLE = 0,
		view_rotate_method_TRACKBALL = 32,
	};
	inline view_rotate_method_enum view_rotate_method(void);
	inline void view_rotate_method(view_rotate_method_enum value);
	inline bool use_mouse_continuous(void);
	inline void use_mouse_continuous(int value);
	enum navigation_mode_enum {
		navigation_mode_WALK = 0,
		navigation_mode_FLY = 1,
	};
	inline navigation_mode_enum navigation_mode(void);
	inline void navigation_mode(navigation_mode_enum value);
	inline WalkNavigation walk_navigation(void);
	inline int drag_threshold(void);
	inline void drag_threshold(int value);
	inline int tweak_threshold(void);
	inline void tweak_threshold(int value);
	inline float ndof_sensitivity(void);
	inline void ndof_sensitivity(float value);
	inline float ndof_orbit_sensitivity(void);
	inline void ndof_orbit_sensitivity(float value);
	inline bool ndof_pan_yz_swap_axis(void);
	inline void ndof_pan_yz_swap_axis(int value);
	inline bool ndof_zoom_invert(void);
	inline void ndof_zoom_invert(int value);
	inline bool ndof_show_guide(void);
	inline void ndof_show_guide(int value);
	enum ndof_view_navigate_method_enum {
		ndof_view_navigate_method_FREE = 0,
		ndof_view_navigate_method_ORBIT = 64,
	};
	inline ndof_view_navigate_method_enum ndof_view_navigate_method(void);
	inline void ndof_view_navigate_method(ndof_view_navigate_method_enum value);
	enum ndof_view_rotate_method_enum {
		ndof_view_rotate_method_TURNTABLE = 32768,
		ndof_view_rotate_method_TRACKBALL = 0,
	};
	inline ndof_view_rotate_method_enum ndof_view_rotate_method(void);
	inline void ndof_view_rotate_method(ndof_view_rotate_method_enum value);
	inline bool ndof_rotx_invert_axis(void);
	inline void ndof_rotx_invert_axis(int value);
	inline bool ndof_roty_invert_axis(void);
	inline void ndof_roty_invert_axis(int value);
	inline bool ndof_rotz_invert_axis(void);
	inline void ndof_rotz_invert_axis(int value);
	inline bool ndof_panx_invert_axis(void);
	inline void ndof_panx_invert_axis(int value);
	inline bool ndof_pany_invert_axis(void);
	inline void ndof_pany_invert_axis(int value);
	inline bool ndof_panz_invert_axis(void);
	inline void ndof_panz_invert_axis(int value);
	inline bool ndof_lock_horizon(void);
	inline void ndof_lock_horizon(int value);
	inline bool ndof_fly_helicopter(void);
	inline void ndof_fly_helicopter(int value);
	inline int mouse_double_click_time(void);
	inline void mouse_double_click_time(int value);
	inline bool use_mouse_emulate_3_button(void);
	inline void use_mouse_emulate_3_button(int value);
	inline bool use_emulate_numpad(void);
	inline void use_emulate_numpad(int value);
	inline bool use_mouse_mmb_paste(void);
	inline void use_mouse_mmb_paste(int value);
	inline bool invert_zoom_wheel(void);
	inline void invert_zoom_wheel(int value);
	inline int wheel_scroll_lines(void);
	inline void wheel_scroll_lines(int value);
	inline bool use_trackpad_natural(void);
	inline void use_trackpad_natural(int value);
	inline std::string active_keyconfig(void);	inline void active_keyconfig(const std::string& value);

};

/**************** File Paths ****************/

class UserPreferencesFilePaths : public Pointer {
public:
	UserPreferencesFilePaths(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool show_hidden_files_datablocks(void);
	inline void show_hidden_files_datablocks(int value);
	inline bool use_filter_files(void);
	inline void use_filter_files(int value);
	inline bool hide_recent_locations(void);
	inline void hide_recent_locations(int value);
	inline bool hide_system_bookmarks(void);
	inline void hide_system_bookmarks(int value);
	inline bool show_thumbnails(void);
	inline void show_thumbnails(int value);
	inline bool use_relative_paths(void);
	inline void use_relative_paths(int value);
	inline bool use_file_compression(void);
	inline void use_file_compression(int value);
	inline bool use_load_ui(void);
	inline void use_load_ui(int value);
	inline std::string font_directory(void);	inline void font_directory(const std::string& value);
	inline std::string texture_directory(void);	inline void texture_directory(const std::string& value);
	inline std::string render_output_directory(void);	inline void render_output_directory(const std::string& value);
	inline std::string script_directory(void);	inline void script_directory(const std::string& value);
	inline std::string i18n_branches_directory(void);	inline void i18n_branches_directory(const std::string& value);
	inline std::string sound_directory(void);	inline void sound_directory(const std::string& value);
	inline std::string temporary_directory(void);	inline void temporary_directory(const std::string& value);
	inline std::string render_cache_directory(void);	inline void render_cache_directory(const std::string& value);
	inline std::string image_editor(void);	inline void image_editor(const std::string& value);
	inline std::string animation_player(void);	inline void animation_player(const std::string& value);
	enum animation_player_preset_enum {
		animation_player_preset_INTERNAL = 0,
		animation_player_preset_DJV = 2,
		animation_player_preset_FRAMECYCLER = 3,
		animation_player_preset_RV = 4,
		animation_player_preset_MPLAYER = 5,
		animation_player_preset_CUSTOM = 50,
	};
	inline animation_player_preset_enum animation_player_preset(void);
	inline void animation_player_preset(animation_player_preset_enum value);
	inline int save_version(void);
	inline void save_version(int value);
	inline bool use_auto_save_temporary_files(void);
	inline void use_auto_save_temporary_files(int value);
	inline int auto_save_time(void);
	inline void auto_save_time(int value);
	inline bool use_keep_session(void);
	inline void use_keep_session(int value);
	inline int recent_files(void);
	inline void recent_files(int value);
	inline bool use_save_preview_images(void);
	inline void use_save_preview_images(int value);

};

/**************** System & OpenGL ****************/

class UserPreferencesSystem : public Pointer {
public:
	UserPreferencesSystem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		solid_lights(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_international_fonts(void);
	inline void use_international_fonts(int value);
	inline int dpi(void);
	inline void dpi(int value);
	enum virtual_pixel_mode_enum {
		virtual_pixel_mode_NATIVE = 0,
		virtual_pixel_mode_DOUBLE = 1,
	};
	inline virtual_pixel_mode_enum virtual_pixel_mode(void);
	inline void virtual_pixel_mode(virtual_pixel_mode_enum value);
	inline std::string font_path_ui(void);	inline void font_path_ui(const std::string& value);
	inline int scrollback(void);
	inline void scrollback(int value);
	inline std::string author(void);	inline void author(const std::string& value);
	enum language_enum {
		language_DEFAULT = 0,
	};
	inline language_enum language(void);
	inline void language(language_enum value);
	inline bool use_translate_tooltips(void);
	inline void use_translate_tooltips(int value);
	inline bool use_translate_interface(void);
	inline void use_translate_interface(int value);
	inline bool use_translate_new_dataname(void);
	inline void use_translate_new_dataname(int value);
	inline bool use_textured_fonts(void);
	inline void use_textured_fonts(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, UserSolidLight, UserPreferencesSystem, solid_lights, true, true, false)
	inline bool use_weight_color_range(void);
	inline void use_weight_color_range(int value);
	inline ColorRamp weight_color_range(void);
	enum color_picker_type_enum {
		color_picker_type_CIRCLE_HSV = 0,
		color_picker_type_CIRCLE_HSL = 4,
		color_picker_type_SQUARE_SV = 1,
		color_picker_type_SQUARE_HS = 2,
		color_picker_type_SQUARE_HV = 3,
	};
	inline color_picker_type_enum color_picker_type(void);
	inline void color_picker_type(color_picker_type_enum value);
	inline bool use_preview_images(void);
	inline void use_preview_images(int value);
	inline bool use_scripts_auto_execute(void);
	inline void use_scripts_auto_execute(int value);
	inline bool use_tabs_as_spaces(void);
	inline void use_tabs_as_spaces(int value);
	inline int prefetch_frames(void);
	inline void prefetch_frames(int value);
	inline int memory_cache_limit(void);
	inline void memory_cache_limit(int value);
	inline int frame_server_port(void);
	inline void frame_server_port(int value);
	inline float gl_clip_alpha(void);
	inline void gl_clip_alpha(float value);
	inline bool use_mipmaps(void);
	inline void use_mipmaps(int value);
	inline bool use_16bit_textures(void);
	inline void use_16bit_textures(int value);
	inline bool use_gpu_mipmap(void);
	inline void use_gpu_mipmap(int value);
	enum image_draw_method_enum {
		image_draw_method_2DTEXTURE = 2,
		image_draw_method_GLSL = 1,
		image_draw_method_DRAWPIXELS = 3,
	};
	inline image_draw_method_enum image_draw_method(void);
	inline void image_draw_method(image_draw_method_enum value);
	inline bool use_vertex_buffer_objects(void);
	inline void use_vertex_buffer_objects(int value);
	enum anisotropic_filter_enum {
		anisotropic_filter_FILTER_0 = 1,
		anisotropic_filter_FILTER_2 = 2,
		anisotropic_filter_FILTER_4 = 4,
		anisotropic_filter_FILTER_8 = 8,
		anisotropic_filter_FILTER_16 = 16,
	};
	inline anisotropic_filter_enum anisotropic_filter(void);
	inline void anisotropic_filter(anisotropic_filter_enum value);
	enum gl_texture_limit_enum {
		gl_texture_limit_CLAMP_OFF = 0,
		gl_texture_limit_CLAMP_8192 = 8192,
		gl_texture_limit_CLAMP_4096 = 4096,
		gl_texture_limit_CLAMP_2048 = 2048,
		gl_texture_limit_CLAMP_1024 = 1024,
		gl_texture_limit_CLAMP_512 = 512,
		gl_texture_limit_CLAMP_256 = 256,
		gl_texture_limit_CLAMP_128 = 128,
	};
	inline gl_texture_limit_enum gl_texture_limit(void);
	inline void gl_texture_limit(gl_texture_limit_enum value);
	inline int texture_time_out(void);
	inline void texture_time_out(int value);
	inline int texture_collection_rate(void);
	inline void texture_collection_rate(int value);
	enum window_draw_method_enum {
		window_draw_method_AUTOMATIC = 3,
		window_draw_method_TRIPLE_BUFFER = 0,
		window_draw_method_OVERLAP = 1,
		window_draw_method_OVERLAP_FLIP = 4,
		window_draw_method_FULL = 2,
	};
	inline window_draw_method_enum window_draw_method(void);
	inline void window_draw_method(window_draw_method_enum value);
	enum audio_mixing_buffer_enum {
		audio_mixing_buffer_SAMPLES_256 = 256,
		audio_mixing_buffer_SAMPLES_512 = 512,
		audio_mixing_buffer_SAMPLES_1024 = 1024,
		audio_mixing_buffer_SAMPLES_2048 = 2048,
		audio_mixing_buffer_SAMPLES_4096 = 4096,
		audio_mixing_buffer_SAMPLES_8192 = 8192,
		audio_mixing_buffer_SAMPLES_16384 = 16384,
		audio_mixing_buffer_SAMPLES_32768 = 32768,
	};
	inline audio_mixing_buffer_enum audio_mixing_buffer(void);
	inline void audio_mixing_buffer(audio_mixing_buffer_enum value);
	enum audio_device_enum {
		audio_device_NONE = 0,
	};
	inline audio_device_enum audio_device(void);
	inline void audio_device(audio_device_enum value);
	enum audio_sample_rate_enum {
		audio_sample_rate_RATE_44100 = 44100,
		audio_sample_rate_RATE_48000 = 48000,
		audio_sample_rate_RATE_96000 = 96000,
		audio_sample_rate_RATE_192000 = 192000,
	};
	inline audio_sample_rate_enum audio_sample_rate(void);
	inline void audio_sample_rate(audio_sample_rate_enum value);
	enum audio_sample_format_enum {
		audio_sample_format_U8 = 1,
		audio_sample_format_S16 = 18,
		audio_sample_format_S24 = 19,
		audio_sample_format_S32 = 20,
		audio_sample_format_FLOAT = 36,
		audio_sample_format_DOUBLE = 40,
	};
	inline audio_sample_format_enum audio_sample_format(void);
	inline void audio_sample_format(audio_sample_format_enum value);
	enum audio_channels_enum {
		audio_channels_MONO = 1,
		audio_channels_STEREO = 2,
		audio_channels_SURROUND4 = 4,
		audio_channels_SURROUND51 = 6,
		audio_channels_SURROUND71 = 8,
	};
	inline audio_channels_enum audio_channels(void);
	inline void audio_channels(audio_channels_enum value);
	inline int screencast_fps(void);
	inline void screencast_fps(int value);
	inline int screencast_wait_time(void);
	inline void screencast_wait_time(int value);
	inline bool use_text_antialiasing(void);
	inline void use_text_antialiasing(int value);
	enum select_method_enum {
		select_method_AUTO = 0,
		select_method_GL_SELECT = 2,
		select_method_GL_QUERY = 1,
	};
	inline select_method_enum select_method(void);
	inline void select_method(select_method_enum value);
	enum multi_sample_enum {
		multi_sample_NONE = 0,
		multi_sample_2 = 2,
		multi_sample_4 = 4,
		multi_sample_8 = 8,
		multi_sample_16 = 16,
	};
	inline multi_sample_enum multi_sample(void);
	inline void multi_sample(multi_sample_enum value);
	inline bool use_region_overlap(void);
	inline void use_region_overlap(int value);

	inline int is_occlusion_query_supported();
};

/**************** Addon ****************/

class Addon : public Pointer {
public:
	Addon(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string module(void);	inline void module(const std::string& value);
	inline AddonPreferences preferences(void);

};

/**************** Addon Preferences ****************/

class AddonPreferences : public Pointer {
public:
	AddonPreferences(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);

};

/**************** Path Compare ****************/

class PathCompare : public Pointer {
public:
	PathCompare(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string path(void);	inline void path(const std::string& value);
	inline bool use_glob(void);
	inline void use_glob(int value);

};

/**************** Vector Font ****************/

class VectorFont : public ID {
public:
	VectorFont(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	inline std::string filepath(void);	inline void filepath(const std::string& value);
	inline PackedFile packed_file(void);

};

/**************** Operator ****************/

class Operator : public Pointer {
public:
	Operator(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline OperatorProperties properties(void);
	inline bool has_reports(void);
	inline void has_reports(int value);
	inline UILayout layout(void);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);	inline void bl_label(const std::string& value);
	inline std::string bl_translation_context(void);	inline void bl_translation_context(const std::string& value);
	inline std::string bl_description(void);	inline void bl_description(const std::string& value);
	enum bl_options_enum {
		bl_options_REGISTER = 1,
		bl_options_UNDO = 2,
		bl_options_BLOCKING = 4,
		bl_options_MACRO = 8,
		bl_options_GRAB_POINTER = 16,
		bl_options_PRESET = 32,
		bl_options_INTERNAL = 64,
	};
	inline bl_options_enum bl_options(void);
	inline void bl_options(bl_options_enum value);

	inline void report(int type, const char * message);
};

/**************** Operator Properties ****************/

class OperatorProperties : public Pointer {
public:
	OperatorProperties(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Operator Mouse Path ****************/

class OperatorMousePath : public PropertyGroup {
public:
	OperatorMousePath(const PointerRNA &ptr_arg) :
		PropertyGroup(ptr_arg)
		{}


};

/**************** Operator File List Element ****************/

class OperatorFileListElement : public PropertyGroup {
public:
	OperatorFileListElement(const PointerRNA &ptr_arg) :
		PropertyGroup(ptr_arg)
		{}


};

/**************** Macro Operator ****************/

class Macro : public Pointer {
public:
	Macro(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	inline OperatorProperties properties(void);
	inline std::string bl_idname(void);	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);	inline void bl_label(const std::string& value);
	inline std::string bl_translation_context(void);	inline void bl_translation_context(const std::string& value);
	inline std::string bl_description(void);	inline void bl_description(const std::string& value);
	enum bl_options_enum {
		bl_options_REGISTER = 1,
		bl_options_UNDO = 2,
		bl_options_BLOCKING = 4,
		bl_options_MACRO = 8,
		bl_options_GRAB_POINTER = 16,
		bl_options_PRESET = 32,
		bl_options_INTERNAL = 64,
	};
	inline bl_options_enum bl_options(void);
	inline void bl_options(bl_options_enum value);

	inline void report(int type, const char * message);
};

/**************** Operator Macro ****************/

class OperatorMacro : public Pointer {
public:
	OperatorMacro(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline OperatorProperties properties(void);

};

/**************** Event ****************/

class Event : public Pointer {
public:
	Event(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string ascii(void);	inline void ascii(const std::string& value);
	inline std::string unicode(void);	inline void unicode(const std::string& value);
	enum value_enum {
		value_ANY = -1,
		value_NOTHING = 0,
		value_PRESS = 1,
		value_RELEASE = 2,
		value_CLICK = 3,
		value_DOUBLE_CLICK = 4,
		value_NORTH = 1,
		value_NORTH_EAST = 2,
		value_EAST = 3,
		value_SOUTH_EAST = 4,
		value_SOUTH = 5,
		value_SOUTH_WEST = 6,
		value_WEST = 7,
		value_NORTH_WEST = 8,
	};
	inline value_enum value(void);
	inline void value(value_enum value);
	enum type_enum {
		type_NONE = 0,
		type_LEFTMOUSE = 1,
		type_MIDDLEMOUSE = 2,
		type_RIGHTMOUSE = 3,
		type_BUTTON4MOUSE = 7,
		type_BUTTON5MOUSE = 8,
		type_BUTTON6MOUSE = 18,
		type_BUTTON7MOUSE = 19,
		type_ACTIONMOUSE = 5,
		type_SELECTMOUSE = 6,
		type_MOUSEMOVE = 4,
		type_INBETWEEN_MOUSEMOVE = 17,
		type_TRACKPADPAN = 14,
		type_TRACKPADZOOM = 15,
		type_MOUSEROTATE = 16,
		type_WHEELUPMOUSE = 10,
		type_WHEELDOWNMOUSE = 11,
		type_WHEELINMOUSE = 12,
		type_WHEELOUTMOUSE = 13,
		type_EVT_TWEAK_L = 20483,
		type_EVT_TWEAK_M = 20484,
		type_EVT_TWEAK_R = 20485,
		type_EVT_TWEAK_A = 20486,
		type_EVT_TWEAK_S = 20487,
		type_A = 97,
		type_B = 98,
		type_C = 99,
		type_D = 100,
		type_E = 101,
		type_F = 102,
		type_G = 103,
		type_H = 104,
		type_I = 105,
		type_J = 106,
		type_K = 107,
		type_L = 108,
		type_M = 109,
		type_N = 110,
		type_O = 111,
		type_P = 112,
		type_Q = 113,
		type_R = 114,
		type_S = 115,
		type_T = 116,
		type_U = 117,
		type_V = 118,
		type_W = 119,
		type_X = 120,
		type_Y = 121,
		type_Z = 122,
		type_ZERO = 48,
		type_ONE = 49,
		type_TWO = 50,
		type_THREE = 51,
		type_FOUR = 52,
		type_FIVE = 53,
		type_SIX = 54,
		type_SEVEN = 55,
		type_EIGHT = 56,
		type_NINE = 57,
		type_LEFT_CTRL = 212,
		type_LEFT_ALT = 213,
		type_LEFT_SHIFT = 217,
		type_RIGHT_ALT = 214,
		type_RIGHT_CTRL = 215,
		type_RIGHT_SHIFT = 216,
		type_OSKEY = 172,
		type_GRLESS = 173,
		type_ESC = 218,
		type_TAB = 219,
		type_RET = 220,
		type_SPACE = 221,
		type_LINE_FEED = 222,
		type_BACK_SPACE = 223,
		type_DEL = 224,
		type_SEMI_COLON = 225,
		type_PERIOD = 226,
		type_COMMA = 227,
		type_QUOTE = 228,
		type_ACCENT_GRAVE = 229,
		type_MINUS = 230,
		type_SLASH = 232,
		type_BACK_SLASH = 233,
		type_EQUAL = 234,
		type_LEFT_BRACKET = 235,
		type_RIGHT_BRACKET = 236,
		type_LEFT_ARROW = 137,
		type_DOWN_ARROW = 138,
		type_RIGHT_ARROW = 139,
		type_UP_ARROW = 140,
		type_NUMPAD_2 = 152,
		type_NUMPAD_4 = 154,
		type_NUMPAD_6 = 156,
		type_NUMPAD_8 = 158,
		type_NUMPAD_1 = 151,
		type_NUMPAD_3 = 153,
		type_NUMPAD_5 = 155,
		type_NUMPAD_7 = 157,
		type_NUMPAD_9 = 159,
		type_NUMPAD_PERIOD = 199,
		type_NUMPAD_SLASH = 161,
		type_NUMPAD_ASTERIX = 160,
		type_NUMPAD_0 = 150,
		type_NUMPAD_MINUS = 162,
		type_NUMPAD_ENTER = 163,
		type_NUMPAD_PLUS = 164,
		type_F1 = 300,
		type_F2 = 301,
		type_F3 = 302,
		type_F4 = 303,
		type_F5 = 304,
		type_F6 = 305,
		type_F7 = 306,
		type_F8 = 307,
		type_F9 = 308,
		type_F10 = 309,
		type_F11 = 310,
		type_F12 = 311,
		type_F13 = 312,
		type_F14 = 313,
		type_F15 = 314,
		type_F16 = 315,
		type_F17 = 316,
		type_F18 = 317,
		type_F19 = 318,
		type_PAUSE = 165,
		type_INSERT = 166,
		type_HOME = 167,
		type_PAGE_UP = 168,
		type_PAGE_DOWN = 169,
		type_END = 170,
		type_MEDIA_PLAY = 174,
		type_MEDIA_STOP = 175,
		type_MEDIA_FIRST = 176,
		type_MEDIA_LAST = 177,
		type_TEXTINPUT = -2,
		type_WINDOW_DEACTIVATE = 260,
		type_TIMER = 272,
		type_TIMER0 = 273,
		type_TIMER1 = 274,
		type_TIMER2 = 275,
		type_TIMER_JOBS = 276,
		type_TIMER_AUTOSAVE = 277,
		type_TIMER_REPORT = 278,
		type_TIMERREGION = 279,
		type_NDOF_MOTION = 400,
		type_NDOF_BUTTON_MENU = 401,
		type_NDOF_BUTTON_FIT = 402,
		type_NDOF_BUTTON_TOP = 403,
		type_NDOF_BUTTON_BOTTOM = 404,
		type_NDOF_BUTTON_LEFT = 405,
		type_NDOF_BUTTON_RIGHT = 406,
		type_NDOF_BUTTON_FRONT = 407,
		type_NDOF_BUTTON_BACK = 408,
		type_NDOF_BUTTON_ISO1 = 409,
		type_NDOF_BUTTON_ISO2 = 410,
		type_NDOF_BUTTON_ROLL_CW = 411,
		type_NDOF_BUTTON_ROLL_CCW = 412,
		type_NDOF_BUTTON_SPIN_CW = 413,
		type_NDOF_BUTTON_SPIN_CCW = 414,
		type_NDOF_BUTTON_TILT_CW = 415,
		type_NDOF_BUTTON_TILT_CCW = 416,
		type_NDOF_BUTTON_ROTATE = 417,
		type_NDOF_BUTTON_PANZOOM = 418,
		type_NDOF_BUTTON_DOMINANT = 419,
		type_NDOF_BUTTON_PLUS = 420,
		type_NDOF_BUTTON_MINUS = 421,
		type_NDOF_BUTTON_ESC = 422,
		type_NDOF_BUTTON_ALT = 423,
		type_NDOF_BUTTON_SHIFT = 424,
		type_NDOF_BUTTON_CTRL = 425,
		type_NDOF_BUTTON_1 = 426,
		type_NDOF_BUTTON_2 = 427,
		type_NDOF_BUTTON_3 = 428,
		type_NDOF_BUTTON_4 = 429,
		type_NDOF_BUTTON_5 = 430,
		type_NDOF_BUTTON_6 = 431,
		type_NDOF_BUTTON_7 = 432,
		type_NDOF_BUTTON_8 = 433,
		type_NDOF_BUTTON_9 = 434,
		type_NDOF_BUTTON_10 = 435,
		type_NDOF_BUTTON_A = 436,
		type_NDOF_BUTTON_B = 437,
		type_NDOF_BUTTON_C = 438,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline int mouse_x(void);
	inline void mouse_x(int value);
	inline int mouse_y(void);
	inline void mouse_y(int value);
	inline int mouse_region_x(void);
	inline void mouse_region_x(int value);
	inline int mouse_region_y(void);
	inline void mouse_region_y(int value);
	inline int mouse_prev_x(void);
	inline void mouse_prev_x(int value);
	inline int mouse_prev_y(void);
	inline void mouse_prev_y(int value);
	inline float pressure(void);
	inline void pressure(float value);
	inline Array<float, 2> tilt(void);
	inline void tilt(float values[2]);
	inline bool is_tablet(void);
	inline void is_tablet(int value);
	inline bool shift(void);
	inline void shift(int value);
	inline bool ctrl(void);
	inline void ctrl(int value);
	inline bool alt(void);
	inline void alt(int value);
	inline bool oskey(void);
	inline void oskey(int value);

};

/**************** Timer ****************/

class Timer : public Pointer {
public:
	Timer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float time_step(void);
	inline void time_step(float value);
	inline float time_delta(void);
	inline void time_delta(float value);
	inline float time_duration(void);
	inline void time_duration(float value);

};

/**************** PopupMenu ****************/

class UIPopupMenu : public Pointer {
public:
	UIPopupMenu(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline UILayout layout(void);

};

/**************** PieMenu ****************/

class UIPieMenu : public Pointer {
public:
	UIPieMenu(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline UILayout layout(void);

};

/**************** Window ****************/

class Window : public Pointer {
public:
	Window(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Screen screen(void);
	inline int x(void);
	inline void x(int value);
	inline int y(void);
	inline void y(int value);
	inline int width(void);
	inline void width(int value);
	inline int height(void);
	inline void height(int value);

	inline void cursor_warp(int x, int y);
	inline void cursor_set(int cursor);
	inline void cursor_modal_set(int cursor);
	inline void cursor_modal_restore();
};

/**************** Window Manager ****************/

class WindowManager : public ID {
public:
	WindowManager(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		operators(ptr_arg),
		windows(ptr_arg),
		keyconfigs(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, Operator, WindowManager, operators, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Window, WindowManager, windows, false, true, false)
	COLLECTION_PROPERTY(KeyConfigurations, KeyConfig, WindowManager, keyconfigs, false, true, true)
	inline std::string clipboard(void);	inline void clipboard(const std::string& value);

	inline void fileselect_add(Context C, Operator operator_value);
	inline int modal_handler_add(Context C, Operator operator_value);
	inline Timer event_timer_add(float time_step, Window window);
	inline void event_timer_remove(Timer timer);
	inline void progress_begin(float min, float max);
	inline void progress_update(float value);
	inline void progress_end();
	inline int invoke_props_popup(Context C, Operator operator_value, Event event);
	inline int invoke_props_dialog(Context C, Operator operator_value, int width, int height);
	inline void invoke_search_popup(Context C, Operator operator_value);
	inline int invoke_popup(Context C, Operator operator_value, int width, int height);
	inline int invoke_confirm(Context C, Operator operator_value, Event event);
	inline UIPopupMenu pupmenu_begin__internal(Context C, const char * title, int icon);
	inline void pupmenu_end__internal(Context C, UIPopupMenu menu);
	inline UIPieMenu piemenu_begin__internal(Context C, const char * title, int icon, Event event);
	inline void piemenu_end__internal(Context C, UIPieMenu menu);
};

/**************** Key Configuration ****************/

class KeyConfig : public Pointer {
public:
	KeyConfig(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		keymaps(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	COLLECTION_PROPERTY(KeyMaps, KeyMap, KeyConfig, keymaps, false, true, true)
	inline bool is_user_defined(void);
	inline void is_user_defined(int value);

};

/**************** Key Map ****************/

class KeyMap : public Pointer {
public:
	KeyMap(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		keymap_items(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);	inline void name(const std::string& value);
	enum space_type_enum {
		space_type_EMPTY = 0,
		space_type_VIEW_3D = 1,
		space_type_TIMELINE = 15,
		space_type_GRAPH_EDITOR = 2,
		space_type_DOPESHEET_EDITOR = 12,
		space_type_NLA_EDITOR = 13,
		space_type_IMAGE_EDITOR = 6,
		space_type_SEQUENCE_EDITOR = 8,
		space_type_CLIP_EDITOR = 20,
		space_type_TEXT_EDITOR = 9,
		space_type_NODE_EDITOR = 16,
		space_type_LOGIC_EDITOR = 17,
		space_type_PROPERTIES = 4,
		space_type_OUTLINER = 3,
		space_type_USER_PREFERENCES = 19,
		space_type_INFO = 7,
		space_type_FILE_BROWSER = 5,
		space_type_CONSOLE = 18,
	};
	inline space_type_enum space_type(void);
	inline void space_type(space_type_enum value);
	enum region_type_enum {
		region_type_WINDOW = 0,
		region_type_HEADER = 1,
		region_type_CHANNELS = 2,
		region_type_TEMPORARY = 3,
		region_type_UI = 4,
		region_type_TOOLS = 5,
		region_type_TOOL_PROPS = 6,
		region_type_PREVIEW = 7,
	};
	inline region_type_enum region_type(void);
	inline void region_type(region_type_enum value);
	COLLECTION_PROPERTY(KeyMapItems, KeyMapItem, KeyMap, keymap_items, false, true, true)
	inline bool is_user_modified(void);
	inline void is_user_modified(int value);
	inline bool is_modal(void);
	inline void is_modal(int value);
	inline bool show_expanded_items(void);
	inline void show_expanded_items(int value);
	inline bool show_expanded_children(void);
	inline void show_expanded_children(int value);

	inline KeyMap active(Context C);
	inline void restore_to_default(Context C);
	inline void restore_item_to_default(Context C, KeyMapItem item);
};

/**************** Key Map Item ****************/

class KeyMapItem : public Pointer {
public:
	KeyMapItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string idname(void);	inline void idname(const std::string& value);
	inline std::string name(void);	inline void name(const std::string& value);
	inline OperatorProperties properties(void);
	enum map_type_enum {
		map_type_KEYBOARD = 0,
		map_type_TWEAK = 2,
		map_type_MOUSE = 1,
		map_type_NDOF = 5,
		map_type_TEXTINPUT = 3,
		map_type_TIMER = 4,
	};
	inline map_type_enum map_type(void);
	inline void map_type(map_type_enum value);
	enum type_enum {
		type_NONE = 0,
		type_LEFTMOUSE = 1,
		type_MIDDLEMOUSE = 2,
		type_RIGHTMOUSE = 3,
		type_BUTTON4MOUSE = 7,
		type_BUTTON5MOUSE = 8,
		type_BUTTON6MOUSE = 18,
		type_BUTTON7MOUSE = 19,
		type_ACTIONMOUSE = 5,
		type_SELECTMOUSE = 6,
		type_MOUSEMOVE = 4,
		type_INBETWEEN_MOUSEMOVE = 17,
		type_TRACKPADPAN = 14,
		type_TRACKPADZOOM = 15,
		type_MOUSEROTATE = 16,
		type_WHEELUPMOUSE = 10,
		type_WHEELDOWNMOUSE = 11,
		type_WHEELINMOUSE = 12,
		type_WHEELOUTMOUSE = 13,
		type_EVT_TWEAK_L = 20483,
		type_EVT_TWEAK_M = 20484,
		type_EVT_TWEAK_R = 20485,
		type_EVT_TWEAK_A = 20486,
		type_EVT_TWEAK_S = 20487,
		type_A = 97,
		type_B = 98,
		type_C = 99,
		type_D = 100,
		type_E = 101,
		type_F = 102,
		type_G = 103,
		type_H = 104,
		type_I = 105,
		type_J = 106,
		type_K = 107,
		type_L = 108,
		type_M = 109,
		type_N = 110,
		type_O = 111,
		type_P = 112,
		type_Q = 113,
		type_R = 114,
		type_S = 115,
		type_T = 116,
		type_U = 117,
		type_V = 118,
		type_W = 119,
		type_X = 120,
		type_Y = 121,
		type_Z = 122,
		type_ZERO = 48,
		type_ONE = 49,
		type_TWO = 50,
		type_THREE = 51,
		type_FOUR = 52,
		type_FIVE = 53,
		type_SIX = 54,
		type_SEVEN = 55,
		type_EIGHT = 56,
		type_NINE = 57,
		type_LEFT_CTRL = 212,
		type_LEFT_ALT = 213,
		type_LEFT_SHIFT = 217,
		type_RIGHT_ALT = 214,
		type_RIGHT_CTRL = 215,
		type_RIGHT_SHIFT = 216,
		type_OSKEY = 172,
		type_GRLESS = 173,
		type_ESC = 218,
		type_TAB = 219,
		type_RET = 220,
		type_SPACE = 221,
		type_LINE_FEED = 222,
		type_BACK_SPACE = 223,
		type_DEL = 224,
		type_SEMI_COLON = 225,
		type_PERIOD = 226,
		type_COMMA = 227,
		type_QUOTE = 228,
		type_ACCENT_GRAVE = 229,
		type_MINUS = 230,
		type_SLASH = 232,
		type_BACK_SLASH = 233,
		type_EQUAL = 234,
		type_LEFT_BRACKET = 235,
		type_RIGHT_BRACKET = 236,
		type_LEFT_ARROW = 137,
		type_DOWN_ARROW = 138,
		type_RIGHT_ARROW = 139,
		type_UP_ARROW = 140,
		type_NUMPAD_2 = 152,
		type_NUMPAD_4 = 154,
		type_NUMPAD_6 = 156,
		type_NUMPAD_8 = 158,
		type_NUMPAD_1 = 151,
		type_NUMPAD_3 = 153,
		type_NUMPAD_5 = 155,
		type_NUMPAD_7 = 157,
		type_NUMPAD_9 = 159,
		type_NUMPAD_PERIOD = 199,
		type_NUMPAD_SLASH = 161,
		type_NUMPAD_ASTERIX = 160,
		type_NUMPAD_0 = 150,
		type_NUMPAD_MINUS = 162,
		type_NUMPAD_ENTER = 163,
		type_NUMPAD_PLUS = 164,
		type_F1 = 300,
		type_F2 = 301,
		type_F3 = 302,
		type_F4 = 303,
		type_F5 = 304,
		type_F6 = 305,
		type_F7 = 306,
		type_F8 = 307,
		type_F9 = 308,
		type_F10 = 309,
		type_F11 = 310,
		type_F12 = 311,
		type_F13 = 312,
		type_F14 = 313,
		type_F15 = 314,
		type_F16 = 315,
		type_F17 = 316,
		type_F18 = 317,
		type_F19 = 318,
		type_PAUSE = 165,
		type_INSERT = 166,
		type_HOME = 167,
		type_PAGE_UP = 168,
		type_PAGE_DOWN = 169,
		type_END = 170,
		type_MEDIA_PLAY = 174,
		type_MEDIA_STOP = 175,
		type_MEDIA_FIRST = 176,
		type_MEDIA_LAST = 177,
		type_TEXTINPUT = -2,
		type_WINDOW_DEACTIVATE = 260,
		type_TIMER = 272,
		type_TIMER0 = 273,
		type_TIMER1 = 274,
		type_TIMER2 = 275,
		type_TIMER_JOBS = 276,
		type_TIMER_AUTOSAVE = 277,
		type_TIMER_REPORT = 278,
		type_TIMERREGION = 279,
		type_NDOF_MOTION = 400,
		type_NDOF_BUTTON_MENU = 401,
		type_NDOF_BUTTON_FIT = 402,
		type_NDOF_BUTTON_TOP = 403,
		type_NDOF_BUTTON_BOTTOM = 404,
		type_NDOF_BUTTON_LEFT = 405,
		type_NDOF_BUTTON_RIGHT = 406,
		type_NDOF_BUTTON_FRONT = 407,
		type_NDOF_BUTTON_BACK = 408,
		type_NDOF_BUTTON_ISO1 = 409,
		type_NDOF_BUTTON_ISO2 = 410,
		type_NDOF_BUTTON_ROLL_CW = 411,
		type_NDOF_BUTTON_ROLL_CCW = 412,
		type_NDOF_BUTTON_SPIN_CW = 413,
		type_NDOF_BUTTON_SPIN_CCW = 414,
		type_NDOF_BUTTON_TILT_CW = 415,
		type_NDOF_BUTTON_TILT_CCW = 416,
		type_NDOF_BUTTON_ROTATE = 417,
		type_NDOF_BUTTON_PANZOOM = 418,
		type_NDOF_BUTTON_DOMINANT = 419,
		type_NDOF_BUTTON_PLUS = 420,
		type_NDOF_BUTTON_MINUS = 421,
		type_NDOF_BUTTON_ESC = 422,
		type_NDOF_BUTTON_ALT = 423,
		type_NDOF_BUTTON_SHIFT = 424,
		type_NDOF_BUTTON_CTRL = 425,
		type_NDOF_BUTTON_1 = 426,
		type_NDOF_BUTTON_2 = 427,
		type_NDOF_BUTTON_3 = 428,
		type_NDOF_BUTTON_4 = 429,
		type_NDOF_BUTTON_5 = 430,
		type_NDOF_BUTTON_6 = 431,
		type_NDOF_BUTTON_7 = 432,
		type_NDOF_BUTTON_8 = 433,
		type_NDOF_BUTTON_9 = 434,
		type_NDOF_BUTTON_10 = 435,
		type_NDOF_BUTTON_A = 436,
		type_NDOF_BUTTON_B = 437,
		type_NDOF_BUTTON_C = 438,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum value_enum {
		value_ANY = -1,
		value_NOTHING = 0,
		value_PRESS = 1,
		value_RELEASE = 2,
		value_CLICK = 3,
		value_DOUBLE_CLICK = 4,
		value_NORTH = 1,
		value_NORTH_EAST = 2,
		value_EAST = 3,
		value_SOUTH_EAST = 4,
		value_SOUTH = 5,
		value_SOUTH_WEST = 6,
		value_WEST = 7,
		value_NORTH_WEST = 8,
	};
	inline value_enum value(void);
	inline void value(value_enum value);
	inline int id(void);
	inline void id(int value);
	inline bool any(void);
	inline void any(int value);
	inline bool shift(void);
	inline void shift(int value);
	inline bool ctrl(void);
	inline void ctrl(int value);
	inline bool alt(void);
	inline void alt(int value);
	inline bool oskey(void);
	inline void oskey(int value);
	enum key_modifier_enum {
		key_modifier_NONE = 0,
		key_modifier_LEFTMOUSE = 1,
		key_modifier_MIDDLEMOUSE = 2,
		key_modifier_RIGHTMOUSE = 3,
		key_modifier_BUTTON4MOUSE = 7,
		key_modifier_BUTTON5MOUSE = 8,
		key_modifier_BUTTON6MOUSE = 18,
		key_modifier_BUTTON7MOUSE = 19,
		key_modifier_ACTIONMOUSE = 5,
		key_modifier_SELECTMOUSE = 6,
		key_modifier_MOUSEMOVE = 4,
		key_modifier_INBETWEEN_MOUSEMOVE = 17,
		key_modifier_TRACKPADPAN = 14,
		key_modifier_TRACKPADZOOM = 15,
		key_modifier_MOUSEROTATE = 16,
		key_modifier_WHEELUPMOUSE = 10,
		key_modifier_WHEELDOWNMOUSE = 11,
		key_modifier_WHEELINMOUSE = 12,
		key_modifier_WHEELOUTMOUSE = 13,
		key_modifier_EVT_TWEAK_L = 20483,
		key_modifier_EVT_TWEAK_M = 20484,
		key_modifier_EVT_TWEAK_R = 20485,
		key_modifier_EVT_TWEAK_A = 20486,
		key_modifier_EVT_TWEAK_S = 20487,
		key_modifier_A = 97,
		key_modifier_B = 98,
		key_modifier_C = 99,
		key_modifier_D = 100,
		key_modifier_E = 101,
		key_modifier_F = 102,
		key_modifier_G = 103,
		key_modifier_H = 104,
		key_modifier_I = 105,
		key_modifier_J = 106,
		key_modifier_K = 107,
		key_modifier_L = 108,
		key_modifier_M = 109,
		key_modifier_N = 110,
		key_modifier_O = 111,
		key_modifier_P = 112,
		key_modifier_Q = 113,
		key_modifier_R = 114,
		key_modifier_S = 115,
		key_modifier_T = 116,
		key_modifier_U = 117,
		key_modifier_V = 118,
		key_modifier_W = 119,
		key_modifier_X = 120,
		key_modifier_Y = 121,
		key_modifier_Z = 122,
		key_modifier_ZERO = 48,
		key_modifier_ONE = 49,
		key_modifier_TWO = 50,
		key_modifier_THREE = 51,
		key_modifier_FOUR = 52,
		key_modifier_FIVE = 53,
		key_modifier_SIX = 54,
		key_modifier_SEVEN = 55,
		key_modifier_EIGHT = 56,
		key_modifier_NINE = 57,
		key_modifier_LEFT_CTRL = 212,
		key_modifier_LEFT_ALT = 213,
		key_modifier_LEFT_SHIFT = 217,
		key_modifier_RIGHT_ALT = 214,
		key_modifier_RIGHT_CTRL = 215,
		key_modifier_RIGHT_SHIFT = 216,
		key_modifier_OSKEY = 172,
		key_modifier_GRLESS = 173,
		key_modifier_ESC = 218,
		key_modifier_TAB = 219,
		key_modifier_RET = 220,
		key_modifier_SPACE = 221,
		key_modifier_LINE_FEED = 222,
		key_modifier_BACK_SPACE = 223,
		key_modifier_DEL = 224,
		key_modifier_SEMI_COLON = 225,
		key_modifier_PERIOD = 226,
		key_modifier_COMMA = 227,
		key_modifier_QUOTE = 228,
		key_modifier_ACCENT_GRAVE = 229,
		key_modifier_MINUS = 230,
		key_modifier_SLASH = 232,
		key_modifier_BACK_SLASH = 233,
		key_modifier_EQUAL = 234,
		key_modifier_LEFT_BRACKET = 235,
		key_modifier_RIGHT_BRACKET = 236,
		key_modifier_LEFT_ARROW = 137,
		key_modifier_DOWN_ARROW = 138,
		key_modifier_RIGHT_ARROW = 139,
		key_modifier_UP_ARROW = 140,
		key_modifier_NUMPAD_2 = 152,
		key_modifier_NUMPAD_4 = 154,
		key_modifier_NUMPAD_6 = 156,
		key_modifier_NUMPAD_8 = 158,
		key_modifier_NUMPAD_1 = 151,
		key_modifier_NUMPAD_3 = 153,
		key_modifier_NUMPAD_5 = 155,
		key_modifier_NUMPAD_7 = 157,
		key_modifier_NUMPAD_9 = 159,
		key_modifier_NUMPAD_PERIOD = 199,
		key_modifier_NUMPAD_SLASH = 161,
		key_modifier_NUMPAD_ASTERIX = 160,
		key_modifier_NUMPAD_0 = 150,
		key_modifier_NUMPAD_MINUS = 162,
		key_modifier_NUMPAD_ENTER = 163,
		key_modifier_NUMPAD_PLUS = 164,
		key_modifier_F1 = 300,
		key_modifier_F2 = 301,
		key_modifier_F3 = 302,
		key_modifier_F4 = 303,
		key_modifier_F5 = 304,
		key_modifier_F6 = 305,
		key_modifier_F7 = 306,
		key_modifier_F8 = 307,
		key_modifier_F9 = 308,
		key_modifier_F10 = 309,
		key_modifier_F11 = 310,
		key_modifier_F12 = 311,
		key_modifier_F13 = 312,
		key_modifier_F14 = 313,
		key_modifier_F1