
      module mo_setaer

      use shr_kind_mod, only : r8 => shr_kind_r8

      implicit none

      private
      public :: setaer

      save

      real(r8), parameter :: qext_so4(8,17) = reshape( (/  &                      ! m^2/gram (NH4)_2(SO4) 
            7.15_r8,  10.29_r8,  12.86_r8,  15.45_r8,  21.52_r8,  30.97_r8,  50.30_r8,  72.31_r8, &
            7.15_r8,  10.30_r8,  12.87_r8,  15.48_r8,  21.58_r8,  31.07_r8,  50.43_r8,  72.49_r8, &
            7.14_r8,  10.29_r8,  12.88_r8,  15.51_r8,  21.68_r8,  31.23_r8,  50.67_r8,  72.78_r8, &
            7.12_r8,  10.28_r8,  12.89_r8,  15.55_r8,  21.78_r8,  31.41_r8,  50.94_r8,  73.10_r8, &
            7.09_r8,  10.26_r8,  12.89_r8,  15.57_r8,  21.88_r8,  31.61_r8,  51.27_r8,  73.48_r8, &
            7.06_r8,  10.22_r8,  12.87_r8,  15.59_r8,  21.98_r8,  31.81_r8,  51.64_r8,  73.95_r8, &
            7.01_r8,  10.43_r8,  12.96_r8,  15.24_r8,  22.10_r8,  32.23_r8,  52.39_r8,  74.86_r8, &
            6.96_r8,  10.35_r8,  12.93_r8,  15.20_r8,  22.12_r8,  32.39_r8,  52.72_r8,  75.39_r8, &
            6.89_r8,  10.26_r8,  12.87_r8,  15.16_r8,  22.11_r8,  32.49_r8,  53.05_r8,  75.85_r8, &
            6.54_r8,   9.80_r8,  12.36_r8,  14.68_r8,  21.88_r8,  32.74_r8,  54.25_r8,  77.77_r8, &
            6.21_r8,   9.34_r8,  11.86_r8,  14.14_r8,  21.41_r8,  32.55_r8,  55.02_r8,  79.20_r8, &
            6.07_r8,   9.14_r8,  11.62_r8,  13.88_r8,  21.17_r8,  32.33_r8,  55.08_r8,  79.56_r8, &
            5.90_r8,   8.90_r8,  11.32_r8,  13.57_r8,  20.80_r8,  32.03_r8,  55.17_r8,  80.02_r8, &
            5.31_r8,   8.04_r8,  10.31_r8,  12.42_r8,  19.45_r8,  30.76_r8,  54.62_r8,  80.61_r8, &
            4.56_r8,   6.97_r8,   9.00_r8,  10.92_r8,  17.55_r8,  28.69_r8,  53.02_r8,  80.43_r8, &
            3.23_r8,   5.02_r8,   6.59_r8,   8.09_r8,  13.57_r8,  23.64_r8,  47.11_r8,  75.36_r8, &
            2.37_r8,   3.73_r8,   4.95_r8,   6.14_r8,  10.65_r8,  19.54_r8,  41.41_r8,  69.26_r8  &
            /),(/8,17/))

      real(r8), parameter :: qext_dso4(7,17) = qext_so4(2:8,:) - qext_so4(1:7,:)

      real(r8), parameter :: ssa_so4(8,17) = reshape( (/  &
        1.00000_r8,0.99907_r8,0.99855_r8,0.99810_r8,0.99724_r8,0.99623_r8,0.99469_r8,0.99340_r8, &
        1.00000_r8,0.99976_r8,0.99962_r8,0.99950_r8,0.99928_r8,0.99900_r8,0.99857_r8,0.99820_r8, &
        1.00000_r8,0.99996_r8,0.99994_r8,0.99992_r8,0.99989_r8,0.99984_r8,0.99978_r8,0.99971_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,0.99999_r8,0.99999_r8,0.99999_r8,0.99998_r8,0.99998_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,0.99999_r8,0.99999_r8,0.99999_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8  &
            /),(/8,17/))

      real(r8), parameter :: ssa_dso4(7,17) = ssa_so4(2:8,:) - ssa_so4(1:7,:)

      real(r8), parameter :: asm_so4(8,17) = reshape( (/ &
        0.67_r8,   0.68_r8,   0.68_r8,   0.68_r8,   0.69_r8,   0.70_r8,   0.71_r8,   0.73_r8, &
        0.67_r8,   0.68_r8,   0.68_r8,   0.68_r8,   0.69_r8,   0.70_r8,   0.72_r8,   0.73_r8, &
        0.67_r8,   0.68_r8,   0.69_r8,   0.69_r8,   0.70_r8,   0.70_r8,   0.72_r8,   0.73_r8, & 
        0.67_r8,   0.69_r8,   0.69_r8,   0.70_r8,   0.70_r8,   0.71_r8,   0.72_r8,   0.74_r8, &
        0.67_r8,   0.69_r8,   0.70_r8,   0.70_r8,   0.71_r8,   0.71_r8,   0.73_r8,   0.74_r8, &
        0.67_r8,   0.69_r8,   0.70_r8,   0.71_r8,   0.71_r8,   0.72_r8,   0.73_r8,   0.74_r8, &
        0.67_r8,   0.70_r8,   0.71_r8,   0.71_r8,   0.72_r8,   0.72_r8,   0.73_r8,   0.74_r8, &
        0.67_r8,   0.70_r8,   0.71_r8,   0.72_r8,   0.73_r8,   0.73_r8,   0.74_r8,   0.75_r8, &
        0.67_r8,   0.70_r8,   0.71_r8,   0.72_r8,   0.73_r8,   0.74_r8,   0.74_r8,   0.75_r8, &
        0.67_r8,   0.71_r8,   0.72_r8,   0.73_r8,   0.75_r8,   0.75_r8,   0.76_r8,   0.76_r8, &
        0.67_r8,   0.71_r8,   0.73_r8,   0.74_r8,   0.76_r8,   0.76_r8,   0.77_r8,   0.77_r8, &
        0.67_r8,   0.71_r8,   0.73_r8,   0.74_r8,   0.76_r8,   0.77_r8,   0.77_r8,   0.77_r8, &
        0.67_r8,   0.71_r8,   0.73_r8,   0.74_r8,   0.76_r8,   0.77_r8,   0.77_r8,   0.77_r8, &
        0.66_r8,   0.71_r8,   0.73_r8,   0.75_r8,   0.77_r8,   0.77_r8,   0.78_r8,   0.78_r8, &
        0.66_r8,   0.71_r8,   0.73_r8,   0.75_r8,   0.77_r8,   0.78_r8,   0.79_r8,   0.79_r8, &
        0.64_r8,   0.69_r8,   0.72_r8,   0.73_r8,   0.76_r8,   0.78_r8,   0.79_r8,   0.80_r8, &
        0.62_r8,   0.67_r8,   0.70_r8,   0.72_r8,   0.75_r8,   0.77_r8,   0.79_r8,   0.80_r8  &
            /),(/8,17/))

      real(r8), parameter :: asm_dso4(7,17) = asm_so4(2:8,:) - asm_so4(1:7,:)

      real(r8), parameter :: qext_ant(8,17) = reshape( (/ &                ! m^2/gram (NH4)NO3
         7.27_r8,  10.47_r8,  13.08_r8,  15.72_r8,  21.90_r8,  31.51_r8,  51.17_r8,  73.57_r8, &
         7.27_r8,  10.48_r8,  13.09_r8,  15.74_r8,  21.96_r8,  31.60_r8,  51.30_r8,  73.75_r8, &
         7.26_r8,  10.47_r8,  13.10_r8,  15.78_r8,  22.05_r8,  31.77_r8,  51.55_r8,  74.04_r8, &
         7.24_r8,  10.46_r8,  13.11_r8,  15.82_r8,  22.16_r8,  31.96_r8,  51.83_r8,  74.37_r8, &
         7.22_r8,  10.43_r8,  13.11_r8,  15.84_r8,  22.26_r8,  32.15_r8,  52.16_r8,  74.76_r8, &
         7.18_r8,  10.40_r8,  13.10_r8,  15.86_r8,  22.36_r8,  32.37_r8,  52.53_r8,  75.24_r8, &
         7.14_r8,  10.35_r8,  13.06_r8,  15.86_r8,  22.44_r8,  32.58_r8,  52.94_r8,  75.75_r8, &
         7.08_r8,  10.53_r8,  13.15_r8,  15.47_r8,  22.50_r8,  32.95_r8,  53.64_r8,  76.69_r8, &
         7.01_r8,  10.44_r8,  13.09_r8,  15.42_r8,  22.49_r8,  33.05_r8,  53.97_r8,  77.17_r8, &
         6.65_r8,   9.96_r8,  12.57_r8,  14.93_r8,  22.26_r8,  33.31_r8,  55.19_r8,  79.12_r8, &
         6.32_r8,   9.50_r8,  12.06_r8,  14.38_r8,  21.78_r8,  33.11_r8,  55.97_r8,  80.57_r8, &
         6.17_r8,   9.30_r8,  11.82_r8,  14.12_r8,  21.53_r8,  32.89_r8,  56.04_r8,  80.94_r8, &
         6.00_r8,   9.05_r8,  11.52_r8,  13.80_r8,  21.16_r8,  32.59_r8,  56.13_r8,  81.41_r8, &
         5.40_r8,   8.18_r8,  10.49_r8,  12.63_r8,  19.79_r8,  31.29_r8,  55.57_r8,  82.01_r8, &
         4.64_r8,   7.09_r8,   9.16_r8,  11.11_r8,  17.86_r8,  29.19_r8,  53.94_r8,  81.83_r8, &
         3.28_r8,   5.11_r8,   6.70_r8,   8.23_r8,  13.80_r8,  24.05_r8,  47.93_r8,  76.67_r8, &
         2.41_r8,   3.79_r8,   5.04_r8,   6.24_r8,  10.83_r8,  19.88_r8,  42.13_r8,  70.46_r8  &
            /),(/8,17/))
 
      real(r8), parameter :: qext_dant(7,17) = qext_ant(2:8,:) - qext_ant(1:7,:)

      real(r8), parameter :: ssa_ant(8,17) = reshape( (/ &
        1.00000_r8,0.99907_r8,0.99855_r8,0.99810_r8,0.99724_r8,0.99623_r8,0.99469_r8,0.99340_r8, &
        1.00000_r8,0.99976_r8,0.99962_r8,0.99950_r8,0.99928_r8,0.99900_r8,0.99857_r8,0.99820_r8, &
        1.00000_r8,0.99996_r8,0.99994_r8,0.99992_r8,0.99989_r8,0.99984_r8,0.99978_r8,0.99971_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,0.99999_r8,0.99999_r8,0.99999_r8,0.99998_r8,0.99998_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,0.99999_r8,0.99999_r8,0.99999_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
        1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8  &
            /),(/8,17/))

      real(r8), parameter :: ssa_dant(7,17) = ssa_ant(2:8,:) - ssa_ant(1:7,:)
 
      real(r8), parameter :: asm_ant(8,17) = reshape( (/ &
        0.67_r8,   0.68_r8,   0.68_r8,   0.68_r8,   0.69_r8,   0.70_r8,   0.71_r8,   0.73_r8, &
        0.67_r8,   0.68_r8,   0.68_r8,   0.68_r8,   0.69_r8,   0.70_r8,   0.72_r8,   0.73_r8, &
        0.67_r8,   0.68_r8,   0.69_r8,   0.69_r8,   0.70_r8,   0.70_r8,   0.72_r8,   0.73_r8, &
        0.67_r8,   0.69_r8,   0.69_r8,   0.70_r8,   0.70_r8,   0.71_r8,   0.72_r8,   0.74_r8, &
        0.67_r8,   0.69_r8,   0.70_r8,   0.70_r8,   0.71_r8,   0.71_r8,   0.73_r8,   0.74_r8, &
        0.67_r8,   0.69_r8,   0.70_r8,   0.71_r8,   0.71_r8,   0.72_r8,   0.73_r8,   0.74_r8, &
        0.67_r8,   0.70_r8,   0.71_r8,   0.71_r8,   0.72_r8,   0.72_r8,   0.73_r8,   0.74_r8, &
        0.67_r8,   0.70_r8,   0.71_r8,   0.72_r8,   0.73_r8,   0.73_r8,   0.74_r8,   0.75_r8, &
        0.67_r8,   0.70_r8,   0.71_r8,   0.72_r8,   0.73_r8,   0.74_r8,   0.74_r8,   0.75_r8, &
        0.67_r8,   0.71_r8,   0.72_r8,   0.73_r8,   0.75_r8,   0.75_r8,   0.76_r8,   0.76_r8, &
        0.67_r8,   0.71_r8,   0.73_r8,   0.74_r8,   0.76_r8,   0.76_r8,   0.77_r8,   0.77_r8, &
        0.67_r8,   0.71_r8,   0.73_r8,   0.74_r8,   0.76_r8,   0.77_r8,   0.77_r8,   0.77_r8, &
        0.67_r8,   0.71_r8,   0.73_r8,   0.74_r8,   0.76_r8,   0.77_r8,   0.77_r8,   0.77_r8, &
        0.66_r8,   0.71_r8,   0.73_r8,   0.75_r8,   0.77_r8,   0.77_r8,   0.78_r8,   0.78_r8, &
        0.66_r8,   0.71_r8,   0.73_r8,   0.75_r8,   0.77_r8,   0.78_r8,   0.79_r8,   0.79_r8, &
        0.64_r8,   0.69_r8,   0.72_r8,   0.73_r8,   0.76_r8,   0.78_r8,   0.79_r8,   0.80_r8, &
        0.62_r8,   0.67_r8,   0.70_r8,   0.72_r8,   0.75_r8,   0.77_r8,   0.79_r8,   0.80_r8  &
            /),(/8,17/))

      real(r8), parameter :: asm_dant(7,17) = asm_ant(2:8,:) - asm_ant(1:7,:)

!--------------------------------------------------------------------
!      dust: bin 1
!--------------------------------------------------------------------
      real(r8), parameter :: qext_ds1(17) =                            &
       (/ 1.99_r8,  1.99_r8,  1.99_r8,  1.99_r8, 2.00_r8,  2.00_r8, 2.00_r8, 2.01_r8,       &
          2.03_r8,  2.13_r8,  2.20_r8,  2.20_r8, 2.20_r8,  2.23_r8, 2.45_r8, 2.82_r8, 2.77_r8 /)

      real(r8), parameter  :: ssa_ds1(17) =                             &
       (/ 0.71575_r8, 0.71916_r8, 0.72437_r8, 0.73098_r8, 0.73895_r8, 0.74845_r8, 0.75953_r8, &
          0.77247_r8, 0.78667_r8, 0.84334_r8, 0.88486_r8, 0.89887_r8, 0.91254_r8, 0.94728_r8, &
          0.97546_r8, 0.99257_r8, 0.99627_r8 /)

      real(r8), parameter :: asm_ds1(17) =                            &
       (/ 0.81_r8, 0.80_r8, 0.80_r8, 0.79_r8, 0.78_r8, 0.78_r8, 0.77_r8, 0.76_r8, 0.75_r8, 0.71_r8,&
          0.68_r8, 0.67_r8, 0.65_r8, 0.62_r8, 0.62_r8, 0.68_r8, 0.69_r8 /)
!--------------------------------------------------------------------
!      dust: bin 2
!--------------------------------------------------------------------
      real(r8), parameter :: qext_ds2(17) =                              &
       (/ 0.77_r8, 0.77_r8, 0.77_r8, 0.77_r8, 0.78_r8, 0.78_r8, 0.78_r8, 0.79_r8, 0.79_r8, 0.79_r8, &
          0.79_r8, 0.80_r8, 0.81_r8, 0.84_r8, 0.84_r8, 0.84_r8, 0.92_r8 /)

      real(r8), parameter ::  ssa_ds2(17) =                               &
       (/0.59522_r8, 0.59816_r8, 0.60304_r8, 0.60951_r8, 0.61766_r8, 0.62757_r8, 0.63939_r8,&
         0.65308_r8, 0.66760_r8, 0.72707_r8, 0.78134_r8, 0.80412_r8, 0.82832_r8, 0.88852_r8,&
         0.93596_r8, 0.97452_r8, 0.98760_r8 /)

      real(r8), parameter :: asm_ds2(17) =                                &
       (/0.91_r8, 0.90_r8, 0.90_r8, 0.90_r8, 0.89_r8, 0.89_r8, 0.88_r8, 0.87_r8, 0.87_r8, 0.83_r8, &
         0.80_r8, 0.80_r8, 0.79_r8, 0.76_r8, 0.72_r8, 0.64_r8, 0.62_r8 /)
!--------------------------------------------------------------------
!      dust: bin 3
!--------------------------------------------------------------------
      real(r8), parameter :: qext_ds3(17) =                                    &
       (/0.36_r8, 0.36_r8, 0.36_r8, 0.36_r8, 0.36_r8, 0.36_r8, 0.36_r8, 0.36_r8, 0.36_r8, 0.36_r8, 0.37_r8, &
         0.37_r8, 0.37_r8, 0.37_r8, 0.37_r8, 0.38_r8, 0.38_r8 /)

      real(r8), parameter :: ssa_ds3(17) =                                          &
       (/0.54872_r8, 0.54937_r8, 0.55055_r8, 0.55244_r8, 0.55533_r8, 0.55919_r8, 0.56387_r8, 0.56968_r8, &
         0.57716_r8, 0.62358_r8, 0.67763_r8, 0.70405_r8, 0.73102_r8, 0.81296_r8, 0.88850_r8, 0.95481_r8, &
         0.97307_r8/)

      real(r8), parameter :: asm_ds3(17) =                                      &
       (/ 0.94_r8, 0.94_r8, 0.94_r8, 0.94_r8, 0.94_r8, 0.94_r8, 0.93_r8, 0.93_r8, 0.92_r8, 0.90_r8, 0.88_r8, &
          0.87_r8, 0.85_r8, 0.82_r8, 0.78_r8, 0.75_r8, 0.73_r8 /)

!--------------------------------------------------------------------
!      dust: bin 4
!--------------------------------------------------------------------
      real(r8), parameter :: qext_ds4(17) =           &
      (/0.18_r8, 0.18_r8, 0.18_r8, 0.18_r8, 0.18_r8, 0.18_r8, 0.18_r8, 0.19_r8, 0.19_r8, 0.19_r8, 0.19_r8, 0.19_r8, &
        0.19_r8, 0.19_r8, 0.19_r8, 0.19_r8, 0.20_r8 /)

      real(r8), parameter :: ssa_ds4(17) =            &
      (/0.55982_r8, 0.56067_r8, 0.56205_r8, 0.56381_r8, 0.56604_r8, 0.56911_r8, 0.57321_r8, 0.57809_r8, 0.58376_r8, &
        0.60863_r8, 0.62981_r8, 0.64251_r8, 0.65974_r8, 0.73256_r8, 0.82372_r8, 0.92454_r8, 0.95662_r8 /)

      real(r8), parameter :: asm_ds4(17) =           &
       (/ 0.94_r8, 0.94_r8, 0.94_r8, 0.94_r8, 0.94_r8, 0.93_r8, 0.93_r8, 0.93_r8, 0.93_r8, 0.91_r8, 0.91_r8, 0.90_r8, &
          0.89_r8, 0.87_r8, 0.83_r8, 0.79_r8, 0.77_r8 /)

!--------------------------------------------------------------------
! black carbon
!--------------------------------------------------------------------
      real(r8), parameter :: qext_cbs(8,17) = reshape( (/ & 
      26.47_r8,  26.47_r8,  26.47_r8,  68.55_r8,  54.51_r8,  68.55_r8,  93.69_r8, 128.49_r8, &
      26.35_r8,  26.35_r8,  26.35_r8,  67.19_r8,  53.53_r8,  67.19_r8,  91.62_r8, 125.62_r8, &
      26.15_r8,  26.15_r8,  26.15_r8,  65.24_r8,  52.13_r8,  65.24_r8,  88.62_r8, 121.44_r8, &
      25.89_r8,  25.89_r8,  25.89_r8,  63.07_r8,  50.57_r8,  63.07_r8,  85.27_r8, 116.72_r8, &
      25.59_r8,  25.59_r8,  25.59_r8,  60.75_r8,  48.90_r8,  60.75_r8,  81.69_r8, 111.62_r8, &
      25.23_r8,  25.23_r8,  25.23_r8,  58.35_r8,  47.17_r8,  58.35_r8,  77.96_r8, 106.29_r8, &
      24.82_r8,  24.82_r8,  24.82_r8,  55.92_r8,  45.41_r8,  55.92_r8,  74.20_r8, 100.86_r8, &
      24.36_r8,  24.36_r8,  24.36_r8,  53.51_r8,  43.65_r8,  53.51_r8,  70.46_r8,  95.43_r8, &
      23.89_r8,  23.89_r8,  23.89_r8,  51.24_r8,  41.98_r8,  51.24_r8,  66.95_r8,  90.33_r8, &
      21.92_r8,  21.92_r8,  21.92_r8,  43.84_r8,  36.46_r8,  43.84_r8,  55.67_r8,  73.81_r8, &
      20.35_r8,  20.35_r8,  20.35_r8,  39.12_r8,  32.87_r8,  39.12_r8,  48.65_r8,  63.58_r8, &
      19.59_r8,  19.59_r8,  19.59_r8,  37.26_r8,  31.38_r8,  37.26_r8,  46.12_r8,  60.08_r8, &
      18.52_r8,  18.52_r8,  18.52_r8,  34.78_r8,  29.37_r8,  34.78_r8,  42.83_r8,  55.62_r8, &
      15.51_r8,  15.51_r8,  15.51_r8,  28.14_r8,  23.92_r8,  28.14_r8,  34.14_r8,  43.91_r8, &
      12.45_r8,  12.45_r8,  12.45_r8,  21.75_r8,  18.64_r8,  21.75_r8,  25.93_r8,  32.95_r8, &
       8.38_r8,   8.38_r8,   8.38_r8,  13.90_r8,  12.07_r8,  13.90_r8,  16.12_r8,  20.04_r8, &
       6.13_r8,   6.13_r8,   6.13_r8,   9.74_r8,   8.56_r8,   9.74_r8,  11.00_r8,  13.35_r8  &
            /),(/8,17/))

      real(r8), parameter :: qext_dcbs(7,17) = qext_cbs(2:8,:) - qext_cbs(1:7,:)

      real(r8), parameter :: ssa_cbs(8,17) = reshape( (/ & 
      0.30538_r8,0.30538_r8,0.30538_r8,0.58171_r8,0.52858_r8,0.58171_r8,0.66772_r8,0.73300_r8, &
      0.30531_r8,0.30531_r8,0.30531_r8,0.57816_r8,0.52490_r8,0.57816_r8,0.66490_r8,0.73116_r8, &
      0.30524_r8,0.30524_r8,0.30524_r8,0.57281_r8,0.51947_r8,0.57281_r8,0.66041_r8,0.72800_r8, &
      0.30519_r8,0.30519_r8,0.30519_r8,0.56680_r8,0.51346_r8,0.56680_r8,0.65519_r8,0.72418_r8, &
      0.30520_r8,0.30520_r8,0.30520_r8,0.56029_r8,0.50707_r8,0.56029_r8,0.64937_r8,0.71979_r8, &
      0.30530_r8,0.30530_r8,0.30530_r8,0.55345_r8,0.50049_r8,0.55345_r8,0.64304_r8,0.71487_r8, &
      0.30552_r8,0.30552_r8,0.30552_r8,0.54644_r8,0.49387_r8,0.54644_r8,0.63633_r8,0.70948_r8, &
      0.30588_r8,0.30588_r8,0.30588_r8,0.53936_r8,0.48731_r8,0.53936_r8,0.62932_r8,0.70368_r8, &
      0.30637_r8,0.30637_r8,0.30637_r8,0.53261_r8,0.48117_r8,0.53261_r8,0.62241_r8,0.69779_r8, &
      0.30947_r8,0.30947_r8,0.30947_r8,0.50973_r8,0.46122_r8,0.50973_r8,0.59715_r8,0.67476_r8, &
      0.31199_r8,0.31199_r8,0.31199_r8,0.49449_r8,0.44836_r8,0.49449_r8,0.57921_r8,0.65742_r8, &
      0.30839_r8,0.30839_r8,0.30839_r8,0.48822_r8,0.44229_r8,0.48822_r8,0.57287_r8,0.65174_r8, &
      0.30122_r8,0.30122_r8,0.30122_r8,0.47923_r8,0.43325_r8,0.47923_r8,0.56425_r8,0.64429_r8, &
      0.27707_r8,0.27707_r8,0.27707_r8,0.44969_r8,0.40365_r8,0.44969_r8,0.53566_r8,0.61916_r8, &
      0.24673_r8,0.24673_r8,0.24673_r8,0.41274_r8,0.36689_r8,0.41274_r8,0.49934_r8,0.58653_r8, &
      0.19216_r8,0.19216_r8,0.19216_r8,0.34214_r8,0.29839_r8,0.34214_r8,0.42664_r8,0.51768_r8, &
      0.15153_r8,0.15153_r8,0.15153_r8,0.28528_r8,0.24454_r8,0.28528_r8,0.36566_r8,0.45729_r8  &
            /),(/8,17/))

      real(r8), parameter :: ssa_dcbs(7,17) = ssa_cbs(2:8,:) - ssa_cbs(1:7,:)

      real(r8), parameter :: asm_cbs(8,17) = reshape( (/ &
      0.59_r8,   0.59_r8,   0.59_r8,   0.71_r8,   0.70_r8,   0.71_r8,   0.71_r8,   0.72_r8, &
      0.59_r8,   0.59_r8,   0.59_r8,   0.71_r8,   0.70_r8,   0.71_r8,   0.72_r8,   0.72_r8, &
      0.59_r8,   0.59_r8,   0.59_r8,   0.71_r8,   0.69_r8,   0.71_r8,   0.72_r8,   0.72_r8, &
      0.58_r8,   0.58_r8,   0.58_r8,   0.70_r8,   0.69_r8,   0.70_r8,   0.72_r8,   0.72_r8, &
      0.57_r8,   0.57_r8,   0.57_r8,   0.70_r8,   0.69_r8,   0.70_r8,   0.72_r8,   0.72_r8, &
      0.56_r8,   0.56_r8,   0.56_r8,   0.70_r8,   0.68_r8,   0.70_r8,   0.71_r8,   0.72_r8, &
      0.55_r8,   0.55_r8,   0.55_r8,   0.69_r8,   0.68_r8,   0.69_r8,   0.71_r8,   0.72_r8, &
      0.54_r8,   0.54_r8,   0.54_r8,   0.69_r8,   0.67_r8,   0.69_r8,   0.71_r8,   0.72_r8, &
      0.53_r8,   0.53_r8,   0.53_r8,   0.68_r8,   0.66_r8,   0.68_r8,   0.70_r8,   0.72_r8, &
      0.49_r8,   0.49_r8,   0.49_r8,   0.65_r8,   0.63_r8,   0.65_r8,   0.68_r8,   0.70_r8, &
      0.46_r8,   0.46_r8,   0.46_r8,   0.63_r8,   0.60_r8,   0.63_r8,   0.66_r8,   0.68_r8, &
      0.45_r8,   0.45_r8,   0.45_r8,   0.62_r8,   0.59_r8,   0.62_r8,   0.65_r8,   0.68_r8, &
      0.44_r8,   0.44_r8,   0.44_r8,   0.61_r8,   0.58_r8,   0.61_r8,   0.64_r8,   0.67_r8, &
      0.41_r8,   0.41_r8,   0.41_r8,   0.58_r8,   0.55_r8,   0.58_r8,   0.61_r8,   0.64_r8, &
      0.37_r8,   0.37_r8,   0.37_r8,   0.54_r8,   0.51_r8,   0.54_r8,   0.58_r8,   0.61_r8, &
      0.32_r8,   0.32_r8,   0.32_r8,   0.47_r8,   0.45_r8,   0.47_r8,   0.51_r8,   0.55_r8, &
      0.28_r8,   0.28_r8,   0.28_r8,   0.42_r8,   0.40_r8,   0.42_r8,   0.46_r8,   0.50_r8  &
            /),(/8,17/))

      real(r8), parameter :: asm_dcbs(7,17) = asm_cbs(2:8,:) - asm_cbs(1:7,:)

!--------------------------------------------------------------------
! organic carbon
!--------------------------------------------------------------------
      real(r8), parameter :: qext_ocs(8,17) = reshape( (/ & 
      5.38_r8,   8.22_r8,  11.03_r8,  13.09_r8,  14.66_r8,  18.31_r8,  25.39_r8,  28.27_r8, &
      5.37_r8,   8.20_r8,  11.00_r8,  13.06_r8,  14.63_r8,  18.29_r8,  25.39_r8,  28.28_r8, &
      5.35_r8,   8.16_r8,  10.95_r8,  13.02_r8,  14.59_r8,  18.26_r8,  25.39_r8,  28.29_r8, &
      5.33_r8,   8.12_r8,  10.90_r8,  12.96_r8,  14.53_r8,  18.21_r8,  25.38_r8,  28.30_r8, &
      5.30_r8,   8.06_r8,  10.83_r8,  12.89_r8,  14.46_r8,  18.15_r8,  25.34_r8,  28.27_r8, &
      5.26_r8,   8.00_r8,  10.74_r8,  12.80_r8,  14.37_r8,  18.07_r8,  25.29_r8,  28.24_r8, &
      5.22_r8,   7.92_r8,  10.65_r8,  12.71_r8,  14.28_r8,  17.98_r8,  25.22_r8,  28.19_r8, &
      5.17_r8,   7.84_r8,  10.54_r8,  12.59_r8,  14.15_r8,  17.85_r8,  25.13_r8,  28.12_r8, &
      5.12_r8,   7.75_r8,  10.42_r8,  12.47_r8,  14.02_r8,  17.71_r8,  25.01_r8,  28.00_r8, &
      4.86_r8,   7.35_r8,   9.90_r8,  11.89_r8,  13.41_r8,  17.05_r8,  24.35_r8,  27.38_r8, &
      4.65_r8,   7.01_r8,   9.46_r8,  11.39_r8,  12.87_r8,  16.45_r8,  23.70_r8,  26.73_r8, &
      4.56_r8,   6.88_r8,   9.29_r8,  11.20_r8,  12.67_r8,  16.21_r8,  23.44_r8,  26.46_r8, &
      4.44_r8,   6.70_r8,   9.06_r8,  10.95_r8,  12.38_r8,  15.89_r8,  23.06_r8,  26.07_r8, &
      4.06_r8,   6.14_r8,   8.32_r8,  10.10_r8,  11.46_r8,  14.81_r8,  21.77_r8,  24.72_r8, &
      3.61_r8,   5.47_r8,   7.44_r8,   9.08_r8,  10.34_r8,  13.47_r8,  20.09_r8,  22.94_r8, &
      2.81_r8,   4.27_r8,   5.86_r8,   7.22_r8,   8.26_r8,  10.91_r8,  16.70_r8,  19.24_r8, &
      2.25_r8,   3.44_r8,   4.74_r8,   5.89_r8,   6.77_r8,   9.04_r8,  14.12_r8,  16.39_r8  &
            /),(/8,17/))

      real(r8), parameter :: qext_docs(7,17) = qext_ocs(2:8,:) - qext_ocs(1:7,:)

      real(r8), parameter :: ssa_ocs(8,17) = reshape( (/ & 
      0.67508_r8,0.73829_r8,0.78690_r8,0.80446_r8,0.82190_r8,0.84991_r8,0.87960_r8,0.88715_r8, &
      0.67840_r8,0.74179_r8,0.79056_r8,0.80819_r8,0.82564_r8,0.85366_r8,0.88338_r8,0.89096_r8, &
      0.68373_r8,0.74715_r8,0.79586_r8,0.81346_r8,0.83078_r8,0.85852_r8,0.88777_r8,0.89520_r8, &
      0.69072_r8,0.75403_r8,0.80249_r8,0.81995_r8,0.83703_r8,0.86424_r8,0.89272_r8,0.89991_r8, &
      0.69947_r8,0.76249_r8,0.81046_r8,0.82767_r8,0.84441_r8,0.87098_r8,0.89863_r8,0.90556_r8, &
      0.71012_r8,0.77261_r8,0.81984_r8,0.83676_r8,0.85311_r8,0.87886_r8,0.90536_r8,0.91195_r8, &
      0.72284_r8,0.78447_r8,0.83062_r8,0.84703_r8,0.86276_r8,0.88742_r8,0.91264_r8,0.91888_r8, &
      0.73788_r8,0.79817_r8,0.84282_r8,0.85864_r8,0.87367_r8,0.89703_r8,0.92063_r8,0.92642_r8, &
      0.75456_r8,0.81304_r8,0.85573_r8,0.87075_r8,0.88494_r8,0.90689_r8,0.92883_r8,0.93416_r8, &
      0.83969_r8,0.88348_r8,0.91349_r8,0.92370_r8,0.93306_r8,0.94713_r8,0.96070_r8,0.96392_r8, &
      0.92455_r8,0.94805_r8,0.96298_r8,0.96787_r8,0.97222_r8,0.97858_r8,0.98451_r8,0.98588_r8, &
      0.93919_r8,0.95861_r8,0.97073_r8,0.97469_r8,0.97818_r8,0.98326_r8,0.98796_r8,0.98905_r8, &
      0.94732_r8,0.96439_r8,0.97494_r8,0.97838_r8,0.98140_r8,0.98578_r8,0.98983_r8,0.99076_r8, &
      0.96028_r8,0.97347_r8,0.98153_r8,0.98416_r8,0.98643_r8,0.98973_r8,0.99275_r8,0.99344_r8, &
      0.96294_r8,0.97536_r8,0.98295_r8,0.98546_r8,0.98760_r8,0.99068_r8,0.99351_r8,0.99416_r8, &
      0.95723_r8,0.97159_r8,0.98043_r8,0.98344_r8,0.98593_r8,0.98957_r8,0.99290_r8,0.99366_r8, &
      0.94701_r8,0.96465_r8,0.97566_r8,0.97951_r8,0.98263_r8,0.98721_r8,0.99143_r8,0.99239_r8  &
            /),(/8,17/))

      real(r8), parameter :: ssa_docs(7,17) = ssa_ocs(2:8,:) - ssa_ocs(1:7,:)

      real(r8), parameter :: asm_ocs(8,17) = reshape( (/ &
      0.77_r8,   0.76_r8,   0.75_r8,   0.74_r8,   0.74_r8,   0.73_r8,   0.73_r8,   0.73_r8, &
      0.77_r8,   0.76_r8,   0.75_r8,   0.74_r8,   0.74_r8,   0.74_r8,   0.73_r8,   0.73_r8, &
      0.77_r8,   0.76_r8,   0.75_r8,   0.75_r8,   0.74_r8,   0.74_r8,   0.74_r8,   0.74_r8, &
      0.76_r8,   0.76_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.74_r8,   0.74_r8,   0.74_r8, &
      0.76_r8,   0.76_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8, &
      0.75_r8,   0.76_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8, &
      0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8, &
      0.74_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.76_r8, &
      0.74_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.76_r8,   0.76_r8,   0.76_r8,   0.76_r8, &
      0.71_r8,   0.73_r8,   0.75_r8,   0.75_r8,   0.75_r8,   0.76_r8,   0.76_r8,   0.76_r8, &
      0.68_r8,   0.72_r8,   0.74_r8,   0.74_r8,   0.75_r8,   0.76_r8,   0.76_r8,   0.77_r8, &
      0.68_r8,   0.72_r8,   0.74_r8,   0.74_r8,   0.75_r8,   0.76_r8,   0.76_r8,   0.77_r8, &
      0.68_r8,   0.71_r8,   0.74_r8,   0.74_r8,   0.75_r8,   0.76_r8,   0.77_r8,   0.77_r8, &
      0.67_r8,   0.71_r8,   0.74_r8,   0.74_r8,   0.75_r8,   0.76_r8,   0.77_r8,   0.77_r8, &
      0.66_r8,   0.71_r8,   0.73_r8,   0.74_r8,   0.75_r8,   0.76_r8,   0.77_r8,   0.77_r8, &
      0.65_r8,   0.70_r8,   0.73_r8,   0.74_r8,   0.75_r8,   0.76_r8,   0.77_r8,   0.78_r8, &
      0.64_r8,   0.69_r8,   0.72_r8,   0.73_r8,   0.74_r8,   0.76_r8,   0.77_r8,   0.77_r8  &
            /),(/8,17/))

      real(r8), parameter :: asm_docs(7,17) = asm_ocs(2:8,:) - asm_ocs(1:7,:)

!--------------------------------------------------------------------
! sea-salt bin 1
!--------------------------------------------------------------------
      real(r8), parameter :: qext_sal01(8,17) = reshape( (/ &
      2.18_r8,   3.87_r8,   5.09_r8,   6.46_r8,   0.00_r8,  15.67_r8,  29.00_r8,  40.81_r8, &
      2.19_r8,   3.89_r8,   5.13_r8,   6.49_r8,   0.00_r8,  15.67_r8,  29.03_r8,  40.76_r8, &
      2.18_r8,   3.83_r8,   5.16_r8,   6.45_r8,   0.00_r8,  15.62_r8,  29.02_r8,  40.81_r8, &
      2.17_r8,   3.82_r8,   5.23_r8,   6.39_r8,   0.00_r8,  15.72_r8,  29.06_r8,  40.86_r8, &
      2.15_r8,   3.85_r8,   5.24_r8,   6.45_r8,   0.00_r8,  15.71_r8,  29.13_r8,  40.89_r8, &
      2.14_r8,   3.93_r8,   5.18_r8,   6.56_r8,   0.00_r8,  15.71_r8,  29.13_r8,  40.90_r8, &
      2.15_r8,   4.01_r8,   5.18_r8,   6.57_r8,   0.00_r8,  15.85_r8,  29.34_r8,  41.03_r8, &
      2.18_r8,   4.02_r8,   5.27_r8,   6.48_r8,   0.00_r8,  15.72_r8,  29.21_r8,  41.15_r8, &
      2.23_r8,   3.96_r8,   5.38_r8,   6.50_r8,   0.00_r8,  15.88_r8,  29.50_r8,  41.17_r8, &
      2.39_r8,   4.09_r8,   5.34_r8,   6.71_r8,   0.00_r8,  16.08_r8,  29.66_r8,  41.58_r8, &
      2.34_r8,   4.34_r8,   5.61_r8,   6.69_r8,   0.00_r8,  16.05_r8,  29.95_r8,  41.93_r8, &
      2.31_r8,   4.35_r8,   5.75_r8,   6.84_r8,   0.00_r8,  16.07_r8,  29.72_r8,  41.59_r8, &
      2.26_r8,   4.28_r8,   5.85_r8,   7.10_r8,   0.00_r8,  16.45_r8,  29.96_r8,  42.10_r8, &
      2.36_r8,   4.10_r8,   5.62_r8,   7.20_r8,   0.00_r8,  16.62_r8,  30.41_r8,  42.58_r8, &
      2.78_r8,   4.50_r8,   5.61_r8,   6.85_r8,   0.00_r8,  17.18_r8,  31.51_r8,  42.82_r8, &
      3.20_r8,   5.65_r8,   7.29_r8,   8.64_r8,   0.00_r8,  17.51_r8,  32.64_r8,  44.52_r8, &
      3.02_r8,   5.74_r8,   7.96_r8,   9.96_r8,   0.00_r8,  18.03_r8,  33.24_r8,  47.22_r8  &
            /),(/8,17/))

      real(r8), parameter :: qext_dsal01(7,17) = qext_sal01(2:8,:) - qext_sal01(1:7,:)

      real(r8), parameter :: ssa_sal01(8,17) = reshape( (/ &
      0.99971_r8,0.99603_r8,0.99413_r8,0.99292_r8,0.00000_r8,0.98870_r8,0.98441_r8,0.98456_r8, &
      0.99972_r8,0.99886_r8,0.99844_r8,0.99822_r8,0.00000_r8,0.99688_r8,0.99566_r8,0.99559_r8, &
      0.99972_r8,0.99970_r8,0.99965_r8,0.99965_r8,0.00000_r8,0.99948_r8,0.99928_r8,0.99927_r8, &
      0.99974_r8,0.99983_r8,0.99989_r8,0.99990_r8,0.00000_r8,0.99992_r8,0.99993_r8,0.99993_r8, &
      0.99975_r8,0.99987_r8,0.99990_r8,0.99992_r8,0.00000_r8,0.99994_r8,0.99996_r8,0.99996_r8, &
      0.99977_r8,0.99988_r8,0.99991_r8,0.99993_r8,0.00000_r8,0.99997_r8,0.99998_r8,0.99998_r8, &
      0.99979_r8,0.99990_r8,0.99992_r8,0.99993_r8,0.00000_r8,0.99997_r8,0.99998_r8,0.99999_r8, &
      0.99982_r8,0.99991_r8,0.99993_r8,0.99994_r8,0.00000_r8,0.99997_r8,0.99999_r8,0.99999_r8, &
      0.99984_r8,0.99992_r8,0.99994_r8,0.99995_r8,0.00000_r8,0.99998_r8,0.99999_r8,0.99999_r8, &
      0.99992_r8,0.99996_r8,0.99997_r8,0.99998_r8,0.00000_r8,0.99999_r8,0.99999_r8,1.00000_r8, &
      0.99996_r8,0.99998_r8,0.99999_r8,0.99999_r8,0.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
      0.99997_r8,0.99999_r8,0.99999_r8,0.99999_r8,0.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
      0.99998_r8,0.99999_r8,0.99999_r8,0.99999_r8,0.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
      1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,0.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
      1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,0.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
      1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,0.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
      1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,0.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8  &
            /),(/8,17/))

      real(r8), parameter :: ssa_dsal01(7,17) = ssa_sal01(2:8,:) - ssa_sal01(1:7,:)

      real(r8), parameter :: asm_sal01(8,17) = reshape( (/ &
      0.73_r8,   0.75_r8,   0.75_r8,   0.76_r8,   0.00_r8,   0.78_r8,   0.79_r8,   0.80_r8, &
      0.72_r8,   0.74_r8,   0.75_r8,   0.76_r8,   0.00_r8,   0.78_r8,   0.79_r8,   0.80_r8, &
      0.72_r8,   0.74_r8,   0.76_r8,   0.76_r8,   0.00_r8,   0.78_r8,   0.79_r8,   0.80_r8, &
      0.72_r8,   0.74_r8,   0.76_r8,   0.76_r8,   0.00_r8,   0.79_r8,   0.80_r8,   0.80_r8, &
      0.71_r8,   0.74_r8,   0.76_r8,   0.76_r8,   0.00_r8,   0.79_r8,   0.80_r8,   0.81_r8, &
      0.71_r8,   0.75_r8,   0.76_r8,   0.77_r8,   0.00_r8,   0.79_r8,   0.80_r8,   0.81_r8, &
      0.70_r8,   0.75_r8,   0.75_r8,   0.77_r8,   0.00_r8,   0.79_r8,   0.81_r8,   0.81_r8, &
      0.70_r8,   0.75_r8,   0.76_r8,   0.76_r8,   0.00_r8,   0.79_r8,   0.81_r8,   0.82_r8, &
      0.70_r8,   0.74_r8,   0.76_r8,   0.76_r8,   0.00_r8,   0.80_r8,   0.81_r8,   0.82_r8, &
      0.69_r8,   0.73_r8,   0.75_r8,   0.77_r8,   0.00_r8,   0.80_r8,   0.81_r8,   0.82_r8, &
      0.66_r8,   0.73_r8,   0.75_r8,   0.75_r8,   0.00_r8,   0.79_r8,   0.81_r8,   0.82_r8, &
      0.64_r8,   0.72_r8,   0.75_r8,   0.75_r8,   0.00_r8,   0.79_r8,   0.81_r8,   0.82_r8, &
      0.62_r8,   0.71_r8,   0.75_r8,   0.76_r8,   0.00_r8,   0.79_r8,   0.81_r8,   0.82_r8, &
      0.61_r8,   0.68_r8,   0.71_r8,   0.74_r8,   0.00_r8,   0.79_r8,   0.81_r8,   0.82_r8, &
      0.66_r8,   0.70_r8,   0.70_r8,   0.71_r8,   0.00_r8,   0.78_r8,   0.80_r8,   0.81_r8, &
      0.73_r8,   0.78_r8,   0.78_r8,   0.77_r8,   0.00_r8,   0.75_r8,   0.78_r8,   0.80_r8, &
      0.74_r8,   0.80_r8,   0.82_r8,   0.82_r8,   0.00_r8,   0.75_r8,   0.77_r8,   0.79_r8  &
            /),(/8,17/))

      real(r8), parameter :: asm_dsal01(7,17) = asm_sal01(2:8,:) - asm_sal01(1:7,:)

!--------------------------------------------------------------------
! sea-salt bin 2
!--------------------------------------------------------------------
      real(r8), parameter :: qext_sal02(8,17) = reshape( (/ &
      0.63_r8,   1.15_r8,   1.56_r8,   1.95_r8,   3.07_r8,   4.83_r8,   8.83_r8,  14.00_r8, &
      0.63_r8,   1.15_r8,   1.56_r8,   1.95_r8,   3.07_r8,   4.82_r8,   8.83_r8,  14.00_r8, &
      0.63_r8,   1.15_r8,   1.56_r8,   1.96_r8,   3.07_r8,   4.83_r8,   8.83_r8,  14.01_r8, &
      0.64_r8,   1.16_r8,   1.56_r8,   1.96_r8,   3.07_r8,   4.83_r8,   8.84_r8,  14.02_r8, &
      0.64_r8,   1.16_r8,   1.56_r8,   1.96_r8,   3.08_r8,   4.84_r8,   8.84_r8,  14.01_r8, &
      0.64_r8,   1.16_r8,   1.57_r8,   1.96_r8,   3.08_r8,   4.84_r8,   8.86_r8,  14.04_r8, &
      0.64_r8,   1.16_r8,   1.57_r8,   1.96_r8,   3.09_r8,   4.85_r8,   8.86_r8,  14.05_r8, &
      0.64_r8,   1.16_r8,   1.57_r8,   1.97_r8,   3.09_r8,   4.85_r8,   8.86_r8,  14.04_r8, &
      0.64_r8,   1.17_r8,   1.57_r8,   1.97_r8,   3.09_r8,   4.86_r8,   8.88_r8,  14.08_r8, &
      0.65_r8,   1.18_r8,   1.59_r8,   1.99_r8,   3.11_r8,   4.88_r8,   8.92_r8,  14.12_r8, &
      0.66_r8,   1.19_r8,   1.59_r8,   2.00_r8,   3.13_r8,   4.91_r8,   8.95_r8,  14.17_r8, &
      0.66_r8,   1.18_r8,   1.60_r8,   2.01_r8,   3.13_r8,   4.91_r8,   8.96_r8,  14.17_r8, &
      0.66_r8,   1.19_r8,   1.61_r8,   2.00_r8,   3.15_r8,   4.92_r8,   8.98_r8,  14.20_r8, &
      0.67_r8,   1.21_r8,   1.62_r8,   2.03_r8,   3.17_r8,   4.96_r8,   9.03_r8,  14.27_r8, &
      0.67_r8,   1.22_r8,   1.65_r8,   2.04_r8,   3.19_r8,   5.00_r8,   9.08_r8,  14.36_r8, &
      0.70_r8,   1.24_r8,   1.67_r8,   2.10_r8,   3.26_r8,   5.10_r8,   9.21_r8,  14.53_r8, &
      0.75_r8,   1.30_r8,   1.67_r8,   2.09_r8,   3.32_r8,   5.21_r8,   9.32_r8,  14.58_r8  &
           /),(/8,17/))

      real(r8), parameter :: qext_dsal02(7,17) = qext_sal02(2:8,:) - qext_sal02(1:7,:)

      real(r8), parameter :: ssa_sal02(8,17) = reshape( (/ &
      0.99919_r8,0.98950_r8,0.98773_r8,0.98690_r8,0.98636_r8,0.98579_r8,0.98479_r8,0.98335_r8, &
      0.99919_r8,0.99678_r8,0.99634_r8,0.99621_r8,0.99608_r8,0.99603_r8,0.99579_r8,0.99540_r8, &
      0.99923_r8,0.99911_r8,0.99916_r8,0.99924_r8,0.99925_r8,0.99933_r8,0.99930_r8,0.99925_r8, &
      0.99927_r8,0.99958_r8,0.99968_r8,0.99975_r8,0.99986_r8,0.99990_r8,0.99992_r8,0.99993_r8, &
      0.99931_r8,0.99961_r8,0.99973_r8,0.99980_r8,0.99989_r8,0.99993_r8,0.99996_r8,0.99997_r8, &
      0.99935_r8,0.99965_r8,0.99975_r8,0.99979_r8,0.99990_r8,0.99995_r8,0.99997_r8,0.99998_r8, &
      0.99942_r8,0.99970_r8,0.99976_r8,0.99983_r8,0.99991_r8,0.99995_r8,0.99998_r8,0.99999_r8, &
      0.99947_r8,0.99973_r8,0.99979_r8,0.99983_r8,0.99991_r8,0.99996_r8,0.99998_r8,0.99999_r8, &
      0.99951_r8,0.99976_r8,0.99982_r8,0.99986_r8,0.99992_r8,0.99995_r8,0.99998_r8,0.99999_r8, &
      0.99973_r8,0.99987_r8,0.99990_r8,0.99992_r8,0.99995_r8,0.99997_r8,0.99999_r8,0.99999_r8, &
      0.99986_r8,0.99992_r8,0.99996_r8,0.99997_r8,0.99998_r8,0.99998_r8,0.99999_r8,1.00000_r8, &
      0.99991_r8,0.99995_r8,0.99996_r8,0.99997_r8,0.99998_r8,0.99999_r8,0.99999_r8,1.00000_r8, &
      0.99994_r8,0.99997_r8,0.99998_r8,0.99998_r8,0.99999_r8,0.99999_r8,1.00000_r8,1.00000_r8, &
      0.99999_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
      1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
      1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
      0.99998_r8,0.99999_r8,0.99999_r8,0.99999_r8,0.99999_r8,0.99999_r8,0.99999_r8,0.99999_r8  &
           /),(/8,17/))

      real(r8), parameter :: ssa_dsal02(7,17) = ssa_sal02(2:8,:) - ssa_sal02(1:7,:)

      real(r8), parameter :: asm_sal02(8,17) = reshape( (/ &
      0.78_r8,   0.80_r8,   0.80_r8,   0.80_r8,   0.81_r8,   0.81_r8,   0.82_r8,   0.82_r8, &
      0.78_r8,   0.80_r8,   0.80_r8,   0.80_r8,   0.81_r8,   0.81_r8,   0.82_r8,   0.82_r8, &
      0.78_r8,   0.80_r8,   0.80_r8,   0.80_r8,   0.81_r8,   0.81_r8,   0.82_r8,   0.82_r8, &
      0.78_r8,   0.80_r8,   0.80_r8,   0.81_r8,   0.81_r8,   0.82_r8,   0.82_r8,   0.82_r8, &
      0.78_r8,   0.80_r8,   0.81_r8,   0.81_r8,   0.82_r8,   0.82_r8,   0.83_r8,   0.83_r8, &
      0.78_r8,   0.80_r8,   0.81_r8,   0.81_r8,   0.82_r8,   0.82_r8,   0.83_r8,   0.83_r8, &
      0.78_r8,   0.80_r8,   0.81_r8,   0.81_r8,   0.82_r8,   0.83_r8,   0.83_r8,   0.84_r8, &
      0.78_r8,   0.80_r8,   0.81_r8,   0.82_r8,   0.82_r8,   0.83_r8,   0.84_r8,   0.84_r8, &
      0.78_r8,   0.80_r8,   0.81_r8,   0.82_r8,   0.83_r8,   0.83_r8,   0.84_r8,   0.84_r8, &
      0.77_r8,   0.80_r8,   0.81_r8,   0.82_r8,   0.83_r8,   0.84_r8,   0.84_r8,   0.85_r8, &
      0.76_r8,   0.80_r8,   0.81_r8,   0.82_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.85_r8, &
      0.76_r8,   0.80_r8,   0.81_r8,   0.82_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.85_r8, &
      0.76_r8,   0.80_r8,   0.81_r8,   0.82_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.85_r8, &
      0.75_r8,   0.80_r8,   0.81_r8,   0.82_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.85_r8, &
      0.74_r8,   0.79_r8,   0.81_r8,   0.81_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.85_r8, &
      0.72_r8,   0.77_r8,   0.79_r8,   0.80_r8,   0.82_r8,   0.83_r8,   0.84_r8,   0.85_r8, &
      0.71_r8,   0.75_r8,   0.77_r8,   0.78_r8,   0.81_r8,   0.83_r8,   0.84_r8,   0.85_r8  &
           /),(/8,17/))

      real(r8), parameter :: asm_dsal02(7,17) = asm_sal02(2:8,:) - asm_sal02(1:7,:)

!--------------------------------------------------------------------
! sea-salt bin 3
!--------------------------------------------------------------------
      real(r8), parameter :: qext_sal03(8,17) = reshape( (/ &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.91_r8,   1.44_r8,   2.66_r8,   4.20_r8, &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.91_r8,   1.44_r8,   2.66_r8,   4.20_r8, &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.91_r8,   1.44_r8,   2.66_r8,   4.20_r8, &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.91_r8,   1.44_r8,   2.66_r8,   4.20_r8, &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.92_r8,   1.44_r8,   2.66_r8,   4.20_r8, &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.92_r8,   1.45_r8,   2.66_r8,   4.20_r8, &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.92_r8,   1.45_r8,   2.66_r8,   4.21_r8, &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.92_r8,   1.45_r8,   2.66_r8,   4.20_r8, &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.92_r8,   1.45_r8,   2.66_r8,   4.21_r8, &
          0.19_r8,   0.34_r8,   0.46_r8,   0.58_r8,   0.92_r8,   1.45_r8,   2.67_r8,   4.21_r8, &
          0.19_r8,   0.34_r8,   0.47_r8,   0.58_r8,   0.92_r8,   1.45_r8,   2.68_r8,   4.22_r8, &
          0.19_r8,   0.34_r8,   0.47_r8,   0.58_r8,   0.92_r8,   1.46_r8,   2.67_r8,   4.22_r8, &
          0.19_r8,   0.35_r8,   0.47_r8,   0.59_r8,   0.92_r8,   1.46_r8,   2.68_r8,   4.23_r8, &
          0.19_r8,   0.35_r8,   0.47_r8,   0.59_r8,   0.93_r8,   1.46_r8,   2.68_r8,   4.23_r8, &
          0.19_r8,   0.35_r8,   0.47_r8,   0.59_r8,   0.93_r8,   1.47_r8,   2.69_r8,   4.25_r8, &
          0.19_r8,   0.35_r8,   0.48_r8,   0.60_r8,   0.94_r8,   1.48_r8,   2.71_r8,   4.27_r8, &
          0.20_r8,   0.36_r8,   0.48_r8,   0.60_r8,   0.94_r8,   1.49_r8,   2.72_r8,   4.29_r8  &
            /),(/8,17/))

      real(r8), parameter :: qext_dsal03(7,17) = qext_sal03(2:8,:) - qext_sal03(1:7,:)

      real(r8), parameter :: ssa_sal03(8,17) = reshape( (/ &
       0.99903_r8,0.98942_r8,0.98658_r8,0.98454_r8,0.98105_r8,0.97736_r8,0.97161_r8,0.96631_r8, &
       0.99907_r8,0.99687_r8,0.99611_r8,0.99559_r8,0.99470_r8,0.99369_r8,0.99208_r8,0.99059_r8, &
       0.99910_r8,0.99917_r8,0.99917_r8,0.99913_r8,0.99905_r8,0.99893_r8,0.99870_r8,0.99847_r8, &
       0.99911_r8,0.99958_r8,0.99970_r8,0.99976_r8,0.99982_r8,0.99985_r8,0.99987_r8,0.99986_r8, &
       0.99915_r8,0.99961_r8,0.99973_r8,0.99980_r8,0.99987_r8,0.99990_r8,0.99993_r8,0.99993_r8, &
       0.99919_r8,0.99963_r8,0.99974_r8,0.99981_r8,0.99988_r8,0.99992_r8,0.99995_r8,0.99996_r8, &
       0.99923_r8,0.99965_r8,0.99976_r8,0.99983_r8,0.99990_r8,0.99994_r8,0.99996_r8,0.99997_r8, &
       0.99929_r8,0.99968_r8,0.99978_r8,0.99984_r8,0.99991_r8,0.99994_r8,0.99997_r8,0.99998_r8, &
       0.99935_r8,0.99970_r8,0.99979_r8,0.99985_r8,0.99991_r8,0.99995_r8,0.99997_r8,0.99998_r8, &
       0.99958_r8,0.99980_r8,0.99987_r8,0.99990_r8,0.99994_r8,0.99997_r8,0.99998_r8,0.99999_r8, &
       0.99976_r8,0.99989_r8,0.99992_r8,0.99995_r8,0.99997_r8,0.99998_r8,0.99999_r8,1.00000_r8, &
       0.99982_r8,0.99991_r8,0.99994_r8,0.99996_r8,0.99998_r8,0.99999_r8,0.99999_r8,1.00000_r8, &
       0.99987_r8,0.99994_r8,0.99996_r8,0.99997_r8,0.99998_r8,0.99999_r8,1.00000_r8,1.00000_r8, &
       0.99998_r8,0.99999_r8,0.99999_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
       1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
       0.99999_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
       0.99994_r8,0.99996_r8,0.99997_r8,0.99997_r8,0.99997_r8,0.99997_r8,0.99997_r8,0.99997_r8  &
            /),(/8,17/))

      real(r8), parameter :: ssa_dsal03(7,17) = ssa_sal03(2:8,:) - ssa_sal03(1:7,:)

      real(r8), parameter :: asm_sal03(8,17) = reshape( (/ &
          0.81_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.83_r8,   0.83_r8, &
          0.81_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.83_r8, &
          0.81_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.83_r8,   0.83_r8,   0.83_r8, &
          0.81_r8,   0.82_r8,   0.82_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8, &
          0.81_r8,   0.82_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.84_r8,   0.84_r8, &
          0.81_r8,   0.82_r8,   0.83_r8,   0.83_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.84_r8, &
          0.81_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.85_r8, &
          0.81_r8,   0.83_r8,   0.83_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.85_r8,   0.85_r8, &
          0.81_r8,   0.83_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.85_r8, &
          0.81_r8,   0.83_r8,   0.84_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.86_r8,   0.86_r8, &
          0.80_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.87_r8, &
          0.80_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.86_r8, &
          0.80_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.86_r8,   0.87_r8, &
          0.80_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.87_r8,   0.87_r8, &
          0.80_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.87_r8,   0.87_r8, &
          0.79_r8,   0.83_r8,   0.84_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.87_r8,   0.87_r8, &
          0.78_r8,   0.82_r8,   0.84_r8,   0.84_r8,   0.85_r8,   0.86_r8,   0.87_r8,   0.87_r8  &
            /),(/8,17/))

      real(r8), parameter :: asm_dsal03(7,17) = asm_sal03(2:8,:) - asm_sal03(1:7,:)

      real(r8), parameter :: qext_sal04(8,17) = reshape( (/ &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.68_r8,   1.26_r8,   1.99_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.68_r8,   1.26_r8,   1.99_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.68_r8,   1.26_r8,   1.99_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.68_r8,   1.26_r8,   1.99_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.68_r8,   1.26_r8,   1.99_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.68_r8,   1.26_r8,   1.99_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.68_r8,   1.26_r8,   2.00_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.69_r8,   1.26_r8,   1.99_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.68_r8,   1.26_r8,   2.00_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.69_r8,   1.26_r8,   2.00_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.28_r8,   0.43_r8,   0.69_r8,   1.26_r8,   2.00_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.27_r8,   0.43_r8,   0.69_r8,   1.27_r8,   2.00_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.28_r8,   0.44_r8,   0.69_r8,   1.27_r8,   2.00_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.28_r8,   0.44_r8,   0.69_r8,   1.27_r8,   2.00_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.28_r8,   0.44_r8,   0.69_r8,   1.27_r8,   2.01_r8, &
          0.09_r8,   0.16_r8,   0.22_r8,   0.28_r8,   0.44_r8,   0.69_r8,   1.27_r8,   2.01_r8, &
          0.09_r8,   0.17_r8,   0.22_r8,   0.28_r8,   0.44_r8,   0.70_r8,   1.28_r8,   2.02_r8  &
            /),(/8,17/))

      real(r8), parameter :: qext_dsal04(7,17) = qext_sal04(2:8,:) - qext_sal04(1:7,:)

      real(r8), parameter :: ssa_sal04(8,17) = reshape( (/ &
       0.99874_r8,0.98463_r8,0.97956_r8,0.97596_r8,0.96927_r8,0.96213_r8,0.95108_r8,0.94110_r8, &
       0.99879_r8,0.99541_r8,0.99411_r8,0.99316_r8,0.99134_r8,0.98932_r8,0.98605_r8,0.98300_r8, &
       0.99881_r8,0.99880_r8,0.99873_r8,0.99866_r8,0.99846_r8,0.99820_r8,0.99771_r8,0.99723_r8, &
       0.99887_r8,0.99940_r8,0.99954_r8,0.99963_r8,0.99971_r8,0.99975_r8,0.99976_r8,0.99975_r8, &
       0.99893_r8,0.99946_r8,0.99960_r8,0.99969_r8,0.99978_r8,0.99984_r8,0.99988_r8,0.99988_r8, &
       0.99899_r8,0.99949_r8,0.99963_r8,0.99972_r8,0.99982_r8,0.99987_r8,0.99991_r8,0.99993_r8, &
       0.99907_r8,0.99952_r8,0.99966_r8,0.99974_r8,0.99984_r8,0.99989_r8,0.99994_r8,0.99995_r8, &
       0.99915_r8,0.99957_r8,0.99969_r8,0.99977_r8,0.99985_r8,0.99991_r8,0.99995_r8,0.99997_r8, &
       0.99923_r8,0.99960_r8,0.99971_r8,0.99979_r8,0.99987_r8,0.99992_r8,0.99996_r8,0.99997_r8, &
       0.99954_r8,0.99976_r8,0.99983_r8,0.99987_r8,0.99992_r8,0.99995_r8,0.99997_r8,0.99998_r8, &
       0.99976_r8,0.99988_r8,0.99991_r8,0.99993_r8,0.99996_r8,0.99998_r8,0.99999_r8,0.99999_r8, &
       0.99982_r8,0.99991_r8,0.99993_r8,0.99995_r8,0.99997_r8,0.99998_r8,0.99999_r8,0.99999_r8, &
       0.99988_r8,0.99994_r8,0.99995_r8,0.99997_r8,0.99998_r8,0.99999_r8,0.99999_r8,1.00000_r8, &
       0.99998_r8,0.99999_r8,0.99999_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
       1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
       0.99999_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8,1.00000_r8, &
       0.99990_r8,0.99993_r8,0.99995_r8,0.99996_r8,0.99997_r8,0.99997_r8,0.99997_r8,0.99997_r8 &
            /),(/8,17/))

      real(r8), parameter :: ssa_dsal04(7,17) = ssa_sal04(2:8,:) - ssa_sal03(1:7,:)

      real(r8), parameter :: asm_sal04(8,17) = reshape( (/ &
          0.82_r8,   0.82_r8,   0.82_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8, &
          0.82_r8,   0.82_r8,   0.82_r8,   0.82_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8, &
          0.82_r8,   0.82_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8, &
          0.82_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.84_r8, &
          0.82_r8,   0.83_r8,   0.83_r8,   0.83_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.84_r8, &
          0.82_r8,   0.83_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.84_r8, &
          0.82_r8,   0.83_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.85_r8, &
          0.82_r8,   0.84_r8,   0.84_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.85_r8,   0.85_r8, &
          0.82_r8,   0.84_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.85_r8,   0.85_r8,   0.85_r8, &
          0.82_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.86_r8,   0.86_r8, &
          0.81_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.86_r8,   0.87_r8, &
          0.81_r8,   0.84_r8,   0.85_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.87_r8,   0.87_r8, &
          0.81_r8,   0.84_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.87_r8,   0.87_r8,   0.87_r8, &
          0.81_r8,   0.84_r8,   0.85_r8,   0.86_r8,   0.86_r8,   0.87_r8,   0.87_r8,   0.87_r8, &
          0.81_r8,   0.85_r8,   0.85_r8,   0.86_r8,   0.87_r8,   0.87_r8,   0.87_r8,   0.88_r8, &
          0.81_r8,   0.84_r8,   0.85_r8,   0.86_r8,   0.87_r8,   0.87_r8,   0.88_r8,   0.88_r8, &
          0.81_r8,   0.84_r8,   0.85_r8,   0.86_r8,   0.87_r8,   0.87_r8,   0.88_r8,   0.88_r8 &
            /),(/8,17/))

      real(r8), parameter :: asm_dsal04(7,17) = asm_sal04(2:8,:) - asm_sal03(1:7,:)

      contains

      subroutine setaer( z, airden, rh, aocs1, aocs2, acbs1, acbs2,&
                         aant, aso4, asal, ads, asoa, &
                         dtcbs1, dtcbs2, omcbs1, omcbs2, gcbs1, gcbs2, &
                         dtocs1, dtocs2, omocs1, omocs2, gocs1, gocs2, &
                         dtant, omant, gant, &
                         dtso4, omso4, gso4, &
                         dtsal, omsal, gsal, &
                         dtds1, dtds2, dtds3, dtds4, &
                         omds1, omds2, omds3, omds4, &
                         gds1, gds2, gds3, gds4, dtsoa, nw )
!-----------------------------------------------------------------------------
!   	... calculate aerosol optical depth
!-----------------------------------------------------------------------------
!   AEROSOL TYPES: 
!   ocs1, ocs2, cbs1, cbs2, ant, so4, ds1-ds4,soa, sal
!   where 1=hydrophobic, 2=hydrophilic;
!
!   PARAMETERS:                                                              
!   NZ      - INTEGER, number of specified altitude levels in the working
!             grid                                                           
!   Z       - REAL, specified altitude working grid (km)
!   axxx     aerosoling mix ratio (where xxx is aerosol type)
!
!   dtxxx    REAL, optical depth (absorption)
!   omxxx    REAL, single albedo             
!   gxxx   asysmetry factor
!
!-----------------------------------------------------------------------------
!     VERTICAL DOMAIN is from bottom(1)  to TOP (TOP=plevp)
!        CCM from top(1) to bottom(plevp)
!
!   Converted to MIE Look-up Table by P. Hess, April 2005
!-----------------------------------------------------------------------------

      use mo_constants,     only : pi
      use ppgrid,           only : pver, pverp
      use chem_mods,        only : adv_mass
      use mo_constants,     only : avogadro
      use mo_chem_utls,     only : get_spc_ndx
      use dust_intr,        only : dust_names
      use progseasalts_intr,only : progseasalts_names

      implicit none

!-----------------------------------------------------------------------------
!	... dummy arguments
!-----------------------------------------------------------------------------
      integer, intent(in)     :: nw
      real(r8), intent(in)    :: z(pverp)
      real(r8), intent(in)    :: aocs1(pverp)
      real(r8), intent(in)    :: aocs2(pverp)
      real(r8), intent(in)    :: acbs1(pverp)
      real(r8), intent(in)    :: acbs2(pverp)
      real(r8), intent(in)    :: aant(pverp)
      real(r8), intent(in)    :: aso4(pverp)
      real(r8), intent(in)    :: asal(pverp,4)
      real(r8), intent(in)    :: ads(4,pverp)
      real(r8), intent(in)    :: asoa(pverp)
      real(r8), intent(in)    :: rh(pverp)
      real(r8), intent(in)    :: airden(pverp)            ! molecules air / cm^3

      real(r8), intent(out)    :: dtcbs1(pver,nw)
      real(r8), intent(out)    :: dtcbs2(pver,nw)
      real(r8), intent(out)    :: omcbs1(pver,nw)
      real(r8), intent(out)    :: omcbs2(pver,nw)
      real(r8), intent(out)    :: gcbs1(pver,nw)
      real(r8), intent(out)    :: gcbs2(pver,nw)

      real(r8), intent(out)    :: dtocs1(pver,nw)
      real(r8), intent(out)    :: dtocs2(pver,nw)
      real(r8), intent(out)    :: dtsoa(pver,nw)
      real(r8), intent(out)    :: omocs1(pver,nw)
      real(r8), intent(out)    :: omocs2(pver,nw)
      real(r8), intent(out)    :: gocs1(pver,nw)
      real(r8), intent(out)    :: gocs2(pver,nw)

      real(r8), intent(out)    :: dtant(pver,nw)
      real(r8), intent(out)    :: omant(pver,nw)
      real(r8), intent(out)    :: gant(pver,nw)

      real(r8), intent(out)    :: dtso4(pver,nw)
      real(r8), intent(out)    :: omso4(pver,nw)
      real(r8), intent(out)    :: gso4(pver,nw)

      real(r8), intent(out)    :: dtsal(pver,nw,4)
      real(r8), intent(out)    :: omsal(pver,nw,4)
      real(r8), intent(out)    :: gsal(pver,nw,4)


      real(r8), intent(out)    :: dtds1(pver,nw)
      real(r8), intent(out)    :: dtds2(pver,nw)
      real(r8), intent(out)    :: dtds3(pver,nw)
      real(r8), intent(out)    :: dtds4(pver,nw)
      real(r8), intent(out)    :: omds1(pver,nw)
      real(r8), intent(out)    :: omds2(pver,nw)
      real(r8), intent(out)    :: omds3(pver,nw)
      real(r8), intent(out)    :: omds4(pver,nw)
      real(r8), intent(out)    :: gds1(pver,nw)
      real(r8), intent(out)    :: gds2(pver,nw)
      real(r8), intent(out)    :: gds3(pver,nw)
      real(r8), intent(out)    :: gds4(pver,nw)

!-----------------------------------------------------------------------------
!	... local variables
!-----------------------------------------------------------------------------
      real(r8), parameter :: km2m     = 1.e3_r8
      real(r8), parameter :: cm3_2_m3 = 1.e6_r8
      real(r8), parameter :: s2as     = 1.37557_r8  ! conversion factor from mass SO4 to mass (NH4)2(SO4) (assumed in mie calculation).
      real(r8), parameter :: rhmax    = .98_r8      ! maximum relative humidity allowed
      real(r8), parameter :: con_fac  = km2m*cm3_2_m3/avogadro

      integer :: k, n, ndx, wn
      integer :: rh_l
      integer :: rh_u
      integer :: rh_ndx(pver)
      real(r8)    :: mw
      real(r8)    :: delrh
      real(r8)    :: rhtest
      real(r8)    :: dz(pver)
      real(r8)    :: del_rh(pver)
      real(r8)    :: gpm2(pver)
      real(r8)    :: table_rh(8) = (/ 0._r8, .5_r8, .7_r8, .8_r8, .9_r8, .95_r8, .98_r8, .99_r8 /)

!-----------------------------------------------------------------------------
! Tables are based on the following wavelength bins from ftuv
!    178.60- 180.00
!    180.00- 183.00
!    183.00- 187.00
!    187.00- 192.00
!    192.00- 198.00
!    198.00- 205.00
!    205.00- 213.00
!    213.00- 222.00
!    222.00- 231.00
!    241.00- 289.90
!    289.90- 305.50
!    305.50- 313.50
!    313.50- 337.50
!    337.50- 420.00
!    420.00- 475.00
!    475.00- 729.00
!    729.00- 743.60
!
! For aerosol types so4 and  ant data tabulated for CAM is used in wavelength bins for which it exists
! This data has been created by  D. Fillmore in the file aerOptics.nc 
! Data is weighted by wavelength bin
! 
! Otherwise, tables have been recreated by P. Hess
!
! Refractive indices and other DATA is mostly from OPAC dataset Hess et al., .....
!
! SULFATE
!
!              r_m = 0.05 ; from Grant 1999   ! median radius of number distribution (microns)
!              sigma = alog10(2.00)           ! standard deviation of distribution
!              rmin = 0.005                   ! minimum radius microns
!              rmax = 20.0                    ! maximum radius microns
!              rho = 1.76                     ! grams / cm^3 
!        PARAMETERS NEEDED FOR CALCULATING KOHLER CURVES for calculating growth with relative humidity
!              nu_s = 3.0
!              rho_u = rho
!              rho_s = rho
!              gamma = 1.0
!              phi = 0.717  ; optimal fit to water activity curves of Tang 1994
!              eps = 1.0
!
!  REFRACTIVE INDEXES FOR SULFATE (for wavelength um)
!     0.300, 0.405, 0.535, 0.656, 0.706, 0.800, 1.00, 1.07,
!     1.15, 1.20, 1.30, 1.40, 1.50, 1.58, 1.60, 1.70, 1.80,
!     1.90, 2.00, 2.05, 2.14, 2.20, 2.30, 2.40, 2.50, 2.63,
!     2.78, 2.94, 3.08, 3.13, 3.18, 3.23, 3.30, 3.33, 3.39,
!     3.45, 3.51, 3.57, 3.85, 4.17, 4.55, 4.76, 5.26]
!
!  REAL
!     1.53, 1.53, 1.52, 1.52, 1.52, 1.52, 1.51, 1.51, $
!     1.51, 1.50, 1.50, 1.50, 1.49, 1.49, 1.49, 1.49, 1.48, $
!     1.48, 1.47, 1.47, 1.47, 1.46, 1.46, 1.45, 1.44, 1.42, $
!     1.40, 1.33, 1.27, 1.39, 1.49, 1.48, 1.56, 1.61, 1.61, $
!     1.60, 1.62, 1.63, 1.56, 1.53, 1.49, 1.48, 1.44]
!  
!  IMAGINARY
!    1.0e-7, 1.0e-7, 1.0e-7, 1.0e-7, 1.0e-7, 1.0e-7, 3.5e-7, 2.4e-6, 
!    9.5e-7, 3.4e-6, 1.7e-5, 1.1e-5, 3.4e-5, 2.1e-4, 1.9e-4, 9.0e-5, 7.6e-5, $
!    1.5e-4, 1.0e-3, 1.5e-3, 3.4e-3, 1.7e-3, 7.7e-4, 4.5e-4, 3.5e-4, 9.0e-4, $
!    5.0e-3, 5.0e-2, 2.3e-1, 3.3e-1, 2.7e-1, 2.4e-1, 2.7e-1, 2.4e-1, 1.7e-1, $
!    1.5e-1, 1.4e-1, 1.0e-1, 2.0e-2, 1.0e-2, 7.0e-3, 6.0e-3, 7.0e-3]
!
!
! NH4NO3
!
! treated the same as sulphate except 
! rho=1.73 (Lowenthal, 1999, Atmospheric Environment).
! 
! DUST
!
! dust is treated as 4 size distributions
! 0.05 - 0.5; 0.5 - 1.25; 1.25 - 2.5; 2.5 - 5.0 microns
! each bin is part of a distribution with median number r_m = 2.524 * exp(- 3.0 * log(2.00)^2) / 2 [number median radius]
! r_m = 0.298, sigma = 2.00, rho = 2.650
! 
! note this treatment of dust is somewhat different than that made in CAM, where each size bin
! has a different number median radius
!
! dust is not assumed to take up water. 
!
! refractive indexes are as in CAM (Fillmore...)
!
! ORGANIC CARBON
!
! In absence of data for organic aerosol 
! refractive indexes are taken as for WASO: based on Fillmore (and OPAC). This is similar to 
! the formulation used in Liao and Seinfeld, 2004, JGR. 
! The growth of organic carbon with relative humidity is assumed constant at all radii following
! hygrscopic growth given in Chen et al. : rel. hum: 0, 50, 70, 80, 90, 95, 98, 99
! multiplier for radius: 1,  1.2,  1.4,  1.5, 1.6, 1.8, 2.1 , 2.2
!
! SOA 
!
! Treated the same as organic aerosol.
!
! SOOT
!
! Refractive index are taken from Fillmore based on OPAC. 
! In a different formulation than that followed in CAM we let hydrophillic soot grow.
!  The growth of organic carbon with relative humidity is assumed constant at all radii following
! hygrscopic growth given in Chen et al. : rel. hum: 0, 50, 70, 80, 90, 95, 98, 99
! multiplier for radius: (1,  1,  1,  1.2, 1.4,  1.5, 1.7, 1.9]
! 
!
! SEA SALT
!
! Assumes 4 bins: 0.1 - 0.5, 0.5-1.5, 1.5-5, 5-10 um assuming a step distribution
! additional parameters used calculation
!   phi = 0.8
!  mol_s = 35.453 + 22.98977
!  nu_s = 2.0
!  rmin = 0.005, rmax = 500, nr = 300
!
! refractive indices are from fillmore
!-----------------------------------------------------------------------------

!-----------------------------------------------------------------------------
! 	... vertical interval dz
!-----------------------------------------------------------------------------
      do k = 1,pver
         dz(k) = abs( z(k+1) - z(k) )  * airden(k) * con_fac
      end do

!----------------------------------------------------------------------------
!  	... calculate interpolatant for relative humidity
!----------------------------------------------------------------------------
       do k = 1,pver
          rhtest = min( rh(k),rhmax )
          do rh_u = 2,8
             if( rhtest <= table_rh(rh_u) ) then
                exit
             end if
          end do
          rh_l      = rh_u - 1
          rh_ndx(k) = rh_l
          del_rh(k) = (rhtest - table_rh(rh_l))/(table_rh(rh_u) - table_rh(rh_l))
       end do

!-----------------------------------------------------------------------------
!      	... so4
!-----------------------------------------------------------------------------
      ndx = get_spc_ndx('SO4') 
      if( ndx > 0 ) then
         mw = adv_mass( ndx )
         gpm2(:) = s2as * dz(:) * aso4(:pver) * mw 
         do wn = 1,nw
            do k = 1,pver
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtso4(k,wn) = gpm2(k)*(qext_so4(rh_l,wn) + delrh*qext_dso4(rh_l,wn))
               omso4(k,wn) = ssa_so4(rh_l,wn) + delrh*ssa_dso4(rh_l,wn)
               gso4(k,wn)  = asm_so4(rh_l,wn) + delrh*asm_dso4(rh_l,wn)
            end do
         end do
      else
         do wn = 1,nw
            dtso4(:,wn) = 0._r8
            omso4(:,wn) = 0._r8
            gso4(:,wn)  = 0._r8
         end do
      end if

!-----------------------------------------------------------------------------
!   	... ant:  nh4no3
!-----------------------------------------------------------------------------    
      ndx = get_spc_ndx('NH4NO3')
      if( ndx > 0 ) then
         mw = adv_mass( ndx )
         gpm2(:) = dz(:) * aant(:pver) * mw 
         do wn = 1,nw
            do k = 1,pver
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtant(k,wn) = gpm2(k)*(qext_ant(rh_l,wn) + delrh*qext_dant(rh_l,wn))
               omant(k,wn) = ssa_ant(rh_l,wn) + delrh*ssa_dant(rh_l,wn)
               gant(k,wn)  = asm_ant(rh_l,wn) + delrh*asm_dant(rh_l,wn)
            end do
         end do
      else
         do wn = 1,nw
            dtant(:,wn) = 0._r8
            omant(:,wn) = 0._r8
            gant(:,wn)  = 0._r8
         end do
      end if

!-----------------------------------------------------------------------------
!  	... cbs : blackcarbons
!-----------------------------------------------------------------------------
       ndx = get_spc_ndx('CB1')
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * acbs1(:pver) * mw 
          do wn = 1,nw
             dtcbs1(:,wn) = gpm2(:)*qext_cbs(1,wn)
             omcbs1(:,wn) = ssa_cbs(1,wn) 
             gcbs1(:,wn)  = asm_cbs(1,wn)
          end do
      else
         do wn = 1,nw
            dtcbs1(:,wn) = 0._r8
            omcbs1(:,wn) = 0._r8
            gcbs1(:,wn)  = 0._r8
         end do
       end if

       ndx = get_spc_ndx('CB2')
       if( ndx > 0 ) then
          gpm2(:) = dz(:) * acbs2(:pver) * mw 
          do wn = 1,nw
             do k = 1,pver
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtcbs2(k,wn) = gpm2(k)*(qext_cbs(rh_l,wn) + delrh*qext_dcbs(rh_l,wn))
               omcbs2(k,wn) = ssa_cbs(rh_l,wn) + delrh*ssa_dcbs(rh_l,wn)
               gcbs2(k,wn)  = asm_cbs(rh_l,wn) + delrh*asm_dcbs(rh_l,wn)
             end do
          end do
      else
         do wn = 1,nw
            dtcbs2(:,wn) = 0._r8
            omcbs2(:,wn) = 0._r8
            gcbs2(:,wn)  = 0._r8
         end do
       end if

!-----------------------------------------------------------------------------
!  	... ocs : organic carbons
!-----------------------------------------------------------------------------
       ndx = get_spc_ndx('OC1')
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * aocs1(:pver) * mw 
          do wn = 1,nw
             dtocs1(:,wn) =  gpm2(:)*qext_ocs(1,wn)
             omocs1(:,wn) =  ssa_ocs(1,wn) 
             gocs1(:,wn)  =  asm_ocs(1,wn)
          end do
      else
         do wn = 1,nw
            dtocs1(:,wn) = 0._r8
            omocs1(:,wn) = 0._r8
            gocs1(:,wn)  = 0._r8
         end do
       end if
 
       ndx = get_spc_ndx('OC2')
       if( ndx > 0 ) then
          gpm2(:) = dz(:) * aocs2(:pver) * mw 
          do wn = 1,nw
            do k = 1,pver
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtocs2(k,wn) = gpm2(k)*(qext_ocs(rh_l,wn) + delrh*qext_docs(rh_l,wn))
               omocs2(k,wn) = ssa_ocs(rh_l,wn) + delrh*ssa_docs(rh_l,wn)
               gocs2(k,wn)  = asm_ocs(rh_l,wn) + delrh*asm_docs(rh_l,wn)
             end do
          end do
      else
         do wn = 1,nw
            dtocs2(:,wn) = 0._r8
            omocs2(:,wn) = 0._r8
            gocs2(:,wn)  = 0._r8
         end do
       end if

!-----------------------------------------------------------------------------
!  	... soa : secondary organic
!-----------------------------------------------------------------------------
       ndx = get_spc_ndx('SOA')
       if( ndx > 0 ) then
          ndx = get_spc_ndx('OC2')
          if( ndx > 0 ) then
             mw = adv_mass( ndx )
             gpm2(:) = dz(:) * asoa(:pver) * mw 
             do wn = 1,nw
                do k = 1,pver
                   rh_l  = rh_ndx(k)
                   dtsoa(k,wn)  = gpm2(k)*(qext_ocs(rh_l,wn) + del_rh(k)*qext_docs(rh_l,wn))
                   dtocs2(k,wn) = dtocs2(k,wn) + dtsoa(k,wn)
                end do
             end do
          end if
       else
          do wn = 1,nw
             dtsoa(:,wn) = 0._r8
          end do
       end if

!-----------------------------------------------------------------------------
!  	... dust
!-----------------------------------------------------------------------------
       ndx = get_spc_ndx(dust_names(1))
       if (ndx >0) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * ads(1,:pver) * mw 
          do wn = 1,nw
             dtds1(:,wn) = gpm2(:)*qext_ds1(wn)
             omds1(:,wn) = ssa_ds1(wn) 
             gds1(:,wn)  = asm_ds1(wn)
          end do
       else
          do wn = 1,nw
             dtds1(:,wn) = 0._r8
             omds1(:,wn) = 0._r8
             gds1(:,wn)  = 0._r8
          end do
       endif
       ndx = get_spc_ndx(dust_names(2))
       if (ndx >0) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * ads(2,:pver) * mw 
          do wn = 1,nw
             dtds2(:,wn) = gpm2(:)*qext_ds2(wn)
             omds2(:,wn) = ssa_ds2(wn) 
             gds2(:,wn)  = asm_ds2(wn)
          end do
       else
          do wn = 1,nw
             dtds2(:,wn) = 0._r8
             omds2(:,wn) = 0._r8
             gds2(:,wn)  = 0._r8
          end do
       endif
       ndx = get_spc_ndx(dust_names(3))
       if (ndx >0) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * ads(3,:pver) * mw 
          do wn = 1,nw
             dtds3(:,wn) = gpm2(:)*qext_ds3(wn)
             omds3(:,wn) = ssa_ds3(wn) 
             gds3(:,wn)  = asm_ds3(wn)
          end do
       else
          do wn = 1,nw
             dtds3(:,wn) = 0._r8
             omds3(:,wn) = 0._r8
             gds3(:,wn)  = 0._r8
          end do
       endif
       ndx = get_spc_ndx(dust_names(4))
       if (ndx >0) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * ads(4,:pver) * mw 
          do wn = 1,nw
             dtds4(:,wn) = gpm2(:)*qext_ds4(wn)
             omds4(:,wn) = ssa_ds4(wn) 
             gds4(:,wn)  = asm_ds4(wn)
          end do
       else
          do wn = 1,nw
             dtds4(:,wn) = 0._r8
             omds4(:,wn) = 0._r8
             gds4(:,wn)  = 0._r8
          end do
       endif

!-----------------------------------------------------------------------------
!  	... sea salts
!-----------------------------------------------------------------------------
       ndx = get_spc_ndx(progseasalts_names(1))
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * asal(:pver,1) * mw 
          do wn = 1,nw
            do k = 1,pver
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtsal(k,wn,1) = gpm2(k)*(qext_sal01(rh_l,wn) + delrh*qext_dsal01(rh_l,wn))
               omsal(k,wn,1) = ssa_sal01(rh_l,wn) + delrh*ssa_dsal01(rh_l,wn)
               gsal(k,wn,1)  = asm_sal01(rh_l,wn) + delrh*asm_dsal01(rh_l,wn)
             end do
          end do
       else
         do wn = 1,nw
            dtsal(:,wn,1) = 0._r8
            omsal(:,wn,1) = 0._r8
            gsal(:,wn,1)  = 0._r8
         end do
       end if
 
       ndx = get_spc_ndx(progseasalts_names(2))
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * asal(:pver,2) * mw 
          do wn = 1,nw
            do k = 1,pver
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtsal(k,wn,2) = gpm2(k)*(qext_sal02(rh_l,wn) + delrh*qext_dsal02(rh_l,wn))
               omsal(k,wn,2) = ssa_sal02(rh_l,wn) + delrh*ssa_dsal02(rh_l,wn)
               gsal(k,wn,2)  = asm_sal02(rh_l,wn) + delrh*asm_dsal02(rh_l,wn)
             end do
          end do
       else
         do wn = 1,nw
            dtsal(:,wn,2) = 0._r8
            omsal(:,wn,2) = 0._r8
            gsal(:,wn,2)  = 0._r8
         end do
       end if

       ndx = get_spc_ndx(progseasalts_names(3))
       if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * asal(:pver,3) * mw 
          do wn = 1,nw
            do k = 1,pver
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtsal(k,wn,3) = gpm2(k)*(qext_sal03(rh_l,wn) + delrh*qext_dsal03(rh_l,wn))
               omsal(k,wn,3) = ssa_sal03(rh_l,wn) + delrh*ssa_dsal03(rh_l,wn)
               gsal(k,wn,3)  = asm_sal03(rh_l,wn) + delrh*asm_dsal03(rh_l,wn)
            end do
         end do
       else
         do wn = 1,nw
            dtsal(:,wn,3) = 0._r8
            omsal(:,wn,3) = 0._r8
            gsal(:,wn,3)  = 0._r8
         end do
      end if

      ndx = get_spc_ndx(progseasalts_names(4))
      if( ndx > 0 ) then
          mw = adv_mass( ndx )
          gpm2(:) = dz(:) * asal(:pver,4) * mw 
          do wn = 1,nw
            do k = 1,pver
               rh_l  = rh_ndx(k)
               delrh = del_rh(k)
               dtsal(k,wn,4) = gpm2(k)*(qext_sal04(rh_l,wn) + delrh*qext_dsal04(rh_l,wn))
               omsal(k,wn,4) = ssa_sal04(rh_l,wn) + delrh*ssa_dsal04(rh_l,wn)
               gsal(k,wn,4)  = asm_sal04(rh_l,wn) + delrh*asm_dsal04(rh_l,wn)
            end do
         end do
       else
         do wn = 1,nw
            dtsal(:,wn,4) = 0._r8
            omsal(:,wn,4) = 0._r8
            gsal(:,wn,4)  = 0._r8
         end do
      end if

      end subroutine setaer

      end module mo_setaer
