
#ifndef __RNA_BLENDER_H__
#define __RNA_BLENDER_H__

/* Automatically generated function declarations for the Data API.
 * Do not edit manually, changes will be overwritten.              */

#include "RNA_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#define FOREACH_BEGIN(property, sptr, itemptr) \
	{ \
		CollectionPropertyIterator rna_macro_iter; \
		for (property##_begin(&rna_macro_iter, sptr); rna_macro_iter.valid; property##_next(&rna_macro_iter)) { \
			itemptr = rna_macro_iter.ptr;

#define FOREACH_END(property) \
		} \
		property##_end(&rna_macro_iter); \
	}

/**************** Action ****************/

extern StructRNA RNA_Action;
extern StructRNA RNA_ID;

void Action_fcurves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Action_fcurves_next(CollectionPropertyIterator *iter);
void Action_fcurves_end(CollectionPropertyIterator *iter);
int Action_fcurves_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void Action_frame_range_get(PointerRNA *ptr, float values[2]);
void Action_frame_range_set(PointerRNA *ptr, const float values[2]);

void Action_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Action_groups_next(CollectionPropertyIterator *iter);
void Action_groups_end(CollectionPropertyIterator *iter);
int Action_groups_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Action_groups_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

enum {
	Action_id_root_ACTION = 17217,
	Action_id_root_ARMATURE = 21057,
	Action_id_root_BRUSH = 21058,
	Action_id_root_CAMERA = 16707,
	Action_id_root_CURVE = 21827,
	Action_id_root_FONT = 18006,
	Action_id_root_GREASEPENCIL = 17479,
	Action_id_root_GROUP = 21063,
	Action_id_root_IMAGE = 19785,
	Action_id_root_KEY = 17739,
	Action_id_root_LAMP = 16716,
	Action_id_root_LIBRARY = 18764,
	Action_id_root_LINESTYLE = 21324,
	Action_id_root_LATTICE = 21580,
	Action_id_root_MASK = 21325,
	Action_id_root_MATERIAL = 16717,
	Action_id_root_META = 16973,
	Action_id_root_MESH = 17741,
	Action_id_root_NODETREE = 21582,
	Action_id_root_OBJECT = 16975,
	Action_id_root_PAINTCURVE = 17232,
	Action_id_root_PALETTE = 19536,
	Action_id_root_PARTICLE = 16720,
	Action_id_root_SCENE = 17235,
	Action_id_root_SCREEN = 21075,
	Action_id_root_SPEAKER = 19283,
	Action_id_root_SOUND = 20307,
	Action_id_root_TEXT = 22612,
	Action_id_root_TEXTURE = 17748,
	Action_id_root_WORLD = 20311,
	Action_id_root_WINDOWMANAGER = 19799,
};

int Action_id_root_get(PointerRNA *ptr);
void Action_id_root_set(PointerRNA *ptr, int value);

void Action_pose_markers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Action_pose_markers_next(CollectionPropertyIterator *iter);
void Action_pose_markers_end(CollectionPropertyIterator *iter);
int Action_pose_markers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Action_pose_markers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Action Actuator ****************/

extern StructRNA RNA_ActionActuator;
extern StructRNA RNA_Actuator;

PointerRNA ActionActuator_action_get(PointerRNA *ptr);

enum {
	ActionActuator_play_mode_PLAY = 0,
	ActionActuator_play_mode_PINGPONG = 1,
	ActionActuator_play_mode_FLIPPER = 2,
	ActionActuator_play_mode_LOOPSTOP = 3,
	ActionActuator_play_mode_LOOPEND = 4,
	ActionActuator_play_mode_PROPERTY = 6,
};

int ActionActuator_play_mode_get(PointerRNA *ptr);
void ActionActuator_play_mode_set(PointerRNA *ptr, int value);

int ActionActuator_use_additive_get(PointerRNA *ptr);
void ActionActuator_use_additive_set(PointerRNA *ptr, int value);

enum {
	ActionActuator_blend_mode_BLEND = 0,
	ActionActuator_blend_mode_ADD = 1,
};

int ActionActuator_blend_mode_get(PointerRNA *ptr);
void ActionActuator_blend_mode_set(PointerRNA *ptr, int value);

int ActionActuator_frame_blend_in_get(PointerRNA *ptr);
void ActionActuator_frame_blend_in_set(PointerRNA *ptr, int value);

int ActionActuator_apply_to_children_get(PointerRNA *ptr);
void ActionActuator_apply_to_children_set(PointerRNA *ptr, int value);

int ActionActuator_use_continue_last_frame_get(PointerRNA *ptr);
void ActionActuator_use_continue_last_frame_set(PointerRNA *ptr, int value);

float ActionActuator_frame_end_get(PointerRNA *ptr);
void ActionActuator_frame_end_set(PointerRNA *ptr, float value);

int ActionActuator_use_force_get(PointerRNA *ptr);
void ActionActuator_use_force_set(PointerRNA *ptr, int value);

#define ActionActuator_frame_property_MAX 64

void ActionActuator_frame_property_get(PointerRNA *ptr, char *value);
int ActionActuator_frame_property_length(PointerRNA *ptr);
void ActionActuator_frame_property_set(PointerRNA *ptr, const char *value);

int ActionActuator_use_local_get(PointerRNA *ptr);
void ActionActuator_use_local_set(PointerRNA *ptr, int value);

int ActionActuator_layer_get(PointerRNA *ptr);
void ActionActuator_layer_set(PointerRNA *ptr, int value);

float ActionActuator_layer_weight_get(PointerRNA *ptr);
void ActionActuator_layer_weight_set(PointerRNA *ptr, float value);

int ActionActuator_priority_get(PointerRNA *ptr);
void ActionActuator_priority_set(PointerRNA *ptr, int value);

#define ActionActuator_property_MAX 64

void ActionActuator_property_get(PointerRNA *ptr, char *value);
int ActionActuator_property_length(PointerRNA *ptr);
void ActionActuator_property_set(PointerRNA *ptr, const char *value);

float ActionActuator_frame_start_get(PointerRNA *ptr);
void ActionActuator_frame_start_set(PointerRNA *ptr, float value);

/**************** Action Constraint ****************/

extern StructRNA RNA_ActionConstraint;
extern StructRNA RNA_Constraint;

PointerRNA ActionConstraint_action_get(PointerRNA *ptr);

int ActionConstraint_frame_end_get(PointerRNA *ptr);
void ActionConstraint_frame_end_set(PointerRNA *ptr, int value);

float ActionConstraint_max_get(PointerRNA *ptr);
void ActionConstraint_max_set(PointerRNA *ptr, float value);

float ActionConstraint_min_get(PointerRNA *ptr);
void ActionConstraint_min_set(PointerRNA *ptr, float value);

int ActionConstraint_use_bone_object_action_get(PointerRNA *ptr);
void ActionConstraint_use_bone_object_action_set(PointerRNA *ptr, int value);

int ActionConstraint_frame_start_get(PointerRNA *ptr);
void ActionConstraint_frame_start_set(PointerRNA *ptr, int value);

#define ActionConstraint_subtarget_MAX 64

void ActionConstraint_subtarget_get(PointerRNA *ptr, char *value);
int ActionConstraint_subtarget_length(PointerRNA *ptr);
void ActionConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA ActionConstraint_target_get(PointerRNA *ptr);

enum {
	ActionConstraint_transform_channel_LOCATION_X = 20,
	ActionConstraint_transform_channel_LOCATION_Y = 21,
	ActionConstraint_transform_channel_LOCATION_Z = 22,
	ActionConstraint_transform_channel_ROTATION_X = 0,
	ActionConstraint_transform_channel_ROTATION_Y = 1,
	ActionConstraint_transform_channel_ROTATION_Z = 2,
	ActionConstraint_transform_channel_SCALE_X = 10,
	ActionConstraint_transform_channel_SCALE_Y = 11,
	ActionConstraint_transform_channel_SCALE_Z = 12,
};

int ActionConstraint_transform_channel_get(PointerRNA *ptr);
void ActionConstraint_transform_channel_set(PointerRNA *ptr, int value);

/**************** Action F-Curves ****************/

extern StructRNA RNA_ActionFCurves;

PointerRNA ActionFCurves_rna_type_get(PointerRNA *ptr);

struct FCurve *ActionFCurves_new(struct bAction *_self, ReportList *reports, const char * data_path, int index, const char * action_group);
void ActionFCurves_remove(struct bAction *_self, ReportList *reports, struct PointerRNA *fcurve);
/**************** Action Group ****************/

extern StructRNA RNA_ActionGroup;

PointerRNA ActionGroup_rna_type_get(PointerRNA *ptr);

#define ActionGroup_name_MAX 64

void ActionGroup_name_get(PointerRNA *ptr, char *value);
int ActionGroup_name_length(PointerRNA *ptr);
void ActionGroup_name_set(PointerRNA *ptr, const char *value);

void ActionGroup_channels_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ActionGroup_channels_next(CollectionPropertyIterator *iter);
void ActionGroup_channels_end(CollectionPropertyIterator *iter);

enum {
	ActionGroup_color_set_DEFAULT = 0,
	ActionGroup_color_set_THEME01 = 1,
	ActionGroup_color_set_THEME02 = 2,
	ActionGroup_color_set_THEME03 = 3,
	ActionGroup_color_set_THEME04 = 4,
	ActionGroup_color_set_THEME05 = 5,
	ActionGroup_color_set_THEME06 = 6,
	ActionGroup_color_set_THEME07 = 7,
	ActionGroup_color_set_THEME08 = 8,
	ActionGroup_color_set_THEME09 = 9,
	ActionGroup_color_set_THEME10 = 10,
	ActionGroup_color_set_THEME11 = 11,
	ActionGroup_color_set_THEME12 = 12,
	ActionGroup_color_set_THEME13 = 13,
	ActionGroup_color_set_THEME14 = 14,
	ActionGroup_color_set_THEME15 = 15,
	ActionGroup_color_set_THEME16 = 16,
	ActionGroup_color_set_THEME17 = 17,
	ActionGroup_color_set_THEME18 = 18,
	ActionGroup_color_set_THEME19 = 19,
	ActionGroup_color_set_THEME20 = 20,
	ActionGroup_color_set_CUSTOM = -1,
};

int ActionGroup_color_set_get(PointerRNA *ptr);
void ActionGroup_color_set_set(PointerRNA *ptr, int value);

PointerRNA ActionGroup_colors_get(PointerRNA *ptr);

int ActionGroup_is_custom_color_set_get(PointerRNA *ptr);
void ActionGroup_is_custom_color_set_set(PointerRNA *ptr, int value);

int ActionGroup_show_expanded_get(PointerRNA *ptr);
void ActionGroup_show_expanded_set(PointerRNA *ptr, int value);

int ActionGroup_lock_get(PointerRNA *ptr);
void ActionGroup_lock_set(PointerRNA *ptr, int value);

int ActionGroup_select_get(PointerRNA *ptr);
void ActionGroup_select_set(PointerRNA *ptr, int value);

/**************** Action Groups ****************/

extern StructRNA RNA_ActionGroups;

PointerRNA ActionGroups_rna_type_get(PointerRNA *ptr);

struct bActionGroup *ActionGroups_new(struct bAction *_self, const char * name);
void ActionGroups_remove(struct bAction *_self, ReportList *reports, struct PointerRNA *action_group);
/**************** Action Pose Markers ****************/

extern StructRNA RNA_ActionPoseMarkers;

PointerRNA ActionPoseMarkers_rna_type_get(PointerRNA *ptr);

PointerRNA ActionPoseMarkers_active_get(PointerRNA *ptr);

int ActionPoseMarkers_active_index_get(PointerRNA *ptr);
void ActionPoseMarkers_active_index_set(PointerRNA *ptr, int value);

struct TimeMarker *ActionPoseMarkers_new(struct bAction *_self, const char * name);
void ActionPoseMarkers_remove(struct bAction *_self, ReportList *reports, struct PointerRNA *marker);
/**************** Actuator ****************/

extern StructRNA RNA_Actuator;

PointerRNA Actuator_rna_type_get(PointerRNA *ptr);

#define Actuator_name_MAX 64

void Actuator_name_get(PointerRNA *ptr, char *value);
int Actuator_name_length(PointerRNA *ptr);
void Actuator_name_set(PointerRNA *ptr, const char *value);

int Actuator_active_get(PointerRNA *ptr);
void Actuator_active_set(PointerRNA *ptr, int value);

int Actuator_show_expanded_get(PointerRNA *ptr);
void Actuator_show_expanded_set(PointerRNA *ptr, int value);

int Actuator_pin_get(PointerRNA *ptr);
void Actuator_pin_set(PointerRNA *ptr, int value);

enum {
	Actuator_type_ACTION = 15,
	Actuator_type_ARMATURE = 23,
	Actuator_type_CAMERA = 3,
	Actuator_type_CONSTRAINT = 9,
	Actuator_type_EDIT_OBJECT = 10,
	Actuator_type_FILTER_2D = 19,
	Actuator_type_GAME = 17,
	Actuator_type_MESSAGE = 14,
	Actuator_type_MOUSE = 25,
	Actuator_type_MOTION = 0,
	Actuator_type_PARENT = 20,
	Actuator_type_PROPERTY = 6,
	Actuator_type_RANDOM = 13,
	Actuator_type_SCENE = 11,
	Actuator_type_SOUND = 5,
	Actuator_type_STATE = 22,
	Actuator_type_VISIBILITY = 18,
	Actuator_type_STEERING = 24,
};

int Actuator_type_get(PointerRNA *ptr);
void Actuator_type_set(PointerRNA *ptr, int value);

void Actuator_link(struct bActuator *_self, struct bController *controller);
void Actuator_unlink(struct bActuator *_self, struct bController *controller);
/**************** Actuator Sensor ****************/

extern StructRNA RNA_ActuatorSensor;
extern StructRNA RNA_Sensor;

#define ActuatorSensor_actuator_MAX 64

void ActuatorSensor_actuator_get(PointerRNA *ptr, char *value);
int ActuatorSensor_actuator_length(PointerRNA *ptr);
void ActuatorSensor_actuator_set(PointerRNA *ptr, const char *value);

/**************** Add Sequence ****************/

extern StructRNA RNA_AddSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

PointerRNA AddSequence_input_1_get(PointerRNA *ptr);

PointerRNA AddSequence_input_2_get(PointerRNA *ptr);

int AddSequence_input_count_get(PointerRNA *ptr);
void AddSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Addon ****************/

extern StructRNA RNA_Addon;

PointerRNA Addon_rna_type_get(PointerRNA *ptr);

#define Addon_module_MAX 64

void Addon_module_get(PointerRNA *ptr, char *value);
int Addon_module_length(PointerRNA *ptr);
void Addon_module_set(PointerRNA *ptr, const char *value);

PointerRNA Addon_preferences_get(PointerRNA *ptr);

/**************** Addon Preferences ****************/

extern StructRNA RNA_AddonPreferences;

PointerRNA AddonPreferences_rna_type_get(PointerRNA *ptr);

#define AddonPreferences_bl_idname_MAX 64

void AddonPreferences_bl_idname_get(PointerRNA *ptr, char *value);
int AddonPreferences_bl_idname_length(PointerRNA *ptr);
void AddonPreferences_bl_idname_set(PointerRNA *ptr, const char *value);

/**************** User Addons ****************/

extern StructRNA RNA_Addons;

PointerRNA Addons_rna_type_get(PointerRNA *ptr);

struct bAddon *Addons_new(void);
void Addons_remove(ReportList *reports, struct PointerRNA *addon);
/**************** Adjustment Layer Sequence ****************/

extern StructRNA RNA_AdjustmentSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

int AdjustmentSequence_animation_offset_end_get(PointerRNA *ptr);
void AdjustmentSequence_animation_offset_end_set(PointerRNA *ptr, int value);

int AdjustmentSequence_animation_offset_start_get(PointerRNA *ptr);
void AdjustmentSequence_animation_offset_start_set(PointerRNA *ptr, int value);

int AdjustmentSequence_input_count_get(PointerRNA *ptr);
void AdjustmentSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Alpha Over Sequence ****************/

extern StructRNA RNA_AlphaOverSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

PointerRNA AlphaOverSequence_input_1_get(PointerRNA *ptr);

PointerRNA AlphaOverSequence_input_2_get(PointerRNA *ptr);

int AlphaOverSequence_input_count_get(PointerRNA *ptr);
void AlphaOverSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Alpha Under Sequence ****************/

extern StructRNA RNA_AlphaUnderSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

PointerRNA AlphaUnderSequence_input_1_get(PointerRNA *ptr);

PointerRNA AlphaUnderSequence_input_2_get(PointerRNA *ptr);

int AlphaUnderSequence_input_count_get(PointerRNA *ptr);
void AlphaUnderSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Always Sensor ****************/

extern StructRNA RNA_AlwaysSensor;
extern StructRNA RNA_Sensor;

/**************** And Controller ****************/

extern StructRNA RNA_AndController;
extern StructRNA RNA_Controller;

/**************** Animation Data ****************/

extern StructRNA RNA_AnimData;

PointerRNA AnimData_rna_type_get(PointerRNA *ptr);

PointerRNA AnimData_action_get(PointerRNA *ptr);

enum {
	AnimData_action_blend_type_REPLACE = 0,
	AnimData_action_blend_type_ADD = 1,
	AnimData_action_blend_type_SUBTRACT = 2,
	AnimData_action_blend_type_MULTIPLY = 3,
};

int AnimData_action_blend_type_get(PointerRNA *ptr);
void AnimData_action_blend_type_set(PointerRNA *ptr, int value);

enum {
	AnimData_action_extrapolation_NOTHING = 2,
	AnimData_action_extrapolation_HOLD = 0,
	AnimData_action_extrapolation_HOLD_FORWARD = 1,
};

int AnimData_action_extrapolation_get(PointerRNA *ptr);
void AnimData_action_extrapolation_set(PointerRNA *ptr, int value);

float AnimData_action_influence_get(PointerRNA *ptr);
void AnimData_action_influence_set(PointerRNA *ptr, float value);

void AnimData_drivers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void AnimData_drivers_next(CollectionPropertyIterator *iter);
void AnimData_drivers_end(CollectionPropertyIterator *iter);
int AnimData_drivers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int AnimData_use_nla_get(PointerRNA *ptr);
void AnimData_use_nla_set(PointerRNA *ptr, int value);

void AnimData_nla_tracks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void AnimData_nla_tracks_next(CollectionPropertyIterator *iter);
void AnimData_nla_tracks_end(CollectionPropertyIterator *iter);
int AnimData_nla_tracks_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int AnimData_nla_tracks_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Drivers ****************/

extern StructRNA RNA_AnimDataDrivers;

PointerRNA AnimDataDrivers_rna_type_get(PointerRNA *ptr);

struct FCurve *AnimDataDrivers_from_existing(struct AnimData *_self, bContext *C, struct FCurve *src_driver);
/**************** Animation Visualization ****************/

extern StructRNA RNA_AnimViz;

PointerRNA AnimViz_rna_type_get(PointerRNA *ptr);

PointerRNA AnimViz_motion_path_get(PointerRNA *ptr);

PointerRNA AnimViz_onion_skin_frames_get(PointerRNA *ptr);

/**************** Motion Path Settings ****************/

extern StructRNA RNA_AnimVizMotionPaths;

PointerRNA AnimVizMotionPaths_rna_type_get(PointerRNA *ptr);

int AnimVizMotionPaths_frame_after_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_after_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_show_keyframe_action_all_get(PointerRNA *ptr);
void AnimVizMotionPaths_show_keyframe_action_all_set(PointerRNA *ptr, int value);

enum {
	AnimVizMotionPaths_bake_location_HEADS = 2,
	AnimVizMotionPaths_bake_location_TAILS = 0,
};

int AnimVizMotionPaths_bake_location_get(PointerRNA *ptr);
void AnimVizMotionPaths_bake_location_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_frame_before_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_before_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_frame_end_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_end_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_frame_step_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_step_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_show_keyframe_highlight_get(PointerRNA *ptr);
void AnimVizMotionPaths_show_keyframe_highlight_set(PointerRNA *ptr, int value);

enum {
	AnimVizMotionPaths_type_CURRENT_FRAME = 1,
	AnimVizMotionPaths_type_RANGE = 0,
};

int AnimVizMotionPaths_type_get(PointerRNA *ptr);
void AnimVizMotionPaths_type_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_show_frame_numbers_get(PointerRNA *ptr);
void AnimVizMotionPaths_show_frame_numbers_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_show_keyframe_numbers_get(PointerRNA *ptr);
void AnimVizMotionPaths_show_keyframe_numbers_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_frame_start_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_start_set(PointerRNA *ptr, int value);

/**************** Onion Skinning Settings ****************/

extern StructRNA RNA_AnimVizOnionSkinning;

PointerRNA AnimVizOnionSkinning_rna_type_get(PointerRNA *ptr);

int AnimVizOnionSkinning_frame_after_get(PointerRNA *ptr);
void AnimVizOnionSkinning_frame_after_set(PointerRNA *ptr, int value);

int AnimVizOnionSkinning_frame_before_get(PointerRNA *ptr);
void AnimVizOnionSkinning_frame_before_set(PointerRNA *ptr, int value);

int AnimVizOnionSkinning_frame_end_get(PointerRNA *ptr);
void AnimVizOnionSkinning_frame_end_set(PointerRNA *ptr, int value);

int AnimVizOnionSkinning_frame_step_get(PointerRNA *ptr);
void AnimVizOnionSkinning_frame_step_set(PointerRNA *ptr, int value);

int AnimVizOnionSkinning_show_only_selected_get(PointerRNA *ptr);
void AnimVizOnionSkinning_show_only_selected_set(PointerRNA *ptr, int value);

int AnimVizOnionSkinning_frame_start_get(PointerRNA *ptr);
void AnimVizOnionSkinning_frame_start_set(PointerRNA *ptr, int value);

enum {
	AnimVizOnionSkinning_type_NONE = 0,
	AnimVizOnionSkinning_type_CURRENT_FRAME = 1,
	AnimVizOnionSkinning_type_RANGE = 2,
	AnimVizOnionSkinning_type_KEYS = 3,
};

int AnimVizOnionSkinning_type_get(PointerRNA *ptr);
void AnimVizOnionSkinning_type_set(PointerRNA *ptr, int value);

/**************** Any Type ****************/

extern StructRNA RNA_AnyType;

PointerRNA AnyType_rna_type_get(PointerRNA *ptr);

/**************** Area ****************/

extern StructRNA RNA_Area;

PointerRNA Area_rna_type_get(PointerRNA *ptr);

enum {
	Area_type_EMPTY = 0,
	Area_type_VIEW_3D = 1,
	Area_type_TIMELINE = 15,
	Area_type_GRAPH_EDITOR = 2,
	Area_type_DOPESHEET_EDITOR = 12,
	Area_type_NLA_EDITOR = 13,
	Area_type_IMAGE_EDITOR = 6,
	Area_type_SEQUENCE_EDITOR = 8,
	Area_type_CLIP_EDITOR = 20,
	Area_type_TEXT_EDITOR = 9,
	Area_type_NODE_EDITOR = 16,
	Area_type_LOGIC_EDITOR = 17,
	Area_type_PROPERTIES = 4,
	Area_type_OUTLINER = 3,
	Area_type_USER_PREFERENCES = 19,
	Area_type_INFO = 7,
	Area_type_FILE_BROWSER = 5,
	Area_type_CONSOLE = 18,
};

int Area_type_get(PointerRNA *ptr);
void Area_type_set(PointerRNA *ptr, int value);

int Area_height_get(PointerRNA *ptr);
void Area_height_set(PointerRNA *ptr, int value);

void Area_regions_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Area_regions_next(CollectionPropertyIterator *iter);
void Area_regions_end(CollectionPropertyIterator *iter);
int Area_regions_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int Area_show_menus_get(PointerRNA *ptr);
void Area_show_menus_set(PointerRNA *ptr, int value);

void Area_spaces_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Area_spaces_next(CollectionPropertyIterator *iter);
void Area_spaces_end(CollectionPropertyIterator *iter);
int Area_spaces_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int Area_width_get(PointerRNA *ptr);
void Area_width_set(PointerRNA *ptr, int value);

int Area_x_get(PointerRNA *ptr);
void Area_x_set(PointerRNA *ptr, int value);

int Area_y_get(PointerRNA *ptr);
void Area_y_set(PointerRNA *ptr, int value);

void Area_tag_redraw(struct ScrArea *_self);
void Area_header_text_set(struct ScrArea *_self, const char * text);
/**************** Area Lamp ****************/

extern StructRNA RNA_AreaLamp;
extern StructRNA RNA_Lamp;
extern StructRNA RNA_ID;

int AreaLamp_use_auto_clip_end_get(PointerRNA *ptr);
void AreaLamp_use_auto_clip_end_set(PointerRNA *ptr, int value);

int AreaLamp_use_auto_clip_start_get(PointerRNA *ptr);
void AreaLamp_use_auto_clip_start_set(PointerRNA *ptr, int value);

float AreaLamp_compression_threshold_get(PointerRNA *ptr);
void AreaLamp_compression_threshold_set(PointerRNA *ptr, float value);

int AreaLamp_use_dither_get(PointerRNA *ptr);
void AreaLamp_use_dither_set(PointerRNA *ptr, int value);

float AreaLamp_gamma_get(PointerRNA *ptr);
void AreaLamp_gamma_set(PointerRNA *ptr, float value);

int AreaLamp_use_jitter_get(PointerRNA *ptr);
void AreaLamp_use_jitter_set(PointerRNA *ptr, int value);

int AreaLamp_use_only_shadow_get(PointerRNA *ptr);
void AreaLamp_use_only_shadow_set(PointerRNA *ptr, int value);

int AreaLamp_shadow_buffer_samples_get(PointerRNA *ptr);
void AreaLamp_shadow_buffer_samples_set(PointerRNA *ptr, int value);

float AreaLamp_shadow_adaptive_threshold_get(PointerRNA *ptr);
void AreaLamp_shadow_adaptive_threshold_set(PointerRNA *ptr, float value);

float AreaLamp_shadow_buffer_bias_get(PointerRNA *ptr);
void AreaLamp_shadow_buffer_bias_set(PointerRNA *ptr, float value);

float AreaLamp_shadow_buffer_bleed_bias_get(PointerRNA *ptr);
void AreaLamp_shadow_buffer_bleed_bias_set(PointerRNA *ptr, float value);

float AreaLamp_shadow_buffer_clip_end_get(PointerRNA *ptr);
void AreaLamp_shadow_buffer_clip_end_set(PointerRNA *ptr, float value);

float AreaLamp_shadow_buffer_clip_start_get(PointerRNA *ptr);
void AreaLamp_shadow_buffer_clip_start_set(PointerRNA *ptr, float value);

int AreaLamp_shadow_buffer_size_get(PointerRNA *ptr);
void AreaLamp_shadow_buffer_size_set(PointerRNA *ptr, int value);

float AreaLamp_shadow_buffer_soft_get(PointerRNA *ptr);
void AreaLamp_shadow_buffer_soft_set(PointerRNA *ptr, float value);

enum {
	AreaLamp_shadow_buffer_type_REGULAR = 0,
	AreaLamp_shadow_buffer_type_HALFWAY = 2,
	AreaLamp_shadow_buffer_type_IRREGULAR = 1,
	AreaLamp_shadow_buffer_type_DEEP = 3,
};

int AreaLamp_shadow_buffer_type_get(PointerRNA *ptr);
void AreaLamp_shadow_buffer_type_set(PointerRNA *ptr, int value);

void AreaLamp_shadow_color_get(PointerRNA *ptr, float values[3]);
void AreaLamp_shadow_color_set(PointerRNA *ptr, const float values[3]);

enum {
	AreaLamp_shadow_filter_type_BOX = 0,
	AreaLamp_shadow_filter_type_TENT = 1,
	AreaLamp_shadow_filter_type_GAUSS = 2,
};

int AreaLamp_shadow_filter_type_get(PointerRNA *ptr);
void AreaLamp_shadow_filter_type_set(PointerRNA *ptr, int value);

int AreaLamp_use_shadow_layer_get(PointerRNA *ptr);
void AreaLamp_use_shadow_layer_set(PointerRNA *ptr, int value);

enum {
	AreaLamp_ge_shadow_buffer_type_SIMPLE = 0,
	AreaLamp_ge_shadow_buffer_type_VARIANCE = 1,
};

int AreaLamp_ge_shadow_buffer_type_get(PointerRNA *ptr);
void AreaLamp_ge_shadow_buffer_type_set(PointerRNA *ptr, int value);

int AreaLamp_shadow_ray_samples_x_get(PointerRNA *ptr);
void AreaLamp_shadow_ray_samples_x_set(PointerRNA *ptr, int value);

int AreaLamp_shadow_ray_samples_y_get(PointerRNA *ptr);
void AreaLamp_shadow_ray_samples_y_set(PointerRNA *ptr, int value);

enum {
	AreaLamp_shadow_ray_sample_method_ADAPTIVE_QMC = 1,
	AreaLamp_shadow_ray_sample_method_CONSTANT_QMC = 2,
	AreaLamp_shadow_ray_sample_method_CONSTANT_JITTERED = 0,
};

int AreaLamp_shadow_ray_sample_method_get(PointerRNA *ptr);
void AreaLamp_shadow_ray_sample_method_set(PointerRNA *ptr, int value);

enum {
	AreaLamp_shadow_sample_buffers_BUFFERS_1 = 1,
	AreaLamp_shadow_sample_buffers_BUFFERS_4 = 4,
	AreaLamp_shadow_sample_buffers_BUFFERS_9 = 9,
};

int AreaLamp_shadow_sample_buffers_get(PointerRNA *ptr);
void AreaLamp_shadow_sample_buffers_set(PointerRNA *ptr, int value);

float AreaLamp_shadow_soft_size_get(PointerRNA *ptr);
void AreaLamp_shadow_soft_size_set(PointerRNA *ptr, float value);

enum {
	AreaLamp_shape_SQUARE = 0,
	AreaLamp_shape_RECTANGLE = 1,
};

int AreaLamp_shape_get(PointerRNA *ptr);
void AreaLamp_shape_set(PointerRNA *ptr, int value);

float AreaLamp_size_get(PointerRNA *ptr);
void AreaLamp_size_set(PointerRNA *ptr, float value);

float AreaLamp_size_y_get(PointerRNA *ptr);
void AreaLamp_size_y_set(PointerRNA *ptr, float value);

int AreaLamp_use_umbra_get(PointerRNA *ptr);
void AreaLamp_use_umbra_set(PointerRNA *ptr, int value);

enum {
	AreaLamp_shadow_method_NOSHADOW = 0,
	AreaLamp_shadow_method_RAY_SHADOW = 8192,
};

int AreaLamp_shadow_method_get(PointerRNA *ptr);
void AreaLamp_shadow_method_set(PointerRNA *ptr, int value);

int AreaLamp_use_shadow_get(PointerRNA *ptr);
void AreaLamp_use_shadow_set(PointerRNA *ptr, int value);

/**************** Area Spaces ****************/

extern StructRNA RNA_AreaSpaces;

PointerRNA AreaSpaces_rna_type_get(PointerRNA *ptr);

PointerRNA AreaSpaces_active_get(PointerRNA *ptr);

/**************** Armature ****************/

extern StructRNA RNA_Armature;
extern StructRNA RNA_ID;

PointerRNA Armature_animation_data_get(PointerRNA *ptr);

int Armature_use_auto_ik_get(PointerRNA *ptr);
void Armature_use_auto_ik_set(PointerRNA *ptr, int value);

void Armature_bones_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Armature_bones_next(CollectionPropertyIterator *iter);
void Armature_bones_end(CollectionPropertyIterator *iter);
int Armature_bones_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Armature_use_deform_delay_get(PointerRNA *ptr);
void Armature_use_deform_delay_set(PointerRNA *ptr, int value);

int Armature_show_axes_get(PointerRNA *ptr);
void Armature_show_axes_set(PointerRNA *ptr, int value);

int Armature_show_group_colors_get(PointerRNA *ptr);
void Armature_show_group_colors_set(PointerRNA *ptr, int value);

int Armature_show_bone_custom_shapes_get(PointerRNA *ptr);
void Armature_show_bone_custom_shapes_set(PointerRNA *ptr, int value);

int Armature_show_only_ghost_selected_get(PointerRNA *ptr);
void Armature_show_only_ghost_selected_set(PointerRNA *ptr, int value);

int Armature_show_names_get(PointerRNA *ptr);
void Armature_show_names_set(PointerRNA *ptr, int value);

enum {
	Armature_draw_type_OCTAHEDRAL = 0,
	Armature_draw_type_STICK = 1,
	Armature_draw_type_BBONE = 2,
	Armature_draw_type_ENVELOPE = 3,
	Armature_draw_type_WIRE = 4,
};

int Armature_draw_type_get(PointerRNA *ptr);
void Armature_draw_type_set(PointerRNA *ptr, int value);

void Armature_edit_bones_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Armature_edit_bones_next(CollectionPropertyIterator *iter);
void Armature_edit_bones_end(CollectionPropertyIterator *iter);
int Armature_edit_bones_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Armature_edit_bones_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

enum {
	Armature_ghost_type_CURRENT_FRAME = 0,
	Armature_ghost_type_RANGE = 1,
	Armature_ghost_type_KEYS = 2,
};

int Armature_ghost_type_get(PointerRNA *ptr);
void Armature_ghost_type_set(PointerRNA *ptr, int value);

int Armature_ghost_frame_end_get(PointerRNA *ptr);
void Armature_ghost_frame_end_set(PointerRNA *ptr, int value);

int Armature_ghost_size_get(PointerRNA *ptr);
void Armature_ghost_size_set(PointerRNA *ptr, int value);

int Armature_ghost_frame_start_get(PointerRNA *ptr);
void Armature_ghost_frame_start_set(PointerRNA *ptr, int value);

int Armature_ghost_step_get(PointerRNA *ptr);
void Armature_ghost_step_set(PointerRNA *ptr, int value);

int Armature_is_editmode_get(PointerRNA *ptr);
void Armature_is_editmode_set(PointerRNA *ptr, int value);

void Armature_layers_protected_get(PointerRNA *ptr, int values[32]);
void Armature_layers_protected_set(PointerRNA *ptr, const int values[32]);

enum {
	Armature_pose_position_POSE = 0,
	Armature_pose_position_REST = 1,
};

int Armature_pose_position_get(PointerRNA *ptr);
void Armature_pose_position_set(PointerRNA *ptr, int value);

enum {
	Armature_deform_method_BLENDER = 0,
	Armature_deform_method_BGE_CPU = 1,
};

int Armature_deform_method_get(PointerRNA *ptr);
void Armature_deform_method_set(PointerRNA *ptr, int value);

void Armature_layers_get(PointerRNA *ptr, int values[32]);
void Armature_layers_set(PointerRNA *ptr, const int values[32]);

int Armature_use_mirror_x_get(PointerRNA *ptr);
void Armature_use_mirror_x_set(PointerRNA *ptr, int value);

void Armature_transform(struct bArmature *_self, float matrix[16]);
/**************** Armature Actuator ****************/

extern StructRNA RNA_ArmatureActuator;
extern StructRNA RNA_Actuator;

#define ArmatureActuator_bone_MAX 64

void ArmatureActuator_bone_get(PointerRNA *ptr, char *value);
int ArmatureActuator_bone_length(PointerRNA *ptr);
void ArmatureActuator_bone_set(PointerRNA *ptr, const char *value);

#define ArmatureActuator_constraint_MAX 64

void ArmatureActuator_constraint_get(PointerRNA *ptr, char *value);
int ArmatureActuator_constraint_length(PointerRNA *ptr);
void ArmatureActuator_constraint_set(PointerRNA *ptr, const char *value);

enum {
	ArmatureActuator_mode_RUN = 0,
	ArmatureActuator_mode_ENABLE = 1,
	ArmatureActuator_mode_DISABLE = 2,
	ArmatureActuator_mode_SETTARGET = 3,
	ArmatureActuator_mode_SETWEIGHT = 4,
	ArmatureActuator_mode_SETINFLUENCE = 5,
};

int ArmatureActuator_mode_get(PointerRNA *ptr);
void ArmatureActuator_mode_set(PointerRNA *ptr, int value);

float ArmatureActuator_influence_get(PointerRNA *ptr);
void ArmatureActuator_influence_set(PointerRNA *ptr, float value);

PointerRNA ArmatureActuator_secondary_target_get(PointerRNA *ptr);

PointerRNA ArmatureActuator_target_get(PointerRNA *ptr);

float ArmatureActuator_weight_get(PointerRNA *ptr);
void ArmatureActuator_weight_set(PointerRNA *ptr, float value);

/**************** Armature Bones ****************/

extern StructRNA RNA_ArmatureBones;

PointerRNA ArmatureBones_rna_type_get(PointerRNA *ptr);

PointerRNA ArmatureBones_active_get(PointerRNA *ptr);

/**************** Armature EditBones ****************/

extern StructRNA RNA_ArmatureEditBones;

PointerRNA ArmatureEditBones_rna_type_get(PointerRNA *ptr);

PointerRNA ArmatureEditBones_active_get(PointerRNA *ptr);

struct EditBone *ArmatureEditBones_new(struct bArmature *_self, ReportList *reports, const char * name);
void ArmatureEditBones_remove(struct bArmature *_self, ReportList *reports, struct PointerRNA *bone);
/**************** Armature Modifier ****************/

extern StructRNA RNA_ArmatureModifier;
extern StructRNA RNA_Modifier;

int ArmatureModifier_invert_vertex_group_get(PointerRNA *ptr);
void ArmatureModifier_invert_vertex_group_set(PointerRNA *ptr, int value);

int ArmatureModifier_use_multi_modifier_get(PointerRNA *ptr);
void ArmatureModifier_use_multi_modifier_set(PointerRNA *ptr, int value);

PointerRNA ArmatureModifier_object_get(PointerRNA *ptr);

int ArmatureModifier_use_deform_preserve_volume_get(PointerRNA *ptr);
void ArmatureModifier_use_deform_preserve_volume_set(PointerRNA *ptr, int value);

int ArmatureModifier_use_bone_envelopes_get(PointerRNA *ptr);
void ArmatureModifier_use_bone_envelopes_set(PointerRNA *ptr, int value);

int ArmatureModifier_use_vertex_groups_get(PointerRNA *ptr);
void ArmatureModifier_use_vertex_groups_set(PointerRNA *ptr, int value);

#define ArmatureModifier_vertex_group_MAX 64

void ArmatureModifier_vertex_group_get(PointerRNA *ptr, char *value);
int ArmatureModifier_vertex_group_length(PointerRNA *ptr);
void ArmatureModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Armature Sensor ****************/

extern StructRNA RNA_ArmatureSensor;
extern StructRNA RNA_Sensor;

#define ArmatureSensor_bone_MAX 64

void ArmatureSensor_bone_get(PointerRNA *ptr, char *value);
int ArmatureSensor_bone_length(PointerRNA *ptr);
void ArmatureSensor_bone_set(PointerRNA *ptr, const char *value);

float ArmatureSensor_value_get(PointerRNA *ptr);
void ArmatureSensor_value_set(PointerRNA *ptr, float value);

#define ArmatureSensor_constraint_MAX 64

void ArmatureSensor_constraint_get(PointerRNA *ptr, char *value);
int ArmatureSensor_constraint_length(PointerRNA *ptr);
void ArmatureSensor_constraint_set(PointerRNA *ptr, const char *value);

enum {
	ArmatureSensor_test_type_STATECHG = 0,
	ArmatureSensor_test_type_LINERRORBELOW = 1,
	ArmatureSensor_test_type_LINERRORABOVE = 2,
	ArmatureSensor_test_type_ROTERRORBELOW = 3,
	ArmatureSensor_test_type_ROTERRORABOVE = 4,
};

int ArmatureSensor_test_type_get(PointerRNA *ptr);
void ArmatureSensor_test_type_set(PointerRNA *ptr, int value);

/**************** Array Modifier ****************/

extern StructRNA RNA_ArrayModifier;
extern StructRNA RNA_Modifier;

int ArrayModifier_use_constant_offset_get(PointerRNA *ptr);
void ArrayModifier_use_constant_offset_set(PointerRNA *ptr, int value);

void ArrayModifier_constant_offset_displace_get(PointerRNA *ptr, float values[3]);
void ArrayModifier_constant_offset_displace_set(PointerRNA *ptr, const float values[3]);

int ArrayModifier_count_get(PointerRNA *ptr);
void ArrayModifier_count_set(PointerRNA *ptr, int value);

PointerRNA ArrayModifier_curve_get(PointerRNA *ptr);

PointerRNA ArrayModifier_end_cap_get(PointerRNA *ptr);

enum {
	ArrayModifier_fit_type_FIXED_COUNT = 0,
	ArrayModifier_fit_type_FIT_LENGTH = 1,
	ArrayModifier_fit_type_FIT_CURVE = 2,
};

int ArrayModifier_fit_type_get(PointerRNA *ptr);
void ArrayModifier_fit_type_set(PointerRNA *ptr, int value);

float ArrayModifier_fit_length_get(PointerRNA *ptr);
void ArrayModifier_fit_length_set(PointerRNA *ptr, float value);

float ArrayModifier_merge_threshold_get(PointerRNA *ptr);
void ArrayModifier_merge_threshold_set(PointerRNA *ptr, float value);

int ArrayModifier_use_merge_vertices_get(PointerRNA *ptr);
void ArrayModifier_use_merge_vertices_set(PointerRNA *ptr, int value);

int ArrayModifier_use_merge_vertices_cap_get(PointerRNA *ptr);
void ArrayModifier_use_merge_vertices_cap_set(PointerRNA *ptr, int value);

int ArrayModifier_use_object_offset_get(PointerRNA *ptr);
void ArrayModifier_use_object_offset_set(PointerRNA *ptr, int value);

PointerRNA ArrayModifier_offset_object_get(PointerRNA *ptr);

int ArrayModifier_use_relative_offset_get(PointerRNA *ptr);
void ArrayModifier_use_relative_offset_set(PointerRNA *ptr, int value);

void ArrayModifier_relative_offset_displace_get(PointerRNA *ptr, float values[3]);
void ArrayModifier_relative_offset_displace_set(PointerRNA *ptr, const float values[3]);

PointerRNA ArrayModifier_start_cap_get(PointerRNA *ptr);

/**************** Background Image ****************/

extern StructRNA RNA_BackgroundImage;

PointerRNA BackgroundImage_rna_type_get(PointerRNA *ptr);

enum {
	BackgroundImage_source_IMAGE = 0,
	BackgroundImage_source_MOVIE_CLIP = 1,
};

int BackgroundImage_source_get(PointerRNA *ptr);
void BackgroundImage_source_set(PointerRNA *ptr, int value);

int BackgroundImage_use_camera_clip_get(PointerRNA *ptr);
void BackgroundImage_use_camera_clip_set(PointerRNA *ptr, int value);

PointerRNA BackgroundImage_clip_user_get(PointerRNA *ptr);

enum {
	BackgroundImage_draw_depth_BACK = 0,
	BackgroundImage_draw_depth_FRONT = 16,
};

int BackgroundImage_draw_depth_get(PointerRNA *ptr);
void BackgroundImage_draw_depth_set(PointerRNA *ptr, int value);

enum {
	BackgroundImage_frame_method_STRETCH = 0,
	BackgroundImage_frame_method_FIT = 32,
	BackgroundImage_frame_method_CROP = 96,
};

int BackgroundImage_frame_method_get(PointerRNA *ptr);
void BackgroundImage_frame_method_set(PointerRNA *ptr, int value);

PointerRNA BackgroundImage_image_get(PointerRNA *ptr);

enum {
	BackgroundImage_view_axis_LEFT = 8,
	BackgroundImage_view_axis_RIGHT = 16,
	BackgroundImage_view_axis_BACK = 4,
	BackgroundImage_view_axis_FRONT = 2,
	BackgroundImage_view_axis_BOTTOM = 64,
	BackgroundImage_view_axis_TOP = 32,
	BackgroundImage_view_axis_ALL = 0,
	BackgroundImage_view_axis_CAMERA = 256,
};

int BackgroundImage_view_axis_get(PointerRNA *ptr);
void BackgroundImage_view_axis_set(PointerRNA *ptr, int value);

PointerRNA BackgroundImage_image_user_get(PointerRNA *ptr);

PointerRNA BackgroundImage_clip_get(PointerRNA *ptr);

float BackgroundImage_opacity_get(PointerRNA *ptr);
void BackgroundImage_opacity_set(PointerRNA *ptr, float value);

int BackgroundImage_show_background_image_get(PointerRNA *ptr);
void BackgroundImage_show_background_image_set(PointerRNA *ptr, int value);

int BackgroundImage_show_expanded_get(PointerRNA *ptr);
void BackgroundImage_show_expanded_set(PointerRNA *ptr, int value);

int BackgroundImage_show_on_foreground_get(PointerRNA *ptr);
void BackgroundImage_show_on_foreground_set(PointerRNA *ptr, int value);

float BackgroundImage_size_get(PointerRNA *ptr);
void BackgroundImage_size_set(PointerRNA *ptr, float value);

float BackgroundImage_offset_x_get(PointerRNA *ptr);
void BackgroundImage_offset_x_set(PointerRNA *ptr, float value);

float BackgroundImage_offset_y_get(PointerRNA *ptr);
void BackgroundImage_offset_y_set(PointerRNA *ptr, float value);

/**************** Background Images ****************/

extern StructRNA RNA_BackgroundImages;

PointerRNA BackgroundImages_rna_type_get(PointerRNA *ptr);

struct BGpic *BackgroundImages_new(struct View3D *_self);
void BackgroundImages_remove(struct View3D *_self, ReportList *reports, struct PointerRNA *image);
void BackgroundImages_clear(struct View3D *_self);
/**************** Bake Pixel ****************/

extern StructRNA RNA_BakePixel;

PointerRNA BakePixel_rna_type_get(PointerRNA *ptr);

float BakePixel_du_dx_get(PointerRNA *ptr);
void BakePixel_du_dx_set(PointerRNA *ptr, float value);

float BakePixel_du_dy_get(PointerRNA *ptr);
void BakePixel_du_dy_set(PointerRNA *ptr, float value);

float BakePixel_dv_dx_get(PointerRNA *ptr);
void BakePixel_dv_dx_set(PointerRNA *ptr, float value);

float BakePixel_dv_dy_get(PointerRNA *ptr);
void BakePixel_dv_dy_set(PointerRNA *ptr, float value);

PointerRNA BakePixel_next_get(PointerRNA *ptr);

int BakePixel_primitive_id_get(PointerRNA *ptr);
void BakePixel_primitive_id_set(PointerRNA *ptr, int value);

void BakePixel_uv_get(PointerRNA *ptr, float values[2]);
void BakePixel_uv_set(PointerRNA *ptr, const float values[2]);

/**************** Bake Data ****************/

extern StructRNA RNA_BakeSettings;

PointerRNA BakeSettings_rna_type_get(PointerRNA *ptr);

int BakeSettings_use_automatic_name_get(PointerRNA *ptr);
void BakeSettings_use_automatic_name_set(PointerRNA *ptr, int value);

int BakeSettings_use_cage_get(PointerRNA *ptr);
void BakeSettings_use_cage_set(PointerRNA *ptr, int value);

float BakeSettings_cage_extrusion_get(PointerRNA *ptr);
void BakeSettings_cage_extrusion_set(PointerRNA *ptr, float value);

#define BakeSettings_cage_object_MAX 64

void BakeSettings_cage_object_get(PointerRNA *ptr, char *value);
int BakeSettings_cage_object_length(PointerRNA *ptr);
void BakeSettings_cage_object_set(PointerRNA *ptr, const char *value);

int BakeSettings_use_clear_get(PointerRNA *ptr);
void BakeSettings_use_clear_set(PointerRNA *ptr, int value);

#define BakeSettings_filepath_MAX 1024

void BakeSettings_filepath_get(PointerRNA *ptr, char *value);
int BakeSettings_filepath_length(PointerRNA *ptr);
void BakeSettings_filepath_set(PointerRNA *ptr, const char *value);

int BakeSettings_height_get(PointerRNA *ptr);
void BakeSettings_height_set(PointerRNA *ptr, int value);

PointerRNA BakeSettings_image_settings_get(PointerRNA *ptr);

int BakeSettings_margin_get(PointerRNA *ptr);
void BakeSettings_margin_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_normal_space_OBJECT = 2,
	BakeSettings_normal_space_TANGENT = 3,
};

int BakeSettings_normal_space_get(PointerRNA *ptr);
void BakeSettings_normal_space_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_normal_r_POS_X = 0,
	BakeSettings_normal_r_POS_Y = 1,
	BakeSettings_normal_r_POS_Z = 2,
	BakeSettings_normal_r_NEG_X = 3,
	BakeSettings_normal_r_NEG_Y = 4,
	BakeSettings_normal_r_NEG_Z = 5,
};

int BakeSettings_normal_r_get(PointerRNA *ptr);
void BakeSettings_normal_r_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_normal_g_POS_X = 0,
	BakeSettings_normal_g_POS_Y = 1,
	BakeSettings_normal_g_POS_Z = 2,
	BakeSettings_normal_g_NEG_X = 3,
	BakeSettings_normal_g_NEG_Y = 4,
	BakeSettings_normal_g_NEG_Z = 5,
};

int BakeSettings_normal_g_get(PointerRNA *ptr);
void BakeSettings_normal_g_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_normal_b_POS_X = 0,
	BakeSettings_normal_b_POS_Y = 1,
	BakeSettings_normal_b_POS_Z = 2,
	BakeSettings_normal_b_NEG_X = 3,
	BakeSettings_normal_b_NEG_Y = 4,
	BakeSettings_normal_b_NEG_Z = 5,
};

int BakeSettings_normal_b_get(PointerRNA *ptr);
void BakeSettings_normal_b_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_save_mode_INTERNAL = 0,
	BakeSettings_save_mode_EXTERNAL = 1,
};

int BakeSettings_save_mode_get(PointerRNA *ptr);
void BakeSettings_save_mode_set(PointerRNA *ptr, int value);

int BakeSettings_use_selected_to_active_get(PointerRNA *ptr);
void BakeSettings_use_selected_to_active_set(PointerRNA *ptr, int value);

int BakeSettings_use_split_materials_get(PointerRNA *ptr);
void BakeSettings_use_split_materials_set(PointerRNA *ptr, int value);

int BakeSettings_width_get(PointerRNA *ptr);
void BakeSettings_width_set(PointerRNA *ptr, int value);

/**************** Bevel Modifier ****************/

extern StructRNA RNA_BevelModifier;
extern StructRNA RNA_Modifier;

enum {
	BevelModifier_offset_type_OFFSET = 0,
	BevelModifier_offset_type_WIDTH = 1,
	BevelModifier_offset_type_DEPTH = 2,
	BevelModifier_offset_type_PERCENT = 3,
};

int BevelModifier_offset_type_get(PointerRNA *ptr);
void BevelModifier_offset_type_set(PointerRNA *ptr, int value);

float BevelModifier_angle_limit_get(PointerRNA *ptr);
void BevelModifier_angle_limit_set(PointerRNA *ptr, float value);

int BevelModifier_use_clamp_overlap_get(PointerRNA *ptr);
void BevelModifier_use_clamp_overlap_set(PointerRNA *ptr, int value);

enum {
	BevelModifier_edge_weight_method_AVERAGE = 0,
	BevelModifier_edge_weight_method_SHARPEST = 128,
	BevelModifier_edge_weight_method_LARGEST = 256,
};

int BevelModifier_edge_weight_method_get(PointerRNA *ptr);
void BevelModifier_edge_weight_method_set(PointerRNA *ptr, int value);

enum {
	BevelModifier_limit_method_NONE = 0,
	BevelModifier_limit_method_ANGLE = 8,
	BevelModifier_limit_method_WEIGHT = 16,
	BevelModifier_limit_method_VGROUP = 32,
};

int BevelModifier_limit_method_get(PointerRNA *ptr);
void BevelModifier_limit_method_set(PointerRNA *ptr, int value);

int BevelModifier_material_get(PointerRNA *ptr);
void BevelModifier_material_set(PointerRNA *ptr, int value);

int BevelModifier_use_only_vertices_get(PointerRNA *ptr);
void BevelModifier_use_only_vertices_set(PointerRNA *ptr, int value);

float BevelModifier_profile_get(PointerRNA *ptr);
void BevelModifier_profile_set(PointerRNA *ptr, float value);

int BevelModifier_segments_get(PointerRNA *ptr);
void BevelModifier_segments_set(PointerRNA *ptr, int value);

#define BevelModifier_vertex_group_MAX 64

void BevelModifier_vertex_group_get(PointerRNA *ptr, char *value);
int BevelModifier_vertex_group_length(PointerRNA *ptr);
void BevelModifier_vertex_group_set(PointerRNA *ptr, const char *value);

float BevelModifier_width_get(PointerRNA *ptr);
void BevelModifier_width_set(PointerRNA *ptr, float value);

/**************** Bezier Curve Point ****************/

extern StructRNA RNA_BezierSplinePoint;

PointerRNA BezierSplinePoint_rna_type_get(PointerRNA *ptr);

float BezierSplinePoint_radius_get(PointerRNA *ptr);
void BezierSplinePoint_radius_set(PointerRNA *ptr, float value);

void BezierSplinePoint_co_get(PointerRNA *ptr, float values[3]);
void BezierSplinePoint_co_set(PointerRNA *ptr, const float values[3]);

int BezierSplinePoint_select_control_point_get(PointerRNA *ptr);
void BezierSplinePoint_select_control_point_set(PointerRNA *ptr, int value);

void BezierSplinePoint_handle_left_get(PointerRNA *ptr, float values[3]);
void BezierSplinePoint_handle_left_set(PointerRNA *ptr, const float values[3]);

enum {
	BezierSplinePoint_handle_left_type_FREE = 0,
	BezierSplinePoint_handle_left_type_VECTOR = 2,
	BezierSplinePoint_handle_left_type_ALIGNED = 3,
	BezierSplinePoint_handle_left_type_AUTO = 1,
};

int BezierSplinePoint_handle_left_type_get(PointerRNA *ptr);
void BezierSplinePoint_handle_left_type_set(PointerRNA *ptr, int value);

int BezierSplinePoint_select_left_handle_get(PointerRNA *ptr);
void BezierSplinePoint_select_left_handle_set(PointerRNA *ptr, int value);

void BezierSplinePoint_handle_right_get(PointerRNA *ptr, float values[3]);
void BezierSplinePoint_handle_right_set(PointerRNA *ptr, const float values[3]);

enum {
	BezierSplinePoint_handle_right_type_FREE = 0,
	BezierSplinePoint_handle_right_type_VECTOR = 2,
	BezierSplinePoint_handle_right_type_ALIGNED = 3,
	BezierSplinePoint_handle_right_type_AUTO = 1,
};

int BezierSplinePoint_handle_right_type_get(PointerRNA *ptr);
void BezierSplinePoint_handle_right_type_set(PointerRNA *ptr, int value);

int BezierSplinePoint_select_right_handle_get(PointerRNA *ptr);
void BezierSplinePoint_select_right_handle_set(PointerRNA *ptr, int value);

int BezierSplinePoint_hide_get(PointerRNA *ptr);
void BezierSplinePoint_hide_set(PointerRNA *ptr, int value);

float BezierSplinePoint_tilt_get(PointerRNA *ptr);
void BezierSplinePoint_tilt_set(PointerRNA *ptr, float value);

float BezierSplinePoint_weight_softbody_get(PointerRNA *ptr);
void BezierSplinePoint_weight_softbody_set(PointerRNA *ptr, float value);

/**************** Blendfile Data ****************/

extern StructRNA RNA_BlendData;

PointerRNA BlendData_rna_type_get(PointerRNA *ptr);

void BlendData_actions_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_actions_next(CollectionPropertyIterator *iter);
void BlendData_actions_end(CollectionPropertyIterator *iter);

void BlendData_armatures_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_armatures_next(CollectionPropertyIterator *iter);
void BlendData_armatures_end(CollectionPropertyIterator *iter);

void BlendData_brushes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_brushes_next(CollectionPropertyIterator *iter);
void BlendData_brushes_end(CollectionPropertyIterator *iter);

void BlendData_cameras_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_cameras_next(CollectionPropertyIterator *iter);
void BlendData_cameras_end(CollectionPropertyIterator *iter);

void BlendData_curves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_curves_next(CollectionPropertyIterator *iter);
void BlendData_curves_end(CollectionPropertyIterator *iter);

int BlendData_is_dirty_get(PointerRNA *ptr);
void BlendData_is_dirty_set(PointerRNA *ptr, int value);

int BlendData_is_saved_get(PointerRNA *ptr);
void BlendData_is_saved_set(PointerRNA *ptr, int value);

#define BlendData_filepath_MAX 1024

void BlendData_filepath_get(PointerRNA *ptr, char *value);
int BlendData_filepath_length(PointerRNA *ptr);
void BlendData_filepath_set(PointerRNA *ptr, const char *value);

void BlendData_grease_pencil_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_grease_pencil_next(CollectionPropertyIterator *iter);
void BlendData_grease_pencil_end(CollectionPropertyIterator *iter);

void BlendData_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_groups_next(CollectionPropertyIterator *iter);
void BlendData_groups_end(CollectionPropertyIterator *iter);

void BlendData_images_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_images_next(CollectionPropertyIterator *iter);
void BlendData_images_end(CollectionPropertyIterator *iter);

void BlendData_lamps_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_lamps_next(CollectionPropertyIterator *iter);
void BlendData_lamps_end(CollectionPropertyIterator *iter);

void BlendData_lattices_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_lattices_next(CollectionPropertyIterator *iter);
void BlendData_lattices_end(CollectionPropertyIterator *iter);

void BlendData_libraries_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_libraries_next(CollectionPropertyIterator *iter);
void BlendData_libraries_end(CollectionPropertyIterator *iter);

void BlendData_linestyles_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_linestyles_next(CollectionPropertyIterator *iter);
void BlendData_linestyles_end(CollectionPropertyIterator *iter);

void BlendData_masks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_masks_next(CollectionPropertyIterator *iter);
void BlendData_masks_end(CollectionPropertyIterator *iter);

void BlendData_materials_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_materials_next(CollectionPropertyIterator *iter);
void BlendData_materials_end(CollectionPropertyIterator *iter);

void BlendData_meshes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_meshes_next(CollectionPropertyIterator *iter);
void BlendData_meshes_end(CollectionPropertyIterator *iter);

void BlendData_metaballs_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_metaballs_next(CollectionPropertyIterator *iter);
void BlendData_metaballs_end(CollectionPropertyIterator *iter);

void BlendData_movieclips_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_movieclips_next(CollectionPropertyIterator *iter);
void BlendData_movieclips_end(CollectionPropertyIterator *iter);

void BlendData_node_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_node_groups_next(CollectionPropertyIterator *iter);
void BlendData_node_groups_end(CollectionPropertyIterator *iter);

void BlendData_objects_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_objects_next(CollectionPropertyIterator *iter);
void BlendData_objects_end(CollectionPropertyIterator *iter);

void BlendData_particles_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_particles_next(CollectionPropertyIterator *iter);
void BlendData_particles_end(CollectionPropertyIterator *iter);

void BlendData_scenes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_scenes_next(CollectionPropertyIterator *iter);
void BlendData_scenes_end(CollectionPropertyIterator *iter);

void BlendData_screens_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_screens_next(CollectionPropertyIterator *iter);
void BlendData_screens_end(CollectionPropertyIterator *iter);

void BlendData_scripts_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_scripts_next(CollectionPropertyIterator *iter);
void BlendData_scripts_end(CollectionPropertyIterator *iter);

void BlendData_shape_keys_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_shape_keys_next(CollectionPropertyIterator *iter);
void BlendData_shape_keys_end(CollectionPropertyIterator *iter);

void BlendData_sounds_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_sounds_next(CollectionPropertyIterator *iter);
void BlendData_sounds_end(CollectionPropertyIterator *iter);

void BlendData_speakers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_speakers_next(CollectionPropertyIterator *iter);
void BlendData_speakers_end(CollectionPropertyIterator *iter);

void BlendData_texts_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_texts_next(CollectionPropertyIterator *iter);
void BlendData_texts_end(CollectionPropertyIterator *iter);

void BlendData_textures_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_textures_next(CollectionPropertyIterator *iter);
void BlendData_textures_end(CollectionPropertyIterator *iter);

int BlendData_use_autopack_get(PointerRNA *ptr);
void BlendData_use_autopack_set(PointerRNA *ptr, int value);

void BlendData_fonts_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_fonts_next(CollectionPropertyIterator *iter);
void BlendData_fonts_end(CollectionPropertyIterator *iter);

void BlendData_version_get(PointerRNA *ptr, int values[3]);
void BlendData_version_set(PointerRNA *ptr, const int values[3]);

void BlendData_window_managers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_window_managers_next(CollectionPropertyIterator *iter);
void BlendData_window_managers_end(CollectionPropertyIterator *iter);

void BlendData_worlds_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_worlds_next(CollectionPropertyIterator *iter);
void BlendData_worlds_end(CollectionPropertyIterator *iter);

/**************** Main Actions ****************/

extern StructRNA RNA_BlendDataActions;

PointerRNA BlendDataActions_rna_type_get(PointerRNA *ptr);

int BlendDataActions_is_updated_get(PointerRNA *ptr);
void BlendDataActions_is_updated_set(PointerRNA *ptr, int value);

struct bAction *BlendDataActions_new(struct Main *_self, const char * name);
void BlendDataActions_remove(struct Main *_self, ReportList *reports, struct PointerRNA *action);
void BlendDataActions_tag(struct Main *_self, int value);
/**************** Main Armatures ****************/

extern StructRNA RNA_BlendDataArmatures;

PointerRNA BlendDataArmatures_rna_type_get(PointerRNA *ptr);

int BlendDataArmatures_is_updated_get(PointerRNA *ptr);
void BlendDataArmatures_is_updated_set(PointerRNA *ptr, int value);

struct bArmature *BlendDataArmatures_new(struct Main *_self, const char * name);
void BlendDataArmatures_remove(struct Main *_self, ReportList *reports, struct PointerRNA *armature);
void BlendDataArmatures_tag(struct Main *_self, int value);
/**************** Main Brushes ****************/

extern StructRNA RNA_BlendDataBrushes;

PointerRNA BlendDataBrushes_rna_type_get(PointerRNA *ptr);

int BlendDataBrushes_is_updated_get(PointerRNA *ptr);
void BlendDataBrushes_is_updated_set(PointerRNA *ptr, int value);

struct Brush *BlendDataBrushes_new(struct Main *_self, const char * name);
void BlendDataBrushes_remove(struct Main *_self, ReportList *reports, struct PointerRNA *brush);
void BlendDataBrushes_tag(struct Main *_self, int value);
/**************** Main Cameras ****************/

extern StructRNA RNA_BlendDataCameras;

PointerRNA BlendDataCameras_rna_type_get(PointerRNA *ptr);

int BlendDataCameras_is_updated_get(PointerRNA *ptr);
void BlendDataCameras_is_updated_set(PointerRNA *ptr, int value);

struct Camera *BlendDataCameras_new(struct Main *_self, const char * name);
void BlendDataCameras_remove(struct Main *_self, ReportList *reports, struct PointerRNA *camera);
void BlendDataCameras_tag(struct Main *_self, int value);
/**************** Main Curves ****************/

extern StructRNA RNA_BlendDataCurves;

PointerRNA BlendDataCurves_rna_type_get(PointerRNA *ptr);

int BlendDataCurves_is_updated_get(PointerRNA *ptr);
void BlendDataCurves_is_updated_set(PointerRNA *ptr, int value);

struct Curve *BlendDataCurves_new(struct Main *_self, const char * name, int type);
void BlendDataCurves_remove(struct Main *_self, ReportList *reports, struct PointerRNA *curve);
void BlendDataCurves_tag(struct Main *_self, int value);
/**************** Main Fonts ****************/

extern StructRNA RNA_BlendDataFonts;

PointerRNA BlendDataFonts_rna_type_get(PointerRNA *ptr);

int BlendDataFonts_is_updated_get(PointerRNA *ptr);
void BlendDataFonts_is_updated_set(PointerRNA *ptr, int value);

struct VFont *BlendDataFonts_load(struct Main *_self, ReportList *reports, const char * filepath);
void BlendDataFonts_remove(struct Main *_self, ReportList *reports, struct PointerRNA *vfont);
void BlendDataFonts_tag(struct Main *_self, int value);
/**************** Main Grease Pencils ****************/

extern StructRNA RNA_BlendDataGreasePencils;

PointerRNA BlendDataGreasePencils_rna_type_get(PointerRNA *ptr);

int BlendDataGreasePencils_is_updated_get(PointerRNA *ptr);
void BlendDataGreasePencils_is_updated_set(PointerRNA *ptr, int value);

void BlendDataGreasePencils_tag(struct Main *_self, int value);
struct bGPdata *BlendDataGreasePencils_new(const char * name);
void BlendDataGreasePencils_remove(struct Main *_self, ReportList *reports, struct PointerRNA *grease_pencil);
/**************** Main Groups ****************/

extern StructRNA RNA_BlendDataGroups;

PointerRNA BlendDataGroups_rna_type_get(PointerRNA *ptr);

int BlendDataGroups_is_updated_get(PointerRNA *ptr);
void BlendDataGroups_is_updated_set(PointerRNA *ptr, int value);

struct Group *BlendDataGroups_new(struct Main *_self, const char * name);
void BlendDataGroups_remove(struct Main *_self, struct PointerRNA *group);
void BlendDataGroups_tag(struct Main *_self, int value);
/**************** Main Images ****************/

extern StructRNA RNA_BlendDataImages;

PointerRNA BlendDataImages_rna_type_get(PointerRNA *ptr);

int BlendDataImages_is_updated_get(PointerRNA *ptr);
void BlendDataImages_is_updated_set(PointerRNA *ptr, int value);

struct Image *BlendDataImages_new(struct Main *_self, const char * name, int width, int height, int alpha, int float_buffer);
struct Image *BlendDataImages_load(struct Main *_self, ReportList *reports, const char * filepath);
void BlendDataImages_remove(struct Main *_self, ReportList *reports, struct PointerRNA *image);
void BlendDataImages_tag(struct Main *_self, int value);
/**************** Main Lamps ****************/

extern StructRNA RNA_BlendDataLamps;

PointerRNA BlendDataLamps_rna_type_get(PointerRNA *ptr);

int BlendDataLamps_is_updated_get(PointerRNA *ptr);
void BlendDataLamps_is_updated_set(PointerRNA *ptr, int value);

struct Lamp *BlendDataLamps_new(struct Main *_self, const char * name, int type);
void BlendDataLamps_remove(struct Main *_self, ReportList *reports, struct PointerRNA *lamp);
void BlendDataLamps_tag(struct Main *_self, int value);
/**************** Main Lattices ****************/

extern StructRNA RNA_BlendDataLattices;

PointerRNA BlendDataLattices_rna_type_get(PointerRNA *ptr);

int BlendDataLattices_is_updated_get(PointerRNA *ptr);
void BlendDataLattices_is_updated_set(PointerRNA *ptr, int value);

struct Lattice *BlendDataLattices_new(struct Main *_self, const char * name);
void BlendDataLattices_remove(struct Main *_self, ReportList *reports, struct PointerRNA *lattice);
void BlendDataLattices_tag(struct Main *_self, int value);
/**************** Main Libraries ****************/

extern StructRNA RNA_BlendDataLibraries;

PointerRNA BlendDataLibraries_rna_type_get(PointerRNA *ptr);

int BlendDataLibraries_is_updated_get(PointerRNA *ptr);
void BlendDataLibraries_is_updated_set(PointerRNA *ptr, int value);

void BlendDataLibraries_tag(struct Main *_self, int value);
/**************** Main Line Styles ****************/

extern StructRNA RNA_BlendDataLineStyles;

PointerRNA BlendDataLineStyles_rna_type_get(PointerRNA *ptr);

int BlendDataLineStyles_is_updated_get(PointerRNA *ptr);
void BlendDataLineStyles_is_updated_set(PointerRNA *ptr, int value);

void BlendDataLineStyles_tag(struct Main *_self, int value);
struct FreestyleLineStyle *BlendDataLineStyles_new(struct Main *_self, const char * name);
void BlendDataLineStyles_remove(struct Main *_self, ReportList *reports, struct FreestyleLineStyle *linestyle);
/**************** Main Masks ****************/

extern StructRNA RNA_BlendDataMasks;

PointerRNA BlendDataMasks_rna_type_get(PointerRNA *ptr);

void BlendDataMasks_tag(struct Main *_self, int value);
struct Mask *BlendDataMasks_new(struct Main *_self, const char * name);
void BlendDataMasks_remove(struct Main *_self, struct PointerRNA *mask);
/**************** Main Materials ****************/

extern StructRNA RNA_BlendDataMaterials;

PointerRNA BlendDataMaterials_rna_type_get(PointerRNA *ptr);

int BlendDataMaterials_is_updated_get(PointerRNA *ptr);
void BlendDataMaterials_is_updated_set(PointerRNA *ptr, int value);

struct Material *BlendDataMaterials_new(struct Main *_self, const char * name);
void BlendDataMaterials_remove(struct Main *_self, ReportList *reports, struct PointerRNA *material);
void BlendDataMaterials_tag(struct Main *_self, int value);
/**************** Main Meshes ****************/

extern StructRNA RNA_BlendDataMeshes;

PointerRNA BlendDataMeshes_rna_type_get(PointerRNA *ptr);

int BlendDataMeshes_is_updated_get(PointerRNA *ptr);
void BlendDataMeshes_is_updated_set(PointerRNA *ptr, int value);

struct Mesh *BlendDataMeshes_new(struct Main *_self, const char * name);
struct Mesh *BlendDataMeshes_new_from_object(struct Main *_self, ReportList *reports, struct Scene *scene, struct Object *object, int apply_modifiers, int settings, int calc_tessface, int calc_undeformed);
void BlendDataMeshes_remove(struct Main *_self, ReportList *reports, struct PointerRNA *mesh);
void BlendDataMeshes_tag(struct Main *_self, int value);
/**************** Main Metaballs ****************/

extern StructRNA RNA_BlendDataMetaBalls;

PointerRNA BlendDataMetaBalls_rna_type_get(PointerRNA *ptr);

int BlendDataMetaBalls_is_updated_get(PointerRNA *ptr);
void BlendDataMetaBalls_is_updated_set(PointerRNA *ptr, int value);

struct MetaBall *BlendDataMetaBalls_new(struct Main *_self, const char * name);
void BlendDataMetaBalls_remove(struct Main *_self, ReportList *reports, struct PointerRNA *metaball);
void BlendDataMetaBalls_tag(struct Main *_self, int value);
/**************** Main Movie Clips ****************/

extern StructRNA RNA_BlendDataMovieClips;

PointerRNA BlendDataMovieClips_rna_type_get(PointerRNA *ptr);

void BlendDataMovieClips_tag(struct Main *_self, int value);
void BlendDataMovieClips_remove(struct Main *_self, struct PointerRNA *clip);
struct MovieClip *BlendDataMovieClips_load(struct Main *_self, ReportList *reports, const char * filepath);
/**************** Main Node Trees ****************/

extern StructRNA RNA_BlendDataNodeTrees;

PointerRNA BlendDataNodeTrees_rna_type_get(PointerRNA *ptr);

int BlendDataNodeTrees_is_updated_get(PointerRNA *ptr);
void BlendDataNodeTrees_is_updated_set(PointerRNA *ptr, int value);

struct bNodeTree *BlendDataNodeTrees_new(struct Main *_self, const char * name, int type);
void BlendDataNodeTrees_remove(struct Main *_self, ReportList *reports, struct PointerRNA *tree);
void BlendDataNodeTrees_tag(struct Main *_self, int value);
/**************** Main Objects ****************/

extern StructRNA RNA_BlendDataObjects;

PointerRNA BlendDataObjects_rna_type_get(PointerRNA *ptr);

int BlendDataObjects_is_updated_get(PointerRNA *ptr);
void BlendDataObjects_is_updated_set(PointerRNA *ptr, int value);

struct Object *BlendDataObjects_new(struct Main *_self, ReportList *reports, const char * name, struct ID *object_data);
void BlendDataObjects_remove(struct Main *_self, ReportList *reports, struct PointerRNA *object);
void BlendDataObjects_tag(struct Main *_self, int value);
/**************** Main Particle Settings ****************/

extern StructRNA RNA_BlendDataParticles;

PointerRNA BlendDataParticles_rna_type_get(PointerRNA *ptr);

int BlendDataParticles_is_updated_get(PointerRNA *ptr);
void BlendDataParticles_is_updated_set(PointerRNA *ptr, int value);

struct ParticleSettings *BlendDataParticles_new(struct Main *_self, const char * name);
void BlendDataParticles_remove(struct Main *_self, ReportList *reports, struct PointerRNA *particle);
void BlendDataParticles_tag(struct Main *_self, int value);
/**************** Main Scenes ****************/

extern StructRNA RNA_BlendDataScenes;

PointerRNA BlendDataScenes_rna_type_get(PointerRNA *ptr);

int BlendDataScenes_is_updated_get(PointerRNA *ptr);
void BlendDataScenes_is_updated_set(PointerRNA *ptr, int value);

struct Scene *BlendDataScenes_new(struct Main *_self, const char * name);
void BlendDataScenes_remove(struct Main *_self, bContext *C, ReportList *reports, struct PointerRNA *scene);
void BlendDataScenes_tag(struct Main *_self, int value);
/**************** Main Screens ****************/

extern StructRNA RNA_BlendDataScreens;

PointerRNA BlendDataScreens_rna_type_get(PointerRNA *ptr);

int BlendDataScreens_is_updated_get(PointerRNA *ptr);
void BlendDataScreens_is_updated_set(PointerRNA *ptr, int value);

void BlendDataScreens_tag(struct Main *_self, int value);
/**************** Main Sounds ****************/

extern StructRNA RNA_BlendDataSounds;

PointerRNA BlendDataSounds_rna_type_get(PointerRNA *ptr);

int BlendDataSounds_is_updated_get(PointerRNA *ptr);
void BlendDataSounds_is_updated_set(PointerRNA *ptr, int value);

void BlendDataSounds_tag(struct Main *_self, int value);
/**************** Main Speakers ****************/

extern StructRNA RNA_BlendDataSpeakers;

PointerRNA BlendDataSpeakers_rna_type_get(PointerRNA *ptr);

int BlendDataSpeakers_is_updated_get(PointerRNA *ptr);
void BlendDataSpeakers_is_updated_set(PointerRNA *ptr, int value);

struct Speaker *BlendDataSpeakers_new(struct Main *_self, const char * name);
void BlendDataSpeakers_remove(struct Main *_self, ReportList *reports, struct PointerRNA *speaker);
void BlendDataSpeakers_tag(struct Main *_self, int value);
/**************** Main Texts ****************/

extern StructRNA RNA_BlendDataTexts;

PointerRNA BlendDataTexts_rna_type_get(PointerRNA *ptr);

int BlendDataTexts_is_updated_get(PointerRNA *ptr);
void BlendDataTexts_is_updated_set(PointerRNA *ptr, int value);

struct Text *BlendDataTexts_new(struct Main *_self, const char * name);
void BlendDataTexts_remove(struct Main *_self, struct PointerRNA *text);
struct Text *BlendDataTexts_load(struct Main *_self, ReportList *reports, const char * filepath, int internal);
void BlendDataTexts_tag(struct Main *_self, int value);
/**************** Main Textures ****************/

extern StructRNA RNA_BlendDataTextures;

PointerRNA BlendDataTextures_rna_type_get(PointerRNA *ptr);

int BlendDataTextures_is_updated_get(PointerRNA *ptr);
void BlendDataTextures_is_updated_set(PointerRNA *ptr, int value);

struct Tex *BlendDataTextures_new(struct Main *_self, const char * name, int type);
void BlendDataTextures_remove(struct Main *_self, ReportList *reports, struct PointerRNA *texture);
void BlendDataTextures_tag(struct Main *_self, int value);
/**************** Main Window Managers ****************/

extern StructRNA RNA_BlendDataWindowManagers;

PointerRNA BlendDataWindowManagers_rna_type_get(PointerRNA *ptr);

int BlendDataWindowManagers_is_updated_get(PointerRNA *ptr);
void BlendDataWindowManagers_is_updated_set(PointerRNA *ptr, int value);

void BlendDataWindowManagers_tag(struct Main *_self, int value);
/**************** Main Worlds ****************/

extern StructRNA RNA_BlendDataWorlds;

PointerRNA BlendDataWorlds_rna_type_get(PointerRNA *ptr);

int BlendDataWorlds_is_updated_get(PointerRNA *ptr);
void BlendDataWorlds_is_updated_set(PointerRNA *ptr, int value);

struct World *BlendDataWorlds_new(struct Main *_self, const char * name);
void BlendDataWorlds_remove(struct Main *_self, ReportList *reports, struct PointerRNA *world);
void BlendDataWorlds_tag(struct Main *_self, int value);
/**************** Blend Texture ****************/

extern StructRNA RNA_BlendTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

enum {
	BlendTexture_use_flip_axis_HORIZONTAL = 0,
	BlendTexture_use_flip_axis_VERTICAL = 2,
};

int BlendTexture_use_flip_axis_get(PointerRNA *ptr);
void BlendTexture_use_flip_axis_set(PointerRNA *ptr, int value);

enum {
	BlendTexture_progression_LINEAR = 0,
	BlendTexture_progression_QUADRATIC = 1,
	BlendTexture_progression_EASING = 2,
	BlendTexture_progression_DIAGONAL = 3,
	BlendTexture_progression_SPHERICAL = 4,
	BlendTexture_progression_QUADRATIC_SPHERE = 5,
	BlendTexture_progression_RADIAL = 6,
};

int BlendTexture_progression_get(PointerRNA *ptr);
void BlendTexture_progression_set(PointerRNA *ptr, int value);

/**************** Blender RNA ****************/

extern StructRNA RNA_BlenderRNA;

PointerRNA BlenderRNA_rna_type_get(PointerRNA *ptr);

void BlenderRNA_structs_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlenderRNA_structs_next(CollectionPropertyIterator *iter);
void BlenderRNA_structs_end(CollectionPropertyIterator *iter);
int BlenderRNA_structs_length(PointerRNA *ptr);
int BlenderRNA_structs_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int BlenderRNA_structs_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Boid Rule ****************/

extern StructRNA RNA_BoidRule;

PointerRNA BoidRule_rna_type_get(PointerRNA *ptr);

#define BoidRule_name_MAX 32

void BoidRule_name_get(PointerRNA *ptr, char *value);
int BoidRule_name_length(PointerRNA *ptr);
void BoidRule_name_set(PointerRNA *ptr, const char *value);

int BoidRule_use_in_air_get(PointerRNA *ptr);
void BoidRule_use_in_air_set(PointerRNA *ptr, int value);

int BoidRule_use_on_land_get(PointerRNA *ptr);
void BoidRule_use_on_land_set(PointerRNA *ptr, int value);

enum {
	BoidRule_type_GOAL = 1,
	BoidRule_type_AVOID = 2,
	BoidRule_type_AVOID_COLLISION = 3,
	BoidRule_type_SEPARATE = 4,
	BoidRule_type_FLOCK = 5,
	BoidRule_type_FOLLOW_LEADER = 6,
	BoidRule_type_AVERAGE_SPEED = 7,
	BoidRule_type_FIGHT = 8,
};

int BoidRule_type_get(PointerRNA *ptr);
void BoidRule_type_set(PointerRNA *ptr, int value);

/**************** Average Speed ****************/

extern StructRNA RNA_BoidRuleAverageSpeed;
extern StructRNA RNA_BoidRule;

float BoidRuleAverageSpeed_level_get(PointerRNA *ptr);
void BoidRuleAverageSpeed_level_set(PointerRNA *ptr, float value);

float BoidRuleAverageSpeed_speed_get(PointerRNA *ptr);
void BoidRuleAverageSpeed_speed_set(PointerRNA *ptr, float value);

float BoidRuleAverageSpeed_wander_get(PointerRNA *ptr);
void BoidRuleAverageSpeed_wander_set(PointerRNA *ptr, float value);

/**************** Avoid ****************/

extern StructRNA RNA_BoidRuleAvoid;
extern StructRNA RNA_BoidRule;

float BoidRuleAvoid_fear_factor_get(PointerRNA *ptr);
void BoidRuleAvoid_fear_factor_set(PointerRNA *ptr, float value);

PointerRNA BoidRuleAvoid_object_get(PointerRNA *ptr);

int BoidRuleAvoid_use_predict_get(PointerRNA *ptr);
void BoidRuleAvoid_use_predict_set(PointerRNA *ptr, int value);

/**************** Avoid Collision ****************/

extern StructRNA RNA_BoidRuleAvoidCollision;
extern StructRNA RNA_BoidRule;

int BoidRuleAvoidCollision_use_avoid_get(PointerRNA *ptr);
void BoidRuleAvoidCollision_use_avoid_set(PointerRNA *ptr, int value);

int BoidRuleAvoidCollision_use_avoid_collision_get(PointerRNA *ptr);
void BoidRuleAvoidCollision_use_avoid_collision_set(PointerRNA *ptr, int value);

float BoidRuleAvoidCollision_look_ahead_get(PointerRNA *ptr);
void BoidRuleAvoidCollision_look_ahead_set(PointerRNA *ptr, float value);

/**************** Fight ****************/

extern StructRNA RNA_BoidRuleFight;
extern StructRNA RNA_BoidRule;

float BoidRuleFight_distance_get(PointerRNA *ptr);
void BoidRuleFight_distance_set(PointerRNA *ptr, float value);

float BoidRuleFight_flee_distance_get(PointerRNA *ptr);
void BoidRuleFight_flee_distance_set(PointerRNA *ptr, float value);

/**************** Follow Leader ****************/

extern StructRNA RNA_BoidRuleFollowLeader;
extern StructRNA RNA_BoidRule;

float BoidRuleFollowLeader_distance_get(PointerRNA *ptr);
void BoidRuleFollowLeader_distance_set(PointerRNA *ptr, float value);

int BoidRuleFollowLeader_use_line_get(PointerRNA *ptr);
void BoidRuleFollowLeader_use_line_set(PointerRNA *ptr, int value);

PointerRNA BoidRuleFollowLeader_object_get(PointerRNA *ptr);

int BoidRuleFollowLeader_queue_count_get(PointerRNA *ptr);
void BoidRuleFollowLeader_queue_count_set(PointerRNA *ptr, int value);

/**************** Goal ****************/

extern StructRNA RNA_BoidRuleGoal;
extern StructRNA RNA_BoidRule;

PointerRNA BoidRuleGoal_object_get(PointerRNA *ptr);

int BoidRuleGoal_use_predict_get(PointerRNA *ptr);
void BoidRuleGoal_use_predict_set(PointerRNA *ptr, int value);

/**************** Boid Settings ****************/

extern StructRNA RNA_BoidSettings;

PointerRNA BoidSettings_rna_type_get(PointerRNA *ptr);

float BoidSettings_accuracy_get(PointerRNA *ptr);
void BoidSettings_accuracy_set(PointerRNA *ptr, float value);

PointerRNA BoidSettings_active_boid_state_get(PointerRNA *ptr);

int BoidSettings_active_boid_state_index_get(PointerRNA *ptr);
void BoidSettings_active_boid_state_index_set(PointerRNA *ptr, int value);

float BoidSettings_aggression_get(PointerRNA *ptr);
void BoidSettings_aggression_set(PointerRNA *ptr, float value);

float BoidSettings_air_personal_space_get(PointerRNA *ptr);
void BoidSettings_air_personal_space_set(PointerRNA *ptr, float value);

int BoidSettings_use_climb_get(PointerRNA *ptr);
void BoidSettings_use_climb_set(PointerRNA *ptr, int value);

int BoidSettings_use_flight_get(PointerRNA *ptr);
void BoidSettings_use_flight_set(PointerRNA *ptr, int value);

int BoidSettings_use_land_get(PointerRNA *ptr);
void BoidSettings_use_land_set(PointerRNA *ptr, int value);

float BoidSettings_bank_get(PointerRNA *ptr);
void BoidSettings_bank_set(PointerRNA *ptr, float value);

void BoidSettings_states_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BoidSettings_states_next(CollectionPropertyIterator *iter);
void BoidSettings_states_end(CollectionPropertyIterator *iter);
int BoidSettings_states_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int BoidSettings_states_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float BoidSettings_health_get(PointerRNA *ptr);
void BoidSettings_health_set(PointerRNA *ptr, float value);

float BoidSettings_height_get(PointerRNA *ptr);
void BoidSettings_height_set(PointerRNA *ptr, float value);

float BoidSettings_land_jump_speed_get(PointerRNA *ptr);
void BoidSettings_land_jump_speed_set(PointerRNA *ptr, float value);

float BoidSettings_land_personal_space_get(PointerRNA *ptr);
void BoidSettings_land_personal_space_set(PointerRNA *ptr, float value);

float BoidSettings_land_stick_force_get(PointerRNA *ptr);
void BoidSettings_land_stick_force_set(PointerRNA *ptr, float value);

float BoidSettings_land_smooth_get(PointerRNA *ptr);
void BoidSettings_land_smooth_set(PointerRNA *ptr, float value);

float BoidSettings_air_acc_max_get(PointerRNA *ptr);
void BoidSettings_air_acc_max_set(PointerRNA *ptr, float value);

float BoidSettings_air_ave_max_get(PointerRNA *ptr);
void BoidSettings_air_ave_max_set(PointerRNA *ptr, float value);

float BoidSettings_air_speed_max_get(PointerRNA *ptr);
void BoidSettings_air_speed_max_set(PointerRNA *ptr, float value);

float BoidSettings_land_acc_max_get(PointerRNA *ptr);
void BoidSettings_land_acc_max_set(PointerRNA *ptr, float value);

float BoidSettings_land_ave_max_get(PointerRNA *ptr);
void BoidSettings_land_ave_max_set(PointerRNA *ptr, float value);

float BoidSettings_land_speed_max_get(PointerRNA *ptr);
void BoidSettings_land_speed_max_set(PointerRNA *ptr, float value);

float BoidSettings_air_speed_min_get(PointerRNA *ptr);
void BoidSettings_air_speed_min_set(PointerRNA *ptr, float value);

float BoidSettings_pitch_get(PointerRNA *ptr);
void BoidSettings_pitch_set(PointerRNA *ptr, float value);

float BoidSettings_range_get(PointerRNA *ptr);
void BoidSettings_range_set(PointerRNA *ptr, float value);

float BoidSettings_strength_get(PointerRNA *ptr);
void BoidSettings_strength_set(PointerRNA *ptr, float value);

/**************** Boid State ****************/

extern StructRNA RNA_BoidState;

PointerRNA BoidState_rna_type_get(PointerRNA *ptr);

#define BoidState_name_MAX 32

void BoidState_name_get(PointerRNA *ptr, char *value);
int BoidState_name_length(PointerRNA *ptr);
void BoidState_name_set(PointerRNA *ptr, const char *value);

PointerRNA BoidState_active_boid_rule_get(PointerRNA *ptr);

int BoidState_active_boid_rule_index_get(PointerRNA *ptr);
void BoidState_active_boid_rule_index_set(PointerRNA *ptr, int value);

void BoidState_rules_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BoidState_rules_next(CollectionPropertyIterator *iter);
void BoidState_rules_end(CollectionPropertyIterator *iter);
int BoidState_rules_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int BoidState_rules_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float BoidState_falloff_get(PointerRNA *ptr);
void BoidState_falloff_set(PointerRNA *ptr, float value);

enum {
	BoidState_ruleset_type_FUZZY = 0,
	BoidState_ruleset_type_RANDOM = 1,
	BoidState_ruleset_type_AVERAGE = 2,
};

int BoidState_ruleset_type_get(PointerRNA *ptr);
void BoidState_ruleset_type_set(PointerRNA *ptr, int value);

float BoidState_rule_fuzzy_get(PointerRNA *ptr);
void BoidState_rule_fuzzy_set(PointerRNA *ptr, float value);

float BoidState_volume_get(PointerRNA *ptr);
void BoidState_volume_set(PointerRNA *ptr, float value);

/**************** Bone ****************/

extern StructRNA RNA_Bone;

PointerRNA Bone_rna_type_get(PointerRNA *ptr);

#define Bone_name_MAX 64

void Bone_name_get(PointerRNA *ptr, char *value);
int Bone_name_length(PointerRNA *ptr);
void Bone_name_set(PointerRNA *ptr, const char *value);

void Bone_head_local_get(PointerRNA *ptr, float values[3]);
void Bone_head_local_set(PointerRNA *ptr, const float values[3]);

void Bone_tail_local_get(PointerRNA *ptr, float values[3]);
void Bone_tail_local_set(PointerRNA *ptr, const float values[3]);

float Bone_bbone_x_get(PointerRNA *ptr);
void Bone_bbone_x_set(PointerRNA *ptr, float value);

float Bone_bbone_z_get(PointerRNA *ptr);
void Bone_bbone_z_set(PointerRNA *ptr, float value);

float Bone_bbone_in_get(PointerRNA *ptr);
void Bone_bbone_in_set(PointerRNA *ptr, float value);

float Bone_bbone_out_get(PointerRNA *ptr);
void Bone_bbone_out_set(PointerRNA *ptr, float value);

int Bone_bbone_segments_get(PointerRNA *ptr);
void Bone_bbone_segments_set(PointerRNA *ptr, int value);

void Bone_matrix_local_get(PointerRNA *ptr, float values[16]);
void Bone_matrix_local_set(PointerRNA *ptr, const float values[16]);

void Bone_matrix_get(PointerRNA *ptr, float values[9]);
void Bone_matrix_set(PointerRNA *ptr, const float values[9]);

void Bone_children_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Bone_children_next(CollectionPropertyIterator *iter);
void Bone_children_end(CollectionPropertyIterator *iter);
int Bone_children_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Bone_children_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Bone_use_connect_get(PointerRNA *ptr);
void Bone_use_connect_set(PointerRNA *ptr, int value);

int Bone_use_cyclic_offset_get(PointerRNA *ptr);
void Bone_use_cyclic_offset_set(PointerRNA *ptr, int value);

int Bone_use_deform_get(PointerRNA *ptr);
void Bone_use_deform_set(PointerRNA *ptr, int value);

int Bone_show_wire_get(PointerRNA *ptr);
void Bone_show_wire_set(PointerRNA *ptr, int value);

float Bone_envelope_distance_get(PointerRNA *ptr);
void Bone_envelope_distance_set(PointerRNA *ptr, float value);

float Bone_envelope_weight_get(PointerRNA *ptr);
void Bone_envelope_weight_set(PointerRNA *ptr, float value);

float Bone_head_radius_get(PointerRNA *ptr);
void Bone_head_radius_set(PointerRNA *ptr, float value);

float Bone_tail_radius_get(PointerRNA *ptr);
void Bone_tail_radius_set(PointerRNA *ptr, float value);

void Bone_head_get(PointerRNA *ptr, float values[3]);
void Bone_head_set(PointerRNA *ptr, const float values[3]);

int Bone_hide_get(PointerRNA *ptr);
void Bone_hide_set(PointerRNA *ptr, int value);

int Bone_use_inherit_rotation_get(PointerRNA *ptr);
void Bone_use_inherit_rotation_set(PointerRNA *ptr, int value);

int Bone_use_inherit_scale_get(PointerRNA *ptr);
void Bone_use_inherit_scale_set(PointerRNA *ptr, int value);

void Bone_layers_get(PointerRNA *ptr, int values[32]);
void Bone_layers_set(PointerRNA *ptr, const int values[32]);

int Bone_use_local_location_get(PointerRNA *ptr);
void Bone_use_local_location_set(PointerRNA *ptr, int value);

int Bone_use_envelope_multiply_get(PointerRNA *ptr);
void Bone_use_envelope_multiply_set(PointerRNA *ptr, int value);

PointerRNA Bone_parent_get(PointerRNA *ptr);

int Bone_use_relative_parent_get(PointerRNA *ptr);
void Bone_use_relative_parent_set(PointerRNA *ptr, int value);

int Bone_select_get(PointerRNA *ptr);
void Bone_select_set(PointerRNA *ptr, int value);

int Bone_select_head_get(PointerRNA *ptr);
void Bone_select_head_set(PointerRNA *ptr, int value);

int Bone_select_tail_get(PointerRNA *ptr);
void Bone_select_tail_set(PointerRNA *ptr, int value);

int Bone_hide_select_get(PointerRNA *ptr);
void Bone_hide_select_set(PointerRNA *ptr, int value);

void Bone_tail_get(PointerRNA *ptr, float values[3]);
void Bone_tail_set(PointerRNA *ptr, const float values[3]);

float Bone_evaluate_envelope(struct Bone *_self, float point[3]);
/**************** Bone Group ****************/

extern StructRNA RNA_BoneGroup;

PointerRNA BoneGroup_rna_type_get(PointerRNA *ptr);

#define BoneGroup_name_MAX 64

void BoneGroup_name_get(PointerRNA *ptr, char *value);
int BoneGroup_name_length(PointerRNA *ptr);
void BoneGroup_name_set(PointerRNA *ptr, const char *value);

enum {
	BoneGroup_color_set_DEFAULT = 0,
	BoneGroup_color_set_THEME01 = 1,
	BoneGroup_color_set_THEME02 = 2,
	BoneGroup_color_set_THEME03 = 3,
	BoneGroup_color_set_THEME04 = 4,
	BoneGroup_color_set_THEME05 = 5,
	BoneGroup_color_set_THEME06 = 6,
	BoneGroup_color_set_THEME07 = 7,
	BoneGroup_color_set_THEME08 = 8,
	BoneGroup_color_set_THEME09 = 9,
	BoneGroup_color_set_THEME10 = 10,
	BoneGroup_color_set_THEME11 = 11,
	BoneGroup_color_set_THEME12 = 12,
	BoneGroup_color_set_THEME13 = 13,
	BoneGroup_color_set_THEME14 = 14,
	BoneGroup_color_set_THEME15 = 15,
	BoneGroup_color_set_THEME16 = 16,
	BoneGroup_color_set_THEME17 = 17,
	BoneGroup_color_set_THEME18 = 18,
	BoneGroup_color_set_THEME19 = 19,
	BoneGroup_color_set_THEME20 = 20,
	BoneGroup_color_set_CUSTOM = -1,
};

int BoneGroup_color_set_get(PointerRNA *ptr);
void BoneGroup_color_set_set(PointerRNA *ptr, int value);

PointerRNA BoneGroup_colors_get(PointerRNA *ptr);

int BoneGroup_is_custom_color_set_get(PointerRNA *ptr);
void BoneGroup_is_custom_color_set_set(PointerRNA *ptr, int value);

/**************** Bone Groups ****************/

extern StructRNA RNA_BoneGroups;

PointerRNA BoneGroups_rna_type_get(PointerRNA *ptr);

PointerRNA BoneGroups_active_get(PointerRNA *ptr);

int BoneGroups_active_index_get(PointerRNA *ptr);
void BoneGroups_active_index_set(PointerRNA *ptr, int value);

struct bActionGroup *BoneGroups_new(struct ID *_selfid, struct bPose *_self, const char * name);
void BoneGroups_remove(struct ID *_selfid, struct bPose *_self, ReportList *reports, struct PointerRNA *group);
/**************** Boolean Definition ****************/

extern StructRNA RNA_BoolProperty;
extern StructRNA RNA_Property;

int BoolProperty_array_length_get(PointerRNA *ptr);
void BoolProperty_array_length_set(PointerRNA *ptr, int value);

int BoolProperty_default_value_get(PointerRNA *ptr);
void BoolProperty_default_value_set(PointerRNA *ptr, int value);

void BoolProperty_default_array_get(PointerRNA *ptr, int values[3]);
void BoolProperty_default_array_set(PointerRNA *ptr, const int values[3]);
int BoolProperty_default_array_get_length(PointerRNA *ptr, int *arraylen);

/**************** Boolean Modifier ****************/

extern StructRNA RNA_BooleanModifier;
extern StructRNA RNA_Modifier;

PointerRNA BooleanModifier_object_get(PointerRNA *ptr);

enum {
	BooleanModifier_operation_INTERSECT = 0,
	BooleanModifier_operation_UNION = 1,
	BooleanModifier_operation_DIFFERENCE = 2,
};

int BooleanModifier_operation_get(PointerRNA *ptr);
void BooleanModifier_operation_set(PointerRNA *ptr, int value);

/**************** BrightContrastModifier ****************/

extern StructRNA RNA_BrightContrastModifier;
extern StructRNA RNA_SequenceModifier;

float BrightContrastModifier_bright_get(PointerRNA *ptr);
void BrightContrastModifier_bright_set(PointerRNA *ptr, float value);

float BrightContrastModifier_contrast_get(PointerRNA *ptr);
void BrightContrastModifier_contrast_set(PointerRNA *ptr, float value);

/**************** Brush ****************/

extern StructRNA RNA_Brush;
extern StructRNA RNA_ID;

int Brush_use_relative_jitter_get(PointerRNA *ptr);
void Brush_use_relative_jitter_set(PointerRNA *ptr, int value);

int Brush_use_accumulate_get(PointerRNA *ptr);
void Brush_use_accumulate_set(PointerRNA *ptr, int value);

int Brush_use_adaptive_space_get(PointerRNA *ptr);
void Brush_use_adaptive_space_set(PointerRNA *ptr, int value);

void Brush_cursor_color_add_get(PointerRNA *ptr, float values[3]);
void Brush_cursor_color_add_set(PointerRNA *ptr, const float values[3]);

int Brush_use_airbrush_get(PointerRNA *ptr);
void Brush_use_airbrush_set(PointerRNA *ptr, int value);

int Brush_use_alpha_get(PointerRNA *ptr);
void Brush_use_alpha_set(PointerRNA *ptr, int value);

int Brush_use_anchor_get(PointerRNA *ptr);
void Brush_use_anchor_set(PointerRNA *ptr, int value);

float Brush_auto_smooth_factor_get(PointerRNA *ptr);
void Brush_auto_smooth_factor_set(PointerRNA *ptr, float value);

enum {
	Brush_blend_MIX = 0,
	Brush_blend_ADD = 1,
	Brush_blend_SUB = 2,
	Brush_blend_MUL = 3,
	Brush_blend_LIGHTEN = 4,
	Brush_blend_DARKEN = 5,
	Brush_blend_ERASE_ALPHA = 6,
	Brush_blend_ADD_ALPHA = 7,
	Brush_blend_OVERLAY = 8,
	Brush_blend_HARDLIGHT = 9,
	Brush_blend_COLORBURN = 10,
	Brush_blend_LINEARBURN = 11,
	Brush_blend_COLORDODGE = 12,
	Brush_blend_SCREEN = 13,
	Brush_blend_SOFTLIGHT = 14,
	Brush_blend_PINLIGHT = 15,
	Brush_blend_VIVIDLIGHT = 16,
	Brush_blend_LINEARLIGHT = 17,
	Brush_blend_DIFFERENCE = 18,
	Brush_blend_EXCLUSION = 19,
	Brush_blend_HUE = 20,
	Brush_blend_SATURATION = 21,
	Brush_blend_LUMINOSITY = 22,
	Brush_blend_COLOR = 23,
};

int Brush_blend_get(PointerRNA *ptr);
void Brush_blend_set(PointerRNA *ptr, int value);

enum {
	Brush_vertex_tool_MIX = 0,
	Brush_vertex_tool_ADD = 1,
	Brush_vertex_tool_SUB = 2,
	Brush_vertex_tool_MUL = 3,
	Brush_vertex_tool_BLUR = 4,
	Brush_vertex_tool_LIGHTEN = 5,
	Brush_vertex_tool_DARKEN = 6,
};

int Brush_vertex_tool_get(PointerRNA *ptr);
void Brush_vertex_tool_set(PointerRNA *ptr, int value);

enum {
	Brush_blur_mode_BOX = 1,
	Brush_blur_mode_GAUSSIAN = 0,
};

int Brush_blur_mode_get(PointerRNA *ptr);
void Brush_blur_mode_set(PointerRNA *ptr, int value);

PointerRNA Brush_brush_capabilities_get(PointerRNA *ptr);

float Brush_height_get(PointerRNA *ptr);
void Brush_height_set(PointerRNA *ptr, float value);

#define Brush_icon_filepath_MAX 1024

void Brush_icon_filepath_get(PointerRNA *ptr, char *value);
int Brush_icon_filepath_length(PointerRNA *ptr);
void Brush_icon_filepath_set(PointerRNA *ptr, const char *value);

float Brush_clone_alpha_get(PointerRNA *ptr);
void Brush_clone_alpha_set(PointerRNA *ptr, float value);

PointerRNA Brush_clone_image_get(PointerRNA *ptr);

void Brush_clone_offset_get(PointerRNA *ptr, float values[2]);
void Brush_clone_offset_set(PointerRNA *ptr, const float values[2]);

void Brush_color_get(PointerRNA *ptr, float values[3]);
void Brush_color_set(PointerRNA *ptr, const float values[3]);

float Brush_crease_pinch_factor_get(PointerRNA *ptr);
void Brush_crease_pinch_factor_set(PointerRNA *ptr, float value);

int Brush_use_curve_get(PointerRNA *ptr);
void Brush_use_curve_set(PointerRNA *ptr, int value);

PointerRNA Brush_curve_get(PointerRNA *ptr);

int Brush_use_custom_icon_get(PointerRNA *ptr);
void Brush_use_custom_icon_set(PointerRNA *ptr, int value);

enum {
	Brush_direction_ADD = 0,
	Brush_direction_SUBTRACT = 512,
};

int Brush_direction_get(PointerRNA *ptr);
void Brush_direction_set(PointerRNA *ptr, int value);

int Brush_use_edge_to_edge_get(PointerRNA *ptr);
void Brush_use_edge_to_edge_set(PointerRNA *ptr, int value);

float Brush_fill_threshold_get(PointerRNA *ptr);
void Brush_fill_threshold_set(PointerRNA *ptr, float value);

PointerRNA Brush_gradient_get(PointerRNA *ptr);

enum {
	Brush_gradient_fill_mode_LINEAR = 0,
	Brush_gradient_fill_mode_RADIAL = 1,
};

int Brush_gradient_fill_mode_get(PointerRNA *ptr);
void Brush_gradient_fill_mode_set(PointerRNA *ptr, int value);

int Brush_grad_spacing_get(PointerRNA *ptr);
void Brush_grad_spacing_set(PointerRNA *ptr, int value);

enum {
	Brush_gradient_stroke_mode_PRESSURE = 0,
	Brush_gradient_stroke_mode_SPACING_REPEAT = 1,
	Brush_gradient_stroke_mode_SPACING_CLAMP = 2,
};

int Brush_gradient_stroke_mode_get(PointerRNA *ptr);
void Brush_gradient_stroke_mode_set(PointerRNA *ptr, int value);

enum {
	Brush_image_tool_DRAW = 0,
	Brush_image_tool_SOFTEN = 1,
	Brush_image_tool_SMEAR = 2,
	Brush_image_tool_CLONE = 3,
	Brush_image_tool_FILL = 4,
	Brush_image_tool_MASK = 5,
};

int Brush_image_tool_get(PointerRNA *ptr);
void Brush_image_tool_set(PointerRNA *ptr, int value);

PointerRNA Brush_image_paint_capabilities_get(PointerRNA *ptr);

int Brush_use_inverse_smooth_pressure_get(PointerRNA *ptr);
void Brush_use_inverse_smooth_pressure_set(PointerRNA *ptr, int value);

float Brush_jitter_get(PointerRNA *ptr);
void Brush_jitter_set(PointerRNA *ptr, float value);

int Brush_jitter_absolute_get(PointerRNA *ptr);
void Brush_jitter_absolute_set(PointerRNA *ptr, int value);

int Brush_use_pressure_jitter_get(PointerRNA *ptr);
void Brush_use_pressure_jitter_set(PointerRNA *ptr, int value);

int Brush_blur_kernel_radius_get(PointerRNA *ptr);
void Brush_blur_kernel_radius_set(PointerRNA *ptr, int value);

int Brush_use_line_get(PointerRNA *ptr);
void Brush_use_line_set(PointerRNA *ptr, int value);

enum {
	Brush_use_pressure_masking_NONE = 0,
	Brush_use_pressure_masking_RAMP = 2,
	Brush_use_pressure_masking_CUTOFF = 4,
};

int Brush_use_pressure_masking_get(PointerRNA *ptr);
void Brush_use_pressure_masking_set(PointerRNA *ptr, int value);

void Brush_mask_stencil_dimension_get(PointerRNA *ptr, float values[2]);
void Brush_mask_stencil_dimension_set(PointerRNA *ptr, const float values[2]);

void Brush_mask_stencil_pos_get(PointerRNA *ptr, float values[2]);
void Brush_mask_stencil_pos_set(PointerRNA *ptr, const float values[2]);

PointerRNA Brush_mask_texture_get(PointerRNA *ptr);

int Brush_mask_overlay_alpha_get(PointerRNA *ptr);
void Brush_mask_overlay_alpha_set(PointerRNA *ptr, int value);

int Brush_cursor_overlay_alpha_get(PointerRNA *ptr);
void Brush_cursor_overlay_alpha_set(PointerRNA *ptr, int value);

PointerRNA Brush_mask_texture_slot_get(PointerRNA *ptr);

enum {
	Brush_mask_tool_DRAW = 0,
	Brush_mask_tool_SMOOTH = 1,
};

int Brush_mask_tool_get(PointerRNA *ptr);
void Brush_mask_tool_set(PointerRNA *ptr, int value);

float Brush_normal_weight_get(PointerRNA *ptr);
void Brush_normal_weight_set(PointerRNA *ptr, float value);

int Brush_use_original_normal_get(PointerRNA *ptr);
void Brush_use_original_normal_set(PointerRNA *ptr, int value);

int Brush_use_cursor_overlay_override_get(PointerRNA *ptr);
void Brush_use_cursor_overlay_override_set(PointerRNA *ptr, int value);

int Brush_use_primary_overlay_override_get(PointerRNA *ptr);
void Brush_use_primary_overlay_override_set(PointerRNA *ptr, int value);

int Brush_use_secondary_overlay_override_get(PointerRNA *ptr);
void Brush_use_secondary_overlay_override_set(PointerRNA *ptr, int value);

PointerRNA Brush_paint_curve_get(PointerRNA *ptr);

int Brush_use_persistent_get(PointerRNA *ptr);
void Brush_use_persistent_set(PointerRNA *ptr, int value);

float Brush_plane_offset_get(PointerRNA *ptr);
void Brush_plane_offset_set(PointerRNA *ptr, float value);

int Brush_use_offset_pressure_get(PointerRNA *ptr);
void Brush_use_offset_pressure_set(PointerRNA *ptr, int value);

float Brush_plane_trim_get(PointerRNA *ptr);
void Brush_plane_trim_set(PointerRNA *ptr, float value);

int Brush_size_get(PointerRNA *ptr);
void Brush_size_set(PointerRNA *ptr, int value);

int Brush_use_rake_get(PointerRNA *ptr);
void Brush_use_rake_set(PointerRNA *ptr, int value);

int Brush_use_random_rotation_get(PointerRNA *ptr);
void Brush_use_random_rotation_set(PointerRNA *ptr, int value);

float Brush_rate_get(PointerRNA *ptr);
void Brush_rate_set(PointerRNA *ptr, float value);

int Brush_use_restore_mesh_get(PointerRNA *ptr);
void Brush_use_restore_mesh_set(PointerRNA *ptr, int value);

PointerRNA Brush_sculpt_capabilities_get(PointerRNA *ptr);

enum {
	Brush_sculpt_plane_AREA = 0,
	Brush_sculpt_plane_VIEW = 1,
	Brush_sculpt_plane_X = 2,
	Brush_sculpt_plane_Y = 3,
	Brush_sculpt_plane_Z = 4,
};

int Brush_sculpt_plane_get(PointerRNA *ptr);
void Brush_sculpt_plane_set(PointerRNA *ptr, int value);

enum {
	Brush_sculpt_tool_BLOB = 17,
	Brush_sculpt_tool_CLAY = 8,
	Brush_sculpt_tool_CLAY_STRIPS = 18,
	Brush_sculpt_tool_CREASE = 16,
	Brush_sculpt_tool_DRAW = 1,
	Brush_sculpt_tool_FILL = 9,
	Brush_sculpt_tool_FLATTEN = 7,
	Brush_sculpt_tool_GRAB = 5,
	Brush_sculpt_tool_INFLATE = 4,
	Brush_sculpt_tool_LAYER = 6,
	Brush_sculpt_tool_MASK = 19,
	Brush_sculpt_tool_NUDGE = 11,
	Brush_sculpt_tool_PINCH = 3,
	Brush_sculpt_tool_ROTATE = 14,
	Brush_sculpt_tool_SCRAPE = 10,
	Brush_sculpt_tool_SIMPLIFY = 15,
	Brush_sculpt_tool_SMOOTH = 2,
	Brush_sculpt_tool_SNAKE_HOOK = 13,
	Brush_sculpt_tool_THUMB = 12,
};

int Brush_sculpt_tool_get(PointerRNA *ptr);
void Brush_sculpt_tool_set(PointerRNA *ptr, int value);

void Brush_secondary_color_get(PointerRNA *ptr, float values[3]);
void Brush_secondary_color_set(PointerRNA *ptr, const float values[3]);

float Brush_sharp_threshold_get(PointerRNA *ptr);
void Brush_sharp_threshold_set(PointerRNA *ptr, float value);

int Brush_use_pressure_size_get(PointerRNA *ptr);
void Brush_use_pressure_size_set(PointerRNA *ptr, int value);

int Brush_use_smooth_stroke_get(PointerRNA *ptr);
void Brush_use_smooth_stroke_set(PointerRNA *ptr, int value);

float Brush_smooth_stroke_factor_get(PointerRNA *ptr);
void Brush_smooth_stroke_factor_set(PointerRNA *ptr, float value);

int Brush_smooth_stroke_radius_get(PointerRNA *ptr);
void Brush_smooth_stroke_radius_set(PointerRNA *ptr, int value);

int Brush_use_space_get(PointerRNA *ptr);
void Brush_use_space_set(PointerRNA *ptr, int value);

int Brush_spacing_get(PointerRNA *ptr);
void Brush_spacing_set(PointerRNA *ptr, int value);

int Brush_use_pressure_spacing_get(PointerRNA *ptr);
void Brush_use_pressure_spacing_set(PointerRNA *ptr, int value);

void Brush_stencil_dimension_get(PointerRNA *ptr, float values[2]);
void Brush_stencil_dimension_set(PointerRNA *ptr, const float values[2]);

void Brush_stencil_pos_get(PointerRNA *ptr, float values[2]);
void Brush_stencil_pos_set(PointerRNA *ptr, const float values[2]);

float Brush_strength_get(PointerRNA *ptr);
void Brush_strength_set(PointerRNA *ptr, float value);

int Brush_use_pressure_strength_get(PointerRNA *ptr);
void Brush_use_pressure_strength_set(PointerRNA *ptr, int value);

enum {
	Brush_stroke_method_DOTS = 0,
	Brush_stroke_method_DRAG_DOT = 8388608,
	Brush_stroke_method_SPACE = 1024,
	Brush_stroke_method_AIRBRUSH = 1,
	Brush_stroke_method_ANCHORED = 256,
	Brush_stroke_method_LINE = 536870912,
	Brush_stroke_method_CURVE = -2147483648,
};

int Brush_stroke_method_get(PointerRNA *ptr);
void Brush_stroke_method_set(PointerRNA *ptr, int value);

void Brush_cursor_color_subtract_get(PointerRNA *ptr, float values[3]);
void Brush_cursor_color_subtract_set(PointerRNA *ptr, const float values[3]);

PointerRNA Brush_texture_get(PointerRNA *ptr);

enum {
	Brush_texture_angle_source_random_USER = 0,
	Brush_texture_angle_source_random_RAKE = 128,
	Brush_texture_angle_source_random_RANDOM = 33554432,
};

int Brush_texture_angle_source_random_get(PointerRNA *ptr);
void Brush_texture_angle_source_random_set(PointerRNA *ptr, int value);

enum {
	Brush_texture_angle_source_no_random_USER = 0,
	Brush_texture_angle_source_no_random_RAKE = 128,
};

int Brush_texture_angle_source_no_random_get(PointerRNA *ptr);
void Brush_texture_angle_source_no_random_set(PointerRNA *ptr, int value);

int Brush_texture_overlay_alpha_get(PointerRNA *ptr);
void Brush_texture_overlay_alpha_set(PointerRNA *ptr, int value);

float Brush_texture_sample_bias_get(PointerRNA *ptr);
void Brush_texture_sample_bias_set(PointerRNA *ptr, float value);

PointerRNA Brush_texture_slot_get(PointerRNA *ptr);

float Brush_unprojected_radius_get(PointerRNA *ptr);
void Brush_unprojected_radius_set(PointerRNA *ptr, float value);

int Brush_use_space_attenuation_get(PointerRNA *ptr);
void Brush_use_space_attenuation_set(PointerRNA *ptr, int value);

int Brush_use_locked_size_get(PointerRNA *ptr);
void Brush_use_locked_size_set(PointerRNA *ptr, int value);

int Brush_use_cursor_overlay_get(PointerRNA *ptr);
void Brush_use_cursor_overlay_set(PointerRNA *ptr, int value);

int Brush_use_frontface_get(PointerRNA *ptr);
void Brush_use_frontface_set(PointerRNA *ptr, int value);

int Brush_use_gradient_get(PointerRNA *ptr);
void Brush_use_gradient_set(PointerRNA *ptr, int value);

int Brush_use_plane_trim_get(PointerRNA *ptr);
void Brush_use_plane_trim_set(PointerRNA *ptr, int value);

int Brush_use_paint_sculpt_get(PointerRNA *ptr);
void Brush_use_paint_sculpt_set(PointerRNA *ptr, int value);

int Brush_use_paint_image_get(PointerRNA *ptr);
void Brush_use_paint_image_set(PointerRNA *ptr, int value);

int Brush_use_primary_overlay_get(PointerRNA *ptr);
void Brush_use_primary_overlay_set(PointerRNA *ptr, int value);

int Brush_use_secondary_overlay_get(PointerRNA *ptr);
void Brush_use_secondary_overlay_set(PointerRNA *ptr, int value);

int Brush_use_paint_vertex_get(PointerRNA *ptr);
void Brush_use_paint_vertex_set(PointerRNA *ptr, int value);

int Brush_use_paint_weight_get(PointerRNA *ptr);
void Brush_use_paint_weight_set(PointerRNA *ptr, int value);

float Brush_weight_get(PointerRNA *ptr);
void Brush_weight_set(PointerRNA *ptr, float value);

int Brush_use_wrap_get(PointerRNA *ptr);
void Brush_use_wrap_set(PointerRNA *ptr, int value);

/**************** Brush Capabilities ****************/

extern StructRNA RNA_BrushCapabilities;

PointerRNA BrushCapabilities_rna_type_get(PointerRNA *ptr);

int BrushCapabilities_has_overlay_get(PointerRNA *ptr);
void BrushCapabilities_has_overlay_set(PointerRNA *ptr, int value);

int BrushCapabilities_has_random_texture_angle_get(PointerRNA *ptr);
void BrushCapabilities_has_random_texture_angle_set(PointerRNA *ptr, int value);

int BrushCapabilities_has_smooth_stroke_get(PointerRNA *ptr);
void BrushCapabilities_has_smooth_stroke_set(PointerRNA *ptr, int value);

int BrushCapabilities_has_spacing_get(PointerRNA *ptr);
void BrushCapabilities_has_spacing_set(PointerRNA *ptr, int value);

int BrushCapabilities_has_texture_angle_get(PointerRNA *ptr);
void BrushCapabilities_has_texture_angle_set(PointerRNA *ptr, int value);

int BrushCapabilities_has_texture_angle_source_get(PointerRNA *ptr);
void BrushCapabilities_has_texture_angle_source_set(PointerRNA *ptr, int value);

/**************** Brush Texture Slot ****************/

extern StructRNA RNA_BrushTextureSlot;
extern StructRNA RNA_TextureSlot;

float BrushTextureSlot_angle_get(PointerRNA *ptr);
void BrushTextureSlot_angle_set(PointerRNA *ptr, float value);

enum {
	BrushTextureSlot_map_mode_VIEW_PLANE = 0,
	BrushTextureSlot_map_mode_AREA_PLANE = 3,
	BrushTextureSlot_map_mode_TILED = 1,
	BrushTextureSlot_map_mode_3D = 2,
	BrushTextureSlot_map_mode_RANDOM = 4,
	BrushTextureSlot_map_mode_STENCIL = 5,
};

int BrushTextureSlot_map_mode_get(PointerRNA *ptr);
void BrushTextureSlot_map_mode_set(PointerRNA *ptr, int value);

enum {
	BrushTextureSlot_tex_paint_map_mode_VIEW_PLANE = 0,
	BrushTextureSlot_tex_paint_map_mode_TILED = 1,
	BrushTextureSlot_tex_paint_map_mode_3D = 2,
	BrushTextureSlot_tex_paint_map_mode_RANDOM = 4,
	BrushTextureSlot_tex_paint_map_mode_STENCIL = 5,
};

int BrushTextureSlot_tex_paint_map_mode_get(PointerRNA *ptr);
void BrushTextureSlot_tex_paint_map_mode_set(PointerRNA *ptr, int value);

enum {
	BrushTextureSlot_mask_map_mode_VIEW_PLANE = 0,
	BrushTextureSlot_mask_map_mode_TILED = 1,
	BrushTextureSlot_mask_map_mode_RANDOM = 4,
	BrushTextureSlot_mask_map_mode_STENCIL = 5,
};

int BrushTextureSlot_mask_map_mode_get(PointerRNA *ptr);
void BrushTextureSlot_mask_map_mode_set(PointerRNA *ptr, int value);

/**************** Build Modifier ****************/

extern StructRNA RNA_BuildModifier;
extern StructRNA RNA_Modifier;

float BuildModifier_frame_duration_get(PointerRNA *ptr);
void BuildModifier_frame_duration_set(PointerRNA *ptr, float value);

int BuildModifier_use_random_order_get(PointerRNA *ptr);
void BuildModifier_use_random_order_set(PointerRNA *ptr, int value);

int BuildModifier_use_reverse_get(PointerRNA *ptr);
void BuildModifier_use_reverse_set(PointerRNA *ptr, int value);

int BuildModifier_seed_get(PointerRNA *ptr);
void BuildModifier_seed_set(PointerRNA *ptr, int value);

float BuildModifier_frame_start_get(PointerRNA *ptr);
void BuildModifier_frame_start_set(PointerRNA *ptr, float value);

/**************** Camera ****************/

extern StructRNA RNA_Camera;
extern StructRNA RNA_ID;

PointerRNA Camera_animation_data_get(PointerRNA *ptr);

float Camera_clip_end_get(PointerRNA *ptr);
void Camera_clip_end_set(PointerRNA *ptr, float value);

float Camera_clip_start_get(PointerRNA *ptr);
void Camera_clip_start_set(PointerRNA *ptr, float value);

enum {
	Camera_show_guide_CENTER = 1,
	Camera_show_guide_CENTER_DIAGONAL = 2,
	Camera_show_guide_THIRDS = 4,
	Camera_show_guide_GOLDEN = 8,
	Camera_show_guide_GOLDEN_TRIANGLE_A = 16,
	Camera_show_guide_GOLDEN_TRIANGLE_B = 32,
	Camera_show_guide_HARMONY_TRIANGLE_A = 64,
	Camera_show_guide_HARMONY_TRIANGLE_B = 128,
};

int Camera_show_guide_get(PointerRNA *ptr);
void Camera_show_guide_set(PointerRNA *ptr, int value);

float Camera_dof_distance_get(PointerRNA *ptr);
void Camera_dof_distance_set(PointerRNA *ptr, float value);

PointerRNA Camera_dof_object_get(PointerRNA *ptr);

float Camera_draw_size_get(PointerRNA *ptr);
void Camera_draw_size_set(PointerRNA *ptr, float value);

float Camera_angle_get(PointerRNA *ptr);
void Camera_angle_set(PointerRNA *ptr, float value);

float Camera_lens_get(PointerRNA *ptr);
void Camera_lens_set(PointerRNA *ptr, float value);

float Camera_angle_x_get(PointerRNA *ptr);
void Camera_angle_x_set(PointerRNA *ptr, float value);

enum {
	Camera_lens_unit_MILLIMETERS = 0,
	Camera_lens_unit_FOV = 32,
};

int Camera_lens_unit_get(PointerRNA *ptr);
void Camera_lens_unit_set(PointerRNA *ptr, int value);

float Camera_ortho_scale_get(PointerRNA *ptr);
void Camera_ortho_scale_set(PointerRNA *ptr, float value);

float Camera_passepartout_alpha_get(PointerRNA *ptr);
void Camera_passepartout_alpha_set(PointerRNA *ptr, float value);

enum {
	Camera_sensor_fit_AUTO = 0,
	Camera_sensor_fit_HORIZONTAL = 1,
	Camera_sensor_fit_VERTICAL = 2,
};

int Camera_sensor_fit_get(PointerRNA *ptr);
void Camera_sensor_fit_set(PointerRNA *ptr, int value);

float Camera_sensor_height_get(PointerRNA *ptr);
void Camera_sensor_height_set(PointerRNA *ptr, float value);

float Camera_sensor_width_get(PointerRNA *ptr);
void Camera_sensor_width_set(PointerRNA *ptr, float value);

float Camera_shift_x_get(PointerRNA *ptr);
void Camera_shift_x_set(PointerRNA *ptr, float value);

float Camera_shift_y_get(PointerRNA *ptr);
void Camera_shift_y_set(PointerRNA *ptr, float value);

int Camera_show_limits_get(PointerRNA *ptr);
void Camera_show_limits_set(PointerRNA *ptr, int value);

int Camera_show_mist_get(PointerRNA *ptr);
void Camera_show_mist_set(PointerRNA *ptr, int value);

int Camera_show_name_get(PointerRNA *ptr);
void Camera_show_name_set(PointerRNA *ptr, int value);

int Camera_show_passepartout_get(PointerRNA *ptr);
void Camera_show_passepartout_set(PointerRNA *ptr, int value);

int Camera_show_title_safe_get(PointerRNA *ptr);
void Camera_show_title_safe_set(PointerRNA *ptr, int value);

int Camera_show_sensor_get(PointerRNA *ptr);
void Camera_show_sensor_set(PointerRNA *ptr, int value);

enum {
	Camera_type_PERSP = 0,
	Camera_type_ORTHO = 1,
	Camera_type_PANO = 2,
};

int Camera_type_get(PointerRNA *ptr);
void Camera_type_set(PointerRNA *ptr, int value);

float Camera_angle_y_get(PointerRNA *ptr);
void Camera_angle_y_set(PointerRNA *ptr, float value);

void Camera_view_frame(struct Camera *_self, struct Scene *scene, float result_1[3], float result_2[3], float result_3[3], float result_4[3]);
/**************** Camera Actuator ****************/

extern StructRNA RNA_CameraActuator;
extern StructRNA RNA_Actuator;

enum {
	CameraActuator_axis_POS_X = 0,
	CameraActuator_axis_POS_Y = 1,
	CameraActuator_axis_NEG_X = 3,
	CameraActuator_axis_NEG_Y = 4,
};

int CameraActuator_axis_get(PointerRNA *ptr);
void CameraActuator_axis_set(PointerRNA *ptr, int value);

PointerRNA CameraActuator_object_get(PointerRNA *ptr);

float CameraActuator_damping_get(PointerRNA *ptr);
void CameraActuator_damping_set(PointerRNA *ptr, float value);

float CameraActuator_height_get(PointerRNA *ptr);
void CameraActuator_height_set(PointerRNA *ptr, float value);

float CameraActuator_max_get(PointerRNA *ptr);
void CameraActuator_max_set(PointerRNA *ptr, float value);

float CameraActuator_min_get(PointerRNA *ptr);
void CameraActuator_min_set(PointerRNA *ptr, float value);

/**************** Camera Solver Constraint ****************/

extern StructRNA RNA_CameraSolverConstraint;
extern StructRNA RNA_Constraint;

int CameraSolverConstraint_use_active_clip_get(PointerRNA *ptr);
void CameraSolverConstraint_use_active_clip_set(PointerRNA *ptr, int value);

PointerRNA CameraSolverConstraint_clip_get(PointerRNA *ptr);

/**************** Cast Modifier ****************/

extern StructRNA RNA_CastModifier;
extern StructRNA RNA_Modifier;

enum {
	CastModifier_cast_type_SPHERE = 0,
	CastModifier_cast_type_CYLINDER = 1,
	CastModifier_cast_type_CUBOID = 2,
};

int CastModifier_cast_type_get(PointerRNA *ptr);
void CastModifier_cast_type_set(PointerRNA *ptr, int value);

float CastModifier_factor_get(PointerRNA *ptr);
void CastModifier_factor_set(PointerRNA *ptr, float value);

int CastModifier_use_radius_as_size_get(PointerRNA *ptr);
void CastModifier_use_radius_as_size_set(PointerRNA *ptr, int value);

PointerRNA CastModifier_object_get(PointerRNA *ptr);

float CastModifier_radius_get(PointerRNA *ptr);
void CastModifier_radius_set(PointerRNA *ptr, float value);

float CastModifier_size_get(PointerRNA *ptr);
void CastModifier_size_set(PointerRNA *ptr, float value);

int CastModifier_use_transform_get(PointerRNA *ptr);
void CastModifier_use_transform_set(PointerRNA *ptr, int value);

#define CastModifier_vertex_group_MAX 64

void CastModifier_vertex_group_get(PointerRNA *ptr, char *value);
int CastModifier_vertex_group_length(PointerRNA *ptr);
void CastModifier_vertex_group_set(PointerRNA *ptr, const char *value);

int CastModifier_use_x_get(PointerRNA *ptr);
void CastModifier_use_x_set(PointerRNA *ptr, int value);

int CastModifier_use_y_get(PointerRNA *ptr);
void CastModifier_use_y_set(PointerRNA *ptr, int value);

int CastModifier_use_z_get(PointerRNA *ptr);
void CastModifier_use_z_set(PointerRNA *ptr, int value);

/**************** ChannelDriver Variables ****************/

extern StructRNA RNA_ChannelDriverVariables;

PointerRNA ChannelDriverVariables_rna_type_get(PointerRNA *ptr);

struct DriverVar *ChannelDriverVariables_new(struct ChannelDriver *_self);
void ChannelDriverVariables_remove(struct ChannelDriver *_self, ReportList *reports, struct PointerRNA *variable);
/**************** Child Of Constraint ****************/

extern StructRNA RNA_ChildOfConstraint;
extern StructRNA RNA_Constraint;

void ChildOfConstraint_inverse_matrix_get(PointerRNA *ptr, float values[16]);
void ChildOfConstraint_inverse_matrix_set(PointerRNA *ptr, const float values[16]);

int ChildOfConstraint_use_location_x_get(PointerRNA *ptr);
void ChildOfConstraint_use_location_x_set(PointerRNA *ptr, int value);

int ChildOfConstraint_use_location_y_get(PointerRNA *ptr);
void ChildOfConstraint_use_location_y_set(PointerRNA *ptr, int value);

int ChildOfConstraint_use_location_z_get(PointerRNA *ptr);
void ChildOfConstraint_use_location_z_set(PointerRNA *ptr, int value);

int ChildOfConstraint_use_rotation_x_get(PointerRNA *ptr);
void ChildOfConstraint_use_rotation_x_set(PointerRNA *ptr, int value);

int ChildOfConstraint_use_rotation_y_get(PointerRNA *ptr);
void ChildOfConstraint_use_rotation_y_set(PointerRNA *ptr, int value);

int ChildOfConstraint_use_rotation_z_get(PointerRNA *ptr);
void ChildOfConstraint_use_rotation_z_set(PointerRNA *ptr, int value);

int ChildOfConstraint_use_scale_x_get(PointerRNA *ptr);
void ChildOfConstraint_use_scale_x_set(PointerRNA *ptr, int value);

int ChildOfConstraint_use_scale_y_get(PointerRNA *ptr);
void ChildOfConstraint_use_scale_y_set(PointerRNA *ptr, int value);

int ChildOfConstraint_use_scale_z_get(PointerRNA *ptr);
void ChildOfConstraint_use_scale_z_set(PointerRNA *ptr, int value);

#define ChildOfConstraint_subtarget_MAX 64

void ChildOfConstraint_subtarget_get(PointerRNA *ptr, char *value);
int ChildOfConstraint_subtarget_length(PointerRNA *ptr);
void ChildOfConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA ChildOfConstraint_target_get(PointerRNA *ptr);

/**************** Child Particle ****************/

extern StructRNA RNA_ChildParticle;

PointerRNA ChildParticle_rna_type_get(PointerRNA *ptr);

/**************** Clamp To Constraint ****************/

extern StructRNA RNA_ClampToConstraint;
extern StructRNA RNA_Constraint;

int ClampToConstraint_use_cyclic_get(PointerRNA *ptr);
void ClampToConstraint_use_cyclic_set(PointerRNA *ptr, int value);

enum {
	ClampToConstraint_main_axis_CLAMPTO_AUTO = 0,
	ClampToConstraint_main_axis_CLAMPTO_X = 1,
	ClampToConstraint_main_axis_CLAMPTO_Y = 2,
	ClampToConstraint_main_axis_CLAMPTO_Z = 3,
};

int ClampToConstraint_main_axis_get(PointerRNA *ptr);
void ClampToConstraint_main_axis_set(PointerRNA *ptr, int value);

PointerRNA ClampToConstraint_target_get(PointerRNA *ptr);

/**************** Cloth Collision Settings ****************/

extern StructRNA RNA_ClothCollisionSettings;

PointerRNA ClothCollisionSettings_rna_type_get(PointerRNA *ptr);

PointerRNA ClothCollisionSettings_group_get(PointerRNA *ptr);

int ClothCollisionSettings_collision_quality_get(PointerRNA *ptr);
void ClothCollisionSettings_collision_quality_set(PointerRNA *ptr, int value);

int ClothCollisionSettings_use_collision_get(PointerRNA *ptr);
void ClothCollisionSettings_use_collision_set(PointerRNA *ptr, int value);

int ClothCollisionSettings_use_self_collision_get(PointerRNA *ptr);
void ClothCollisionSettings_use_self_collision_set(PointerRNA *ptr, int value);

float ClothCollisionSettings_friction_get(PointerRNA *ptr);
void ClothCollisionSettings_friction_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_distance_min_get(PointerRNA *ptr);
void ClothCollisionSettings_distance_min_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_distance_repel_get(PointerRNA *ptr);
void ClothCollisionSettings_distance_repel_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_repel_force_get(PointerRNA *ptr);
void ClothCollisionSettings_repel_force_set(PointerRNA *ptr, float value);

int ClothCollisionSettings_self_collision_quality_get(PointerRNA *ptr);
void ClothCollisionSettings_self_collision_quality_set(PointerRNA *ptr, int value);

float ClothCollisionSettings_self_friction_get(PointerRNA *ptr);
void ClothCollisionSettings_self_friction_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_self_distance_min_get(PointerRNA *ptr);
void ClothCollisionSettings_self_distance_min_set(PointerRNA *ptr, float value);

void ClothCollisionSettings_vertex_group_self_collisions_get(PointerRNA *ptr, char *value);
int ClothCollisionSettings_vertex_group_self_collisions_length(PointerRNA *ptr);
void ClothCollisionSettings_vertex_group_self_collisions_set(PointerRNA *ptr, const char *value);

/**************** Cloth Modifier ****************/

extern StructRNA RNA_ClothModifier;
extern StructRNA RNA_Modifier;

PointerRNA ClothModifier_collision_settings_get(PointerRNA *ptr);

PointerRNA ClothModifier_settings_get(PointerRNA *ptr);

PointerRNA ClothModifier_point_cache_get(PointerRNA *ptr);

/**************** Cloth Settings ****************/

extern StructRNA RNA_ClothSettings;

PointerRNA ClothSettings_rna_type_get(PointerRNA *ptr);

float ClothSettings_air_damping_get(PointerRNA *ptr);
void ClothSettings_air_damping_set(PointerRNA *ptr, float value);

float ClothSettings_bending_stiffness_get(PointerRNA *ptr);
void ClothSettings_bending_stiffness_set(PointerRNA *ptr, float value);

float ClothSettings_bending_stiffness_max_get(PointerRNA *ptr);
void ClothSettings_bending_stiffness_max_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_bending_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_bending_length(PointerRNA *ptr);
void ClothSettings_vertex_group_bending_set(PointerRNA *ptr, const char *value);

float ClothSettings_collider_friction_get(PointerRNA *ptr);
void ClothSettings_collider_friction_set(PointerRNA *ptr, float value);

PointerRNA ClothSettings_effector_weights_get(PointerRNA *ptr);

float ClothSettings_goal_friction_get(PointerRNA *ptr);
void ClothSettings_goal_friction_set(PointerRNA *ptr, float value);

float ClothSettings_goal_default_get(PointerRNA *ptr);
void ClothSettings_goal_default_set(PointerRNA *ptr, float value);

float ClothSettings_goal_max_get(PointerRNA *ptr);
void ClothSettings_goal_max_set(PointerRNA *ptr, float value);

float ClothSettings_goal_min_get(PointerRNA *ptr);
void ClothSettings_goal_min_set(PointerRNA *ptr, float value);

float ClothSettings_goal_spring_get(PointerRNA *ptr);
void ClothSettings_goal_spring_set(PointerRNA *ptr, float value);

void ClothSettings_gravity_get(PointerRNA *ptr, float values[3]);
void ClothSettings_gravity_set(PointerRNA *ptr, const float values[3]);

float ClothSettings_internal_friction_get(PointerRNA *ptr);
void ClothSettings_internal_friction_set(PointerRNA *ptr, float value);

float ClothSettings_mass_get(PointerRNA *ptr);
void ClothSettings_mass_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_mass_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_mass_length(PointerRNA *ptr);
void ClothSettings_vertex_group_mass_set(PointerRNA *ptr, const char *value);

int ClothSettings_use_pin_cloth_get(PointerRNA *ptr);
void ClothSettings_use_pin_cloth_set(PointerRNA *ptr, int value);

float ClothSettings_pin_stiffness_get(PointerRNA *ptr);
void ClothSettings_pin_stiffness_set(PointerRNA *ptr, float value);

int ClothSettings_pre_roll_get(PointerRNA *ptr);
void ClothSettings_pre_roll_set(PointerRNA *ptr, int value);

int ClothSettings_quality_get(PointerRNA *ptr);
void ClothSettings_quality_set(PointerRNA *ptr, int value);

PointerRNA ClothSettings_rest_shape_key_get(PointerRNA *ptr);

int ClothSettings_use_sewing_springs_get(PointerRNA *ptr);
void ClothSettings_use_sewing_springs_set(PointerRNA *ptr, int value);

float ClothSettings_sewing_force_max_get(PointerRNA *ptr);
void ClothSettings_sewing_force_max_set(PointerRNA *ptr, float value);

float ClothSettings_shrink_max_get(PointerRNA *ptr);
void ClothSettings_shrink_max_set(PointerRNA *ptr, float value);

float ClothSettings_shrink_min_get(PointerRNA *ptr);
void ClothSettings_shrink_min_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_shrink_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_shrink_length(PointerRNA *ptr);
void ClothSettings_vertex_group_shrink_set(PointerRNA *ptr, const char *value);

float ClothSettings_spring_damping_get(PointerRNA *ptr);
void ClothSettings_spring_damping_set(PointerRNA *ptr, float value);

int ClothSettings_use_stiffness_scale_get(PointerRNA *ptr);
void ClothSettings_use_stiffness_scale_set(PointerRNA *ptr, int value);

float ClothSettings_structural_stiffness_get(PointerRNA *ptr);
void ClothSettings_structural_stiffness_set(PointerRNA *ptr, float value);

float ClothSettings_structural_stiffness_max_get(PointerRNA *ptr);
void ClothSettings_structural_stiffness_max_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_structural_stiffness_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_structural_stiffness_length(PointerRNA *ptr);
void ClothSettings_vertex_group_structural_stiffness_set(PointerRNA *ptr, const char *value);

float ClothSettings_vel_damping_get(PointerRNA *ptr);
void ClothSettings_vel_damping_set(PointerRNA *ptr, float value);

/**************** Clouds Texture ****************/

extern StructRNA RNA_CloudsTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

enum {
	CloudsTexture_cloud_type_GRAYSCALE = 0,
	CloudsTexture_cloud_type_COLOR = 1,
};

int CloudsTexture_cloud_type_get(PointerRNA *ptr);
void CloudsTexture_cloud_type_set(PointerRNA *ptr, int value);

float CloudsTexture_nabla_get(PointerRNA *ptr);
void CloudsTexture_nabla_set(PointerRNA *ptr, float value);

enum {
	CloudsTexture_noise_basis_BLENDER_ORIGINAL = 0,
	CloudsTexture_noise_basis_ORIGINAL_PERLIN = 1,
	CloudsTexture_noise_basis_IMPROVED_PERLIN = 2,
	CloudsTexture_noise_basis_VORONOI_F1 = 3,
	CloudsTexture_noise_basis_VORONOI_F2 = 4,
	CloudsTexture_noise_basis_VORONOI_F3 = 5,
	CloudsTexture_noise_basis_VORONOI_F4 = 6,
	CloudsTexture_noise_basis_VORONOI_F2_F1 = 7,
	CloudsTexture_noise_basis_VORONOI_CRACKLE = 8,
	CloudsTexture_noise_basis_CELL_NOISE = 14,
};

int CloudsTexture_noise_basis_get(PointerRNA *ptr);
void CloudsTexture_noise_basis_set(PointerRNA *ptr, int value);

int CloudsTexture_noise_depth_get(PointerRNA *ptr);
void CloudsTexture_noise_depth_set(PointerRNA *ptr, int value);

float CloudsTexture_noise_scale_get(PointerRNA *ptr);
void CloudsTexture_noise_scale_set(PointerRNA *ptr, float value);

enum {
	CloudsTexture_noise_type_SOFT_NOISE = 0,
	CloudsTexture_noise_type_HARD_NOISE = 1,
};

int CloudsTexture_noise_type_get(PointerRNA *ptr);
void CloudsTexture_noise_type_set(PointerRNA *ptr, int value);

/**************** Collection Definition ****************/

extern StructRNA RNA_CollectionProperty;
extern StructRNA RNA_Property;

PointerRNA CollectionProperty_fixed_type_get(PointerRNA *ptr);

/**************** Collision Modifier ****************/

extern StructRNA RNA_CollisionModifier;
extern StructRNA RNA_Modifier;

PointerRNA CollisionModifier_settings_get(PointerRNA *ptr);

/**************** Collision Sensor ****************/

extern StructRNA RNA_CollisionSensor;
extern StructRNA RNA_Sensor;

int CollisionSensor_use_material_get(PointerRNA *ptr);
void CollisionSensor_use_material_set(PointerRNA *ptr, int value);

#define CollisionSensor_material_MAX 64

void CollisionSensor_material_get(PointerRNA *ptr, char *value);
int CollisionSensor_material_length(PointerRNA *ptr);
void CollisionSensor_material_set(PointerRNA *ptr, const char *value);

#define CollisionSensor_property_MAX 64

void CollisionSensor_property_get(PointerRNA *ptr, char *value);
int CollisionSensor_property_length(PointerRNA *ptr);
void CollisionSensor_property_set(PointerRNA *ptr, const char *value);

int CollisionSensor_use_pulse_get(PointerRNA *ptr);
void CollisionSensor_use_pulse_set(PointerRNA *ptr, int value);

/**************** Collision Settings ****************/

extern StructRNA RNA_CollisionSettings;

PointerRNA CollisionSettings_rna_type_get(PointerRNA *ptr);

float CollisionSettings_absorption_get(PointerRNA *ptr);
void CollisionSettings_absorption_set(PointerRNA *ptr, float value);

float CollisionSettings_damping_get(PointerRNA *ptr);
void CollisionSettings_damping_set(PointerRNA *ptr, float value);

float CollisionSettings_damping_factor_get(PointerRNA *ptr);
void CollisionSettings_damping_factor_set(PointerRNA *ptr, float value);

int CollisionSettings_use_get(PointerRNA *ptr);
void CollisionSettings_use_set(PointerRNA *ptr, int value);

float CollisionSettings_friction_factor_get(PointerRNA *ptr);
void CollisionSettings_friction_factor_set(PointerRNA *ptr, float value);

float CollisionSettings_thickness_inner_get(PointerRNA *ptr);
void CollisionSettings_thickness_inner_set(PointerRNA *ptr, float value);

int CollisionSettings_use_particle_kill_get(PointerRNA *ptr);
void CollisionSettings_use_particle_kill_set(PointerRNA *ptr, int value);

float CollisionSettings_thickness_outer_get(PointerRNA *ptr);
void CollisionSettings_thickness_outer_set(PointerRNA *ptr, float value);

float CollisionSettings_permeability_get(PointerRNA *ptr);
void CollisionSettings_permeability_set(PointerRNA *ptr, float value);

float CollisionSettings_damping_random_get(PointerRNA *ptr);
void CollisionSettings_damping_random_set(PointerRNA *ptr, float value);

float CollisionSettings_friction_random_get(PointerRNA *ptr);
void CollisionSettings_friction_random_set(PointerRNA *ptr, float value);

float CollisionSettings_stickiness_get(PointerRNA *ptr);
void CollisionSettings_stickiness_set(PointerRNA *ptr, float value);

/**************** ColorBalanceModifier ****************/

extern StructRNA RNA_ColorBalanceModifier;
extern StructRNA RNA_SequenceModifier;

float ColorBalanceModifier_color_multiply_get(PointerRNA *ptr);
void ColorBalanceModifier_color_multiply_set(PointerRNA *ptr, float value);

PointerRNA ColorBalanceModifier_color_balance_get(PointerRNA *ptr);

/**************** ColorManagedDisplaySettings ****************/

extern StructRNA RNA_ColorManagedDisplaySettings;

PointerRNA ColorManagedDisplaySettings_rna_type_get(PointerRNA *ptr);

enum {
	ColorManagedDisplaySettings_display_device_DEFAULT = 0,
};

int ColorManagedDisplaySettings_display_device_get(PointerRNA *ptr);
void ColorManagedDisplaySettings_display_device_set(PointerRNA *ptr, int value);

/**************** ColorManagedInputColorspaceSettings ****************/

extern StructRNA RNA_ColorManagedInputColorspaceSettings;

PointerRNA ColorManagedInputColorspaceSettings_rna_type_get(PointerRNA *ptr);

enum {
	ColorManagedInputColorspaceSettings_name_NONE = 0,
};

int ColorManagedInputColorspaceSettings_name_get(PointerRNA *ptr);
void ColorManagedInputColorspaceSettings_name_set(PointerRNA *ptr, int value);

/**************** ColorManagedSequencerColorspaceSettings ****************/

extern StructRNA RNA_ColorManagedSequencerColorspaceSettings;

PointerRNA ColorManagedSequencerColorspaceSettings_rna_type_get(PointerRNA *ptr);

enum {
	ColorManagedSequencerColorspaceSettings_name_NONE = 0,
};

int ColorManagedSequencerColorspaceSettings_name_get(PointerRNA *ptr);
void ColorManagedSequencerColorspaceSettings_name_set(PointerRNA *ptr, int value);

/**************** ColorManagedViewSettings ****************/

extern StructRNA RNA_ColorManagedViewSettings;

PointerRNA ColorManagedViewSettings_rna_type_get(PointerRNA *ptr);

PointerRNA ColorManagedViewSettings_curve_mapping_get(PointerRNA *ptr);

float ColorManagedViewSettings_exposure_get(PointerRNA *ptr);
void ColorManagedViewSettings_exposure_set(PointerRNA *ptr, float value);

float ColorManagedViewSettings_gamma_get(PointerRNA *ptr);
void ColorManagedViewSettings_gamma_set(PointerRNA *ptr, float value);

enum {
	ColorManagedViewSettings_look_NONE = 0,
};

int ColorManagedViewSettings_look_get(PointerRNA *ptr);
void ColorManagedViewSettings_look_set(PointerRNA *ptr, int value);

int ColorManagedViewSettings_use_curve_mapping_get(PointerRNA *ptr);
void ColorManagedViewSettings_use_curve_mapping_set(PointerRNA *ptr, int value);

enum {
	ColorManagedViewSettings_view_transform_NONE = 0,
};

int ColorManagedViewSettings_view_transform_get(PointerRNA *ptr);
void ColorManagedViewSettings_view_transform_set(PointerRNA *ptr, int value);

/**************** Color Mapping ****************/

extern StructRNA RNA_ColorMapping;

PointerRNA ColorMapping_rna_type_get(PointerRNA *ptr);

float ColorMapping_blend_factor_get(PointerRNA *ptr);
void ColorMapping_blend_factor_set(PointerRNA *ptr, float value);

enum {
	ColorMapping_blend_type_MIX = 0,
	ColorMapping_blend_type_ADD = 2,
	ColorMapping_blend_type_SUBTRACT = 3,
	ColorMapping_blend_type_MULTIPLY = 1,
	ColorMapping_blend_type_SCREEN = 8,
	ColorMapping_blend_type_OVERLAY = 9,
	ColorMapping_blend_type_DIFFERENCE = 6,
	ColorMapping_blend_type_DIVIDE = 4,
	ColorMapping_blend_type_DARKEN = 5,
	ColorMapping_blend_type_LIGHTEN = 7,
	ColorMapping_blend_type_HUE = 10,
	ColorMapping_blend_type_SATURATION = 11,
	ColorMapping_blend_type_VALUE = 12,
	ColorMapping_blend_type_COLOR = 13,
	ColorMapping_blend_type_SOFT_LIGHT = 15,
	ColorMapping_blend_type_LINEAR_LIGHT = 16,
};

int ColorMapping_blend_type_get(PointerRNA *ptr);
void ColorMapping_blend_type_set(PointerRNA *ptr, int value);

float ColorMapping_brightness_get(PointerRNA *ptr);
void ColorMapping_brightness_set(PointerRNA *ptr, float value);

void ColorMapping_blend_color_get(PointerRNA *ptr, float values[3]);
void ColorMapping_blend_color_set(PointerRNA *ptr, const float values[3]);

PointerRNA ColorMapping_color_ramp_get(PointerRNA *ptr);

float ColorMapping_contrast_get(PointerRNA *ptr);
void ColorMapping_contrast_set(PointerRNA *ptr, float value);

float ColorMapping_saturation_get(PointerRNA *ptr);
void ColorMapping_saturation_set(PointerRNA *ptr, float value);

int ColorMapping_use_color_ramp_get(PointerRNA *ptr);
void ColorMapping_use_color_ramp_set(PointerRNA *ptr, int value);

/**************** Color Ramp ****************/

extern StructRNA RNA_ColorRamp;

PointerRNA ColorRamp_rna_type_get(PointerRNA *ptr);

enum {
	ColorRamp_hue_interpolation_NEAR = 0,
	ColorRamp_hue_interpolation_FAR = 1,
	ColorRamp_hue_interpolation_CW = 2,
	ColorRamp_hue_interpolation_CCW = 3,
};

int ColorRamp_hue_interpolation_get(PointerRNA *ptr);
void ColorRamp_hue_interpolation_set(PointerRNA *ptr, int value);

enum {
	ColorRamp_color_mode_RGB = 0,
	ColorRamp_color_mode_HSV = 1,
	ColorRamp_color_mode_HSL = 2,
};

int ColorRamp_color_mode_get(PointerRNA *ptr);
void ColorRamp_color_mode_set(PointerRNA *ptr, int value);

void ColorRamp_elements_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ColorRamp_elements_next(CollectionPropertyIterator *iter);
void ColorRamp_elements_end(CollectionPropertyIterator *iter);
int ColorRamp_elements_length(PointerRNA *ptr);
int ColorRamp_elements_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	ColorRamp_interpolation_EASE = 1,
	ColorRamp_interpolation_CARDINAL = 3,
	ColorRamp_interpolation_LINEAR = 0,
	ColorRamp_interpolation_B_SPLINE = 2,
	ColorRamp_interpolation_CONSTANT = 4,
};

int ColorRamp_interpolation_get(PointerRNA *ptr);
void ColorRamp_interpolation_set(PointerRNA *ptr, int value);

void ColorRamp_evaluate(struct ColorBand *_self, float position, float color[4]);
/**************** Color Ramp Element ****************/

extern StructRNA RNA_ColorRampElement;

PointerRNA ColorRampElement_rna_type_get(PointerRNA *ptr);

float ColorRampElement_alpha_get(PointerRNA *ptr);
void ColorRampElement_alpha_set(PointerRNA *ptr, float value);

void ColorRampElement_color_get(PointerRNA *ptr, float values[4]);
void ColorRampElement_color_set(PointerRNA *ptr, const float values[4]);

float ColorRampElement_position_get(PointerRNA *ptr);
void ColorRampElement_position_set(PointerRNA *ptr, float value);

/**************** Color Ramp Elements ****************/

extern StructRNA RNA_ColorRampElements;

PointerRNA ColorRampElements_rna_type_get(PointerRNA *ptr);

struct CBData *ColorRampElements_new(struct ColorBand *_self, ReportList *reports, float position);
void ColorRampElements_remove(struct ColorBand *_self, ReportList *reports, struct PointerRNA *element);
/**************** Color Sequence ****************/

extern StructRNA RNA_ColorSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

void ColorSequence_color_get(PointerRNA *ptr, float values[3]);
void ColorSequence_color_set(PointerRNA *ptr, const float values[3]);

int ColorSequence_input_count_get(PointerRNA *ptr);
void ColorSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Compositor Node ****************/

extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void CompositorNode_tag_need_exec(struct bNode *_self);
/**************** Alpha Over ****************/

extern StructRNA RNA_CompositorNodeAlphaOver;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeAlphaOver_use_premultiply_get(PointerRNA *ptr);
void CompositorNodeAlphaOver_use_premultiply_set(PointerRNA *ptr, int value);

float CompositorNodeAlphaOver_premul_get(PointerRNA *ptr);
void CompositorNodeAlphaOver_premul_set(PointerRNA *ptr, float value);

int CompositorNodeAlphaOver_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeAlphaOver_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeAlphaOver_output_template(struct StructRNA *_type, int index);
/**************** Bilateral Blur ****************/

extern StructRNA RNA_CompositorNodeBilateralblur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeBilateralblur_sigma_color_get(PointerRNA *ptr);
void CompositorNodeBilateralblur_sigma_color_set(PointerRNA *ptr, float value);

int CompositorNodeBilateralblur_iterations_get(PointerRNA *ptr);
void CompositorNodeBilateralblur_iterations_set(PointerRNA *ptr, int value);

float CompositorNodeBilateralblur_sigma_space_get(PointerRNA *ptr);
void CompositorNodeBilateralblur_sigma_space_set(PointerRNA *ptr, float value);

int CompositorNodeBilateralblur_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeBilateralblur_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBilateralblur_output_template(struct StructRNA *_type, int index);
/**************** Blur ****************/

extern StructRNA RNA_CompositorNodeBlur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeBlur_aspect_correction_NONE = 0,
	CompositorNodeBlur_aspect_correction_Y = 1,
	CompositorNodeBlur_aspect_correction_X = 2,
};

int CompositorNodeBlur_aspect_correction_get(PointerRNA *ptr);
void CompositorNodeBlur_aspect_correction_set(PointerRNA *ptr, int value);

int CompositorNodeBlur_use_bokeh_get(PointerRNA *ptr);
void CompositorNodeBlur_use_bokeh_set(PointerRNA *ptr, int value);

float CompositorNodeBlur_factor_get(PointerRNA *ptr);
void CompositorNodeBlur_factor_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeBlur_filter_type_FLAT = 0,
	CompositorNodeBlur_filter_type_TENT = 1,
	CompositorNodeBlur_filter_type_QUAD = 2,
	CompositorNodeBlur_filter_type_CUBIC = 3,
	CompositorNodeBlur_filter_type_GAUSS = 5,
	CompositorNodeBlur_filter_type_FAST_GAUSS = 7,
	CompositorNodeBlur_filter_type_CATROM = 4,
	CompositorNodeBlur_filter_type_MITCH = 6,
};

int CompositorNodeBlur_filter_type_get(PointerRNA *ptr);
void CompositorNodeBlur_filter_type_set(PointerRNA *ptr, int value);

int CompositorNodeBlur_use_gamma_correction_get(PointerRNA *ptr);
void CompositorNodeBlur_use_gamma_correction_set(PointerRNA *ptr, int value);

int CompositorNodeBlur_use_relative_get(PointerRNA *ptr);
void CompositorNodeBlur_use_relative_set(PointerRNA *ptr, int value);

float CompositorNodeBlur_factor_x_get(PointerRNA *ptr);
void CompositorNodeBlur_factor_x_set(PointerRNA *ptr, float value);

float CompositorNodeBlur_factor_y_get(PointerRNA *ptr);
void CompositorNodeBlur_factor_y_set(PointerRNA *ptr, float value);

int CompositorNodeBlur_size_x_get(PointerRNA *ptr);
void CompositorNodeBlur_size_x_set(PointerRNA *ptr, int value);

int CompositorNodeBlur_size_y_get(PointerRNA *ptr);
void CompositorNodeBlur_size_y_set(PointerRNA *ptr, int value);

int CompositorNodeBlur_use_variable_size_get(PointerRNA *ptr);
void CompositorNodeBlur_use_variable_size_set(PointerRNA *ptr, int value);

int CompositorNodeBlur_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeBlur_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBlur_output_template(struct StructRNA *_type, int index);
/**************** Bokeh Blur ****************/

extern StructRNA RNA_CompositorNodeBokehBlur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeBokehBlur_blur_max_get(PointerRNA *ptr);
void CompositorNodeBokehBlur_blur_max_set(PointerRNA *ptr, float value);

int CompositorNodeBokehBlur_use_variable_size_get(PointerRNA *ptr);
void CompositorNodeBokehBlur_use_variable_size_set(PointerRNA *ptr, int value);

int CompositorNodeBokehBlur_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeBokehBlur_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBokehBlur_output_template(struct StructRNA *_type, int index);
/**************** Bokeh Image ****************/

extern StructRNA RNA_CompositorNodeBokehImage;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeBokehImage_angle_get(PointerRNA *ptr);
void CompositorNodeBokehImage_angle_set(PointerRNA *ptr, float value);

float CompositorNodeBokehImage_catadioptric_get(PointerRNA *ptr);
void CompositorNodeBokehImage_catadioptric_set(PointerRNA *ptr, float value);

int CompositorNodeBokehImage_flaps_get(PointerRNA *ptr);
void CompositorNodeBokehImage_flaps_set(PointerRNA *ptr, int value);

float CompositorNodeBokehImage_shift_get(PointerRNA *ptr);
void CompositorNodeBokehImage_shift_set(PointerRNA *ptr, float value);

float CompositorNodeBokehImage_rounding_get(PointerRNA *ptr);
void CompositorNodeBokehImage_rounding_set(PointerRNA *ptr, float value);

int CompositorNodeBokehImage_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeBokehImage_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBokehImage_output_template(struct StructRNA *_type, int index);
/**************** Box Mask ****************/

extern StructRNA RNA_CompositorNodeBoxMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeBoxMask_height_get(PointerRNA *ptr);
void CompositorNodeBoxMask_height_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeBoxMask_mask_type_ADD = 0,
	CompositorNodeBoxMask_mask_type_SUBTRACT = 1,
	CompositorNodeBoxMask_mask_type_MULTIPLY = 2,
	CompositorNodeBoxMask_mask_type_NOT = 3,
};

int CompositorNodeBoxMask_mask_type_get(PointerRNA *ptr);
void CompositorNodeBoxMask_mask_type_set(PointerRNA *ptr, int value);

float CompositorNodeBoxMask_rotation_get(PointerRNA *ptr);
void CompositorNodeBoxMask_rotation_set(PointerRNA *ptr, float value);

float CompositorNodeBoxMask_width_get(PointerRNA *ptr);
void CompositorNodeBoxMask_width_set(PointerRNA *ptr, float value);

float CompositorNodeBoxMask_x_get(PointerRNA *ptr);
void CompositorNodeBoxMask_x_set(PointerRNA *ptr, float value);

float CompositorNodeBoxMask_y_get(PointerRNA *ptr);
void CompositorNodeBoxMask_y_set(PointerRNA *ptr, float value);

int CompositorNodeBoxMask_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeBoxMask_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBoxMask_output_template(struct StructRNA *_type, int index);
/**************** Bright/Contrast ****************/

extern StructRNA RNA_CompositorNodeBrightContrast;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeBrightContrast_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeBrightContrast_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBrightContrast_output_template(struct StructRNA *_type, int index);
/**************** Channel Key ****************/

extern StructRNA RNA_CompositorNodeChannelMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeChannelMatte_limit_method_SINGLE = 0,
	CompositorNodeChannelMatte_limit_method_MAX = 1,
};

int CompositorNodeChannelMatte_limit_method_get(PointerRNA *ptr);
void CompositorNodeChannelMatte_limit_method_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeChannelMatte_matte_channel_R = 1,
	CompositorNodeChannelMatte_matte_channel_G = 2,
	CompositorNodeChannelMatte_matte_channel_B = 3,
};

int CompositorNodeChannelMatte_matte_channel_get(PointerRNA *ptr);
void CompositorNodeChannelMatte_matte_channel_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeChannelMatte_color_space_RGB = 1,
	CompositorNodeChannelMatte_color_space_HSV = 2,
	CompositorNodeChannelMatte_color_space_YUV = 3,
	CompositorNodeChannelMatte_color_space_YCC = 4,
};

int CompositorNodeChannelMatte_color_space_get(PointerRNA *ptr);
void CompositorNodeChannelMatte_color_space_set(PointerRNA *ptr, int value);

float CompositorNodeChannelMatte_limit_max_get(PointerRNA *ptr);
void CompositorNodeChannelMatte_limit_max_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeChannelMatte_limit_channel_R = 1,
	CompositorNodeChannelMatte_limit_channel_G = 2,
	CompositorNodeChannelMatte_limit_channel_B = 3,
};

int CompositorNodeChannelMatte_limit_channel_get(PointerRNA *ptr);
void CompositorNodeChannelMatte_limit_channel_set(PointerRNA *ptr, int value);

float CompositorNodeChannelMatte_limit_min_get(PointerRNA *ptr);
void CompositorNodeChannelMatte_limit_min_set(PointerRNA *ptr, float value);

int CompositorNodeChannelMatte_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeChannelMatte_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeChannelMatte_output_template(struct StructRNA *_type, int index);
/**************** Chroma Key ****************/

extern StructRNA RNA_CompositorNodeChromaMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeChromaMatte_tolerance_get(PointerRNA *ptr);
void CompositorNodeChromaMatte_tolerance_set(PointerRNA *ptr, float value);

float CompositorNodeChromaMatte_threshold_get(PointerRNA *ptr);
void CompositorNodeChromaMatte_threshold_set(PointerRNA *ptr, float value);

float CompositorNodeChromaMatte_gain_get(PointerRNA *ptr);
void CompositorNodeChromaMatte_gain_set(PointerRNA *ptr, float value);

float CompositorNodeChromaMatte_lift_get(PointerRNA *ptr);
void CompositorNodeChromaMatte_lift_set(PointerRNA *ptr, float value);

float CompositorNodeChromaMatte_shadow_adjust_get(PointerRNA *ptr);
void CompositorNodeChromaMatte_shadow_adjust_set(PointerRNA *ptr, float value);

int CompositorNodeChromaMatte_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeChromaMatte_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeChromaMatte_output_template(struct StructRNA *_type, int index);
/**************** Color Balance ****************/

extern StructRNA RNA_CompositorNodeColorBalance;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeColorBalance_correction_method_LIFT_GAMMA_GAIN = 0,
	CompositorNodeColorBalance_correction_method_OFFSET_POWER_SLOPE = 1,
};

int CompositorNodeColorBalance_correction_method_get(PointerRNA *ptr);
void CompositorNodeColorBalance_correction_method_set(PointerRNA *ptr, int value);

void CompositorNodeColorBalance_gain_get(PointerRNA *ptr, float values[3]);
void CompositorNodeColorBalance_gain_set(PointerRNA *ptr, const float values[3]);

void CompositorNodeColorBalance_gamma_get(PointerRNA *ptr, float values[3]);
void CompositorNodeColorBalance_gamma_set(PointerRNA *ptr, const float values[3]);

void CompositorNodeColorBalance_lift_get(PointerRNA *ptr, float values[3]);
void CompositorNodeColorBalance_lift_set(PointerRNA *ptr, const float values[3]);

void CompositorNodeColorBalance_offset_get(PointerRNA *ptr, float values[3]);
void CompositorNodeColorBalance_offset_set(PointerRNA *ptr, const float values[3]);

void CompositorNodeColorBalance_power_get(PointerRNA *ptr, float values[3]);
void CompositorNodeColorBalance_power_set(PointerRNA *ptr, const float values[3]);

void CompositorNodeColorBalance_slope_get(PointerRNA *ptr, float values[3]);
void CompositorNodeColorBalance_slope_set(PointerRNA *ptr, const float values[3]);

int CompositorNodeColorBalance_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeColorBalance_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeColorBalance_output_template(struct StructRNA *_type, int index);
/**************** Color Correction ****************/

extern StructRNA RNA_CompositorNodeColorCorrection;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeColorCorrection_blue_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_blue_set(PointerRNA *ptr, int value);

int CompositorNodeColorCorrection_green_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_green_set(PointerRNA *ptr, int value);

float CompositorNodeColorCorrection_highlights_contrast_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_highlights_contrast_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_highlights_gain_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_highlights_gain_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_highlights_gamma_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_highlights_gamma_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_highlights_lift_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_highlights_lift_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_highlights_saturation_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_highlights_saturation_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_master_contrast_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_master_contrast_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_master_gain_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_master_gain_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_master_gamma_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_master_gamma_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_master_lift_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_master_lift_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_master_saturation_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_master_saturation_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_midtones_contrast_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_midtones_contrast_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_midtones_end_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_midtones_end_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_midtones_gain_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_midtones_gain_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_midtones_gamma_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_midtones_gamma_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_midtones_lift_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_midtones_lift_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_midtones_saturation_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_midtones_saturation_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_midtones_start_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_midtones_start_set(PointerRNA *ptr, float value);

int CompositorNodeColorCorrection_red_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_red_set(PointerRNA *ptr, int value);

float CompositorNodeColorCorrection_shadows_contrast_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_shadows_contrast_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_shadows_gain_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_shadows_gain_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_shadows_gamma_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_shadows_gamma_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_shadows_lift_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_shadows_lift_set(PointerRNA *ptr, float value);

float CompositorNodeColorCorrection_shadows_saturation_get(PointerRNA *ptr);
void CompositorNodeColorCorrection_shadows_saturation_set(PointerRNA *ptr, float value);

int CompositorNodeColorCorrection_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeColorCorrection_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeColorCorrection_output_template(struct StructRNA *_type, int index);
/**************** Color Key ****************/

extern StructRNA RNA_CompositorNodeColorMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeColorMatte_color_hue_get(PointerRNA *ptr);
void CompositorNodeColorMatte_color_hue_set(PointerRNA *ptr, float value);

float CompositorNodeColorMatte_color_saturation_get(PointerRNA *ptr);
void CompositorNodeColorMatte_color_saturation_set(PointerRNA *ptr, float value);

float CompositorNodeColorMatte_color_value_get(PointerRNA *ptr);
void CompositorNodeColorMatte_color_value_set(PointerRNA *ptr, float value);

int CompositorNodeColorMatte_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeColorMatte_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeColorMatte_output_template(struct StructRNA *_type, int index);
/**************** Color Spill ****************/

extern StructRNA RNA_CompositorNodeColorSpill;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeColorSpill_limit_method_SIMPLE = 0,
	CompositorNodeColorSpill_limit_method_AVERAGE = 1,
};

int CompositorNodeColorSpill_limit_method_get(PointerRNA *ptr);
void CompositorNodeColorSpill_limit_method_set(PointerRNA *ptr, int value);

float CompositorNodeColorSpill_unspill_blue_get(PointerRNA *ptr);
void CompositorNodeColorSpill_unspill_blue_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeColorSpill_channel_R = 1,
	CompositorNodeColorSpill_channel_G = 2,
	CompositorNodeColorSpill_channel_B = 3,
};

int CompositorNodeColorSpill_channel_get(PointerRNA *ptr);
void CompositorNodeColorSpill_channel_set(PointerRNA *ptr, int value);

float CompositorNodeColorSpill_unspill_green_get(PointerRNA *ptr);
void CompositorNodeColorSpill_unspill_green_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeColorSpill_limit_channel_R = 1,
	CompositorNodeColorSpill_limit_channel_G = 2,
	CompositorNodeColorSpill_limit_channel_B = 3,
};

int CompositorNodeColorSpill_limit_channel_get(PointerRNA *ptr);
void CompositorNodeColorSpill_limit_channel_set(PointerRNA *ptr, int value);

float CompositorNodeColorSpill_unspill_red_get(PointerRNA *ptr);
void CompositorNodeColorSpill_unspill_red_set(PointerRNA *ptr, float value);

float CompositorNodeColorSpill_ratio_get(PointerRNA *ptr);
void CompositorNodeColorSpill_ratio_set(PointerRNA *ptr, float value);

int CompositorNodeColorSpill_use_unspill_get(PointerRNA *ptr);
void CompositorNodeColorSpill_use_unspill_set(PointerRNA *ptr, int value);

int CompositorNodeColorSpill_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeColorSpill_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeColorSpill_output_template(struct StructRNA *_type, int index);
/**************** Combine HSVA ****************/

extern StructRNA RNA_CompositorNodeCombHSVA;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeCombHSVA_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeCombHSVA_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCombHSVA_output_template(struct StructRNA *_type, int index);
/**************** Combine RGBA ****************/

extern StructRNA RNA_CompositorNodeCombRGBA;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeCombRGBA_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeCombRGBA_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCombRGBA_output_template(struct StructRNA *_type, int index);
/**************** Combine YCbCrA ****************/

extern StructRNA RNA_CompositorNodeCombYCCA;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeCombYCCA_mode_ITUBT601 = 0,
	CompositorNodeCombYCCA_mode_ITUBT709 = 1,
	CompositorNodeCombYCCA_mode_JFIF = 2,
};

int CompositorNodeCombYCCA_mode_get(PointerRNA *ptr);
void CompositorNodeCombYCCA_mode_set(PointerRNA *ptr, int value);

int CompositorNodeCombYCCA_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeCombYCCA_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCombYCCA_output_template(struct StructRNA *_type, int index);
/**************** Combine YUVA ****************/

extern StructRNA RNA_CompositorNodeCombYUVA;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeCombYUVA_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeCombYUVA_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCombYUVA_output_template(struct StructRNA *_type, int index);
/**************** Composite ****************/

extern StructRNA RNA_CompositorNodeComposite;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeComposite_use_alpha_get(PointerRNA *ptr);
void CompositorNodeComposite_use_alpha_set(PointerRNA *ptr, int value);

int CompositorNodeComposite_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeComposite_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeComposite_output_template(struct StructRNA *_type, int index);
/**************** Corner Pin ****************/

extern StructRNA RNA_CompositorNodeCornerPin;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeCornerPin_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeCornerPin_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCornerPin_output_template(struct StructRNA *_type, int index);
/**************** Crop ****************/

extern StructRNA RNA_CompositorNodeCrop;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeCrop_use_crop_size_get(PointerRNA *ptr);
void CompositorNodeCrop_use_crop_size_set(PointerRNA *ptr, int value);

int CompositorNodeCrop_relative_get(PointerRNA *ptr);
void CompositorNodeCrop_relative_set(PointerRNA *ptr, int value);

int CompositorNodeCrop_min_x_get(PointerRNA *ptr);
void CompositorNodeCrop_min_x_set(PointerRNA *ptr, int value);

float CompositorNodeCrop_rel_min_x_get(PointerRNA *ptr);
void CompositorNodeCrop_rel_min_x_set(PointerRNA *ptr, float value);

int CompositorNodeCrop_max_x_get(PointerRNA *ptr);
void CompositorNodeCrop_max_x_set(PointerRNA *ptr, int value);

float CompositorNodeCrop_rel_max_x_get(PointerRNA *ptr);
void CompositorNodeCrop_rel_max_x_set(PointerRNA *ptr, float value);

int CompositorNodeCrop_min_y_get(PointerRNA *ptr);
void CompositorNodeCrop_min_y_set(PointerRNA *ptr, int value);

float CompositorNodeCrop_rel_min_y_get(PointerRNA *ptr);
void CompositorNodeCrop_rel_min_y_set(PointerRNA *ptr, float value);

int CompositorNodeCrop_max_y_get(PointerRNA *ptr);
void CompositorNodeCrop_max_y_set(PointerRNA *ptr, int value);

float CompositorNodeCrop_rel_max_y_get(PointerRNA *ptr);
void CompositorNodeCrop_rel_max_y_set(PointerRNA *ptr, float value);

int CompositorNodeCrop_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeCrop_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCrop_output_template(struct StructRNA *_type, int index);
/**************** RGB Curves ****************/

extern StructRNA RNA_CompositorNodeCurveRGB;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeCurveRGB_mapping_get(PointerRNA *ptr);

int CompositorNodeCurveRGB_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeCurveRGB_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCurveRGB_output_template(struct StructRNA *_type, int index);
/**************** Vector Curves ****************/

extern StructRNA RNA_CompositorNodeCurveVec;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeCurveVec_mapping_get(PointerRNA *ptr);

int CompositorNodeCurveVec_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeCurveVec_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCurveVec_output_template(struct StructRNA *_type, int index);
/**************** Directional Blur ****************/

extern StructRNA RNA_CompositorNodeDBlur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeDBlur_angle_get(PointerRNA *ptr);
void CompositorNodeDBlur_angle_set(PointerRNA *ptr, float value);

float CompositorNodeDBlur_center_x_get(PointerRNA *ptr);
void CompositorNodeDBlur_center_x_set(PointerRNA *ptr, float value);

float CompositorNodeDBlur_center_y_get(PointerRNA *ptr);
void CompositorNodeDBlur_center_y_set(PointerRNA *ptr, float value);

float CompositorNodeDBlur_distance_get(PointerRNA *ptr);
void CompositorNodeDBlur_distance_set(PointerRNA *ptr, float value);

int CompositorNodeDBlur_iterations_get(PointerRNA *ptr);
void CompositorNodeDBlur_iterations_set(PointerRNA *ptr, int value);

float CompositorNodeDBlur_spin_get(PointerRNA *ptr);
void CompositorNodeDBlur_spin_set(PointerRNA *ptr, float value);

int CompositorNodeDBlur_use_wrap_get(PointerRNA *ptr);
void CompositorNodeDBlur_use_wrap_set(PointerRNA *ptr, int value);

float CompositorNodeDBlur_zoom_get(PointerRNA *ptr);
void CompositorNodeDBlur_zoom_set(PointerRNA *ptr, float value);

int CompositorNodeDBlur_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeDBlur_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDBlur_output_template(struct StructRNA *_type, int index);
/**************** Defocus ****************/

extern StructRNA RNA_CompositorNodeDefocus;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeDefocus_angle_get(PointerRNA *ptr);
void CompositorNodeDefocus_angle_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeDefocus_bokeh_OCTAGON = 8,
	CompositorNodeDefocus_bokeh_HEPTAGON = 7,
	CompositorNodeDefocus_bokeh_HEXAGON = 6,
	CompositorNodeDefocus_bokeh_PENTAGON = 5,
	CompositorNodeDefocus_bokeh_SQUARE = 4,
	CompositorNodeDefocus_bokeh_TRIANGLE = 3,
	CompositorNodeDefocus_bokeh_CIRCLE = 0,
};

int CompositorNodeDefocus_bokeh_get(PointerRNA *ptr);
void CompositorNodeDefocus_bokeh_set(PointerRNA *ptr, int value);

int CompositorNodeDefocus_use_gamma_correction_get(PointerRNA *ptr);
void CompositorNodeDefocus_use_gamma_correction_set(PointerRNA *ptr, int value);

float CompositorNodeDefocus_blur_max_get(PointerRNA *ptr);
void CompositorNodeDefocus_blur_max_set(PointerRNA *ptr, float value);

int CompositorNodeDefocus_use_preview_get(PointerRNA *ptr);
void CompositorNodeDefocus_use_preview_set(PointerRNA *ptr, int value);

PointerRNA CompositorNodeDefocus_scene_get(PointerRNA *ptr);

float CompositorNodeDefocus_threshold_get(PointerRNA *ptr);
void CompositorNodeDefocus_threshold_set(PointerRNA *ptr, float value);

int CompositorNodeDefocus_use_zbuffer_get(PointerRNA *ptr);
void CompositorNodeDefocus_use_zbuffer_set(PointerRNA *ptr, int value);

float CompositorNodeDefocus_z_scale_get(PointerRNA *ptr);
void CompositorNodeDefocus_z_scale_set(PointerRNA *ptr, float value);

float CompositorNodeDefocus_f_stop_get(PointerRNA *ptr);
void CompositorNodeDefocus_f_stop_set(PointerRNA *ptr, float value);

int CompositorNodeDefocus_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeDefocus_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDefocus_output_template(struct StructRNA *_type, int index);
/**************** Despeckle ****************/

extern StructRNA RNA_CompositorNodeDespeckle;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeDespeckle_threshold_neighbor_get(PointerRNA *ptr);
void CompositorNodeDespeckle_threshold_neighbor_set(PointerRNA *ptr, float value);

float CompositorNodeDespeckle_threshold_get(PointerRNA *ptr);
void CompositorNodeDespeckle_threshold_set(PointerRNA *ptr, float value);

int CompositorNodeDespeckle_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeDespeckle_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDespeckle_output_template(struct StructRNA *_type, int index);
/**************** Difference Key ****************/

extern StructRNA RNA_CompositorNodeDiffMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeDiffMatte_falloff_get(PointerRNA *ptr);
void CompositorNodeDiffMatte_falloff_set(PointerRNA *ptr, float value);

float CompositorNodeDiffMatte_tolerance_get(PointerRNA *ptr);
void CompositorNodeDiffMatte_tolerance_set(PointerRNA *ptr, float value);

int CompositorNodeDiffMatte_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeDiffMatte_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDiffMatte_output_template(struct StructRNA *_type, int index);
/**************** Dilate/Erode ****************/

extern StructRNA RNA_CompositorNodeDilateErode;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeDilateErode_distance_get(PointerRNA *ptr);
void CompositorNodeDilateErode_distance_set(PointerRNA *ptr, int value);

float CompositorNodeDilateErode_edge_get(PointerRNA *ptr);
void CompositorNodeDilateErode_edge_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeDilateErode_falloff_SMOOTH = 0,
	CompositorNodeDilateErode_falloff_SPHERE = 1,
	CompositorNodeDilateErode_falloff_ROOT = 2,
	CompositorNodeDilateErode_falloff_SHARP = 3,
	CompositorNodeDilateErode_falloff_LINEAR = 4,
};

int CompositorNodeDilateErode_falloff_get(PointerRNA *ptr);
void CompositorNodeDilateErode_falloff_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeDilateErode_mode_STEP = 0,
	CompositorNodeDilateErode_mode_THRESHOLD = 1,
	CompositorNodeDilateErode_mode_DISTANCE = 2,
	CompositorNodeDilateErode_mode_FEATHER = 3,
};

int CompositorNodeDilateErode_mode_get(PointerRNA *ptr);
void CompositorNodeDilateErode_mode_set(PointerRNA *ptr, int value);

int CompositorNodeDilateErode_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeDilateErode_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDilateErode_output_template(struct StructRNA *_type, int index);
/**************** Displace ****************/

extern StructRNA RNA_CompositorNodeDisplace;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeDisplace_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeDisplace_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDisplace_output_template(struct StructRNA *_type, int index);
/**************** Distance Key ****************/

extern StructRNA RNA_CompositorNodeDistanceMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeDistanceMatte_channel_RGB = 1,
	CompositorNodeDistanceMatte_channel_YCC = 2,
};

int CompositorNodeDistanceMatte_channel_get(PointerRNA *ptr);
void CompositorNodeDistanceMatte_channel_set(PointerRNA *ptr, int value);

float CompositorNodeDistanceMatte_falloff_get(PointerRNA *ptr);
void CompositorNodeDistanceMatte_falloff_set(PointerRNA *ptr, float value);

float CompositorNodeDistanceMatte_tolerance_get(PointerRNA *ptr);
void CompositorNodeDistanceMatte_tolerance_set(PointerRNA *ptr, float value);

int CompositorNodeDistanceMatte_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeDistanceMatte_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDistanceMatte_output_template(struct StructRNA *_type, int index);
/**************** Double Edge Mask ****************/

extern StructRNA RNA_CompositorNodeDoubleEdgeMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeDoubleEdgeMask_edge_mode_BLEED_OUT = 0,
	CompositorNodeDoubleEdgeMask_edge_mode_KEEP_IN = 1,
};

int CompositorNodeDoubleEdgeMask_edge_mode_get(PointerRNA *ptr);
void CompositorNodeDoubleEdgeMask_edge_mode_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeDoubleEdgeMask_inner_mode_ALL = 0,
	CompositorNodeDoubleEdgeMask_inner_mode_ADJACENT_ONLY = 1,
};

int CompositorNodeDoubleEdgeMask_inner_mode_get(PointerRNA *ptr);
void CompositorNodeDoubleEdgeMask_inner_mode_set(PointerRNA *ptr, int value);

int CompositorNodeDoubleEdgeMask_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeDoubleEdgeMask_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDoubleEdgeMask_output_template(struct StructRNA *_type, int index);
/**************** Ellipse Mask ****************/

extern StructRNA RNA_CompositorNodeEllipseMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeEllipseMask_height_get(PointerRNA *ptr);
void CompositorNodeEllipseMask_height_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeEllipseMask_mask_type_ADD = 0,
	CompositorNodeEllipseMask_mask_type_SUBTRACT = 1,
	CompositorNodeEllipseMask_mask_type_MULTIPLY = 2,
	CompositorNodeEllipseMask_mask_type_NOT = 3,
};

int CompositorNodeEllipseMask_mask_type_get(PointerRNA *ptr);
void CompositorNodeEllipseMask_mask_type_set(PointerRNA *ptr, int value);

float CompositorNodeEllipseMask_rotation_get(PointerRNA *ptr);
void CompositorNodeEllipseMask_rotation_set(PointerRNA *ptr, float value);

float CompositorNodeEllipseMask_width_get(PointerRNA *ptr);
void CompositorNodeEllipseMask_width_set(PointerRNA *ptr, float value);

float CompositorNodeEllipseMask_x_get(PointerRNA *ptr);
void CompositorNodeEllipseMask_x_set(PointerRNA *ptr, float value);

float CompositorNodeEllipseMask_y_get(PointerRNA *ptr);
void CompositorNodeEllipseMask_y_set(PointerRNA *ptr, float value);

int CompositorNodeEllipseMask_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeEllipseMask_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeEllipseMask_output_template(struct StructRNA *_type, int index);
/**************** Filter ****************/

extern StructRNA RNA_CompositorNodeFilter;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeFilter_filter_type_SOFTEN = 0,
	CompositorNodeFilter_filter_type_SHARPEN = 1,
	CompositorNodeFilter_filter_type_LAPLACE = 2,
	CompositorNodeFilter_filter_type_SOBEL = 3,
	CompositorNodeFilter_filter_type_PREWITT = 4,
	CompositorNodeFilter_filter_type_KIRSCH = 5,
	CompositorNodeFilter_filter_type_SHADOW = 6,
};

int CompositorNodeFilter_filter_type_get(PointerRNA *ptr);
void CompositorNodeFilter_filter_type_set(PointerRNA *ptr, int value);

int CompositorNodeFilter_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeFilter_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeFilter_output_template(struct StructRNA *_type, int index);
/**************** Flip ****************/

extern StructRNA RNA_CompositorNodeFlip;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeFlip_axis_X = 0,
	CompositorNodeFlip_axis_Y = 1,
	CompositorNodeFlip_axis_XY = 2,
};

int CompositorNodeFlip_axis_get(PointerRNA *ptr);
void CompositorNodeFlip_axis_set(PointerRNA *ptr, int value);

int CompositorNodeFlip_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeFlip_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeFlip_output_template(struct StructRNA *_type, int index);
/**************** Gamma ****************/

extern StructRNA RNA_CompositorNodeGamma;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeGamma_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeGamma_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeGamma_output_template(struct StructRNA *_type, int index);
/**************** Glare ****************/

extern StructRNA RNA_CompositorNodeGlare;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeGlare_angle_offset_get(PointerRNA *ptr);
void CompositorNodeGlare_angle_offset_set(PointerRNA *ptr, float value);

float CompositorNodeGlare_color_modulation_get(PointerRNA *ptr);
void CompositorNodeGlare_color_modulation_set(PointerRNA *ptr, float value);

float CompositorNodeGlare_fade_get(PointerRNA *ptr);
void CompositorNodeGlare_fade_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeGlare_glare_type_GHOSTS = 3,
	CompositorNodeGlare_glare_type_STREAKS = 2,
	CompositorNodeGlare_glare_type_FOG_GLOW = 1,
	CompositorNodeGlare_glare_type_SIMPLE_STAR = 0,
};

int CompositorNodeGlare_glare_type_get(PointerRNA *ptr);
void CompositorNodeGlare_glare_type_set(PointerRNA *ptr, int value);

int CompositorNodeGlare_iterations_get(PointerRNA *ptr);
void CompositorNodeGlare_iterations_set(PointerRNA *ptr, int value);

float CompositorNodeGlare_mix_get(PointerRNA *ptr);
void CompositorNodeGlare_mix_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeGlare_quality_HIGH = 0,
	CompositorNodeGlare_quality_MEDIUM = 1,
	CompositorNodeGlare_quality_LOW = 2,
};

int CompositorNodeGlare_quality_get(PointerRNA *ptr);
void CompositorNodeGlare_quality_set(PointerRNA *ptr, int value);

int CompositorNodeGlare_use_rotate_45_get(PointerRNA *ptr);
void CompositorNodeGlare_use_rotate_45_set(PointerRNA *ptr, int value);

int CompositorNodeGlare_size_get(PointerRNA *ptr);
void CompositorNodeGlare_size_set(PointerRNA *ptr, int value);

int CompositorNodeGlare_streaks_get(PointerRNA *ptr);
void CompositorNodeGlare_streaks_set(PointerRNA *ptr, int value);

float CompositorNodeGlare_threshold_get(PointerRNA *ptr);
void CompositorNodeGlare_threshold_set(PointerRNA *ptr, float value);

int CompositorNodeGlare_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeGlare_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeGlare_output_template(struct StructRNA *_type, int index);
/**************** Group ****************/

extern StructRNA RNA_CompositorNodeGroup;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeGroup_node_tree_get(PointerRNA *ptr);

int CompositorNodeGroup_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeGroup_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeGroup_output_template(struct StructRNA *_type, int index);
/**************** Hue Correct ****************/

extern StructRNA RNA_CompositorNodeHueCorrect;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeHueCorrect_mapping_get(PointerRNA *ptr);

int CompositorNodeHueCorrect_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeHueCorrect_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeHueCorrect_output_template(struct StructRNA *_type, int index);
/**************** Hue Saturation Value ****************/

extern StructRNA RNA_CompositorNodeHueSat;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeHueSat_color_hue_get(PointerRNA *ptr);
void CompositorNodeHueSat_color_hue_set(PointerRNA *ptr, float value);

float CompositorNodeHueSat_color_saturation_get(PointerRNA *ptr);
void CompositorNodeHueSat_color_saturation_set(PointerRNA *ptr, float value);

float CompositorNodeHueSat_color_value_get(PointerRNA *ptr);
void CompositorNodeHueSat_color_value_set(PointerRNA *ptr, float value);

int CompositorNodeHueSat_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeHueSat_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeHueSat_output_template(struct StructRNA *_type, int index);
/**************** ID Mask ****************/

extern StructRNA RNA_CompositorNodeIDMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeIDMask_use_antialiasing_get(PointerRNA *ptr);
void CompositorNodeIDMask_use_antialiasing_set(PointerRNA *ptr, int value);

int CompositorNodeIDMask_index_get(PointerRNA *ptr);
void CompositorNodeIDMask_index_set(PointerRNA *ptr, int value);

int CompositorNodeIDMask_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeIDMask_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeIDMask_output_template(struct StructRNA *_type, int index);
/**************** Image ****************/

extern StructRNA RNA_CompositorNodeImage;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeImage_use_auto_refresh_get(PointerRNA *ptr);
void CompositorNodeImage_use_auto_refresh_set(PointerRNA *ptr, int value);

int CompositorNodeImage_use_cyclic_get(PointerRNA *ptr);
void CompositorNodeImage_use_cyclic_set(PointerRNA *ptr, int value);

int CompositorNodeImage_frame_duration_get(PointerRNA *ptr);
void CompositorNodeImage_frame_duration_set(PointerRNA *ptr, int value);

PointerRNA CompositorNodeImage_image_get(PointerRNA *ptr);

enum {
	CompositorNodeImage_layer_PLACEHOLDER = 0,
};

int CompositorNodeImage_layer_get(PointerRNA *ptr);
void CompositorNodeImage_layer_set(PointerRNA *ptr, int value);

int CompositorNodeImage_frame_offset_get(PointerRNA *ptr);
void CompositorNodeImage_frame_offset_set(PointerRNA *ptr, int value);

int CompositorNodeImage_frame_start_get(PointerRNA *ptr);
void CompositorNodeImage_frame_start_set(PointerRNA *ptr, int value);

int CompositorNodeImage_use_straight_alpha_output_get(PointerRNA *ptr);
void CompositorNodeImage_use_straight_alpha_output_set(PointerRNA *ptr, int value);

int CompositorNodeImage_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeImage_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeImage_output_template(struct StructRNA *_type, int index);
/**************** Inpaint ****************/

extern StructRNA RNA_CompositorNodeInpaint;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeInpaint_distance_get(PointerRNA *ptr);
void CompositorNodeInpaint_distance_set(PointerRNA *ptr, int value);

int CompositorNodeInpaint_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeInpaint_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeInpaint_output_template(struct StructRNA *_type, int index);
/**************** Invert ****************/

extern StructRNA RNA_CompositorNodeInvert;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeInvert_invert_alpha_get(PointerRNA *ptr);
void CompositorNodeInvert_invert_alpha_set(PointerRNA *ptr, int value);

int CompositorNodeInvert_invert_rgb_get(PointerRNA *ptr);
void CompositorNodeInvert_invert_rgb_set(PointerRNA *ptr, int value);

int CompositorNodeInvert_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeInvert_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeInvert_output_template(struct StructRNA *_type, int index);
/**************** Keying ****************/

extern StructRNA RNA_CompositorNodeKeying;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeKeying_clip_black_get(PointerRNA *ptr);
void CompositorNodeKeying_clip_black_set(PointerRNA *ptr, float value);

float CompositorNodeKeying_clip_white_get(PointerRNA *ptr);
void CompositorNodeKeying_clip_white_set(PointerRNA *ptr, float value);

float CompositorNodeKeying_despill_balance_get(PointerRNA *ptr);
void CompositorNodeKeying_despill_balance_set(PointerRNA *ptr, float value);

float CompositorNodeKeying_despill_factor_get(PointerRNA *ptr);
void CompositorNodeKeying_despill_factor_set(PointerRNA *ptr, float value);

int CompositorNodeKeying_dilate_distance_get(PointerRNA *ptr);
void CompositorNodeKeying_dilate_distance_set(PointerRNA *ptr, int value);

int CompositorNodeKeying_edge_kernel_radius_get(PointerRNA *ptr);
void CompositorNodeKeying_edge_kernel_radius_set(PointerRNA *ptr, int value);

float CompositorNodeKeying_edge_kernel_tolerance_get(PointerRNA *ptr);
void CompositorNodeKeying_edge_kernel_tolerance_set(PointerRNA *ptr, float value);

int CompositorNodeKeying_feather_distance_get(PointerRNA *ptr);
void CompositorNodeKeying_feather_distance_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeKeying_feather_falloff_SMOOTH = 0,
	CompositorNodeKeying_feather_falloff_SPHERE = 1,
	CompositorNodeKeying_feather_falloff_ROOT = 2,
	CompositorNodeKeying_feather_falloff_SHARP = 3,
	CompositorNodeKeying_feather_falloff_LINEAR = 4,
};

int CompositorNodeKeying_feather_falloff_get(PointerRNA *ptr);
void CompositorNodeKeying_feather_falloff_set(PointerRNA *ptr, int value);

int CompositorNodeKeying_blur_post_get(PointerRNA *ptr);
void CompositorNodeKeying_blur_post_set(PointerRNA *ptr, int value);

int CompositorNodeKeying_blur_pre_get(PointerRNA *ptr);
void CompositorNodeKeying_blur_pre_set(PointerRNA *ptr, int value);

float CompositorNodeKeying_screen_balance_get(PointerRNA *ptr);
void CompositorNodeKeying_screen_balance_set(PointerRNA *ptr, float value);

int CompositorNodeKeying_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeKeying_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeKeying_output_template(struct StructRNA *_type, int index);
/**************** Keying Screen ****************/

extern StructRNA RNA_CompositorNodeKeyingScreen;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeKeyingScreen_clip_get(PointerRNA *ptr);

#define CompositorNodeKeyingScreen_tracking_object_MAX 64

void CompositorNodeKeyingScreen_tracking_object_get(PointerRNA *ptr, char *value);
int CompositorNodeKeyingScreen_tracking_object_length(PointerRNA *ptr);
void CompositorNodeKeyingScreen_tracking_object_set(PointerRNA *ptr, const char *value);

int CompositorNodeKeyingScreen_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeKeyingScreen_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeKeyingScreen_output_template(struct StructRNA *_type, int index);
/**************** Lens Distortion ****************/

extern StructRNA RNA_CompositorNodeLensdist;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeLensdist_use_fit_get(PointerRNA *ptr);
void CompositorNodeLensdist_use_fit_set(PointerRNA *ptr, int value);

int CompositorNodeLensdist_use_jitter_get(PointerRNA *ptr);
void CompositorNodeLensdist_use_jitter_set(PointerRNA *ptr, int value);

int CompositorNodeLensdist_use_projector_get(PointerRNA *ptr);
void CompositorNodeLensdist_use_projector_set(PointerRNA *ptr, int value);

int CompositorNodeLensdist_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeLensdist_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeLensdist_output_template(struct StructRNA *_type, int index);
/**************** Levels ****************/

extern StructRNA RNA_CompositorNodeLevels;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeLevels_channel_COMBINED_RGB = 1,
	CompositorNodeLevels_channel_RED = 2,
	CompositorNodeLevels_channel_GREEN = 3,
	CompositorNodeLevels_channel_BLUE = 4,
	CompositorNodeLevels_channel_LUMINANCE = 5,
};

int CompositorNodeLevels_channel_get(PointerRNA *ptr);
void CompositorNodeLevels_channel_set(PointerRNA *ptr, int value);

int CompositorNodeLevels_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeLevels_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeLevels_output_template(struct StructRNA *_type, int index);
/**************** Luminance Key ****************/

extern StructRNA RNA_CompositorNodeLumaMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeLumaMatte_limit_max_get(PointerRNA *ptr);
void CompositorNodeLumaMatte_limit_max_set(PointerRNA *ptr, float value);

float CompositorNodeLumaMatte_limit_min_get(PointerRNA *ptr);
void CompositorNodeLumaMatte_limit_min_set(PointerRNA *ptr, float value);

int CompositorNodeLumaMatte_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeLumaMatte_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeLumaMatte_output_template(struct StructRNA *_type, int index);
/**************** Map Range ****************/

extern StructRNA RNA_CompositorNodeMapRange;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeMapRange_use_clamp_get(PointerRNA *ptr);
void CompositorNodeMapRange_use_clamp_set(PointerRNA *ptr, int value);

int CompositorNodeMapRange_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeMapRange_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMapRange_output_template(struct StructRNA *_type, int index);
/**************** Map UV ****************/

extern StructRNA RNA_CompositorNodeMapUV;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeMapUV_alpha_get(PointerRNA *ptr);
void CompositorNodeMapUV_alpha_set(PointerRNA *ptr, int value);

int CompositorNodeMapUV_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeMapUV_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMapUV_output_template(struct StructRNA *_type, int index);
/**************** Map Value ****************/

extern StructRNA RNA_CompositorNodeMapValue;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void CompositorNodeMapValue_max_get(PointerRNA *ptr, float values[1]);
void CompositorNodeMapValue_max_set(PointerRNA *ptr, const float values[1]);

void CompositorNodeMapValue_min_get(PointerRNA *ptr, float values[1]);
void CompositorNodeMapValue_min_set(PointerRNA *ptr, const float values[1]);

void CompositorNodeMapValue_offset_get(PointerRNA *ptr, float values[1]);
void CompositorNodeMapValue_offset_set(PointerRNA *ptr, const float values[1]);

void CompositorNodeMapValue_size_get(PointerRNA *ptr, float values[1]);
void CompositorNodeMapValue_size_set(PointerRNA *ptr, const float values[1]);

int CompositorNodeMapValue_use_max_get(PointerRNA *ptr);
void CompositorNodeMapValue_use_max_set(PointerRNA *ptr, int value);

int CompositorNodeMapValue_use_min_get(PointerRNA *ptr);
void CompositorNodeMapValue_use_min_set(PointerRNA *ptr, int value);

int CompositorNodeMapValue_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeMapValue_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMapValue_output_template(struct StructRNA *_type, int index);
/**************** Mask ****************/

extern StructRNA RNA_CompositorNodeMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeMask_use_antialiasing_get(PointerRNA *ptr);
void CompositorNodeMask_use_antialiasing_set(PointerRNA *ptr, int value);

int CompositorNodeMask_use_feather_get(PointerRNA *ptr);
void CompositorNodeMask_use_feather_set(PointerRNA *ptr, int value);

PointerRNA CompositorNodeMask_mask_get(PointerRNA *ptr);

int CompositorNodeMask_use_motion_blur_get(PointerRNA *ptr);
void CompositorNodeMask_use_motion_blur_set(PointerRNA *ptr, int value);

int CompositorNodeMask_motion_blur_samples_get(PointerRNA *ptr);
void CompositorNodeMask_motion_blur_samples_set(PointerRNA *ptr, int value);

float CompositorNodeMask_motion_blur_shutter_get(PointerRNA *ptr);
void CompositorNodeMask_motion_blur_shutter_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeMask_size_source_SCENE = 0,
	CompositorNodeMask_size_source_FIXED = 256,
	CompositorNodeMask_size_source_FIXED_SCENE = 512,
};

int CompositorNodeMask_size_source_get(PointerRNA *ptr);
void CompositorNodeMask_size_source_set(PointerRNA *ptr, int value);

int CompositorNodeMask_size_x_get(PointerRNA *ptr);
void CompositorNodeMask_size_x_set(PointerRNA *ptr, int value);

int CompositorNodeMask_size_y_get(PointerRNA *ptr);
void CompositorNodeMask_size_y_set(PointerRNA *ptr, int value);

int CompositorNodeMask_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeMask_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMask_output_template(struct StructRNA *_type, int index);
/**************** Math ****************/

extern StructRNA RNA_CompositorNodeMath;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeMath_use_clamp_get(PointerRNA *ptr);
void CompositorNodeMath_use_clamp_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeMath_operation_ADD = 0,
	CompositorNodeMath_operation_SUBTRACT = 1,
	CompositorNodeMath_operation_MULTIPLY = 2,
	CompositorNodeMath_operation_DIVIDE = 3,
	CompositorNodeMath_operation_SINE = 4,
	CompositorNodeMath_operation_COSINE = 5,
	CompositorNodeMath_operation_TANGENT = 6,
	CompositorNodeMath_operation_ARCSINE = 7,
	CompositorNodeMath_operation_ARCCOSINE = 8,
	CompositorNodeMath_operation_ARCTANGENT = 9,
	CompositorNodeMath_operation_POWER = 10,
	CompositorNodeMath_operation_LOGARITHM = 11,
	CompositorNodeMath_operation_MINIMUM = 12,
	CompositorNodeMath_operation_MAXIMUM = 13,
	CompositorNodeMath_operation_ROUND = 14,
	CompositorNodeMath_operation_LESS_THAN = 15,
	CompositorNodeMath_operation_GREATER_THAN = 16,
	CompositorNodeMath_operation_MODULO = 17,
	CompositorNodeMath_operation_ABSOLUTE = 18,
};

int CompositorNodeMath_operation_get(PointerRNA *ptr);
void CompositorNodeMath_operation_set(PointerRNA *ptr, int value);

int CompositorNodeMath_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeMath_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMath_output_template(struct StructRNA *_type, int index);
/**************** Mix ****************/

extern StructRNA RNA_CompositorNodeMixRGB;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeMixRGB_use_alpha_get(PointerRNA *ptr);
void CompositorNodeMixRGB_use_alpha_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeMixRGB_blend_type_MIX = 0,
	CompositorNodeMixRGB_blend_type_ADD = 1,
	CompositorNodeMixRGB_blend_type_MULTIPLY = 2,
	CompositorNodeMixRGB_blend_type_SUBTRACT = 3,
	CompositorNodeMixRGB_blend_type_SCREEN = 4,
	CompositorNodeMixRGB_blend_type_DIVIDE = 5,
	CompositorNodeMixRGB_blend_type_DIFFERENCE = 6,
	CompositorNodeMixRGB_blend_type_DARKEN = 7,
	CompositorNodeMixRGB_blend_type_LIGHTEN = 8,
	CompositorNodeMixRGB_blend_type_OVERLAY = 9,
	CompositorNodeMixRGB_blend_type_DODGE = 10,
	CompositorNodeMixRGB_blend_type_BURN = 11,
	CompositorNodeMixRGB_blend_type_HUE = 12,
	CompositorNodeMixRGB_blend_type_SATURATION = 13,
	CompositorNodeMixRGB_blend_type_VALUE = 14,
	CompositorNodeMixRGB_blend_type_COLOR = 15,
	CompositorNodeMixRGB_blend_type_SOFT_LIGHT = 16,
	CompositorNodeMixRGB_blend_type_LINEAR_LIGHT = 17,
};

int CompositorNodeMixRGB_blend_type_get(PointerRNA *ptr);
void CompositorNodeMixRGB_blend_type_set(PointerRNA *ptr, int value);

int CompositorNodeMixRGB_use_clamp_get(PointerRNA *ptr);
void CompositorNodeMixRGB_use_clamp_set(PointerRNA *ptr, int value);

int CompositorNodeMixRGB_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeMixRGB_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMixRGB_output_template(struct StructRNA *_type, int index);
/**************** Movie Clip ****************/

extern StructRNA RNA_CompositorNodeMovieClip;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeMovieClip_clip_get(PointerRNA *ptr);

int CompositorNodeMovieClip_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeMovieClip_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMovieClip_output_template(struct StructRNA *_type, int index);
/**************** Movie Distortion ****************/

extern StructRNA RNA_CompositorNodeMovieDistortion;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeMovieDistortion_distortion_type_UNDISTORT = 0,
	CompositorNodeMovieDistortion_distortion_type_DISTORT = 1,
};

int CompositorNodeMovieDistortion_distortion_type_get(PointerRNA *ptr);
void CompositorNodeMovieDistortion_distortion_type_set(PointerRNA *ptr, int value);

PointerRNA CompositorNodeMovieDistortion_clip_get(PointerRNA *ptr);

int CompositorNodeMovieDistortion_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeMovieDistortion_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMovieDistortion_output_template(struct StructRNA *_type, int index);
/**************** Normal ****************/

extern StructRNA RNA_CompositorNodeNormal;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeNormal_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeNormal_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeNormal_output_template(struct StructRNA *_type, int index);
/**************** Normalize ****************/

extern StructRNA RNA_CompositorNodeNormalize;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeNormalize_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeNormalize_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeNormalize_output_template(struct StructRNA *_type, int index);
/**************** File Output ****************/

extern StructRNA RNA_CompositorNodeOutputFile;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeOutputFile_active_input_index_get(PointerRNA *ptr);
void CompositorNodeOutputFile_active_input_index_set(PointerRNA *ptr, int value);

#define CompositorNodeOutputFile_base_path_MAX 1024

void CompositorNodeOutputFile_base_path_get(PointerRNA *ptr, char *value);
int CompositorNodeOutputFile_base_path_length(PointerRNA *ptr);
void CompositorNodeOutputFile_base_path_set(PointerRNA *ptr, const char *value);

void CompositorNodeOutputFile_layer_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CompositorNodeOutputFile_layer_slots_next(CollectionPropertyIterator *iter);
void CompositorNodeOutputFile_layer_slots_end(CollectionPropertyIterator *iter);

void CompositorNodeOutputFile_file_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CompositorNodeOutputFile_file_slots_next(CollectionPropertyIterator *iter);
void CompositorNodeOutputFile_file_slots_end(CollectionPropertyIterator *iter);

PointerRNA CompositorNodeOutputFile_format_get(PointerRNA *ptr);

int CompositorNodeOutputFile_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeOutputFile_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeOutputFile_output_template(struct StructRNA *_type, int index);
/**************** File Output Slots ****************/

extern StructRNA RNA_CompositorNodeOutputFileFileSlots;

PointerRNA CompositorNodeOutputFileFileSlots_rna_type_get(PointerRNA *ptr);

struct bNodeSocket *CompositorNodeOutputFileFileSlots_new(struct ID *_selfid, struct bNode *_self, bContext *C, ReportList *reports, const char * name);
void CompositorNodeOutputFileFileSlots_remove(struct ID *_selfid, struct bNode *_self, ReportList *reports, struct bNodeSocket *socket);
void CompositorNodeOutputFileFileSlots_clear(struct ID *_selfid, struct bNode *_self);
void CompositorNodeOutputFileFileSlots_move(struct ID *_selfid, struct bNode *_self, int from_index, int to_index);
/**************** File Output Slots ****************/

extern StructRNA RNA_CompositorNodeOutputFileLayerSlots;

PointerRNA CompositorNodeOutputFileLayerSlots_rna_type_get(PointerRNA *ptr);

struct bNodeSocket *CompositorNodeOutputFileLayerSlots_new(struct ID *_selfid, struct bNode *_self, bContext *C, ReportList *reports, const char * name);
void CompositorNodeOutputFileLayerSlots_remove(struct ID *_selfid, struct bNode *_self, ReportList *reports, struct bNodeSocket *socket);
void CompositorNodeOutputFileLayerSlots_clear(struct ID *_selfid, struct bNode *_self);
void CompositorNodeOutputFileLayerSlots_move(struct ID *_selfid, struct bNode *_self, int from_index, int to_index);
/**************** Pixelate ****************/

extern StructRNA RNA_CompositorNodePixelate;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodePixelate_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodePixelate_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodePixelate_output_template(struct StructRNA *_type, int index);
/**************** Plane Track Deform ****************/

extern StructRNA RNA_CompositorNodePlaneTrackDeform;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodePlaneTrackDeform_clip_get(PointerRNA *ptr);

#define CompositorNodePlaneTrackDeform_plane_track_name_MAX 64

void CompositorNodePlaneTrackDeform_plane_track_name_get(PointerRNA *ptr, char *value);
int CompositorNodePlaneTrackDeform_plane_track_name_length(PointerRNA *ptr);
void CompositorNodePlaneTrackDeform_plane_track_name_set(PointerRNA *ptr, const char *value);

#define CompositorNodePlaneTrackDeform_tracking_object_MAX 64

void CompositorNodePlaneTrackDeform_tracking_object_get(PointerRNA *ptr, char *value);
int CompositorNodePlaneTrackDeform_tracking_object_length(PointerRNA *ptr);
void CompositorNodePlaneTrackDeform_tracking_object_set(PointerRNA *ptr, const char *value);

int CompositorNodePlaneTrackDeform_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodePlaneTrackDeform_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodePlaneTrackDeform_output_template(struct StructRNA *_type, int index);
/**************** Alpha Convert ****************/

extern StructRNA RNA_CompositorNodePremulKey;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodePremulKey_mapping_STRAIGHT_TO_PREMUL = 0,
	CompositorNodePremulKey_mapping_PREMUL_TO_STRAIGHT = 1,
};

int CompositorNodePremulKey_mapping_get(PointerRNA *ptr);
void CompositorNodePremulKey_mapping_set(PointerRNA *ptr, int value);

int CompositorNodePremulKey_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodePremulKey_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodePremulKey_output_template(struct StructRNA *_type, int index);
/**************** RGB ****************/

extern StructRNA RNA_CompositorNodeRGB;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeRGB_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeRGB_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeRGB_output_template(struct StructRNA *_type, int index);
/**************** RGB to BW ****************/

extern StructRNA RNA_CompositorNodeRGBToBW;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeRGBToBW_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeRGBToBW_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeRGBToBW_output_template(struct StructRNA *_type, int index);
/**************** Render Layers ****************/

extern StructRNA RNA_CompositorNodeRLayers;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeRLayers_layer_PLACEHOLDER = 0,
};

int CompositorNodeRLayers_layer_get(PointerRNA *ptr);
void CompositorNodeRLayers_layer_set(PointerRNA *ptr, int value);

PointerRNA CompositorNodeRLayers_scene_get(PointerRNA *ptr);

int CompositorNodeRLayers_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeRLayers_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeRLayers_output_template(struct StructRNA *_type, int index);
/**************** Rotate ****************/

extern StructRNA RNA_CompositorNodeRotate;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeRotate_filter_type_NEAREST = 0,
	CompositorNodeRotate_filter_type_BILINEAR = 1,
	CompositorNodeRotate_filter_type_BICUBIC = 2,
};

int CompositorNodeRotate_filter_type_get(PointerRNA *ptr);
void CompositorNodeRotate_filter_type_set(PointerRNA *ptr, int value);

int CompositorNodeRotate_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeRotate_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeRotate_output_template(struct StructRNA *_type, int index);
/**************** Scale ****************/

extern StructRNA RNA_CompositorNodeScale;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeScale_frame_method_STRETCH = 0,
	CompositorNodeScale_frame_method_FIT = 1,
	CompositorNodeScale_frame_method_CROP = 3,
};

int CompositorNodeScale_frame_method_get(PointerRNA *ptr);
void CompositorNodeScale_frame_method_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeScale_space_RELATIVE = 0,
	CompositorNodeScale_space_ABSOLUTE = 1,
	CompositorNodeScale_space_SCENE_SIZE = 2,
	CompositorNodeScale_space_RENDER_SIZE = 3,
};

int CompositorNodeScale_space_get(PointerRNA *ptr);
void CompositorNodeScale_space_set(PointerRNA *ptr, int value);

float CompositorNodeScale_offset_x_get(PointerRNA *ptr);
void CompositorNodeScale_offset_x_set(PointerRNA *ptr, float value);

float CompositorNodeScale_offset_y_get(PointerRNA *ptr);
void CompositorNodeScale_offset_y_set(PointerRNA *ptr, float value);

int CompositorNodeScale_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeScale_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeScale_output_template(struct StructRNA *_type, int index);
/**************** Separate HSVA ****************/

extern StructRNA RNA_CompositorNodeSepHSVA;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeSepHSVA_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeSepHSVA_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSepHSVA_output_template(struct StructRNA *_type, int index);
/**************** Separate RGBA ****************/

extern StructRNA RNA_CompositorNodeSepRGBA;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeSepRGBA_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeSepRGBA_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSepRGBA_output_template(struct StructRNA *_type, int index);
/**************** Separate YCbCrA ****************/

extern StructRNA RNA_CompositorNodeSepYCCA;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeSepYCCA_mode_ITUBT601 = 0,
	CompositorNodeSepYCCA_mode_ITUBT709 = 1,
	CompositorNodeSepYCCA_mode_JFIF = 2,
};

int CompositorNodeSepYCCA_mode_get(PointerRNA *ptr);
void CompositorNodeSepYCCA_mode_set(PointerRNA *ptr, int value);

int CompositorNodeSepYCCA_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeSepYCCA_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSepYCCA_output_template(struct StructRNA *_type, int index);
/**************** Separate YUVA ****************/

extern StructRNA RNA_CompositorNodeSepYUVA;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeSepYUVA_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeSepYUVA_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSepYUVA_output_template(struct StructRNA *_type, int index);
/**************** Set Alpha ****************/

extern StructRNA RNA_CompositorNodeSetAlpha;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeSetAlpha_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeSetAlpha_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSetAlpha_output_template(struct StructRNA *_type, int index);
/**************** Split Viewer ****************/

extern StructRNA RNA_CompositorNodeSplitViewer;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeSplitViewer_axis_X = 0,
	CompositorNodeSplitViewer_axis_Y = 1,
};

int CompositorNodeSplitViewer_axis_get(PointerRNA *ptr);
void CompositorNodeSplitViewer_axis_set(PointerRNA *ptr, int value);

int CompositorNodeSplitViewer_factor_get(PointerRNA *ptr);
void CompositorNodeSplitViewer_factor_set(PointerRNA *ptr, int value);

int CompositorNodeSplitViewer_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeSplitViewer_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSplitViewer_output_template(struct StructRNA *_type, int index);
/**************** Stabilize 2D ****************/

extern StructRNA RNA_CompositorNodeStabilize;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeStabilize_filter_type_NEAREST = 0,
	CompositorNodeStabilize_filter_type_BILINEAR = 1,
	CompositorNodeStabilize_filter_type_BICUBIC = 2,
};

int CompositorNodeStabilize_filter_type_get(PointerRNA *ptr);
void CompositorNodeStabilize_filter_type_set(PointerRNA *ptr, int value);

PointerRNA CompositorNodeStabilize_clip_get(PointerRNA *ptr);

int CompositorNodeStabilize_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeStabilize_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeStabilize_output_template(struct StructRNA *_type, int index);
/**************** Sun Beams ****************/

extern StructRNA RNA_CompositorNodeSunBeams;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeSunBeams_ray_length_get(PointerRNA *ptr);
void CompositorNodeSunBeams_ray_length_set(PointerRNA *ptr, float value);

void CompositorNodeSunBeams_source_get(PointerRNA *ptr, float values[2]);
void CompositorNodeSunBeams_source_set(PointerRNA *ptr, const float values[2]);

int CompositorNodeSunBeams_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeSunBeams_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSunBeams_output_template(struct StructRNA *_type, int index);
/**************** Switch ****************/

extern StructRNA RNA_CompositorNodeSwitch;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeSwitch_check_get(PointerRNA *ptr);
void CompositorNodeSwitch_check_set(PointerRNA *ptr, int value);

int CompositorNodeSwitch_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeSwitch_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSwitch_output_template(struct StructRNA *_type, int index);
/**************** Texture ****************/

extern StructRNA RNA_CompositorNodeTexture;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeTexture_node_output_get(PointerRNA *ptr);
void CompositorNodeTexture_node_output_set(PointerRNA *ptr, int value);

PointerRNA CompositorNodeTexture_texture_get(PointerRNA *ptr);

int CompositorNodeTexture_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeTexture_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTexture_output_template(struct StructRNA *_type, int index);
/**************** Time ****************/

extern StructRNA RNA_CompositorNodeTime;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeTime_curve_get(PointerRNA *ptr);

int CompositorNodeTime_frame_end_get(PointerRNA *ptr);
void CompositorNodeTime_frame_end_set(PointerRNA *ptr, int value);

int CompositorNodeTime_frame_start_get(PointerRNA *ptr);
void CompositorNodeTime_frame_start_set(PointerRNA *ptr, int value);

int CompositorNodeTime_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeTime_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTime_output_template(struct StructRNA *_type, int index);
/**************** Tonemap ****************/

extern StructRNA RNA_CompositorNodeTonemap;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeTonemap_adaptation_get(PointerRNA *ptr);
void CompositorNodeTonemap_adaptation_set(PointerRNA *ptr, float value);

float CompositorNodeTonemap_correction_get(PointerRNA *ptr);
void CompositorNodeTonemap_correction_set(PointerRNA *ptr, float value);

float CompositorNodeTonemap_contrast_get(PointerRNA *ptr);
void CompositorNodeTonemap_contrast_set(PointerRNA *ptr, float value);

float CompositorNodeTonemap_gamma_get(PointerRNA *ptr);
void CompositorNodeTonemap_gamma_set(PointerRNA *ptr, float value);

float CompositorNodeTonemap_intensity_get(PointerRNA *ptr);
void CompositorNodeTonemap_intensity_set(PointerRNA *ptr, float value);

float CompositorNodeTonemap_key_get(PointerRNA *ptr);
void CompositorNodeTonemap_key_set(PointerRNA *ptr, float value);

float CompositorNodeTonemap_offset_get(PointerRNA *ptr);
void CompositorNodeTonemap_offset_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeTonemap_tonemap_type_RD_PHOTORECEPTOR = 1,
	CompositorNodeTonemap_tonemap_type_RH_SIMPLE = 0,
};

int CompositorNodeTonemap_tonemap_type_get(PointerRNA *ptr);
void CompositorNodeTonemap_tonemap_type_set(PointerRNA *ptr, int value);

int CompositorNodeTonemap_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeTonemap_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTonemap_output_template(struct StructRNA *_type, int index);
/**************** Track Position ****************/

extern StructRNA RNA_CompositorNodeTrackPos;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeTrackPos_frame_relative_get(PointerRNA *ptr);
void CompositorNodeTrackPos_frame_relative_set(PointerRNA *ptr, int value);

PointerRNA CompositorNodeTrackPos_clip_get(PointerRNA *ptr);

enum {
	CompositorNodeTrackPos_position_ABSOLUTE = 0,
	CompositorNodeTrackPos_position_RELATIVE_START = 1,
	CompositorNodeTrackPos_position_RELATIVE_FRAME = 2,
	CompositorNodeTrackPos_position_ABSOLUTE_FRAME = 3,
};

int CompositorNodeTrackPos_position_get(PointerRNA *ptr);
void CompositorNodeTrackPos_position_set(PointerRNA *ptr, int value);

#define CompositorNodeTrackPos_track_name_MAX 64

void CompositorNodeTrackPos_track_name_get(PointerRNA *ptr, char *value);
int CompositorNodeTrackPos_track_name_length(PointerRNA *ptr);
void CompositorNodeTrackPos_track_name_set(PointerRNA *ptr, const char *value);

#define CompositorNodeTrackPos_tracking_object_MAX 64

void CompositorNodeTrackPos_tracking_object_get(PointerRNA *ptr, char *value);
int CompositorNodeTrackPos_tracking_object_length(PointerRNA *ptr);
void CompositorNodeTrackPos_tracking_object_set(PointerRNA *ptr, const char *value);

int CompositorNodeTrackPos_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeTrackPos_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTrackPos_output_template(struct StructRNA *_type, int index);
/**************** Transform ****************/

extern StructRNA RNA_CompositorNodeTransform;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeTransform_filter_type_NEAREST = 0,
	CompositorNodeTransform_filter_type_BILINEAR = 1,
	CompositorNodeTransform_filter_type_BICUBIC = 2,
};

int CompositorNodeTransform_filter_type_get(PointerRNA *ptr);
void CompositorNodeTransform_filter_type_set(PointerRNA *ptr, int value);

int CompositorNodeTransform_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeTransform_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTransform_output_template(struct StructRNA *_type, int index);
/**************** Translate ****************/

extern StructRNA RNA_CompositorNodeTranslate;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeTranslate_use_relative_get(PointerRNA *ptr);
void CompositorNodeTranslate_use_relative_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeTranslate_wrap_axis_NONE = 0,
	CompositorNodeTranslate_wrap_axis_XAXIS = 1,
	CompositorNodeTranslate_wrap_axis_YAXIS = 2,
	CompositorNodeTranslate_wrap_axis_BOTH = 3,
};

int CompositorNodeTranslate_wrap_axis_get(PointerRNA *ptr);
void CompositorNodeTranslate_wrap_axis_set(PointerRNA *ptr, int value);

int CompositorNodeTranslate_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeTranslate_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTranslate_output_template(struct StructRNA *_type, int index);
/**************** Compositor Node Tree ****************/

extern StructRNA RNA_CompositorNodeTree;
extern StructRNA RNA_NodeTree;
extern StructRNA RNA_ID;

int CompositorNodeTree_use_groupnode_buffer_get(PointerRNA *ptr);
void CompositorNodeTree_use_groupnode_buffer_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeTree_chunk_size_32 = 32,
	CompositorNodeTree_chunk_size_64 = 64,
	CompositorNodeTree_chunk_size_128 = 128,
	CompositorNodeTree_chunk_size_256 = 256,
	CompositorNodeTree_chunk_size_512 = 512,
	CompositorNodeTree_chunk_size_1024 = 1024,
};

int CompositorNodeTree_chunk_size_get(PointerRNA *ptr);
void CompositorNodeTree_chunk_size_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeTree_edit_quality_HIGH = 0,
	CompositorNodeTree_edit_quality_MEDIUM = 1,
	CompositorNodeTree_edit_quality_LOW = 2,
};

int CompositorNodeTree_edit_quality_get(PointerRNA *ptr);
void CompositorNodeTree_edit_quality_set(PointerRNA *ptr, int value);

int CompositorNodeTree_use_opencl_get(PointerRNA *ptr);
void CompositorNodeTree_use_opencl_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeTree_render_quality_HIGH = 0,
	CompositorNodeTree_render_quality_MEDIUM = 1,
	CompositorNodeTree_render_quality_LOW = 2,
};

int CompositorNodeTree_render_quality_get(PointerRNA *ptr);
void CompositorNodeTree_render_quality_set(PointerRNA *ptr, int value);

int CompositorNodeTree_use_two_pass_get(PointerRNA *ptr);
void CompositorNodeTree_use_two_pass_set(PointerRNA *ptr, int value);

int CompositorNodeTree_use_viewer_border_get(PointerRNA *ptr);
void CompositorNodeTree_use_viewer_border_set(PointerRNA *ptr, int value);

/**************** ColorRamp ****************/

extern StructRNA RNA_CompositorNodeValToRGB;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeValToRGB_color_ramp_get(PointerRNA *ptr);

int CompositorNodeValToRGB_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeValToRGB_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeValToRGB_output_template(struct StructRNA *_type, int index);
/**************** Value ****************/

extern StructRNA RNA_CompositorNodeValue;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeValue_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeValue_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeValue_output_template(struct StructRNA *_type, int index);
/**************** Vector Blur ****************/

extern StructRNA RNA_CompositorNodeVecBlur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeVecBlur_factor_get(PointerRNA *ptr);
void CompositorNodeVecBlur_factor_set(PointerRNA *ptr, float value);

int CompositorNodeVecBlur_use_curved_get(PointerRNA *ptr);
void CompositorNodeVecBlur_use_curved_set(PointerRNA *ptr, int value);

int CompositorNodeVecBlur_speed_max_get(PointerRNA *ptr);
void CompositorNodeVecBlur_speed_max_set(PointerRNA *ptr, int value);

int CompositorNodeVecBlur_speed_min_get(PointerRNA *ptr);
void CompositorNodeVecBlur_speed_min_set(PointerRNA *ptr, int value);

int CompositorNodeVecBlur_samples_get(PointerRNA *ptr);
void CompositorNodeVecBlur_samples_set(PointerRNA *ptr, int value);

int CompositorNodeVecBlur_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeVecBlur_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeVecBlur_output_template(struct StructRNA *_type, int index);
/**************** Viewer ****************/

extern StructRNA RNA_CompositorNodeViewer;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeViewer_tile_order_CENTEROUT = 0,
	CompositorNodeViewer_tile_order_RANDOM = 1,
	CompositorNodeViewer_tile_order_BOTTOMUP = 2,
	CompositorNodeViewer_tile_order_RULE_OF_THIRDS = 3,
};

int CompositorNodeViewer_tile_order_get(PointerRNA *ptr);
void CompositorNodeViewer_tile_order_set(PointerRNA *ptr, int value);

int CompositorNodeViewer_use_alpha_get(PointerRNA *ptr);
void CompositorNodeViewer_use_alpha_set(PointerRNA *ptr, int value);

float CompositorNodeViewer_center_x_get(PointerRNA *ptr);
void CompositorNodeViewer_center_x_set(PointerRNA *ptr, float value);

float CompositorNodeViewer_center_y_get(PointerRNA *ptr);
void CompositorNodeViewer_center_y_set(PointerRNA *ptr, float value);

int CompositorNodeViewer_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeViewer_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeViewer_output_template(struct StructRNA *_type, int index);
/**************** Z Combine ****************/

extern StructRNA RNA_CompositorNodeZcombine;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeZcombine_use_antialias_z_get(PointerRNA *ptr);
void CompositorNodeZcombine_use_antialias_z_set(PointerRNA *ptr, int value);

int CompositorNodeZcombine_use_alpha_get(PointerRNA *ptr);
void CompositorNodeZcombine_use_alpha_set(PointerRNA *ptr, int value);

int CompositorNodeZcombine_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA CompositorNodeZcombine_input_template(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeZcombine_output_template(struct StructRNA *_type, int index);
/**************** Console Input ****************/

extern StructRNA RNA_ConsoleLine;

PointerRNA ConsoleLine_rna_type_get(PointerRNA *ptr);

void ConsoleLine_body_get(PointerRNA *ptr, char *value);
int ConsoleLine_body_length(PointerRNA *ptr);
void ConsoleLine_body_set(PointerRNA *ptr, const char *value);

enum {
	ConsoleLine_type_OUTPUT = 0,
	ConsoleLine_type_INPUT = 1,
	ConsoleLine_type_INFO = 2,
	ConsoleLine_type_ERROR = 3,
};

int ConsoleLine_type_get(PointerRNA *ptr);
void ConsoleLine_type_set(PointerRNA *ptr, int value);

int ConsoleLine_current_character_get(PointerRNA *ptr);
void ConsoleLine_current_character_set(PointerRNA *ptr, int value);

/**************** Constraint ****************/

extern StructRNA RNA_Constraint;

PointerRNA Constraint_rna_type_get(PointerRNA *ptr);

#define Constraint_name_MAX 64

void Constraint_name_get(PointerRNA *ptr, char *value);
int Constraint_name_length(PointerRNA *ptr);
void Constraint_name_set(PointerRNA *ptr, const char *value);

int Constraint_active_get(PointerRNA *ptr);
void Constraint_active_set(PointerRNA *ptr, int value);

int Constraint_mute_get(PointerRNA *ptr);
void Constraint_mute_set(PointerRNA *ptr, int value);

int Constraint_show_expanded_get(PointerRNA *ptr);
void Constraint_show_expanded_set(PointerRNA *ptr, int value);

float Constraint_influence_get(PointerRNA *ptr);
void Constraint_influence_set(PointerRNA *ptr, float value);

float Constraint_error_location_get(PointerRNA *ptr);
void Constraint_error_location_set(PointerRNA *ptr, float value);

enum {
	Constraint_owner_space_WORLD = 0,
	Constraint_owner_space_POSE = 2,
	Constraint_owner_space_LOCAL_WITH_PARENT = 3,
	Constraint_owner_space_LOCAL = 1,
};

int Constraint_owner_space_get(PointerRNA *ptr);
void Constraint_owner_space_set(PointerRNA *ptr, int value);

int Constraint_is_proxy_local_get(PointerRNA *ptr);
void Constraint_is_proxy_local_set(PointerRNA *ptr, int value);

float Constraint_error_rotation_get(PointerRNA *ptr);
void Constraint_error_rotation_set(PointerRNA *ptr, float value);

enum {
	Constraint_target_space_WORLD = 0,
	Constraint_target_space_POSE = 2,
	Constraint_target_space_LOCAL_WITH_PARENT = 3,
	Constraint_target_space_LOCAL = 1,
};

int Constraint_target_space_get(PointerRNA *ptr);
void Constraint_target_space_set(PointerRNA *ptr, int value);

enum {
	Constraint_type_CAMERA_SOLVER = 27,
	Constraint_type_FOLLOW_TRACK = 26,
	Constraint_type_OBJECT_SOLVER = 28,
	Constraint_type_COPY_LOCATION = 9,
	Constraint_type_COPY_ROTATION = 8,
	Constraint_type_COPY_SCALE = 10,
	Constraint_type_COPY_TRANSFORMS = 23,
	Constraint_type_LIMIT_DISTANCE = 14,
	Constraint_type_LIMIT_LOCATION = 6,
	Constraint_type_LIMIT_ROTATION = 5,
	Constraint_type_LIMIT_SCALE = 7,
	Constraint_type_MAINTAIN_VOLUME = 24,
	Constraint_type_TRANSFORM = 19,
	Constraint_type_CLAMP_TO = 18,
	Constraint_type_DAMPED_TRACK = 21,
	Constraint_type_IK = 3,
	Constraint_type_LOCKED_TRACK = 13,
	Constraint_type_SPLINE_IK = 22,
	Constraint_type_STRETCH_TO = 15,
	Constraint_type_TRACK_TO = 2,
	Constraint_type_ACTION = 12,
	Constraint_type_CHILD_OF = 1,
	Constraint_type_FLOOR = 16,
	Constraint_type_FOLLOW_PATH = 4,
	Constraint_type_PIVOT = 25,
	Constraint_type_RIGID_BODY_JOINT = 17,
	Constraint_type_SHRINKWRAP = 20,
};

int Constraint_type_get(PointerRNA *ptr);
void Constraint_type_set(PointerRNA *ptr, int value);

int Constraint_is_valid_get(PointerRNA *ptr);
void Constraint_is_valid_set(PointerRNA *ptr, int value);

/**************** Constraint Actuator ****************/

extern StructRNA RNA_ConstraintActuator;
extern StructRNA RNA_Actuator;

enum {
	ConstraintActuator_mode_LOC = 0,
	ConstraintActuator_mode_DIST = 1,
	ConstraintActuator_mode_ORI = 2,
	ConstraintActuator_mode_FH = 3,
};

int ConstraintActuator_mode_get(PointerRNA *ptr);
void ConstraintActuator_mode_set(PointerRNA *ptr, int value);

int ConstraintActuator_damping_get(PointerRNA *ptr);
void ConstraintActuator_damping_set(PointerRNA *ptr, int value);

float ConstraintActuator_fh_damping_get(PointerRNA *ptr);
void ConstraintActuator_fh_damping_set(PointerRNA *ptr, float value);

enum {
	ConstraintActuator_direction_NONE = 0,
	ConstraintActuator_direction_DIRPX = 1,
	ConstraintActuator_direction_DIRPY = 2,
	ConstraintActuator_direction_DIRPZ = 4,
	ConstraintActuator_direction_DIRNX = 8,
	ConstraintActuator_direction_DIRNY = 16,
	ConstraintActuator_direction_DIRNZ = 32,
};

int ConstraintActuator_direction_get(PointerRNA *ptr);
void ConstraintActuator_direction_set(PointerRNA *ptr, int value);

enum {
	ConstraintActuator_direction_axis_NONE = 0,
	ConstraintActuator_direction_axis_DIRPX = 1,
	ConstraintActuator_direction_axis_DIRPY = 2,
	ConstraintActuator_direction_axis_DIRPZ = 4,
	ConstraintActuator_direction_axis_DIRNX = 8,
	ConstraintActuator_direction_axis_DIRNY = 16,
	ConstraintActuator_direction_axis_DIRNZ = 32,
};

int ConstraintActuator_direction_axis_get(PointerRNA *ptr);
void ConstraintActuator_direction_axis_set(PointerRNA *ptr, int value);

enum {
	ConstraintActuator_direction_axis_pos_NONE = 0,
	ConstraintActuator_direction_axis_pos_DIRPX = 1,
	ConstraintActuator_direction_axis_pos_DIRPY = 2,
	ConstraintActuator_direction_axis_pos_DIRPZ = 4,
};

int ConstraintActuator_direction_axis_pos_get(PointerRNA *ptr);
void ConstraintActuator_direction_axis_pos_set(PointerRNA *ptr, int value);

float ConstraintActuator_distance_get(PointerRNA *ptr);
void ConstraintActuator_distance_set(PointerRNA *ptr, float value);

float ConstraintActuator_fh_height_get(PointerRNA *ptr);
void ConstraintActuator_fh_height_set(PointerRNA *ptr, float value);

float ConstraintActuator_fh_force_get(PointerRNA *ptr);
void ConstraintActuator_fh_force_set(PointerRNA *ptr, float value);

int ConstraintActuator_use_force_distance_get(PointerRNA *ptr);
void ConstraintActuator_use_force_distance_set(PointerRNA *ptr, int value);

int ConstraintActuator_use_local_get(PointerRNA *ptr);
void ConstraintActuator_use_local_set(PointerRNA *ptr, int value);

enum {
	ConstraintActuator_limit_NONE = 0,
	ConstraintActuator_limit_LOCX = 1,
	ConstraintActuator_limit_LOCY = 2,
	ConstraintActuator_limit_LOCZ = 4,
};

int ConstraintActuator_limit_get(PointerRNA *ptr);
void ConstraintActuator_limit_set(PointerRNA *ptr, int value);

int ConstraintActuator_use_material_detect_get(PointerRNA *ptr);
void ConstraintActuator_use_material_detect_set(PointerRNA *ptr, int value);

#define ConstraintActuator_material_MAX 64

void ConstraintActuator_material_get(PointerRNA *ptr, char *value);
int ConstraintActuator_material_length(PointerRNA *ptr);
void ConstraintActuator_material_set(PointerRNA *ptr, const char *value);

float ConstraintActuator_limit_max_get(PointerRNA *ptr);
void ConstraintActuator_limit_max_set(PointerRNA *ptr, float value);

float ConstraintActuator_angle_max_get(PointerRNA *ptr);
void ConstraintActuator_angle_max_set(PointerRNA *ptr, float value);

float ConstraintActuator_limit_min_get(PointerRNA *ptr);
void ConstraintActuator_limit_min_set(PointerRNA *ptr, float value);

float ConstraintActuator_angle_min_get(PointerRNA *ptr);
void ConstraintActuator_angle_min_set(PointerRNA *ptr, float value);

int ConstraintActuator_use_normal_get(PointerRNA *ptr);
void ConstraintActuator_use_normal_set(PointerRNA *ptr, int value);

int ConstraintActuator_use_fh_normal_get(PointerRNA *ptr);
void ConstraintActuator_use_fh_normal_set(PointerRNA *ptr, int value);

int ConstraintActuator_use_persistent_get(PointerRNA *ptr);
void ConstraintActuator_use_persistent_set(PointerRNA *ptr, int value);

#define ConstraintActuator_property_MAX 64

void ConstraintActuator_property_get(PointerRNA *ptr, char *value);
int ConstraintActuator_property_length(PointerRNA *ptr);
void ConstraintActuator_property_set(PointerRNA *ptr, const char *value);

float ConstraintActuator_range_get(PointerRNA *ptr);
void ConstraintActuator_range_set(PointerRNA *ptr, float value);

void ConstraintActuator_rotation_max_get(PointerRNA *ptr, float values[3]);
void ConstraintActuator_rotation_max_set(PointerRNA *ptr, const float values[3]);

int ConstraintActuator_use_fh_paralel_axis_get(PointerRNA *ptr);
void ConstraintActuator_use_fh_paralel_axis_set(PointerRNA *ptr, int value);

int ConstraintActuator_damping_rotation_get(PointerRNA *ptr);
void ConstraintActuator_damping_rotation_set(PointerRNA *ptr, int value);

int ConstraintActuator_time_get(PointerRNA *ptr);
void ConstraintActuator_time_set(PointerRNA *ptr, int value);

/**************** Constraint Target ****************/

extern StructRNA RNA_ConstraintTarget;

PointerRNA ConstraintTarget_rna_type_get(PointerRNA *ptr);

#define ConstraintTarget_subtarget_MAX 64

void ConstraintTarget_subtarget_get(PointerRNA *ptr, char *value);
int ConstraintTarget_subtarget_length(PointerRNA *ptr);
void ConstraintTarget_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA ConstraintTarget_target_get(PointerRNA *ptr);

/**************** Context ****************/

extern StructRNA RNA_Context;

PointerRNA Context_rna_type_get(PointerRNA *ptr);

PointerRNA Context_area_get(PointerRNA *ptr);

PointerRNA Context_blend_data_get(PointerRNA *ptr);

enum {
	Context_mode_EDIT_MESH = 0,
	Context_mode_EDIT_CURVE = 1,
	Context_mode_EDIT_SURFACE = 2,
	Context_mode_EDIT_TEXT = 3,
	Context_mode_EDIT_ARMATURE = 4,
	Context_mode_EDIT_METABALL = 5,
	Context_mode_EDIT_LATTICE = 6,
	Context_mode_POSE = 7,
	Context_mode_SCULPT = 8,
	Context_mode_PAINT_WEIGHT = 9,
	Context_mode_PAINT_VERTEX = 10,
	Context_mode_PAINT_TEXTURE = 11,
	Context_mode_PARTICLE = 12,
	Context_mode_OBJECT = 13,
};

int Context_mode_get(PointerRNA *ptr);
void Context_mode_set(PointerRNA *ptr, int value);

PointerRNA Context_region_get(PointerRNA *ptr);

PointerRNA Context_region_data_get(PointerRNA *ptr);

PointerRNA Context_scene_get(PointerRNA *ptr);

PointerRNA Context_screen_get(PointerRNA *ptr);

PointerRNA Context_space_data_get(PointerRNA *ptr);

PointerRNA Context_tool_settings_get(PointerRNA *ptr);

PointerRNA Context_user_preferences_get(PointerRNA *ptr);

PointerRNA Context_window_get(PointerRNA *ptr);

PointerRNA Context_window_manager_get(PointerRNA *ptr);

/**************** Control Fluid Simulation Settings ****************/

extern StructRNA RNA_ControlFluidSettings;
extern StructRNA RNA_FluidSettings;

float ControlFluidSettings_attraction_radius_get(PointerRNA *ptr);
void ControlFluidSettings_attraction_radius_set(PointerRNA *ptr, float value);

float ControlFluidSettings_attraction_strength_get(PointerRNA *ptr);
void ControlFluidSettings_attraction_strength_set(PointerRNA *ptr, float value);

int ControlFluidSettings_use_get(PointerRNA *ptr);
void ControlFluidSettings_use_set(PointerRNA *ptr, int value);

float ControlFluidSettings_end_time_get(PointerRNA *ptr);
void ControlFluidSettings_end_time_set(PointerRNA *ptr, float value);

float ControlFluidSettings_quality_get(PointerRNA *ptr);
void ControlFluidSettings_quality_set(PointerRNA *ptr, float value);

int ControlFluidSettings_use_reverse_frames_get(PointerRNA *ptr);
void ControlFluidSettings_use_reverse_frames_set(PointerRNA *ptr, int value);

float ControlFluidSettings_start_time_get(PointerRNA *ptr);
void ControlFluidSettings_start_time_set(PointerRNA *ptr, float value);

float ControlFluidSettings_velocity_radius_get(PointerRNA *ptr);
void ControlFluidSettings_velocity_radius_set(PointerRNA *ptr, float value);

float ControlFluidSettings_velocity_strength_get(PointerRNA *ptr);
void ControlFluidSettings_velocity_strength_set(PointerRNA *ptr, float value);

/**************** Controller ****************/

extern StructRNA RNA_Controller;

PointerRNA Controller_rna_type_get(PointerRNA *ptr);

#define Controller_name_MAX 64

void Controller_name_get(PointerRNA *ptr, char *value);
int Controller_name_length(PointerRNA *ptr);
void Controller_name_set(PointerRNA *ptr, const char *value);

int Controller_states_get(PointerRNA *ptr);
void Controller_states_set(PointerRNA *ptr, int value);

int Controller_active_get(PointerRNA *ptr);
void Controller_active_set(PointerRNA *ptr, int value);

void Controller_actuators_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Controller_actuators_next(CollectionPropertyIterator *iter);
void Controller_actuators_end(CollectionPropertyIterator *iter);
int Controller_actuators_length(PointerRNA *ptr);
int Controller_actuators_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Controller_actuators_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Controller_show_expanded_get(PointerRNA *ptr);
void Controller_show_expanded_set(PointerRNA *ptr, int value);

int Controller_use_priority_get(PointerRNA *ptr);
void Controller_use_priority_set(PointerRNA *ptr, int value);

enum {
	Controller_type_LOGIC_AND = 0,
	Controller_type_LOGIC_OR = 1,
	Controller_type_LOGIC_NAND = 4,
	Controller_type_LOGIC_NOR = 5,
	Controller_type_LOGIC_XOR = 6,
	Controller_type_LOGIC_XNOR = 7,
	Controller_type_EXPRESSION = 2,
	Controller_type_PYTHON = 3,
};

int Controller_type_get(PointerRNA *ptr);
void Controller_type_set(PointerRNA *ptr, int value);

void Controller_link(struct bController *_self, struct bSensor *sensor, struct bActuator *actuator);
void Controller_unlink(struct bController *_self, struct bSensor *sensor, struct bActuator *actuator);
/**************** Copy Location Constraint ****************/

extern StructRNA RNA_CopyLocationConstraint;
extern StructRNA RNA_Constraint;

int CopyLocationConstraint_use_x_get(PointerRNA *ptr);
void CopyLocationConstraint_use_x_set(PointerRNA *ptr, int value);

int CopyLocationConstraint_use_y_get(PointerRNA *ptr);
void CopyLocationConstraint_use_y_set(PointerRNA *ptr, int value);

int CopyLocationConstraint_use_z_get(PointerRNA *ptr);
void CopyLocationConstraint_use_z_set(PointerRNA *ptr, int value);

float CopyLocationConstraint_head_tail_get(PointerRNA *ptr);
void CopyLocationConstraint_head_tail_set(PointerRNA *ptr, float value);

int CopyLocationConstraint_invert_x_get(PointerRNA *ptr);
void CopyLocationConstraint_invert_x_set(PointerRNA *ptr, int value);

int CopyLocationConstraint_invert_y_get(PointerRNA *ptr);
void CopyLocationConstraint_invert_y_set(PointerRNA *ptr, int value);

int CopyLocationConstraint_invert_z_get(PointerRNA *ptr);
void CopyLocationConstraint_invert_z_set(PointerRNA *ptr, int value);

int CopyLocationConstraint_use_offset_get(PointerRNA *ptr);
void CopyLocationConstraint_use_offset_set(PointerRNA *ptr, int value);

#define CopyLocationConstraint_subtarget_MAX 64

void CopyLocationConstraint_subtarget_get(PointerRNA *ptr, char *value);
int CopyLocationConstraint_subtarget_length(PointerRNA *ptr);
void CopyLocationConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA CopyLocationConstraint_target_get(PointerRNA *ptr);

/**************** Copy Rotation Constraint ****************/

extern StructRNA RNA_CopyRotationConstraint;
extern StructRNA RNA_Constraint;

int CopyRotationConstraint_use_x_get(PointerRNA *ptr);
void CopyRotationConstraint_use_x_set(PointerRNA *ptr, int value);

int CopyRotationConstraint_use_y_get(PointerRNA *ptr);
void CopyRotationConstraint_use_y_set(PointerRNA *ptr, int value);

int CopyRotationConstraint_use_z_get(PointerRNA *ptr);
void CopyRotationConstraint_use_z_set(PointerRNA *ptr, int value);

int CopyRotationConstraint_invert_x_get(PointerRNA *ptr);
void CopyRotationConstraint_invert_x_set(PointerRNA *ptr, int value);

int CopyRotationConstraint_invert_y_get(PointerRNA *ptr);
void CopyRotationConstraint_invert_y_set(PointerRNA *ptr, int value);

int CopyRotationConstraint_invert_z_get(PointerRNA *ptr);
void CopyRotationConstraint_invert_z_set(PointerRNA *ptr, int value);

int CopyRotationConstraint_use_offset_get(PointerRNA *ptr);
void CopyRotationConstraint_use_offset_set(PointerRNA *ptr, int value);

#define CopyRotationConstraint_subtarget_MAX 64

void CopyRotationConstraint_subtarget_get(PointerRNA *ptr, char *value);
int CopyRotationConstraint_subtarget_length(PointerRNA *ptr);
void CopyRotationConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA CopyRotationConstraint_target_get(PointerRNA *ptr);

/**************** Copy Scale Constraint ****************/

extern StructRNA RNA_CopyScaleConstraint;
extern StructRNA RNA_Constraint;

int CopyScaleConstraint_use_x_get(PointerRNA *ptr);
void CopyScaleConstraint_use_x_set(PointerRNA *ptr, int value);

int CopyScaleConstraint_use_y_get(PointerRNA *ptr);
void CopyScaleConstraint_use_y_set(PointerRNA *ptr, int value);

int CopyScaleConstraint_use_z_get(PointerRNA *ptr);
void CopyScaleConstraint_use_z_set(PointerRNA *ptr, int value);

int CopyScaleConstraint_use_offset_get(PointerRNA *ptr);
void CopyScaleConstraint_use_offset_set(PointerRNA *ptr, int value);

#define CopyScaleConstraint_subtarget_MAX 64

void CopyScaleConstraint_subtarget_get(PointerRNA *ptr, char *value);
int CopyScaleConstraint_subtarget_length(PointerRNA *ptr);
void CopyScaleConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA CopyScaleConstraint_target_get(PointerRNA *ptr);

/**************** Copy Transforms Constraint ****************/

extern StructRNA RNA_CopyTransformsConstraint;
extern StructRNA RNA_Constraint;

float CopyTransformsConstraint_head_tail_get(PointerRNA *ptr);
void CopyTransformsConstraint_head_tail_set(PointerRNA *ptr, float value);

#define CopyTransformsConstraint_subtarget_MAX 64

void CopyTransformsConstraint_subtarget_get(PointerRNA *ptr, char *value);
int CopyTransformsConstraint_subtarget_length(PointerRNA *ptr);
void CopyTransformsConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA CopyTransformsConstraint_target_get(PointerRNA *ptr);

/**************** Cross Sequence ****************/

extern StructRNA RNA_CrossSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

PointerRNA CrossSequence_input_1_get(PointerRNA *ptr);

PointerRNA CrossSequence_input_2_get(PointerRNA *ptr);

int CrossSequence_input_count_get(PointerRNA *ptr);
void CrossSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Curve ****************/

extern StructRNA RNA_Curve;
extern StructRNA RNA_ID;

PointerRNA Curve_animation_data_get(PointerRNA *ptr);

int Curve_use_auto_texspace_get(PointerRNA *ptr);
void Curve_use_auto_texspace_set(PointerRNA *ptr, int value);

float Curve_bevel_depth_get(PointerRNA *ptr);
void Curve_bevel_depth_set(PointerRNA *ptr, float value);

PointerRNA Curve_bevel_object_get(PointerRNA *ptr);

int Curve_bevel_resolution_get(PointerRNA *ptr);
void Curve_bevel_resolution_set(PointerRNA *ptr, int value);

int Curve_use_deform_bounds_get(PointerRNA *ptr);
void Curve_use_deform_bounds_set(PointerRNA *ptr, int value);

enum {
	Curve_dimensions_2D = 0,
	Curve_dimensions_3D = 1,
};

int Curve_dimensions_get(PointerRNA *ptr);
void Curve_dimensions_set(PointerRNA *ptr, int value);

int Curve_show_handles_get(PointerRNA *ptr);
void Curve_show_handles_set(PointerRNA *ptr, int value);

int Curve_show_normal_face_get(PointerRNA *ptr);
void Curve_show_normal_face_set(PointerRNA *ptr, int value);

float Curve_bevel_factor_end_get(PointerRNA *ptr);
void Curve_bevel_factor_end_set(PointerRNA *ptr, float value);

enum {
	Curve_bevel_factor_mapping_end_RESOLUTION = 0,
	Curve_bevel_factor_mapping_end_SEGMENTS = 1,
	Curve_bevel_factor_mapping_end_SPLINE = 2,
};

int Curve_bevel_factor_mapping_end_get(PointerRNA *ptr);
void Curve_bevel_factor_mapping_end_set(PointerRNA *ptr, int value);

float Curve_eval_time_get(PointerRNA *ptr);
void Curve_eval_time_set(PointerRNA *ptr, float value);

float Curve_extrude_get(PointerRNA *ptr);
void Curve_extrude_set(PointerRNA *ptr, float value);

int Curve_use_fill_caps_get(PointerRNA *ptr);
void Curve_use_fill_caps_set(PointerRNA *ptr, int value);

int Curve_use_fill_deform_get(PointerRNA *ptr);
void Curve_use_fill_deform_set(PointerRNA *ptr, int value);

enum {
	Curve_fill_mode_FULL = 0,
	Curve_fill_mode_BACK = 4,
	Curve_fill_mode_FRONT = 2,
	Curve_fill_mode_HALF = 6,
};

int Curve_fill_mode_get(PointerRNA *ptr);
void Curve_fill_mode_set(PointerRNA *ptr, int value);

int Curve_use_path_follow_get(PointerRNA *ptr);
void Curve_use_path_follow_set(PointerRNA *ptr, int value);

int Curve_is_editmode_get(PointerRNA *ptr);
void Curve_is_editmode_set(PointerRNA *ptr, int value);

int Curve_use_map_taper_get(PointerRNA *ptr);
void Curve_use_map_taper_set(PointerRNA *ptr, int value);

void Curve_materials_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curve_materials_next(CollectionPropertyIterator *iter);
void Curve_materials_end(CollectionPropertyIterator *iter);
int Curve_materials_length(PointerRNA *ptr);
int Curve_materials_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Curve_materials_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float Curve_offset_get(PointerRNA *ptr);
void Curve_offset_set(PointerRNA *ptr, float value);

int Curve_use_path_get(PointerRNA *ptr);
void Curve_use_path_set(PointerRNA *ptr, int value);

int Curve_path_duration_get(PointerRNA *ptr);
void Curve_path_duration_set(PointerRNA *ptr, int value);

int Curve_use_radius_get(PointerRNA *ptr);
void Curve_use_radius_set(PointerRNA *ptr, int value);

int Curve_render_resolution_u_get(PointerRNA *ptr);
void Curve_render_resolution_u_set(PointerRNA *ptr, int value);

int Curve_render_resolution_v_get(PointerRNA *ptr);
void Curve_render_resolution_v_set(PointerRNA *ptr, int value);

int Curve_resolution_u_get(PointerRNA *ptr);
void Curve_resolution_u_set(PointerRNA *ptr, int value);

int Curve_resolution_v_get(PointerRNA *ptr);
void Curve_resolution_v_set(PointerRNA *ptr, int value);

PointerRNA Curve_shape_keys_get(PointerRNA *ptr);

void Curve_splines_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curve_splines_next(CollectionPropertyIterator *iter);
void Curve_splines_end(CollectionPropertyIterator *iter);

float Curve_bevel_factor_start_get(PointerRNA *ptr);
void Curve_bevel_factor_start_set(PointerRNA *ptr, float value);

enum {
	Curve_bevel_factor_mapping_start_RESOLUTION = 0,
	Curve_bevel_factor_mapping_start_SEGMENTS = 1,
	Curve_bevel_factor_mapping_start_SPLINE = 2,
};

int Curve_bevel_factor_mapping_start_get(PointerRNA *ptr);
void Curve_bevel_factor_mapping_start_set(PointerRNA *ptr, int value);

int Curve_use_stretch_get(PointerRNA *ptr);
void Curve_use_stretch_set(PointerRNA *ptr, int value);

PointerRNA Curve_taper_object_get(PointerRNA *ptr);

void Curve_texspace_location_get(PointerRNA *ptr, float values[3]);
void Curve_texspace_location_set(PointerRNA *ptr, const float values[3]);

void Curve_texspace_size_get(PointerRNA *ptr, float values[3]);
void Curve_texspace_size_set(PointerRNA *ptr, const float values[3]);

enum {
	Curve_twist_mode_Z_UP = 0,
	Curve_twist_mode_MINIMUM = 3,
	Curve_twist_mode_TANGENT = 4,
};

int Curve_twist_mode_get(PointerRNA *ptr);
void Curve_twist_mode_set(PointerRNA *ptr, int value);

float Curve_twist_smooth_get(PointerRNA *ptr);
void Curve_twist_smooth_set(PointerRNA *ptr, float value);

int Curve_use_uv_as_generated_get(PointerRNA *ptr);
void Curve_use_uv_as_generated_set(PointerRNA *ptr, int value);

void Curve_transform(struct Curve *_self, float matrix[16], int shape_keys);
int Curve_validate_material_indices(struct Curve *_self);
/**************** CurveMap ****************/

extern StructRNA RNA_CurveMap;

PointerRNA CurveMap_rna_type_get(PointerRNA *ptr);

enum {
	CurveMap_extend_HORIZONTAL = 0,
	CurveMap_extend_EXTRAPOLATED = 1,
};

int CurveMap_extend_get(PointerRNA *ptr);
void CurveMap_extend_set(PointerRNA *ptr, int value);

void CurveMap_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CurveMap_points_next(CollectionPropertyIterator *iter);
void CurveMap_points_end(CollectionPropertyIterator *iter);
int CurveMap_points_length(PointerRNA *ptr);
int CurveMap_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

float CurveMap_evaluate(struct CurveMap *_self, ReportList *reports, float position);
/**************** CurveMapPoint ****************/

extern StructRNA RNA_CurveMapPoint;

PointerRNA CurveMapPoint_rna_type_get(PointerRNA *ptr);

enum {
	CurveMapPoint_handle_type_AUTO = 0,
	CurveMapPoint_handle_type_VECTOR = 2,
};

int CurveMapPoint_handle_type_get(PointerRNA *ptr);
void CurveMapPoint_handle_type_set(PointerRNA *ptr, int value);

void CurveMapPoint_location_get(PointerRNA *ptr, float values[2]);
void CurveMapPoint_location_set(PointerRNA *ptr, const float values[2]);

int CurveMapPoint_select_get(PointerRNA *ptr);
void CurveMapPoint_select_set(PointerRNA *ptr, int value);

/**************** Curve Map Point ****************/

extern StructRNA RNA_CurveMapPoints;

PointerRNA CurveMapPoints_rna_type_get(PointerRNA *ptr);

struct CurveMapPoint *CurveMapPoints_new(struct CurveMap *_self, float position, float value);
void CurveMapPoints_remove(struct CurveMap *_self, ReportList *reports, struct PointerRNA *point);
/**************** CurveMapping ****************/

extern StructRNA RNA_CurveMapping;

PointerRNA CurveMapping_rna_type_get(PointerRNA *ptr);

void CurveMapping_black_level_get(PointerRNA *ptr, float values[3]);
void CurveMapping_black_level_set(PointerRNA *ptr, const float values[3]);

int CurveMapping_use_clip_get(PointerRNA *ptr);
void CurveMapping_use_clip_set(PointerRNA *ptr, int value);

float CurveMapping_clip_max_x_get(PointerRNA *ptr);
void CurveMapping_clip_max_x_set(PointerRNA *ptr, float value);

float CurveMapping_clip_max_y_get(PointerRNA *ptr);
void CurveMapping_clip_max_y_set(PointerRNA *ptr, float value);

float CurveMapping_clip_min_x_get(PointerRNA *ptr);
void CurveMapping_clip_min_x_set(PointerRNA *ptr, float value);

float CurveMapping_clip_min_y_get(PointerRNA *ptr);
void CurveMapping_clip_min_y_set(PointerRNA *ptr, float value);

void CurveMapping_curves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CurveMapping_curves_next(CollectionPropertyIterator *iter);
void CurveMapping_curves_end(CollectionPropertyIterator *iter);
int CurveMapping_curves_length(PointerRNA *ptr);

void CurveMapping_white_level_get(PointerRNA *ptr, float values[3]);
void CurveMapping_white_level_set(PointerRNA *ptr, const float values[3]);

void CurveMapping_update(struct CurveMapping *_self);
void CurveMapping_initialize(struct CurveMapping *_self);
/**************** Curve Modifier ****************/

extern StructRNA RNA_CurveModifier;
extern StructRNA RNA_Modifier;

enum {
	CurveModifier_deform_axis_POS_X = 1,
	CurveModifier_deform_axis_POS_Y = 2,
	CurveModifier_deform_axis_POS_Z = 3,
	CurveModifier_deform_axis_NEG_X = 4,
	CurveModifier_deform_axis_NEG_Y = 5,
	CurveModifier_deform_axis_NEG_Z = 6,
};

int CurveModifier_deform_axis_get(PointerRNA *ptr);
void CurveModifier_deform_axis_set(PointerRNA *ptr, int value);

PointerRNA CurveModifier_object_get(PointerRNA *ptr);

#define CurveModifier_vertex_group_MAX 64

void CurveModifier_vertex_group_get(PointerRNA *ptr, char *value);
int CurveModifier_vertex_group_length(PointerRNA *ptr);
void CurveModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Curve Splines ****************/

extern StructRNA RNA_CurveSplines;

PointerRNA CurveSplines_rna_type_get(PointerRNA *ptr);

PointerRNA CurveSplines_active_get(PointerRNA *ptr);

struct Nurb *CurveSplines_new(struct Curve *_self, int type);
void CurveSplines_remove(struct Curve *_self, ReportList *reports, struct PointerRNA *spline);
void CurveSplines_clear(struct Curve *_self);
/**************** CurvesModifier ****************/

extern StructRNA RNA_CurvesModifier;
extern StructRNA RNA_SequenceModifier;

PointerRNA CurvesModifier_curve_mapping_get(PointerRNA *ptr);

/**************** Damped Track Constraint ****************/

extern StructRNA RNA_DampedTrackConstraint;
extern StructRNA RNA_Constraint;

float DampedTrackConstraint_head_tail_get(PointerRNA *ptr);
void DampedTrackConstraint_head_tail_set(PointerRNA *ptr, float value);

#define DampedTrackConstraint_subtarget_MAX 64

void DampedTrackConstraint_subtarget_get(PointerRNA *ptr, char *value);
int DampedTrackConstraint_subtarget_length(PointerRNA *ptr);
void DampedTrackConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA DampedTrackConstraint_target_get(PointerRNA *ptr);

enum {
	DampedTrackConstraint_track_axis_TRACK_X = 0,
	DampedTrackConstraint_track_axis_TRACK_Y = 1,
	DampedTrackConstraint_track_axis_TRACK_Z = 2,
	DampedTrackConstraint_track_axis_TRACK_NEGATIVE_X = 3,
	DampedTrackConstraint_track_axis_TRACK_NEGATIVE_Y = 4,
	DampedTrackConstraint_track_axis_TRACK_NEGATIVE_Z = 5,
};

int DampedTrackConstraint_track_axis_get(PointerRNA *ptr);
void DampedTrackConstraint_track_axis_set(PointerRNA *ptr, int value);

/**************** Decimate Modifier ****************/

extern StructRNA RNA_DecimateModifier;
extern StructRNA RNA_Modifier;

int DecimateModifier_use_dissolve_boundaries_get(PointerRNA *ptr);
void DecimateModifier_use_dissolve_boundaries_set(PointerRNA *ptr, int value);

float DecimateModifier_angle_limit_get(PointerRNA *ptr);
void DecimateModifier_angle_limit_set(PointerRNA *ptr, float value);

enum {
	DecimateModifier_delimit_NORMAL = 1,
	DecimateModifier_delimit_MATERIAL = 2,
	DecimateModifier_delimit_SEAM = 4,
};

int DecimateModifier_delimit_get(PointerRNA *ptr);
void DecimateModifier_delimit_set(PointerRNA *ptr, int value);

int DecimateModifier_face_count_get(PointerRNA *ptr);
void DecimateModifier_face_count_set(PointerRNA *ptr, int value);

int DecimateModifier_invert_vertex_group_get(PointerRNA *ptr);
void DecimateModifier_invert_vertex_group_set(PointerRNA *ptr, int value);

int DecimateModifier_iterations_get(PointerRNA *ptr);
void DecimateModifier_iterations_set(PointerRNA *ptr, int value);

enum {
	DecimateModifier_decimate_type_COLLAPSE = 0,
	DecimateModifier_decimate_type_UNSUBDIV = 1,
	DecimateModifier_decimate_type_DISSOLVE = 2,
};

int DecimateModifier_decimate_type_get(PointerRNA *ptr);
void DecimateModifier_decimate_type_set(PointerRNA *ptr, int value);

float DecimateModifier_ratio_get(PointerRNA *ptr);
void DecimateModifier_ratio_set(PointerRNA *ptr, float value);

int DecimateModifier_use_collapse_triangulate_get(PointerRNA *ptr);
void DecimateModifier_use_collapse_triangulate_set(PointerRNA *ptr, int value);

#define DecimateModifier_vertex_group_MAX 64

void DecimateModifier_vertex_group_get(PointerRNA *ptr, char *value);
int DecimateModifier_vertex_group_length(PointerRNA *ptr);
void DecimateModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Delay Sensor ****************/

extern StructRNA RNA_DelaySensor;
extern StructRNA RNA_Sensor;

int DelaySensor_delay_get(PointerRNA *ptr);
void DelaySensor_delay_set(PointerRNA *ptr, int value);

int DelaySensor_duration_get(PointerRNA *ptr);
void DelaySensor_duration_set(PointerRNA *ptr, int value);

int DelaySensor_use_repeat_get(PointerRNA *ptr);
void DelaySensor_use_repeat_set(PointerRNA *ptr, int value);

/**************** Displace Modifier ****************/

extern StructRNA RNA_DisplaceModifier;
extern StructRNA RNA_Modifier;

enum {
	DisplaceModifier_direction_X = 0,
	DisplaceModifier_direction_Y = 1,
	DisplaceModifier_direction_Z = 2,
	DisplaceModifier_direction_NORMAL = 3,
	DisplaceModifier_direction_RGB_TO_XYZ = 4,
};

int DisplaceModifier_direction_get(PointerRNA *ptr);
void DisplaceModifier_direction_set(PointerRNA *ptr, int value);

float DisplaceModifier_mid_level_get(PointerRNA *ptr);
void DisplaceModifier_mid_level_set(PointerRNA *ptr, float value);

float DisplaceModifier_strength_get(PointerRNA *ptr);
void DisplaceModifier_strength_set(PointerRNA *ptr, float value);

PointerRNA DisplaceModifier_texture_get(PointerRNA *ptr);

PointerRNA DisplaceModifier_texture_coords_object_get(PointerRNA *ptr);

enum {
	DisplaceModifier_texture_coords_LOCAL = 0,
	DisplaceModifier_texture_coords_GLOBAL = 1,
	DisplaceModifier_texture_coords_OBJECT = 2,
	DisplaceModifier_texture_coords_UV = 3,
};

int DisplaceModifier_texture_coords_get(PointerRNA *ptr);
void DisplaceModifier_texture_coords_set(PointerRNA *ptr, int value);

#define DisplaceModifier_uv_layer_MAX 64

void DisplaceModifier_uv_layer_get(PointerRNA *ptr, char *value);
int DisplaceModifier_uv_layer_length(PointerRNA *ptr);
void DisplaceModifier_uv_layer_set(PointerRNA *ptr, const char *value);

#define DisplaceModifier_vertex_group_MAX 64

void DisplaceModifier_vertex_group_get(PointerRNA *ptr, char *value);
int DisplaceModifier_vertex_group_length(PointerRNA *ptr);
void DisplaceModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Distorted Noise ****************/

extern StructRNA RNA_DistortedNoiseTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

float DistortedNoiseTexture_distortion_get(PointerRNA *ptr);
void DistortedNoiseTexture_distortion_set(PointerRNA *ptr, float value);

float DistortedNoiseTexture_nabla_get(PointerRNA *ptr);
void DistortedNoiseTexture_nabla_set(PointerRNA *ptr, float value);

enum {
	DistortedNoiseTexture_noise_basis_BLENDER_ORIGINAL = 0,
	DistortedNoiseTexture_noise_basis_ORIGINAL_PERLIN = 1,
	DistortedNoiseTexture_noise_basis_IMPROVED_PERLIN = 2,
	DistortedNoiseTexture_noise_basis_VORONOI_F1 = 3,
	DistortedNoiseTexture_noise_basis_VORONOI_F2 = 4,
	DistortedNoiseTexture_noise_basis_VORONOI_F3 = 5,
	DistortedNoiseTexture_noise_basis_VORONOI_F4 = 6,
	DistortedNoiseTexture_noise_basis_VORONOI_F2_F1 = 7,
	DistortedNoiseTexture_noise_basis_VORONOI_CRACKLE = 8,
	DistortedNoiseTexture_noise_basis_CELL_NOISE = 14,
};

int DistortedNoiseTexture_noise_basis_get(PointerRNA *ptr);
void DistortedNoiseTexture_noise_basis_set(PointerRNA *ptr, int value);

enum {
	DistortedNoiseTexture_noise_distortion_BLENDER_ORIGINAL = 0,
	DistortedNoiseTexture_noise_distortion_ORIGINAL_PERLIN = 1,
	DistortedNoiseTexture_noise_distortion_IMPROVED_PERLIN = 2,
	DistortedNoiseTexture_noise_distortion_VORONOI_F1 = 3,
	DistortedNoiseTexture_noise_distortion_VORONOI_F2 = 4,
	DistortedNoiseTexture_noise_distortion_VORONOI_F3 = 5,
	DistortedNoiseTexture_noise_distortion_VORONOI_F4 = 6,
	DistortedNoiseTexture_noise_distortion_VORONOI_F2_F1 = 7,
	DistortedNoiseTexture_noise_distortion_VORONOI_CRACKLE = 8,
	DistortedNoiseTexture_noise_distortion_CELL_NOISE = 14,
};

int DistortedNoiseTexture_noise_distortion_get(PointerRNA *ptr);
void DistortedNoiseTexture_noise_distortion_set(PointerRNA *ptr, int value);

float DistortedNoiseTexture_noise_scale_get(PointerRNA *ptr);
void DistortedNoiseTexture_noise_scale_set(PointerRNA *ptr, float value);

/**************** Domain Fluid Simulation Settings ****************/

extern StructRNA RNA_DomainFluidSettings;
extern StructRNA RNA_FluidSettings;

int DomainFluidSettings_frame_offset_get(PointerRNA *ptr);
void DomainFluidSettings_frame_offset_set(PointerRNA *ptr, int value);

float DomainFluidSettings_compressibility_get(PointerRNA *ptr);
void DomainFluidSettings_compressibility_set(PointerRNA *ptr, float value);

float DomainFluidSettings_end_time_get(PointerRNA *ptr);
void DomainFluidSettings_end_time_set(PointerRNA *ptr, float value);

void DomainFluidSettings_fluid_mesh_vertices_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void DomainFluidSettings_fluid_mesh_vertices_next(CollectionPropertyIterator *iter);
void DomainFluidSettings_fluid_mesh_vertices_end(CollectionPropertyIterator *iter);
int DomainFluidSettings_fluid_mesh_vertices_length(PointerRNA *ptr);

float DomainFluidSettings_generate_particles_get(PointerRNA *ptr);
void DomainFluidSettings_generate_particles_set(PointerRNA *ptr, float value);

int DomainFluidSettings_use_speed_vectors_get(PointerRNA *ptr);
void DomainFluidSettings_use_speed_vectors_set(PointerRNA *ptr, int value);

void DomainFluidSettings_gravity_get(PointerRNA *ptr, float values[3]);
void DomainFluidSettings_gravity_set(PointerRNA *ptr, const float values[3]);

int DomainFluidSettings_grid_levels_get(PointerRNA *ptr);
void DomainFluidSettings_grid_levels_set(PointerRNA *ptr, int value);

void DomainFluidSettings_memory_estimate_get(PointerRNA *ptr, char *value);
int DomainFluidSettings_memory_estimate_length(PointerRNA *ptr);
void DomainFluidSettings_memory_estimate_set(PointerRNA *ptr, const char *value);

int DomainFluidSettings_use_time_override_get(PointerRNA *ptr);
void DomainFluidSettings_use_time_override_set(PointerRNA *ptr, int value);

float DomainFluidSettings_partial_slip_factor_get(PointerRNA *ptr);
void DomainFluidSettings_partial_slip_factor_set(PointerRNA *ptr, float value);

#define DomainFluidSettings_filepath_MAX 1024

void DomainFluidSettings_filepath_get(PointerRNA *ptr, char *value);
int DomainFluidSettings_filepath_length(PointerRNA *ptr);
void DomainFluidSettings_filepath_set(PointerRNA *ptr, const char *value);

int DomainFluidSettings_preview_resolution_get(PointerRNA *ptr);
void DomainFluidSettings_preview_resolution_set(PointerRNA *ptr, int value);

float DomainFluidSettings_simulation_scale_get(PointerRNA *ptr);
void DomainFluidSettings_simulation_scale_set(PointerRNA *ptr, float value);

int DomainFluidSettings_use_surface_noobs_get(PointerRNA *ptr);
void DomainFluidSettings_use_surface_noobs_set(PointerRNA *ptr, int value);

enum {
	DomainFluidSettings_render_display_mode_GEOMETRY = 1,
	DomainFluidSettings_render_display_mode_PREVIEW = 2,
	DomainFluidSettings_render_display_mode_FINAL = 3,
};

int DomainFluidSettings_render_display_mode_get(PointerRNA *ptr);
void DomainFluidSettings_render_display_mode_set(PointerRNA *ptr, int value);

int DomainFluidSettings_resolution_get(PointerRNA *ptr);
void DomainFluidSettings_resolution_set(PointerRNA *ptr, int value);

int DomainFluidSettings_use_reverse_frames_get(PointerRNA *ptr);
void DomainFluidSettings_use_reverse_frames_set(PointerRNA *ptr, int value);

float DomainFluidSettings_simulation_rate_get(PointerRNA *ptr);
void DomainFluidSettings_simulation_rate_set(PointerRNA *ptr, float value);

int DomainFluidSettings_threads_get(PointerRNA *ptr);
void DomainFluidSettings_threads_set(PointerRNA *ptr, int value);

enum {
	DomainFluidSettings_slip_type_NOSLIP = 512,
	DomainFluidSettings_slip_type_PARTIALSLIP = 1024,
	DomainFluidSettings_slip_type_FREESLIP = 2048,
};

int DomainFluidSettings_slip_type_get(PointerRNA *ptr);
void DomainFluidSettings_slip_type_set(PointerRNA *ptr, int value);

float DomainFluidSettings_start_time_get(PointerRNA *ptr);
void DomainFluidSettings_start_time_set(PointerRNA *ptr, float value);

float DomainFluidSettings_surface_smooth_get(PointerRNA *ptr);
void DomainFluidSettings_surface_smooth_set(PointerRNA *ptr, float value);

int DomainFluidSettings_surface_subdivisions_get(PointerRNA *ptr);
void DomainFluidSettings_surface_subdivisions_set(PointerRNA *ptr, int value);

int DomainFluidSettings_tracer_particles_get(PointerRNA *ptr);
void DomainFluidSettings_tracer_particles_set(PointerRNA *ptr, int value);

enum {
	DomainFluidSettings_viewport_display_mode_GEOMETRY = 1,
	DomainFluidSettings_viewport_display_mode_PREVIEW = 2,
	DomainFluidSettings_viewport_display_mode_FINAL = 3,
};

int DomainFluidSettings_viewport_display_mode_get(PointerRNA *ptr);
void DomainFluidSettings_viewport_display_mode_set(PointerRNA *ptr, int value);

float DomainFluidSettings_viscosity_base_get(PointerRNA *ptr);
void DomainFluidSettings_viscosity_base_set(PointerRNA *ptr, float value);

int DomainFluidSettings_viscosity_exponent_get(PointerRNA *ptr);
void DomainFluidSettings_viscosity_exponent_set(PointerRNA *ptr, int value);

/**************** Dope Sheet ****************/

extern StructRNA RNA_DopeSheet;

PointerRNA DopeSheet_rna_type_get(PointerRNA *ptr);

int DopeSheet_show_expanded_summary_get(PointerRNA *ptr);
void DopeSheet_show_expanded_summary_set(PointerRNA *ptr, int value);

int DopeSheet_show_armatures_get(PointerRNA *ptr);
void DopeSheet_show_armatures_set(PointerRNA *ptr, int value);

int DopeSheet_show_cameras_get(PointerRNA *ptr);
void DopeSheet_show_cameras_set(PointerRNA *ptr, int value);

int DopeSheet_show_curves_get(PointerRNA *ptr);
void DopeSheet_show_curves_set(PointerRNA *ptr, int value);

int DopeSheet_show_hidden_get(PointerRNA *ptr);
void DopeSheet_show_hidden_set(PointerRNA *ptr, int value);

int DopeSheet_show_lamps_get(PointerRNA *ptr);
void DopeSheet_show_lamps_set(PointerRNA *ptr, int value);

int DopeSheet_show_lattices_get(PointerRNA *ptr);
void DopeSheet_show_lattices_set(PointerRNA *ptr, int value);

int DopeSheet_show_linestyles_get(PointerRNA *ptr);
void DopeSheet_show_linestyles_set(PointerRNA *ptr, int value);

int DopeSheet_show_materials_get(PointerRNA *ptr);
void DopeSheet_show_materials_set(PointerRNA *ptr, int value);

int DopeSheet_show_meshes_get(PointerRNA *ptr);
void DopeSheet_show_meshes_set(PointerRNA *ptr, int value);

int DopeSheet_show_metaballs_get(PointerRNA *ptr);
void DopeSheet_show_metaballs_set(PointerRNA *ptr, int value);

int DopeSheet_show_modifiers_get(PointerRNA *ptr);
void DopeSheet_show_modifiers_set(PointerRNA *ptr, int value);

int DopeSheet_show_nodes_get(PointerRNA *ptr);
void DopeSheet_show_nodes_set(PointerRNA *ptr, int value);

int DopeSheet_show_particles_get(PointerRNA *ptr);
void DopeSheet_show_particles_set(PointerRNA *ptr, int value);

int DopeSheet_show_scenes_get(PointerRNA *ptr);
void DopeSheet_show_scenes_set(PointerRNA *ptr, int value);

int DopeSheet_show_shapekeys_get(PointerRNA *ptr);
void DopeSheet_show_shapekeys_set(PointerRNA *ptr, int value);

int DopeSheet_show_speakers_get(PointerRNA *ptr);
void DopeSheet_show_speakers_set(PointerRNA *ptr, int value);

int DopeSheet_show_summary_get(PointerRNA *ptr);
void DopeSheet_show_summary_set(PointerRNA *ptr, int value);

int DopeSheet_show_textures_get(PointerRNA *ptr);
void DopeSheet_show_textures_set(PointerRNA *ptr, int value);

int DopeSheet_show_transforms_get(PointerRNA *ptr);
void DopeSheet_show_transforms_set(PointerRNA *ptr, int value);

int DopeSheet_show_worlds_get(PointerRNA *ptr);
void DopeSheet_show_worlds_set(PointerRNA *ptr, int value);

#define DopeSheet_filter_fcurve_name_MAX 64

void DopeSheet_filter_fcurve_name_get(PointerRNA *ptr, char *value);
int DopeSheet_filter_fcurve_name_length(PointerRNA *ptr);
void DopeSheet_filter_fcurve_name_set(PointerRNA *ptr, const char *value);

PointerRNA DopeSheet_filter_group_get(PointerRNA *ptr);

int DopeSheet_show_missing_nla_get(PointerRNA *ptr);
void DopeSheet_show_missing_nla_set(PointerRNA *ptr, int value);

int DopeSheet_show_only_matching_fcurves_get(PointerRNA *ptr);
void DopeSheet_show_only_matching_fcurves_set(PointerRNA *ptr, int value);

int DopeSheet_show_only_group_objects_get(PointerRNA *ptr);
void DopeSheet_show_only_group_objects_set(PointerRNA *ptr, int value);

int DopeSheet_show_only_selected_get(PointerRNA *ptr);
void DopeSheet_show_only_selected_set(PointerRNA *ptr, int value);

int DopeSheet_show_datablock_filters_get(PointerRNA *ptr);
void DopeSheet_show_datablock_filters_set(PointerRNA *ptr, int value);

int DopeSheet_show_only_errors_get(PointerRNA *ptr);
void DopeSheet_show_only_errors_set(PointerRNA *ptr, int value);

PointerRNA DopeSheet_source_get(PointerRNA *ptr);

/**************** Driver ****************/

extern StructRNA RNA_Driver;

PointerRNA Driver_rna_type_get(PointerRNA *ptr);

#define Driver_expression_MAX 256

void Driver_expression_get(PointerRNA *ptr, char *value);
int Driver_expression_length(PointerRNA *ptr);
void Driver_expression_set(PointerRNA *ptr, const char *value);

int Driver_is_valid_get(PointerRNA *ptr);
void Driver_is_valid_set(PointerRNA *ptr, int value);

int Driver_show_debug_info_get(PointerRNA *ptr);
void Driver_show_debug_info_set(PointerRNA *ptr, int value);

enum {
	Driver_type_AVERAGE = 0,
	Driver_type_SUM = 2,
	Driver_type_SCRIPTED = 1,
	Driver_type_MIN = 3,
	Driver_type_MAX = 4,
};

int Driver_type_get(PointerRNA *ptr);
void Driver_type_set(PointerRNA *ptr, int value);

void Driver_variables_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Driver_variables_next(CollectionPropertyIterator *iter);
void Driver_variables_end(CollectionPropertyIterator *iter);
int Driver_variables_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Driver_variables_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Driver Target ****************/

extern StructRNA RNA_DriverTarget;

PointerRNA DriverTarget_rna_type_get(PointerRNA *ptr);

#define DriverTarget_bone_target_MAX 32

void DriverTarget_bone_target_get(PointerRNA *ptr, char *value);
int DriverTarget_bone_target_length(PointerRNA *ptr);
void DriverTarget_bone_target_set(PointerRNA *ptr, const char *value);

void DriverTarget_data_path_get(PointerRNA *ptr, char *value);
int DriverTarget_data_path_length(PointerRNA *ptr);
void DriverTarget_data_path_set(PointerRNA *ptr, const char *value);

PointerRNA DriverTarget_id_get(PointerRNA *ptr);

enum {
	DriverTarget_id_type_ACTION = 17217,
	DriverTarget_id_type_ARMATURE = 21057,
	DriverTarget_id_type_BRUSH = 21058,
	DriverTarget_id_type_CAMERA = 16707,
	DriverTarget_id_type_CURVE = 21827,
	DriverTarget_id_type_FONT = 18006,
	DriverTarget_id_type_GREASEPENCIL = 17479,
	DriverTarget_id_type_GROUP = 21063,
	DriverTarget_id_type_IMAGE = 19785,
	DriverTarget_id_type_KEY = 17739,
	DriverTarget_id_type_LAMP = 16716,
	DriverTarget_id_type_LIBRARY = 18764,
	DriverTarget_id_type_LINESTYLE = 21324,
	DriverTarget_id_type_LATTICE = 21580,
	DriverTarget_id_type_MASK = 21325,
	DriverTarget_id_type_MATERIAL = 16717,
	DriverTarget_id_type_META = 16973,
	DriverTarget_id_type_MESH = 17741,
	DriverTarget_id_type_NODETREE = 21582,
	DriverTarget_id_type_OBJECT = 16975,
	DriverTarget_id_type_PAINTCURVE = 17232,
	DriverTarget_id_type_PALETTE = 19536,
	DriverTarget_id_type_PARTICLE = 16720,
	DriverTarget_id_type_SCENE = 17235,
	DriverTarget_id_type_SCREEN = 21075,
	DriverTarget_id_type_SPEAKER = 19283,
	DriverTarget_id_type_SOUND = 20307,
	DriverTarget_id_type_TEXT = 22612,
	DriverTarget_id_type_TEXTURE = 17748,
	DriverTarget_id_type_WORLD = 20311,
	DriverTarget_id_type_WINDOWMANAGER = 19799,
};

int DriverTarget_id_type_get(PointerRNA *ptr);
void DriverTarget_id_type_set(PointerRNA *ptr, int value);

enum {
	DriverTarget_transform_space_WORLD_SPACE = 0,
	DriverTarget_transform_space_TRANSFORM_SPACE = 4,
	DriverTarget_transform_space_LOCAL_SPACE = 12,
};

int DriverTarget_transform_space_get(PointerRNA *ptr);
void DriverTarget_transform_space_set(PointerRNA *ptr, int value);

enum {
	DriverTarget_transform_type_LOC_X = 0,
	DriverTarget_transform_type_LOC_Y = 1,
	DriverTarget_transform_type_LOC_Z = 2,
	DriverTarget_transform_type_ROT_X = 3,
	DriverTarget_transform_type_ROT_Y = 4,
	DriverTarget_transform_type_ROT_Z = 5,
	DriverTarget_transform_type_SCALE_X = 6,
	DriverTarget_transform_type_SCALE_Y = 7,
	DriverTarget_transform_type_SCALE_Z = 8,
};

int DriverTarget_transform_type_get(PointerRNA *ptr);
void DriverTarget_transform_type_set(PointerRNA *ptr, int value);

/**************** Driver Variable ****************/

extern StructRNA RNA_DriverVariable;

PointerRNA DriverVariable_rna_type_get(PointerRNA *ptr);

#define DriverVariable_name_MAX 64

void DriverVariable_name_get(PointerRNA *ptr, char *value);
int DriverVariable_name_length(PointerRNA *ptr);
void DriverVariable_name_set(PointerRNA *ptr, const char *value);

void DriverVariable_targets_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void DriverVariable_targets_next(CollectionPropertyIterator *iter);
void DriverVariable_targets_end(CollectionPropertyIterator *iter);
int DriverVariable_targets_length(PointerRNA *ptr);
int DriverVariable_targets_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	DriverVariable_type_SINGLE_PROP = 0,
	DriverVariable_type_TRANSFORMS = 3,
	DriverVariable_type_ROTATION_DIFF = 1,
	DriverVariable_type_LOC_DIFF = 2,
};

int DriverVariable_type_get(PointerRNA *ptr);
void DriverVariable_type_set(PointerRNA *ptr, int value);

/**************** Object Duplicate ****************/

extern StructRNA RNA_DupliObject;

PointerRNA DupliObject_rna_type_get(PointerRNA *ptr);

enum {
	DupliObject_type_NONE = 0,
	DupliObject_type_FRAMES = 8,
	DupliObject_type_VERTS = 16,
	DupliObject_type_FACES = 512,
	DupliObject_type_GROUP = 256,
};

int DupliObject_type_get(PointerRNA *ptr);
void DupliObject_type_set(PointerRNA *ptr, int value);

void DupliObject_orco_get(PointerRNA *ptr, float values[3]);
void DupliObject_orco_set(PointerRNA *ptr, const float values[3]);

int DupliObject_hide_get(PointerRNA *ptr);
void DupliObject_hide_set(PointerRNA *ptr, int value);

int DupliObject_index_get(PointerRNA *ptr);
void DupliObject_index_set(PointerRNA *ptr, int value);

PointerRNA DupliObject_object_get(PointerRNA *ptr);

void DupliObject_matrix_get(PointerRNA *ptr, float values[16]);
void DupliObject_matrix_set(PointerRNA *ptr, const float values[16]);

PointerRNA DupliObject_particle_system_get(PointerRNA *ptr);

void DupliObject_persistent_id_get(PointerRNA *ptr, int values[8]);
void DupliObject_persistent_id_set(PointerRNA *ptr, const int values[8]);

void DupliObject_uv_get(PointerRNA *ptr, float values[2]);
void DupliObject_uv_set(PointerRNA *ptr, const float values[2]);

/**************** Brush Settings ****************/

extern StructRNA RNA_DynamicPaintBrushSettings;

PointerRNA DynamicPaintBrushSettings_rna_type_get(PointerRNA *ptr);

int DynamicPaintBrushSettings_use_absolute_alpha_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_absolute_alpha_set(PointerRNA *ptr, int value);

float DynamicPaintBrushSettings_wave_clamp_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_wave_clamp_set(PointerRNA *ptr, float value);

int DynamicPaintBrushSettings_use_smudge_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_smudge_set(PointerRNA *ptr, int value);

int DynamicPaintBrushSettings_use_paint_erase_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_paint_erase_set(PointerRNA *ptr, int value);

float DynamicPaintBrushSettings_wave_factor_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_wave_factor_set(PointerRNA *ptr, float value);

enum {
	DynamicPaintBrushSettings_proximity_falloff_SMOOTH = 1,
	DynamicPaintBrushSettings_proximity_falloff_CONSTANT = 0,
	DynamicPaintBrushSettings_proximity_falloff_RAMP = 2,
};

int DynamicPaintBrushSettings_proximity_falloff_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_proximity_falloff_set(PointerRNA *ptr, int value);

int DynamicPaintBrushSettings_invert_proximity_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_invert_proximity_set(PointerRNA *ptr, int value);

PointerRNA DynamicPaintBrushSettings_material_get(PointerRNA *ptr);

float DynamicPaintBrushSettings_velocity_max_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_velocity_max_set(PointerRNA *ptr, float value);

int DynamicPaintBrushSettings_use_velocity_alpha_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_velocity_alpha_set(PointerRNA *ptr, int value);

int DynamicPaintBrushSettings_use_velocity_depth_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_velocity_depth_set(PointerRNA *ptr, int value);

int DynamicPaintBrushSettings_use_negative_volume_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_negative_volume_set(PointerRNA *ptr, int value);

int DynamicPaintBrushSettings_use_proximity_ramp_alpha_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_proximity_ramp_alpha_set(PointerRNA *ptr, int value);

float DynamicPaintBrushSettings_paint_alpha_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_paint_alpha_set(PointerRNA *ptr, float value);

void DynamicPaintBrushSettings_paint_color_get(PointerRNA *ptr, float values[3]);
void DynamicPaintBrushSettings_paint_color_set(PointerRNA *ptr, const float values[3]);

PointerRNA DynamicPaintBrushSettings_paint_ramp_get(PointerRNA *ptr);

enum {
	DynamicPaintBrushSettings_paint_source_PARTICLE_SYSTEM = 3,
	DynamicPaintBrushSettings_paint_source_POINT = 4,
	DynamicPaintBrushSettings_paint_source_DISTANCE = 1,
	DynamicPaintBrushSettings_paint_source_VOLUME_DISTANCE = 2,
	DynamicPaintBrushSettings_paint_source_VOLUME = 0,
};

int DynamicPaintBrushSettings_paint_source_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_paint_source_set(PointerRNA *ptr, int value);

float DynamicPaintBrushSettings_paint_wetness_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_paint_wetness_set(PointerRNA *ptr, float value);

PointerRNA DynamicPaintBrushSettings_particle_system_get(PointerRNA *ptr);

int DynamicPaintBrushSettings_use_proximity_project_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_proximity_project_set(PointerRNA *ptr, int value);

float DynamicPaintBrushSettings_paint_distance_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_paint_distance_set(PointerRNA *ptr, float value);

enum {
	DynamicPaintBrushSettings_ray_direction_CANVAS = 0,
	DynamicPaintBrushSettings_ray_direction_BRUSH = 1,
	DynamicPaintBrushSettings_ray_direction_Z_AXIS = 2,
};

int DynamicPaintBrushSettings_ray_direction_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_ray_direction_set(PointerRNA *ptr, int value);

int DynamicPaintBrushSettings_use_velocity_color_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_velocity_color_set(PointerRNA *ptr, int value);

float DynamicPaintBrushSettings_smooth_radius_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_smooth_radius_set(PointerRNA *ptr, float value);

float DynamicPaintBrushSettings_smudge_strength_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_smudge_strength_set(PointerRNA *ptr, float value);

float DynamicPaintBrushSettings_solid_radius_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_solid_radius_set(PointerRNA *ptr, float value);

int DynamicPaintBrushSettings_use_particle_radius_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_particle_radius_set(PointerRNA *ptr, int value);

int DynamicPaintBrushSettings_use_material_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_material_set(PointerRNA *ptr, int value);

PointerRNA DynamicPaintBrushSettings_velocity_ramp_get(PointerRNA *ptr);

enum {
	DynamicPaintBrushSettings_wave_type_CHANGE = 3,
	DynamicPaintBrushSettings_wave_type_DEPTH = 0,
	DynamicPaintBrushSettings_wave_type_FORCE = 1,
	DynamicPaintBrushSettings_wave_type_REFLECT = 2,
};

int DynamicPaintBrushSettings_wave_type_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_wave_type_set(PointerRNA *ptr, int value);

/**************** Canvas Settings ****************/

extern StructRNA RNA_DynamicPaintCanvasSettings;

PointerRNA DynamicPaintCanvasSettings_rna_type_get(PointerRNA *ptr);

void DynamicPaintCanvasSettings_canvas_surfaces_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void DynamicPaintCanvasSettings_canvas_surfaces_next(CollectionPropertyIterator *iter);
void DynamicPaintCanvasSettings_canvas_surfaces_end(CollectionPropertyIterator *iter);

/**************** Dynamic Paint Modifier ****************/

extern StructRNA RNA_DynamicPaintModifier;
extern StructRNA RNA_Modifier;

PointerRNA DynamicPaintModifier_brush_settings_get(PointerRNA *ptr);

PointerRNA DynamicPaintModifier_canvas_settings_get(PointerRNA *ptr);

enum {
	DynamicPaintModifier_ui_type_CANVAS = 1,
	DynamicPaintModifier_ui_type_BRUSH = 2,
};

int DynamicPaintModifier_ui_type_get(PointerRNA *ptr);
void DynamicPaintModifier_ui_type_set(PointerRNA *ptr, int value);

/**************** Paint Surface ****************/

extern StructRNA RNA_DynamicPaintSurface;

PointerRNA DynamicPaintSurface_rna_type_get(PointerRNA *ptr);

#define DynamicPaintSurface_name_MAX 64

void DynamicPaintSurface_name_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_name_length(PointerRNA *ptr);
void DynamicPaintSurface_name_set(PointerRNA *ptr, const char *value);

float DynamicPaintSurface_drip_acceleration_get(PointerRNA *ptr);
void DynamicPaintSurface_drip_acceleration_set(PointerRNA *ptr, float value);

int DynamicPaintSurface_use_antialiasing_get(PointerRNA *ptr);
void DynamicPaintSurface_use_antialiasing_set(PointerRNA *ptr, int value);

PointerRNA DynamicPaintSurface_brush_group_get(PointerRNA *ptr);

void DynamicPaintSurface_init_color_get(PointerRNA *ptr, float values[4]);
void DynamicPaintSurface_init_color_set(PointerRNA *ptr, const float values[4]);

float DynamicPaintSurface_color_dry_threshold_get(PointerRNA *ptr);
void DynamicPaintSurface_color_dry_threshold_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_color_spread_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_color_spread_speed_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_wave_damping_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_damping_set(PointerRNA *ptr, float value);

#define DynamicPaintSurface_init_layername_MAX 64

void DynamicPaintSurface_init_layername_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_init_layername_length(PointerRNA *ptr);
void DynamicPaintSurface_init_layername_set(PointerRNA *ptr, const char *value);

enum {
	DynamicPaintSurface_displace_type_DISPLACE = 0,
	DynamicPaintSurface_displace_type_DEPTH = 1,
};

int DynamicPaintSurface_displace_type_get(PointerRNA *ptr);
void DynamicPaintSurface_displace_type_set(PointerRNA *ptr, int value);

float DynamicPaintSurface_displace_factor_get(PointerRNA *ptr);
void DynamicPaintSurface_displace_factor_set(PointerRNA *ptr, float value);

int DynamicPaintSurface_use_dissolve_get(PointerRNA *ptr);
void DynamicPaintSurface_use_dissolve_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_dissolve_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_dissolve_speed_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_use_drying_get(PointerRNA *ptr);
void DynamicPaintSurface_use_drying_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_dry_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_dry_speed_set(PointerRNA *ptr, int value);

enum {
	DynamicPaintSurface_effect_ui_SPREAD = 1,
	DynamicPaintSurface_effect_ui_DRIP = 2,
	DynamicPaintSurface_effect_ui_SHRINK = 3,
};

int DynamicPaintSurface_effect_ui_get(PointerRNA *ptr);
void DynamicPaintSurface_effect_ui_set(PointerRNA *ptr, int value);

PointerRNA DynamicPaintSurface_effector_weights_get(PointerRNA *ptr);

int DynamicPaintSurface_frame_end_get(PointerRNA *ptr);
void DynamicPaintSurface_frame_end_set(PointerRNA *ptr, int value);

enum {
	DynamicPaintSurface_image_fileformat_PNG = 0,
};

int DynamicPaintSurface_image_fileformat_get(PointerRNA *ptr);
void DynamicPaintSurface_image_fileformat_set(PointerRNA *ptr, int value);

enum {
	DynamicPaintSurface_surface_format_VERTEX = 1,
	DynamicPaintSurface_surface_format_IMAGE = 2,
};

int DynamicPaintSurface_surface_format_get(PointerRNA *ptr);
void DynamicPaintSurface_surface_format_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_use_incremental_displace_get(PointerRNA *ptr);
void DynamicPaintSurface_use_incremental_displace_set(PointerRNA *ptr, int value);

float DynamicPaintSurface_brush_influence_scale_get(PointerRNA *ptr);
void DynamicPaintSurface_brush_influence_scale_set(PointerRNA *ptr, float value);

enum {
	DynamicPaintSurface_init_color_type_NONE = 0,
	DynamicPaintSurface_init_color_type_COLOR = 1,
	DynamicPaintSurface_init_color_type_TEXTURE = 2,
	DynamicPaintSurface_init_color_type_VERTEX_COLOR = 3,
};

int DynamicPaintSurface_init_color_type_get(PointerRNA *ptr);
void DynamicPaintSurface_init_color_type_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_is_active_get(PointerRNA *ptr);
void DynamicPaintSurface_is_active_set(PointerRNA *ptr, int value);

float DynamicPaintSurface_depth_clamp_get(PointerRNA *ptr);
void DynamicPaintSurface_depth_clamp_set(PointerRNA *ptr, float value);

int DynamicPaintSurface_use_wave_open_border_get(PointerRNA *ptr);
void DynamicPaintSurface_use_wave_open_border_set(PointerRNA *ptr, int value);

#define DynamicPaintSurface_output_name_a_MAX 64

void DynamicPaintSurface_output_name_a_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_output_name_a_length(PointerRNA *ptr);
void DynamicPaintSurface_output_name_a_set(PointerRNA *ptr, const char *value);

#define DynamicPaintSurface_output_name_b_MAX 64

void DynamicPaintSurface_output_name_b_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_output_name_b_length(PointerRNA *ptr);
void DynamicPaintSurface_output_name_b_set(PointerRNA *ptr, const char *value);

#define DynamicPaintSurface_image_output_path_MAX 1024

void DynamicPaintSurface_image_output_path_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_image_output_path_length(PointerRNA *ptr);
void DynamicPaintSurface_image_output_path_set(PointerRNA *ptr, const char *value);

PointerRNA DynamicPaintSurface_point_cache_get(PointerRNA *ptr);

int DynamicPaintSurface_use_premultiply_get(PointerRNA *ptr);
void DynamicPaintSurface_use_premultiply_set(PointerRNA *ptr, int value);

enum {
	DynamicPaintSurface_preview_id_PAINT = 0,
	DynamicPaintSurface_preview_id_WETMAP = 1,
};

int DynamicPaintSurface_preview_id_get(PointerRNA *ptr);
void DynamicPaintSurface_preview_id_set(PointerRNA *ptr, int value);

float DynamicPaintSurface_brush_radius_scale_get(PointerRNA *ptr);
void DynamicPaintSurface_brush_radius_scale_set(PointerRNA *ptr, float value);

int DynamicPaintSurface_image_resolution_get(PointerRNA *ptr);
void DynamicPaintSurface_image_resolution_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_show_preview_get(PointerRNA *ptr);
void DynamicPaintSurface_show_preview_set(PointerRNA *ptr, int value);

float DynamicPaintSurface_shrink_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_shrink_speed_set(PointerRNA *ptr, float value);

int DynamicPaintSurface_use_dry_log_get(PointerRNA *ptr);
void DynamicPaintSurface_use_dry_log_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_use_dissolve_log_get(PointerRNA *ptr);
void DynamicPaintSurface_use_dissolve_log_set(PointerRNA *ptr, int value);

float DynamicPaintSurface_wave_smoothness_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_smoothness_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_wave_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_speed_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_spread_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_spread_speed_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_wave_spring_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_spring_set(PointerRNA *ptr, float value);

int DynamicPaintSurface_frame_start_get(PointerRNA *ptr);
void DynamicPaintSurface_frame_start_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_frame_substeps_get(PointerRNA *ptr);
void DynamicPaintSurface_frame_substeps_set(PointerRNA *ptr, int value);

enum {
	DynamicPaintSurface_surface_type_PAINT = 0,
};

int DynamicPaintSurface_surface_type_get(PointerRNA *ptr);
void DynamicPaintSurface_surface_type_set(PointerRNA *ptr, int value);

PointerRNA DynamicPaintSurface_init_texture_get(PointerRNA *ptr);

float DynamicPaintSurface_wave_timescale_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_timescale_set(PointerRNA *ptr, float value);

#define DynamicPaintSurface_uv_layer_MAX 64

void DynamicPaintSurface_uv_layer_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_uv_layer_length(PointerRNA *ptr);
void DynamicPaintSurface_uv_layer_set(PointerRNA *ptr, const char *value);

int DynamicPaintSurface_is_cache_user_get(PointerRNA *ptr);
void DynamicPaintSurface_is_cache_user_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_use_color_preview_get(PointerRNA *ptr);
void DynamicPaintSurface_use_color_preview_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_use_drip_get(PointerRNA *ptr);
void DynamicPaintSurface_use_drip_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_use_output_a_get(PointerRNA *ptr);
void DynamicPaintSurface_use_output_a_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_use_output_b_get(PointerRNA *ptr);
void DynamicPaintSurface_use_output_b_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_use_shrink_get(PointerRNA *ptr);
void DynamicPaintSurface_use_shrink_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_use_spread_get(PointerRNA *ptr);
void DynamicPaintSurface_use_spread_set(PointerRNA *ptr, int value);

float DynamicPaintSurface_drip_velocity_get(PointerRNA *ptr);
void DynamicPaintSurface_drip_velocity_set(PointerRNA *ptr, float value);

int DynamicPaintSurface_output_exists(struct DynamicPaintSurface *_self, struct Object *object, int index);
/**************** Canvas Surfaces ****************/

extern StructRNA RNA_DynamicPaintSurfaces;

PointerRNA DynamicPaintSurfaces_rna_type_get(PointerRNA *ptr);

int DynamicPaintSurfaces_active_index_get(PointerRNA *ptr);
void DynamicPaintSurfaces_active_index_set(PointerRNA *ptr, int value);

PointerRNA DynamicPaintSurfaces_active_get(PointerRNA *ptr);

/**************** EdgeSplit Modifier ****************/

extern StructRNA RNA_EdgeSplitModifier;
extern StructRNA RNA_Modifier;

float EdgeSplitModifier_split_angle_get(PointerRNA *ptr);
void EdgeSplitModifier_split_angle_set(PointerRNA *ptr, float value);

int EdgeSplitModifier_use_edge_angle_get(PointerRNA *ptr);
void EdgeSplitModifier_use_edge_angle_set(PointerRNA *ptr, int value);

int EdgeSplitModifier_use_edge_sharp_get(PointerRNA *ptr);
void EdgeSplitModifier_use_edge_sharp_set(PointerRNA *ptr, int value);

/**************** Edit Bone ****************/

extern StructRNA RNA_EditBone;

PointerRNA EditBone_rna_type_get(PointerRNA *ptr);

void EditBone_name_get(PointerRNA *ptr, char *value);
int EditBone_name_length(PointerRNA *ptr);
void EditBone_name_set(PointerRNA *ptr, const char *value);

float EditBone_bbone_x_get(PointerRNA *ptr);
void EditBone_bbone_x_set(PointerRNA *ptr, float value);

float EditBone_bbone_z_get(PointerRNA *ptr);
void EditBone_bbone_z_set(PointerRNA *ptr, float value);

float EditBone_bbone_in_get(PointerRNA *ptr);
void EditBone_bbone_in_set(PointerRNA *ptr, float value);

float EditBone_bbone_out_get(PointerRNA *ptr);
void EditBone_bbone_out_set(PointerRNA *ptr, float value);

int EditBone_bbone_segments_get(PointerRNA *ptr);
void EditBone_bbone_segments_set(PointerRNA *ptr, int value);

int EditBone_use_connect_get(PointerRNA *ptr);
void EditBone_use_connect_set(PointerRNA *ptr, int value);

int EditBone_use_cyclic_offset_get(PointerRNA *ptr);
void EditBone_use_cyclic_offset_set(PointerRNA *ptr, int value);

int EditBone_use_deform_get(PointerRNA *ptr);
void EditBone_use_deform_set(PointerRNA *ptr, int value);

int EditBone_show_wire_get(PointerRNA *ptr);
void EditBone_show_wire_set(PointerRNA *ptr, int value);

void EditBone_matrix_get(PointerRNA *ptr, float values[16]);
void EditBone_matrix_set(PointerRNA *ptr, const float values[16]);

float EditBone_envelope_distance_get(PointerRNA *ptr);
void EditBone_envelope_distance_set(PointerRNA *ptr, float value);

float EditBone_envelope_weight_get(PointerRNA *ptr);
void EditBone_envelope_weight_set(PointerRNA *ptr, float value);

float EditBone_head_radius_get(PointerRNA *ptr);
void EditBone_head_radius_set(PointerRNA *ptr, float value);

float EditBone_tail_radius_get(PointerRNA *ptr);
void EditBone_tail_radius_set(PointerRNA *ptr, float value);

void EditBone_head_get(PointerRNA *ptr, float values[3]);
void EditBone_head_set(PointerRNA *ptr, const float values[3]);

int EditBone_select_head_get(PointerRNA *ptr);
void EditBone_select_head_set(PointerRNA *ptr, int value);

int EditBone_hide_get(PointerRNA *ptr);
void EditBone_hide_set(PointerRNA *ptr, int value);

int EditBone_use_inherit_rotation_get(PointerRNA *ptr);
void EditBone_use_inherit_rotation_set(PointerRNA *ptr, int value);

int EditBone_use_inherit_scale_get(PointerRNA *ptr);
void EditBone_use_inherit_scale_set(PointerRNA *ptr, int value);

void EditBone_layers_get(PointerRNA *ptr, int values[32]);
void EditBone_layers_set(PointerRNA *ptr, const int values[32]);

int EditBone_use_local_location_get(PointerRNA *ptr);
void EditBone_use_local_location_set(PointerRNA *ptr, int value);

int EditBone_lock_get(PointerRNA *ptr);
void EditBone_lock_set(PointerRNA *ptr, int value);

int EditBone_use_envelope_multiply_get(PointerRNA *ptr);
void EditBone_use_envelope_multiply_set(PointerRNA *ptr, int value);

PointerRNA EditBone_parent_get(PointerRNA *ptr);

int EditBone_use_relative_parent_get(PointerRNA *ptr);
void EditBone_use_relative_parent_set(PointerRNA *ptr, int value);

float EditBone_roll_get(PointerRNA *ptr);
void EditBone_roll_set(PointerRNA *ptr, float value);

int EditBone_select_get(PointerRNA *ptr);
void EditBone_select_set(PointerRNA *ptr, int value);

int EditBone_hide_select_get(PointerRNA *ptr);
void EditBone_hide_select_set(PointerRNA *ptr, int value);

void EditBone_tail_get(PointerRNA *ptr, float values[3]);
void EditBone_tail_set(PointerRNA *ptr, const float values[3]);

int EditBone_select_tail_get(PointerRNA *ptr);
void EditBone_select_tail_set(PointerRNA *ptr, int value);

void EditBone_align_roll(struct EditBone *_self, float vector[3]);
/**************** Edit Object Actuator ****************/

extern StructRNA RNA_EditObjectActuator;
extern StructRNA RNA_Actuator;

int EditObjectActuator_use_3d_tracking_get(PointerRNA *ptr);
void EditObjectActuator_use_3d_tracking_set(PointerRNA *ptr, int value);

void EditObjectActuator_angular_velocity_get(PointerRNA *ptr, float values[3]);
void EditObjectActuator_angular_velocity_set(PointerRNA *ptr, const float values[3]);

enum {
	EditObjectActuator_dynamic_operation_RESTOREDYN = 0,
	EditObjectActuator_dynamic_operation_SUSPENDDYN = 1,
	EditObjectActuator_dynamic_operation_ENABLERIGIDBODY = 2,
	EditObjectActuator_dynamic_operation_DISABLERIGIDBODY = 3,
	EditObjectActuator_dynamic_operation_SETMASS = 4,
};

int EditObjectActuator_dynamic_operation_get(PointerRNA *ptr);
void EditObjectActuator_dynamic_operation_set(PointerRNA *ptr, int value);

enum {
	EditObjectActuator_mode_ADDOBJECT = 0,
	EditObjectActuator_mode_ENDOBJECT = 1,
	EditObjectActuator_mode_REPLACEMESH = 2,
	EditObjectActuator_mode_TRACKTO = 3,
	EditObjectActuator_mode_DYNAMICS = 4,
};

int EditObjectActuator_mode_get(PointerRNA *ptr);
void EditObjectActuator_mode_set(PointerRNA *ptr, int value);

int EditObjectActuator_use_replace_display_mesh_get(PointerRNA *ptr);
void EditObjectActuator_use_replace_display_mesh_set(PointerRNA *ptr, int value);

int EditObjectActuator_use_local_linear_velocity_get(PointerRNA *ptr);
void EditObjectActuator_use_local_linear_velocity_set(PointerRNA *ptr, int value);

int EditObjectActuator_use_local_angular_velocity_get(PointerRNA *ptr);
void EditObjectActuator_use_local_angular_velocity_set(PointerRNA *ptr, int value);

void EditObjectActuator_linear_velocity_get(PointerRNA *ptr, float values[3]);
void EditObjectActuator_linear_velocity_set(PointerRNA *ptr, const float values[3]);

float EditObjectActuator_mass_get(PointerRNA *ptr);
void EditObjectActuator_mass_set(PointerRNA *ptr, float value);

PointerRNA EditObjectActuator_mesh_get(PointerRNA *ptr);

PointerRNA EditObjectActuator_object_get(PointerRNA *ptr);

PointerRNA EditObjectActuator_track_object_get(PointerRNA *ptr);

int EditObjectActuator_use_replace_physics_mesh_get(PointerRNA *ptr);
void EditObjectActuator_use_replace_physics_mesh_set(PointerRNA *ptr, int value);

int EditObjectActuator_time_get(PointerRNA *ptr);
void EditObjectActuator_time_set(PointerRNA *ptr, int value);

enum {
	EditObjectActuator_track_axis_TRACKAXISX = 0,
	EditObjectActuator_track_axis_TRACKAXISY = 1,
	EditObjectActuator_track_axis_TRACKAXISZ = 2,
	EditObjectActuator_track_axis_TRACKAXISNEGX = 3,
	EditObjectActuator_track_axis_TRACKAXISNEGY = 4,
	EditObjectActuator_track_axis_TRACKAXISNEGZ = 5,
};

int EditObjectActuator_track_axis_get(PointerRNA *ptr);
void EditObjectActuator_track_axis_set(PointerRNA *ptr, int value);

enum {
	EditObjectActuator_up_axis_UPAXISX = 0,
	EditObjectActuator_up_axis_UPAXISY = 1,
	EditObjectActuator_up_axis_UPAXISZ = 2,
};

int EditObjectActuator_up_axis_get(PointerRNA *ptr);
void EditObjectActuator_up_axis_set(PointerRNA *ptr, int value);

/**************** Effect Sequence ****************/

extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

enum {
	EffectSequence_alpha_mode_STRAIGHT = 0,
	EffectSequence_alpha_mode_PREMUL = 1,
};

int EffectSequence_alpha_mode_get(PointerRNA *ptr);
void EffectSequence_alpha_mode_set(PointerRNA *ptr, int value);

int EffectSequence_use_float_get(PointerRNA *ptr);
void EffectSequence_use_float_set(PointerRNA *ptr, int value);

PointerRNA EffectSequence_crop_get(PointerRNA *ptr);

int EffectSequence_use_deinterlace_get(PointerRNA *ptr);
void EffectSequence_use_deinterlace_set(PointerRNA *ptr, int value);

int EffectSequence_use_reverse_frames_get(PointerRNA *ptr);
void EffectSequence_use_reverse_frames_set(PointerRNA *ptr, int value);

int EffectSequence_use_flip_x_get(PointerRNA *ptr);
void EffectSequence_use_flip_x_set(PointerRNA *ptr, int value);

int EffectSequence_use_flip_y_get(PointerRNA *ptr);
void EffectSequence_use_flip_y_set(PointerRNA *ptr, int value);

float EffectSequence_color_multiply_get(PointerRNA *ptr);
void EffectSequence_color_multiply_set(PointerRNA *ptr, float value);

PointerRNA EffectSequence_proxy_get(PointerRNA *ptr);

int EffectSequence_use_proxy_custom_directory_get(PointerRNA *ptr);
void EffectSequence_use_proxy_custom_directory_set(PointerRNA *ptr, int value);

int EffectSequence_use_proxy_custom_file_get(PointerRNA *ptr);
void EffectSequence_use_proxy_custom_file_set(PointerRNA *ptr, int value);

float EffectSequence_color_saturation_get(PointerRNA *ptr);
void EffectSequence_color_saturation_set(PointerRNA *ptr, float value);

float EffectSequence_strobe_get(PointerRNA *ptr);
void EffectSequence_strobe_set(PointerRNA *ptr, float value);

PointerRNA EffectSequence_transform_get(PointerRNA *ptr);

int EffectSequence_use_crop_get(PointerRNA *ptr);
void EffectSequence_use_crop_set(PointerRNA *ptr, int value);

int EffectSequence_use_proxy_get(PointerRNA *ptr);
void EffectSequence_use_proxy_set(PointerRNA *ptr, int value);

int EffectSequence_use_translation_get(PointerRNA *ptr);
void EffectSequence_use_translation_set(PointerRNA *ptr, int value);

/**************** Effector Weights ****************/

extern StructRNA RNA_EffectorWeights;

PointerRNA EffectorWeights_rna_type_get(PointerRNA *ptr);

float EffectorWeights_all_get(PointerRNA *ptr);
void EffectorWeights_all_set(PointerRNA *ptr, float value);

float EffectorWeights_boid_get(PointerRNA *ptr);
void EffectorWeights_boid_set(PointerRNA *ptr, float value);

float EffectorWeights_charge_get(PointerRNA *ptr);
void EffectorWeights_charge_set(PointerRNA *ptr, float value);

float EffectorWeights_curve_guide_get(PointerRNA *ptr);
void EffectorWeights_curve_guide_set(PointerRNA *ptr, float value);

float EffectorWeights_drag_get(PointerRNA *ptr);
void EffectorWeights_drag_set(PointerRNA *ptr, float value);

PointerRNA EffectorWeights_group_get(PointerRNA *ptr);

float EffectorWeights_force_get(PointerRNA *ptr);
void EffectorWeights_force_set(PointerRNA *ptr, float value);

float EffectorWeights_gravity_get(PointerRNA *ptr);
void EffectorWeights_gravity_set(PointerRNA *ptr, float value);

float EffectorWeights_harmonic_get(PointerRNA *ptr);
void EffectorWeights_harmonic_set(PointerRNA *ptr, float value);

float EffectorWeights_lennardjones_get(PointerRNA *ptr);
void EffectorWeights_lennardjones_set(PointerRNA *ptr, float value);

float EffectorWeights_magnetic_get(PointerRNA *ptr);
void EffectorWeights_magnetic_set(PointerRNA *ptr, float value);

float EffectorWeights_smokeflow_get(PointerRNA *ptr);
void EffectorWeights_smokeflow_set(PointerRNA *ptr, float value);

float EffectorWeights_texture_get(PointerRNA *ptr);
void EffectorWeights_texture_set(PointerRNA *ptr, float value);

float EffectorWeights_turbulence_get(PointerRNA *ptr);
void EffectorWeights_turbulence_set(PointerRNA *ptr, float value);

int EffectorWeights_apply_to_hair_growing_get(PointerRNA *ptr);
void EffectorWeights_apply_to_hair_growing_set(PointerRNA *ptr, int value);

float EffectorWeights_vortex_get(PointerRNA *ptr);
void EffectorWeights_vortex_set(PointerRNA *ptr, float value);

float EffectorWeights_wind_get(PointerRNA *ptr);
void EffectorWeights_wind_set(PointerRNA *ptr, float value);

/**************** Enum Definition ****************/

extern StructRNA RNA_EnumProperty;
extern StructRNA RNA_Property;

enum {
	EnumProperty_default_DUMMY = 0,
};

int EnumProperty_default_value_get(PointerRNA *ptr);
void EnumProperty_default_value_set(PointerRNA *ptr, int value);

enum {
	EnumProperty_default_flag_DUMMY = 0,
};

int EnumProperty_default_flag_get(PointerRNA *ptr);
void EnumProperty_default_flag_set(PointerRNA *ptr, int value);

void EnumProperty_enum_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void EnumProperty_enum_items_next(CollectionPropertyIterator *iter);
void EnumProperty_enum_items_end(CollectionPropertyIterator *iter);

/**************** Enum Item Definition ****************/

extern StructRNA RNA_EnumPropertyItem;

PointerRNA EnumPropertyItem_rna_type_get(PointerRNA *ptr);

void EnumPropertyItem_name_get(PointerRNA *ptr, char *value);
int EnumPropertyItem_name_length(PointerRNA *ptr);
void EnumPropertyItem_name_set(PointerRNA *ptr, const char *value);

void EnumPropertyItem_description_get(PointerRNA *ptr, char *value);
int EnumPropertyItem_description_length(PointerRNA *ptr);
void EnumPropertyItem_description_set(PointerRNA *ptr, const char *value);

enum {
	EnumPropertyItem_icon_NONE = 0,
	EnumPropertyItem_icon_QUESTION = 1,
	EnumPropertyItem_icon_ERROR = 2,
	EnumPropertyItem_icon_CANCEL = 3,
	EnumPropertyItem_icon_TRIA_RIGHT = 4,
	EnumPropertyItem_icon_TRIA_DOWN = 5,
	EnumPropertyItem_icon_TRIA_LEFT = 6,
	EnumPropertyItem_icon_TRIA_UP = 7,
	EnumPropertyItem_icon_ARROW_LEFTRIGHT = 8,
	EnumPropertyItem_icon_PLUS = 9,
	EnumPropertyItem_icon_DISCLOSURE_TRI_DOWN = 10,
	EnumPropertyItem_icon_DISCLOSURE_TRI_RIGHT = 11,
	EnumPropertyItem_icon_RADIOBUT_OFF = 12,
	EnumPropertyItem_icon_RADIOBUT_ON = 13,
	EnumPropertyItem_icon_MENU_PANEL = 14,
	EnumPropertyItem_icon_BLENDER = 15,
	EnumPropertyItem_icon_GRIP = 16,
	EnumPropertyItem_icon_DOT = 17,
	EnumPropertyItem_icon_COLLAPSEMENU = 18,
	EnumPropertyItem_icon_X = 19,
	EnumPropertyItem_icon_GO_LEFT = 21,
	EnumPropertyItem_icon_PLUG = 22,
	EnumPropertyItem_icon_UI = 23,
	EnumPropertyItem_icon_NODE = 24,
	EnumPropertyItem_icon_NODE_SEL = 25,
	EnumPropertyItem_icon_FULLSCREEN = 26,
	EnumPropertyItem_icon_SPLITSCREEN = 27,
	EnumPropertyItem_icon_RIGHTARROW_THIN = 28,
	EnumPropertyItem_icon_BORDERMOVE = 29,
	EnumPropertyItem_icon_VIEWZOOM = 30,
	EnumPropertyItem_icon_ZOOMIN = 31,
	EnumPropertyItem_icon_ZOOMOUT = 32,
	EnumPropertyItem_icon_PANEL_CLOSE = 33,
	EnumPropertyItem_icon_COPY_ID = 34,
	EnumPropertyItem_icon_EYEDROPPER = 35,
	EnumPropertyItem_icon_LINK_AREA = 36,
	EnumPropertyItem_icon_AUTO = 37,
	EnumPropertyItem_icon_CHECKBOX_DEHLT = 38,
	EnumPropertyItem_icon_CHECKBOX_HLT = 39,
	EnumPropertyItem_icon_UNLOCKED = 40,
	EnumPropertyItem_icon_LOCKED = 41,
	EnumPropertyItem_icon_UNPINNED = 42,
	EnumPropertyItem_icon_PINNED = 43,
	EnumPropertyItem_icon_SCREEN_BACK = 44,
	EnumPropertyItem_icon_RIGHTARROW = 45,
	EnumPropertyItem_icon_DOWNARROW_HLT = 46,
	EnumPropertyItem_icon_DOTSUP = 47,
	EnumPropertyItem_icon_DOTSDOWN = 48,
	EnumPropertyItem_icon_LINK = 49,
	EnumPropertyItem_icon_INLINK = 50,
	EnumPropertyItem_icon_PLUGIN = 51,
	EnumPropertyItem_icon_HELP = 52,
	EnumPropertyItem_icon_GHOST_ENABLED = 53,
	EnumPropertyItem_icon_COLOR = 54,
	EnumPropertyItem_icon_LINKED = 55,
	EnumPropertyItem_icon_UNLINKED = 56,
	EnumPropertyItem_icon_HAND = 57,
	EnumPropertyItem_icon_ZOOM_ALL = 58,
	EnumPropertyItem_icon_ZOOM_SELECTED = 59,
	EnumPropertyItem_icon_ZOOM_PREVIOUS = 60,
	EnumPropertyItem_icon_ZOOM_IN = 61,
	EnumPropertyItem_icon_ZOOM_OUT = 62,
	EnumPropertyItem_icon_RENDER_REGION = 63,
	EnumPropertyItem_icon_BORDER_RECT = 64,
	EnumPropertyItem_icon_BORDER_LASSO = 65,
	EnumPropertyItem_icon_FREEZE = 66,
	EnumPropertyItem_icon_STYLUS_PRESSURE = 67,
	EnumPropertyItem_icon_GHOST_DISABLED = 68,
	EnumPropertyItem_icon_NEW = 69,
	EnumPropertyItem_icon_FILE_TICK = 70,
	EnumPropertyItem_icon_QUIT = 71,
	EnumPropertyItem_icon_URL = 72,
	EnumPropertyItem_icon_RECOVER_LAST = 73,
	EnumPropertyItem_icon_FULLSCREEN_ENTER = 75,
	EnumPropertyItem_icon_FULLSCREEN_EXIT = 76,
	EnumPropertyItem_icon_BLANK1 = 77,
	EnumPropertyItem_icon_LAMP = 78,
	EnumPropertyItem_icon_MATERIAL = 79,
	EnumPropertyItem_icon_TEXTURE = 80,
	EnumPropertyItem_icon_ANIM = 81,
	EnumPropertyItem_icon_WORLD = 82,
	EnumPropertyItem_icon_SCENE = 83,
	EnumPropertyItem_icon_EDIT = 84,
	EnumPropertyItem_icon_GAME = 85,
	EnumPropertyItem_icon_RADIO = 86,
	EnumPropertyItem_icon_SCRIPT = 87,
	EnumPropertyItem_icon_PARTICLES = 88,
	EnumPropertyItem_icon_PHYSICS = 89,
	EnumPropertyItem_icon_SPEAKER = 90,
	EnumPropertyItem_icon_TEXTURE_SHADED = 91,
	EnumPropertyItem_icon_VIEW3D = 104,
	EnumPropertyItem_icon_IPO = 105,
	EnumPropertyItem_icon_OOPS = 106,
	EnumPropertyItem_icon_BUTS = 107,
	EnumPropertyItem_icon_FILESEL = 108,
	EnumPropertyItem_icon_IMAGE_COL = 109,
	EnumPropertyItem_icon_INFO = 110,
	EnumPropertyItem_icon_SEQUENCE = 111,
	EnumPropertyItem_icon_TEXT = 112,
	EnumPropertyItem_icon_IMASEL = 113,
	EnumPropertyItem_icon_SOUND = 114,
	EnumPropertyItem_icon_ACTION = 115,
	EnumPropertyItem_icon_NLA = 116,
	EnumPropertyItem_icon_SCRIPTWIN = 117,
	EnumPropertyItem_icon_TIME = 118,
	EnumPropertyItem_icon_NODETREE = 119,
	EnumPropertyItem_icon_LOGIC = 120,
	EnumPropertyItem_icon_CONSOLE = 121,
	EnumPropertyItem_icon_PREFERENCES = 122,
	EnumPropertyItem_icon_CLIP = 123,
	EnumPropertyItem_icon_ASSET_MANAGER = 124,
	EnumPropertyItem_icon_OBJECT_DATAMODE = 130,
	EnumPropertyItem_icon_EDITMODE_HLT = 131,
	EnumPropertyItem_icon_FACESEL_HLT = 132,
	EnumPropertyItem_icon_VPAINT_HLT = 133,
	EnumPropertyItem_icon_TPAINT_HLT = 134,
	EnumPropertyItem_icon_WPAINT_HLT = 135,
	EnumPropertyItem_icon_SCULPTMODE_HLT = 136,
	EnumPropertyItem_icon_POSE_HLT = 137,
	EnumPropertyItem_icon_PARTICLEMODE = 138,
	EnumPropertyItem_icon_LIGHTPAINT = 139,
	EnumPropertyItem_icon_SCENE_DATA = 156,
	EnumPropertyItem_icon_RENDERLAYERS = 157,
	EnumPropertyItem_icon_WORLD_DATA = 158,
	EnumPropertyItem_icon_OBJECT_DATA = 159,
	EnumPropertyItem_icon_MESH_DATA = 160,
	EnumPropertyItem_icon_CURVE_DATA = 161,
	EnumPropertyItem_icon_META_DATA = 162,
	EnumPropertyItem_icon_LATTICE_DATA = 163,
	EnumPropertyItem_icon_LAMP_DATA = 164,
	EnumPropertyItem_icon_MATERIAL_DATA = 165,
	EnumPropertyItem_icon_TEXTURE_DATA = 166,
	EnumPropertyItem_icon_ANIM_DATA = 167,
	EnumPropertyItem_icon_CAMERA_DATA = 168,
	EnumPropertyItem_icon_PARTICLE_DATA = 169,
	EnumPropertyItem_icon_LIBRARY_DATA_DIRECT = 170,
	EnumPropertyItem_icon_GROUP = 171,
	EnumPropertyItem_icon_ARMATURE_DATA = 172,
	EnumPropertyItem_icon_POSE_DATA = 173,
	EnumPropertyItem_icon_BONE_DATA = 174,
	EnumPropertyItem_icon_CONSTRAINT = 175,
	EnumPropertyItem_icon_SHAPEKEY_DATA = 176,
	EnumPropertyItem_icon_CONSTRAINT_BONE = 177,
	EnumPropertyItem_icon_CAMERA_STEREO = 178,
	EnumPropertyItem_icon_PACKAGE = 179,
	EnumPropertyItem_icon_UGLYPACKAGE = 180,
	EnumPropertyItem_icon_BRUSH_DATA = 182,
	EnumPropertyItem_icon_IMAGE_DATA = 183,
	EnumPropertyItem_icon_FILE = 184,
	EnumPropertyItem_icon_FCURVE = 185,
	EnumPropertyItem_icon_FONT_DATA = 186,
	EnumPropertyItem_icon_RENDER_RESULT = 187,
	EnumPropertyItem_icon_SURFACE_DATA = 188,
	EnumPropertyItem_icon_EMPTY_DATA = 189,
	EnumPropertyItem_icon_SETTINGS = 190,
	EnumPropertyItem_icon_RENDER_ANIMATION = 191,
	EnumPropertyItem_icon_RENDER_STILL = 192,
	EnumPropertyItem_icon_BOIDS = 194,
	EnumPropertyItem_icon_STRANDS = 195,
	EnumPropertyItem_icon_LIBRARY_DATA_INDIRECT = 196,
	EnumPropertyItem_icon_GREASEPENCIL = 197,
	EnumPropertyItem_icon_LINE_DATA = 198,
	EnumPropertyItem_icon_GROUP_BONE = 200,
	EnumPropertyItem_icon_GROUP_VERTEX = 201,
	EnumPropertyItem_icon_GROUP_VCOL = 202,
	EnumPropertyItem_icon_GROUP_UVS = 203,
	EnumPropertyItem_icon_RNA = 206,
	EnumPropertyItem_icon_RNA_ADD = 207,
	EnumPropertyItem_icon_OUTLINER_OB_EMPTY = 234,
	EnumPropertyItem_icon_OUTLINER_OB_MESH = 235,
	EnumPropertyItem_icon_OUTLINER_OB_CURVE = 236,
	EnumPropertyItem_icon_OUTLINER_OB_LATTICE = 237,
	EnumPropertyItem_icon_OUTLINER_OB_META = 238,
	EnumPropertyItem_icon_OUTLINER_OB_LAMP = 239,
	EnumPropertyItem_icon_OUTLINER_OB_CAMERA = 240,
	EnumPropertyItem_icon_OUTLINER_OB_ARMATURE = 241,
	EnumPropertyItem_icon_OUTLINER_OB_FONT = 242,
	EnumPropertyItem_icon_OUTLINER_OB_SURFACE = 243,
	EnumPropertyItem_icon_OUTLINER_OB_SPEAKER = 244,
	EnumPropertyItem_icon_RESTRICT_VIEW_OFF = 253,
	EnumPropertyItem_icon_RESTRICT_VIEW_ON = 254,
	EnumPropertyItem_icon_RESTRICT_SELECT_OFF = 255,
	EnumPropertyItem_icon_RESTRICT_SELECT_ON = 256,
	EnumPropertyItem_icon_RESTRICT_RENDER_OFF = 257,
	EnumPropertyItem_icon_RESTRICT_RENDER_ON = 258,
	EnumPropertyItem_icon_OUTLINER_DATA_EMPTY = 260,
	EnumPropertyItem_icon_OUTLINER_DATA_MESH = 261,
	EnumPropertyItem_icon_OUTLINER_DATA_CURVE = 262,
	EnumPropertyItem_icon_OUTLINER_DATA_LATTICE = 263,
	EnumPropertyItem_icon_OUTLINER_DATA_META = 264,
	EnumPropertyItem_icon_OUTLINER_DATA_LAMP = 265,
	EnumPropertyItem_icon_OUTLINER_DATA_CAMERA = 266,
	EnumPropertyItem_icon_OUTLINER_DATA_ARMATURE = 267,
	EnumPropertyItem_icon_OUTLINER_DATA_FONT = 268,
	EnumPropertyItem_icon_OUTLINER_DATA_SURFACE = 269,
	EnumPropertyItem_icon_OUTLINER_DATA_SPEAKER = 270,
	EnumPropertyItem_icon_OUTLINER_DATA_POSE = 271,
	EnumPropertyItem_icon_MESH_PLANE = 286,
	EnumPropertyItem_icon_MESH_CUBE = 287,
	EnumPropertyItem_icon_MESH_CIRCLE = 288,
	EnumPropertyItem_icon_MESH_UVSPHERE = 289,
	EnumPropertyItem_icon_MESH_ICOSPHERE = 290,
	EnumPropertyItem_icon_MESH_GRID = 291,
	EnumPropertyItem_icon_MESH_MONKEY = 292,
	EnumPropertyItem_icon_MESH_CYLINDER = 293,
	EnumPropertyItem_icon_MESH_TORUS = 294,
	EnumPropertyItem_icon_MESH_CONE = 295,
	EnumPropertyItem_icon_LAMP_POINT = 298,
	EnumPropertyItem_icon_LAMP_SUN = 299,
	EnumPropertyItem_icon_LAMP_SPOT = 300,
	EnumPropertyItem_icon_LAMP_HEMI = 301,
	EnumPropertyItem_icon_LAMP_AREA = 302,
	EnumPropertyItem_icon_META_EMPTY = 305,
	EnumPropertyItem_icon_META_PLANE = 306,
	EnumPropertyItem_icon_META_CUBE = 307,
	EnumPropertyItem_icon_META_BALL = 308,
	EnumPropertyItem_icon_META_ELLIPSOID = 309,
	EnumPropertyItem_icon_META_CAPSULE = 310,
	EnumPropertyItem_icon_SURFACE_NCURVE = 312,
	EnumPropertyItem_icon_SURFACE_NCIRCLE = 313,
	EnumPropertyItem_icon_SURFACE_NSURFACE = 314,
	EnumPropertyItem_icon_SURFACE_NCYLINDER = 315,
	EnumPropertyItem_icon_SURFACE_NSPHERE = 316,
	EnumPropertyItem_icon_SURFACE_NTORUS = 317,
	EnumPropertyItem_icon_CURVE_BEZCURVE = 321,
	EnumPropertyItem_icon_CURVE_BEZCIRCLE = 322,
	EnumPropertyItem_icon_CURVE_NCURVE = 323,
	EnumPropertyItem_icon_CURVE_NCIRCLE = 324,
	EnumPropertyItem_icon_CURVE_PATH = 325,
	EnumPropertyItem_icon_COLOR_RED = 331,
	EnumPropertyItem_icon_COLOR_GREEN = 332,
	EnumPropertyItem_icon_COLOR_BLUE = 333,
	EnumPropertyItem_icon_TRIA_RIGHT_BAR = 334,
	EnumPropertyItem_icon_TRIA_DOWN_BAR = 335,
	EnumPropertyItem_icon_TRIA_LEFT_BAR = 336,
	EnumPropertyItem_icon_TRIA_UP_BAR = 337,
	EnumPropertyItem_icon_FORCE_FORCE = 338,
	EnumPropertyItem_icon_FORCE_WIND = 339,
	EnumPropertyItem_icon_FORCE_VORTEX = 340,
	EnumPropertyItem_icon_FORCE_MAGNETIC = 341,
	EnumPropertyItem_icon_FORCE_HARMONIC = 342,
	EnumPropertyItem_icon_FORCE_CHARGE = 343,
	EnumPropertyItem_icon_FORCE_LENNARDJONES = 344,
	EnumPropertyItem_icon_FORCE_TEXTURE = 345,
	EnumPropertyItem_icon_FORCE_CURVE = 346,
	EnumPropertyItem_icon_FORCE_BOID = 347,
	EnumPropertyItem_icon_FORCE_TURBULENCE = 348,
	EnumPropertyItem_icon_FORCE_DRAG = 349,
	EnumPropertyItem_icon_FORCE_SMOKEFLOW = 350,
	EnumPropertyItem_icon_MODIFIER = 442,
	EnumPropertyItem_icon_MOD_WAVE = 443,
	EnumPropertyItem_icon_MOD_BUILD = 444,
	EnumPropertyItem_icon_MOD_DECIM = 445,
	EnumPropertyItem_icon_MOD_MIRROR = 446,
	EnumPropertyItem_icon_MOD_SOFT = 447,
	EnumPropertyItem_icon_MOD_SUBSURF = 448,
	EnumPropertyItem_icon_HOOK = 449,
	EnumPropertyItem_icon_MOD_PHYSICS = 450,
	EnumPropertyItem_icon_MOD_PARTICLES = 451,
	EnumPropertyItem_icon_MOD_BOOLEAN = 452,
	EnumPropertyItem_icon_MOD_EDGESPLIT = 453,
	EnumPropertyItem_icon_MOD_ARRAY = 454,
	EnumPropertyItem_icon_MOD_UVPROJECT = 455,
	EnumPropertyItem_icon_MOD_DISPLACE = 456,
	EnumPropertyItem_icon_MOD_CURVE = 457,
	EnumPropertyItem_icon_MOD_LATTICE = 458,
	EnumPropertyItem_icon_CONSTRAINT_DATA = 459,
	EnumPropertyItem_icon_MOD_ARMATURE = 460,
	EnumPropertyItem_icon_MOD_SHRINKWRAP = 461,
	EnumPropertyItem_icon_MOD_CAST = 462,
	EnumPropertyItem_icon_MOD_MESHDEFORM = 463,
	EnumPropertyItem_icon_MOD_BEVEL = 464,
	EnumPropertyItem_icon_MOD_SMOOTH = 465,
	EnumPropertyItem_icon_MOD_SIMPLEDEFORM = 466,
	EnumPropertyItem_icon_MOD_MASK = 467,
	EnumPropertyItem_icon_MOD_CLOTH = 468,
	EnumPropertyItem_icon_MOD_EXPLODE = 469,
	EnumPropertyItem_icon_MOD_FLUIDSIM = 470,
	EnumPropertyItem_icon_MOD_MULTIRES = 471,
	EnumPropertyItem_icon_MOD_SMOKE = 472,
	EnumPropertyItem_icon_MOD_SOLIDIFY = 473,
	EnumPropertyItem_icon_MOD_SCREW = 474,
	EnumPropertyItem_icon_MOD_VERTEX_WEIGHT = 475,
	EnumPropertyItem_icon_MOD_DYNAMICPAINT = 476,
	EnumPropertyItem_icon_MOD_REMESH = 477,
	EnumPropertyItem_icon_MOD_OCEAN = 478,
	EnumPropertyItem_icon_MOD_WARP = 479,
	EnumPropertyItem_icon_MOD_SKIN = 480,
	EnumPropertyItem_icon_MOD_TRIANGULATE = 481,
	EnumPropertyItem_icon_MOD_WIREFRAME = 482,
	EnumPropertyItem_icon_REC = 494,
	EnumPropertyItem_icon_PLAY = 495,
	EnumPropertyItem_icon_FF = 496,
	EnumPropertyItem_icon_REW = 497,
	EnumPropertyItem_icon_PAUSE = 498,
	EnumPropertyItem_icon_PREV_KEYFRAME = 499,
	EnumPropertyItem_icon_NEXT_KEYFRAME = 500,
	EnumPropertyItem_icon_PLAY_AUDIO = 501,
	EnumPropertyItem_icon_PLAY_REVERSE = 502,
	EnumPropertyItem_icon_PREVIEW_RANGE = 503,
	EnumPropertyItem_icon_ACTION_TWEAK = 504,
	EnumPropertyItem_icon_PMARKER_ACT = 505,
	EnumPropertyItem_icon_PMARKER_SEL = 506,
	EnumPropertyItem_icon_PMARKER = 507,
	EnumPropertyItem_icon_MARKER_HLT = 508,
	EnumPropertyItem_icon_MARKER = 509,
	EnumPropertyItem_icon_SPACE2 = 510,
	EnumPropertyItem_icon_SPACE3 = 511,
	EnumPropertyItem_icon_KEYINGSET = 512,
	EnumPropertyItem_icon_KEY_DEHLT = 513,
	EnumPropertyItem_icon_KEY_HLT = 514,
	EnumPropertyItem_icon_MUTE_IPO_OFF = 515,
	EnumPropertyItem_icon_MUTE_IPO_ON = 516,
	EnumPropertyItem_icon_VISIBLE_IPO_OFF = 517,
	EnumPropertyItem_icon_VISIBLE_IPO_ON = 518,
	EnumPropertyItem_icon_DRIVER = 519,
	EnumPropertyItem_icon_SOLO_OFF = 520,
	EnumPropertyItem_icon_SOLO_ON = 521,
	EnumPropertyItem_icon_FRAME_PREV = 522,
	EnumPropertyItem_icon_FRAME_NEXT = 523,
	EnumPropertyItem_icon_NLA_PUSHDOWN = 524,
	EnumPropertyItem_icon_IPO_CONSTANT = 525,
	EnumPropertyItem_icon_IPO_LINEAR = 526,
	EnumPropertyItem_icon_IPO_BEZIER = 527,
	EnumPropertyItem_icon_IPO_SINE = 528,
	EnumPropertyItem_icon_IPO_QUAD = 529,
	EnumPropertyItem_icon_IPO_CUBIC = 530,
	EnumPropertyItem_icon_IPO_QUART = 531,
	EnumPropertyItem_icon_IPO_QUINT = 532,
	EnumPropertyItem_icon_IPO_EXPO = 533,
	EnumPropertyItem_icon_IPO_CIRC = 534,
	EnumPropertyItem_icon_IPO_BOUNCE = 535,
	EnumPropertyItem_icon_IPO_ELASTIC = 536,
	EnumPropertyItem_icon_IPO_BACK = 537,
	EnumPropertyItem_icon_IPO_EASE_IN = 538,
	EnumPropertyItem_icon_IPO_EASE_OUT = 539,
	EnumPropertyItem_icon_IPO_EASE_IN_OUT = 540,
	EnumPropertyItem_icon_VERTEXSEL = 546,
	EnumPropertyItem_icon_EDGESEL = 547,
	EnumPropertyItem_icon_FACESEL = 548,
	EnumPropertyItem_icon_LOOPSEL = 549,
	EnumPropertyItem_icon_ROTATE = 551,
	EnumPropertyItem_icon_CURSOR = 552,
	EnumPropertyItem_icon_ROTATECOLLECTION = 553,
	EnumPropertyItem_icon_ROTATECENTER = 554,
	EnumPropertyItem_icon_ROTACTIVE = 555,
	EnumPropertyItem_icon_ALIGN = 556,
	EnumPropertyItem_icon_SMOOTHCURVE = 558,
	EnumPropertyItem_icon_SPHERECURVE = 559,
	EnumPropertyItem_icon_ROOTCURVE = 560,
	EnumPropertyItem_icon_SHARPCURVE = 561,
	EnumPropertyItem_icon_LINCURVE = 562,
	EnumPropertyItem_icon_NOCURVE = 563,
	EnumPropertyItem_icon_RNDCURVE = 564,
	EnumPropertyItem_icon_PROP_OFF = 565,
	EnumPropertyItem_icon_PROP_ON = 566,
	EnumPropertyItem_icon_PROP_CON = 567,
	EnumPropertyItem_icon_SCULPT_DYNTOPO = 568,
	EnumPropertyItem_icon_PARTICLE_POINT = 569,
	EnumPropertyItem_icon_PARTICLE_TIP = 570,
	EnumPropertyItem_icon_PARTICLE_PATH = 571,
	EnumPropertyItem_icon_MAN_TRANS = 572,
	EnumPropertyItem_icon_MAN_ROT = 573,
	EnumPropertyItem_icon_MAN_SCALE = 574,
	EnumPropertyItem_icon_MANIPUL = 575,
	EnumPropertyItem_icon_SNAP_OFF = 576,
	EnumPropertyItem_icon_SNAP_ON = 577,
	EnumPropertyItem_icon_SNAP_NORMAL = 578,
	EnumPropertyItem_icon_SNAP_INCREMENT = 579,
	EnumPropertyItem_icon_SNAP_VERTEX = 580,
	EnumPropertyItem_icon_SNAP_EDGE = 581,
	EnumPropertyItem_icon_SNAP_FACE = 582,
	EnumPropertyItem_icon_SNAP_VOLUME = 583,
	EnumPropertyItem_icon_STICKY_UVS_LOC = 585,
	EnumPropertyItem_icon_STICKY_UVS_DISABLE = 586,
	EnumPropertyItem_icon_STICKY_UVS_VERT = 587,
	EnumPropertyItem_icon_CLIPUV_DEHLT = 588,
	EnumPropertyItem_icon_CLIPUV_HLT = 589,
	EnumPropertyItem_icon_SNAP_PEEL_OBJECT = 590,
	EnumPropertyItem_icon_GRID = 591,
	EnumPropertyItem_icon_PASTEDOWN = 598,
	EnumPropertyItem_icon_COPYDOWN = 599,
	EnumPropertyItem_icon_PASTEFLIPUP = 600,
	EnumPropertyItem_icon_PASTEFLIPDOWN = 601,
	EnumPropertyItem_icon_SNAP_SURFACE = 606,
	EnumPropertyItem_icon_AUTOMERGE_ON = 607,
	EnumPropertyItem_icon_AUTOMERGE_OFF = 608,
	EnumPropertyItem_icon_RETOPO = 609,
	EnumPropertyItem_icon_UV_VERTEXSEL = 610,
	EnumPropertyItem_icon_UV_EDGESEL = 611,
	EnumPropertyItem_icon_UV_FACESEL = 612,
	EnumPropertyItem_icon_UV_ISLANDSEL = 613,
	EnumPropertyItem_icon_UV_SYNC_SELECT = 614,
	EnumPropertyItem_icon_BBOX = 624,
	EnumPropertyItem_icon_WIRE = 625,
	EnumPropertyItem_icon_SOLID = 626,
	EnumPropertyItem_icon_SMOOTH = 627,
	EnumPropertyItem_icon_POTATO = 628,
	EnumPropertyItem_icon_ORTHO = 630,
	EnumPropertyItem_icon_LOCKVIEW_OFF = 633,
	EnumPropertyItem_icon_LOCKVIEW_ON = 634,
	EnumPropertyItem_icon_AXIS_SIDE = 636,
	EnumPropertyItem_icon_AXIS_FRONT = 637,
	EnumPropertyItem_icon_AXIS_TOP = 638,
	EnumPropertyItem_icon_NDOF_DOM = 639,
	EnumPropertyItem_icon_NDOF_TURN = 640,
	EnumPropertyItem_icon_NDOF_FLY = 641,
	EnumPropertyItem_icon_NDOF_TRANS = 642,
	EnumPropertyItem_icon_LAYER_USED = 643,
	EnumPropertyItem_icon_LAYER_ACTIVE = 644,
	EnumPropertyItem_icon_SORTALPHA = 676,
	EnumPropertyItem_icon_SORTBYEXT = 677,
	EnumPropertyItem_icon_SORTTIME = 678,
	EnumPropertyItem_icon_SORTSIZE = 679,
	EnumPropertyItem_icon_LONGDISPLAY = 680,
	EnumPropertyItem_icon_SHORTDISPLAY = 681,
	EnumPropertyItem_icon_GHOST = 682,
	EnumPropertyItem_icon_IMGDISPLAY = 683,
	EnumPropertyItem_icon_SAVE_AS = 684,
	EnumPropertyItem_icon_SAVE_COPY = 685,
	EnumPropertyItem_icon_BOOKMARKS = 686,
	EnumPropertyItem_icon_FONTPREVIEW = 687,
	EnumPropertyItem_icon_FILTER = 688,
	EnumPropertyItem_icon_NEWFOLDER = 689,
	EnumPropertyItem_icon_OPEN_RECENT = 690,
	EnumPropertyItem_icon_FILE_PARENT = 691,
	EnumPropertyItem_icon_FILE_REFRESH = 692,
	EnumPropertyItem_icon_FILE_FOLDER = 693,
	EnumPropertyItem_icon_FILE_BLANK = 694,
	EnumPropertyItem_icon_FILE_BLEND = 695,
	EnumPropertyItem_icon_FILE_IMAGE = 696,
	EnumPropertyItem_icon_FILE_MOVIE = 697,
	EnumPropertyItem_icon_FILE_SCRIPT = 698,
	EnumPropertyItem_icon_FILE_SOUND = 699,
	EnumPropertyItem_icon_FILE_FONT = 700,
	EnumPropertyItem_icon_FILE_TEXT = 701,
	EnumPropertyItem_icon_RECOVER_AUTO = 702,
	EnumPropertyItem_icon_SAVE_PREFS = 703,
	EnumPropertyItem_icon_LINK_BLEND = 704,
	EnumPropertyItem_icon_APPEND_BLEND = 705,
	EnumPropertyItem_icon_IMPORT = 706,
	EnumPropertyItem_icon_EXPORT = 707,
	EnumPropertyItem_icon_EXTERNAL_DATA = 708,
	EnumPropertyItem_icon_LOAD_FACTORY = 709,
	EnumPropertyItem_icon_LOOP_BACK = 715,
	EnumPropertyItem_icon_LOOP_FORWARDS = 716,
	EnumPropertyItem_icon_BACK = 717,
	EnumPropertyItem_icon_FORWARD = 718,
	EnumPropertyItem_icon_FILE_BACKUP = 726,
	EnumPropertyItem_icon_DISK_DRIVE = 727,
	EnumPropertyItem_icon_MATPLANE = 728,
	EnumPropertyItem_icon_MATSPHERE = 729,
	EnumPropertyItem_icon_MATCUBE = 730,
	EnumPropertyItem_icon_MONKEY = 731,
	EnumPropertyItem_icon_HAIR = 732,
	EnumPropertyItem_icon_ALIASED = 733,
	EnumPropertyItem_icon_ANTIALIASED = 734,
	EnumPropertyItem_icon_MAT_SPHERE_SKY = 735,
	EnumPropertyItem_icon_WORDWRAP_OFF = 740,
	EnumPropertyItem_icon_WORDWRAP_ON = 741,
	EnumPropertyItem_icon_SYNTAX_OFF = 742,
	EnumPropertyItem_icon_SYNTAX_ON = 743,
	EnumPropertyItem_icon_LINENUMBERS_OFF = 744,
	EnumPropertyItem_icon_LINENUMBERS_ON = 745,
	EnumPropertyItem_icon_SCRIPTPLUGINS = 746,
	EnumPropertyItem_icon_SEQ_SEQUENCER = 754,
	EnumPropertyItem_icon_SEQ_PREVIEW = 755,
	EnumPropertyItem_icon_SEQ_LUMA_WAVEFORM = 756,
	EnumPropertyItem_icon_SEQ_CHROMA_SCOPE = 757,
	EnumPropertyItem_icon_SEQ_HISTOGRAM = 758,
	EnumPropertyItem_icon_SEQ_SPLITVIEW = 759,
	EnumPropertyItem_icon_IMAGE_RGB = 763,
	EnumPropertyItem_icon_IMAGE_RGB_ALPHA = 764,
	EnumPropertyItem_icon_IMAGE_ALPHA = 765,
	EnumPropertyItem_icon_IMAGE_ZDEPTH = 766,
	EnumPropertyItem_icon_IMAGEFILE = 767,
	EnumPropertyItem_icon_BRUSH_ADD = 780,
	EnumPropertyItem_icon_BRUSH_BLOB = 781,
	EnumPropertyItem_icon_BRUSH_BLUR = 782,
	EnumPropertyItem_icon_BRUSH_CLAY = 783,
	EnumPropertyItem_icon_BRUSH_CLAY_STRIPS = 784,
	EnumPropertyItem_icon_BRUSH_CLONE = 785,
	EnumPropertyItem_icon_BRUSH_CREASE = 786,
	EnumPropertyItem_icon_BRUSH_DARKEN = 787,
	EnumPropertyItem_icon_BRUSH_FILL = 788,
	EnumPropertyItem_icon_BRUSH_FLATTEN = 789,
	EnumPropertyItem_icon_BRUSH_GRAB = 790,
	EnumPropertyItem_icon_BRUSH_INFLATE = 791,
	EnumPropertyItem_icon_BRUSH_LAYER = 792,
	EnumPropertyItem_icon_BRUSH_LIGHTEN = 793,
	EnumPropertyItem_icon_BRUSH_MASK = 794,
	EnumPropertyItem_icon_BRUSH_MIX = 795,
	EnumPropertyItem_icon_BRUSH_MULTIPLY = 796,
	EnumPropertyItem_icon_BRUSH_NUDGE = 797,
	EnumPropertyItem_icon_BRUSH_PINCH = 798,
	EnumPropertyItem_icon_BRUSH_SCRAPE = 799,
	EnumPropertyItem_icon_BRUSH_SCULPT_DRAW = 800,
	EnumPropertyItem_icon_BRUSH_SMEAR = 801,
	EnumPropertyItem_icon_BRUSH_SMOOTH = 802,
	EnumPropertyItem_icon_BRUSH_SNAKE_HOOK = 803,
	EnumPropertyItem_icon_BRUSH_SOFTEN = 804,
	EnumPropertyItem_icon_BRUSH_SUBTRACT = 805,
	EnumPropertyItem_icon_BRUSH_TEXDRAW = 806,
	EnumPropertyItem_icon_BRUSH_TEXFILL = 807,
	EnumPropertyItem_icon_BRUSH_TEXMASK = 808,
	EnumPropertyItem_icon_BRUSH_THUMB = 809,
	EnumPropertyItem_icon_BRUSH_ROTATE = 810,
	EnumPropertyItem_icon_BRUSH_VERTEXDRAW = 811,
	EnumPropertyItem_icon_MATCAP_01 = 812,
	EnumPropertyItem_icon_MATCAP_02 = 813,
	EnumPropertyItem_icon_MATCAP_03 = 814,
	EnumPropertyItem_icon_MATCAP_04 = 815,
	EnumPropertyItem_icon_MATCAP_05 = 816,
	EnumPropertyItem_icon_MATCAP_06 = 817,
	EnumPropertyItem_icon_MATCAP_07 = 818,
	EnumPropertyItem_icon_MATCAP_08 = 819,
	EnumPropertyItem_icon_MATCAP_09 = 820,
	EnumPropertyItem_icon_MATCAP_10 = 821,
	EnumPropertyItem_icon_MATCAP_11 = 822,
	EnumPropertyItem_icon_MATCAP_12 = 823,
	EnumPropertyItem_icon_MATCAP_13 = 824,
	EnumPropertyItem_icon_MATCAP_14 = 825,
	EnumPropertyItem_icon_MATCAP_15 = 826,
	EnumPropertyItem_icon_MATCAP_16 = 827,
	EnumPropertyItem_icon_MATCAP_17 = 828,
	EnumPropertyItem_icon_MATCAP_18 = 829,
	EnumPropertyItem_icon_MATCAP_19 = 830,
	EnumPropertyItem_icon_MATCAP_20 = 831,
	EnumPropertyItem_icon_MATCAP_21 = 832,
	EnumPropertyItem_icon_MATCAP_22 = 833,
	EnumPropertyItem_icon_MATCAP_23 = 834,
	EnumPropertyItem_icon_MATCAP_24 = 835,
	EnumPropertyItem_icon_VIEW3D_VEC = 836,
	EnumPropertyItem_icon_EDIT_VEC = 837,
	EnumPropertyItem_icon_EDITMODE_VEC_DEHLT = 838,
	EnumPropertyItem_icon_EDITMODE_VEC_HLT = 839,
	EnumPropertyItem_icon_DISCLOSURE_TRI_RIGHT_VEC = 840,
	EnumPropertyItem_icon_DISCLOSURE_TRI_DOWN_VEC = 841,
	EnumPropertyItem_icon_MOVE_UP_VEC = 842,
	EnumPropertyItem_icon_MOVE_DOWN_VEC = 843,
	EnumPropertyItem_icon_X_VEC = 844,
	EnumPropertyItem_icon_SMALL_TRI_RIGHT_VEC = 845,
};

int EnumPropertyItem_icon_get(PointerRNA *ptr);
void EnumPropertyItem_icon_set(PointerRNA *ptr, int value);

void EnumPropertyItem_identifier_get(PointerRNA *ptr, char *value);
int EnumPropertyItem_identifier_length(PointerRNA *ptr);
void EnumPropertyItem_identifier_set(PointerRNA *ptr, const char *value);

int EnumPropertyItem_value_get(PointerRNA *ptr);
void EnumPropertyItem_value_set(PointerRNA *ptr, int value);

/**************** EnvironmentMap ****************/

extern StructRNA RNA_EnvironmentMap;

PointerRNA EnvironmentMap_rna_type_get(PointerRNA *ptr);

float EnvironmentMap_clip_end_get(PointerRNA *ptr);
void EnvironmentMap_clip_end_set(PointerRNA *ptr, float value);

float EnvironmentMap_clip_start_get(PointerRNA *ptr);
void EnvironmentMap_clip_start_set(PointerRNA *ptr, float value);

int EnvironmentMap_depth_get(PointerRNA *ptr);
void EnvironmentMap_depth_set(PointerRNA *ptr, int value);

void EnvironmentMap_layers_ignore_get(PointerRNA *ptr, int values[20]);
void EnvironmentMap_layers_ignore_set(PointerRNA *ptr, const int values[20]);

enum {
	EnvironmentMap_mapping_CUBE = 0,
	EnvironmentMap_mapping_PLANE = 1,
};

int EnvironmentMap_mapping_get(PointerRNA *ptr);
void EnvironmentMap_mapping_set(PointerRNA *ptr, int value);

int EnvironmentMap_resolution_get(PointerRNA *ptr);
void EnvironmentMap_resolution_set(PointerRNA *ptr, int value);

enum {
	EnvironmentMap_source_STATIC = 0,
	EnvironmentMap_source_ANIMATED = 1,
	EnvironmentMap_source_IMAGE_FILE = 2,
};

int EnvironmentMap_source_get(PointerRNA *ptr);
void EnvironmentMap_source_set(PointerRNA *ptr, int value);

int EnvironmentMap_is_valid_get(PointerRNA *ptr);
void EnvironmentMap_is_valid_set(PointerRNA *ptr, int value);

PointerRNA EnvironmentMap_viewpoint_object_get(PointerRNA *ptr);

float EnvironmentMap_zoom_get(PointerRNA *ptr);
void EnvironmentMap_zoom_set(PointerRNA *ptr, float value);

void EnvironmentMap_clear(struct EnvMap *_self, bContext *C);
void EnvironmentMap_save(struct EnvMap *_self, bContext *C, ReportList *reports, const char * filepath, struct Scene *scene, float layout[12]);
/**************** Environment Map ****************/

extern StructRNA RNA_EnvironmentMapTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

PointerRNA EnvironmentMapTexture_environment_map_get(PointerRNA *ptr);

enum {
	EnvironmentMapTexture_filter_type_BOX = 0,
	EnvironmentMapTexture_filter_type_EWA = 1,
	EnvironmentMapTexture_filter_type_FELINE = 2,
	EnvironmentMapTexture_filter_type_AREA = 3,
};

int EnvironmentMapTexture_filter_type_get(PointerRNA *ptr);
void EnvironmentMapTexture_filter_type_set(PointerRNA *ptr, int value);

int EnvironmentMapTexture_filter_eccentricity_get(PointerRNA *ptr);
void EnvironmentMapTexture_filter_eccentricity_set(PointerRNA *ptr, int value);

int EnvironmentMapTexture_filter_probes_get(PointerRNA *ptr);
void EnvironmentMapTexture_filter_probes_set(PointerRNA *ptr, int value);

float EnvironmentMapTexture_filter_size_get(PointerRNA *ptr);
void EnvironmentMapTexture_filter_size_set(PointerRNA *ptr, float value);

PointerRNA EnvironmentMapTexture_image_get(PointerRNA *ptr);

PointerRNA EnvironmentMapTexture_image_user_get(PointerRNA *ptr);

int EnvironmentMapTexture_use_mipmap_get(PointerRNA *ptr);
void EnvironmentMapTexture_use_mipmap_set(PointerRNA *ptr, int value);

int EnvironmentMapTexture_use_mipmap_gauss_get(PointerRNA *ptr);
void EnvironmentMapTexture_use_mipmap_gauss_set(PointerRNA *ptr, int value);

int EnvironmentMapTexture_use_filter_size_min_get(PointerRNA *ptr);
void EnvironmentMapTexture_use_filter_size_min_set(PointerRNA *ptr, int value);

/**************** Event ****************/

extern StructRNA RNA_Event;

PointerRNA Event_rna_type_get(PointerRNA *ptr);

void Event_ascii_get(PointerRNA *ptr, char *value);
int Event_ascii_length(PointerRNA *ptr);
void Event_ascii_set(PointerRNA *ptr, const char *value);

int Event_alt_get(PointerRNA *ptr);
void Event_alt_set(PointerRNA *ptr, int value);

int Event_ctrl_get(PointerRNA *ptr);
void Event_ctrl_set(PointerRNA *ptr, int value);

int Event_mouse_prev_x_get(PointerRNA *ptr);
void Event_mouse_prev_x_set(PointerRNA *ptr, int value);

int Event_mouse_prev_y_get(PointerRNA *ptr);
void Event_mouse_prev_y_set(PointerRNA *ptr, int value);

int Event_mouse_x_get(PointerRNA *ptr);
void Event_mouse_x_set(PointerRNA *ptr, int value);

int Event_mouse_region_x_get(PointerRNA *ptr);
void Event_mouse_region_x_set(PointerRNA *ptr, int value);

int Event_mouse_y_get(PointerRNA *ptr);
void Event_mouse_y_set(PointerRNA *ptr, int value);

int Event_mouse_region_y_get(PointerRNA *ptr);
void Event_mouse_region_y_set(PointerRNA *ptr, int value);

int Event_oskey_get(PointerRNA *ptr);
void Event_oskey_set(PointerRNA *ptr, int value);

int Event_shift_get(PointerRNA *ptr);
void Event_shift_set(PointerRNA *ptr, int value);

float Event_pressure_get(PointerRNA *ptr);
void Event_pressure_set(PointerRNA *ptr, float value);

int Event_is_tablet_get(PointerRNA *ptr);
void Event_is_tablet_set(PointerRNA *ptr, int value);

void Event_tilt_get(PointerRNA *ptr, float values[2]);
void Event_tilt_set(PointerRNA *ptr, const float values[2]);

enum {
	Event_type_NONE = 0,
	Event_type_LEFTMOUSE = 1,
	Event_type_MIDDLEMOUSE = 2,
	Event_type_RIGHTMOUSE = 3,
	Event_type_BUTTON4MOUSE = 7,
	Event_type_BUTTON5MOUSE = 8,
	Event_type_BUTTON6MOUSE = 18,
	Event_type_BUTTON7MOUSE = 19,
	Event_type_ACTIONMOUSE = 5,
	Event_type_SELECTMOUSE = 6,
	Event_type_MOUSEMOVE = 4,
	Event_type_INBETWEEN_MOUSEMOVE = 17,
	Event_type_TRACKPADPAN = 14,
	Event_type_TRACKPADZOOM = 15,
	Event_type_MOUSEROTATE = 16,
	Event_type_WHEELUPMOUSE = 10,
	Event_type_WHEELDOWNMOUSE = 11,
	Event_type_WHEELINMOUSE = 12,
	Event_type_WHEELOUTMOUSE = 13,
	Event_type_EVT_TWEAK_L = 20483,
	Event_type_EVT_TWEAK_M = 20484,
	Event_type_EVT_TWEAK_R = 20485,
	Event_type_EVT_TWEAK_A = 20486,
	Event_type_EVT_TWEAK_S = 20487,
	Event_type_A = 97,
	Event_type_B = 98,
	Event_type_C = 99,
	Event_type_D = 100,
	Event_type_E = 101,
	Event_type_F = 102,
	Event_type_G = 103,
	Event_type_H = 104,
	Event_type_I = 105,
	Event_type_J = 106,
	Event_type_K = 107,
	Event_type_L = 108,
	Event_type_M = 109,
	Event_type_N = 110,
	Event_type_O = 111,
	Event_type_P = 112,
	Event_type_Q = 113,
	Event_type_R = 114,
	Event_type_S = 115,
	Event_type_T = 116,
	Event_type_U = 117,
	Event_type_V = 118,
	Event_type_W = 119,
	Event_type_X = 120,
	Event_type_Y = 121,
	Event_type_Z = 122,
	Event_type_ZERO = 48,
	Event_type_ONE = 49,
	Event_type_TWO = 50,
	Event_type_THREE = 51,
	Event_type_FOUR = 52,
	Event_type_FIVE = 53,
	Event_type_SIX = 54,
	Event_type_SEVEN = 55,
	Event_type_EIGHT = 56,
	Event_type_NINE = 57,
	Event_type_LEFT_CTRL = 212,
	Event_type_LEFT_ALT = 213,
	Event_type_LEFT_SHIFT = 217,
	Event_type_RIGHT_ALT = 214,
	Event_type_RIGHT_CTRL = 215,
	Event_type_RIGHT_SHIFT = 216,
	Event_type_OSKEY = 172,
	Event_type_GRLESS = 173,
	Event_type_ESC = 218,
	Event_type_TAB = 219,
	Event_type_RET = 220,
	Event_type_SPACE = 221,
	Event_type_LINE_FEED = 222,
	Event_type_BACK_SPACE = 223,
	Event_type_DEL = 224,
	Event_type_SEMI_COLON = 225,
	Event_type_PERIOD = 226,
	Event_type_COMMA = 227,
	Event_type_QUOTE = 228,
	Event_type_ACCENT_GRAVE = 229,
	Event_type_MINUS = 230,
	Event_type_SLASH = 232,
	Event_type_BACK_SLASH = 233,
	Event_type_EQUAL = 234,
	Event_type_LEFT_BRACKET = 235,
	Event_type_RIGHT_BRACKET = 236,
	Event_type_LEFT_ARROW = 137,
	Event_type_DOWN_ARROW = 138,
	Event_type_RIGHT_ARROW = 139,
	Event_type_UP_ARROW = 140,
	Event_type_NUMPAD_2 = 152,
	Event_type_NUMPAD_4 = 154,
	Event_type_NUMPAD_6 = 156,
	Event_type_NUMPAD_8 = 158,
	Event_type_NUMPAD_1 = 151,
	Event_type_NUMPAD_3 = 153,
	Event_type_NUMPAD_5 = 155,
	Event_type_NUMPAD_7 = 157,
	Event_type_NUMPAD_9 = 159,
	Event_type_NUMPAD_PERIOD = 199,
	Event_type_NUMPAD_SLASH = 161,
	Event_type_NUMPAD_ASTERIX = 160,
	Event_type_NUMPAD_0 = 150,
	Event_type_NUMPAD_MINUS = 162,
	Event_type_NUMPAD_ENTER = 163,
	Event_type_NUMPAD_PLUS = 164,
	Event_type_F1 = 300,
	Event_type_F2 = 301,
	Event_type_F3 = 302,
	Event_type_F4 = 303,
	Event_type_F5 = 304,
	Event_type_F6 = 305,
	Event_type_F7 = 306,
	Event_type_F8 = 307,
	Event_type_F9 = 308,
	Event_type_F10 = 309,
	Event_type_F11 = 310,
	Event_type_F12 = 311,
	Event_type_F13 = 312,
	Event_type_F14 = 313,
	Event_type_F15 = 314,
	Event_type_F16 = 315,
	Event_type_F17 = 316,
	Event_type_F18 = 317,
	Event_type_F19 = 318,
	Event_type_PAUSE = 165,
	Event_type_INSERT = 166,
	Event_type_HOME = 167,
	Event_type_PAGE_UP = 168,
	Event_type_PAGE_DOWN = 169,
	Event_type_END = 170,
	Event_type_MEDIA_PLAY = 174,
	Event_type_MEDIA_STOP = 175,
	Event_type_MEDIA_FIRST = 176,
	Event_type_MEDIA_LAST = 177,
	Event_type_TEXTINPUT = -2,
	Event_type_WINDOW_DEACTIVATE = 260,
	Event_type_TIMER = 272,
	Event_type_TIMER0 = 273,
	Event_type_TIMER1 = 274,
	Event_type_TIMER2 = 275,
	Event_type_TIMER_JOBS = 276,
	Event_type_TIMER_AUTOSAVE = 277,
	Event_type_TIMER_REPORT = 278,
	Event_type_TIMERREGION = 279,
	Event_type_NDOF_MOTION = 400,
	Event_type_NDOF_BUTTON_MENU = 401,
	Event_type_NDOF_BUTTON_FIT = 402,
	Event_type_NDOF_BUTTON_TOP = 403,
	Event_type_NDOF_BUTTON_BOTTOM = 404,
	Event_type_NDOF_BUTTON_LEFT = 405,
	Event_type_NDOF_BUTTON_RIGHT = 406,
	Event_type_NDOF_BUTTON_FRONT = 407,
	Event_type_NDOF_BUTTON_BACK = 408,
	Event_type_NDOF_BUTTON_ISO1 = 409,
	Event_type_NDOF_BUTTON_ISO2 = 410,
	Event_type_NDOF_BUTTON_ROLL_CW = 411,
	Event_type_NDOF_BUTTON_ROLL_CCW = 412,
	Event_type_NDOF_BUTTON_SPIN_CW = 413,
	Event_type_NDOF_BUTTON_SPIN_CCW = 414,
	Event_type_NDOF_BUTTON_TILT_CW = 415,
	Event_type_NDOF_BUTTON_TILT_CCW = 416,
	Event_type_NDOF_BUTTON_ROTATE = 417,
	Event_type_NDOF_BUTTON_PANZOOM = 418,
	Event_type_NDOF_BUTTON_DOMINANT = 419,
	Event_type_NDOF_BUTTON_PLUS = 420,
	Event_type_NDOF_BUTTON_MINUS = 421,
	Event_type_NDOF_BUTTON_ESC = 422,
	Event_type_NDOF_BUTTON_ALT = 423,
	Event_type_NDOF_BUTTON_SHIFT = 424,
	Event_type_NDOF_BUTTON_CTRL = 425,
	Event_type_NDOF_BUTTON_1 = 426,
	Event_type_NDOF_BUTTON_2 = 427,
	Event_type_NDOF_BUTTON_3 = 428,
	Event_type_NDOF_BUTTON_4 = 429,
	Event_type_NDOF_BUTTON_5 = 430,
	Event_type_NDOF_BUTTON_6 = 431,
	Event_type_NDOF_BUTTON_7 = 432,
	Event_type_NDOF_BUTTON_8 = 433,
	Event_type_NDOF_BUTTON_9 = 434,
	Event_type_NDOF_BUTTON_10 = 435,
	Event_type_NDOF_BUTTON_A = 436,
	Event_type_NDOF_BUTTON_B = 437,
	Event_type_NDOF_BUTTON_C = 438,
};

int Event_type_get(PointerRNA *ptr);
void Event_type_set(PointerRNA *ptr, int value);

void Event_unicode_get(PointerRNA *ptr, char *value);
int Event_unicode_length(PointerRNA *ptr);
void Event_unicode_set(PointerRNA *ptr, const char *value);

enum {
	Event_value_ANY = -1,
	Event_value_NOTHING = 0,
	Event_value_PRESS = 1,
	Event_value_RELEASE = 2,
	Event_value_CLICK = 3,
	Event_value_DOUBLE_CLICK = 4,
	Event_value_NORTH = 1,
	Event_value_NORTH_EAST = 2,
	Event_value_EAST = 3,
	Event_value_SOUTH_EAST = 4,
	Event_value_SOUTH = 5,
	Event_value_SOUTH_WEST = 6,
	Event_value_WEST = 7,
	Event_value_NORTH_WEST = 8,
};

int Event_value_get(PointerRNA *ptr);
void Event_value_set(PointerRNA *ptr, int value);

/**************** Explode Modifier ****************/

extern StructRNA RNA_ExplodeModifier;
extern StructRNA RNA_Modifier;

int ExplodeModifier_show_alive_get(PointerRNA *ptr);
void ExplodeModifier_show_alive_set(PointerRNA *ptr, int value);

int ExplodeModifier_use_edge_cut_get(PointerRNA *ptr);
void ExplodeModifier_use_edge_cut_set(PointerRNA *ptr, int value);

int ExplodeModifier_show_dead_get(PointerRNA *ptr);
void ExplodeModifier_show_dead_set(PointerRNA *ptr, int value);

#define ExplodeModifier_particle_uv_MAX 64

void ExplodeModifier_particle_uv_get(PointerRNA *ptr, char *value);
int ExplodeModifier_particle_uv_length(PointerRNA *ptr);
void ExplodeModifier_particle_uv_set(PointerRNA *ptr, const char *value);

float ExplodeModifier_protect_get(PointerRNA *ptr);
void ExplodeModifier_protect_set(PointerRNA *ptr, float value);

int ExplodeModifier_use_size_get(PointerRNA *ptr);
void ExplodeModifier_use_size_set(PointerRNA *ptr, int value);

int ExplodeModifier_show_unborn_get(PointerRNA *ptr);
void ExplodeModifier_show_unborn_set(PointerRNA *ptr, int value);

void ExplodeModifier_vertex_group_get(PointerRNA *ptr, char *value);
int ExplodeModifier_vertex_group_length(PointerRNA *ptr);
void ExplodeModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Expression Controller ****************/

extern StructRNA RNA_ExpressionController;
extern StructRNA RNA_Controller;

#define ExpressionController_expression_MAX 128

void ExpressionController_expression_get(PointerRNA *ptr, char *value);
int ExpressionController_expression_length(PointerRNA *ptr);
void ExpressionController_expression_set(PointerRNA *ptr, const char *value);

/**************** F-Curve ****************/

extern StructRNA RNA_FCurve;

PointerRNA FCurve_rna_type_get(PointerRNA *ptr);

void FCurve_color_get(PointerRNA *ptr, float values[3]);
void FCurve_color_set(PointerRNA *ptr, const float values[3]);

enum {
	FCurve_color_mode_AUTO_RAINBOW = 0,
	FCurve_color_mode_AUTO_RGB = 1,
	FCurve_color_mode_CUSTOM = 2,
};

int FCurve_color_mode_get(PointerRNA *ptr);
void FCurve_color_mode_set(PointerRNA *ptr, int value);

void FCurve_data_path_get(PointerRNA *ptr, char *value);
int FCurve_data_path_length(PointerRNA *ptr);
void FCurve_data_path_set(PointerRNA *ptr, const char *value);

PointerRNA FCurve_driver_get(PointerRNA *ptr);

enum {
	FCurve_extrapolation_CONSTANT = 0,
	FCurve_extrapolation_LINEAR = 1,
};

int FCurve_extrapolation_get(PointerRNA *ptr);
void FCurve_extrapolation_set(PointerRNA *ptr, int value);

PointerRNA FCurve_group_get(PointerRNA *ptr);

int FCurve_hide_get(PointerRNA *ptr);
void FCurve_hide_set(PointerRNA *ptr, int value);

void FCurve_keyframe_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FCurve_keyframe_points_next(CollectionPropertyIterator *iter);
void FCurve_keyframe_points_end(CollectionPropertyIterator *iter);
int FCurve_keyframe_points_length(PointerRNA *ptr);
int FCurve_keyframe_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int FCurve_lock_get(PointerRNA *ptr);
void FCurve_lock_set(PointerRNA *ptr, int value);

void FCurve_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FCurve_modifiers_next(CollectionPropertyIterator *iter);
void FCurve_modifiers_end(CollectionPropertyIterator *iter);
int FCurve_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int FCurve_mute_get(PointerRNA *ptr);
void FCurve_mute_set(PointerRNA *ptr, int value);

int FCurve_array_index_get(PointerRNA *ptr);
void FCurve_array_index_set(PointerRNA *ptr, int value);

void FCurve_sampled_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FCurve_sampled_points_next(CollectionPropertyIterator *iter);
void FCurve_sampled_points_end(CollectionPropertyIterator *iter);
int FCurve_sampled_points_length(PointerRNA *ptr);
int FCurve_sampled_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int FCurve_select_get(PointerRNA *ptr);
void FCurve_select_set(PointerRNA *ptr, int value);

int FCurve_is_valid_get(PointerRNA *ptr);
void FCurve_is_valid_set(PointerRNA *ptr, int value);

float FCurve_evaluate(struct FCurve *_self, float frame);
void FCurve_update(struct FCurve *_self);
void FCurve_range(struct FCurve *_self, float range[2]);
void FCurve_update_autoflags(struct FCurve *_self, bContext *C, ReportList *reports, struct PointerRNA *data);
/**************** Keyframe Points ****************/

extern StructRNA RNA_FCurveKeyframePoints;

PointerRNA FCurveKeyframePoints_rna_type_get(PointerRNA *ptr);

struct BezTriple *FCurveKeyframePoints_insert(struct FCurve *_self, float frame, float value, int options);
void FCurveKeyframePoints_add(struct FCurve *_self, int count);
void FCurveKeyframePoints_remove(struct FCurve *_self, ReportList *reports, struct PointerRNA *keyframe, int fast);
/**************** F-Curve Modifiers ****************/

extern StructRNA RNA_FCurveModifiers;

PointerRNA FCurveModifiers_rna_type_get(PointerRNA *ptr);

PointerRNA FCurveModifiers_active_get(PointerRNA *ptr);

struct FModifier *FCurveModifiers_new(struct FCurve *_self, int type);
void FCurveModifiers_remove(struct FCurve *_self, ReportList *reports, struct PointerRNA *modifier);
/**************** F-Curve Sample ****************/

extern StructRNA RNA_FCurveSample;

PointerRNA FCurveSample_rna_type_get(PointerRNA *ptr);

void FCurveSample_co_get(PointerRNA *ptr, float values[2]);
void FCurveSample_co_set(PointerRNA *ptr, const float values[2]);

int FCurveSample_select_get(PointerRNA *ptr);
void FCurveSample_select_set(PointerRNA *ptr, int value);

/**************** FFmpeg Settings ****************/

extern StructRNA RNA_FFmpegSettings;

PointerRNA FFmpegSettings_rna_type_get(PointerRNA *ptr);

enum {
	FFmpegSettings_audio_channels_MONO = 1,
	FFmpegSettings_audio_channels_STEREO = 2,
	FFmpegSettings_audio_channels_SURROUND4 = 4,
	FFmpegSettings_audio_channels_SURROUND51 = 6,
	FFmpegSettings_audio_channels_SURROUND71 = 8,
};

int FFmpegSettings_audio_channels_get(PointerRNA *ptr);
void FFmpegSettings_audio_channels_set(PointerRNA *ptr, int value);

int FFmpegSettings_audio_mixrate_get(PointerRNA *ptr);
void FFmpegSettings_audio_mixrate_set(PointerRNA *ptr, int value);

/**************** F-Modifier ****************/

extern StructRNA RNA_FModifier;

PointerRNA FModifier_rna_type_get(PointerRNA *ptr);

int FModifier_active_get(PointerRNA *ptr);
void FModifier_active_set(PointerRNA *ptr, int value);

float FModifier_blend_in_get(PointerRNA *ptr);
void FModifier_blend_in_set(PointerRNA *ptr, float value);

float FModifier_blend_out_get(PointerRNA *ptr);
void FModifier_blend_out_set(PointerRNA *ptr, float value);

int FModifier_is_valid_get(PointerRNA *ptr);
void FModifier_is_valid_set(PointerRNA *ptr, int value);

float FModifier_frame_end_get(PointerRNA *ptr);
void FModifier_frame_end_set(PointerRNA *ptr, float value);

int FModifier_show_expanded_get(PointerRNA *ptr);
void FModifier_show_expanded_set(PointerRNA *ptr, int value);

float FModifier_influence_get(PointerRNA *ptr);
void FModifier_influence_set(PointerRNA *ptr, float value);

int FModifier_mute_get(PointerRNA *ptr);
void FModifier_mute_set(PointerRNA *ptr, int value);

int FModifier_use_restricted_range_get(PointerRNA *ptr);
void FModifier_use_restricted_range_set(PointerRNA *ptr, int value);

float FModifier_frame_start_get(PointerRNA *ptr);
void FModifier_frame_start_set(PointerRNA *ptr, float value);

enum {
	FModifier_type_NULL = 0,
	FModifier_type_GENERATOR = 1,
	FModifier_type_FNGENERATOR = 2,
	FModifier_type_ENVELOPE = 3,
	FModifier_type_CYCLES = 4,
	FModifier_type_NOISE = 5,
	FModifier_type_PYTHON = 7,
	FModifier_type_LIMITS = 8,
	FModifier_type_STEPPED = 9,
};

int FModifier_type_get(PointerRNA *ptr);
void FModifier_type_set(PointerRNA *ptr, int value);

int FModifier_use_influence_get(PointerRNA *ptr);
void FModifier_use_influence_set(PointerRNA *ptr, int value);

/**************** Cycles F-Modifier ****************/

extern StructRNA RNA_FModifierCycles;
extern StructRNA RNA_FModifier;

int FModifierCycles_cycles_after_get(PointerRNA *ptr);
void FModifierCycles_cycles_after_set(PointerRNA *ptr, int value);

enum {
	FModifierCycles_mode_after_NONE = 0,
	FModifierCycles_mode_after_REPEAT = 1,
	FModifierCycles_mode_after_REPEAT_OFFSET = 2,
	FModifierCycles_mode_after_MIRROR = 3,
};

int FModifierCycles_mode_after_get(PointerRNA *ptr);
void FModifierCycles_mode_after_set(PointerRNA *ptr, int value);

int FModifierCycles_cycles_before_get(PointerRNA *ptr);
void FModifierCycles_cycles_before_set(PointerRNA *ptr, int value);

enum {
	FModifierCycles_mode_before_NONE = 0,
	FModifierCycles_mode_before_REPEAT = 1,
	FModifierCycles_mode_before_REPEAT_OFFSET = 2,
	FModifierCycles_mode_before_MIRROR = 3,
};

int FModifierCycles_mode_before_get(PointerRNA *ptr);
void FModifierCycles_mode_before_set(PointerRNA *ptr, int value);

/**************** Envelope F-Modifier ****************/

extern StructRNA RNA_FModifierEnvelope;
extern StructRNA RNA_FModifier;

void FModifierEnvelope_control_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FModifierEnvelope_control_points_next(CollectionPropertyIterator *iter);
void FModifierEnvelope_control_points_end(CollectionPropertyIterator *iter);
int FModifierEnvelope_control_points_length(PointerRNA *ptr);
int FModifierEnvelope_control_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

float FModifierEnvelope_default_max_get(PointerRNA *ptr);
void FModifierEnvelope_default_max_set(PointerRNA *ptr, float value);

float FModifierEnvelope_default_min_get(PointerRNA *ptr);
void FModifierEnvelope_default_min_set(PointerRNA *ptr, float value);

float FModifierEnvelope_reference_value_get(PointerRNA *ptr);
void FModifierEnvelope_reference_value_set(PointerRNA *ptr, float value);

/**************** Envelope Control Point ****************/

extern StructRNA RNA_FModifierEnvelopeControlPoint;

PointerRNA FModifierEnvelopeControlPoint_rna_type_get(PointerRNA *ptr);

float FModifierEnvelopeControlPoint_frame_get(PointerRNA *ptr);
void FModifierEnvelopeControlPoint_frame_set(PointerRNA *ptr, float value);

float FModifierEnvelopeControlPoint_max_get(PointerRNA *ptr);
void FModifierEnvelopeControlPoint_max_set(PointerRNA *ptr, float value);

float FModifierEnvelopeControlPoint_min_get(PointerRNA *ptr);
void FModifierEnvelopeControlPoint_min_set(PointerRNA *ptr, float value);

/**************** Control Points ****************/

extern StructRNA RNA_FModifierEnvelopeControlPoints;

PointerRNA FModifierEnvelopeControlPoints_rna_type_get(PointerRNA *ptr);

struct FCM_EnvelopeData *FModifierEnvelopeControlPoints_add(struct FModifier *_self, ReportList *reports, float frame);
void FModifierEnvelopeControlPoints_remove(struct FModifier *_self, ReportList *reports, struct PointerRNA *point);
/**************** Built-In Function F-Modifier ****************/

extern StructRNA RNA_FModifierFunctionGenerator;
extern StructRNA RNA_FModifier;

int FModifierFunctionGenerator_use_additive_get(PointerRNA *ptr);
void FModifierFunctionGenerator_use_additive_set(PointerRNA *ptr, int value);

float FModifierFunctionGenerator_amplitude_get(PointerRNA *ptr);
void FModifierFunctionGenerator_amplitude_set(PointerRNA *ptr, float value);

float FModifierFunctionGenerator_phase_multiplier_get(PointerRNA *ptr);
void FModifierFunctionGenerator_phase_multiplier_set(PointerRNA *ptr, float value);

float FModifierFunctionGenerator_phase_offset_get(PointerRNA *ptr);
void FModifierFunctionGenerator_phase_offset_set(PointerRNA *ptr, float value);

enum {
	FModifierFunctionGenerator_function_type_SIN = 0,
	FModifierFunctionGenerator_function_type_COS = 1,
	FModifierFunctionGenerator_function_type_TAN = 2,
	FModifierFunctionGenerator_function_type_SQRT = 3,
	FModifierFunctionGenerator_function_type_LN = 4,
	FModifierFunctionGenerator_function_type_SINC = 5,
};

int FModifierFunctionGenerator_function_type_get(PointerRNA *ptr);
void FModifierFunctionGenerator_function_type_set(PointerRNA *ptr, int value);

float FModifierFunctionGenerator_value_offset_get(PointerRNA *ptr);
void FModifierFunctionGenerator_value_offset_set(PointerRNA *ptr, float value);

/**************** Generator F-Modifier ****************/

extern StructRNA RNA_FModifierGenerator;
extern StructRNA RNA_FModifier;

int FModifierGenerator_use_additive_get(PointerRNA *ptr);
void FModifierGenerator_use_additive_set(PointerRNA *ptr, int value);

void FModifierGenerator_coefficients_get(PointerRNA *ptr, float values[32]);
void FModifierGenerator_coefficients_set(PointerRNA *ptr, const float values[32]);
int FModifierGenerator_coefficients_get_length(PointerRNA *ptr, int *arraylen);

enum {
	FModifierGenerator_mode_POLYNOMIAL = 0,
	FModifierGenerator_mode_POLYNOMIAL_FACTORISED = 1,
};

int FModifierGenerator_mode_get(PointerRNA *ptr);
void FModifierGenerator_mode_set(PointerRNA *ptr, int value);

int FModifierGenerator_poly_order_get(PointerRNA *ptr);
void FModifierGenerator_poly_order_set(PointerRNA *ptr, int value);

/**************** Limit F-Modifier ****************/

extern StructRNA RNA_FModifierLimits;
extern StructRNA RNA_FModifier;

int FModifierLimits_use_max_x_get(PointerRNA *ptr);
void FModifierLimits_use_max_x_set(PointerRNA *ptr, int value);

float FModifierLimits_max_x_get(PointerRNA *ptr);
void FModifierLimits_max_x_set(PointerRNA *ptr, float value);

int FModifierLimits_use_max_y_get(PointerRNA *ptr);
void FModifierLimits_use_max_y_set(PointerRNA *ptr, int value);

float FModifierLimits_max_y_get(PointerRNA *ptr);
void FModifierLimits_max_y_set(PointerRNA *ptr, float value);

int FModifierLimits_use_min_x_get(PointerRNA *ptr);
void FModifierLimits_use_min_x_set(PointerRNA *ptr, int value);

float FModifierLimits_min_x_get(PointerRNA *ptr);
void FModifierLimits_min_x_set(PointerRNA *ptr, float value);

int FModifierLimits_use_min_y_get(PointerRNA *ptr);
void FModifierLimits_use_min_y_set(PointerRNA *ptr, int value);

float FModifierLimits_min_y_get(PointerRNA *ptr);
void FModifierLimits_min_y_set(PointerRNA *ptr, float value);

/**************** Noise F-Modifier ****************/

extern StructRNA RNA_FModifierNoise;
extern StructRNA RNA_FModifier;

enum {
	FModifierNoise_blend_type_REPLACE = 0,
	FModifierNoise_blend_type_ADD = 1,
	FModifierNoise_blend_type_SUBTRACT = 2,
	FModifierNoise_blend_type_MULTIPLY = 3,
};

int FModifierNoise_blend_type_get(PointerRNA *ptr);
void FModifierNoise_blend_type_set(PointerRNA *ptr, int value);

int FModifierNoise_depth_get(PointerRNA *ptr);
void FModifierNoise_depth_set(PointerRNA *ptr, int value);

float FModifierNoise_offset_get(PointerRNA *ptr);
void FModifierNoise_offset_set(PointerRNA *ptr, float value);

float FModifierNoise_phase_get(PointerRNA *ptr);
void FModifierNoise_phase_set(PointerRNA *ptr, float value);

float FModifierNoise_scale_get(PointerRNA *ptr);
void FModifierNoise_scale_set(PointerRNA *ptr, float value);

float FModifierNoise_strength_get(PointerRNA *ptr);
void FModifierNoise_strength_set(PointerRNA *ptr, float value);

/**************** Python F-Modifier ****************/

extern StructRNA RNA_FModifierPython;
extern StructRNA RNA_FModifier;

/**************** Stepped Interpolation F-Modifier ****************/

extern StructRNA RNA_FModifierStepped;
extern StructRNA RNA_FModifier;

float FModifierStepped_frame_end_get(PointerRNA *ptr);
void FModifierStepped_frame_end_set(PointerRNA *ptr, float value);

float FModifierStepped_frame_offset_get(PointerRNA *ptr);
void FModifierStepped_frame_offset_set(PointerRNA *ptr, float value);

float FModifierStepped_frame_start_get(PointerRNA *ptr);
void FModifierStepped_frame_start_set(PointerRNA *ptr, float value);

float FModifierStepped_frame_step_get(PointerRNA *ptr);
void FModifierStepped_frame_step_set(PointerRNA *ptr, float value);

int FModifierStepped_use_frame_end_get(PointerRNA *ptr);
void FModifierStepped_use_frame_end_set(PointerRNA *ptr, int value);

int FModifierStepped_use_frame_start_get(PointerRNA *ptr);
void FModifierStepped_use_frame_start_set(PointerRNA *ptr, int value);

/**************** Field Settings ****************/

extern StructRNA RNA_FieldSettings;

PointerRNA FieldSettings_rna_type_get(PointerRNA *ptr);

int FieldSettings_use_2d_force_get(PointerRNA *ptr);
void FieldSettings_use_2d_force_set(PointerRNA *ptr, int value);

int FieldSettings_use_absorption_get(PointerRNA *ptr);
void FieldSettings_use_absorption_set(PointerRNA *ptr, int value);

int FieldSettings_use_guide_path_add_get(PointerRNA *ptr);
void FieldSettings_use_guide_path_add_set(PointerRNA *ptr, int value);

float FieldSettings_guide_clump_amount_get(PointerRNA *ptr);
void FieldSettings_guide_clump_amount_set(PointerRNA *ptr, float value);

float FieldSettings_guide_kink_amplitude_get(PointerRNA *ptr);
void FieldSettings_guide_kink_amplitude_set(PointerRNA *ptr, float value);

int FieldSettings_use_smoke_density_get(PointerRNA *ptr);
void FieldSettings_use_smoke_density_set(PointerRNA *ptr, int value);

enum {
	FieldSettings_guide_kink_axis_X = 0,
	FieldSettings_guide_kink_axis_Y = 1,
	FieldSettings_guide_kink_axis_Z = 2,
};

int FieldSettings_guide_kink_axis_get(PointerRNA *ptr);
void FieldSettings_guide_kink_axis_set(PointerRNA *ptr, int value);

PointerRNA FieldSettings_source_object_get(PointerRNA *ptr);

enum {
	FieldSettings_falloff_type_SPHERE = 0,
	FieldSettings_falloff_type_TUBE = 1,
	FieldSettings_falloff_type_CONE = 2,
};

int FieldSettings_falloff_type_get(PointerRNA *ptr);
void FieldSettings_falloff_type_set(PointerRNA *ptr, int value);

float FieldSettings_falloff_power_get(PointerRNA *ptr);
void FieldSettings_falloff_power_set(PointerRNA *ptr, float value);

float FieldSettings_flow_get(PointerRNA *ptr);
void FieldSettings_flow_set(PointerRNA *ptr, float value);

float FieldSettings_guide_free_get(PointerRNA *ptr);
void FieldSettings_guide_free_set(PointerRNA *ptr, float value);

float FieldSettings_guide_kink_frequency_get(PointerRNA *ptr);
void FieldSettings_guide_kink_frequency_set(PointerRNA *ptr, float value);

float FieldSettings_harmonic_damping_get(PointerRNA *ptr);
void FieldSettings_harmonic_damping_set(PointerRNA *ptr, float value);

float FieldSettings_inflow_get(PointerRNA *ptr);
void FieldSettings_inflow_set(PointerRNA *ptr, float value);

enum {
	FieldSettings_guide_kink_type_NONE = 0,
	FieldSettings_guide_kink_type_CURL = 1,
	FieldSettings_guide_kink_type_RADIAL = 2,
	FieldSettings_guide_kink_type_WAVE = 3,
	FieldSettings_guide_kink_type_BRAID = 4,
	FieldSettings_guide_kink_type_ROTATION = 5,
	FieldSettings_guide_kink_type_ROLL = 6,
};

int FieldSettings_guide_kink_type_get(PointerRNA *ptr);
void FieldSettings_guide_kink_type_set(PointerRNA *ptr, int value);

float FieldSettings_linear_drag_get(PointerRNA *ptr);
void FieldSettings_linear_drag_set(PointerRNA *ptr, float value);

int FieldSettings_apply_to_location_get(PointerRNA *ptr);
void FieldSettings_apply_to_location_set(PointerRNA *ptr, int value);

float FieldSettings_distance_max_get(PointerRNA *ptr);
void FieldSettings_distance_max_set(PointerRNA *ptr, float value);

float FieldSettings_radial_max_get(PointerRNA *ptr);
void FieldSettings_radial_max_set(PointerRNA *ptr, float value);

float FieldSettings_distance_min_get(PointerRNA *ptr);
void FieldSettings_distance_min_set(PointerRNA *ptr, float value);

float FieldSettings_guide_minimum_get(PointerRNA *ptr);
void FieldSettings_guide_minimum_set(PointerRNA *ptr, float value);

float FieldSettings_radial_min_get(PointerRNA *ptr);
void FieldSettings_radial_min_set(PointerRNA *ptr, float value);

int FieldSettings_use_multiple_springs_get(PointerRNA *ptr);
void FieldSettings_use_multiple_springs_set(PointerRNA *ptr, int value);

float FieldSettings_texture_nabla_get(PointerRNA *ptr);
void FieldSettings_texture_nabla_set(PointerRNA *ptr, float value);

float FieldSettings_noise_get(PointerRNA *ptr);
void FieldSettings_noise_set(PointerRNA *ptr, float value);

float FieldSettings_quadratic_drag_get(PointerRNA *ptr);
void FieldSettings_quadratic_drag_set(PointerRNA *ptr, float value);

float FieldSettings_radial_falloff_get(PointerRNA *ptr);
void FieldSettings_radial_falloff_set(PointerRNA *ptr, float value);

float FieldSettings_rest_length_get(PointerRNA *ptr);
void FieldSettings_rest_length_set(PointerRNA *ptr, float value);

int FieldSettings_use_root_coords_get(PointerRNA *ptr);
void FieldSettings_use_root_coords_set(PointerRNA *ptr, int value);

int FieldSettings_apply_to_rotation_get(PointerRNA *ptr);
void FieldSettings_apply_to_rotation_set(PointerRNA *ptr, int value);

int FieldSettings_seed_get(PointerRNA *ptr);
void FieldSettings_seed_set(PointerRNA *ptr, int value);

enum {
	FieldSettings_shape_POINT = 0,
	FieldSettings_shape_PLANE = 1,
	FieldSettings_shape_SURFACE = 2,
	FieldSettings_shape_POINTS = 3,
};

int FieldSettings_shape_get(PointerRNA *ptr);
void FieldSettings_shape_set(PointerRNA *ptr, int value);

float FieldSettings_guide_clump_shape_get(PointerRNA *ptr);
void FieldSettings_guide_clump_shape_set(PointerRNA *ptr, float value);

float FieldSettings_guide_kink_shape_get(PointerRNA *ptr);
void FieldSettings_guide_kink_shape_set(PointerRNA *ptr, float value);

float FieldSettings_size_get(PointerRNA *ptr);
void FieldSettings_size_set(PointerRNA *ptr, float value);

float FieldSettings_strength_get(PointerRNA *ptr);
void FieldSettings_strength_set(PointerRNA *ptr, float value);

PointerRNA FieldSettings_texture_get(PointerRNA *ptr);

enum {
	FieldSettings_texture_mode_RGB = 0,
	FieldSettings_texture_mode_GRADIENT = 1,
	FieldSettings_texture_mode_CURL = 2,
};

int FieldSettings_texture_mode_get(PointerRNA *ptr);
void FieldSettings_texture_mode_set(PointerRNA *ptr, int value);

enum {
	FieldSettings_type_NONE = 0,
	FieldSettings_type_FORCE = 1,
	FieldSettings_type_WIND = 4,
	FieldSettings_type_VORTEX = 2,
	FieldSettings_type_MAGNET = 3,
	FieldSettings_type_HARMONIC = 7,
	FieldSettings_type_CHARGE = 8,
	FieldSettings_type_LENNARDJ = 9,
	FieldSettings_type_TEXTURE = 6,
	FieldSettings_type_GUIDE = 5,
	FieldSettings_type_BOID = 10,
	FieldSettings_type_TURBULENCE = 11,
	FieldSettings_type_DRAG = 12,
	FieldSettings_type_SMOKE_FLOW = 13,
};

int FieldSettings_type_get(PointerRNA *ptr);
void FieldSettings_type_set(PointerRNA *ptr, int value);

int FieldSettings_use_object_coords_get(PointerRNA *ptr);
void FieldSettings_use_object_coords_set(PointerRNA *ptr, int value);

int FieldSettings_use_global_coords_get(PointerRNA *ptr);
void FieldSettings_use_global_coords_set(PointerRNA *ptr, int value);

int FieldSettings_use_max_distance_get(PointerRNA *ptr);
void FieldSettings_use_max_distance_set(PointerRNA *ptr, int value);

int FieldSettings_use_radial_max_get(PointerRNA *ptr);
void FieldSettings_use_radial_max_set(PointerRNA *ptr, int value);

int FieldSettings_use_min_distance_get(PointerRNA *ptr);
void FieldSettings_use_min_distance_set(PointerRNA *ptr, int value);

int FieldSettings_use_radial_min_get(PointerRNA *ptr);
void FieldSettings_use_radial_min_set(PointerRNA *ptr, int value);

int FieldSettings_use_guide_path_weight_get(PointerRNA *ptr);
void FieldSettings_use_guide_path_weight_set(PointerRNA *ptr, int value);

enum {
	FieldSettings_z_direction_BOTH = 0,
	FieldSettings_z_direction_POSITIVE = 1,
	FieldSettings_z_direction_NEGATIVE = 2,
};

int FieldSettings_z_direction_get(PointerRNA *ptr);
void FieldSettings_z_direction_set(PointerRNA *ptr, int value);

/**************** File Select Parameters ****************/

extern StructRNA RNA_FileSelectParams;

PointerRNA FileSelectParams_rna_type_get(PointerRNA *ptr);

#define FileSelectParams_directory_MAX 1056

void FileSelectParams_directory_get(PointerRNA *ptr, char *value);
int FileSelectParams_directory_length(PointerRNA *ptr);
void FileSelectParams_directory_set(PointerRNA *ptr, const char *value);

enum {
	FileSelectParams_display_type_FILE_SHORTDISPLAY = 1,
	FileSelectParams_display_type_FILE_LONGDISPLAY = 2,
	FileSelectParams_display_type_FILE_IMGDISPLAY = 3,
};

int FileSelectParams_display_type_get(PointerRNA *ptr);
void FileSelectParams_display_type_set(PointerRNA *ptr, int value);

#define FileSelectParams_filter_glob_MAX 64

void FileSelectParams_filter_glob_get(PointerRNA *ptr, char *value);
int FileSelectParams_filter_glob_length(PointerRNA *ptr);
void FileSelectParams_filter_glob_set(PointerRNA *ptr, const char *value);

#define FileSelectParams_filename_MAX 256

void FileSelectParams_filename_get(PointerRNA *ptr, char *value);
int FileSelectParams_filename_length(PointerRNA *ptr);
void FileSelectParams_filename_set(PointerRNA *ptr, const char *value);

int FileSelectParams_use_filter_blender_get(PointerRNA *ptr);
void FileSelectParams_use_filter_blender_set(PointerRNA *ptr, int value);

int FileSelectParams_use_filter_backup_get(PointerRNA *ptr);
void FileSelectParams_use_filter_backup_set(PointerRNA *ptr, int value);

int FileSelectParams_use_filter_get(PointerRNA *ptr);
void FileSelectParams_use_filter_set(PointerRNA *ptr, int value);

int FileSelectParams_use_filter_folder_get(PointerRNA *ptr);
void FileSelectParams_use_filter_folder_set(PointerRNA *ptr, int value);

int FileSelectParams_use_filter_font_get(PointerRNA *ptr);
void FileSelectParams_use_filter_font_set(PointerRNA *ptr, int value);

int FileSelectParams_use_filter_image_get(PointerRNA *ptr);
void FileSelectParams_use_filter_image_set(PointerRNA *ptr, int value);

int FileSelectParams_use_filter_movie_get(PointerRNA *ptr);
void FileSelectParams_use_filter_movie_set(PointerRNA *ptr, int value);

int FileSelectParams_use_filter_script_get(PointerRNA *ptr);
void FileSelectParams_use_filter_script_set(PointerRNA *ptr, int value);

int FileSelectParams_use_filter_sound_get(PointerRNA *ptr);
void FileSelectParams_use_filter_sound_set(PointerRNA *ptr, int value);

int FileSelectParams_use_filter_text_get(PointerRNA *ptr);
void FileSelectParams_use_filter_text_set(PointerRNA *ptr, int value);

int FileSelectParams_show_hidden_get(PointerRNA *ptr);
void FileSelectParams_show_hidden_set(PointerRNA *ptr, int value);

enum {
	FileSelectParams_sort_method_FILE_SORT_ALPHA = 1,
	FileSelectParams_sort_method_FILE_SORT_EXTENSION = 2,
	FileSelectParams_sort_method_FILE_SORT_TIME = 3,
	FileSelectParams_sort_method_FILE_SORT_SIZE = 4,
};

int FileSelectParams_sort_method_get(PointerRNA *ptr);
void FileSelectParams_sort_method_set(PointerRNA *ptr, int value);

#define FileSelectParams_title_MAX 96

void FileSelectParams_title_get(PointerRNA *ptr, char *value);
int FileSelectParams_title_length(PointerRNA *ptr);
void FileSelectParams_title_set(PointerRNA *ptr, const char *value);

/**************** Filter 2D Actuator ****************/

extern StructRNA RNA_Filter2DActuator;
extern StructRNA RNA_Actuator;

int Filter2DActuator_use_motion_blur_get(PointerRNA *ptr);
void Filter2DActuator_use_motion_blur_set(PointerRNA *ptr, int value);

enum {
	Filter2DActuator_mode_ENABLE = -2,
	Filter2DActuator_mode_DISABLE = -1,
	Filter2DActuator_mode_REMOVE = 0,
	Filter2DActuator_mode_MOTIONBLUR = 1,
	Filter2DActuator_mode_BLUR = 2,
	Filter2DActuator_mode_SHARPEN = 3,
	Filter2DActuator_mode_DILATION = 4,
	Filter2DActuator_mode_EROSION = 5,
	Filter2DActuator_mode_LAPLACIAN = 6,
	Filter2DActuator_mode_SOBEL = 7,
	Filter2DActuator_mode_PREWITT = 8,
	Filter2DActuator_mode_GRAYSCALE = 9,
	Filter2DActuator_mode_SEPIA = 10,
	Filter2DActuator_mode_INVERT = 11,
	Filter2DActuator_mode_CUSTOMFILTER = 12,
};

int Filter2DActuator_mode_get(PointerRNA *ptr);
void Filter2DActuator_mode_set(PointerRNA *ptr, int value);

int Filter2DActuator_filter_pass_get(PointerRNA *ptr);
void Filter2DActuator_filter_pass_set(PointerRNA *ptr, int value);

PointerRNA Filter2DActuator_glsl_shader_get(PointerRNA *ptr);

float Filter2DActuator_motion_blur_factor_get(PointerRNA *ptr);
void Filter2DActuator_motion_blur_factor_set(PointerRNA *ptr, float value);

/**************** Float Properties ****************/

extern StructRNA RNA_FloatProperties;

PointerRNA FloatProperties_rna_type_get(PointerRNA *ptr);

struct PointerRNA FloatProperties_new(struct Mesh *_self, const char * name);
/**************** Float Definition ****************/

extern StructRNA RNA_FloatProperty;
extern StructRNA RNA_Property;

int FloatProperty_array_length_get(PointerRNA *ptr);
void FloatProperty_array_length_set(PointerRNA *ptr, int value);

float FloatProperty_default_value_get(PointerRNA *ptr);
void FloatProperty_default_value_set(PointerRNA *ptr, float value);

void FloatProperty_default_array_get(PointerRNA *ptr, float values[3]);
void FloatProperty_default_array_set(PointerRNA *ptr, const float values[3]);
int FloatProperty_default_array_get_length(PointerRNA *ptr, int *arraylen);

float FloatProperty_hard_max_get(PointerRNA *ptr);
void FloatProperty_hard_max_set(PointerRNA *ptr, float value);

float FloatProperty_hard_min_get(PointerRNA *ptr);
void FloatProperty_hard_min_set(PointerRNA *ptr, float value);

int FloatProperty_precision_get(PointerRNA *ptr);
void FloatProperty_precision_set(PointerRNA *ptr, int value);

float FloatProperty_soft_max_get(PointerRNA *ptr);
void FloatProperty_soft_max_set(PointerRNA *ptr, float value);

float FloatProperty_soft_min_get(PointerRNA *ptr);
void FloatProperty_soft_min_set(PointerRNA *ptr, float value);

float FloatProperty_step_get(PointerRNA *ptr);
void FloatProperty_step_set(PointerRNA *ptr, float value);

/**************** Floor Constraint ****************/

extern StructRNA RNA_FloorConstraint;
extern StructRNA RNA_Constraint;

enum {
	FloorConstraint_floor_location_FLOOR_X = 0,
	FloorConstraint_floor_location_FLOOR_Y = 1,
	FloorConstraint_floor_location_FLOOR_Z = 2,
	FloorConstraint_floor_location_FLOOR_NEGATIVE_X = 3,
	FloorConstraint_floor_location_FLOOR_NEGATIVE_Y = 4,
	FloorConstraint_floor_location_FLOOR_NEGATIVE_Z = 5,
};

int FloorConstraint_floor_location_get(PointerRNA *ptr);
void FloorConstraint_floor_location_set(PointerRNA *ptr, int value);

float FloorConstraint_offset_get(PointerRNA *ptr);
void FloorConstraint_offset_set(PointerRNA *ptr, float value);

int FloorConstraint_use_sticky_get(PointerRNA *ptr);
void FloorConstraint_use_sticky_set(PointerRNA *ptr, int value);

#define FloorConstraint_subtarget_MAX 64

void FloorConstraint_subtarget_get(PointerRNA *ptr, char *value);
int FloorConstraint_subtarget_length(PointerRNA *ptr);
void FloorConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA FloorConstraint_target_get(PointerRNA *ptr);

int FloorConstraint_use_rotation_get(PointerRNA *ptr);
void FloorConstraint_use_rotation_set(PointerRNA *ptr, int value);

/**************** Fluid Fluid Simulation Settings ****************/

extern StructRNA RNA_FluidFluidSettings;
extern StructRNA RNA_FluidSettings;

int FluidFluidSettings_use_get(PointerRNA *ptr);
void FluidFluidSettings_use_set(PointerRNA *ptr, int value);

int FluidFluidSettings_use_animated_mesh_get(PointerRNA *ptr);
void FluidFluidSettings_use_animated_mesh_set(PointerRNA *ptr, int value);

void FluidFluidSettings_initial_velocity_get(PointerRNA *ptr, float values[3]);
void FluidFluidSettings_initial_velocity_set(PointerRNA *ptr, const float values[3]);

enum {
	FluidFluidSettings_volume_initialization_VOLUME = 1,
	FluidFluidSettings_volume_initialization_SHELL = 2,
	FluidFluidSettings_volume_initialization_BOTH = 3,
};

int FluidFluidSettings_volume_initialization_get(PointerRNA *ptr);
void FluidFluidSettings_volume_initialization_set(PointerRNA *ptr, int value);

/**************** Fluid Mesh Vertex ****************/

extern StructRNA RNA_FluidMeshVertex;

PointerRNA FluidMeshVertex_rna_type_get(PointerRNA *ptr);

void FluidMeshVertex_velocity_get(PointerRNA *ptr, float values[3]);
void FluidMeshVertex_velocity_set(PointerRNA *ptr, const float values[3]);

/**************** Fluid Simulation Settings ****************/

extern StructRNA RNA_FluidSettings;

PointerRNA FluidSettings_rna_type_get(PointerRNA *ptr);

enum {
	FluidSettings_type_NONE = 1,
	FluidSettings_type_DOMAIN = 2,
	FluidSettings_type_FLUID = 4,
	FluidSettings_type_OBSTACLE = 8,
	FluidSettings_type_INFLOW = 16,
	FluidSettings_type_OUTFLOW = 32,
	FluidSettings_type_PARTICLE = 64,
	FluidSettings_type_CONTROL = 128,
};

int FluidSettings_type_get(PointerRNA *ptr);
void FluidSettings_type_set(PointerRNA *ptr, int value);

/**************** Fluid Simulation Modifier ****************/

extern StructRNA RNA_FluidSimulationModifier;
extern StructRNA RNA_Modifier;

PointerRNA FluidSimulationModifier_settings_get(PointerRNA *ptr);

/**************** Follow Path Constraint ****************/

extern StructRNA RNA_FollowPathConstraint;
extern StructRNA RNA_Constraint;

int FollowPathConstraint_use_curve_radius_get(PointerRNA *ptr);
void FollowPathConstraint_use_curve_radius_set(PointerRNA *ptr, int value);

int FollowPathConstraint_use_fixed_location_get(PointerRNA *ptr);
void FollowPathConstraint_use_fixed_location_set(PointerRNA *ptr, int value);

int FollowPathConstraint_use_curve_follow_get(PointerRNA *ptr);
void FollowPathConstraint_use_curve_follow_set(PointerRNA *ptr, int value);

enum {
	FollowPathConstraint_forward_axis_FORWARD_X = 0,
	FollowPathConstraint_forward_axis_FORWARD_Y = 1,
	FollowPathConstraint_forward_axis_FORWARD_Z = 2,
	FollowPathConstraint_forward_axis_TRACK_NEGATIVE_X = 3,
	FollowPathConstraint_forward_axis_TRACK_NEGATIVE_Y = 4,
	FollowPathConstraint_forward_axis_TRACK_NEGATIVE_Z = 5,
};

int FollowPathConstraint_forward_axis_get(PointerRNA *ptr);
void FollowPathConstraint_forward_axis_set(PointerRNA *ptr, int value);

float FollowPathConstraint_offset_get(PointerRNA *ptr);
void FollowPathConstraint_offset_set(PointerRNA *ptr, float value);

float FollowPathConstraint_offset_factor_get(PointerRNA *ptr);
void FollowPathConstraint_offset_factor_set(PointerRNA *ptr, float value);

PointerRNA FollowPathConstraint_target_get(PointerRNA *ptr);

enum {
	FollowPathConstraint_up_axis_UP_X = 0,
	FollowPathConstraint_up_axis_UP_Y = 1,
	FollowPathConstraint_up_axis_UP_Z = 2,
};

int FollowPathConstraint_up_axis_get(PointerRNA *ptr);
void FollowPathConstraint_up_axis_set(PointerRNA *ptr, int value);

/**************** Follow Track Constraint ****************/

extern StructRNA RNA_FollowTrackConstraint;
extern StructRNA RNA_Constraint;

int FollowTrackConstraint_use_3d_position_get(PointerRNA *ptr);
void FollowTrackConstraint_use_3d_position_set(PointerRNA *ptr, int value);

int FollowTrackConstraint_use_active_clip_get(PointerRNA *ptr);
void FollowTrackConstraint_use_active_clip_set(PointerRNA *ptr, int value);

PointerRNA FollowTrackConstraint_camera_get(PointerRNA *ptr);

PointerRNA FollowTrackConstraint_depth_object_get(PointerRNA *ptr);

enum {
	FollowTrackConstraint_frame_method_STRETCH = 0,
	FollowTrackConstraint_frame_method_FIT = 1,
	FollowTrackConstraint_frame_method_CROP = 2,
};

int FollowTrackConstraint_frame_method_get(PointerRNA *ptr);
void FollowTrackConstraint_frame_method_set(PointerRNA *ptr, int value);

PointerRNA FollowTrackConstraint_clip_get(PointerRNA *ptr);

#define FollowTrackConstraint_object_MAX 64

void FollowTrackConstraint_object_get(PointerRNA *ptr, char *value);
int FollowTrackConstraint_object_length(PointerRNA *ptr);
void FollowTrackConstraint_object_set(PointerRNA *ptr, const char *value);

#define FollowTrackConstraint_track_MAX 64

void FollowTrackConstraint_track_get(PointerRNA *ptr, char *value);
int FollowTrackConstraint_track_length(PointerRNA *ptr);
void FollowTrackConstraint_track_set(PointerRNA *ptr, const char *value);

int FollowTrackConstraint_use_undistorted_position_get(PointerRNA *ptr);
void FollowTrackConstraint_use_undistorted_position_set(PointerRNA *ptr, int value);

/**************** Freestyle Line Set ****************/

extern StructRNA RNA_FreestyleLineSet;

PointerRNA FreestyleLineSet_rna_type_get(PointerRNA *ptr);

#define FreestyleLineSet_name_MAX 64

void FreestyleLineSet_name_get(PointerRNA *ptr, char *value);
int FreestyleLineSet_name_length(PointerRNA *ptr);
void FreestyleLineSet_name_set(PointerRNA *ptr, const char *value);

int FreestyleLineSet_select_border_get(PointerRNA *ptr);
void FreestyleLineSet_select_border_set(PointerRNA *ptr, int value);

int FreestyleLineSet_exclude_border_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_border_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_contour_get(PointerRNA *ptr);
void FreestyleLineSet_select_contour_set(PointerRNA *ptr, int value);

int FreestyleLineSet_exclude_contour_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_contour_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_crease_get(PointerRNA *ptr);
void FreestyleLineSet_select_crease_set(PointerRNA *ptr, int value);

int FreestyleLineSet_exclude_crease_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_crease_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_edge_mark_get(PointerRNA *ptr);
void FreestyleLineSet_select_edge_mark_set(PointerRNA *ptr, int value);

int FreestyleLineSet_exclude_edge_mark_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_edge_mark_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineSet_edge_type_combination_OR = 0,
	FreestyleLineSet_edge_type_combination_AND = 8,
};

int FreestyleLineSet_edge_type_combination_get(PointerRNA *ptr);
void FreestyleLineSet_edge_type_combination_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineSet_edge_type_negation_INCLUSIVE = 0,
	FreestyleLineSet_edge_type_negation_EXCLUSIVE = 4,
};

int FreestyleLineSet_edge_type_negation_get(PointerRNA *ptr);
void FreestyleLineSet_edge_type_negation_set(PointerRNA *ptr, int value);

int FreestyleLineSet_qi_end_get(PointerRNA *ptr);
void FreestyleLineSet_qi_end_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_external_contour_get(PointerRNA *ptr);
void FreestyleLineSet_select_external_contour_set(PointerRNA *ptr, int value);

int FreestyleLineSet_exclude_external_contour_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_external_contour_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineSet_face_mark_condition_ONE = 0,
	FreestyleLineSet_face_mark_condition_BOTH = 64,
};

int FreestyleLineSet_face_mark_condition_get(PointerRNA *ptr);
void FreestyleLineSet_face_mark_condition_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineSet_face_mark_negation_INCLUSIVE = 0,
	FreestyleLineSet_face_mark_negation_EXCLUSIVE = 32,
};

int FreestyleLineSet_face_mark_negation_get(PointerRNA *ptr);
void FreestyleLineSet_face_mark_negation_set(PointerRNA *ptr, int value);

PointerRNA FreestyleLineSet_group_get(PointerRNA *ptr);

enum {
	FreestyleLineSet_group_negation_INCLUSIVE = 0,
	FreestyleLineSet_group_negation_EXCLUSIVE = 16,
};

int FreestyleLineSet_group_negation_get(PointerRNA *ptr);
void FreestyleLineSet_group_negation_set(PointerRNA *ptr, int value);

PointerRNA FreestyleLineSet_linestyle_get(PointerRNA *ptr);

int FreestyleLineSet_select_material_boundary_get(PointerRNA *ptr);
void FreestyleLineSet_select_material_boundary_set(PointerRNA *ptr, int value);

int FreestyleLineSet_exclude_material_boundary_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_material_boundary_set(PointerRNA *ptr, int value);

int FreestyleLineSet_show_render_get(PointerRNA *ptr);
void FreestyleLineSet_show_render_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_ridge_valley_get(PointerRNA *ptr);
void FreestyleLineSet_select_ridge_valley_set(PointerRNA *ptr, int value);

int FreestyleLineSet_exclude_ridge_valley_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_ridge_valley_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_by_edge_types_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_edge_types_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_by_face_marks_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_face_marks_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_by_group_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_group_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_by_image_border_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_image_border_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_by_visibility_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_visibility_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_silhouette_get(PointerRNA *ptr);
void FreestyleLineSet_select_silhouette_set(PointerRNA *ptr, int value);

int FreestyleLineSet_exclude_silhouette_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_silhouette_set(PointerRNA *ptr, int value);

int FreestyleLineSet_qi_start_get(PointerRNA *ptr);
void FreestyleLineSet_qi_start_set(PointerRNA *ptr, int value);

int FreestyleLineSet_select_suggestive_contour_get(PointerRNA *ptr);
void FreestyleLineSet_select_suggestive_contour_set(PointerRNA *ptr, int value);

int FreestyleLineSet_exclude_suggestive_contour_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_suggestive_contour_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineSet_visibility_VISIBLE = 1,
	FreestyleLineSet_visibility_HIDDEN = 2,
	FreestyleLineSet_visibility_RANGE = 3,
};

int FreestyleLineSet_visibility_get(PointerRNA *ptr);
void FreestyleLineSet_visibility_set(PointerRNA *ptr, int value);

/**************** Freestyle Line Style ****************/

extern StructRNA RNA_FreestyleLineStyle;
extern StructRNA RNA_ID;

PointerRNA FreestyleLineStyle_active_texture_get(PointerRNA *ptr);

int FreestyleLineStyle_active_texture_index_get(PointerRNA *ptr);
void FreestyleLineStyle_active_texture_index_set(PointerRNA *ptr, int value);

void FreestyleLineStyle_alpha_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_alpha_modifiers_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_alpha_modifiers_end(CollectionPropertyIterator *iter);
int FreestyleLineStyle_alpha_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

float FreestyleLineStyle_alpha_get(PointerRNA *ptr);
void FreestyleLineStyle_alpha_set(PointerRNA *ptr, float value);

enum {
	FreestyleLineStyle_caps_BUTT = 1,
	FreestyleLineStyle_caps_ROUND = 2,
	FreestyleLineStyle_caps_SQUARE = 3,
};

int FreestyleLineStyle_caps_get(PointerRNA *ptr);
void FreestyleLineStyle_caps_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_chain_count_get(PointerRNA *ptr);
void FreestyleLineStyle_chain_count_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_chaining_get(PointerRNA *ptr);
void FreestyleLineStyle_use_chaining_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineStyle_chaining_PLAIN = 1,
	FreestyleLineStyle_chaining_SKETCHY = 2,
};

int FreestyleLineStyle_chaining_get(PointerRNA *ptr);
void FreestyleLineStyle_chaining_set(PointerRNA *ptr, int value);

void FreestyleLineStyle_color_get(PointerRNA *ptr, float values[3]);
void FreestyleLineStyle_color_set(PointerRNA *ptr, const float values[3]);

void FreestyleLineStyle_color_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_color_modifiers_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_color_modifiers_end(CollectionPropertyIterator *iter);
int FreestyleLineStyle_color_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int FreestyleLineStyle_dash1_get(PointerRNA *ptr);
void FreestyleLineStyle_dash1_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_dash2_get(PointerRNA *ptr);
void FreestyleLineStyle_dash2_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_dash3_get(PointerRNA *ptr);
void FreestyleLineStyle_dash3_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_dashed_line_get(PointerRNA *ptr);
void FreestyleLineStyle_use_dashed_line_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_gap1_get(PointerRNA *ptr);
void FreestyleLineStyle_gap1_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_gap2_get(PointerRNA *ptr);
void FreestyleLineStyle_gap2_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_gap3_get(PointerRNA *ptr);
void FreestyleLineStyle_gap3_set(PointerRNA *ptr, int value);

void FreestyleLineStyle_geometry_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_geometry_modifiers_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_geometry_modifiers_end(CollectionPropertyIterator *iter);
int FreestyleLineStyle_geometry_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	FreestyleLineStyle_integration_type_MEAN = 1,
	FreestyleLineStyle_integration_type_MIN = 2,
	FreestyleLineStyle_integration_type_MAX = 3,
	FreestyleLineStyle_integration_type_FIRST = 4,
	FreestyleLineStyle_integration_type_LAST = 5,
};

int FreestyleLineStyle_integration_type_get(PointerRNA *ptr);
void FreestyleLineStyle_integration_type_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_material_boundary_get(PointerRNA *ptr);
void FreestyleLineStyle_material_boundary_set(PointerRNA *ptr, int value);

float FreestyleLineStyle_angle_max_get(PointerRNA *ptr);
void FreestyleLineStyle_angle_max_set(PointerRNA *ptr, float value);

float FreestyleLineStyle_length_max_get(PointerRNA *ptr);
void FreestyleLineStyle_length_max_set(PointerRNA *ptr, float value);

float FreestyleLineStyle_angle_min_get(PointerRNA *ptr);
void FreestyleLineStyle_angle_min_set(PointerRNA *ptr, float value);

float FreestyleLineStyle_length_min_get(PointerRNA *ptr);
void FreestyleLineStyle_length_min_set(PointerRNA *ptr, float value);

PointerRNA FreestyleLineStyle_node_tree_get(PointerRNA *ptr);

enum {
	FreestyleLineStyle_panel_STROKES = 1,
	FreestyleLineStyle_panel_COLOR = 2,
	FreestyleLineStyle_panel_ALPHA = 3,
	FreestyleLineStyle_panel_THICKNESS = 4,
	FreestyleLineStyle_panel_GEOMETRY = 5,
	FreestyleLineStyle_panel_TEXTURE = 6,
};

int FreestyleLineStyle_panel_get(PointerRNA *ptr);
void FreestyleLineStyle_panel_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_rounds_get(PointerRNA *ptr);
void FreestyleLineStyle_rounds_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_same_object_get(PointerRNA *ptr);
void FreestyleLineStyle_use_same_object_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineStyle_sort_key_DISTANCE_FROM_CAMERA = 1,
	FreestyleLineStyle_sort_key_2D_LENGTH = 2,
	FreestyleLineStyle_sort_key_PROJECTED_X = 3,
	FreestyleLineStyle_sort_key_PROJECTED_Y = 4,
};

int FreestyleLineStyle_sort_key_get(PointerRNA *ptr);
void FreestyleLineStyle_sort_key_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineStyle_sort_order_DEFAULT = 0,
	FreestyleLineStyle_sort_order_REVERSE = 4096,
};

int FreestyleLineStyle_sort_order_get(PointerRNA *ptr);
void FreestyleLineStyle_sort_order_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_sorting_get(PointerRNA *ptr);
void FreestyleLineStyle_use_sorting_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_dash1_get(PointerRNA *ptr);
void FreestyleLineStyle_split_dash1_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_dash2_get(PointerRNA *ptr);
void FreestyleLineStyle_split_dash2_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_dash3_get(PointerRNA *ptr);
void FreestyleLineStyle_split_dash3_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_gap1_get(PointerRNA *ptr);
void FreestyleLineStyle_split_gap1_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_gap2_get(PointerRNA *ptr);
void FreestyleLineStyle_split_gap2_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_gap3_get(PointerRNA *ptr);
void FreestyleLineStyle_split_gap3_set(PointerRNA *ptr, int value);

float FreestyleLineStyle_split_length_get(PointerRNA *ptr);
void FreestyleLineStyle_split_length_set(PointerRNA *ptr, float value);

float FreestyleLineStyle_texture_spacing_get(PointerRNA *ptr);
void FreestyleLineStyle_texture_spacing_set(PointerRNA *ptr, float value);

void FreestyleLineStyle_texture_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_texture_slots_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_texture_slots_end(CollectionPropertyIterator *iter);

float FreestyleLineStyle_thickness_get(PointerRNA *ptr);
void FreestyleLineStyle_thickness_set(PointerRNA *ptr, float value);

void FreestyleLineStyle_thickness_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_thickness_modifiers_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_thickness_modifiers_end(CollectionPropertyIterator *iter);
int FreestyleLineStyle_thickness_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	FreestyleLineStyle_thickness_position_CENTER = 1,
	FreestyleLineStyle_thickness_position_INSIDE = 2,
	FreestyleLineStyle_thickness_position_OUTSIDE = 3,
	FreestyleLineStyle_thickness_position_RELATIVE = 4,
};

int FreestyleLineStyle_thickness_position_get(PointerRNA *ptr);
void FreestyleLineStyle_thickness_position_set(PointerRNA *ptr, int value);

float FreestyleLineStyle_thickness_ratio_get(PointerRNA *ptr);
void FreestyleLineStyle_thickness_ratio_set(PointerRNA *ptr, float value);

int FreestyleLineStyle_use_chain_count_get(PointerRNA *ptr);
void FreestyleLineStyle_use_chain_count_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_angle_max_get(PointerRNA *ptr);
void FreestyleLineStyle_use_angle_max_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_length_max_get(PointerRNA *ptr);
void FreestyleLineStyle_use_length_max_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_angle_min_get(PointerRNA *ptr);
void FreestyleLineStyle_use_angle_min_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_length_min_get(PointerRNA *ptr);
void FreestyleLineStyle_use_length_min_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_nodes_get(PointerRNA *ptr);
void FreestyleLineStyle_use_nodes_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_split_length_get(PointerRNA *ptr);
void FreestyleLineStyle_use_split_length_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_split_pattern_get(PointerRNA *ptr);
void FreestyleLineStyle_use_split_pattern_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_use_texture_get(PointerRNA *ptr);
void FreestyleLineStyle_use_texture_set(PointerRNA *ptr, int value);

/**************** Freestyle Module ****************/

extern StructRNA RNA_FreestyleModuleSettings;

PointerRNA FreestyleModuleSettings_rna_type_get(PointerRNA *ptr);

PointerRNA FreestyleModuleSettings_script_get(PointerRNA *ptr);

int FreestyleModuleSettings_use_get(PointerRNA *ptr);
void FreestyleModuleSettings_use_set(PointerRNA *ptr, int value);

/**************** Style Modules ****************/

extern StructRNA RNA_FreestyleModules;

PointerRNA FreestyleModules_rna_type_get(PointerRNA *ptr);

struct FreestyleModuleConfig *FreestyleModules_new(struct ID *_selfid, struct FreestyleSettings *_self);
void FreestyleModules_remove(struct ID *_selfid, struct FreestyleSettings *_self, ReportList *reports, struct PointerRNA *module);
/**************** Freestyle Settings ****************/

extern StructRNA RNA_FreestyleSettings;

PointerRNA FreestyleSettings_rna_type_get(PointerRNA *ptr);

int FreestyleSettings_use_advanced_options_get(PointerRNA *ptr);
void FreestyleSettings_use_advanced_options_set(PointerRNA *ptr, int value);

enum {
	FreestyleSettings_mode_SCRIPT = 1,
	FreestyleSettings_mode_EDITOR = 2,
};

int FreestyleSettings_mode_get(PointerRNA *ptr);
void FreestyleSettings_mode_set(PointerRNA *ptr, int value);

float FreestyleSettings_crease_angle_get(PointerRNA *ptr);
void FreestyleSettings_crease_angle_set(PointerRNA *ptr, float value);

int FreestyleSettings_use_culling_get(PointerRNA *ptr);
void FreestyleSettings_use_culling_set(PointerRNA *ptr, int value);

int FreestyleSettings_use_smoothness_get(PointerRNA *ptr);
void FreestyleSettings_use_smoothness_set(PointerRNA *ptr, int value);

float FreestyleSettings_kr_derivative_epsilon_get(PointerRNA *ptr);
void FreestyleSettings_kr_derivative_epsilon_set(PointerRNA *ptr, float value);

void FreestyleSettings_linesets_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleSettings_linesets_next(CollectionPropertyIterator *iter);
void FreestyleSettings_linesets_end(CollectionPropertyIterator *iter);
int FreestyleSettings_linesets_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int FreestyleSettings_linesets_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int FreestyleSettings_use_material_boundaries_get(PointerRNA *ptr);
void FreestyleSettings_use_material_boundaries_set(PointerRNA *ptr, int value);

int FreestyleSettings_use_ridges_and_valleys_get(PointerRNA *ptr);
void FreestyleSettings_use_ridges_and_valleys_set(PointerRNA *ptr, int value);

float FreestyleSettings_sphere_radius_get(PointerRNA *ptr);
void FreestyleSettings_sphere_radius_set(PointerRNA *ptr, float value);

void FreestyleSettings_modules_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleSettings_modules_next(CollectionPropertyIterator *iter);
void FreestyleSettings_modules_end(CollectionPropertyIterator *iter);
int FreestyleSettings_modules_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int FreestyleSettings_use_suggestive_contours_get(PointerRNA *ptr);
void FreestyleSettings_use_suggestive_contours_set(PointerRNA *ptr, int value);

int FreestyleSettings_use_view_map_cache_get(PointerRNA *ptr);
void FreestyleSettings_use_view_map_cache_set(PointerRNA *ptr, int value);

/**************** Function Definition ****************/

extern StructRNA RNA_Function;

PointerRNA Function_rna_type_get(PointerRNA *ptr);

void Function_description_get(PointerRNA *ptr, char *value);
int Function_description_length(PointerRNA *ptr);
void Function_description_set(PointerRNA *ptr, const char *value);

void Function_identifier_get(PointerRNA *ptr, char *value);
int Function_identifier_length(PointerRNA *ptr);
void Function_identifier_set(PointerRNA *ptr, const char *value);

int Function_use_self_get(PointerRNA *ptr);
void Function_use_self_set(PointerRNA *ptr, int value);

void Function_parameters_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Function_parameters_next(CollectionPropertyIterator *iter);
void Function_parameters_end(CollectionPropertyIterator *iter);

int Function_is_registered_get(PointerRNA *ptr);
void Function_is_registered_set(PointerRNA *ptr, int value);

int Function_is_registered_optional_get(PointerRNA *ptr);
void Function_is_registered_optional_set(PointerRNA *ptr, int value);

int Function_use_self_type_get(PointerRNA *ptr);
void Function_use_self_type_set(PointerRNA *ptr, int value);

/**************** Grease Pencil Frame ****************/

extern StructRNA RNA_GPencilFrame;

PointerRNA GPencilFrame_rna_type_get(PointerRNA *ptr);

int GPencilFrame_frame_number_get(PointerRNA *ptr);
void GPencilFrame_frame_number_set(PointerRNA *ptr, int value);

int GPencilFrame_is_edited_get(PointerRNA *ptr);
void GPencilFrame_is_edited_set(PointerRNA *ptr, int value);

int GPencilFrame_select_get(PointerRNA *ptr);
void GPencilFrame_select_set(PointerRNA *ptr, int value);

void GPencilFrame_strokes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GPencilFrame_strokes_next(CollectionPropertyIterator *iter);
void GPencilFrame_strokes_end(CollectionPropertyIterator *iter);
int GPencilFrame_strokes_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void GPencilFrame_clear(struct bGPDframe *_self);
/**************** Grease Pencil Frames ****************/

extern StructRNA RNA_GPencilFrames;

PointerRNA GPencilFrames_rna_type_get(PointerRNA *ptr);

struct bGPDframe *GPencilFrames_new(struct bGPDlayer *_self, ReportList *reports, int frame_number);
void GPencilFrames_remove(struct bGPDlayer *_self, ReportList *reports, struct PointerRNA *frame);
struct bGPDframe *GPencilFrames_copy(struct bGPDlayer *_self, struct bGPDframe *source);
/**************** Grease Pencil Layer ****************/

extern StructRNA RNA_GPencilLayer;

PointerRNA GPencilLayer_rna_type_get(PointerRNA *ptr);

PointerRNA GPencilLayer_active_frame_get(PointerRNA *ptr);

void GPencilLayer_color_get(PointerRNA *ptr, float values[3]);
void GPencilLayer_color_set(PointerRNA *ptr, const float values[3]);

int GPencilLayer_lock_frame_get(PointerRNA *ptr);
void GPencilLayer_lock_frame_set(PointerRNA *ptr, int value);

void GPencilLayer_frames_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GPencilLayer_frames_next(CollectionPropertyIterator *iter);
void GPencilLayer_frames_end(CollectionPropertyIterator *iter);
int GPencilLayer_frames_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int GPencilLayer_hide_get(PointerRNA *ptr);
void GPencilLayer_hide_set(PointerRNA *ptr, int value);

#define GPencilLayer_info_MAX 128

void GPencilLayer_info_get(PointerRNA *ptr, char *value);
int GPencilLayer_info_length(PointerRNA *ptr);
void GPencilLayer_info_set(PointerRNA *ptr, const char *value);

int GPencilLayer_lock_get(PointerRNA *ptr);
void GPencilLayer_lock_set(PointerRNA *ptr, int value);

int GPencilLayer_ghost_range_max_get(PointerRNA *ptr);
void GPencilLayer_ghost_range_max_set(PointerRNA *ptr, int value);

int GPencilLayer_use_onion_skinning_get(PointerRNA *ptr);
void GPencilLayer_use_onion_skinning_set(PointerRNA *ptr, int value);

float GPencilLayer_alpha_get(PointerRNA *ptr);
void GPencilLayer_alpha_set(PointerRNA *ptr, float value);

int GPencilLayer_select_get(PointerRNA *ptr);
void GPencilLayer_select_set(PointerRNA *ptr, int value);

int GPencilLayer_show_points_get(PointerRNA *ptr);
void GPencilLayer_show_points_set(PointerRNA *ptr, int value);

int GPencilLayer_line_width_get(PointerRNA *ptr);
void GPencilLayer_line_width_set(PointerRNA *ptr, int value);

int GPencilLayer_show_x_ray_get(PointerRNA *ptr);
void GPencilLayer_show_x_ray_set(PointerRNA *ptr, int value);

void GPencilLayer_clear(struct bGPDlayer *_self);
/**************** Grease Pencil Stroke ****************/

extern StructRNA RNA_GPencilStroke;

PointerRNA GPencilStroke_rna_type_get(PointerRNA *ptr);

enum {
	GPencilStroke_draw_mode_SCREEN = 0,
	GPencilStroke_draw_mode_3DSPACE = 1,
	GPencilStroke_draw_mode_2DSPACE = 2,
	GPencilStroke_draw_mode_2DIMAGE = 4,
};

int GPencilStroke_draw_mode_get(PointerRNA *ptr);
void GPencilStroke_draw_mode_set(PointerRNA *ptr, int value);

void GPencilStroke_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GPencilStroke_points_next(CollectionPropertyIterator *iter);
void GPencilStroke_points_end(CollectionPropertyIterator *iter);
int GPencilStroke_points_length(PointerRNA *ptr);
int GPencilStroke_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Grease Pencil Stroke Point ****************/

extern StructRNA RNA_GPencilStrokePoint;

PointerRNA GPencilStrokePoint_rna_type_get(PointerRNA *ptr);

void GPencilStrokePoint_co_get(PointerRNA *ptr, float values[3]);
void GPencilStrokePoint_co_set(PointerRNA *ptr, const float values[3]);

float GPencilStrokePoint_pressure_get(PointerRNA *ptr);
void GPencilStrokePoint_pressure_set(PointerRNA *ptr, float value);

/**************** Grease Pencil Stroke Points ****************/

extern StructRNA RNA_GPencilStrokePoints;

PointerRNA GPencilStrokePoints_rna_type_get(PointerRNA *ptr);

void GPencilStrokePoints_add(struct bGPDstroke *_self, int count);
void GPencilStrokePoints_pop(struct bGPDstroke *_self, ReportList *reports, int index);
/**************** Grease Pencil Frames ****************/

extern StructRNA RNA_GPencilStrokes;

PointerRNA GPencilStrokes_rna_type_get(PointerRNA *ptr);

struct bGPDstroke *GPencilStrokes_new(struct bGPDframe *_self);
void GPencilStrokes_remove(struct bGPDframe *_self, ReportList *reports, struct PointerRNA *stroke);
/**************** Game Actuator ****************/

extern StructRNA RNA_GameActuator;
extern StructRNA RNA_Actuator;

#define GameActuator_filename_MAX 64

void GameActuator_filename_get(PointerRNA *ptr, char *value);
int GameActuator_filename_length(PointerRNA *ptr);
void GameActuator_filename_set(PointerRNA *ptr, const char *value);

enum {
	GameActuator_mode_START = 0,
	GameActuator_mode_RESTART = 2,
	GameActuator_mode_QUIT = 3,
	GameActuator_mode_SAVECFG = 4,
	GameActuator_mode_LOADCFG = 5,
};

int GameActuator_mode_get(PointerRNA *ptr);
void GameActuator_mode_set(PointerRNA *ptr, int value);

/**************** Game Boolean Property ****************/

extern StructRNA RNA_GameBooleanProperty;
extern StructRNA RNA_GameProperty;

int GameBooleanProperty_value_get(PointerRNA *ptr);
void GameBooleanProperty_value_set(PointerRNA *ptr, int value);

/**************** Game Float Property ****************/

extern StructRNA RNA_GameFloatProperty;
extern StructRNA RNA_GameProperty;

float GameFloatProperty_value_get(PointerRNA *ptr);
void GameFloatProperty_value_set(PointerRNA *ptr, float value);

/**************** Game Integer Property ****************/

extern StructRNA RNA_GameIntProperty;
extern StructRNA RNA_GameProperty;

int GameIntProperty_value_get(PointerRNA *ptr);
void GameIntProperty_value_set(PointerRNA *ptr, int value);

/**************** Game Object Settings ****************/

extern StructRNA RNA_GameObjectSettings;

PointerRNA GameObjectSettings_rna_type_get(PointerRNA *ptr);

int GameObjectSettings_use_actor_get(PointerRNA *ptr);
void GameObjectSettings_use_actor_set(PointerRNA *ptr, int value);

void GameObjectSettings_actuators_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GameObjectSettings_actuators_next(CollectionPropertyIterator *iter);
void GameObjectSettings_actuators_end(CollectionPropertyIterator *iter);
int GameObjectSettings_actuators_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int GameObjectSettings_actuators_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int GameObjectSettings_use_all_states_get(PointerRNA *ptr);
void GameObjectSettings_use_all_states_set(PointerRNA *ptr, int value);

int GameObjectSettings_use_anisotropic_friction_get(PointerRNA *ptr);
void GameObjectSettings_use_anisotropic_friction_set(PointerRNA *ptr, int value);

enum {
	GameObjectSettings_collision_bounds_type_BOX = 0,
	GameObjectSettings_collision_bounds_type_SPHERE = 1,
	GameObjectSettings_collision_bounds_type_CYLINDER = 2,
	GameObjectSettings_collision_bounds_type_CONE = 3,
	GameObjectSettings_collision_bounds_type_CONVEX_HULL = 5,
	GameObjectSettings_collision_bounds_type_TRIANGLE_MESH = 4,
	GameObjectSettings_collision_bounds_type_CAPSULE = 7,
};

int GameObjectSettings_collision_bounds_type_get(PointerRNA *ptr);
void GameObjectSettings_collision_bounds_type_set(PointerRNA *ptr, int value);

int GameObjectSettings_use_collision_compound_get(PointerRNA *ptr);
void GameObjectSettings_use_collision_compound_set(PointerRNA *ptr, int value);

void GameObjectSettings_collision_group_get(PointerRNA *ptr, int values[8]);
void GameObjectSettings_collision_group_set(PointerRNA *ptr, const int values[8]);

float GameObjectSettings_collision_margin_get(PointerRNA *ptr);
void GameObjectSettings_collision_margin_set(PointerRNA *ptr, float value);

void GameObjectSettings_collision_mask_get(PointerRNA *ptr, int values[8]);
void GameObjectSettings_collision_mask_set(PointerRNA *ptr, const int values[8]);

void GameObjectSettings_controllers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GameObjectSettings_controllers_next(CollectionPropertyIterator *iter);
void GameObjectSettings_controllers_end(CollectionPropertyIterator *iter);
int GameObjectSettings_controllers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int GameObjectSettings_controllers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int GameObjectSettings_use_obstacle_create_get(PointerRNA *ptr);
void GameObjectSettings_use_obstacle_create_set(PointerRNA *ptr, int value);

float GameObjectSettings_damping_get(PointerRNA *ptr);
void GameObjectSettings_damping_set(PointerRNA *ptr, float value);

int GameObjectSettings_show_debug_state_get(PointerRNA *ptr);
void GameObjectSettings_show_debug_state_set(PointerRNA *ptr, int value);

float GameObjectSettings_fall_speed_get(PointerRNA *ptr);
void GameObjectSettings_fall_speed_set(PointerRNA *ptr, float value);

float GameObjectSettings_form_factor_get(PointerRNA *ptr);
void GameObjectSettings_form_factor_set(PointerRNA *ptr, float value);

void GameObjectSettings_friction_coefficients_get(PointerRNA *ptr, float values[3]);
void GameObjectSettings_friction_coefficients_set(PointerRNA *ptr, const float values[3]);

int GameObjectSettings_use_ghost_get(PointerRNA *ptr);
void GameObjectSettings_use_ghost_set(PointerRNA *ptr, int value);

void GameObjectSettings_states_initial_get(PointerRNA *ptr, int values[30]);
void GameObjectSettings_states_initial_set(PointerRNA *ptr, const int values[30]);

float GameObjectSettings_jump_speed_get(PointerRNA *ptr);
void GameObjectSettings_jump_speed_set(PointerRNA *ptr, float value);

int GameObjectSettings_lock_location_x_get(PointerRNA *ptr);
void GameObjectSettings_lock_location_x_set(PointerRNA *ptr, int value);

int GameObjectSettings_lock_rotation_x_get(PointerRNA *ptr);
void GameObjectSettings_lock_rotation_x_set(PointerRNA *ptr, int value);

int GameObjectSettings_lock_location_y_get(PointerRNA *ptr);
void GameObjectSettings_lock_location_y_set(PointerRNA *ptr, int value);

int GameObjectSettings_lock_rotation_y_get(PointerRNA *ptr);
void GameObjectSettings_lock_rotation_y_set(PointerRNA *ptr, int value);

int GameObjectSettings_lock_location_z_get(PointerRNA *ptr);
void GameObjectSettings_lock_location_z_set(PointerRNA *ptr, int value);

int GameObjectSettings_lock_rotation_z_get(PointerRNA *ptr);
void GameObjectSettings_lock_rotation_z_set(PointerRNA *ptr, int value);

int GameObjectSettings_use_activity_culling_get(PointerRNA *ptr);
void GameObjectSettings_use_activity_culling_set(PointerRNA *ptr, int value);

float GameObjectSettings_mass_get(PointerRNA *ptr);
void GameObjectSettings_mass_set(PointerRNA *ptr, float value);

int GameObjectSettings_use_sleep_get(PointerRNA *ptr);
void GameObjectSettings_use_sleep_set(PointerRNA *ptr, int value);

float GameObjectSettings_obstacle_radius_get(PointerRNA *ptr);
void GameObjectSettings_obstacle_radius_set(PointerRNA *ptr, float value);

enum {
	GameObjectSettings_physics_type_NO_COLLISION = 0,
	GameObjectSettings_physics_type_STATIC = 1,
	GameObjectSettings_physics_type_DYNAMIC = 2,
	GameObjectSettings_physics_type_RIGID_BODY = 3,
	GameObjectSettings_physics_type_SOFT_BODY = 4,
	GameObjectSettings_physics_type_OCCLUDE = 5,
	GameObjectSettings_physics_type_SENSOR = 6,
	GameObjectSettings_physics_type_NAVMESH = 7,
	GameObjectSettings_physics_type_CHARACTER = 8,
};

int GameObjectSettings_physics_type_get(PointerRNA *ptr);
void GameObjectSettings_physics_type_set(PointerRNA *ptr, int value);

void GameObjectSettings_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GameObjectSettings_properties_next(CollectionPropertyIterator *iter);
void GameObjectSettings_properties_end(CollectionPropertyIterator *iter);
int GameObjectSettings_properties_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int GameObjectSettings_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float GameObjectSettings_radius_get(PointerRNA *ptr);
void GameObjectSettings_radius_set(PointerRNA *ptr, float value);

int GameObjectSettings_use_record_animation_get(PointerRNA *ptr);
void GameObjectSettings_use_record_animation_set(PointerRNA *ptr, int value);

int GameObjectSettings_use_rotate_from_normal_get(PointerRNA *ptr);
void GameObjectSettings_use_rotate_from_normal_set(PointerRNA *ptr, int value);

float GameObjectSettings_rotation_damping_get(PointerRNA *ptr);
void GameObjectSettings_rotation_damping_set(PointerRNA *ptr, float value);

void GameObjectSettings_sensors_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GameObjectSettings_sensors_next(CollectionPropertyIterator *iter);
void GameObjectSettings_sensors_end(CollectionPropertyIterator *iter);
int GameObjectSettings_sensors_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int GameObjectSettings_sensors_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int GameObjectSettings_show_actuators_get(PointerRNA *ptr);
void GameObjectSettings_show_actuators_set(PointerRNA *ptr, int value);

int GameObjectSettings_show_controllers_get(PointerRNA *ptr);
void GameObjectSettings_show_controllers_set(PointerRNA *ptr, int value);

int GameObjectSettings_show_sensors_get(PointerRNA *ptr);
void GameObjectSettings_show_sensors_set(PointerRNA *ptr, int value);

PointerRNA GameObjectSettings_soft_body_get(PointerRNA *ptr);

void GameObjectSettings_states_visible_get(PointerRNA *ptr, int values[30]);
void GameObjectSettings_states_visible_set(PointerRNA *ptr, const int values[30]);

int GameObjectSettings_show_state_panel_get(PointerRNA *ptr);
void GameObjectSettings_show_state_panel_set(PointerRNA *ptr, int value);

float GameObjectSettings_step_height_get(PointerRNA *ptr);
void GameObjectSettings_step_height_set(PointerRNA *ptr, float value);

int GameObjectSettings_use_collision_bounds_get(PointerRNA *ptr);
void GameObjectSettings_use_collision_bounds_set(PointerRNA *ptr, int value);

int GameObjectSettings_use_material_physics_fh_get(PointerRNA *ptr);
void GameObjectSettings_use_material_physics_fh_set(PointerRNA *ptr, int value);

void GameObjectSettings_used_states_get(PointerRNA *ptr, int values[30]);
void GameObjectSettings_used_states_set(PointerRNA *ptr, const int values[30]);

float GameObjectSettings_velocity_max_get(PointerRNA *ptr);
void GameObjectSettings_velocity_max_set(PointerRNA *ptr, float value);

float GameObjectSettings_velocity_min_get(PointerRNA *ptr);
void GameObjectSettings_velocity_min_set(PointerRNA *ptr, float value);

/**************** Game Property ****************/

extern StructRNA RNA_GameProperty;

PointerRNA GameProperty_rna_type_get(PointerRNA *ptr);

#define GameProperty_name_MAX 64

void GameProperty_name_get(PointerRNA *ptr, char *value);
int GameProperty_name_length(PointerRNA *ptr);
void GameProperty_name_set(PointerRNA *ptr, const char *value);

int GameProperty_show_debug_get(PointerRNA *ptr);
void GameProperty_show_debug_set(PointerRNA *ptr, int value);

enum {
	GameProperty_type_BOOL = 0,
	GameProperty_type_INT = 1,
	GameProperty_type_FLOAT = 2,
	GameProperty_type_STRING = 3,
	GameProperty_type_TIMER = 5,
};

int GameProperty_type_get(PointerRNA *ptr);
void GameProperty_type_set(PointerRNA *ptr, int value);

/**************** Game Soft Body Settings ****************/

extern StructRNA RNA_GameSoftBodySettings;

PointerRNA GameSoftBodySettings_rna_type_get(PointerRNA *ptr);

int GameSoftBodySettings_use_bending_constraints_get(PointerRNA *ptr);
void GameSoftBodySettings_use_bending_constraints_set(PointerRNA *ptr, int value);

int GameSoftBodySettings_cluster_iterations_get(PointerRNA *ptr);
void GameSoftBodySettings_cluster_iterations_set(PointerRNA *ptr, int value);

float GameSoftBodySettings_dynamic_friction_get(PointerRNA *ptr);
void GameSoftBodySettings_dynamic_friction_set(PointerRNA *ptr, float value);

float GameSoftBodySettings_linear_stiffness_get(PointerRNA *ptr);
void GameSoftBodySettings_linear_stiffness_set(PointerRNA *ptr, float value);

float GameSoftBodySettings_collision_margin_get(PointerRNA *ptr);
void GameSoftBodySettings_collision_margin_set(PointerRNA *ptr, float value);

int GameSoftBodySettings_location_iterations_get(PointerRNA *ptr);
void GameSoftBodySettings_location_iterations_set(PointerRNA *ptr, int value);

int GameSoftBodySettings_use_cluster_rigid_to_softbody_get(PointerRNA *ptr);
void GameSoftBodySettings_use_cluster_rigid_to_softbody_set(PointerRNA *ptr, int value);

int GameSoftBodySettings_use_shape_match_get(PointerRNA *ptr);
void GameSoftBodySettings_use_shape_match_set(PointerRNA *ptr, int value);

int GameSoftBodySettings_use_cluster_soft_to_softbody_get(PointerRNA *ptr);
void GameSoftBodySettings_use_cluster_soft_to_softbody_set(PointerRNA *ptr, int value);

float GameSoftBodySettings_shape_threshold_get(PointerRNA *ptr);
void GameSoftBodySettings_shape_threshold_set(PointerRNA *ptr, float value);

float GameSoftBodySettings_weld_threshold_get(PointerRNA *ptr);
void GameSoftBodySettings_weld_threshold_set(PointerRNA *ptr, float value);

/**************** Game String Property ****************/

extern StructRNA RNA_GameStringProperty;
extern StructRNA RNA_GameProperty;

#define GameStringProperty_value_MAX 128

void GameStringProperty_value_get(PointerRNA *ptr, char *value);
int GameStringProperty_value_length(PointerRNA *ptr);
void GameStringProperty_value_set(PointerRNA *ptr, const char *value);

/**************** Game Timer Property ****************/

extern StructRNA RNA_GameTimerProperty;
extern StructRNA RNA_GameProperty;

float GameTimerProperty_value_get(PointerRNA *ptr);
void GameTimerProperty_value_set(PointerRNA *ptr, float value);

/**************** Gamma Cross Sequence ****************/

extern StructRNA RNA_GammaCrossSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

PointerRNA GammaCrossSequence_input_1_get(PointerRNA *ptr);

PointerRNA GammaCrossSequence_input_2_get(PointerRNA *ptr);

int GammaCrossSequence_input_count_get(PointerRNA *ptr);
void GammaCrossSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Gaussian Blur Sequence ****************/

extern StructRNA RNA_GaussianBlurSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

PointerRNA GaussianBlurSequence_input_1_get(PointerRNA *ptr);

float GaussianBlurSequence_size_x_get(PointerRNA *ptr);
void GaussianBlurSequence_size_x_set(PointerRNA *ptr, float value);

float GaussianBlurSequence_size_y_get(PointerRNA *ptr);
void GaussianBlurSequence_size_y_set(PointerRNA *ptr, float value);

int GaussianBlurSequence_input_count_get(PointerRNA *ptr);
void GaussianBlurSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Glow Sequence ****************/

extern StructRNA RNA_GlowSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

float GlowSequence_blur_radius_get(PointerRNA *ptr);
void GlowSequence_blur_radius_set(PointerRNA *ptr, float value);

float GlowSequence_boost_factor_get(PointerRNA *ptr);
void GlowSequence_boost_factor_set(PointerRNA *ptr, float value);

float GlowSequence_clamp_get(PointerRNA *ptr);
void GlowSequence_clamp_set(PointerRNA *ptr, float value);

PointerRNA GlowSequence_input_1_get(PointerRNA *ptr);

int GlowSequence_use_only_boost_get(PointerRNA *ptr);
void GlowSequence_use_only_boost_set(PointerRNA *ptr, int value);

int GlowSequence_quality_get(PointerRNA *ptr);
void GlowSequence_quality_set(PointerRNA *ptr, int value);

float GlowSequence_threshold_get(PointerRNA *ptr);
void GlowSequence_threshold_set(PointerRNA *ptr, float value);

int GlowSequence_input_count_get(PointerRNA *ptr);
void GlowSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Grease Pencil ****************/

extern StructRNA RNA_GreasePencil;
extern StructRNA RNA_ID;

enum {
	GreasePencil_draw_mode_CURSOR = 16,
	GreasePencil_draw_mode_VIEW = 0,
	GreasePencil_draw_mode_SURFACE = 48,
	GreasePencil_draw_mode_STROKE = 80,
};

int GreasePencil_draw_mode_get(PointerRNA *ptr);
void GreasePencil_draw_mode_set(PointerRNA *ptr, int value);

void GreasePencil_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencil_layers_next(CollectionPropertyIterator *iter);
void GreasePencil_layers_end(CollectionPropertyIterator *iter);
int GreasePencil_layers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int GreasePencil_layers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int GreasePencil_use_stroke_endpoints_get(PointerRNA *ptr);
void GreasePencil_use_stroke_endpoints_set(PointerRNA *ptr, int value);

void GreasePencil_clear(struct bGPdata *_self);
/**************** Grease Pencil Layers ****************/

extern StructRNA RNA_GreasePencilLayers;

PointerRNA GreasePencilLayers_rna_type_get(PointerRNA *ptr);

PointerRNA GreasePencilLayers_active_get(PointerRNA *ptr);

struct bGPDlayer *GreasePencilLayers_new(struct bGPdata *_self, const char * name, int set_active);
void GreasePencilLayers_remove(struct bGPdata *_self, ReportList *reports, struct PointerRNA *layer);
/**************** Group ****************/

extern StructRNA RNA_Group;
extern StructRNA RNA_ID;

void Group_layers_get(PointerRNA *ptr, int values[20]);
void Group_layers_set(PointerRNA *ptr, const int values[20]);

void Group_dupli_offset_get(PointerRNA *ptr, float values[3]);
void Group_dupli_offset_set(PointerRNA *ptr, const float values[3]);

void Group_objects_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Group_objects_next(CollectionPropertyIterator *iter);
void Group_objects_end(CollectionPropertyIterator *iter);
int Group_objects_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Group_objects_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Group Objects ****************/

extern StructRNA RNA_GroupObjects;

PointerRNA GroupObjects_rna_type_get(PointerRNA *ptr);

void GroupObjects_link(struct Group *_self, bContext *C, ReportList *reports, struct Object *object);
void GroupObjects_unlink(struct Group *_self, bContext *C, ReportList *reports, struct Object *object);
/**************** Header ****************/

extern StructRNA RNA_Header;

PointerRNA Header_rna_type_get(PointerRNA *ptr);

void Header_bl_idname_get(PointerRNA *ptr, char *value);
int Header_bl_idname_length(PointerRNA *ptr);
void Header_bl_idname_set(PointerRNA *ptr, const char *value);

PointerRNA Header_layout_get(PointerRNA *ptr);

enum {
	Header_bl_space_type_EMPTY = 0,
	Header_bl_space_type_VIEW_3D = 1,
	Header_bl_space_type_TIMELINE = 15,
	Header_bl_space_type_GRAPH_EDITOR = 2,
	Header_bl_space_type_DOPESHEET_EDITOR = 12,
	Header_bl_space_type_NLA_EDITOR = 13,
	Header_bl_space_type_IMAGE_EDITOR = 6,
	Header_bl_space_type_SEQUENCE_EDITOR = 8,
	Header_bl_space_type_CLIP_EDITOR = 20,
	Header_bl_space_type_TEXT_EDITOR = 9,
	Header_bl_space_type_NODE_EDITOR = 16,
	Header_bl_space_type_LOGIC_EDITOR = 17,
	Header_bl_space_type_PROPERTIES = 4,
	Header_bl_space_type_OUTLINER = 3,
	Header_bl_space_type_USER_PREFERENCES = 19,
	Header_bl_space_type_INFO = 7,
	Header_bl_space_type_FILE_BROWSER = 5,
	Header_bl_space_type_CONSOLE = 18,
};

int Header_bl_space_type_get(PointerRNA *ptr);
void Header_bl_space_type_set(PointerRNA *ptr, int value);

void Header_draw(struct Header *_self, struct bContext *context);
/**************** Hemi Lamp ****************/

extern StructRNA RNA_HemiLamp;
extern StructRNA RNA_Lamp;
extern StructRNA RNA_ID;

/**************** Histogram ****************/

extern StructRNA RNA_Histogram;

PointerRNA Histogram_rna_type_get(PointerRNA *ptr);

enum {
	Histogram_mode_LUMA = 0,
	Histogram_mode_RGB = 1,
	Histogram_mode_R = 2,
	Histogram_mode_G = 3,
	Histogram_mode_B = 4,
	Histogram_mode_A = 5,
};

int Histogram_mode_get(PointerRNA *ptr);
void Histogram_mode_set(PointerRNA *ptr, int value);

int Histogram_show_line_get(PointerRNA *ptr);
void Histogram_show_line_set(PointerRNA *ptr, int value);

/**************** Hook Modifier ****************/

extern StructRNA RNA_HookModifier;
extern StructRNA RNA_Modifier;

float HookModifier_falloff_get(PointerRNA *ptr);
void HookModifier_falloff_set(PointerRNA *ptr, float value);

float HookModifier_force_get(PointerRNA *ptr);
void HookModifier_force_set(PointerRNA *ptr, float value);

void HookModifier_center_get(PointerRNA *ptr, float values[3]);
void HookModifier_center_set(PointerRNA *ptr, const float values[3]);

PointerRNA HookModifier_object_get(PointerRNA *ptr);

#define HookModifier_subtarget_MAX 64

void HookModifier_subtarget_get(PointerRNA *ptr, char *value);
int HookModifier_subtarget_length(PointerRNA *ptr);
void HookModifier_subtarget_set(PointerRNA *ptr, const char *value);

#define HookModifier_vertex_group_MAX 64

void HookModifier_vertex_group_get(PointerRNA *ptr, char *value);
int HookModifier_vertex_group_length(PointerRNA *ptr);
void HookModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** HueCorrectModifier ****************/

extern StructRNA RNA_HueCorrectModifier;
extern StructRNA RNA_SequenceModifier;

PointerRNA HueCorrectModifier_curve_mapping_get(PointerRNA *ptr);

/**************** ID ****************/

extern StructRNA RNA_ID;

PointerRNA ID_rna_type_get(PointerRNA *ptr);

#define ID_name_MAX 64

void ID_name_get(PointerRNA *ptr, char *value);
int ID_name_length(PointerRNA *ptr);
void ID_name_set(PointerRNA *ptr, const char *value);

int ID_use_fake_user_get(PointerRNA *ptr);
void ID_use_fake_user_set(PointerRNA *ptr, int value);

int ID_is_library_indirect_get(PointerRNA *ptr);
void ID_is_library_indirect_set(PointerRNA *ptr, int value);

int ID_is_updated_get(PointerRNA *ptr);
void ID_is_updated_set(PointerRNA *ptr, int value);

int ID_is_updated_data_get(PointerRNA *ptr);
void ID_is_updated_data_set(PointerRNA *ptr, int value);

PointerRNA ID_library_get(PointerRNA *ptr);

int ID_tag_get(PointerRNA *ptr);
void ID_tag_set(PointerRNA *ptr, int value);

int ID_users_get(PointerRNA *ptr);
void ID_users_set(PointerRNA *ptr, int value);

struct ID *ID_copy(struct ID *_self);
void ID_user_clear(struct ID *_self);
struct AnimData *ID_animation_data_create(struct ID *_self);
void ID_animation_data_clear(struct ID *_self);
void ID_update_tag(struct ID *_self, ReportList *reports, int refresh);
/**************** ID Materials ****************/

extern StructRNA RNA_IDMaterials;

PointerRNA IDMaterials_rna_type_get(PointerRNA *ptr);

void IDMaterials_append(struct ID *_self, struct Material *material);
struct Material *IDMaterials_pop(struct ID *_self, ReportList *reports, int index, int update_data);
void IDMaterials_clear(struct ID *_self, int update_data);
/**************** IKParam ****************/

extern StructRNA RNA_IKParam;

PointerRNA IKParam_rna_type_get(PointerRNA *ptr);

enum {
	IKParam_ik_solver_LEGACY = 0,
	IKParam_ik_solver_ITASC = 1,
};

int IKParam_ik_solver_get(PointerRNA *ptr);
void IKParam_ik_solver_set(PointerRNA *ptr, int value);

/**************** Image ****************/

extern StructRNA RNA_Image;
extern StructRNA RNA_ID;

enum {
	Image_alpha_mode_STRAIGHT = 0,
	Image_alpha_mode_PREMUL = 1,
};

int Image_alpha_mode_get(PointerRNA *ptr);
void Image_alpha_mode_set(PointerRNA *ptr, int value);

int Image_use_animation_get(PointerRNA *ptr);
void Image_use_animation_set(PointerRNA *ptr, int value);

int Image_frame_end_get(PointerRNA *ptr);
void Image_frame_end_set(PointerRNA *ptr, int value);

int Image_fps_get(PointerRNA *ptr);
void Image_fps_set(PointerRNA *ptr, int value);

int Image_frame_start_get(PointerRNA *ptr);
void Image_frame_start_set(PointerRNA *ptr, int value);

int Image_bindcode_get(PointerRNA *ptr);
void Image_bindcode_set(PointerRNA *ptr, int value);

int Image_channels_get(PointerRNA *ptr);
void Image_channels_set(PointerRNA *ptr, int value);

int Image_use_clamp_x_get(PointerRNA *ptr);
void Image_use_clamp_x_set(PointerRNA *ptr, int value);

int Image_use_clamp_y_get(PointerRNA *ptr);
void Image_use_clamp_y_set(PointerRNA *ptr, int value);

void Image_generated_color_get(PointerRNA *ptr, float values[4]);
void Image_generated_color_set(PointerRNA *ptr, const float values[4]);

PointerRNA Image_colorspace_settings_get(PointerRNA *ptr);

int Image_depth_get(PointerRNA *ptr);
void Image_depth_set(PointerRNA *ptr, int value);

int Image_is_dirty_get(PointerRNA *ptr);
void Image_is_dirty_set(PointerRNA *ptr, int value);

void Image_display_aspect_get(PointerRNA *ptr, float values[2]);
void Image_display_aspect_set(PointerRNA *ptr, const float values[2]);

int Image_frame_duration_get(PointerRNA *ptr);
void Image_frame_duration_set(PointerRNA *ptr, int value);

enum {
	Image_field_order_EVEN = 0,
	Image_field_order_ODD = 2,
};

int Image_field_order_get(PointerRNA *ptr);
void Image_field_order_set(PointerRNA *ptr, int value);

int Image_use_fields_get(PointerRNA *ptr);
void Image_use_fields_set(PointerRNA *ptr, int value);

enum {
	Image_file_format_BMP = 20,
	Image_file_format_IRIS = 1,
	Image_file_format_PNG = 17,
	Image_file_format_JPEG = 4,
	Image_file_format_TARGA = 0,
	Image_file_format_TARGA_RAW = 14,
	Image_file_format_AVI_JPEG = 16,
	Image_file_format_AVI_RAW = 15,
};

int Image_file_format_get(PointerRNA *ptr);
void Image_file_format_set(PointerRNA *ptr, int value);

#define Image_filepath_MAX 1024

void Image_filepath_get(PointerRNA *ptr, char *value);
int Image_filepath_length(PointerRNA *ptr);
void Image_filepath_set(PointerRNA *ptr, const char *value);

#define Image_filepath_raw_MAX 1024

void Image_filepath_raw_get(PointerRNA *ptr, char *value);
int Image_filepath_raw_length(PointerRNA *ptr);
void Image_filepath_raw_set(PointerRNA *ptr, const char *value);

int Image_use_generated_float_get(PointerRNA *ptr);
void Image_use_generated_float_set(PointerRNA *ptr, int value);

int Image_generated_height_get(PointerRNA *ptr);
void Image_generated_height_set(PointerRNA *ptr, int value);

enum {
	Image_generated_type_BLANK = 0,
	Image_generated_type_UV_GRID = 1,
	Image_generated_type_COLOR_GRID = 2,
};

int Image_generated_type_get(PointerRNA *ptr);
void Image_generated_type_set(PointerRNA *ptr, int value);

int Image_generated_width_get(PointerRNA *ptr);
void Image_generated_width_set(PointerRNA *ptr, int value);

int Image_has_data_get(PointerRNA *ptr);
void Image_has_data_set(PointerRNA *ptr, int value);

int Image_is_float_get(PointerRNA *ptr);
void Image_is_float_set(PointerRNA *ptr, int value);

enum {
	Image_mapping_UV = 0,
	Image_mapping_REFLECTION = 16,
};

int Image_mapping_get(PointerRNA *ptr);
void Image_mapping_set(PointerRNA *ptr, int value);

PointerRNA Image_packed_file_get(PointerRNA *ptr);

void Image_pixels_get(PointerRNA *ptr, float values[]);
void Image_pixels_set(PointerRNA *ptr, const float values[]);int Image_pixels_get_length(PointerRNA *ptr, int *arraylen);

void Image_render_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Image_render_slots_next(CollectionPropertyIterator *iter);
void Image_render_slots_end(CollectionPropertyIterator *iter);
int Image_render_slots_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void Image_resolution_get(PointerRNA *ptr, float values[2]);
void Image_resolution_set(PointerRNA *ptr, const float values[2]);

void Image_size_get(PointerRNA *ptr, int values[2]);
void Image_size_set(PointerRNA *ptr, const int values[2]);

enum {
	Image_source_FILE = 1,
	Image_source_SEQUENCE = 2,
	Image_source_MOVIE = 3,
	Image_source_GENERATED = 4,
	Image_source_VIEWER = 5,
};

int Image_source_get(PointerRNA *ptr);
void Image_source_set(PointerRNA *ptr, int value);

int Image_use_tiles_get(PointerRNA *ptr);
void Image_use_tiles_set(PointerRNA *ptr, int value);

int Image_tiles_x_get(PointerRNA *ptr);
void Image_tiles_x_set(PointerRNA *ptr, int value);

int Image_tiles_y_get(PointerRNA *ptr);
void Image_tiles_y_set(PointerRNA *ptr, int value);

enum {
	Image_type_IMAGE = 0,
	Image_type_MULTILAYER = 1,
	Image_type_UV_TEST = 2,
	Image_type_RENDER_RESULT = 4,
	Image_type_COMPOSITING = 5,
};

int Image_type_get(PointerRNA *ptr);
void Image_type_set(PointerRNA *ptr, int value);

int Image_use_alpha_get(PointerRNA *ptr);
void Image_use_alpha_set(PointerRNA *ptr, int value);

int Image_use_view_as_render_get(PointerRNA *ptr);
void Image_use_view_as_render_set(PointerRNA *ptr, int value);

void Image_save_render(struct Image *_self, bContext *C, ReportList *reports, const char * filepath, struct Scene *scene);
void Image_save(struct Image *_self, bContext *C, ReportList *reports);
void Image_pack(struct Image *_self, bContext *C, ReportList *reports, int as_png);
void Image_unpack(struct Image *_self, ReportList *reports, int method);
void Image_reload(struct Image *_self);
void Image_update(struct Image *_self, ReportList *reports);
void Image_scale(struct Image *_self, ReportList *reports, int width, int height);
int Image_gl_touch(struct Image *_self, ReportList *reports, int frame, int filter, int mag);
int Image_gl_load(struct Image *_self, ReportList *reports, int frame, int filter, int mag);
void Image_gl_free(struct Image *_self);
void Image_filepath_from_user(struct Image *_self, struct ImageUser *image_user, char * filepath);
/**************** Image Format ****************/

extern StructRNA RNA_ImageFormatSettings;

PointerRNA ImageFormatSettings_rna_type_get(PointerRNA *ptr);

int ImageFormatSettings_cineon_black_get(PointerRNA *ptr);
void ImageFormatSettings_cineon_black_set(PointerRNA *ptr, int value);

enum {
	ImageFormatSettings_color_depth_8 = 2,
	ImageFormatSettings_color_depth_10 = 4,
	ImageFormatSettings_color_depth_12 = 8,
	ImageFormatSettings_color_depth_16 = 16,
	ImageFormatSettings_color_depth_32 = 64,
};

int ImageFormatSettings_color_depth_get(PointerRNA *ptr);
void ImageFormatSettings_color_depth_set(PointerRNA *ptr, int value);

enum {
	ImageFormatSettings_color_mode_BW = 8,
	ImageFormatSettings_color_mode_RGB = 24,
	ImageFormatSettings_color_mode_RGBA = 32,
};

int ImageFormatSettings_color_mode_get(PointerRNA *ptr);
void ImageFormatSettings_color_mode_set(PointerRNA *ptr, int value);

int ImageFormatSettings_compression_get(PointerRNA *ptr);
void ImageFormatSettings_compression_set(PointerRNA *ptr, int value);

PointerRNA ImageFormatSettings_display_settings_get(PointerRNA *ptr);

enum {
	ImageFormatSettings_file_format_BMP = 20,
	ImageFormatSettings_file_format_IRIS = 1,
	ImageFormatSettings_file_format_PNG = 17,
	ImageFormatSettings_file_format_JPEG = 4,
	ImageFormatSettings_file_format_TARGA = 0,
	ImageFormatSettings_file_format_TARGA_RAW = 14,
	ImageFormatSettings_file_format_AVI_JPEG = 16,
	ImageFormatSettings_file_format_AVI_RAW = 15,
};

int ImageFormatSettings_file_format_get(PointerRNA *ptr);
void ImageFormatSettings_file_format_set(PointerRNA *ptr, int value);

float ImageFormatSettings_cineon_gamma_get(PointerRNA *ptr);
void ImageFormatSettings_cineon_gamma_set(PointerRNA *ptr, float value);

int ImageFormatSettings_use_cineon_log_get(PointerRNA *ptr);
void ImageFormatSettings_use_cineon_log_set(PointerRNA *ptr, int value);

int ImageFormatSettings_use_preview_get(PointerRNA *ptr);
void ImageFormatSettings_use_preview_set(PointerRNA *ptr, int value);

int ImageFormatSettings_quality_get(PointerRNA *ptr);
void ImageFormatSettings_quality_set(PointerRNA *ptr, int value);

PointerRNA ImageFormatSettings_view_settings_get(PointerRNA *ptr);

int ImageFormatSettings_cineon_white_get(PointerRNA *ptr);
void ImageFormatSettings_cineon_white_set(PointerRNA *ptr, int value);

int ImageFormatSettings_use_zbuffer_get(PointerRNA *ptr);
void ImageFormatSettings_use_zbuffer_set(PointerRNA *ptr, int value);

/**************** Image Paint ****************/

extern StructRNA RNA_ImagePaint;
extern StructRNA RNA_Paint;

int ImagePaint_normal_angle_get(PointerRNA *ptr);
void ImagePaint_normal_angle_set(PointerRNA *ptr, int value);

int ImagePaint_seam_bleed_get(PointerRNA *ptr);
void ImagePaint_seam_bleed_set(PointerRNA *ptr, int value);

PointerRNA ImagePaint_canvas_get(PointerRNA *ptr);

PointerRNA ImagePaint_clone_image_get(PointerRNA *ptr);

int ImagePaint_use_clone_layer_get(PointerRNA *ptr);
void ImagePaint_use_clone_layer_set(PointerRNA *ptr, int value);

int ImagePaint_use_backface_culling_get(PointerRNA *ptr);
void ImagePaint_use_backface_culling_set(PointerRNA *ptr, int value);

int ImagePaint_invert_stencil_get(PointerRNA *ptr);
void ImagePaint_invert_stencil_set(PointerRNA *ptr, int value);

int ImagePaint_missing_materials_get(PointerRNA *ptr);
void ImagePaint_missing_materials_set(PointerRNA *ptr, int value);

int ImagePaint_missing_stencil_get(PointerRNA *ptr);
void ImagePaint_missing_stencil_set(PointerRNA *ptr, int value);

int ImagePaint_missing_texture_get(PointerRNA *ptr);
void ImagePaint_missing_texture_set(PointerRNA *ptr, int value);

int ImagePaint_missing_uvs_get(PointerRNA *ptr);
void ImagePaint_missing_uvs_set(PointerRNA *ptr, int value);

enum {
	ImagePaint_mode_MATERIAL = 0,
	ImagePaint_mode_IMAGE = 1,
};

int ImagePaint_mode_get(PointerRNA *ptr);
void ImagePaint_mode_set(PointerRNA *ptr, int value);

int ImagePaint_use_normal_falloff_get(PointerRNA *ptr);
void ImagePaint_use_normal_falloff_set(PointerRNA *ptr, int value);

int ImagePaint_use_occlude_get(PointerRNA *ptr);
void ImagePaint_use_occlude_set(PointerRNA *ptr, int value);

void ImagePaint_stencil_color_get(PointerRNA *ptr, float values[3]);
void ImagePaint_stencil_color_set(PointerRNA *ptr, const float values[3]);

PointerRNA ImagePaint_stencil_image_get(PointerRNA *ptr);

int ImagePaint_use_stencil_layer_get(PointerRNA *ptr);
void ImagePaint_use_stencil_layer_set(PointerRNA *ptr, int value);

void ImagePaint_screen_grab_size_get(PointerRNA *ptr, int values[2]);
void ImagePaint_screen_grab_size_set(PointerRNA *ptr, const int values[2]);

int ImagePaint_detect_data(struct ImagePaintSettings *_self);
/**************** Image Sequence ****************/

extern StructRNA RNA_ImageSequence;
extern StructRNA RNA_Sequence;

enum {
	ImageSequence_alpha_mode_STRAIGHT = 0,
	ImageSequence_alpha_mode_PREMUL = 1,
};

int ImageSequence_alpha_mode_get(PointerRNA *ptr);
void ImageSequence_alpha_mode_set(PointerRNA *ptr, int value);

int ImageSequence_animation_offset_end_get(PointerRNA *ptr);
void ImageSequence_animation_offset_end_set(PointerRNA *ptr, int value);

int ImageSequence_animation_offset_start_get(PointerRNA *ptr);
void ImageSequence_animation_offset_start_set(PointerRNA *ptr, int value);

PointerRNA ImageSequence_colorspace_settings_get(PointerRNA *ptr);

int ImageSequence_use_float_get(PointerRNA *ptr);
void ImageSequence_use_float_set(PointerRNA *ptr, int value);

PointerRNA ImageSequence_crop_get(PointerRNA *ptr);

int ImageSequence_use_deinterlace_get(PointerRNA *ptr);
void ImageSequence_use_deinterlace_set(PointerRNA *ptr, int value);

#define ImageSequence_directory_MAX 768

void ImageSequence_directory_get(PointerRNA *ptr, char *value);
int ImageSequence_directory_length(PointerRNA *ptr);
void ImageSequence_directory_set(PointerRNA *ptr, const char *value);

void ImageSequence_elements_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ImageSequence_elements_next(CollectionPropertyIterator *iter);
void ImageSequence_elements_end(CollectionPropertyIterator *iter);
int ImageSequence_elements_length(PointerRNA *ptr);
int ImageSequence_elements_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int ImageSequence_use_reverse_frames_get(PointerRNA *ptr);
void ImageSequence_use_reverse_frames_set(PointerRNA *ptr, int value);

int ImageSequence_use_flip_x_get(PointerRNA *ptr);
void ImageSequence_use_flip_x_set(PointerRNA *ptr, int value);

int ImageSequence_use_flip_y_get(PointerRNA *ptr);
void ImageSequence_use_flip_y_set(PointerRNA *ptr, int value);

float ImageSequence_color_multiply_get(PointerRNA *ptr);
void ImageSequence_color_multiply_set(PointerRNA *ptr, float value);

PointerRNA ImageSequence_proxy_get(PointerRNA *ptr);

int ImageSequence_use_proxy_custom_directory_get(PointerRNA *ptr);
void ImageSequence_use_proxy_custom_directory_set(PointerRNA *ptr, int value);

int ImageSequence_use_proxy_custom_file_get(PointerRNA *ptr);
void ImageSequence_use_proxy_custom_file_set(PointerRNA *ptr, int value);

float ImageSequence_color_saturation_get(PointerRNA *ptr);
void ImageSequence_color_saturation_set(PointerRNA *ptr, float value);

float ImageSequence_strobe_get(PointerRNA *ptr);
void ImageSequence_strobe_set(PointerRNA *ptr, float value);

PointerRNA ImageSequence_transform_get(PointerRNA *ptr);

int ImageSequence_use_crop_get(PointerRNA *ptr);
void ImageSequence_use_crop_set(PointerRNA *ptr, int value);

int ImageSequence_use_proxy_get(PointerRNA *ptr);
void ImageSequence_use_proxy_set(PointerRNA *ptr, int value);

int ImageSequence_use_translation_get(PointerRNA *ptr);
void ImageSequence_use_translation_set(PointerRNA *ptr, int value);

/**************** Image Texture ****************/

extern StructRNA RNA_ImageTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

int ImageTexture_use_calculate_alpha_get(PointerRNA *ptr);
void ImageTexture_use_calculate_alpha_set(PointerRNA *ptr, int value);

float ImageTexture_checker_distance_get(PointerRNA *ptr);
void ImageTexture_checker_distance_set(PointerRNA *ptr, float value);

int ImageTexture_use_checker_even_get(PointerRNA *ptr);
void ImageTexture_use_checker_even_set(PointerRNA *ptr, int value);

int ImageTexture_use_checker_odd_get(PointerRNA *ptr);
void ImageTexture_use_checker_odd_set(PointerRNA *ptr, int value);

float ImageTexture_crop_max_x_get(PointerRNA *ptr);
void ImageTexture_crop_max_x_set(PointerRNA *ptr, float value);

float ImageTexture_crop_max_y_get(PointerRNA *ptr);
void ImageTexture_crop_max_y_set(PointerRNA *ptr, float value);

float ImageTexture_crop_min_x_get(PointerRNA *ptr);
void ImageTexture_crop_min_x_set(PointerRNA *ptr, float value);

float ImageTexture_crop_min_y_get(PointerRNA *ptr);
void ImageTexture_crop_min_y_set(PointerRNA *ptr, float value);

int ImageTexture_use_derivative_map_get(PointerRNA *ptr);
void ImageTexture_use_derivative_map_set(PointerRNA *ptr, int value);

enum {
	ImageTexture_extension_EXTEND = 1,
	ImageTexture_extension_CLIP = 2,
	ImageTexture_extension_CLIP_CUBE = 4,
	ImageTexture_extension_REPEAT = 3,
	ImageTexture_extension_CHECKER = 5,
};

int ImageTexture_extension_get(PointerRNA *ptr);
void ImageTexture_extension_set(PointerRNA *ptr, int value);

enum {
	ImageTexture_filter_type_BOX = 0,
	ImageTexture_filter_type_EWA = 1,
	ImageTexture_filter_type_FELINE = 2,
	ImageTexture_filter_type_AREA = 3,
};

int ImageTexture_filter_type_get(PointerRNA *ptr);
void ImageTexture_filter_type_set(PointerRNA *ptr, int value);

int ImageTexture_filter_eccentricity_get(PointerRNA *ptr);
void ImageTexture_filter_eccentricity_set(PointerRNA *ptr, int value);

int ImageTexture_filter_probes_get(PointerRNA *ptr);
void ImageTexture_filter_probes_set(PointerRNA *ptr, int value);

float ImageTexture_filter_size_get(PointerRNA *ptr);
void ImageTexture_filter_size_set(PointerRNA *ptr, float value);

int ImageTexture_use_flip_axis_get(PointerRNA *ptr);
void ImageTexture_use_flip_axis_set(PointerRNA *ptr, int value);

PointerRNA ImageTexture_image_get(PointerRNA *ptr);

PointerRNA ImageTexture_image_user_get(PointerRNA *ptr);

int ImageTexture_use_interpolation_get(PointerRNA *ptr);
void ImageTexture_use_interpolation_set(PointerRNA *ptr, int value);

int ImageTexture_invert_alpha_get(PointerRNA *ptr);
void ImageTexture_invert_alpha_set(PointerRNA *ptr, int value);

int ImageTexture_use_mipmap_get(PointerRNA *ptr);
void ImageTexture_use_mipmap_set(PointerRNA *ptr, int value);

int ImageTexture_use_mipmap_gauss_get(PointerRNA *ptr);
void ImageTexture_use_mipmap_gauss_set(PointerRNA *ptr, int value);

int ImageTexture_use_filter_size_min_get(PointerRNA *ptr);
void ImageTexture_use_filter_size_min_set(PointerRNA *ptr, int value);

int ImageTexture_use_mirror_x_get(PointerRNA *ptr);
void ImageTexture_use_mirror_x_set(PointerRNA *ptr, int value);

int ImageTexture_use_mirror_y_get(PointerRNA *ptr);
void ImageTexture_use_mirror_y_set(PointerRNA *ptr, int value);

int ImageTexture_use_normal_map_get(PointerRNA *ptr);
void ImageTexture_use_normal_map_set(PointerRNA *ptr, int value);

int ImageTexture_repeat_x_get(PointerRNA *ptr);
void ImageTexture_repeat_x_set(PointerRNA *ptr, int value);

int ImageTexture_repeat_y_get(PointerRNA *ptr);
void ImageTexture_repeat_y_set(PointerRNA *ptr, int value);

int ImageTexture_use_alpha_get(PointerRNA *ptr);
void ImageTexture_use_alpha_set(PointerRNA *ptr, int value);

/**************** Image User ****************/

extern StructRNA RNA_ImageUser;

PointerRNA ImageUser_rna_type_get(PointerRNA *ptr);

int ImageUser_use_auto_refresh_get(PointerRNA *ptr);
void ImageUser_use_auto_refresh_set(PointerRNA *ptr, int value);

int ImageUser_frame_current_get(PointerRNA *ptr);
void ImageUser_frame_current_set(PointerRNA *ptr, int value);

int ImageUser_use_cyclic_get(PointerRNA *ptr);
void ImageUser_use_cyclic_set(PointerRNA *ptr, int value);

int ImageUser_fields_per_frame_get(PointerRNA *ptr);
void ImageUser_fields_per_frame_set(PointerRNA *ptr, int value);

int ImageUser_frame_duration_get(PointerRNA *ptr);
void ImageUser_frame_duration_set(PointerRNA *ptr, int value);

int ImageUser_multilayer_layer_get(PointerRNA *ptr);
void ImageUser_multilayer_layer_set(PointerRNA *ptr, int value);

int ImageUser_frame_offset_get(PointerRNA *ptr);
void ImageUser_frame_offset_set(PointerRNA *ptr, int value);

int ImageUser_multilayer_pass_get(PointerRNA *ptr);
void ImageUser_multilayer_pass_set(PointerRNA *ptr, int value);

int ImageUser_frame_start_get(PointerRNA *ptr);
void ImageUser_frame_start_set(PointerRNA *ptr, int value);

/**************** Image Paint Capabilities ****************/

extern StructRNA RNA_ImapaintToolCapabilities;

PointerRNA ImapaintToolCapabilities_rna_type_get(PointerRNA *ptr);

int ImapaintToolCapabilities_has_accumulate_get(PointerRNA *ptr);
void ImapaintToolCapabilities_has_accumulate_set(PointerRNA *ptr, int value);

int ImapaintToolCapabilities_has_radius_get(PointerRNA *ptr);
void ImapaintToolCapabilities_has_radius_set(PointerRNA *ptr, int value);

int ImapaintToolCapabilities_has_space_attenuation_get(PointerRNA *ptr);
void ImapaintToolCapabilities_has_space_attenuation_set(PointerRNA *ptr, int value);

/**************** Inflow Fluid Simulation Settings ****************/

extern StructRNA RNA_InflowFluidSettings;
extern StructRNA RNA_FluidSettings;

int InflowFluidSettings_use_get(PointerRNA *ptr);
void InflowFluidSettings_use_set(PointerRNA *ptr, int value);

int InflowFluidSettings_use_animated_mesh_get(PointerRNA *ptr);
void InflowFluidSettings_use_animated_mesh_set(PointerRNA *ptr, int value);

void InflowFluidSettings_inflow_velocity_get(PointerRNA *ptr, float values[3]);
void InflowFluidSettings_inflow_velocity_set(PointerRNA *ptr, const float values[3]);

int InflowFluidSettings_use_local_coords_get(PointerRNA *ptr);
void InflowFluidSettings_use_local_coords_set(PointerRNA *ptr, int value);

enum {
	InflowFluidSettings_volume_initialization_VOLUME = 1,
	InflowFluidSettings_volume_initialization_SHELL = 2,
	InflowFluidSettings_volume_initialization_BOTH = 3,
};

int InflowFluidSettings_volume_initialization_get(PointerRNA *ptr);
void InflowFluidSettings_volume_initialization_set(PointerRNA *ptr, int value);

/**************** Int Properties ****************/

extern StructRNA RNA_IntProperties;

PointerRNA IntProperties_rna_type_get(PointerRNA *ptr);

struct PointerRNA IntProperties_new(struct Mesh *_self, const char * name);
/**************** Int Definition ****************/

extern StructRNA RNA_IntProperty;
extern StructRNA RNA_Property;

int IntProperty_array_length_get(PointerRNA *ptr);
void IntProperty_array_length_set(PointerRNA *ptr, int value);

int IntProperty_default_value_get(PointerRNA *ptr);
void IntProperty_default_value_set(PointerRNA *ptr, int value);

void IntProperty_default_array_get(PointerRNA *ptr, int values[3]);
void IntProperty_default_array_set(PointerRNA *ptr, const int values[3]);
int IntProperty_default_array_get_length(PointerRNA *ptr, int *arraylen);

int IntProperty_hard_max_get(PointerRNA *ptr);
void IntProperty_hard_max_set(PointerRNA *ptr, int value);

int IntProperty_hard_min_get(PointerRNA *ptr);
void IntProperty_hard_min_set(PointerRNA *ptr, int value);

int IntProperty_soft_max_get(PointerRNA *ptr);
void IntProperty_soft_max_set(PointerRNA *ptr, int value);

int IntProperty_soft_min_get(PointerRNA *ptr);
void IntProperty_soft_min_set(PointerRNA *ptr, int value);

int IntProperty_step_get(PointerRNA *ptr);
void IntProperty_step_set(PointerRNA *ptr, int value);

/**************** bItasc ****************/

extern StructRNA RNA_Itasc;
extern StructRNA RNA_IKParam;

int Itasc_use_auto_step_get(PointerRNA *ptr);
void Itasc_use_auto_step_set(PointerRNA *ptr, int value);

float Itasc_damping_max_get(PointerRNA *ptr);
void Itasc_damping_max_set(PointerRNA *ptr, float value);

float Itasc_damping_epsilon_get(PointerRNA *ptr);
void Itasc_damping_epsilon_set(PointerRNA *ptr, float value);

float Itasc_feedback_get(PointerRNA *ptr);
void Itasc_feedback_set(PointerRNA *ptr, float value);

int Itasc_iterations_get(PointerRNA *ptr);
void Itasc_iterations_set(PointerRNA *ptr, int value);

float Itasc_velocity_max_get(PointerRNA *ptr);
void Itasc_velocity_max_set(PointerRNA *ptr, float value);

float Itasc_step_max_get(PointerRNA *ptr);
void Itasc_step_max_set(PointerRNA *ptr, float value);

float Itasc_step_min_get(PointerRNA *ptr);
void Itasc_step_min_set(PointerRNA *ptr, float value);

enum {
	Itasc_mode_ANIMATION = 0,
	Itasc_mode_SIMULATION = 8,
};

int Itasc_mode_get(PointerRNA *ptr);
void Itasc_mode_set(PointerRNA *ptr, int value);

int Itasc_step_count_get(PointerRNA *ptr);
void Itasc_step_count_set(PointerRNA *ptr, int value);

float Itasc_precision_get(PointerRNA *ptr);
void Itasc_precision_set(PointerRNA *ptr, float value);

enum {
	Itasc_reiteration_method_NEVER = 0,
	Itasc_reiteration_method_INITIAL = 2,
	Itasc_reiteration_method_ALWAYS = 6,
};

int Itasc_reiteration_method_get(PointerRNA *ptr);
void Itasc_reiteration_method_set(PointerRNA *ptr, int value);

enum {
	Itasc_solver_SDLS = 0,
	Itasc_solver_DLS = 1,
};

int Itasc_solver_get(PointerRNA *ptr);
void Itasc_solver_set(PointerRNA *ptr, int value);

/**************** Joystick Sensor ****************/

extern StructRNA RNA_JoystickSensor;
extern StructRNA RNA_Sensor;

int JoystickSensor_use_all_events_get(PointerRNA *ptr);
void JoystickSensor_use_all_events_set(PointerRNA *ptr, int value);

enum {
	JoystickSensor_axis_direction_RIGHTAXIS = 0,
	JoystickSensor_axis_direction_UPAXIS = 1,
	JoystickSensor_axis_direction_LEFTAXIS = 2,
	JoystickSensor_axis_direction_DOWNAXIS = 3,
};

int JoystickSensor_axis_direction_get(PointerRNA *ptr);
void JoystickSensor_axis_direction_set(PointerRNA *ptr, int value);

int JoystickSensor_axis_number_get(PointerRNA *ptr);
void JoystickSensor_axis_number_set(PointerRNA *ptr, int value);

int JoystickSensor_single_axis_number_get(PointerRNA *ptr);
void JoystickSensor_single_axis_number_set(PointerRNA *ptr, int value);

int JoystickSensor_axis_threshold_get(PointerRNA *ptr);
void JoystickSensor_axis_threshold_set(PointerRNA *ptr, int value);

int JoystickSensor_button_number_get(PointerRNA *ptr);
void JoystickSensor_button_number_set(PointerRNA *ptr, int value);

enum {
	JoystickSensor_event_type_BUTTON = 0,
	JoystickSensor_event_type_AXIS = 1,
	JoystickSensor_event_type_HAT = 2,
	JoystickSensor_event_type_AXIS_SINGLE = 3,
};

int JoystickSensor_event_type_get(PointerRNA *ptr);
void JoystickSensor_event_type_set(PointerRNA *ptr, int value);

enum {
	JoystickSensor_hat_direction_UP = 1,
	JoystickSensor_hat_direction_DOWN = 4,
	JoystickSensor_hat_direction_LEFT = 8,
	JoystickSensor_hat_direction_RIGHT = 2,
	JoystickSensor_hat_direction_UPRIGHT = 3,
	JoystickSensor_hat_direction_DOWNLEFT = 12,
	JoystickSensor_hat_direction_UPLEFT = 9,
	JoystickSensor_hat_direction_DOWNRIGHT = 6,
};

int JoystickSensor_hat_direction_get(PointerRNA *ptr);
void JoystickSensor_hat_direction_set(PointerRNA *ptr, int value);

int JoystickSensor_hat_number_get(PointerRNA *ptr);
void JoystickSensor_hat_number_set(PointerRNA *ptr, int value);

int JoystickSensor_joystick_index_get(PointerRNA *ptr);
void JoystickSensor_joystick_index_set(PointerRNA *ptr, int value);

/**************** Key ****************/

extern StructRNA RNA_Key;
extern StructRNA RNA_ID;

PointerRNA Key_animation_data_get(PointerRNA *ptr);

float Key_eval_time_get(PointerRNA *ptr);
void Key_eval_time_set(PointerRNA *ptr, float value);

void Key_key_blocks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Key_key_blocks_next(CollectionPropertyIterator *iter);
void Key_key_blocks_end(CollectionPropertyIterator *iter);
int Key_key_blocks_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Key_key_blocks_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA Key_reference_key_get(PointerRNA *ptr);

int Key_use_relative_get(PointerRNA *ptr);
void Key_use_relative_set(PointerRNA *ptr, int value);

int Key_slurph_get(PointerRNA *ptr);
void Key_slurph_set(PointerRNA *ptr, int value);

PointerRNA Key_user_get(PointerRNA *ptr);

/**************** Key Configuration ****************/

extern StructRNA RNA_KeyConfig;

PointerRNA KeyConfig_rna_type_get(PointerRNA *ptr);

#define KeyConfig_name_MAX 64

void KeyConfig_name_get(PointerRNA *ptr, char *value);
int KeyConfig_name_length(PointerRNA *ptr);
void KeyConfig_name_set(PointerRNA *ptr, const char *value);

void KeyConfig_keymaps_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void KeyConfig_keymaps_next(CollectionPropertyIterator *iter);
void KeyConfig_keymaps_end(CollectionPropertyIterator *iter);
int KeyConfig_keymaps_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int KeyConfig_keymaps_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int KeyConfig_is_user_defined_get(PointerRNA *ptr);
void KeyConfig_is_user_defined_set(PointerRNA *ptr, int value);

/**************** KeyConfigs ****************/

extern StructRNA RNA_KeyConfigurations;

PointerRNA KeyConfigurations_rna_type_get(PointerRNA *ptr);

PointerRNA KeyConfigurations_active_get(PointerRNA *ptr);

PointerRNA KeyConfigurations_addon_get(PointerRNA *ptr);

PointerRNA KeyConfigurations_default_value_get(PointerRNA *ptr);

PointerRNA KeyConfigurations_user_get(PointerRNA *ptr);

struct wmKeyConfig *KeyConfigurations_new(struct wmWindowManager *_self, const char * name);
void KeyConfigurations_remove(struct wmWindowManager *_self, ReportList *reports, struct PointerRNA *keyconfig);
/**************** Key Map ****************/

extern StructRNA RNA_KeyMap;

PointerRNA KeyMap_rna_type_get(PointerRNA *ptr);

#define KeyMap_name_MAX 64

void KeyMap_name_get(PointerRNA *ptr, char *value);
int KeyMap_name_length(PointerRNA *ptr);
void KeyMap_name_set(PointerRNA *ptr, const char *value);

int KeyMap_show_expanded_children_get(PointerRNA *ptr);
void KeyMap_show_expanded_children_set(PointerRNA *ptr, int value);

void KeyMap_keymap_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void KeyMap_keymap_items_next(CollectionPropertyIterator *iter);
void KeyMap_keymap_items_end(CollectionPropertyIterator *iter);
int KeyMap_keymap_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int KeyMap_keymap_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int KeyMap_show_expanded_items_get(PointerRNA *ptr);
void KeyMap_show_expanded_items_set(PointerRNA *ptr, int value);

int KeyMap_is_modal_get(PointerRNA *ptr);
void KeyMap_is_modal_set(PointerRNA *ptr, int value);

enum {
	KeyMap_region_type_WINDOW = 0,
	KeyMap_region_type_HEADER = 1,
	KeyMap_region_type_CHANNELS = 2,
	KeyMap_region_type_TEMPORARY = 3,
	KeyMap_region_type_UI = 4,
	KeyMap_region_type_TOOLS = 5,
	KeyMap_region_type_TOOL_PROPS = 6,
	KeyMap_region_type_PREVIEW = 7,
};

int KeyMap_region_type_get(PointerRNA *ptr);
void KeyMap_region_type_set(PointerRNA *ptr, int value);

enum {
	KeyMap_space_type_EMPTY = 0,
	KeyMap_space_type_VIEW_3D = 1,
	KeyMap_space_type_TIMELINE = 15,
	KeyMap_space_type_GRAPH_EDITOR = 2,
	KeyMap_space_type_DOPESHEET_EDITOR = 12,
	KeyMap_space_type_NLA_EDITOR = 13,
	KeyMap_space_type_IMAGE_EDITOR = 6,
	KeyMap_space_type_SEQUENCE_EDITOR = 8,
	KeyMap_space_type_CLIP_EDITOR = 20,
	KeyMap_space_type_TEXT_EDITOR = 9,
	KeyMap_space_type_NODE_EDITOR = 16,
	KeyMap_space_type_LOGIC_EDITOR = 17,
	KeyMap_space_type_PROPERTIES = 4,
	KeyMap_space_type_OUTLINER = 3,
	KeyMap_space_type_USER_PREFERENCES = 19,
	KeyMap_space_type_INFO = 7,
	KeyMap_space_type_FILE_BROWSER = 5,
	KeyMap_space_type_CONSOLE = 18,
};

int KeyMap_space_type_get(PointerRNA *ptr);
void KeyMap_space_type_set(PointerRNA *ptr, int value);

int KeyMap_is_user_modified_get(PointerRNA *ptr);
void KeyMap_is_user_modified_set(PointerRNA *ptr, int value);

struct wmKeyMap *KeyMap_active(struct wmKeyMap *_self, bContext *C);
void KeyMap_restore_to_default(struct wmKeyMap *_self, bContext *C);
void KeyMap_restore_item_to_default(struct wmKeyMap *_self, bContext *C, struct wmKeyMapItem *item);
/**************** Key Map Item ****************/

extern StructRNA RNA_KeyMapItem;

PointerRNA KeyMapItem_rna_type_get(PointerRNA *ptr);

void KeyMapItem_name_get(PointerRNA *ptr, char *value);
int KeyMapItem_name_length(PointerRNA *ptr);
void KeyMapItem_name_set(PointerRNA *ptr, const char *value);

int KeyMapItem_active_get(PointerRNA *ptr);
void KeyMapItem_active_set(PointerRNA *ptr, int value);

int KeyMapItem_alt_get(PointerRNA *ptr);
void KeyMapItem_alt_set(PointerRNA *ptr, int value);

int KeyMapItem_any_get(PointerRNA *ptr);
void KeyMapItem_any_set(PointerRNA *ptr, int value);

int KeyMapItem_ctrl_get(PointerRNA *ptr);
void KeyMapItem_ctrl_set(PointerRNA *ptr, int value);

int KeyMapItem_show_expanded_get(PointerRNA *ptr);
void KeyMapItem_show_expanded_set(PointerRNA *ptr, int value);

int KeyMapItem_id_get(PointerRNA *ptr);
void KeyMapItem_id_set(PointerRNA *ptr, int value);

#define KeyMapItem_idname_MAX 64

void KeyMapItem_idname_get(PointerRNA *ptr, char *value);
int KeyMapItem_idname_length(PointerRNA *ptr);
void KeyMapItem_idname_set(PointerRNA *ptr, const char *value);

enum {
	KeyMapItem_key_modifier_NONE = 0,
	KeyMapItem_key_modifier_LEFTMOUSE = 1,
	KeyMapItem_key_modifier_MIDDLEMOUSE = 2,
	KeyMapItem_key_modifier_RIGHTMOUSE = 3,
	KeyMapItem_key_modifier_BUTTON4MOUSE = 7,
	KeyMapItem_key_modifier_BUTTON5MOUSE = 8,
	KeyMapItem_key_modifier_BUTTON6MOUSE = 18,
	KeyMapItem_key_modifier_BUTTON7MOUSE = 19,
	KeyMapItem_key_modifier_ACTIONMOUSE = 5,
	KeyMapItem_key_modifier_SELECTMOUSE = 6,
	KeyMapItem_key_modifier_MOUSEMOVE = 4,
	KeyMapItem_key_modifier_INBETWEEN_MOUSEMOVE = 17,
	KeyMapItem_key_modifier_TRACKPADPAN = 14,
	KeyMapItem_key_modifier_TRACKPADZOOM = 15,
	KeyMapItem_key_modifier_MOUSEROTATE = 16,
	KeyMapItem_key_modifier_WHEELUPMOUSE = 10,
	KeyMapItem_key_modifier_WHEELDOWNMOUSE = 11,
	KeyMapItem_key_modifier_WHEELINMOUSE = 12,
	KeyMapItem_key_modifier_WHEELOUTMOUSE = 13,
	KeyMapItem_key_modifier_EVT_TWEAK_L = 20483,
	KeyMapItem_key_modifier_EVT_TWEAK_M = 20484,
	KeyMapItem_key_modifier_EVT_TWEAK_R = 20485,
	KeyMapItem_key_modifier_EVT_TWEAK_A = 20486,
	KeyMapItem_key_modifier_EVT_TWEAK_S = 20487,
	KeyMapItem_key_modifier_A = 97,
	KeyMapItem_key_modifier_B = 98,
	KeyMapItem_key_modifier_C = 99,
	KeyMapItem_key_modifier_D = 100,
	KeyMapItem_key_modifier_E = 101,
	KeyMapItem_key_modifier_F = 102,
	KeyMapItem_key_modifier_G = 103,
	KeyMapItem_key_modifier_H = 104,
	KeyMapItem_key_modifier_I = 105,
	KeyMapItem_key_modifier_J = 106,
	KeyMapItem_key_modifier_K = 107,
	KeyMapItem_key_modifier_L = 108,
	KeyMapItem_key_modifier_M = 109,
	KeyMapItem_key_modifier_N = 110,
	KeyMapItem_key_modifier_O = 111,
	KeyMapItem_key_modifier_P = 112,
	KeyMapItem_key_modifier_Q = 113,
	KeyMapItem_key_modifier_R = 114,
	KeyMapItem_key_modifier_S = 115,
	KeyMapItem_key_modifier_T = 116,
	KeyMapItem_key_modifier_U = 117,
	KeyMapItem_key_modifier_V = 118,
	KeyMapItem_key_modifier_W = 119,
	KeyMapItem_key_modifier_X = 120,
	KeyMapItem_key_modifier_Y = 121,
	KeyMapItem_key_modifier_Z = 122,
	KeyMapItem_key_modifier_ZERO = 48,
	KeyMapItem_key_modifier_ONE = 49,
	KeyMapItem_key_modifier_TWO = 50,
	KeyMapItem_key_modifier_THREE = 51,
	KeyMapItem_key_modifier_FOUR = 52,
	KeyMapItem_key_modifier_FIVE = 53,
	KeyMapItem_key_modifier_SIX = 54,
	KeyMapItem_key_modifier_SEVEN = 55,
	KeyMapItem_key_modifier_EIGHT = 56,
	KeyMapItem_key_modifier_NINE = 57,
	KeyMapItem_key_modifier_LEFT_CTRL = 212,
	KeyMapItem_key_modifier_LEFT_ALT = 213,
	KeyMapItem_key_modifier_LEFT_SHIFT = 217,
	KeyMapItem_key_modifier_RIGHT_ALT = 214,
	KeyMapItem_key_modifier_RIGHT_CTRL = 215,
	KeyMapItem_key_modifier_RIGHT_SHIFT = 216,
	KeyMapItem_key_modifier_OSKEY = 172,
	KeyMapItem_key_modifier_GRLESS = 173,
	KeyMapItem_key_modifier_ESC = 218,
	KeyMapItem_key_modifier_TAB = 219,
	KeyMapItem_key_modifier_RET = 220,
	KeyMapItem_key_modifier_SPACE = 221,
	KeyMapItem_key_modifier_LINE_FEED = 222,
	KeyMapItem_key_modifier_BACK_SPACE = 223,
	KeyMapItem_key_modifier_DEL = 224,
	KeyMapItem_key_modifier_SEMI_COLON = 225,
	KeyMapItem_key_modifier_PERIOD = 226,
	KeyMapItem_key_modifier_COMMA = 227,
	KeyMapItem_key_modifier_QUOTE = 228,
	KeyMapItem_key_modifier_ACCENT_GRAVE = 229,
	KeyMapItem_key_modifier_MINUS = 230,
	KeyMapItem_key_modifier_SLASH = 232,
	KeyMapItem_key_modifier_BACK_SLASH = 233,
	KeyMapItem_key_modifier_EQUAL = 234,
	KeyMapItem_key_modifier_LEFT_BRACKET = 235,
	KeyMapItem_key_modifier_RIGHT_BRACKET = 236,
	KeyMapItem_key_modifier_LEFT_ARROW = 137,
	KeyMapItem_key_modifier_DOWN_ARROW = 138,
	KeyMapItem_key_modifier_RIGHT_ARROW = 139,
	KeyMapItem_key_modifier_UP_ARROW = 140,
	KeyMapItem_key_modifier_NUMPAD_2 = 152,
	KeyMapItem_key_modifier_NUMPAD_4 = 154,
	KeyMapItem_key_modifier_NUMPAD_6 = 156,
	KeyMapItem_key_modifier_NUMPAD_8 = 158,
	KeyMapItem_key_modifier_NUMPAD_1 = 151,
	KeyMapItem_key_modifier_NUMPAD_3 = 153,
	KeyMapItem_key_modifier_NUMPAD_5 = 155,
	KeyMapItem_key_modifier_NUMPAD_7 = 157,
	KeyMapItem_key_modifier_NUMPAD_9 = 159,
	KeyMapItem_key_modifier_NUMPAD_PERIOD = 199,
	KeyMapItem_key_modifier_NUMPAD_SLASH = 161,
	KeyMapItem_key_modifier_NUMPAD_ASTERIX = 160,
	KeyMapItem_key_modifier_NUMPAD_0 = 150,
	KeyMapItem_key_modifier_NUMPAD_MINUS = 162,
	KeyMapItem_key_modifier_NUMPAD_ENTER = 163,
	KeyMapItem_key_modifier_NUMPAD_PLUS = 164,
	KeyMapItem_key_modifier_F1 = 300,
	KeyMapItem_key_modifier_F2 = 301,
	KeyMapItem_key_modifier_F3 = 302,
	KeyMapItem_key_modifier_F4 = 303,
	KeyMapItem_key_modifier_F5 = 304,
	KeyMapItem_key_modifier_F6 = 305,
	KeyMapItem_key_modifier_F7 = 306,
	KeyMapItem_key_modifier_F8 = 307,
	KeyMapItem_key_modifier_F9 = 308,
	KeyMapItem_key_modifier_F10 = 309,
	KeyMapItem_key_modifier_F11 = 310,
	KeyMapItem_key_modifier_F12 = 311,
	KeyMapItem_key_modifier_F13 = 312,
	KeyMapItem_key_modifier_F14 = 313,
	KeyMapItem_key_modifier_F15 = 314,
	KeyMapItem_key_modifier_F16 = 315,
	KeyMapItem_key_modifier_F17 = 316,
	KeyMapItem_key_modifier_F18 = 317,
	KeyMapItem_key_modifier_F19 = 318,
	KeyMapItem_key_modifier_PAUSE = 165,
	KeyMapItem_key_modifier_INSERT = 166,
	KeyMapItem_key_modifier_HOME = 167,
	KeyMapItem_key_modifier_PAGE_UP = 168,
	KeyMapItem_key_modifier_PAGE_DOWN = 169,
	KeyMapItem_key_modifier_END = 170,
	KeyMapItem_key_modifier_MEDIA_PLAY = 174,
	KeyMapItem_key_modifier_MEDIA_STOP = 175,
	KeyMapItem_key_modifier_MEDIA_FIRST = 176,
	KeyMapItem_key_modifier_MEDIA_LAST = 177,
	KeyMapItem_key_modifier_TEXTINPUT = -2,
	KeyMapItem_key_modifier_WINDOW_DEACTIVATE = 260,
	KeyMapItem_key_modifier_TIMER = 272,
	KeyMapItem_key_modifier_TIMER0 = 273,
	KeyMapItem_key_modifier_TIMER1 = 274,
	KeyMapItem_key_modifier_TIMER2 = 275,
	KeyMapItem_key_modifier_TIMER_JOBS = 276,
	KeyMapItem_key_modifier_TIMER_AUTOSAVE = 277,
	KeyMapItem_key_modifier_TIMER_REPORT = 278,
	KeyMapItem_key_modifier_TIMERREGION = 279,
	KeyMapItem_key_modifier_NDOF_MOTION = 400,
	KeyMapItem_key_modifier_NDOF_BUTTON_MENU = 401,
	KeyMapItem_key_modifier_NDOF_BUTTON_FIT = 402,
	KeyMapItem_key_modifier_NDOF_BUTTON_TOP = 403,
	KeyMapItem_key_modifier_NDOF_BUTTON_BOTTOM = 404,
	KeyMapItem_key_modifier_NDOF_BUTTON_LEFT = 405,
	KeyMapItem_key_modifier_NDOF_BUTTON_RIGHT = 406,
	KeyMapItem_key_modifier_NDOF_BUTTON_FRONT = 407,
	KeyMapItem_key_modifier_NDOF_BUTTON_BACK = 408,
	KeyMapItem_key_modifier_NDOF_BUTTON_ISO1 = 409,
	KeyMapItem_key_modifier_NDOF_BUTTON_ISO2 = 410,
	KeyMapItem_key_modifier_NDOF_BUTTON_ROLL_CW = 411,
	KeyMapItem_key_modifier_NDOF_BUTTON_ROLL_CCW = 412,
	KeyMapItem_key_modifier_NDOF_BUTTON_SPIN_CW = 413,
	KeyMapItem_key_modifier_NDOF_BUTTON_SPIN_CCW = 414,
	KeyMapItem_key_modifier_NDOF_BUTTON_TILT_CW = 415,
	KeyMapItem_key_modifier_NDOF_BUTTON_TILT_CCW = 416,
	KeyMapItem_key_modifier_NDOF_BUTTON_ROTATE = 417,
	KeyMapItem_key_modifier_NDOF_BUTTON_PANZOOM = 418,
	KeyMapItem_key_modifier_NDOF_BUTTON_DOMINANT = 419,
	KeyMapItem_key_modifier_NDOF_BUTTON_PLUS = 420,
	KeyMapItem_key_modifier_NDOF_BUTTON_MINUS = 421,
	KeyMapItem_key_modifier_NDOF_BUTTON_ESC = 422,
	KeyMapItem_key_modifier_NDOF_BUTTON_ALT = 423,
	KeyMapItem_key_modifier_NDOF_BUTTON_SHIFT = 424,
	KeyMapItem_key_modifier_NDOF_BUTTON_CTRL = 425,
	KeyMapItem_key_modifier_NDOF_BUTTON_1 = 426,
	KeyMapItem_key_modifier_NDOF_BUTTON_2 = 427,
	KeyMapItem_key_modifier_NDOF_BUTTON_3 = 428,
	KeyMapItem_key_modifier_NDOF_BUTTON_4 = 429,
	KeyMapItem_key_modifier_NDOF_BUTTON_5 = 430,
	KeyMapItem_key_modifier_NDOF_BUTTON_6 = 431,
	KeyMapItem_key_modifier_NDOF_BUTTON_7 = 432,
	KeyMapItem_key_modifier_NDOF_BUTTON_8 = 433,
	KeyMapItem_key_modifier_NDOF_BUTTON_9 = 434,
	KeyMapItem_key_modifier_NDOF_BUTTON_10 = 435,
	KeyMapItem_key_modifier_NDOF_BUTTON_A = 436,
	KeyMapItem_key_modifier_NDOF_BUTTON_B = 437,
	KeyMapItem_key_modifier_NDOF_BUTTON_C = 438,
};

int KeyMapItem_key_modifier_get(PointerRNA *ptr);
void KeyMapItem_key_modifier_set(PointerRNA *ptr, int value);

enum {
	KeyMapItem_map_type_KEYBOARD = 0,
	KeyMapItem_map_type_TWEAK = 2,
	KeyMapItem_map_type_MOUSE = 1,
	KeyMapItem_map_type_NDOF = 5,
	KeyMapItem_map_type_TEXTINPUT = 3,
	KeyMapItem_map_type_TIMER = 4,
};

int KeyMapItem_map_type_get(PointerRNA *ptr);
void KeyMapItem_map_type_set(PointerRNA *ptr, int value);

int KeyMapItem_oskey_get(PointerRNA *ptr);
void KeyMapItem_oskey_set(PointerRNA *ptr, int value);

PointerRNA KeyMapItem_properties_get(PointerRNA *ptr);

enum {
	KeyMapItem_propvalue_NONE = 0,
};

int KeyMapItem_propvalue_get(PointerRNA *ptr);
void KeyMapItem_propvalue_set(PointerRNA *ptr, int value);

int KeyMapItem_shift_get(PointerRNA *ptr);
void KeyMapItem_shift_set(PointerRNA *ptr, int value);

enum {
	KeyMapItem_type_NONE = 0,
	KeyMapItem_type_LEFTMOUSE = 1,
	KeyMapItem_type_MIDDLEMOUSE = 2,
	KeyMapItem_type_RIGHTMOUSE = 3,
	KeyMapItem_type_BUTTON4MOUSE = 7,
	KeyMapItem_type_BUTTON5MOUSE = 8,
	KeyMapItem_type_BUTTON6MOUSE = 18,
	KeyMapItem_type_BUTTON7MOUSE = 19,
	KeyMapItem_type_ACTIONMOUSE = 5,
	KeyMapItem_type_SELECTMOUSE = 6,
	KeyMapItem_type_MOUSEMOVE = 4,
	KeyMapItem_type_INBETWEEN_MOUSEMOVE = 17,
	KeyMapItem_type_TRACKPADPAN = 14,
	KeyMapItem_type_TRACKPADZOOM = 15,
	KeyMapItem_type_MOUSEROTATE = 16,
	KeyMapItem_type_WHEELUPMOUSE = 10,
	KeyMapItem_type_WHEELDOWNMOUSE = 11,
	KeyMapItem_type_WHEELINMOUSE = 12,
	KeyMapItem_type_WHEELOUTMOUSE = 13,
	KeyMapItem_type_EVT_TWEAK_L = 20483,
	KeyMapItem_type_EVT_TWEAK_M = 20484,
	KeyMapItem_type_EVT_TWEAK_R = 20485,
	KeyMapItem_type_EVT_TWEAK_A = 20486,
	KeyMapItem_type_EVT_TWEAK_S = 20487,
	KeyMapItem_type_A = 97,
	KeyMapItem_type_B = 98,
	KeyMapItem_type_C = 99,
	KeyMapItem_type_D = 100,
	KeyMapItem_type_E = 101,
	KeyMapItem_type_F = 102,
	KeyMapItem_type_G = 103,
	KeyMapItem_type_H = 104,
	KeyMapItem_type_I = 105,
	KeyMapItem_type_J = 106,
	KeyMapItem_type_K = 107,
	KeyMapItem_type_L = 108,
	KeyMapItem_type_M = 109,
	KeyMapItem_type_N = 110,
	KeyMapItem_type_O = 111,
	KeyMapItem_type_P = 112,
	KeyMapItem_type_Q = 113,
	KeyMapItem_type_R = 114,
	KeyMapItem_type_S = 115,
	KeyMapItem_type_T = 116,
	KeyMapItem_type_U = 117,
	KeyMapItem_type_V = 118,
	KeyMapItem_type_W = 119,
	KeyMapItem_type_X = 120,
	KeyMapItem_type_Y = 121,
	KeyMapItem_type_Z = 122,
	KeyMapItem_type_ZERO = 48,
	KeyMapItem_type_ONE = 49,
	KeyMapItem_type_TWO = 50,
	KeyMapItem_type_THREE = 51,
	KeyMapItem_type_FOUR = 52,
	KeyMapItem_type_FIVE = 53,
	KeyMapItem_type_SIX = 54,
	KeyMapItem_type_SEVEN = 55,
	KeyMapItem_type_EIGHT = 56,
	KeyMapItem_type_NINE = 57,
	KeyMapItem_type_LEFT_CTRL = 212,
	KeyMapItem_type_LEFT_ALT = 213,
	KeyMapItem_type_LEFT_SHIFT = 217,
	KeyMapItem_type_RIGHT_ALT = 214,
	KeyMapItem_type_RIGHT_CTRL = 215,
	KeyMapItem_type_RIGHT_SHIFT = 216,
	KeyMapItem_type_OSKEY = 172,
	KeyMapItem_type_GRLESS = 173,
	KeyMapItem_type_ESC = 218,
	KeyMapItem_type_TAB = 219,
	KeyMapItem_type_RET = 220,
	KeyMapItem_type_SPACE = 221,
	KeyMapItem_type_LINE_FEED = 222,
	KeyMapItem_type_BACK_SPACE = 223,
	KeyMapItem_type_DEL = 224,
	KeyMapItem_type_SEMI_COLON = 225,
	KeyMapItem_type_PERIOD = 226,
	KeyMapItem_type_COMMA = 227,
	KeyMapItem_type_QUOTE = 228,
	KeyMapItem_type_ACCENT_GRAVE = 229,
	KeyMapItem_type_MINUS = 230,
	KeyMapItem_type_SLASH = 232,
	KeyMapItem_type_BACK_SLASH = 233,
	KeyMapItem_type_EQUAL = 234,
	KeyMapItem_type_LEFT_BRACKET = 235,
	KeyMapItem_type_RIGHT_BRACKET = 236,
	KeyMapItem_type_LEFT_ARROW = 137,
	KeyMapItem_type_DOWN_ARROW = 138,
	KeyMapItem_type_RIGHT_ARROW = 139,
	KeyMapItem_type_UP_ARROW = 140,
	KeyMapItem_type_NUMPAD_2 = 152,
	KeyMapItem_type_NUMPAD_4 = 154,
	KeyMapItem_type_NUMPAD_6 = 156,
	KeyMapItem_type_NUMPAD_8 = 158,
	KeyMapItem_type_NUMPAD_1 = 151,
	KeyMapItem_type_NUMPAD_3 = 153,
	KeyMapItem_type_NUMPAD_5 = 155,
	KeyMapItem_type_NUMPAD_7 = 157,
	KeyMapItem_type_NUMPAD_9 = 159,
	KeyMapItem_type_NUMPAD_PERIOD = 199,
	KeyMapItem_type_NUMPAD_SLASH = 161,
	KeyMapItem_type_NUMPAD_ASTERIX = 160,
	KeyMapItem_type_NUMPAD_0 = 150,
	KeyMapItem_type_NUMPAD_MINUS = 162,
	KeyMapItem_type_NUMPAD_ENTER = 163,
	KeyMapItem_type_NUMPAD_PLUS = 164,
	KeyMapItem_type_F1 = 300,
	KeyMapItem_type_F2 = 301,
	KeyMapItem_type_F3 = 302,
	KeyMapItem_type_F4 = 303,
	KeyMapItem_type_F5 = 304,
	KeyMapItem_type_F6 = 305,
	KeyMapItem_type_F7 = 306,
	KeyMapItem_type_F8 = 307,
	KeyMapItem_type_F9 = 308,
	KeyMapItem_type_F10 = 309,
	KeyMapItem_type_F11 = 310,
	KeyMapItem_type_F12 = 311,
	KeyMapItem_type_F13 = 312,
	KeyMapItem_type_F14 = 313,
	KeyMapItem_type_F15 = 314,
	KeyMapItem_type_F16 = 315,
	KeyMapItem_type_F17 = 316,
	KeyMapItem_type_F18 = 317,
	KeyMapItem_type_F19 = 318,
	KeyMapItem_type_PAUSE = 165,
	KeyMapItem_type_INSERT = 166,
	KeyMapItem_type_HOME = 167,
	KeyMapItem_type_PAGE_UP = 168,
	KeyMapItem_type_PAGE_DOWN = 169,
	KeyMapItem_type_END = 170,
	KeyMapItem_type_MEDIA_PLAY = 174,
	KeyMapItem_type_MEDIA_STOP = 175,
	KeyMapItem_type_MEDIA_FIRST = 176,
	KeyMapItem_type_MEDIA_LAST = 177,
	KeyMapItem_type_TEXTINPUT = -2,
	KeyMapItem_type_WINDOW_DEACTIVATE = 260,
	KeyMapItem_type_TIMER = 272,
	KeyMapItem_type_TIMER0 = 273,
	KeyMapItem_type_TIMER1 = 274,
	KeyMapItem_type_TIMER2 = 275,
	KeyMapItem_type_TIMER_JOBS = 276,
	KeyMapItem_type_TIMER_AUTOSAVE = 277,
	KeyMapItem_type_TIMER_REPORT = 278,
	KeyMapItem_type_TIMERREGION = 279,
	KeyMapItem_type_NDOF_MOTION = 400,
	KeyMapItem_type_NDOF_BUTTON_MENU = 401,
	KeyMapItem_type_NDOF_BUTTON_FIT = 402,
	KeyMapItem_type_NDOF_BUTTON_TOP = 403,
	KeyMapItem_type_NDOF_BUTTON_BOTTOM = 404,
	KeyMapItem_type_NDOF_BUTTON_LEFT = 405,
	KeyMapItem_type_NDOF_BUTTON_RIGHT = 406,
	KeyMapItem_type_NDOF_BUTTON_FRONT = 407,
	KeyMapItem_type_NDOF_BUTTON_BACK = 408,
	KeyMapItem_type_NDOF_BUTTON_ISO1 = 409,
	KeyMapItem_type_NDOF_BUTTON_ISO2 = 410,
	KeyMapItem_type_NDOF_BUTTON_ROLL_CW = 411,
	KeyMapItem_type_NDOF_BUTTON_ROLL_CCW = 412,
	KeyMapItem_type_NDOF_BUTTON_SPIN_CW = 413,
	KeyMapItem_type_NDOF_BUTTON_SPIN_CCW = 414,
	KeyMapItem_type_NDOF_BUTTON_TILT_CW = 415,
	KeyMapItem_type_NDOF_BUTTON_TILT_CCW = 416,
	KeyMapItem_type_NDOF_BUTTON_ROTATE = 417,
	KeyMapItem_type_NDOF_BUTTON_PANZOOM = 418,
	KeyMapItem_type_NDOF_BUTTON_DOMINANT = 419,
	KeyMapItem_type_NDOF_BUTTON_PLUS = 420,
	KeyMapItem_type_NDOF_BUTTON_MINUS = 421,
	KeyMapItem_type_NDOF_BUTTON_ESC = 422,
	KeyMapItem_type_NDOF_BUTTON_ALT = 423,
	KeyMapItem_type_NDOF_BUTTON_SHIFT = 424,
	KeyMapItem_type_NDOF_BUTTON_CTRL = 425,
	KeyMapItem_type_NDOF_BUTTON_1 = 426,
	KeyMapItem_type_NDOF_BUTTON_2 = 427,
	KeyMapItem_type_NDOF_BUTTON_3 = 428,
	KeyMapItem_type_NDOF_BUTTON_4 = 429,
	KeyMapItem_type_NDOF_BUTTON_5 = 430,
	KeyMapItem_type_NDOF_BUTTON_6 = 431,
	KeyMapItem_type_NDOF_BUTTON_7 = 432,
	KeyMapItem_type_NDOF_BUTTON_8 = 433,
	KeyMapItem_type_NDOF_BUTTON_9 = 434,
	KeyMapItem_type_NDOF_BUTTON_10 = 435,
	KeyMapItem_type_NDOF_BUTTON_A = 436,
	KeyMapItem_type_NDOF_BUTTON_B = 437,
	KeyMapItem_type_NDOF_BUTTON_C = 438,
};

int KeyMapItem_type_get(PointerRNA *ptr);
void KeyMapItem_type_set(PointerRNA *ptr, int value);

int KeyMapItem_is_user_defined_get(PointerRNA *ptr);
void KeyMapItem_is_user_defined_set(PointerRNA *ptr, int value);

int KeyMapItem_is_user_modified_get(PointerRNA *ptr);
void KeyMapItem_is_user_modified_set(PointerRNA *ptr, int value);

enum {
	KeyMapItem_value_ANY = -1,
	KeyMapItem_value_NOTHING = 0,
	KeyMapItem_value_PRESS = 1,
	KeyMapItem_value_RELEASE = 2,
	KeyMapItem_value_CLICK = 3,
	KeyMapItem_value_DOUBLE_CLICK = 4,
	KeyMapItem_value_NORTH = 1,
	KeyMapItem_value_NORTH_EAST = 2,
	KeyMapItem_value_EAST = 3,
	KeyMapItem_value_SOUTH_EAST = 4,
	KeyMapItem_value_SOUTH = 5,
	KeyMapItem_value_SOUTH_WEST = 6,
	KeyMapItem_value_WEST = 7,
	KeyMapItem_value_NORTH_WEST = 8,
};

int KeyMapItem_value_get(PointerRNA *ptr);
void KeyMapItem_value_set(PointerRNA *ptr, int value);

int KeyMapItem_compare(struct wmKeyMapItem *_self, struct wmKeyMapItem *item);
/**************** KeyMap Items ****************/

extern StructRNA RNA_KeyMapItems;

PointerRNA KeyMapItems_rna_type_get(PointerRNA *ptr);

struct wmKeyMapItem *KeyMapItems_new(struct wmKeyMap *_self, ReportList *reports, const char * idname, int type, int value, int any, int shift, int ctrl, int alt, int oskey, int key_modifier, int head);
struct wmKeyMapItem *KeyMapItems_new_modal(struct wmKeyMap *_self, ReportList *reports, const char * propvalue, int type, int value, int any, int shift, int ctrl, int alt, int oskey, int key_modifier);
void KeyMapItems_remove(struct wmKeyMap *_self, ReportList *reports, struct PointerRNA *item);
struct wmKeyMapItem *KeyMapItems_from_id(struct wmKeyMap *_self, int id);
/**************** Key Maps ****************/

extern StructRNA RNA_KeyMaps;

PointerRNA KeyMaps_rna_type_get(PointerRNA *ptr);

struct wmKeyMap *KeyMaps_new(struct wmKeyConfig *_self, const char * name, int space_type, int region_type, int modal);
void KeyMaps_remove(struct wmKeyConfig *_self, ReportList *reports, struct PointerRNA *keymap);
struct wmKeyMap *KeyMaps_find(struct wmKeyConfig *_self, const char * name, int space_type, int region_type);
struct wmKeyMap *KeyMaps_find_modal(struct wmKeyConfig *_self, const char * name);
/**************** Keyboard Sensor ****************/

extern StructRNA RNA_KeyboardSensor;
extern StructRNA RNA_Sensor;

int KeyboardSensor_use_all_keys_get(PointerRNA *ptr);
void KeyboardSensor_use_all_keys_set(PointerRNA *ptr, int value);

enum {
	KeyboardSensor_key_NONE = 0,
	KeyboardSensor_key_LEFTMOUSE = 1,
	KeyboardSensor_key_MIDDLEMOUSE = 2,
	KeyboardSensor_key_RIGHTMOUSE = 3,
	KeyboardSensor_key_BUTTON4MOUSE = 7,
	KeyboardSensor_key_BUTTON5MOUSE = 8,
	KeyboardSensor_key_BUTTON6MOUSE = 18,
	KeyboardSensor_key_BUTTON7MOUSE = 19,
	KeyboardSensor_key_ACTIONMOUSE = 5,
	KeyboardSensor_key_SELECTMOUSE = 6,
	KeyboardSensor_key_MOUSEMOVE = 4,
	KeyboardSensor_key_INBETWEEN_MOUSEMOVE = 17,
	KeyboardSensor_key_TRACKPADPAN = 14,
	KeyboardSensor_key_TRACKPADZOOM = 15,
	KeyboardSensor_key_MOUSEROTATE = 16,
	KeyboardSensor_key_WHEELUPMOUSE = 10,
	KeyboardSensor_key_WHEELDOWNMOUSE = 11,
	KeyboardSensor_key_WHEELINMOUSE = 12,
	KeyboardSensor_key_WHEELOUTMOUSE = 13,
	KeyboardSensor_key_EVT_TWEAK_L = 20483,
	KeyboardSensor_key_EVT_TWEAK_M = 20484,
	KeyboardSensor_key_EVT_TWEAK_R = 20485,
	KeyboardSensor_key_EVT_TWEAK_A = 20486,
	KeyboardSensor_key_EVT_TWEAK_S = 20487,
	KeyboardSensor_key_A = 97,
	KeyboardSensor_key_B = 98,
	KeyboardSensor_key_C = 99,
	KeyboardSensor_key_D = 100,
	KeyboardSensor_key_E = 101,
	KeyboardSensor_key_F = 102,
	KeyboardSensor_key_G = 103,
	KeyboardSensor_key_H = 104,
	KeyboardSensor_key_I = 105,
	KeyboardSensor_key_J = 106,
	KeyboardSensor_key_K = 107,
	KeyboardSensor_key_L = 108,
	KeyboardSensor_key_M = 109,
	KeyboardSensor_key_N = 110,
	KeyboardSensor_key_O = 111,
	KeyboardSensor_key_P = 112,
	KeyboardSensor_key_Q = 113,
	KeyboardSensor_key_R = 114,
	KeyboardSensor_key_S = 115,
	KeyboardSensor_key_T = 116,
	KeyboardSensor_key_U = 117,
	KeyboardSensor_key_V = 118,
	KeyboardSensor_key_W = 119,
	KeyboardSensor_key_X = 120,
	KeyboardSensor_key_Y = 121,
	KeyboardSensor_key_Z = 122,
	KeyboardSensor_key_ZERO = 48,
	KeyboardSensor_key_ONE = 49,
	KeyboardSensor_key_TWO = 50,
	KeyboardSensor_key_THREE = 51,
	KeyboardSensor_key_FOUR = 52,
	KeyboardSensor_key_FIVE = 53,
	KeyboardSensor_key_SIX = 54,
	KeyboardSensor_key_SEVEN = 55,
	KeyboardSensor_key_EIGHT = 56,
	KeyboardSensor_key_NINE = 57,
	KeyboardSensor_key_LEFT_CTRL = 212,
	KeyboardSensor_key_LEFT_ALT = 213,
	KeyboardSensor_key_LEFT_SHIFT = 217,
	KeyboardSensor_key_RIGHT_ALT = 214,
	KeyboardSensor_key_RIGHT_CTRL = 215,
	KeyboardSensor_key_RIGHT_SHIFT = 216,
	KeyboardSensor_key_OSKEY = 172,
	KeyboardSensor_key_GRLESS = 173,
	KeyboardSensor_key_ESC = 218,
	KeyboardSensor_key_TAB = 219,
	KeyboardSensor_key_RET = 220,
	KeyboardSensor_key_SPACE = 221,
	KeyboardSensor_key_LINE_FEED = 222,
	KeyboardSensor_key_BACK_SPACE = 223,
	KeyboardSensor_key_DEL = 224,
	KeyboardSensor_key_SEMI_COLON = 225,
	KeyboardSensor_key_PERIOD = 226,
	KeyboardSensor_key_COMMA = 227,
	KeyboardSensor_key_QUOTE = 228,
	KeyboardSensor_key_ACCENT_GRAVE = 229,
	KeyboardSensor_key_MINUS = 230,
	KeyboardSensor_key_SLASH = 232,
	KeyboardSensor_key_BACK_SLASH = 233,
	KeyboardSensor_key_EQUAL = 234,
	KeyboardSensor_key_LEFT_BRACKET = 235,
	KeyboardSensor_key_RIGHT_BRACKET = 236,
	KeyboardSensor_key_LEFT_ARROW = 137,
	KeyboardSensor_key_DOWN_ARROW = 138,
	KeyboardSensor_key_RIGHT_ARROW = 139,
	KeyboardSensor_key_UP_ARROW = 140,
	KeyboardSensor_key_NUMPAD_2 = 152,
	KeyboardSensor_key_NUMPAD_4 = 154,
	KeyboardSensor_key_NUMPAD_6 = 156,
	KeyboardSensor_key_NUMPAD_8 = 158,
	KeyboardSensor_key_NUMPAD_1 = 151,
	KeyboardSensor_key_NUMPAD_3 = 153,
	KeyboardSensor_key_NUMPAD_5 = 155,
	KeyboardSensor_key_NUMPAD_7 = 157,
	KeyboardSensor_key_NUMPAD_9 = 159,
	KeyboardSensor_key_NUMPAD_PERIOD = 199,
	KeyboardSensor_key_NUMPAD_SLASH = 161,
	KeyboardSensor_key_NUMPAD_ASTERIX = 160,
	KeyboardSensor_key_NUMPAD_0 = 150,
	KeyboardSensor_key_NUMPAD_MINUS = 162,
	KeyboardSensor_key_NUMPAD_ENTER = 163,
	KeyboardSensor_key_NUMPAD_PLUS = 164,
	KeyboardSensor_key_F1 = 300,
	KeyboardSensor_key_F2 = 301,
	KeyboardSensor_key_F3 = 302,
	KeyboardSensor_key_F4 = 303,
	KeyboardSensor_key_F5 = 304,
	KeyboardSensor_key_F6 = 305,
	KeyboardSensor_key_F7 = 306,
	KeyboardSensor_key_F8 = 307,
	KeyboardSensor_key_F9 = 308,
	KeyboardSensor_key_F10 = 309,
	KeyboardSensor_key_F11 = 310,
	KeyboardSensor_key_F12 = 311,
	KeyboardSensor_key_F13 = 312,
	KeyboardSensor_key_F14 = 313,
	KeyboardSensor_key_F15 = 314,
	KeyboardSensor_key_F16 = 315,
	KeyboardSensor_key_F17 = 316,
	KeyboardSensor_key_F18 = 317,
	KeyboardSensor_key_F19 = 318,
	KeyboardSensor_key_PAUSE = 165,
	KeyboardSensor_key_INSERT = 166,
	KeyboardSensor_key_HOME = 167,
	KeyboardSensor_key_PAGE_UP = 168,
	KeyboardSensor_key_PAGE_DOWN = 169,
	KeyboardSensor_key_END = 170,
	KeyboardSensor_key_MEDIA_PLAY = 174,
	KeyboardSensor_key_MEDIA_STOP = 175,
	KeyboardSensor_key_MEDIA_FIRST = 176,
	KeyboardSensor_key_MEDIA_LAST = 177,
	KeyboardSensor_key_TEXTINPUT = -2,
	KeyboardSensor_key_WINDOW_DEACTIVATE = 260,
	KeyboardSensor_key_TIMER = 272,
	KeyboardSensor_key_TIMER0 = 273,
	KeyboardSensor_key_TIMER1 = 274,
	KeyboardSensor_key_TIMER2 = 275,
	KeyboardSensor_key_TIMER_JOBS = 276,
	KeyboardSensor_key_TIMER_AUTOSAVE = 277,
	KeyboardSensor_key_TIMER_REPORT = 278,
	KeyboardSensor_key_TIMERREGION = 279,
	KeyboardSensor_key_NDOF_MOTION = 400,
	KeyboardSensor_key_NDOF_BUTTON_MENU = 401,
	KeyboardSensor_key_NDOF_BUTTON_FIT = 402,
	KeyboardSensor_key_NDOF_BUTTON_TOP = 403,
	KeyboardSensor_key_NDOF_BUTTON_BOTTOM = 404,
	KeyboardSensor_key_NDOF_BUTTON_LEFT = 405,
	KeyboardSensor_key_NDOF_BUTTON_RIGHT = 406,
	KeyboardSensor_key_NDOF_BUTTON_FRONT = 407,
	KeyboardSensor_key_NDOF_BUTTON_BACK = 408,
	KeyboardSensor_key_NDOF_BUTTON_ISO1 = 409,
	KeyboardSensor_key_NDOF_BUTTON_ISO2 = 410,
	KeyboardSensor_key_NDOF_BUTTON_ROLL_CW = 411,
	KeyboardSensor_key_NDOF_BUTTON_ROLL_CCW = 412,
	KeyboardSensor_key_NDOF_BUTTON_SPIN_CW = 413,
	KeyboardSensor_key_NDOF_BUTTON_SPIN_CCW = 414,
	KeyboardSensor_key_NDOF_BUTTON_TILT_CW = 415,
	KeyboardSensor_key_NDOF_BUTTON_TILT_CCW = 416,
	KeyboardSensor_key_NDOF_BUTTON_ROTATE = 417,
	KeyboardSensor_key_NDOF_BUTTON_PANZOOM = 418,
	KeyboardSensor_key_NDOF_BUTTON_DOMINANT = 419,
	KeyboardSensor_key_NDOF_BUTTON_PLUS = 420,
	KeyboardSensor_key_NDOF_BUTTON_MINUS = 421,
	KeyboardSensor_key_NDOF_BUTTON_ESC = 422,
	KeyboardSensor_key_NDOF_BUTTON_ALT = 423,
	KeyboardSensor_key_NDOF_BUTTON_SHIFT = 424,
	KeyboardSensor_key_NDOF_BUTTON_CTRL = 425,
	KeyboardSensor_key_NDOF_BUTTON_1 = 426,
	KeyboardSensor_key_NDOF_BUTTON_2 = 427,
	KeyboardSensor_key_NDOF_BUTTON_3 = 428,
	KeyboardSensor_key_NDOF_BUTTON_4 = 429,
	KeyboardSensor_key_NDOF_BUTTON_5 = 430,
	KeyboardSensor_key_NDOF_BUTTON_6 = 431,
	KeyboardSensor_key_NDOF_BUTTON_7 = 432,
	KeyboardSensor_key_NDOF_BUTTON_8 = 433,
	KeyboardSensor_key_NDOF_BUTTON_9 = 434,
	KeyboardSensor_key_NDOF_BUTTON_10 = 435,
	KeyboardSensor_key_NDOF_BUTTON_A = 436,
	KeyboardSensor_key_NDOF_BUTTON_B = 437,
	KeyboardSensor_key_NDOF_BUTTON_C = 438,
};

int KeyboardSensor_key_get(PointerRNA *ptr);
void KeyboardSensor_key_set(PointerRNA *ptr, int value);

#define KeyboardSensor_log_MAX 64

void KeyboardSensor_log_get(PointerRNA *ptr, char *value);
int KeyboardSensor_log_length(PointerRNA *ptr);
void KeyboardSensor_log_set(PointerRNA *ptr, const char *value);

enum {
	KeyboardSensor_modifier_key_1_NONE = 0,
	KeyboardSensor_modifier_key_1_LEFTMOUSE = 1,
	KeyboardSensor_modifier_key_1_MIDDLEMOUSE = 2,
	KeyboardSensor_modifier_key_1_RIGHTMOUSE = 3,
	KeyboardSensor_modifier_key_1_BUTTON4MOUSE = 7,
	KeyboardSensor_modifier_key_1_BUTTON5MOUSE = 8,
	KeyboardSensor_modifier_key_1_BUTTON6MOUSE = 18,
	KeyboardSensor_modifier_key_1_BUTTON7MOUSE = 19,
	KeyboardSensor_modifier_key_1_ACTIONMOUSE = 5,
	KeyboardSensor_modifier_key_1_SELECTMOUSE = 6,
	KeyboardSensor_modifier_key_1_MOUSEMOVE = 4,
	KeyboardSensor_modifier_key_1_INBETWEEN_MOUSEMOVE = 17,
	KeyboardSensor_modifier_key_1_TRACKPADPAN = 14,
	KeyboardSensor_modifier_key_1_TRACKPADZOOM = 15,
	KeyboardSensor_modifier_key_1_MOUSEROTATE = 16,
	KeyboardSensor_modifier_key_1_WHEELUPMOUSE = 10,
	KeyboardSensor_modifier_key_1_WHEELDOWNMOUSE = 11,
	KeyboardSensor_modifier_key_1_WHEELINMOUSE = 12,
	KeyboardSensor_modifier_key_1_WHEELOUTMOUSE = 13,
	KeyboardSensor_modifier_key_1_EVT_TWEAK_L = 20483,
	KeyboardSensor_modifier_key_1_EVT_TWEAK_M = 20484,
	KeyboardSensor_modifier_key_1_EVT_TWEAK_R = 20485,
	KeyboardSensor_modifier_key_1_EVT_TWEAK_A = 20486,
	KeyboardSensor_modifier_key_1_EVT_TWEAK_S = 20487,
	KeyboardSensor_modifier_key_1_A = 97,
	KeyboardSensor_modifier_key_1_B = 98,
	KeyboardSensor_modifier_key_1_C = 99,
	KeyboardSensor_modifier_key_1_D = 100,
	KeyboardSensor_modifier_key_1_E = 101,
	KeyboardSensor_modifier_key_1_F = 102,
	KeyboardSensor_modifier_key_1_G = 103,
	KeyboardSensor_modifier_key_1_H = 104,
	KeyboardSensor_modifier_key_1_I = 105,
	KeyboardSensor_modifier_key_1_J = 106,
	KeyboardSensor_modifier_key_1_K = 107,
	KeyboardSensor_modifier_key_1_L = 108,
	KeyboardSensor_modifier_key_1_M = 109,
	KeyboardSensor_modifier_key_1_N = 110,
	KeyboardSensor_modifier_key_1_O = 111,
	KeyboardSensor_modifier_key_1_P = 112,
	KeyboardSensor_modifier_key_1_Q = 113,
	KeyboardSensor_modifier_key_1_R = 114,
	KeyboardSensor_modifier_key_1_S = 115,
	KeyboardSensor_modifier_key_1_T = 116,
	KeyboardSensor_modifier_key_1_U = 117,
	KeyboardSensor_modifier_key_1_V = 118,
	KeyboardSensor_modifier_key_1_W = 119,
	KeyboardSensor_modifier_key_1_X = 120,
	KeyboardSensor_modifier_key_1_Y = 121,
	KeyboardSensor_modifier_key_1_Z = 122,
	KeyboardSensor_modifier_key_1_ZERO = 48,
	KeyboardSensor_modifier_key_1_ONE = 49,
	KeyboardSensor_modifier_key_1_TWO = 50,
	KeyboardSensor_modifier_key_1_THREE = 51,
	KeyboardSensor_modifier_key_1_FOUR = 52,
	KeyboardSensor_modifier_key_1_FIVE = 53,
	KeyboardSensor_modifier_key_1_SIX = 54,
	KeyboardSensor_modifier_key_1_SEVEN = 55,
	KeyboardSensor_modifier_key_1_EIGHT = 56,
	KeyboardSensor_modifier_key_1_NINE = 57,
	KeyboardSensor_modifier_key_1_LEFT_CTRL = 212,
	KeyboardSensor_modifier_key_1_LEFT_ALT = 213,
	KeyboardSensor_modifier_key_1_LEFT_SHIFT = 217,
	KeyboardSensor_modifier_key_1_RIGHT_ALT = 214,
	KeyboardSensor_modifier_key_1_RIGHT_CTRL = 215,
	KeyboardSensor_modifier_key_1_RIGHT_SHIFT = 216,
	KeyboardSensor_modifier_key_1_OSKEY = 172,
	KeyboardSensor_modifier_key_1_GRLESS = 173,
	KeyboardSensor_modifier_key_1_ESC = 218,
	KeyboardSensor_modifier_key_1_TAB = 219,
	KeyboardSensor_modifier_key_1_RET = 220,
	KeyboardSensor_modifier_key_1_SPACE = 221,
	KeyboardSensor_modifier_key_1_LINE_FEED = 222,
	KeyboardSensor_modifier_key_1_BACK_SPACE = 223,
	KeyboardSensor_modifier_key_1_DEL = 224,
	KeyboardSensor_modifier_key_1_SEMI_COLON = 225,
	KeyboardSensor_modifier_key_1_PERIOD = 226,
	KeyboardSensor_modifier_key_1_COMMA = 227,
	KeyboardSensor_modifier_key_1_QUOTE = 228,
	KeyboardSensor_modifier_key_1_ACCENT_GRAVE = 229,
	KeyboardSensor_modifier_key_1_MINUS = 230,
	KeyboardSensor_modifier_key_1_SLASH = 232,
	KeyboardSensor_modifier_key_1_BACK_SLASH = 233,
	KeyboardSensor_modifier_key_1_EQUAL = 234,
	KeyboardSensor_modifier_key_1_LEFT_BRACKET = 235,
	KeyboardSensor_modifier_key_1_RIGHT_BRACKET = 236,
	KeyboardSensor_modifier_key_1_LEFT_ARROW = 137,
	KeyboardSensor_modifier_key_1_DOWN_ARROW = 138,
	KeyboardSensor_modifier_key_1_RIGHT_ARROW = 139,
	KeyboardSensor_modifier_key_1_UP_ARROW = 140,
	KeyboardSensor_modifier_key_1_NUMPAD_2 = 152,
	KeyboardSensor_modifier_key_1_NUMPAD_4 = 154,
	KeyboardSensor_modifier_key_1_NUMPAD_6 = 156,
	KeyboardSensor_modifier_key_1_NUMPAD_8 = 158,
	KeyboardSensor_modifier_key_1_NUMPAD_1 = 151,
	KeyboardSensor_modifier_key_1_NUMPAD_3 = 153,
	KeyboardSensor_modifier_key_1_NUMPAD_5 = 155,
	KeyboardSensor_modifier_key_1_NUMPAD_7 = 157,
	KeyboardSensor_modifier_key_1_NUMPAD_9 = 159,
	KeyboardSensor_modifier_key_1_NUMPAD_PERIOD = 199,
	KeyboardSensor_modifier_key_1_NUMPAD_SLASH = 161,
	KeyboardSensor_modifier_key_1_NUMPAD_ASTERIX = 160,
	KeyboardSensor_modifier_key_1_NUMPAD_0 = 150,
	KeyboardSensor_modifier_key_1_NUMPAD_MINUS = 162,
	KeyboardSensor_modifier_key_1_NUMPAD_ENTER = 163,
	KeyboardSensor_modifier_key_1_NUMPAD_PLUS = 164,
	KeyboardSensor_modifier_key_1_F1 = 300,
	KeyboardSensor_modifier_key_1_F2 = 301,
	KeyboardSensor_modifier_key_1_F3 = 302,
	KeyboardSensor_modifier_key_1_F4 = 303,
	KeyboardSensor_modifier_key_1_F5 = 304,
	KeyboardSensor_modifier_key_1_F6 = 305,
	KeyboardSensor_modifier_key_1_F7 = 306,
	KeyboardSensor_modifier_key_1_F8 = 307,
	KeyboardSensor_modifier_key_1_F9 = 308,
	KeyboardSensor_modifier_key_1_F10 = 309,
	KeyboardSensor_modifier_key_1_F11 = 310,
	KeyboardSensor_modifier_key_1_F12 = 311,
	KeyboardSensor_modifier_key_1_F13 = 312,
	KeyboardSensor_modifier_key_1_F14 = 313,
	KeyboardSensor_modifier_key_1_F15 = 314,
	KeyboardSensor_modifier_key_1_F16 = 315,
	KeyboardSensor_modifier_key_1_F17 = 316,
	KeyboardSensor_modifier_key_1_F18 = 317,
	KeyboardSensor_modifier_key_1_F19 = 318,
	KeyboardSensor_modifier_key_1_PAUSE = 165,
	KeyboardSensor_modifier_key_1_INSERT = 166,
	KeyboardSensor_modifier_key_1_HOME = 167,
	KeyboardSensor_modifier_key_1_PAGE_UP = 168,
	KeyboardSensor_modifier_key_1_PAGE_DOWN = 169,
	KeyboardSensor_modifier_key_1_END = 170,
	KeyboardSensor_modifier_key_1_MEDIA_PLAY = 174,
	KeyboardSensor_modifier_key_1_MEDIA_STOP = 175,
	KeyboardSensor_modifier_key_1_MEDIA_FIRST = 176,
	KeyboardSensor_modifier_key_1_MEDIA_LAST = 177,
	KeyboardSensor_modifier_key_1_TEXTINPUT = -2,
	KeyboardSensor_modifier_key_1_WINDOW_DEACTIVATE = 260,
	KeyboardSensor_modifier_key_1_TIMER = 272,
	KeyboardSensor_modifier_key_1_TIMER0 = 273,
	KeyboardSensor_modifier_key_1_TIMER1 = 274,
	KeyboardSensor_modifier_key_1_TIMER2 = 275,
	KeyboardSensor_modifier_key_1_TIMER_JOBS = 276,
	KeyboardSensor_modifier_key_1_TIMER_AUTOSAVE = 277,
	KeyboardSensor_modifier_key_1_TIMER_REPORT = 278,
	KeyboardSensor_modifier_key_1_TIMERREGION = 279,
	KeyboardSensor_modifier_key_1_NDOF_MOTION = 400,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_MENU = 401,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_FIT = 402,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_TOP = 403,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_BOTTOM = 404,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_LEFT = 405,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_RIGHT = 406,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_FRONT = 407,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_BACK = 408,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_ISO1 = 409,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_ISO2 = 410,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_ROLL_CW = 411,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_ROLL_CCW = 412,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_SPIN_CW = 413,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_SPIN_CCW = 414,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_TILT_CW = 415,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_TILT_CCW = 416,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_ROTATE = 417,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_PANZOOM = 418,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_DOMINANT = 419,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_PLUS = 420,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_MINUS = 421,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_ESC = 422,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_ALT = 423,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_SHIFT = 424,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_CTRL = 425,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_1 = 426,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_2 = 427,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_3 = 428,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_4 = 429,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_5 = 430,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_6 = 431,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_7 = 432,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_8 = 433,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_9 = 434,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_10 = 435,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_A = 436,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_B = 437,
	KeyboardSensor_modifier_key_1_NDOF_BUTTON_C = 438,
};

int KeyboardSensor_modifier_key_1_get(PointerRNA *ptr);
void KeyboardSensor_modifier_key_1_set(PointerRNA *ptr, int value);

enum {
	KeyboardSensor_modifier_key_2_NONE = 0,
	KeyboardSensor_modifier_key_2_LEFTMOUSE = 1,
	KeyboardSensor_modifier_key_2_MIDDLEMOUSE = 2,
	KeyboardSensor_modifier_key_2_RIGHTMOUSE = 3,
	KeyboardSensor_modifier_key_2_BUTTON4MOUSE = 7,
	KeyboardSensor_modifier_key_2_BUTTON5MOUSE = 8,
	KeyboardSensor_modifier_key_2_BUTTON6MOUSE = 18,
	KeyboardSensor_modifier_key_2_BUTTON7MOUSE = 19,
	KeyboardSensor_modifier_key_2_ACTIONMOUSE = 5,
	KeyboardSensor_modifier_key_2_SELECTMOUSE = 6,
	KeyboardSensor_modifier_key_2_MOUSEMOVE = 4,
	KeyboardSensor_modifier_key_2_INBETWEEN_MOUSEMOVE = 17,
	KeyboardSensor_modifier_key_2_TRACKPADPAN = 14,
	KeyboardSensor_modifier_key_2_TRACKPADZOOM = 15,
	KeyboardSensor_modifier_key_2_MOUSEROTATE = 16,
	KeyboardSensor_modifier_key_2_WHEELUPMOUSE = 10,
	KeyboardSensor_modifier_key_2_WHEELDOWNMOUSE = 11,
	KeyboardSensor_modifier_key_2_WHEELINMOUSE = 12,
	KeyboardSensor_modifier_key_2_WHEELOUTMOUSE = 13,
	KeyboardSensor_modifier_key_2_EVT_TWEAK_L = 20483,
	KeyboardSensor_modifier_key_2_EVT_TWEAK_M = 20484,
	KeyboardSensor_modifier_key_2_EVT_TWEAK_R = 20485,
	KeyboardSensor_modifier_key_2_EVT_TWEAK_A = 20486,
	KeyboardSensor_modifier_key_2_EVT_TWEAK_S = 20487,
	KeyboardSensor_modifier_key_2_A = 97,
	KeyboardSensor_modifier_key_2_B = 98,
	KeyboardSensor_modifier_key_2_C = 99,
	KeyboardSensor_modifier_key_2_D = 100,
	KeyboardSensor_modifier_key_2_E = 101,
	KeyboardSensor_modifier_key_2_F = 102,
	KeyboardSensor_modifier_key_2_G = 103,
	KeyboardSensor_modifier_key_2_H = 104,
	KeyboardSensor_modifier_key_2_I = 105,
	KeyboardSensor_modifier_key_2_J = 106,
	KeyboardSensor_modifier_key_2_K = 107,
	KeyboardSensor_modifier_key_2_L = 108,
	KeyboardSensor_modifier_key_2_M = 109,
	KeyboardSensor_modifier_key_2_N = 110,
	KeyboardSensor_modifier_key_2_O = 111,
	KeyboardSensor_modifier_key_2_P = 112,
	KeyboardSensor_modifier_key_2_Q = 113,
	KeyboardSensor_modifier_key_2_R = 114,
	KeyboardSensor_modifier_key_2_S = 115,
	KeyboardSensor_modifier_key_2_T = 116,
	KeyboardSensor_modifier_key_2_U = 117,
	KeyboardSensor_modifier_key_2_V = 118,
	KeyboardSensor_modifier_key_2_W = 119,
	KeyboardSensor_modifier_key_2_X = 120,
	KeyboardSensor_modifier_key_2_Y = 121,
	KeyboardSensor_modifier_key_2_Z = 122,
	KeyboardSensor_modifier_key_2_ZERO = 48,
	KeyboardSensor_modifier_key_2_ONE = 49,
	KeyboardSensor_modifier_key_2_TWO = 50,
	KeyboardSensor_modifier_key_2_THREE = 51,
	KeyboardSensor_modifier_key_2_FOUR = 52,
	KeyboardSensor_modifier_key_2_FIVE = 53,
	KeyboardSensor_modifier_key_2_SIX = 54,
	KeyboardSensor_modifier_key_2_SEVEN = 55,
	KeyboardSensor_modifier_key_2_EIGHT = 56,
	KeyboardSensor_modifier_key_2_NINE = 57,
	KeyboardSensor_modifier_key_2_LEFT_CTRL = 212,
	KeyboardSensor_modifier_key_2_LEFT_ALT = 213,
	KeyboardSensor_modifier_key_2_LEFT_SHIFT = 217,
	KeyboardSensor_modifier_key_2_RIGHT_ALT = 214,
	KeyboardSensor_modifier_key_2_RIGHT_CTRL = 215,
	KeyboardSensor_modifier_key_2_RIGHT_SHIFT = 216,
	KeyboardSensor_modifier_key_2_OSKEY = 172,
	KeyboardSensor_modifier_key_2_GRLESS = 173,
	KeyboardSensor_modifier_key_2_ESC = 218,
	KeyboardSensor_modifier_key_2_TAB = 219,
	KeyboardSensor_modifier_key_2_RET = 220,
	KeyboardSensor_modifier_key_2_SPACE = 221,
	KeyboardSensor_modifier_key_2_LINE_FEED = 222,
	KeyboardSensor_modifier_key_2_BACK_SPACE = 223,
	KeyboardSensor_modifier_key_2_DEL = 224,
	KeyboardSensor_modifier_key_2_SEMI_COLON = 225,
	KeyboardSensor_modifier_key_2_PERIOD = 226,
	KeyboardSensor_modifier_key_2_COMMA = 227,
	KeyboardSensor_modifier_key_2_QUOTE = 228,
	KeyboardSensor_modifier_key_2_ACCENT_GRAVE = 229,
	KeyboardSensor_modifier_key_2_MINUS = 230,
	KeyboardSensor_modifier_key_2_SLASH = 232,
	KeyboardSensor_modifier_key_2_BACK_SLASH = 233,
	KeyboardSensor_modifier_key_2_EQUAL = 234,
	KeyboardSensor_modifier_key_2_LEFT_BRACKET = 235,
	KeyboardSensor_modifier_key_2_RIGHT_BRACKET = 236,
	KeyboardSensor_modifier_key_2_LEFT_ARROW = 137,
	KeyboardSensor_modifier_key_2_DOWN_ARROW = 138,
	KeyboardSensor_modifier_key_2_RIGHT_ARROW = 139,
	KeyboardSensor_modifier_key_2_UP_ARROW = 140,
	KeyboardSensor_modifier_key_2_NUMPAD_2 = 152,
	KeyboardSensor_modifier_key_2_NUMPAD_4 = 154,
	KeyboardSensor_modifier_key_2_NUMPAD_6 = 156,
	KeyboardSensor_modifier_key_2_NUMPAD_8 = 158,
	KeyboardSensor_modifier_key_2_NUMPAD_1 = 151,
	KeyboardSensor_modifier_key_2_NUMPAD_3 = 153,
	KeyboardSensor_modifier_key_2_NUMPAD_5 = 155,
	KeyboardSensor_modifier_key_2_NUMPAD_7 = 157,
	KeyboardSensor_modifier_key_2_NUMPAD_9 = 159,
	KeyboardSensor_modifier_key_2_NUMPAD_PERIOD = 199,
	KeyboardSensor_modifier_key_2_NUMPAD_SLASH = 161,
	KeyboardSensor_modifier_key_2_NUMPAD_ASTERIX = 160,
	KeyboardSensor_modifier_key_2_NUMPAD_0 = 150,
	KeyboardSensor_modifier_key_2_NUMPAD_MINUS = 162,
	KeyboardSensor_modifier_key_2_NUMPAD_ENTER = 163,
	KeyboardSensor_modifier_key_2_NUMPAD_PLUS = 164,
	KeyboardSensor_modifier_key_2_F1 = 300,
	KeyboardSensor_modifier_key_2_F2 = 301,
	KeyboardSensor_modifier_key_2_F3 = 302,
	KeyboardSensor_modifier_key_2_F4 = 303,
	KeyboardSensor_modifier_key_2_F5 = 304,
	KeyboardSensor_modifier_key_2_F6 = 305,
	KeyboardSensor_modifier_key_2_F7 = 306,
	KeyboardSensor_modifier_key_2_F8 = 307,
	KeyboardSensor_modifier_key_2_F9 = 308,
	KeyboardSensor_modifier_key_2_F10 = 309,
	KeyboardSensor_modifier_key_2_F11 = 310,
	KeyboardSensor_modifier_key_2_F12 = 311,
	KeyboardSensor_modifier_key_2_F13 = 312,
	KeyboardSensor_modifier_key_2_F14 = 313,
	KeyboardSensor_modifier_key_2_F15 = 314,
	KeyboardSensor_modifier_key_2_F16 = 315,
	KeyboardSensor_modifier_key_2_F17 = 316,
	KeyboardSensor_modifier_key_2_F18 = 317,
	KeyboardSensor_modifier_key_2_F19 = 318,
	KeyboardSensor_modifier_key_2_PAUSE = 165,
	KeyboardSensor_modifier_key_2_INSERT = 166,
	KeyboardSensor_modifier_key_2_HOME = 167,
	KeyboardSensor_modifier_key_2_PAGE_UP = 168,
	KeyboardSensor_modifier_key_2_PAGE_DOWN = 169,
	KeyboardSensor_modifier_key_2_END = 170,
	KeyboardSensor_modifier_key_2_MEDIA_PLAY = 174,
	KeyboardSensor_modifier_key_2_MEDIA_STOP = 175,
	KeyboardSensor_modifier_key_2_MEDIA_FIRST = 176,
	KeyboardSensor_modifier_key_2_MEDIA_LAST = 177,
	KeyboardSensor_modifier_key_2_TEXTINPUT = -2,
	KeyboardSensor_modifier_key_2_WINDOW_DEACTIVATE = 260,
	KeyboardSensor_modifier_key_2_TIMER = 272,
	KeyboardSensor_modifier_key_2_TIMER0 = 273,
	KeyboardSensor_modifier_key_2_TIMER1 = 274,
	KeyboardSensor_modifier_key_2_TIMER2 = 275,
	KeyboardSensor_modifier_key_2_TIMER_JOBS = 276,
	KeyboardSensor_modifier_key_2_TIMER_AUTOSAVE = 277,
	KeyboardSensor_modifier_key_2_TIMER_REPORT = 278,
	KeyboardSensor_modifier_key_2_TIMERREGION = 279,
	KeyboardSensor_modifier_key_2_NDOF_MOTION = 400,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_MENU = 401,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_FIT = 402,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_TOP = 403,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_BOTTOM = 404,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_LEFT = 405,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_RIGHT = 406,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_FRONT = 407,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_BACK = 408,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_ISO1 = 409,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_ISO2 = 410,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_ROLL_CW = 411,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_ROLL_CCW = 412,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_SPIN_CW = 413,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_SPIN_CCW = 414,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_TILT_CW = 415,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_TILT_CCW = 416,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_ROTATE = 417,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_PANZOOM = 418,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_DOMINANT = 419,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_PLUS = 420,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_MINUS = 421,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_ESC = 422,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_ALT = 423,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_SHIFT = 424,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_CTRL = 425,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_1 = 426,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_2 = 427,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_3 = 428,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_4 = 429,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_5 = 430,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_6 = 431,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_7 = 432,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_8 = 433,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_9 = 434,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_10 = 435,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_A = 436,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_B = 437,
	KeyboardSensor_modifier_key_2_NDOF_BUTTON_C = 438,
};

int KeyboardSensor_modifier_key_2_get(PointerRNA *ptr);
void KeyboardSensor_modifier_key_2_set(PointerRNA *ptr, int value);

#define KeyboardSensor_target_MAX 64

void KeyboardSensor_target_get(PointerRNA *ptr, char *value);
int KeyboardSensor_target_length(PointerRNA *ptr);
void KeyboardSensor_target_set(PointerRNA *ptr, const char *value);

/**************** Keyframe ****************/

extern StructRNA RNA_Keyframe;

PointerRNA Keyframe_rna_type_get(PointerRNA *ptr);

float Keyframe_amplitude_get(PointerRNA *ptr);
void Keyframe_amplitude_set(PointerRNA *ptr, float value);

float Keyframe_back_get(PointerRNA *ptr);
void Keyframe_back_set(PointerRNA *ptr, float value);

void Keyframe_co_get(PointerRNA *ptr, float values[2]);
void Keyframe_co_set(PointerRNA *ptr, const float values[2]);

enum {
	Keyframe_easing_AUTO = 0,
	Keyframe_easing_EASE_IN = 1,
	Keyframe_easing_EASE_OUT = 2,
	Keyframe_easing_EASE_IN_OUT = 3,
};

int Keyframe_easing_get(PointerRNA *ptr);
void Keyframe_easing_set(PointerRNA *ptr, int value);

int Keyframe_select_left_handle_get(PointerRNA *ptr);
void Keyframe_select_left_handle_set(PointerRNA *ptr, int value);

int Keyframe_select_right_handle_get(PointerRNA *ptr);
void Keyframe_select_right_handle_set(PointerRNA *ptr, int value);

enum {
	Keyframe_interpolation_CONSTANT = 0,
	Keyframe_interpolation_LINEAR = 1,
	Keyframe_interpolation_BEZIER = 2,
	Keyframe_interpolation_SINE = 12,
	Keyframe_interpolation_QUAD = 9,
	Keyframe_interpolation_CUBIC = 6,
	Keyframe_interpolation_QUART = 10,
	Keyframe_interpolation_QUINT = 11,
	Keyframe_interpolation_EXPO = 8,
	Keyframe_interpolation_CIRC = 5,
	Keyframe_interpolation_BACK = 3,
	Keyframe_interpolation_BOUNCE = 4,
	Keyframe_interpolation_ELASTIC = 7,
};

int Keyframe_interpolation_get(PointerRNA *ptr);
void Keyframe_interpolation_set(PointerRNA *ptr, int value);

void Keyframe_handle_left_get(PointerRNA *ptr, float values[2]);
void Keyframe_handle_left_set(PointerRNA *ptr, const float values[2]);

enum {
	Keyframe_handle_left_type_FREE = 0,
	Keyframe_handle_left_type_VECTOR = 2,
	Keyframe_handle_left_type_ALIGNED = 3,
	Keyframe_handle_left_type_AUTO = 1,
	Keyframe_handle_left_type_AUTO_CLAMPED = 4,
};

int Keyframe_handle_left_type_get(PointerRNA *ptr);
void Keyframe_handle_left_type_set(PointerRNA *ptr, int value);

float Keyframe_period_get(PointerRNA *ptr);
void Keyframe_period_set(PointerRNA *ptr, float value);

void Keyframe_handle_right_get(PointerRNA *ptr, float values[2]);
void Keyframe_handle_right_set(PointerRNA *ptr, const float values[2]);

enum {
	Keyframe_handle_right_type_FREE = 0,
	Keyframe_handle_right_type_VECTOR = 2,
	Keyframe_handle_right_type_ALIGNED = 3,
	Keyframe_handle_right_type_AUTO = 1,
	Keyframe_handle_right_type_AUTO_CLAMPED = 4,
};

int Keyframe_handle_right_type_get(PointerRNA *ptr);
void Keyframe_handle_right_type_set(PointerRNA *ptr, int value);

int Keyframe_select_control_point_get(PointerRNA *ptr);
void Keyframe_select_control_point_set(PointerRNA *ptr, int value);

enum {
	Keyframe_type_KEYFRAME = 0,
	Keyframe_type_BREAKDOWN = 2,
	Keyframe_type_EXTREME = 1,
	Keyframe_type_JITTER = 3,
};

int Keyframe_type_get(PointerRNA *ptr);
void Keyframe_type_set(PointerRNA *ptr, int value);

/**************** Keying Set ****************/

extern StructRNA RNA_KeyingSet;

PointerRNA KeyingSet_rna_type_get(PointerRNA *ptr);

int KeyingSet_is_path_absolute_get(PointerRNA *ptr);
void KeyingSet_is_path_absolute_set(PointerRNA *ptr, int value);

#define KeyingSet_bl_description_MAX 240

void KeyingSet_bl_description_get(PointerRNA *ptr, char *value);
int KeyingSet_bl_description_length(PointerRNA *ptr);
void KeyingSet_bl_description_set(PointerRNA *ptr, const char *value);

#define KeyingSet_bl_idname_MAX 64

void KeyingSet_bl_idname_get(PointerRNA *ptr, char *value);
int KeyingSet_bl_idname_length(PointerRNA *ptr);
void KeyingSet_bl_idname_set(PointerRNA *ptr, const char *value);

enum {
	KeyingSet_bl_options_INSERTKEY_NEEDED = 1,
	KeyingSet_bl_options_INSERTKEY_VISUAL = 2,
	KeyingSet_bl_options_INSERTKEY_XYZ_TO_RGB = 32,
};

int KeyingSet_bl_options_get(PointerRNA *ptr);
void KeyingSet_bl_options_set(PointerRNA *ptr, int value);

void KeyingSet_paths_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void KeyingSet_paths_next(CollectionPropertyIterator *iter);
void KeyingSet_paths_end(CollectionPropertyIterator *iter);
int KeyingSet_paths_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int KeyingSet_paths_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA KeyingSet_type_info_get(PointerRNA *ptr);

#define KeyingSet_bl_label_MAX 64

void KeyingSet_bl_label_get(PointerRNA *ptr, char *value);
int KeyingSet_bl_label_length(PointerRNA *ptr);
void KeyingSet_bl_label_set(PointerRNA *ptr, const char *value);

void KeyingSet_refresh(struct KeyingSet *_self, bContext *C, ReportList *reports);
/**************** Keying Set Info ****************/

extern StructRNA RNA_KeyingSetInfo;

PointerRNA KeyingSetInfo_rna_type_get(PointerRNA *ptr);

#define KeyingSetInfo_bl_description_MAX 240

void KeyingSetInfo_bl_description_get(PointerRNA *ptr, char *value);
int KeyingSetInfo_bl_description_length(PointerRNA *ptr);
void KeyingSetInfo_bl_description_set(PointerRNA *ptr, const char *value);

void KeyingSetInfo_bl_idname_get(PointerRNA *ptr, char *value);
int KeyingSetInfo_bl_idname_length(PointerRNA *ptr);
void KeyingSetInfo_bl_idname_set(PointerRNA *ptr, const char *value);

enum {
	KeyingSetInfo_bl_options_INSERTKEY_NEEDED = 1,
	KeyingSetInfo_bl_options_INSERTKEY_VISUAL = 2,
	KeyingSetInfo_bl_options_INSERTKEY_XYZ_TO_RGB = 32,
};

int KeyingSetInfo_bl_options_get(PointerRNA *ptr);
void KeyingSetInfo_bl_options_set(PointerRNA *ptr, int value);

void KeyingSetInfo_bl_label_get(PointerRNA *ptr, char *value);
int KeyingSetInfo_bl_label_length(PointerRNA *ptr);
void KeyingSetInfo_bl_label_set(PointerRNA *ptr, const char *value);

int KeyingSetInfo_poll(struct KeyingSetInfo *_self, struct bContext *context);
void KeyingSetInfo_iterator(struct KeyingSetInfo *_self, struct bContext *context, struct KeyingSet *ks);
void KeyingSetInfo_generate(struct KeyingSetInfo *_self, struct bContext *context, struct KeyingSet *ks, struct PointerRNA *data);
/**************** Keying Set Path ****************/

extern StructRNA RNA_KeyingSetPath;

PointerRNA KeyingSetPath_rna_type_get(PointerRNA *ptr);

void KeyingSetPath_data_path_get(PointerRNA *ptr, char *value);
int KeyingSetPath_data_path_length(PointerRNA *ptr);
void KeyingSetPath_data_path_set(PointerRNA *ptr, const char *value);

int KeyingSetPath_use_entire_array_get(PointerRNA *ptr);
void KeyingSetPath_use_entire_array_set(PointerRNA *ptr, int value);

#define KeyingSetPath_group_MAX 64

void KeyingSetPath_group_get(PointerRNA *ptr, char *value);
int KeyingSetPath_group_length(PointerRNA *ptr);
void KeyingSetPath_group_set(PointerRNA *ptr, const char *value);

enum {
	KeyingSetPath_group_method_NAMED = 0,
	KeyingSetPath_group_method_NONE = 1,
	KeyingSetPath_group_method_KEYINGSET = 2,
};

int KeyingSetPath_group_method_get(PointerRNA *ptr);
void KeyingSetPath_group_method_set(PointerRNA *ptr, int value);

enum {
	KeyingSetPath_id_type_ACTION = 17217,
	KeyingSetPath_id_type_ARMATURE = 21057,
	KeyingSetPath_id_type_BRUSH = 21058,
	KeyingSetPath_id_type_CAMERA = 16707,
	KeyingSetPath_id_type_CURVE = 21827,
	KeyingSetPath_id_type_FONT = 18006,
	KeyingSetPath_id_type_GREASEPENCIL = 17479,
	KeyingSetPath_id_type_GROUP = 21063,
	KeyingSetPath_id_type_IMAGE = 19785,
	KeyingSetPath_id_type_KEY = 17739,
	KeyingSetPath_id_type_LAMP = 16716,
	KeyingSetPath_id_type_LIBRARY = 18764,
	KeyingSetPath_id_type_LINESTYLE = 21324,
	KeyingSetPath_id_type_LATTICE = 21580,
	KeyingSetPath_id_type_MASK = 21325,
	KeyingSetPath_id_type_MATERIAL = 16717,
	KeyingSetPath_id_type_META = 16973,
	KeyingSetPath_id_type_MESH = 17741,
	KeyingSetPath_id_type_NODETREE = 21582,
	KeyingSetPath_id_type_OBJECT = 16975,
	KeyingSetPath_id_type_PAINTCURVE = 17232,
	KeyingSetPath_id_type_PALETTE = 19536,
	KeyingSetPath_id_type_PARTICLE = 16720,
	KeyingSetPath_id_type_SCENE = 17235,
	KeyingSetPath_id_type_SCREEN = 21075,
	KeyingSetPath_id_type_SPEAKER = 19283,
	KeyingSetPath_id_type_SOUND = 20307,
	KeyingSetPath_id_type_TEXT = 22612,
	KeyingSetPath_id_type_TEXTURE = 17748,
	KeyingSetPath_id_type_WORLD = 20311,
	KeyingSetPath_id_type_WINDOWMANAGER = 19799,
};

int KeyingSetPath_id_type_get(PointerRNA *ptr);
void KeyingSetPath_id_type_set(PointerRNA *ptr, int value);

PointerRNA KeyingSetPath_id_get(PointerRNA *ptr);

enum {
	KeyingSetPath_bl_options_INSERTKEY_NEEDED = 1,
	KeyingSetPath_bl_options_INSERTKEY_VISUAL = 2,
	KeyingSetPath_bl_options_INSERTKEY_XYZ_TO_RGB = 32,
};

int KeyingSetPath_bl_options_get(PointerRNA *ptr);
void KeyingSetPath_bl_options_set(PointerRNA *ptr, int value);

int KeyingSetPath_array_index_get(PointerRNA *ptr);
void KeyingSetPath_array_index_set(PointerRNA *ptr, int value);

/**************** Keying set paths ****************/

extern StructRNA RNA_KeyingSetPaths;

PointerRNA KeyingSetPaths_rna_type_get(PointerRNA *ptr);

PointerRNA KeyingSetPaths_active_get(PointerRNA *ptr);

int KeyingSetPaths_active_index_get(PointerRNA *ptr);
void KeyingSetPaths_active_index_set(PointerRNA *ptr, int value);

struct KS_Path *KeyingSetPaths_add(struct KeyingSet *_self, ReportList *reports, struct ID *target_id, const char * data_path, int index, int group_method, const char * group_name);
void KeyingSetPaths_remove(struct KeyingSet *_self, ReportList *reports, struct PointerRNA *path);
void KeyingSetPaths_clear(struct KeyingSet *_self, ReportList *reports);
/**************** Keying Sets ****************/

extern StructRNA RNA_KeyingSets;

PointerRNA KeyingSets_rna_type_get(PointerRNA *ptr);

PointerRNA KeyingSets_active_get(PointerRNA *ptr);

int KeyingSets_active_index_get(PointerRNA *ptr);
void KeyingSets_active_index_set(PointerRNA *ptr, int value);

struct KeyingSet *KeyingSets_new(struct Scene *_self, ReportList *reports, const char * idname, const char * name);
/**************** Keying Sets All ****************/

extern StructRNA RNA_KeyingSetsAll;

PointerRNA KeyingSetsAll_rna_type_get(PointerRNA *ptr);

PointerRNA KeyingSetsAll_active_get(PointerRNA *ptr);

int KeyingSetsAll_active_index_get(PointerRNA *ptr);
void KeyingSetsAll_active_index_set(PointerRNA *ptr, int value);

/**************** Kinematic Constraint ****************/

extern StructRNA RNA_KinematicConstraint;
extern StructRNA RNA_Constraint;

enum {
	KinematicConstraint_reference_axis_BONE = 0,
	KinematicConstraint_reference_axis_TARGET = 16384,
};

int KinematicConstraint_reference_axis_get(PointerRNA *ptr);
void KinematicConstraint_reference_axis_set(PointerRNA *ptr, int value);

int KinematicConstraint_chain_count_get(PointerRNA *ptr);
void KinematicConstraint_chain_count_set(PointerRNA *ptr, int value);

float KinematicConstraint_distance_get(PointerRNA *ptr);
void KinematicConstraint_distance_set(PointerRNA *ptr, float value);

enum {
	KinematicConstraint_ik_type_COPY_POSE = 0,
	KinematicConstraint_ik_type_DISTANCE = 1,
};

int KinematicConstraint_ik_type_get(PointerRNA *ptr);
void KinematicConstraint_ik_type_set(PointerRNA *ptr, int value);

int KinematicConstraint_iterations_get(PointerRNA *ptr);
void KinematicConstraint_iterations_set(PointerRNA *ptr, int value);

enum {
	KinematicConstraint_limit_mode_LIMITDIST_INSIDE = 0,
	KinematicConstraint_limit_mode_LIMITDIST_OUTSIDE = 1,
	KinematicConstraint_limit_mode_LIMITDIST_ONSURFACE = 2,
};

int KinematicConstraint_limit_mode_get(PointerRNA *ptr);
void KinematicConstraint_limit_mode_set(PointerRNA *ptr, int value);

int KinematicConstraint_lock_location_x_get(PointerRNA *ptr);
void KinematicConstraint_lock_location_x_set(PointerRNA *ptr, int value);

int KinematicConstraint_lock_rotation_x_get(PointerRNA *ptr);
void KinematicConstraint_lock_rotation_x_set(PointerRNA *ptr, int value);

int KinematicConstraint_lock_location_y_get(PointerRNA *ptr);
void KinematicConstraint_lock_location_y_set(PointerRNA *ptr, int value);

int KinematicConstraint_lock_rotation_y_get(PointerRNA *ptr);
void KinematicConstraint_lock_rotation_y_set(PointerRNA *ptr, int value);

int KinematicConstraint_lock_location_z_get(PointerRNA *ptr);
void KinematicConstraint_lock_location_z_set(PointerRNA *ptr, int value);

int KinematicConstraint_lock_rotation_z_get(PointerRNA *ptr);
void KinematicConstraint_lock_rotation_z_set(PointerRNA *ptr, int value);

float KinematicConstraint_orient_weight_get(PointerRNA *ptr);
void KinematicConstraint_orient_weight_set(PointerRNA *ptr, float value);

float KinematicConstraint_pole_angle_get(PointerRNA *ptr);
void KinematicConstraint_pole_angle_set(PointerRNA *ptr, float value);

#define KinematicConstraint_pole_subtarget_MAX 64

void KinematicConstraint_pole_subtarget_get(PointerRNA *ptr, char *value);
int KinematicConstraint_pole_subtarget_length(PointerRNA *ptr);
void KinematicConstraint_pole_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA KinematicConstraint_pole_target_get(PointerRNA *ptr);

int KinematicConstraint_use_location_get(PointerRNA *ptr);
void KinematicConstraint_use_location_set(PointerRNA *ptr, int value);

int KinematicConstraint_use_rotation_get(PointerRNA *ptr);
void KinematicConstraint_use_rotation_set(PointerRNA *ptr, int value);

int KinematicConstraint_use_stretch_get(PointerRNA *ptr);
void KinematicConstraint_use_stretch_set(PointerRNA *ptr, int value);

#define KinematicConstraint_subtarget_MAX 64

void KinematicConstraint_subtarget_get(PointerRNA *ptr, char *value);
int KinematicConstraint_subtarget_length(PointerRNA *ptr);
void KinematicConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA KinematicConstraint_target_get(PointerRNA *ptr);

int KinematicConstraint_use_tail_get(PointerRNA *ptr);
void KinematicConstraint_use_tail_set(PointerRNA *ptr, int value);

float KinematicConstraint_weight_get(PointerRNA *ptr);
void KinematicConstraint_weight_set(PointerRNA *ptr, float value);

/**************** Lamp ****************/

extern StructRNA RNA_Lamp;
extern StructRNA RNA_ID;

PointerRNA Lamp_active_texture_get(PointerRNA *ptr);

int Lamp_active_texture_index_get(PointerRNA *ptr);
void Lamp_active_texture_index_set(PointerRNA *ptr, int value);

PointerRNA Lamp_animation_data_get(PointerRNA *ptr);

void Lamp_color_get(PointerRNA *ptr, float values[3]);
void Lamp_color_set(PointerRNA *ptr, const float values[3]);

int Lamp_use_diffuse_get(PointerRNA *ptr);
void Lamp_use_diffuse_set(PointerRNA *ptr, int value);

float Lamp_distance_get(PointerRNA *ptr);
void Lamp_distance_set(PointerRNA *ptr, float value);

float Lamp_energy_get(PointerRNA *ptr);
void Lamp_energy_set(PointerRNA *ptr, float value);

int Lamp_use_own_layer_get(PointerRNA *ptr);
void Lamp_use_own_layer_set(PointerRNA *ptr, int value);

int Lamp_use_negative_get(PointerRNA *ptr);
void Lamp_use_negative_set(PointerRNA *ptr, int value);

PointerRNA Lamp_node_tree_get(PointerRNA *ptr);

int Lamp_use_specular_get(PointerRNA *ptr);
void Lamp_use_specular_set(PointerRNA *ptr, int value);

void Lamp_texture_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Lamp_texture_slots_next(CollectionPropertyIterator *iter);
void Lamp_texture_slots_end(CollectionPropertyIterator *iter);

enum {
	Lamp_type_POINT = 0,
	Lamp_type_SUN = 1,
	Lamp_type_SPOT = 2,
	Lamp_type_HEMI = 3,
	Lamp_type_AREA = 4,
};

int Lamp_type_get(PointerRNA *ptr);
void Lamp_type_set(PointerRNA *ptr, int value);

int Lamp_use_nodes_get(PointerRNA *ptr);
void Lamp_use_nodes_set(PointerRNA *ptr, int value);

/**************** Lamp Sky Settings ****************/

extern StructRNA RNA_LampSkySettings;

PointerRNA LampSkySettings_rna_type_get(PointerRNA *ptr);

int LampSkySettings_use_atmosphere_get(PointerRNA *ptr);
void LampSkySettings_use_atmosphere_set(PointerRNA *ptr, int value);

float LampSkySettings_atmosphere_distance_factor_get(PointerRNA *ptr);
void LampSkySettings_atmosphere_distance_factor_set(PointerRNA *ptr, float value);

float LampSkySettings_atmosphere_extinction_get(PointerRNA *ptr);
void LampSkySettings_atmosphere_extinction_set(PointerRNA *ptr, float value);

float LampSkySettings_atmosphere_inscattering_get(PointerRNA *ptr);
void LampSkySettings_atmosphere_inscattering_set(PointerRNA *ptr, float value);

float LampSkySettings_atmosphere_turbidity_get(PointerRNA *ptr);
void LampSkySettings_atmosphere_turbidity_set(PointerRNA *ptr, float value);

float LampSkySettings_backscattered_light_get(PointerRNA *ptr);
void LampSkySettings_backscattered_light_set(PointerRNA *ptr, float value);

float LampSkySettings_horizon_brightness_get(PointerRNA *ptr);
void LampSkySettings_horizon_brightness_set(PointerRNA *ptr, float value);

float LampSkySettings_spread_get(PointerRNA *ptr);
void LampSkySettings_spread_set(PointerRNA *ptr, float value);

int LampSkySettings_use_sky_get(PointerRNA *ptr);
void LampSkySettings_use_sky_set(PointerRNA *ptr, int value);

float LampSkySettings_sky_blend_get(PointerRNA *ptr);
void LampSkySettings_sky_blend_set(PointerRNA *ptr, float value);

enum {
	LampSkySettings_sky_blend_type_MIX = 0,
	LampSkySettings_sky_blend_type_ADD = 1,
	LampSkySettings_sky_blend_type_MULTIPLY = 2,
	LampSkySettings_sky_blend_type_SUBTRACT = 3,
	LampSkySettings_sky_blend_type_SCREEN = 4,
	LampSkySettings_sky_blend_type_DIVIDE = 5,
	LampSkySettings_sky_blend_type_DIFFERENCE = 6,
	LampSkySettings_sky_blend_type_DARKEN = 7,
	LampSkySettings_sky_blend_type_LIGHTEN = 8,
	LampSkySettings_sky_blend_type_OVERLAY = 9,
	LampSkySettings_sky_blend_type_DODGE = 10,
	LampSkySettings_sky_blend_type_BURN = 11,
	LampSkySettings_sky_blend_type_HUE = 12,
	LampSkySettings_sky_blend_type_SATURATION = 13,
	LampSkySettings_sky_blend_type_VALUE = 14,
	LampSkySettings_sky_blend_type_COLOR = 15,
	LampSkySettings_sky_blend_type_SOFT_LIGHT = 16,
	LampSkySettings_sky_blend_type_LINEAR_LIGHT = 17,
};

int LampSkySettings_sky_blend_type_get(PointerRNA *ptr);
void LampSkySettings_sky_blend_type_set(PointerRNA *ptr, int value);

enum {
	LampSkySettings_sky_color_space_SMPTE = 0,
	LampSkySettings_sky_color_space_REC709 = 1,
	LampSkySettings_sky_color_space_CIE = 2,
};

int LampSkySettings_sky_color_space_get(PointerRNA *ptr);
void LampSkySettings_sky_color_space_set(PointerRNA *ptr, int value);

float LampSkySettings_sky_exposure_get(PointerRNA *ptr);
void LampSkySettings_sky_exposure_set(PointerRNA *ptr, float value);

float LampSkySettings_sun_brightness_get(PointerRNA *ptr);
void LampSkySettings_sun_brightness_set(PointerRNA *ptr, float value);

float LampSkySettings_sun_intensity_get(PointerRNA *ptr);
void LampSkySettings_sun_intensity_set(PointerRNA *ptr, float value);

float LampSkySettings_sun_size_get(PointerRNA *ptr);
void LampSkySettings_sun_size_set(PointerRNA *ptr, float value);

/**************** Lamp Texture Slot ****************/

extern StructRNA RNA_LampTextureSlot;
extern StructRNA RNA_TextureSlot;

int LampTextureSlot_use_map_color_get(PointerRNA *ptr);
void LampTextureSlot_use_map_color_set(PointerRNA *ptr, int value);

float LampTextureSlot_color_factor_get(PointerRNA *ptr);
void LampTextureSlot_color_factor_set(PointerRNA *ptr, float value);

PointerRNA LampTextureSlot_object_get(PointerRNA *ptr);

int LampTextureSlot_use_map_shadow_get(PointerRNA *ptr);
void LampTextureSlot_use_map_shadow_set(PointerRNA *ptr, int value);

float LampTextureSlot_shadow_factor_get(PointerRNA *ptr);
void LampTextureSlot_shadow_factor_set(PointerRNA *ptr, float value);

enum {
	LampTextureSlot_texture_coords_GLOBAL = 8,
	LampTextureSlot_texture_coords_VIEW = 128,
	LampTextureSlot_texture_coords_OBJECT = 32,
};

int LampTextureSlot_texture_coords_get(PointerRNA *ptr);
void LampTextureSlot_texture_coords_set(PointerRNA *ptr, int value);

/**************** Texture Slots ****************/

extern StructRNA RNA_LampTextureSlots;

PointerRNA LampTextureSlots_rna_type_get(PointerRNA *ptr);

struct MTex *LampTextureSlots_add(struct ID *_selfid, bContext *C, ReportList *reports);
struct MTex *LampTextureSlots_create(struct ID *_selfid, bContext *C, ReportList *reports, int index);
void LampTextureSlots_clear(struct ID *_selfid, bContext *C, ReportList *reports, int index);
/**************** Laplacian Deform Modifier ****************/

extern StructRNA RNA_LaplacianDeformModifier;
extern StructRNA RNA_Modifier;

int LaplacianDeformModifier_is_bind_get(PointerRNA *ptr);
void LaplacianDeformModifier_is_bind_set(PointerRNA *ptr, int value);

int LaplacianDeformModifier_iterations_get(PointerRNA *ptr);
void LaplacianDeformModifier_iterations_set(PointerRNA *ptr, int value);

#define LaplacianDeformModifier_vertex_group_MAX 64

void LaplacianDeformModifier_vertex_group_get(PointerRNA *ptr, char *value);
int LaplacianDeformModifier_vertex_group_length(PointerRNA *ptr);
void LaplacianDeformModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Laplacian Smooth Modifier ****************/

extern StructRNA RNA_LaplacianSmoothModifier;
extern StructRNA RNA_Modifier;

float LaplacianSmoothModifier_lambda_border_get(PointerRNA *ptr);
void LaplacianSmoothModifier_lambda_border_set(PointerRNA *ptr, float value);

float LaplacianSmoothModifier_lambda_factor_get(PointerRNA *ptr);
void LaplacianSmoothModifier_lambda_factor_set(PointerRNA *ptr, float value);

int LaplacianSmoothModifier_use_normalized_get(PointerRNA *ptr);
void LaplacianSmoothModifier_use_normalized_set(PointerRNA *ptr, int value);

int LaplacianSmoothModifier_use_volume_preserve_get(PointerRNA *ptr);
void LaplacianSmoothModifier_use_volume_preserve_set(PointerRNA *ptr, int value);

int LaplacianSmoothModifier_iterations_get(PointerRNA *ptr);
void LaplacianSmoothModifier_iterations_set(PointerRNA *ptr, int value);

#define LaplacianSmoothModifier_vertex_group_MAX 64

void LaplacianSmoothModifier_vertex_group_get(PointerRNA *ptr, char *value);
int LaplacianSmoothModifier_vertex_group_length(PointerRNA *ptr);
void LaplacianSmoothModifier_vertex_group_set(PointerRNA *ptr, const char *value);

int LaplacianSmoothModifier_use_x_get(PointerRNA *ptr);
void LaplacianSmoothModifier_use_x_set(PointerRNA *ptr, int value);

int LaplacianSmoothModifier_use_y_get(PointerRNA *ptr);
void LaplacianSmoothModifier_use_y_set(PointerRNA *ptr, int value);

int LaplacianSmoothModifier_use_z_get(PointerRNA *ptr);
void LaplacianSmoothModifier_use_z_set(PointerRNA *ptr, int value);

/**************** Lattice ****************/

extern StructRNA RNA_Lattice;
extern StructRNA RNA_ID;

PointerRNA Lattice_animation_data_get(PointerRNA *ptr);

enum {
	Lattice_interpolation_type_u_KEY_LINEAR = 0,
	Lattice_interpolation_type_u_KEY_CARDINAL = 1,
	Lattice_interpolation_type_u_KEY_CATMULL_ROM = 3,
	Lattice_interpolation_type_u_KEY_BSPLINE = 2,
};

int Lattice_interpolation_type_u_get(PointerRNA *ptr);
void Lattice_interpolation_type_u_set(PointerRNA *ptr, int value);

enum {
	Lattice_interpolation_type_v_KEY_LINEAR = 0,
	Lattice_interpolation_type_v_KEY_CARDINAL = 1,
	Lattice_interpolation_type_v_KEY_CATMULL_ROM = 3,
	Lattice_interpolation_type_v_KEY_BSPLINE = 2,
};

int Lattice_interpolation_type_v_get(PointerRNA *ptr);
void Lattice_interpolation_type_v_set(PointerRNA *ptr, int value);

enum {
	Lattice_interpolation_type_w_KEY_LINEAR = 0,
	Lattice_interpolation_type_w_KEY_CARDINAL = 1,
	Lattice_interpolation_type_w_KEY_CATMULL_ROM = 3,
	Lattice_interpolation_type_w_KEY_BSPLINE = 2,
};

int Lattice_interpolation_type_w_get(PointerRNA *ptr);
void Lattice_interpolation_type_w_set(PointerRNA *ptr, int value);

int Lattice_is_editmode_get(PointerRNA *ptr);
void Lattice_is_editmode_set(PointerRNA *ptr, int value);

int Lattice_use_outside_get(PointerRNA *ptr);
void Lattice_use_outside_set(PointerRNA *ptr, int value);

void Lattice_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Lattice_points_next(CollectionPropertyIterator *iter);
void Lattice_points_end(CollectionPropertyIterator *iter);

PointerRNA Lattice_shape_keys_get(PointerRNA *ptr);

int Lattice_points_u_get(PointerRNA *ptr);
void Lattice_points_u_set(PointerRNA *ptr, int value);

int Lattice_points_v_get(PointerRNA *ptr);
void Lattice_points_v_set(PointerRNA *ptr, int value);

#define Lattice_vertex_group_MAX 64

void Lattice_vertex_group_get(PointerRNA *ptr, char *value);
int Lattice_vertex_group_length(PointerRNA *ptr);
void Lattice_vertex_group_set(PointerRNA *ptr, const char *value);

int Lattice_points_w_get(PointerRNA *ptr);
void Lattice_points_w_set(PointerRNA *ptr, int value);

void Lattice_transform(struct Lattice *_self, float matrix[16], int shape_keys);
/**************** Lattice Modifier ****************/

extern StructRNA RNA_LatticeModifier;
extern StructRNA RNA_Modifier;

PointerRNA LatticeModifier_object_get(PointerRNA *ptr);

float LatticeModifier_strength_get(PointerRNA *ptr);
void LatticeModifier_strength_set(PointerRNA *ptr, float value);

#define LatticeModifier_vertex_group_MAX 64

void LatticeModifier_vertex_group_get(PointerRNA *ptr, char *value);
int LatticeModifier_vertex_group_length(PointerRNA *ptr);
void LatticeModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** LatticePoint ****************/

extern StructRNA RNA_LatticePoint;

PointerRNA LatticePoint_rna_type_get(PointerRNA *ptr);

void LatticePoint_co_deform_get(PointerRNA *ptr, float values[3]);
void LatticePoint_co_deform_set(PointerRNA *ptr, const float values[3]);

void LatticePoint_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void LatticePoint_groups_next(CollectionPropertyIterator *iter);
void LatticePoint_groups_end(CollectionPropertyIterator *iter);

void LatticePoint_co_get(PointerRNA *ptr, float values[3]);
void LatticePoint_co_set(PointerRNA *ptr, const float values[3]);

int LatticePoint_select_get(PointerRNA *ptr);
void LatticePoint_select_set(PointerRNA *ptr, int value);

float LatticePoint_weight_softbody_get(PointerRNA *ptr);
void LatticePoint_weight_softbody_set(PointerRNA *ptr, float value);

/**************** Library ****************/

extern StructRNA RNA_Library;
extern StructRNA RNA_ID;

#define Library_filepath_MAX 1024

void Library_filepath_get(PointerRNA *ptr, char *value);
int Library_filepath_length(PointerRNA *ptr);
void Library_filepath_set(PointerRNA *ptr, const char *value);

PointerRNA Library_packed_file_get(PointerRNA *ptr);

PointerRNA Library_parent_get(PointerRNA *ptr);

/**************** Limit Distance Constraint ****************/

extern StructRNA RNA_LimitDistanceConstraint;
extern StructRNA RNA_Constraint;

float LimitDistanceConstraint_distance_get(PointerRNA *ptr);
void LimitDistanceConstraint_distance_set(PointerRNA *ptr, float value);

int LimitDistanceConstraint_use_transform_limit_get(PointerRNA *ptr);
void LimitDistanceConstraint_use_transform_limit_set(PointerRNA *ptr, int value);

float LimitDistanceConstraint_head_tail_get(PointerRNA *ptr);
void LimitDistanceConstraint_head_tail_set(PointerRNA *ptr, float value);

enum {
	LimitDistanceConstraint_limit_mode_LIMITDIST_INSIDE = 0,
	LimitDistanceConstraint_limit_mode_LIMITDIST_OUTSIDE = 1,
	LimitDistanceConstraint_limit_mode_LIMITDIST_ONSURFACE = 2,
};

int LimitDistanceConstraint_limit_mode_get(PointerRNA *ptr);
void LimitDistanceConstraint_limit_mode_set(PointerRNA *ptr, int value);

#define LimitDistanceConstraint_subtarget_MAX 64

void LimitDistanceConstraint_subtarget_get(PointerRNA *ptr, char *value);
int LimitDistanceConstraint_subtarget_length(PointerRNA *ptr);
void LimitDistanceConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA LimitDistanceConstraint_target_get(PointerRNA *ptr);

/**************** Limit Location Constraint ****************/

extern StructRNA RNA_LimitLocationConstraint;
extern StructRNA RNA_Constraint;

int LimitLocationConstraint_use_transform_limit_get(PointerRNA *ptr);
void LimitLocationConstraint_use_transform_limit_set(PointerRNA *ptr, int value);

int LimitLocationConstraint_use_max_x_get(PointerRNA *ptr);
void LimitLocationConstraint_use_max_x_set(PointerRNA *ptr, int value);

float LimitLocationConstraint_max_x_get(PointerRNA *ptr);
void LimitLocationConstraint_max_x_set(PointerRNA *ptr, float value);

int LimitLocationConstraint_use_max_y_get(PointerRNA *ptr);
void LimitLocationConstraint_use_max_y_set(PointerRNA *ptr, int value);

float LimitLocationConstraint_max_y_get(PointerRNA *ptr);
void LimitLocationConstraint_max_y_set(PointerRNA *ptr, float value);

int LimitLocationConstraint_use_max_z_get(PointerRNA *ptr);
void LimitLocationConstraint_use_max_z_set(PointerRNA *ptr, int value);

float LimitLocationConstraint_max_z_get(PointerRNA *ptr);
void LimitLocationConstraint_max_z_set(PointerRNA *ptr, float value);

int LimitLocationConstraint_use_min_x_get(PointerRNA *ptr);
void LimitLocationConstraint_use_min_x_set(PointerRNA *ptr, int value);

float LimitLocationConstraint_min_x_get(PointerRNA *ptr);
void LimitLocationConstraint_min_x_set(PointerRNA *ptr, float value);

int LimitLocationConstraint_use_min_y_get(PointerRNA *ptr);
void LimitLocationConstraint_use_min_y_set(PointerRNA *ptr, int value);

float LimitLocationConstraint_min_y_get(PointerRNA *ptr);
void LimitLocationConstraint_min_y_set(PointerRNA *ptr, float value);

int LimitLocationConstraint_use_min_z_get(PointerRNA *ptr);
void LimitLocationConstraint_use_min_z_set(PointerRNA *ptr, int value);

float LimitLocationConstraint_min_z_get(PointerRNA *ptr);
void LimitLocationConstraint_min_z_set(PointerRNA *ptr, float value);

/**************** Limit Rotation Constraint ****************/

extern StructRNA RNA_LimitRotationConstraint;
extern StructRNA RNA_Constraint;

int LimitRotationConstraint_use_transform_limit_get(PointerRNA *ptr);
void LimitRotationConstraint_use_transform_limit_set(PointerRNA *ptr, int value);

int LimitRotationConstraint_use_limit_x_get(PointerRNA *ptr);
void LimitRotationConstraint_use_limit_x_set(PointerRNA *ptr, int value);

int LimitRotationConstraint_use_limit_y_get(PointerRNA *ptr);
void LimitRotationConstraint_use_limit_y_set(PointerRNA *ptr, int value);

int LimitRotationConstraint_use_limit_z_get(PointerRNA *ptr);
void LimitRotationConstraint_use_limit_z_set(PointerRNA *ptr, int value);

float LimitRotationConstraint_max_x_get(PointerRNA *ptr);
void LimitRotationConstraint_max_x_set(PointerRNA *ptr, float value);

float LimitRotationConstraint_max_y_get(PointerRNA *ptr);
void LimitRotationConstraint_max_y_set(PointerRNA *ptr, float value);

float LimitRotationConstraint_max_z_get(PointerRNA *ptr);
void LimitRotationConstraint_max_z_set(PointerRNA *ptr, float value);

float LimitRotationConstraint_min_x_get(PointerRNA *ptr);
void LimitRotationConstraint_min_x_set(PointerRNA *ptr, float value);

float LimitRotationConstraint_min_y_get(PointerRNA *ptr);
void LimitRotationConstraint_min_y_set(PointerRNA *ptr, float value);

float LimitRotationConstraint_min_z_get(PointerRNA *ptr);
void LimitRotationConstraint_min_z_set(PointerRNA *ptr, float value);

/**************** Limit Size Constraint ****************/

extern StructRNA RNA_LimitScaleConstraint;
extern StructRNA RNA_Constraint;

int LimitScaleConstraint_use_transform_limit_get(PointerRNA *ptr);
void LimitScaleConstraint_use_transform_limit_set(PointerRNA *ptr, int value);

int LimitScaleConstraint_use_max_x_get(PointerRNA *ptr);
void LimitScaleConstraint_use_max_x_set(PointerRNA *ptr, int value);

float LimitScaleConstraint_max_x_get(PointerRNA *ptr);
void LimitScaleConstraint_max_x_set(PointerRNA *ptr, float value);

int LimitScaleConstraint_use_max_y_get(PointerRNA *ptr);
void LimitScaleConstraint_use_max_y_set(PointerRNA *ptr, int value);

float LimitScaleConstraint_max_y_get(PointerRNA *ptr);
void LimitScaleConstraint_max_y_set(PointerRNA *ptr, float value);

int LimitScaleConstraint_use_max_z_get(PointerRNA *ptr);
void LimitScaleConstraint_use_max_z_set(PointerRNA *ptr, int value);

float LimitScaleConstraint_max_z_get(PointerRNA *ptr);
void LimitScaleConstraint_max_z_set(PointerRNA *ptr, float value);

int LimitScaleConstraint_use_min_x_get(PointerRNA *ptr);
void LimitScaleConstraint_use_min_x_set(PointerRNA *ptr, int value);

float LimitScaleConstraint_min_x_get(PointerRNA *ptr);
void LimitScaleConstraint_min_x_set(PointerRNA *ptr, float value);

int LimitScaleConstraint_use_min_y_get(PointerRNA *ptr);
void LimitScaleConstraint_use_min_y_set(PointerRNA *ptr, int value);

float LimitScaleConstraint_min_y_get(PointerRNA *ptr);
void LimitScaleConstraint_min_y_set(PointerRNA *ptr, float value);

int LimitScaleConstraint_use_min_z_get(PointerRNA *ptr);
void LimitScaleConstraint_use_min_z_set(PointerRNA *ptr, int value);

float LimitScaleConstraint_min_z_get(PointerRNA *ptr);
void LimitScaleConstraint_min_z_set(PointerRNA *ptr, float value);

/**************** Line Style Alpha Modifier ****************/

extern StructRNA RNA_LineStyleAlphaModifier;
extern StructRNA RNA_LineStyleModifier;

/**************** Along Stroke ****************/

extern StructRNA RNA_LineStyleAlphaModifier_AlongStroke;
extern StructRNA RNA_LineStyleAlphaModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleAlphaModifier_AlongStroke_name_MAX 64

void LineStyleAlphaModifier_AlongStroke_name_get(PointerRNA *ptr, char *value);
int LineStyleAlphaModifier_AlongStroke_name_length(PointerRNA *ptr);
void LineStyleAlphaModifier_AlongStroke_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleAlphaModifier_AlongStroke_blend_MIX = 0,
	LineStyleAlphaModifier_AlongStroke_blend_ADD = 1,
	LineStyleAlphaModifier_AlongStroke_blend_SUBTRACT = 3,
	LineStyleAlphaModifier_AlongStroke_blend_MULTIPLY = 2,
	LineStyleAlphaModifier_AlongStroke_blend_DIVIDE = 4,
	LineStyleAlphaModifier_AlongStroke_blend_DIFFERENCE = 5,
	LineStyleAlphaModifier_AlongStroke_blend_MININUM = 6,
	LineStyleAlphaModifier_AlongStroke_blend_MAXIMUM = 7,
};

int LineStyleAlphaModifier_AlongStroke_blend_get(PointerRNA *ptr);
void LineStyleAlphaModifier_AlongStroke_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleAlphaModifier_AlongStroke_curve_get(PointerRNA *ptr);

int LineStyleAlphaModifier_AlongStroke_expanded_get(PointerRNA *ptr);
void LineStyleAlphaModifier_AlongStroke_expanded_set(PointerRNA *ptr, int value);

float LineStyleAlphaModifier_AlongStroke_influence_get(PointerRNA *ptr);
void LineStyleAlphaModifier_AlongStroke_influence_set(PointerRNA *ptr, float value);

int LineStyleAlphaModifier_AlongStroke_invert_get(PointerRNA *ptr);
void LineStyleAlphaModifier_AlongStroke_invert_set(PointerRNA *ptr, int value);

enum {
	LineStyleAlphaModifier_AlongStroke_mapping_LINEAR = 0,
	LineStyleAlphaModifier_AlongStroke_mapping_CURVE = 1,
};

int LineStyleAlphaModifier_AlongStroke_mapping_get(PointerRNA *ptr);
void LineStyleAlphaModifier_AlongStroke_mapping_set(PointerRNA *ptr, int value);

enum {
	LineStyleAlphaModifier_AlongStroke_type_ALONG_STROKE = 1,
	LineStyleAlphaModifier_AlongStroke_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleAlphaModifier_AlongStroke_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleAlphaModifier_AlongStroke_type_MATERIAL = 4,
};

int LineStyleAlphaModifier_AlongStroke_type_get(PointerRNA *ptr);
void LineStyleAlphaModifier_AlongStroke_type_set(PointerRNA *ptr, int value);

int LineStyleAlphaModifier_AlongStroke_use_get(PointerRNA *ptr);
void LineStyleAlphaModifier_AlongStroke_use_set(PointerRNA *ptr, int value);

/**************** Distance from Camera ****************/

extern StructRNA RNA_LineStyleAlphaModifier_DistanceFromCamera;
extern StructRNA RNA_LineStyleAlphaModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleAlphaModifier_DistanceFromCamera_name_MAX 64

void LineStyleAlphaModifier_DistanceFromCamera_name_get(PointerRNA *ptr, char *value);
int LineStyleAlphaModifier_DistanceFromCamera_name_length(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleAlphaModifier_DistanceFromCamera_blend_MIX = 0,
	LineStyleAlphaModifier_DistanceFromCamera_blend_ADD = 1,
	LineStyleAlphaModifier_DistanceFromCamera_blend_SUBTRACT = 3,
	LineStyleAlphaModifier_DistanceFromCamera_blend_MULTIPLY = 2,
	LineStyleAlphaModifier_DistanceFromCamera_blend_DIVIDE = 4,
	LineStyleAlphaModifier_DistanceFromCamera_blend_DIFFERENCE = 5,
	LineStyleAlphaModifier_DistanceFromCamera_blend_MININUM = 6,
	LineStyleAlphaModifier_DistanceFromCamera_blend_MAXIMUM = 7,
};

int LineStyleAlphaModifier_DistanceFromCamera_blend_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleAlphaModifier_DistanceFromCamera_curve_get(PointerRNA *ptr);

int LineStyleAlphaModifier_DistanceFromCamera_expanded_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_expanded_set(PointerRNA *ptr, int value);

float LineStyleAlphaModifier_DistanceFromCamera_influence_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_influence_set(PointerRNA *ptr, float value);

int LineStyleAlphaModifier_DistanceFromCamera_invert_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_invert_set(PointerRNA *ptr, int value);

enum {
	LineStyleAlphaModifier_DistanceFromCamera_mapping_LINEAR = 0,
	LineStyleAlphaModifier_DistanceFromCamera_mapping_CURVE = 1,
};

int LineStyleAlphaModifier_DistanceFromCamera_mapping_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_mapping_set(PointerRNA *ptr, int value);

enum {
	LineStyleAlphaModifier_DistanceFromCamera_type_ALONG_STROKE = 1,
	LineStyleAlphaModifier_DistanceFromCamera_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleAlphaModifier_DistanceFromCamera_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleAlphaModifier_DistanceFromCamera_type_MATERIAL = 4,
};

int LineStyleAlphaModifier_DistanceFromCamera_type_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_type_set(PointerRNA *ptr, int value);

float LineStyleAlphaModifier_DistanceFromCamera_range_max_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_range_max_set(PointerRNA *ptr, float value);

float LineStyleAlphaModifier_DistanceFromCamera_range_min_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_range_min_set(PointerRNA *ptr, float value);

int LineStyleAlphaModifier_DistanceFromCamera_use_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromCamera_use_set(PointerRNA *ptr, int value);

/**************** Distance from Object ****************/

extern StructRNA RNA_LineStyleAlphaModifier_DistanceFromObject;
extern StructRNA RNA_LineStyleAlphaModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleAlphaModifier_DistanceFromObject_name_MAX 64

void LineStyleAlphaModifier_DistanceFromObject_name_get(PointerRNA *ptr, char *value);
int LineStyleAlphaModifier_DistanceFromObject_name_length(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleAlphaModifier_DistanceFromObject_blend_MIX = 0,
	LineStyleAlphaModifier_DistanceFromObject_blend_ADD = 1,
	LineStyleAlphaModifier_DistanceFromObject_blend_SUBTRACT = 3,
	LineStyleAlphaModifier_DistanceFromObject_blend_MULTIPLY = 2,
	LineStyleAlphaModifier_DistanceFromObject_blend_DIVIDE = 4,
	LineStyleAlphaModifier_DistanceFromObject_blend_DIFFERENCE = 5,
	LineStyleAlphaModifier_DistanceFromObject_blend_MININUM = 6,
	LineStyleAlphaModifier_DistanceFromObject_blend_MAXIMUM = 7,
};

int LineStyleAlphaModifier_DistanceFromObject_blend_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleAlphaModifier_DistanceFromObject_curve_get(PointerRNA *ptr);

int LineStyleAlphaModifier_DistanceFromObject_expanded_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_expanded_set(PointerRNA *ptr, int value);

float LineStyleAlphaModifier_DistanceFromObject_influence_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_influence_set(PointerRNA *ptr, float value);

int LineStyleAlphaModifier_DistanceFromObject_invert_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_invert_set(PointerRNA *ptr, int value);

enum {
	LineStyleAlphaModifier_DistanceFromObject_mapping_LINEAR = 0,
	LineStyleAlphaModifier_DistanceFromObject_mapping_CURVE = 1,
};

int LineStyleAlphaModifier_DistanceFromObject_mapping_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_mapping_set(PointerRNA *ptr, int value);

enum {
	LineStyleAlphaModifier_DistanceFromObject_type_ALONG_STROKE = 1,
	LineStyleAlphaModifier_DistanceFromObject_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleAlphaModifier_DistanceFromObject_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleAlphaModifier_DistanceFromObject_type_MATERIAL = 4,
};

int LineStyleAlphaModifier_DistanceFromObject_type_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_type_set(PointerRNA *ptr, int value);

float LineStyleAlphaModifier_DistanceFromObject_range_max_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_range_max_set(PointerRNA *ptr, float value);

float LineStyleAlphaModifier_DistanceFromObject_range_min_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_range_min_set(PointerRNA *ptr, float value);

PointerRNA LineStyleAlphaModifier_DistanceFromObject_target_get(PointerRNA *ptr);

int LineStyleAlphaModifier_DistanceFromObject_use_get(PointerRNA *ptr);
void LineStyleAlphaModifier_DistanceFromObject_use_set(PointerRNA *ptr, int value);

/**************** Material ****************/

extern StructRNA RNA_LineStyleAlphaModifier_Material;
extern StructRNA RNA_LineStyleAlphaModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleAlphaModifier_Material_name_MAX 64

void LineStyleAlphaModifier_Material_name_get(PointerRNA *ptr, char *value);
int LineStyleAlphaModifier_Material_name_length(PointerRNA *ptr);
void LineStyleAlphaModifier_Material_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleAlphaModifier_Material_blend_MIX = 0,
	LineStyleAlphaModifier_Material_blend_ADD = 1,
	LineStyleAlphaModifier_Material_blend_SUBTRACT = 3,
	LineStyleAlphaModifier_Material_blend_MULTIPLY = 2,
	LineStyleAlphaModifier_Material_blend_DIVIDE = 4,
	LineStyleAlphaModifier_Material_blend_DIFFERENCE = 5,
	LineStyleAlphaModifier_Material_blend_MININUM = 6,
	LineStyleAlphaModifier_Material_blend_MAXIMUM = 7,
};

int LineStyleAlphaModifier_Material_blend_get(PointerRNA *ptr);
void LineStyleAlphaModifier_Material_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleAlphaModifier_Material_curve_get(PointerRNA *ptr);

int LineStyleAlphaModifier_Material_expanded_get(PointerRNA *ptr);
void LineStyleAlphaModifier_Material_expanded_set(PointerRNA *ptr, int value);

float LineStyleAlphaModifier_Material_influence_get(PointerRNA *ptr);
void LineStyleAlphaModifier_Material_influence_set(PointerRNA *ptr, float value);

int LineStyleAlphaModifier_Material_invert_get(PointerRNA *ptr);
void LineStyleAlphaModifier_Material_invert_set(PointerRNA *ptr, int value);

enum {
	LineStyleAlphaModifier_Material_mapping_LINEAR = 0,
	LineStyleAlphaModifier_Material_mapping_CURVE = 1,
};

int LineStyleAlphaModifier_Material_mapping_get(PointerRNA *ptr);
void LineStyleAlphaModifier_Material_mapping_set(PointerRNA *ptr, int value);

enum {
	LineStyleAlphaModifier_Material_material_attribute_LINE = 11,
	LineStyleAlphaModifier_Material_material_attribute_LINE_R = 12,
	LineStyleAlphaModifier_Material_material_attribute_LINE_G = 13,
	LineStyleAlphaModifier_Material_material_attribute_LINE_B = 14,
	LineStyleAlphaModifier_Material_material_attribute_LINE_A = 15,
	LineStyleAlphaModifier_Material_material_attribute_DIFF = 1,
	LineStyleAlphaModifier_Material_material_attribute_DIFF_R = 2,
	LineStyleAlphaModifier_Material_material_attribute_DIFF_G = 3,
	LineStyleAlphaModifier_Material_material_attribute_DIFF_B = 4,
	LineStyleAlphaModifier_Material_material_attribute_SPEC = 5,
	LineStyleAlphaModifier_Material_material_attribute_SPEC_R = 6,
	LineStyleAlphaModifier_Material_material_attribute_SPEC_G = 7,
	LineStyleAlphaModifier_Material_material_attribute_SPEC_B = 8,
	LineStyleAlphaModifier_Material_material_attribute_SPEC_HARD = 9,
	LineStyleAlphaModifier_Material_material_attribute_ALPHA = 10,
};

int LineStyleAlphaModifier_Material_material_attribute_get(PointerRNA *ptr);
void LineStyleAlphaModifier_Material_material_attribute_set(PointerRNA *ptr, int value);

enum {
	LineStyleAlphaModifier_Material_type_ALONG_STROKE = 1,
	LineStyleAlphaModifier_Material_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleAlphaModifier_Material_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleAlphaModifier_Material_type_MATERIAL = 4,
};

int LineStyleAlphaModifier_Material_type_get(PointerRNA *ptr);
void LineStyleAlphaModifier_Material_type_set(PointerRNA *ptr, int value);

int LineStyleAlphaModifier_Material_use_get(PointerRNA *ptr);
void LineStyleAlphaModifier_Material_use_set(PointerRNA *ptr, int value);

/**************** Alpha Modifiers ****************/

extern StructRNA RNA_LineStyleAlphaModifiers;

PointerRNA LineStyleAlphaModifiers_rna_type_get(PointerRNA *ptr);

struct LineStyleModifier *LineStyleAlphaModifiers_new(struct FreestyleLineStyle *_self, ReportList *reports, const char * name, int type);
void LineStyleAlphaModifiers_remove(struct FreestyleLineStyle *_self, ReportList *reports, struct PointerRNA *modifier);
/**************** Line Style Color Modifier ****************/

extern StructRNA RNA_LineStyleColorModifier;
extern StructRNA RNA_LineStyleModifier;

/**************** Along Stroke ****************/

extern StructRNA RNA_LineStyleColorModifier_AlongStroke;
extern StructRNA RNA_LineStyleColorModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleColorModifier_AlongStroke_name_MAX 64

void LineStyleColorModifier_AlongStroke_name_get(PointerRNA *ptr, char *value);
int LineStyleColorModifier_AlongStroke_name_length(PointerRNA *ptr);
void LineStyleColorModifier_AlongStroke_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleColorModifier_AlongStroke_blend_MIX = 0,
	LineStyleColorModifier_AlongStroke_blend_ADD = 1,
	LineStyleColorModifier_AlongStroke_blend_MULTIPLY = 2,
	LineStyleColorModifier_AlongStroke_blend_SUBTRACT = 3,
	LineStyleColorModifier_AlongStroke_blend_SCREEN = 4,
	LineStyleColorModifier_AlongStroke_blend_DIVIDE = 5,
	LineStyleColorModifier_AlongStroke_blend_DIFFERENCE = 6,
	LineStyleColorModifier_AlongStroke_blend_DARKEN = 7,
	LineStyleColorModifier_AlongStroke_blend_LIGHTEN = 8,
	LineStyleColorModifier_AlongStroke_blend_OVERLAY = 9,
	LineStyleColorModifier_AlongStroke_blend_DODGE = 10,
	LineStyleColorModifier_AlongStroke_blend_BURN = 11,
	LineStyleColorModifier_AlongStroke_blend_HUE = 12,
	LineStyleColorModifier_AlongStroke_blend_SATURATION = 13,
	LineStyleColorModifier_AlongStroke_blend_VALUE = 14,
	LineStyleColorModifier_AlongStroke_blend_COLOR = 15,
	LineStyleColorModifier_AlongStroke_blend_SOFT_LIGHT = 16,
	LineStyleColorModifier_AlongStroke_blend_LINEAR_LIGHT = 17,
};

int LineStyleColorModifier_AlongStroke_blend_get(PointerRNA *ptr);
void LineStyleColorModifier_AlongStroke_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleColorModifier_AlongStroke_color_ramp_get(PointerRNA *ptr);

int LineStyleColorModifier_AlongStroke_expanded_get(PointerRNA *ptr);
void LineStyleColorModifier_AlongStroke_expanded_set(PointerRNA *ptr, int value);

float LineStyleColorModifier_AlongStroke_influence_get(PointerRNA *ptr);
void LineStyleColorModifier_AlongStroke_influence_set(PointerRNA *ptr, float value);

enum {
	LineStyleColorModifier_AlongStroke_type_ALONG_STROKE = 1,
	LineStyleColorModifier_AlongStroke_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleColorModifier_AlongStroke_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleColorModifier_AlongStroke_type_MATERIAL = 4,
};

int LineStyleColorModifier_AlongStroke_type_get(PointerRNA *ptr);
void LineStyleColorModifier_AlongStroke_type_set(PointerRNA *ptr, int value);

int LineStyleColorModifier_AlongStroke_use_get(PointerRNA *ptr);
void LineStyleColorModifier_AlongStroke_use_set(PointerRNA *ptr, int value);

/**************** Distance from Camera ****************/

extern StructRNA RNA_LineStyleColorModifier_DistanceFromCamera;
extern StructRNA RNA_LineStyleColorModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleColorModifier_DistanceFromCamera_name_MAX 64

void LineStyleColorModifier_DistanceFromCamera_name_get(PointerRNA *ptr, char *value);
int LineStyleColorModifier_DistanceFromCamera_name_length(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromCamera_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleColorModifier_DistanceFromCamera_blend_MIX = 0,
	LineStyleColorModifier_DistanceFromCamera_blend_ADD = 1,
	LineStyleColorModifier_DistanceFromCamera_blend_MULTIPLY = 2,
	LineStyleColorModifier_DistanceFromCamera_blend_SUBTRACT = 3,
	LineStyleColorModifier_DistanceFromCamera_blend_SCREEN = 4,
	LineStyleColorModifier_DistanceFromCamera_blend_DIVIDE = 5,
	LineStyleColorModifier_DistanceFromCamera_blend_DIFFERENCE = 6,
	LineStyleColorModifier_DistanceFromCamera_blend_DARKEN = 7,
	LineStyleColorModifier_DistanceFromCamera_blend_LIGHTEN = 8,
	LineStyleColorModifier_DistanceFromCamera_blend_OVERLAY = 9,
	LineStyleColorModifier_DistanceFromCamera_blend_DODGE = 10,
	LineStyleColorModifier_DistanceFromCamera_blend_BURN = 11,
	LineStyleColorModifier_DistanceFromCamera_blend_HUE = 12,
	LineStyleColorModifier_DistanceFromCamera_blend_SATURATION = 13,
	LineStyleColorModifier_DistanceFromCamera_blend_VALUE = 14,
	LineStyleColorModifier_DistanceFromCamera_blend_COLOR = 15,
	LineStyleColorModifier_DistanceFromCamera_blend_SOFT_LIGHT = 16,
	LineStyleColorModifier_DistanceFromCamera_blend_LINEAR_LIGHT = 17,
};

int LineStyleColorModifier_DistanceFromCamera_blend_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromCamera_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleColorModifier_DistanceFromCamera_color_ramp_get(PointerRNA *ptr);

int LineStyleColorModifier_DistanceFromCamera_expanded_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromCamera_expanded_set(PointerRNA *ptr, int value);

float LineStyleColorModifier_DistanceFromCamera_influence_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromCamera_influence_set(PointerRNA *ptr, float value);

enum {
	LineStyleColorModifier_DistanceFromCamera_type_ALONG_STROKE = 1,
	LineStyleColorModifier_DistanceFromCamera_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleColorModifier_DistanceFromCamera_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleColorModifier_DistanceFromCamera_type_MATERIAL = 4,
};

int LineStyleColorModifier_DistanceFromCamera_type_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromCamera_type_set(PointerRNA *ptr, int value);

float LineStyleColorModifier_DistanceFromCamera_range_max_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromCamera_range_max_set(PointerRNA *ptr, float value);

float LineStyleColorModifier_DistanceFromCamera_range_min_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromCamera_range_min_set(PointerRNA *ptr, float value);

int LineStyleColorModifier_DistanceFromCamera_use_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromCamera_use_set(PointerRNA *ptr, int value);

/**************** Distance from Object ****************/

extern StructRNA RNA_LineStyleColorModifier_DistanceFromObject;
extern StructRNA RNA_LineStyleColorModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleColorModifier_DistanceFromObject_name_MAX 64

void LineStyleColorModifier_DistanceFromObject_name_get(PointerRNA *ptr, char *value);
int LineStyleColorModifier_DistanceFromObject_name_length(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromObject_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleColorModifier_DistanceFromObject_blend_MIX = 0,
	LineStyleColorModifier_DistanceFromObject_blend_ADD = 1,
	LineStyleColorModifier_DistanceFromObject_blend_MULTIPLY = 2,
	LineStyleColorModifier_DistanceFromObject_blend_SUBTRACT = 3,
	LineStyleColorModifier_DistanceFromObject_blend_SCREEN = 4,
	LineStyleColorModifier_DistanceFromObject_blend_DIVIDE = 5,
	LineStyleColorModifier_DistanceFromObject_blend_DIFFERENCE = 6,
	LineStyleColorModifier_DistanceFromObject_blend_DARKEN = 7,
	LineStyleColorModifier_DistanceFromObject_blend_LIGHTEN = 8,
	LineStyleColorModifier_DistanceFromObject_blend_OVERLAY = 9,
	LineStyleColorModifier_DistanceFromObject_blend_DODGE = 10,
	LineStyleColorModifier_DistanceFromObject_blend_BURN = 11,
	LineStyleColorModifier_DistanceFromObject_blend_HUE = 12,
	LineStyleColorModifier_DistanceFromObject_blend_SATURATION = 13,
	LineStyleColorModifier_DistanceFromObject_blend_VALUE = 14,
	LineStyleColorModifier_DistanceFromObject_blend_COLOR = 15,
	LineStyleColorModifier_DistanceFromObject_blend_SOFT_LIGHT = 16,
	LineStyleColorModifier_DistanceFromObject_blend_LINEAR_LIGHT = 17,
};

int LineStyleColorModifier_DistanceFromObject_blend_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromObject_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleColorModifier_DistanceFromObject_color_ramp_get(PointerRNA *ptr);

int LineStyleColorModifier_DistanceFromObject_expanded_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromObject_expanded_set(PointerRNA *ptr, int value);

float LineStyleColorModifier_DistanceFromObject_influence_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromObject_influence_set(PointerRNA *ptr, float value);

enum {
	LineStyleColorModifier_DistanceFromObject_type_ALONG_STROKE = 1,
	LineStyleColorModifier_DistanceFromObject_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleColorModifier_DistanceFromObject_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleColorModifier_DistanceFromObject_type_MATERIAL = 4,
};

int LineStyleColorModifier_DistanceFromObject_type_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromObject_type_set(PointerRNA *ptr, int value);

float LineStyleColorModifier_DistanceFromObject_range_max_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromObject_range_max_set(PointerRNA *ptr, float value);

float LineStyleColorModifier_DistanceFromObject_range_min_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromObject_range_min_set(PointerRNA *ptr, float value);

PointerRNA LineStyleColorModifier_DistanceFromObject_target_get(PointerRNA *ptr);

int LineStyleColorModifier_DistanceFromObject_use_get(PointerRNA *ptr);
void LineStyleColorModifier_DistanceFromObject_use_set(PointerRNA *ptr, int value);

/**************** Material ****************/

extern StructRNA RNA_LineStyleColorModifier_Material;
extern StructRNA RNA_LineStyleColorModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleColorModifier_Material_name_MAX 64

void LineStyleColorModifier_Material_name_get(PointerRNA *ptr, char *value);
int LineStyleColorModifier_Material_name_length(PointerRNA *ptr);
void LineStyleColorModifier_Material_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleColorModifier_Material_blend_MIX = 0,
	LineStyleColorModifier_Material_blend_ADD = 1,
	LineStyleColorModifier_Material_blend_MULTIPLY = 2,
	LineStyleColorModifier_Material_blend_SUBTRACT = 3,
	LineStyleColorModifier_Material_blend_SCREEN = 4,
	LineStyleColorModifier_Material_blend_DIVIDE = 5,
	LineStyleColorModifier_Material_blend_DIFFERENCE = 6,
	LineStyleColorModifier_Material_blend_DARKEN = 7,
	LineStyleColorModifier_Material_blend_LIGHTEN = 8,
	LineStyleColorModifier_Material_blend_OVERLAY = 9,
	LineStyleColorModifier_Material_blend_DODGE = 10,
	LineStyleColorModifier_Material_blend_BURN = 11,
	LineStyleColorModifier_Material_blend_HUE = 12,
	LineStyleColorModifier_Material_blend_SATURATION = 13,
	LineStyleColorModifier_Material_blend_VALUE = 14,
	LineStyleColorModifier_Material_blend_COLOR = 15,
	LineStyleColorModifier_Material_blend_SOFT_LIGHT = 16,
	LineStyleColorModifier_Material_blend_LINEAR_LIGHT = 17,
};

int LineStyleColorModifier_Material_blend_get(PointerRNA *ptr);
void LineStyleColorModifier_Material_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleColorModifier_Material_color_ramp_get(PointerRNA *ptr);

int LineStyleColorModifier_Material_expanded_get(PointerRNA *ptr);
void LineStyleColorModifier_Material_expanded_set(PointerRNA *ptr, int value);

float LineStyleColorModifier_Material_influence_get(PointerRNA *ptr);
void LineStyleColorModifier_Material_influence_set(PointerRNA *ptr, float value);

enum {
	LineStyleColorModifier_Material_material_attribute_LINE = 11,
	LineStyleColorModifier_Material_material_attribute_LINE_R = 12,
	LineStyleColorModifier_Material_material_attribute_LINE_G = 13,
	LineStyleColorModifier_Material_material_attribute_LINE_B = 14,
	LineStyleColorModifier_Material_material_attribute_LINE_A = 15,
	LineStyleColorModifier_Material_material_attribute_DIFF = 1,
	LineStyleColorModifier_Material_material_attribute_DIFF_R = 2,
	LineStyleColorModifier_Material_material_attribute_DIFF_G = 3,
	LineStyleColorModifier_Material_material_attribute_DIFF_B = 4,
	LineStyleColorModifier_Material_material_attribute_SPEC = 5,
	LineStyleColorModifier_Material_material_attribute_SPEC_R = 6,
	LineStyleColorModifier_Material_material_attribute_SPEC_G = 7,
	LineStyleColorModifier_Material_material_attribute_SPEC_B = 8,
	LineStyleColorModifier_Material_material_attribute_SPEC_HARD = 9,
	LineStyleColorModifier_Material_material_attribute_ALPHA = 10,
};

int LineStyleColorModifier_Material_material_attribute_get(PointerRNA *ptr);
void LineStyleColorModifier_Material_material_attribute_set(PointerRNA *ptr, int value);

enum {
	LineStyleColorModifier_Material_type_ALONG_STROKE = 1,
	LineStyleColorModifier_Material_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleColorModifier_Material_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleColorModifier_Material_type_MATERIAL = 4,
};

int LineStyleColorModifier_Material_type_get(PointerRNA *ptr);
void LineStyleColorModifier_Material_type_set(PointerRNA *ptr, int value);

int LineStyleColorModifier_Material_use_ramp_get(PointerRNA *ptr);
void LineStyleColorModifier_Material_use_ramp_set(PointerRNA *ptr, int value);

int LineStyleColorModifier_Material_use_get(PointerRNA *ptr);
void LineStyleColorModifier_Material_use_set(PointerRNA *ptr, int value);

/**************** Color Modifiers ****************/

extern StructRNA RNA_LineStyleColorModifiers;

PointerRNA LineStyleColorModifiers_rna_type_get(PointerRNA *ptr);

struct LineStyleModifier *LineStyleColorModifiers_new(struct FreestyleLineStyle *_self, ReportList *reports, const char * name, int type);
void LineStyleColorModifiers_remove(struct FreestyleLineStyle *_self, ReportList *reports, struct PointerRNA *modifier);
/**************** Line Style Geometry Modifier ****************/

extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

/**************** 2D Offset ****************/

extern StructRNA RNA_LineStyleGeometryModifier_2DOffset;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_2DOffset_name_MAX 64

void LineStyleGeometryModifier_2DOffset_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_2DOffset_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_2DOffset_name_set(PointerRNA *ptr, const char *value);

float LineStyleGeometryModifier_2DOffset_end_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DOffset_end_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_2DOffset_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DOffset_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_2DOffset_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_2DOffset_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_2DOffset_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_2DOffset_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_2DOffset_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_2DOffset_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_2DOffset_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_2DOffset_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_2DOffset_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_2DOffset_type_SAMPLING = 5,
	LineStyleGeometryModifier_2DOffset_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_2DOffset_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_2DOffset_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_2DOffset_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DOffset_type_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_2DOffset_start_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DOffset_start_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_2DOffset_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DOffset_use_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_2DOffset_x_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DOffset_x_set(PointerRNA *ptr, float value);

float LineStyleGeometryModifier_2DOffset_y_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DOffset_y_set(PointerRNA *ptr, float value);

/**************** 2D Transform ****************/

extern StructRNA RNA_LineStyleGeometryModifier_2DTransform;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_2DTransform_name_MAX 64

void LineStyleGeometryModifier_2DTransform_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_2DTransform_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_name_set(PointerRNA *ptr, const char *value);

int LineStyleGeometryModifier_2DTransform_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_2DTransform_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_2DTransform_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_2DTransform_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_2DTransform_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_2DTransform_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_2DTransform_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_2DTransform_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_2DTransform_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_2DTransform_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_2DTransform_type_SAMPLING = 5,
	LineStyleGeometryModifier_2DTransform_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_2DTransform_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_2DTransform_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_2DTransform_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_type_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_2DTransform_pivot_CENTER = 1,
	LineStyleGeometryModifier_2DTransform_pivot_START = 2,
	LineStyleGeometryModifier_2DTransform_pivot_END = 3,
	LineStyleGeometryModifier_2DTransform_pivot_PARAM = 4,
	LineStyleGeometryModifier_2DTransform_pivot_ABSOLUTE = 5,
};

int LineStyleGeometryModifier_2DTransform_pivot_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_pivot_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_2DTransform_pivot_x_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_pivot_x_set(PointerRNA *ptr, float value);

float LineStyleGeometryModifier_2DTransform_pivot_y_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_pivot_y_set(PointerRNA *ptr, float value);

float LineStyleGeometryModifier_2DTransform_angle_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_angle_set(PointerRNA *ptr, float value);

float LineStyleGeometryModifier_2DTransform_scale_x_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_scale_x_set(PointerRNA *ptr, float value);

float LineStyleGeometryModifier_2DTransform_scale_y_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_scale_y_set(PointerRNA *ptr, float value);

float LineStyleGeometryModifier_2DTransform_pivot_u_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_pivot_u_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_2DTransform_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_2DTransform_use_set(PointerRNA *ptr, int value);

/**************** Backbone Stretcher ****************/

extern StructRNA RNA_LineStyleGeometryModifier_BackboneStretcher;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_BackboneStretcher_name_MAX 64

void LineStyleGeometryModifier_BackboneStretcher_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_BackboneStretcher_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_BackboneStretcher_name_set(PointerRNA *ptr, const char *value);

float LineStyleGeometryModifier_BackboneStretcher_backbone_length_get(PointerRNA *ptr);
void LineStyleGeometryModifier_BackboneStretcher_backbone_length_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_BackboneStretcher_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_BackboneStretcher_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_BackboneStretcher_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_BackboneStretcher_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_BackboneStretcher_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_BackboneStretcher_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_BackboneStretcher_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_BackboneStretcher_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_BackboneStretcher_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_BackboneStretcher_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_BackboneStretcher_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_BackboneStretcher_type_SAMPLING = 5,
	LineStyleGeometryModifier_BackboneStretcher_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_BackboneStretcher_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_BackboneStretcher_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_BackboneStretcher_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_BackboneStretcher_type_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_BackboneStretcher_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_BackboneStretcher_use_set(PointerRNA *ptr, int value);

/**************** Bezier Curve ****************/

extern StructRNA RNA_LineStyleGeometryModifier_BezierCurve;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_BezierCurve_name_MAX 64

void LineStyleGeometryModifier_BezierCurve_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_BezierCurve_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_BezierCurve_name_set(PointerRNA *ptr, const char *value);

float LineStyleGeometryModifier_BezierCurve_error_get(PointerRNA *ptr);
void LineStyleGeometryModifier_BezierCurve_error_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_BezierCurve_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_BezierCurve_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_BezierCurve_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_BezierCurve_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_BezierCurve_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_BezierCurve_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_BezierCurve_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_BezierCurve_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_BezierCurve_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_BezierCurve_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_BezierCurve_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_BezierCurve_type_SAMPLING = 5,
	LineStyleGeometryModifier_BezierCurve_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_BezierCurve_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_BezierCurve_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_BezierCurve_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_BezierCurve_type_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_BezierCurve_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_BezierCurve_use_set(PointerRNA *ptr, int value);

/**************** Blueprint ****************/

extern StructRNA RNA_LineStyleGeometryModifier_Blueprint;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_Blueprint_name_MAX 64

void LineStyleGeometryModifier_Blueprint_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_Blueprint_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_name_set(PointerRNA *ptr, const char *value);

float LineStyleGeometryModifier_Blueprint_backbone_length_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_backbone_length_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_Blueprint_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_Blueprint_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_Blueprint_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_Blueprint_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_Blueprint_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_Blueprint_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_Blueprint_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_Blueprint_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_Blueprint_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_Blueprint_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_Blueprint_type_SAMPLING = 5,
	LineStyleGeometryModifier_Blueprint_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_Blueprint_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_Blueprint_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_Blueprint_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_type_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_Blueprint_random_backbone_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_random_backbone_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_Blueprint_random_center_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_random_center_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_Blueprint_random_radius_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_random_radius_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_Blueprint_rounds_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_rounds_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_Blueprint_shape_CIRCLES = 1,
	LineStyleGeometryModifier_Blueprint_shape_ELLIPSES = 2,
	LineStyleGeometryModifier_Blueprint_shape_SQUARES = 4,
};

int LineStyleGeometryModifier_Blueprint_shape_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_shape_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_Blueprint_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Blueprint_use_set(PointerRNA *ptr, int value);

/**************** Guiding Lines ****************/

extern StructRNA RNA_LineStyleGeometryModifier_GuidingLines;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_GuidingLines_name_MAX 64

void LineStyleGeometryModifier_GuidingLines_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_GuidingLines_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_GuidingLines_name_set(PointerRNA *ptr, const char *value);

int LineStyleGeometryModifier_GuidingLines_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_GuidingLines_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_GuidingLines_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_GuidingLines_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_GuidingLines_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_GuidingLines_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_GuidingLines_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_GuidingLines_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_GuidingLines_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_GuidingLines_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_GuidingLines_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_GuidingLines_type_SAMPLING = 5,
	LineStyleGeometryModifier_GuidingLines_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_GuidingLines_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_GuidingLines_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_GuidingLines_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_GuidingLines_type_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_GuidingLines_offset_get(PointerRNA *ptr);
void LineStyleGeometryModifier_GuidingLines_offset_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_GuidingLines_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_GuidingLines_use_set(PointerRNA *ptr, int value);

/**************** Perlin Noise 1D ****************/

extern StructRNA RNA_LineStyleGeometryModifier_PerlinNoise1D;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_PerlinNoise1D_name_MAX 64

void LineStyleGeometryModifier_PerlinNoise1D_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_PerlinNoise1D_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise1D_name_set(PointerRNA *ptr, const char *value);

float LineStyleGeometryModifier_PerlinNoise1D_amplitude_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise1D_amplitude_set(PointerRNA *ptr, float value);

float LineStyleGeometryModifier_PerlinNoise1D_angle_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise1D_angle_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_PerlinNoise1D_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise1D_expanded_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_PerlinNoise1D_frequency_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise1D_frequency_set(PointerRNA *ptr, float value);

enum {
	LineStyleGeometryModifier_PerlinNoise1D_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_PerlinNoise1D_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_PerlinNoise1D_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_PerlinNoise1D_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_PerlinNoise1D_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_PerlinNoise1D_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_PerlinNoise1D_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_PerlinNoise1D_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_PerlinNoise1D_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_PerlinNoise1D_type_SAMPLING = 5,
	LineStyleGeometryModifier_PerlinNoise1D_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_PerlinNoise1D_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_PerlinNoise1D_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_PerlinNoise1D_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise1D_type_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_PerlinNoise1D_octaves_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise1D_octaves_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_PerlinNoise1D_seed_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise1D_seed_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_PerlinNoise1D_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise1D_use_set(PointerRNA *ptr, int value);

/**************** Perlin Noise 2D ****************/

extern StructRNA RNA_LineStyleGeometryModifier_PerlinNoise2D;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_PerlinNoise2D_name_MAX 64

void LineStyleGeometryModifier_PerlinNoise2D_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_PerlinNoise2D_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise2D_name_set(PointerRNA *ptr, const char *value);

float LineStyleGeometryModifier_PerlinNoise2D_amplitude_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise2D_amplitude_set(PointerRNA *ptr, float value);

float LineStyleGeometryModifier_PerlinNoise2D_angle_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise2D_angle_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_PerlinNoise2D_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise2D_expanded_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_PerlinNoise2D_frequency_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise2D_frequency_set(PointerRNA *ptr, float value);

enum {
	LineStyleGeometryModifier_PerlinNoise2D_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_PerlinNoise2D_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_PerlinNoise2D_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_PerlinNoise2D_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_PerlinNoise2D_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_PerlinNoise2D_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_PerlinNoise2D_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_PerlinNoise2D_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_PerlinNoise2D_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_PerlinNoise2D_type_SAMPLING = 5,
	LineStyleGeometryModifier_PerlinNoise2D_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_PerlinNoise2D_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_PerlinNoise2D_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_PerlinNoise2D_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise2D_type_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_PerlinNoise2D_octaves_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise2D_octaves_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_PerlinNoise2D_seed_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise2D_seed_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_PerlinNoise2D_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_PerlinNoise2D_use_set(PointerRNA *ptr, int value);

/**************** Polygonalization ****************/

extern StructRNA RNA_LineStyleGeometryModifier_Polygonalization;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_Polygonalization_name_MAX 64

void LineStyleGeometryModifier_Polygonalization_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_Polygonalization_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_Polygonalization_name_set(PointerRNA *ptr, const char *value);

float LineStyleGeometryModifier_Polygonalization_error_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Polygonalization_error_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_Polygonalization_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Polygonalization_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_Polygonalization_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_Polygonalization_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_Polygonalization_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_Polygonalization_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_Polygonalization_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_Polygonalization_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_Polygonalization_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_Polygonalization_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_Polygonalization_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_Polygonalization_type_SAMPLING = 5,
	LineStyleGeometryModifier_Polygonalization_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_Polygonalization_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_Polygonalization_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_Polygonalization_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Polygonalization_type_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_Polygonalization_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Polygonalization_use_set(PointerRNA *ptr, int value);

/**************** Sampling ****************/

extern StructRNA RNA_LineStyleGeometryModifier_Sampling;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_Sampling_name_MAX 64

void LineStyleGeometryModifier_Sampling_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_Sampling_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_Sampling_name_set(PointerRNA *ptr, const char *value);

int LineStyleGeometryModifier_Sampling_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Sampling_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_Sampling_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_Sampling_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_Sampling_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_Sampling_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_Sampling_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_Sampling_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_Sampling_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_Sampling_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_Sampling_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_Sampling_type_SAMPLING = 5,
	LineStyleGeometryModifier_Sampling_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_Sampling_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_Sampling_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_Sampling_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Sampling_type_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_Sampling_sampling_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Sampling_sampling_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_Sampling_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_Sampling_use_set(PointerRNA *ptr, int value);

/**************** Sinus Displacement ****************/

extern StructRNA RNA_LineStyleGeometryModifier_SinusDisplacement;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_SinusDisplacement_name_MAX 64

void LineStyleGeometryModifier_SinusDisplacement_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_SinusDisplacement_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_SinusDisplacement_name_set(PointerRNA *ptr, const char *value);

float LineStyleGeometryModifier_SinusDisplacement_amplitude_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SinusDisplacement_amplitude_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_SinusDisplacement_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SinusDisplacement_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_SinusDisplacement_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_SinusDisplacement_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_SinusDisplacement_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_SinusDisplacement_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_SinusDisplacement_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_SinusDisplacement_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_SinusDisplacement_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_SinusDisplacement_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_SinusDisplacement_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_SinusDisplacement_type_SAMPLING = 5,
	LineStyleGeometryModifier_SinusDisplacement_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_SinusDisplacement_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_SinusDisplacement_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_SinusDisplacement_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SinusDisplacement_type_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_SinusDisplacement_phase_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SinusDisplacement_phase_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_SinusDisplacement_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SinusDisplacement_use_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_SinusDisplacement_wavelength_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SinusDisplacement_wavelength_set(PointerRNA *ptr, float value);

/**************** Spatial Noise ****************/

extern StructRNA RNA_LineStyleGeometryModifier_SpatialNoise;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_SpatialNoise_name_MAX 64

void LineStyleGeometryModifier_SpatialNoise_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_SpatialNoise_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_SpatialNoise_name_set(PointerRNA *ptr, const char *value);

float LineStyleGeometryModifier_SpatialNoise_amplitude_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SpatialNoise_amplitude_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_SpatialNoise_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SpatialNoise_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_SpatialNoise_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_SpatialNoise_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_SpatialNoise_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_SpatialNoise_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_SpatialNoise_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_SpatialNoise_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_SpatialNoise_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_SpatialNoise_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_SpatialNoise_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_SpatialNoise_type_SAMPLING = 5,
	LineStyleGeometryModifier_SpatialNoise_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_SpatialNoise_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_SpatialNoise_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_SpatialNoise_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SpatialNoise_type_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_SpatialNoise_octaves_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SpatialNoise_octaves_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_SpatialNoise_use_pure_random_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SpatialNoise_use_pure_random_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_SpatialNoise_scale_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SpatialNoise_scale_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_SpatialNoise_smooth_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SpatialNoise_smooth_set(PointerRNA *ptr, int value);

int LineStyleGeometryModifier_SpatialNoise_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_SpatialNoise_use_set(PointerRNA *ptr, int value);

/**************** Tip Remover ****************/

extern StructRNA RNA_LineStyleGeometryModifier_TipRemover;
extern StructRNA RNA_LineStyleGeometryModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleGeometryModifier_TipRemover_name_MAX 64

void LineStyleGeometryModifier_TipRemover_name_get(PointerRNA *ptr, char *value);
int LineStyleGeometryModifier_TipRemover_name_length(PointerRNA *ptr);
void LineStyleGeometryModifier_TipRemover_name_set(PointerRNA *ptr, const char *value);

int LineStyleGeometryModifier_TipRemover_expanded_get(PointerRNA *ptr);
void LineStyleGeometryModifier_TipRemover_expanded_set(PointerRNA *ptr, int value);

enum {
	LineStyleGeometryModifier_TipRemover_type_2D_OFFSET = 17,
	LineStyleGeometryModifier_TipRemover_type_2D_TRANSFORM = 18,
	LineStyleGeometryModifier_TipRemover_type_BACKBONE_STRETCHER = 11,
	LineStyleGeometryModifier_TipRemover_type_BEZIER_CURVE = 6,
	LineStyleGeometryModifier_TipRemover_type_BLUEPRINT = 16,
	LineStyleGeometryModifier_TipRemover_type_GUIDING_LINES = 15,
	LineStyleGeometryModifier_TipRemover_type_PERLIN_NOISE_1D = 9,
	LineStyleGeometryModifier_TipRemover_type_PERLIN_NOISE_2D = 10,
	LineStyleGeometryModifier_TipRemover_type_POLYGONIZATION = 14,
	LineStyleGeometryModifier_TipRemover_type_SAMPLING = 5,
	LineStyleGeometryModifier_TipRemover_type_SINUS_DISPLACEMENT = 7,
	LineStyleGeometryModifier_TipRemover_type_SPATIAL_NOISE = 8,
	LineStyleGeometryModifier_TipRemover_type_TIP_REMOVER = 12,
};

int LineStyleGeometryModifier_TipRemover_type_get(PointerRNA *ptr);
void LineStyleGeometryModifier_TipRemover_type_set(PointerRNA *ptr, int value);

float LineStyleGeometryModifier_TipRemover_tip_length_get(PointerRNA *ptr);
void LineStyleGeometryModifier_TipRemover_tip_length_set(PointerRNA *ptr, float value);

int LineStyleGeometryModifier_TipRemover_use_get(PointerRNA *ptr);
void LineStyleGeometryModifier_TipRemover_use_set(PointerRNA *ptr, int value);

/**************** Geometry Modifiers ****************/

extern StructRNA RNA_LineStyleGeometryModifiers;

PointerRNA LineStyleGeometryModifiers_rna_type_get(PointerRNA *ptr);

struct LineStyleModifier *LineStyleGeometryModifiers_new(struct FreestyleLineStyle *_self, ReportList *reports, const char * name, int type);
void LineStyleGeometryModifiers_remove(struct FreestyleLineStyle *_self, ReportList *reports, struct PointerRNA *modifier);
/**************** Line Style Modifier ****************/

extern StructRNA RNA_LineStyleModifier;

PointerRNA LineStyleModifier_rna_type_get(PointerRNA *ptr);

/**************** LineStyle Texture Slot ****************/

extern StructRNA RNA_LineStyleTextureSlot;
extern StructRNA RNA_TextureSlot;

int LineStyleTextureSlot_use_map_alpha_get(PointerRNA *ptr);
void LineStyleTextureSlot_use_map_alpha_set(PointerRNA *ptr, int value);

float LineStyleTextureSlot_alpha_factor_get(PointerRNA *ptr);
void LineStyleTextureSlot_alpha_factor_set(PointerRNA *ptr, float value);

int LineStyleTextureSlot_use_map_color_diffuse_get(PointerRNA *ptr);
void LineStyleTextureSlot_use_map_color_diffuse_set(PointerRNA *ptr, int value);

float LineStyleTextureSlot_diffuse_color_factor_get(PointerRNA *ptr);
void LineStyleTextureSlot_diffuse_color_factor_set(PointerRNA *ptr, float value);

enum {
	LineStyleTextureSlot_mapping_FLAT = 0,
	LineStyleTextureSlot_mapping_CUBE = 1,
	LineStyleTextureSlot_mapping_TUBE = 2,
	LineStyleTextureSlot_mapping_SPHERE = 3,
};

int LineStyleTextureSlot_mapping_get(PointerRNA *ptr);
void LineStyleTextureSlot_mapping_set(PointerRNA *ptr, int value);

enum {
	LineStyleTextureSlot_texture_coords_WINDOW = 1024,
	LineStyleTextureSlot_texture_coords_GLOBAL = 8,
	LineStyleTextureSlot_texture_coords_ALONG_STROKE = 16,
	LineStyleTextureSlot_texture_coords_ORCO = 1,
};

int LineStyleTextureSlot_texture_coords_get(PointerRNA *ptr);
void LineStyleTextureSlot_texture_coords_set(PointerRNA *ptr, int value);

int LineStyleTextureSlot_use_tips_get(PointerRNA *ptr);
void LineStyleTextureSlot_use_tips_set(PointerRNA *ptr, int value);

enum {
	LineStyleTextureSlot_mapping_x_NONE = 0,
	LineStyleTextureSlot_mapping_x_X = 1,
	LineStyleTextureSlot_mapping_x_Y = 2,
	LineStyleTextureSlot_mapping_x_Z = 3,
};

int LineStyleTextureSlot_mapping_x_get(PointerRNA *ptr);
void LineStyleTextureSlot_mapping_x_set(PointerRNA *ptr, int value);

enum {
	LineStyleTextureSlot_mapping_y_NONE = 0,
	LineStyleTextureSlot_mapping_y_X = 1,
	LineStyleTextureSlot_mapping_y_Y = 2,
	LineStyleTextureSlot_mapping_y_Z = 3,
};

int LineStyleTextureSlot_mapping_y_get(PointerRNA *ptr);
void LineStyleTextureSlot_mapping_y_set(PointerRNA *ptr, int value);

enum {
	LineStyleTextureSlot_mapping_z_NONE = 0,
	LineStyleTextureSlot_mapping_z_X = 1,
	LineStyleTextureSlot_mapping_z_Y = 2,
	LineStyleTextureSlot_mapping_z_Z = 3,
};

int LineStyleTextureSlot_mapping_z_get(PointerRNA *ptr);
void LineStyleTextureSlot_mapping_z_set(PointerRNA *ptr, int value);

/**************** Texture Slots ****************/

extern StructRNA RNA_LineStyleTextureSlots;

PointerRNA LineStyleTextureSlots_rna_type_get(PointerRNA *ptr);

struct MTex *LineStyleTextureSlots_add(struct ID *_selfid, bContext *C, ReportList *reports);
struct MTex *LineStyleTextureSlots_create(struct ID *_selfid, bContext *C, ReportList *reports, int index);
void LineStyleTextureSlots_clear(struct ID *_selfid, bContext *C, ReportList *reports, int index);
/**************** Line Style Thickness Modifier ****************/

extern StructRNA RNA_LineStyleThicknessModifier;
extern StructRNA RNA_LineStyleModifier;

/**************** Along Stroke ****************/

extern StructRNA RNA_LineStyleThicknessModifier_AlongStroke;
extern StructRNA RNA_LineStyleThicknessModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleThicknessModifier_AlongStroke_name_MAX 64

void LineStyleThicknessModifier_AlongStroke_name_get(PointerRNA *ptr, char *value);
int LineStyleThicknessModifier_AlongStroke_name_length(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleThicknessModifier_AlongStroke_blend_MIX = 0,
	LineStyleThicknessModifier_AlongStroke_blend_ADD = 1,
	LineStyleThicknessModifier_AlongStroke_blend_SUBTRACT = 3,
	LineStyleThicknessModifier_AlongStroke_blend_MULTIPLY = 2,
	LineStyleThicknessModifier_AlongStroke_blend_DIVIDE = 4,
	LineStyleThicknessModifier_AlongStroke_blend_DIFFERENCE = 5,
	LineStyleThicknessModifier_AlongStroke_blend_MININUM = 6,
	LineStyleThicknessModifier_AlongStroke_blend_MAXIMUM = 7,
};

int LineStyleThicknessModifier_AlongStroke_blend_get(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleThicknessModifier_AlongStroke_curve_get(PointerRNA *ptr);

int LineStyleThicknessModifier_AlongStroke_expanded_get(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_expanded_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_AlongStroke_influence_get(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_influence_set(PointerRNA *ptr, float value);

int LineStyleThicknessModifier_AlongStroke_invert_get(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_invert_set(PointerRNA *ptr, int value);

enum {
	LineStyleThicknessModifier_AlongStroke_mapping_LINEAR = 0,
	LineStyleThicknessModifier_AlongStroke_mapping_CURVE = 1,
};

int LineStyleThicknessModifier_AlongStroke_mapping_get(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_mapping_set(PointerRNA *ptr, int value);

enum {
	LineStyleThicknessModifier_AlongStroke_type_ALONG_STROKE = 1,
	LineStyleThicknessModifier_AlongStroke_type_CALLIGRAPHY = 13,
	LineStyleThicknessModifier_AlongStroke_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleThicknessModifier_AlongStroke_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleThicknessModifier_AlongStroke_type_MATERIAL = 4,
};

int LineStyleThicknessModifier_AlongStroke_type_get(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_type_set(PointerRNA *ptr, int value);

int LineStyleThicknessModifier_AlongStroke_use_get(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_use_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_AlongStroke_value_max_get(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_value_max_set(PointerRNA *ptr, float value);

float LineStyleThicknessModifier_AlongStroke_value_min_get(PointerRNA *ptr);
void LineStyleThicknessModifier_AlongStroke_value_min_set(PointerRNA *ptr, float value);

/**************** Calligraphy ****************/

extern StructRNA RNA_LineStyleThicknessModifier_Calligraphy;
extern StructRNA RNA_LineStyleThicknessModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleThicknessModifier_Calligraphy_name_MAX 64

void LineStyleThicknessModifier_Calligraphy_name_get(PointerRNA *ptr, char *value);
int LineStyleThicknessModifier_Calligraphy_name_length(PointerRNA *ptr);
void LineStyleThicknessModifier_Calligraphy_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleThicknessModifier_Calligraphy_blend_MIX = 0,
	LineStyleThicknessModifier_Calligraphy_blend_ADD = 1,
	LineStyleThicknessModifier_Calligraphy_blend_SUBTRACT = 3,
	LineStyleThicknessModifier_Calligraphy_blend_MULTIPLY = 2,
	LineStyleThicknessModifier_Calligraphy_blend_DIVIDE = 4,
	LineStyleThicknessModifier_Calligraphy_blend_DIFFERENCE = 5,
	LineStyleThicknessModifier_Calligraphy_blend_MININUM = 6,
	LineStyleThicknessModifier_Calligraphy_blend_MAXIMUM = 7,
};

int LineStyleThicknessModifier_Calligraphy_blend_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Calligraphy_blend_set(PointerRNA *ptr, int value);

int LineStyleThicknessModifier_Calligraphy_expanded_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Calligraphy_expanded_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_Calligraphy_influence_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Calligraphy_influence_set(PointerRNA *ptr, float value);

float LineStyleThicknessModifier_Calligraphy_thickness_max_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Calligraphy_thickness_max_set(PointerRNA *ptr, float value);

float LineStyleThicknessModifier_Calligraphy_thickness_min_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Calligraphy_thickness_min_set(PointerRNA *ptr, float value);

enum {
	LineStyleThicknessModifier_Calligraphy_type_ALONG_STROKE = 1,
	LineStyleThicknessModifier_Calligraphy_type_CALLIGRAPHY = 13,
	LineStyleThicknessModifier_Calligraphy_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleThicknessModifier_Calligraphy_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleThicknessModifier_Calligraphy_type_MATERIAL = 4,
};

int LineStyleThicknessModifier_Calligraphy_type_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Calligraphy_type_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_Calligraphy_orientation_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Calligraphy_orientation_set(PointerRNA *ptr, float value);

int LineStyleThicknessModifier_Calligraphy_use_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Calligraphy_use_set(PointerRNA *ptr, int value);

/**************** Distance from Camera ****************/

extern StructRNA RNA_LineStyleThicknessModifier_DistanceFromCamera;
extern StructRNA RNA_LineStyleThicknessModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleThicknessModifier_DistanceFromCamera_name_MAX 64

void LineStyleThicknessModifier_DistanceFromCamera_name_get(PointerRNA *ptr, char *value);
int LineStyleThicknessModifier_DistanceFromCamera_name_length(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleThicknessModifier_DistanceFromCamera_blend_MIX = 0,
	LineStyleThicknessModifier_DistanceFromCamera_blend_ADD = 1,
	LineStyleThicknessModifier_DistanceFromCamera_blend_SUBTRACT = 3,
	LineStyleThicknessModifier_DistanceFromCamera_blend_MULTIPLY = 2,
	LineStyleThicknessModifier_DistanceFromCamera_blend_DIVIDE = 4,
	LineStyleThicknessModifier_DistanceFromCamera_blend_DIFFERENCE = 5,
	LineStyleThicknessModifier_DistanceFromCamera_blend_MININUM = 6,
	LineStyleThicknessModifier_DistanceFromCamera_blend_MAXIMUM = 7,
};

int LineStyleThicknessModifier_DistanceFromCamera_blend_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleThicknessModifier_DistanceFromCamera_curve_get(PointerRNA *ptr);

int LineStyleThicknessModifier_DistanceFromCamera_expanded_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_expanded_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_DistanceFromCamera_influence_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_influence_set(PointerRNA *ptr, float value);

int LineStyleThicknessModifier_DistanceFromCamera_invert_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_invert_set(PointerRNA *ptr, int value);

enum {
	LineStyleThicknessModifier_DistanceFromCamera_mapping_LINEAR = 0,
	LineStyleThicknessModifier_DistanceFromCamera_mapping_CURVE = 1,
};

int LineStyleThicknessModifier_DistanceFromCamera_mapping_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_mapping_set(PointerRNA *ptr, int value);

enum {
	LineStyleThicknessModifier_DistanceFromCamera_type_ALONG_STROKE = 1,
	LineStyleThicknessModifier_DistanceFromCamera_type_CALLIGRAPHY = 13,
	LineStyleThicknessModifier_DistanceFromCamera_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleThicknessModifier_DistanceFromCamera_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleThicknessModifier_DistanceFromCamera_type_MATERIAL = 4,
};

int LineStyleThicknessModifier_DistanceFromCamera_type_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_type_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_DistanceFromCamera_range_max_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_range_max_set(PointerRNA *ptr, float value);

float LineStyleThicknessModifier_DistanceFromCamera_range_min_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_range_min_set(PointerRNA *ptr, float value);

int LineStyleThicknessModifier_DistanceFromCamera_use_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_use_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_DistanceFromCamera_value_max_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_value_max_set(PointerRNA *ptr, float value);

float LineStyleThicknessModifier_DistanceFromCamera_value_min_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromCamera_value_min_set(PointerRNA *ptr, float value);

/**************** Distance from Object ****************/

extern StructRNA RNA_LineStyleThicknessModifier_DistanceFromObject;
extern StructRNA RNA_LineStyleThicknessModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleThicknessModifier_DistanceFromObject_name_MAX 64

void LineStyleThicknessModifier_DistanceFromObject_name_get(PointerRNA *ptr, char *value);
int LineStyleThicknessModifier_DistanceFromObject_name_length(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleThicknessModifier_DistanceFromObject_blend_MIX = 0,
	LineStyleThicknessModifier_DistanceFromObject_blend_ADD = 1,
	LineStyleThicknessModifier_DistanceFromObject_blend_SUBTRACT = 3,
	LineStyleThicknessModifier_DistanceFromObject_blend_MULTIPLY = 2,
	LineStyleThicknessModifier_DistanceFromObject_blend_DIVIDE = 4,
	LineStyleThicknessModifier_DistanceFromObject_blend_DIFFERENCE = 5,
	LineStyleThicknessModifier_DistanceFromObject_blend_MININUM = 6,
	LineStyleThicknessModifier_DistanceFromObject_blend_MAXIMUM = 7,
};

int LineStyleThicknessModifier_DistanceFromObject_blend_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleThicknessModifier_DistanceFromObject_curve_get(PointerRNA *ptr);

int LineStyleThicknessModifier_DistanceFromObject_expanded_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_expanded_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_DistanceFromObject_influence_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_influence_set(PointerRNA *ptr, float value);

int LineStyleThicknessModifier_DistanceFromObject_invert_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_invert_set(PointerRNA *ptr, int value);

enum {
	LineStyleThicknessModifier_DistanceFromObject_mapping_LINEAR = 0,
	LineStyleThicknessModifier_DistanceFromObject_mapping_CURVE = 1,
};

int LineStyleThicknessModifier_DistanceFromObject_mapping_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_mapping_set(PointerRNA *ptr, int value);

enum {
	LineStyleThicknessModifier_DistanceFromObject_type_ALONG_STROKE = 1,
	LineStyleThicknessModifier_DistanceFromObject_type_CALLIGRAPHY = 13,
	LineStyleThicknessModifier_DistanceFromObject_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleThicknessModifier_DistanceFromObject_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleThicknessModifier_DistanceFromObject_type_MATERIAL = 4,
};

int LineStyleThicknessModifier_DistanceFromObject_type_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_type_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_DistanceFromObject_range_max_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_range_max_set(PointerRNA *ptr, float value);

float LineStyleThicknessModifier_DistanceFromObject_range_min_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_range_min_set(PointerRNA *ptr, float value);

PointerRNA LineStyleThicknessModifier_DistanceFromObject_target_get(PointerRNA *ptr);

int LineStyleThicknessModifier_DistanceFromObject_use_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_use_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_DistanceFromObject_value_max_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_value_max_set(PointerRNA *ptr, float value);

float LineStyleThicknessModifier_DistanceFromObject_value_min_get(PointerRNA *ptr);
void LineStyleThicknessModifier_DistanceFromObject_value_min_set(PointerRNA *ptr, float value);

/**************** Material ****************/

extern StructRNA RNA_LineStyleThicknessModifier_Material;
extern StructRNA RNA_LineStyleThicknessModifier;
extern StructRNA RNA_LineStyleModifier;

#define LineStyleThicknessModifier_Material_name_MAX 64

void LineStyleThicknessModifier_Material_name_get(PointerRNA *ptr, char *value);
int LineStyleThicknessModifier_Material_name_length(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_name_set(PointerRNA *ptr, const char *value);

enum {
	LineStyleThicknessModifier_Material_blend_MIX = 0,
	LineStyleThicknessModifier_Material_blend_ADD = 1,
	LineStyleThicknessModifier_Material_blend_SUBTRACT = 3,
	LineStyleThicknessModifier_Material_blend_MULTIPLY = 2,
	LineStyleThicknessModifier_Material_blend_DIVIDE = 4,
	LineStyleThicknessModifier_Material_blend_DIFFERENCE = 5,
	LineStyleThicknessModifier_Material_blend_MININUM = 6,
	LineStyleThicknessModifier_Material_blend_MAXIMUM = 7,
};

int LineStyleThicknessModifier_Material_blend_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_blend_set(PointerRNA *ptr, int value);

PointerRNA LineStyleThicknessModifier_Material_curve_get(PointerRNA *ptr);

int LineStyleThicknessModifier_Material_expanded_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_expanded_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_Material_influence_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_influence_set(PointerRNA *ptr, float value);

int LineStyleThicknessModifier_Material_invert_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_invert_set(PointerRNA *ptr, int value);

enum {
	LineStyleThicknessModifier_Material_mapping_LINEAR = 0,
	LineStyleThicknessModifier_Material_mapping_CURVE = 1,
};

int LineStyleThicknessModifier_Material_mapping_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_mapping_set(PointerRNA *ptr, int value);

enum {
	LineStyleThicknessModifier_Material_material_attribute_LINE = 11,
	LineStyleThicknessModifier_Material_material_attribute_LINE_R = 12,
	LineStyleThicknessModifier_Material_material_attribute_LINE_G = 13,
	LineStyleThicknessModifier_Material_material_attribute_LINE_B = 14,
	LineStyleThicknessModifier_Material_material_attribute_LINE_A = 15,
	LineStyleThicknessModifier_Material_material_attribute_DIFF = 1,
	LineStyleThicknessModifier_Material_material_attribute_DIFF_R = 2,
	LineStyleThicknessModifier_Material_material_attribute_DIFF_G = 3,
	LineStyleThicknessModifier_Material_material_attribute_DIFF_B = 4,
	LineStyleThicknessModifier_Material_material_attribute_SPEC = 5,
	LineStyleThicknessModifier_Material_material_attribute_SPEC_R = 6,
	LineStyleThicknessModifier_Material_material_attribute_SPEC_G = 7,
	LineStyleThicknessModifier_Material_material_attribute_SPEC_B = 8,
	LineStyleThicknessModifier_Material_material_attribute_SPEC_HARD = 9,
	LineStyleThicknessModifier_Material_material_attribute_ALPHA = 10,
};

int LineStyleThicknessModifier_Material_material_attribute_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_material_attribute_set(PointerRNA *ptr, int value);

enum {
	LineStyleThicknessModifier_Material_type_ALONG_STROKE = 1,
	LineStyleThicknessModifier_Material_type_CALLIGRAPHY = 13,
	LineStyleThicknessModifier_Material_type_DISTANCE_FROM_CAMERA = 2,
	LineStyleThicknessModifier_Material_type_DISTANCE_FROM_OBJECT = 3,
	LineStyleThicknessModifier_Material_type_MATERIAL = 4,
};

int LineStyleThicknessModifier_Material_type_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_type_set(PointerRNA *ptr, int value);

int LineStyleThicknessModifier_Material_use_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_use_set(PointerRNA *ptr, int value);

float LineStyleThicknessModifier_Material_value_max_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_value_max_set(PointerRNA *ptr, float value);

float LineStyleThicknessModifier_Material_value_min_get(PointerRNA *ptr);
void LineStyleThicknessModifier_Material_value_min_set(PointerRNA *ptr, float value);

/**************** Thickness Modifiers ****************/

extern StructRNA RNA_LineStyleThicknessModifiers;

PointerRNA LineStyleThicknessModifiers_rna_type_get(PointerRNA *ptr);

struct LineStyleModifier *LineStyleThicknessModifiers_new(struct FreestyleLineStyle *_self, ReportList *reports, const char * name, int type);
void LineStyleThicknessModifiers_remove(struct FreestyleLineStyle *_self, ReportList *reports, struct PointerRNA *modifier);
/**************** Line Sets ****************/

extern StructRNA RNA_Linesets;

PointerRNA Linesets_rna_type_get(PointerRNA *ptr);

PointerRNA Linesets_active_get(PointerRNA *ptr);

int Linesets_active_index_get(PointerRNA *ptr);
void Linesets_active_index_set(PointerRNA *ptr, int value);

struct FreestyleLineSet *Linesets_new(struct ID *_selfid, struct FreestyleSettings *_self, const char * name);
void Linesets_remove(struct ID *_selfid, struct FreestyleSettings *_self, ReportList *reports, struct PointerRNA *lineset);
/**************** Locked Track Constraint ****************/

extern StructRNA RNA_LockedTrackConstraint;
extern StructRNA RNA_Constraint;

float LockedTrackConstraint_head_tail_get(PointerRNA *ptr);
void LockedTrackConstraint_head_tail_set(PointerRNA *ptr, float value);

enum {
	LockedTrackConstraint_lock_axis_LOCK_X = 0,
	LockedTrackConstraint_lock_axis_LOCK_Y = 1,
	LockedTrackConstraint_lock_axis_LOCK_Z = 2,
};

int LockedTrackConstraint_lock_axis_get(PointerRNA *ptr);
void LockedTrackConstraint_lock_axis_set(PointerRNA *ptr, int value);

#define LockedTrackConstraint_subtarget_MAX 64

void LockedTrackConstraint_subtarget_get(PointerRNA *ptr, char *value);
int LockedTrackConstraint_subtarget_length(PointerRNA *ptr);
void LockedTrackConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA LockedTrackConstraint_target_get(PointerRNA *ptr);

enum {
	LockedTrackConstraint_track_axis_TRACK_X = 0,
	LockedTrackConstraint_track_axis_TRACK_Y = 1,
	LockedTrackConstraint_track_axis_TRACK_Z = 2,
	LockedTrackConstraint_track_axis_TRACK_NEGATIVE_X = 3,
	LockedTrackConstraint_track_axis_TRACK_NEGATIVE_Y = 4,
	LockedTrackConstraint_track_axis_TRACK_NEGATIVE_Z = 5,
};

int LockedTrackConstraint_track_axis_get(PointerRNA *ptr);
void LockedTrackConstraint_track_axis_set(PointerRNA *ptr, int value);

/**************** LodLevel ****************/

extern StructRNA RNA_LodLevel;

PointerRNA LodLevel_rna_type_get(PointerRNA *ptr);

float LodLevel_distance_get(PointerRNA *ptr);
void LodLevel_distance_set(PointerRNA *ptr, float value);

PointerRNA LodLevel_object_get(PointerRNA *ptr);

int LodLevel_use_material_get(PointerRNA *ptr);
void LodLevel_use_material_set(PointerRNA *ptr, int value);

int LodLevel_use_mesh_get(PointerRNA *ptr);
void LodLevel_use_mesh_set(PointerRNA *ptr, int value);

/**************** Loop Colors ****************/

extern StructRNA RNA_LoopColors;

PointerRNA LoopColors_rna_type_get(PointerRNA *ptr);

int LoopColors_active_index_get(PointerRNA *ptr);
void LoopColors_active_index_set(PointerRNA *ptr, int value);

PointerRNA LoopColors_active_get(PointerRNA *ptr);

struct PointerRNA LoopColors_new(struct Mesh *_self, const char * name);
void LoopColors_remove(struct Mesh *_self, ReportList *reports, struct CustomDataLayer *layer);
/**************** Macro Operator ****************/

extern StructRNA RNA_Macro;

PointerRNA Macro_rna_type_get(PointerRNA *ptr);

void Macro_name_get(PointerRNA *ptr, char *value);
int Macro_name_length(PointerRNA *ptr);
void Macro_name_set(PointerRNA *ptr, const char *value);

enum {
	Macro_bl_options_REGISTER = 1,
	Macro_bl_options_UNDO = 2,
	Macro_bl_options_BLOCKING = 4,
	Macro_bl_options_MACRO = 8,
	Macro_bl_options_GRAB_POINTER = 16,
	Macro_bl_options_PRESET = 32,
	Macro_bl_options_INTERNAL = 64,
};

int Macro_bl_options_get(PointerRNA *ptr);
void Macro_bl_options_set(PointerRNA *ptr, int value);

PointerRNA Macro_properties_get(PointerRNA *ptr);

#define Macro_bl_description_MAX 240

void Macro_bl_description_get(PointerRNA *ptr, char *value);
int Macro_bl_description_length(PointerRNA *ptr);
void Macro_bl_description_set(PointerRNA *ptr, const char *value);

#define Macro_bl_idname_MAX 64

void Macro_bl_idname_get(PointerRNA *ptr, char *value);
int Macro_bl_idname_length(PointerRNA *ptr);
void Macro_bl_idname_set(PointerRNA *ptr, const char *value);

#define Macro_bl_label_MAX 240

void Macro_bl_label_get(PointerRNA *ptr, char *value);
int Macro_bl_label_length(PointerRNA *ptr);
void Macro_bl_label_set(PointerRNA *ptr, const char *value);

#define Macro_bl_translation_context_MAX 240

void Macro_bl_translation_context_get(PointerRNA *ptr, char *value);
int Macro_bl_translation_context_length(PointerRNA *ptr);
void Macro_bl_translation_context_set(PointerRNA *ptr, const char *value);

void Macro_report(struct wmOperator *_self, int type, const char * message);
int Macro_poll(struct bContext *context);
void Macro_draw(struct wmOperator *_self, struct bContext *context);
/**************** Magic Texture ****************/

extern StructRNA RNA_MagicTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

int MagicTexture_noise_depth_get(PointerRNA *ptr);
void MagicTexture_noise_depth_set(PointerRNA *ptr, int value);

float MagicTexture_turbulence_get(PointerRNA *ptr);
void MagicTexture_turbulence_set(PointerRNA *ptr, float value);

/**************** Maintain Volume Constraint ****************/

extern StructRNA RNA_MaintainVolumeConstraint;
extern StructRNA RNA_Constraint;

enum {
	MaintainVolumeConstraint_free_axis_SAMEVOL_X = 0,
	MaintainVolumeConstraint_free_axis_SAMEVOL_Y = 1,
	MaintainVolumeConstraint_free_axis_SAMEVOL_Z = 2,
};

int MaintainVolumeConstraint_free_axis_get(PointerRNA *ptr);
void MaintainVolumeConstraint_free_axis_set(PointerRNA *ptr, int value);

float MaintainVolumeConstraint_volume_get(PointerRNA *ptr);
void MaintainVolumeConstraint_volume_set(PointerRNA *ptr, float value);

/**************** Marble Texture ****************/

extern StructRNA RNA_MarbleTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

float MarbleTexture_nabla_get(PointerRNA *ptr);
void MarbleTexture_nabla_set(PointerRNA *ptr, float value);

enum {
	MarbleTexture_noise_basis_BLENDER_ORIGINAL = 0,
	MarbleTexture_noise_basis_ORIGINAL_PERLIN = 1,
	MarbleTexture_noise_basis_IMPROVED_PERLIN = 2,
	MarbleTexture_noise_basis_VORONOI_F1 = 3,
	MarbleTexture_noise_basis_VORONOI_F2 = 4,
	MarbleTexture_noise_basis_VORONOI_F3 = 5,
	MarbleTexture_noise_basis_VORONOI_F4 = 6,
	MarbleTexture_noise_basis_VORONOI_F2_F1 = 7,
	MarbleTexture_noise_basis_VORONOI_CRACKLE = 8,
	MarbleTexture_noise_basis_CELL_NOISE = 14,
};

int MarbleTexture_noise_basis_get(PointerRNA *ptr);
void MarbleTexture_noise_basis_set(PointerRNA *ptr, int value);

enum {
	MarbleTexture_noise_basis_2_SIN = 0,
	MarbleTexture_noise_basis_2_SAW = 1,
	MarbleTexture_noise_basis_2_TRI = 2,
};

int MarbleTexture_noise_basis_2_get(PointerRNA *ptr);
void MarbleTexture_noise_basis_2_set(PointerRNA *ptr, int value);

int MarbleTexture_noise_depth_get(PointerRNA *ptr);
void MarbleTexture_noise_depth_set(PointerRNA *ptr, int value);

float MarbleTexture_noise_scale_get(PointerRNA *ptr);
void MarbleTexture_noise_scale_set(PointerRNA *ptr, float value);

enum {
	MarbleTexture_noise_type_SOFT_NOISE = 0,
	MarbleTexture_noise_type_HARD_NOISE = 1,
};

int MarbleTexture_noise_type_get(PointerRNA *ptr);
void MarbleTexture_noise_type_set(PointerRNA *ptr, int value);

enum {
	MarbleTexture_marble_type_SOFT = 0,
	MarbleTexture_marble_type_SHARP = 1,
	MarbleTexture_marble_type_SHARPER = 2,
};

int MarbleTexture_marble_type_get(PointerRNA *ptr);
void MarbleTexture_marble_type_set(PointerRNA *ptr, int value);

float MarbleTexture_turbulence_get(PointerRNA *ptr);
void MarbleTexture_turbulence_set(PointerRNA *ptr, float value);

/**************** Mask ****************/

extern StructRNA RNA_Mask;
extern StructRNA RNA_ID;

int Mask_active_layer_index_get(PointerRNA *ptr);
void Mask_active_layer_index_set(PointerRNA *ptr, int value);

PointerRNA Mask_animation_data_get(PointerRNA *ptr);

int Mask_frame_end_get(PointerRNA *ptr);
void Mask_frame_end_set(PointerRNA *ptr, int value);

void Mask_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mask_layers_next(CollectionPropertyIterator *iter);
void Mask_layers_end(CollectionPropertyIterator *iter);

int Mask_frame_start_get(PointerRNA *ptr);
void Mask_frame_start_set(PointerRNA *ptr, int value);

/**************** Mask Layer ****************/

extern StructRNA RNA_MaskLayer;

PointerRNA MaskLayer_rna_type_get(PointerRNA *ptr);

#define MaskLayer_name_MAX 64

void MaskLayer_name_get(PointerRNA *ptr, char *value);
int MaskLayer_name_length(PointerRNA *ptr);
void MaskLayer_name_set(PointerRNA *ptr, const char *value);

enum {
	MaskLayer_blend_MERGE_ADD = 7,
	MaskLayer_blend_MERGE_SUBTRACT = 8,
	MaskLayer_blend_ADD = 0,
	MaskLayer_blend_SUBTRACT = 1,
	MaskLayer_blend_LIGHTEN = 2,
	MaskLayer_blend_DARKEN = 3,
	MaskLayer_blend_MUL = 4,
	MaskLayer_blend_REPLACE = 5,
	MaskLayer_blend_DIFFERENCE = 6,
};

int MaskLayer_blend_get(PointerRNA *ptr);
void MaskLayer_blend_set(PointerRNA *ptr, int value);

int MaskLayer_use_fill_holes_get(PointerRNA *ptr);
void MaskLayer_use_fill_holes_set(PointerRNA *ptr, int value);

int MaskLayer_use_fill_overlap_get(PointerRNA *ptr);
void MaskLayer_use_fill_overlap_set(PointerRNA *ptr, int value);

enum {
	MaskLayer_falloff_SMOOTH = 0,
	MaskLayer_falloff_SPHERE = 1,
	MaskLayer_falloff_ROOT = 2,
	MaskLayer_falloff_SHARP = 3,
	MaskLayer_falloff_LINEAR = 4,
};

int MaskLayer_falloff_get(PointerRNA *ptr);
void MaskLayer_falloff_set(PointerRNA *ptr, int value);

float MaskLayer_alpha_get(PointerRNA *ptr);
void MaskLayer_alpha_set(PointerRNA *ptr, float value);

int MaskLayer_hide_render_get(PointerRNA *ptr);
void MaskLayer_hide_render_set(PointerRNA *ptr, int value);

int MaskLayer_hide_select_get(PointerRNA *ptr);
void MaskLayer_hide_select_set(PointerRNA *ptr, int value);

int MaskLayer_hide_get(PointerRNA *ptr);
void MaskLayer_hide_set(PointerRNA *ptr, int value);

int MaskLayer_invert_get(PointerRNA *ptr);
void MaskLayer_invert_set(PointerRNA *ptr, int value);

int MaskLayer_select_get(PointerRNA *ptr);
void MaskLayer_select_set(PointerRNA *ptr, int value);

void MaskLayer_splines_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MaskLayer_splines_next(CollectionPropertyIterator *iter);
void MaskLayer_splines_end(CollectionPropertyIterator *iter);
int MaskLayer_splines_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Mask Layers ****************/

extern StructRNA RNA_MaskLayers;

PointerRNA MaskLayers_rna_type_get(PointerRNA *ptr);

PointerRNA MaskLayers_active_get(PointerRNA *ptr);

struct MaskLayer *MaskLayers_new(struct Mask *_self, const char * name);
void MaskLayers_remove(struct Mask *_self, ReportList *reports, struct PointerRNA *layer);
void MaskLayers_clear(struct Mask *_self);
/**************** Mask Modifier ****************/

extern StructRNA RNA_MaskModifier;
extern StructRNA RNA_Modifier;

PointerRNA MaskModifier_armature_get(PointerRNA *ptr);

int MaskModifier_invert_vertex_group_get(PointerRNA *ptr);
void MaskModifier_invert_vertex_group_set(PointerRNA *ptr, int value);

enum {
	MaskModifier_mode_VERTEX_GROUP = 0,
	MaskModifier_mode_ARMATURE = 1,
};

int MaskModifier_mode_get(PointerRNA *ptr);
void MaskModifier_mode_set(PointerRNA *ptr, int value);

#define MaskModifier_vertex_group_MAX 64

void MaskModifier_vertex_group_get(PointerRNA *ptr, char *value);
int MaskModifier_vertex_group_length(PointerRNA *ptr);
void MaskModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Mask Parent ****************/

extern StructRNA RNA_MaskParent;

PointerRNA MaskParent_rna_type_get(PointerRNA *ptr);

PointerRNA MaskParent_id_get(PointerRNA *ptr);

enum {
	MaskParent_id_type_MOVIECLIP = 17229,
};

int MaskParent_id_type_get(PointerRNA *ptr);
void MaskParent_id_type_set(PointerRNA *ptr, int value);

#define MaskParent_parent_MAX 64

void MaskParent_parent_get(PointerRNA *ptr, char *value);
int MaskParent_parent_length(PointerRNA *ptr);
void MaskParent_parent_set(PointerRNA *ptr, const char *value);

enum {
	MaskParent_type_POINT_TRACK = 0,
	MaskParent_type_PLANE_TRACK = 1,
};

int MaskParent_type_get(PointerRNA *ptr);
void MaskParent_type_set(PointerRNA *ptr, int value);

#define MaskParent_sub_parent_MAX 64

void MaskParent_sub_parent_get(PointerRNA *ptr, char *value);
int MaskParent_sub_parent_length(PointerRNA *ptr);
void MaskParent_sub_parent_set(PointerRNA *ptr, const char *value);

/**************** Mask Sequence ****************/

extern StructRNA RNA_MaskSequence;
extern StructRNA RNA_Sequence;

enum {
	MaskSequence_alpha_mode_STRAIGHT = 0,
	MaskSequence_alpha_mode_PREMUL = 1,
};

int MaskSequence_alpha_mode_get(PointerRNA *ptr);
void MaskSequence_alpha_mode_set(PointerRNA *ptr, int value);

int MaskSequence_animation_offset_end_get(PointerRNA *ptr);
void MaskSequence_animation_offset_end_set(PointerRNA *ptr, int value);

int MaskSequence_animation_offset_start_get(PointerRNA *ptr);
void MaskSequence_animation_offset_start_set(PointerRNA *ptr, int value);

int MaskSequence_use_float_get(PointerRNA *ptr);
void MaskSequence_use_float_set(PointerRNA *ptr, int value);

PointerRNA MaskSequence_crop_get(PointerRNA *ptr);

int MaskSequence_use_deinterlace_get(PointerRNA *ptr);
void MaskSequence_use_deinterlace_set(PointerRNA *ptr, int value);

int MaskSequence_use_reverse_frames_get(PointerRNA *ptr);
void MaskSequence_use_reverse_frames_set(PointerRNA *ptr, int value);

int MaskSequence_use_flip_x_get(PointerRNA *ptr);
void MaskSequence_use_flip_x_set(PointerRNA *ptr, int value);

int MaskSequence_use_flip_y_get(PointerRNA *ptr);
void MaskSequence_use_flip_y_set(PointerRNA *ptr, int value);

PointerRNA MaskSequence_mask_get(PointerRNA *ptr);

float MaskSequence_color_multiply_get(PointerRNA *ptr);
void MaskSequence_color_multiply_set(PointerRNA *ptr, float value);

float MaskSequence_color_saturation_get(PointerRNA *ptr);
void MaskSequence_color_saturation_set(PointerRNA *ptr, float value);

float MaskSequence_strobe_get(PointerRNA *ptr);
void MaskSequence_strobe_set(PointerRNA *ptr, float value);

PointerRNA MaskSequence_transform_get(PointerRNA *ptr);

int MaskSequence_use_crop_get(PointerRNA *ptr);
void MaskSequence_use_crop_set(PointerRNA *ptr, int value);

int MaskSequence_use_translation_get(PointerRNA *ptr);
void MaskSequence_use_translation_set(PointerRNA *ptr, int value);

/**************** Mask spline ****************/

extern StructRNA RNA_MaskSpline;

PointerRNA MaskSpline_rna_type_get(PointerRNA *ptr);

int MaskSpline_use_cyclic_get(PointerRNA *ptr);
void MaskSpline_use_cyclic_set(PointerRNA *ptr, int value);

enum {
	MaskSpline_offset_mode_EVEN = 0,
	MaskSpline_offset_mode_SMOOTH = 1,
};

int MaskSpline_offset_mode_get(PointerRNA *ptr);
void MaskSpline_offset_mode_set(PointerRNA *ptr, int value);

int MaskSpline_use_fill_get(PointerRNA *ptr);
void MaskSpline_use_fill_set(PointerRNA *ptr, int value);

void MaskSpline_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MaskSpline_points_next(CollectionPropertyIterator *iter);
void MaskSpline_points_end(CollectionPropertyIterator *iter);
int MaskSpline_points_length(PointerRNA *ptr);
int MaskSpline_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int MaskSpline_use_self_intersection_check_get(PointerRNA *ptr);
void MaskSpline_use_self_intersection_check_set(PointerRNA *ptr, int value);

enum {
	MaskSpline_weight_interpolation_LINEAR = 1,
	MaskSpline_weight_interpolation_EASE = 2,
};

int MaskSpline_weight_interpolation_get(PointerRNA *ptr);
void MaskSpline_weight_interpolation_set(PointerRNA *ptr, int value);

/**************** Mask Spline Point ****************/

extern StructRNA RNA_MaskSplinePoint;

PointerRNA MaskSplinePoint_rna_type_get(PointerRNA *ptr);

void MaskSplinePoint_co_get(PointerRNA *ptr, float values[2]);
void MaskSplinePoint_co_set(PointerRNA *ptr, const float values[2]);

void MaskSplinePoint_feather_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MaskSplinePoint_feather_points_next(CollectionPropertyIterator *iter);
void MaskSplinePoint_feather_points_end(CollectionPropertyIterator *iter);
int MaskSplinePoint_feather_points_length(PointerRNA *ptr);
int MaskSplinePoint_feather_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void MaskSplinePoint_handle_left_get(PointerRNA *ptr, float values[2]);
void MaskSplinePoint_handle_left_set(PointerRNA *ptr, const float values[2]);

enum {
	MaskSplinePoint_handle_left_type_AUTO = 1,
	MaskSplinePoint_handle_left_type_VECTOR = 2,
	MaskSplinePoint_handle_left_type_ALIGNED = 3,
	MaskSplinePoint_handle_left_type_ALIGNED_DOUBLESIDE = 5,
	MaskSplinePoint_handle_left_type_FREE = 0,
};

int MaskSplinePoint_handle_left_type_get(PointerRNA *ptr);
void MaskSplinePoint_handle_left_type_set(PointerRNA *ptr, int value);

void MaskSplinePoint_handle_right_get(PointerRNA *ptr, float values[2]);
void MaskSplinePoint_handle_right_set(PointerRNA *ptr, const float values[2]);

enum {
	MaskSplinePoint_handle_right_type_AUTO = 1,
	MaskSplinePoint_handle_right_type_VECTOR = 2,
	MaskSplinePoint_handle_right_type_ALIGNED = 3,
	MaskSplinePoint_handle_right_type_ALIGNED_DOUBLESIDE = 5,
	MaskSplinePoint_handle_right_type_FREE = 0,
};

int MaskSplinePoint_handle_right_type_get(PointerRNA *ptr);
void MaskSplinePoint_handle_right_type_set(PointerRNA *ptr, int value);

enum {
	MaskSplinePoint_handle_type_AUTO = 1,
	MaskSplinePoint_handle_type_VECTOR = 2,
	MaskSplinePoint_handle_type_ALIGNED = 3,
	MaskSplinePoint_handle_type_ALIGNED_DOUBLESIDE = 5,
	MaskSplinePoint_handle_type_FREE = 0,
};

int MaskSplinePoint_handle_type_get(PointerRNA *ptr);
void MaskSplinePoint_handle_type_set(PointerRNA *ptr, int value);

int MaskSplinePoint_select_get(PointerRNA *ptr);
void MaskSplinePoint_select_set(PointerRNA *ptr, int value);

float MaskSplinePoint_weight_get(PointerRNA *ptr);
void MaskSplinePoint_weight_set(PointerRNA *ptr, float value);

PointerRNA MaskSplinePoint_parent_get(PointerRNA *ptr);

/**************** Mask Spline UW Point ****************/

extern StructRNA RNA_MaskSplinePointUW;

PointerRNA MaskSplinePointUW_rna_type_get(PointerRNA *ptr);

int MaskSplinePointUW_select_get(PointerRNA *ptr);
void MaskSplinePointUW_select_set(PointerRNA *ptr, int value);

float MaskSplinePointUW_u_get(PointerRNA *ptr);
void MaskSplinePointUW_u_set(PointerRNA *ptr, float value);

float MaskSplinePointUW_weight_get(PointerRNA *ptr);
void MaskSplinePointUW_weight_set(PointerRNA *ptr, float value);

/**************** Mask Spline Points ****************/

extern StructRNA RNA_MaskSplinePoints;

PointerRNA MaskSplinePoints_rna_type_get(PointerRNA *ptr);

void MaskSplinePoints_add(struct ID *_selfid, struct MaskSpline *_self, int count);
void MaskSplinePoints_remove(struct ID *_selfid, struct MaskSpline *_self, ReportList *reports, struct PointerRNA *point);
/**************** Mask Splines ****************/

extern StructRNA RNA_MaskSplines;

PointerRNA MaskSplines_rna_type_get(PointerRNA *ptr);

PointerRNA MaskSplines_active_get(PointerRNA *ptr);

PointerRNA MaskSplines_active_point_get(PointerRNA *ptr);

struct MaskSpline *MaskSplines_new(struct ID *_selfid, struct MaskLayer *_self);
void MaskSplines_remove(struct ID *_selfid, struct MaskLayer *_self, ReportList *reports, struct PointerRNA *spline);
/**************** Material ****************/

extern StructRNA RNA_Material;
extern StructRNA RNA_ID;

int Material_paint_active_slot_get(PointerRNA *ptr);
void Material_paint_active_slot_set(PointerRNA *ptr, int value);

PointerRNA Material_active_texture_get(PointerRNA *ptr);

int Material_active_texture_index_get(PointerRNA *ptr);
void Material_active_texture_index_set(PointerRNA *ptr, int value);

float Material_alpha_get(PointerRNA *ptr);
void Material_alpha_set(PointerRNA *ptr, float value);

float Material_ambient_get(PointerRNA *ptr);
void Material_ambient_set(PointerRNA *ptr, float value);

PointerRNA Material_animation_data_get(PointerRNA *ptr);

int Material_use_cast_approximate_get(PointerRNA *ptr);
void Material_use_cast_approximate_set(PointerRNA *ptr, int value);

int Material_use_cast_buffer_shadows_get(PointerRNA *ptr);
void Material_use_cast_buffer_shadows_set(PointerRNA *ptr, int value);

int Material_use_cast_shadows_get(PointerRNA *ptr);
void Material_use_cast_shadows_set(PointerRNA *ptr, int value);

int Material_use_cast_shadows_only_get(PointerRNA *ptr);
void Material_use_cast_shadows_only_set(PointerRNA *ptr, int value);

int Material_paint_clone_slot_get(PointerRNA *ptr);
void Material_paint_clone_slot_set(PointerRNA *ptr, int value);

int Material_use_cubic_get(PointerRNA *ptr);
void Material_use_cubic_set(PointerRNA *ptr, int value);

float Material_darkness_get(PointerRNA *ptr);
void Material_darkness_set(PointerRNA *ptr, float value);

void Material_diffuse_color_get(PointerRNA *ptr, float values[3]);
void Material_diffuse_color_set(PointerRNA *ptr, const float values[3]);

float Material_diffuse_fresnel_get(PointerRNA *ptr);
void Material_diffuse_fresnel_set(PointerRNA *ptr, float value);

float Material_diffuse_fresnel_factor_get(PointerRNA *ptr);
void Material_diffuse_fresnel_factor_set(PointerRNA *ptr, float value);

float Material_diffuse_intensity_get(PointerRNA *ptr);
void Material_diffuse_intensity_set(PointerRNA *ptr, float value);

PointerRNA Material_diffuse_ramp_get(PointerRNA *ptr);

enum {
	Material_diffuse_ramp_blend_MIX = 0,
	Material_diffuse_ramp_blend_ADD = 1,
	Material_diffuse_ramp_blend_MULTIPLY = 2,
	Material_diffuse_ramp_blend_SUBTRACT = 3,
	Material_diffuse_ramp_blend_SCREEN = 4,
	Material_diffuse_ramp_blend_DIVIDE = 5,
	Material_diffuse_ramp_blend_DIFFERENCE = 6,
	Material_diffuse_ramp_blend_DARKEN = 7,
	Material_diffuse_ramp_blend_LIGHTEN = 8,
	Material_diffuse_ramp_blend_OVERLAY = 9,
	Material_diffuse_ramp_blend_DODGE = 10,
	Material_diffuse_ramp_blend_BURN = 11,
	Material_diffuse_ramp_blend_HUE = 12,
	Material_diffuse_ramp_blend_SATURATION = 13,
	Material_diffuse_ramp_blend_VALUE = 14,
	Material_diffuse_ramp_blend_COLOR = 15,
	Material_diffuse_ramp_blend_SOFT_LIGHT = 16,
	Material_diffuse_ramp_blend_LINEAR_LIGHT = 17,
};

int Material_diffuse_ramp_blend_get(PointerRNA *ptr);
void Material_diffuse_ramp_blend_set(PointerRNA *ptr, int value);

float Material_diffuse_ramp_factor_get(PointerRNA *ptr);
void Material_diffuse_ramp_factor_set(PointerRNA *ptr, float value);

enum {
	Material_diffuse_ramp_input_SHADER = 0,
	Material_diffuse_ramp_input_ENERGY = 1,
	Material_diffuse_ramp_input_NORMAL = 2,
	Material_diffuse_ramp_input_RESULT = 3,
};

int Material_diffuse_ramp_input_get(PointerRNA *ptr);
void Material_diffuse_ramp_input_set(PointerRNA *ptr, int value);

enum {
	Material_diffuse_shader_LAMBERT = 0,
	Material_diffuse_shader_OREN_NAYAR = 1,
	Material_diffuse_shader_TOON = 2,
	Material_diffuse_shader_MINNAERT = 3,
	Material_diffuse_shader_FRESNEL = 4,
};

int Material_diffuse_shader_get(PointerRNA *ptr);
void Material_diffuse_shader_set(PointerRNA *ptr, int value);

float Material_diffuse_toon_size_get(PointerRNA *ptr);
void Material_diffuse_toon_size_set(PointerRNA *ptr, float value);

float Material_diffuse_toon_smooth_get(PointerRNA *ptr);
void Material_diffuse_toon_smooth_set(PointerRNA *ptr, float value);

float Material_emit_get(PointerRNA *ptr);
void Material_emit_set(PointerRNA *ptr, float value);

int Material_use_face_texture_get(PointerRNA *ptr);
void Material_use_face_texture_set(PointerRNA *ptr, int value);

int Material_use_face_texture_alpha_get(PointerRNA *ptr);
void Material_use_face_texture_alpha_set(PointerRNA *ptr, int value);

int Material_use_full_oversampling_get(PointerRNA *ptr);
void Material_use_full_oversampling_set(PointerRNA *ptr, int value);

PointerRNA Material_game_settings_get(PointerRNA *ptr);

PointerRNA Material_halo_get(PointerRNA *ptr);

int Material_invert_z_get(PointerRNA *ptr);
void Material_invert_z_set(PointerRNA *ptr, int value);

PointerRNA Material_light_group_get(PointerRNA *ptr);

int Material_use_light_group_exclusive_get(PointerRNA *ptr);
void Material_use_light_group_exclusive_set(PointerRNA *ptr, int value);

int Material_use_light_group_local_get(PointerRNA *ptr);
void Material_use_light_group_local_set(PointerRNA *ptr, int value);

void Material_line_color_get(PointerRNA *ptr, float values[4]);
void Material_line_color_set(PointerRNA *ptr, const float values[4]);

int Material_line_priority_get(PointerRNA *ptr);
void Material_line_priority_set(PointerRNA *ptr, int value);

PointerRNA Material_active_node_material_get(PointerRNA *ptr);

void Material_mirror_color_get(PointerRNA *ptr, float values[3]);
void Material_mirror_color_set(PointerRNA *ptr, const float values[3]);

PointerRNA Material_node_tree_get(PointerRNA *ptr);

int Material_use_object_color_get(PointerRNA *ptr);
void Material_use_object_color_set(PointerRNA *ptr, int value);

int Material_use_only_shadow_get(PointerRNA *ptr);
void Material_use_only_shadow_set(PointerRNA *ptr, int value);

int Material_pass_index_get(PointerRNA *ptr);
void Material_pass_index_set(PointerRNA *ptr, int value);

PointerRNA Material_physics_get(PointerRNA *ptr);

enum {
	Material_preview_render_type_FLAT = 0,
	Material_preview_render_type_SPHERE = 1,
	Material_preview_render_type_CUBE = 2,
	Material_preview_render_type_MONKEY = 3,
	Material_preview_render_type_HAIR = 10,
	Material_preview_render_type_SPHERE_A = 4,
};

int Material_preview_render_type_get(PointerRNA *ptr);
void Material_preview_render_type_set(PointerRNA *ptr, int value);

int Material_use_ray_shadow_bias_get(PointerRNA *ptr);
void Material_use_ray_shadow_bias_set(PointerRNA *ptr, int value);

PointerRNA Material_raytrace_mirror_get(PointerRNA *ptr);

PointerRNA Material_raytrace_transparency_get(PointerRNA *ptr);

int Material_use_transparent_shadows_get(PointerRNA *ptr);
void Material_use_transparent_shadows_set(PointerRNA *ptr, int value);

float Material_roughness_get(PointerRNA *ptr);
void Material_roughness_set(PointerRNA *ptr, float value);

int Material_use_shadeless_get(PointerRNA *ptr);
void Material_use_shadeless_set(PointerRNA *ptr, int value);

float Material_shadow_buffer_bias_get(PointerRNA *ptr);
void Material_shadow_buffer_bias_set(PointerRNA *ptr, float value);

float Material_shadow_cast_alpha_get(PointerRNA *ptr);
void Material_shadow_cast_alpha_set(PointerRNA *ptr, float value);

float Material_shadow_ray_bias_get(PointerRNA *ptr);
void Material_shadow_ray_bias_set(PointerRNA *ptr, float value);

enum {
	Material_shadow_only_type_SHADOW_ONLY_OLD = 0,
	Material_shadow_only_type_SHADOW_ONLY = 1,
	Material_shadow_only_type_SHADOW_ONLY_SHADED = 2,
};

int Material_shadow_only_type_get(PointerRNA *ptr);
void Material_shadow_only_type_set(PointerRNA *ptr, int value);

int Material_use_shadows_get(PointerRNA *ptr);
void Material_use_shadows_set(PointerRNA *ptr, int value);

int Material_use_sky_get(PointerRNA *ptr);
void Material_use_sky_set(PointerRNA *ptr, int value);

float Material_specular_alpha_get(PointerRNA *ptr);
void Material_specular_alpha_set(PointerRNA *ptr, float value);

void Material_specular_color_get(PointerRNA *ptr, float values[3]);
void Material_specular_color_set(PointerRNA *ptr, const float values[3]);

int Material_specular_hardness_get(PointerRNA *ptr);
void Material_specular_hardness_set(PointerRNA *ptr, int value);

float Material_specular_ior_get(PointerRNA *ptr);
void Material_specular_ior_set(PointerRNA *ptr, float value);

float Material_specular_intensity_get(PointerRNA *ptr);
void Material_specular_intensity_set(PointerRNA *ptr, float value);

PointerRNA Material_specular_ramp_get(PointerRNA *ptr);

enum {
	Material_specular_ramp_blend_MIX = 0,
	Material_specular_ramp_blend_ADD = 1,
	Material_specular_ramp_blend_MULTIPLY = 2,
	Material_specular_ramp_blend_SUBTRACT = 3,
	Material_specular_ramp_blend_SCREEN = 4,
	Material_specular_ramp_blend_DIVIDE = 5,
	Material_specular_ramp_blend_DIFFERENCE = 6,
	Material_specular_ramp_blend_DARKEN = 7,
	Material_specular_ramp_blend_LIGHTEN = 8,
	Material_specular_ramp_blend_OVERLAY = 9,
	Material_specular_ramp_blend_DODGE = 10,
	Material_specular_ramp_blend_BURN = 11,
	Material_specular_ramp_blend_HUE = 12,
	Material_specular_ramp_blend_SATURATION = 13,
	Material_specular_ramp_blend_VALUE = 14,
	Material_specular_ramp_blend_COLOR = 15,
	Material_specular_ramp_blend_SOFT_LIGHT = 16,
	Material_specular_ramp_blend_LINEAR_LIGHT = 17,
};

int Material_specular_ramp_blend_get(PointerRNA *ptr);
void Material_specular_ramp_blend_set(PointerRNA *ptr, int value);

float Material_specular_ramp_factor_get(PointerRNA *ptr);
void Material_specular_ramp_factor_set(PointerRNA *ptr, float value);

enum {
	Material_specular_ramp_input_SHADER = 0,
	Material_specular_ramp_input_ENERGY = 1,
	Material_specular_ramp_input_NORMAL = 2,
	Material_specular_ramp_input_RESULT = 3,
};

int Material_specular_ramp_input_get(PointerRNA *ptr);
void Material_specular_ramp_input_set(PointerRNA *ptr, int value);

enum {
	Material_specular_shader_COOKTORR = 0,
	Material_specular_shader_PHONG = 1,
	Material_specular_shader_BLINN = 2,
	Material_specular_shader_TOON = 3,
	Material_specular_shader_WARDISO = 4,
};

int Material_specular_shader_get(PointerRNA *ptr);
void Material_specular_shader_set(PointerRNA *ptr, int value);

float Material_specular_slope_get(PointerRNA *ptr);
void Material_specular_slope_set(PointerRNA *ptr, float value);

float Material_specular_toon_size_get(PointerRNA *ptr);
void Material_specular_toon_size_set(PointerRNA *ptr, float value);

float Material_specular_toon_smooth_get(PointerRNA *ptr);
void Material_specular_toon_smooth_set(PointerRNA *ptr, float value);

PointerRNA Material_strand_get(PointerRNA *ptr);

PointerRNA Material_subsurface_scattering_get(PointerRNA *ptr);

int Material_use_tangent_shading_get(PointerRNA *ptr);
void Material_use_tangent_shading_set(PointerRNA *ptr, int value);

void Material_texture_paint_images_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Material_texture_paint_images_next(CollectionPropertyIterator *iter);
void Material_texture_paint_images_end(CollectionPropertyIterator *iter);
int Material_texture_paint_images_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Material_texture_paint_images_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Material_texture_paint_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Material_texture_paint_slots_next(CollectionPropertyIterator *iter);
void Material_texture_paint_slots_end(CollectionPropertyIterator *iter);

void Material_texture_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Material_texture_slots_next(CollectionPropertyIterator *iter);
void Material_texture_slots_end(CollectionPropertyIterator *iter);

int Material_use_raytrace_get(PointerRNA *ptr);
void Material_use_raytrace_set(PointerRNA *ptr, int value);

float Material_translucency_get(PointerRNA *ptr);
void Material_translucency_set(PointerRNA *ptr, float value);

int Material_use_transparency_get(PointerRNA *ptr);
void Material_use_transparency_set(PointerRNA *ptr, int value);

enum {
	Material_transparency_method_MASK = 0,
	Material_transparency_method_Z_TRANSPARENCY = 64,
	Material_transparency_method_RAYTRACE = 131072,
};

int Material_transparency_method_get(PointerRNA *ptr);
void Material_transparency_method_set(PointerRNA *ptr, int value);

enum {
	Material_type_SURFACE = 0,
	Material_type_WIRE = 3,
	Material_type_VOLUME = 2,
	Material_type_HALO = 1,
};

int Material_type_get(PointerRNA *ptr);
void Material_type_set(PointerRNA *ptr, int value);

int Material_use_uv_project_get(PointerRNA *ptr);
void Material_use_uv_project_set(PointerRNA *ptr, int value);

int Material_use_diffuse_ramp_get(PointerRNA *ptr);
void Material_use_diffuse_ramp_set(PointerRNA *ptr, int value);

int Material_use_mist_get(PointerRNA *ptr);
void Material_use_mist_set(PointerRNA *ptr, int value);

int Material_use_nodes_get(PointerRNA *ptr);
void Material_use_nodes_set(PointerRNA *ptr, int value);

int Material_use_specular_ramp_get(PointerRNA *ptr);
void Material_use_specular_ramp_set(PointerRNA *ptr, int value);

void Material_use_textures_get(PointerRNA *ptr, int values[18]);
void Material_use_textures_set(PointerRNA *ptr, const int values[18]);

int Material_use_vertex_color_light_get(PointerRNA *ptr);
void Material_use_vertex_color_light_set(PointerRNA *ptr, int value);

int Material_use_vertex_color_paint_get(PointerRNA *ptr);
void Material_use_vertex_color_paint_set(PointerRNA *ptr, int value);

PointerRNA Material_volume_get(PointerRNA *ptr);

float Material_offset_z_get(PointerRNA *ptr);
void Material_offset_z_set(PointerRNA *ptr, float value);

/**************** Material Game Settings ****************/

extern StructRNA RNA_MaterialGameSettings;

PointerRNA MaterialGameSettings_rna_type_get(PointerRNA *ptr);

int MaterialGameSettings_use_backface_culling_get(PointerRNA *ptr);
void MaterialGameSettings_use_backface_culling_set(PointerRNA *ptr, int value);

enum {
	MaterialGameSettings_alpha_blend_OPAQUE = 0,
	MaterialGameSettings_alpha_blend_ADD = 1,
	MaterialGameSettings_alpha_blend_CLIP = 4,
	MaterialGameSettings_alpha_blend_ALPHA = 2,
	MaterialGameSettings_alpha_blend_ALPHA_SORT = 8,
};

int MaterialGameSettings_alpha_blend_get(PointerRNA *ptr);
void MaterialGameSettings_alpha_blend_set(PointerRNA *ptr, int value);

enum {
	MaterialGameSettings_face_orientation_NORMAL = 0,
	MaterialGameSettings_face_orientation_HALO = 512,
	MaterialGameSettings_face_orientation_BILLBOARD = 1024,
	MaterialGameSettings_face_orientation_SHADOW = 2048,
};

int MaterialGameSettings_face_orientation_get(PointerRNA *ptr);
void MaterialGameSettings_face_orientation_set(PointerRNA *ptr, int value);

int MaterialGameSettings_invisible_get(PointerRNA *ptr);
void MaterialGameSettings_invisible_set(PointerRNA *ptr, int value);

int MaterialGameSettings_physics_get(PointerRNA *ptr);
void MaterialGameSettings_physics_set(PointerRNA *ptr, int value);

int MaterialGameSettings_text_get(PointerRNA *ptr);
void MaterialGameSettings_text_set(PointerRNA *ptr, int value);

/**************** Material Halo ****************/

extern StructRNA RNA_MaterialHalo;

PointerRNA MaterialHalo_rna_type_get(PointerRNA *ptr);

float MaterialHalo_add_get(PointerRNA *ptr);
void MaterialHalo_add_set(PointerRNA *ptr, float value);

int MaterialHalo_use_extreme_alpha_get(PointerRNA *ptr);
void MaterialHalo_use_extreme_alpha_set(PointerRNA *ptr, int value);

int MaterialHalo_use_flare_mode_get(PointerRNA *ptr);
void MaterialHalo_use_flare_mode_set(PointerRNA *ptr, int value);

float MaterialHalo_flare_boost_get(PointerRNA *ptr);
void MaterialHalo_flare_boost_set(PointerRNA *ptr, float value);

int MaterialHalo_flare_seed_get(PointerRNA *ptr);
void MaterialHalo_flare_seed_set(PointerRNA *ptr, int value);

float MaterialHalo_flare_size_get(PointerRNA *ptr);
void MaterialHalo_flare_size_set(PointerRNA *ptr, float value);

float MaterialHalo_flare_subflare_size_get(PointerRNA *ptr);
void MaterialHalo_flare_subflare_size_set(PointerRNA *ptr, float value);

int MaterialHalo_flare_subflare_count_get(PointerRNA *ptr);
void MaterialHalo_flare_subflare_count_set(PointerRNA *ptr, int value);

int MaterialHalo_hardness_get(PointerRNA *ptr);
void MaterialHalo_hardness_set(PointerRNA *ptr, int value);

int MaterialHalo_line_count_get(PointerRNA *ptr);
void MaterialHalo_line_count_set(PointerRNA *ptr, int value);

int MaterialHalo_use_lines_get(PointerRNA *ptr);
void MaterialHalo_use_lines_set(PointerRNA *ptr, int value);

int MaterialHalo_ring_count_get(PointerRNA *ptr);
void MaterialHalo_ring_count_set(PointerRNA *ptr, int value);

int MaterialHalo_use_ring_get(PointerRNA *ptr);
void MaterialHalo_use_ring_set(PointerRNA *ptr, int value);

int MaterialHalo_seed_get(PointerRNA *ptr);
void MaterialHalo_seed_set(PointerRNA *ptr, int value);

int MaterialHalo_use_shaded_get(PointerRNA *ptr);
void MaterialHalo_use_shaded_set(PointerRNA *ptr, int value);

float MaterialHalo_size_get(PointerRNA *ptr);
void MaterialHalo_size_set(PointerRNA *ptr, float value);

int MaterialHalo_use_soft_get(PointerRNA *ptr);
void MaterialHalo_use_soft_set(PointerRNA *ptr, int value);

int MaterialHalo_use_star_get(PointerRNA *ptr);
void MaterialHalo_use_star_set(PointerRNA *ptr, int value);

int MaterialHalo_star_tip_count_get(PointerRNA *ptr);
void MaterialHalo_star_tip_count_set(PointerRNA *ptr, int value);

int MaterialHalo_use_texture_get(PointerRNA *ptr);
void MaterialHalo_use_texture_set(PointerRNA *ptr, int value);

int MaterialHalo_use_vertex_normal_get(PointerRNA *ptr);
void MaterialHalo_use_vertex_normal_set(PointerRNA *ptr, int value);

/**************** Material Physics ****************/

extern StructRNA RNA_MaterialPhysics;

PointerRNA MaterialPhysics_rna_type_get(PointerRNA *ptr);

int MaterialPhysics_use_fh_normal_get(PointerRNA *ptr);
void MaterialPhysics_use_fh_normal_set(PointerRNA *ptr, int value);

float MaterialPhysics_fh_damping_get(PointerRNA *ptr);
void MaterialPhysics_fh_damping_set(PointerRNA *ptr, float value);

float MaterialPhysics_fh_distance_get(PointerRNA *ptr);
void MaterialPhysics_fh_distance_set(PointerRNA *ptr, float value);

float MaterialPhysics_elasticity_get(PointerRNA *ptr);
void MaterialPhysics_elasticity_set(PointerRNA *ptr, float value);

float MaterialPhysics_fh_force_get(PointerRNA *ptr);
void MaterialPhysics_fh_force_set(PointerRNA *ptr, float value);

float MaterialPhysics_friction_get(PointerRNA *ptr);
void MaterialPhysics_friction_set(PointerRNA *ptr, float value);

/**************** Material Raytrace Mirror ****************/

extern StructRNA RNA_MaterialRaytraceMirror;

PointerRNA MaterialRaytraceMirror_rna_type_get(PointerRNA *ptr);

int MaterialRaytraceMirror_depth_get(PointerRNA *ptr);
void MaterialRaytraceMirror_depth_set(PointerRNA *ptr, int value);

int MaterialRaytraceMirror_use_get(PointerRNA *ptr);
void MaterialRaytraceMirror_use_set(PointerRNA *ptr, int value);

enum {
	MaterialRaytraceMirror_fade_to_FADE_TO_SKY = 0,
	MaterialRaytraceMirror_fade_to_FADE_TO_MATERIAL = 1,
};

int MaterialRaytraceMirror_fade_to_get(PointerRNA *ptr);
void MaterialRaytraceMirror_fade_to_set(PointerRNA *ptr, int value);

float MaterialRaytraceMirror_fresnel_get(PointerRNA *ptr);
void MaterialRaytraceMirror_fresnel_set(PointerRNA *ptr, float value);

float MaterialRaytraceMirror_fresnel_factor_get(PointerRNA *ptr);
void MaterialRaytraceMirror_fresnel_factor_set(PointerRNA *ptr, float value);

float MaterialRaytraceMirror_gloss_factor_get(PointerRNA *ptr);
void MaterialRaytraceMirror_gloss_factor_set(PointerRNA *ptr, float value);

float MaterialRaytraceMirror_gloss_anisotropic_get(PointerRNA *ptr);
void MaterialRaytraceMirror_gloss_anisotropic_set(PointerRNA *ptr, float value);

int MaterialRaytraceMirror_gloss_samples_get(PointerRNA *ptr);
void MaterialRaytraceMirror_gloss_samples_set(PointerRNA *ptr, int value);

float MaterialRaytraceMirror_gloss_threshold_get(PointerRNA *ptr);
void MaterialRaytraceMirror_gloss_threshold_set(PointerRNA *ptr, float value);

float MaterialRaytraceMirror_distance_get(PointerRNA *ptr);
void MaterialRaytraceMirror_distance_set(PointerRNA *ptr, float value);

float MaterialRaytraceMirror_reflect_factor_get(PointerRNA *ptr);
void MaterialRaytraceMirror_reflect_factor_set(PointerRNA *ptr, float value);

/**************** Material Raytrace Transparency ****************/

extern StructRNA RNA_MaterialRaytraceTransparency;

PointerRNA MaterialRaytraceTransparency_rna_type_get(PointerRNA *ptr);

int MaterialRaytraceTransparency_depth_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_depth_set(PointerRNA *ptr, int value);

float MaterialRaytraceTransparency_falloff_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_falloff_set(PointerRNA *ptr, float value);

float MaterialRaytraceTransparency_filter_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_filter_set(PointerRNA *ptr, float value);

float MaterialRaytraceTransparency_fresnel_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_fresnel_set(PointerRNA *ptr, float value);

float MaterialRaytraceTransparency_fresnel_factor_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_fresnel_factor_set(PointerRNA *ptr, float value);

float MaterialRaytraceTransparency_gloss_factor_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_gloss_factor_set(PointerRNA *ptr, float value);

int MaterialRaytraceTransparency_gloss_samples_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_gloss_samples_set(PointerRNA *ptr, int value);

float MaterialRaytraceTransparency_gloss_threshold_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_gloss_threshold_set(PointerRNA *ptr, float value);

float MaterialRaytraceTransparency_ior_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_ior_set(PointerRNA *ptr, float value);

float MaterialRaytraceTransparency_depth_max_get(PointerRNA *ptr);
void MaterialRaytraceTransparency_depth_max_set(PointerRNA *ptr, float value);

/**************** Material Slot ****************/

extern StructRNA RNA_MaterialSlot;

PointerRNA MaterialSlot_rna_type_get(PointerRNA *ptr);

void MaterialSlot_name_get(PointerRNA *ptr, char *value);
int MaterialSlot_name_length(PointerRNA *ptr);
void MaterialSlot_name_set(PointerRNA *ptr, const char *value);

enum {
	MaterialSlot_link_OBJECT = 1,
	MaterialSlot_link_DATA = 0,
};

int MaterialSlot_link_get(PointerRNA *ptr);
void MaterialSlot_link_set(PointerRNA *ptr, int value);

PointerRNA MaterialSlot_material_get(PointerRNA *ptr);

/**************** Material Strand ****************/

extern StructRNA RNA_MaterialStrand;

PointerRNA MaterialStrand_rna_type_get(PointerRNA *ptr);

float MaterialStrand_blend_distance_get(PointerRNA *ptr);
void MaterialStrand_blend_distance_set(PointerRNA *ptr, float value);

int MaterialStrand_use_blender_units_get(PointerRNA *ptr);
void MaterialStrand_use_blender_units_set(PointerRNA *ptr, int value);

float MaterialStrand_size_min_get(PointerRNA *ptr);
void MaterialStrand_size_min_set(PointerRNA *ptr, float value);

float MaterialStrand_root_size_get(PointerRNA *ptr);
void MaterialStrand_root_size_set(PointerRNA *ptr, float value);

float MaterialStrand_shape_get(PointerRNA *ptr);
void MaterialStrand_shape_set(PointerRNA *ptr, float value);

int MaterialStrand_use_surface_diffuse_get(PointerRNA *ptr);
void MaterialStrand_use_surface_diffuse_set(PointerRNA *ptr, int value);

int MaterialStrand_use_tangent_shading_get(PointerRNA *ptr);
void MaterialStrand_use_tangent_shading_set(PointerRNA *ptr, int value);

float MaterialStrand_tip_size_get(PointerRNA *ptr);
void MaterialStrand_tip_size_set(PointerRNA *ptr, float value);

#define MaterialStrand_uv_layer_MAX 64

void MaterialStrand_uv_layer_get(PointerRNA *ptr, char *value);
int MaterialStrand_uv_layer_length(PointerRNA *ptr);
void MaterialStrand_uv_layer_set(PointerRNA *ptr, const char *value);

float MaterialStrand_width_fade_get(PointerRNA *ptr);
void MaterialStrand_width_fade_set(PointerRNA *ptr, float value);

/**************** Material Subsurface Scattering ****************/

extern StructRNA RNA_MaterialSubsurfaceScattering;

PointerRNA MaterialSubsurfaceScattering_rna_type_get(PointerRNA *ptr);

float MaterialSubsurfaceScattering_back_get(PointerRNA *ptr);
void MaterialSubsurfaceScattering_back_set(PointerRNA *ptr, float value);

void MaterialSubsurfaceScattering_color_get(PointerRNA *ptr, float values[3]);
void MaterialSubsurfaceScattering_color_set(PointerRNA *ptr, const float values[3]);

float MaterialSubsurfaceScattering_color_factor_get(PointerRNA *ptr);
void MaterialSubsurfaceScattering_color_factor_set(PointerRNA *ptr, float value);

int MaterialSubsurfaceScattering_use_get(PointerRNA *ptr);
void MaterialSubsurfaceScattering_use_set(PointerRNA *ptr, int value);

float MaterialSubsurfaceScattering_error_threshold_get(PointerRNA *ptr);
void MaterialSubsurfaceScattering_error_threshold_set(PointerRNA *ptr, float value);

float MaterialSubsurfaceScattering_front_get(PointerRNA *ptr);
void MaterialSubsurfaceScattering_front_set(PointerRNA *ptr, float value);

float MaterialSubsurfaceScattering_ior_get(PointerRNA *ptr);
void MaterialSubsurfaceScattering_ior_set(PointerRNA *ptr, float value);

void MaterialSubsurfaceScattering_radius_get(PointerRNA *ptr, float values[3]);
void MaterialSubsurfaceScattering_radius_set(PointerRNA *ptr, const float values[3]);

float MaterialSubsurfaceScattering_scale_get(PointerRNA *ptr);
void MaterialSubsurfaceScattering_scale_set(PointerRNA *ptr, float value);

float MaterialSubsurfaceScattering_texture_factor_get(PointerRNA *ptr);
void MaterialSubsurfaceScattering_texture_factor_set(PointerRNA *ptr, float value);

/**************** Material Texture Slot ****************/

extern StructRNA RNA_MaterialTextureSlot;
extern StructRNA RNA_TextureSlot;

int MaterialTextureSlot_use_map_alpha_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_alpha_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_alpha_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_alpha_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_ambient_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_ambient_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_ambient_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_ambient_factor_set(PointerRNA *ptr, float value);

enum {
	MaterialTextureSlot_bump_method_BUMP_ORIGINAL = 0,
	MaterialTextureSlot_bump_method_BUMP_COMPATIBLE = 128,
	MaterialTextureSlot_bump_method_BUMP_LOW_QUALITY = 256,
	MaterialTextureSlot_bump_method_BUMP_MEDIUM_QUALITY = 512,
	MaterialTextureSlot_bump_method_BUMP_BEST_QUALITY = 8192,
};

int MaterialTextureSlot_bump_method_get(PointerRNA *ptr);
void MaterialTextureSlot_bump_method_set(PointerRNA *ptr, int value);

enum {
	MaterialTextureSlot_bump_objectspace_BUMP_VIEWSPACE = 0,
	MaterialTextureSlot_bump_objectspace_BUMP_OBJECTSPACE = 1024,
	MaterialTextureSlot_bump_objectspace_BUMP_TEXTURESPACE = 2048,
};

int MaterialTextureSlot_bump_objectspace_get(PointerRNA *ptr);
void MaterialTextureSlot_bump_objectspace_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_map_density_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_density_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_density_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_density_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_diffuse_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_diffuse_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_map_color_diffuse_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_color_diffuse_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_diffuse_color_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_diffuse_color_factor_set(PointerRNA *ptr, float value);

float MaterialTextureSlot_diffuse_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_diffuse_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_displacement_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_displacement_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_displacement_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_displacement_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_emission_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_emission_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_map_color_emission_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_color_emission_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_emission_color_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_emission_color_factor_set(PointerRNA *ptr, float value);

float MaterialTextureSlot_emission_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_emission_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_emit_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_emit_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_emit_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_emit_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_get(PointerRNA *ptr);
void MaterialTextureSlot_use_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_from_dupli_get(PointerRNA *ptr);
void MaterialTextureSlot_use_from_dupli_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_from_original_get(PointerRNA *ptr);
void MaterialTextureSlot_use_from_original_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_map_hardness_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_hardness_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_hardness_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_hardness_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_to_bounds_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_to_bounds_set(PointerRNA *ptr, int value);

enum {
	MaterialTextureSlot_mapping_FLAT = 0,
	MaterialTextureSlot_mapping_CUBE = 1,
	MaterialTextureSlot_mapping_TUBE = 2,
	MaterialTextureSlot_mapping_SPHERE = 3,
};

int MaterialTextureSlot_mapping_get(PointerRNA *ptr);
void MaterialTextureSlot_mapping_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_map_mirror_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_mirror_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_mirror_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_mirror_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_normal_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_normal_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_normal_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_normal_factor_set(PointerRNA *ptr, float value);

enum {
	MaterialTextureSlot_normal_map_space_CAMERA = 0,
	MaterialTextureSlot_normal_map_space_WORLD = 1,
	MaterialTextureSlot_normal_map_space_OBJECT = 2,
	MaterialTextureSlot_normal_map_space_TANGENT = 3,
};

int MaterialTextureSlot_normal_map_space_get(PointerRNA *ptr);
void MaterialTextureSlot_normal_map_space_set(PointerRNA *ptr, int value);

PointerRNA MaterialTextureSlot_object_get(PointerRNA *ptr);

float MaterialTextureSlot_raymir_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_raymir_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_raymir_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_raymir_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_map_reflect_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_reflect_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_map_color_reflection_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_color_reflection_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_reflection_color_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_reflection_color_factor_set(PointerRNA *ptr, float value);

float MaterialTextureSlot_reflection_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_reflection_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_scatter_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_scatter_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_scattering_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_scattering_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_specular_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_specular_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_map_color_spec_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_color_spec_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_specular_color_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_specular_color_factor_set(PointerRNA *ptr, float value);

float MaterialTextureSlot_specular_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_specular_factor_set(PointerRNA *ptr, float value);

enum {
	MaterialTextureSlot_texture_coords_GLOBAL = 8,
	MaterialTextureSlot_texture_coords_OBJECT = 32,
	MaterialTextureSlot_texture_coords_UV = 16,
	MaterialTextureSlot_texture_coords_ORCO = 1,
	MaterialTextureSlot_texture_coords_STRAND = 8192,
	MaterialTextureSlot_texture_coords_WINDOW = 1024,
	MaterialTextureSlot_texture_coords_NORMAL = 4,
	MaterialTextureSlot_texture_coords_REFLECTION = 2,
	MaterialTextureSlot_texture_coords_STRESS = 16384,
	MaterialTextureSlot_texture_coords_TANGENT = 4096,
};

int MaterialTextureSlot_texture_coords_get(PointerRNA *ptr);
void MaterialTextureSlot_texture_coords_set(PointerRNA *ptr, int value);

int MaterialTextureSlot_use_map_translucency_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_translucency_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_translucency_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_translucency_factor_set(PointerRNA *ptr, float value);

int MaterialTextureSlot_use_map_color_transmission_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_color_transmission_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_transmission_color_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_transmission_color_factor_set(PointerRNA *ptr, float value);

#define MaterialTextureSlot_uv_layer_MAX 64

void MaterialTextureSlot_uv_layer_get(PointerRNA *ptr, char *value);
int MaterialTextureSlot_uv_layer_length(PointerRNA *ptr);
void MaterialTextureSlot_uv_layer_set(PointerRNA *ptr, const char *value);

int MaterialTextureSlot_use_map_warp_get(PointerRNA *ptr);
void MaterialTextureSlot_use_map_warp_set(PointerRNA *ptr, int value);

float MaterialTextureSlot_warp_factor_get(PointerRNA *ptr);
void MaterialTextureSlot_warp_factor_set(PointerRNA *ptr, float value);

enum {
	MaterialTextureSlot_mapping_x_NONE = 0,
	MaterialTextureSlot_mapping_x_X = 1,
	MaterialTextureSlot_mapping_x_Y = 2,
	MaterialTextureSlot_mapping_x_Z = 3,
};

int MaterialTextureSlot_mapping_x_get(PointerRNA *ptr);
void MaterialTextureSlot_mapping_x_set(PointerRNA *ptr, int value);

enum {
	MaterialTextureSlot_mapping_y_NONE = 0,
	MaterialTextureSlot_mapping_y_X = 1,
	MaterialTextureSlot_mapping_y_Y = 2,
	MaterialTextureSlot_mapping_y_Z = 3,
};

int MaterialTextureSlot_mapping_y_get(PointerRNA *ptr);
void MaterialTextureSlot_mapping_y_set(PointerRNA *ptr, int value);

enum {
	MaterialTextureSlot_mapping_z_NONE = 0,
	MaterialTextureSlot_mapping_z_X = 1,
	MaterialTextureSlot_mapping_z_Y = 2,
	MaterialTextureSlot_mapping_z_Z = 3,
};

int MaterialTextureSlot_mapping_z_get(PointerRNA *ptr);
void MaterialTextureSlot_mapping_z_set(PointerRNA *ptr, int value);

/**************** Texture Slots ****************/

extern StructRNA RNA_MaterialTextureSlots;

PointerRNA MaterialTextureSlots_rna_type_get(PointerRNA *ptr);

struct MTex *MaterialTextureSlots_add(struct ID *_selfid, bContext *C, ReportList *reports);
struct MTex *MaterialTextureSlots_create(struct ID *_selfid, bContext *C, ReportList *reports, int index);
void MaterialTextureSlots_clear(struct ID *_selfid, bContext *C, ReportList *reports, int index);
/**************** Material Volume ****************/

extern StructRNA RNA_MaterialVolume;

PointerRNA MaterialVolume_rna_type_get(PointerRNA *ptr);

float MaterialVolume_asymmetry_get(PointerRNA *ptr);
void MaterialVolume_asymmetry_set(PointerRNA *ptr, float value);

float MaterialVolume_density_get(PointerRNA *ptr);
void MaterialVolume_density_set(PointerRNA *ptr, float value);

float MaterialVolume_density_scale_get(PointerRNA *ptr);
void MaterialVolume_density_scale_set(PointerRNA *ptr, float value);

float MaterialVolume_depth_threshold_get(PointerRNA *ptr);
void MaterialVolume_depth_threshold_set(PointerRNA *ptr, float value);

float MaterialVolume_ms_diffusion_get(PointerRNA *ptr);
void MaterialVolume_ms_diffusion_set(PointerRNA *ptr, float value);

float MaterialVolume_emission_get(PointerRNA *ptr);
void MaterialVolume_emission_set(PointerRNA *ptr, float value);

void MaterialVolume_emission_color_get(PointerRNA *ptr, float values[3]);
void MaterialVolume_emission_color_set(PointerRNA *ptr, const float values[3]);

int MaterialVolume_use_external_shadows_get(PointerRNA *ptr);
void MaterialVolume_use_external_shadows_set(PointerRNA *ptr, int value);

float MaterialVolume_ms_intensity_get(PointerRNA *ptr);
void MaterialVolume_ms_intensity_set(PointerRNA *ptr, float value);

int MaterialVolume_use_light_cache_get(PointerRNA *ptr);
void MaterialVolume_use_light_cache_set(PointerRNA *ptr, int value);

enum {
	MaterialVolume_light_method_SHADELESS = 0,
	MaterialVolume_light_method_SHADOWED = 2,
	MaterialVolume_light_method_SHADED = 1,
	MaterialVolume_light_method_MULTIPLE_SCATTERING = 3,
	MaterialVolume_light_method_SHADED_PLUS_MULTIPLE_SCATTERING = 4,
};

int MaterialVolume_light_method_get(PointerRNA *ptr);
void MaterialVolume_light_method_set(PointerRNA *ptr, int value);

float MaterialVolume_reflection_get(PointerRNA *ptr);
void MaterialVolume_reflection_set(PointerRNA *ptr, float value);

void MaterialVolume_reflection_color_get(PointerRNA *ptr, float values[3]);
void MaterialVolume_reflection_color_set(PointerRNA *ptr, const float values[3]);

int MaterialVolume_cache_resolution_get(PointerRNA *ptr);
void MaterialVolume_cache_resolution_set(PointerRNA *ptr, int value);

float MaterialVolume_scattering_get(PointerRNA *ptr);
void MaterialVolume_scattering_set(PointerRNA *ptr, float value);

float MaterialVolume_ms_spread_get(PointerRNA *ptr);
void MaterialVolume_ms_spread_set(PointerRNA *ptr, float value);

enum {
	MaterialVolume_step_method_RANDOMIZED = 0,
	MaterialVolume_step_method_CONSTANT = 1,
};

int MaterialVolume_step_method_get(PointerRNA *ptr);
void MaterialVolume_step_method_set(PointerRNA *ptr, int value);

float MaterialVolume_step_size_get(PointerRNA *ptr);
void MaterialVolume_step_size_set(PointerRNA *ptr, float value);

void MaterialVolume_transmission_color_get(PointerRNA *ptr, float values[3]);
void MaterialVolume_transmission_color_set(PointerRNA *ptr, const float values[3]);

/**************** Menu ****************/

extern StructRNA RNA_Menu;

PointerRNA Menu_rna_type_get(PointerRNA *ptr);

void Menu_bl_idname_get(PointerRNA *ptr, char *value);
int Menu_bl_idname_length(PointerRNA *ptr);
void Menu_bl_idname_set(PointerRNA *ptr, const char *value);

void Menu_bl_label_get(PointerRNA *ptr, char *value);
int Menu_bl_label_length(PointerRNA *ptr);
void Menu_bl_label_set(PointerRNA *ptr, const char *value);

PointerRNA Menu_layout_get(PointerRNA *ptr);

#define Menu_bl_description_MAX 240

void Menu_bl_description_get(PointerRNA *ptr, char *value);
int Menu_bl_description_length(PointerRNA *ptr);
void Menu_bl_description_set(PointerRNA *ptr, const char *value);

void Menu_bl_translation_context_get(PointerRNA *ptr, char *value);
int Menu_bl_translation_context_length(PointerRNA *ptr);
void Menu_bl_translation_context_set(PointerRNA *ptr, const char *value);

int Menu_poll(struct bContext *context);
void Menu_draw(struct Menu *_self, struct bContext *context);
/**************** Mesh ****************/

extern StructRNA RNA_Mesh;
extern StructRNA RNA_ID;

PointerRNA Mesh_animation_data_get(PointerRNA *ptr);

int Mesh_use_auto_smooth_get(PointerRNA *ptr);
void Mesh_use_auto_smooth_set(PointerRNA *ptr, int value);

float Mesh_auto_smooth_angle_get(PointerRNA *ptr);
void Mesh_auto_smooth_angle_set(PointerRNA *ptr, float value);

int Mesh_use_auto_texspace_get(PointerRNA *ptr);
void Mesh_use_auto_texspace_set(PointerRNA *ptr, int value);

int Mesh_auto_texspace_get(PointerRNA *ptr);
void Mesh_auto_texspace_set(PointerRNA *ptr, int value);

PointerRNA Mesh_uv_texture_clone_get(PointerRNA *ptr);

int Mesh_uv_texture_clone_index_get(PointerRNA *ptr);
void Mesh_uv_texture_clone_index_set(PointerRNA *ptr, int value);

PointerRNA Mesh_uv_layer_clone_get(PointerRNA *ptr);

int Mesh_uv_layer_clone_index_get(PointerRNA *ptr);
void Mesh_uv_layer_clone_index_set(PointerRNA *ptr, int value);

int Mesh_show_double_sided_get(PointerRNA *ptr);
void Mesh_show_double_sided_set(PointerRNA *ptr, int value);

int Mesh_show_edge_bevel_weight_get(PointerRNA *ptr);
void Mesh_show_edge_bevel_weight_set(PointerRNA *ptr, int value);

int Mesh_show_edge_crease_get(PointerRNA *ptr);
void Mesh_show_edge_crease_set(PointerRNA *ptr, int value);

int Mesh_show_edges_get(PointerRNA *ptr);
void Mesh_show_edges_set(PointerRNA *ptr, int value);

int Mesh_show_faces_get(PointerRNA *ptr);
void Mesh_show_faces_set(PointerRNA *ptr, int value);

int Mesh_show_freestyle_edge_marks_get(PointerRNA *ptr);
void Mesh_show_freestyle_edge_marks_set(PointerRNA *ptr, int value);

int Mesh_show_freestyle_face_marks_get(PointerRNA *ptr);
void Mesh_show_freestyle_face_marks_set(PointerRNA *ptr, int value);

int Mesh_show_normal_face_get(PointerRNA *ptr);
void Mesh_show_normal_face_set(PointerRNA *ptr, int value);

int Mesh_show_edge_seams_get(PointerRNA *ptr);
void Mesh_show_edge_seams_set(PointerRNA *ptr, int value);

int Mesh_show_edge_sharp_get(PointerRNA *ptr);
void Mesh_show_edge_sharp_set(PointerRNA *ptr, int value);

int Mesh_show_normal_loop_get(PointerRNA *ptr);
void Mesh_show_normal_loop_set(PointerRNA *ptr, int value);

int Mesh_show_normal_vertex_get(PointerRNA *ptr);
void Mesh_show_normal_vertex_set(PointerRNA *ptr, int value);

int Mesh_show_extra_edge_angle_get(PointerRNA *ptr);
void Mesh_show_extra_edge_angle_set(PointerRNA *ptr, int value);

int Mesh_show_extra_edge_length_get(PointerRNA *ptr);
void Mesh_show_extra_edge_length_set(PointerRNA *ptr, int value);

void Mesh_edges_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_edges_next(CollectionPropertyIterator *iter);
void Mesh_edges_end(CollectionPropertyIterator *iter);
int Mesh_edges_length(PointerRNA *ptr);
int Mesh_edges_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int Mesh_show_extra_face_angle_get(PointerRNA *ptr);
void Mesh_show_extra_face_angle_set(PointerRNA *ptr, int value);

int Mesh_show_extra_face_area_get(PointerRNA *ptr);
void Mesh_show_extra_face_area_set(PointerRNA *ptr, int value);

void Mesh_polygon_layers_float_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_polygon_layers_float_next(CollectionPropertyIterator *iter);
void Mesh_polygon_layers_float_end(CollectionPropertyIterator *iter);
int Mesh_polygon_layers_float_length(PointerRNA *ptr);
int Mesh_polygon_layers_float_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_polygon_layers_float_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Mesh_show_extra_indices_get(PointerRNA *ptr);
void Mesh_show_extra_indices_set(PointerRNA *ptr, int value);

void Mesh_polygon_layers_int_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_polygon_layers_int_next(CollectionPropertyIterator *iter);
void Mesh_polygon_layers_int_end(CollectionPropertyIterator *iter);
int Mesh_polygon_layers_int_length(PointerRNA *ptr);
int Mesh_polygon_layers_int_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_polygon_layers_int_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Mesh_is_editmode_get(PointerRNA *ptr);
void Mesh_is_editmode_set(PointerRNA *ptr, int value);

void Mesh_loops_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_loops_next(CollectionPropertyIterator *iter);
void Mesh_loops_end(CollectionPropertyIterator *iter);
int Mesh_loops_length(PointerRNA *ptr);
int Mesh_loops_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

PointerRNA Mesh_uv_texture_stencil_get(PointerRNA *ptr);

int Mesh_uv_texture_stencil_index_get(PointerRNA *ptr);
void Mesh_uv_texture_stencil_index_set(PointerRNA *ptr, int value);

PointerRNA Mesh_uv_layer_stencil_get(PointerRNA *ptr);

int Mesh_uv_layer_stencil_index_get(PointerRNA *ptr);
void Mesh_uv_layer_stencil_index_set(PointerRNA *ptr, int value);

void Mesh_materials_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_materials_next(CollectionPropertyIterator *iter);
void Mesh_materials_end(CollectionPropertyIterator *iter);
int Mesh_materials_length(PointerRNA *ptr);
int Mesh_materials_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_materials_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Mesh_use_paint_mask_get(PointerRNA *ptr);
void Mesh_use_paint_mask_set(PointerRNA *ptr, int value);

void Mesh_polygons_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_polygons_next(CollectionPropertyIterator *iter);
void Mesh_polygons_end(CollectionPropertyIterator *iter);
int Mesh_polygons_length(PointerRNA *ptr);
int Mesh_polygons_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int Mesh_total_edge_sel_get(PointerRNA *ptr);
void Mesh_total_edge_sel_set(PointerRNA *ptr, int value);

int Mesh_total_face_sel_get(PointerRNA *ptr);
void Mesh_total_face_sel_set(PointerRNA *ptr, int value);

int Mesh_total_vert_sel_get(PointerRNA *ptr);
void Mesh_total_vert_sel_set(PointerRNA *ptr, int value);

PointerRNA Mesh_shape_keys_get(PointerRNA *ptr);

int Mesh_show_weight_get(PointerRNA *ptr);
void Mesh_show_weight_set(PointerRNA *ptr, int value);

void Mesh_skin_vertices_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_skin_vertices_next(CollectionPropertyIterator *iter);
void Mesh_skin_vertices_end(CollectionPropertyIterator *iter);
int Mesh_skin_vertices_length(PointerRNA *ptr);
int Mesh_skin_vertices_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_skin_vertices_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Mesh_show_statvis_get(PointerRNA *ptr);
void Mesh_show_statvis_set(PointerRNA *ptr, int value);

int Mesh_use_customdata_edge_bevel_get(PointerRNA *ptr);
void Mesh_use_customdata_edge_bevel_set(PointerRNA *ptr, int value);

int Mesh_use_customdata_edge_crease_get(PointerRNA *ptr);
void Mesh_use_customdata_edge_crease_set(PointerRNA *ptr, int value);

int Mesh_use_customdata_vertex_bevel_get(PointerRNA *ptr);
void Mesh_use_customdata_vertex_bevel_set(PointerRNA *ptr, int value);

void Mesh_polygon_layers_string_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_polygon_layers_string_next(CollectionPropertyIterator *iter);
void Mesh_polygon_layers_string_end(CollectionPropertyIterator *iter);
int Mesh_polygon_layers_string_length(PointerRNA *ptr);
int Mesh_polygon_layers_string_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_polygon_layers_string_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Mesh_tessfaces_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_tessfaces_next(CollectionPropertyIterator *iter);
void Mesh_tessfaces_end(CollectionPropertyIterator *iter);
int Mesh_tessfaces_length(PointerRNA *ptr);
int Mesh_tessfaces_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void Mesh_tessface_vertex_colors_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_tessface_vertex_colors_next(CollectionPropertyIterator *iter);
void Mesh_tessface_vertex_colors_end(CollectionPropertyIterator *iter);
int Mesh_tessface_vertex_colors_length(PointerRNA *ptr);
int Mesh_tessface_vertex_colors_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_tessface_vertex_colors_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Mesh_tessface_uv_textures_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_tessface_uv_textures_next(CollectionPropertyIterator *iter);
void Mesh_tessface_uv_textures_end(CollectionPropertyIterator *iter);
int Mesh_tessface_uv_textures_length(PointerRNA *ptr);
int Mesh_tessface_uv_textures_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_tessface_uv_textures_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA Mesh_texture_mesh_get(PointerRNA *ptr);

void Mesh_texspace_location_get(PointerRNA *ptr, float values[3]);
void Mesh_texspace_location_set(PointerRNA *ptr, const float values[3]);

PointerRNA Mesh_texco_mesh_get(PointerRNA *ptr);

void Mesh_texspace_size_get(PointerRNA *ptr, float values[3]);
void Mesh_texspace_size_set(PointerRNA *ptr, const float values[3]);

int Mesh_use_mirror_topology_get(PointerRNA *ptr);
void Mesh_use_mirror_topology_set(PointerRNA *ptr, int value);

void Mesh_uv_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_uv_layers_next(CollectionPropertyIterator *iter);
void Mesh_uv_layers_end(CollectionPropertyIterator *iter);
int Mesh_uv_layers_length(PointerRNA *ptr);
int Mesh_uv_layers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_uv_layers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Mesh_uv_textures_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_uv_textures_next(CollectionPropertyIterator *iter);
void Mesh_uv_textures_end(CollectionPropertyIterator *iter);
int Mesh_uv_textures_length(PointerRNA *ptr);
int Mesh_uv_textures_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_uv_textures_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Mesh_vertex_colors_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_vertex_colors_next(CollectionPropertyIterator *iter);
void Mesh_vertex_colors_end(CollectionPropertyIterator *iter);
int Mesh_vertex_colors_length(PointerRNA *ptr);
int Mesh_vertex_colors_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Mesh_vertex_colors_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Mesh_use_paint_mask_vertex_get(PointerRNA *ptr);
void Mesh_use_paint_mask_vertex_set(PointerRNA *ptr, int value);

void Mesh_vertices_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Mesh_vertices_next(CollectionPropertyIterator *iter);
void Mesh_vertices_end(CollectionPropertyIterator *iter);
int Mesh_vertices_length(PointerRNA *ptr);
int Mesh_vertices_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int Mesh_use_mirror_x_get(PointerRNA *ptr);
void Mesh_use_mirror_x_set(PointerRNA *ptr, int value);

void Mesh_transform(struct Mesh *_self, float matrix[16], int shape_keys);
void Mesh_calc_normals(struct Mesh *_self);
void Mesh_calc_normals_split(struct Mesh *_self, float split_angle);
void Mesh_free_normals_split(struct Mesh *_self);
void Mesh_calc_tangents(struct Mesh *_self, ReportList *reports, const char * uvmap);
void Mesh_free_tangents(struct Mesh *_self);
void Mesh_calc_tessface(struct Mesh *_self);
void Mesh_calc_smooth_groups(struct Mesh *_self, int use_bitflags, int *poly_groups_len, int **poly_groups, int *groups);
void Mesh_update(struct Mesh *_self, bContext *C, int calc_edges, int calc_tessface);
const char * Mesh_unit_test_compare(struct Mesh *_self, struct Mesh *mesh);
int Mesh_validate(struct Mesh *_self, int verbose);
int Mesh_validate_material_indices(struct Mesh *_self);
/**************** Cache Modifier ****************/

extern StructRNA RNA_MeshCacheModifier;
extern StructRNA RNA_Modifier;

enum {
	MeshCacheModifier_deform_mode_OVERWRITE = 0,
	MeshCacheModifier_deform_mode_INTEGRATE = 1,
};

int MeshCacheModifier_deform_mode_get(PointerRNA *ptr);
void MeshCacheModifier_deform_mode_set(PointerRNA *ptr, int value);

float MeshCacheModifier_eval_factor_get(PointerRNA *ptr);
void MeshCacheModifier_eval_factor_set(PointerRNA *ptr, float value);

float MeshCacheModifier_eval_frame_get(PointerRNA *ptr);
void MeshCacheModifier_eval_frame_set(PointerRNA *ptr, float value);

float MeshCacheModifier_eval_time_get(PointerRNA *ptr);
void MeshCacheModifier_eval_time_set(PointerRNA *ptr, float value);

#define MeshCacheModifier_filepath_MAX 1024

void MeshCacheModifier_filepath_get(PointerRNA *ptr, char *value);
int MeshCacheModifier_filepath_length(PointerRNA *ptr);
void MeshCacheModifier_filepath_set(PointerRNA *ptr, const char *value);

enum {
	MeshCacheModifier_flip_axis_X = 1,
	MeshCacheModifier_flip_axis_Y = 2,
	MeshCacheModifier_flip_axis_Z = 4,
};

int MeshCacheModifier_flip_axis_get(PointerRNA *ptr);
void MeshCacheModifier_flip_axis_set(PointerRNA *ptr, int value);

enum {
	MeshCacheModifier_cache_format_MDD = 1,
	MeshCacheModifier_cache_format_PC2 = 2,
};

int MeshCacheModifier_cache_format_get(PointerRNA *ptr);
void MeshCacheModifier_cache_format_set(PointerRNA *ptr, int value);

enum {
	MeshCacheModifier_forward_axis_POS_X = 0,
	MeshCacheModifier_forward_axis_POS_Y = 1,
	MeshCacheModifier_forward_axis_POS_Z = 2,
	MeshCacheModifier_forward_axis_NEG_X = 3,
	MeshCacheModifier_forward_axis_NEG_Y = 4,
	MeshCacheModifier_forward_axis_NEG_Z = 5,
};

int MeshCacheModifier_forward_axis_get(PointerRNA *ptr);
void MeshCacheModifier_forward_axis_set(PointerRNA *ptr, int value);

float MeshCacheModifier_frame_scale_get(PointerRNA *ptr);
void MeshCacheModifier_frame_scale_set(PointerRNA *ptr, float value);

float MeshCacheModifier_frame_start_get(PointerRNA *ptr);
void MeshCacheModifier_frame_start_set(PointerRNA *ptr, float value);

float MeshCacheModifier_factor_get(PointerRNA *ptr);
void MeshCacheModifier_factor_set(PointerRNA *ptr, float value);

enum {
	MeshCacheModifier_interpolation_NONE = 0,
	MeshCacheModifier_interpolation_LINEAR = 1,
};

int MeshCacheModifier_interpolation_get(PointerRNA *ptr);
void MeshCacheModifier_interpolation_set(PointerRNA *ptr, int value);

enum {
	MeshCacheModifier_time_mode_FRAME = 0,
	MeshCacheModifier_time_mode_TIME = 1,
	MeshCacheModifier_time_mode_FACTOR = 2,
};

int MeshCacheModifier_time_mode_get(PointerRNA *ptr);
void MeshCacheModifier_time_mode_set(PointerRNA *ptr, int value);

enum {
	MeshCacheModifier_play_mode_SCENE = 0,
	MeshCacheModifier_play_mode_CUSTOM = 1,
};

int MeshCacheModifier_play_mode_get(PointerRNA *ptr);
void MeshCacheModifier_play_mode_set(PointerRNA *ptr, int value);

enum {
	MeshCacheModifier_up_axis_POS_X = 0,
	MeshCacheModifier_up_axis_POS_Y = 1,
	MeshCacheModifier_up_axis_POS_Z = 2,
	MeshCacheModifier_up_axis_NEG_X = 3,
	MeshCacheModifier_up_axis_NEG_Y = 4,
	MeshCacheModifier_up_axis_NEG_Z = 5,
};

int MeshCacheModifier_up_axis_get(PointerRNA *ptr);
void MeshCacheModifier_up_axis_set(PointerRNA *ptr, int value);

/**************** Mesh Vertex Color ****************/

extern StructRNA RNA_MeshColor;

PointerRNA MeshColor_rna_type_get(PointerRNA *ptr);

void MeshColor_color1_get(PointerRNA *ptr, float values[3]);
void MeshColor_color1_set(PointerRNA *ptr, const float values[3]);

void MeshColor_color2_get(PointerRNA *ptr, float values[3]);
void MeshColor_color2_set(PointerRNA *ptr, const float values[3]);

void MeshColor_color3_get(PointerRNA *ptr, float values[3]);
void MeshColor_color3_set(PointerRNA *ptr, const float values[3]);

void MeshColor_color4_get(PointerRNA *ptr, float values[3]);
void MeshColor_color4_set(PointerRNA *ptr, const float values[3]);

/**************** Mesh Vertex Color Layer ****************/

extern StructRNA RNA_MeshColorLayer;

PointerRNA MeshColorLayer_rna_type_get(PointerRNA *ptr);

#define MeshColorLayer_name_MAX 64

void MeshColorLayer_name_get(PointerRNA *ptr, char *value);
int MeshColorLayer_name_length(PointerRNA *ptr);
void MeshColorLayer_name_set(PointerRNA *ptr, const char *value);

int MeshColorLayer_active_get(PointerRNA *ptr);
void MeshColorLayer_active_set(PointerRNA *ptr, int value);

int MeshColorLayer_active_render_get(PointerRNA *ptr);
void MeshColorLayer_active_render_set(PointerRNA *ptr, int value);

void MeshColorLayer_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshColorLayer_data_next(CollectionPropertyIterator *iter);
void MeshColorLayer_data_end(CollectionPropertyIterator *iter);
int MeshColorLayer_data_length(PointerRNA *ptr);
int MeshColorLayer_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** MeshDeform Modifier ****************/

extern StructRNA RNA_MeshDeformModifier;
extern StructRNA RNA_Modifier;

int MeshDeformModifier_is_bound_get(PointerRNA *ptr);
void MeshDeformModifier_is_bound_set(PointerRNA *ptr, int value);

int MeshDeformModifier_use_dynamic_bind_get(PointerRNA *ptr);
void MeshDeformModifier_use_dynamic_bind_set(PointerRNA *ptr, int value);

int MeshDeformModifier_invert_vertex_group_get(PointerRNA *ptr);
void MeshDeformModifier_invert_vertex_group_set(PointerRNA *ptr, int value);

PointerRNA MeshDeformModifier_object_get(PointerRNA *ptr);

int MeshDeformModifier_precision_get(PointerRNA *ptr);
void MeshDeformModifier_precision_set(PointerRNA *ptr, int value);

#define MeshDeformModifier_vertex_group_MAX 64

void MeshDeformModifier_vertex_group_get(PointerRNA *ptr, char *value);
int MeshDeformModifier_vertex_group_length(PointerRNA *ptr);
void MeshDeformModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Mesh Edge ****************/

extern StructRNA RNA_MeshEdge;

PointerRNA MeshEdge_rna_type_get(PointerRNA *ptr);

float MeshEdge_bevel_weight_get(PointerRNA *ptr);
void MeshEdge_bevel_weight_set(PointerRNA *ptr, float value);

float MeshEdge_crease_get(PointerRNA *ptr);
void MeshEdge_crease_set(PointerRNA *ptr, float value);

int MeshEdge_use_freestyle_mark_get(PointerRNA *ptr);
void MeshEdge_use_freestyle_mark_set(PointerRNA *ptr, int value);

int MeshEdge_hide_get(PointerRNA *ptr);
void MeshEdge_hide_set(PointerRNA *ptr, int value);

int MeshEdge_index_get(PointerRNA *ptr);
void MeshEdge_index_set(PointerRNA *ptr, int value);

int MeshEdge_is_loose_get(PointerRNA *ptr);
void MeshEdge_is_loose_set(PointerRNA *ptr, int value);

int MeshEdge_use_seam_get(PointerRNA *ptr);
void MeshEdge_use_seam_set(PointerRNA *ptr, int value);

int MeshEdge_select_get(PointerRNA *ptr);
void MeshEdge_select_set(PointerRNA *ptr, int value);

int MeshEdge_use_edge_sharp_get(PointerRNA *ptr);
void MeshEdge_use_edge_sharp_set(PointerRNA *ptr, int value);

void MeshEdge_vertices_get(PointerRNA *ptr, int values[2]);
void MeshEdge_vertices_set(PointerRNA *ptr, const int values[2]);

/**************** Mesh Edges ****************/

extern StructRNA RNA_MeshEdges;

PointerRNA MeshEdges_rna_type_get(PointerRNA *ptr);

void MeshEdges_add(struct Mesh *_self, ReportList *reports, int count);
/**************** Mesh Float Property ****************/

extern StructRNA RNA_MeshFloatProperty;

PointerRNA MeshFloatProperty_rna_type_get(PointerRNA *ptr);

float MeshFloatProperty_value_get(PointerRNA *ptr);
void MeshFloatProperty_value_set(PointerRNA *ptr, float value);

/**************** Mesh Float Property Layer ****************/

extern StructRNA RNA_MeshFloatPropertyLayer;

PointerRNA MeshFloatPropertyLayer_rna_type_get(PointerRNA *ptr);

#define MeshFloatPropertyLayer_name_MAX 64

void MeshFloatPropertyLayer_name_get(PointerRNA *ptr, char *value);
int MeshFloatPropertyLayer_name_length(PointerRNA *ptr);
void MeshFloatPropertyLayer_name_set(PointerRNA *ptr, const char *value);

void MeshFloatPropertyLayer_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshFloatPropertyLayer_data_next(CollectionPropertyIterator *iter);
void MeshFloatPropertyLayer_data_end(CollectionPropertyIterator *iter);
int MeshFloatPropertyLayer_data_length(PointerRNA *ptr);
int MeshFloatPropertyLayer_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Mesh Int Property ****************/

extern StructRNA RNA_MeshIntProperty;

PointerRNA MeshIntProperty_rna_type_get(PointerRNA *ptr);

int MeshIntProperty_value_get(PointerRNA *ptr);
void MeshIntProperty_value_set(PointerRNA *ptr, int value);

/**************** Mesh Int Property Layer ****************/

extern StructRNA RNA_MeshIntPropertyLayer;

PointerRNA MeshIntPropertyLayer_rna_type_get(PointerRNA *ptr);

#define MeshIntPropertyLayer_name_MAX 64

void MeshIntPropertyLayer_name_get(PointerRNA *ptr, char *value);
int MeshIntPropertyLayer_name_length(PointerRNA *ptr);
void MeshIntPropertyLayer_name_set(PointerRNA *ptr, const char *value);

void MeshIntPropertyLayer_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshIntPropertyLayer_data_next(CollectionPropertyIterator *iter);
void MeshIntPropertyLayer_data_end(CollectionPropertyIterator *iter);
int MeshIntPropertyLayer_data_length(PointerRNA *ptr);
int MeshIntPropertyLayer_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Mesh Loop ****************/

extern StructRNA RNA_MeshLoop;

PointerRNA MeshLoop_rna_type_get(PointerRNA *ptr);

void MeshLoop_bitangent_get(PointerRNA *ptr, float values[3]);
void MeshLoop_bitangent_set(PointerRNA *ptr, const float values[3]);

float MeshLoop_bitangent_sign_get(PointerRNA *ptr);
void MeshLoop_bitangent_sign_set(PointerRNA *ptr, float value);

int MeshLoop_edge_index_get(PointerRNA *ptr);
void MeshLoop_edge_index_set(PointerRNA *ptr, int value);

int MeshLoop_index_get(PointerRNA *ptr);
void MeshLoop_index_set(PointerRNA *ptr, int value);

void MeshLoop_normal_get(PointerRNA *ptr, float values[3]);
void MeshLoop_normal_set(PointerRNA *ptr, const float values[3]);

void MeshLoop_tangent_get(PointerRNA *ptr, float values[3]);
void MeshLoop_tangent_set(PointerRNA *ptr, const float values[3]);

int MeshLoop_vertex_index_get(PointerRNA *ptr);
void MeshLoop_vertex_index_set(PointerRNA *ptr, int value);

/**************** Mesh Vertex Color ****************/

extern StructRNA RNA_MeshLoopColor;

PointerRNA MeshLoopColor_rna_type_get(PointerRNA *ptr);

void MeshLoopColor_color_get(PointerRNA *ptr, float values[3]);
void MeshLoopColor_color_set(PointerRNA *ptr, const float values[3]);

/**************** Mesh Vertex Color Layer ****************/

extern StructRNA RNA_MeshLoopColorLayer;

PointerRNA MeshLoopColorLayer_rna_type_get(PointerRNA *ptr);

#define MeshLoopColorLayer_name_MAX 64

void MeshLoopColorLayer_name_get(PointerRNA *ptr, char *value);
int MeshLoopColorLayer_name_length(PointerRNA *ptr);
void MeshLoopColorLayer_name_set(PointerRNA *ptr, const char *value);

int MeshLoopColorLayer_active_get(PointerRNA *ptr);
void MeshLoopColorLayer_active_set(PointerRNA *ptr, int value);

int MeshLoopColorLayer_active_render_get(PointerRNA *ptr);
void MeshLoopColorLayer_active_render_set(PointerRNA *ptr, int value);

void MeshLoopColorLayer_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshLoopColorLayer_data_next(CollectionPropertyIterator *iter);
void MeshLoopColorLayer_data_end(CollectionPropertyIterator *iter);
int MeshLoopColorLayer_data_length(PointerRNA *ptr);
int MeshLoopColorLayer_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Mesh Loops ****************/

extern StructRNA RNA_MeshLoops;

PointerRNA MeshLoops_rna_type_get(PointerRNA *ptr);

void MeshLoops_add(struct Mesh *_self, ReportList *reports, int count);
/**************** Mesh Polygon ****************/

extern StructRNA RNA_MeshPolygon;

PointerRNA MeshPolygon_rna_type_get(PointerRNA *ptr);

int MeshPolygon_use_freestyle_mark_get(PointerRNA *ptr);
void MeshPolygon_use_freestyle_mark_set(PointerRNA *ptr, int value);

int MeshPolygon_hide_get(PointerRNA *ptr);
void MeshPolygon_hide_set(PointerRNA *ptr, int value);

int MeshPolygon_index_get(PointerRNA *ptr);
void MeshPolygon_index_set(PointerRNA *ptr, int value);

int MeshPolygon_loop_start_get(PointerRNA *ptr);
void MeshPolygon_loop_start_set(PointerRNA *ptr, int value);

int MeshPolygon_loop_total_get(PointerRNA *ptr);
void MeshPolygon_loop_total_set(PointerRNA *ptr, int value);

int MeshPolygon_material_index_get(PointerRNA *ptr);
void MeshPolygon_material_index_set(PointerRNA *ptr, int value);

float MeshPolygon_area_get(PointerRNA *ptr);
void MeshPolygon_area_set(PointerRNA *ptr, float value);

void MeshPolygon_center_get(PointerRNA *ptr, float values[3]);
void MeshPolygon_center_set(PointerRNA *ptr, const float values[3]);

void MeshPolygon_normal_get(PointerRNA *ptr, float values[3]);
void MeshPolygon_normal_set(PointerRNA *ptr, const float values[3]);

int MeshPolygon_select_get(PointerRNA *ptr);
void MeshPolygon_select_set(PointerRNA *ptr, int value);

int MeshPolygon_use_smooth_get(PointerRNA *ptr);
void MeshPolygon_use_smooth_set(PointerRNA *ptr, int value);

void MeshPolygon_vertices_get(PointerRNA *ptr, int values[3]);
void MeshPolygon_vertices_set(PointerRNA *ptr, const int values[3]);
int MeshPolygon_vertices_get_length(PointerRNA *ptr, int *arraylen);

/**************** Mesh Polygons ****************/

extern StructRNA RNA_MeshPolygons;

PointerRNA MeshPolygons_rna_type_get(PointerRNA *ptr);

int MeshPolygons_active_get(PointerRNA *ptr);
void MeshPolygons_active_set(PointerRNA *ptr, int value);

void MeshPolygons_add(struct Mesh *_self, ReportList *reports, int count);
/**************** Skin Vertex ****************/

extern StructRNA RNA_MeshSkinVertex;

PointerRNA MeshSkinVertex_rna_type_get(PointerRNA *ptr);

int MeshSkinVertex_use_loose_get(PointerRNA *ptr);
void MeshSkinVertex_use_loose_set(PointerRNA *ptr, int value);

void MeshSkinVertex_radius_get(PointerRNA *ptr, float values[2]);
void MeshSkinVertex_radius_set(PointerRNA *ptr, const float values[2]);

int MeshSkinVertex_use_root_get(PointerRNA *ptr);
void MeshSkinVertex_use_root_set(PointerRNA *ptr, int value);

/**************** Mesh Skin Vertex Layer ****************/

extern StructRNA RNA_MeshSkinVertexLayer;

PointerRNA MeshSkinVertexLayer_rna_type_get(PointerRNA *ptr);

#define MeshSkinVertexLayer_name_MAX 64

void MeshSkinVertexLayer_name_get(PointerRNA *ptr, char *value);
int MeshSkinVertexLayer_name_length(PointerRNA *ptr);
void MeshSkinVertexLayer_name_set(PointerRNA *ptr, const char *value);

void MeshSkinVertexLayer_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshSkinVertexLayer_data_next(CollectionPropertyIterator *iter);
void MeshSkinVertexLayer_data_end(CollectionPropertyIterator *iter);
int MeshSkinVertexLayer_data_length(PointerRNA *ptr);
int MeshSkinVertexLayer_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Mesh Visualize Statistics ****************/

extern StructRNA RNA_MeshStatVis;

PointerRNA MeshStatVis_rna_type_get(PointerRNA *ptr);

enum {
	MeshStatVis_overhang_axis_POS_X = 0,
	MeshStatVis_overhang_axis_POS_Y = 1,
	MeshStatVis_overhang_axis_POS_Z = 2,
	MeshStatVis_overhang_axis_NEG_X = 3,
	MeshStatVis_overhang_axis_NEG_Y = 4,
	MeshStatVis_overhang_axis_NEG_Z = 5,
};

int MeshStatVis_overhang_axis_get(PointerRNA *ptr);
void MeshStatVis_overhang_axis_set(PointerRNA *ptr, int value);

float MeshStatVis_distort_max_get(PointerRNA *ptr);
void MeshStatVis_distort_max_set(PointerRNA *ptr, float value);

float MeshStatVis_sharp_max_get(PointerRNA *ptr);
void MeshStatVis_sharp_max_set(PointerRNA *ptr, float value);

float MeshStatVis_distort_min_get(PointerRNA *ptr);
void MeshStatVis_distort_min_set(PointerRNA *ptr, float value);

float MeshStatVis_sharp_min_get(PointerRNA *ptr);
void MeshStatVis_sharp_min_set(PointerRNA *ptr, float value);

float MeshStatVis_overhang_max_get(PointerRNA *ptr);
void MeshStatVis_overhang_max_set(PointerRNA *ptr, float value);

float MeshStatVis_overhang_min_get(PointerRNA *ptr);
void MeshStatVis_overhang_min_set(PointerRNA *ptr, float value);

int MeshStatVis_thickness_samples_get(PointerRNA *ptr);
void MeshStatVis_thickness_samples_set(PointerRNA *ptr, int value);

float MeshStatVis_thickness_max_get(PointerRNA *ptr);
void MeshStatVis_thickness_max_set(PointerRNA *ptr, float value);

float MeshStatVis_thickness_min_get(PointerRNA *ptr);
void MeshStatVis_thickness_min_set(PointerRNA *ptr, float value);

enum {
	MeshStatVis_type_OVERHANG = 0,
	MeshStatVis_type_THICKNESS = 1,
	MeshStatVis_type_INTERSECT = 2,
	MeshStatVis_type_DISTORT = 3,
	MeshStatVis_type_SHARP = 4,
};

int MeshStatVis_type_get(PointerRNA *ptr);
void MeshStatVis_type_set(PointerRNA *ptr, int value);

/**************** Mesh String Property ****************/

extern StructRNA RNA_MeshStringProperty;

PointerRNA MeshStringProperty_rna_type_get(PointerRNA *ptr);

#define MeshStringProperty_value_MAX 255

void MeshStringProperty_value_get(PointerRNA *ptr, char *value);
int MeshStringProperty_value_length(PointerRNA *ptr);
void MeshStringProperty_value_set(PointerRNA *ptr, const char *value);

/**************** Mesh String Property Layer ****************/

extern StructRNA RNA_MeshStringPropertyLayer;

PointerRNA MeshStringPropertyLayer_rna_type_get(PointerRNA *ptr);

#define MeshStringPropertyLayer_name_MAX 64

void MeshStringPropertyLayer_name_get(PointerRNA *ptr, char *value);
int MeshStringPropertyLayer_name_length(PointerRNA *ptr);
void MeshStringPropertyLayer_name_set(PointerRNA *ptr, const char *value);

void MeshStringPropertyLayer_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshStringPropertyLayer_data_next(CollectionPropertyIterator *iter);
void MeshStringPropertyLayer_data_end(CollectionPropertyIterator *iter);
int MeshStringPropertyLayer_data_length(PointerRNA *ptr);
int MeshStringPropertyLayer_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Mesh TessFace ****************/

extern StructRNA RNA_MeshTessFace;

PointerRNA MeshTessFace_rna_type_get(PointerRNA *ptr);

float MeshTessFace_area_get(PointerRNA *ptr);
void MeshTessFace_area_set(PointerRNA *ptr, float value);

void MeshTessFace_normal_get(PointerRNA *ptr, float values[3]);
void MeshTessFace_normal_set(PointerRNA *ptr, const float values[3]);

int MeshTessFace_hide_get(PointerRNA *ptr);
void MeshTessFace_hide_set(PointerRNA *ptr, int value);

int MeshTessFace_index_get(PointerRNA *ptr);
void MeshTessFace_index_set(PointerRNA *ptr, int value);

int MeshTessFace_material_index_get(PointerRNA *ptr);
void MeshTessFace_material_index_set(PointerRNA *ptr, int value);

int MeshTessFace_select_get(PointerRNA *ptr);
void MeshTessFace_select_set(PointerRNA *ptr, int value);

int MeshTessFace_use_smooth_get(PointerRNA *ptr);
void MeshTessFace_use_smooth_set(PointerRNA *ptr, int value);

void MeshTessFace_split_normals_get(PointerRNA *ptr, float values[12]);
void MeshTessFace_split_normals_set(PointerRNA *ptr, const float values[12]);

void MeshTessFace_vertices_get(PointerRNA *ptr, int values[4]);
void MeshTessFace_vertices_set(PointerRNA *ptr, const int values[4]);
int MeshTessFace_vertices_get_length(PointerRNA *ptr, int *arraylen);

void MeshTessFace_vertices_raw_get(PointerRNA *ptr, int values[4]);
void MeshTessFace_vertices_raw_set(PointerRNA *ptr, const int values[4]);

/**************** Mesh Faces ****************/

extern StructRNA RNA_MeshTessFaces;

PointerRNA MeshTessFaces_rna_type_get(PointerRNA *ptr);

int MeshTessFaces_active_get(PointerRNA *ptr);
void MeshTessFaces_active_set(PointerRNA *ptr, int value);

void MeshTessFaces_add(struct Mesh *_self, ReportList *reports, int count);
/**************** Mesh UV Map Face ****************/

extern StructRNA RNA_MeshTextureFace;

PointerRNA MeshTextureFace_rna_type_get(PointerRNA *ptr);

PointerRNA MeshTextureFace_image_get(PointerRNA *ptr);

void MeshTextureFace_uv_get(PointerRNA *ptr, float values[8]);
void MeshTextureFace_uv_set(PointerRNA *ptr, const float values[8]);
int MeshTextureFace_uv_get_length(PointerRNA *ptr, int *arraylen);

void MeshTextureFace_uv1_get(PointerRNA *ptr, float values[2]);
void MeshTextureFace_uv1_set(PointerRNA *ptr, const float values[2]);

void MeshTextureFace_uv2_get(PointerRNA *ptr, float values[2]);
void MeshTextureFace_uv2_set(PointerRNA *ptr, const float values[2]);

void MeshTextureFace_uv3_get(PointerRNA *ptr, float values[2]);
void MeshTextureFace_uv3_set(PointerRNA *ptr, const float values[2]);

void MeshTextureFace_uv4_get(PointerRNA *ptr, float values[2]);
void MeshTextureFace_uv4_set(PointerRNA *ptr, const float values[2]);

void MeshTextureFace_uv_raw_get(PointerRNA *ptr, float values[8]);
void MeshTextureFace_uv_raw_set(PointerRNA *ptr, const float values[8]);

/**************** Mesh UV Map ****************/

extern StructRNA RNA_MeshTextureFaceLayer;

PointerRNA MeshTextureFaceLayer_rna_type_get(PointerRNA *ptr);

#define MeshTextureFaceLayer_name_MAX 64

void MeshTextureFaceLayer_name_get(PointerRNA *ptr, char *value);
int MeshTextureFaceLayer_name_length(PointerRNA *ptr);
void MeshTextureFaceLayer_name_set(PointerRNA *ptr, const char *value);

int MeshTextureFaceLayer_active_get(PointerRNA *ptr);
void MeshTextureFaceLayer_active_set(PointerRNA *ptr, int value);

int MeshTextureFaceLayer_active_clone_get(PointerRNA *ptr);
void MeshTextureFaceLayer_active_clone_set(PointerRNA *ptr, int value);

int MeshTextureFaceLayer_active_render_get(PointerRNA *ptr);
void MeshTextureFaceLayer_active_render_set(PointerRNA *ptr, int value);

void MeshTextureFaceLayer_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshTextureFaceLayer_data_next(CollectionPropertyIterator *iter);
void MeshTextureFaceLayer_data_end(CollectionPropertyIterator *iter);
int MeshTextureFaceLayer_data_length(PointerRNA *ptr);
int MeshTextureFaceLayer_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Mesh UV Map Face ****************/

extern StructRNA RNA_MeshTexturePoly;

PointerRNA MeshTexturePoly_rna_type_get(PointerRNA *ptr);

PointerRNA MeshTexturePoly_image_get(PointerRNA *ptr);

/**************** Mesh UV Map ****************/

extern StructRNA RNA_MeshTexturePolyLayer;

PointerRNA MeshTexturePolyLayer_rna_type_get(PointerRNA *ptr);

#define MeshTexturePolyLayer_name_MAX 64

void MeshTexturePolyLayer_name_get(PointerRNA *ptr, char *value);
int MeshTexturePolyLayer_name_length(PointerRNA *ptr);
void MeshTexturePolyLayer_name_set(PointerRNA *ptr, const char *value);

int MeshTexturePolyLayer_active_get(PointerRNA *ptr);
void MeshTexturePolyLayer_active_set(PointerRNA *ptr, int value);

int MeshTexturePolyLayer_active_clone_get(PointerRNA *ptr);
void MeshTexturePolyLayer_active_clone_set(PointerRNA *ptr, int value);

int MeshTexturePolyLayer_active_render_get(PointerRNA *ptr);
void MeshTexturePolyLayer_active_render_set(PointerRNA *ptr, int value);

void MeshTexturePolyLayer_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshTexturePolyLayer_data_next(CollectionPropertyIterator *iter);
void MeshTexturePolyLayer_data_end(CollectionPropertyIterator *iter);
int MeshTexturePolyLayer_data_length(PointerRNA *ptr);
int MeshTexturePolyLayer_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** MeshUVLoop ****************/

extern StructRNA RNA_MeshUVLoop;

PointerRNA MeshUVLoop_rna_type_get(PointerRNA *ptr);

int MeshUVLoop_select_edge_get(PointerRNA *ptr);
void MeshUVLoop_select_edge_set(PointerRNA *ptr, int value);

int MeshUVLoop_pin_uv_get(PointerRNA *ptr);
void MeshUVLoop_pin_uv_set(PointerRNA *ptr, int value);

int MeshUVLoop_select_get(PointerRNA *ptr);
void MeshUVLoop_select_set(PointerRNA *ptr, int value);

void MeshUVLoop_uv_get(PointerRNA *ptr, float values[2]);
void MeshUVLoop_uv_set(PointerRNA *ptr, const float values[2]);

/**************** MeshUVLoopLayer ****************/

extern StructRNA RNA_MeshUVLoopLayer;

PointerRNA MeshUVLoopLayer_rna_type_get(PointerRNA *ptr);

#define MeshUVLoopLayer_name_MAX 64

void MeshUVLoopLayer_name_get(PointerRNA *ptr, char *value);
int MeshUVLoopLayer_name_length(PointerRNA *ptr);
void MeshUVLoopLayer_name_set(PointerRNA *ptr, const char *value);

void MeshUVLoopLayer_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshUVLoopLayer_data_next(CollectionPropertyIterator *iter);
void MeshUVLoopLayer_data_end(CollectionPropertyIterator *iter);
int MeshUVLoopLayer_data_length(PointerRNA *ptr);
int MeshUVLoopLayer_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Mesh Vertex ****************/

extern StructRNA RNA_MeshVertex;

PointerRNA MeshVertex_rna_type_get(PointerRNA *ptr);

float MeshVertex_bevel_weight_get(PointerRNA *ptr);
void MeshVertex_bevel_weight_set(PointerRNA *ptr, float value);

void MeshVertex_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MeshVertex_groups_next(CollectionPropertyIterator *iter);
void MeshVertex_groups_end(CollectionPropertyIterator *iter);

int MeshVertex_hide_get(PointerRNA *ptr);
void MeshVertex_hide_set(PointerRNA *ptr, int value);

int MeshVertex_index_get(PointerRNA *ptr);
void MeshVertex_index_set(PointerRNA *ptr, int value);

void MeshVertex_co_get(PointerRNA *ptr, float values[3]);
void MeshVertex_co_set(PointerRNA *ptr, const float values[3]);

void MeshVertex_normal_get(PointerRNA *ptr, float values[3]);
void MeshVertex_normal_set(PointerRNA *ptr, const float values[3]);

int MeshVertex_select_get(PointerRNA *ptr);
void MeshVertex_select_set(PointerRNA *ptr, int value);

void MeshVertex_undeformed_co_get(PointerRNA *ptr, float values[3]);
void MeshVertex_undeformed_co_set(PointerRNA *ptr, const float values[3]);

/**************** Mesh Vertices ****************/

extern StructRNA RNA_MeshVertices;

PointerRNA MeshVertices_rna_type_get(PointerRNA *ptr);

void MeshVertices_add(struct Mesh *_self, ReportList *reports, int count);
/**************** Message Actuator ****************/

extern StructRNA RNA_MessageActuator;
extern StructRNA RNA_Actuator;

enum {
	MessageActuator_body_type_TEXT = 0,
	MessageActuator_body_type_PROPERTY = 1,
};

int MessageActuator_body_type_get(PointerRNA *ptr);
void MessageActuator_body_type_set(PointerRNA *ptr, int value);

#define MessageActuator_body_message_MAX 64

void MessageActuator_body_message_get(PointerRNA *ptr, char *value);
int MessageActuator_body_message_length(PointerRNA *ptr);
void MessageActuator_body_message_set(PointerRNA *ptr, const char *value);

#define MessageActuator_body_property_MAX 64

void MessageActuator_body_property_get(PointerRNA *ptr, char *value);
int MessageActuator_body_property_length(PointerRNA *ptr);
void MessageActuator_body_property_set(PointerRNA *ptr, const char *value);

#define MessageActuator_subject_MAX 64

void MessageActuator_subject_get(PointerRNA *ptr, char *value);
int MessageActuator_subject_length(PointerRNA *ptr);
void MessageActuator_subject_set(PointerRNA *ptr, const char *value);

#define MessageActuator_to_property_MAX 64

void MessageActuator_to_property_get(PointerRNA *ptr, char *value);
int MessageActuator_to_property_length(PointerRNA *ptr);
void MessageActuator_to_property_set(PointerRNA *ptr, const char *value);

/**************** Message Sensor ****************/

extern StructRNA RNA_MessageSensor;
extern StructRNA RNA_Sensor;

#define MessageSensor_subject_MAX 64

void MessageSensor_subject_get(PointerRNA *ptr, char *value);
int MessageSensor_subject_length(PointerRNA *ptr);
void MessageSensor_subject_set(PointerRNA *ptr, const char *value);

/**************** MetaBall ****************/

extern StructRNA RNA_MetaBall;
extern StructRNA RNA_ID;

PointerRNA MetaBall_animation_data_get(PointerRNA *ptr);

int MetaBall_use_auto_texspace_get(PointerRNA *ptr);
void MetaBall_use_auto_texspace_set(PointerRNA *ptr, int value);

void MetaBall_elements_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MetaBall_elements_next(CollectionPropertyIterator *iter);
void MetaBall_elements_end(CollectionPropertyIterator *iter);
int MetaBall_elements_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int MetaBall_is_editmode_get(PointerRNA *ptr);
void MetaBall_is_editmode_set(PointerRNA *ptr, int value);

void MetaBall_materials_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MetaBall_materials_next(CollectionPropertyIterator *iter);
void MetaBall_materials_end(CollectionPropertyIterator *iter);
int MetaBall_materials_length(PointerRNA *ptr);
int MetaBall_materials_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int MetaBall_materials_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float MetaBall_render_resolution_get(PointerRNA *ptr);
void MetaBall_render_resolution_set(PointerRNA *ptr, float value);

void MetaBall_texspace_location_get(PointerRNA *ptr, float values[3]);
void MetaBall_texspace_location_set(PointerRNA *ptr, const float values[3]);

void MetaBall_texspace_size_get(PointerRNA *ptr, float values[3]);
void MetaBall_texspace_size_set(PointerRNA *ptr, const float values[3]);

float MetaBall_threshold_get(PointerRNA *ptr);
void MetaBall_threshold_set(PointerRNA *ptr, float value);

enum {
	MetaBall_update_method_UPDATE_ALWAYS = 0,
	MetaBall_update_method_HALFRES = 1,
	MetaBall_update_method_FAST = 2,
	MetaBall_update_method_NEVER = 3,
};

int MetaBall_update_method_get(PointerRNA *ptr);
void MetaBall_update_method_set(PointerRNA *ptr, int value);

float MetaBall_resolution_get(PointerRNA *ptr);
void MetaBall_resolution_set(PointerRNA *ptr, float value);

void MetaBall_transform(struct MetaBall *_self, float matrix[16]);
/**************** Meta Elements ****************/

extern StructRNA RNA_MetaBallElements;

PointerRNA MetaBallElements_rna_type_get(PointerRNA *ptr);

PointerRNA MetaBallElements_active_get(PointerRNA *ptr);

struct MetaElem *MetaBallElements_new(struct MetaBall *_self, int type);
void MetaBallElements_remove(struct MetaBall *_self, ReportList *reports, struct PointerRNA *element);
void MetaBallElements_clear(struct MetaBall *_self);
/**************** Meta Element ****************/

extern StructRNA RNA_MetaElement;

PointerRNA MetaElement_rna_type_get(PointerRNA *ptr);

int MetaElement_hide_get(PointerRNA *ptr);
void MetaElement_hide_set(PointerRNA *ptr, int value);

void MetaElement_co_get(PointerRNA *ptr, float values[3]);
void MetaElement_co_set(PointerRNA *ptr, const float values[3]);

int MetaElement_use_negative_get(PointerRNA *ptr);
void MetaElement_use_negative_set(PointerRNA *ptr, int value);

float MetaElement_radius_get(PointerRNA *ptr);
void MetaElement_radius_set(PointerRNA *ptr, float value);

void MetaElement_rotation_get(PointerRNA *ptr, float values[4]);
void MetaElement_rotation_set(PointerRNA *ptr, const float values[4]);

float MetaElement_size_x_get(PointerRNA *ptr);
void MetaElement_size_x_set(PointerRNA *ptr, float value);

float MetaElement_size_y_get(PointerRNA *ptr);
void MetaElement_size_y_set(PointerRNA *ptr, float value);

float MetaElement_size_z_get(PointerRNA *ptr);
void MetaElement_size_z_set(PointerRNA *ptr, float value);

float MetaElement_stiffness_get(PointerRNA *ptr);
void MetaElement_stiffness_set(PointerRNA *ptr, float value);

enum {
	MetaElement_type_BALL = 0,
	MetaElement_type_CAPSULE = 4,
	MetaElement_type_PLANE = 5,
	MetaElement_type_ELLIPSOID = 6,
	MetaElement_type_CUBE = 7,
};

int MetaElement_type_get(PointerRNA *ptr);
void MetaElement_type_set(PointerRNA *ptr, int value);

/**************** Meta Sequence ****************/

extern StructRNA RNA_MetaSequence;
extern StructRNA RNA_Sequence;

enum {
	MetaSequence_alpha_mode_STRAIGHT = 0,
	MetaSequence_alpha_mode_PREMUL = 1,
};

int MetaSequence_alpha_mode_get(PointerRNA *ptr);
void MetaSequence_alpha_mode_set(PointerRNA *ptr, int value);

int MetaSequence_animation_offset_end_get(PointerRNA *ptr);
void MetaSequence_animation_offset_end_set(PointerRNA *ptr, int value);

int MetaSequence_animation_offset_start_get(PointerRNA *ptr);
void MetaSequence_animation_offset_start_set(PointerRNA *ptr, int value);

int MetaSequence_use_float_get(PointerRNA *ptr);
void MetaSequence_use_float_set(PointerRNA *ptr, int value);

PointerRNA MetaSequence_crop_get(PointerRNA *ptr);

int MetaSequence_use_deinterlace_get(PointerRNA *ptr);
void MetaSequence_use_deinterlace_set(PointerRNA *ptr, int value);

int MetaSequence_use_reverse_frames_get(PointerRNA *ptr);
void MetaSequence_use_reverse_frames_set(PointerRNA *ptr, int value);

int MetaSequence_use_flip_x_get(PointerRNA *ptr);
void MetaSequence_use_flip_x_set(PointerRNA *ptr, int value);

int MetaSequence_use_flip_y_get(PointerRNA *ptr);
void MetaSequence_use_flip_y_set(PointerRNA *ptr, int value);

float MetaSequence_color_multiply_get(PointerRNA *ptr);
void MetaSequence_color_multiply_set(PointerRNA *ptr, float value);

PointerRNA MetaSequence_proxy_get(PointerRNA *ptr);

int MetaSequence_use_proxy_custom_directory_get(PointerRNA *ptr);
void MetaSequence_use_proxy_custom_directory_set(PointerRNA *ptr, int value);

int MetaSequence_use_proxy_custom_file_get(PointerRNA *ptr);
void MetaSequence_use_proxy_custom_file_set(PointerRNA *ptr, int value);

float MetaSequence_color_saturation_get(PointerRNA *ptr);
void MetaSequence_color_saturation_set(PointerRNA *ptr, float value);

void MetaSequence_sequences_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MetaSequence_sequences_next(CollectionPropertyIterator *iter);
void MetaSequence_sequences_end(CollectionPropertyIterator *iter);
int MetaSequence_sequences_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int MetaSequence_sequences_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float MetaSequence_strobe_get(PointerRNA *ptr);
void MetaSequence_strobe_set(PointerRNA *ptr, float value);

PointerRNA MetaSequence_transform_get(PointerRNA *ptr);

int MetaSequence_use_crop_get(PointerRNA *ptr);
void MetaSequence_use_crop_set(PointerRNA *ptr, int value);

int MetaSequence_use_proxy_get(PointerRNA *ptr);
void MetaSequence_use_proxy_set(PointerRNA *ptr, int value);

int MetaSequence_use_translation_get(PointerRNA *ptr);
void MetaSequence_use_translation_set(PointerRNA *ptr, int value);

/**************** Mirror Modifier ****************/

extern StructRNA RNA_MirrorModifier;
extern StructRNA RNA_Modifier;

int MirrorModifier_use_clip_get(PointerRNA *ptr);
void MirrorModifier_use_clip_set(PointerRNA *ptr, int value);

float MirrorModifier_merge_threshold_get(PointerRNA *ptr);
void MirrorModifier_merge_threshold_set(PointerRNA *ptr, float value);

int MirrorModifier_use_mirror_merge_get(PointerRNA *ptr);
void MirrorModifier_use_mirror_merge_set(PointerRNA *ptr, int value);

PointerRNA MirrorModifier_mirror_object_get(PointerRNA *ptr);

int MirrorModifier_use_mirror_u_get(PointerRNA *ptr);
void MirrorModifier_use_mirror_u_set(PointerRNA *ptr, int value);

int MirrorModifier_use_mirror_v_get(PointerRNA *ptr);
void MirrorModifier_use_mirror_v_set(PointerRNA *ptr, int value);

int MirrorModifier_use_mirror_vertex_groups_get(PointerRNA *ptr);
void MirrorModifier_use_mirror_vertex_groups_set(PointerRNA *ptr, int value);

int MirrorModifier_use_x_get(PointerRNA *ptr);
void MirrorModifier_use_x_set(PointerRNA *ptr, int value);

int MirrorModifier_use_y_get(PointerRNA *ptr);
void MirrorModifier_use_y_set(PointerRNA *ptr, int value);

int MirrorModifier_use_z_get(PointerRNA *ptr);
void MirrorModifier_use_z_set(PointerRNA *ptr, int value);

/**************** Modifier ****************/

extern StructRNA RNA_Modifier;

PointerRNA Modifier_rna_type_get(PointerRNA *ptr);

#define Modifier_name_MAX 64

void Modifier_name_get(PointerRNA *ptr, char *value);
int Modifier_name_length(PointerRNA *ptr);
void Modifier_name_set(PointerRNA *ptr, const char *value);

int Modifier_use_apply_on_spline_get(PointerRNA *ptr);
void Modifier_use_apply_on_spline_set(PointerRNA *ptr, int value);

int Modifier_show_in_editmode_get(PointerRNA *ptr);
void Modifier_show_in_editmode_set(PointerRNA *ptr, int value);

int Modifier_show_expanded_get(PointerRNA *ptr);
void Modifier_show_expanded_set(PointerRNA *ptr, int value);

int Modifier_show_on_cage_get(PointerRNA *ptr);
void Modifier_show_on_cage_set(PointerRNA *ptr, int value);

int Modifier_show_viewport_get(PointerRNA *ptr);
void Modifier_show_viewport_set(PointerRNA *ptr, int value);

int Modifier_show_render_get(PointerRNA *ptr);
void Modifier_show_render_set(PointerRNA *ptr, int value);

enum {
	Modifier_type_MESH_CACHE = 46,
	Modifier_type_UV_PROJECT = 15,
	Modifier_type_UV_WARP = 45,
	Modifier_type_VERTEX_WEIGHT_EDIT = 36,
	Modifier_type_VERTEX_WEIGHT_MIX = 37,
	Modifier_type_VERTEX_WEIGHT_PROXIMITY = 38,
	Modifier_type_ARRAY = 12,
	Modifier_type_BEVEL = 24,
	Modifier_type_BOOLEAN = 11,
	Modifier_type_BUILD = 4,
	Modifier_type_DECIMATE = 6,
	Modifier_type_EDGE_SPLIT = 13,
	Modifier_type_MASK = 27,
	Modifier_type_MIRROR = 5,
	Modifier_type_MULTIRES = 29,
	Modifier_type_REMESH = 41,
	Modifier_type_SCREW = 34,
	Modifier_type_SKIN = 42,
	Modifier_type_SOLIDIFY = 33,
	Modifier_type_SUBSURF = 1,
	Modifier_type_TRIANGULATE = 44,
	Modifier_type_WIREFRAME = 48,
	Modifier_type_ARMATURE = 8,
	Modifier_type_CAST = 17,
	Modifier_type_CURVE = 3,
	Modifier_type_DISPLACE = 14,
	Modifier_type_HOOK = 9,
	Modifier_type_LAPLACIANSMOOTH = 43,
	Modifier_type_LAPLACIANDEFORM = 47,
	Modifier_type_LATTICE = 2,
	Modifier_type_MESH_DEFORM = 18,
	Modifier_type_SHRINKWRAP = 25,
	Modifier_type_SIMPLE_DEFORM = 28,
	Modifier_type_SMOOTH = 16,
	Modifier_type_WARP = 35,
	Modifier_type_WAVE = 7,
	Modifier_type_CLOTH = 22,
	Modifier_type_COLLISION = 23,
	Modifier_type_DYNAMIC_PAINT = 40,
	Modifier_type_EXPLODE = 21,
	Modifier_type_FLUID_SIMULATION = 26,
	Modifier_type_OCEAN = 39,
	Modifier_type_PARTICLE_INSTANCE = 20,
	Modifier_type_PARTICLE_SYSTEM = 19,
	Modifier_type_SMOKE = 31,
	Modifier_type_SOFT_BODY = 10,
	Modifier_type_SURFACE = 30,
};

int Modifier_type_get(PointerRNA *ptr);
void Modifier_type_set(PointerRNA *ptr, int value);

/**************** Motion Path ****************/

extern StructRNA RNA_MotionPath;

PointerRNA MotionPath_rna_type_get(PointerRNA *ptr);

int MotionPath_is_modified_get(PointerRNA *ptr);
void MotionPath_is_modified_set(PointerRNA *ptr, int value);

int MotionPath_frame_end_get(PointerRNA *ptr);
void MotionPath_frame_end_set(PointerRNA *ptr, int value);

int MotionPath_length_get(PointerRNA *ptr);
void MotionPath_length_set(PointerRNA *ptr, int value);

void MotionPath_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MotionPath_points_next(CollectionPropertyIterator *iter);
void MotionPath_points_end(CollectionPropertyIterator *iter);
int MotionPath_points_length(PointerRNA *ptr);
int MotionPath_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int MotionPath_frame_start_get(PointerRNA *ptr);
void MotionPath_frame_start_set(PointerRNA *ptr, int value);

int MotionPath_use_bone_head_get(PointerRNA *ptr);
void MotionPath_use_bone_head_set(PointerRNA *ptr, int value);

/**************** Motion Path Cache Point ****************/

extern StructRNA RNA_MotionPathVert;

PointerRNA MotionPathVert_rna_type_get(PointerRNA *ptr);

void MotionPathVert_co_get(PointerRNA *ptr, float values[3]);
void MotionPathVert_co_set(PointerRNA *ptr, const float values[3]);

int MotionPathVert_select_get(PointerRNA *ptr);
void MotionPathVert_select_set(PointerRNA *ptr, int value);

/**************** Mouse Actuator ****************/

extern StructRNA RNA_MouseActuator;
extern StructRNA RNA_Actuator;

int MouseActuator_local_x_get(PointerRNA *ptr);
void MouseActuator_local_x_set(PointerRNA *ptr, int value);

int MouseActuator_local_y_get(PointerRNA *ptr);
void MouseActuator_local_y_set(PointerRNA *ptr, int value);

float MouseActuator_max_x_get(PointerRNA *ptr);
void MouseActuator_max_x_set(PointerRNA *ptr, float value);

float MouseActuator_max_y_get(PointerRNA *ptr);
void MouseActuator_max_y_set(PointerRNA *ptr, float value);

float MouseActuator_min_x_get(PointerRNA *ptr);
void MouseActuator_min_x_set(PointerRNA *ptr, float value);

float MouseActuator_min_y_get(PointerRNA *ptr);
void MouseActuator_min_y_set(PointerRNA *ptr, float value);

enum {
	MouseActuator_mode_VISIBILITY = 0,
	MouseActuator_mode_LOOK = 1,
};

int MouseActuator_mode_get(PointerRNA *ptr);
void MouseActuator_mode_set(PointerRNA *ptr, int value);

enum {
	MouseActuator_object_axis_x_OBJECT_AXIS_X = 0,
	MouseActuator_object_axis_x_OBJECT_AXIS_Y = 1,
	MouseActuator_object_axis_x_OBJECT_AXIS_Z = 2,
};

int MouseActuator_object_axis_x_get(PointerRNA *ptr);
void MouseActuator_object_axis_x_set(PointerRNA *ptr, int value);

enum {
	MouseActuator_object_axis_y_OBJECT_AXIS_X = 0,
	MouseActuator_object_axis_y_OBJECT_AXIS_Y = 1,
	MouseActuator_object_axis_y_OBJECT_AXIS_Z = 2,
};

int MouseActuator_object_axis_y_get(PointerRNA *ptr);
void MouseActuator_object_axis_y_set(PointerRNA *ptr, int value);

int MouseActuator_reset_x_get(PointerRNA *ptr);
void MouseActuator_reset_x_set(PointerRNA *ptr, int value);

int MouseActuator_reset_y_get(PointerRNA *ptr);
void MouseActuator_reset_y_set(PointerRNA *ptr, int value);

float MouseActuator_sensitivity_x_get(PointerRNA *ptr);
void MouseActuator_sensitivity_x_set(PointerRNA *ptr, float value);

float MouseActuator_sensitivity_y_get(PointerRNA *ptr);
void MouseActuator_sensitivity_y_set(PointerRNA *ptr, float value);

float MouseActuator_threshold_x_get(PointerRNA *ptr);
void MouseActuator_threshold_x_set(PointerRNA *ptr, float value);

float MouseActuator_threshold_y_get(PointerRNA *ptr);
void MouseActuator_threshold_y_set(PointerRNA *ptr, float value);

int MouseActuator_use_axis_x_get(PointerRNA *ptr);
void MouseActuator_use_axis_x_set(PointerRNA *ptr, int value);

int MouseActuator_use_axis_y_get(PointerRNA *ptr);
void MouseActuator_use_axis_y_set(PointerRNA *ptr, int value);

int MouseActuator_visible_get(PointerRNA *ptr);
void MouseActuator_visible_set(PointerRNA *ptr, int value);

/**************** Mouse Sensor ****************/

extern StructRNA RNA_MouseSensor;
extern StructRNA RNA_Sensor;

enum {
	MouseSensor_use_material_PROPERTY = 0,
	MouseSensor_use_material_MATERIAL = 1,
};

int MouseSensor_use_material_get(PointerRNA *ptr);
void MouseSensor_use_material_set(PointerRNA *ptr, int value);

#define MouseSensor_material_MAX 64

void MouseSensor_material_get(PointerRNA *ptr, char *value);
int MouseSensor_material_length(PointerRNA *ptr);
void MouseSensor_material_set(PointerRNA *ptr, const char *value);

enum {
	MouseSensor_mouse_event_LEFTCLICK = 1,
	MouseSensor_mouse_event_MIDDLECLICK = 2,
	MouseSensor_mouse_event_RIGHTCLICK = 4,
	MouseSensor_mouse_event_WHEELUP = 5,
	MouseSensor_mouse_event_WHEELDOWN = 6,
	MouseSensor_mouse_event_MOVEMENT = 8,
	MouseSensor_mouse_event_MOUSEOVER = 16,
	MouseSensor_mouse_event_MOUSEOVERANY = 32,
};

int MouseSensor_mouse_event_get(PointerRNA *ptr);
void MouseSensor_mouse_event_set(PointerRNA *ptr, int value);

#define MouseSensor_property_MAX 64

void MouseSensor_property_get(PointerRNA *ptr, char *value);
int MouseSensor_property_length(PointerRNA *ptr);
void MouseSensor_property_set(PointerRNA *ptr, const char *value);

int MouseSensor_use_pulse_get(PointerRNA *ptr);
void MouseSensor_use_pulse_set(PointerRNA *ptr, int value);

int MouseSensor_use_x_ray_get(PointerRNA *ptr);
void MouseSensor_use_x_ray_set(PointerRNA *ptr, int value);

/**************** MovieClip ****************/

extern StructRNA RNA_MovieClip;
extern StructRNA RNA_ID;

PointerRNA MovieClip_colorspace_settings_get(PointerRNA *ptr);

void MovieClip_display_aspect_get(PointerRNA *ptr, float values[2]);
void MovieClip_display_aspect_set(PointerRNA *ptr, const float values[2]);

int MovieClip_frame_duration_get(PointerRNA *ptr);
void MovieClip_frame_duration_set(PointerRNA *ptr, int value);

#define MovieClip_filepath_MAX 1024

void MovieClip_filepath_get(PointerRNA *ptr, char *value);
int MovieClip_filepath_length(PointerRNA *ptr);
void MovieClip_filepath_set(PointerRNA *ptr, const char *value);

int MovieClip_frame_offset_get(PointerRNA *ptr);
void MovieClip_frame_offset_set(PointerRNA *ptr, int value);

PointerRNA MovieClip_grease_pencil_get(PointerRNA *ptr);

int MovieClip_use_proxy_custom_directory_get(PointerRNA *ptr);
void MovieClip_use_proxy_custom_directory_set(PointerRNA *ptr, int value);

void MovieClip_size_get(PointerRNA *ptr, int values[2]);
void MovieClip_size_set(PointerRNA *ptr, const int values[2]);

enum {
	MovieClip_source_SEQUENCE = 1,
	MovieClip_source_MOVIE = 2,
};

int MovieClip_source_get(PointerRNA *ptr);
void MovieClip_source_set(PointerRNA *ptr, int value);

int MovieClip_frame_start_get(PointerRNA *ptr);
void MovieClip_frame_start_set(PointerRNA *ptr, int value);

int MovieClip_use_proxy_get(PointerRNA *ptr);
void MovieClip_use_proxy_set(PointerRNA *ptr, int value);

PointerRNA MovieClip_proxy_get(PointerRNA *ptr);

PointerRNA MovieClip_tracking_get(PointerRNA *ptr);

/**************** Movie Clip Proxy ****************/

extern StructRNA RNA_MovieClipProxy;

PointerRNA MovieClipProxy_rna_type_get(PointerRNA *ptr);

int MovieClipProxy_build_100_get(PointerRNA *ptr);
void MovieClipProxy_build_100_set(PointerRNA *ptr, int value);

int MovieClipProxy_build_undistorted_100_get(PointerRNA *ptr);
void MovieClipProxy_build_undistorted_100_set(PointerRNA *ptr, int value);

int MovieClipProxy_build_25_get(PointerRNA *ptr);
void MovieClipProxy_build_25_set(PointerRNA *ptr, int value);

int MovieClipProxy_build_undistorted_25_get(PointerRNA *ptr);
void MovieClipProxy_build_undistorted_25_set(PointerRNA *ptr, int value);

int MovieClipProxy_build_50_get(PointerRNA *ptr);
void MovieClipProxy_build_50_set(PointerRNA *ptr, int value);

int MovieClipProxy_build_undistorted_50_get(PointerRNA *ptr);
void MovieClipProxy_build_undistorted_50_set(PointerRNA *ptr, int value);

int MovieClipProxy_build_75_get(PointerRNA *ptr);
void MovieClipProxy_build_75_set(PointerRNA *ptr, int value);

int MovieClipProxy_build_undistorted_75_get(PointerRNA *ptr);
void MovieClipProxy_build_undistorted_75_set(PointerRNA *ptr, int value);

#define MovieClipProxy_directory_MAX 768

void MovieClipProxy_directory_get(PointerRNA *ptr, char *value);
int MovieClipProxy_directory_length(PointerRNA *ptr);
void MovieClipProxy_directory_set(PointerRNA *ptr, const char *value);

int MovieClipProxy_build_free_run_get(PointerRNA *ptr);
void MovieClipProxy_build_free_run_set(PointerRNA *ptr, int value);

int MovieClipProxy_build_free_run_rec_date_get(PointerRNA *ptr);
void MovieClipProxy_build_free_run_rec_date_set(PointerRNA *ptr, int value);

int MovieClipProxy_quality_get(PointerRNA *ptr);
void MovieClipProxy_quality_set(PointerRNA *ptr, int value);

int MovieClipProxy_build_record_run_get(PointerRNA *ptr);
void MovieClipProxy_build_record_run_set(PointerRNA *ptr, int value);

enum {
	MovieClipProxy_timecode_NONE = 0,
	MovieClipProxy_timecode_RECORD_RUN = 1,
	MovieClipProxy_timecode_FREE_RUN = 2,
	MovieClipProxy_timecode_FREE_RUN_REC_DATE = 4,
	MovieClipProxy_timecode_FREE_RUN_NO_GAPS = 8,
};

int MovieClipProxy_timecode_get(PointerRNA *ptr);
void MovieClipProxy_timecode_set(PointerRNA *ptr, int value);

/**************** MovieClipScopes ****************/

extern StructRNA RNA_MovieClipScopes;

PointerRNA MovieClipScopes_rna_type_get(PointerRNA *ptr);

/**************** MovieClip Sequence ****************/

extern StructRNA RNA_MovieClipSequence;
extern StructRNA RNA_Sequence;

enum {
	MovieClipSequence_alpha_mode_STRAIGHT = 0,
	MovieClipSequence_alpha_mode_PREMUL = 1,
};

int MovieClipSequence_alpha_mode_get(PointerRNA *ptr);
void MovieClipSequence_alpha_mode_set(PointerRNA *ptr, int value);

int MovieClipSequence_animation_offset_end_get(PointerRNA *ptr);
void MovieClipSequence_animation_offset_end_set(PointerRNA *ptr, int value);

int MovieClipSequence_animation_offset_start_get(PointerRNA *ptr);
void MovieClipSequence_animation_offset_start_set(PointerRNA *ptr, int value);

int MovieClipSequence_use_float_get(PointerRNA *ptr);
void MovieClipSequence_use_float_set(PointerRNA *ptr, int value);

PointerRNA MovieClipSequence_crop_get(PointerRNA *ptr);

int MovieClipSequence_use_deinterlace_get(PointerRNA *ptr);
void MovieClipSequence_use_deinterlace_set(PointerRNA *ptr, int value);

int MovieClipSequence_use_reverse_frames_get(PointerRNA *ptr);
void MovieClipSequence_use_reverse_frames_set(PointerRNA *ptr, int value);

int MovieClipSequence_use_flip_x_get(PointerRNA *ptr);
void MovieClipSequence_use_flip_x_set(PointerRNA *ptr, int value);

int MovieClipSequence_use_flip_y_get(PointerRNA *ptr);
void MovieClipSequence_use_flip_y_set(PointerRNA *ptr, int value);

float MovieClipSequence_color_multiply_get(PointerRNA *ptr);
void MovieClipSequence_color_multiply_set(PointerRNA *ptr, float value);

float MovieClipSequence_color_saturation_get(PointerRNA *ptr);
void MovieClipSequence_color_saturation_set(PointerRNA *ptr, float value);

int MovieClipSequence_stabilize2d_get(PointerRNA *ptr);
void MovieClipSequence_stabilize2d_set(PointerRNA *ptr, int value);

float MovieClipSequence_strobe_get(PointerRNA *ptr);
void MovieClipSequence_strobe_set(PointerRNA *ptr, float value);

PointerRNA MovieClipSequence_transform_get(PointerRNA *ptr);

int MovieClipSequence_undistort_get(PointerRNA *ptr);
void MovieClipSequence_undistort_set(PointerRNA *ptr, int value);

int MovieClipSequence_use_crop_get(PointerRNA *ptr);
void MovieClipSequence_use_crop_set(PointerRNA *ptr, int value);

int MovieClipSequence_use_translation_get(PointerRNA *ptr);
void MovieClipSequence_use_translation_set(PointerRNA *ptr, int value);

/**************** Movie Clip User ****************/

extern StructRNA RNA_MovieClipUser;

PointerRNA MovieClipUser_rna_type_get(PointerRNA *ptr);

int MovieClipUser_frame_current_get(PointerRNA *ptr);
void MovieClipUser_frame_current_set(PointerRNA *ptr, int value);

enum {
	MovieClipUser_proxy_render_size_PROXY_25 = 1,
	MovieClipUser_proxy_render_size_PROXY_50 = 2,
	MovieClipUser_proxy_render_size_PROXY_75 = 3,
	MovieClipUser_proxy_render_size_PROXY_100 = 4,
	MovieClipUser_proxy_render_size_FULL = 0,
};

int MovieClipUser_proxy_render_size_get(PointerRNA *ptr);
void MovieClipUser_proxy_render_size_set(PointerRNA *ptr, int value);

int MovieClipUser_use_render_undistorted_get(PointerRNA *ptr);
void MovieClipUser_use_render_undistorted_set(PointerRNA *ptr, int value);

/**************** Movie tracking reconstructed camera data ****************/

extern StructRNA RNA_MovieReconstructedCamera;

PointerRNA MovieReconstructedCamera_rna_type_get(PointerRNA *ptr);

float MovieReconstructedCamera_average_error_get(PointerRNA *ptr);
void MovieReconstructedCamera_average_error_set(PointerRNA *ptr, float value);

int MovieReconstructedCamera_frame_get(PointerRNA *ptr);
void MovieReconstructedCamera_frame_set(PointerRNA *ptr, int value);

void MovieReconstructedCamera_matrix_get(PointerRNA *ptr, float values[16]);
void MovieReconstructedCamera_matrix_set(PointerRNA *ptr, const float values[16]);

/**************** Movie Sequence ****************/

extern StructRNA RNA_MovieSequence;
extern StructRNA RNA_Sequence;

enum {
	MovieSequence_alpha_mode_STRAIGHT = 0,
	MovieSequence_alpha_mode_PREMUL = 1,
};

int MovieSequence_alpha_mode_get(PointerRNA *ptr);
void MovieSequence_alpha_mode_set(PointerRNA *ptr, int value);

int MovieSequence_animation_offset_end_get(PointerRNA *ptr);
void MovieSequence_animation_offset_end_set(PointerRNA *ptr, int value);

int MovieSequence_animation_offset_start_get(PointerRNA *ptr);
void MovieSequence_animation_offset_start_set(PointerRNA *ptr, int value);

PointerRNA MovieSequence_colorspace_settings_get(PointerRNA *ptr);

int MovieSequence_use_float_get(PointerRNA *ptr);
void MovieSequence_use_float_set(PointerRNA *ptr, int value);

PointerRNA MovieSequence_crop_get(PointerRNA *ptr);

int MovieSequence_use_deinterlace_get(PointerRNA *ptr);
void MovieSequence_use_deinterlace_set(PointerRNA *ptr, int value);

void MovieSequence_elements_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieSequence_elements_next(CollectionPropertyIterator *iter);
void MovieSequence_elements_end(CollectionPropertyIterator *iter);
int MovieSequence_elements_length(PointerRNA *ptr);
int MovieSequence_elements_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void MovieSequence_filepath_get(PointerRNA *ptr, char *value);
int MovieSequence_filepath_length(PointerRNA *ptr);
void MovieSequence_filepath_set(PointerRNA *ptr, const char *value);

int MovieSequence_use_reverse_frames_get(PointerRNA *ptr);
void MovieSequence_use_reverse_frames_set(PointerRNA *ptr, int value);

int MovieSequence_use_flip_x_get(PointerRNA *ptr);
void MovieSequence_use_flip_x_set(PointerRNA *ptr, int value);

int MovieSequence_use_flip_y_get(PointerRNA *ptr);
void MovieSequence_use_flip_y_set(PointerRNA *ptr, int value);

int MovieSequence_mpeg_preseek_get(PointerRNA *ptr);
void MovieSequence_mpeg_preseek_set(PointerRNA *ptr, int value);

float MovieSequence_color_multiply_get(PointerRNA *ptr);
void MovieSequence_color_multiply_set(PointerRNA *ptr, float value);

PointerRNA MovieSequence_proxy_get(PointerRNA *ptr);

int MovieSequence_use_proxy_custom_directory_get(PointerRNA *ptr);
void MovieSequence_use_proxy_custom_directory_set(PointerRNA *ptr, int value);

int MovieSequence_use_proxy_custom_file_get(PointerRNA *ptr);
void MovieSequence_use_proxy_custom_file_set(PointerRNA *ptr, int value);

float MovieSequence_color_saturation_get(PointerRNA *ptr);
void MovieSequence_color_saturation_set(PointerRNA *ptr, float value);

int MovieSequence_stream_index_get(PointerRNA *ptr);
void MovieSequence_stream_index_set(PointerRNA *ptr, int value);

float MovieSequence_strobe_get(PointerRNA *ptr);
void MovieSequence_strobe_set(PointerRNA *ptr, float value);

PointerRNA MovieSequence_transform_get(PointerRNA *ptr);

int MovieSequence_use_crop_get(PointerRNA *ptr);
void MovieSequence_use_crop_set(PointerRNA *ptr, int value);

int MovieSequence_use_proxy_get(PointerRNA *ptr);
void MovieSequence_use_proxy_set(PointerRNA *ptr, int value);

int MovieSequence_use_translation_get(PointerRNA *ptr);
void MovieSequence_use_translation_set(PointerRNA *ptr, int value);

/**************** Movie tracking data ****************/

extern StructRNA RNA_MovieTracking;

PointerRNA MovieTracking_rna_type_get(PointerRNA *ptr);

int MovieTracking_active_object_index_get(PointerRNA *ptr);
void MovieTracking_active_object_index_set(PointerRNA *ptr, int value);

void MovieTracking_objects_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieTracking_objects_next(CollectionPropertyIterator *iter);
void MovieTracking_objects_end(CollectionPropertyIterator *iter);
int MovieTracking_objects_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int MovieTracking_objects_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void MovieTracking_plane_tracks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieTracking_plane_tracks_next(CollectionPropertyIterator *iter);
void MovieTracking_plane_tracks_end(CollectionPropertyIterator *iter);
int MovieTracking_plane_tracks_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int MovieTracking_plane_tracks_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void MovieTracking_tracks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieTracking_tracks_next(CollectionPropertyIterator *iter);
void MovieTracking_tracks_end(CollectionPropertyIterator *iter);
int MovieTracking_tracks_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int MovieTracking_tracks_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA MovieTracking_camera_get(PointerRNA *ptr);

PointerRNA MovieTracking_dopesheet_get(PointerRNA *ptr);

PointerRNA MovieTracking_reconstruction_get(PointerRNA *ptr);

PointerRNA MovieTracking_settings_get(PointerRNA *ptr);

PointerRNA MovieTracking_stabilization_get(PointerRNA *ptr);

/**************** Movie tracking camera data ****************/

extern StructRNA RNA_MovieTrackingCamera;

PointerRNA MovieTrackingCamera_rna_type_get(PointerRNA *ptr);

enum {
	MovieTrackingCamera_distortion_model_POLYNOMIAL = 0,
	MovieTrackingCamera_distortion_model_DIVISION = 1,
};

int MovieTrackingCamera_distortion_model_get(PointerRNA *ptr);
void MovieTrackingCamera_distortion_model_set(PointerRNA *ptr, int value);

float MovieTrackingCamera_focal_length_get(PointerRNA *ptr);
void MovieTrackingCamera_focal_length_set(PointerRNA *ptr, float value);

float MovieTrackingCamera_focal_length_pixels_get(PointerRNA *ptr);
void MovieTrackingCamera_focal_length_pixels_set(PointerRNA *ptr, float value);

float MovieTrackingCamera_k1_get(PointerRNA *ptr);
void MovieTrackingCamera_k1_set(PointerRNA *ptr, float value);

float MovieTrackingCamera_division_k1_get(PointerRNA *ptr);
void MovieTrackingCamera_division_k1_set(PointerRNA *ptr, float value);

float MovieTrackingCamera_k2_get(PointerRNA *ptr);
void MovieTrackingCamera_k2_set(PointerRNA *ptr, float value);

float MovieTrackingCamera_division_k2_get(PointerRNA *ptr);
void MovieTrackingCamera_division_k2_set(PointerRNA *ptr, float value);

float MovieTrackingCamera_k3_get(PointerRNA *ptr);
void MovieTrackingCamera_k3_set(PointerRNA *ptr, float value);

float MovieTrackingCamera_pixel_aspect_get(PointerRNA *ptr);
void MovieTrackingCamera_pixel_aspect_set(PointerRNA *ptr, float value);

void MovieTrackingCamera_principal_get(PointerRNA *ptr, float values[2]);
void MovieTrackingCamera_principal_set(PointerRNA *ptr, const float values[2]);

float MovieTrackingCamera_sensor_width_get(PointerRNA *ptr);
void MovieTrackingCamera_sensor_width_set(PointerRNA *ptr, float value);

enum {
	MovieTrackingCamera_units_PIXELS = 0,
	MovieTrackingCamera_units_MILLIMETERS = 1,
};

int MovieTrackingCamera_units_get(PointerRNA *ptr);
void MovieTrackingCamera_units_set(PointerRNA *ptr, int value);

/**************** Movie Tracking Dopesheet ****************/

extern StructRNA RNA_MovieTrackingDopesheet;

PointerRNA MovieTrackingDopesheet_rna_type_get(PointerRNA *ptr);

int MovieTrackingDopesheet_show_hidden_get(PointerRNA *ptr);
void MovieTrackingDopesheet_show_hidden_set(PointerRNA *ptr, int value);

enum {
	MovieTrackingDopesheet_sort_method_NAME = 0,
	MovieTrackingDopesheet_sort_method_LONGEST = 1,
	MovieTrackingDopesheet_sort_method_TOTAL = 2,
	MovieTrackingDopesheet_sort_method_AVERAGE_ERROR = 3,
};

int MovieTrackingDopesheet_sort_method_get(PointerRNA *ptr);
void MovieTrackingDopesheet_sort_method_set(PointerRNA *ptr, int value);

int MovieTrackingDopesheet_use_invert_sort_get(PointerRNA *ptr);
void MovieTrackingDopesheet_use_invert_sort_set(PointerRNA *ptr, int value);

int MovieTrackingDopesheet_show_only_selected_get(PointerRNA *ptr);
void MovieTrackingDopesheet_show_only_selected_set(PointerRNA *ptr, int value);

/**************** Movie tracking marker data ****************/

extern StructRNA RNA_MovieTrackingMarker;

PointerRNA MovieTrackingMarker_rna_type_get(PointerRNA *ptr);

int MovieTrackingMarker_frame_get(PointerRNA *ptr);
void MovieTrackingMarker_frame_set(PointerRNA *ptr, int value);

int MovieTrackingMarker_is_keyed_get(PointerRNA *ptr);
void MovieTrackingMarker_is_keyed_set(PointerRNA *ptr, int value);

int MovieTrackingMarker_mute_get(PointerRNA *ptr);
void MovieTrackingMarker_mute_set(PointerRNA *ptr, int value);

void MovieTrackingMarker_pattern_bound_box_get(PointerRNA *ptr, float values[4]);
void MovieTrackingMarker_pattern_bound_box_set(PointerRNA *ptr, const float values[4]);

void MovieTrackingMarker_pattern_corners_get(PointerRNA *ptr, float values[8]);
void MovieTrackingMarker_pattern_corners_set(PointerRNA *ptr, const float values[8]);

void MovieTrackingMarker_co_get(PointerRNA *ptr, float values[2]);
void MovieTrackingMarker_co_set(PointerRNA *ptr, const float values[2]);

void MovieTrackingMarker_search_max_get(PointerRNA *ptr, float values[2]);
void MovieTrackingMarker_search_max_set(PointerRNA *ptr, const float values[2]);

void MovieTrackingMarker_search_min_get(PointerRNA *ptr, float values[2]);
void MovieTrackingMarker_search_min_set(PointerRNA *ptr, const float values[2]);

/**************** Movie Tracking Markers ****************/

extern StructRNA RNA_MovieTrackingMarkers;

PointerRNA MovieTrackingMarkers_rna_type_get(PointerRNA *ptr);

struct MovieTrackingMarker *MovieTrackingMarkers_find_frame(struct MovieTrackingTrack *_self, int frame, int exact);
struct MovieTrackingMarker *MovieTrackingMarkers_insert_frame(struct MovieTrackingTrack *_self, int frame, float co[2]);
void MovieTrackingMarkers_delete_frame(struct MovieTrackingTrack *_self, int frame);
/**************** Movie tracking object data ****************/

extern StructRNA RNA_MovieTrackingObject;

PointerRNA MovieTrackingObject_rna_type_get(PointerRNA *ptr);

#define MovieTrackingObject_name_MAX 64

void MovieTrackingObject_name_get(PointerRNA *ptr, char *value);
int MovieTrackingObject_name_length(PointerRNA *ptr);
void MovieTrackingObject_name_set(PointerRNA *ptr, const char *value);

int MovieTrackingObject_is_camera_get(PointerRNA *ptr);
void MovieTrackingObject_is_camera_set(PointerRNA *ptr, int value);

int MovieTrackingObject_keyframe_a_get(PointerRNA *ptr);
void MovieTrackingObject_keyframe_a_set(PointerRNA *ptr, int value);

int MovieTrackingObject_keyframe_b_get(PointerRNA *ptr);
void MovieTrackingObject_keyframe_b_set(PointerRNA *ptr, int value);

void MovieTrackingObject_plane_tracks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieTrackingObject_plane_tracks_next(CollectionPropertyIterator *iter);
void MovieTrackingObject_plane_tracks_end(CollectionPropertyIterator *iter);
int MovieTrackingObject_plane_tracks_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int MovieTrackingObject_plane_tracks_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float MovieTrackingObject_scale_get(PointerRNA *ptr);
void MovieTrackingObject_scale_set(PointerRNA *ptr, float value);

void MovieTrackingObject_tracks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieTrackingObject_tracks_next(CollectionPropertyIterator *iter);
void MovieTrackingObject_tracks_end(CollectionPropertyIterator *iter);
int MovieTrackingObject_tracks_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int MovieTrackingObject_tracks_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA MovieTrackingObject_reconstruction_get(PointerRNA *ptr);

/**************** Plane Tracks ****************/

extern StructRNA RNA_MovieTrackingObjectPlaneTracks;

PointerRNA MovieTrackingObjectPlaneTracks_rna_type_get(PointerRNA *ptr);

PointerRNA MovieTrackingObjectPlaneTracks_active_get(PointerRNA *ptr);

/**************** Movie Tracks ****************/

extern StructRNA RNA_MovieTrackingObjectTracks;

PointerRNA MovieTrackingObjectTracks_rna_type_get(PointerRNA *ptr);

PointerRNA MovieTrackingObjectTracks_active_get(PointerRNA *ptr);

struct MovieTrackingTrack *MovieTrackingObjectTracks_new(struct ID *_selfid, struct MovieTrackingObject *_self, const char * name, int frame);
/**************** Movie Objects ****************/

extern StructRNA RNA_MovieTrackingObjects;

PointerRNA MovieTrackingObjects_rna_type_get(PointerRNA *ptr);

PointerRNA MovieTrackingObjects_active_get(PointerRNA *ptr);

struct MovieTrackingObject *MovieTrackingObjects_new(struct MovieTracking *_self, const char * name);
void MovieTrackingObjects_remove(struct MovieTracking *_self, ReportList *reports, struct PointerRNA *object);
/**************** Movie Tracking Plane Marker Data ****************/

extern StructRNA RNA_MovieTrackingPlaneMarker;

PointerRNA MovieTrackingPlaneMarker_rna_type_get(PointerRNA *ptr);

void MovieTrackingPlaneMarker_corners_get(PointerRNA *ptr, float values[8]);
void MovieTrackingPlaneMarker_corners_set(PointerRNA *ptr, const float values[8]);

int MovieTrackingPlaneMarker_frame_get(PointerRNA *ptr);
void MovieTrackingPlaneMarker_frame_set(PointerRNA *ptr, int value);

int MovieTrackingPlaneMarker_mute_get(PointerRNA *ptr);
void MovieTrackingPlaneMarker_mute_set(PointerRNA *ptr, int value);

/**************** Movie Tracking Plane Markers ****************/

extern StructRNA RNA_MovieTrackingPlaneMarkers;

PointerRNA MovieTrackingPlaneMarkers_rna_type_get(PointerRNA *ptr);

struct MovieTrackingPlaneMarker *MovieTrackingPlaneMarkers_find_frame(struct MovieTrackingPlaneTrack *_self, int frame, int exact);
struct MovieTrackingPlaneMarker *MovieTrackingPlaneMarkers_insert_frame(struct MovieTrackingPlaneTrack *_self, int frame);
void MovieTrackingPlaneMarkers_delete_frame(struct MovieTrackingPlaneTrack *_self, int frame);
/**************** Movie tracking plane track data ****************/

extern StructRNA RNA_MovieTrackingPlaneTrack;

PointerRNA MovieTrackingPlaneTrack_rna_type_get(PointerRNA *ptr);

#define MovieTrackingPlaneTrack_name_MAX 64

void MovieTrackingPlaneTrack_name_get(PointerRNA *ptr, char *value);
int MovieTrackingPlaneTrack_name_length(PointerRNA *ptr);
void MovieTrackingPlaneTrack_name_set(PointerRNA *ptr, const char *value);

int MovieTrackingPlaneTrack_use_auto_keying_get(PointerRNA *ptr);
void MovieTrackingPlaneTrack_use_auto_keying_set(PointerRNA *ptr, int value);

PointerRNA MovieTrackingPlaneTrack_image_get(PointerRNA *ptr);

float MovieTrackingPlaneTrack_image_opacity_get(PointerRNA *ptr);
void MovieTrackingPlaneTrack_image_opacity_set(PointerRNA *ptr, float value);

void MovieTrackingPlaneTrack_markers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieTrackingPlaneTrack_markers_next(CollectionPropertyIterator *iter);
void MovieTrackingPlaneTrack_markers_end(CollectionPropertyIterator *iter);
int MovieTrackingPlaneTrack_markers_length(PointerRNA *ptr);
int MovieTrackingPlaneTrack_markers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int MovieTrackingPlaneTrack_select_get(PointerRNA *ptr);
void MovieTrackingPlaneTrack_select_set(PointerRNA *ptr, int value);

/**************** Movie Plane Tracks ****************/

extern StructRNA RNA_MovieTrackingPlaneTracks;

PointerRNA MovieTrackingPlaneTracks_rna_type_get(PointerRNA *ptr);

PointerRNA MovieTrackingPlaneTracks_active_get(PointerRNA *ptr);

/**************** Reconstructed Cameras ****************/

extern StructRNA RNA_MovieTrackingReconstructedCameras;

PointerRNA MovieTrackingReconstructedCameras_rna_type_get(PointerRNA *ptr);

struct MovieReconstructedCamera *MovieTrackingReconstructedCameras_find_frame(struct ID *_selfid, struct MovieTrackingReconstruction *_self, int frame);
void MovieTrackingReconstructedCameras_matrix_from_frame(struct ID *_selfid, struct MovieTrackingReconstruction *_self, int frame, float matrix[16]);
/**************** Movie tracking reconstruction data ****************/

extern StructRNA RNA_MovieTrackingReconstruction;

PointerRNA MovieTrackingReconstruction_rna_type_get(PointerRNA *ptr);

float MovieTrackingReconstruction_average_error_get(PointerRNA *ptr);
void MovieTrackingReconstruction_average_error_set(PointerRNA *ptr, float value);

void MovieTrackingReconstruction_cameras_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieTrackingReconstruction_cameras_next(CollectionPropertyIterator *iter);
void MovieTrackingReconstruction_cameras_end(CollectionPropertyIterator *iter);
int MovieTrackingReconstruction_cameras_length(PointerRNA *ptr);
int MovieTrackingReconstruction_cameras_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int MovieTrackingReconstruction_is_valid_get(PointerRNA *ptr);
void MovieTrackingReconstruction_is_valid_set(PointerRNA *ptr, int value);

/**************** Movie tracking settings ****************/

extern StructRNA RNA_MovieTrackingSettings;

PointerRNA MovieTrackingSettings_rna_type_get(PointerRNA *ptr);

enum {
	MovieTrackingSettings_clean_action_SELECT = 0,
	MovieTrackingSettings_clean_action_DELETE_TRACK = 1,
	MovieTrackingSettings_clean_action_DELETE_SEGMENTS = 2,
};

int MovieTrackingSettings_clean_action_get(PointerRNA *ptr);
void MovieTrackingSettings_clean_action_set(PointerRNA *ptr, int value);

float MovieTrackingSettings_default_correlation_min_get(PointerRNA *ptr);
void MovieTrackingSettings_default_correlation_min_set(PointerRNA *ptr, float value);

float MovieTrackingSettings_distance_get(PointerRNA *ptr);
void MovieTrackingSettings_distance_set(PointerRNA *ptr, float value);

float MovieTrackingSettings_object_distance_get(PointerRNA *ptr);
void MovieTrackingSettings_object_distance_set(PointerRNA *ptr, float value);

int MovieTrackingSettings_default_frames_limit_get(PointerRNA *ptr);
void MovieTrackingSettings_default_frames_limit_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_use_keyframe_selection_get(PointerRNA *ptr);
void MovieTrackingSettings_use_keyframe_selection_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_default_margin_get(PointerRNA *ptr);
void MovieTrackingSettings_default_margin_set(PointerRNA *ptr, int value);

enum {
	MovieTrackingSettings_default_motion_model_Perspective = 5,
	MovieTrackingSettings_default_motion_model_Affine = 4,
	MovieTrackingSettings_default_motion_model_LocRotScale = 3,
	MovieTrackingSettings_default_motion_model_LocScale = 2,
	MovieTrackingSettings_default_motion_model_LocRot = 1,
	MovieTrackingSettings_default_motion_model_Loc = 0,
};

int MovieTrackingSettings_default_motion_model_get(PointerRNA *ptr);
void MovieTrackingSettings_default_motion_model_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_use_default_normalization_get(PointerRNA *ptr);
void MovieTrackingSettings_use_default_normalization_set(PointerRNA *ptr, int value);

enum {
	MovieTrackingSettings_default_pattern_match_KEYFRAME = 0,
	MovieTrackingSettings_default_pattern_match_PREV_FRAME = 1,
};

int MovieTrackingSettings_default_pattern_match_get(PointerRNA *ptr);
void MovieTrackingSettings_default_pattern_match_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_default_pattern_size_get(PointerRNA *ptr);
void MovieTrackingSettings_default_pattern_size_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_use_default_brute_get(PointerRNA *ptr);
void MovieTrackingSettings_use_default_brute_set(PointerRNA *ptr, int value);

enum {
	MovieTrackingSettings_refine_intrinsics_NONE = 0,
	MovieTrackingSettings_refine_intrinsics_FOCAL_LENGTH = 1,
	MovieTrackingSettings_refine_intrinsics_FOCAL_LENGTH_RADIAL_K1 = 5,
	MovieTrackingSettings_refine_intrinsics_FOCAL_LENGTH_RADIAL_K1_K2 = 21,
	MovieTrackingSettings_refine_intrinsics_FOCAL_LENGTH_PRINCIPAL_POINT_RADIAL_K1_K2 = 23,
	MovieTrackingSettings_refine_intrinsics_FOCAL_LENGTH_PRINCIPAL_POINT = 3,
	MovieTrackingSettings_refine_intrinsics_RADIAL_K1_K2 = 20,
};

int MovieTrackingSettings_refine_intrinsics_get(PointerRNA *ptr);
void MovieTrackingSettings_refine_intrinsics_set(PointerRNA *ptr, int value);

float MovieTrackingSettings_clean_error_get(PointerRNA *ptr);
void MovieTrackingSettings_clean_error_set(PointerRNA *ptr, float value);

int MovieTrackingSettings_default_search_size_get(PointerRNA *ptr);
void MovieTrackingSettings_default_search_size_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_show_default_expanded_get(PointerRNA *ptr);
void MovieTrackingSettings_show_default_expanded_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_show_extra_expanded_get(PointerRNA *ptr);
void MovieTrackingSettings_show_extra_expanded_set(PointerRNA *ptr, int value);

enum {
	MovieTrackingSettings_speed_FASTEST = 0,
	MovieTrackingSettings_speed_DOUBLE = 5,
	MovieTrackingSettings_speed_REALTIME = 1,
	MovieTrackingSettings_speed_HALF = 2,
	MovieTrackingSettings_speed_QUARTER = 4,
};

int MovieTrackingSettings_speed_get(PointerRNA *ptr);
void MovieTrackingSettings_speed_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_clean_frames_get(PointerRNA *ptr);
void MovieTrackingSettings_clean_frames_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_use_tripod_solver_get(PointerRNA *ptr);
void MovieTrackingSettings_use_tripod_solver_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_use_default_blue_channel_get(PointerRNA *ptr);
void MovieTrackingSettings_use_default_blue_channel_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_use_default_green_channel_get(PointerRNA *ptr);
void MovieTrackingSettings_use_default_green_channel_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_use_default_mask_get(PointerRNA *ptr);
void MovieTrackingSettings_use_default_mask_set(PointerRNA *ptr, int value);

int MovieTrackingSettings_use_default_red_channel_get(PointerRNA *ptr);
void MovieTrackingSettings_use_default_red_channel_set(PointerRNA *ptr, int value);

float MovieTrackingSettings_default_weight_get(PointerRNA *ptr);
void MovieTrackingSettings_default_weight_set(PointerRNA *ptr, float value);

/**************** Movie tracking stabilization data ****************/

extern StructRNA RNA_MovieTrackingStabilization;

PointerRNA MovieTrackingStabilization_rna_type_get(PointerRNA *ptr);

int MovieTrackingStabilization_active_track_index_get(PointerRNA *ptr);
void MovieTrackingStabilization_active_track_index_set(PointerRNA *ptr, int value);

int MovieTrackingStabilization_use_autoscale_get(PointerRNA *ptr);
void MovieTrackingStabilization_use_autoscale_set(PointerRNA *ptr, int value);

enum {
	MovieTrackingStabilization_filter_type_NEAREST = 0,
	MovieTrackingStabilization_filter_type_BILINEAR = 1,
	MovieTrackingStabilization_filter_type_BICUBIC = 2,
};

int MovieTrackingStabilization_filter_type_get(PointerRNA *ptr);
void MovieTrackingStabilization_filter_type_set(PointerRNA *ptr, int value);

float MovieTrackingStabilization_influence_location_get(PointerRNA *ptr);
void MovieTrackingStabilization_influence_location_set(PointerRNA *ptr, float value);

float MovieTrackingStabilization_scale_max_get(PointerRNA *ptr);
void MovieTrackingStabilization_scale_max_set(PointerRNA *ptr, float value);

float MovieTrackingStabilization_influence_rotation_get(PointerRNA *ptr);
void MovieTrackingStabilization_influence_rotation_set(PointerRNA *ptr, float value);

PointerRNA MovieTrackingStabilization_rotation_track_get(PointerRNA *ptr);

float MovieTrackingStabilization_influence_scale_get(PointerRNA *ptr);
void MovieTrackingStabilization_influence_scale_set(PointerRNA *ptr, float value);

int MovieTrackingStabilization_use_stabilize_rotation_get(PointerRNA *ptr);
void MovieTrackingStabilization_use_stabilize_rotation_set(PointerRNA *ptr, int value);

void MovieTrackingStabilization_tracks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieTrackingStabilization_tracks_next(CollectionPropertyIterator *iter);
void MovieTrackingStabilization_tracks_end(CollectionPropertyIterator *iter);

int MovieTrackingStabilization_use_2d_stabilization_get(PointerRNA *ptr);
void MovieTrackingStabilization_use_2d_stabilization_set(PointerRNA *ptr, int value);

/**************** Movie tracking track data ****************/

extern StructRNA RNA_MovieTrackingTrack;

PointerRNA MovieTrackingTrack_rna_type_get(PointerRNA *ptr);

#define MovieTrackingTrack_name_MAX 64

void MovieTrackingTrack_name_get(PointerRNA *ptr, char *value);
int MovieTrackingTrack_name_length(PointerRNA *ptr);
void MovieTrackingTrack_name_set(PointerRNA *ptr, const char *value);

int MovieTrackingTrack_use_alpha_preview_get(PointerRNA *ptr);
void MovieTrackingTrack_use_alpha_preview_set(PointerRNA *ptr, int value);

float MovieTrackingTrack_average_error_get(PointerRNA *ptr);
void MovieTrackingTrack_average_error_set(PointerRNA *ptr, float value);

void MovieTrackingTrack_bundle_get(PointerRNA *ptr, float values[3]);
void MovieTrackingTrack_bundle_set(PointerRNA *ptr, const float values[3]);

void MovieTrackingTrack_color_get(PointerRNA *ptr, float values[3]);
void MovieTrackingTrack_color_set(PointerRNA *ptr, const float values[3]);

float MovieTrackingTrack_correlation_min_get(PointerRNA *ptr);
void MovieTrackingTrack_correlation_min_set(PointerRNA *ptr, float value);

int MovieTrackingTrack_use_custom_color_get(PointerRNA *ptr);
void MovieTrackingTrack_use_custom_color_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_frames_limit_get(PointerRNA *ptr);
void MovieTrackingTrack_frames_limit_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_use_grayscale_preview_get(PointerRNA *ptr);
void MovieTrackingTrack_use_grayscale_preview_set(PointerRNA *ptr, int value);

PointerRNA MovieTrackingTrack_grease_pencil_get(PointerRNA *ptr);

int MovieTrackingTrack_has_bundle_get(PointerRNA *ptr);
void MovieTrackingTrack_has_bundle_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_hide_get(PointerRNA *ptr);
void MovieTrackingTrack_hide_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_lock_get(PointerRNA *ptr);
void MovieTrackingTrack_lock_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_margin_get(PointerRNA *ptr);
void MovieTrackingTrack_margin_set(PointerRNA *ptr, int value);

void MovieTrackingTrack_markers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void MovieTrackingTrack_markers_next(CollectionPropertyIterator *iter);
void MovieTrackingTrack_markers_end(CollectionPropertyIterator *iter);
int MovieTrackingTrack_markers_length(PointerRNA *ptr);
int MovieTrackingTrack_markers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	MovieTrackingTrack_motion_model_Perspective = 5,
	MovieTrackingTrack_motion_model_Affine = 4,
	MovieTrackingTrack_motion_model_LocRotScale = 3,
	MovieTrackingTrack_motion_model_LocScale = 2,
	MovieTrackingTrack_motion_model_LocRot = 1,
	MovieTrackingTrack_motion_model_Loc = 0,
};

int MovieTrackingTrack_motion_model_get(PointerRNA *ptr);
void MovieTrackingTrack_motion_model_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_use_normalization_get(PointerRNA *ptr);
void MovieTrackingTrack_use_normalization_set(PointerRNA *ptr, int value);

void MovieTrackingTrack_offset_get(PointerRNA *ptr, float values[2]);
void MovieTrackingTrack_offset_set(PointerRNA *ptr, const float values[2]);

enum {
	MovieTrackingTrack_pattern_match_KEYFRAME = 0,
	MovieTrackingTrack_pattern_match_PREV_FRAME = 1,
};

int MovieTrackingTrack_pattern_match_get(PointerRNA *ptr);
void MovieTrackingTrack_pattern_match_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_use_brute_get(PointerRNA *ptr);
void MovieTrackingTrack_use_brute_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_select_get(PointerRNA *ptr);
void MovieTrackingTrack_select_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_select_anchor_get(PointerRNA *ptr);
void MovieTrackingTrack_select_anchor_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_select_pattern_get(PointerRNA *ptr);
void MovieTrackingTrack_select_pattern_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_select_search_get(PointerRNA *ptr);
void MovieTrackingTrack_select_search_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_use_blue_channel_get(PointerRNA *ptr);
void MovieTrackingTrack_use_blue_channel_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_use_green_channel_get(PointerRNA *ptr);
void MovieTrackingTrack_use_green_channel_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_use_mask_get(PointerRNA *ptr);
void MovieTrackingTrack_use_mask_set(PointerRNA *ptr, int value);

int MovieTrackingTrack_use_red_channel_get(PointerRNA *ptr);
void MovieTrackingTrack_use_red_channel_set(PointerRNA *ptr, int value);

float MovieTrackingTrack_weight_get(PointerRNA *ptr);
void MovieTrackingTrack_weight_set(PointerRNA *ptr, float value);

/**************** Movie Tracks ****************/

extern StructRNA RNA_MovieTrackingTracks;

PointerRNA MovieTrackingTracks_rna_type_get(PointerRNA *ptr);

PointerRNA MovieTrackingTracks_active_get(PointerRNA *ptr);

struct MovieTrackingTrack *MovieTrackingTracks_new(struct ID *_selfid, struct MovieTracking *_self, const char * name, int frame);
/**************** Multicam Select Sequence ****************/

extern StructRNA RNA_MulticamSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

int MulticamSequence_animation_offset_end_get(PointerRNA *ptr);
void MulticamSequence_animation_offset_end_set(PointerRNA *ptr, int value);

int MulticamSequence_animation_offset_start_get(PointerRNA *ptr);
void MulticamSequence_animation_offset_start_set(PointerRNA *ptr, int value);

int MulticamSequence_multicam_source_get(PointerRNA *ptr);
void MulticamSequence_multicam_source_set(PointerRNA *ptr, int value);

int MulticamSequence_input_count_get(PointerRNA *ptr);
void MulticamSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Multiply Sequence ****************/

extern StructRNA RNA_MultiplySequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

PointerRNA MultiplySequence_input_1_get(PointerRNA *ptr);

PointerRNA MultiplySequence_input_2_get(PointerRNA *ptr);

int MultiplySequence_input_count_get(PointerRNA *ptr);
void MultiplySequence_input_count_set(PointerRNA *ptr, int value);

/**************** Multires Modifier ****************/

extern StructRNA RNA_MultiresModifier;
extern StructRNA RNA_Modifier;

int MultiresModifier_is_external_get(PointerRNA *ptr);
void MultiresModifier_is_external_set(PointerRNA *ptr, int value);

void MultiresModifier_filepath_get(PointerRNA *ptr, char *value);
int MultiresModifier_filepath_length(PointerRNA *ptr);
void MultiresModifier_filepath_set(PointerRNA *ptr, const char *value);

int MultiresModifier_levels_get(PointerRNA *ptr);
void MultiresModifier_levels_set(PointerRNA *ptr, int value);

int MultiresModifier_show_only_control_edges_get(PointerRNA *ptr);
void MultiresModifier_show_only_control_edges_set(PointerRNA *ptr, int value);

int MultiresModifier_render_levels_get(PointerRNA *ptr);
void MultiresModifier_render_levels_set(PointerRNA *ptr, int value);

int MultiresModifier_sculpt_levels_get(PointerRNA *ptr);
void MultiresModifier_sculpt_levels_set(PointerRNA *ptr, int value);

int MultiresModifier_use_subsurf_uv_get(PointerRNA *ptr);
void MultiresModifier_use_subsurf_uv_set(PointerRNA *ptr, int value);

enum {
	MultiresModifier_subdivision_type_CATMULL_CLARK = 0,
	MultiresModifier_subdivision_type_SIMPLE = 1,
};

int MultiresModifier_subdivision_type_get(PointerRNA *ptr);
void MultiresModifier_subdivision_type_set(PointerRNA *ptr, int value);

int MultiresModifier_total_levels_get(PointerRNA *ptr);
void MultiresModifier_total_levels_set(PointerRNA *ptr, int value);

/**************** Musgrave ****************/

extern StructRNA RNA_MusgraveTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

float MusgraveTexture_gain_get(PointerRNA *ptr);
void MusgraveTexture_gain_set(PointerRNA *ptr, float value);

float MusgraveTexture_dimension_max_get(PointerRNA *ptr);
void MusgraveTexture_dimension_max_set(PointerRNA *ptr, float value);

float MusgraveTexture_lacunarity_get(PointerRNA *ptr);
void MusgraveTexture_lacunarity_set(PointerRNA *ptr, float value);

float MusgraveTexture_nabla_get(PointerRNA *ptr);
void MusgraveTexture_nabla_set(PointerRNA *ptr, float value);

enum {
	MusgraveTexture_noise_basis_BLENDER_ORIGINAL = 0,
	MusgraveTexture_noise_basis_ORIGINAL_PERLIN = 1,
	MusgraveTexture_noise_basis_IMPROVED_PERLIN = 2,
	MusgraveTexture_noise_basis_VORONOI_F1 = 3,
	MusgraveTexture_noise_basis_VORONOI_F2 = 4,
	MusgraveTexture_noise_basis_VORONOI_F3 = 5,
	MusgraveTexture_noise_basis_VORONOI_F4 = 6,
	MusgraveTexture_noise_basis_VORONOI_F2_F1 = 7,
	MusgraveTexture_noise_basis_VORONOI_CRACKLE = 8,
	MusgraveTexture_noise_basis_CELL_NOISE = 14,
};

int MusgraveTexture_noise_basis_get(PointerRNA *ptr);
void MusgraveTexture_noise_basis_set(PointerRNA *ptr, int value);

float MusgraveTexture_noise_intensity_get(PointerRNA *ptr);
void MusgraveTexture_noise_intensity_set(PointerRNA *ptr, float value);

float MusgraveTexture_noise_scale_get(PointerRNA *ptr);
void MusgraveTexture_noise_scale_set(PointerRNA *ptr, float value);

float MusgraveTexture_octaves_get(PointerRNA *ptr);
void MusgraveTexture_octaves_set(PointerRNA *ptr, float value);

float MusgraveTexture_offset_get(PointerRNA *ptr);
void MusgraveTexture_offset_set(PointerRNA *ptr, float value);

enum {
	MusgraveTexture_musgrave_type_MULTIFRACTAL = 0,
	MusgraveTexture_musgrave_type_RIDGED_MULTIFRACTAL = 1,
	MusgraveTexture_musgrave_type_HYBRID_MULTIFRACTAL = 2,
	MusgraveTexture_musgrave_type_FBM = 3,
	MusgraveTexture_musgrave_type_HETERO_TERRAIN = 4,
};

int MusgraveTexture_musgrave_type_get(PointerRNA *ptr);
void MusgraveTexture_musgrave_type_set(PointerRNA *ptr, int value);

/**************** Nand Controller ****************/

extern StructRNA RNA_NandController;
extern StructRNA RNA_Controller;

/**************** Near Sensor ****************/

extern StructRNA RNA_NearSensor;
extern StructRNA RNA_Sensor;

float NearSensor_distance_get(PointerRNA *ptr);
void NearSensor_distance_set(PointerRNA *ptr, float value);

#define NearSensor_property_MAX 64

void NearSensor_property_get(PointerRNA *ptr, char *value);
int NearSensor_property_length(PointerRNA *ptr);
void NearSensor_property_set(PointerRNA *ptr, const char *value);

float NearSensor_reset_distance_get(PointerRNA *ptr);
void NearSensor_reset_distance_set(PointerRNA *ptr, float value);

/**************** NLA Strip ****************/

extern StructRNA RNA_NlaStrip;

PointerRNA NlaStrip_rna_type_get(PointerRNA *ptr);

#define NlaStrip_name_MAX 64

void NlaStrip_name_get(PointerRNA *ptr, char *value);
int NlaStrip_name_length(PointerRNA *ptr);
void NlaStrip_name_set(PointerRNA *ptr, const char *value);

PointerRNA NlaStrip_action_get(PointerRNA *ptr);

float NlaStrip_action_frame_end_get(PointerRNA *ptr);
void NlaStrip_action_frame_end_set(PointerRNA *ptr, float value);

float NlaStrip_action_frame_start_get(PointerRNA *ptr);
void NlaStrip_action_frame_start_set(PointerRNA *ptr, float value);

int NlaStrip_active_get(PointerRNA *ptr);
void NlaStrip_active_set(PointerRNA *ptr, int value);

int NlaStrip_use_animated_influence_get(PointerRNA *ptr);
void NlaStrip_use_animated_influence_set(PointerRNA *ptr, int value);

int NlaStrip_use_animated_time_get(PointerRNA *ptr);
void NlaStrip_use_animated_time_set(PointerRNA *ptr, int value);

int NlaStrip_use_auto_blend_get(PointerRNA *ptr);
void NlaStrip_use_auto_blend_set(PointerRNA *ptr, int value);

float NlaStrip_blend_in_get(PointerRNA *ptr);
void NlaStrip_blend_in_set(PointerRNA *ptr, float value);

float NlaStrip_blend_out_get(PointerRNA *ptr);
void NlaStrip_blend_out_set(PointerRNA *ptr, float value);

enum {
	NlaStrip_blend_type_REPLACE = 0,
	NlaStrip_blend_type_ADD = 1,
	NlaStrip_blend_type_SUBTRACT = 2,
	NlaStrip_blend_type_MULTIPLY = 3,
};

int NlaStrip_blend_type_get(PointerRNA *ptr);
void NlaStrip_blend_type_set(PointerRNA *ptr, int value);

int NlaStrip_use_animated_time_cyclic_get(PointerRNA *ptr);
void NlaStrip_use_animated_time_cyclic_set(PointerRNA *ptr, int value);

float NlaStrip_frame_end_get(PointerRNA *ptr);
void NlaStrip_frame_end_set(PointerRNA *ptr, float value);

enum {
	NlaStrip_extrapolation_NOTHING = 2,
	NlaStrip_extrapolation_HOLD = 0,
	NlaStrip_extrapolation_HOLD_FORWARD = 1,
};

int NlaStrip_extrapolation_get(PointerRNA *ptr);
void NlaStrip_extrapolation_set(PointerRNA *ptr, int value);

void NlaStrip_fcurves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void NlaStrip_fcurves_next(CollectionPropertyIterator *iter);
void NlaStrip_fcurves_end(CollectionPropertyIterator *iter);
int NlaStrip_fcurves_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

float NlaStrip_influence_get(PointerRNA *ptr);
void NlaStrip_influence_set(PointerRNA *ptr, float value);

void NlaStrip_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void NlaStrip_modifiers_next(CollectionPropertyIterator *iter);
void NlaStrip_modifiers_end(CollectionPropertyIterator *iter);
int NlaStrip_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int NlaStrip_mute_get(PointerRNA *ptr);
void NlaStrip_mute_set(PointerRNA *ptr, int value);

void NlaStrip_strips_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void NlaStrip_strips_next(CollectionPropertyIterator *iter);
void NlaStrip_strips_end(CollectionPropertyIterator *iter);
int NlaStrip_strips_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int NlaStrip_strips_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float NlaStrip_repeat_get(PointerRNA *ptr);
void NlaStrip_repeat_set(PointerRNA *ptr, float value);

int NlaStrip_use_reverse_get(PointerRNA *ptr);
void NlaStrip_use_reverse_set(PointerRNA *ptr, int value);

float NlaStrip_scale_get(PointerRNA *ptr);
void NlaStrip_scale_set(PointerRNA *ptr, float value);

int NlaStrip_select_get(PointerRNA *ptr);
void NlaStrip_select_set(PointerRNA *ptr, int value);

float NlaStrip_frame_start_get(PointerRNA *ptr);
void NlaStrip_frame_start_set(PointerRNA *ptr, float value);

float NlaStrip_strip_time_get(PointerRNA *ptr);
void NlaStrip_strip_time_set(PointerRNA *ptr, float value);

int NlaStrip_use_sync_length_get(PointerRNA *ptr);
void NlaStrip_use_sync_length_set(PointerRNA *ptr, int value);

enum {
	NlaStrip_type_CLIP = 0,
	NlaStrip_type_TRANSITION = 1,
	NlaStrip_type_META = 2,
	NlaStrip_type_SOUND = 3,
};

int NlaStrip_type_get(PointerRNA *ptr);
void NlaStrip_type_set(PointerRNA *ptr, int value);

/**************** Nla Strips ****************/

extern StructRNA RNA_NlaStrips;

PointerRNA NlaStrips_rna_type_get(PointerRNA *ptr);

struct NlaStrip *NlaStrips_new(struct NlaTrack *_self, bContext *C, ReportList *reports, const char * name, int start, struct bAction *action);
void NlaStrips_remove(struct NlaTrack *_self, bContext *C, ReportList *reports, struct PointerRNA *strip);
/**************** NLA Track ****************/

extern StructRNA RNA_NlaTrack;

PointerRNA NlaTrack_rna_type_get(PointerRNA *ptr);

#define NlaTrack_name_MAX 64

void NlaTrack_name_get(PointerRNA *ptr, char *value);
int NlaTrack_name_length(PointerRNA *ptr);
void NlaTrack_name_set(PointerRNA *ptr, const char *value);

int NlaTrack_active_get(PointerRNA *ptr);
void NlaTrack_active_set(PointerRNA *ptr, int value);

int NlaTrack_lock_get(PointerRNA *ptr);
void NlaTrack_lock_set(PointerRNA *ptr, int value);

int NlaTrack_mute_get(PointerRNA *ptr);
void NlaTrack_mute_set(PointerRNA *ptr, int value);

void NlaTrack_strips_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void NlaTrack_strips_next(CollectionPropertyIterator *iter);
void NlaTrack_strips_end(CollectionPropertyIterator *iter);
int NlaTrack_strips_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int NlaTrack_strips_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int NlaTrack_select_get(PointerRNA *ptr);
void NlaTrack_select_set(PointerRNA *ptr, int value);

int NlaTrack_is_solo_get(PointerRNA *ptr);
void NlaTrack_is_solo_set(PointerRNA *ptr, int value);

/**************** NLA Tracks ****************/

extern StructRNA RNA_NlaTracks;

PointerRNA NlaTracks_rna_type_get(PointerRNA *ptr);

PointerRNA NlaTracks_active_get(PointerRNA *ptr);

struct NlaTrack *NlaTracks_new(struct AnimData *_self, bContext *C, struct NlaTrack *prev);
void NlaTracks_remove(struct AnimData *_self, bContext *C, ReportList *reports, struct PointerRNA *track);
/**************** Node ****************/

extern StructRNA RNA_Node;

PointerRNA Node_rna_type_get(PointerRNA *ptr);

#define Node_name_MAX 64

void Node_name_get(PointerRNA *ptr, char *value);
int Node_name_length(PointerRNA *ptr);
void Node_name_set(PointerRNA *ptr, const char *value);

void Node_color_get(PointerRNA *ptr, float values[3]);
void Node_color_set(PointerRNA *ptr, const float values[3]);

int Node_use_custom_color_get(PointerRNA *ptr);
void Node_use_custom_color_set(PointerRNA *ptr, int value);

void Node_dimensions_get(PointerRNA *ptr, float values[2]);
void Node_dimensions_set(PointerRNA *ptr, const float values[2]);

float Node_height_get(PointerRNA *ptr);
void Node_height_set(PointerRNA *ptr, float value);

int Node_hide_get(PointerRNA *ptr);
void Node_hide_set(PointerRNA *ptr, int value);

void Node_bl_idname_get(PointerRNA *ptr, char *value);
int Node_bl_idname_length(PointerRNA *ptr);
void Node_bl_idname_set(PointerRNA *ptr, const char *value);

enum {
	Node_bl_icon_NONE = 0,
	Node_bl_icon_QUESTION = 1,
	Node_bl_icon_ERROR = 2,
	Node_bl_icon_CANCEL = 3,
	Node_bl_icon_TRIA_RIGHT = 4,
	Node_bl_icon_TRIA_DOWN = 5,
	Node_bl_icon_TRIA_LEFT = 6,
	Node_bl_icon_TRIA_UP = 7,
	Node_bl_icon_ARROW_LEFTRIGHT = 8,
	Node_bl_icon_PLUS = 9,
	Node_bl_icon_DISCLOSURE_TRI_DOWN = 10,
	Node_bl_icon_DISCLOSURE_TRI_RIGHT = 11,
	Node_bl_icon_RADIOBUT_OFF = 12,
	Node_bl_icon_RADIOBUT_ON = 13,
	Node_bl_icon_MENU_PANEL = 14,
	Node_bl_icon_BLENDER = 15,
	Node_bl_icon_GRIP = 16,
	Node_bl_icon_DOT = 17,
	Node_bl_icon_COLLAPSEMENU = 18,
	Node_bl_icon_X = 19,
	Node_bl_icon_GO_LEFT = 21,
	Node_bl_icon_PLUG = 22,
	Node_bl_icon_UI = 23,
	Node_bl_icon_NODE = 24,
	Node_bl_icon_NODE_SEL = 25,
	Node_bl_icon_FULLSCREEN = 26,
	Node_bl_icon_SPLITSCREEN = 27,
	Node_bl_icon_RIGHTARROW_THIN = 28,
	Node_bl_icon_BORDERMOVE = 29,
	Node_bl_icon_VIEWZOOM = 30,
	Node_bl_icon_ZOOMIN = 31,
	Node_bl_icon_ZOOMOUT = 32,
	Node_bl_icon_PANEL_CLOSE = 33,
	Node_bl_icon_COPY_ID = 34,
	Node_bl_icon_EYEDROPPER = 35,
	Node_bl_icon_LINK_AREA = 36,
	Node_bl_icon_AUTO = 37,
	Node_bl_icon_CHECKBOX_DEHLT = 38,
	Node_bl_icon_CHECKBOX_HLT = 39,
	Node_bl_icon_UNLOCKED = 40,
	Node_bl_icon_LOCKED = 41,
	Node_bl_icon_UNPINNED = 42,
	Node_bl_icon_PINNED = 43,
	Node_bl_icon_SCREEN_BACK = 44,
	Node_bl_icon_RIGHTARROW = 45,
	Node_bl_icon_DOWNARROW_HLT = 46,
	Node_bl_icon_DOTSUP = 47,
	Node_bl_icon_DOTSDOWN = 48,
	Node_bl_icon_LINK = 49,
	Node_bl_icon_INLINK = 50,
	Node_bl_icon_PLUGIN = 51,
	Node_bl_icon_HELP = 52,
	Node_bl_icon_GHOST_ENABLED = 53,
	Node_bl_icon_COLOR = 54,
	Node_bl_icon_LINKED = 55,
	Node_bl_icon_UNLINKED = 56,
	Node_bl_icon_HAND = 57,
	Node_bl_icon_ZOOM_ALL = 58,
	Node_bl_icon_ZOOM_SELECTED = 59,
	Node_bl_icon_ZOOM_PREVIOUS = 60,
	Node_bl_icon_ZOOM_IN = 61,
	Node_bl_icon_ZOOM_OUT = 62,
	Node_bl_icon_RENDER_REGION = 63,
	Node_bl_icon_BORDER_RECT = 64,
	Node_bl_icon_BORDER_LASSO = 65,
	Node_bl_icon_FREEZE = 66,
	Node_bl_icon_STYLUS_PRESSURE = 67,
	Node_bl_icon_GHOST_DISABLED = 68,
	Node_bl_icon_NEW = 69,
	Node_bl_icon_FILE_TICK = 70,
	Node_bl_icon_QUIT = 71,
	Node_bl_icon_URL = 72,
	Node_bl_icon_RECOVER_LAST = 73,
	Node_bl_icon_FULLSCREEN_ENTER = 75,
	Node_bl_icon_FULLSCREEN_EXIT = 76,
	Node_bl_icon_BLANK1 = 77,
	Node_bl_icon_LAMP = 78,
	Node_bl_icon_MATERIAL = 79,
	Node_bl_icon_TEXTURE = 80,
	Node_bl_icon_ANIM = 81,
	Node_bl_icon_WORLD = 82,
	Node_bl_icon_SCENE = 83,
	Node_bl_icon_EDIT = 84,
	Node_bl_icon_GAME = 85,
	Node_bl_icon_RADIO = 86,
	Node_bl_icon_SCRIPT = 87,
	Node_bl_icon_PARTICLES = 88,
	Node_bl_icon_PHYSICS = 89,
	Node_bl_icon_SPEAKER = 90,
	Node_bl_icon_TEXTURE_SHADED = 91,
	Node_bl_icon_VIEW3D = 104,
	Node_bl_icon_IPO = 105,
	Node_bl_icon_OOPS = 106,
	Node_bl_icon_BUTS = 107,
	Node_bl_icon_FILESEL = 108,
	Node_bl_icon_IMAGE_COL = 109,
	Node_bl_icon_INFO = 110,
	Node_bl_icon_SEQUENCE = 111,
	Node_bl_icon_TEXT = 112,
	Node_bl_icon_IMASEL = 113,
	Node_bl_icon_SOUND = 114,
	Node_bl_icon_ACTION = 115,
	Node_bl_icon_NLA = 116,
	Node_bl_icon_SCRIPTWIN = 117,
	Node_bl_icon_TIME = 118,
	Node_bl_icon_NODETREE = 119,
	Node_bl_icon_LOGIC = 120,
	Node_bl_icon_CONSOLE = 121,
	Node_bl_icon_PREFERENCES = 122,
	Node_bl_icon_CLIP = 123,
	Node_bl_icon_ASSET_MANAGER = 124,
	Node_bl_icon_OBJECT_DATAMODE = 130,
	Node_bl_icon_EDITMODE_HLT = 131,
	Node_bl_icon_FACESEL_HLT = 132,
	Node_bl_icon_VPAINT_HLT = 133,
	Node_bl_icon_TPAINT_HLT = 134,
	Node_bl_icon_WPAINT_HLT = 135,
	Node_bl_icon_SCULPTMODE_HLT = 136,
	Node_bl_icon_POSE_HLT = 137,
	Node_bl_icon_PARTICLEMODE = 138,
	Node_bl_icon_LIGHTPAINT = 139,
	Node_bl_icon_SCENE_DATA = 156,
	Node_bl_icon_RENDERLAYERS = 157,
	Node_bl_icon_WORLD_DATA = 158,
	Node_bl_icon_OBJECT_DATA = 159,
	Node_bl_icon_MESH_DATA = 160,
	Node_bl_icon_CURVE_DATA = 161,
	Node_bl_icon_META_DATA = 162,
	Node_bl_icon_LATTICE_DATA = 163,
	Node_bl_icon_LAMP_DATA = 164,
	Node_bl_icon_MATERIAL_DATA = 165,
	Node_bl_icon_TEXTURE_DATA = 166,
	Node_bl_icon_ANIM_DATA = 167,
	Node_bl_icon_CAMERA_DATA = 168,
	Node_bl_icon_PARTICLE_DATA = 169,
	Node_bl_icon_LIBRARY_DATA_DIRECT = 170,
	Node_bl_icon_GROUP = 171,
	Node_bl_icon_ARMATURE_DATA = 172,
	Node_bl_icon_POSE_DATA = 173,
	Node_bl_icon_BONE_DATA = 174,
	Node_bl_icon_CONSTRAINT = 175,
	Node_bl_icon_SHAPEKEY_DATA = 176,
	Node_bl_icon_CONSTRAINT_BONE = 177,
	Node_bl_icon_CAMERA_STEREO = 178,
	Node_bl_icon_PACKAGE = 179,
	Node_bl_icon_UGLYPACKAGE = 180,
	Node_bl_icon_BRUSH_DATA = 182,
	Node_bl_icon_IMAGE_DATA = 183,
	Node_bl_icon_FILE = 184,
	Node_bl_icon_FCURVE = 185,
	Node_bl_icon_FONT_DATA = 186,
	Node_bl_icon_RENDER_RESULT = 187,
	Node_bl_icon_SURFACE_DATA = 188,
	Node_bl_icon_EMPTY_DATA = 189,
	Node_bl_icon_SETTINGS = 190,
	Node_bl_icon_RENDER_ANIMATION = 191,
	Node_bl_icon_RENDER_STILL = 192,
	Node_bl_icon_BOIDS = 194,
	Node_bl_icon_STRANDS = 195,
	Node_bl_icon_LIBRARY_DATA_INDIRECT = 196,
	Node_bl_icon_GREASEPENCIL = 197,
	Node_bl_icon_LINE_DATA = 198,
	Node_bl_icon_GROUP_BONE = 200,
	Node_bl_icon_GROUP_VERTEX = 201,
	Node_bl_icon_GROUP_VCOL = 202,
	Node_bl_icon_GROUP_UVS = 203,
	Node_bl_icon_RNA = 206,
	Node_bl_icon_RNA_ADD = 207,
	Node_bl_icon_OUTLINER_OB_EMPTY = 234,
	Node_bl_icon_OUTLINER_OB_MESH = 235,
	Node_bl_icon_OUTLINER_OB_CURVE = 236,
	Node_bl_icon_OUTLINER_OB_LATTICE = 237,
	Node_bl_icon_OUTLINER_OB_META = 238,
	Node_bl_icon_OUTLINER_OB_LAMP = 239,
	Node_bl_icon_OUTLINER_OB_CAMERA = 240,
	Node_bl_icon_OUTLINER_OB_ARMATURE = 241,
	Node_bl_icon_OUTLINER_OB_FONT = 242,
	Node_bl_icon_OUTLINER_OB_SURFACE = 243,
	Node_bl_icon_OUTLINER_OB_SPEAKER = 244,
	Node_bl_icon_RESTRICT_VIEW_OFF = 253,
	Node_bl_icon_RESTRICT_VIEW_ON = 254,
	Node_bl_icon_RESTRICT_SELECT_OFF = 255,
	Node_bl_icon_RESTRICT_SELECT_ON = 256,
	Node_bl_icon_RESTRICT_RENDER_OFF = 257,
	Node_bl_icon_RESTRICT_RENDER_ON = 258,
	Node_bl_icon_OUTLINER_DATA_EMPTY = 260,
	Node_bl_icon_OUTLINER_DATA_MESH = 261,
	Node_bl_icon_OUTLINER_DATA_CURVE = 262,
	Node_bl_icon_OUTLINER_DATA_LATTICE = 263,
	Node_bl_icon_OUTLINER_DATA_META = 264,
	Node_bl_icon_OUTLINER_DATA_LAMP = 265,
	Node_bl_icon_OUTLINER_DATA_CAMERA = 266,
	Node_bl_icon_OUTLINER_DATA_ARMATURE = 267,
	Node_bl_icon_OUTLINER_DATA_FONT = 268,
	Node_bl_icon_OUTLINER_DATA_SURFACE = 269,
	Node_bl_icon_OUTLINER_DATA_SPEAKER = 270,
	Node_bl_icon_OUTLINER_DATA_POSE = 271,
	Node_bl_icon_MESH_PLANE = 286,
	Node_bl_icon_MESH_CUBE = 287,
	Node_bl_icon_MESH_CIRCLE = 288,
	Node_bl_icon_MESH_UVSPHERE = 289,
	Node_bl_icon_MESH_ICOSPHERE = 290,
	Node_bl_icon_MESH_GRID = 291,
	Node_bl_icon_MESH_MONKEY = 292,
	Node_bl_icon_MESH_CYLINDER = 293,
	Node_bl_icon_MESH_TORUS = 294,
	Node_bl_icon_MESH_CONE = 295,
	Node_bl_icon_LAMP_POINT = 298,
	Node_bl_icon_LAMP_SUN = 299,
	Node_bl_icon_LAMP_SPOT = 300,
	Node_bl_icon_LAMP_HEMI = 301,
	Node_bl_icon_LAMP_AREA = 302,
	Node_bl_icon_META_EMPTY = 305,
	Node_bl_icon_META_PLANE = 306,
	Node_bl_icon_META_CUBE = 307,
	Node_bl_icon_META_BALL = 308,
	Node_bl_icon_META_ELLIPSOID = 309,
	Node_bl_icon_META_CAPSULE = 310,
	Node_bl_icon_SURFACE_NCURVE = 312,
	Node_bl_icon_SURFACE_NCIRCLE = 313,
	Node_bl_icon_SURFACE_NSURFACE = 314,
	Node_bl_icon_SURFACE_NCYLINDER = 315,
	Node_bl_icon_SURFACE_NSPHERE = 316,
	Node_bl_icon_SURFACE_NTORUS = 317,
	Node_bl_icon_CURVE_BEZCURVE = 321,
	Node_bl_icon_CURVE_BEZCIRCLE = 322,
	Node_bl_icon_CURVE_NCURVE = 323,
	Node_bl_icon_CURVE_NCIRCLE = 324,
	Node_bl_icon_CURVE_PATH = 325,
	Node_bl_icon_COLOR_RED = 331,
	Node_bl_icon_COLOR_GREEN = 332,
	Node_bl_icon_COLOR_BLUE = 333,
	Node_bl_icon_TRIA_RIGHT_BAR = 334,
	Node_bl_icon_TRIA_DOWN_BAR = 335,
	Node_bl_icon_TRIA_LEFT_BAR = 336,
	Node_bl_icon_TRIA_UP_BAR = 337,
	Node_bl_icon_FORCE_FORCE = 338,
	Node_bl_icon_FORCE_WIND = 339,
	Node_bl_icon_FORCE_VORTEX = 340,
	Node_bl_icon_FORCE_MAGNETIC = 341,
	Node_bl_icon_FORCE_HARMONIC = 342,
	Node_bl_icon_FORCE_CHARGE = 343,
	Node_bl_icon_FORCE_LENNARDJONES = 344,
	Node_bl_icon_FORCE_TEXTURE = 345,
	Node_bl_icon_FORCE_CURVE = 346,
	Node_bl_icon_FORCE_BOID = 347,
	Node_bl_icon_FORCE_TURBULENCE = 348,
	Node_bl_icon_FORCE_DRAG = 349,
	Node_bl_icon_FORCE_SMOKEFLOW = 350,
	Node_bl_icon_MODIFIER = 442,
	Node_bl_icon_MOD_WAVE = 443,
	Node_bl_icon_MOD_BUILD = 444,
	Node_bl_icon_MOD_DECIM = 445,
	Node_bl_icon_MOD_MIRROR = 446,
	Node_bl_icon_MOD_SOFT = 447,
	Node_bl_icon_MOD_SUBSURF = 448,
	Node_bl_icon_HOOK = 449,
	Node_bl_icon_MOD_PHYSICS = 450,
	Node_bl_icon_MOD_PARTICLES = 451,
	Node_bl_icon_MOD_BOOLEAN = 452,
	Node_bl_icon_MOD_EDGESPLIT = 453,
	Node_bl_icon_MOD_ARRAY = 454,
	Node_bl_icon_MOD_UVPROJECT = 455,
	Node_bl_icon_MOD_DISPLACE = 456,
	Node_bl_icon_MOD_CURVE = 457,
	Node_bl_icon_MOD_LATTICE = 458,
	Node_bl_icon_CONSTRAINT_DATA = 459,
	Node_bl_icon_MOD_ARMATURE = 460,
	Node_bl_icon_MOD_SHRINKWRAP = 461,
	Node_bl_icon_MOD_CAST = 462,
	Node_bl_icon_MOD_MESHDEFORM = 463,
	Node_bl_icon_MOD_BEVEL = 464,
	Node_bl_icon_MOD_SMOOTH = 465,
	Node_bl_icon_MOD_SIMPLEDEFORM = 466,
	Node_bl_icon_MOD_MASK = 467,
	Node_bl_icon_MOD_CLOTH = 468,
	Node_bl_icon_MOD_EXPLODE = 469,
	Node_bl_icon_MOD_FLUIDSIM = 470,
	Node_bl_icon_MOD_MULTIRES = 471,
	Node_bl_icon_MOD_SMOKE = 472,
	Node_bl_icon_MOD_SOLIDIFY = 473,
	Node_bl_icon_MOD_SCREW = 474,
	Node_bl_icon_MOD_VERTEX_WEIGHT = 475,
	Node_bl_icon_MOD_DYNAMICPAINT = 476,
	Node_bl_icon_MOD_REMESH = 477,
	Node_bl_icon_MOD_OCEAN = 478,
	Node_bl_icon_MOD_WARP = 479,
	Node_bl_icon_MOD_SKIN = 480,
	Node_bl_icon_MOD_TRIANGULATE = 481,
	Node_bl_icon_MOD_WIREFRAME = 482,
	Node_bl_icon_REC = 494,
	Node_bl_icon_PLAY = 495,
	Node_bl_icon_FF = 496,
	Node_bl_icon_REW = 497,
	Node_bl_icon_PAUSE = 498,
	Node_bl_icon_PREV_KEYFRAME = 499,
	Node_bl_icon_NEXT_KEYFRAME = 500,
	Node_bl_icon_PLAY_AUDIO = 501,
	Node_bl_icon_PLAY_REVERSE = 502,
	Node_bl_icon_PREVIEW_RANGE = 503,
	Node_bl_icon_ACTION_TWEAK = 504,
	Node_bl_icon_PMARKER_ACT = 505,
	Node_bl_icon_PMARKER_SEL = 506,
	Node_bl_icon_PMARKER = 507,
	Node_bl_icon_MARKER_HLT = 508,
	Node_bl_icon_MARKER = 509,
	Node_bl_icon_SPACE2 = 510,
	Node_bl_icon_SPACE3 = 511,
	Node_bl_icon_KEYINGSET = 512,
	Node_bl_icon_KEY_DEHLT = 513,
	Node_bl_icon_KEY_HLT = 514,
	Node_bl_icon_MUTE_IPO_OFF = 515,
	Node_bl_icon_MUTE_IPO_ON = 516,
	Node_bl_icon_VISIBLE_IPO_OFF = 517,
	Node_bl_icon_VISIBLE_IPO_ON = 518,
	Node_bl_icon_DRIVER = 519,
	Node_bl_icon_SOLO_OFF = 520,
	Node_bl_icon_SOLO_ON = 521,
	Node_bl_icon_FRAME_PREV = 522,
	Node_bl_icon_FRAME_NEXT = 523,
	Node_bl_icon_NLA_PUSHDOWN = 524,
	Node_bl_icon_IPO_CONSTANT = 525,
	Node_bl_icon_IPO_LINEAR = 526,
	Node_bl_icon_IPO_BEZIER = 527,
	Node_bl_icon_IPO_SINE = 528,
	Node_bl_icon_IPO_QUAD = 529,
	Node_bl_icon_IPO_CUBIC = 530,
	Node_bl_icon_IPO_QUART = 531,
	Node_bl_icon_IPO_QUINT = 532,
	Node_bl_icon_IPO_EXPO = 533,
	Node_bl_icon_IPO_CIRC = 534,
	Node_bl_icon_IPO_BOUNCE = 535,
	Node_bl_icon_IPO_ELASTIC = 536,
	Node_bl_icon_IPO_BACK = 537,
	Node_bl_icon_IPO_EASE_IN = 538,
	Node_bl_icon_IPO_EASE_OUT = 539,
	Node_bl_icon_IPO_EASE_IN_OUT = 540,
	Node_bl_icon_VERTEXSEL = 546,
	Node_bl_icon_EDGESEL = 547,
	Node_bl_icon_FACESEL = 548,
	Node_bl_icon_LOOPSEL = 549,
	Node_bl_icon_ROTATE = 551,
	Node_bl_icon_CURSOR = 552,
	Node_bl_icon_ROTATECOLLECTION = 553,
	Node_bl_icon_ROTATECENTER = 554,
	Node_bl_icon_ROTACTIVE = 555,
	Node_bl_icon_ALIGN = 556,
	Node_bl_icon_SMOOTHCURVE = 558,
	Node_bl_icon_SPHERECURVE = 559,
	Node_bl_icon_ROOTCURVE = 560,
	Node_bl_icon_SHARPCURVE = 561,
	Node_bl_icon_LINCURVE = 562,
	Node_bl_icon_NOCURVE = 563,
	Node_bl_icon_RNDCURVE = 564,
	Node_bl_icon_PROP_OFF = 565,
	Node_bl_icon_PROP_ON = 566,
	Node_bl_icon_PROP_CON = 567,
	Node_bl_icon_SCULPT_DYNTOPO = 568,
	Node_bl_icon_PARTICLE_POINT = 569,
	Node_bl_icon_PARTICLE_TIP = 570,
	Node_bl_icon_PARTICLE_PATH = 571,
	Node_bl_icon_MAN_TRANS = 572,
	Node_bl_icon_MAN_ROT = 573,
	Node_bl_icon_MAN_SCALE = 574,
	Node_bl_icon_MANIPUL = 575,
	Node_bl_icon_SNAP_OFF = 576,
	Node_bl_icon_SNAP_ON = 577,
	Node_bl_icon_SNAP_NORMAL = 578,
	Node_bl_icon_SNAP_INCREMENT = 579,
	Node_bl_icon_SNAP_VERTEX = 580,
	Node_bl_icon_SNAP_EDGE = 581,
	Node_bl_icon_SNAP_FACE = 582,
	Node_bl_icon_SNAP_VOLUME = 583,
	Node_bl_icon_STICKY_UVS_LOC = 585,
	Node_bl_icon_STICKY_UVS_DISABLE = 586,
	Node_bl_icon_STICKY_UVS_VERT = 587,
	Node_bl_icon_CLIPUV_DEHLT = 588,
	Node_bl_icon_CLIPUV_HLT = 589,
	Node_bl_icon_SNAP_PEEL_OBJECT = 590,
	Node_bl_icon_GRID = 591,
	Node_bl_icon_PASTEDOWN = 598,
	Node_bl_icon_COPYDOWN = 599,
	Node_bl_icon_PASTEFLIPUP = 600,
	Node_bl_icon_PASTEFLIPDOWN = 601,
	Node_bl_icon_SNAP_SURFACE = 606,
	Node_bl_icon_AUTOMERGE_ON = 607,
	Node_bl_icon_AUTOMERGE_OFF = 608,
	Node_bl_icon_RETOPO = 609,
	Node_bl_icon_UV_VERTEXSEL = 610,
	Node_bl_icon_UV_EDGESEL = 611,
	Node_bl_icon_UV_FACESEL = 612,
	Node_bl_icon_UV_ISLANDSEL = 613,
	Node_bl_icon_UV_SYNC_SELECT = 614,
	Node_bl_icon_BBOX = 624,
	Node_bl_icon_WIRE = 625,
	Node_bl_icon_SOLID = 626,
	Node_bl_icon_SMOOTH = 627,
	Node_bl_icon_POTATO = 628,
	Node_bl_icon_ORTHO = 630,
	Node_bl_icon_LOCKVIEW_OFF = 633,
	Node_bl_icon_LOCKVIEW_ON = 634,
	Node_bl_icon_AXIS_SIDE = 636,
	Node_bl_icon_AXIS_FRONT = 637,
	Node_bl_icon_AXIS_TOP = 638,
	Node_bl_icon_NDOF_DOM = 639,
	Node_bl_icon_NDOF_TURN = 640,
	Node_bl_icon_NDOF_FLY = 641,
	Node_bl_icon_NDOF_TRANS = 642,
	Node_bl_icon_LAYER_USED = 643,
	Node_bl_icon_LAYER_ACTIVE = 644,
	Node_bl_icon_SORTALPHA = 676,
	Node_bl_icon_SORTBYEXT = 677,
	Node_bl_icon_SORTTIME = 678,
	Node_bl_icon_SORTSIZE = 679,
	Node_bl_icon_LONGDISPLAY = 680,
	Node_bl_icon_SHORTDISPLAY = 681,
	Node_bl_icon_GHOST = 682,
	Node_bl_icon_IMGDISPLAY = 683,
	Node_bl_icon_SAVE_AS = 684,
	Node_bl_icon_SAVE_COPY = 685,
	Node_bl_icon_BOOKMARKS = 686,
	Node_bl_icon_FONTPREVIEW = 687,
	Node_bl_icon_FILTER = 688,
	Node_bl_icon_NEWFOLDER = 689,
	Node_bl_icon_OPEN_RECENT = 690,
	Node_bl_icon_FILE_PARENT = 691,
	Node_bl_icon_FILE_REFRESH = 692,
	Node_bl_icon_FILE_FOLDER = 693,
	Node_bl_icon_FILE_BLANK = 694,
	Node_bl_icon_FILE_BLEND = 695,
	Node_bl_icon_FILE_IMAGE = 696,
	Node_bl_icon_FILE_MOVIE = 697,
	Node_bl_icon_FILE_SCRIPT = 698,
	Node_bl_icon_FILE_SOUND = 699,
	Node_bl_icon_FILE_FONT = 700,
	Node_bl_icon_FILE_TEXT = 701,
	Node_bl_icon_RECOVER_AUTO = 702,
	Node_bl_icon_SAVE_PREFS = 703,
	Node_bl_icon_LINK_BLEND = 704,
	Node_bl_icon_APPEND_BLEND = 705,
	Node_bl_icon_IMPORT = 706,
	Node_bl_icon_EXPORT = 707,
	Node_bl_icon_EXTERNAL_DATA = 708,
	Node_bl_icon_LOAD_FACTORY = 709,
	Node_bl_icon_LOOP_BACK = 715,
	Node_bl_icon_LOOP_FORWARDS = 716,
	Node_bl_icon_BACK = 717,
	Node_bl_icon_FORWARD = 718,
	Node_bl_icon_FILE_BACKUP = 726,
	Node_bl_icon_DISK_DRIVE = 727,
	Node_bl_icon_MATPLANE = 728,
	Node_bl_icon_MATSPHERE = 729,
	Node_bl_icon_MATCUBE = 730,
	Node_bl_icon_MONKEY = 731,
	Node_bl_icon_HAIR = 732,
	Node_bl_icon_ALIASED = 733,
	Node_bl_icon_ANTIALIASED = 734,
	Node_bl_icon_MAT_SPHERE_SKY = 735,
	Node_bl_icon_WORDWRAP_OFF = 740,
	Node_bl_icon_WORDWRAP_ON = 741,
	Node_bl_icon_SYNTAX_OFF = 742,
	Node_bl_icon_SYNTAX_ON = 743,
	Node_bl_icon_LINENUMBERS_OFF = 744,
	Node_bl_icon_LINENUMBERS_ON = 745,
	Node_bl_icon_SCRIPTPLUGINS = 746,
	Node_bl_icon_SEQ_SEQUENCER = 754,
	Node_bl_icon_SEQ_PREVIEW = 755,
	Node_bl_icon_SEQ_LUMA_WAVEFORM = 756,
	Node_bl_icon_SEQ_CHROMA_SCOPE = 757,
	Node_bl_icon_SEQ_HISTOGRAM = 758,
	Node_bl_icon_SEQ_SPLITVIEW = 759,
	Node_bl_icon_IMAGE_RGB = 763,
	Node_bl_icon_IMAGE_RGB_ALPHA = 764,
	Node_bl_icon_IMAGE_ALPHA = 765,
	Node_bl_icon_IMAGE_ZDEPTH = 766,
	Node_bl_icon_IMAGEFILE = 767,
	Node_bl_icon_BRUSH_ADD = 780,
	Node_bl_icon_BRUSH_BLOB = 781,
	Node_bl_icon_BRUSH_BLUR = 782,
	Node_bl_icon_BRUSH_CLAY = 783,
	Node_bl_icon_BRUSH_CLAY_STRIPS = 784,
	Node_bl_icon_BRUSH_CLONE = 785,
	Node_bl_icon_BRUSH_CREASE = 786,
	Node_bl_icon_BRUSH_DARKEN = 787,
	Node_bl_icon_BRUSH_FILL = 788,
	Node_bl_icon_BRUSH_FLATTEN = 789,
	Node_bl_icon_BRUSH_GRAB = 790,
	Node_bl_icon_BRUSH_INFLATE = 791,
	Node_bl_icon_BRUSH_LAYER = 792,
	Node_bl_icon_BRUSH_LIGHTEN = 793,
	Node_bl_icon_BRUSH_MASK = 794,
	Node_bl_icon_BRUSH_MIX = 795,
	Node_bl_icon_BRUSH_MULTIPLY = 796,
	Node_bl_icon_BRUSH_NUDGE = 797,
	Node_bl_icon_BRUSH_PINCH = 798,
	Node_bl_icon_BRUSH_SCRAPE = 799,
	Node_bl_icon_BRUSH_SCULPT_DRAW = 800,
	Node_bl_icon_BRUSH_SMEAR = 801,
	Node_bl_icon_BRUSH_SMOOTH = 802,
	Node_bl_icon_BRUSH_SNAKE_HOOK = 803,
	Node_bl_icon_BRUSH_SOFTEN = 804,
	Node_bl_icon_BRUSH_SUBTRACT = 805,
	Node_bl_icon_BRUSH_TEXDRAW = 806,
	Node_bl_icon_BRUSH_TEXFILL = 807,
	Node_bl_icon_BRUSH_TEXMASK = 808,
	Node_bl_icon_BRUSH_THUMB = 809,
	Node_bl_icon_BRUSH_ROTATE = 810,
	Node_bl_icon_BRUSH_VERTEXDRAW = 811,
	Node_bl_icon_MATCAP_01 = 812,
	Node_bl_icon_MATCAP_02 = 813,
	Node_bl_icon_MATCAP_03 = 814,
	Node_bl_icon_MATCAP_04 = 815,
	Node_bl_icon_MATCAP_05 = 816,
	Node_bl_icon_MATCAP_06 = 817,
	Node_bl_icon_MATCAP_07 = 818,
	Node_bl_icon_MATCAP_08 = 819,
	Node_bl_icon_MATCAP_09 = 820,
	Node_bl_icon_MATCAP_10 = 821,
	Node_bl_icon_MATCAP_11 = 822,
	Node_bl_icon_MATCAP_12 = 823,
	Node_bl_icon_MATCAP_13 = 824,
	Node_bl_icon_MATCAP_14 = 825,
	Node_bl_icon_MATCAP_15 = 826,
	Node_bl_icon_MATCAP_16 = 827,
	Node_bl_icon_MATCAP_17 = 828,
	Node_bl_icon_MATCAP_18 = 829,
	Node_bl_icon_MATCAP_19 = 830,
	Node_bl_icon_MATCAP_20 = 831,
	Node_bl_icon_MATCAP_21 = 832,
	Node_bl_icon_MATCAP_22 = 833,
	Node_bl_icon_MATCAP_23 = 834,
	Node_bl_icon_MATCAP_24 = 835,
};

int Node_bl_icon_get(PointerRNA *ptr);
void Node_bl_icon_set(PointerRNA *ptr, int value);

void Node_inputs_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Node_inputs_next(CollectionPropertyIterator *iter);
void Node_inputs_end(CollectionPropertyIterator *iter);
int Node_inputs_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Node_inputs_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Node_internal_links_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Node_internal_links_next(CollectionPropertyIterator *iter);
void Node_internal_links_end(CollectionPropertyIterator *iter);
int Node_internal_links_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

#define Node_label_MAX 64

void Node_label_get(PointerRNA *ptr, char *value);
int Node_label_length(PointerRNA *ptr);
void Node_label_set(PointerRNA *ptr, const char *value);

void Node_bl_label_get(PointerRNA *ptr, char *value);
int Node_bl_label_length(PointerRNA *ptr);
void Node_bl_label_set(PointerRNA *ptr, const char *value);

void Node_location_get(PointerRNA *ptr, float values[2]);
void Node_location_set(PointerRNA *ptr, const float values[2]);

int Node_mute_get(PointerRNA *ptr);
void Node_mute_set(PointerRNA *ptr, int value);

void Node_outputs_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Node_outputs_next(CollectionPropertyIterator *iter);
void Node_outputs_end(CollectionPropertyIterator *iter);
int Node_outputs_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Node_outputs_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA Node_parent_get(PointerRNA *ptr);

int Node_select_get(PointerRNA *ptr);
void Node_select_set(PointerRNA *ptr, int value);

int Node_show_options_get(PointerRNA *ptr);
void Node_show_options_set(PointerRNA *ptr, int value);

int Node_show_preview_get(PointerRNA *ptr);
void Node_show_preview_set(PointerRNA *ptr, int value);

int Node_show_texture_get(PointerRNA *ptr);
void Node_show_texture_set(PointerRNA *ptr, int value);

enum {
	Node_bl_static_type_CUSTOM = -1,
};

int Node_bl_static_type_get(PointerRNA *ptr);
void Node_bl_static_type_set(PointerRNA *ptr, int value);

enum {
	Node_type_CUSTOM = -1,
};

int Node_type_get(PointerRNA *ptr);
void Node_type_set(PointerRNA *ptr, int value);

float Node_width_get(PointerRNA *ptr);
void Node_width_set(PointerRNA *ptr, float value);

float Node_width_hidden_get(PointerRNA *ptr);
void Node_width_hidden_set(PointerRNA *ptr, float value);

void Node_bl_description_get(PointerRNA *ptr, char *value);
int Node_bl_description_length(PointerRNA *ptr);
void Node_bl_description_set(PointerRNA *ptr, const char *value);

float Node_bl_height_default_get(PointerRNA *ptr);
void Node_bl_height_default_set(PointerRNA *ptr, float value);

float Node_bl_height_max_get(PointerRNA *ptr);
void Node_bl_height_max_set(PointerRNA *ptr, float value);

float Node_bl_height_min_get(PointerRNA *ptr);
void Node_bl_height_min_set(PointerRNA *ptr, float value);

float Node_bl_width_default_get(PointerRNA *ptr);
void Node_bl_width_default_set(PointerRNA *ptr, float value);

float Node_bl_width_max_get(PointerRNA *ptr);
void Node_bl_width_max_set(PointerRNA *ptr, float value);

float Node_bl_width_min_get(PointerRNA *ptr);
void Node_bl_width_min_set(PointerRNA *ptr, float value);

void Node_socket_value_update(struct ID *_selfid, struct bNode *_self, struct bContext *context);
int Node_is_registered_node_type(struct StructRNA *_type);
int Node_poll(struct bNodeTree *node_tree);
int Node_poll_instance(struct bNode *_self, struct bNodeTree *node_tree);
void Node_update(struct ID *_selfid, struct bNode *_self);
void Node_init(struct bNode *_self, struct bContext *context);
void Node_copy(struct bNode *_self, struct bNode *node);
void Node_free(struct bNode *_self);
void Node_draw_buttons(struct bNode *_self, struct bContext *context, struct uiLayout *layout);
void Node_draw_buttons_ext(struct bNode *_self, struct bContext *context, struct uiLayout *layout);
void Node_draw_label(struct bNode *_self, char * label);
/**************** Custom Group ****************/

extern StructRNA RNA_NodeCustomGroup;
extern StructRNA RNA_Node;

PointerRNA NodeCustomGroup_node_tree_get(PointerRNA *ptr);

/**************** Frame ****************/

extern StructRNA RNA_NodeFrame;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int NodeFrame_label_size_get(PointerRNA *ptr);
void NodeFrame_label_size_set(PointerRNA *ptr, int value);

int NodeFrame_shrink_get(PointerRNA *ptr);
void NodeFrame_shrink_set(PointerRNA *ptr, int value);

int NodeFrame_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA NodeFrame_input_template(struct StructRNA *_type, int index);
struct PointerRNA NodeFrame_output_template(struct StructRNA *_type, int index);
/**************** Group ****************/

extern StructRNA RNA_NodeGroup;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA NodeGroup_node_tree_get(PointerRNA *ptr);

int NodeGroup_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA NodeGroup_input_template(struct StructRNA *_type, int index);
struct PointerRNA NodeGroup_output_template(struct StructRNA *_type, int index);
/**************** Group Input ****************/

extern StructRNA RNA_NodeGroupInput;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int NodeGroupInput_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA NodeGroupInput_input_template(struct StructRNA *_type, int index);
struct PointerRNA NodeGroupInput_output_template(struct StructRNA *_type, int index);
/**************** Group Output ****************/

extern StructRNA RNA_NodeGroupOutput;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int NodeGroupOutput_is_active_output_get(PointerRNA *ptr);
void NodeGroupOutput_is_active_output_set(PointerRNA *ptr, int value);

int NodeGroupOutput_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA NodeGroupOutput_input_template(struct StructRNA *_type, int index);
struct PointerRNA NodeGroupOutput_output_template(struct StructRNA *_type, int index);
/**************** Node Inputs ****************/

extern StructRNA RNA_NodeInputs;

PointerRNA NodeInputs_rna_type_get(PointerRNA *ptr);

struct bNodeSocket *NodeInputs_new(struct ID *_selfid, struct bNode *_self, ReportList *reports, const char * type, const char * name, const char * identifier);
void NodeInputs_remove(struct ID *_selfid, struct bNode *_self, ReportList *reports, struct bNodeSocket *socket);
void NodeInputs_clear(struct ID *_selfid, struct bNode *_self);
void NodeInputs_move(struct ID *_selfid, struct bNode *_self, int from_index, int to_index);
/**************** Node Instance Hash ****************/

extern StructRNA RNA_NodeInstanceHash;

PointerRNA NodeInstanceHash_rna_type_get(PointerRNA *ptr);

/**************** NodeInternal ****************/

extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int NodeInternal_poll(struct StructRNA *_type, struct bNodeTree *node_tree);
int NodeInternal_poll_instance(struct bNode *_self, struct bNodeTree *node_tree);
void NodeInternal_update(struct ID *_selfid, struct bNode *_self);
void NodeInternal_draw_buttons(struct ID *_selfid, struct bNode *_self, struct bContext *context, struct uiLayout *layout);
void NodeInternal_draw_buttons_ext(struct ID *_selfid, struct bNode *_self, struct bContext *context, struct uiLayout *layout);
/**************** Socket Template ****************/

extern StructRNA RNA_NodeInternalSocketTemplate;

PointerRNA NodeInternalSocketTemplate_rna_type_get(PointerRNA *ptr);

void NodeInternalSocketTemplate_name_get(PointerRNA *ptr, char *value);
int NodeInternalSocketTemplate_name_length(PointerRNA *ptr);
void NodeInternalSocketTemplate_name_set(PointerRNA *ptr, const char *value);

void NodeInternalSocketTemplate_identifier_get(PointerRNA *ptr, char *value);
int NodeInternalSocketTemplate_identifier_length(PointerRNA *ptr);
void NodeInternalSocketTemplate_identifier_set(PointerRNA *ptr, const char *value);

enum {
	NodeInternalSocketTemplate_type_CUSTOM = -1,
	NodeInternalSocketTemplate_type_VALUE = 0,
	NodeInternalSocketTemplate_type_INT = 6,
	NodeInternalSocketTemplate_type_BOOLEAN = 4,
	NodeInternalSocketTemplate_type_VECTOR = 1,
	NodeInternalSocketTemplate_type_STRING = 7,
	NodeInternalSocketTemplate_type_RGBA = 2,
	NodeInternalSocketTemplate_type_SHADER = 3,
};

int NodeInternalSocketTemplate_type_get(PointerRNA *ptr);
void NodeInternalSocketTemplate_type_set(PointerRNA *ptr, int value);

/**************** Valid ****************/

extern StructRNA RNA_NodeLink;

PointerRNA NodeLink_rna_type_get(PointerRNA *ptr);

PointerRNA NodeLink_from_node_get(PointerRNA *ptr);

PointerRNA NodeLink_from_socket_get(PointerRNA *ptr);

int NodeLink_is_hidden_get(PointerRNA *ptr);
void NodeLink_is_hidden_set(PointerRNA *ptr, int value);

PointerRNA NodeLink_to_node_get(PointerRNA *ptr);

PointerRNA NodeLink_to_socket_get(PointerRNA *ptr);

int NodeLink_is_valid_get(PointerRNA *ptr);
void NodeLink_is_valid_set(PointerRNA *ptr, int value);

/**************** Node Links ****************/

extern StructRNA RNA_NodeLinks;

PointerRNA NodeLinks_rna_type_get(PointerRNA *ptr);

struct bNodeLink *NodeLinks_new(struct bNodeTree *_self, ReportList *reports, struct bNodeSocket *input, struct bNodeSocket *output, int verify_limits);
void NodeLinks_remove(struct bNodeTree *_self, ReportList *reports, struct PointerRNA *link);
void NodeLinks_clear(struct bNodeTree *_self, ReportList *reports);
/**************** Output File Slot ****************/

extern StructRNA RNA_NodeOutputFileSlotFile;

PointerRNA NodeOutputFileSlotFile_rna_type_get(PointerRNA *ptr);

#define NodeOutputFileSlotFile_path_MAX 1024

void NodeOutputFileSlotFile_path_get(PointerRNA *ptr, char *value);
int NodeOutputFileSlotFile_path_length(PointerRNA *ptr);
void NodeOutputFileSlotFile_path_set(PointerRNA *ptr, const char *value);

int NodeOutputFileSlotFile_use_node_format_get(PointerRNA *ptr);
void NodeOutputFileSlotFile_use_node_format_set(PointerRNA *ptr, int value);

PointerRNA NodeOutputFileSlotFile_format_get(PointerRNA *ptr);

/**************** Output File Layer Slot ****************/

extern StructRNA RNA_NodeOutputFileSlotLayer;

PointerRNA NodeOutputFileSlotLayer_rna_type_get(PointerRNA *ptr);

#define NodeOutputFileSlotLayer_name_MAX 30

void NodeOutputFileSlotLayer_name_get(PointerRNA *ptr, char *value);
int NodeOutputFileSlotLayer_name_length(PointerRNA *ptr);
void NodeOutputFileSlotLayer_name_set(PointerRNA *ptr, const char *value);

/**************** Node Outputs ****************/

extern StructRNA RNA_NodeOutputs;

PointerRNA NodeOutputs_rna_type_get(PointerRNA *ptr);

struct bNodeSocket *NodeOutputs_new(struct ID *_selfid, struct bNode *_self, ReportList *reports, const char * type, const char * name, const char * identifier);
void NodeOutputs_remove(struct ID *_selfid, struct bNode *_self, ReportList *reports, struct bNodeSocket *socket);
void NodeOutputs_clear(struct ID *_selfid, struct bNode *_self);
void NodeOutputs_move(struct ID *_selfid, struct bNode *_self, int from_index, int to_index);
/**************** Reroute ****************/

extern StructRNA RNA_NodeReroute;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int NodeReroute_is_registered_node_type(struct StructRNA *_type);
struct PointerRNA NodeReroute_input_template(struct StructRNA *_type, int index);
struct PointerRNA NodeReroute_output_template(struct StructRNA *_type, int index);
/**************** Node Socket ****************/

extern StructRNA RNA_NodeSocket;

PointerRNA NodeSocket_rna_type_get(PointerRNA *ptr);

#define NodeSocket_name_MAX 64

void NodeSocket_name_get(PointerRNA *ptr, char *value);
int NodeSocket_name_length(PointerRNA *ptr);
void NodeSocket_name_set(PointerRNA *ptr, const char *value);

int NodeSocket_enabled_get(PointerRNA *ptr);
void NodeSocket_enabled_set(PointerRNA *ptr, int value);

int NodeSocket_show_expanded_get(PointerRNA *ptr);
void NodeSocket_show_expanded_set(PointerRNA *ptr, int value);

int NodeSocket_hide_get(PointerRNA *ptr);
void NodeSocket_hide_set(PointerRNA *ptr, int value);

int NodeSocket_hide_value_get(PointerRNA *ptr);
void NodeSocket_hide_value_set(PointerRNA *ptr, int value);

void NodeSocket_bl_idname_get(PointerRNA *ptr, char *value);
int NodeSocket_bl_idname_length(PointerRNA *ptr);
void NodeSocket_bl_idname_set(PointerRNA *ptr, const char *value);

#define NodeSocket_identifier_MAX 64

void NodeSocket_identifier_get(PointerRNA *ptr, char *value);
int NodeSocket_identifier_length(PointerRNA *ptr);
void NodeSocket_identifier_set(PointerRNA *ptr, const char *value);

int NodeSocket_is_output_get(PointerRNA *ptr);
void NodeSocket_is_output_set(PointerRNA *ptr, int value);

int NodeSocket_link_limit_get(PointerRNA *ptr);
void NodeSocket_link_limit_set(PointerRNA *ptr, int value);

int NodeSocket_is_linked_get(PointerRNA *ptr);
void NodeSocket_is_linked_set(PointerRNA *ptr, int value);

PointerRNA NodeSocket_node_get(PointerRNA *ptr);

enum {
	NodeSocket_type_CUSTOM = -1,
	NodeSocket_type_VALUE = 0,
	NodeSocket_type_INT = 6,
	NodeSocket_type_BOOLEAN = 4,
	NodeSocket_type_VECTOR = 1,
	NodeSocket_type_STRING = 7,
	NodeSocket_type_RGBA = 2,
	NodeSocket_type_SHADER = 3,
};

int NodeSocket_type_get(PointerRNA *ptr);
void NodeSocket_type_set(PointerRNA *ptr, int value);

void NodeSocket_draw(struct bNodeSocket *_self, struct bContext *context, struct uiLayout *layout, struct PointerRNA *node, const char * text);
void NodeSocket_draw_color(struct bNodeSocket *_self, struct bContext *context, struct PointerRNA *node, float color[4]);
/**************** Boolean Node Socket ****************/

extern StructRNA RNA_NodeSocketBool;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

int NodeSocketBool_default_value_get(PointerRNA *ptr);
void NodeSocketBool_default_value_set(PointerRNA *ptr, int value);

/**************** Color Node Socket ****************/

extern StructRNA RNA_NodeSocketColor;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

void NodeSocketColor_default_value_get(PointerRNA *ptr, float values[4]);
void NodeSocketColor_default_value_set(PointerRNA *ptr, const float values[4]);

/**************** Float Node Socket ****************/

extern StructRNA RNA_NodeSocketFloat;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

float NodeSocketFloat_default_value_get(PointerRNA *ptr);
void NodeSocketFloat_default_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket ****************/

extern StructRNA RNA_NodeSocketFloatAngle;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

float NodeSocketFloatAngle_default_value_get(PointerRNA *ptr);
void NodeSocketFloatAngle_default_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket ****************/

extern StructRNA RNA_NodeSocketFloatFactor;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

float NodeSocketFloatFactor_default_value_get(PointerRNA *ptr);
void NodeSocketFloatFactor_default_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket ****************/

extern StructRNA RNA_NodeSocketFloatPercentage;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

float NodeSocketFloatPercentage_default_value_get(PointerRNA *ptr);
void NodeSocketFloatPercentage_default_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket ****************/

extern StructRNA RNA_NodeSocketFloatTime;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

float NodeSocketFloatTime_default_value_get(PointerRNA *ptr);
void NodeSocketFloatTime_default_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket ****************/

extern StructRNA RNA_NodeSocketFloatUnsigned;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

float NodeSocketFloatUnsigned_default_value_get(PointerRNA *ptr);
void NodeSocketFloatUnsigned_default_value_set(PointerRNA *ptr, float value);

/**************** Integer Node Socket ****************/

extern StructRNA RNA_NodeSocketInt;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

int NodeSocketInt_default_value_get(PointerRNA *ptr);
void NodeSocketInt_default_value_set(PointerRNA *ptr, int value);

/**************** Integer Node Socket ****************/

extern StructRNA RNA_NodeSocketIntFactor;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

int NodeSocketIntFactor_default_value_get(PointerRNA *ptr);
void NodeSocketIntFactor_default_value_set(PointerRNA *ptr, int value);

/**************** Integer Node Socket ****************/

extern StructRNA RNA_NodeSocketIntPercentage;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

int NodeSocketIntPercentage_default_value_get(PointerRNA *ptr);
void NodeSocketIntPercentage_default_value_set(PointerRNA *ptr, int value);

/**************** Integer Node Socket ****************/

extern StructRNA RNA_NodeSocketIntUnsigned;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

int NodeSocketIntUnsigned_default_value_get(PointerRNA *ptr);
void NodeSocketIntUnsigned_default_value_set(PointerRNA *ptr, int value);

/**************** Node Socket Template ****************/

extern StructRNA RNA_NodeSocketInterface;

PointerRNA NodeSocketInterface_rna_type_get(PointerRNA *ptr);

#define NodeSocketInterface_name_MAX 64

void NodeSocketInterface_name_get(PointerRNA *ptr, char *value);
int NodeSocketInterface_name_length(PointerRNA *ptr);
void NodeSocketInterface_name_set(PointerRNA *ptr, const char *value);

void NodeSocketInterface_bl_socket_idname_get(PointerRNA *ptr, char *value);
int NodeSocketInterface_bl_socket_idname_length(PointerRNA *ptr);
void NodeSocketInterface_bl_socket_idname_set(PointerRNA *ptr, const char *value);

#define NodeSocketInterface_identifier_MAX 64

void NodeSocketInterface_identifier_get(PointerRNA *ptr, char *value);
int NodeSocketInterface_identifier_length(PointerRNA *ptr);
void NodeSocketInterface_identifier_set(PointerRNA *ptr, const char *value);

int NodeSocketInterface_is_output_get(PointerRNA *ptr);
void NodeSocketInterface_is_output_set(PointerRNA *ptr, int value);

void NodeSocketInterface_draw(struct bNodeSocket *_self, struct bContext *context, struct uiLayout *layout);
void NodeSocketInterface_draw_color(struct bNodeSocket *_self, struct bContext *context, float color[4]);
void NodeSocketInterface_register_properties(struct bNodeSocket *_self, struct Struct *data_rna_type);
void NodeSocketInterface_init_socket(struct bNodeSocket *_self, struct PointerRNA *node, struct PointerRNA *socket, const char * data_path);
void NodeSocketInterface_from_socket(struct bNodeSocket *_self, struct PointerRNA *node, struct PointerRNA *socket);
/**************** Boolean Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceBool;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

int NodeSocketInterfaceBool_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceBool_default_value_set(PointerRNA *ptr, int value);

/**************** Color Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceColor;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

void NodeSocketInterfaceColor_default_value_get(PointerRNA *ptr, float values[4]);
void NodeSocketInterfaceColor_default_value_set(PointerRNA *ptr, const float values[4]);

/**************** Float Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceFloat;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

float NodeSocketInterfaceFloat_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloat_default_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloat_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloat_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloat_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloat_min_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceFloatAngle;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

float NodeSocketInterfaceFloatAngle_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatAngle_default_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatAngle_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatAngle_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatAngle_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatAngle_min_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceFloatFactor;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

float NodeSocketInterfaceFloatFactor_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatFactor_default_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatFactor_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatFactor_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatFactor_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatFactor_min_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceFloatPercentage;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

float NodeSocketInterfaceFloatPercentage_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatPercentage_default_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatPercentage_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatPercentage_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatPercentage_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatPercentage_min_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceFloatTime;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

float NodeSocketInterfaceFloatTime_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatTime_default_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatTime_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatTime_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatTime_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatTime_min_value_set(PointerRNA *ptr, float value);

/**************** Float Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceFloatUnsigned;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

float NodeSocketInterfaceFloatUnsigned_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatUnsigned_default_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatUnsigned_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatUnsigned_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceFloatUnsigned_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceFloatUnsigned_min_value_set(PointerRNA *ptr, float value);

/**************** Integer Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceInt;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

int NodeSocketInterfaceInt_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceInt_default_value_set(PointerRNA *ptr, int value);

int NodeSocketInterfaceInt_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceInt_max_value_set(PointerRNA *ptr, int value);

int NodeSocketInterfaceInt_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceInt_min_value_set(PointerRNA *ptr, int value);

/**************** Integer Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceIntFactor;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

int NodeSocketInterfaceIntFactor_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceIntFactor_default_value_set(PointerRNA *ptr, int value);

int NodeSocketInterfaceIntFactor_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceIntFactor_max_value_set(PointerRNA *ptr, int value);

int NodeSocketInterfaceIntFactor_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceIntFactor_min_value_set(PointerRNA *ptr, int value);

/**************** Integer Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceIntPercentage;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

int NodeSocketInterfaceIntPercentage_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceIntPercentage_default_value_set(PointerRNA *ptr, int value);

int NodeSocketInterfaceIntPercentage_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceIntPercentage_max_value_set(PointerRNA *ptr, int value);

int NodeSocketInterfaceIntPercentage_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceIntPercentage_min_value_set(PointerRNA *ptr, int value);

/**************** Integer Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceIntUnsigned;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

int NodeSocketInterfaceIntUnsigned_default_value_get(PointerRNA *ptr);
void NodeSocketInterfaceIntUnsigned_default_value_set(PointerRNA *ptr, int value);

int NodeSocketInterfaceIntUnsigned_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceIntUnsigned_max_value_set(PointerRNA *ptr, int value);

int NodeSocketInterfaceIntUnsigned_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceIntUnsigned_min_value_set(PointerRNA *ptr, int value);

/**************** Shader Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceShader;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

/**************** NodeSocketInterfaceStandard ****************/

extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

enum {
	NodeSocketInterfaceStandard_type_CUSTOM = -1,
	NodeSocketInterfaceStandard_type_VALUE = 0,
	NodeSocketInterfaceStandard_type_INT = 6,
	NodeSocketInterfaceStandard_type_BOOLEAN = 4,
	NodeSocketInterfaceStandard_type_VECTOR = 1,
	NodeSocketInterfaceStandard_type_STRING = 7,
	NodeSocketInterfaceStandard_type_RGBA = 2,
	NodeSocketInterfaceStandard_type_SHADER = 3,
};

int NodeSocketInterfaceStandard_type_get(PointerRNA *ptr);
void NodeSocketInterfaceStandard_type_set(PointerRNA *ptr, int value);

void NodeSocketInterfaceStandard_draw(struct ID *_selfid, struct bNodeSocket *_self, struct bContext *context, struct uiLayout *layout);
void NodeSocketInterfaceStandard_draw_color(struct ID *_selfid, struct bNodeSocket *_self, struct bContext *context, float color[4]);
/**************** String Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceString;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

#define NodeSocketInterfaceString_default_value_MAX 1024

void NodeSocketInterfaceString_default_value_get(PointerRNA *ptr, char *value);
int NodeSocketInterfaceString_default_value_length(PointerRNA *ptr);
void NodeSocketInterfaceString_default_value_set(PointerRNA *ptr, const char *value);

/**************** Vector Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceVector;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

void NodeSocketInterfaceVector_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketInterfaceVector_default_value_set(PointerRNA *ptr, const float values[3]);

float NodeSocketInterfaceVector_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVector_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceVector_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVector_min_value_set(PointerRNA *ptr, float value);

/**************** Vector Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceVectorAcceleration;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

void NodeSocketInterfaceVectorAcceleration_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketInterfaceVectorAcceleration_default_value_set(PointerRNA *ptr, const float values[3]);

float NodeSocketInterfaceVectorAcceleration_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorAcceleration_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceVectorAcceleration_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorAcceleration_min_value_set(PointerRNA *ptr, float value);

/**************** Vector Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceVectorDirection;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

void NodeSocketInterfaceVectorDirection_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketInterfaceVectorDirection_default_value_set(PointerRNA *ptr, const float values[3]);

float NodeSocketInterfaceVectorDirection_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorDirection_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceVectorDirection_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorDirection_min_value_set(PointerRNA *ptr, float value);

/**************** Vector Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceVectorEuler;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

void NodeSocketInterfaceVectorEuler_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketInterfaceVectorEuler_default_value_set(PointerRNA *ptr, const float values[3]);

float NodeSocketInterfaceVectorEuler_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorEuler_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceVectorEuler_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorEuler_min_value_set(PointerRNA *ptr, float value);

/**************** Vector Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceVectorTranslation;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

void NodeSocketInterfaceVectorTranslation_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketInterfaceVectorTranslation_default_value_set(PointerRNA *ptr, const float values[3]);

float NodeSocketInterfaceVectorTranslation_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorTranslation_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceVectorTranslation_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorTranslation_min_value_set(PointerRNA *ptr, float value);

/**************** Vector Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceVectorVelocity;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

void NodeSocketInterfaceVectorVelocity_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketInterfaceVectorVelocity_default_value_set(PointerRNA *ptr, const float values[3]);

float NodeSocketInterfaceVectorVelocity_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorVelocity_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceVectorVelocity_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorVelocity_min_value_set(PointerRNA *ptr, float value);

/**************** Vector Node Socket Interface ****************/

extern StructRNA RNA_NodeSocketInterfaceVectorXYZ;
extern StructRNA RNA_NodeSocketInterfaceStandard;
extern StructRNA RNA_NodeSocketInterface;

void NodeSocketInterfaceVectorXYZ_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketInterfaceVectorXYZ_default_value_set(PointerRNA *ptr, const float values[3]);

float NodeSocketInterfaceVectorXYZ_max_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorXYZ_max_value_set(PointerRNA *ptr, float value);

float NodeSocketInterfaceVectorXYZ_min_value_get(PointerRNA *ptr);
void NodeSocketInterfaceVectorXYZ_min_value_set(PointerRNA *ptr, float value);

/**************** Shader Node Socket ****************/

extern StructRNA RNA_NodeSocketShader;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

/**************** NodeSocketStandard ****************/

extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

void NodeSocketStandard_draw(struct ID *_selfid, struct bNodeSocket *_self, struct bContext *context, struct uiLayout *layout, struct PointerRNA *node, const char * text);
void NodeSocketStandard_draw_color(struct ID *_selfid, struct bNodeSocket *_self, struct bContext *context, struct PointerRNA *node, float color[4]);
/**************** String Node Socket ****************/

extern StructRNA RNA_NodeSocketString;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

#define NodeSocketString_default_value_MAX 1024

void NodeSocketString_default_value_get(PointerRNA *ptr, char *value);
int NodeSocketString_default_value_length(PointerRNA *ptr);
void NodeSocketString_default_value_set(PointerRNA *ptr, const char *value);

/**************** Vector Node Socket ****************/

extern StructRNA RNA_NodeSocketVector;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

void NodeSocketVector_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketVector_default_value_set(PointerRNA *ptr, const float values[3]);

/**************** Vector Node Socket ****************/

extern StructRNA RNA_NodeSocketVectorAcceleration;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

void NodeSocketVectorAcceleration_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketVectorAcceleration_default_value_set(PointerRNA *ptr, const float values[3]);

/**************** Vector Node Socket ****************/

extern StructRNA RNA_NodeSocketVectorDirection;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

void NodeSocketVectorDirection_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketVectorDirection_default_value_set(PointerRNA *ptr, const float values[3]);

/**************** Vector Node Socket ****************/

extern StructRNA RNA_NodeSocketVectorEuler;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

void NodeSocketVectorEuler_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketVectorEuler_default_value_set(PointerRNA *ptr, const float values[3]);

/**************** Vector Node Socket ****************/

extern StructRNA RNA_NodeSocketVectorTranslation;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

void NodeSocketVectorTranslation_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketVectorTranslation_default_value_set(PointerRNA *ptr, const float values[3]);

/**************** Vector Node Socket ****************/

extern StructRNA RNA_NodeSocketVectorVelocity;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

void NodeSocketVectorVelocity_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketVectorVelocity_default_value_set(PointerRNA *ptr, const float values[3]);

/**************** Vector Node Socket ****************/

extern StructRNA RNA_NodeSocketVectorXYZ;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

void NodeSocketVectorXYZ_default_value_get(PointerRNA *ptr, float values[3]);
void NodeSocketVectorXYZ_default_value_set(PointerRNA *ptr, const float values[3]);

/**************** Virtual Node Socket ****************/

extern StructRNA RNA_NodeSocketVirtual;
extern StructRNA RNA_NodeSocketStandard;
extern StructRNA RNA_NodeSocket;

/**************** Node Tree ****************/

extern StructRNA RNA_NodeTree;
extern StructRNA RNA_ID;

int NodeTree_active_input_get(PointerRNA *ptr);
void NodeTree_active_input_set(PointerRNA *ptr, int value);

int NodeTree_active_output_get(PointerRNA *ptr);
void NodeTree_active_output_set(PointerRNA *ptr, int value);

PointerRNA NodeTree_animation_data_get(PointerRNA *ptr);

PointerRNA NodeTree_grease_pencil_get(PointerRNA *ptr);

void NodeTree_bl_idname_get(PointerRNA *ptr, char *value);
int NodeTree_bl_idname_length(PointerRNA *ptr);
void NodeTree_bl_idname_set(PointerRNA *ptr, const char *value);

enum {
	NodeTree_bl_icon_NONE = 0,
	NodeTree_bl_icon_QUESTION = 1,
	NodeTree_bl_icon_ERROR = 2,
	NodeTree_bl_icon_CANCEL = 3,
	NodeTree_bl_icon_TRIA_RIGHT = 4,
	NodeTree_bl_icon_TRIA_DOWN = 5,
	NodeTree_bl_icon_TRIA_LEFT = 6,
	NodeTree_bl_icon_TRIA_UP = 7,
	NodeTree_bl_icon_ARROW_LEFTRIGHT = 8,
	NodeTree_bl_icon_PLUS = 9,
	NodeTree_bl_icon_DISCLOSURE_TRI_DOWN = 10,
	NodeTree_bl_icon_DISCLOSURE_TRI_RIGHT = 11,
	NodeTree_bl_icon_RADIOBUT_OFF = 12,
	NodeTree_bl_icon_RADIOBUT_ON = 13,
	NodeTree_bl_icon_MENU_PANEL = 14,
	NodeTree_bl_icon_BLENDER = 15,
	NodeTree_bl_icon_GRIP = 16,
	NodeTree_bl_icon_DOT = 17,
	NodeTree_bl_icon_COLLAPSEMENU = 18,
	NodeTree_bl_icon_X = 19,
	NodeTree_bl_icon_GO_LEFT = 21,
	NodeTree_bl_icon_PLUG = 22,
	NodeTree_bl_icon_UI = 23,
	NodeTree_bl_icon_NODE = 24,
	NodeTree_bl_icon_NODE_SEL = 25,
	NodeTree_bl_icon_FULLSCREEN = 26,
	NodeTree_bl_icon_SPLITSCREEN = 27,
	NodeTree_bl_icon_RIGHTARROW_THIN = 28,
	NodeTree_bl_icon_BORDERMOVE = 29,
	NodeTree_bl_icon_VIEWZOOM = 30,
	NodeTree_bl_icon_ZOOMIN = 31,
	NodeTree_bl_icon_ZOOMOUT = 32,
	NodeTree_bl_icon_PANEL_CLOSE = 33,
	NodeTree_bl_icon_COPY_ID = 34,
	NodeTree_bl_icon_EYEDROPPER = 35,
	NodeTree_bl_icon_LINK_AREA = 36,
	NodeTree_bl_icon_AUTO = 37,
	NodeTree_bl_icon_CHECKBOX_DEHLT = 38,
	NodeTree_bl_icon_CHECKBOX_HLT = 39,
	NodeTree_bl_icon_UNLOCKED = 40,
	NodeTree_bl_icon_LOCKED = 41,
	NodeTree_bl_icon_UNPINNED = 42,
	NodeTree_bl_icon_PINNED = 43,
	NodeTree_bl_icon_SCREEN_BACK = 44,
	NodeTree_bl_icon_RIGHTARROW = 45,
	NodeTree_bl_icon_DOWNARROW_HLT = 46,
	NodeTree_bl_icon_DOTSUP = 47,
	NodeTree_bl_icon_DOTSDOWN = 48,
	NodeTree_bl_icon_LINK = 49,
	NodeTree_bl_icon_INLINK = 50,
	NodeTree_bl_icon_PLUGIN = 51,
	NodeTree_bl_icon_HELP = 52,
	NodeTree_bl_icon_GHOST_ENABLED = 53,
	NodeTree_bl_icon_COLOR = 54,
	NodeTree_bl_icon_LINKED = 55,
	NodeTree_bl_icon_UNLINKED = 56,
	NodeTree_bl_icon_HAND = 57,
	NodeTree_bl_icon_ZOOM_ALL = 58,
	NodeTree_bl_icon_ZOOM_SELECTED = 59,
	NodeTree_bl_icon_ZOOM_PREVIOUS = 60,
	NodeTree_bl_icon_ZOOM_IN = 61,
	NodeTree_bl_icon_ZOOM_OUT = 62,
	NodeTree_bl_icon_RENDER_REGION = 63,
	NodeTree_bl_icon_BORDER_RECT = 64,
	NodeTree_bl_icon_BORDER_LASSO = 65,
	NodeTree_bl_icon_FREEZE = 66,
	NodeTree_bl_icon_STYLUS_PRESSURE = 67,
	NodeTree_bl_icon_GHOST_DISABLED = 68,
	NodeTree_bl_icon_NEW = 69,
	NodeTree_bl_icon_FILE_TICK = 70,
	NodeTree_bl_icon_QUIT = 71,
	NodeTree_bl_icon_URL = 72,
	NodeTree_bl_icon_RECOVER_LAST = 73,
	NodeTree_bl_icon_FULLSCREEN_ENTER = 75,
	NodeTree_bl_icon_FULLSCREEN_EXIT = 76,
	NodeTree_bl_icon_BLANK1 = 77,
	NodeTree_bl_icon_LAMP = 78,
	NodeTree_bl_icon_MATERIAL = 79,
	NodeTree_bl_icon_TEXTURE = 80,
	NodeTree_bl_icon_ANIM = 81,
	NodeTree_bl_icon_WORLD = 82,
	NodeTree_bl_icon_SCENE = 83,
	NodeTree_bl_icon_EDIT = 84,
	NodeTree_bl_icon_GAME = 85,
	NodeTree_bl_icon_RADIO = 86,
	NodeTree_bl_icon_SCRIPT = 87,
	NodeTree_bl_icon_PARTICLES = 88,
	NodeTree_bl_icon_PHYSICS = 89,
	NodeTree_bl_icon_SPEAKER = 90,
	NodeTree_bl_icon_TEXTURE_SHADED = 91,
	NodeTree_bl_icon_VIEW3D = 104,
	NodeTree_bl_icon_IPO = 105,
	NodeTree_bl_icon_OOPS = 106,
	NodeTree_bl_icon_BUTS = 107,
	NodeTree_bl_icon_FILESEL = 108,
	NodeTree_bl_icon_IMAGE_COL = 109,
	NodeTree_bl_icon_INFO = 110,
	NodeTree_bl_icon_SEQUENCE = 111,
	NodeTree_bl_icon_TEXT = 112,
	NodeTree_bl_icon_IMASEL = 113,
	NodeTree_bl_icon_SOUND = 114,
	NodeTree_bl_icon_ACTION = 115,
	NodeTree_bl_icon_NLA = 116,
	NodeTree_bl_icon_SCRIPTWIN = 117,
	NodeTree_bl_icon_TIME = 118,
	NodeTree_bl_icon_NODETREE = 119,
	NodeTree_bl_icon_LOGIC = 120,
	NodeTree_bl_icon_CONSOLE = 121,
	NodeTree_bl_icon_PREFERENCES = 122,
	NodeTree_bl_icon_CLIP = 123,
	NodeTree_bl_icon_ASSET_MANAGER = 124,
	NodeTree_bl_icon_OBJECT_DATAMODE = 130,
	NodeTree_bl_icon_EDITMODE_HLT = 131,
	NodeTree_bl_icon_FACESEL_HLT = 132,
	NodeTree_bl_icon_VPAINT_HLT = 133,
	NodeTree_bl_icon_TPAINT_HLT = 134,
	NodeTree_bl_icon_WPAINT_HLT = 135,
	NodeTree_bl_icon_SCULPTMODE_HLT = 136,
	NodeTree_bl_icon_POSE_HLT = 137,
	NodeTree_bl_icon_PARTICLEMODE = 138,
	NodeTree_bl_icon_LIGHTPAINT = 139,
	NodeTree_bl_icon_SCENE_DATA = 156,
	NodeTree_bl_icon_RENDERLAYERS = 157,
	NodeTree_bl_icon_WORLD_DATA = 158,
	NodeTree_bl_icon_OBJECT_DATA = 159,
	NodeTree_bl_icon_MESH_DATA = 160,
	NodeTree_bl_icon_CURVE_DATA = 161,
	NodeTree_bl_icon_META_DATA = 162,
	NodeTree_bl_icon_LATTICE_DATA = 163,
	NodeTree_bl_icon_LAMP_DATA = 164,
	NodeTree_bl_icon_MATERIAL_DATA = 165,
	NodeTree_bl_icon_TEXTURE_DATA = 166,
	NodeTree_bl_icon_ANIM_DATA = 167,
	NodeTree_bl_icon_CAMERA_DATA = 168,
	NodeTree_bl_icon_PARTICLE_DATA = 169,
	NodeTree_bl_icon_LIBRARY_DATA_DIRECT = 170,
	NodeTree_bl_icon_GROUP = 171,
	NodeTree_bl_icon_ARMATURE_DATA = 172,
	NodeTree_bl_icon_POSE_DATA = 173,
	NodeTree_bl_icon_BONE_DATA = 174,
	NodeTree_bl_icon_CONSTRAINT = 175,
	NodeTree_bl_icon_SHAPEKEY_DATA = 176,
	NodeTree_bl_icon_CONSTRAINT_BONE = 177,
	NodeTree_bl_icon_CAMERA_STEREO = 178,
	NodeTree_bl_icon_PACKAGE = 179,
	NodeTree_bl_icon_UGLYPACKAGE = 180,
	NodeTree_bl_icon_BRUSH_DATA = 182,
	NodeTree_bl_icon_IMAGE_DATA = 183,
	NodeTree_bl_icon_FILE = 184,
	NodeTree_bl_icon_FCURVE = 185,
	NodeTree_bl_icon_FONT_DATA = 186,
	NodeTree_bl_icon_RENDER_RESULT = 187,
	NodeTree_bl_icon_SURFACE_DATA = 188,
	NodeTree_bl_icon_EMPTY_DATA = 189,
	NodeTree_bl_icon_SETTINGS = 190,
	NodeTree_bl_icon_RENDER_ANIMATION = 191,
	NodeTree_bl_icon_RENDER_STILL = 192,
	NodeTree_bl_icon_BOIDS = 194,
	NodeTree_bl_icon_STRANDS = 195,
	NodeTree_bl_icon_LIBRARY_DATA_INDIRECT = 196,
	NodeTree_bl_icon_GREASEPENCIL = 197,
	NodeTree_bl_icon_LINE_DATA = 198,
	NodeTree_bl_icon_GROUP_BONE = 200,
	NodeTree_bl_icon_GROUP_VERTEX = 201,
	NodeTree_bl_icon_GROUP_VCOL = 202,
	NodeTree_bl_icon_GROUP_UVS = 203,
	NodeTree_bl_icon_RNA = 206,
	NodeTree_bl_icon_RNA_ADD = 207,
	NodeTree_bl_icon_OUTLINER_OB_EMPTY = 234,
	NodeTree_bl_icon_OUTLINER_OB_MESH = 235,
	NodeTree_bl_icon_OUTLINER_OB_CURVE = 236,
	NodeTree_bl_icon_OUTLINER_OB_LATTICE = 237,
	NodeTree_bl_icon_OUTLINER_OB_META = 238,
	NodeTree_bl_icon_OUTLINER_OB_LAMP = 239,
	NodeTree_bl_icon_OUTLINER_OB_CAMERA = 240,
	NodeTree_bl_icon_OUTLINER_OB_ARMATURE = 241,
	NodeTree_bl_icon_OUTLINER_OB_FONT = 242,
	NodeTree_bl_icon_OUTLINER_OB_SURFACE = 243,
	NodeTree_bl_icon_OUTLINER_OB_SPEAKER = 244,
	NodeTree_bl_icon_RESTRICT_VIEW_OFF = 253,
	NodeTree_bl_icon_RESTRICT_VIEW_ON = 254,
	NodeTree_bl_icon_RESTRICT_SELECT_OFF = 255,
	NodeTree_bl_icon_RESTRICT_SELECT_ON = 256,
	NodeTree_bl_icon_RESTRICT_RENDER_OFF = 257,
	NodeTree_bl_icon_RESTRICT_RENDER_ON = 258,
	NodeTree_bl_icon_OUTLINER_DATA_EMPTY = 260,
	NodeTree_bl_icon_OUTLINER_DATA_MESH = 261,
	NodeTree_bl_icon_OUTLINER_DATA_CURVE = 262,
	NodeTree_bl_icon_OUTLINER_DATA_LATTICE = 263,
	NodeTree_bl_icon_OUTLINER_DATA_META = 264,
	NodeTree_bl_icon_OUTLINER_DATA_LAMP = 265,
	NodeTree_bl_icon_OUTLINER_DATA_CAMERA = 266,
	NodeTree_bl_icon_OUTLINER_DATA_ARMATURE = 267,
	NodeTree_bl_icon_OUTLINER_DATA_FONT = 268,
	NodeTree_bl_icon_OUTLINER_DATA_SURFACE = 269,
	NodeTree_bl_icon_OUTLINER_DATA_SPEAKER = 270,
	NodeTree_bl_icon_OUTLINER_DATA_POSE = 271,
	NodeTree_bl_icon_MESH_PLANE = 286,
	NodeTree_bl_icon_MESH_CUBE = 287,
	NodeTree_bl_icon_MESH_CIRCLE = 288,
	NodeTree_bl_icon_MESH_UVSPHERE = 289,
	NodeTree_bl_icon_MESH_ICOSPHERE = 290,
	NodeTree_bl_icon_MESH_GRID = 291,
	NodeTree_bl_icon_MESH_MONKEY = 292,
	NodeTree_bl_icon_MESH_CYLINDER = 293,
	NodeTree_bl_icon_MESH_TORUS = 294,
	NodeTree_bl_icon_MESH_CONE = 295,
	NodeTree_bl_icon_LAMP_POINT = 298,
	NodeTree_bl_icon_LAMP_SUN = 299,
	NodeTree_bl_icon_LAMP_SPOT = 300,
	NodeTree_bl_icon_LAMP_HEMI = 301,
	NodeTree_bl_icon_LAMP_AREA = 302,
	NodeTree_bl_icon_META_EMPTY = 305,
	NodeTree_bl_icon_META_PLANE = 306,
	NodeTree_bl_icon_META_CUBE = 307,
	NodeTree_bl_icon_META_BALL = 308,
	NodeTree_bl_icon_META_ELLIPSOID = 309,
	NodeTree_bl_icon_META_CAPSULE = 310,
	NodeTree_bl_icon_SURFACE_NCURVE = 312,
	NodeTree_bl_icon_SURFACE_NCIRCLE = 313,
	NodeTree_bl_icon_SURFACE_NSURFACE = 314,
	NodeTree_bl_icon_SURFACE_NCYLINDER = 315,
	NodeTree_bl_icon_SURFACE_NSPHERE = 316,
	NodeTree_bl_icon_SURFACE_NTORUS = 317,
	NodeTree_bl_icon_CURVE_BEZCURVE = 321,
	NodeTree_bl_icon_CURVE_BEZCIRCLE = 322,
	NodeTree_bl_icon_CURVE_NCURVE = 323,
	NodeTree_bl_icon_CURVE_NCIRCLE = 324,
	NodeTree_bl_icon_CURVE_PATH = 325,
	NodeTree_bl_icon_COLOR_RED = 331,
	NodeTree_bl_icon_COLOR_GREEN = 332,
	NodeTree_bl_icon_COLOR_BLUE = 333,
	NodeTree_bl_icon_TRIA_RIGHT_BAR = 334,
	NodeTree_bl_icon_TRIA_DOWN_BAR = 335,
	NodeTree_bl_icon_TRIA_LEFT_BAR = 336,
	NodeTree_bl_icon_TRIA_UP_BAR = 337,
	NodeTree_bl_icon_FORCE_FORCE = 338,
	NodeTree_bl_icon_FORCE_WIND = 339,
	NodeTree_bl_icon_FORCE_VORTEX = 340,
	NodeTree_bl_icon_FORCE_MAGNETIC = 341,
	NodeTree_bl_icon_FORCE_HARMONIC = 342,
	NodeTree_bl_icon_FORCE_CHARGE = 343,
	NodeTree_bl_icon_FORCE_LENNARDJONES = 344,
	NodeTree_bl_icon_FORCE_TEXTURE = 345,
	NodeTree_bl_icon_FORCE_CURVE = 346,
	NodeTree_bl_icon_FORCE_BOID = 347,
	NodeTree_bl_icon_FORCE_TURBULENCE = 348,
	NodeTree_bl_icon_FORCE_DRAG = 349,
	NodeTree_bl_icon_FORCE_SMOKEFLOW = 350,
	NodeTree_bl_icon_MODIFIER = 442,
	NodeTree_bl_icon_MOD_WAVE = 443,
	NodeTree_bl_icon_MOD_BUILD = 444,
	NodeTree_bl_icon_MOD_DECIM = 445,
	NodeTree_bl_icon_MOD_MIRROR = 446,
	NodeTree_bl_icon_MOD_SOFT = 447,
	NodeTree_bl_icon_MOD_SUBSURF = 448,
	NodeTree_bl_icon_HOOK = 449,
	NodeTree_bl_icon_MOD_PHYSICS = 450,
	NodeTree_bl_icon_MOD_PARTICLES = 451,
	NodeTree_bl_icon_MOD_BOOLEAN = 452,
	NodeTree_bl_icon_MOD_EDGESPLIT = 453,
	NodeTree_bl_icon_MOD_ARRAY = 454,
	NodeTree_bl_icon_MOD_UVPROJECT = 455,
	NodeTree_bl_icon_MOD_DISPLACE = 456,
	NodeTree_bl_icon_MOD_CURVE = 457,
	NodeTree_bl_icon_MOD_LATTICE = 458,
	NodeTree_bl_icon_CONSTRAINT_DATA = 459,
	NodeTree_bl_icon_MOD_ARMATURE = 460,
	NodeTree_bl_icon_MOD_SHRINKWRAP = 461,
	NodeTree_bl_icon_MOD_CAST = 462,
	NodeTree_bl_icon_MOD_MESHDEFORM = 463,
	NodeTree_bl_icon_MOD_BEVEL = 464,
	NodeTree_bl_icon_MOD_SMOOTH = 465,
	NodeTree_bl_icon_MOD_SIMPLEDEFORM = 466,
	NodeTree_bl_icon_MOD_MASK = 467,
	NodeTree_bl_icon_MOD_CLOTH = 468,
	NodeTree_bl_icon_MOD_EXPLODE = 469,
	NodeTree_bl_icon_MOD_FLUIDSIM = 470,
	NodeTree_bl_icon_MOD_MULTIRES = 471,
	NodeTree_bl_icon_MOD_SMOKE = 472,
	NodeTree_bl_icon_MOD_SOLIDIFY = 473,
	NodeTree_bl_icon_MOD_SCREW = 474,
	NodeTree_bl_icon_MOD_VERTEX_WEIGHT = 475,
	NodeTree_bl_icon_MOD_DYNAMICPAINT = 476,
	NodeTree_bl_icon_MOD_REMESH = 477,
	NodeTree_bl_icon_MOD_OCEAN = 478,
	NodeTree_bl_icon_MOD_WARP = 479,
	NodeTree_bl_icon_MOD_SKIN = 480,
	NodeTree_bl_icon_MOD_TRIANGULATE = 481,
	NodeTree_bl_icon_MOD_WIREFRAME = 482,
	NodeTree_bl_icon_REC = 494,
	NodeTree_bl_icon_PLAY = 495,
	NodeTree_bl_icon_FF = 496,
	NodeTree_bl_icon_REW = 497,
	NodeTree_bl_icon_PAUSE = 498,
	NodeTree_bl_icon_PREV_KEYFRAME = 499,
	NodeTree_bl_icon_NEXT_KEYFRAME = 500,
	NodeTree_bl_icon_PLAY_AUDIO = 501,
	NodeTree_bl_icon_PLAY_REVERSE = 502,
	NodeTree_bl_icon_PREVIEW_RANGE = 503,
	NodeTree_bl_icon_ACTION_TWEAK = 504,
	NodeTree_bl_icon_PMARKER_ACT = 505,
	NodeTree_bl_icon_PMARKER_SEL = 506,
	NodeTree_bl_icon_PMARKER = 507,
	NodeTree_bl_icon_MARKER_HLT = 508,
	NodeTree_bl_icon_MARKER = 509,
	NodeTree_bl_icon_SPACE2 = 510,
	NodeTree_bl_icon_SPACE3 = 511,
	NodeTree_bl_icon_KEYINGSET = 512,
	NodeTree_bl_icon_KEY_DEHLT = 513,
	NodeTree_bl_icon_KEY_HLT = 514,
	NodeTree_bl_icon_MUTE_IPO_OFF = 515,
	NodeTree_bl_icon_MUTE_IPO_ON = 516,
	NodeTree_bl_icon_VISIBLE_IPO_OFF = 517,
	NodeTree_bl_icon_VISIBLE_IPO_ON = 518,
	NodeTree_bl_icon_DRIVER = 519,
	NodeTree_bl_icon_SOLO_OFF = 520,
	NodeTree_bl_icon_SOLO_ON = 521,
	NodeTree_bl_icon_FRAME_PREV = 522,
	NodeTree_bl_icon_FRAME_NEXT = 523,
	NodeTree_bl_icon_NLA_PUSHDOWN = 524,
	NodeTree_bl_icon_IPO_CONSTANT = 525,
	NodeTree_bl_icon_IPO_LINEAR = 526,
	NodeTree_bl_icon_IPO_BEZIER = 527,
	NodeTree_bl_icon_IPO_SINE = 528,
	NodeTree_bl_icon_IPO_QUAD = 529,
	NodeTree_bl_icon_IPO_CUBIC = 530,
	NodeTree_bl_icon_IPO_QUART = 531,
	NodeTree_bl_icon_IPO_QUINT = 532,
	NodeTree_bl_icon_IPO_EXPO = 533,
	NodeTree_bl_icon_IPO_CIRC = 534,
	NodeTree_bl_icon_IPO_BOUNCE = 535,
	NodeTree_bl_icon_IPO_ELASTIC = 536,
	NodeTree_bl_icon_IPO_BACK = 537,
	NodeTree_bl_icon_IPO_EASE_IN = 538,
	NodeTree_bl_icon_IPO_EASE_OUT = 539,
	NodeTree_bl_icon_IPO_EASE_IN_OUT = 540,
	NodeTree_bl_icon_VERTEXSEL = 546,
	NodeTree_bl_icon_EDGESEL = 547,
	NodeTree_bl_icon_FACESEL = 548,
	NodeTree_bl_icon_LOOPSEL = 549,
	NodeTree_bl_icon_ROTATE = 551,
	NodeTree_bl_icon_CURSOR = 552,
	NodeTree_bl_icon_ROTATECOLLECTION = 553,
	NodeTree_bl_icon_ROTATECENTER = 554,
	NodeTree_bl_icon_ROTACTIVE = 555,
	NodeTree_bl_icon_ALIGN = 556,
	NodeTree_bl_icon_SMOOTHCURVE = 558,
	NodeTree_bl_icon_SPHERECURVE = 559,
	NodeTree_bl_icon_ROOTCURVE = 560,
	NodeTree_bl_icon_SHARPCURVE = 561,
	NodeTree_bl_icon_LINCURVE = 562,
	NodeTree_bl_icon_NOCURVE = 563,
	NodeTree_bl_icon_RNDCURVE = 564,
	NodeTree_bl_icon_PROP_OFF = 565,
	NodeTree_bl_icon_PROP_ON = 566,
	NodeTree_bl_icon_PROP_CON = 567,
	NodeTree_bl_icon_SCULPT_DYNTOPO = 568,
	NodeTree_bl_icon_PARTICLE_POINT = 569,
	NodeTree_bl_icon_PARTICLE_TIP = 570,
	NodeTree_bl_icon_PARTICLE_PATH = 571,
	NodeTree_bl_icon_MAN_TRANS = 572,
	NodeTree_bl_icon_MAN_ROT = 573,
	NodeTree_bl_icon_MAN_SCALE = 574,
	NodeTree_bl_icon_MANIPUL = 575,
	NodeTree_bl_icon_SNAP_OFF = 576,
	NodeTree_bl_icon_SNAP_ON = 577,
	NodeTree_bl_icon_SNAP_NORMAL = 578,
	NodeTree_bl_icon_SNAP_INCREMENT = 579,
	NodeTree_bl_icon_SNAP_VERTEX = 580,
	NodeTree_bl_icon_SNAP_EDGE = 581,
	NodeTree_bl_icon_SNAP_FACE = 582,
	NodeTree_bl_icon_SNAP_VOLUME = 583,
	NodeTree_bl_icon_STICKY_UVS_LOC = 585,
	NodeTree_bl_icon_STICKY_UVS_DISABLE = 586,
	NodeTree_bl_icon_STICKY_UVS_VERT = 587,
	NodeTree_bl_icon_CLIPUV_DEHLT = 588,
	NodeTree_bl_icon_CLIPUV_HLT = 589,
	NodeTree_bl_icon_SNAP_PEEL_OBJECT = 590,
	NodeTree_bl_icon_GRID = 591,
	NodeTree_bl_icon_PASTEDOWN = 598,
	NodeTree_bl_icon_COPYDOWN = 599,
	NodeTree_bl_icon_PASTEFLIPUP = 600,
	NodeTree_bl_icon_PASTEFLIPDOWN = 601,
	NodeTree_bl_icon_SNAP_SURFACE = 606,
	NodeTree_bl_icon_AUTOMERGE_ON = 607,
	NodeTree_bl_icon_AUTOMERGE_OFF = 608,
	NodeTree_bl_icon_RETOPO = 609,
	NodeTree_bl_icon_UV_VERTEXSEL = 610,
	NodeTree_bl_icon_UV_EDGESEL = 611,
	NodeTree_bl_icon_UV_FACESEL = 612,
	NodeTree_bl_icon_UV_ISLANDSEL = 613,
	NodeTree_bl_icon_UV_SYNC_SELECT = 614,
	NodeTree_bl_icon_BBOX = 624,
	NodeTree_bl_icon_WIRE = 625,
	NodeTree_bl_icon_SOLID = 626,
	NodeTree_bl_icon_SMOOTH = 627,
	NodeTree_bl_icon_POTATO = 628,
	NodeTree_bl_icon_ORTHO = 630,
	NodeTree_bl_icon_LOCKVIEW_OFF = 633,
	NodeTree_bl_icon_LOCKVIEW_ON = 634,
	NodeTree_bl_icon_AXIS_SIDE = 636,
	NodeTree_bl_icon_AXIS_FRONT = 637,
	NodeTree_bl_icon_AXIS_TOP = 638,
	NodeTree_bl_icon_NDOF_DOM = 639,
	NodeTree_bl_icon_NDOF_TURN = 640,
	NodeTree_bl_icon_NDOF_FLY = 641,
	NodeTree_bl_icon_NDOF_TRANS = 642,
	NodeTree_bl_icon_LAYER_USED = 643,
	NodeTree_bl_icon_LAYER_ACTIVE = 644,
	NodeTree_bl_icon_SORTALPHA = 676,
	NodeTree_bl_icon_SORTBYEXT = 677,
	NodeTree_bl_icon_SORTTIME = 678,
	NodeTree_bl_icon_SORTSIZE = 679,
	NodeTree_bl_icon_LONGDISPLAY = 680,
	NodeTree_bl_icon_SHORTDISPLAY = 681,
	NodeTree_bl_icon_GHOST = 682,
	NodeTree_bl_icon_IMGDISPLAY = 683,
	NodeTree_bl_icon_SAVE_AS = 684,
	NodeTree_bl_icon_SAVE_COPY = 685,
	NodeTree_bl_icon_BOOKMARKS = 686,
	NodeTree_bl_icon_FONTPREVIEW = 687,
	NodeTree_bl_icon_FILTER = 688,
	NodeTree_bl_icon_NEWFOLDER = 689,
	NodeTree_bl_icon_OPEN_RECENT = 690,
	NodeTree_bl_icon_FILE_PARENT = 691,
	NodeTree_bl_icon_FILE_REFRESH = 692,
	NodeTree_bl_icon_FILE_FOLDER = 693,
	NodeTree_bl_icon_FILE_BLANK = 694,
	NodeTree_bl_icon_FILE_BLEND = 695,
	NodeTree_bl_icon_FILE_IMAGE = 696,
	NodeTree_bl_icon_FILE_MOVIE = 697,
	NodeTree_bl_icon_FILE_SCRIPT = 698,
	NodeTree_bl_icon_FILE_SOUND = 699,
	NodeTree_bl_icon_FILE_FONT = 700,
	NodeTree_bl_icon_FILE_TEXT = 701,
	NodeTree_bl_icon_RECOVER_AUTO = 702,
	NodeTree_bl_icon_SAVE_PREFS = 703,
	NodeTree_bl_icon_LINK_BLEND = 704,
	NodeTree_bl_icon_APPEND_BLEND = 705,
	NodeTree_bl_icon_IMPORT = 706,
	NodeTree_bl_icon_EXPORT = 707,
	NodeTree_bl_icon_EXTERNAL_DATA = 708,
	NodeTree_bl_icon_LOAD_FACTORY = 709,
	NodeTree_bl_icon_LOOP_BACK = 715,
	NodeTree_bl_icon_LOOP_FORWARDS = 716,
	NodeTree_bl_icon_BACK = 717,
	NodeTree_bl_icon_FORWARD = 718,
	NodeTree_bl_icon_FILE_BACKUP = 726,
	NodeTree_bl_icon_DISK_DRIVE = 727,
	NodeTree_bl_icon_MATPLANE = 728,
	NodeTree_bl_icon_MATSPHERE = 729,
	NodeTree_bl_icon_MATCUBE = 730,
	NodeTree_bl_icon_MONKEY = 731,
	NodeTree_bl_icon_HAIR = 732,
	NodeTree_bl_icon_ALIASED = 733,
	NodeTree_bl_icon_ANTIALIASED = 734,
	NodeTree_bl_icon_MAT_SPHERE_SKY = 735,
	NodeTree_bl_icon_WORDWRAP_OFF = 740,
	NodeTree_bl_icon_WORDWRAP_ON = 741,
	NodeTree_bl_icon_SYNTAX_OFF = 742,
	NodeTree_bl_icon_SYNTAX_ON = 743,
	NodeTree_bl_icon_LINENUMBERS_OFF = 744,
	NodeTree_bl_icon_LINENUMBERS_ON = 745,
	NodeTree_bl_icon_SCRIPTPLUGINS = 746,
	NodeTree_bl_icon_SEQ_SEQUENCER = 754,
	NodeTree_bl_icon_SEQ_PREVIEW = 755,
	NodeTree_bl_icon_SEQ_LUMA_WAVEFORM = 756,
	NodeTree_bl_icon_SEQ_CHROMA_SCOPE = 757,
	NodeTree_bl_icon_SEQ_HISTOGRAM = 758,
	NodeTree_bl_icon_SEQ_SPLITVIEW = 759,
	NodeTree_bl_icon_IMAGE_RGB = 763,
	NodeTree_bl_icon_IMAGE_RGB_ALPHA = 764,
	NodeTree_bl_icon_IMAGE_ALPHA = 765,
	NodeTree_bl_icon_IMAGE_ZDEPTH = 766,
	NodeTree_bl_icon_IMAGEFILE = 767,
	NodeTree_bl_icon_BRUSH_ADD = 780,
	NodeTree_bl_icon_BRUSH_BLOB = 781,
	NodeTree_bl_icon_BRUSH_BLUR = 782,
	NodeTree_bl_icon_BRUSH_CLAY = 783,
	NodeTree_bl_icon_BRUSH_CLAY_STRIPS = 784,
	NodeTree_bl_icon_BRUSH_CLONE = 785,
	NodeTree_bl_icon_BRUSH_CREASE = 786,
	NodeTree_bl_icon_BRUSH_DARKEN = 787,
	NodeTree_bl_icon_BRUSH_FILL = 788,
	NodeTree_bl_icon_BRUSH_FLATTEN = 789,
	NodeTree_bl_icon_BRUSH_GRAB = 790,
	NodeTree_bl_icon_BRUSH_INFLATE = 791,
	NodeTree_bl_icon_BRUSH_LAYER = 792,
	NodeTree_bl_icon_BRUSH_LIGHTEN = 793,
	NodeTree_bl_icon_BRUSH_MASK = 794,
	NodeTree_bl_icon_BRUSH_MIX = 795,
	NodeTree_bl_icon_BRUSH_MULTIPLY = 796,
	NodeTree_bl_icon_BRUSH_NUDGE = 797,
	NodeTree_bl_icon_BRUSH_PINCH = 798,
	NodeTree_bl_icon_BRUSH_SCRAPE = 799,
	NodeTree_bl_icon_BRUSH_SCULPT_DRAW = 800,
	NodeTree_bl_icon_BRUSH_SMEAR = 801,
	NodeTree_bl_icon_BRUSH_SMOOTH = 802,
	NodeTree_bl_icon_BRUSH_SNAKE_HOOK = 803,
	NodeTree_bl_icon_BRUSH_SOFTEN = 804,
	NodeTree_bl_icon_BRUSH_SUBTRACT = 805,
	NodeTree_bl_icon_BRUSH_TEXDRAW = 806,
	NodeTree_bl_icon_BRUSH_TEXFILL = 807,
	NodeTree_bl_icon_BRUSH_TEXMASK = 808,
	NodeTree_bl_icon_BRUSH_THUMB = 809,
	NodeTree_bl_icon_BRUSH_ROTATE = 810,
	NodeTree_bl_icon_BRUSH_VERTEXDRAW = 811,
	NodeTree_bl_icon_MATCAP_01 = 812,
	NodeTree_bl_icon_MATCAP_02 = 813,
	NodeTree_bl_icon_MATCAP_03 = 814,
	NodeTree_bl_icon_MATCAP_04 = 815,
	NodeTree_bl_icon_MATCAP_05 = 816,
	NodeTree_bl_icon_MATCAP_06 = 817,
	NodeTree_bl_icon_MATCAP_07 = 818,
	NodeTree_bl_icon_MATCAP_08 = 819,
	NodeTree_bl_icon_MATCAP_09 = 820,
	NodeTree_bl_icon_MATCAP_10 = 821,
	NodeTree_bl_icon_MATCAP_11 = 822,
	NodeTree_bl_icon_MATCAP_12 = 823,
	NodeTree_bl_icon_MATCAP_13 = 824,
	NodeTree_bl_icon_MATCAP_14 = 825,
	NodeTree_bl_icon_MATCAP_15 = 826,
	NodeTree_bl_icon_MATCAP_16 = 827,
	NodeTree_bl_icon_MATCAP_17 = 828,
	NodeTree_bl_icon_MATCAP_18 = 829,
	NodeTree_bl_icon_MATCAP_19 = 830,
	NodeTree_bl_icon_MATCAP_20 = 831,
	NodeTree_bl_icon_MATCAP_21 = 832,
	NodeTree_bl_icon_MATCAP_22 = 833,
	NodeTree_bl_icon_MATCAP_23 = 834,
	NodeTree_bl_icon_MATCAP_24 = 835,
};

int NodeTree_bl_icon_get(PointerRNA *ptr);
void NodeTree_bl_icon_set(PointerRNA *ptr, int value);

void NodeTree_inputs_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void NodeTree_inputs_next(CollectionPropertyIterator *iter);
void NodeTree_inputs_end(CollectionPropertyIterator *iter);
int NodeTree_inputs_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int NodeTree_inputs_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void NodeTree_bl_label_get(PointerRNA *ptr, char *value);
int NodeTree_bl_label_length(PointerRNA *ptr);
void NodeTree_bl_label_set(PointerRNA *ptr, const char *value);

void NodeTree_links_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void NodeTree_links_next(CollectionPropertyIterator *iter);
void NodeTree_links_end(CollectionPropertyIterator *iter);
int NodeTree_links_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void NodeTree_nodes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void NodeTree_nodes_next(CollectionPropertyIterator *iter);
void NodeTree_nodes_end(CollectionPropertyIterator *iter);
int NodeTree_nodes_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int NodeTree_nodes_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void NodeTree_outputs_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void NodeTree_outputs_next(CollectionPropertyIterator *iter);
void NodeTree_outputs_end(CollectionPropertyIterator *iter);
int NodeTree_outputs_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int NodeTree_outputs_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

enum {
	NodeTree_type_SHADER = 0,
	NodeTree_type_TEXTURE = 2,
	NodeTree_type_COMPOSITING = 1,
};

int NodeTree_type_get(PointerRNA *ptr);
void NodeTree_type_set(PointerRNA *ptr, int value);

void NodeTree_bl_description_get(PointerRNA *ptr, char *value);
int NodeTree_bl_description_length(PointerRNA *ptr);
void NodeTree_bl_description_set(PointerRNA *ptr, const char *value);

void NodeTree_view_center_get(PointerRNA *ptr, float values[2]);
void NodeTree_view_center_set(PointerRNA *ptr, const float values[2]);

void NodeTree_interface_update(struct bNodeTree *_self, struct bContext *context);
int NodeTree_poll(struct bContext *context);
void NodeTree_update(struct bNodeTree *_self);
void NodeTree_get_from_context(struct bContext *context, struct bNodeTree **result_1, struct ID **result_2, struct ID **result_3);
/**************** Node Tree Inputs ****************/

extern StructRNA RNA_NodeTreeInputs;

PointerRNA NodeTreeInputs_rna_type_get(PointerRNA *ptr);

struct bNodeSocket *NodeTreeInputs_new(struct bNodeTree *_self, ReportList *reports, const char * type, const char * name);
void NodeTreeInputs_remove(struct bNodeTree *_self, ReportList *reports, struct bNodeSocket *socket);
void NodeTreeInputs_clear(struct bNodeTree *_self, ReportList *reports);
void NodeTreeInputs_move(struct bNodeTree *_self, int from_index, int to_index);
/**************** Node Tree Outputs ****************/

extern StructRNA RNA_NodeTreeOutputs;

PointerRNA NodeTreeOutputs_rna_type_get(PointerRNA *ptr);

struct bNodeSocket *NodeTreeOutputs_new(struct bNodeTree *_self, ReportList *reports, const char * type, const char * name);
void NodeTreeOutputs_remove(struct bNodeTree *_self, ReportList *reports, struct bNodeSocket *socket);
void NodeTreeOutputs_clear(struct bNodeTree *_self, ReportList *reports);
void NodeTreeOutputs_move(struct bNodeTree *_self, int from_index, int to_index);
/**************** Node Tree Path ****************/

extern StructRNA RNA_NodeTreePath;

PointerRNA NodeTreePath_rna_type_get(PointerRNA *ptr);

PointerRNA NodeTreePath_node_tree_get(PointerRNA *ptr);

/**************** Nodes ****************/

extern StructRNA RNA_Nodes;

PointerRNA Nodes_rna_type_get(PointerRNA *ptr);

PointerRNA Nodes_active_get(PointerRNA *ptr);

struct bNode *Nodes_new(struct bNodeTree *_self, bContext *C, ReportList *reports, const char * type);
void Nodes_remove(struct bNodeTree *_self, ReportList *reports, struct PointerRNA *node);
void Nodes_clear(struct bNodeTree *_self, ReportList *reports);
/**************** Noise Texture ****************/

extern StructRNA RNA_NoiseTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

/**************** Nor Controller ****************/

extern StructRNA RNA_NorController;
extern StructRNA RNA_Controller;

/**************** Object ****************/

extern StructRNA RNA_Object;
extern StructRNA RNA_ID;

PointerRNA Object_active_material_get(PointerRNA *ptr);

int Object_active_material_index_get(PointerRNA *ptr);
void Object_active_material_index_set(PointerRNA *ptr, int value);

PointerRNA Object_active_shape_key_get(PointerRNA *ptr);

int Object_active_shape_key_index_get(PointerRNA *ptr);
void Object_active_shape_key_index_set(PointerRNA *ptr, int value);

PointerRNA Object_animation_data_get(PointerRNA *ptr);

PointerRNA Object_animation_visualization_get(PointerRNA *ptr);

void Object_rotation_axis_angle_get(PointerRNA *ptr, float values[4]);
void Object_rotation_axis_angle_set(PointerRNA *ptr, const float values[4]);

void Object_bound_box_get(PointerRNA *ptr, float values[24]);
void Object_bound_box_set(PointerRNA *ptr, const float values[24]);

PointerRNA Object_collision_get(PointerRNA *ptr);

void Object_color_get(PointerRNA *ptr, float values[4]);
void Object_color_set(PointerRNA *ptr, const float values[4]);

void Object_constraints_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Object_constraints_next(CollectionPropertyIterator *iter);
void Object_constraints_end(CollectionPropertyIterator *iter);
int Object_constraints_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Object_constraints_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA Object_data_get(PointerRNA *ptr);

void Object_delta_location_get(PointerRNA *ptr, float values[3]);
void Object_delta_location_set(PointerRNA *ptr, const float values[3]);

void Object_delta_rotation_euler_get(PointerRNA *ptr, float values[3]);
void Object_delta_rotation_euler_set(PointerRNA *ptr, const float values[3]);

void Object_delta_rotation_quaternion_get(PointerRNA *ptr, float values[4]);
void Object_delta_rotation_quaternion_set(PointerRNA *ptr, const float values[4]);

void Object_delta_scale_get(PointerRNA *ptr, float values[3]);
void Object_delta_scale_set(PointerRNA *ptr, const float values[3]);

void Object_dimensions_get(PointerRNA *ptr, float values[3]);
void Object_dimensions_set(PointerRNA *ptr, const float values[3]);

int Object_show_all_edges_get(PointerRNA *ptr);
void Object_show_all_edges_set(PointerRNA *ptr, int value);

int Object_show_axis_get(PointerRNA *ptr);
void Object_show_axis_set(PointerRNA *ptr, int value);

int Object_show_bounds_get(PointerRNA *ptr);
void Object_show_bounds_set(PointerRNA *ptr, int value);

enum {
	Object_draw_bounds_type_BOX = 0,
	Object_draw_bounds_type_SPHERE = 1,
	Object_draw_bounds_type_CYLINDER = 2,
	Object_draw_bounds_type_CONE = 3,
	Object_draw_bounds_type_CAPSULE = 7,
};

int Object_draw_bounds_type_get(PointerRNA *ptr);
void Object_draw_bounds_type_set(PointerRNA *ptr, int value);

int Object_show_name_get(PointerRNA *ptr);
void Object_show_name_set(PointerRNA *ptr, int value);

int Object_show_texture_space_get(PointerRNA *ptr);
void Object_show_texture_space_set(PointerRNA *ptr, int value);

int Object_show_transparent_get(PointerRNA *ptr);
void Object_show_transparent_set(PointerRNA *ptr, int value);

int Object_show_wire_get(PointerRNA *ptr);
void Object_show_wire_set(PointerRNA *ptr, int value);

int Object_use_dupli_faces_scale_get(PointerRNA *ptr);
void Object_use_dupli_faces_scale_set(PointerRNA *ptr, int value);

float Object_dupli_faces_scale_get(PointerRNA *ptr);
void Object_dupli_faces_scale_set(PointerRNA *ptr, float value);

int Object_dupli_frames_end_get(PointerRNA *ptr);
void Object_dupli_frames_end_set(PointerRNA *ptr, int value);

int Object_dupli_frames_off_get(PointerRNA *ptr);
void Object_dupli_frames_off_set(PointerRNA *ptr, int value);

int Object_dupli_frames_on_get(PointerRNA *ptr);
void Object_dupli_frames_on_set(PointerRNA *ptr, int value);

int Object_use_dupli_frames_speed_get(PointerRNA *ptr);
void Object_use_dupli_frames_speed_set(PointerRNA *ptr, int value);

int Object_dupli_frames_start_get(PointerRNA *ptr);
void Object_dupli_frames_start_set(PointerRNA *ptr, int value);

PointerRNA Object_dupli_group_get(PointerRNA *ptr);

enum {
	Object_dupli_type_NONE = 0,
	Object_dupli_type_FRAMES = 8,
	Object_dupli_type_VERTS = 16,
	Object_dupli_type_FACES = 512,
	Object_dupli_type_GROUP = 256,
};

int Object_dupli_type_get(PointerRNA *ptr);
void Object_dupli_type_set(PointerRNA *ptr, int value);

int Object_use_dupli_vertices_rotation_get(PointerRNA *ptr);
void Object_use_dupli_vertices_rotation_set(PointerRNA *ptr, int value);

void Object_dupli_list_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Object_dupli_list_next(CollectionPropertyIterator *iter);
void Object_dupli_list_end(CollectionPropertyIterator *iter);
int Object_dupli_list_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int Object_use_dynamic_topology_sculpting_get(PointerRNA *ptr);
void Object_use_dynamic_topology_sculpting_set(PointerRNA *ptr, int value);

float Object_empty_draw_size_get(PointerRNA *ptr);
void Object_empty_draw_size_set(PointerRNA *ptr, float value);

enum {
	Object_empty_draw_type_PLAIN_AXES = 2,
	Object_empty_draw_type_ARROWS = 1,
	Object_empty_draw_type_SINGLE_ARROW = 4,
	Object_empty_draw_type_CIRCLE = 3,
	Object_empty_draw_type_CUBE = 5,
	Object_empty_draw_type_SPHERE = 6,
	Object_empty_draw_type_CONE = 7,
	Object_empty_draw_type_IMAGE = 8,
};

int Object_empty_draw_type_get(PointerRNA *ptr);
void Object_empty_draw_type_set(PointerRNA *ptr, int value);

void Object_rotation_euler_get(PointerRNA *ptr, float values[3]);
void Object_rotation_euler_set(PointerRNA *ptr, const float values[3]);

int Object_use_extra_recalc_data_get(PointerRNA *ptr);
void Object_use_extra_recalc_data_set(PointerRNA *ptr, int value);

int Object_use_extra_recalc_object_get(PointerRNA *ptr);
void Object_use_extra_recalc_object_set(PointerRNA *ptr, int value);

PointerRNA Object_field_get(PointerRNA *ptr);

PointerRNA Object_game_get(PointerRNA *ptr);

PointerRNA Object_grease_pencil_get(PointerRNA *ptr);

PointerRNA Object_image_user_get(PointerRNA *ptr);

void Object_matrix_basis_get(PointerRNA *ptr, float values[16]);
void Object_matrix_basis_set(PointerRNA *ptr, const float values[16]);

void Object_layers_get(PointerRNA *ptr, int values[20]);
void Object_layers_set(PointerRNA *ptr, const int values[20]);

void Object_lod_levels_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Object_lod_levels_next(CollectionPropertyIterator *iter);
void Object_lod_levels_end(CollectionPropertyIterator *iter);
int Object_lod_levels_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void Object_matrix_local_get(PointerRNA *ptr, float values[16]);
void Object_matrix_local_set(PointerRNA *ptr, const float values[16]);

void Object_layers_local_view_get(PointerRNA *ptr, int values[8]);
void Object_layers_local_view_set(PointerRNA *ptr, const int values[8]);

void Object_location_get(PointerRNA *ptr, float values[3]);
void Object_location_set(PointerRNA *ptr, const float values[3]);

void Object_lock_location_get(PointerRNA *ptr, int values[3]);
void Object_lock_location_set(PointerRNA *ptr, const int values[3]);

void Object_lock_rotation_get(PointerRNA *ptr, int values[3]);
void Object_lock_rotation_set(PointerRNA *ptr, const int values[3]);

int Object_lock_rotation_w_get(PointerRNA *ptr);
void Object_lock_rotation_w_set(PointerRNA *ptr, int value);

int Object_lock_rotations_4d_get(PointerRNA *ptr);
void Object_lock_rotations_4d_set(PointerRNA *ptr, int value);

void Object_lock_scale_get(PointerRNA *ptr, int values[3]);
void Object_lock_scale_set(PointerRNA *ptr, const int values[3]);

void Object_material_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Object_material_slots_next(CollectionPropertyIterator *iter);
void Object_material_slots_end(CollectionPropertyIterator *iter);
int Object_material_slots_length(PointerRNA *ptr);
int Object_material_slots_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Object_material_slots_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Object_matrix_parent_inverse_get(PointerRNA *ptr, float values[16]);
void Object_matrix_parent_inverse_set(PointerRNA *ptr, const float values[16]);

void Object_matrix_world_get(PointerRNA *ptr, float values[16]);
void Object_matrix_world_set(PointerRNA *ptr, const float values[16]);

enum {
	Object_draw_type_BOUNDS = 1,
	Object_draw_type_WIRE = 2,
	Object_draw_type_SOLID = 3,
	Object_draw_type_TEXTURED = 5,
};

int Object_draw_type_get(PointerRNA *ptr);
void Object_draw_type_set(PointerRNA *ptr, int value);

enum {
	Object_mode_OBJECT = 0,
	Object_mode_EDIT = 1,
	Object_mode_POSE = 64,
	Object_mode_SCULPT = 2,
	Object_mode_VERTEX_PAINT = 4,
	Object_mode_WEIGHT_PAINT = 8,
	Object_mode_TEXTURE_PAINT = 16,
	Object_mode_PARTICLE_EDIT = 32,
};

int Object_mode_get(PointerRNA *ptr);
void Object_mode_set(PointerRNA *ptr, int value);

void Object_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Object_modifiers_next(CollectionPropertyIterator *iter);
void Object_modifiers_end(CollectionPropertyIterator *iter);
int Object_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Object_modifiers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA Object_motion_path_get(PointerRNA *ptr);

void Object_empty_image_offset_get(PointerRNA *ptr, float values[2]);
void Object_empty_image_offset_set(PointerRNA *ptr, const float values[2]);

PointerRNA Object_parent_get(PointerRNA *ptr);

#define Object_parent_bone_MAX 64

void Object_parent_bone_get(PointerRNA *ptr, char *value);
int Object_parent_bone_length(PointerRNA *ptr);
void Object_parent_bone_set(PointerRNA *ptr, const char *value);

enum {
	Object_parent_type_OBJECT = 0,
	Object_parent_type_CURVE = 1,
	Object_parent_type_KEY = 2,
	Object_parent_type_ARMATURE = 4,
	Object_parent_type_LATTICE = 4,
	Object_parent_type_VERTEX = 5,
	Object_parent_type_VERTEX_3 = 6,
	Object_parent_type_BONE = 7,
};

int Object_parent_type_get(PointerRNA *ptr);
void Object_parent_type_set(PointerRNA *ptr, int value);

void Object_parent_vertices_get(PointerRNA *ptr, int values[3]);
void Object_parent_vertices_set(PointerRNA *ptr, const int values[3]);

void Object_particle_systems_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Object_particle_systems_next(CollectionPropertyIterator *iter);
void Object_particle_systems_end(CollectionPropertyIterator *iter);
int Object_particle_systems_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Object_particle_systems_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Object_pass_index_get(PointerRNA *ptr);
void Object_pass_index_set(PointerRNA *ptr, int value);

PointerRNA Object_pose_get(PointerRNA *ptr);

PointerRNA Object_pose_library_get(PointerRNA *ptr);

PointerRNA Object_proxy_get(PointerRNA *ptr);

PointerRNA Object_proxy_group_get(PointerRNA *ptr);

void Object_rotation_quaternion_get(PointerRNA *ptr, float values[4]);
void Object_rotation_quaternion_set(PointerRNA *ptr, const float values[4]);

int Object_hide_render_get(PointerRNA *ptr);
void Object_hide_render_set(PointerRNA *ptr, int value);

int Object_hide_select_get(PointerRNA *ptr);
void Object_hide_select_set(PointerRNA *ptr, int value);

int Object_hide_get(PointerRNA *ptr);
void Object_hide_set(PointerRNA *ptr, int value);

PointerRNA Object_rigid_body_constraint_get(PointerRNA *ptr);

PointerRNA Object_rigid_body_get(PointerRNA *ptr);

enum {
	Object_rotation_mode_QUATERNION = 0,
	Object_rotation_mode_XYZ = 1,
	Object_rotation_mode_XZY = 2,
	Object_rotation_mode_YXZ = 3,
	Object_rotation_mode_YZX = 4,
	Object_rotation_mode_ZXY = 5,
	Object_rotation_mode_ZYX = 6,
	Object_rotation_mode_AXIS_ANGLE = -1,
};

int Object_rotation_mode_get(PointerRNA *ptr);
void Object_rotation_mode_set(PointerRNA *ptr, int value);

void Object_scale_get(PointerRNA *ptr, float values[3]);
void Object_scale_set(PointerRNA *ptr, const float values[3]);

int Object_select_get(PointerRNA *ptr);
void Object_select_set(PointerRNA *ptr, int value);

int Object_use_shape_key_edit_mode_get(PointerRNA *ptr);
void Object_use_shape_key_edit_mode_set(PointerRNA *ptr, int value);

int Object_show_only_shape_key_get(PointerRNA *ptr);
void Object_show_only_shape_key_set(PointerRNA *ptr, int value);

int Object_use_slow_parent_get(PointerRNA *ptr);
void Object_use_slow_parent_set(PointerRNA *ptr, int value);

float Object_slow_parent_offset_get(PointerRNA *ptr);
void Object_slow_parent_offset_set(PointerRNA *ptr, float value);

PointerRNA Object_soft_body_get(PointerRNA *ptr);

enum {
	Object_track_axis_POS_X = 0,
	Object_track_axis_POS_Y = 1,
	Object_track_axis_POS_Z = 2,
	Object_track_axis_NEG_X = 3,
	Object_track_axis_NEG_Y = 4,
	Object_track_axis_NEG_Z = 5,
};

int Object_track_axis_get(PointerRNA *ptr);
void Object_track_axis_set(PointerRNA *ptr, int value);

enum {
	Object_type_MESH = 1,
	Object_type_CURVE = 2,
	Object_type_SURFACE = 3,
	Object_type_META = 5,
	Object_type_FONT = 4,
	Object_type_ARMATURE = 25,
	Object_type_LATTICE = 22,
	Object_type_EMPTY = 0,
	Object_type_CAMERA = 11,
	Object_type_LAMP = 10,
	Object_type_SPEAKER = 12,
};

int Object_type_get(PointerRNA *ptr);
void Object_type_set(PointerRNA *ptr, int value);

enum {
	Object_up_axis_X = 0,
	Object_up_axis_Y = 1,
	Object_up_axis_Z = 2,
};

int Object_up_axis_get(PointerRNA *ptr);
void Object_up_axis_set(PointerRNA *ptr, int value);

void Object_vertex_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Object_vertex_groups_next(CollectionPropertyIterator *iter);
void Object_vertex_groups_end(CollectionPropertyIterator *iter);
int Object_vertex_groups_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Object_vertex_groups_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int Object_show_x_ray_get(PointerRNA *ptr);
void Object_show_x_ray_set(PointerRNA *ptr, int value);

int Object_is_duplicator_get(PointerRNA *ptr);
void Object_is_duplicator_set(PointerRNA *ptr, int value);

void Object_convert_space(struct Object *_self, ReportList *reports, struct bPoseChannel *pose_bone, float matrix[16], float matrix_return[16], int from_space, int to_space);
struct Mesh *Object_to_mesh(struct Object *_self, ReportList *reports, struct Scene *scene, int apply_modifiers, int settings, int calc_tessface, int calc_undeformed);
void Object_dupli_list_create(struct Object *_self, ReportList *reports, struct Scene *scene, int settings);
void Object_dupli_list_clear(struct Object *_self);
struct Object *Object_find_armature(struct Object *_self);
struct PointerRNA Object_shape_key_add(struct Object *_self, bContext *C, ReportList *reports, const char * name, int from_mix);
void Object_ray_cast(struct Object *_self, ReportList *reports, float start[3], float end[3], float location[3], float normal[3], int *index);
void Object_closest_point_on_mesh(struct Object *_self, ReportList *reports, float point[3], float max_dist, float location[3], float normal[3], int *index);
int Object_is_visible(struct Object *_self, struct Scene *scene);
int Object_is_modified(struct Object *_self, struct Scene *scene, int settings);
int Object_is_deform_modified(struct Object *_self, struct Scene *scene, int settings);
int Object_update_from_editmode(struct Object *_self);
/**************** Motion Actuator ****************/

extern StructRNA RNA_ObjectActuator;
extern StructRNA RNA_Actuator;

int ObjectActuator_use_add_linear_velocity_get(PointerRNA *ptr);
void ObjectActuator_use_add_linear_velocity_set(PointerRNA *ptr, int value);

int ObjectActuator_use_add_character_location_get(PointerRNA *ptr);
void ObjectActuator_use_add_character_location_set(PointerRNA *ptr, int value);

void ObjectActuator_angular_velocity_get(PointerRNA *ptr, float values[3]);
void ObjectActuator_angular_velocity_set(PointerRNA *ptr, const float values[3]);

int ObjectActuator_damping_get(PointerRNA *ptr);
void ObjectActuator_damping_set(PointerRNA *ptr, int value);

float ObjectActuator_derivate_coefficient_get(PointerRNA *ptr);
void ObjectActuator_derivate_coefficient_set(PointerRNA *ptr, float value);

void ObjectActuator_force_get(PointerRNA *ptr, float values[3]);
void ObjectActuator_force_set(PointerRNA *ptr, const float values[3]);

float ObjectActuator_integral_coefficient_get(PointerRNA *ptr);
void ObjectActuator_integral_coefficient_set(PointerRNA *ptr, float value);

int ObjectActuator_use_character_jump_get(PointerRNA *ptr);
void ObjectActuator_use_character_jump_set(PointerRNA *ptr, int value);

int ObjectActuator_use_local_location_get(PointerRNA *ptr);
void ObjectActuator_use_local_location_set(PointerRNA *ptr, int value);

int ObjectActuator_use_local_rotation_get(PointerRNA *ptr);
void ObjectActuator_use_local_rotation_set(PointerRNA *ptr, int value);

int ObjectActuator_use_local_force_get(PointerRNA *ptr);
void ObjectActuator_use_local_force_set(PointerRNA *ptr, int value);

int ObjectActuator_use_local_torque_get(PointerRNA *ptr);
void ObjectActuator_use_local_torque_set(PointerRNA *ptr, int value);

int ObjectActuator_use_local_linear_velocity_get(PointerRNA *ptr);
void ObjectActuator_use_local_linear_velocity_set(PointerRNA *ptr, int value);

int ObjectActuator_use_local_angular_velocity_get(PointerRNA *ptr);
void ObjectActuator_use_local_angular_velocity_set(PointerRNA *ptr, int value);

void ObjectActuator_linear_velocity_get(PointerRNA *ptr, float values[3]);
void ObjectActuator_linear_velocity_set(PointerRNA *ptr, const float values[3]);

void ObjectActuator_offset_location_get(PointerRNA *ptr, float values[3]);
void ObjectActuator_offset_location_set(PointerRNA *ptr, const float values[3]);

float ObjectActuator_force_max_x_get(PointerRNA *ptr);
void ObjectActuator_force_max_x_set(PointerRNA *ptr, float value);

float ObjectActuator_force_max_y_get(PointerRNA *ptr);
void ObjectActuator_force_max_y_set(PointerRNA *ptr, float value);

float ObjectActuator_force_max_z_get(PointerRNA *ptr);
void ObjectActuator_force_max_z_set(PointerRNA *ptr, float value);

float ObjectActuator_force_min_x_get(PointerRNA *ptr);
void ObjectActuator_force_min_x_set(PointerRNA *ptr, float value);

float ObjectActuator_force_min_y_get(PointerRNA *ptr);
void ObjectActuator_force_min_y_set(PointerRNA *ptr, float value);

float ObjectActuator_force_min_z_get(PointerRNA *ptr);
void ObjectActuator_force_min_z_set(PointerRNA *ptr, float value);

enum {
	ObjectActuator_mode_OBJECT_NORMAL = 0,
	ObjectActuator_mode_OBJECT_SERVO = 1,
	ObjectActuator_mode_OBJECT_CHARACTER = 2,
};

int ObjectActuator_mode_get(PointerRNA *ptr);
void ObjectActuator_mode_set(PointerRNA *ptr, int value);

float ObjectActuator_proportional_coefficient_get(PointerRNA *ptr);
void ObjectActuator_proportional_coefficient_set(PointerRNA *ptr, float value);

PointerRNA ObjectActuator_reference_object_get(PointerRNA *ptr);

void ObjectActuator_offset_rotation_get(PointerRNA *ptr, float values[3]);
void ObjectActuator_offset_rotation_set(PointerRNA *ptr, const float values[3]);

void ObjectActuator_torque_get(PointerRNA *ptr, float values[3]);
void ObjectActuator_torque_set(PointerRNA *ptr, const float values[3]);

int ObjectActuator_use_servo_limit_x_get(PointerRNA *ptr);
void ObjectActuator_use_servo_limit_x_set(PointerRNA *ptr, int value);

int ObjectActuator_use_servo_limit_y_get(PointerRNA *ptr);
void ObjectActuator_use_servo_limit_y_set(PointerRNA *ptr, int value);

int ObjectActuator_use_servo_limit_z_get(PointerRNA *ptr);
void ObjectActuator_use_servo_limit_z_set(PointerRNA *ptr, int value);

/**************** Object Base ****************/

extern StructRNA RNA_ObjectBase;

PointerRNA ObjectBase_rna_type_get(PointerRNA *ptr);

void ObjectBase_layers_get(PointerRNA *ptr, int values[20]);
void ObjectBase_layers_set(PointerRNA *ptr, const int values[20]);

void ObjectBase_layers_local_view_get(PointerRNA *ptr, int values[8]);
void ObjectBase_layers_local_view_set(PointerRNA *ptr, const int values[8]);

PointerRNA ObjectBase_object_get(PointerRNA *ptr);

int ObjectBase_select_get(PointerRNA *ptr);
void ObjectBase_select_set(PointerRNA *ptr, int value);

void ObjectBase_layers_from_view(struct Base *_self, struct View3D *view);
/**************** Object Constraints ****************/

extern StructRNA RNA_ObjectConstraints;

PointerRNA ObjectConstraints_rna_type_get(PointerRNA *ptr);

PointerRNA ObjectConstraints_active_get(PointerRNA *ptr);

struct bConstraint *ObjectConstraints_new(struct Object *_self, int type);
void ObjectConstraints_remove(struct Object *_self, ReportList *reports, struct PointerRNA *constraint);
void ObjectConstraints_clear(struct Object *_self);
/**************** Object Modifiers ****************/

extern StructRNA RNA_ObjectModifiers;

PointerRNA ObjectModifiers_rna_type_get(PointerRNA *ptr);

struct ModifierData *ObjectModifiers_new(struct Object *_self, bContext *C, ReportList *reports, const char * name, int type);
void ObjectModifiers_remove(struct Object *_self, bContext *C, ReportList *reports, struct PointerRNA *modifier);
void ObjectModifiers_clear(struct Object *_self, bContext *C);
/**************** Object Solver Constraint ****************/

extern StructRNA RNA_ObjectSolverConstraint;
extern StructRNA RNA_Constraint;

int ObjectSolverConstraint_use_active_clip_get(PointerRNA *ptr);
void ObjectSolverConstraint_use_active_clip_set(PointerRNA *ptr, int value);

PointerRNA ObjectSolverConstraint_camera_get(PointerRNA *ptr);

PointerRNA ObjectSolverConstraint_clip_get(PointerRNA *ptr);

#define ObjectSolverConstraint_object_MAX 64

void ObjectSolverConstraint_object_get(PointerRNA *ptr, char *value);
int ObjectSolverConstraint_object_length(PointerRNA *ptr);
void ObjectSolverConstraint_object_set(PointerRNA *ptr, const char *value);

/**************** Obstacle Fluid Simulation Settings ****************/

extern StructRNA RNA_ObstacleFluidSettings;
extern StructRNA RNA_FluidSettings;

int ObstacleFluidSettings_use_get(PointerRNA *ptr);
void ObstacleFluidSettings_use_set(PointerRNA *ptr, int value);

int ObstacleFluidSettings_use_animated_mesh_get(PointerRNA *ptr);
void ObstacleFluidSettings_use_animated_mesh_set(PointerRNA *ptr, int value);

float ObstacleFluidSettings_impact_factor_get(PointerRNA *ptr);
void ObstacleFluidSettings_impact_factor_set(PointerRNA *ptr, float value);

float ObstacleFluidSettings_partial_slip_factor_get(PointerRNA *ptr);
void ObstacleFluidSettings_partial_slip_factor_set(PointerRNA *ptr, float value);

enum {
	ObstacleFluidSettings_slip_type_NOSLIP = 512,
	ObstacleFluidSettings_slip_type_PARTIALSLIP = 1024,
	ObstacleFluidSettings_slip_type_FREESLIP = 2048,
};

int ObstacleFluidSettings_slip_type_get(PointerRNA *ptr);
void ObstacleFluidSettings_slip_type_set(PointerRNA *ptr, int value);

enum {
	ObstacleFluidSettings_volume_initialization_VOLUME = 1,
	ObstacleFluidSettings_volume_initialization_SHELL = 2,
	ObstacleFluidSettings_volume_initialization_BOTH = 3,
};

int ObstacleFluidSettings_volume_initialization_get(PointerRNA *ptr);
void ObstacleFluidSettings_volume_initialization_set(PointerRNA *ptr, int value);

/**************** Ocean Modifier ****************/

extern StructRNA RNA_OceanModifier;
extern StructRNA RNA_Modifier;

int OceanModifier_frame_end_get(PointerRNA *ptr);
void OceanModifier_frame_end_set(PointerRNA *ptr, int value);

int OceanModifier_frame_start_get(PointerRNA *ptr);
void OceanModifier_frame_start_set(PointerRNA *ptr, int value);

#define OceanModifier_filepath_MAX 1024

void OceanModifier_filepath_get(PointerRNA *ptr, char *value);
int OceanModifier_filepath_length(PointerRNA *ptr);
void OceanModifier_filepath_set(PointerRNA *ptr, const char *value);

float OceanModifier_choppiness_get(PointerRNA *ptr);
void OceanModifier_choppiness_set(PointerRNA *ptr, float value);

float OceanModifier_damping_get(PointerRNA *ptr);
void OceanModifier_damping_set(PointerRNA *ptr, float value);

float OceanModifier_depth_get(PointerRNA *ptr);
void OceanModifier_depth_set(PointerRNA *ptr, float value);

float OceanModifier_foam_coverage_get(PointerRNA *ptr);
void OceanModifier_foam_coverage_set(PointerRNA *ptr, float value);

float OceanModifier_bake_foam_fade_get(PointerRNA *ptr);
void OceanModifier_bake_foam_fade_set(PointerRNA *ptr, float value);

#define OceanModifier_foam_layer_name_MAX 64

void OceanModifier_foam_layer_name_get(PointerRNA *ptr, char *value);
int OceanModifier_foam_layer_name_length(PointerRNA *ptr);
void OceanModifier_foam_layer_name_set(PointerRNA *ptr, const char *value);

int OceanModifier_use_foam_get(PointerRNA *ptr);
void OceanModifier_use_foam_set(PointerRNA *ptr, int value);

int OceanModifier_use_normals_get(PointerRNA *ptr);
void OceanModifier_use_normals_set(PointerRNA *ptr, int value);

enum {
	OceanModifier_geometry_mode_GENERATE = 0,
	OceanModifier_geometry_mode_DISPLACE = 1,
};

int OceanModifier_geometry_mode_get(PointerRNA *ptr);
void OceanModifier_geometry_mode_set(PointerRNA *ptr, int value);

int OceanModifier_is_cached_get(PointerRNA *ptr);
void OceanModifier_is_cached_set(PointerRNA *ptr, int value);

int OceanModifier_random_seed_get(PointerRNA *ptr);
void OceanModifier_random_seed_set(PointerRNA *ptr, int value);

int OceanModifier_repeat_x_get(PointerRNA *ptr);
void OceanModifier_repeat_x_set(PointerRNA *ptr, int value);

int OceanModifier_repeat_y_get(PointerRNA *ptr);
void OceanModifier_repeat_y_set(PointerRNA *ptr, int value);

int OceanModifier_resolution_get(PointerRNA *ptr);
void OceanModifier_resolution_set(PointerRNA *ptr, int value);

float OceanModifier_size_get(PointerRNA *ptr);
void OceanModifier_size_set(PointerRNA *ptr, float value);

float OceanModifier_wave_scale_min_get(PointerRNA *ptr);
void OceanModifier_wave_scale_min_set(PointerRNA *ptr, float value);

int OceanModifier_spatial_size_get(PointerRNA *ptr);
void OceanModifier_spatial_size_set(PointerRNA *ptr, int value);

float OceanModifier_time_get(PointerRNA *ptr);
void OceanModifier_time_set(PointerRNA *ptr, float value);

float OceanModifier_wave_alignment_get(PointerRNA *ptr);
void OceanModifier_wave_alignment_set(PointerRNA *ptr, float value);

float OceanModifier_wave_direction_get(PointerRNA *ptr);
void OceanModifier_wave_direction_set(PointerRNA *ptr, float value);

float OceanModifier_wave_scale_get(PointerRNA *ptr);
void OceanModifier_wave_scale_set(PointerRNA *ptr, float value);

float OceanModifier_wind_velocity_get(PointerRNA *ptr);
void OceanModifier_wind_velocity_set(PointerRNA *ptr, float value);

/**************** Ocean ****************/

extern StructRNA RNA_OceanTexData;

PointerRNA OceanTexData_rna_type_get(PointerRNA *ptr);

PointerRNA OceanTexData_ocean_object_get(PointerRNA *ptr);

enum {
	OceanTexData_output_DISPLACEMENT = 1,
	OceanTexData_output_FOAM = 2,
	OceanTexData_output_JPLUS = 3,
	OceanTexData_output_EMINUS = 4,
	OceanTexData_output_EPLUS = 5,
};

int OceanTexData_output_get(PointerRNA *ptr);
void OceanTexData_output_set(PointerRNA *ptr, int value);

/**************** Ocean ****************/

extern StructRNA RNA_OceanTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

PointerRNA OceanTexture_ocean_get(PointerRNA *ptr);

/**************** Operator ****************/

extern StructRNA RNA_Operator;

PointerRNA Operator_rna_type_get(PointerRNA *ptr);

void Operator_name_get(PointerRNA *ptr, char *value);
int Operator_name_length(PointerRNA *ptr);
void Operator_name_set(PointerRNA *ptr, const char *value);

int Operator_has_reports_get(PointerRNA *ptr);
void Operator_has_reports_set(PointerRNA *ptr, int value);

enum {
	Operator_bl_options_REGISTER = 1,
	Operator_bl_options_UNDO = 2,
	Operator_bl_options_BLOCKING = 4,
	Operator_bl_options_MACRO = 8,
	Operator_bl_options_GRAB_POINTER = 16,
	Operator_bl_options_PRESET = 32,
	Operator_bl_options_INTERNAL = 64,
};

int Operator_bl_options_get(PointerRNA *ptr);
void Operator_bl_options_set(PointerRNA *ptr, int value);

PointerRNA Operator_properties_get(PointerRNA *ptr);

#define Operator_bl_description_MAX 240

void Operator_bl_description_get(PointerRNA *ptr, char *value);
int Operator_bl_description_length(PointerRNA *ptr);
void Operator_bl_description_set(PointerRNA *ptr, const char *value);

#define Operator_bl_idname_MAX 61

void Operator_bl_idname_get(PointerRNA *ptr, char *value);
int Operator_bl_idname_length(PointerRNA *ptr);
void Operator_bl_idname_set(PointerRNA *ptr, const char *value);

#define Operator_bl_label_MAX 240

void Operator_bl_label_get(PointerRNA *ptr, char *value);
int Operator_bl_label_length(PointerRNA *ptr);
void Operator_bl_label_set(PointerRNA *ptr, const char *value);

#define Operator_bl_translation_context_MAX 240

void Operator_bl_translation_context_get(PointerRNA *ptr, char *value);
int Operator_bl_translation_context_length(PointerRNA *ptr);
void Operator_bl_translation_context_set(PointerRNA *ptr, const char *value);

PointerRNA Operator_layout_get(PointerRNA *ptr);

void Operator_report(struct wmOperator *_self, int type, const char * message);
int Operator_poll(struct bContext *context);
int Operator_execute(struct wmOperator *_self, struct bContext *context);
int Operator_check(struct wmOperator *_self, struct bContext *context);
int Operator_invoke(struct wmOperator *_self, struct bContext *context, struct wmEvent *event);
int Operator_modal(struct wmOperator *_self, struct bContext *context, struct wmEvent *event);
void Operator_draw(struct wmOperator *_self, struct bContext *context);
void Operator_cancel(struct wmOperator *_self, struct bContext *context);
/**************** Operator File List Element ****************/

extern StructRNA RNA_OperatorFileListElement;
extern StructRNA RNA_PropertyGroup;

/**************** Operator Macro ****************/

extern StructRNA RNA_OperatorMacro;

PointerRNA OperatorMacro_rna_type_get(PointerRNA *ptr);

PointerRNA OperatorMacro_properties_get(PointerRNA *ptr);

/**************** Operator Mouse Path ****************/

extern StructRNA RNA_OperatorMousePath;
extern StructRNA RNA_PropertyGroup;

/**************** Operator Properties ****************/

extern StructRNA RNA_OperatorProperties;

PointerRNA OperatorProperties_rna_type_get(PointerRNA *ptr);

/**************** Operator Stroke Element ****************/

extern StructRNA RNA_OperatorStrokeElement;
extern StructRNA RNA_PropertyGroup;

/**************** Or Controller ****************/

extern StructRNA RNA_OrController;
extern StructRNA RNA_Controller;

/**************** Outflow Fluid Simulation Settings ****************/

extern StructRNA RNA_OutflowFluidSettings;
extern StructRNA RNA_FluidSettings;

int OutflowFluidSettings_use_get(PointerRNA *ptr);
void OutflowFluidSettings_use_set(PointerRNA *ptr, int value);

int OutflowFluidSettings_use_animated_mesh_get(PointerRNA *ptr);
void OutflowFluidSettings_use_animated_mesh_set(PointerRNA *ptr, int value);

enum {
	OutflowFluidSettings_volume_initialization_VOLUME = 1,
	OutflowFluidSettings_volume_initialization_SHELL = 2,
	OutflowFluidSettings_volume_initialization_BOTH = 3,
};

int OutflowFluidSettings_volume_initialization_get(PointerRNA *ptr);
void OutflowFluidSettings_volume_initialization_set(PointerRNA *ptr, int value);

/**************** Over Drop Sequence ****************/

extern StructRNA RNA_OverDropSequence;
extern StructRNA RNA_EffectSequence;
extern StructRNA RNA_Sequence;

PointerRNA OverDropSequence_input_1_get(PointerRNA *ptr);

PointerRNA OverDropSequence_input_2_get(PointerRNA *ptr);

int OverDropSequence_input_count_get(PointerRNA *ptr);
void OverDropSequence_input_count_set(PointerRNA *ptr, int value);

/**************** Packed File ****************/

extern StructRNA RNA_PackedFile;

PointerRNA PackedFile_rna_type_get(PointerRNA *ptr);

void PackedFile_data_get(PointerRNA *ptr, char *value);
int PackedFile_data_length(PointerRNA *ptr);
void PackedFile_data_set(PointerRNA *ptr, const char *value);

int PackedFile_size_get(PointerRNA *ptr);
void PackedFile_size_set(PointerRNA *ptr, int value);

/**************** Paint ****************/

extern StructRNA RNA_Paint;

PointerRNA Paint_rna_type_get(PointerRNA *ptr);

PointerRNA Paint_brush_get(PointerRNA *ptr);

int Paint_show_low_resolution_get(PointerRNA *ptr);
void Paint_show_low_resolution_set(PointerRNA *ptr, int value);

int Paint_input_samples_get(PointerRNA *ptr);
void Paint_input_samples_set(PointerRNA *ptr, int value);

PointerRNA Paint_palette_get(PointerRNA *ptr);

int Paint_show_brush_get(PointerRNA *ptr);
void Paint_show_brush_set(PointerRNA *ptr, int value);

int Paint_show_brush_on_surface_get(PointerRNA *ptr);
void Paint_show_brush_on_surface_set(PointerRNA *ptr, int value);

int Paint_use_symmetry_feather_get(PointerRNA *ptr);
void Paint_use_symmetry_feather_set(PointerRNA *ptr, int value);

int Paint_use_symmetry_x_get(PointerRNA *ptr);
void Paint_use_symmetry_x_set(PointerRNA *ptr, int value);

int Paint_use_symmetry_y_get(PointerRNA *ptr);
void Paint_use_symmetry_y_set(PointerRNA *ptr, int value);

int Paint_use_symmetry_z_get(PointerRNA *ptr);
void Paint_use_symmetry_z_set(PointerRNA *ptr, int value);

/**************** Paint Curve ****************/

extern StructRNA RNA_PaintCurve;
extern StructRNA RNA_ID;

/**************** Palette ****************/

extern StructRNA RNA_Palette;
extern StructRNA RNA_ID;

void Palette_colors_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Palette_colors_next(CollectionPropertyIterator *iter);
void Palette_colors_end(CollectionPropertyIterator *iter);
int Palette_colors_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Palette Color ****************/

extern StructRNA RNA_PaletteColor;

PointerRNA PaletteColor_rna_type_get(PointerRNA *ptr);

void PaletteColor_color_get(PointerRNA *ptr, float values[3]);
void PaletteColor_color_set(PointerRNA *ptr, const float values[3]);

float PaletteColor_strength_get(PointerRNA *ptr);
void PaletteColor_strength_set(PointerRNA *ptr, float value);

float PaletteColor_weight_get(PointerRNA *ptr);
void PaletteColor_weight_set(PointerRNA *ptr, float value);

/**************** Panel ****************/

extern StructRNA RNA_Panel;

PointerRNA Panel_rna_type_get(PointerRNA *ptr);

void Panel_bl_context_get(PointerRNA *ptr, char *value);
int Panel_bl_context_length(PointerRNA *ptr);
void Panel_bl_context_set(PointerRNA *ptr, const char *value);

void Panel_bl_idname_get(PointerRNA *ptr, char *value);
int Panel_bl_idname_length(PointerRNA *ptr);
void Panel_bl_idname_set(PointerRNA *ptr, const char *value);

void Panel_bl_label_get(PointerRNA *ptr, char *value);
int Panel_bl_label_length(PointerRNA *ptr);
void Panel_bl_label_set(PointerRNA *ptr, const char *value);

PointerRNA Panel_layout_get(PointerRNA *ptr);

enum {
	Panel_bl_options_DEFAULT_CLOSED = 1,
	Panel_bl_options_HIDE_HEADER = 2,
};

int Panel_bl_options_get(PointerRNA *ptr);
void Panel_bl_options_set(PointerRNA *ptr, int value);

int Panel_use_pin_get(PointerRNA *ptr);
void Panel_use_pin_set(PointerRNA *ptr, int value);

enum {
	Panel_bl_region_type_WINDOW = 0,
	Panel_bl_region_type_HEADER = 1,
	Panel_bl_region_type_CHANNELS = 2,
	Panel_bl_region_type_TEMPORARY = 3,
	Panel_bl_region_type_UI = 4,
	Panel_bl_region_type_TOOLS = 5,
	Panel_bl_region_type_TOOL_PROPS = 6,
	Panel_bl_region_type_PREVIEW = 7,
};

int Panel_bl_region_type_get(PointerRNA *ptr);
void Panel_bl_region_type_set(PointerRNA *ptr, int value);

enum {
	Panel_bl_space_type_EMPTY = 0,
	Panel_bl_space_type_VIEW_3D = 1,
	Panel_bl_space_type_TIMELINE = 15,
	Panel_bl_space_type_GRAPH_EDITOR = 2,
	Panel_bl_space_type_DOPESHEET_EDITOR = 12,
	Panel_bl_space_type_NLA_EDITOR = 13,
	Panel_bl_space_type_IMAGE_EDITOR = 6,
	Panel_bl_space_type_SEQUENCE_EDITOR = 8,
	Panel_bl_space_type_CLIP_EDITOR = 20,
	Panel_bl_space_type_TEXT_EDITOR = 9,
	Panel_bl_space_type_NODE_EDITOR = 16,
	Panel_bl_space_type_LOGIC_EDITOR = 17,
	Panel_bl_space_type_PROPERTIES = 4,
	Panel_bl_space_type_OUTLINER = 3,
	Panel_bl_space_type_USER_PREFERENCES = 19,
	Panel_bl_space_type_INFO = 7,
	Panel_bl_space_type_FILE_BROWSER = 5,
	Panel_bl_space_type_CONSOLE = 18,
};

int Panel_bl_space_type_get(PointerRNA *ptr);
void Panel_bl_space_type_set(PointerRNA *ptr, int value);

#define Panel_text_MAX 64

void Panel_text_get(PointerRNA *ptr, char *value);
int Panel_text_length(PointerRNA *ptr);
void Panel_text_set(PointerRNA *ptr, const char *value);

void Panel_bl_category_get(PointerRNA *ptr, char *value);
int Panel_bl_category_length(PointerRNA *ptr);
void Panel_bl_category_set(PointerRNA *ptr, const char *value);

void Panel_bl_translation_context_get(PointerRNA *ptr, char *value);
int Panel_bl_translation_context_length(PointerRNA *ptr);
void Panel_bl_translation_context_set(PointerRNA *ptr, const char *value);

int Panel_poll(struct bContext *context);
void Panel_draw(struct Panel *_self, struct bContext *context);
void Panel_draw_header(struct Panel *_self, struct bContext *context);
/**************** Parent Actuator ****************/

extern StructRNA RNA_ParentActuator;
extern StructRNA RNA_Actuator;

int ParentActuator_use_compound_get(PointerRNA *ptr);
void ParentActuator_use_compound_set(PointerRNA *ptr, int value);

int ParentActuator_use_ghost_get(PointerRNA *ptr);
void ParentActuator_use_ghost_set(PointerRNA *ptr, int value);

PointerRNA ParentActuator_object_get(PointerRNA *ptr);

enum {
	ParentActuator_mode_SETPARENT = 0,
	ParentActuator_mode_REMOVEPARENT = 1,
};

int ParentActuator_mode_get(PointerRNA *ptr);
void ParentActuator_mode_set(PointerRNA *ptr, int value);

/**************** Particle ****************/

extern StructRNA RNA_Particle;

PointerRNA Particle_rna_type_get(PointerRNA *ptr);

enum {
	Particle_alive_state_DEAD = 1,
	Particle_alive_state_UNBORN = 2,
	Particle_alive_state_ALIVE = 3,
	Particle_alive_state_DYING = 4,
};

int Particle_alive_state_get(PointerRNA *ptr);
void Particle_alive_state_set(PointerRNA *ptr, int value);

void Particle_angular_velocity_get(PointerRNA *ptr, float values[3]);
void Particle_angular_velocity_set(PointerRNA *ptr, const float values[3]);

float Particle_birth_time_get(PointerRNA *ptr);
void Particle_birth_time_set(PointerRNA *ptr, float value);

float Particle_die_time_get(PointerRNA *ptr);
void Particle_die_time_set(PointerRNA *ptr, float value);

int Particle_is_exist_get(PointerRNA *ptr);
void Particle_is_exist_set(PointerRNA *ptr, int value);

void Particle_hair_keys_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Particle_hair_keys_next(CollectionPropertyIterator *iter);
void Particle_hair_keys_end(CollectionPropertyIterator *iter);
int Particle_hair_keys_length(PointerRNA *ptr);
int Particle_hair_keys_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void Particle_particle_keys_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Particle_particle_keys_next(CollectionPropertyIterator *iter);
void Particle_particle_keys_end(CollectionPropertyIterator *iter);
int Particle_particle_keys_length(PointerRNA *ptr);
int Particle_particle_keys_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

float Particle_lifetime_get(PointerRNA *ptr);
void Particle_lifetime_set(PointerRNA *ptr, float value);

void Particle_location_get(PointerRNA *ptr, float values[3]);
void Particle_location_set(PointerRNA *ptr, const float values[3]);

void Particle_velocity_get(PointerRNA *ptr, float values[3]);
void Particle_velocity_set(PointerRNA *ptr, const float values[3]);

void Particle_prev_angular_velocity_get(PointerRNA *ptr, float values[3]);
void Particle_prev_angular_velocity_set(PointerRNA *ptr, const float values[3]);

void Particle_prev_location_get(PointerRNA *ptr, float values[3]);
void Particle_prev_location_set(PointerRNA *ptr, const float values[3]);

void Particle_prev_velocity_get(PointerRNA *ptr, float values[3]);
void Particle_prev_velocity_set(PointerRNA *ptr, const float values[3]);

void Particle_prev_rotation_get(PointerRNA *ptr, float values[4]);
void Particle_prev_rotation_set(PointerRNA *ptr, const float values[4]);

void Particle_rotation_get(PointerRNA *ptr, float values[4]);
void Particle_rotation_set(PointerRNA *ptr, const float values[4]);

float Particle_size_get(PointerRNA *ptr);
void Particle_size_set(PointerRNA *ptr, float value);

int Particle_is_visible_get(PointerRNA *ptr);
void Particle_is_visible_set(PointerRNA *ptr, int value);

void Particle_uv_on_emitter(struct ParticleData *_self, ReportList *reports, struct ParticleSystemModifierData *modifier, float uv[2]);
/**************** Particle Brush ****************/

extern StructRNA RNA_ParticleBrush;

PointerRNA ParticleBrush_rna_type_get(PointerRNA *ptr);

int ParticleBrush_count_get(PointerRNA *ptr);
void ParticleBrush_count_set(PointerRNA *ptr, int value);

PointerRNA ParticleBrush_curve_get(PointerRNA *ptr);

enum {
	ParticleBrush_length_mode_GROW = 0,
	ParticleBrush_length_mode_SHRINK = 1,
};

int ParticleBrush_length_mode_get(PointerRNA *ptr);
void ParticleBrush_length_mode_set(PointerRNA *ptr, int value);

enum {
	ParticleBrush_puff_mode_ADD = 0,
	ParticleBrush_puff_mode_SUB = 1,
};

int ParticleBrush_puff_mode_get(PointerRNA *ptr);
void ParticleBrush_puff_mode_set(PointerRNA *ptr, int value);

int ParticleBrush_use_puff_volume_get(PointerRNA *ptr);
void ParticleBrush_use_puff_volume_set(PointerRNA *ptr, int value);

int ParticleBrush_size_get(PointerRNA *ptr);
void ParticleBrush_size_set(PointerRNA *ptr, int value);

int ParticleBrush_steps_get(PointerRNA *ptr);
void ParticleBrush_steps_set(PointerRNA *ptr, int value);

float ParticleBrush_strength_get(PointerRNA *ptr);
void ParticleBrush_strength_set(PointerRNA *ptr, float value);

/**************** Particle Dupliobject Weight ****************/

extern StructRNA RNA_ParticleDupliWeight;

PointerRNA ParticleDupliWeight_rna_type_get(PointerRNA *ptr);

void ParticleDupliWeight_name_get(PointerRNA *ptr, char *value);
int ParticleDupliWeight_name_length(PointerRNA *ptr);
void ParticleDupliWeight_name_set(PointerRNA *ptr, const char *value);

int ParticleDupliWeight_count_get(PointerRNA *ptr);
void ParticleDupliWeight_count_set(PointerRNA *ptr, int value);

/**************** Particle Edit ****************/

extern StructRNA RNA_ParticleEdit;

PointerRNA ParticleEdit_rna_type_get(PointerRNA *ptr);

int ParticleEdit_use_auto_velocity_get(PointerRNA *ptr);
void ParticleEdit_use_auto_velocity_set(PointerRNA *ptr, int value);

PointerRNA ParticleEdit_brush_get(PointerRNA *ptr);

int ParticleEdit_use_emitter_deflect_get(PointerRNA *ptr);
void ParticleEdit_use_emitter_deflect_set(PointerRNA *ptr, int value);

int ParticleEdit_show_particles_get(PointerRNA *ptr);
void ParticleEdit_show_particles_set(PointerRNA *ptr, int value);

int ParticleEdit_is_editable_get(PointerRNA *ptr);
void ParticleEdit_is_editable_set(PointerRNA *ptr, int value);

float ParticleEdit_emitter_distance_get(PointerRNA *ptr);
void ParticleEdit_emitter_distance_set(PointerRNA *ptr, float value);

int ParticleEdit_use_fade_time_get(PointerRNA *ptr);
void ParticleEdit_use_fade_time_set(PointerRNA *ptr, int value);

int ParticleEdit_fade_frames_get(PointerRNA *ptr);
void ParticleEdit_fade_frames_set(PointerRNA *ptr, int value);

int ParticleEdit_is_hair_get(PointerRNA *ptr);
void ParticleEdit_is_hair_set(PointerRNA *ptr, int value);

int ParticleEdit_use_default_interpolate_get(PointerRNA *ptr);
void ParticleEdit_use_default_interpolate_set(PointerRNA *ptr, int value);

int ParticleEdit_use_preserve_length_get(PointerRNA *ptr);
void ParticleEdit_use_preserve_length_set(PointerRNA *ptr, int value);

int ParticleEdit_use_preserve_root_get(PointerRNA *ptr);
void ParticleEdit_use_preserve_root_set(PointerRNA *ptr, int value);

int ParticleEdit_default_key_count_get(PointerRNA *ptr);
void ParticleEdit_default_key_count_set(PointerRNA *ptr, int value);

PointerRNA ParticleEdit_object_get(PointerRNA *ptr);

enum {
	ParticleEdit_select_mode_PATH = 1,
	ParticleEdit_select_mode_POINT = 2,
	ParticleEdit_select_mode_TIP = 4,
};

int ParticleEdit_select_mode_get(PointerRNA *ptr);
void ParticleEdit_select_mode_set(PointerRNA *ptr, int value);

int ParticleEdit_draw_step_get(PointerRNA *ptr);
void ParticleEdit_draw_step_set(PointerRNA *ptr, int value);

enum {
	ParticleEdit_tool_NONE = -1,
	ParticleEdit_tool_COMB = 0,
	ParticleEdit_tool_SMOOTH = 5,
	ParticleEdit_tool_ADD = 4,
	ParticleEdit_tool_LENGTH = 2,
	ParticleEdit_tool_PUFF = 3,
	ParticleEdit_tool_CUT = 1,
	ParticleEdit_tool_WEIGHT = 6,
};

int ParticleEdit_tool_get(PointerRNA *ptr);
void ParticleEdit_tool_set(PointerRNA *ptr, int value);

enum {
	ParticleEdit_type_PARTICLES = 0,
	ParticleEdit_type_SOFT_BODY = 1,
	ParticleEdit_type_CLOTH = 2,
};

int ParticleEdit_type_get(PointerRNA *ptr);
void ParticleEdit_type_set(PointerRNA *ptr, int value);

/**************** Particle Fluid Simulation Settings ****************/

extern StructRNA RNA_ParticleFluidSettings;
extern StructRNA RNA_FluidSettings;

float ParticleFluidSettings_alpha_influence_get(PointerRNA *ptr);
void ParticleFluidSettings_alpha_influence_set(PointerRNA *ptr, float value);

int ParticleFluidSettings_use_drops_get(PointerRNA *ptr);
void ParticleFluidSettings_use_drops_set(PointerRNA *ptr, int value);

int ParticleFluidSettings_use_floats_get(PointerRNA *ptr);
void ParticleFluidSettings_use_floats_set(PointerRNA *ptr, int value);

float ParticleFluidSettings_particle_influence_get(PointerRNA *ptr);
void ParticleFluidSettings_particle_influence_set(PointerRNA *ptr, float value);

#define ParticleFluidSettings_filepath_MAX 1024

void ParticleFluidSettings_filepath_get(PointerRNA *ptr, char *value);
int ParticleFluidSettings_filepath_length(PointerRNA *ptr);
void ParticleFluidSettings_filepath_set(PointerRNA *ptr, const char *value);

int ParticleFluidSettings_show_tracer_get(PointerRNA *ptr);
void ParticleFluidSettings_show_tracer_set(PointerRNA *ptr, int value);

/**************** Particle Hair Key ****************/

extern StructRNA RNA_ParticleHairKey;

PointerRNA ParticleHairKey_rna_type_get(PointerRNA *ptr);

void ParticleHairKey_co_local_get(PointerRNA *ptr, float values[3]);
void ParticleHairKey_co_local_set(PointerRNA *ptr, const float values[3]);

void ParticleHairKey_co_get(PointerRNA *ptr, float values[3]);
void ParticleHairKey_co_set(PointerRNA *ptr, const float values[3]);

float ParticleHairKey_time_get(PointerRNA *ptr);
void ParticleHairKey_time_set(PointerRNA *ptr, float value);

float ParticleHairKey_weight_get(PointerRNA *ptr);
void ParticleHairKey_weight_set(PointerRNA *ptr, float value);

void ParticleHairKey_co_object(struct HairKey *_self, struct Object *object, struct ParticleSystemModifierData *modifier, struct ParticleData *particle, float co[3]);
/**************** ParticleInstance Modifier ****************/

extern StructRNA RNA_ParticleInstanceModifier;
extern StructRNA RNA_Modifier;

int ParticleInstanceModifier_show_alive_get(PointerRNA *ptr);
void ParticleInstanceModifier_show_alive_set(PointerRNA *ptr, int value);

enum {
	ParticleInstanceModifier_axis_X = 0,
	ParticleInstanceModifier_axis_Y = 1,
	ParticleInstanceModifier_axis_Z = 2,
};

int ParticleInstanceModifier_axis_get(PointerRNA *ptr);
void ParticleInstanceModifier_axis_set(PointerRNA *ptr, int value);

int ParticleInstanceModifier_use_children_get(PointerRNA *ptr);
void ParticleInstanceModifier_use_children_set(PointerRNA *ptr, int value);

int ParticleInstanceModifier_show_dead_get(PointerRNA *ptr);
void ParticleInstanceModifier_show_dead_set(PointerRNA *ptr, int value);

int ParticleInstanceModifier_use_preserve_shape_get(PointerRNA *ptr);
void ParticleInstanceModifier_use_preserve_shape_set(PointerRNA *ptr, int value);

int ParticleInstanceModifier_use_normal_get(PointerRNA *ptr);
void ParticleInstanceModifier_use_normal_set(PointerRNA *ptr, int value);

PointerRNA ParticleInstanceModifier_object_get(PointerRNA *ptr);

int ParticleInstanceModifier_particle_system_index_get(PointerRNA *ptr);
void ParticleInstanceModifier_particle_system_index_set(PointerRNA *ptr, int value);

int ParticleInstanceModifier_use_path_get(PointerRNA *ptr);
void ParticleInstanceModifier_use_path_set(PointerRNA *ptr, int value);

float ParticleInstanceModifier_position_get(PointerRNA *ptr);
void ParticleInstanceModifier_position_set(PointerRNA *ptr, float value);

float ParticleInstanceModifier_random_position_get(PointerRNA *ptr);
void ParticleInstanceModifier_random_position_set(PointerRNA *ptr, float value);

int ParticleInstanceModifier_use_size_get(PointerRNA *ptr);
void ParticleInstanceModifier_use_size_set(PointerRNA *ptr, int value);

int ParticleInstanceModifier_show_unborn_get(PointerRNA *ptr);
void ParticleInstanceModifier_show_unborn_set(PointerRNA *ptr, int value);

/**************** Particle Key ****************/

extern StructRNA RNA_ParticleKey;

PointerRNA ParticleKey_rna_type_get(PointerRNA *ptr);

void ParticleKey_angular_velocity_get(PointerRNA *ptr, float values[3]);
void ParticleKey_angular_velocity_set(PointerRNA *ptr, const float values[3]);

void ParticleKey_location_get(PointerRNA *ptr, float values[3]);
void ParticleKey_location_set(PointerRNA *ptr, const float values[3]);

void ParticleKey_rotation_get(PointerRNA *ptr, float values[4]);
void ParticleKey_rotation_set(PointerRNA *ptr, const float values[4]);

float ParticleKey_time_get(PointerRNA *ptr);
void ParticleKey_time_set(PointerRNA *ptr, float value);

void ParticleKey_velocity_get(PointerRNA *ptr, float values[3]);
void ParticleKey_velocity_set(PointerRNA *ptr, const float values[3]);

/**************** Particle Settings ****************/

extern StructRNA RNA_ParticleSettings;
extern StructRNA RNA_ID;

int ParticleSettings_use_absolute_path_time_get(PointerRNA *ptr);
void ParticleSettings_use_absolute_path_time_set(PointerRNA *ptr, int value);

PointerRNA ParticleSettings_active_dupliweight_get(PointerRNA *ptr);

int ParticleSettings_active_dupliweight_index_get(PointerRNA *ptr);
void ParticleSettings_active_dupliweight_index_set(PointerRNA *ptr, int value);

PointerRNA ParticleSettings_active_texture_get(PointerRNA *ptr);

int ParticleSettings_active_texture_index_get(PointerRNA *ptr);
void ParticleSettings_active_texture_index_set(PointerRNA *ptr, int value);

float ParticleSettings_courant_target_get(PointerRNA *ptr);
void ParticleSettings_courant_target_set(PointerRNA *ptr, float value);

int ParticleSettings_use_render_adaptive_get(PointerRNA *ptr);
void ParticleSettings_use_render_adaptive_set(PointerRNA *ptr, int value);

int ParticleSettings_use_advanced_hair_get(PointerRNA *ptr);
void ParticleSettings_use_advanced_hair_set(PointerRNA *ptr, int value);

enum {
	ParticleSettings_billboard_align_X = 0,
	ParticleSettings_billboard_align_Y = 1,
	ParticleSettings_billboard_align_Z = 2,
	ParticleSettings_billboard_align_VIEW = 3,
	ParticleSettings_billboard_align_VEL = 4,
};

int ParticleSettings_billboard_align_get(PointerRNA *ptr);
void ParticleSettings_billboard_align_set(PointerRNA *ptr, int value);

float ParticleSettings_jitter_factor_get(PointerRNA *ptr);
void ParticleSettings_jitter_factor_set(PointerRNA *ptr, float value);

float ParticleSettings_kink_amplitude_get(PointerRNA *ptr);
void ParticleSettings_kink_amplitude_set(PointerRNA *ptr, float value);

float ParticleSettings_kink_amplitude_clump_get(PointerRNA *ptr);
void ParticleSettings_kink_amplitude_clump_set(PointerRNA *ptr, float value);

float ParticleSettings_angular_velocity_factor_get(PointerRNA *ptr);
void ParticleSettings_angular_velocity_factor_set(PointerRNA *ptr, float value);

enum {
	ParticleSettings_angular_velocity_mode_NONE = 0,
	ParticleSettings_angular_velocity_mode_VELOCITY = 1,
	ParticleSettings_angular_velocity_mode_HORIZONTAL = 3,
	ParticleSettings_angular_velocity_mode_VERTICAL = 4,
	ParticleSettings_angular_velocity_mode_GLOBAL_X = 5,
	ParticleSettings_angular_velocity_mode_GLOBAL_Y = 6,
	ParticleSettings_angular_velocity_mode_GLOBAL_Z = 7,
	ParticleSettings_angular_velocity_mode_RAND = 2,
};

int ParticleSettings_angular_velocity_mode_get(PointerRNA *ptr);
void ParticleSettings_angular_velocity_mode_set(PointerRNA *ptr, int value);

enum {
	ParticleSettings_billboard_animation_NONE = 0,
	ParticleSettings_billboard_animation_AGE = 1,
	ParticleSettings_billboard_animation_FRAME = 3,
	ParticleSettings_billboard_animation_ANGLE = 2,
};

int ParticleSettings_billboard_animation_get(PointerRNA *ptr);
void ParticleSettings_billboard_animation_set(PointerRNA *ptr, int value);

PointerRNA ParticleSettings_animation_data_get(PointerRNA *ptr);

int ParticleSettings_use_adaptive_subframes_get(PointerRNA *ptr);
void ParticleSettings_use_adaptive_subframes_set(PointerRNA *ptr, int value);

enum {
	ParticleSettings_kink_axis_X = 0,
	ParticleSettings_kink_axis_Y = 1,
	ParticleSettings_kink_axis_Z = 2,
};

int ParticleSettings_kink_axis_get(PointerRNA *ptr);
void ParticleSettings_kink_axis_set(PointerRNA *ptr, int value);

int ParticleSettings_use_hair_bspline_get(PointerRNA *ptr);
void ParticleSettings_use_hair_bspline_set(PointerRNA *ptr, int value);

PointerRNA ParticleSettings_billboard_object_get(PointerRNA *ptr);

void ParticleSettings_billboard_offset_get(PointerRNA *ptr, float values[2]);
void ParticleSettings_billboard_offset_set(PointerRNA *ptr, const float values[2]);

void ParticleSettings_billboard_size_get(PointerRNA *ptr, float values[2]);
void ParticleSettings_billboard_size_set(PointerRNA *ptr, const float values[2]);

float ParticleSettings_billboard_velocity_head_get(PointerRNA *ptr);
void ParticleSettings_billboard_velocity_head_set(PointerRNA *ptr, float value);

float ParticleSettings_billboard_velocity_tail_get(PointerRNA *ptr);
void ParticleSettings_billboard_velocity_tail_set(PointerRNA *ptr, float value);

PointerRNA ParticleSettings_boids_get(PointerRNA *ptr);

int ParticleSettings_lock_boids_to_surface_get(PointerRNA *ptr);
void ParticleSettings_lock_boids_to_surface_set(PointerRNA *ptr, int value);

float ParticleSettings_brownian_factor_get(PointerRNA *ptr);
void ParticleSettings_brownian_factor_set(PointerRNA *ptr, float value);

float ParticleSettings_child_radius_get(PointerRNA *ptr);
void ParticleSettings_child_radius_set(PointerRNA *ptr, float value);

float ParticleSettings_child_roundness_get(PointerRNA *ptr);
void ParticleSettings_child_roundness_set(PointerRNA *ptr, float value);

int ParticleSettings_use_simplify_get(PointerRNA *ptr);
void ParticleSettings_use_simplify_set(PointerRNA *ptr, int value);

float ParticleSettings_child_size_get(PointerRNA *ptr);
void ParticleSettings_child_size_set(PointerRNA *ptr, float value);

enum {
	ParticleSettings_child_type_NONE = 0,
	ParticleSettings_child_type_SIMPLE = 1,
	ParticleSettings_child_type_INTERPOLATED = 2,
};

int ParticleSettings_child_type_get(PointerRNA *ptr);
void ParticleSettings_child_type_set(PointerRNA *ptr, int value);

int ParticleSettings_child_nbr_get(PointerRNA *ptr);
void ParticleSettings_child_nbr_set(PointerRNA *ptr, int value);

float ParticleSettings_clump_factor_get(PointerRNA *ptr);
void ParticleSettings_clump_factor_set(PointerRNA *ptr, float value);

float ParticleSettings_color_maximum_get(PointerRNA *ptr);
void ParticleSettings_color_maximum_set(PointerRNA *ptr, float value);

float ParticleSettings_damping_get(PointerRNA *ptr);
void ParticleSettings_damping_set(PointerRNA *ptr, float value);

int ParticleSettings_adaptive_angle_get(PointerRNA *ptr);
void ParticleSettings_adaptive_angle_set(PointerRNA *ptr, int value);

int ParticleSettings_use_die_on_collision_get(PointerRNA *ptr);
void ParticleSettings_use_die_on_collision_set(PointerRNA *ptr, int value);

int ParticleSettings_use_dead_get(PointerRNA *ptr);
void ParticleSettings_use_dead_set(PointerRNA *ptr, int value);

int ParticleSettings_draw_percentage_get(PointerRNA *ptr);
void ParticleSettings_draw_percentage_set(PointerRNA *ptr, int value);

enum {
	ParticleSettings_distribution_JIT = 0,
	ParticleSettings_distribution_RAND = 1,
	ParticleSettings_distribution_GRID = 2,
};

int ParticleSettings_distribution_get(PointerRNA *ptr);
void ParticleSettings_distribution_set(PointerRNA *ptr, int value);

float ParticleSettings_drag_factor_get(PointerRNA *ptr);
void ParticleSettings_drag_factor_set(PointerRNA *ptr, float value);

enum {
	ParticleSettings_draw_color_NONE = 0,
	ParticleSettings_draw_color_MATERIAL = 1,
	ParticleSettings_draw_color_VELOCITY = 2,
	ParticleSettings_draw_color_ACCELERATION = 3,
};

int ParticleSettings_draw_color_get(PointerRNA *ptr);
void ParticleSettings_draw_color_set(PointerRNA *ptr, int value);

int ParticleSettings_draw_size_get(PointerRNA *ptr);
void ParticleSettings_draw_size_set(PointerRNA *ptr, int value);

PointerRNA ParticleSettings_dupli_group_get(PointerRNA *ptr);

void ParticleSettings_dupli_weights_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ParticleSettings_dupli_weights_next(CollectionPropertyIterator *iter);
void ParticleSettings_dupli_weights_end(CollectionPropertyIterator *iter);
int ParticleSettings_dupli_weights_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int ParticleSettings_dupli_weights_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA ParticleSettings_dupli_object_get(PointerRNA *ptr);

int ParticleSettings_use_dynamic_rotation_get(PointerRNA *ptr);
void ParticleSettings_use_dynamic_rotation_set(PointerRNA *ptr, int value);

int ParticleSettings_apply_effector_to_children_get(PointerRNA *ptr);
void ParticleSettings_apply_effector_to_children_set(PointerRNA *ptr, int value);

int ParticleSettings_effector_amount_get(PointerRNA *ptr);
void ParticleSettings_effector_amount_set(PointerRNA *ptr, int value);

PointerRNA ParticleSettings_effector_weights_get(PointerRNA *ptr);

enum {
	ParticleSettings_emit_from_VERT = 0,
	ParticleSettings_emit_from_FACE = 1,
	ParticleSettings_emit_from_VOLUME = 2,
};

int ParticleSettings_emit_from_get(PointerRNA *ptr);
void ParticleSettings_emit_from_set(PointerRNA *ptr, int value);

int ParticleSettings_use_render_emitter_get(PointerRNA *ptr);
void ParticleSettings_use_render_emitter_set(PointerRNA *ptr, int value);

float ParticleSettings_frame_end_get(PointerRNA *ptr);
void ParticleSettings_frame_end_set(PointerRNA *ptr, float value);

int ParticleSettings_use_even_distribution_get(PointerRNA *ptr);
void ParticleSettings_use_even_distribution_set(PointerRNA *ptr, int value);

float ParticleSettings_kink_flat_get(PointerRNA *ptr);
void ParticleSettings_kink_flat_set(PointerRNA *ptr, float value);

int ParticleSettings_is_fluid_get(PointerRNA *ptr);
void ParticleSettings_is_fluid_set(PointerRNA *ptr, int value);

PointerRNA ParticleSettings_force_field_1_get(PointerRNA *ptr);

PointerRNA ParticleSettings_force_field_2_get(PointerRNA *ptr);

float ParticleSettings_kink_frequency_get(PointerRNA *ptr);
void ParticleSettings_kink_frequency_set(PointerRNA *ptr, float value);

int ParticleSettings_use_global_dupli_get(PointerRNA *ptr);
void ParticleSettings_use_global_dupli_set(PointerRNA *ptr, int value);

float ParticleSettings_grid_random_get(PointerRNA *ptr);
void ParticleSettings_grid_random_set(PointerRNA *ptr, float value);

float ParticleSettings_hair_length_get(PointerRNA *ptr);
void ParticleSettings_hair_length_set(PointerRNA *ptr, float value);

float ParticleSettings_line_length_head_get(PointerRNA *ptr);
void ParticleSettings_line_length_head_set(PointerRNA *ptr, float value);

int ParticleSettings_show_health_get(PointerRNA *ptr);
void ParticleSettings_show_health_set(PointerRNA *ptr, int value);

int ParticleSettings_hexagonal_grid_get(PointerRNA *ptr);
void ParticleSettings_hexagonal_grid_set(PointerRNA *ptr, int value);

enum {
	ParticleSettings_integrator_EULER = 0,
	ParticleSettings_integrator_VERLET = 3,
	ParticleSettings_integrator_MIDPOINT = 1,
	ParticleSettings_integrator_RK4 = 2,
};

int ParticleSettings_integrator_get(PointerRNA *ptr);
void ParticleSettings_integrator_set(PointerRNA *ptr, int value);

int ParticleSettings_invert_grid_get(PointerRNA *ptr);
void ParticleSettings_invert_grid_set(PointerRNA *ptr, int value);

int ParticleSettings_keys_step_get(PointerRNA *ptr);
void ParticleSettings_keys_step_set(PointerRNA *ptr, int value);

enum {
	ParticleSettings_kink_NO = 0,
	ParticleSettings_kink_CURL = 1,
	ParticleSettings_kink_RADIAL = 2,
	ParticleSettings_kink_WAVE = 3,
	ParticleSettings_kink_BRAID = 4,
};

int ParticleSettings_kink_get(PointerRNA *ptr);
void ParticleSettings_kink_set(PointerRNA *ptr, int value);

float ParticleSettings_child_length_get(PointerRNA *ptr);
void ParticleSettings_child_length_set(PointerRNA *ptr, float value);

float ParticleSettings_lifetime_get(PointerRNA *ptr);
void ParticleSettings_lifetime_set(PointerRNA *ptr, float value);

int ParticleSettings_lock_billboard_get(PointerRNA *ptr);
void ParticleSettings_lock_billboard_set(PointerRNA *ptr, int value);

int ParticleSettings_create_long_hair_children_get(PointerRNA *ptr);
void ParticleSettings_create_long_hair_children_set(PointerRNA *ptr, int value);

int ParticleSettings_keyed_loops_get(PointerRNA *ptr);
void ParticleSettings_keyed_loops_set(PointerRNA *ptr, int value);

float ParticleSettings_mass_get(PointerRNA *ptr);
void ParticleSettings_mass_set(PointerRNA *ptr, float value);

int ParticleSettings_use_multiply_size_mass_get(PointerRNA *ptr);
void ParticleSettings_use_multiply_size_mass_set(PointerRNA *ptr, int value);

int ParticleSettings_material_get(PointerRNA *ptr);
void ParticleSettings_material_set(PointerRNA *ptr, int value);

enum {
	ParticleSettings_material_slot_DUMMY = 0,
};

int ParticleSettings_material_slot_get(PointerRNA *ptr);
void ParticleSettings_material_slot_set(PointerRNA *ptr, int value);

int ParticleSettings_use_react_multiple_get(PointerRNA *ptr);
void ParticleSettings_use_react_multiple_set(PointerRNA *ptr, int value);

float ParticleSettings_normal_factor_get(PointerRNA *ptr);
void ParticleSettings_normal_factor_set(PointerRNA *ptr, float value);

int ParticleSettings_show_number_get(PointerRNA *ptr);
void ParticleSettings_show_number_set(PointerRNA *ptr, int value);

int ParticleSettings_count_get(PointerRNA *ptr);
void ParticleSettings_count_set(PointerRNA *ptr, int value);

float ParticleSettings_object_factor_get(PointerRNA *ptr);
void ParticleSettings_object_factor_set(PointerRNA *ptr, float value);

void ParticleSettings_object_align_factor_get(PointerRNA *ptr, float values[3]);
void ParticleSettings_object_align_factor_set(PointerRNA *ptr, const float values[3]);

enum {
	ParticleSettings_billboard_offset_split_NONE = 0,
	ParticleSettings_billboard_offset_split_LINEAR = 1,
	ParticleSettings_billboard_offset_split_RANDOM = 2,
};

int ParticleSettings_billboard_offset_split_get(PointerRNA *ptr);
void ParticleSettings_billboard_offset_split_set(PointerRNA *ptr, int value);

enum {
	ParticleSettings_rotation_mode_NONE = 0,
	ParticleSettings_rotation_mode_NOR = 1,
	ParticleSettings_rotation_mode_NOR_TAN = 9,
	ParticleSettings_rotation_mode_VEL = 2,
	ParticleSettings_rotation_mode_GLOB_X = 3,
	ParticleSettings_rotation_mode_GLOB_Y = 4,
	ParticleSettings_rotation_mode_GLOB_Z = 5,
	ParticleSettings_rotation_mode_OB_X = 6,
	ParticleSettings_rotation_mode_OB_Y = 7,
	ParticleSettings_rotation_mode_OB_Z = 8,
};

int ParticleSettings_rotation_mode_get(PointerRNA *ptr);
void ParticleSettings_rotation_mode_set(PointerRNA *ptr, int value);

int ParticleSettings_userjit_get(PointerRNA *ptr);
void ParticleSettings_userjit_set(PointerRNA *ptr, int value);

int ParticleSettings_use_parent_particles_get(PointerRNA *ptr);
void ParticleSettings_use_parent_particles_set(PointerRNA *ptr, int value);

float ParticleSettings_particle_factor_get(PointerRNA *ptr);
void ParticleSettings_particle_factor_set(PointerRNA *ptr, float value);

enum {
	ParticleSettings_draw_method_NONE = 0,
	ParticleSettings_draw_method_RENDER = 10,
	ParticleSettings_draw_method_DOT = 1,
	ParticleSettings_draw_method_CIRC = 2,
	ParticleSettings_draw_method_CROSS = 3,
	ParticleSettings_draw_method_AXIS = 4,
};

int ParticleSettings_draw_method_get(PointerRNA *ptr);
void ParticleSettings_draw_method_set(PointerRNA *ptr, int value);

enum {
	ParticleSettings_render_type_NONE = 0,
	ParticleSettings_render_type_HALO = 1,
	ParticleSettings_render_type_LINE = 5,
	ParticleSettings_render_type_PATH = 6,
	ParticleSettings_render_type_OBJECT = 7,
	ParticleSettings_render_type_GROUP = 8,
	ParticleSettings_render_type_BILLBOARD = 9,
};

int ParticleSettings_render_type_get(PointerRNA *ptr);
void ParticleSettings_render_type_set(PointerRNA *ptr, int value);

float ParticleSettings_child_parting_factor_get(PointerRNA *ptr);
void ParticleSettings_child_parting_factor_set(PointerRNA *ptr, float value);

float ParticleSettings_child_parting_max_get(PointerRNA *ptr);
void ParticleSettings_child_parting_max_set(PointerRNA *ptr, float value);

float ParticleSettings_child_parting_min_get(PointerRNA *ptr);
void ParticleSettings_child_parting_min_set(PointerRNA *ptr, float value);

float ParticleSettings_path_end_get(PointerRNA *ptr);
void ParticleSettings_path_end_set(PointerRNA *ptr, float value);

float ParticleSettings_path_start_get(PointerRNA *ptr);
void ParticleSettings_path_start_set(PointerRNA *ptr, float value);

float ParticleSettings_phase_factor_get(PointerRNA *ptr);
void ParticleSettings_phase_factor_set(PointerRNA *ptr, float value);

enum {
	ParticleSettings_physics_type_NO = 0,
	ParticleSettings_physics_type_NEWTON = 1,
	ParticleSettings_physics_type_KEYED = 2,
	ParticleSettings_physics_type_BOIDS = 3,
	ParticleSettings_physics_type_FLUID = 4,
};

int ParticleSettings_physics_type_get(PointerRNA *ptr);
void ParticleSettings_physics_type_set(PointerRNA *ptr, int value);

int ParticleSettings_use_group_pick_random_get(PointerRNA *ptr);
void ParticleSettings_use_group_pick_random_set(PointerRNA *ptr, int value);

int ParticleSettings_adaptive_pixel_get(PointerRNA *ptr);
void ParticleSettings_adaptive_pixel_set(PointerRNA *ptr, int value);

int ParticleSettings_use_emit_random_get(PointerRNA *ptr);
void ParticleSettings_use_emit_random_set(PointerRNA *ptr, int value);

float ParticleSettings_lifetime_random_get(PointerRNA *ptr);
void ParticleSettings_lifetime_random_set(PointerRNA *ptr, float value);

float ParticleSettings_factor_random_get(PointerRNA *ptr);
void ParticleSettings_factor_random_set(PointerRNA *ptr, float value);

float ParticleSettings_child_size_random_get(PointerRNA *ptr);
void ParticleSettings_child_size_random_set(PointerRNA *ptr, float value);

float ParticleSettings_length_random_get(PointerRNA *ptr);
void ParticleSettings_length_random_set(PointerRNA *ptr, float value);

float ParticleSettings_rotation_factor_random_get(PointerRNA *ptr);
void ParticleSettings_rotation_factor_random_set(PointerRNA *ptr, float value);

float ParticleSettings_phase_factor_random_get(PointerRNA *ptr);
void ParticleSettings_phase_factor_random_set(PointerRNA *ptr, float value);

float ParticleSettings_size_random_get(PointerRNA *ptr);
void ParticleSettings_size_random_set(PointerRNA *ptr, float value);

float ParticleSettings_billboard_tilt_random_get(PointerRNA *ptr);
void ParticleSettings_billboard_tilt_random_set(PointerRNA *ptr, float value);

float ParticleSettings_simplify_rate_get(PointerRNA *ptr);
void ParticleSettings_simplify_rate_set(PointerRNA *ptr, float value);

float ParticleSettings_simplify_viewport_get(PointerRNA *ptr);
void ParticleSettings_simplify_viewport_set(PointerRNA *ptr, float value);

enum {
	ParticleSettings_react_event_DEATH = 0,
	ParticleSettings_react_event_COLLIDE = 1,
	ParticleSettings_react_event_NEAR = 2,
};

int ParticleSettings_react_event_get(PointerRNA *ptr);
void ParticleSettings_react_event_set(PointerRNA *ptr, int value);

float ParticleSettings_reactor_factor_get(PointerRNA *ptr);
void ParticleSettings_reactor_factor_set(PointerRNA *ptr, float value);

int ParticleSettings_simplify_refsize_get(PointerRNA *ptr);
void ParticleSettings_simplify_refsize_set(PointerRNA *ptr, int value);

int ParticleSettings_regrow_hair_get(PointerRNA *ptr);
void ParticleSettings_regrow_hair_set(PointerRNA *ptr, int value);

int ParticleSettings_render_step_get(PointerRNA *ptr);
void ParticleSettings_render_step_set(PointerRNA *ptr, int value);

int ParticleSettings_rendered_child_count_get(PointerRNA *ptr);
void ParticleSettings_rendered_child_count_set(PointerRNA *ptr, int value);

int ParticleSettings_grid_resolution_get(PointerRNA *ptr);
void ParticleSettings_grid_resolution_set(PointerRNA *ptr, int value);

float ParticleSettings_tangent_phase_get(PointerRNA *ptr);
void ParticleSettings_tangent_phase_set(PointerRNA *ptr, float value);

int ParticleSettings_use_rotation_dupli_get(PointerRNA *ptr);
void ParticleSettings_use_rotation_dupli_set(PointerRNA *ptr, int value);

int ParticleSettings_use_rotations_get(PointerRNA *ptr);
void ParticleSettings_use_rotations_set(PointerRNA *ptr, int value);

float ParticleSettings_roughness_endpoint_get(PointerRNA *ptr);
void ParticleSettings_roughness_endpoint_set(PointerRNA *ptr, float value);

float ParticleSettings_roughness_1_get(PointerRNA *ptr);
void ParticleSettings_roughness_1_set(PointerRNA *ptr, float value);

float ParticleSettings_roughness_2_get(PointerRNA *ptr);
void ParticleSettings_roughness_2_set(PointerRNA *ptr, float value);

PointerRNA ParticleSettings_fluid_get(PointerRNA *ptr);

int ParticleSettings_use_scale_dupli_get(PointerRNA *ptr);
void ParticleSettings_use_scale_dupli_set(PointerRNA *ptr, int value);

int ParticleSettings_hair_step_get(PointerRNA *ptr);
void ParticleSettings_hair_step_set(PointerRNA *ptr, int value);

int ParticleSettings_use_self_effect_get(PointerRNA *ptr);
void ParticleSettings_use_self_effect_set(PointerRNA *ptr, int value);

float ParticleSettings_clump_shape_get(PointerRNA *ptr);
void ParticleSettings_clump_shape_set(PointerRNA *ptr, float value);

float ParticleSettings_kink_shape_get(PointerRNA *ptr);
void ParticleSettings_kink_shape_set(PointerRNA *ptr, float value);

float ParticleSettings_roughness_end_shape_get(PointerRNA *ptr);
void ParticleSettings_roughness_end_shape_set(PointerRNA *ptr, float value);

int ParticleSettings_show_size_get(PointerRNA *ptr);
void ParticleSettings_show_size_set(PointerRNA *ptr, int value);

float ParticleSettings_particle_size_get(PointerRNA *ptr);
void ParticleSettings_particle_size_set(PointerRNA *ptr, float value);

int ParticleSettings_use_size_deflect_get(PointerRNA *ptr);
void ParticleSettings_use_size_deflect_set(PointerRNA *ptr, int value);

float ParticleSettings_roughness_1_size_get(PointerRNA *ptr);
void ParticleSettings_roughness_1_size_set(PointerRNA *ptr, float value);

float ParticleSettings_roughness_2_size_get(PointerRNA *ptr);
void ParticleSettings_roughness_2_size_set(PointerRNA *ptr, float value);

int ParticleSettings_use_velocity_length_get(PointerRNA *ptr);
void ParticleSettings_use_velocity_length_set(PointerRNA *ptr, int value);

float ParticleSettings_frame_start_get(PointerRNA *ptr);
void ParticleSettings_frame_start_set(PointerRNA *ptr, float value);

int ParticleSettings_use_react_start_end_get(PointerRNA *ptr);
void ParticleSettings_use_react_start_end_set(PointerRNA *ptr, int value);

int ParticleSettings_draw_step_get(PointerRNA *ptr);
void ParticleSettings_draw_step_set(PointerRNA *ptr, int value);

float ParticleSettings_effect_hair_get(PointerRNA *ptr);
void ParticleSettings_effect_hair_set(PointerRNA *ptr, float value);

int ParticleSettings_use_strand_primitive_get(PointerRNA *ptr);
void ParticleSettings_use_strand_primitive_set(PointerRNA *ptr, int value);

int ParticleSettings_subframes_get(PointerRNA *ptr);
void ParticleSettings_subframes_set(PointerRNA *ptr, int value);

float ParticleSettings_line_length_tail_get(PointerRNA *ptr);
void ParticleSettings_line_length_tail_set(PointerRNA *ptr, float value);

float ParticleSettings_tangent_factor_get(PointerRNA *ptr);
void ParticleSettings_tangent_factor_set(PointerRNA *ptr, float value);

void ParticleSettings_texture_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ParticleSettings_texture_slots_next(CollectionPropertyIterator *iter);
void ParticleSettings_texture_slots_end(CollectionPropertyIterator *iter);

float ParticleSettings_roughness_2_threshold_get(PointerRNA *ptr);
void ParticleSettings_roughness_2_threshold_set(PointerRNA *ptr, float value);

float ParticleSettings_child_length_threshold_get(PointerRNA *ptr);
void ParticleSettings_child_length_threshold_set(PointerRNA *ptr, float value);

float ParticleSettings_branch_threshold_get(PointerRNA *ptr);
void ParticleSettings_branch_threshold_set(PointerRNA *ptr, float value);

float ParticleSettings_billboard_tilt_get(PointerRNA *ptr);
void ParticleSettings_billboard_tilt_set(PointerRNA *ptr, float value);

float ParticleSettings_timestep_get(PointerRNA *ptr);
void ParticleSettings_timestep_set(PointerRNA *ptr, float value);

int ParticleSettings_trail_count_get(PointerRNA *ptr);
void ParticleSettings_trail_count_set(PointerRNA *ptr, int value);

float ParticleSettings_simplify_transition_get(PointerRNA *ptr);
void ParticleSettings_simplify_transition_set(PointerRNA *ptr, float value);

float ParticleSettings_time_tweak_get(PointerRNA *ptr);
void ParticleSettings_time_tweak_set(PointerRNA *ptr, float value);

enum {
	ParticleSettings_type_EMITTER = 0,
	ParticleSettings_type_HAIR = 2,
};

int ParticleSettings_type_get(PointerRNA *ptr);
void ParticleSettings_type_set(PointerRNA *ptr, int value);

int ParticleSettings_billboard_uv_split_get(PointerRNA *ptr);
void ParticleSettings_billboard_uv_split_set(PointerRNA *ptr, int value);

int ParticleSettings_show_unborn_get(PointerRNA *ptr);
void ParticleSettings_show_unborn_set(PointerRNA *ptr, int value);

int ParticleSettings_use_group_count_get(PointerRNA *ptr);
void ParticleSettings_use_group_count_set(PointerRNA *ptr, int value);

int ParticleSettings_use_modifier_stack_get(PointerRNA *ptr);
void ParticleSettings_use_modifier_stack_set(PointerRNA *ptr, int value);

int ParticleSettings_show_velocity_get(PointerRNA *ptr);
void ParticleSettings_show_velocity_set(PointerRNA *ptr, int value);

int ParticleSettings_use_simplify_viewport_get(PointerRNA *ptr);
void ParticleSettings_use_simplify_viewport_set(PointerRNA *ptr, int value);

float ParticleSettings_virtual_parents_get(PointerRNA *ptr);
void ParticleSettings_virtual_parents_set(PointerRNA *ptr, float value);

int ParticleSettings_use_whole_group_get(PointerRNA *ptr);
void ParticleSettings_use_whole_group_set(PointerRNA *ptr, int value);

int ParticleSettings_apply_guide_to_children_get(PointerRNA *ptr);
void ParticleSettings_apply_guide_to_children_set(PointerRNA *ptr, int value);

/**************** Particle Settings Texture Slot ****************/

extern StructRNA RNA_ParticleSettingsTextureSlot;
extern StructRNA RNA_TextureSlot;

int ParticleSettingsTextureSlot_use_map_clump_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_clump_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_clump_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_clump_factor_set(PointerRNA *ptr, float value);

int ParticleSettingsTextureSlot_use_map_damp_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_damp_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_damp_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_damp_factor_set(PointerRNA *ptr, float value);

int ParticleSettingsTextureSlot_use_map_density_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_density_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_density_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_density_factor_set(PointerRNA *ptr, float value);

int ParticleSettingsTextureSlot_use_map_time_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_time_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_time_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_time_factor_set(PointerRNA *ptr, float value);

float ParticleSettingsTextureSlot_field_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_field_factor_set(PointerRNA *ptr, float value);

int ParticleSettingsTextureSlot_use_map_field_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_field_set(PointerRNA *ptr, int value);

int ParticleSettingsTextureSlot_use_map_gravity_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_gravity_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_gravity_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_gravity_factor_set(PointerRNA *ptr, float value);

int ParticleSettingsTextureSlot_use_map_velocity_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_velocity_set(PointerRNA *ptr, int value);

int ParticleSettingsTextureSlot_use_map_kink_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_kink_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_kink_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_kink_factor_set(PointerRNA *ptr, float value);

int ParticleSettingsTextureSlot_use_map_length_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_length_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_length_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_length_factor_set(PointerRNA *ptr, float value);

int ParticleSettingsTextureSlot_use_map_life_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_life_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_life_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_life_factor_set(PointerRNA *ptr, float value);

enum {
	ParticleSettingsTextureSlot_mapping_FLAT = 0,
	ParticleSettingsTextureSlot_mapping_CUBE = 1,
	ParticleSettingsTextureSlot_mapping_TUBE = 2,
	ParticleSettingsTextureSlot_mapping_SPHERE = 3,
};

int ParticleSettingsTextureSlot_mapping_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_mapping_set(PointerRNA *ptr, int value);

PointerRNA ParticleSettingsTextureSlot_object_get(PointerRNA *ptr);

int ParticleSettingsTextureSlot_use_map_rough_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_rough_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_rough_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_rough_factor_set(PointerRNA *ptr, float value);

int ParticleSettingsTextureSlot_use_map_size_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_use_map_size_set(PointerRNA *ptr, int value);

float ParticleSettingsTextureSlot_size_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_size_factor_set(PointerRNA *ptr, float value);

enum {
	ParticleSettingsTextureSlot_texture_coords_GLOBAL = 8,
	ParticleSettingsTextureSlot_texture_coords_OBJECT = 32,
	ParticleSettingsTextureSlot_texture_coords_UV = 16,
	ParticleSettingsTextureSlot_texture_coords_ORCO = 1,
	ParticleSettingsTextureSlot_texture_coords_STRAND = 8192,
};

int ParticleSettingsTextureSlot_texture_coords_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_texture_coords_set(PointerRNA *ptr, int value);

#define ParticleSettingsTextureSlot_uv_layer_MAX 64

void ParticleSettingsTextureSlot_uv_layer_get(PointerRNA *ptr, char *value);
int ParticleSettingsTextureSlot_uv_layer_length(PointerRNA *ptr);
void ParticleSettingsTextureSlot_uv_layer_set(PointerRNA *ptr, const char *value);

float ParticleSettingsTextureSlot_velocity_factor_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_velocity_factor_set(PointerRNA *ptr, float value);

enum {
	ParticleSettingsTextureSlot_mapping_x_NONE = 0,
	ParticleSettingsTextureSlot_mapping_x_X = 1,
	ParticleSettingsTextureSlot_mapping_x_Y = 2,
	ParticleSettingsTextureSlot_mapping_x_Z = 3,
};

int ParticleSettingsTextureSlot_mapping_x_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_mapping_x_set(PointerRNA *ptr, int value);

enum {
	ParticleSettingsTextureSlot_mapping_y_NONE = 0,
	ParticleSettingsTextureSlot_mapping_y_X = 1,
	ParticleSettingsTextureSlot_mapping_y_Y = 2,
	ParticleSettingsTextureSlot_mapping_y_Z = 3,
};

int ParticleSettingsTextureSlot_mapping_y_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_mapping_y_set(PointerRNA *ptr, int value);

enum {
	ParticleSettingsTextureSlot_mapping_z_NONE = 0,
	ParticleSettingsTextureSlot_mapping_z_X = 1,
	ParticleSettingsTextureSlot_mapping_z_Y = 2,
	ParticleSettingsTextureSlot_mapping_z_Z = 3,
};

int ParticleSettingsTextureSlot_mapping_z_get(PointerRNA *ptr);
void ParticleSettingsTextureSlot_mapping_z_set(PointerRNA *ptr, int value);

/**************** Texture Slots ****************/

extern StructRNA RNA_ParticleSettingsTextureSlots;

PointerRNA ParticleSettingsTextureSlots_rna_type_get(PointerRNA *ptr);

struct MTex *ParticleSettingsTextureSlots_add(struct ID *_selfid, bContext *C, ReportList *reports);
struct MTex *ParticleSettingsTextureSlots_create(struct ID *_selfid, bContext *C, ReportList *reports, int index);
void ParticleSettingsTextureSlots_clear(struct ID *_selfid, bContext *C, ReportList *reports, int index);
/**************** Particle System ****************/

extern StructRNA RNA_ParticleSystem;

PointerRNA ParticleSystem_rna_type_get(PointerRNA *ptr);

#define ParticleSystem_name_MAX 64

void ParticleSystem_name_get(PointerRNA *ptr, char *value);
int ParticleSystem_name_length(PointerRNA *ptr);
void ParticleSystem_name_set(PointerRNA *ptr, const char *value);

PointerRNA ParticleSystem_active_particle_target_get(PointerRNA *ptr);

int ParticleSystem_active_particle_target_index_get(PointerRNA *ptr);
void ParticleSystem_active_particle_target_index_set(PointerRNA *ptr, int value);

#define ParticleSystem_billboard_normal_uv_MAX 32

void ParticleSystem_billboard_normal_uv_get(PointerRNA *ptr, char *value);
int ParticleSystem_billboard_normal_uv_length(PointerRNA *ptr);
void ParticleSystem_billboard_normal_uv_set(PointerRNA *ptr, const char *value);

#define ParticleSystem_billboard_split_uv_MAX 32

void ParticleSystem_billboard_split_uv_get(PointerRNA *ptr, char *value);
int ParticleSystem_billboard_split_uv_length(PointerRNA *ptr);
void ParticleSystem_billboard_split_uv_set(PointerRNA *ptr, const char *value);

#define ParticleSystem_billboard_time_index_uv_MAX 32

void ParticleSystem_billboard_time_index_uv_get(PointerRNA *ptr, char *value);
int ParticleSystem_billboard_time_index_uv_length(PointerRNA *ptr);
void ParticleSystem_billboard_time_index_uv_set(PointerRNA *ptr, const char *value);

void ParticleSystem_child_particles_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ParticleSystem_child_particles_next(CollectionPropertyIterator *iter);
void ParticleSystem_child_particles_end(CollectionPropertyIterator *iter);
int ParticleSystem_child_particles_length(PointerRNA *ptr);
int ParticleSystem_child_particles_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int ParticleSystem_child_seed_get(PointerRNA *ptr);
void ParticleSystem_child_seed_set(PointerRNA *ptr, int value);

PointerRNA ParticleSystem_cloth_get(PointerRNA *ptr);

int ParticleSystem_is_editable_get(PointerRNA *ptr);
void ParticleSystem_is_editable_set(PointerRNA *ptr, int value);

int ParticleSystem_is_edited_get(PointerRNA *ptr);
void ParticleSystem_is_edited_set(PointerRNA *ptr, int value);

int ParticleSystem_is_global_hair_get(PointerRNA *ptr);
void ParticleSystem_is_global_hair_set(PointerRNA *ptr, int value);

int ParticleSystem_use_hair_dynamics_get(PointerRNA *ptr);
void ParticleSystem_use_hair_dynamics_set(PointerRNA *ptr, int value);

int ParticleSystem_use_keyed_timing_get(PointerRNA *ptr);
void ParticleSystem_use_keyed_timing_set(PointerRNA *ptr, int value);

int ParticleSystem_has_multiple_caches_get(PointerRNA *ptr);
void ParticleSystem_has_multiple_caches_set(PointerRNA *ptr, int value);

PointerRNA ParticleSystem_parent_get(PointerRNA *ptr);

void ParticleSystem_particles_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ParticleSystem_particles_next(CollectionPropertyIterator *iter);
void ParticleSystem_particles_end(CollectionPropertyIterator *iter);
int ParticleSystem_particles_length(PointerRNA *ptr);
int ParticleSystem_particles_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

PointerRNA ParticleSystem_point_cache_get(PointerRNA *ptr);

PointerRNA ParticleSystem_reactor_target_object_get(PointerRNA *ptr);

int ParticleSystem_reactor_target_particle_system_get(PointerRNA *ptr);
void ParticleSystem_reactor_target_particle_system_set(PointerRNA *ptr, int value);

int ParticleSystem_seed_get(PointerRNA *ptr);
void ParticleSystem_seed_set(PointerRNA *ptr, int value);

PointerRNA ParticleSystem_settings_get(PointerRNA *ptr);

void ParticleSystem_targets_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ParticleSystem_targets_next(CollectionPropertyIterator *iter);
void ParticleSystem_targets_end(CollectionPropertyIterator *iter);
int ParticleSystem_targets_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int ParticleSystem_targets_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float ParticleSystem_dt_frac_get(PointerRNA *ptr);
void ParticleSystem_dt_frac_set(PointerRNA *ptr, float value);

void ParticleSystem_vertex_group_clump_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_clump_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_clump_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_clump_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_clump_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_density_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_density_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_density_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_density_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_density_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_field_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_field_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_field_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_field_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_field_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_kink_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_kink_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_kink_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_kink_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_kink_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_length_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_length_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_length_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_length_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_length_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_rotation_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_rotation_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_rotation_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_rotation_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_rotation_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_roughness_1_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_roughness_1_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_roughness_1_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_roughness_1_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_roughness_1_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_roughness_2_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_roughness_2_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_roughness_2_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_roughness_2_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_roughness_2_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_roughness_end_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_roughness_end_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_roughness_end_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_roughness_end_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_roughness_end_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_size_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_size_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_size_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_size_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_size_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_tangent_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_tangent_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_tangent_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_tangent_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_tangent_set(PointerRNA *ptr, int value);

void ParticleSystem_vertex_group_velocity_get(PointerRNA *ptr, char *value);
int ParticleSystem_vertex_group_velocity_length(PointerRNA *ptr);
void ParticleSystem_vertex_group_velocity_set(PointerRNA *ptr, const char *value);

int ParticleSystem_invert_vertex_group_velocity_get(PointerRNA *ptr);
void ParticleSystem_invert_vertex_group_velocity_set(PointerRNA *ptr, int value);

void ParticleSystem_set_resolution(struct ParticleSystem *_self, struct Scene *scene, struct Object *object, int resolution);
void ParticleSystem_co_hair(struct ParticleSystem *_self, struct Object *object, int particle_no, int step, float co[3]);
void ParticleSystem_uv_on_emitter(struct ParticleSystem *_self, ReportList *reports, struct ParticleSystemModifierData *modifier, struct ParticleData *particle, int particle_no, int uv_no, float uv[2]);
void ParticleSystem_mcol_on_emitter(struct ParticleSystem *_self, ReportList *reports, struct ParticleSystemModifierData *modifier, struct ParticleData *particle, int particle_no, int vcol_no, float mcol[3]);
/**************** ParticleSystem Modifier ****************/

extern StructRNA RNA_ParticleSystemModifier;
extern StructRNA RNA_Modifier;

PointerRNA ParticleSystemModifier_particle_system_get(PointerRNA *ptr);

/**************** Particle Systems ****************/

extern StructRNA RNA_ParticleSystems;

PointerRNA ParticleSystems_rna_type_get(PointerRNA *ptr);

PointerRNA ParticleSystems_active_get(PointerRNA *ptr);

int ParticleSystems_active_index_get(PointerRNA *ptr);
void ParticleSystems_active_index_set(PointerRNA *ptr, int value);

/**************** Particle Target ****************/

extern StructRNA RNA_ParticleTarget;

PointerRNA ParticleTarget_rna_type_get(PointerRNA *ptr);

void ParticleTarget_name_get(PointerRNA *ptr, char *value);
int ParticleTarget_name_length(PointerRNA *ptr);
void ParticleTarget_name_set(PointerRNA *ptr, const char *value);

float ParticleTarget_duration_get(PointerRNA *ptr);
void ParticleTarget_duration_set(PointerRNA *ptr, float value);

enum {
	ParticleTarget_alliance_FRIEND = 1,
	ParticleTarget_alliance_NEUTRAL = 0,
	ParticleTarget_alliance_ENEMY = 2,
};

int ParticleTarget_alliance_get(PointerRNA *ptr);
void ParticleTarget_alliance_set(PointerRNA *ptr, int value);

PointerRNA ParticleTarget_object_get(PointerRNA *ptr);

int ParticleTarget_system_get(PointerRNA *ptr);
void ParticleTarget_system_set(PointerRNA *ptr, int value);

float ParticleTarget_time_get(PointerRNA *ptr);
void ParticleTarget_time_set(PointerRNA *ptr, float value);

int ParticleTarget_is_valid_get(PointerRNA *ptr);
void ParticleTarget_is_valid_set(PointerRNA *ptr, int value);

/**************** Path Compare ****************/

extern StructRNA RNA_PathCompare;

PointerRNA PathCompare_rna_type_get(PointerRNA *ptr);

#define PathCompare_path_MAX 768

void PathCompare_path_get(PointerRNA *ptr, char *value);
int PathCompare_path_length(PointerRNA *ptr);
void PathCompare_path_set(PointerRNA *ptr, const char *value);

int PathCompare_use_glob_get(PointerRNA *ptr);
void PathCompare_use_glob_set(PointerRNA *ptr, int value);

/**************** Paths Compare ****************/

extern StructRNA RNA_PathCompareCollection;

PointerRNA PathCompareCollection_rna_type_get(PointerRNA *ptr);

struct bPathCompare *PathCompareCollection_new(void);
void PathCompareCollection_remove(ReportList *reports, struct PointerRNA *pathcmp);
/**************** Pivot Constraint ****************/

extern StructRNA RNA_PivotConstraint;
extern StructRNA RNA_Constraint;

enum {
	PivotConstraint_rotation_range_ALWAYS_ACTIVE = -1,
	PivotConstraint_rotation_range_NX = 0,
	PivotConstraint_rotation_range_NY = 1,
	PivotConstraint_rotation_range_NZ = 2,
	PivotConstraint_rotation_range_X = 3,
	PivotConstraint_rotation_range_Y = 4,
	PivotConstraint_rotation_range_Z = 5,
};

int PivotConstraint_rotation_range_get(PointerRNA *ptr);
void PivotConstraint_rotation_range_set(PointerRNA *ptr, int value);

float PivotConstraint_head_tail_get(PointerRNA *ptr);
void PivotConstraint_head_tail_set(PointerRNA *ptr, float value);

void PivotConstraint_offset_get(PointerRNA *ptr, float values[3]);
void PivotConstraint_offset_set(PointerRNA *ptr, const float values[3]);

#define PivotConstraint_subtarget_MAX 64

void PivotConstraint_subtarget_get(PointerRNA *ptr, char *value);
int PivotConstraint_subtarget_length(PointerRNA *ptr);
void PivotConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA PivotConstraint_target_get(PointerRNA *ptr);

int PivotConstraint_use_relative_location_get(PointerRNA *ptr);
void PivotConstraint_use_relative_location_set(PointerRNA *ptr, int value);

/**************** Point Cache ****************/

extern StructRNA RNA_PointCache;

PointerRNA PointCache_rna_type_get(PointerRNA *ptr);

#define PointCache_name_MAX 64

void PointCache_name_get(PointerRNA *ptr, char *value);
int PointCache_name_length(PointerRNA *ptr);
void PointCache_name_set(PointerRNA *ptr, const char *value);

enum {
	PointCache_compression_NO = 0,
	PointCache_compression_LIGHT = 1,
	PointCache_compression_HEAVY = 2,
};

int PointCache_compression_get(PointerRNA *ptr);
void PointCache_compression_set(PointerRNA *ptr, int value);

int PointCache_index_get(PointerRNA *ptr);
void PointCache_index_set(PointerRNA *ptr, int value);

#define PointCache_info_MAX 64

void PointCache_info_get(PointerRNA *ptr, char *value);
int PointCache_info_length(PointerRNA *ptr);
void PointCache_info_set(PointerRNA *ptr, const char *value);

int PointCache_frame_step_get(PointerRNA *ptr);
void PointCache_frame_step_set(PointerRNA *ptr, int value);

int PointCache_is_outdated_get(PointerRNA *ptr);
void PointCache_is_outdated_set(PointerRNA *ptr, int value);

int PointCache_use_disk_cache_get(PointerRNA *ptr);
void PointCache_use_disk_cache_set(PointerRNA *ptr, int value);

int PointCache_frame_end_get(PointerRNA *ptr);
void PointCache_frame_end_set(PointerRNA *ptr, int value);

int PointCache_use_external_get(PointerRNA *ptr);
void PointCache_use_external_set(PointerRNA *ptr, int value);

#define PointCache_filepath_MAX 1024

void PointCache_filepath_get(PointerRNA *ptr, char *value);
int PointCache_filepath_length(PointerRNA *ptr);
void PointCache_filepath_set(PointerRNA *ptr, const char *value);

int PointCache_use_library_path_get(PointerRNA *ptr);
void PointCache_use_library_path_set(PointerRNA *ptr, int value);

void PointCache_point_caches_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void PointCache_point_caches_next(CollectionPropertyIterator *iter);
void PointCache_point_caches_end(CollectionPropertyIterator *iter);

int PointCache_frame_start_get(PointerRNA *ptr);
void PointCache_frame_start_set(PointerRNA *ptr, int value);

int PointCache_frames_skipped_get(PointerRNA *ptr);
void PointCache_frames_skipped_set(PointerRNA *ptr, int value);

int PointCache_is_baked_get(PointerRNA *ptr);
void PointCache_is_baked_set(PointerRNA *ptr, int value);

int PointCache_is_baking_get(PointerRNA *ptr);
void PointCache_is_baking_set(PointerRNA *ptr, int value);

/**************** Point Caches ****************/

extern StructRNA RNA_PointCaches;

PointerRNA PointCaches_rna_type_get(PointerRNA *ptr);

int PointCaches_active_index_get(PointerRNA *ptr);
void PointCaches_active_index_set(PointerRNA *ptr, int value);

/**************** PointDensity ****************/

extern StructRNA RNA_PointDensity;

PointerRNA PointDensity_rna_type_get(PointerRNA *ptr);

PointerRNA PointDensity_color_ramp_get(PointerRNA *ptr);

enum {
	PointDensity_color_source_CONSTANT = 0,
	PointDensity_color_source_PARTICLE_AGE = 1,
	PointDensity_color_source_PARTICLE_SPEED = 2,
	PointDensity_color_source_PARTICLE_VELOCITY = 3,
};

int PointDensity_color_source_get(PointerRNA *ptr);
void PointDensity_color_source_set(PointerRNA *ptr, int value);

int PointDensity_turbulence_depth_get(PointerRNA *ptr);
void PointDensity_turbulence_depth_set(PointerRNA *ptr, int value);

enum {
	PointDensity_falloff_STANDARD = 0,
	PointDensity_falloff_SMOOTH = 1,
	PointDensity_falloff_SOFT = 2,
	PointDensity_falloff_CONSTANT = 3,
	PointDensity_falloff_ROOT = 4,
	PointDensity_falloff_PARTICLE_AGE = 5,
	PointDensity_falloff_PARTICLE_VELOCITY = 6,
};

int PointDensity_falloff_get(PointerRNA *ptr);
void PointDensity_falloff_set(PointerRNA *ptr, int value);

PointerRNA PointDensity_falloff_curve_get(PointerRNA *ptr);

int PointDensity_use_falloff_curve_get(PointerRNA *ptr);
void PointDensity_use_falloff_curve_set(PointerRNA *ptr, int value);

enum {
	PointDensity_noise_basis_BLENDER_ORIGINAL = 0,
	PointDensity_noise_basis_ORIGINAL_PERLIN = 1,
	PointDensity_noise_basis_IMPROVED_PERLIN = 2,
	PointDensity_noise_basis_VORONOI_F1 = 3,
	PointDensity_noise_basis_VORONOI_F2 = 4,
	PointDensity_noise_basis_VORONOI_F3 = 5,
	PointDensity_noise_basis_VORONOI_F4 = 6,
	PointDensity_noise_basis_VORONOI_F2_F1 = 7,
	PointDensity_noise_basis_VORONOI_CRACKLE = 8,
	PointDensity_noise_basis_CELL_NOISE = 14,
};

int PointDensity_noise_basis_get(PointerRNA *ptr);
void PointDensity_noise_basis_set(PointerRNA *ptr, int value);

PointerRNA PointDensity_object_get(PointerRNA *ptr);

enum {
	PointDensity_particle_cache_space_OBJECT_LOCATION = 0,
	PointDensity_particle_cache_space_OBJECT_SPACE = 1,
	PointDensity_particle_cache_space_WORLD_SPACE = 2,
};

int PointDensity_particle_cache_space_get(PointerRNA *ptr);
void PointDensity_particle_cache_space_set(PointerRNA *ptr, int value);

PointerRNA PointDensity_particle_system_get(PointerRNA *ptr);

enum {
	PointDensity_point_source_PARTICLE_SYSTEM = 0,
	PointDensity_point_source_OBJECT = 1,
};

int PointDensity_point_source_get(PointerRNA *ptr);
void PointDensity_point_source_set(PointerRNA *ptr, int value);

float PointDensity_radius_get(PointerRNA *ptr);
void PointDensity_radius_set(PointerRNA *ptr, float value);

float PointDensity_speed_scale_get(PointerRNA *ptr);
void PointDensity_speed_scale_set(PointerRNA *ptr, float value);

float PointDensity_turbulence_scale_get(PointerRNA *ptr);
void PointDensity_turbulence_scale_set(PointerRNA *ptr, float value);

float PointDensity_falloff_soft_get(PointerRNA *ptr);
void PointDensity_falloff_soft_set(PointerRNA *ptr, float value);

int PointDensity_use_turbulence_get(PointerRNA *ptr);
void PointDensity_use_turbulence_set(PointerRNA *ptr, int value);

enum {
	PointDensity_turbulence_influence_STATIC = 0,
	PointDensity_turbulence_influence_PARTICLE_VELOCITY = 1,
	PointDensity_turbulence_influence_PARTICLE_AGE = 2,
	PointDensity_turbulence_influence_GLOBAL_TIME = 3,
};

int PointDensity_turbulence_influence_get(PointerRNA *ptr);
void PointDensity_turbulence_influence_set(PointerRNA *ptr, int value);

float PointDensity_turbulence_strength_get(PointerRNA *ptr);
void PointDensity_turbulence_strength_set(PointerRNA *ptr, float value);

float PointDensity_falloff_speed_scale_get(PointerRNA *ptr);
void PointDensity_falloff_speed_scale_set(PointerRNA *ptr, float value);

enum {
	PointDensity_vertex_cache_space_OBJECT_LOCATION = 0,
	PointDensity_vertex_cache_space_OBJECT_SPACE = 1,
	PointDensity_vertex_cache_space_WORLD_SPACE = 2,
};

int PointDensity_vertex_cache_space_get(PointerRNA *ptr);
void PointDensity_vertex_cache_space_set(PointerRNA *ptr, int value);

/**************** Point Density ****************/

extern StructRNA RNA_PointDensityTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

PointerRNA PointDensityTexture_point_density_get(PointerRNA *ptr);

/**************** Point Lamp ****************/

extern StructRNA RNA_PointLamp;
extern StructRNA RNA_Lamp;
extern StructRNA RNA_ID;

int PointLamp_use_auto_clip_end_get(PointerRNA *ptr);
void PointLamp_use_auto_clip_end_set(PointerRNA *ptr, int value);

int PointLamp_use_auto_clip_start_get(PointerRNA *ptr);
void PointLamp_use_auto_clip_start_set(PointerRNA *ptr, int value);

float PointLamp_compression_threshold_get(PointerRNA *ptr);
void PointLamp_compression_threshold_set(PointerRNA *ptr, float value);

PointerRNA PointLamp_falloff_curve_get(PointerRNA *ptr);

enum {
	PointLamp_falloff_type_CONSTANT = 0,
	PointLamp_falloff_type_INVERSE_LINEAR = 1,
	PointLamp_falloff_type_INVERSE_SQUARE = 2,
	PointLamp_falloff_type_CUSTOM_CURVE = 3,
	PointLamp_falloff_type_LINEAR_QUADRATIC_WEIGHTED = 4,
};

int PointLamp_falloff_type_get(PointerRNA *ptr);
void PointLamp_falloff_type_set(PointerRNA *ptr, int value);

float PointLamp_linear_attenuation_get(PointerRNA *ptr);
void PointLamp_linear_attenuation_set(PointerRNA *ptr, float value);

int PointLamp_use_only_shadow_get(PointerRNA *ptr);
void PointLamp_use_only_shadow_set(PointerRNA *ptr, int value);

float PointLamp_quadratic_attenuation_get(PointerRNA *ptr);
void PointLamp_quadratic_attenuation_set(PointerRNA *ptr, float value);

int PointLamp_shadow_buffer_samples_get(PointerRNA *ptr);
void PointLamp_shadow_buffer_samples_set(PointerRNA *ptr, int value);

float PointLamp_shadow_adaptive_threshold_get(PointerRNA *ptr);
void PointLamp_shadow_adaptive_threshold_set(PointerRNA *ptr, float value);

float PointLamp_shadow_buffer_bias_get(PointerRNA *ptr);
void PointLamp_shadow_buffer_bias_set(PointerRNA *ptr, float value);

float PointLamp_shadow_buffer_bleed_bias_get(PointerRNA *ptr);
void PointLamp_shadow_buffer_bleed_bias_set(PointerRNA *ptr, float value);

float PointLamp_shadow_buffer_clip_end_get(PointerRNA *ptr);
void PointLamp_shadow_buffer_clip_end_set(PointerRNA *ptr, float value);

float PointLamp_shadow_buffer_clip_start_get(PointerRNA *ptr);
void PointLamp_shadow_buffer_clip_start_set(PointerRNA *ptr, float value);

int PointLamp_shadow_buffer_size_get(PointerRNA *ptr);
void PointLamp_shadow_buffer_size_set(PointerRNA *ptr, int value);

float PointLamp_shadow_buffer_soft_get(PointerRNA *ptr);
void PointLamp_shadow_buffer_soft_set(PointerRNA *ptr, float value);

enum {
	PointLamp_shadow_buffer_type_REGULAR = 0,
	PointLamp_shadow_buffer_type_HALFWAY = 2,
	PointLamp_shadow_buffer_type_IRREGULAR = 1,
	PointLamp_shadow_buffer_type_DEEP = 3,
};

int PointLamp_shadow_buffer_type_get(PointerRNA *ptr);
void PointLamp_shadow_buffer_type_set(PointerRNA *ptr, int value);

void PointLamp_shadow_color_get(PointerRNA *ptr, float values[3]);
void PointLamp_shadow_color_set(PointerRNA *ptr, const float values[3]);

enum {
	PointLamp_shadow_filter_type_BOX = 0,
	PointLamp_shadow_filter_type_TENT = 1,
	PointLamp_shadow_filter_type_GAUSS = 2,
};

int PointLamp_shadow_filter_type_get(PointerRNA *ptr);
void PointLamp_shadow_filter_type_set(PointerRNA *ptr, int value);

int PointLamp_use_shadow_layer_get(PointerRNA *ptr);
void PointLamp_use_shadow_layer_set(PointerRNA *ptr, int value);

enum {
	PointLamp_ge_shadow_buffer_type_SIMPLE = 0,
	PointLamp_ge_shadow_buffer_type_VARIANCE = 1,
};

int PointLamp_ge_shadow_buffer_type_get(PointerRNA *ptr);
void PointLamp_ge_shadow_buffer_type_set(PointerRNA *ptr, int value);

int PointLamp_shadow_ray_samples_get(PointerRNA *ptr);
void PointLamp_shadow_ray_samples_set(PointerRNA *ptr, int value);

enum {
	PointLamp_shadow_ray_sample_method_ADAPTIVE_QMC = 1,
	PointLamp_shadow_ray_sample_method_CONSTANT_QMC = 2,
};

int PointLamp_shadow_ray_sample_method_get(PointerRNA *ptr);
void PointLamp_shadow_ray_sample_method_set(PointerRNA *ptr, int value);

enum {
	PointLamp_shadow_sample_buffers_BUFFERS_1 = 1,
	PointLamp_shadow_sample_buffers_BUFFERS_4 = 4,
	PointLamp_shadow_sample_buffers_BUFFERS_9 = 9,
};

int PointLamp_shadow_sample_buffers_get(PointerRNA *ptr);
void PointLamp_shadow_sample_buffers_set(PointerRNA *ptr, int value);

float PointLamp_shadow_soft_size_get(PointerRNA *ptr);
void PointLamp_shadow_soft_size_set(PointerRNA *ptr, float value);

int PointLamp_use_sphere_get(PointerRNA *ptr);
void PointLamp_use_sphere_set(PointerRNA *ptr, int value);

enum {
	PointLamp_shadow_method_NOSHADOW = 0,
	PointLamp_shadow_method_RAY_SHADOW = 8192,
};

int PointLamp_shadow_method_get(PointerRNA *ptr);
void PointLamp_shadow_method_set(PointerRNA *ptr, int value);

int PointLamp_use_shadow_get(PointerRNA *ptr);
void PointLamp_use_shadow_set(PointerRNA *ptr, int value);

/**************** Pointer Definition ****************/

extern StructRNA RNA_PointerProperty;
extern StructRNA RNA_Property;

PointerRNA PointerProperty_fixed_type_get(PointerRNA *ptr);

/**************** Pose ****************/

extern StructRNA RNA_Pose;

PointerRNA Pose_rna_type_get(PointerRNA *ptr);

PointerRNA Pose_animation_visualization_get(PointerRNA *ptr);

void Pose_bone_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Pose_bone_groups_next(CollectionPropertyIterator *iter);
void Pose_bone_groups_end(CollectionPropertyIterator *iter);
int Pose_bone_groups_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Pose_bone_groups_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA Pose_ik_param_get(PointerRNA *ptr);

enum {
	Pose_ik_solver_LEGACY = 0,
	Pose_ik_solver_ITASC = 1,
};

int Pose_ik_solver_get(PointerRNA *ptr);
void Pose_ik_solver_set(PointerRNA *ptr, int value);

void Pose_bones_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Pose_bones_next(CollectionPropertyIterator *iter);
void Pose_bones_end(CollectionPropertyIterator *iter);
int Pose_bones_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int Pose_bones_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Pose Bone ****************/

extern StructRNA RNA_PoseBone;

PointerRNA PoseBone_rna_type_get(PointerRNA *ptr);

#define PoseBone_name_MAX 64

void PoseBone_name_get(PointerRNA *ptr, char *value);
int PoseBone_name_length(PointerRNA *ptr);
void PoseBone_name_set(PointerRNA *ptr, const char *value);

void PoseBone_rotation_axis_angle_get(PointerRNA *ptr, float values[4]);
void PoseBone_rotation_axis_angle_set(PointerRNA *ptr, const float values[4]);

void PoseBone_matrix_basis_get(PointerRNA *ptr, float values[16]);
void PoseBone_matrix_basis_set(PointerRNA *ptr, const float values[16]);

PointerRNA PoseBone_bone_get(PointerRNA *ptr);

PointerRNA PoseBone_bone_group_get(PointerRNA *ptr);

int PoseBone_bone_group_index_get(PointerRNA *ptr);
void PoseBone_bone_group_index_set(PointerRNA *ptr, int value);

void PoseBone_matrix_channel_get(PointerRNA *ptr, float values[16]);
void PoseBone_matrix_channel_set(PointerRNA *ptr, const float values[16]);

PointerRNA PoseBone_child_get(PointerRNA *ptr);

void PoseBone_constraints_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void PoseBone_constraints_next(CollectionPropertyIterator *iter);
void PoseBone_constraints_end(CollectionPropertyIterator *iter);
int PoseBone_constraints_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
int PoseBone_constraints_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA PoseBone_custom_shape_get(PointerRNA *ptr);

PointerRNA PoseBone_custom_shape_transform_get(PointerRNA *ptr);

void PoseBone_rotation_euler_get(PointerRNA *ptr, float values[3]);
void PoseBone_rotation_euler_set(PointerRNA *ptr, const float values[3]);

int PoseBone_is_in_ik_chain_get(PointerRNA *ptr);
void PoseBone_is_in_ik_chain_set(PointerRNA *ptr, int value);

float PoseBone_ik_linear_weight_get(PointerRNA *ptr);
void PoseBone_ik_linear_weight_set(PointerRNA *ptr, float value);

float PoseBone_ik_rotation_weight_get(PointerRNA *ptr);
void PoseBone_ik_rotation_weight_set(PointerRNA *ptr, float value);

float PoseBone_ik_stretch_get(PointerRNA *ptr);
void PoseBone_ik_stretch_set(PointerRNA *ptr, float value);

int PoseBone_use_ik_limit_x_get(PointerRNA *ptr);
void PoseBone_use_ik_limit_x_set(PointerRNA *ptr, int value);

int PoseBone_lock_ik_x_get(PointerRNA *ptr);
void PoseBone_lock_ik_x_set(PointerRNA *ptr, int value);

float PoseBone_ik_max_x_get(PointerRNA *ptr);
void PoseBone_ik_max_x_set(PointerRNA *ptr, float value);

float PoseBone_ik_min_x_get(PointerRNA *ptr);
void PoseBone_ik_min_x_set(PointerRNA *ptr, float value);

float PoseBone_ik_stiffness_x_get(PointerRNA *ptr);
void PoseBone_ik_stiffness_x_set(PointerRNA *ptr, float value);

int PoseBone_use_ik_limit_y_get(PointerRNA *ptr);
void PoseBone_use_ik_limit_y_set(PointerRNA *ptr, int value);

int PoseBone_lock_ik_y_get(PointerRNA *ptr);
void PoseBone_lock_ik_y_set(PointerRNA *ptr, int value);

float PoseBone_ik_max_y_get(PointerRNA *ptr);
void PoseBone_ik_max_y_set(PointerRNA *ptr, float value);

float PoseBone_ik_min_y_get(PointerRNA *ptr);
void PoseBone_ik_min_y_set(PointerRNA *ptr, float value);

float PoseBone_ik_stiffness_y_get(PointerRNA *ptr);
void PoseBone_ik_stiffness_y_set(PointerRNA *ptr, float value);

int PoseBone_use_ik_limit_z_get(PointerRNA *ptr);
void PoseBone_use_ik_limit_z_set(PointerRNA *ptr, int value);

int PoseBone_lock_ik_z_get(PointerRNA *ptr);
void PoseBone_lock_ik_z_set(PointerRNA *ptr, int value);

float PoseBone_ik_max_z_get(PointerRNA *ptr);
void PoseBone_ik_max_z_set(PointerRNA *ptr, float value);

float PoseBone_ik_min_z_get(PointerRNA *ptr);
void PoseBone_ik_min_z_set(PointerRNA *ptr, float value);

float PoseBone_ik_stiffness_z_get(PointerRNA *ptr);
void PoseBone_ik_stiffness_z_set(PointerRNA *ptr, float value);

int PoseBone_use_ik_rotation_control_get(PointerRNA *ptr);
void PoseBone_use_ik_rotation_control_set(PointerRNA *ptr, int value);

int PoseBone_use_ik_linear_control_get(PointerRNA *ptr);
void PoseBone_use_ik_linear_control_set(PointerRNA *ptr, int value);

void PoseBone_location_get(PointerRNA *ptr, float values[3]);
void PoseBone_location_set(PointerRNA *ptr, const float values[3]);

void PoseBone_lock_location_get(PointerRNA *ptr, int values[3]);
void PoseBone_lock_location_set(PointerRNA *ptr, const int values[3]);

void PoseBone_lock_rotation_get(PointerRNA *ptr, int values[3]);
void PoseBone_lock_rotation_set(PointerRNA *ptr, const int values[3]);

int PoseBone_lock_rotation_w_get(PointerRNA *ptr);
void PoseBone_lock_rotation_w_set(PointerRNA *ptr, int value);

int PoseBone_lock_rotations_4d_get(PointerRNA *ptr);
void PoseBone_lock_rotations_4d_set(PointerRNA *ptr, int value);

void PoseBone_lock_scale_get(PointerRNA *ptr, int values[3]);
void PoseBone_lock_scale_set(PointerRNA *ptr, const int values[3]);

PointerRNA PoseBone_motion_path_get(PointerRNA *ptr);

PointerRNA PoseBone_parent_get(PointerRNA *ptr);

void PoseBone_head_get(PointerRNA *ptr, float values[3]);
void PoseBone_head_set(PointerRNA *ptr, const float values[3]);

void PoseBone_matrix_get(PointerRNA *ptr, float values[16]);
void PoseBone_matrix_set(PointerRNA *ptr, const float values[16]);

void PoseBone_tail_get(PointerRNA *ptr, float values[3]);
void PoseBone_tail_set(PointerRNA *ptr, const float values[3]);

void PoseBone_rotation_quaternion_get(PointerRNA *ptr, float values[4]);
void PoseBone_rotation_quaternion_set(PointerRNA *ptr, const float values[4]);

enum {
	PoseBone_rotation_mode_QUATERNION = 0,
	PoseBone_rotation_mode_XYZ = 1,
	PoseBone_rotation_mode_XZY = 2,
	PoseBone_rotation_mode_YXZ = 3,
	PoseBone_rotation_mode_YZX = 4,
	PoseBone_rotation_mode_ZXY = 5,
	PoseBone_rotation_mode_ZYX = 6,
	PoseBone_rotation_mode_AXIS_ANGLE = -1,
};

int PoseBone_rotation_mode_get(PointerRNA *ptr);
void PoseBone_rotation_mode_set(PointerRNA *ptr, int value);

void PoseBone_scale_get(PointerRNA *ptr, float values[3]);
void PoseBone_scale_set(PointerRNA *ptr, const float values[3]);

float PoseBone_evaluate_envelope(struct bPoseChannel *_self, float point[3]);
/**************** PoseBone Constraints ****************/

extern StructRNA RNA_PoseBoneConstraints;

PointerRNA PoseBoneConstraints_rna_type_get(PointerRNA *ptr);

PointerRNA PoseBoneConstraints_active_get(PointerRNA *ptr);

struct bConstraint *PoseBoneConstraints_new(struct bPoseChannel *_self, int type);
void PoseBoneConstraints_remove(struct ID *_selfid, struct bPoseChannel *_self, ReportList *reports, struct PointerRNA *constraint);
/**************** Property Definition ****************/

extern StructRNA RNA_Property;

PointerRNA Property_rna_type_get(PointerRNA *ptr);

void Property_name_get(PointerRNA *ptr, char *value);
int Property_name_length(PointerRNA *ptr);
void Property_name_set(PointerRNA *ptr, const char *value);

int Property_is_animatable_get(PointerRNA *ptr);
void Property_is_animatable_set(PointerRNA *ptr, int value);

PointerRNA Property_srna_get(PointerRNA *ptr);

void Property_description_get(PointerRNA *ptr, char *value);
int Property_description_length(PointerRNA *ptr);
void Property_description_set(PointerRNA *ptr, const char *value);

int Property_is_enum_flag_get(PointerRNA *ptr);
void Property_is_enum_flag_set(PointerRNA *ptr, int value);

int Property_is_hidden_get(PointerRNA *ptr);
void Property_is_hidden_set(PointerRNA *ptr, int value);

enum {
	Property_icon_NONE = 0,
	Property_icon_QUESTION = 1,
	Property_icon_ERROR = 2,
	Property_icon_CANCEL = 3,
	Property_icon_TRIA_RIGHT = 4,
	Property_icon_TRIA_DOWN = 5,
	Property_icon_TRIA_LEFT = 6,
	Property_icon_TRIA_UP = 7,
	Property_icon_ARROW_LEFTRIGHT = 8,
	Property_icon_PLUS = 9,
	Property_icon_DISCLOSURE_TRI_DOWN = 10,
	Property_icon_DISCLOSURE_TRI_RIGHT = 11,
	Property_icon_RADIOBUT_OFF = 12,
	Property_icon_RADIOBUT_ON = 13,
	Property_icon_MENU_PANEL = 14,
	Property_icon_BLENDER = 15,
	Property_icon_GRIP = 16,
	Property_icon_DOT = 17,
	Property_icon_COLLAPSEMENU = 18,
	Property_icon_X = 19,
	Property_icon_GO_LEFT = 21,
	Property_icon_PLUG = 22,
	Property_icon_UI = 23,
	Property_icon_NODE = 24,
	Property_icon_NODE_SEL = 25,
	Property_icon_FULLSCREEN = 26,
	Property_icon_SPLITSCREEN = 27,
	Property_icon_RIGHTARROW_THIN = 28,
	Property_icon_BORDERMOVE = 29,
	Property_icon_VIEWZOOM = 30,
	Property_icon_ZOOMIN = 31,
	Property_icon_ZOOMOUT = 32,
	Property_icon_PANEL_CLOSE = 33,
	Property_icon_COPY_ID = 34,
	Property_icon_EYEDROPPER = 35,
	Property_icon_LINK_AREA = 36,
	Property_icon_AUTO = 37,
	Property_icon_CHECKBOX_DEHLT = 38,
	Property_icon_CHECKBOX_HLT = 39,
	Property_icon_UNLOCKED = 40,
	Property_icon_LOCKED = 41,
	Property_icon_UNPINNED = 42,
	Property_icon_PINNED = 43,
	Property_icon_SCREEN_BACK = 44,
	Property_icon_RIGHTARROW = 45,
	Property_icon_DOWNARROW_HLT = 46,
	Property_icon_DOTSUP = 47,
	Property_icon_DOTSDOWN = 48,
	Property_icon_LINK = 49,
	Property_icon_INLINK = 50,
	Property_icon_PLUGIN = 51,
	Property_icon_HELP = 52,
	Property_icon_GHOST_ENABLED = 53,
	Property_icon_COLOR = 54,
	Property_icon_LINKED = 55,
	Property_icon_UNLINKED = 56,
	Property_icon_HAND = 57,
	Property_icon_ZOOM_ALL = 58,
	Property_icon_ZOOM_SELECTED = 59,
	Property_icon_ZOOM_PREVIOUS = 60,
	Property_icon_ZOOM_IN = 61,
	Property_icon_ZOOM_OUT = 62,
	Property_icon_RENDER_REGION = 63,
	Property_icon_BORDER_RECT = 64,
	Property_icon_BORDER_LASSO = 65,
	Property_icon_FREEZE = 66,
	Property_icon_STYLUS_PRESSURE = 67,
	Property_icon_GHOST_DISABLED = 68,
	Property_icon_NEW = 69,
	Property_icon_FILE_TICK = 70,
	Property_icon_QUIT = 71,
	Property_icon_URL = 72,
	Property_icon_RECOVER_LAST = 73,
	Property_icon_FULLSCREEN_ENTER = 75,
	Property_icon_FULLSCREEN_EXIT = 76,
	Property_icon_BLANK1 = 77,
	Property_icon_LAMP = 78,
	Property_icon_MATERIAL = 79,
	Property_icon_TEXTURE = 80,
	Property_icon_ANIM = 81,
	Property_icon_WORLD = 82,
	Property_icon_SCENE = 83,
	Property_icon_EDIT = 84,
	Property_icon_GAME = 85,
	Property_icon_RADIO = 86,
	Property_icon_SCRIPT = 87,
	Property_icon_PARTICLES = 88,
	Property_icon_PHYSICS = 89,
	Property_icon_SPEAKER = 90,
	Property_icon_TEXTURE_SHADED = 91,
	Property_icon_VIEW3D = 104,
	Property_icon_IPO = 105,
	Property_icon_OOPS = 106,
	Property_icon_BUTS = 107,
	Property_icon_FILESEL = 108,
	Property_icon_IMAGE_COL = 109,
	Property_icon_INFO = 110,
	Property_icon_SEQUENCE = 111,
	Property_icon_TEXT = 112,
	Property_icon_IMASEL = 113,
	Property_icon_SOUND = 114,
	Property_icon_ACTION = 115,
	Property_icon_NLA = 116,
	Property_icon_SCRIPTWIN = 117,
	Property_icon_TIME = 118,
	Property_icon_NODETREE = 119,
	Property_icon_LOGIC = 120,
	Property_icon_CONSOLE = 121,
	Property_icon_PREFERENCES = 122,
	Property_icon_CLIP = 123,
	Property_icon_ASSET_MANAGER = 124,
	Property_icon_OBJECT_DATAMODE = 130,
	Property_icon_EDITMODE_HLT = 131,
	Property_icon_FACESEL_HLT = 132,
	Property_icon_VPAINT_HLT = 133,
	Property_icon_TPAINT_HLT = 134,
	Property_icon_WPAINT_HLT = 135,
	Property_icon_SCULPTMODE_HLT = 136,
	Property_icon_POSE_HLT = 137,
	Property_icon_PARTICLEMODE = 138,
	Property_icon_LIGHTPAINT = 139,
	Property_icon_SCENE_DATA = 156,
	Property_icon_RENDERLAYERS = 157,
	Property_icon_WORLD_DATA = 158,
	Property_icon_OBJECT_DATA = 159,
	Property_icon_MESH_DATA = 160,
	Property_icon_CURVE_DATA = 161,
	Property_icon_META_DATA = 162,
	Property_icon_LATTICE_DATA = 163,
	Property_icon_LAMP_DATA = 164,
	Property_icon_MATERIAL_DATA = 165,
	Property_icon_TEXTURE_DATA = 166,
	Property_icon_ANIM_DATA = 167,
	Property_icon_CAMERA_DATA = 168,
	Property_icon_PARTICLE_DATA = 169,
	Property_icon_LIBRARY_DATA_DIRECT = 170,
	Property_icon_GROUP = 171,
	Property_icon_ARMATURE_DATA = 172,
	Property_icon_POSE_DATA = 173,
	Property_icon_BONE_DATA = 174,
	Property_icon_CONSTRAINT = 175,
	Property_icon_SHAPEKEY_DATA = 176,
	Property_icon_CONSTRAINT_BONE = 177,
	Property_icon_CAMERA_STEREO = 178,
	Property_icon_PACKAGE = 179,
	Property_icon_UGLYPACKAGE = 180,
	Property_icon_BRUSH_DATA = 182,
	Property_icon_IMAGE_DATA = 183,
	Property_icon_FILE = 184,
	Property_icon_FCURVE = 185,
	Property_icon_FONT_DATA = 186,
	Property_icon_RENDER_RESULT = 187,
	Property_icon_SURFACE_DATA = 188,
	Property_icon_EMPTY_DATA = 189,
	Property_icon_SETTINGS = 190,
	Property_icon_RENDER_ANIMATION = 191,
	Property_icon_RENDER_STILL = 192,
	Property_icon_BOIDS = 194,
	Property_icon_STRANDS = 195,
	Property_icon_LIBRARY_DATA_INDIRECT = 196,
	Property_icon_GREASEPENCIL = 197,
	Property_icon_LINE_DATA = 198,
	Property_icon_GROUP_BONE = 200,
	Property_icon_GROUP_VERTEX = 201,
	Property_icon_GROUP_VCOL = 202,
	Property_icon_GROUP_UVS = 203,
	Property_icon_RNA = 206,
	Property_icon_RNA_ADD = 207,
	Property_icon_OUTLINER_OB_EMPTY = 234,
	Property_icon_OUTLINER_OB_MESH = 235,
	Property_icon_OUTLINER_OB_CURVE = 236,
	Property_icon_OUTLINER_OB_LATTICE = 237,
	Property_icon_OUTLINER_OB_META = 238,
	Property_icon_OUTLINER_OB_LAMP = 239,
	Property_icon_OUTLINER_OB_CAMERA = 240,
	Property_icon_OUTLINER_OB_ARMATURE = 241,
	Property_icon_OUTLINER_OB_FONT = 242,
	Property_icon_OUTLINER_OB_SURFACE = 243,
	Property_icon_OUTLINER_OB_SPEAKER = 244,
	Property_icon_RESTRICT_VIEW_OFF = 253,
	Property_icon_RESTRICT_VIEW_ON = 254,
	Property_icon_RESTRICT_SELECT_OFF = 255,
	Property_icon_RESTRICT_SELECT_ON = 256,
	Property_icon_RESTRICT_RENDER_OFF = 257,
	Property_icon_RESTRICT_RENDER_ON = 258,
	Property_icon_OUTLINER_DATA_EMPTY = 260,
	Property_icon_OUTLINER_DATA_MESH = 261,
	Property_icon_OUTLINER_DATA_CURVE = 262,
	Property_icon_OUTLINER_DATA_LATTICE = 263,
	Property_icon_OUTLINER_DATA_META = 264,
	Property_icon_OUTLINER_DATA_LAMP = 265,
	Property_icon_OUTLINER_DATA_CAMERA = 266,
	Property_icon_OUTLINER_DATA_ARMATURE = 267,
	Property_icon_OUTLINER_DATA_FONT = 268,
	Property_icon_OUTLINER_DATA_SURFACE = 269,
	Property_icon_OUTLINER_DATA_SPEAKER = 270,
	Property_icon_OUTLINER_DATA_POSE = 271,
	Property_icon_MESH_PLANE = 286,
	Property_icon_MESH_CUBE = 287,
	Property_icon_MESH_CIRCLE = 288,
	Property_icon_MESH_UVSPHERE = 289,
	Property_icon_MESH_ICOSPHERE = 290,
	Property_icon_MESH_GRID = 291,
	Property_icon_MESH_MONKEY = 292,
	Property_icon_MESH_CYLINDER = 293,
	Property_icon_MESH_TORUS = 294,
	Property_icon_MESH_CONE = 295,
	Property_icon_LAMP_POINT = 298,
	Property_icon_LAMP_SUN = 299,
	Property_icon_LAMP_SPOT = 300,
	Property_icon_LAMP_HEMI = 301,
	Property_icon_LAMP_AREA = 302,
	Property_icon_META_EMPTY = 305,
	Property_icon_META_PLANE = 306,
	Property_icon_META_CUBE = 307,
	Property_icon_META_BALL = 308,
	Property_icon_META_ELLIPSOID = 309,
	Property_icon_META_CAPSULE = 310,
	Property_icon_SURFACE_NCURVE = 312,
	Property_icon_SURFACE_NCIRCLE = 313,
	Property_icon_SURFACE_NSURFACE = 314,
	Property_icon_SURFACE_NCYLINDER = 315,
	Property_icon_SURFACE_NSPHERE = 316,
	Property_icon_SURFACE_NTORUS = 317,
	Property_icon_CURVE_BEZCURVE = 321,
	Property_icon_CURVE_BEZCIRCLE = 322,
	Property_icon_CURVE_NCURVE = 323,
	Property_icon_CURVE_NCIRCLE = 324,
	Property_icon_CURVE_PATH = 325,
	Property_icon_COLOR_RED = 331,
	Property_icon_COLOR_GREEN = 332,
	Property_icon_COLOR_BLUE = 333,
	Property_icon_TRIA_RIGHT_BAR = 334,
	Property_icon_TRIA_DOWN_BAR = 335,
	Property_icon_TRIA_LEFT_BAR = 336,
	Property_icon_TRIA_UP_BAR = 337,
	Property_icon_FORCE_FORCE = 338,
	Property_icon_FORCE_WIND = 339,
	Property_icon_FORCE_VORTEX = 340,
	Property_icon_FORCE_MAGNETIC = 341,
	Property_icon_FORCE_HARMONIC = 342,
	Property_icon_FORCE_CHARGE = 343,
	Property_icon_FORCE_LENNARDJONES = 344,
	Property_icon_FORCE_TEXTURE = 345,
	Property_icon_FORCE_CURVE = 346,
	Property_icon_FORCE_BOID = 347,
	Property_icon_FORCE_TURBULENCE = 348,
	Property_icon_FORCE_DRAG = 349,
	Property_icon_FORCE_SMOKEFLOW = 350,
	Property_icon_MODIFIER = 442,
	Property_icon_MOD_WAVE = 443,
	Property_icon_MOD_BUILD = 444,
	Property_icon_MOD_DECIM = 445,
	Property_icon_MOD_MIRROR = 446,
	Property_icon_MOD_SOFT = 447,
	Property_icon_MOD_SUBSURF = 448,
	Property_icon_HOOK = 449,
	Property_icon_MOD_PHYSICS = 450,
	Property_icon_MOD_PARTICLES = 451,
	Property_icon_MOD_BOOLEAN = 452,
	Property_icon_MOD_EDGESPLIT = 453,
	Property_icon_MOD_ARRAY = 454,
	Property_icon_MOD_UVPROJECT = 455,
	Property_icon_MOD_DISPLACE = 456,
	Property_icon_MOD_CURVE = 457,
	Property_icon_MOD_LATTICE = 458,
	Property_icon_CONSTRAINT_DATA = 459,
	Property_icon_MOD_ARMATURE = 460,
	Property_icon_MOD_SHRINKWRAP = 461,
	Property_icon_MOD_CAST = 462,
	Property_icon_MOD_MESHDEFORM = 463,
	Property_icon_MOD_BEVEL = 464,
	Property_icon_MOD_SMOOTH = 465,
	Property_icon_MOD_SIMPLEDEFORM = 466,
	Property_icon_MOD_MASK = 467,
	Property_icon_MOD_CLOTH = 468,
	Property_icon_MOD_EXPLODE = 469,
	Property_icon_MOD_FLUIDSIM = 470,
	Property_icon_MOD_MULTIRES = 471,
	Property_icon_MOD_SMOKE = 472,
	Property_icon_MOD_SOLIDIFY = 473,
	Property_icon_MOD_SCREW = 474,
	Property_icon_MOD_VERTEX_WEIGHT = 475,
	Property_icon_MOD_DYNAMICPAINT = 476,
	Property_icon_MOD_REMESH = 477,
	Property_icon_MOD_OCEAN = 478,
	Property_icon_MOD_WARP = 479,
	Property_icon_MOD_SKIN = 480,
	Property_icon_MOD_TRIANGULATE = 481,
	Property_icon_MOD_WIREFRAME = 482,
	Property_icon_REC = 494,
	Property_icon_PLAY = 495,
	Property_icon_FF = 496,
	Property_icon_REW = 497,
	Property_icon_PAUSE = 498,
	Property_icon_PREV_KEYFRAME = 499,
	Property_icon_NEXT_KEYFRAME = 500,
	Property_icon_PLAY_AUDIO = 501,
	Property_icon_PLAY_REVERSE = 502,
	Property_icon_PREVIEW_RANGE = 503,
	Property_icon_ACTION_TWEAK = 504,
	Property_icon_PMARKER_ACT = 505,
	Property_icon_PMARKER_SEL = 506,
	Property_icon_PMARKER = 507,
	Property_icon_MARKER_HLT = 508,
	Property_icon_MARKER = 509,
	Property_icon_SPACE2 = 510,
	Property_icon_SPACE3 = 511,
	Property_icon_KEYINGSET = 512,
	Property_icon_KEY_DEHLT = 513,
	Property_icon_KEY_HLT = 514,
	Property_icon_MUTE_IPO_OFF = 515,
	Property_icon_MUTE_IPO_ON = 516,
	Property_icon_VISIBLE_IPO_OFF = 517,
	Property_icon_VISIBLE_IPO_ON = 518,
	Property_icon_DRIVER = 519,
	Property_icon_SOLO_OFF = 520,
	Property_icon_SOLO_ON = 521,
	Property_icon_FRAME_PREV = 522,
	Property_icon_FRAME_NEXT = 523,
	Property_icon_NLA_PUSHDOWN = 524,
	Property_icon_IPO_CONSTANT = 525,
	Property_icon_IPO_LINEAR = 526,
	Property_icon_IPO_BEZIER = 527,
	Property_icon_IPO_SINE = 528,
	Property_icon_IPO_QUAD = 529,
	Property_icon_IPO_CUBIC = 530,
	Property_icon_IPO_QUART = 531,
	Property_icon_IPO_QUINT = 532,
	Property_icon_IPO_EXPO = 533,
	Property_icon_IPO_CIRC = 534,
	Property_icon_IPO_BOUNCE = 535,
	Property_icon_IPO_ELASTIC = 536,
	Property_icon_IPO_BACK = 537,
	Property_icon_IPO_EASE_IN = 538,
	Property_icon_IPO_EASE_OUT = 539,
	Property_icon_IPO_EASE_IN_OUT = 540,
	Property_icon_VERTEXSEL = 546,
	Property_icon_EDGESEL = 547,
	Property_icon_FACESEL = 548,
	Property_icon_LOOPSEL = 549,
	Property_icon_ROTATE = 551,
	Property_icon_CURSOR = 552,
	Property_icon_ROTATECOLLECTION = 553,
	Property_icon_ROTATECENTER = 554,
	Property_icon_ROTACTIVE = 555,
	Property_icon_ALIGN = 556,
	Property_icon_SMOOTHCURVE = 558,
	Property_icon_SPHERECURVE = 559,
	Property_icon_ROOTCURVE = 560,
	Property_icon_SHARPCURVE = 561,
	Property_icon_LINCURVE = 562,
	Property_icon_NOCURVE = 563,
	Property_icon_RNDCURVE = 564,
	Property_icon_PROP_OFF = 565,
	Property_icon_PROP_ON = 566,
	Property_icon_PROP_CON = 567,
	Property_icon_SCULPT_DYNTOPO = 568,
	Property_icon_PARTICLE_POINT = 569,
	Property_icon_PARTICLE_TIP = 570,
	Property_icon_PARTICLE_PATH = 571,
	Property_icon_MAN_TRANS = 572,
	Property_icon_MAN_ROT = 573,
	Property_icon_MAN_SCALE = 574,
	Property_icon_MANIPUL = 575,
	Property_icon_SNAP_OFF = 576,
	Property_icon_SNAP_ON = 577,
	Property_icon_SNAP_NORMAL = 578,
	Property_icon_SNAP_INCREMENT = 579,
	Property_icon_SNAP_VERTEX = 580,
	Property_icon_SNAP_EDGE = 581,
	Property_icon_SNAP_FACE = 582,
	Property_icon_SNAP_VOLUME = 583,
	Property_icon_STICKY_UVS_LOC = 585,
	Property_icon_STICKY_UVS_DISABLE = 586,
	Property_icon_STICKY_UVS_VERT = 587,
	Property_icon_CLIPUV_DEHLT = 588,
	Property_icon_CLIPUV_HLT = 589,
	Property_icon_SNAP_PEEL_OBJECT = 590,
	Property_icon_GRID = 591,
	Property_icon_PASTEDOWN = 598,
	Property_icon_COPYDOWN = 599,
	Property_icon_PASTEFLIPUP = 600,
	Property_icon_PASTEFLIPDOWN = 601,
	Property_icon_SNAP_SURFACE = 606,
	Property_icon_AUTOMERGE_ON = 607,
	Property_icon_AUTOMERGE_OFF = 608,
	Property_icon_RETOPO = 609,
	Property_icon_UV_VERTEXSEL = 610,
	Property_icon_UV_EDGESEL = 611,
	Property_icon_UV_FACESEL = 612,
	Property_icon_UV_ISLANDSEL = 613,
	Property_icon_UV_SYNC_SELECT = 614,
	Property_icon_BBOX = 624,
	Property_icon_WIRE = 625,
	Property_icon_SOLID = 626,
	Property_icon_SMOOTH = 627,
	Property_icon_POTATO = 628,
	Property_icon_ORTHO = 630,
	Property_icon_LOCKVIEW_OFF = 633,
	Property_icon_LOCKVIEW_ON = 634,
	Property_icon_AXIS_SIDE = 636,
	Property_icon_AXIS_FRONT = 637,
	Property_icon_AXIS_TOP = 638,
	Property_icon_NDOF_DOM = 639,
	Property_icon_NDOF_TURN = 640,
	Property_icon_NDOF_FLY = 641,
	Property_icon_NDOF_TRANS = 642,
	Property_icon_LAYER_USED = 643,
	Property_icon_LAYER_ACTIVE = 644,
	Property_icon_SORTALPHA = 676,
	Property_icon_SORTBYEXT = 677,
	Property_icon_SORTTIME = 678,
	Property_icon_SORTSIZE = 679,
	Property_icon_LONGDISPLAY = 680,
	Property_icon_SHORTDISPLAY = 681,
	Property_icon_GHOST = 682,
	Property_icon_IMGDISPLAY = 683,
	Property_icon_SAVE_AS = 684,
	Property_icon_SAVE_COPY = 685,
	Property_icon_BOOKMARKS = 686,
	Property_icon_FONTPREVIEW = 687,
	Property_icon_FILTER = 688,
	Property_icon_NEWFOLDER = 689,
	Property_icon_OPEN_RECENT = 690,
	Property_icon_FILE_PARENT = 691,
	Property_icon_FILE_REFRESH = 692,
	Property_icon_FILE_FOLDER = 693,
	Property_icon_FILE_BLANK = 694,
	Property_icon_FILE_BLEND = 695,
	Property_icon_FILE_IMAGE = 696,
	Property_icon_FILE_MOVIE = 697,
	Property_icon_FILE_SCRIPT = 698,
	Property_icon_FILE_SOUND = 699,
	Property_icon_FILE_FONT = 700,
	Property_icon_FILE_TEXT = 701,
	Property_icon_RECOVER_AUTO = 702,
	Property_icon_SAVE_PREFS = 703,
	Property_icon_LINK_BLEND = 704,
	Property_icon_APPEND_BLEND = 705,
	Property_icon_IMPORT = 706,
	Property_icon_EXPORT = 707,
	Property_icon_EXTERNAL_DATA = 708,
	Property_icon_LOAD_FACTORY = 709,
	Property_icon_LOOP_BACK = 715,
	Property_icon_LOOP_FORWARDS = 716,
	Property_icon_BACK = 717,
	Property_icon_FORWARD = 718,
	Property_icon_FILE_BACKUP = 726,
	Property_icon_DISK_DRIVE = 727,
	Property_icon_MATPLANE = 728,
	Property_icon_MATSPHERE = 729,
	Property_icon_MATCUBE = 730,
	Property_icon_MONKEY = 731,
	Property_icon_HAIR = 732,
	Property_icon_ALIASED = 733,
	Property_icon_ANTIALIASED = 734,
	Property_icon_MAT_SPHERE_SKY = 735,
	Property_icon_WORDWRAP_OFF = 740,
	Property_icon_WORDWRAP_ON = 741,
	Property_icon_SYNTAX_OFF = 742,
	Property_icon_SYNTAX_ON = 743,
	Property_icon_LINENUMBERS_OFF = 744,
	Property_icon_LINENUMBERS_ON = 745,
	Property_icon_SCRIPTPLUGINS = 746,
	Property_icon_SEQ_SEQUENCER = 754,
	Property_icon_SEQ_PREVIEW = 755,
	Property_icon_SEQ_LUMA_WAVEFORM = 756,
	Property_icon_SEQ_CHROMA_SCOPE = 757,
	Property_icon_SEQ_HISTOGRAM = 758,
	Property_icon_SEQ_SPLITVIEW = 759,
	Property_icon_IMAGE_RGB = 763,
	Property_icon_IMAGE_RGB_ALPHA = 764,
	Property_icon_IMAGE_ALPHA = 765,
	Property_icon_IMAGE_ZDEPTH = 766,
	Property_icon_IMAGEFILE = 767,
	Property_icon_BRUSH_ADD = 780,
	Property_icon_BRUSH_BLOB = 781,
	Property_icon_BRUSH_BLUR = 782,
	Property_icon_BRUSH_CLAY = 783,
	Property_icon_BRUSH_CLAY_STRIPS = 784,
	Property_icon_BRUSH_CLONE = 785,
	Property_icon_BRUSH_CREASE = 786,
	Property_icon_BRUSH_DARKEN = 787,
	Property_icon_BRUSH_FILL = 788,
	Property_icon_BRUSH_FLATTEN = 789,
	Property_icon_BRUSH_GRAB = 790,
	Property_icon_BRUSH_INFLATE = 791,
	Property_icon_BRUSH_LAYER = 792,
	Property_icon_BRUSH_LIGHTEN = 793,
	Property_icon_BRUSH_MASK = 794,
	Property_icon_BRUSH_MIX = 795,
	Property_icon_BRUSH_MULTIPLY = 796,
	Property_icon_BRUSH_NUDGE = 797,
	Property_icon_BRUSH_PINCH = 798,
	Property_icon_BRUSH_SCRAPE = 799,
	Property_icon_BRUSH_SCULPT_DRAW = 800,
	Property_icon_BRUSH_SMEAR = 801,
	Property_icon_BRUSH_SMOOTH = 802,
	Property_icon_BRUSH_SNAKE_HOOK = 803,
	Property_icon_BRUSH_SOFTEN = 804,
	Property_icon_BRUSH_SUBTRACT = 805,
	Property_icon_BRUSH_TEXDRAW = 806,
	Property_icon_BRUSH_TEXFILL = 807,
	Property_icon_BRUSH_TEXMASK = 808,
	Property_icon_BRUSH_THUMB = 809,
	Property_icon_BRUSH_ROTATE = 810,
	Property_icon_BRUSH_VERTEXDRAW = 811,
	Property_icon_MATCAP_01 = 812,
	Property_icon_MATCAP_02 = 813,
	Property_icon_MATCAP_03 = 814,
	Property_icon_MATCAP_04 = 815,
	Property_icon_MATCAP_05 = 816,
	Property_icon_MATCAP_06 = 817,
	Property_icon_MATCAP_07 = 818,
	Property_icon_MATCAP_08 = 819,
	Property_icon_MATCAP_09 = 820,
	Property_icon_MATCAP_10 = 821,
	Property_icon_MATCAP_11 = 822,
	Property_icon_MATCAP_12 = 823,
	Property_icon_MATCAP_13 = 824,
	Property_icon_MATCAP_14 = 825,
	Property_icon_MATCAP_15 = 826,
	Property_icon_MATCAP_16 = 827,
	Property_icon_MATCAP_17 = 828,
	Property_icon_MATCAP_18 = 829,
	Property_icon_MATCAP_19 = 830,
	Property_icon_MATCAP_20 = 831,
	Property_icon_MATCAP_21 = 832,
	Property_icon_MATCAP_22 = 833,
	Property_icon_MATCAP_23 = 834,
	Property_icon_MATCAP_24 = 835,
	Property_icon_VIEW3D_VEC = 836,
	Property_icon_EDIT_VEC = 837,
	Property_icon_EDITMODE_VEC_DEHLT = 838,
	Property_icon_EDITMODE_VEC_HLT = 839,
	Property_icon_DISCLOSURE_TRI_RIGHT_VEC = 840,
	Property_icon_DISCLOSURE_TRI_DOWN_VEC = 841,
	Property_icon_MOVE_UP_VEC = 842,
	Property_icon_MOVE_DOWN_VEC = 843,
	Property_icon_X_VEC = 844,
	Property_icon_SMALL_TRI_RIGHT_VEC = 845,
};

int Property_icon_get(PointerRNA *ptr);
void Property_icon_set(PointerRNA *ptr, int value);

void Property_identifier_get(PointerRNA *ptr, char *value);
int Property_identifier_length(PointerRNA *ptr);
void Property_identifier_set(PointerRNA *ptr, const char *value);

int Property_is_library_editable_get(PointerRNA *ptr);
void Property_is_library_editable_set(PointerRNA *ptr, int value);

int Property_is_never_none_get(PointerRNA *ptr);
void Property_is_never_none_set(PointerRNA *ptr, int value);

int Property_is_argument_optional_get(PointerRNA *ptr);
void Property_is_argument_optional_set(PointerRNA *ptr, int value);

int Property_is_readonly_get(PointerRNA *ptr);
void Property_is_readonly_set(PointerRNA *ptr, int value);

int Property_is_registered_get(PointerRNA *ptr);
void Property_is_registered_set(PointerRNA *ptr, int value);

int Property_is_registered_optional_get(PointerRNA *ptr);
void Property_is_registered_optional_set(PointerRNA *ptr, int value);

int Property_is_required_get(PointerRNA *ptr);
void Property_is_required_set(PointerRNA *ptr, int value);

int Property_is_output_get(PointerRNA *ptr);
void Property_is_output_set(PointerRNA *ptr, int value);

int Property_is_runtime_get(PointerRNA *ptr);
void Property_is_runtime_set(PointerRNA *ptr, int value);

int Property_is_skip_save_get(PointerRNA *ptr);
void Property_is_skip_save_set(PointerRNA *ptr, int value);

enum {
	Property_subtype_NONE = 0,
	Property_subtype_FILE_PATH = 1,
	Property_subtype_DIR_PATH = 2,
	Property_subtype_PIXEL = 12,
	Property_subtype_UNSIGNED = 13,
	Property_subtype_PERCENTAGE = 14,
	Property_subtype_FACTOR = 15,
	Property_subtype_ANGLE = 327696,
	Property_subtype_TIME = 393233,
	Property_subtype_DISTANCE = 65554,
	Property_subtype_COLOR = 20,
	Property_subtype_TRANSLATION = 65557,
	Property_subtype_DIRECTION = 22,
	Property_subtype_MATRIX = 25,
	Property_subtype_EULER = 327706,
	Property_subtype_QUATERNION = 27,
	Property_subtype_XYZ = 29,
	Property_subtype_COLOR_GAMMA = 30,
	Property_subtype_COORDINATES = 31,
	Property_subtype_LAYER = 40,
	Property_subtype_LAYER_MEMBERSHIP = 41,
};

int Property_subtype_get(PointerRNA *ptr);
void Property_subtype_set(PointerRNA *ptr, int value);

void Property_translation_context_get(PointerRNA *ptr, char *value);
int Property_translation_context_length(PointerRNA *ptr);
void Property_translation_context_set(PointerRNA *ptr, const char *value);

enum {
	Property_type_BOOLEAN = 0,
	Property_type_INT = 1,
	Property_type_FLOAT = 2,
	Property_type_STRING = 3,
	Property_type_ENUM = 4,
	Property_type_POINTER = 5,
	Property_type_COLLECTION = 6,
};

int Property_type_get(PointerRNA *ptr);
void Property_type_set(PointerRNA *ptr, int value);

enum {
	Property_unit_NONE = 0,
	Property_unit_LENGTH = 65536,
	Property_unit_AREA = 131072,
	Property_unit_VOLUME = 196608,
	Property_unit_ROTATION = 327680,
	Property_unit_TIME = 393216,
	Property_unit_VELOCITY = 458752,
	Property_unit_ACCELERATION = 524288,
	Property_unit_CAMERA = 589824,
};

int Property_unit_get(PointerRNA *ptr);
void Property_unit_set(PointerRNA *ptr, int value);

/**************** Property Actuator ****************/

extern StructRNA RNA_PropertyActuator;
extern StructRNA RNA_Actuator;

enum {
	PropertyActuator_mode_ASSIGN = 0,
	PropertyActuator_mode_ADD = 1,
	PropertyActuator_mode_COPY = 2,
	PropertyActuator_mode_TOGGLE = 3,
	PropertyActuator_mode_LEVEL = 4,
};

int PropertyActuator_mode_get(PointerRNA *ptr);
void PropertyActuator_mode_set(PointerRNA *ptr, int value);

PointerRNA PropertyActuator_object_get(PointerRNA *ptr);

#define PropertyActuator_property_MAX 64

void PropertyActuator_property_get(PointerRNA *ptr, char *value);
int PropertyActuator_property_length(PointerRNA *ptr);
void PropertyActuator_property_set(PointerRNA *ptr, const char *value);

#define PropertyActuator_object_property_MAX 64

void PropertyActuator_object_property_get(PointerRNA *ptr, char *value);
int PropertyActuator_object_property_length(PointerRNA *ptr);
void PropertyActuator_object_property_set(PointerRNA *ptr, const char *value);

#define PropertyActuator_value_MAX 64

void PropertyActuator_value_get(PointerRNA *ptr, char *value);
int PropertyActuator_value_length(PointerRNA *ptr);
void PropertyActuator_value_set(PointerRNA *ptr, const char *value);

/**************** ID Property Group ****************/

extern StructRNA RNA_PropertyGroup;

PointerRNA PropertyGroup_rna_type_get(PointerRNA *ptr);

/**************** ID Property ****************/

extern StructRNA RNA_PropertyGroupItem;

PointerRNA PropertyGroupItem_rna_type_get(PointerRNA *ptr);

/**************** Property Sensor ****************/

extern StructRNA RNA_PropertySensor;
extern StructRNA RNA_Sensor;

enum {
	PropertySensor_evaluation_type_PROPEQUAL = 0,
	PropertySensor_evaluation_type_PROPNEQUAL = 1,
	PropertySensor_evaluation_type_PROPINTERVAL = 2,
	PropertySensor_evaluation_type_PROPCHANGED = 3,
	PropertySensor_evaluation_type_PROPLESSTHAN = 5,
	PropertySensor_evaluation_type_PROPGREATERTHAN = 6,
};

int PropertySensor_evaluation_type_get(PointerRNA *ptr);
void PropertySensor_evaluation_type_set(PointerRNA *ptr, int value);

#define PropertySensor_value_max_MAX 64

void PropertySensor_value_max_get(PointerRNA *ptr, char *value);
int PropertySensor_value_max_length(PointerRNA *ptr);
void PropertySensor_value_max_set(PointerRNA *ptr, const char *value);

#define PropertySensor_value_min_MAX 64

void PropertySensor_value_min_get(PointerRNA *ptr, char *value);
int PropertySensor_value_min_length(PointerRNA *ptr);
void PropertySensor_value_min_set(PointerRNA *ptr, const char *value);

#define PropertySensor_property_MAX 64

void PropertySensor_property_get(PointerRNA *ptr, char *value);
int PropertySensor_property_length(PointerRNA *ptr);
void PropertySensor_property_set(PointerRNA *ptr, const char *value);

#define PropertySensor_value_MAX 64

void PropertySensor_value_get(PointerRNA *ptr, char *value);
int PropertySensor_value_length(PointerRNA *ptr);
void PropertySensor_value_set(PointerRNA *ptr, const char *value);

/**************** Python Constraint ****************/

extern StructRNA RNA_PythonConstraint;
extern StructRNA RNA_Constraint;

int PythonConstraint_target_count_get(PointerRNA *ptr);
void PythonConstraint_target_count_set(PointerRNA *ptr, int value);

PointerRNA PythonConstraint_text_get(PointerRNA *ptr);

int PythonConstraint_has_script_error_get(PointerRNA *ptr);
void PythonConstraint_has_script_error_set(PointerRNA *ptr, int value);

void PythonConstraint_targets_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void PythonConstraint_targets_next(CollectionPropertyIterator *iter);
void PythonConstraint_targets_end(CollectionPropertyIterator *iter);
int PythonConstraint_targets_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int PythonConstraint_use_targets_get(PointerRNA *ptr);
void PythonConstraint_use_targets_set(PointerRNA *ptr, int value);

/**************** Python Controller ****************/

extern StructRNA RNA_PythonController;
extern StructRNA RNA_Controller;

int PythonController_use_debug_get(PointerRNA *ptr);
void PythonController_use_debug_set(PointerRNA *ptr, int value);

enum {
	PythonController_mode_SCRIPT = 0,
	PythonController_mode_MODULE = 1,
};

int PythonController_mode_get(PointerRNA *ptr);
void PythonController_mode_set(PointerRNA *ptr, int value);

#define PythonController_module_MAX 64

void PythonController_module_get(PointerRNA *ptr, char *value);
int PythonController_module_length(PointerRNA *ptr);
void PythonController_module_set(PointerRNA *ptr, const char *value);

PointerRNA PythonController_text_get(PointerRNA *ptr);

/**************** Radar Sensor ****************/

extern StructRNA RNA_RadarSensor;
extern StructRNA RNA_Sensor;

float RadarSensor_angle_get(PointerRNA *ptr);
void RadarSensor_angle_set(PointerRNA *ptr, float value);

enum {
	RadarSensor_axis_XAXIS = 0,
	RadarSensor_axis_YAXIS = 1,
	RadarSensor_axis_ZAXIS = 2,
	RadarSensor_axis_NEGXAXIS = 3,
	RadarSensor_axis_NEGYAXIS = 4,
	RadarSensor_axis_NEGZAXIS = 5,
};

int RadarSensor_axis_get(PointerRNA *ptr);
void RadarSensor_axis_set(PointerRNA *ptr, int value);

float RadarSensor_distance_get(PointerRNA *ptr);
void RadarSensor_distance_set(PointerRNA *ptr, float value);

#define RadarSensor_property_MAX 64

void RadarSensor_property_get(PointerRNA *ptr, char *value);
int RadarSensor_property_length(PointerRNA *ptr);
void RadarSensor_property_set(PointerRNA *ptr, const char *value);

/**************** Random Actuator ****************/

extern StructRNA RNA_RandomActuator;
extern StructRNA RNA_Actuator;

int RandomActuator_use_always_true_get(PointerRNA *ptr);
void RandomActuator_use_always_true_set(PointerRNA *ptr, int value);

float RandomActuator_chance_get(PointerRNA *ptr);
void RandomActuator_chance_set(PointerRNA *ptr, float value);

enum {
	RandomActuator_distribution_BOOL_CONSTANT = 0,
	RandomActuator_distribution_BOOL_UNIFORM = 1,
	RandomActuator_distribution_BOOL_BERNOUILLI = 2,
	RandomActuator_distribution_INT_CONSTANT = 3,
	RandomActuator_distribution_INT_UNIFORM = 4,
	RandomActuator_distribution_INT_POISSON = 5,
	RandomActuator_distribution_FLOAT_CONSTANT = 6,
	RandomActuator_distribution_FLOAT_UNIFORM = 7,
	RandomActuator_distribution_FLOAT_NORMAL = 8,
	RandomActuator_distribution_FLOAT_NEGATIVE_EXPONENTIAL = 9,
};

int RandomActuator_distribution_get(PointerRNA *ptr);
void RandomActuator_distribution_set(PointerRNA *ptr, int value);

float RandomActuator_half_life_time_get(PointerRNA *ptr);
void RandomActuator_half_life_time_set(PointerRNA *ptr, float value);

int RandomActuator_int_max_get(PointerRNA *ptr);
void RandomActuator_int_max_set(PointerRNA *ptr, int value);

float RandomActuator_float_max_get(PointerRNA *ptr);
void RandomActuator_float_max_set(PointerRNA *ptr, float value);

float RandomActuator_int_mean_get(PointerRNA *ptr);
void RandomActuator_int_mean_set(PointerRNA *ptr, float value);

float RandomActuator_float_mean_get(PointerRNA *ptr);
void RandomActuator_float_mean_set(PointerRNA *ptr, float value);

int RandomActuator_int_min_get(PointerRNA *ptr);
void RandomActuator_int_min_set(PointerRNA *ptr, int value);

float RandomActuator_float_min_get(PointerRNA *ptr);
void RandomActuator_float_min_set(PointerRNA *ptr, float value);

#define RandomActuator_property_MAX 64

void RandomActuator_property_get(PointerRNA *ptr, char *value);
int RandomActuator_property_length(PointerRNA *ptr);
void RandomActuator_property_set(PointerRNA *ptr, const char *value);

float RandomActuator_standard_derivation_get(PointerRNA *ptr);
void RandomActuator_standard_derivation_set(PointerRNA *ptr, float value);

int RandomActuator_seed_get(PointerRNA *ptr);
void RandomActuator_seed_set(PointerRNA *ptr, int value);

int RandomActuator_int_value_get(PointerRNA *ptr);
void RandomActuator_int_value_set(PointerRNA *ptr, int value);

float RandomActuator_float_value_get(PointerRNA *ptr);
void RandomActuator_float_value_set(PointerRNA *ptr, float value);

/**************** Random Sensor ****************/

extern StructRNA RNA_RandomSensor;
extern StructRNA RNA_Sensor;

int RandomSensor_seed_get(PointerRNA *ptr);
void RandomSensor_seed_set(PointerRNA *ptr, int value);

/**************** Ray Sensor ****************/

extern StructRNA RNA_RaySensor;
extern StructRNA RNA_Sensor;

enum {
	RaySensor_axis_XAXIS = 1,
	RaySensor_axis_YAXIS = 0,
	RaySensor_axis_ZAXIS = 2,
	RaySensor_axis_NEGXAXIS = 3,
	RaySensor_axis_NEGYAXIS = 4,
	RaySensor_axis_NEGZAXIS = 5,
};

int RaySensor_axis_get(PointerRNA *ptr);
void RaySensor_axis_set(PointerRNA *ptr, int value);

#define RaySensor_material_MAX 64

void RaySensor_material_get(PointerRNA *ptr, char *value);
int RaySensor_material_length(PointerRNA *ptr);
void RaySensor_material_set(PointerRNA *ptr, const char *value);

#define RaySensor_property_MAX 64

void RaySensor_property_get(PointerRNA *ptr, char *value);
int RaySensor_property_length(PointerRNA *ptr);
void RaySensor_property_set(PointerRNA *ptr, const char *value);

float RaySensor_range_get(PointerRNA *ptr);
void RaySensor_range_set(PointerRNA *ptr, float value);

enum {
	RaySensor_ray_type_PROPERTY = 0,
	RaySensor_ray_type_MATERIAL = 1,
};

int RaySensor_ray_type_get(PointerRNA *ptr);
void RaySensor_ray_type_set(PointerRNA *ptr, int value);

int RaySensor_use_x_ray_get(PointerRNA *ptr);
void RaySensor_use_x_ray_set(PointerRNA *ptr, int value);

/**************** Region ****************/

extern StructRNA RNA_Region;

PointerRNA Region_rna_type_get(PointerRNA *ptr);

int Region_height_get(PointerRNA *ptr);
void Region_height_set(PointerRNA *ptr, int value);

int Region_id_get(PointerRNA *ptr);
void Region_id_set(PointerRNA *ptr, int value);

enum {
	Region_type_WINDOW = 0,
	Region_type_HEADER = 1,
	Region_type_CHANNELS = 2,
	Region_type_TEMPORARY = 3,
	Region_type_UI = 4,
	Region_type_TOOLS = 5,
	Region_type_TOOL_PROPS = 6,
	Region_type_PREVIEW = 7,
};

int Region_type_get(PointerRNA *ptr);
void Region_type_set(PointerRNA *ptr, int value);

PointerRNA Region_view2d_get(PointerRNA *ptr);

int Region_width_get(PointerRNA *ptr);
void Region_width_set(PointerRNA *ptr, int value);

int Region_x_get(PointerRNA *ptr);
void Region_x_set(PointerRNA *ptr, int value);

int Region_y_get(PointerRNA *ptr);
void Region_y_set(PointerRNA *ptr, int value);

void Region_tag_redraw(struct ARegion *_self);
/**************** 3D View Region ****************/

extern StructRNA RNA_RegionView3D;

PointerRNA RegionView3D_rna_type_get(PointerRNA *ptr);

int RegionView3D_show_sync_view_get(PointerRNA *ptr);
void RegionView3D_show_sync_view_set(PointerRNA *ptr, int value);

void RegionView3D_view_camera_offset_get(PointerRNA *ptr, float values[2]);
void RegionView3D_view_camera_offset_set(PointerRNA *ptr, const float values[2]);

float RegionView3D_view_camera_zoom_get(PointerRNA *ptr);
void RegionView3D_view_camera_zoom_set(PointerRNA *ptr, float value);

int RegionView3D_use_box_clip_get(PointerRNA *ptr);
void RegionView3D_use_box_clip_set(PointerRNA *ptr, int value);

float RegionView3D_view_distance_get(PointerRNA *ptr);
void RegionView3D_view_distance_set(PointerRNA *ptr, float value);

int RegionView3D_is_perspective_get(PointerRNA *ptr);
void RegionView3D_is_perspective_set(PointerRNA *ptr, int value);

int RegionView3D_lock_rotation_get(PointerRNA *ptr);
void RegionView3D_lock_rotation_set(PointerRNA *ptr, int value);

enum {
	RegionView3D_view_perspective_PERSP = 1,
	RegionView3D_view_perspective_ORTHO = 0,
	RegionView3D_view_perspective_CAMERA = 2,
};

int RegionView3D_view_perspective_get(PointerRNA *ptr);
void RegionView3D_view_perspective_set(PointerRNA *ptr, int value);

void RegionView3D_perspective_matrix_get(PointerRNA *ptr, float values[16]);
void RegionView3D_perspective_matrix_set(PointerRNA *ptr, const float values[16]);

void RegionView3D_view_location_get(PointerRNA *ptr, float values[3]);
void RegionView3D_view_location_set(PointerRNA *ptr, const float values[3]);

void RegionView3D_view_matrix_get(PointerRNA *ptr, float values[16]);
void RegionView3D_view_matrix_set(PointerRNA *ptr, const float values[16]);

void RegionView3D_view_rotation_get(PointerRNA *ptr, float values[4]);
void RegionView3D_view_rotation_set(PointerRNA *ptr, const float values[4]);

void RegionView3D_update(struct ID *_selfid, struct RegionView3D *_self);
/**************** Remesh Modifier ****************/

extern StructRNA RNA_RemeshModifier;
extern StructRNA RNA_Modifier;

enum {
	RemeshModifier_mode_BLOCKS = 0,
	RemeshModifier_mode_SMOOTH = 1,
	RemeshModifier_mode_SHARP = 2,
};

int RemeshModifier_mode_get(PointerRNA *ptr);
void RemeshModifier_mode_set(PointerRNA *ptr, int value);

int RemeshModifier_octree_depth_get(PointerRNA *ptr);
void RemeshModifier_octree_depth_set(PointerRNA *ptr, int value);

int RemeshModifier_use_remove_disconnected_get(PointerRNA *ptr);
void RemeshModifier_use_remove_disconnected_set(PointerRNA *ptr, int value);

float RemeshModifier_scale_get(PointerRNA *ptr);
void RemeshModifier_scale_set(PointerRNA *ptr, float value);

float RemeshModifier_sharpness_get(PointerRNA *ptr);
void RemeshModifier_sharpness_set(PointerRNA *ptr, float value);

int RemeshModifier_use_smooth_shade_get(PointerRNA *ptr);
void RemeshModifier_use_smooth_shade_set(PointerRNA *ptr, int value);

float RemeshModifier_threshold_get(PointerRNA *ptr);
void RemeshModifier_threshold_set(PointerRNA *ptr, float value);

/**************** Render Engine ****************/

extern StructRNA RNA_RenderEngine;

PointerRNA RenderEngine_rna_type_get(PointerRNA *ptr);

PointerRNA RenderEngine_render_get(PointerRNA *ptr);

void RenderEngine_bl_idname_get(PointerRNA *ptr, char *value);
int RenderEngine_bl_idname_length(PointerRNA *ptr);
void RenderEngine_bl_idname_set(PointerRNA *ptr, const char *value);

void RenderEngine_bl_label_get(PointerRNA *ptr, char *value);
int RenderEngine_bl_label_length(PointerRNA *ptr);
void RenderEngine_bl_label_set(PointerRNA *ptr, const char *value);

int RenderEngine_bl_use_exclude_layers_get(PointerRNA *ptr);
void RenderEngine_bl_use_exclude_layers_set(PointerRNA *ptr, int value);

int RenderEngine_bl_use_postprocess_get(PointerRNA *ptr);
void RenderEngine_bl_use_postprocess_set(PointerRNA *ptr, int value);

int RenderEngine_bl_use_preview_get(PointerRNA *ptr);
void RenderEngine_bl_use_preview_set(PointerRNA *ptr, int value);

int RenderEngine_bl_use_save_buffers_get(PointerRNA *ptr);
void RenderEngine_bl_use_save_buffers_set(PointerRNA *ptr, int value);

int RenderEngine_bl_use_shading_nodes_get(PointerRNA *ptr);
void RenderEngine_bl_use_shading_nodes_set(PointerRNA *ptr, int value);

int RenderEngine_bl_use_texture_preview_get(PointerRNA *ptr);
void RenderEngine_bl_use_texture_preview_set(PointerRNA *ptr, int value);

PointerRNA RenderEngine_camera_override_get(PointerRNA *ptr);

int RenderEngine_is_animation_get(PointerRNA *ptr);
void RenderEngine_is_animation_set(PointerRNA *ptr, int value);

int RenderEngine_is_preview_get(PointerRNA *ptr);
void RenderEngine_is_preview_set(PointerRNA *ptr, int value);

void RenderEngine_layer_override_get(PointerRNA *ptr, int values[20]);
void RenderEngine_layer_override_set(PointerRNA *ptr, const int values[20]);

int RenderEngine_resolution_x_get(PointerRNA *ptr);
void RenderEngine_resolution_x_set(PointerRNA *ptr, int value);

int RenderEngine_resolution_y_get(PointerRNA *ptr);
void RenderEngine_resolution_y_set(PointerRNA *ptr, int value);

int RenderEngine_tile_x_get(PointerRNA *ptr);
void RenderEngine_tile_x_set(PointerRNA *ptr, int value);

int RenderEngine_tile_y_get(PointerRNA *ptr);
void RenderEngine_tile_y_set(PointerRNA *ptr, int value);

int RenderEngine_use_highlight_tiles_get(PointerRNA *ptr);
void RenderEngine_use_highlight_tiles_set(PointerRNA *ptr, int value);

void RenderEngine_update(struct RenderEngine *_self, struct BlendData *data, struct Scene *scene);
void RenderEngine_render(struct RenderEngine *_self, struct Scene *scene);
void RenderEngine_bake(struct RenderEngine *_self, struct Scene *scene, struct Object *object, int pass_type, struct BakePixel *pixel_array, int num_pixels, int depth, struct AnyType *result);
void RenderEngine_view_update(struct RenderEngine *_self, struct bContext *context);
void RenderEngine_view_draw(struct RenderEngine *_self, struct bContext *context);
void RenderEngine_update_script_node(struct RenderEngine *_self, struct PointerRNA *node);
void RenderEngine_tag_redraw(struct RenderEngine *_self);
void RenderEngine_tag_update(struct RenderEngine *_self);
struct RenderResult *RenderEngine_begin_result(struct RenderEngine *_self, int x, int y, int w, int h, const char * layer);
void RenderEngine_update_result(struct RenderEngine *_self, struct RenderResult *result);
void RenderEngine_end_result(struct RenderEngine *_self, struct RenderResult *result, int cancel, int do_merge_results);
int RenderEngine_test_break(struct RenderEngine *_self);
void RenderEngine_update_stats(struct RenderEngine *_self, const char * stats, const char * info);
void RenderEngine_frame_set(struct RenderEngine *_self, int frame, float subframe);
void RenderEngine_update_progress(struct RenderEngine *_self, float progress);
void RenderEngine_update_memory_stats(struct RenderEngine *_self, float memory_used, float memory_peak);
void RenderEngine_report(struct RenderEngine *_self, int type, const char * message);
void RenderEngine_bind_display_space_shader(struct RenderEngine *_self, struct Scene *scene);
void RenderEngine_unbind_display_space_shader(struct RenderEngine *_self);
int RenderEngine_support_display_space_shader(struct RenderEngine *_self, struct Scene *scene);
/**************** Render Layer ****************/

extern StructRNA RNA_RenderLayer;

PointerRNA RenderLayer_rna_type_get(PointerRNA *ptr);

void RenderLayer_name_get(PointerRNA *ptr, char *value);
int RenderLayer_name_length(PointerRNA *ptr);
void RenderLayer_name_set(PointerRNA *ptr, const char *value);

int RenderLayer_use_pass_ambient_occlusion_get(PointerRNA *ptr);
void RenderLayer_use_pass_ambient_occlusion_set(PointerRNA *ptr, int value);

int RenderLayer_exclude_ambient_occlusion_get(PointerRNA *ptr);
void RenderLayer_exclude_ambient_occlusion_set(PointerRNA *ptr, int value);

int RenderLayer_use_all_z_get(PointerRNA *ptr);
void RenderLayer_use_all_z_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_color_get(PointerRNA *ptr);
void RenderLayer_use_pass_color_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_combined_get(PointerRNA *ptr);
void RenderLayer_use_pass_combined_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_diffuse_get(PointerRNA *ptr);
void RenderLayer_use_pass_diffuse_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_diffuse_color_get(PointerRNA *ptr);
void RenderLayer_use_pass_diffuse_color_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_diffuse_direct_get(PointerRNA *ptr);
void RenderLayer_use_pass_diffuse_direct_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_diffuse_indirect_get(PointerRNA *ptr);
void RenderLayer_use_pass_diffuse_indirect_set(PointerRNA *ptr, int value);

int RenderLayer_use_edge_enhance_get(PointerRNA *ptr);
void RenderLayer_use_edge_enhance_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_emit_get(PointerRNA *ptr);
void RenderLayer_use_pass_emit_set(PointerRNA *ptr, int value);

int RenderLayer_exclude_emit_get(PointerRNA *ptr);
void RenderLayer_exclude_emit_set(PointerRNA *ptr, int value);

int RenderLayer_use_get(PointerRNA *ptr);
void RenderLayer_use_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_environment_get(PointerRNA *ptr);
void RenderLayer_use_pass_environment_set(PointerRNA *ptr, int value);

int RenderLayer_exclude_environment_get(PointerRNA *ptr);
void RenderLayer_exclude_environment_set(PointerRNA *ptr, int value);

void RenderLayer_layers_exclude_get(PointerRNA *ptr, int values[20]);
void RenderLayer_layers_exclude_set(PointerRNA *ptr, const int values[20]);

int RenderLayer_use_freestyle_get(PointerRNA *ptr);
void RenderLayer_use_freestyle_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_glossy_color_get(PointerRNA *ptr);
void RenderLayer_use_pass_glossy_color_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_glossy_direct_get(PointerRNA *ptr);
void RenderLayer_use_pass_glossy_direct_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_glossy_indirect_get(PointerRNA *ptr);
void RenderLayer_use_pass_glossy_indirect_set(PointerRNA *ptr, int value);

int RenderLayer_use_halo_get(PointerRNA *ptr);
void RenderLayer_use_halo_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_indirect_get(PointerRNA *ptr);
void RenderLayer_use_pass_indirect_set(PointerRNA *ptr, int value);

int RenderLayer_exclude_indirect_get(PointerRNA *ptr);
void RenderLayer_exclude_indirect_set(PointerRNA *ptr, int value);

PointerRNA RenderLayer_light_override_get(PointerRNA *ptr);

int RenderLayer_use_pass_material_index_get(PointerRNA *ptr);
void RenderLayer_use_pass_material_index_set(PointerRNA *ptr, int value);

PointerRNA RenderLayer_material_override_get(PointerRNA *ptr);

int RenderLayer_use_pass_mist_get(PointerRNA *ptr);
void RenderLayer_use_pass_mist_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_normal_get(PointerRNA *ptr);
void RenderLayer_use_pass_normal_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_object_index_get(PointerRNA *ptr);
void RenderLayer_use_pass_object_index_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_reflection_get(PointerRNA *ptr);
void RenderLayer_use_pass_reflection_set(PointerRNA *ptr, int value);

int RenderLayer_exclude_reflection_get(PointerRNA *ptr);
void RenderLayer_exclude_reflection_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_refraction_get(PointerRNA *ptr);
void RenderLayer_use_pass_refraction_set(PointerRNA *ptr, int value);

int RenderLayer_exclude_refraction_get(PointerRNA *ptr);
void RenderLayer_exclude_refraction_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_shadow_get(PointerRNA *ptr);
void RenderLayer_use_pass_shadow_set(PointerRNA *ptr, int value);

int RenderLayer_exclude_shadow_get(PointerRNA *ptr);
void RenderLayer_exclude_shadow_set(PointerRNA *ptr, int value);

int RenderLayer_use_sky_get(PointerRNA *ptr);
void RenderLayer_use_sky_set(PointerRNA *ptr, int value);

int RenderLayer_use_solid_get(PointerRNA *ptr);
void RenderLayer_use_solid_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_specular_get(PointerRNA *ptr);
void RenderLayer_use_pass_specular_set(PointerRNA *ptr, int value);

int RenderLayer_exclude_specular_get(PointerRNA *ptr);
void RenderLayer_exclude_specular_set(PointerRNA *ptr, int value);

int RenderLayer_use_strand_get(PointerRNA *ptr);
void RenderLayer_use_strand_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_subsurface_color_get(PointerRNA *ptr);
void RenderLayer_use_pass_subsurface_color_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_subsurface_direct_get(PointerRNA *ptr);
void RenderLayer_use_pass_subsurface_direct_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_subsurface_indirect_get(PointerRNA *ptr);
void RenderLayer_use_pass_subsurface_indirect_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_transmission_color_get(PointerRNA *ptr);
void RenderLayer_use_pass_transmission_color_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_transmission_direct_get(PointerRNA *ptr);
void RenderLayer_use_pass_transmission_direct_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_transmission_indirect_get(PointerRNA *ptr);
void RenderLayer_use_pass_transmission_indirect_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_uv_get(PointerRNA *ptr);
void RenderLayer_use_pass_uv_set(PointerRNA *ptr, int value);

int RenderLayer_use_pass_vector_get(PointerRNA *ptr);
void RenderLayer_use_pass_vector_set(PointerRNA *ptr, int value);

void RenderLayer_layers_get(PointerRNA *ptr, int values[20]);
void RenderLayer_layers_set(PointerRNA *ptr, const int values[20]);

int RenderLayer_use_pass_z_get(PointerRNA *ptr);
void RenderLayer_use_pass_z_set(PointerRNA *ptr, int value);

int RenderLayer_use_ztransp_get(PointerRNA *ptr);
void RenderLayer_use_ztransp_set(PointerRNA *ptr, int value);

int RenderLayer_use_zmask_get(PointerRNA *ptr);
void RenderLayer_use_zmask_set(PointerRNA *ptr, int value);

void RenderLayer_layers_zmask_get(PointerRNA *ptr, int values[20]);
void RenderLayer_layers_zmask_set(PointerRNA *ptr, const int values[20]);

int RenderLayer_invert_zmask_get(PointerRNA *ptr);
void RenderLayer_invert_zmask_set(PointerRNA *ptr, int value);

void RenderLayer_passes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void RenderLayer_passes_next(CollectionPropertyIterator *iter);
void RenderLayer_passes_end(CollectionPropertyIterator *iter);

void RenderLayer_rect_get(PointerRNA *ptr, float values[]);
void RenderLayer_rect_set(PointerRNA *ptr, const float values[]);int RenderLayer_rect_get_length(PointerRNA *ptr, int *arraylen);

void RenderLayer_load_from_file(struct RenderLayer *_self, ReportList *reports, const char * filename, int x, int y);
/**************** Render Layers ****************/

extern StructRNA RNA_RenderLayers;

PointerRNA RenderLayers_rna_type_get(PointerRNA *ptr);

int RenderLayers_active_index_get(PointerRNA *ptr);
void RenderLayers_active_index_set(PointerRNA *ptr, int value);

PointerRNA RenderLayers_active_get(PointerRNA *ptr);

struct SceneRenderLayer *RenderLayers_new(struct ID *_selfid, struct RenderData *_self, const char * name);
void RenderLayers_remove(struct ID *_selfid, struct RenderData *_self, Main *bmain, ReportList *reports, struct PointerRNA *layer);
/**************** Render Pass ****************/

extern StructRNA RNA_RenderPass;

PointerRNA RenderPass_rna_type_get(PointerRNA *ptr);

void RenderPass_name_get(PointerRNA *ptr, char *value);
int RenderPass_name_length(PointerRNA *ptr);
void RenderPass_name_set(PointerRNA *ptr, const char *value);

void RenderPass_channel_id_get(PointerRNA *ptr, char *value);
int RenderPass_channel_id_length(PointerRNA *ptr);
void RenderPass_channel_id_set(PointerRNA *ptr, const char *value);

int RenderPass_channels_get(PointerRNA *ptr);
void RenderPass_channels_set(PointerRNA *ptr, int value);

enum {
	RenderPass_debug_type_BVH_TRAVERSAL_STEPS = 0,
};

int RenderPass_debug_type_get(PointerRNA *ptr);
void RenderPass_debug_type_set(PointerRNA *ptr, int value);

void RenderPass_rect_get(PointerRNA *ptr, float values[]);
void RenderPass_rect_set(PointerRNA *ptr, const float values[]);int RenderPass_rect_get_length(PointerRNA *ptr, int *arraylen);

enum {
	RenderPass_type_COMBINED = 1,
	RenderPass_type_Z = 2,
	RenderPass_type_COLOR = 4,
	RenderPass_type_DIFFUSE = 8,
	RenderPass_type_SPECULAR = 16,
	RenderPass_type_SHADOW = 32,
	RenderPass_type_AO = 64,
	RenderPass_type_REFLECTION = 128,
	RenderPass_type_NORMAL = 256,
	RenderPass_type_VECTOR = 512,
	RenderPass_type_REFRACTION = 1024,
	RenderPass_type_OBJECT_INDEX = 2048,
	RenderPass_type_UV = 4096,
	RenderPass_type_MIST = 16384,
	RenderPass_type_EMIT = 65536,
	RenderPass_type_ENVIRONMENT = 131072,
	RenderPass_type_MATERIAL_INDEX = 262144,
	RenderPass_type_DIFFUSE_DIRECT = 524288,
	RenderPass_type_DIFFUSE_INDIRECT = 1048576,
	RenderPass_type_DIFFUSE_COLOR = 2097152,
	RenderPass_type_GLOSSY_DIRECT = 4194304,
	RenderPass_type_GLOSSY_INDIRECT = 8388608,
	RenderPass_type_GLOSSY_COLOR = 16777216,
	RenderPass_type_TRANSMISSION_DIRECT = 33554432,
	RenderPass_type_TRANSMISSION_INDIRECT = 67108864,
	RenderPass_type_TRANSMISSION_COLOR = 134217728,
	RenderPass_type_SUBSURFACE_DIRECT = 268435456,
	RenderPass_type_SUBSURFACE_INDIRECT = 536870912,
	RenderPass_type_SUBSURFACE_COLOR = 1073741824,
};

int RenderPass_type_get(PointerRNA *ptr);
void RenderPass_type_set(PointerRNA *ptr, int value);

/**************** Render Result ****************/

extern StructRNA RNA_RenderResult;

PointerRNA RenderResult_rna_type_get(PointerRNA *ptr);

void RenderResult_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void RenderResult_layers_next(CollectionPropertyIterator *iter);
void RenderResult_layers_end(CollectionPropertyIterator *iter);

int RenderResult_resolution_x_get(PointerRNA *ptr);
void RenderResult_resolution_x_set(PointerRNA *ptr, int value);

int RenderResult_resolution_y_get(PointerRNA *ptr);
void RenderResult_resolution_y_set(PointerRNA *ptr, int value);

void RenderResult_load_from_file(struct RenderResult *_self, ReportList *reports, const char * filename);
/**************** Render Data ****************/

extern StructRNA RNA_RenderSettings;

PointerRNA RenderSettings_rna_type_get(PointerRNA *ptr);

enum {
	RenderSettings_alpha_mode_SKY = 0,
	RenderSettings_alpha_mode_TRANSPARENT = 1,
};

int RenderSettings_alpha_mode_get(PointerRNA *ptr);
void RenderSettings_alpha_mode_set(PointerRNA *ptr, int value);

int RenderSettings_use_antialiasing_get(PointerRNA *ptr);
void RenderSettings_use_antialiasing_set(PointerRNA *ptr, int value);

int RenderSettings_use_bake_antialiasing_get(PointerRNA *ptr);
void RenderSettings_use_bake_antialiasing_set(PointerRNA *ptr, int value);

enum {
	RenderSettings_bake_aa_mode_5 = 5,
	RenderSettings_bake_aa_mode