

/** \returns an expression of the coefficient-wise absolute value of \c *this
  *
  * Example: \include Cwise_abs.cpp
  * Output: \verbinclude Cwise_abs.out
  *
  * \sa abs2()
  */
EIGEN_STRONG_INLINE const CwiseUnaryOp<ei_scalar_abs_op<Scalar>, Derived>
abs() const
{
  return derived();
}

/** \returns an expression of the coefficient-wise squared absolute value of \c *this
  *
  * Example: \include Cwise_abs2.cpp
  * Output: \verbinclude Cwise_abs2.out
  *
  * \sa abs(), square()
  */
EIGEN_STRONG_INLINE const CwiseUnaryOp<ei_scalar_abs2_op<Scalar>, Derived>
abs2() const
{
  return derived();
}

/** \returns an expression of the coefficient-wise exponential of *this.
  *
  * Example: \include Cwise_exp.cpp
  * Output: \verbinclude Cwise_exp.out
  *
  * \sa pow(), log(), sin(), cos()
  */
inline const CwiseUnaryOp<ei_scalar_exp_op<Scalar>, Derived>
exp() const
{
  return derived();
}

/** \returns an expression of the coefficient-wise logarithm of *this.
  *
  * Example: \include Cwise_log.cpp
  * Output: \verbinclude Cwise_log.out
  *
  * \sa exp()
  */
inline const CwiseUnaryOp<ei_scalar_log_op<Scalar>, Derived>
log() const
{
  return derived();
}

/** \returns an expression of the coefficient-wise square root of *this.
  *
  * Example: \include Cwise_sqrt.cpp
  * Output: \verbinclude Cwise_sqrt.out
  *
  * \sa pow(), square()
  */
inline const CwiseUnaryOp<ei_scalar_sqrt_op<Scalar>, Derived>
sqrt() const
{
  return derived();
}

/** \returns an expression of the coefficient-wise cosine of *this.
  *
  * Example: \include Cwise_cos.cpp
  * Output: \verbinclude Cwise_cos.out
  *
  * \sa sin(), exp()
  */
inline const CwiseUnaryOp<ei_scalar_cos_op<Scalar>, Derived>
cos() const
{
  return derived();
}


/** \returns an expression of the coefficient-wise sine of *this.
  *
  * Example: \include Cwise_sin.cpp
  * Output: \verbinclude Cwise_sin.out
  *
  * \sa cos(), exp()
  */
inline const CwiseUnaryOp<ei_scalar_sin_op<Scalar>, Derived>
sin() const
{
  return derived();
}


/** \returns an expression of the coefficient-wise power of *this to the given exponent.
  *
  * Example: \include Cwise_pow.cpp
  * Output: \verbinclude Cwise_pow.out
  *
  * \sa exp(), log()
  */
inline const CwiseUnaryOp<ei_scalar_pow_op<Scalar>, Derived>
pow(const Scalar& exponent) const
{
  return CwiseUnaryOp<ei_scalar_pow_op<Scalar>,Derived>
          (derived(), ei_scalar_pow_op<Scalar>(exponent));
}


/** \returns an expression of the coefficient-wise inverse of *this.
  *
  * Example: \include Cwise_inverse.cpp
  * Output: \verbinclude Cwise_inverse.out
  *
  * \sa operator/(), operator*()
  */
inline const CwiseUnaryOp<ei_scalar_inverse_op<Scalar>, Derived>
inverse() const
{
  return derived();
}

/** \returns an expression of the coefficient-wise square of *this.
  *
  * Example: \include Cwise_square.cpp
  * Output: \verbinclude Cwise_square.out
  *
  * \sa operator/(), operator*(), abs2()
  */
inline const CwiseUnaryOp<ei_scalar_square_op<Scalar>, Derived>
square() const
{
  return derived();
}

/** \returns an expression of the coefficient-wise cube of *this.
  *
  * Example: \include Cwise_cube.cpp
  * Output: \verbinclude Cwise_cube.out
  *
  * \sa square(), pow()
  */
inline const CwiseUnaryOp<ei_scalar_cube_op<Scalar>, Derived>
cube() const
{
  return derived();
}

#define EIGEN_MAKE_SCALAR_CWISE_UNARY_OP(METHOD_NAME,FUNCTOR) \
  inline const CwiseUnaryOp<std::binder2nd<FUNCTOR<Scalar> >,Derived> \
  METHOD_NAME(const Scalar& s) const { \
    return CwiseUnaryOp<std::binder2nd<FUNCTOR<Scalar> >,Derived> \
            (derived(), std::bind2nd(FUNCTOR<Scalar>(), s)); \
  }

EIGEN_MAKE_SCALAR_CWISE_UNARY_OP(operator==,  std::equal_to)
EIGEN_MAKE_SCALAR_CWISE_UNARY_OP(operator!=,  std::not_equal_to)
EIGEN_MAKE_SCALAR_CWISE_UNARY_OP(operator<,   std::less)
EIGEN_MAKE_SCALAR_CWISE_UNARY_OP(operator<=,  std::less_equal)
EIGEN_MAKE_SCALAR_CWISE_UNARY_OP(operator>,   std::greater)
EIGEN_MAKE_SCALAR_CWISE_UNARY_OP(operator>=,  std::greater_equal)

