#! /bin/tcsh -f
#
#=======================================================================
#
#  run-pc.csh
#
#  Generic batch submission script for PC-linux using PBS.  
#
#-----------------------------------------------------------------------
# Batch options for machine with PBS batch system. (anchorage)
# Usage for Lahey compiler (default): 
#   qsub run-pc.csh
# Usage for pgf90 compiler with pgcc: 
#   env OPT_BLD=pgf90-pgcc qsub run-pc.csh
#-----------------------------------------------------------------------
#
# Name of the queue (CHANGE THIS if needed)
#PBS -q long
# Number of nodes & procs/node - must have ecc memory (CHANGE THIS if needed)
#PBS -l nodes=2:ppn=2
# output file base name
#PBS -N run-pc
# Put standard error and standard out in same file
#PBS -j oe
# Export all Environment variables
#PBS -V
# End of options
#=======================================================================

##extract number of tasks from batch environment
set ntasks = `wc -l $PBS_NODEFILE`
set ntasks = $ntasks[1]

set OS = `uname -s`;
switch ( $OS )
  case Linux:
     if ( ! $?PBS_JOBID ) then
       echo "${0}: ERROR::  This batch script must be submitted via PBS";
       echo "${0}:          on a Linux machine\!";
       exit;
     else
       echo "${0}: Running CAM on Linux using PBS";
     endif

     setenv PGI /usr/local/pgi
     setenv LAHEY /usr/local/lf95
     setenv LD_LIBRARY_PATH ${PGI}/linux86/6.1/lib:${LAHEY}/lib:/cluster/torque/lib:${LD_LIBRARY_PATH}

     if ( ! $?OPT_BLD ) then
       set netcdf = /usr/local/netcdf-gcc-lf95
       setenv INC_NETCDF ${netcdf}/include
       setenv LIB_NETCDF ${netcdf}/lib
       set mpich = /usr/local/mpich-lf95
       setenv INC_MPI ${mpich}/include
       setenv LIB_MPI ${mpich}/lib
       setenv PATH ${LAHEY}/bin:${mpich}/bin:${PATH}
       set cfg_string = "-fc lf95"
     else
       set netcdf = /usr/local/netcdf-pgi
       setenv INC_NETCDF ${netcdf}/include
       setenv LIB_NETCDF ${netcdf}/lib
       set mpich = /usr/local/mpich-pgi
       setenv INC_MPI ${mpich}/include
       setenv LIB_MPI ${mpich}/lib
       setenv PATH ${PGI}/linux86/6.1/bin:${mpich}/bin:${PATH}
       set cfg_string = ""
     endif
     breaksw;
  default:
    echo "${0}: This script meant for running CAM on Linux machines";    exit;
endsw

## Do our best to get sufficient stack memory
limit stacksize unlimited

## ROOT OF CAM DISTRIBUTION - probably needs to be customized.
## Contains the source code for the CAM distribution.
## (the root directory contains the subdirectory "models")
set camroot      = /fs/cgd/...

## ROOT OF CAM DATA DISTRIBUTION - needs to be customized unless running at NCAR.
## Contains the initial and boundary data for the CAM distribution.
## (the root directory contains the subdirectories "atm" and "lnd")
setenv CSMDATA     /fs/cgd/csm/inputdata

## LOGNAME - used in default settings, must be set if not available
## setenv LOGNAME <username>
if !($?LOGNAME) then
    echo "environment variable, LOGNAME required for setting of defaults - exiting"
    exit 1
endif

## Default namelist settings:
## $case is the case identifier for this run. It will be placed in the namelist.
## $runtype is the run type: startup, continue, or branch.
## $stop_n is the number of days to integrate (units depends on stop_option)
set case         = camrun
set runtype      = startup
set stop_n       = 1

## $wrkdir is a working directory where the model will be built and run.
## $blddir is the directory where model will be compiled.
## $rundir is the directory where the model will be run.
## $cfgdir is the directory containing the CAM configuration scripts.
set wrkdir       = /scratch/cluster/$LOGNAME
set blddir       = $wrkdir/$case/bld
set rundir       = $wrkdir/$case
set cfgdir       = $camroot/models/atm/cam/bld
set archdir      = $camroot/scripts/ccsm_utils/Tools/archiving

## Ensure that run and build directories exist
mkdir -p $rundir                || echo "cannot create $rundir" && exit 1
mkdir -p $blddir                || echo "cannot create $blddir" && exit 1

## If an executable doesn't exist, build one.
if ( ! -x $blddir/cam ) then
    cd $blddir                  || echo "cd $blddir failed" && exit 1
    $cfgdir/configure $cfg_string -spmd -ntasks $ntasks    || echo "configure failed" && exit 1
    echo "building CAM in $blddir ..."
    rm -f Depends
    gmake >&! MAKE.out      || echo "CAM build failed: see $blddir/MAKE.out" && exit 1
endif

## Create the namelist
cd $blddir                      || echo "cd $blddir failed" && exit 1
$cfgdir/build-namelist -s -case $case -runtype $runtype \
 -namelist "&camexp stop_option='ndays', stop_n=$stop_n /"  || echo "build-namelist failed" && exit 1

## Run CAM
cd $rundir                      || echo "cd $rundir failed" && exit 1
mv $blddir/*in .
echo "running CAM in $rundir"
mpiexec -n $ntasks $blddir/cam             || echo "CAM run failed" && exit 1

## POST-PROCESSING vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
## see the README in the archiving dir for more info how to use these scripts

## SHORT-TERM ARCHIVE SETTINGS
setenv STA_ROOT $wrkdir               #root path - required
setenv STA_SAVE_INTERIM_RFILES FALSE  #false->will archive only restart files from end of block run

## LONG-TERM ARCHIVE SETTINGS
set uc_logname = `sh -c 'echo ${LOGNAME} | tr [a-z] [A-Z]'`
setenv LTA_ROOT /${uc_logname}/csm    #root path - required
setenv LTA_RETENTION 365              #retention period (days)
setenv LTA_INTEGRITY HIGH             #archival validated by file comparison (vs NORMAL where its by file size only)
setenv LTA_COS rel=ec                 #ec->economy class of service (just one copy archived)

## GENERAL ARCHIVING SETTINGS
setenv ARCH_CASE $case                #casename - required

## call to short-term archive script
$archdir/st_archive.sh

## call to long-term archive script - will spawn batch job
$archdir/lt_archive.sh -f

exit 0
