!
! This module should 'use' only module 'kinds'
!
module physical_constants
  ! ------------------------------
  use kinds, only : real_kind, longdouble_kind
#ifdef CAM
  use shr_const_mod
#endif
  ! -----------------------------
  implicit none

  private
#ifdef CAM
  real (kind=real_kind), public, parameter :: DD_PI = shr_const_pi
  real (kind=longdouble_kind), public, parameter :: QQ_PI = 3.141592653589793238462643383279_longdouble_kind
  real (kind=real_kind), public, parameter :: g            = shr_const_G      ! m s^-2
  real (kind=real_kind), public, parameter :: rearth       = shr_const_rearth        ! m
  real (kind=real_kind), public, parameter :: omega        = SHR_CONST_OMEGA       ! s^-1

  real (kind=real_kind), public, parameter :: Rgas         = SHR_CONST_RDAIR
        
  real (kind=real_kind), public, parameter :: Cp           = SHR_CONST_CPDAIR
  real (kind=real_kind), public, parameter :: p0           = SHR_CONST_PSTD/100.0_real_kind ! surface pressure (mbar)
  real(kind=real_kind), public,parameter   :: MWDAIR       = SHR_CONST_MWDAIR
  real (kind=real_kind), public, parameter :: Rwater_vapor = SHR_CONST_RWV
  real (kind=real_kind), public, parameter :: Cpwater_vapor= SHR_CONST_CPWV
#else
  real (kind=real_kind), public, parameter :: DD_PI = 3.141592653589793238462643383279_real_kind
  real (kind=longdouble_kind), public, parameter :: QQ_PI = 3.141592653589793238462643383279_longdouble_kind
  real (kind=real_kind), public, parameter :: g            = 9.80616D0       ! m s^-2
  real (kind=real_kind), public, parameter :: rearth       = 6.376D6         ! m
  real (kind=real_kind), public, parameter :: omega        = 7.292D-5        ! s^-1
  real (kind=real_kind), public, parameter :: Rgas         = 287.04D0        
  real (kind=real_kind), public, parameter :: Cp           = 1005.0D0
  real (kind=real_kind), public, parameter :: p0           = 100000.0D0        ! surface pressure (mbar)
  real(kind=real_kind), public,parameter   :: MWDAIR       = 28.966D0
  real (kind=real_kind), public, parameter :: Rwater_vapor = 461.50D0
  real (kind=real_kind), public, parameter :: Cpwater_vapor= 1870.0D0 !ASC ANDII VERIFY PLS
#endif
  real (kind=real_kind), public, parameter :: rrearth      = 1.0_real_kind/rearth         ! m
  real (kind=real_kind), public, parameter :: kappa        = Rgas/Cp
  real (kind=real_kind), public, parameter :: Rd_on_Rv     = Rgas/Rwater_vapor	
  real (kind=real_kind), public, parameter :: Cpd_on_Cpv     = Cp/Cpwater_vapor

end module physical_constants
