#!/bin/sh 
#

if [ $# -ne 3 ]; then
    echo "TCT_ccsmseq.sh: incorrect number of input arguments" 
    exit 1
fi

echo "TCT.ccsm.sh: creating seq-ccsm test - output from create_test follows..."

cd ${CLM_SCRIPTDIR}/../../../../../scripts

test_name="TCT_ccsmseq.${1}.${2}.${3}.${CCSM_MACH}"

if [ -f ${CLM_TESTDIR}/${test_name}/TestStatus ]; then
    if grep -c PASS ${CLM_TESTDIR}/${test_name}/TestStatus > /dev/null; then
        echo "TCT_ccsmseq.sh: sequential CCSM create test has already passed; results are in "
	echo "        ${CLM_TESTDIR}/${test_name}" 
        exit 0
    elif grep -c GEN ${CLM_TESTDIR}/${test_name}/TestStatus > /dev/null; then
        echo "TCT_ccsmseq.sh: test already generated"
    else
	read fail_msg < ${CLM_TESTDIR}/${test_name}/TestStatus
        prev_jobid=${fail_msg#*job}

	if [ $JOBID = $prev_jobid ]; then
            echo "TCT_ccsmseq.sh: sequential CCSM create test has already failed for this job - will not reattempt; "
	    echo "        results are in: ${CLM_TESTDIR}/${test_name}" 
	    exit 2
	else
	    echo "TCT_ccsmseq.sh: this sequential CCSM create test failed under job ${prev_jobid} - moving those results to "
	    echo "        ${CLM_TESTDIR}/${test_name}_FAIL.job$prev_jobid and trying again"
            cp -rp ${CLM_TESTDIR}/${test_name} ${CLM_TESTDIR}/${test_name}_FAIL.job$prev_jobid
        fi
    fi
fi

if [ -d ${CLM_TESTDIR}/${test_name} ] && [ $CLM_RETAIN_FILES != "TRUE" ]; then
    echo "TCT.ccsm.sh: removing old ccsm test directories"
    rm -rf ${CLM_TESTDIR}/${test_name}
fi


blddir=${CLM_TESTDIR}/${test_name}

echo "blddir: $blddir"

if [ -d ${blddir} ] && [ $CLM_RETAIN_FILES != "TRUE" ]; then
    rm -r ${blddir}
fi
mkdir -p ${blddir} 
if [ $? -ne 0 ]; then
    echo "TCT_ccsmseq.sh: error, unable to create work subdirectory" 
    exit 3
fi

echo "cat env_pes.xml"

cat > ${CLM_TESTDIR}/env_pes.xml << EOF
<?xml version="1.0"?>

<pesinfo>

<!-------------------------------------------------------------------------------
 tasks/thread setup -- default
 ------------------------------------------------------------------------------->

<pes>
    <NTASKS_ATM>$CLM_TASKS</NTASKS_ATM> <NTHRDS_ATM>1</NTHRDS_ATM> <ROOTPE_ATM>0</ROOTPE_ATM>
    <NTASKS_LND>\$NTASKS_ATM</NTASKS_LND> <NTHRDS_LND>1</NTHRDS_LND> <ROOTPE_LND>0</ROOTPE_LND>
    <NTASKS_ICE>\$NTASKS_ATM</NTASKS_ICE> <NTHRDS_ICE>1</NTHRDS_ICE> <ROOTPE_ICE>0</ROOTPE_ICE>
    <NTASKS_OCN>\$NTASKS_ATM</NTASKS_OCN> <NTHRDS_OCN>1</NTHRDS_OCN> <ROOTPE_OCN>0</ROOTPE_OCN>
    <NTASKS_CPL>\$NTASKS_ATM</NTASKS_CPL> <NTHRDS_CPL>1</NTHRDS_CPL> <ROOTPE_CPL>0</ROOTPE_CPL>
    <NTASKS_GLC>\$NTASKS_ATM</NTASKS_GLC> <NTHRDS_GLC>1</NTHRDS_GLC> <ROOTPE_GLC>0</ROOTPE_GLC>
    <PES_LEVEL>0</PES_LEVEL>
</pes>

</pesinfo>
EOF

echo "./create_test -testname $1.$2.$3.${CCSM_MACH} -testroot ${CLM_TESTDIR} -testid \"sc.${JOBID}\" -clean off -pes_file ${CLM_TESTDIR}/env_pes.xml"
./create_test -testname $1.$2.$3.${CCSM_MACH} -testroot ${CLM_TESTDIR} \
    -testid "sc.${JOBID}" -clean off -pes_file ${CLM_TESTDIR}/env_pes.xml
rc=$?
echo "rc = $rc"
if [ $rc -ne 0 ]; then
    echo "TCT_ccsmseq.sh: create_test failed, error= $rc"
    echo "FAIL.job${JOBID}" > ${CLM_TESTDIR}/${test_name}/TestStatus
    exit 5
else
    echo "TCT_ccsmseq.sh: sequential ccsm create test completed successfully"
    echo "PASS" > ${CLM_TESTDIR}/${test_name}/TestStatus
fi
exit 0
