#!/bin/bash
# Simple build script, potentially useful if building a GPL-redistributable
# version on a system *without* SPEC CPU2017.  See:
#
#     https://www.spec.org/cpu2017/Docs/licenses.html#GPLtarballs
#
# Note: if the benchmark uses "specpp", that is the freely-redistributable
#       preprocessor "filepp".   It is described at 
#         https://www.spec.org/cpu2017/Docs/utility.html#specpp  
#       and will need to be in your path.  You can find filepp sources as
#       modified by SPEC in redistributable_sources/modified/tools.src/harness-spec.tar.xz 
#---------------------------------------------------------------------------

/usr/bin/gcc     -std=c99   -m64 -c -o main.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  main.c
/usr/bin/gcc     -std=c99   -m64 -c -o cc1-checksum.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cc1-checksum.c
/usr/bin/gcc     -std=c99   -m64 -c -o alias.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  alias.c
/usr/bin/gcc     -std=c99   -m64 -c -o alloca.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  alloca.c
/usr/bin/gcc     -std=c99   -m64 -c -o alloc-pool.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  alloc-pool.c
/usr/bin/gcc     -std=c99   -m64 -c -o argv.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  argv.c
/usr/bin/gcc     -std=c99   -m64 -c -o attribs.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  attribs.c
/usr/bin/gcc     -std=c99   -m64 -c -o auto-inc-dec.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  auto-inc-dec.c
/usr/bin/gcc     -std=c99   -m64 -c -o bb-reorder.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  bb-reorder.c
/usr/bin/gcc     -std=c99   -m64 -c -o bid2dpd_dpd2bid.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  bid2dpd_dpd2bid.c
/usr/bin/gcc     -std=c99   -m64 -c -o bitmap.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  bitmap.c
/usr/bin/gcc     -std=c99   -m64 -c -o bt-load.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  bt-load.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-lang.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-lang.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-errors.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-errors.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-lex.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-lex.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-pragma.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-pragma.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-decl.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-decl.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-typeck.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-typeck.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-convert.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-convert.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-aux-info.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-aux-info.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-common.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-common.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-opts.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-opts.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-format.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-format.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-semantics.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-semantics.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-ppoutput.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-ppoutput.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-objc-common.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-objc-common.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-dump.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-dump.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-parser.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-parser.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-gimplify.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-gimplify.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-pretty-print.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-pretty-print.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-omp.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-omp.c
/usr/bin/gcc     -std=c99   -m64 -c -o caller-save.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  caller-save.c
/usr/bin/gcc     -std=c99   -m64 -c -o calls.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  calls.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfg.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfg.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfganal.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfganal.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfgbuild.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfgbuild.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfgcleanup.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfgcleanup.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfgexpand.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfgexpand.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfghooks.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfghooks.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfglayout.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfglayout.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfgloop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfgloop.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfgloopanal.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfgloopanal.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfgloopmanip.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfgloopmanip.c
/usr/bin/gcc     -std=c99   -m64 -c -o cfgrtl.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cfgrtl.c
/usr/bin/gcc     -std=c99   -m64 -c -o cgraph.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cgraph.c
/usr/bin/gcc     -std=c99   -m64 -c -o cgraphbuild.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cgraphbuild.c
/usr/bin/gcc     -std=c99   -m64 -c -o cgraphunit.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cgraphunit.c
/usr/bin/gcc     -std=c99   -m64 -c -o combine.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  combine.c
/usr/bin/gcc     -std=c99   -m64 -c -o combine-stack-adj.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  combine-stack-adj.c
/usr/bin/gcc     -std=c99   -m64 -c -o concat.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  concat.c
/usr/bin/gcc     -std=c99   -m64 -c -o convert.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  convert.c
/usr/bin/gcc     -std=c99   -m64 -c -o coverage.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  coverage.c
/usr/bin/gcc     -std=c99   -m64 -c -o cp-demangle.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cp-demangle.c
/usr/bin/gcc     -std=c99   -m64 -c -o cp-demint.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cp-demint.c
/usr/bin/gcc     -std=c99   -m64 -c -o cplus-dem.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cplus-dem.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_directives.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_directives.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_lex.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_lex.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_errors.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_errors.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_expr.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_expr.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_charset.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_charset.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_macro.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_macro.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_traditional.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_traditional.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_line-map.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_line-map.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_symtab.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_symtab.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_identifiers.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_identifiers.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_mkdeps.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_mkdeps.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_pch.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_pch.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_directives-only.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_directives-only.c
/usr/bin/gcc     -std=c99   -m64 -c -o crc32.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  crc32.c
/usr/bin/gcc     -std=c99   -m64 -c -o cse.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cse.c
/usr/bin/gcc     -std=c99   -m64 -c -o cselib.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cselib.c
/usr/bin/gcc     -std=c99   -m64 -c -o dbxout.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dbxout.c
/usr/bin/gcc     -std=c99   -m64 -c -o dbgcnt.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dbgcnt.c
/usr/bin/gcc     -std=c99   -m64 -c -o dce.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dce.c
/usr/bin/gcc     -std=c99   -m64 -c -o ddg.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ddg.c
/usr/bin/gcc     -std=c99   -m64 -c -o debug.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  debug.c
/usr/bin/gcc     -std=c99   -m64 -c -o decContext.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  decContext.c
/usr/bin/gcc     -std=c99   -m64 -c -o decimal128.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  decimal128.c
/usr/bin/gcc     -std=c99   -m64 -c -o decimal32.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  decimal32.c
/usr/bin/gcc     -std=c99   -m64 -c -o decimal64.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  decimal64.c
/usr/bin/gcc     -std=c99   -m64 -c -o decNumber.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  decNumber.c
/usr/bin/gcc     -std=c99   -m64 -c -o df-byte-scan.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  df-byte-scan.c
/usr/bin/gcc     -std=c99   -m64 -c -o df-core.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  df-core.c
/usr/bin/gcc     -std=c99   -m64 -c -o df-problems.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  df-problems.c
/usr/bin/gcc     -std=c99   -m64 -c -o df-scan.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  df-scan.c
/usr/bin/gcc     -std=c99   -m64 -c -o dfp.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dfp.c
/usr/bin/gcc     -std=c99   -m64 -c -o diagnostic.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  diagnostic.c
/usr/bin/gcc     -std=c99   -m64 -c -o dojump.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dojump.c
/usr/bin/gcc     -std=c99   -m64 -c -o dominance.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dominance.c
/usr/bin/gcc     -std=c99   -m64 -c -o domwalk.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  domwalk.c
/usr/bin/gcc     -std=c99   -m64 -c -o double-int.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  double-int.c
/usr/bin/gcc     -std=c99   -m64 -c -o dse.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dse.c
/usr/bin/gcc     -std=c99   -m64 -c -o dwarf2asm.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dwarf2asm.c
/usr/bin/gcc     -std=c99   -m64 -c -o dwarf2out.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dwarf2out.c
/usr/bin/gcc     -std=c99   -m64 -c -o dyn-string.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  dyn-string.c
/usr/bin/gcc     -std=c99   -m64 -c -o ebitmap.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ebitmap.c
/usr/bin/gcc     -std=c99   -m64 -c -o emit-rtl.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  emit-rtl.c
/usr/bin/gcc     -std=c99   -m64 -c -o et-forest.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  et-forest.c
/usr/bin/gcc     -std=c99   -m64 -c -o except.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  except.c
/usr/bin/gcc     -std=c99   -m64 -c -o explow.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  explow.c
/usr/bin/gcc     -std=c99   -m64 -c -o expmed.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  expmed.c
/usr/bin/gcc     -std=c99   -m64 -c -o expr.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  expr.c
/usr/bin/gcc     -std=c99   -m64 -c -o fdmatch.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  fdmatch.c
/usr/bin/gcc     -std=c99   -m64 -c -o fibheap.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  fibheap.c
/usr/bin/gcc     -std=c99   -m64 -c -o filename_cmp.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  filename_cmp.c
/usr/bin/gcc     -std=c99   -m64 -c -o final.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  final.c
/usr/bin/gcc     -std=c99   -m64 -c -o fixed-value.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  fixed-value.c
/usr/bin/gcc     -std=c99   -m64 -c -o floatformat.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  floatformat.c
/usr/bin/gcc     -std=c99   -m64 -c -o fold-const.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  fold-const.c
/usr/bin/gcc     -std=c99   -m64 -c -o fopen_unlocked.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  fopen_unlocked.c
/usr/bin/gcc     -std=c99   -m64 -c -o function.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  function.c
/usr/bin/gcc     -std=c99   -m64 -c -o fwprop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  fwprop.c
/usr/bin/gcc     -std=c99   -m64 -c -o gcse.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  gcse.c
/usr/bin/gcc     -std=c99   -m64 -c -o genrtl.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  genrtl.c
/usr/bin/gcc     -std=c99   -m64 -c -o getopt1.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  getopt1.c
/usr/bin/gcc     -std=c99   -m64 -c -o getopt.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  getopt.c
/usr/bin/gcc     -std=c99   -m64 -c -o getpwd.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  getpwd.c
/usr/bin/gcc     -std=c99   -m64 -c -o getruntime.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  getruntime.c
/usr/bin/gcc     -std=c99   -m64 -c -o ggc-common.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ggc-common.c
/usr/bin/gcc     -std=c99   -m64 -c -o ggc-page.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ggc-page.c
/usr/bin/gcc     -std=c99   -m64 -c -o gimple.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  gimple.c
/usr/bin/gcc     -std=c99   -m64 -c -o gimple-iterator.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  gimple-iterator.c
/usr/bin/gcc     -std=c99   -m64 -c -o gimple-low.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  gimple-low.c
/usr/bin/gcc     -std=c99   -m64 -c -o gimple-pretty-print.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  gimple-pretty-print.c
/usr/bin/gcc     -std=c99   -m64 -c -o gimplify.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  gimplify.c
/usr/bin/gcc     -std=c99   -m64 -c -o graph.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graph.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphds.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphds.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphite.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphite.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphite-blocking.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphite-blocking.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphite-clast-to-gimple.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphite-clast-to-gimple.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphite-dependences.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphite-dependences.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphite-interchange.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphite-interchange.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphite-poly.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphite-poly.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphite-ppl.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphite-ppl.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphite-scop-detection.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphite-scop-detection.c
/usr/bin/gcc     -std=c99   -m64 -c -o graphite-sese-to-poly.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  graphite-sese-to-poly.c
/usr/bin/gcc     -std=c99   -m64 -c -o gtype-desc.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  gtype-desc.c
/usr/bin/gcc     -std=c99   -m64 -c -o haifa-sched.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  haifa-sched.c
/usr/bin/gcc     -std=c99   -m64 -c -o hashtab.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  hashtab.c
/usr/bin/gcc     -std=c99   -m64 -c -o hex.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  hex.c
/usr/bin/gcc     -std=c99   -m64 -c -o hooks.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  hooks.c
/usr/bin/gcc     -std=c99   -m64 -c -o host-ieee128.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  host-ieee128.c
/usr/bin/gcc     -std=c99   -m64 -c -o host-ieee32.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  host-ieee32.c
/usr/bin/gcc     -std=c99   -m64 -c -o host-ieee64.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  host-ieee64.c
/usr/bin/gcc     -std=c99   -m64 -c -o host-linux.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  host-linux.c
/usr/bin/gcc     -std=c99   -m64 -c -o i386.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  i386.c
/usr/bin/gcc     -std=c99   -m64 -c -o i386-c.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  i386-c.c
/usr/bin/gcc     -std=c99   -m64 -c -o ifcvt.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ifcvt.c
/usr/bin/gcc     -std=c99   -m64 -c -o incpath.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  incpath.c
/usr/bin/gcc     -std=c99   -m64 -c -o init-regs.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  init-regs.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-attrtab.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-attrtab.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-automata.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-automata.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-emit.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-emit.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-extract.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-extract.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-modes.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-modes.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-opinit.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-opinit.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-output.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-output.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-peep.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-peep.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-preds.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-preds.c
/usr/bin/gcc     -std=c99   -m64 -c -o insn-recog.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  insn-recog.c
/usr/bin/gcc     -std=c99   -m64 -c -o integrate.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  integrate.c
/usr/bin/gcc     -std=c99   -m64 -c -o ipa-cp.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ipa-cp.c
/usr/bin/gcc     -std=c99   -m64 -c -o ipa-inline.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ipa-inline.c
/usr/bin/gcc     -std=c99   -m64 -c -o ipa-prop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ipa-prop.c
/usr/bin/gcc     -std=c99   -m64 -c -o ipa-pure-const.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ipa-pure-const.c
/usr/bin/gcc     -std=c99   -m64 -c -o ipa-reference.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ipa-reference.c
/usr/bin/gcc     -std=c99   -m64 -c -o ipa-struct-reorg.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ipa-struct-reorg.c
/usr/bin/gcc     -std=c99   -m64 -c -o ipa-type-escape.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ipa-type-escape.c
/usr/bin/gcc     -std=c99   -m64 -c -o ipa-utils.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ipa-utils.c
/usr/bin/gcc     -std=c99   -m64 -c -o ipa.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ipa.c
/usr/bin/gcc     -std=c99   -m64 -c -o ira.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ira.c
/usr/bin/gcc     -std=c99   -m64 -c -o ira-build.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ira-build.c
/usr/bin/gcc     -std=c99   -m64 -c -o ira-costs.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ira-costs.c
/usr/bin/gcc     -std=c99   -m64 -c -o ira-conflicts.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ira-conflicts.c
/usr/bin/gcc     -std=c99   -m64 -c -o ira-color.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ira-color.c
/usr/bin/gcc     -std=c99   -m64 -c -o ira-emit.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ira-emit.c
/usr/bin/gcc     -std=c99   -m64 -c -o ira-lives.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  ira-lives.c
/usr/bin/gcc     -std=c99   -m64 -c -o jump.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  jump.c
/usr/bin/gcc     -std=c99   -m64 -c -o lambda-code.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lambda-code.c
/usr/bin/gcc     -std=c99   -m64 -c -o lambda-mat.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lambda-mat.c
/usr/bin/gcc     -std=c99   -m64 -c -o lambda-trans.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lambda-trans.c
/usr/bin/gcc     -std=c99   -m64 -c -o langhooks.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  langhooks.c
/usr/bin/gcc     -std=c99   -m64 -c -o lbasename.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lbasename.c
/usr/bin/gcc     -std=c99   -m64 -c -o lcm.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lcm.c
/usr/bin/gcc     -std=c99   -m64 -c -o lists.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lists.c
/usr/bin/gcc     -std=c99   -m64 -c -o loop-doloop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  loop-doloop.c
/usr/bin/gcc     -std=c99   -m64 -c -o loop-init.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  loop-init.c
/usr/bin/gcc     -std=c99   -m64 -c -o loop-invariant.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  loop-invariant.c
/usr/bin/gcc     -std=c99   -m64 -c -o loop-iv.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  loop-iv.c
/usr/bin/gcc     -std=c99   -m64 -c -o loop-unroll.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  loop-unroll.c
/usr/bin/gcc     -std=c99   -m64 -c -o loop-unswitch.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  loop-unswitch.c
/usr/bin/gcc     -std=c99   -m64 -c -o lower-subreg.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lower-subreg.c
/usr/bin/gcc     -std=c99   -m64 -c -o lrealpath.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lrealpath.c
/usr/bin/gcc     -std=c99   -m64 -c -o lto-cgraph.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lto-cgraph.c
/usr/bin/gcc     -std=c99   -m64 -c -o lto-streamer-in.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lto-streamer-in.c
/usr/bin/gcc     -std=c99   -m64 -c -o lto-streamer-out.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lto-streamer-out.c
/usr/bin/gcc     -std=c99   -m64 -c -o lto-section-in.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lto-section-in.c
/usr/bin/gcc     -std=c99   -m64 -c -o lto-section-out.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lto-section-out.c
/usr/bin/gcc     -std=c99   -m64 -c -o lto-symtab.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lto-symtab.c
/usr/bin/gcc     -std=c99   -m64 -c -o lto-opts.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lto-opts.c
/usr/bin/gcc     -std=c99   -m64 -c -o lto-streamer.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lto-streamer.c
/usr/bin/gcc     -std=c99   -m64 -c -o lto-wpa-fixup.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  lto-wpa-fixup.c
/usr/bin/gcc     -std=c99   -m64 -c -o make-relative-prefix.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  make-relative-prefix.c
/usr/bin/gcc     -std=c99   -m64 -c -o make-temp-file.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  make-temp-file.c
/usr/bin/gcc     -std=c99   -m64 -c -o partition.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  partition.c
/usr/bin/gcc     -std=c99   -m64 -c -o matrix-reorg.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  matrix-reorg.c
/usr/bin/gcc     -std=c99   -m64 -c -o mcf.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  mcf.c
/usr/bin/gcc     -std=c99   -m64 -c -o md5.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  md5.c
/usr/bin/gcc     -std=c99   -m64 -c -o mkstemps.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  mkstemps.c
/usr/bin/gcc     -std=c99   -m64 -c -o mode-switching.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  mode-switching.c
/usr/bin/gcc     -std=c99   -m64 -c -o modulo-sched.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  modulo-sched.c
/usr/bin/gcc     -std=c99   -m64 -c -o objalloc.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  objalloc.c
/usr/bin/gcc     -std=c99   -m64 -c -o obstack.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  obstack.c
/usr/bin/gcc     -std=c99   -m64 -c -o omega.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  omega.c
/usr/bin/gcc     -std=c99   -m64 -c -o omp-low.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  omp-low.c
/usr/bin/gcc     -std=c99   -m64 -c -o optabs.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  optabs.c
/usr/bin/gcc     -std=c99   -m64 -c -o options.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  options.c
/usr/bin/gcc     -std=c99   -m64 -c -o opts-common.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  opts-common.c
/usr/bin/gcc     -std=c99   -m64 -c -o opts.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  opts.c
/usr/bin/gcc     -std=c99   -m64 -c -o params.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  params.c
/usr/bin/gcc     -std=c99   -m64 -c -o passes.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  passes.c
/usr/bin/gcc     -std=c99   -m64 -c -o physmem.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  physmem.c
/usr/bin/gcc     -std=c99   -m64 -c -o plugin.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  plugin.c
/usr/bin/gcc     -std=c99   -m64 -c -o pointer-set.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  pointer-set.c
/usr/bin/gcc     -std=c99   -m64 -c -o postreload-gcse.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  postreload-gcse.c
/usr/bin/gcc     -std=c99   -m64 -c -o postreload.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  postreload.c
/usr/bin/gcc     -std=c99   -m64 -c -o predict.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  predict.c
/usr/bin/gcc     -std=c99   -m64 -c -o pretty-print.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  pretty-print.c
/usr/bin/gcc     -std=c99   -m64 -c -o print-rtl.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  print-rtl.c
/usr/bin/gcc     -std=c99   -m64 -c -o print-tree.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  print-tree.c
/usr/bin/gcc     -std=c99   -m64 -c -o profile.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  profile.c
/usr/bin/gcc     -std=c99   -m64 -c -o recog.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  recog.c
/usr/bin/gcc     -std=c99   -m64 -c -o reg-stack.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  reg-stack.c
/usr/bin/gcc     -std=c99   -m64 -c -o regcprop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  regcprop.c
/usr/bin/gcc     -std=c99   -m64 -c -o regex.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  regex.c
/usr/bin/gcc     -std=c99   -m64 -c -o reginfo.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  reginfo.c
/usr/bin/gcc     -std=c99   -m64 -c -o regmove.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  regmove.c
/usr/bin/gcc     -std=c99   -m64 -c -o regrename.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  regrename.c
/usr/bin/gcc     -std=c99   -m64 -c -o regstat.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  regstat.c
/usr/bin/gcc     -std=c99   -m64 -c -o reload.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  reload.c
/usr/bin/gcc     -std=c99   -m64 -c -o reload1.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  reload1.c
/usr/bin/gcc     -std=c99   -m64 -c -o reorg.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  reorg.c
/usr/bin/gcc     -std=c99   -m64 -c -o resource.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  resource.c
/usr/bin/gcc     -std=c99   -m64 -c -o rtl-error.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  rtl-error.c
/usr/bin/gcc     -std=c99   -m64 -c -o rtl.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  rtl.c
/usr/bin/gcc     -std=c99   -m64 -c -o rtlanal.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  rtlanal.c
/usr/bin/gcc     -std=c99   -m64 -c -o rtlhooks.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  rtlhooks.c
/usr/bin/gcc     -std=c99   -m64 -c -o safe-ctype.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  safe-ctype.c
/usr/bin/gcc     -std=c99   -m64 -c -o sbitmap.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sbitmap.c
/usr/bin/gcc     -std=c99   -m64 -c -o sched-deps.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sched-deps.c
/usr/bin/gcc     -std=c99   -m64 -c -o sched-ebb.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sched-ebb.c
/usr/bin/gcc     -std=c99   -m64 -c -o sched-rgn.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sched-rgn.c
/usr/bin/gcc     -std=c99   -m64 -c -o sched-vis.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sched-vis.c
/usr/bin/gcc     -std=c99   -m64 -c -o sdbout.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sdbout.c
/usr/bin/gcc     -std=c99   -m64 -c -o sel-sched-ir.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sel-sched-ir.c
/usr/bin/gcc     -std=c99   -m64 -c -o sel-sched-dump.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sel-sched-dump.c
/usr/bin/gcc     -std=c99   -m64 -c -o sel-sched.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sel-sched.c
/usr/bin/gcc     -std=c99   -m64 -c -o sese.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sese.c
/usr/bin/gcc     -std=c99   -m64 -c -o sha1.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sha1.c
/usr/bin/gcc     -std=c99   -m64 -c -o simplify-rtx.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  simplify-rtx.c
/usr/bin/gcc     -std=c99   -m64 -c -o sort.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sort.c
/usr/bin/gcc     -std=c99   -m64 -c -o spaces.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  spaces.c
/usr/bin/gcc     -std=c99   -m64 -c -o sparseset.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sparseset.c
/usr/bin/gcc     -std=c99   -m64 -c -o splay-tree.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  splay-tree.c
/usr/bin/gcc     -std=c99   -m64 -c -o sreal.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  sreal.c
/usr/bin/gcc     -std=c99   -m64 -c -o stack-ptr-mod.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  stack-ptr-mod.c
/usr/bin/gcc     -std=c99   -m64 -c -o statistics.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  statistics.c
/usr/bin/gcc     -std=c99   -m64 -c -o stmt.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  stmt.c
/usr/bin/gcc     -std=c99   -m64 -c -o stor-layout.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  stor-layout.c
/usr/bin/gcc     -std=c99   -m64 -c -o store-motion.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  store-motion.c
/usr/bin/gcc     -std=c99   -m64 -c -o stringpool.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  stringpool.c
/usr/bin/gcc     -std=c99   -m64 -c -o strsignal.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  strsignal.c
/usr/bin/gcc     -std=c99   -m64 -c -o stub-objc.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  stub-objc.c
/usr/bin/gcc     -std=c99   -m64 -c -o targhooks.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  targhooks.c
/usr/bin/gcc     -std=c99   -m64 -c -o timevar.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  timevar.c
/usr/bin/gcc     -std=c99   -m64 -c -o tracer.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tracer.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-affine.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-affine.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-call-cdce.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-call-cdce.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-cfg.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-cfg.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-cfgcleanup.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-cfgcleanup.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-chrec.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-chrec.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-complex.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-complex.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-data-ref.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-data-ref.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-dfa.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-dfa.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-dump.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-dump.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-eh.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-eh.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-if-conv.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-if-conv.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-inline.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-inline.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-into-ssa.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-into-ssa.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-iterator.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-iterator.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-loop-distribution.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-loop-distribution.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-loop-linear.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-loop-linear.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-mudflap.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-mudflap.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-nested.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-nested.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-nrv.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-nrv.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-object-size.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-object-size.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-optimize.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-optimize.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-outof-ssa.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-outof-ssa.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-parloops.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-parloops.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-phinodes.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-phinodes.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-predcom.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-predcom.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-pretty-print.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-pretty-print.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-profile.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-profile.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-scalar-evolution.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-scalar-evolution.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-sra.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-sra.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-switch-conversion.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-switch-conversion.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-address.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-address.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-alias.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-alias.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-ccp.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-ccp.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-coalesce.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-coalesce.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-copy.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-copy.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-copyrename.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-copyrename.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-dce.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-dce.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-dom.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-dom.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-dse.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-dse.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-forwprop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-forwprop.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-ifcombine.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-ifcombine.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-live.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-live.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-loop-ch.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-loop-ch.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-loop-im.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-loop-im.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-loop-ivcanon.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-loop-ivcanon.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-loop-ivopts.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-loop-ivopts.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-loop-manip.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-loop-manip.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-loop-niter.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-loop-niter.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-loop-prefetch.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-loop-prefetch.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-loop-unswitch.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-loop-unswitch.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-loop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-loop.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-math-opts.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-math-opts.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-operands.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-operands.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-phiopt.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-phiopt.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-phiprop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-phiprop.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-pre.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-pre.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-propagate.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-propagate.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-reassoc.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-reassoc.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-sccvn.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-sccvn.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-sink.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-sink.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-structalias.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-structalias.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-ter.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-ter.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-threadedge.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-threadedge.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-threadupdate.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-threadupdate.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa-uncprop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa-uncprop.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssa.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssa.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-ssanames.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-ssanames.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-stdarg.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-stdarg.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-tailcall.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-tailcall.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-vect-generic.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-vect-generic.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-vect-patterns.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-vect-patterns.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-vect-data-refs.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-vect-data-refs.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-vect-stmts.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-vect-stmts.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-vect-loop.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-vect-loop.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-vect-loop-manip.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-vect-loop-manip.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-vect-slp.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-vect-slp.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-vectorizer.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-vectorizer.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree-vrp.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree-vrp.c
/usr/bin/gcc     -std=c99   -m64 -c -o tree.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  tree.c
/usr/bin/gcc     -std=c99   -m64 -c -o unlink-if-ordinary.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  unlink-if-ordinary.c
/usr/bin/gcc     -std=c99   -m64 -c -o value-prof.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  value-prof.c
/usr/bin/gcc     -std=c99   -m64 -c -o var-tracking.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  var-tracking.c
/usr/bin/gcc     -std=c99   -m64 -c -o varpool.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  varpool.c
/usr/bin/gcc     -std=c99   -m64 -c -o varasm.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  varasm.c
/usr/bin/gcc     -std=c99   -m64 -c -o varray.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  varray.c
/usr/bin/gcc     -std=c99   -m64 -c -o vec.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  vec.c
/usr/bin/gcc     -std=c99   -m64 -c -o vmsdbgout.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  vmsdbgout.c
/usr/bin/gcc     -std=c99   -m64 -c -o web.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  web.c
/usr/bin/gcc     -std=c99   -m64 -c -o xatexit.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  xatexit.c
/usr/bin/gcc     -std=c99   -m64 -c -o xcoffout.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  xcoffout.c
/usr/bin/gcc     -std=c99   -m64 -c -o xexit.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  xexit.c
/usr/bin/gcc     -std=c99   -m64 -c -o xmalloc.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  xmalloc.c
/usr/bin/gcc     -std=c99   -m64 -c -o xmemdup.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  xmemdup.c
/usr/bin/gcc     -std=c99   -m64 -c -o xstrdup.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  xstrdup.c
/usr/bin/gcc     -std=c99   -m64 -c -o xstrerror.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  xstrerror.c
/usr/bin/gcc     -std=c99   -m64 -c -o xstrndup.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  xstrndup.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-cppbuiltin.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-cppbuiltin.c
/usr/bin/gcc     -std=c99   -m64 -c -o c-pch.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  c-pch.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_files.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_files.c
/usr/bin/gcc     -std=c99   -m64 -c -o cpp_init.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cpp_init.c
/usr/bin/gcc     -std=c99   -m64 -c -o cppdefault.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  cppdefault.c
/usr/bin/gcc     -std=c99   -m64 -c -o intl.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  intl.c
/usr/bin/gcc     -std=c99   -m64 -c -o prefix.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  prefix.c
/usr/bin/gcc     -std=c99   -m64 -c -o strerror.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  strerror.c
/usr/bin/gcc     -std=c99   -m64 -c -o toplev.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  toplev.c
/usr/bin/gcc     -std=c99   -m64 -c -o vasprintf.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  vasprintf.c
/usr/bin/gcc     -std=c99   -m64 -c -o version.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  version.c
/usr/bin/gcc     -std=c99   -m64 -c -o builtins.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  builtins.c
/usr/bin/gcc     -std=c99   -m64 -c -o real.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  real.c
/usr/bin/gcc     -std=c99   -m64 -c -o mini-gmp.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  mini-gmp.c
/usr/bin/gcc     -std=c99   -m64 -c -o spec_qsort/spec_qsort.o -DSPEC -DSPEC_CPU -DNDEBUG -I. -I./include -I./spec_qsort -DSPEC_602 -DIN_GCC -DHAVE_CONFIG_H  -g           -fopenmp -DSPEC_OPENMP -fno-strict-aliasing   -DSPEC_LP64  spec_qsort/spec_qsort.c
/usr/bin/gcc     -std=c99   -m64  -z muldefs    -g        -fopenmp -DSPEC_OPENMP -fno-strict-aliasing main.o cc1-checksum.o alias.o alloca.o alloc-pool.o argv.o attribs.o auto-inc-dec.o bb-reorder.o bid2dpd_dpd2bid.o bitmap.o bt-load.o c-lang.o c-errors.o c-lex.o c-pragma.o c-decl.o c-typeck.o c-convert.o c-aux-info.o c-common.o c-opts.o c-format.o c-semantics.o c-ppoutput.o c-objc-common.o c-dump.o c-parser.o c-gimplify.o c-pretty-print.o c-omp.o caller-save.o calls.o cfg.o cfganal.o cfgbuild.o cfgcleanup.o cfgexpand.o cfghooks.o cfglayout.o cfgloop.o cfgloopanal.o cfgloopmanip.o cfgrtl.o cgraph.o cgraphbuild.o cgraphunit.o combine.o combine-stack-adj.o concat.o convert.o coverage.o cp-demangle.o cp-demint.o cplus-dem.o cpp_directives.o cpp_lex.o cpp_errors.o cpp_expr.o cpp_charset.o cpp_macro.o cpp_traditional.o cpp_line-map.o cpp_symtab.o cpp_identifiers.o cpp_mkdeps.o cpp_pch.o cpp_directives-only.o crc32.o cse.o cselib.o dbxout.o dbgcnt.o dce.o ddg.o debug.o decContext.o decimal128.o decimal32.o decimal64.o decNumber.o df-byte-scan.o df-core.o df-problems.o df-scan.o dfp.o diagnostic.o dojump.o dominance.o domwalk.o double-int.o dse.o dwarf2asm.o dwarf2out.o dyn-string.o ebitmap.o emit-rtl.o et-forest.o except.o explow.o expmed.o expr.o fdmatch.o fibheap.o filename_cmp.o final.o fixed-value.o floatformat.o fold-const.o fopen_unlocked.o function.o fwprop.o gcse.o genrtl.o getopt1.o getopt.o getpwd.o getruntime.o ggc-common.o ggc-page.o gimple.o gimple-iterator.o gimple-low.o gimple-pretty-print.o gimplify.o graph.o graphds.o graphite.o graphite-blocking.o graphite-clast-to-gimple.o graphite-dependences.o graphite-interchange.o graphite-poly.o graphite-ppl.o graphite-scop-detection.o graphite-sese-to-poly.o gtype-desc.o haifa-sched.o hashtab.o hex.o hooks.o host-ieee128.o host-ieee32.o host-ieee64.o host-linux.o i386.o i386-c.o ifcvt.o incpath.o init-regs.o insn-attrtab.o insn-automata.o insn-emit.o insn-extract.o insn-modes.o insn-opinit.o insn-output.o insn-peep.o insn-preds.o insn-recog.o integrate.o ipa-cp.o ipa-inline.o ipa-prop.o ipa-pure-const.o ipa-reference.o ipa-struct-reorg.o ipa-type-escape.o ipa-utils.o ipa.o ira.o ira-build.o ira-costs.o ira-conflicts.o ira-color.o ira-emit.o ira-lives.o jump.o lambda-code.o lambda-mat.o lambda-trans.o langhooks.o lbasename.o lcm.o lists.o loop-doloop.o loop-init.o loop-invariant.o loop-iv.o loop-unroll.o loop-unswitch.o lower-subreg.o lrealpath.o lto-cgraph.o lto-streamer-in.o lto-streamer-out.o lto-section-in.o lto-section-out.o lto-symtab.o lto-opts.o lto-streamer.o lto-wpa-fixup.o make-relative-prefix.o make-temp-file.o partition.o matrix-reorg.o mcf.o md5.o mkstemps.o mode-switching.o modulo-sched.o objalloc.o obstack.o omega.o omp-low.o optabs.o options.o opts-common.o opts.o params.o passes.o physmem.o plugin.o pointer-set.o postreload-gcse.o postreload.o predict.o pretty-print.o print-rtl.o print-tree.o profile.o recog.o reg-stack.o regcprop.o regex.o reginfo.o regmove.o regrename.o regstat.o reload.o reload1.o reorg.o resource.o rtl-error.o rtl.o rtlanal.o rtlhooks.o safe-ctype.o sbitmap.o sched-deps.o sched-ebb.o sched-rgn.o sched-vis.o sdbout.o sel-sched-ir.o sel-sched-dump.o sel-sched.o sese.o sha1.o simplify-rtx.o sort.o spaces.o sparseset.o splay-tree.o sreal.o stack-ptr-mod.o statistics.o stmt.o stor-layout.o store-motion.o stringpool.o strsignal.o stub-objc.o targhooks.o timevar.o tracer.o tree-affine.o tree-call-cdce.o tree-cfg.o tree-cfgcleanup.o tree-chrec.o tree-complex.o tree-data-ref.o tree-dfa.o tree-dump.o tree-eh.o tree-if-conv.o tree-inline.o tree-into-ssa.o tree-iterator.o tree-loop-distribution.o tree-loop-linear.o tree-mudflap.o tree-nested.o tree-nrv.o tree-object-size.o tree-optimize.o tree-outof-ssa.o tree-parloops.o tree-phinodes.o tree-predcom.o tree-pretty-print.o tree-profile.o tree-scalar-evolution.o tree-sra.o tree-switch-conversion.o tree-ssa-address.o tree-ssa-alias.o tree-ssa-ccp.o tree-ssa-coalesce.o tree-ssa-copy.o tree-ssa-copyrename.o tree-ssa-dce.o tree-ssa-dom.o tree-ssa-dse.o tree-ssa-forwprop.o tree-ssa-ifcombine.o tree-ssa-live.o tree-ssa-loop-ch.o tree-ssa-loop-im.o tree-ssa-loop-ivcanon.o tree-ssa-loop-ivopts.o tree-ssa-loop-manip.o tree-ssa-loop-niter.o tree-ssa-loop-prefetch.o tree-ssa-loop-unswitch.o tree-ssa-loop.o tree-ssa-math-opts.o tree-ssa-operands.o tree-ssa-phiopt.o tree-ssa-phiprop.o tree-ssa-pre.o tree-ssa-propagate.o tree-ssa-reassoc.o tree-ssa-sccvn.o tree-ssa-sink.o tree-ssa-structalias.o tree-ssa-ter.o tree-ssa-threadedge.o tree-ssa-threadupdate.o tree-ssa-uncprop.o tree-ssa.o tree-ssanames.o tree-stdarg.o tree-tailcall.o tree-vect-generic.o tree-vect-patterns.o tree-vect-data-refs.o tree-vect-stmts.o tree-vect-loop.o tree-vect-loop-manip.o tree-vect-slp.o tree-vectorizer.o tree-vrp.o tree.o unlink-if-ordinary.o value-prof.o var-tracking.o varpool.o varasm.o varray.o vec.o vmsdbgout.o web.o xatexit.o xcoffout.o xexit.o xmalloc.o xmemdup.o xstrdup.o xstrerror.o xstrndup.o c-cppbuiltin.o c-pch.o cpp_files.o cpp_init.o cppdefault.o intl.o prefix.o strerror.o toplev.o vasprintf.o version.o builtins.o real.o mini-gmp.o spec_qsort/spec_qsort.o             -lm         -o sgcc  
