/*@@
   @file    GaugeWave_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"
#include "ParameterCRestrictedADMBASE.h"
#include "ParameterCRestrictedGENERICFD.h"
#include "ParameterCRestrictedMETHODOFLINES.h"

/* structure containing all private parameters of thorn GaugeWave */
struct
{
  int dummy_parameter;
} PRIVATE_GAUGEWAVE_STRUCT;


/* structure containing all restricted parameters of thorn GaugeWave */
struct
{
  CCTK_REAL amp;
  CCTK_REAL boostx;
  CCTK_REAL boosty;
  CCTK_REAL boostz;
  CCTK_REAL lapsefactor;
  CCTK_REAL period;
  CCTK_REAL phi;
  CCTK_REAL positionx;
  CCTK_REAL positiony;
  CCTK_REAL positionz;
  CCTK_REAL psi;
  CCTK_REAL shiftaddx;
  CCTK_REAL shiftaddy;
  CCTK_REAL shiftaddz;
  CCTK_REAL theta;
  CCTK_REAL timeoffset;
  CCTK_INT GaugeWave_MaxNumArrayEvolvedVars;
  CCTK_INT GaugeWave_MaxNumEvolvedVars;
  CCTK_INT GaugeWave_always_calc_every;
  CCTK_INT GaugeWave_always_calc_offset;
  CCTK_INT GaugeWave_initial_calc_every;
  CCTK_INT GaugeWave_initial_calc_offset;
  CCTK_INT other_timelevels;
  CCTK_INT rhs_timelevels;
  CCTK_INT timelevels;
  CCTK_INT verbose;
} RESTRICTED_GAUGEWAVE_STRUCT;


int CCTKi_BindingsCreateGaugeWaveParameters(void);
int CCTKi_BindingsCreateGaugeWaveParameters(void)
{
  CCTKi_ParameterCreate("GaugeWave_MaxNumArrayEvolvedVars",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of Array evolved variables used by this thorn",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.GaugeWave_MaxNumArrayEvolvedVars),
                        0,
                        NULL,
                        1,
                        "0:0", "Number of Array evolved variables used by this thorn");

  CCTKi_ParameterCreate("GaugeWave_MaxNumEvolvedVars",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of evolved variables used by this thorn",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.GaugeWave_MaxNumEvolvedVars),
                        0,
                        NULL,
                        1,
                        "0:0", "Number of evolved variables used by this thorn");

  CCTKi_ParameterCreate("GaugeWave_always_calc_every",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "GaugeWave_always_calc_every",
                        "1",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.GaugeWave_always_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("GaugeWave_always_calc_offset",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "GaugeWave_always_calc_offset",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.GaugeWave_always_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("GaugeWave_initial_calc_every",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "GaugeWave_initial_calc_every",
                        "1",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.GaugeWave_initial_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("GaugeWave_initial_calc_offset",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "GaugeWave_initial_calc_offset",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.GaugeWave_initial_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("amp",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "amp",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.amp),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("boostx",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "boostx",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.boostx),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("boosty",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "boosty",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.boosty),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("boostz",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "boostz",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.boostz),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("lapsefactor",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "lapsefactor",
                        "1",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.lapsefactor),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("other_timelevels",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of active timelevels for non-evolved grid functions",
                        "1",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.other_timelevels),
                        0,
                        NULL,
                        1,
                        "0:3", "");

  CCTKi_ParameterCreate("period",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "period",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.period),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("phi",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "phi",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.phi),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("positionx",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "positionx",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.positionx),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("positiony",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "positiony",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.positiony),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("positionz",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "positionz",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.positionz),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("psi",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "psi",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.psi),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("rhs_timelevels",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of active RHS timelevels",
                        "1",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.rhs_timelevels),
                        0,
                        NULL,
                        1,
                        "0:3", "");

  CCTKi_ParameterCreate("shiftaddx",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "shiftaddx",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.shiftaddx),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("shiftaddy",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "shiftaddy",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.shiftaddy),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("shiftaddz",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "shiftaddz",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.shiftaddz),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("theta",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "theta",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.theta),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("timelevels",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of active timelevels",
                        "3",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.timelevels),
                        0,
                        NULL,
                        1,
                        "0:3", "");

  CCTKi_ParameterCreate("timeoffset",
                        "GaugeWave",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "timeoffset",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.timeoffset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("verbose",
                        "GaugeWave",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "verbose",
                        "0",
                        &(RESTRICTED_GAUGEWAVE_STRUCT.verbose),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  return 0;
}

int CCTKi_BindingsGaugeWaveParameterExtensions(void);
int CCTKi_BindingsGaugeWaveParameterExtensions(void)
{
  CCTKi_ParameterAddRange("ADMBASE",
                          "initial_data",
                          "GaugeWave",
                          "GaugeWave",
                          "");

  CCTKi_ParameterAddRange("ADMBASE",
                          "initial_lapse",
                          "GaugeWave",
                          "GaugeWave",
                          "");

  CCTKi_ParameterAddRange("ADMBASE",
                          "initial_shift",
                          "GaugeWave",
                          "GaugeWave",
                          "");

  CCTKi_ParameterAddRange("ADMBASE",
                          "initial_dtlapse",
                          "GaugeWave",
                          "GaugeWave",
                          "");

  CCTKi_ParameterAddRange("ADMBASE",
                          "initial_dtshift",
                          "GaugeWave",
                          "GaugeWave",
                          "");

  CCTKi_ParameterAddRange("ADMBASE",
                          "evolution_method",
                          "GaugeWave",
                          "GaugeWave",
                          "");

  CCTKi_ParameterAccumulatorBase("GaugeWave",
                          "GaugeWave_MaxNumArrayEvolvedVars",
                          "MethodofLines",
                          "MoL_Num_ArrayEvolved_Vars");

  CCTKi_ParameterAccumulatorBase("GaugeWave",
                          "GaugeWave_MaxNumEvolvedVars",
                          "MethodofLines",
                          "MoL_Num_Evolved_Vars");

  return 0;
}
