/*@@
   @file    MoL_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"
#include "ParameterCRestrictedCACTUS.h"

/* structure containing all private parameters of thorn MoL */
struct
{
  CCTK_REAL ICN_avg_theta;
  CCTK_REAL MoL_Tiny;
  CCTK_REAL RHS_error_weight;
  CCTK_REAL maximum_absolute_error;
  CCTK_REAL maximum_decrease;
  CCTK_REAL maximum_increase;
  CCTK_REAL maximum_relative_error;
  CCTK_REAL safety_factor;
  const char * AB_Type;
  const char * Generic_Method_Descriptor;
  const char * Generic_Type;
  const char * ODE_Method;
  const char * verbose;
  CCTK_INT AB_initially_reduce_order;
  CCTK_INT ICN_avg_swapped;
  CCTK_INT MoL_Intermediate_Steps;
  CCTK_INT MoL_Memory_Always_On;
  CCTK_INT MoL_NaN_Check;
  CCTK_INT adaptive_stepsize;
  CCTK_INT copy_ID_after_MoL_PostStep;
  CCTK_INT disable_prolongation;
  CCTK_INT init_RHS_zero;
  CCTK_INT initial_data_is_crap;
  CCTK_INT run_MoL_PostStep_in_Post_Recover_Variables;
  CCTK_INT set_ID_boundaries;
  CCTK_INT skip_initial_copy;
} PRIVATE_MOL_STRUCT;


/* structure containing all restricted parameters of thorn MoL */
struct
{
  CCTK_INT MoL_Max_Evolved_Array_Size;
  CCTK_INT MoL_Max_Evolved_ComplexArray_Size;
  CCTK_INT MoL_Num_ArrayConstrained_Vars;
  CCTK_INT MoL_Num_ArrayEvolved_Vars;
  CCTK_INT MoL_Num_ArraySaveAndRestore_Vars;
  CCTK_INT MoL_Num_ComplexArrayConstrained_Vars;
  CCTK_INT MoL_Num_ComplexArrayEvolved_Vars;
  CCTK_INT MoL_Num_ComplexArraySaveAndRestore_Vars;
  CCTK_INT MoL_Num_ComplexConstrained_Vars;
  CCTK_INT MoL_Num_ComplexEvolved_Vars;
  CCTK_INT MoL_Num_ComplexSaveAndRestore_Vars;
  CCTK_INT MoL_Num_Constrained_Vars;
  CCTK_INT MoL_Num_Evolved_Vars;
  CCTK_INT MoL_Num_Evolved_Vars_Slow;
  CCTK_INT MoL_Num_SaveAndRestore_Vars;
  CCTK_INT MoL_Num_Scratch_Levels;
} RESTRICTED_METHODOFLINES_STRUCT;


int CCTKi_BindingsCreateMoLParameters(void);
int CCTKi_BindingsCreateMoLParameters(void)
{
  CCTKi_ParameterCreate("MoL_Max_Evolved_Array_Size",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum total size of any grid arrays to be evolved",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Max_Evolved_Array_Size),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Accumulated by other thorns");

  CCTKi_ParameterCreate("MoL_Max_Evolved_ComplexArray_Size",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum total size of any complex grid arrays to be evolved",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Max_Evolved_ComplexArray_Size),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Accumulated by other thorns");

  CCTKi_ParameterCreate("MoL_Num_ArrayConstrained_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of array constrained variables with timelevels that MoL needs to know about",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_ArrayConstrained_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_ArrayEvolved_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of array variables to be evolved by MoL",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_ArrayEvolved_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_ArraySaveAndRestore_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of array variables to be evolved outside of MoL but that MoL needs to know about",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_ArraySaveAndRestore_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_ComplexArrayConstrained_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of complex array constrained variables with timelevels that MoL needs to know about",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_ComplexArrayConstrained_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_ComplexArrayEvolved_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of complex array variables to be evolved by MoL",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_ComplexArrayEvolved_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_ComplexArraySaveAndRestore_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of complex array variables to be evolved outside of MoL but that MoL needs to know about",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_ComplexArraySaveAndRestore_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_ComplexConstrained_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of complex constrained variables with timelevels that MoL needs to know about",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_ComplexConstrained_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_ComplexEvolved_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of complex variables to be evolved by MoL",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_ComplexEvolved_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_ComplexSaveAndRestore_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of complex variables to be evolved outside of MoL but that MoL needs to know about",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_ComplexSaveAndRestore_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_Constrained_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of constrained variables with timelevels that MoL needs to know about",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_Constrained_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_Evolved_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of variables to be evolved by MoL",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_Evolved_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_Evolved_Vars_Slow",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of 'slow' variables to be evolved by MoL",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_Evolved_Vars_Slow),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_SaveAndRestore_Vars",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "The maximum number of variables to be evolved outside of MoL but that MoL needs to know about",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_SaveAndRestore_Vars),
                        0,
                        "(x+y)",
                        1,
                        "0:*", "Anything non negative. Added to by other thorns.");

  CCTKi_ParameterCreate("MoL_Num_Scratch_Levels",
                        "MoL",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Number of scratch levels required by the ODE method",
                        "0",
                        &(RESTRICTED_METHODOFLINES_STRUCT.MoL_Num_Scratch_Levels),
                        0,
                        NULL,
                        1,
                        "0:*", "Anything non negative");

  CCTKi_ParameterCreate("AB_Type",
                        "MoL",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "If using the the AB method, which sort",
                        "1",
                        &(PRIVATE_MOL_STRUCT.AB_Type),
                        0,
                        NULL,
                        5,
                        "1", "same as forward Euler",
                        "2", "second order",
                        "3", "third order",
                        "4", "fourth order",
                        "5", "fifth order");

  CCTKi_ParameterCreate("AB_initially_reduce_order",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Reduce order of accuracy initially so that no past timelevels of initial data are required",
                        "yes",
                        &(PRIVATE_MOL_STRUCT.AB_initially_reduce_order),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("Generic_Method_Descriptor",
                        "MoL",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "A string used to create a table containing the description of the generic method",
                        "GenericIntermediateSteps = 2    GenericAlphaCoeffs = { 1.0 0.0 0.5 0.5 }    GenericBetaCoeffs = { 1.0 0.5 }",
                        &(PRIVATE_MOL_STRUCT.Generic_Method_Descriptor),
                        0,
                        NULL,
                        1,
                        ".*", "Should contain the Alpha and Beta arrays, and the number of intermediate steps");

  CCTKi_ParameterCreate("Generic_Type",
                        "MoL",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "If using the generic method, which sort",
                        "RK",
                        &(PRIVATE_MOL_STRUCT.Generic_Type),
                        0,
                        NULL,
                        4,
                        "RK", "One of the standard TVD Runge-Kutta methods",
                        "ICN", "Iterative Crank Nicholson as a generic method",
                        "Table", "Given from the generic method descriptor parameter",
                        "Classic RK3", "Efficient RK3 - classical version");

  CCTKi_ParameterCreate("ICN_avg_swapped",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Use swapped averages in ICN method?",
                        "no",
                        &(PRIVATE_MOL_STRUCT.ICN_avg_swapped),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("ICN_avg_theta",
                        "MoL",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "theta of averaged ICN method, usually 0.5",
                        "0.5",
                        &(PRIVATE_MOL_STRUCT.ICN_avg_theta),
                        0,
                        NULL,
                        1,
                        "0:1", "0 <= theta <= 1");

  CCTKi_ParameterCreate("MoL_Intermediate_Steps",
                        "MoL",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Number of intermediate steps taken by the ODE method",
                        "3",
                        &(PRIVATE_MOL_STRUCT.MoL_Intermediate_Steps),
                        0,
                        NULL,
                        1,
                        "1:*", "Anything greater than 1");

  CCTKi_ParameterCreate("MoL_Memory_Always_On",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Do we keep the scratch arrays allocated all the time?",
                        "yes",
                        &(PRIVATE_MOL_STRUCT.MoL_Memory_Always_On),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("MoL_NaN_Check",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Should the RHS GFs be checked for NaNs?",
                        "no",
                        &(PRIVATE_MOL_STRUCT.MoL_NaN_Check),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("MoL_Tiny",
                        "MoL",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Effective local machine zero; required by generic solvers",
                        "1.e-15",
                        &(PRIVATE_MOL_STRUCT.MoL_Tiny),
                        0,
                        NULL,
                        1,
                        "0:*", "Defaults to 1.e-15");

  CCTKi_ParameterCreate("ODE_Method",
                        "MoL",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The ODE method use by MoL to do time integration",
                        "ICN",
                        &(PRIVATE_MOL_STRUCT.ODE_Method),
                        0,
                        NULL,
                        15,
                        "Generic", "Generic Shu-Osher Runge-Kutta type",
                        "ICN", "Iterative Crank Nicholson",
                        "ICN-avg", "Iterative Crank Nicholson with averaging",
                        "Euler", "Euler",
                        "RK2", "Efficient RK2",
                        "RK3", "Efficient RK3",
                        "RK4", "Efficient RK4",
                        "RK45", "RK45 (Fehlberg) with error estimation",
                        "RK45CK", "RK45CK (Cash-Karp) with error estimation",
                        "RK65", "RK65 with error estimation",
                        "RK87", "RK87 with error estimation",
                        "AB", "Adams-Bashforth",
                        "RK2-MR-2:1", "2nd order 2:1 multirate RK scheme based on RK2 due to Schlegel et al 2009",
                        "RK4-MR-2:1", "3rd order 2:1 multirate RK scheme based on RK43 due to Schlegel et al 2009",
                        "RK4-RK2", "RK4 as fast method and RK2 as slow method");

  CCTKi_ParameterCreate("RHS_error_weight",
                        "MoL",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Weight of the RHS in the relative error calculation",
                        "1.0",
                        &(PRIVATE_MOL_STRUCT.RHS_error_weight),
                        0,
                        NULL,
                        1,
                        "0.0:*", "should be between zero and one");

  CCTKi_ParameterCreate("adaptive_stepsize",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Choose the time step size adaptively",
                        "no",
                        &(PRIVATE_MOL_STRUCT.adaptive_stepsize),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("copy_ID_after_MoL_PostStep",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "if  initial_data_is_crap  is true, *when* should we copy the		   current time level to all previous time levels:			   false ==> copy *before* MoL_PostStep  (default, matches old behavior)   true  ==> copy *after*  MoL_PostStep  (maybe preferable for new code)",
                        "no",
                        &(PRIVATE_MOL_STRUCT.copy_ID_after_MoL_PostStep),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("disable_prolongation",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "If Mesh refinement is enabled should we use buffer zones in intermediate steps?",
                        "yes",
                        &(PRIVATE_MOL_STRUCT.disable_prolongation),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("init_RHS_zero",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Initialise the RHS to zero",
                        "yes",
                        &(PRIVATE_MOL_STRUCT.init_RHS_zero),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("initial_data_is_crap",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "If the initial data routine fails to set up the previous time levels, copy the current backwards",
                        "no",
                        &(PRIVATE_MOL_STRUCT.initial_data_is_crap),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("maximum_absolute_error",
                        "MoL",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Maximum allowed absolute error for adaptive stepsize control",
                        "1.0e-6",
                        &(PRIVATE_MOL_STRUCT.maximum_absolute_error),
                        0,
                        NULL,
                        1,
                        "(0.0:*)", "");

  CCTKi_ParameterCreate("maximum_decrease",
                        "MoL",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Maximum stepsize decrease factor",
                        "10.0",
                        &(PRIVATE_MOL_STRUCT.maximum_decrease),
                        0,
                        NULL,
                        1,
                        "(0.0:*)", "should be larger than one");

  CCTKi_ParameterCreate("maximum_increase",
                        "MoL",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Maximum stepsize increase factor",
                        "5.0",
                        &(PRIVATE_MOL_STRUCT.maximum_increase),
                        0,
                        NULL,
                        1,
                        "(0.0:*)", "should be larger than one");

  CCTKi_ParameterCreate("maximum_relative_error",
                        "MoL",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Maximum allowed relative error for adaptive stepsize control",
                        "1.0e-6",
                        &(PRIVATE_MOL_STRUCT.maximum_relative_error),
                        0,
                        NULL,
                        1,
                        "(0.0:*)", "");

  CCTKi_ParameterCreate("run_MoL_PostStep_in_Post_Recover_Variables",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Schedule the PostStep parts after recovery so that symmetries are automatically done correctly.",
                        "yes",
                        &(PRIVATE_MOL_STRUCT.run_MoL_PostStep_in_Post_Recover_Variables),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("safety_factor",
                        "MoL",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Safety factor for stepsize control",
                        "0.9",
                        &(PRIVATE_MOL_STRUCT.safety_factor),
                        0,
                        NULL,
                        1,
                        "(0.0:*)", "should be less than one");

  CCTKi_ParameterCreate("set_ID_boundaries",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Should boundaries be overwritten (via synchronization, prolongation, boundary conditions) by MoL?",
                        "yes",
                        &(PRIVATE_MOL_STRUCT.set_ID_boundaries),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("skip_initial_copy",
                        "MoL",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Skip initial copy from previous to current time level",
                        "no",
                        &(PRIVATE_MOL_STRUCT.skip_initial_copy),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("verbose",
                        "MoL",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "How verbose should MoL be?",
                        "normal",
                        &(PRIVATE_MOL_STRUCT.verbose),
                        0,
                        NULL,
                        4,
                        "none", "No output at all (not implemented)",
                        "normal", "Standard verbosity",
                        "register", "List the variables registered as well",
                        "extreme", "Everything you never wanted to know");

  return 0;
}

int CCTKi_BindingsMoLParameterExtensions(void);
int CCTKi_BindingsMoLParameterExtensions(void)
{
  return 0;
}
