/*@@
   @file    Time_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"
#include "ParameterCRestrictedCACTUS.h"

/* structure containing all private parameters of thorn Time */
struct
{
  CCTK_REAL courant_fac;
  CCTK_REAL dtfac;
  CCTK_REAL timestep;
  CCTK_INT timestep_outevery;
  CCTK_INT verbose;
} PRIVATE_TIME_STRUCT;


/* structure containing all restricted parameters of thorn Time */
struct
{
  const char * timestep_method;
  CCTK_INT timestep_outonly;
} RESTRICTED_TIME_STRUCT;


int CCTKi_BindingsCreateTimeParameters(void);
int CCTKi_BindingsCreateTimeParameters(void)
{
  CCTKi_ParameterCreate("timestep_method",
                        "Time",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Method for calculating timestep",
                        "courant_static",
                        &(RESTRICTED_TIME_STRUCT.timestep_method),
                        0,
                        NULL,
                        4,
                        "given", "Use given timestep",
                        "courant_static", "Courant condition at BASEGRID (using dtfac)",
                        "courant_speed", "Courant condition at POSTSTEP (using wavespeed and courant_fac)",
                        "courant_time", "Courant condition at POSTSTEP (using min time and courant_fac)");

  CCTKi_ParameterCreate("timestep_outonly",
                        "Time",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Don't set a dynamic timestep, just output what it would be",
                        "no",
                        &(RESTRICTED_TIME_STRUCT.timestep_outonly),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("courant_fac",
                        "Time",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The courant timestep condition dt = courant_fac*max(delta_space)/speed/sqrt(dim)",
                        "0.9",
                        &(PRIVATE_TIME_STRUCT.courant_fac),
                        0,
                        NULL,
                        2,
                        "0:*", "For positive timestep",
                        "*:0", "For negative timestep");

  CCTKi_ParameterCreate("dtfac",
                        "Time",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The standard timestep condition dt = dtfac*max(delta_space)",
                        "0.5",
                        &(PRIVATE_TIME_STRUCT.dtfac),
                        0,
                        NULL,
                        2,
                        "0:*", "For positive timestep",
                        "*:0", "For negative timestep");

  CCTKi_ParameterCreate("timestep",
                        "Time",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Absolute value for timestep",
                        "0.0",
                        &(PRIVATE_TIME_STRUCT.timestep),
                        0,
                        NULL,
                        1,
                        "*:*", "Could be anything");

  CCTKi_ParameterCreate("timestep_outevery",
                        "Time",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "How often to output courant timestep",
                        "1",
                        &(PRIVATE_TIME_STRUCT.timestep_outevery),
                        0,
                        NULL,
                        1,
                        "1:*", "Zero means no output");

  CCTKi_ParameterCreate("verbose",
                        "Time",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Give selective information about timestep setting",
                        "no",
                        &(PRIVATE_TIME_STRUCT.verbose),
                        0,
                        NULL,
                        0);

  return 0;
}

int CCTKi_BindingsTimeParameterExtensions(void);
int CCTKi_BindingsTimeParameterExtensions(void)
{
  return 0;
}
