/*@@
  @header   CDYCDK_guts.h
  @date     August 98
  @author   Gabrielle Allen
  @desc
  Macro to calculate the first covariant derivatives of the 
  extrinsic curvature with respect to x
  @enddesc
@@*/

#ifndef CDYCDK_GUTS
#define CDYCDK_GUTS

#include "DYDK_guts.h"
#include "CHR2_guts.h"

#ifdef FCODE 

      CDYCDK_CDYCDKXX = DYDK_DYDKXX - 2D0*(CHR2_XXY*CDYCDK_KXX +  \
       CHR2_YXY*CDYCDK_KXY + CHR2_ZXY*CDYCDK_KXZ)

      CDYCDK_CDYCDKYY = DYDK_DYDKYY - 2D0*(CHR2_XYY*CDYCDK_KXY +  \
       CHR2_YYY*CDYCDK_KYY + CHR2_ZYY*CDYCDK_KYZ)

      CDYCDK_CDYCDKZZ = DYDK_DYDKZZ - 2D0*(CHR2_XYZ*CDYCDK_KXZ +  \
       CHR2_YYZ*CDYCDK_KYZ + CHR2_ZYZ*CDYCDK_KZZ)

      CDYCDK_CDYCDKXY = DYDK_DYDKXY - (CHR2_XYY*CDYCDK_KXX) -  \
       (CHR2_XXY + CHR2_YYY)*CDYCDK_KXY  - CHR2_ZYY*CDYCDK_KXZ -  \
       CHR2_YXY*CDYCDK_KYY - CHR2_ZXY*CDYCDK_KYZ
 
      CDYCDK_CDYCDKXZ = DYDK_DYDKXZ - (CHR2_XYZ*CDYCDK_KXX) -  \
       CHR2_YYZ*CDYCDK_KXY - (CHR2_XXY + CHR2_ZYZ)*CDYCDK_KXZ  - \
       CHR2_YXY*CDYCDK_KYZ - CHR2_ZXY*CDYCDK_KZZ

      CDYCDK_CDYCDKYZ = DYDK_DYDKYZ -(CHR2_XYZ*CDYCDK_KXY) -  \
       CHR2_XYY*CDYCDK_KXZ - CHR2_YYZ*CDYCDK_KYY -  \
       (CHR2_YYY + CHR2_ZYZ)*CDYCDK_KYZ - CHR2_ZYY*CDYCDK_KZZ

#endif

#ifdef CCODE

      CDYCDK_CDYCDKXX = DYDK_DYDKXX - 2.*(CHR2_XXY*CDYCDK_KXX + 
       CHR2_YXY*CDYCDK_KXY + CHR2_ZXY*CDYCDK_KXZ);

      CDYCDK_CDYCDKYY = DYDK_DYDKYY - 2.*(CHR2_XYY*CDYCDK_KXY + 
       CHR2_YYY*CDYCDK_KYY + CHR2_ZYY*CDYCDK_KYZ);

      CDYCDK_CDYCDKZZ = DYDK_DYDKZZ - 2.*(CHR2_XYZ*CDYCDK_KXZ + 
       CHR2_YYZ*CDYCDK_KYZ + CHR2_ZYZ*CDYCDK_KZZ);

      CDYCDK_CDYCDKXY = DYDK_DYDKXY - (CHR2_XYY*CDYCDK_KXX) - 
       (CHR2_XXY + CHR2_YYY)*CDYCDK_KXY  - CHR2_ZYY*CDYCDK_KXZ - 
       CHR2_YXY*CDYCDK_KYY - CHR2_ZXY*CDYCDK_KYZ;
 
      CDYCDK_CDYCDKXZ = DYDK_DYDKXZ - (CHR2_XYZ*CDYCDK_KXX) - 
       CHR2_YYZ*CDYCDK_KXY - (CHR2_XXY + CHR2_ZYZ)*CDYCDK_KXZ  -
       CHR2_YXY*CDYCDK_KYZ - CHR2_ZXY*CDYCDK_KZZ;

      CDYCDK_CDYCDKYZ = DYDK_DYDKYZ -(CHR2_XYZ*CDYCDK_KXY) - 
       CHR2_XYY*CDYCDK_KXZ - CHR2_YYZ*CDYCDK_KYY - 
       (CHR2_YYY + CHR2_ZYZ)*CDYCDK_KYZ - CHR2_ZYY*CDYCDK_KZZ;

#endif

#endif
