/*@@
  @header   GAMMA_guts.h
  @date     Oct 98
  @author   Gabrielle Allen
  @desc
  Macro to calculate Gauge Source Functions (Gammas)

  That is GAMMA_Ga = g^bc CHR2_abc

  @enddesc
@@*/

#ifndef GAMMA_GUTS
#define GAMMA_GUTS

#include "CHR2_guts.h"
#include "UPPERMET_guts.h"

#ifdef FCODE 

      GAMMA_GAMMAX = UPPERMET_UXX*CHR2_XXX + 2D0*UPPERMET_UXY*CHR2_XXY \
         + 2D0*UPPERMET_UXZ*CHR2_XXZ + UPPERMET_UYY*CHR2_XYY  \
         + 2D0*UPPERMET_UYZ*CHR2_XYZ + UPPERMET_UZZ*CHR2_XZZ 

      GAMMA_GAMMAY = UPPERMET_UXX*CHR2_YXX + 2D0*UPPERMET_UXY*CHR2_YXY \
         + 2D0*UPPERMET_UXZ*CHR2_YXZ + UPPERMET_UYY*CHR2_YYY  \
         + 2D0*UPPERMET_UYZ*CHR2_YYZ + UPPERMET_UZZ*CHR2_YZZ 

      GAMMA_GAMMAZ = UPPERMET_UXX*CHR2_ZXX + 2D0*UPPERMET_UXY*CHR2_ZXY \
         + 2D0*UPPERMET_UXZ*CHR2_ZXZ + UPPERMET_UYY*CHR2_ZYY  \
         + 2D0*UPPERMET_UYZ*CHR2_ZYZ + UPPERMET_UZZ*CHR2_ZZZ 

#endif

#ifdef CCODE

      GAMMA_GAMMAX = UPPERMET_UXX*CHR2_XXX + 2*UPPERMET_UXY*CHR2_XXY
          + 2*UPPERMET_UXZ*CHR2_XXZ + UPPERMET_UYY*CHR2_XYY 
          + 2*UPPERMET_UYZ*CHR2_XYZ + UPPERMET_UZZ*CHR2_XZZ; 

      GAMMA_GAMMAY = UPPERMET_UXX*CHR2_YXX + 2*UPPERMET_UXY*CHR2_YXY
          + 2*UPPERMET_UXZ*CHR2_YXZ + UPPERMET_UYY*CHR2_YYY 
          + 2*UPPERMET_UYZ*CHR2_YYZ + UPPERMET_UZZ*CHR2_YZZ; 

      GAMMA_GAMMAZ = UPPERMET_UXX*CHR2_ZXX + 2*UPPERMET_UXY*CHR2_ZXY
          + 2*UPPERMET_UXZ*CHR2_ZXZ + UPPERMET_UYY*CHR2_ZYY 
          + 2*UPPERMET_UYZ*CHR2_ZYZ + UPPERMET_UZZ*CHR2_ZZZ;

#endif

#endif
