/****************************************************************************
 *                  povmsgid.h
 *
 * This module contains all defines, typedefs, and prototypes for the POVMS.
 *
 * from Persistence of Vision(tm) Ray Tracer version 3.6.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2009 Persistence of Vision Raytracer Pty. Ltd.
 *---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 *---------------------------------------------------------------------------
 * This program is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 *---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.6/source/base/povmsgid.h $
 * $Revision: #1 $
 * $Change: 5014 $
 * $DateTime: 2010/06/13 03:51:51 $
 * $Author: thorsten $
 * $Log$
 *****************************************************************************/


#ifndef POVMSGID_H
#define POVMSGID_H

/*****************************************************************************
* NOTE: If you do not understand the code below, stay away! If your compiler
* warns you about the code below, your compiler warning configuration is
* incorrect. Turn that warning off! Do not, ever, mess with the code below to
* just please your compiler. Do not, ever, complain to the POV-Team about the
* code below! Just stay away from this code, please!!!
* RATIONALE: If you do understand the code below and are concerned about
* portability, please direct your attention to the file povms.cpp. There are
* several methods there that do determine the byteorder at runtime. Please
* refer to POVMSStream_Init, POVMSStream_ReadType and POVMSStream_WriteType
* in that file for details. If you have a failure of those functions to
* report, please include as many details about your platform and compiler
* as possible!
******************************************************************************/

#if !defined(SPEC)
/* POV-Ray Object Classes */
enum
{
	kPOVObjectClass_Rect			 = 'Rect',
	kPOVObjectClass_Path			 = 'Path',
	kPOVObjectClass_File			 = 'File',
	kPOVObjectClass_FileLoc			 = 'FPos',
	kPOVObjectClass_Command			 = 'Comm',
	kPOVObjectClass_OIStat			 = 'OISt',
	kPOVObjectClass_ROptions		 = 'ROpt',
	kPOVObjectClass_RTime			 = 'RTim',
	kPOVObjectClass_FStats			 = 'FSta',
	kPOVObjectClass_RStats			 = 'RSta',
	kPOVObjectClass_PStats			 = 'PSta',
	kPOVObjectClass_Progress		 = 'Prog'
};

/* POV-Ray Message Classes */
enum
{
	kPOVMsgClass_RenderControl		 = 'Ctrl',
	kPOVMsgClass_RenderOutput		 = 'Outp',
	kPOVMsgClass_IniOptions			 = 'IniO',
	kPOVMsgClass_Miscellaneous		 = 'Misc'
};

/* POV-Ray Message Identifiers */
enum
{
	kPOVMsgIdent_InitInfo			 = 'InIn',
	kPOVMsgIdent_RenderOptions		 = 'ROpt',
	kPOVMsgIdent_RenderAll			 = 'RAll',
	kPOVMsgIdent_RenderArea			 = 'RAre',
	kPOVMsgIdent_RenderPause		 = 'RPau',
	kPOVMsgIdent_RenderStop			 = 'RSto',
	kPOVMsgIdent_RenderStarted		 = 'RRun',
	kPOVMsgIdent_RenderDone			 = 'REnd',
	kPOVMsgIdent_FrameStatistics	 = 'FSta',
	kPOVMsgIdent_ParseStatistics	 = 'PSta',
	kPOVMsgIdent_RenderStatistics	 = 'RSta',
	kPOVMsgIdent_Progress			 = 'Prog',
	kPOVMsgIdent_Warning			 = 'Warn',
	kPOVMsgIdent_Error				 = 'ErrW',
	kPOVMsgIdent_FatalError			 = 'ErrF',
	kPOVMsgIdent_Debug				 = 'Dbug'
};

/* POV-Ray Message Attributes */
enum
{
	kPOVAttrib_Height				 = 'Heig',
	kPOVAttrib_Width				 = 'Widt',
	kPOVAttrib_TestAbort			 = 'TstA',
	kPOVAttrib_TestAbortCount		 = 'TsAC',
	kPOVAttrib_ContinueTrace		 = 'ConT',
	kPOVAttrib_CreateIni			 = 'CIni',
	kPOVAttrib_Clock				 = 'Clck',
	kPOVAttrib_InitialFrame			 = 'IFrm',
	kPOVAttrib_FinalFrame			 = 'FFrm',
	kPOVAttrib_InitialClock			 = 'IClk',
	kPOVAttrib_FinalClock			 = 'FClk',
	kPOVAttrib_SubsetStartFrame		 = 'SStF',
	kPOVAttrib_SubsetEndFrame		 = 'SEnF',
	kPOVAttrib_CyclicAnimation		 = 'CylA',
	kPOVAttrib_FieldRender			 = 'FldR',
	kPOVAttrib_OddField				 = 'OddF',
	kPOVAttrib_PauseWhenDone		 = 'PWDo',
	kPOVAttrib_Verbose				 = 'Verb',
	kPOVAttrib_DrawVistas			 = 'DrVi',
	kPOVAttrib_Display				 = 'Disp',
	kPOVAttrib_VideoMode			 = 'VMod',
	kPOVAttrib_Palette				 = 'Palt',
	kPOVAttrib_DisplayGamma			 = 'DGam',
	kPOVAttrib_PreviewStartSize		 = 'PStS',
	kPOVAttrib_PreviewEndSize		 = 'PEnS',
	kPOVAttrib_OutputToFile			 = 'OToF',
	kPOVAttrib_OutputFileType		 = 'OFTy',
	kPOVAttrib_OutputAlpha			 = 'OAlp',
	kPOVAttrib_BitsPerColor			 = 'BPCo',
	kPOVAttrib_OutputFile			 = 'OFNa',
	kPOVAttrib_OutputPath			 = 'OPat',
	kPOVAttrib_Compression			 = 'OFCo',
	kPOVAttrib_CreateHistogram		 = 'CHis',
	kPOVAttrib_HistogramFileType	 = 'HFTy',
	kPOVAttrib_HistogramFile		 = 'HFNa',
	kPOVAttrib_HistogramGridSizeX	 = 'HGSX',
	kPOVAttrib_HistogramGridSizeY	 = 'HGSY',
	kPOVAttrib_PreSceneCommand		 = 'PrSC',
	kPOVAttrib_PreFrameCommand		 = 'PrFC',
	kPOVAttrib_PostSceneCommand		 = 'PoSc',
	kPOVAttrib_PostFrameCommand		 = 'PoFC',
	kPOVAttrib_UserAbortCommand		 = 'UAbC',
	kPOVAttrib_FatalErrorCommand	 = 'FErC',
	kPOVAttrib_InputFile			 = 'IFNa',
	kPOVAttrib_LibraryPath			 = 'LibP',
	kPOVAttrib_Version				 = 'Vers',
	kPOVAttrib_DebugConsole			 = 'DCon',
	kPOVAttrib_FatalConsole			 = 'FCon',
	kPOVAttrib_RenderConsole		 = 'RCon',
	kPOVAttrib_StatisticsConsole	 = 'SCon',
	kPOVAttrib_WarningConsole		 = 'WCon',
	kPOVAttrib_AllConsole			 = 'ACon',
	kPOVAttrib_Declare				 = 'Decl',
	kPOVAttrib_DebugFile			 = 'DFNa',
	kPOVAttrib_FatalFile			 = 'FFNa',
	kPOVAttrib_RenderFile			 = 'RFNa',
	kPOVAttrib_StatisticsFile		 = 'SFNa',
	kPOVAttrib_WarningFile			 = 'WFNa',
	kPOVAttrib_WarningLevel			 = 'WLev',
	kPOVAttrib_AllFile				 = 'AFNa',
	kPOVAttrib_Quality				 = 'Qual',
	kPOVAttrib_Bounding				 = 'Boun',
	kPOVAttrib_BoundingThreshold	 = 'BdTh',
	kPOVAttrib_LightBuffer			 = 'LBuf',
	kPOVAttrib_VistaBuffer			 = 'VBuf',
	kPOVAttrib_Radiosity			 = 'Radi',
	kPOVAttrib_RemoveBounds			 = 'RmBd',
	kPOVAttrib_SplitUnions			 = 'SplU',
	kPOVAttrib_Antialias			 = 'Anti',
	kPOVAttrib_SamplingMethod		 = 'AASM',
	kPOVAttrib_AntialiasThreshold	 = 'AATh',
	kPOVAttrib_AntialiasDepth		 = 'AADe',
	kPOVAttrib_AntialiasClipped		 = 'AACl',
	kPOVAttrib_Jitter				 = 'AAJi',
	kPOVAttrib_JitterAmount			 = 'AAJA',
	kPOVAttrib_Left					 = 'Left',
	kPOVAttrib_Top					 = 'Top ',
	kPOVAttrib_Right				 = 'Righ',
	kPOVAttrib_Bottom				 = 'Bott',
	kPOVAttrib_CoreVersion			 = 'Core',
	kPOVAttrib_PlatformName			 = 'Plat',
	kPOVAttrib_Official				 = 'Offi',
	kPOVAttrib_PrimaryDevs			 = 'Prim',
	kPOVAttrib_ContributingDevs		 = 'Cont',
	kPOVAttrib_ImageLibVersions		 = 'ILVe',
	kPOVAttrib_EnglishText			 = 'ETxt',
	kPOVAttrib_CurrentToken			 = 'CurT',
	kPOVAttrib_CurrentLine			 = 'CurL',
	kPOVAttrib_LineCount			 = 'LCnt',
	kPOVAttrib_AbsoluteCurrentLine	 = 'AbsL',
	kPOVAttrib_FiniteObjects		 = 'FiOb',
	kPOVAttrib_InfiniteObjects		 = 'InOb',
	kPOVAttrib_LightSources			 = 'LiSo',
	kPOVAttrib_CurrentFrame			 = 'CurF',
	kPOVAttrib_FrameCount			 = 'FCnt',
	kPOVAttrib_AbsoluteCurFrame		 = 'AbsF',
	kPOVAttrib_FirstClock			 = 'FirC',
	kPOVAttrib_CurrentClock			 = 'CurC',
	kPOVAttrib_LastClock			 = 'LasC',
	kPOVAttrib_TotalPhotonCount		 = 'TPCn',
	kPOVAttrib_CurrentPhotonCount	 = 'CPCn',
	kPOVAttrib_ObjectPhotonCount	 = 'OPCn',
	kPOVAttrib_MediaPhotonCount		 = 'MPCn',
	kPOVAttrib_PhotonXSamples		 = 'PXSa',
	kPOVAttrib_PhotonYSamples		 = 'PYSa',
	kPOVAttrib_ProgressStatus		 = 'ProS',
	kPOVAttrib_ParseTime			 = 'ParT',
	kPOVAttrib_PhotonTime			 = 'PhoT',
	kPOVAttrib_TraceTime			 = 'TraT',
	kPOVAttrib_TotalTime			 = 'TotT',
	kPOVAttrib_FileName				 = 'File',
	kPOVAttrib_Pixels				 = 'Pixe',
	kPOVAttrib_PixelSamples			 = 'PixS',
	kPOVAttrib_SuperSampleCount		 = 'SSCn',
	kPOVAttrib_MosaicPreviewSize	 = 'MPSi',
	kPOVAttrib_Rays					 = 'Rays',
	kPOVAttrib_RaysSaved			 = 'RSav',
	kPOVAttrib_TraceLevel			 = 'TLev',
	kPOVAttrib_MaxTraceLevel		 = 'MaxL',
	kPOVAttrib_ObjectIStats			 = 'OISt',
	kPOVAttrib_ShadowTest			 = 'ShdT',
	kPOVAttrib_ShadowTestSuc		 = 'ShdS',
	kPOVAttrib_PolynomTest			 = 'PnmT',
	kPOVAttrib_RootsEliminated		 = 'REli',
	kPOVAttrib_CallsToNoise			 = 'CTNo',
	kPOVAttrib_CallsToDNoise		 = 'CTDN',
	kPOVAttrib_MediaSamples			 = 'MeSa',
	kPOVAttrib_MediaIntervals		 = 'MeIn',
	kPOVAttrib_ReflectedRays		 = 'RflR',
	kPOVAttrib_InnerReflectedRays	 = 'IReR',
	kPOVAttrib_RefractedRays		 = 'RfrT',
	kPOVAttrib_TransmittedRays		 = 'TraR',
	kPOVAttrib_IStackOverflow		 = 'IStO',
	kPOVAttrib_RadGatherCount		 = 'RGCt',
	kPOVAttrib_RadReuseCount		 = 'RRCt',
	kPOVAttrib_MinAlloc				 = 'MinA',
	kPOVAttrib_MaxAlloc				 = 'MaxA',
	kPOVAttrib_CallsToAlloc			 = 'CTAl',
	kPOVAttrib_CallsToFree			 = 'CTFr',
	kPOVAttrib_PeakMemoryUsage		 = 'PMUs',
	kPOVAttrib_PhotonsShot			 = 'PSho',
	kPOVAttrib_PhotonsStored		 = 'PSto',
	kPOVAttrib_GlobalPhotonsStored	 = 'GPSt',
	kPOVAttrib_MediaPhotonsStored	 = 'MPSt',
	kPOVAttrib_PhotonsPriQInsert	 = 'PPQI',
	kPOVAttrib_PhotonsPriQRemove	 = 'PPQR',
	kPOVAttrib_GatherPerformedCnt	 = 'GPCn',
	kPOVAttrib_GatherExpandedCnt	 = 'GECn',
	kPOVAttrib_IsoFindRoot			 = 'IFRo',
	kPOVAttrib_FunctionVMCalls		 = 'FVMC',
	kPOVAttrib_FunctionVMInstrEst	 = 'FVMI',
	kPOVAttrib_State				 = 'Stat',
	kPOVAttrib_Warning				 = 'Warn',
	kPOVAttrib_Line					 = 'Line',
	kPOVAttrib_Column				 = 'Colu',
	kPOVAttrib_FilePosition			 = 'FPos',
	kPOVAttrib_TokenName			 = 'TokN',
	kPOVAttrib_Error				 = 'Erro',
	kPOVAttrib_ObjectName			 = 'ONam',
	kPOVAttrib_ObjectID				 = 'OIde',
	kPOVAttrib_ISectsTests			 = 'ITst',
	kPOVAttrib_ISectsSucceeded		 = 'ISuc',
	kPOVAttrib_CommandString		 = 'ComS',
	kPOVAttrib_ReturnAction			 = 'RAct',
	kPOVAttrib_FrameTime			 = 'FTim',
	kPOVAttrib_AnimationTime		 = 'ATim',
	kPOVAttrib_IncludeHeader		 = 'IncH',
	kPOVAttrib_IncludeIni			 = 'IncI',
	kPOVAttrib_PreviewRefCon		 = 'PRef',
	kPOVAttrib_INIFile				 = 'IFil',
	kPOVAttrib_RenderOptions		 = 'ROpt',
	kPOVAttrib_Identifier			 = 'Iden',
	kPOVAttrib_Value				 = 'Valu',
	kPOVAttrib_StartColumn			 = kPOVAttrib_Left,
	kPOVAttrib_EndColumn			 = kPOVAttrib_Right,
	kPOVAttrib_StartRow				 = kPOVAttrib_Top,
	kPOVAttrib_EndRow				 = kPOVAttrib_Bottom
};
#else
/* POV-Ray Object Classes */
enum
{
	kPOVObjectClass_Rect			 = ( ('R' << 24) | ('e' << 16) | ('c' << 8) | 't' )	/* 'Rect' */,
	kPOVObjectClass_Path			 = ( ('P' << 24) | ('a' << 16) | ('t' << 8) | 'h' )	/* 'Path' */,
	kPOVObjectClass_File			 = ( ('F' << 24) | ('i' << 16) | ('l' << 8) | 'e' )	/* 'File' */,
	kPOVObjectClass_FileLoc			 = ( ('F' << 24) | ('P' << 16) | ('o' << 8) | 's' )	/* 'FPos' */,
	kPOVObjectClass_Command			 = ( ('C' << 24) | ('o' << 16) | ('m' << 8) | 'm' )	/* 'Comm' */,
	kPOVObjectClass_OIStat			 = ( ('O' << 24) | ('I' << 16) | ('S' << 8) | 't' )	/* 'OISt' */,
	kPOVObjectClass_ROptions		 = ( ('R' << 24) | ('O' << 16) | ('p' << 8) | 't' )	/* 'ROpt' */,
	kPOVObjectClass_RTime			 = ( ('R' << 24) | ('T' << 16) | ('i' << 8) | 'm' )	/* 'RTim' */,
	kPOVObjectClass_FStats			 = ( ('F' << 24) | ('S' << 16) | ('t' << 8) | 'a' )	/* 'FSta' */,
	kPOVObjectClass_RStats			 = ( ('R' << 24) | ('S' << 16) | ('t' << 8) | 'a' )	/* 'RSta' */,
	kPOVObjectClass_PStats			 = ( ('P' << 24) | ('S' << 16) | ('t' << 8) | 'a' )	/* 'PSta' */,
	kPOVObjectClass_Progress		 = ( ('P' << 24) | ('r' << 16) | ('o' << 8) | 'g' )	/* 'Prog' */
};

/* POV-Ray Message Classes */
enum
{
	kPOVMsgClass_RenderControl		 = ( ('C' << 24) | ('t' << 16) | ('r' << 8) | 'l' )	/* 'Ctrl' */,
	kPOVMsgClass_RenderOutput		 = ( ('O' << 24) | ('u' << 16) | ('t' << 8) | 'p' )	/* 'Outp' */,
	kPOVMsgClass_IniOptions			 = ( ('I' << 24) | ('n' << 16) | ('i' << 8) | 'O' )	/* 'IniO' */,
	kPOVMsgClass_Miscellaneous		 = ( ('M' << 24) | ('i' << 16) | ('s' << 8) | 'c' )	/* 'Misc' */
};

/* POV-Ray Message Identifiers */
enum
{
	kPOVMsgIdent_InitInfo			 = ( ('I' << 24) | ('n' << 16) | ('I' << 8) | 'n' )	/* 'InIn' */,
	kPOVMsgIdent_RenderOptions		 = ( ('R' << 24) | ('O' << 16) | ('p' << 8) | 't' )	/* 'ROpt' */,
	kPOVMsgIdent_RenderAll			 = ( ('R' << 24) | ('A' << 16) | ('l' << 8) | 'l' )	/* 'RAll' */,
	kPOVMsgIdent_RenderArea			 = ( ('R' << 24) | ('A' << 16) | ('r' << 8) | 'e' )	/* 'RAre' */,
	kPOVMsgIdent_RenderPause		 = ( ('R' << 24) | ('P' << 16) | ('a' << 8) | 'u' )	/* 'RPau' */,
	kPOVMsgIdent_RenderStop			 = ( ('R' << 24) | ('S' << 16) | ('t' << 8) | 'o' )	/* 'RSto' */,
	kPOVMsgIdent_RenderStarted		 = ( ('R' << 24) | ('R' << 16) | ('u' << 8) | 'n' )	/* 'RRun' */,
	kPOVMsgIdent_RenderDone			 = ( ('R' << 24) | ('E' << 16) | ('n' << 8) | 'd' )	/* 'REnd' */,
	kPOVMsgIdent_FrameStatistics		 = ( ('F' << 24) | ('S' << 16) | ('t' << 8) | 'a' )	/* 'FSta' */,
	kPOVMsgIdent_ParseStatistics		 = ( ('P' << 24) | ('S' << 16) | ('t' << 8) | 'a' )	/* 'PSta' */,
	kPOVMsgIdent_RenderStatistics		 = ( ('R' << 24) | ('S' << 16) | ('t' << 8) | 'a' )	/* 'RSta' */,
	kPOVMsgIdent_Progress			 = ( ('P' << 24) | ('r' << 16) | ('o' << 8) | 'g' )	/* 'Prog' */,
	kPOVMsgIdent_Warning			 = ( ('W' << 24) | ('a' << 16) | ('r' << 8) | 'n' )	/* 'Warn' */,
	kPOVMsgIdent_Error			 = ( ('E' << 24) | ('r' << 16) | ('r' << 8) | 'W' )	/* 'ErrW' */,
	kPOVMsgIdent_FatalError			 = ( ('E' << 24) | ('r' << 16) | ('r' << 8) | 'F' )	/* 'ErrF' */,
	kPOVMsgIdent_Debug			 = ( ('D' << 24) | ('b' << 16) | ('u' << 8) | 'g' )	/* 'Dbug' */
};

/* POV-Ray Message Attributes */
enum
{
	kPOVAttrib_Height			 = ( ('H' << 24) | ('e' << 16) | ('i' << 8) | 'g' )	/* 'Heig' */,
	kPOVAttrib_Width			 = ( ('W' << 24) | ('i' << 16) | ('d' << 8) | 't' )	/* 'Widt' */,
	kPOVAttrib_TestAbort			 = ( ('T' << 24) | ('s' << 16) | ('t' << 8) | 'A' )	/* 'TstA' */,
	kPOVAttrib_TestAbortCount		 = ( ('T' << 24) | ('s' << 16) | ('A' << 8) | 'C' )	/* 'TsAC' */,
	kPOVAttrib_ContinueTrace		 = ( ('C' << 24) | ('o' << 16) | ('n' << 8) | 'T' )	/* 'ConT' */,
	kPOVAttrib_CreateIni			 = ( ('C' << 24) | ('I' << 16) | ('n' << 8) | 'i' )	/* 'CIni' */,
	kPOVAttrib_Clock			 = ( ('C' << 24) | ('l' << 16) | ('c' << 8) | 'k' )	/* 'Clck' */,
	kPOVAttrib_InitialFrame			 = ( ('I' << 24) | ('F' << 16) | ('r' << 8) | 'm' )	/* 'IFrm' */,
	kPOVAttrib_FinalFrame			 = ( ('F' << 24) | ('F' << 16) | ('r' << 8) | 'm' )	/* 'FFrm' */,
	kPOVAttrib_InitialClock			 = ( ('I' << 24) | ('C' << 16) | ('l' << 8) | 'k' )	/* 'IClk' */,
	kPOVAttrib_FinalClock			 = ( ('F' << 24) | ('C' << 16) | ('l' << 8) | 'k' )	/* 'FClk' */,
	kPOVAttrib_SubsetStartFrame		 = ( ('S' << 24) | ('S' << 16) | ('t' << 8) | 'F' )	/* 'SStF' */,
	kPOVAttrib_SubsetEndFrame		 = ( ('S' << 24) | ('E' << 16) | ('n' << 8) | 'F' )	/* 'SEnF' */,
	kPOVAttrib_CyclicAnimation		 = ( ('C' << 24) | ('y' << 16) | ('l' << 8) | 'A' )	/* 'CylA' */,
	kPOVAttrib_FieldRender			 = ( ('F' << 24) | ('l' << 16) | ('d' << 8) | 'R' )	/* 'FldR' */,
	kPOVAttrib_OddField			 = ( ('O' << 24) | ('d' << 16) | ('d' << 8) | 'F' )	/* 'OddF' */,
	kPOVAttrib_PauseWhenDone		 = ( ('P' << 24) | ('W' << 16) | ('D' << 8) | 'o' )	/* 'PWDo' */,
	kPOVAttrib_Verbose			 = ( ('V' << 24) | ('e' << 16) | ('r' << 8) | 'b' )	/* 'Verb' */,
	kPOVAttrib_DrawVistas			 = ( ('D' << 24) | ('r' << 16) | ('V' << 8) | 'i' )	/* 'DrVi' */,
	kPOVAttrib_Display			 = ( ('D' << 24) | ('i' << 16) | ('s' << 8) | 'p' )	/* 'Disp' */,
	kPOVAttrib_VideoMode			 = ( ('V' << 24) | ('M' << 16) | ('o' << 8) | 'd' )	/* 'VMod' */,
	kPOVAttrib_Palette			 = ( ('P' << 24) | ('a' << 16) | ('l' << 8) | 't' )	/* 'Palt' */,
	kPOVAttrib_DisplayGamma			 = ( ('D' << 24) | ('G' << 16) | ('a' << 8) | 'm' )	/* 'DGam' */,
	kPOVAttrib_PreviewStartSize		 = ( ('P' << 24) | ('S' << 16) | ('t' << 8) | 'S' )	/* 'PStS' */,
	kPOVAttrib_PreviewEndSize		 = ( ('P' << 24) | ('E' << 16) | ('n' << 8) | 'S' )	/* 'PEnS' */,
	kPOVAttrib_OutputToFile			 = ( ('O' << 24) | ('T' << 16) | ('o' << 8) | 'F' )	/* 'OToF' */,
	kPOVAttrib_OutputFileType		 = ( ('O' << 24) | ('F' << 16) | ('T' << 8) | 'y' )	/* 'OFTy' */,
	kPOVAttrib_OutputAlpha			 = ( ('O' << 24) | ('A' << 16) | ('l' << 8) | 'p' )	/* 'OAlp' */,
	kPOVAttrib_BitsPerColor			 = ( ('B' << 24) | ('P' << 16) | ('C' << 8) | 'o' )	/* 'BPCo' */,
	kPOVAttrib_OutputFile			 = ( ('O' << 24) | ('F' << 16) | ('N' << 8) | 'a' )	/* 'OFNa' */,
	kPOVAttrib_OutputPath			 = ( ('O' << 24) | ('P' << 16) | ('a' << 8) | 't' )	/* 'OPat' */,
	kPOVAttrib_Compression			 = ( ('O' << 24) | ('F' << 16) | ('C' << 8) | 'o' )	/* 'OFCo' */,
	kPOVAttrib_CreateHistogram		 = ( ('C' << 24) | ('H' << 16) | ('i' << 8) | 's' )	/* 'CHis' */,
	kPOVAttrib_HistogramFileType		 = ( ('H' << 24) | ('F' << 16) | ('T' << 8) | 'y' )	/* 'HFTy' */,
	kPOVAttrib_HistogramFile		 = ( ('H' << 24) | ('F' << 16) | ('N' << 8) | 'a' )	/* 'HFNa' */,
	kPOVAttrib_HistogramGridSizeX		 = ( ('H' << 24) | ('G' << 16) | ('S' << 8) | 'X' )	/* 'HGSX' */,
	kPOVAttrib_HistogramGridSizeY		 = ( ('H' << 24) | ('G' << 16) | ('S' << 8) | 'Y' )	/* 'HGSY' */,
	kPOVAttrib_PreSceneCommand		 = ( ('P' << 24) | ('r' << 16) | ('S' << 8) | 'C' )	/* 'PrSC' */,
	kPOVAttrib_PreFrameCommand		 = ( ('P' << 24) | ('r' << 16) | ('F' << 8) | 'C' )	/* 'PrFC' */,
	kPOVAttrib_PostSceneCommand		 = ( ('P' << 24) | ('o' << 16) | ('S' << 8) | 'c' )	/* 'PoSc' */,
	kPOVAttrib_PostFrameCommand		 = ( ('P' << 24) | ('o' << 16) | ('F' << 8) | 'C' )	/* 'PoFC' */,
	kPOVAttrib_UserAbortCommand		 = ( ('U' << 24) | ('A' << 16) | ('b' << 8) | 'C' )	/* 'UAbC' */,
	kPOVAttrib_FatalErrorCommand		 = ( ('F' << 24) | ('E' << 16) | ('r' << 8) | 'C' )	/* 'FErC' */,
	kPOVAttrib_InputFile			 = ( ('I' << 24) | ('F' << 16) | ('N' << 8) | 'a' )	/* 'IFNa' */,
	kPOVAttrib_LibraryPath			 = ( ('L' << 24) | ('i' << 16) | ('b' << 8) | 'P' )	/* 'LibP' */,
	kPOVAttrib_Version			 = ( ('V' << 24) | ('e' << 16) | ('r' << 8) | 's' )	/* 'Vers' */,
	kPOVAttrib_DebugConsole			 = ( ('D' << 24) | ('C' << 16) | ('o' << 8) | 'n' )	/* 'DCon' */,
	kPOVAttrib_FatalConsole			 = ( ('F' << 24) | ('C' << 16) | ('o' << 8) | 'n' )	/* 'FCon' */,
	kPOVAttrib_RenderConsole		 = ( ('R' << 24) | ('C' << 16) | ('o' << 8) | 'n' )	/* 'RCon' */,
	kPOVAttrib_StatisticsConsole		 = ( ('S' << 24) | ('C' << 16) | ('o' << 8) | 'n' )	/* 'SCon' */,
	kPOVAttrib_WarningConsole		 = ( ('W' << 24) | ('C' << 16) | ('o' << 8) | 'n' )	/* 'WCon' */,
	kPOVAttrib_AllConsole			 = ( ('A' << 24) | ('C' << 16) | ('o' << 8) | 'n' )	/* 'ACon' */,
	kPOVAttrib_Declare			 = ( ('D' << 24) | ('e' << 16) | ('c' << 8) | 'l' )	/* 'Decl' */,
	kPOVAttrib_DebugFile			 = ( ('D' << 24) | ('F' << 16) | ('N' << 8) | 'a' )	/* 'DFNa' */,
	kPOVAttrib_FatalFile			 = ( ('F' << 24) | ('F' << 16) | ('N' << 8) | 'a' )	/* 'FFNa' */,
	kPOVAttrib_RenderFile			 = ( ('R' << 24) | ('F' << 16) | ('N' << 8) | 'a' )	/* 'RFNa' */,
	kPOVAttrib_StatisticsFile		 = ( ('S' << 24) | ('F' << 16) | ('N' << 8) | 'a' )	/* 'SFNa' */,
	kPOVAttrib_WarningFile			 = ( ('W' << 24) | ('F' << 16) | ('N' << 8) | 'a' )	/* 'WFNa' */,
	kPOVAttrib_WarningLevel			 = ( ('W' << 24) | ('L' << 16) | ('e' << 8) | 'v' )	/* 'WLev' */,
	kPOVAttrib_AllFile			 = ( ('A' << 24) | ('F' << 16) | ('N' << 8) | 'a' )	/* 'AFNa' */,
	kPOVAttrib_Quality			 = ( ('Q' << 24) | ('u' << 16) | ('a' << 8) | 'l' )	/* 'Qual' */,
	kPOVAttrib_Bounding			 = ( ('B' << 24) | ('o' << 16) | ('u' << 8) | 'n' )	/* 'Boun' */,
	kPOVAttrib_BoundingThreshold		 = ( ('B' << 24) | ('d' << 16) | ('T' << 8) | 'h' )	/* 'BdTh' */,
	kPOVAttrib_LightBuffer			 = ( ('L' << 24) | ('B' << 16) | ('u' << 8) | 'f' )	/* 'LBuf' */,
	kPOVAttrib_VistaBuffer			 = ( ('V' << 24) | ('B' << 16) | ('u' << 8) | 'f' )	/* 'VBuf' */,
	kPOVAttrib_Radiosity			 = ( ('R' << 24) | ('a' << 16) | ('d' << 8) | 'i' )	/* 'Radi' */,
	kPOVAttrib_RemoveBounds			 = ( ('R' << 24) | ('m' << 16) | ('B' << 8) | 'd' )	/* 'RmBd' */,
	kPOVAttrib_SplitUnions			 = ( ('S' << 24) | ('p' << 16) | ('l' << 8) | 'U' )	/* 'SplU' */,
	kPOVAttrib_Antialias			 = ( ('A' << 24) | ('n' << 16) | ('t' << 8) | 'i' )	/* 'Anti' */,
	kPOVAttrib_SamplingMethod		 = ( ('A' << 24) | ('A' << 16) | ('S' << 8) | 'M' )	/* 'AASM' */,
	kPOVAttrib_AntialiasThreshold		 = ( ('A' << 24) | ('A' << 16) | ('T' << 8) | 'h' )	/* 'AATh' */,
	kPOVAttrib_AntialiasDepth		 = ( ('A' << 24) | ('A' << 16) | ('D' << 8) | 'e' )	/* 'AADe' */,
	kPOVAttrib_AntialiasClipped		 = ( ('A' << 24) | ('A' << 16) | ('C' << 8) | 'l' )	/* 'AACl' */,
	kPOVAttrib_Jitter			 = ( ('A' << 24) | ('A' << 16) | ('J' << 8) | 'i' )	/* 'AAJi' */,
	kPOVAttrib_JitterAmount			 = ( ('A' << 24) | ('A' << 16) | ('J' << 8) | 'A' )	/* 'AAJA' */,
	kPOVAttrib_Left				 = ( ('L' << 24) | ('e' << 16) | ('f' << 8) | 't' )	/* 'Left' */,
	kPOVAttrib_Top				 = ( ('T' << 24) | ('o' << 16) | ('p' << 8) | ' ' )	/* 'Top ' */,
	kPOVAttrib_Right			 = ( ('R' << 24) | ('i' << 16) | ('g' << 8) | 'h' )	/* 'Righ' */,
	kPOVAttrib_Bottom			 = ( ('B' << 24) | ('o' << 16) | ('t' << 8) | 't' )	/* 'Bott' */,
	kPOVAttrib_CoreVersion			 = ( ('C' << 24) | ('o' << 16) | ('r' << 8) | 'e' )	/* 'Core' */,
	kPOVAttrib_PlatformName			 = ( ('P' << 24) | ('l' << 16) | ('a' << 8) | 't' )	/* 'Plat' */,
	kPOVAttrib_Official			 = ( ('O' << 24) | ('f' << 16) | ('f' << 8) | 'i' )	/* 'Offi' */,
	kPOVAttrib_PrimaryDevs			 = ( ('P' << 24) | ('r' << 16) | ('i' << 8) | 'm' )	/* 'Prim' */,
	kPOVAttrib_ContributingDevs		 = ( ('C' << 24) | ('o' << 16) | ('n' << 8) | 't' )	/* 'Cont' */,
	kPOVAttrib_ImageLibVersions		 = ( ('I' << 24) | ('L' << 16) | ('V' << 8) | 'e' )	/* 'ILVe' */,
	kPOVAttrib_EnglishText			 = ( ('E' << 24) | ('T' << 16) | ('x' << 8) | 't' )	/* 'ETxt' */,
	kPOVAttrib_CurrentToken			 = ( ('C' << 24) | ('u' << 16) | ('r' << 8) | 'T' )	/* 'CurT' */,
	kPOVAttrib_CurrentLine			 = ( ('C' << 24) | ('u' << 16) | ('r' << 8) | 'L' )	/* 'CurL' */,
	kPOVAttrib_LineCount			 = ( ('L' << 24) | ('C' << 16) | ('n' << 8) | 't' )	/* 'LCnt' */,
	kPOVAttrib_AbsoluteCurrentLine		 = ( ('A' << 24) | ('b' << 16) | ('s' << 8) | 'L' )	/* 'AbsL' */,
	kPOVAttrib_FiniteObjects		 = ( ('F' << 24) | ('i' << 16) | ('O' << 8) | 'b' )	/* 'FiOb' */,
	kPOVAttrib_InfiniteObjects		 = ( ('I' << 24) | ('n' << 16) | ('O' << 8) | 'b' )	/* 'InOb' */,
	kPOVAttrib_LightSources			 = ( ('L' << 24) | ('i' << 16) | ('S' << 8) | 'o' )	/* 'LiSo' */,
	kPOVAttrib_CurrentFrame			 = ( ('C' << 24) | ('u' << 16) | ('r' << 8) | 'F' )	/* 'CurF' */,
	kPOVAttrib_FrameCount			 = ( ('F' << 24) | ('C' << 16) | ('n' << 8) | 't' )	/* 'FCnt' */,
	kPOVAttrib_AbsoluteCurFrame		 = ( ('A' << 24) | ('b' << 16) | ('s' << 8) | 'F' )	/* 'AbsF' */,
	kPOVAttrib_FirstClock			 = ( ('F' << 24) | ('i' << 16) | ('r' << 8) | 'C' )	/* 'FirC' */,
	kPOVAttrib_CurrentClock			 = ( ('C' << 24) | ('u' << 16) | ('r' << 8) | 'C' )	/* 'CurC' */,
	kPOVAttrib_LastClock			 = ( ('L' << 24) | ('a' << 16) | ('s' << 8) | 'C' )	/* 'LasC' */,
	kPOVAttrib_TotalPhotonCount		 = ( ('T' << 24) | ('P' << 16) | ('C' << 8) | 'n' )	/* 'TPCn' */,
	kPOVAttrib_CurrentPhotonCount		 = ( ('C' << 24) | ('P' << 16) | ('C' << 8) | 'n' )	/* 'CPCn' */,
	kPOVAttrib_ObjectPhotonCount		 = ( ('O' << 24) | ('P' << 16) | ('C' << 8) | 'n' )	/* 'OPCn' */,
	kPOVAttrib_MediaPhotonCount		 = ( ('M' << 24) | ('P' << 16) | ('C' << 8) | 'n' )	/* 'MPCn' */,
	kPOVAttrib_PhotonXSamples		 = ( ('P' << 24) | ('X' << 16) | ('S' << 8) | 'a' )	/* 'PXSa' */,
	kPOVAttrib_PhotonYSamples		 = ( ('P' << 24) | ('Y' << 16) | ('S' << 8) | 'a' )	/* 'PYSa' */,
	kPOVAttrib_ProgressStatus		 = ( ('P' << 24) | ('r' << 16) | ('o' << 8) | 'S' )	/* 'ProS' */,
	kPOVAttrib_ParseTime			 = ( ('P' << 24) | ('a' << 16) | ('r' << 8) | 'T' )	/* 'ParT' */,
	kPOVAttrib_PhotonTime			 = ( ('P' << 24) | ('h' << 16) | ('o' << 8) | 'T' )	/* 'PhoT' */,
	kPOVAttrib_TraceTime			 = ( ('T' << 24) | ('r' << 16) | ('a' << 8) | 'T' )	/* 'TraT' */,
	kPOVAttrib_TotalTime			 = ( ('T' << 24) | ('o' << 16) | ('t' << 8) | 'T' )	/* 'TotT' */,
	kPOVAttrib_FileName			 = ( ('F' << 24) | ('i' << 16) | ('l' << 8) | 'e' )	/* 'File' */,
	kPOVAttrib_Pixels			 = ( ('P' << 24) | ('i' << 16) | ('x' << 8) | 'e' )	/* 'Pixe' */,
	kPOVAttrib_PixelSamples			 = ( ('P' << 24) | ('i' << 16) | ('x' << 8) | 'S' )	/* 'PixS' */,
	kPOVAttrib_SuperSampleCount		 = ( ('S' << 24) | ('S' << 16) | ('C' << 8) | 'n' )	/* 'SSCn' */,
	kPOVAttrib_MosaicPreviewSize		 = ( ('M' << 24) | ('P' << 16) | ('S' << 8) | 'i' )	/* 'MPSi' */,
	kPOVAttrib_Rays				 = ( ('R' << 24) | ('a' << 16) | ('y' << 8) | 's' )	/* 'Rays' */,
	kPOVAttrib_RaysSaved			 = ( ('R' << 24) | ('S' << 16) | ('a' << 8) | 'v' )	/* 'RSav' */,
	kPOVAttrib_TraceLevel			 = ( ('T' << 24) | ('L' << 16) | ('e' << 8) | 'v' )	/* 'TLev' */,
	kPOVAttrib_MaxTraceLevel		 = ( ('M' << 24) | ('a' << 16) | ('x' << 8) | 'L' )	/* 'MaxL' */,
	kPOVAttrib_ObjectIStats			 = ( ('O' << 24) | ('I' << 16) | ('S' << 8) | 't' )	/* 'OISt' */,
	kPOVAttrib_ShadowTest			 = ( ('S' << 24) | ('h' << 16) | ('d' << 8) | 'T' )	/* 'ShdT' */,
	kPOVAttrib_ShadowTestSuc		 = ( ('S' << 24) | ('h' << 16) | ('d' << 8) | 'S' )	/* 'ShdS' */,
	kPOVAttrib_PolynomTest			 = ( ('P' << 24) | ('n' << 16) | ('m' << 8) | 'T' )	/* 'PnmT' */,
	kPOVAttrib_RootsEliminated		 = ( ('R' << 24) | ('E' << 16) | ('l' << 8) | 'i' )	/* 'REli' */,
	kPOVAttrib_CallsToNoise			 = ( ('C' << 24) | ('T' << 16) | ('N' << 8) | 'o' )	/* 'CTNo' */,
	kPOVAttrib_CallsToDNoise		 = ( ('C' << 24) | ('T' << 16) | ('D' << 8) | 'N' )	/* 'CTDN' */,
	kPOVAttrib_MediaSamples			 = ( ('M' << 24) | ('e' << 16) | ('S' << 8) | 'a' )	/* 'MeSa' */,
	kPOVAttrib_MediaIntervals		 = ( ('M' << 24) | ('e' << 16) | ('I' << 8) | 'n' )	/* 'MeIn' */,
	kPOVAttrib_ReflectedRays		 = ( ('R' << 24) | ('f' << 16) | ('l' << 8) | 'R' )	/* 'RflR' */,
	kPOVAttrib_InnerReflectedRays		 = ( ('I' << 24) | ('R' << 16) | ('e' << 8) | 'R' )	/* 'IReR' */,
	kPOVAttrib_RefractedRays		 = ( ('R' << 24) | ('f' << 16) | ('r' << 8) | 'T' )	/* 'RfrT' */,
	kPOVAttrib_TransmittedRays		 = ( ('T' << 24) | ('r' << 16) | ('a' << 8) | 'R' )	/* 'TraR' */,
	kPOVAttrib_IStackOverflow		 = ( ('I' << 24) | ('S' << 16) | ('t' << 8) | 'O' )	/* 'IStO' */,
	kPOVAttrib_RadGatherCount		 = ( ('R' << 24) | ('G' << 16) | ('C' << 8) | 't' )	/* 'RGCt' */,
	kPOVAttrib_RadReuseCount		 = ( ('R' << 24) | ('R' << 16) | ('C' << 8) | 't' )	/* 'RRCt' */,
	kPOVAttrib_MinAlloc			 = ( ('M' << 24) | ('i' << 16) | ('n' << 8) | 'A' )	/* 'MinA' */,
	kPOVAttrib_MaxAlloc			 = ( ('M' << 24) | ('a' << 16) | ('x' << 8) | 'A' )	/* 'MaxA' */,
	kPOVAttrib_CallsToAlloc			 = ( ('C' << 24) | ('T' << 16) | ('A' << 8) | 'l' )	/* 'CTAl' */,
	kPOVAttrib_CallsToFree			 = ( ('C' << 24) | ('T' << 16) | ('F' << 8) | 'r' )	/* 'CTFr' */,
	kPOVAttrib_PeakMemoryUsage		 = ( ('P' << 24) | ('M' << 16) | ('U' << 8) | 's' )	/* 'PMUs' */,
	kPOVAttrib_PhotonsShot			 = ( ('P' << 24) | ('S' << 16) | ('h' << 8) | 'o' )	/* 'PSho' */,
	kPOVAttrib_PhotonsStored		 = ( ('P' << 24) | ('S' << 16) | ('t' << 8) | 'o' )	/* 'PSto' */,
	kPOVAttrib_GlobalPhotonsStored		 = ( ('G' << 24) | ('P' << 16) | ('S' << 8) | 't' )	/* 'GPSt' */,
	kPOVAttrib_MediaPhotonsStored		 = ( ('M' << 24) | ('P' << 16) | ('S' << 8) | 't' )	/* 'MPSt' */,
	kPOVAttrib_PhotonsPriQInsert		 = ( ('P' << 24) | ('P' << 16) | ('Q' << 8) | 'I' )	/* 'PPQI' */,
	kPOVAttrib_PhotonsPriQRemove		 = ( ('P' << 24) | ('P' << 16) | ('Q' << 8) | 'R' )	/* 'PPQR' */,
	kPOVAttrib_GatherPerformedCnt		 = ( ('G' << 24) | ('P' << 16) | ('C' << 8) | 'n' )	/* 'GPCn' */,
	kPOVAttrib_GatherExpandedCnt		 = ( ('G' << 24) | ('E' << 16) | ('C' << 8) | 'n' )	/* 'GECn' */,
	kPOVAttrib_IsoFindRoot			 = ( ('I' << 24) | ('F' << 16) | ('R' << 8) | 'o' )	/* 'IFRo' */,
	kPOVAttrib_FunctionVMCalls		 = ( ('F' << 24) | ('V' << 16) | ('M' << 8) | 'C' )	/* 'FVMC' */,
	kPOVAttrib_FunctionVMInstrEst		 = ( ('F' << 24) | ('V' << 16) | ('M' << 8) | 'I' )	/* 'FVMI' */,
	kPOVAttrib_State			 = ( ('S' << 24) | ('t' << 16) | ('a' << 8) | 't' )	/* 'Stat' */,
	kPOVAttrib_Warning			 = ( ('W' << 24) | ('a' << 16) | ('r' << 8) | 'n' )	/* 'Warn' */,
	kPOVAttrib_Line				 = ( ('L' << 24) | ('i' << 16) | ('n' << 8) | 'e' )	/* 'Line' */,
	kPOVAttrib_Column			 = ( ('C' << 24) | ('o' << 16) | ('l' << 8) | 'u' )	/* 'Colu' */,
	kPOVAttrib_FilePosition			 = ( ('F' << 24) | ('P' << 16) | ('o' << 8) | 's' )	/* 'FPos' */,
	kPOVAttrib_TokenName			 = ( ('T' << 24) | ('o' << 16) | ('k' << 8) | 'N' )	/* 'TokN' */,
	kPOVAttrib_Error			 = ( ('E' << 24) | ('r' << 16) | ('r' << 8) | 'o' )	/* 'Erro' */,
	kPOVAttrib_ObjectName			 = ( ('O' << 24) | ('N' << 16) | ('a' << 8) | 'm' )	/* 'ONam' */,
	kPOVAttrib_ObjectID			 = ( ('O' << 24) | ('I' << 16) | ('d' << 8) | 'e' )	/* 'OIde' */,
	kPOVAttrib_ISectsTests			 = ( ('I' << 24) | ('T' << 16) | ('s' << 8) | 't' )	/* 'ITst' */,
	kPOVAttrib_ISectsSucceeded		 = ( ('I' << 24) | ('S' << 16) | ('u' << 8) | 'c' )	/* 'ISuc' */,
	kPOVAttrib_CommandString		 = ( ('C' << 24) | ('o' << 16) | ('m' << 8) | 'S' )	/* 'ComS' */,
	kPOVAttrib_ReturnAction			 = ( ('R' << 24) | ('A' << 16) | ('c' << 8) | 't' )	/* 'RAct' */,
	kPOVAttrib_FrameTime			 = ( ('F' << 24) | ('T' << 16) | ('i' << 8) | 'm' )	/* 'FTim' */,
	kPOVAttrib_AnimationTime		 = ( ('A' << 24) | ('T' << 16) | ('i' << 8) | 'm' )	/* 'ATim' */,
	kPOVAttrib_IncludeHeader		 = ( ('I' << 24) | ('n' << 16) | ('c' << 8) | 'H' )	/* 'IncH' */,
	kPOVAttrib_IncludeIni			 = ( ('I' << 24) | ('n' << 16) | ('c' << 8) | 'I' )	/* 'IncI' */,
	kPOVAttrib_PreviewRefCon		 = ( ('P' << 24) | ('R' << 16) | ('e' << 8) | 'f' )	/* 'PRef' */,
	kPOVAttrib_INIFile			 = ( ('I' << 24) | ('F' << 16) | ('i' << 8) | 'l' )	/* 'IFil' */,
	kPOVAttrib_RenderOptions		 = ( ('R' << 24) | ('O' << 16) | ('p' << 8) | 't' )	/* 'ROpt' */,
	kPOVAttrib_Identifier			 = ( ('I' << 24) | ('d' << 16) | ('e' << 8) | 'n' )	/* 'Iden' */,
	kPOVAttrib_Value			 = ( ('V' << 24) | ('a' << 16) | ('l' << 8) | 'u' )	/* 'Valu' */,
	kPOVAttrib_StartColumn			 = kPOVAttrib_Left,
	kPOVAttrib_EndColumn			 = kPOVAttrib_Right,
	kPOVAttrib_StartRow			 = kPOVAttrib_Top,
	kPOVAttrib_EndRow			 = kPOVAttrib_Bottom
};
#endif /* SPEC */

/* Add new stats ONLY at the end!!! */
enum
{
	kPOVList_Stat_BicubicTest = 1,
	kPOVList_Stat_BlobTest,
	kPOVList_Stat_BlobCpTest,
	kPOVList_Stat_BlobBdTest,
	kPOVList_Stat_BoxTest,
	kPOVList_Stat_ConeCylTest,
	kPOVList_Stat_CSGIntersectTest,
	kPOVList_Stat_CSGMergeTest,
	kPOVList_Stat_CSGUnionTest,
	kPOVList_Stat_DiscTest,
	kPOVList_Stat_FractalTest,
	kPOVList_Stat_HFTest,
	kPOVList_Stat_HFBoxTest,
	kPOVList_Stat_HFTriangleTest,
	kPOVList_Stat_HFBlockTest,
	kPOVList_Stat_HFCellTest,
	kPOVList_Stat_IsosurfaceTest,
	kPOVList_Stat_IsosurfaceBdTest,
	kPOVList_Stat_IsosurfaceCacheTest,
	kPOVList_Stat_LatheTest,
	kPOVList_Stat_LatheBdTest,
	kPOVList_Stat_MeshTest,
	kPOVList_Stat_PlaneTest,
	kPOVList_Stat_PolygonTest,
	kPOVList_Stat_PrismTest,
	kPOVList_Stat_PrismBdTest,
	kPOVList_Stat_ParametricTest,
	kPOVList_Stat_ParametricBoxTest,
	kPOVList_Stat_QuardicTest,
	kPOVList_Stat_QuadPolyTest,
	kPOVList_Stat_SphereTest,
	kPOVList_Stat_SphereSweepTest,
	kPOVList_Stat_SuperellipsTest,
	kPOVList_Stat_SORTest,
	kPOVList_Stat_SORBdTest,
	kPOVList_Stat_TorusTest,
	kPOVList_Stat_TorusBdTest,
	kPOVList_Stat_TriangleTest,
	kPOVList_Stat_TTFontTest,
	kPOVList_Stat_BoundObjectTest,
	kPOVList_Stat_ClipObjectTest,
	kPOVList_Stat_BoundingBoxTest,
	kPOVList_Stat_LightBufferTest,
	kPOVList_Stat_VistaBufferTest,
	kPOVList_Stat_RBezierTest,
	kPOVList_Stat_Last
};

/* Add new progress messages ONLY at the end!!! */
enum
{
	kPOVList_Prog_CreatingBoundingSlabs = 1,
	kPOVList_Prog_CreatingVistaBuffer,
	kPOVList_Prog_CreatingLightBuffers,
	kPOVList_Prog_BuildingPhotonMaps,
	kPOVList_Prog_LoadingPhotonMaps,
	kPOVList_Prog_SavingPhotonMaps,
	kPOVList_Prog_SortingPhotons,
	kPOVList_Prog_ReclaimingMemory,
	kPOVList_Prog_WritingINIFile,
	kPOVList_Prog_WritingHistogramFile,
	kPOVList_Prog_PerformingShelloutCommand,
	kPOVList_Prog_ResumingInterruptedTrace,
	kPOVList_Prog_ProcessingFrame,
	kPOVList_Prog_Parsing,
	kPOVList_Prog_Displaying,
	kPOVList_Prog_Rendering,
	kPOVList_Prog_DoneTracing,
	kPOVList_Prog_AbortingRender,
	kPOVList_Prog_UserAbort
};

#endif /* POVMSGID_H */
