#!/bin/bash
# Simple build script, potentially useful if building a GPL-redistributable
# version on a system *without* SPEC CPU2017.  See:
#
#     https://www.spec.org/cpu2017/Docs/licenses.html#GPLtarballs
#
# Note: if the benchmark uses "specpp", that is the freely-redistributable
#       preprocessor "filepp".   It is described at 
#         https://www.spec.org/cpu2017/Docs/utility.html#specpp  
#       and will need to be in your path.  You can find filepp sources as
#       modified by SPEC in redistributable_sources/modified/tools.src/harness-spec.tar.xz 
#---------------------------------------------------------------------------

/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/nal.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/nal.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/mbuffer_mvc.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/mbuffer_mvc.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/image.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/image.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/mb_access.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/mb_access.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/memalloc.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/memalloc.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/mc_prediction.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/mc_prediction.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/mb_prediction.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/mb_prediction.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra4x4_pred_mbaff.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra4x4_pred_mbaff.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/loop_filter_mbaff.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/loop_filter_mbaff.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/context_ini.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/context_ini.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/configfile.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/configfile.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/cabac.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/cabac.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/sei.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/sei.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/leaky_bucket.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/leaky_bucket.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/filehandle.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/filehandle.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/errorconcealment.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/errorconcealment.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/decoder_test.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/decoder_test.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/img_process.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/img_process.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/mv_prediction.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/mv_prediction.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/fmo.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/fmo.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/output.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/output.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/mc_direct.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/mc_direct.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/rtp.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/rtp.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/nalucommon.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/nalucommon.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/config_common.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/config_common.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra_chroma_pred.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra_chroma_pred.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/transform8x8.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/transform8x8.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/blk_prediction.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/blk_prediction.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra8x8_pred_mbaff.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra8x8_pred_mbaff.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/erc_do_i.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/erc_do_i.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/io_tiff.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/io_tiff.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/mbuffer.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/mbuffer.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/block.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/block.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra4x4_pred.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra4x4_pred.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/transform.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/transform.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/annexb.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/annexb.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/ldecod.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/ldecod.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/macroblock.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/macroblock.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/vlc.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/vlc.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/parset.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/parset.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/loop_filter_normal.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/loop_filter_normal.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/parsetcommon.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/parsetcommon.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/erc_do_p.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/erc_do_p.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/loopFilter.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/loopFilter.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra16x16_pred_mbaff.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra16x16_pred_mbaff.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra4x4_pred_normal.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra4x4_pred_normal.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra16x16_pred_normal.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra16x16_pred_normal.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/win32.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/win32.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra16x16_pred.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra16x16_pred.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra8x8_pred_normal.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra8x8_pred_normal.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/io_raw.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/io_raw.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/img_io.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/img_io.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/nalu.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/nalu.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/quant.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/quant.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/intra8x8_pred.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/intra8x8_pred.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/erc_api.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/erc_api.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/header.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/header.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/biaridecod.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/biaridecod.c
/usr/bin/gcc     -std=c99   -m64 -c -o ldecod_src/input.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  ldecod_src/input.c
/usr/bin/gcc     -std=c99   -m64  -z muldefs    -g         -fno-strict-aliasing ldecod_src/nal.o ldecod_src/mbuffer_mvc.o ldecod_src/image.o ldecod_src/mb_access.o ldecod_src/memalloc.o ldecod_src/mc_prediction.o ldecod_src/mb_prediction.o ldecod_src/intra4x4_pred_mbaff.o ldecod_src/loop_filter_mbaff.o ldecod_src/context_ini.o ldecod_src/configfile.o ldecod_src/cabac.o ldecod_src/sei.o ldecod_src/leaky_bucket.o ldecod_src/filehandle.o ldecod_src/errorconcealment.o ldecod_src/decoder_test.o ldecod_src/img_process.o ldecod_src/mv_prediction.o ldecod_src/fmo.o ldecod_src/output.o ldecod_src/mc_direct.o ldecod_src/rtp.o ldecod_src/nalucommon.o ldecod_src/config_common.o ldecod_src/intra_chroma_pred.o ldecod_src/transform8x8.o ldecod_src/blk_prediction.o ldecod_src/intra8x8_pred_mbaff.o ldecod_src/erc_do_i.o ldecod_src/io_tiff.o ldecod_src/mbuffer.o ldecod_src/block.o ldecod_src/intra4x4_pred.o ldecod_src/transform.o ldecod_src/annexb.o ldecod_src/ldecod.o ldecod_src/macroblock.o ldecod_src/vlc.o ldecod_src/parset.o ldecod_src/loop_filter_normal.o ldecod_src/parsetcommon.o ldecod_src/erc_do_p.o ldecod_src/loopFilter.o ldecod_src/intra16x16_pred_mbaff.o ldecod_src/intra4x4_pred_normal.o ldecod_src/intra16x16_pred_normal.o ldecod_src/win32.o ldecod_src/intra16x16_pred.o ldecod_src/intra8x8_pred_normal.o ldecod_src/io_raw.o ldecod_src/img_io.o ldecod_src/nalu.o ldecod_src/quant.o ldecod_src/intra8x8_pred.o ldecod_src/erc_api.o ldecod_src/header.o ldecod_src/biaridecod.o ldecod_src/input.o             -lm         -o ldecod_r  
