""" 
Defines the standard amino acid and nucleic acid residues along
with their connectivity. This is essential for loading PDB and PQR
files properly as Molecule classes.
"""

# Lists the standard residues for which we have topology data
StandardResidues = ['ALA','ARG','ASP','ASN','CYS','GLN','GLU','GLY','HIS','ILE',
                    'LEU','LYS','MET','PHE','PRO','SER','THR','TRP','TYR','VAL',
                    'A'  ,'C'  ,'G'  ,'U'  ,'DA' ,'DC' ,'DG' ,'DT']

# Account for different names with different protonation states in Amber residue naming
AmberResidues    = {'ALA' : 'ALA',
                    'ARG' : 'ARG',
                    'ASP' : 'ASP',
                    'ASH' : 'ASP',
                    'AS4' : 'ASP',
                    'ASN' : 'ASN',
                    'CYS' : 'CYS',
                    'CYM' : 'CYS',
                    'CYX' : 'CYS',
                    'GLN' : 'GLN',
                    'GLU' : 'GLU',
                    'GLH' : 'GLU',
                    'GLY' : 'GLY',
                    'HIS' : 'HIS',
                    'HIE' : 'HIS',
                    'HID' : 'HIS',
                    'HIP' : 'HIS',
                    'ILE' : 'ILE',
                    'LEU' : 'LEU',
                    'LYN' : 'LYS',
                    'LYS' : 'LYS',
                    'MET' : 'MET',
                    'PHE' : 'PHE',
                    'PRO' : 'PRO',
                    'SER' : 'SER',
                    'THR' : 'THR',
                    'TRP' : 'TRP',
                    'TYR' : 'TYR',
                    'VAL' : 'VAL',
                    'A'   : 'A',
                    'A3'  : 'A',
                    'A5'  : 'A',
                    'AN'  : 'A',
                    'C'   : 'C',
                    'C3'  : 'C',
                    'C5'  : 'C',
                    'CN'  : 'C',
                    'G'   : 'G',
                    'G3'  : 'G',
                    'G5'  : 'G',
                    'GN'  : 'G',
                    'U'   : 'U',
                    'U3'  : 'U',
                    'U5'  : 'U',
                    'UN'  : 'U',
                    'DA'  : 'DA',
                    'DA3' : 'DA',
                    'DA5' : 'DA',
                    'DAN' : 'DA',
                    'DC'  : 'DC',
                    'DC3' : 'DC',
                    'DC5' : 'DC',
                    'DCN' : 'DC',
                    'DG'  : 'DG',
                    'DG3' : 'DG',
                    'DG5' : 'DG',
                    'DGN' : 'DG',
                    'RA'  : 'A',
                    'RA3' : 'A',
                    'RA5' : 'A',
                    'RAN' : 'A',
                    'RC'  : 'C',
                    'RC3' : 'C',
                    'RC5' : 'C',
                    'RCN' : 'C',
                    'RG'  : 'G',
                    'RG3' : 'G',
                    'RG5' : 'G',
                    'RGN' : 'G',
                    'RU'  : 'U',
                    'RU3' : 'U',
                    'RU5' : 'U',
                    'RUN' : 'U' }

