#!/bin/bash

. ../MasterTest.sh

# Clean
# NOTE: CpptrajPairDist name defined in Action_Clustering.cpp
CleanFiles cluster.in cnumvtime.dat avg.summary.dat summary.dat CpptrajPairDist

# Test 1
CheckNetcdf
cat > cluster.in <<EOF
noprogress
parm ../tz2.parm7
trajin ../tz2.nc
cluster C1 :2-10 clusters 3 epsilon 4.0 out cnumvtime.dat summary avg.summary.dat nofit 
cluster :2-10 clusters 3 epsilon 4.0 summary summary.dat complete nofit
EOF
INPUT="-i cluster.in"
RunCpptraj "Cluster command test."
DoTest cnumvtime.dat.save cnumvtime.dat
DoTest avg.summary.dat.save avg.summary.dat 
DoTest summary.dat.save summary.dat
CheckTest

EndTest

exit 0
